// ---------  Error Message Utilities  --------- //
var sErrMsg = null;
var bErrFound = false;
var iMsgCharCnt = 0;

// Error message constants
sRequired  = "is required.";
sDate      = "is not a valid date. Please enter dates as 'mm/dd/yyyy'.";
sSDate     = "is not a valid date. Please enter dates as 'mm/yyyy'.";
sSSN       = "is not valid. Please enter social security numbers as '###-##-####'.";
sNumber    = "is not a valid number.";
sPhone     = "is not a valid phone number.\n  Please enter phone numbers as '(###) ###-####' or '(###) ###-####x###.";
sZipCode   = "is not valid. Please enter zip codes as '#####' or '#####-####'.";
sMonthYear = "is not a valid month and year. Please enter month and year as 'mm/yyyy'.";
sEmail	   = "is not a valid email address. Please enter a valid email address."

function resetErrMsg()
{
	sErrMsg = "";
	iMsgCharCnt = 0;
}

function showErrMsg()
{
	var sFinalErrMsg = "";
	var iCnt = 0;
	var sAlertHdr = "Missing or Incorrect Information Entered\n";
	
	if (iMsgCharCnt < sAlertHdr.length)
		iMsgCharCnt = sAlertHdr.length;
	
	if (oDetect.mac && oDetect.nav4)
	{
		// Netscape 4 on the Mac seems to limit alert text
		// to eight lines and 255 characters.
		// The following code adjusts the error message accordingly
		
		var iLineCnt = 1;
		var iCurrLineIdx = 0;
		
		sFinalErrMsg += sAlertHdr;
		for (iCnt = 0; iCnt < sErrMsg.length; iCnt++)
		{
			if (sErrMsg.charAt(iCnt) == "\n")
			{
				if (iCnt < 210 && iLineCnt < 7)
				{
					iLineCnt++;
					iCurrLineIdx = iCnt;
				}
				else
					break;
			}
		}
		
		if (iCnt == sErrMsg.length)
			sFinalErrMsg += sErrMsg;
		else
			sFinalErrMsg += sErrMsg.substring(0, iCurrLineIdx - 1) + "\n- more errors exist...";
	}
	else
	{
		var sLine = "";

		for (iCnt = 0; iCnt < iMsgCharCnt; iCnt++)
			sLine += "_";

		sFinalErrMsg = sLine + "\n";
		sFinalErrMsg += "\n" + sAlertHdr;
		sFinalErrMsg += sLine;
		sFinalErrMsg += "\n\n";
		sFinalErrMsg += sErrMsg;
		sFinalErrMsg += sLine;
	}
		
	alert(sFinalErrMsg);
	bErrFound = false;
}
	
function addErrItem(oAnyFormElt, sLabel, sMsg)
{
	var sTempMsg = "";
	if (!bErrFound)
		if (oAnyFormElt.length > 0 && oAnyFormElt.selectedIndex == null)
			oAnyFormElt[0].focus();
		else
			oAnyFormElt.focus();

	sTempMsg = "- " + sLabel + " " + sMsg + "\n";
	if (sTempMsg.length > iMsgCharCnt)
		iMsgCharCnt = (sTempMsg.length > 80) ? 80 : sTempMsg.length;
	sErrMsg += sTempMsg;
	bErrFound = true;
}
// ---------  End Error Message Utilities  --------- //



// ---------  Validation Utilities  --------- //
function isValidInteger(sVal)
{
	//matches all digits
	IntegerRegEx = /^[0-9]+$/i;
	return IntegerRegEx.test(sVal);
}

function isValidFloat(sVal)
{
	//matches all digits
	IntegerRegEx = /^[0-9\.]+$/i;
	return IntegerRegEx.test(sVal);
}

function isValidAlpha(sVal)
{
	//matches all letters, period, and space
	ValidAlphaRegEx = /^[A-Za-z\.\s ]+$/i;
	return ValidAlphaRegEx.test(sVal);
}

function isValidAlphaNumeric(sVal)
{
	//matches all letters, digits, period, and space
	ValidAlphaNumericRegEx = /^[A-Za-z\d\.\s]+$/i;
	return ValidAlphaNumericRegEx.test(sVal);
}

function isValidDate(sVal, sFormat)
{
	var iMonth = null;
	var iDay = null;
	var iYear = null;
	var bErrFnd = false;
	
	if (sVal.length == 8 && isValidInteger(sVal))
	{
		switch(sFormat)
		{
			case "short":
				iDay = sVal.substring(6,8);
				sVal = sVal.substring(4,6) + "/" + sVal.substring(0,4);
				break;
			case "long":
				sVal = sVal.substring(4,6) + "/" + sVal.substring(6,8) + "/" + sVal.substring(0,4);
				break;
		}
	}
	
	switch(sFormat)
	{
		case "short":
			DateRegEx = /^[0-9]{1,2}\/{1}[0-9]{4}$/;
			break;
		case "long":
			DateRegEx = /^[0-9]{1,2}\/{1}[0-9]{1,2}\/{1}[0-9]{4}$/;
			break;
	}
	
	bErrFnd = !(DateRegEx.test(sVal));
	if (!bErrFnd)
	{
		iMonth = sVal.substring(0, sVal.indexOf("/"));
		iYear = sVal.substring(sVal.lastIndexOf("/") + 1, sVal.length);

		if (sVal.indexOf("/") != sVal.lastIndexOf("/"))
			iDay = sVal.substring(sVal.indexOf("/") + 1, sVal.lastIndexOf("/"));

		if (iMonth < 1 || iMonth > 12)
			bErrFnd = true;

		if (iDay && (iDay < 1 || iDay > daysInMonth(iMonth, iYear)))
			bErrFnd = true;
	}
	return !bErrFnd;
}

function isValidEmail(sVal)
{
	// match an Email, with 1 @ and at least one . with at least one alpha character after it
	EmailRegEx = /^[A-Za-z0-9_\.\-]+[@][\w{1,}\.\-]+\.\w+$/i;
	return EmailRegEx.test(sVal);
}

function isValidZipCode(sVal)
{
	// match either xxxxx or xxxxx-xxxx
	ZIPCodeRegEx = /^[\d]{5}$/;
	if (ZIPCodeRegEx.test(sVal))
		return true;
	ZIPCodeRegEx = /^[\d]{5}-[\d]{4}$/;
	if (ZIPCodeRegEx.test(sVal))
		return true;
	return false;
}
	
function isValidSSN(sVal)
{
	// match an ssn of form: 111223333 or 111-22-3333 or 111 22 3333 respectively
	SSNRegEx = /^[0-9]{3}[0-9]{2}[0-9]{4}$/i;
	if (SSNRegEx.test(sVal))
		return true;
	SSNRegEx = /^[0-9]{3}-[0-9]{2}-[0-9]{4}$/i;
	if (SSNRegEx.test(sVal))
		return true;
	SSNRegEx = /^[0-9]{3}\s[0-9]{2}\s[0-9]{4}$/i;
	if (SSNRegEx.test(sVal))
		return true;
	return false;
}

function isValidPhone(oAnyElt, sTempVal)
{
	var sVal;
	var sFmtStr = "";
	
	if (oAnyElt)
		sVal = oAnyElt.value;
	else
		sVal = sTempVal;

	// match a phone of forms: 8037480506, 803-748-0506, (803)748-0506, (803)748-0506 x139, 803-748-0506 x139
	PhoneRegEx = /^([0-9]{3})-?([0-9]{3})-?([0-9]{4})$/i;
	if (PhoneRegEx.test(sVal))
	{
		sFmtStr = "(" + RegExp.$1 + ")" + RegExp.$2 + "-" + RegExp.$3;
		if (oAnyElt)
			oAnyElt.value = sFmtStr;
		return true;
	}
	
	PhoneRegEx = /^[\(]([0-9]{3})[\)][ ]?-?([0-9]{3})-?([0-9]{4})$/i;
	if (PhoneRegEx.test(sVal))
	{
		sFmtStr = "(" + RegExp.$1 + ")" + RegExp.$2 + "-" + RegExp.$3;
		if (oAnyElt)
			oAnyElt.value = sFmtStr;
		return true;
	}

	PhoneRegEx = /^[\(]([0-9]{3})[\)]-?([0-9]{3})-?([0-9]{4})[ ]?[xX]?[ ]?([0-9]{1,})$/i;
	if (PhoneRegEx.test(sVal))
	{
		sFmtStr = "(" + RegExp.$1 + ")" + RegExp.$2 + "-" + RegExp.$3 + "x" + RegExp.$4;
		if (oAnyElt)
			oAnyElt.value = sFmtStr;
		return true;
	}

	PhoneRegEx = /^([0-9]{3})-?([0-9]{3})-?([0-9]{4})[ ]?[xX]?[ ]?([0-9]{1,})$/i;
	if (PhoneRegEx.test(sVal))
	{
		sFmtStr = "(" + RegExp.$1 + ")" + RegExp.$2 + "-" + RegExp.$3 + "x" + RegExp.$4;
		if (oAnyElt)
			oAnyElt.value = sFmtStr;
		return true;
	}

	PhoneRegEx = /^([0-9]{3})([0-9]{3})([0-9]{4})([0-9]{1,})$/i;
	if (PhoneRegEx.test(sVal))
	{
		sFmtStr = "(" + RegExp.$1 + ")" + RegExp.$2 + "-" + RegExp.$3 + "x" + RegExp.$4;
		if (oAnyElt)
			oAnyElt.value = sFmtStr;
		return true;
	}
	
	return false;
}

function daysInMonth(m, y)
{
	if (m == 2)
		return ((y % 4 == 0) && ( (!(y % 100 == 0)) || (y % 400 == 0) ) ) ? 29 : 28;
	else if (m == 1 || m == 3 || m == 5 || m == 7 || m == 8 || m == 10 || m == 12)
		return 31;
	else if (m == 4 || m == 6 || m == 9 || m == 11)
		return 30;
	else
		return 0;
}

function whichRadioSel(oAnyFrmRadio)
{
	for (iCnt = 0; iCnt < oAnyFrmRadio.length; iCnt++)
		if (oAnyFrmRadio[iCnt].checked)
			return iCnt
	return -1;
}

function isBlank(oTxtFld)
{
	var regEx = /\w/g;
	return !regEx.test(oTxtFld.value);
}
// ---------  End Validation Utilities  --------- //