Imports System
Imports System.Data
Imports System.Data.SqlClient
Partial Public Class Category
    Inherits System.Web.UI.Page
    Dim Conn As SqlConnection = New SqlConnection
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Session("user_id") = "" Then
            Response.Redirect("Login.aspx")
            Exit Sub
        End If
        Conn.ConnectionString = ConfigurationManager.ConnectionStrings("CalendarConnStr").ConnectionString
        If Not IsPostBack Then
            Bind_Category_data()
            ''Need to modify further
            If lblMessage.Text = "" Then
                grdCategory.FooterRow.Visible = False
            End If
        End If
        ''Post Back
        btnModalDelete.OnClientClick = String.Format("fnClickDelete('{0}','{1}')", btnModalDelete.UniqueID, "")
    End Sub
    Protected Sub btnEvent_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnEvent.Click
        Response.Redirect("Event.aspx")
    End Sub

    Protected Sub btnCategories_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCategories.Click
        Response.Redirect("Category.aspx")
    End Sub

    Protected Sub btnClosedDates_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnClosedDates.Click
        Response.Redirect("ClosedDates.aspx")
    End Sub

    Protected Sub btnUsers_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnUsers.Click
        Response.Redirect("Users.aspx")
    End Sub
    Protected Sub Bind_Category_data()
        lblMessage.Text = ""
        Dim CategoryDataSet As New DataSet()
        Dim CategorySql As String = "SELECT * FROM event_category WHERE status='True' ORDER BY display_order"
        Dim CategoryAdapter As New SqlDataAdapter(CategorySql, Conn)
        Try
            CategoryAdapter.Fill(CategoryDataSet)
        Catch ex As Exception
            lblMessage.Text = "There is some problem in connecting the database. Please try again later. "
            Exit Sub
        End Try
        If (CategoryDataSet.Tables(0).Rows.Count > 0) Then
            grdCategory.DataSource = CategoryDataSet
            Me.grdCategory.DataBind()

            If Me.grdCategory.Rows.Count > 0 Then
                grdCategory.Rows(0).Cells(0).FindControl("btnarrow").Visible = False
            End If
            'Removing the Delete Button for General category 
            For Each gv As GridViewRow In grdCategory.Rows
                If gv.FindControl("delHyperLnk").Visible = True Then
                    Dim catTitle As String = CType(gv.FindControl("txtCatTitle"), TextBox).Text.ToString()
                    If catTitle.ToLower = "general" Then
                        gv.FindControl("delHyperLnk").Visible = False
                    End If
                End If
            Next
            grdCategory.FooterRow.Visible = False
        Else
            ' ''If No records found
            'CategoryDataSet.Tables(0).Rows.Add(CategoryDataSet.Tables(0).NewRow())
            'grdCategory.DataSource = CategoryDataSet
            'grdCategory.DataBind()

            'Dim TotalColumns As Integer = grdCategory.Rows(0).Cells.Count
            'grdCategory.Rows(0).Cells.Clear()
            'grdCategory.Rows(0).Cells.Add(New TableCell())
            'grdCategory.Rows(0).Cells(0).ColumnSpan = TotalColumns
            'grdCategory.Rows(0).Cells(0).ForeColor = System.Drawing.Color.Red
            'grdCategory.Rows(0).Cells(0).Text = "NO RECORDS FOUND"
            Conn.Open()
            Dim CatAddGeneralCmd As SqlCommand
            CatAddGeneralCmd = New SqlCommand("INSERT INTO event_category(display_order,category_text,status) VALUES (1 ,'General','True')", Conn)
            Try
                CatAddGeneralCmd.ExecuteNonQuery()
            Catch ex As Exception
                lblMessage.Text = "There is some problem in connecting the database. Please try again later. "
                Exit Sub
            Finally
                Conn.Close()
            End Try
            Bind_Category_data()
        End If
    End Sub

    Protected Sub btnAddCategory_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnAddCategory.Click
        grdCategory.FooterRow.Visible = True
        grdCategory.FooterRow.FindControl("txtCatTitle").Focus()
        ''Add a new row at top of the gridView
        'AddGridTopRow()        
    End Sub

    Protected Sub grdCategory_RowCommand(ByVal sender As System.Object, ByVal e As System.Web.UI.WebControls.GridViewCommandEventArgs) Handles grdCategory.RowCommand
        lblMessage.Text = ""
        If e.CommandName = "AddNew" Then
            Dim txtNewName As TextBox = CType(grdCategory.FooterRow.FindControl("txtCatTitle"), TextBox)
            If txtNewName.Text = "" Then
                lblMessage.Text = "* Category title can not be blank!"
                Exit Sub
            End If
            'Reteriving the MAX value of display_order
            Dim SelMaxDipOrderDataSet As New DataSet()
            Dim SelMaxDipOrderSql As String = "SELECT MAX(display_order) FROM event_category where status = 'True'"
            Dim SelMaxDipOrderAdapter As New SqlDataAdapter(SelMaxDipOrderSql, Conn)
            Try
                SelMaxDipOrderAdapter.Fill(SelMaxDipOrderDataSet)
            Catch ex As Exception
                lblMessage.Text = "There is some problem in connecting the database. Please try again later. "
                Exit Sub
            Finally
                Conn.Close()
            End Try

            Dim DispOrder As Integer = SelMaxDipOrderDataSet.Tables(0).Rows(0)(0).ToString
            Conn.Close()
            'Inserting values into event_category
            Conn.Open()
            Dim CatAddCmd As SqlCommand
            CatAddCmd = New SqlCommand("INSERT INTO event_category(display_order,category_text,status) VALUES (" & DispOrder + 1 & ", '" & Replace(txtNewName.Text.Trim, "'", "''") & "','True')", Conn)
            Try
                CatAddCmd.ExecuteNonQuery()
            Catch ex As Exception
                lblMessage.Text = "There is some problem in connecting the database. Please try again later. "
                Exit Sub
            Finally
                Conn.Close()
            End Try
            Bind_Category_data()
        End If
    End Sub

    Protected Sub grdCategory_RowUpdating(ByVal sender As System.Object, ByVal e As System.Web.UI.WebControls.GridViewUpdateEventArgs) Handles grdCategory.RowUpdating
        lblMessage.Text = ""
        Dim catId As Integer = grdCategory.DataKeys(e.RowIndex).Values(0).ToString.Trim
        ''Updating the Display order
        Dim CmdSpUpdateDisplayorder As New SqlCommand("SP_UPDATE_DISPLAYORDER", Conn)
        CmdSpUpdateDisplayorder.CommandType = CommandType.StoredProcedure
        CmdSpUpdateDisplayorder.Parameters.AddWithValue("@CatID", catId)
        Conn.Open()
        Try
            CmdSpUpdateDisplayorder.ExecuteNonQuery()
        Catch ex As Exception
            lblMessage.Text = "There is some problem in connecting the database. Please try again later. "
            Exit Sub
        Finally
            Conn.Close()
        End Try
        grdCategory.EditIndex = -1
        Bind_Category_data()
    End Sub
    Protected Sub grdCategory_RowDataBound(ByVal sender As System.Object, ByVal e As System.Web.UI.WebControls.GridViewRowEventArgs) Handles grdCategory.RowDataBound
        If (e.Row.RowType = DataControlRowType.DataRow) Then
            Dim delHyperLnk As HyperLink = CType(e.Row.FindControl("delHyperLnk"), HyperLink)
            ''Displaying the Popup
            delHyperLnk.Attributes.Add("onclick", "ShowMyModalPopup('" & grdCategory.DataKeys(e.Row.RowIndex).Values(0) & "','" & grdCategory.DataKeys(e.Row.RowIndex).Values(1) & "')")
        End If
    End Sub
    Protected Sub btnModalDelete_Click1(ByVal sender As System.Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles btnModalDelete.Click
        'btnModalDelete.Attributes.Add("onclick", "delFadeEffect()")
        lblMessage.Text = ""
        Dim delCatId As Integer = hdnCatId.Value.Trim
        Dim CmdSpDeleteCategory As New SqlCommand("SP_DELETE_CATEGORY", Conn)
        CmdSpDeleteCategory.CommandType = CommandType.StoredProcedure
        CmdSpDeleteCategory.Parameters.AddWithValue("@CatID", delCatId)
        Conn.Open()
        Try
            CmdSpDeleteCategory.ExecuteNonQuery()
        Catch ex As Exception
            lblMessage.Text = "There is some problem in connecting the database. Please try again later. "
            Exit Sub
        Finally
            Conn.Close()
        End Try
        Bind_Category_data()
    End Sub

    Protected Sub AddGridTopRow()
        Dim row As GridViewRow
        row = New GridViewRow(-1, -1, DataControlRowType.DataRow, DataControlRowState.Insert)

        Dim tableCell0 As TableCell = New TableCell()
        Dim tableCell1 As TableCell = New TableCell()
        Dim tableCell2 As TableCell = New TableCell()
        Dim tableCell3 As TableCell = New TableCell()

        Dim txtCatTitle As New TextBox()
        txtCatTitle.Width = 310

        Dim ImageButton2 As New ImageButton()
        ImageButton2.CommandName = "AddNew"
        ImageButton2.ImageUrl = "~/images/btnAdd.gif"

        row.Cells.Add(tableCell0)
        row.Cells.Add(tableCell1)
        row.Cells.Add(tableCell2)
        row.Cells.Add(tableCell3)
        grdCategory.Controls(0).Controls.AddAt(1, row)

        'AddHandler ImageButton2.Click, AddressOf ImageButton2.Click
        'AddHandler grdCategory.RowCommand, AddressOf grdCategory_RowCommand
    End Sub
    Protected Sub lnkLogout_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lnkLogout.Click
        Session.Abandon()
        Response.Redirect("Login.aspx")
    End Sub
    
End Class