Imports System
Imports System.Data
Imports System.Data.SqlClient
Partial Public Class EventDetail
    Inherits System.Web.UI.Page
    Dim Conn As SqlConnection = New SqlConnection
    Dim eventId As Integer
    Dim StartDate As Date
    Dim EndDate As Date
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        Conn.ConnectionString = ConfigurationManager.ConnectionStrings("CalendarConnStr").ConnectionString
        Conn.Open()
        txtEventTitle.Focus()
        If Session("user_id") = "" Then
            Response.Redirect("Login.aspx")
            Exit Sub
        End If
        If Not IsPostBack Then
            Bind_Category_data()
            Bind_Contact_Data()
        End If
        'For Edit Screen
        If Session("EVENT_ID") <> "" Then
            btnSaveEventDetail.CommandName = "Update"
            btnSaveEventDetail.Text = "Update >"
            Bind_For_Edit()
            Bind_Contact_Data()
            Bind_AddAother_DateRange_to_Grid()
            'Bind_Year()
        End If
        Conn.Close()
        'Bind_Year()
    End Sub
    '' ''Protected Sub Bind_Year()
    '' ''    Dim i = 0
    '' ''    For Each gv As GridViewRow In grdAnotherDateRange.Rows
    '' ''        Dim cmbYear1 As DropDownList = CType(gv.FindControl("cmbYear1"), DropDownList)
    '' ''        If cmbYear1.ID = CType(gv.FindControl("cmbYear1"), DropDownList).ID Then
    '' ''            For i = 0 To 10
    '' ''                cmbYear1.Items.Add(New ListItem(Now.Year + i, Now.Year + i))
    '' ''            Next
    '' ''        End If
    '' ''    Next
    '' ''End Sub

    Protected Sub btnEvent_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnEvent.Click
        Response.Redirect("Event.aspx")
    End Sub

    Protected Sub btnCategories_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCategories.Click
        Response.Redirect("Category.aspx")
    End Sub

    Protected Sub btnClosedDates_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnClosedDates.Click
        Response.Redirect("ClosedDates.aspx")
    End Sub

    Protected Sub btnUsers_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnUsers.Click
        Response.Redirect("Users.aspx")
    End Sub
    Protected Sub Bind_For_Edit()
        hdnUpdateEventId.Value = Session("EVENT_ID")
        Dim EventDataSet As New DataSet()
        Dim EventSql As String = "select event_title, event_category, short_description,long_description,status,iscoming_soon,is_everyday,on_sundays,on_mondays,on_tuesdays,on_wednesdays,on_thursdays,on_fridays, on_saturdays, timing from event_master where event_id=" & hdnUpdateEventId.Value.Trim & ""
        Dim EventAdapter As New SqlDataAdapter(EventSql, Conn)
        EventAdapter.Fill(EventDataSet)
        If (EventDataSet.Tables(0).Rows.Count > 0) Then
            txtEventTitle.Text = EventDataSet.Tables(0).Rows(0)("event_title")
            cboCategory.SelectedValue = EventDataSet.Tables(0).Rows(0)("event_category")
            txtShortDescription.Text = EventDataSet.Tables(0).Rows(0)("short_description")
            txtLongDescription.Text = EventDataSet.Tables(0).Rows(0)("long_description")
            If EventDataSet.Tables(0).Rows(0)("status") = True Then
                chkActive.Checked = True : Else : chkActive.Checked = False
            End If
            If EventDataSet.Tables(0).Rows(0)("iscoming_soon") = True Then
                chkComingSoon.Checked = True : Else : chkComingSoon.Checked = False
            End If
            If EventDataSet.Tables(0).Rows(0)("is_everyday") = True Then
                chkEveryDayAt.Checked = True : Else : chkEveryDayAt.Checked = False
            End If
            If EventDataSet.Tables(0).Rows(0)("on_sundays") = True Then
                chkSunday.Checked = True : Else : chkSunday.Checked = False
            End If
            If EventDataSet.Tables(0).Rows(0)("on_mondays") = True Then
                chkMonday.Checked = True : Else : chkMonday.Checked = False
            End If
            If EventDataSet.Tables(0).Rows(0)("on_tuesdays") = True Then
                chkTuesday.Checked = True : Else : chkTuesday.Checked = False
            End If
            If EventDataSet.Tables(0).Rows(0)("on_wednesdays") = True Then
                chkWednesday.Checked = True : Else : chkWednesday.Checked = False
            End If
            If EventDataSet.Tables(0).Rows(0)("on_thursdays") = True Then
                chkThursdays.Checked = True : Else : chkThursdays.Checked = False
            End If
            If EventDataSet.Tables(0).Rows(0)("on_fridays") = True Then
                chkFridays.Checked = True : Else : chkFridays.Checked = False
            End If
            If EventDataSet.Tables(0).Rows(0)("on_saturdays") = True Then
                chkSatardays.Checked = True : Else : chkSatardays.Checked = False
            End If
            txtTimeofDay.Text = EventDataSet.Tables(0).Rows(0)("timing")
        End If
        Conn.Close()
        'Display Sponsor Logo
        Bind_For_DisplaySponsorLogo()
        'Display Events Logo
        Bind_For_DisplayEventsLogo()
        Session("EVENT_ID") = ""
    End Sub
    Protected Sub Bind_Category_data()
        Dim CategoryDataSet As New DataSet()
        Dim CategorySql As String = "select category_id,category_text FROM event_category where status='True' order by display_order"
        Dim CategoryAdapter As New SqlDataAdapter(CategorySql, Conn)
        CategoryAdapter.Fill(CategoryDataSet)
        If (CategoryDataSet.Tables(0).Rows.Count > 0) Then
            Me.cboCategory.DataSource = CategoryDataSet
            Me.cboCategory.DataTextField = "category_text"
            Me.cboCategory.DataValueField = "category_id"
            Me.cboCategory.DataBind()
            Me.cboCategory.Items.Insert(0, "Choose a Category")
        Else
            Me.cboCategory.Items.Insert(0, "No Record Found")
        End If
    End Sub
    Protected Sub btnSaveEventDetail_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSaveEventDetail.Click
        ''For Saving Event Details
      
        lblMessage.Text = ""
        Dim status As Boolean
        Dim iscoming_soon As Boolean
        Dim is_everyday As Boolean
        Dim on_sundays As Boolean
        Dim on_mondays As Boolean
        Dim on_tuesdays As Boolean
        Dim on_wednesdays As Boolean
        Dim on_thursdays As Boolean
        Dim on_fridays As Boolean
        Dim on_saturdays As Boolean

        If chkActive.Checked = True Then
            status = True : Else : status = False
        End If
        If chkComingSoon.Checked = True Then
            iscoming_soon = True : Else : iscoming_soon = False
        End If
        If chkActive.Checked = True Then
            status = True : Else : status = False
        End If
        If chkEveryDayAt.Checked = True Then
            is_everyday = True : Else : is_everyday = False
        End If
        If chkSunday.Checked = True Then
            on_sundays = True : Else : on_sundays = False
        End If
        If chkMonday.Checked = True Then
            on_mondays = True : Else : on_mondays = False
        End If
        If chkTuesday.Checked = True Then
            on_tuesdays = True : Else : on_tuesdays = False
        End If
        If chkWednesday.Checked = True Then
            on_wednesdays = True : Else : on_wednesdays = False
        End If
        If chkThursdays.Checked = True Then
            on_thursdays = True : Else : on_thursdays = False
        End If
        If chkFridays.Checked = True Then
            on_fridays = True : Else : on_fridays = False
        End If
        If chkSatardays.Checked = True Then
            on_saturdays = True : Else : on_saturdays = False
        End If
      

        Dim MaxID As Integer
        If btnSaveEventDetail.CommandName = "Save" Then
            If Validate_Form() Then

                Dim saveCommand As SqlCommand = New SqlCommand()
                Dim saveTrans As SqlTransaction
                Conn.Open()
                saveCommand.Connection = Conn
                saveTrans = Conn.BeginTransaction()
                saveCommand.Transaction = saveTrans
                Try
                    If hdnSubSaveId.Value = "" Then 'This will be excecuted if first time save or add another is clicked
                        saveCommand.CommandText = "insert into event_master(event_title, event_category, short_description,long_description,status,iscoming_soon,is_everyday,on_sundays,on_mondays,on_tuesdays,on_wednesdays,on_thursdays,on_fridays, on_saturdays, timing,created_by,created_on,del_status)  VALUES " & _
                        "('" & txtEventTitle.Text.Trim() & "', " & cboCategory.SelectedValue & ", '" & txtShortDescription.Text.Trim & "', '" & txtLongDescription.Text.Trim & "', '" & status & "', '" & iscoming_soon & "', '" & is_everyday & "','" & on_sundays & "','" & on_mondays & "','" & on_tuesdays & "','" & on_wednesdays & "','" & on_thursdays & "'," & _
                        "'" & on_fridays & "','" & on_saturdays & "','" & txtTimeofDay.Text.Trim & "'," & Session("user_id") & ",getdate(),'True')"
                        saveCommand.ExecuteNonQuery()
                    End If

                    saveCommand.CommandText = "select isnull(max(event_id),0) As Event_id from event_master"
                    MaxID = saveCommand.ExecuteScalar()
                    If hdnSubSave.Value = "Y" Then
                        hdnSubSaveId.Value = MaxID
                    End If

                    Dim btnId As String = CType(sender, System.Web.UI.WebControls.Button).ID

                    If btnId = "btnSaveEventDetail" Or btnId = "btnAddAnotherDate" Then
                        If cboStartMonth.SelectedValue <> "Month" Or cboStartDay.SelectedValue <> "Day" Or cboStartYear.SelectedValue <> "Year" Or cboEndMonth.SelectedValue <> "Month" Or cboEndDay.SelectedValue <> "Day" Or cboEndYear.SelectedValue <> "Year" Then
                            saveCommand.CommandText = "insert into event_daterange(event_id, start_date, end_date) VALUES " & _
                            "(" & MaxID & ", '" & StartDate & " ' , '" & EndDate & " ') "
                            saveCommand.ExecuteNonQuery()
                        End If
                    End If

                    If btnId = "btnSaveEventDetail" Or btnId = "btnAddAnotherContact" Then
                        If txtContactName.Text.Trim <> "" Or txtContactEmail.Text.Trim <> "" Or txtContactPhoneNo.Text.Trim <> "" Then
                            saveCommand.CommandText = "insert into event_contacts(event_id, contact_name, contact_emailid,contact_phoneno) VALUES " & _
                             "(" & MaxID & ", '" & txtContactName.Text.Trim & " ' , '" & txtContactEmail.Text.Trim & " ' , '" & txtContactPhoneNo.Text.Trim & " ') "
                            saveCommand.ExecuteNonQuery()
                        End If
                    End If

                    If btnId = "btnSaveEventDetail" Or btnId = "btnAnotherSpLogo" Then
                        ' ''Browse Sponsor Logo and Get the Sql String
                        If fuSponsorsLogo.HasFile = True Then
                            saveCommand = SponsorLogo(MaxID)
                            saveCommand.Transaction = saveTrans
                            saveCommand.ExecuteNonQuery()
                        End If
                    End If

                    If btnId = "btnSaveEventDetail" Or btnId = "btnAnotherEventLogo" Then
                        ' ''Browse Event Logo and Get the Sql String
                        If fuEventsLogo.HasFile = True Then
                            saveCommand = EventLogo(MaxID)
                            saveCommand.Transaction = saveTrans
                            saveCommand.ExecuteNonQuery()
                        End If
                    End If

                    saveTrans.Commit()

                    If hdnSubSaveId.Value = "" Then
                        lblMessage.Text = "Event Details Saved... "
                        hdnSubSaveId.Value = ""
                        Response.Redirect("Event.aspx")
                    ElseIf hdnSubSaveId.Value <> "" And hdnSubSave.Value = "N" Then
                        lblMessage.Text = "Event Details Saved... "
                        hdnSubSaveId.Value = ""
                        Response.Redirect("Event.aspx")
                    End If
                Catch ex As Exception
                    saveTrans.Rollback()
                    lblMessage.Text = ex.Message
                    Exit Sub
                Finally
                    Conn.Close()
                End Try
            Else
                Exit Sub
            End If
        End If

        ''For Updating Event Details
        If btnSaveEventDetail.CommandName = "Update" Then
            If (Validate_Form()) Then
                Dim updateCommand As SqlCommand = New SqlCommand()
                Dim updateTrans As SqlTransaction
                Conn.Open()
                updateCommand.Connection = Conn
                updateTrans = Conn.BeginTransaction()
                updateCommand.Transaction = updateTrans
                Dim updateEventId As Integer = hdnUpdateEventId.Value
                Try
                    updateCommand.CommandText = "UPDATE event_master " & _
                    "SET event_title='" & txtEventTitle.Text.Trim() & "'," & _
                    "event_category =" & cboCategory.SelectedValue & ", short_description='" & txtShortDescription.Text.Trim & "' ," & _
                    "long_description ='" & txtLongDescription.Text.Trim & "', status = '" & status & "'," & _
                    "iscoming_soon = '" & iscoming_soon & "',is_everyday='" & is_everyday & "'," & _
                    "on_sundays='" & on_sundays & "', on_mondays='" & on_mondays & "'," & _
                    "on_tuesdays='" & on_tuesdays & "', on_wednesdays='" & on_wednesdays & "'," & _
                    "on_thursdays='" & on_thursdays & "', on_fridays='" & on_fridays & "', " & _
                    "on_saturdays='" & on_saturdays & "', timing='" & txtTimeofDay.Text.Trim & "'," & _
                    "created_by=" & Session("user_id") & " " & _
                    "WHERE event_id=" & updateEventId & " "
                    updateCommand.ExecuteNonQuery()

                    ''For Multiple date range 
                    For Each gv As GridViewRow In grdAnotherDateRange.Rows
                        Dim stDate As Date
                        Dim endate As Date
                        Dim lblId As Integer = CType(gv.FindControl("lblDateRangeId"), Label).Text.ToString()
                        Dim cboStartMonth As DropDownList = CType(gv.FindControl("cboStartMonth"), DropDownList)
                        Dim cboStartDay As DropDownList = CType(gv.FindControl("cboStartDay"), DropDownList)
                        Dim cboStartYear As DropDownList = CType(gv.FindControl("cboStartYear"), DropDownList)
                        Dim cboEndMonth As DropDownList = CType(gv.FindControl("cboEndMonth"), DropDownList)
                        Dim cboEndDay As DropDownList = CType(gv.FindControl("cboEndDay"), DropDownList)
                        Dim cboEndYear As DropDownList = CType(gv.FindControl("cboEndYear"), DropDownList)
                        Try
                            stDate = "" & cboStartMonth.SelectedValue & "-" & cboStartDay.SelectedValue & "-" & cboStartYear.SelectedValue & ""
                            endate = "" & cboEndMonth.SelectedValue & "-" & cboEndDay.SelectedValue & "-" & cboEndYear.SelectedValue & ""
                        Catch ex As Exception
                            lblMessage.Text = "* Not a Valid Date!"
                            Exit Sub
                        End Try
                        updateCommand.CommandText = "UPDATE event_daterange " & _
                             "SET start_date ='" & stDate & " ',end_date='" & endate & "' " & _
                             "WHERE date_range_id=" & lblId & " "
                        updateCommand.ExecuteNonQuery()
                    Next

                    ''For Multiple Contacts 
                    For Each gv As GridViewRow In grdContact.Rows
                        Dim contactid As String = CType(gv.FindControl("lblcontactid"), Label).Text.ToString()
                        Dim contactname As String = CType(gv.FindControl("txtCntName"), TextBox).Text.ToString()
                        Dim contactemail As String = CType(gv.FindControl("txtContEmail"), TextBox).Text.ToString()
                        Dim contactphno As String = CType(gv.FindControl("txtContPhone"), TextBox).Text.ToString
                        updateCommand.CommandText = "update event_contacts set contact_name= '" & contactname & "',  contact_emailid='" & contactemail & "', contact_phoneno='" & contactphno & "'   where contact_id='" & contactid & "'"
                        updateCommand.ExecuteNonQuery()
                    Next
                    ' ''Adding a New Contact while updating
                    If txtContactName.Text.Trim <> "" Or txtContactEmail.Text.Trim <> "" Or txtContactPhoneNo.Text.Trim <> "" Then
                        updateCommand.CommandText = "insert into event_contacts(event_id, contact_name, contact_emailid,contact_phoneno) VALUES " & _
                                "(" & updateEventId & ", '" & txtContactName.Text.Trim & " ' , '" & txtContactEmail.Text.Trim & " ' , '" & txtContactPhoneNo.Text.Trim & " ') "
                        updateCommand.ExecuteNonQuery()
                    End If

                    ' ''Adding a New Date Range while updating
                    If cboStartMonth.SelectedValue <> "Month" Or cboStartDay.SelectedValue <> "Day" Or cboStartYear.SelectedValue <> "Year" Or cboEndMonth.SelectedValue <> "Month" Or cboEndDay.SelectedValue <> "Day" Or cboEndYear.SelectedValue <> "Year" Then
                        updateCommand.CommandText = "insert into event_daterange(event_id, start_date, end_date) VALUES " & _
                           "(" & updateEventId & ", '" & StartDate & " ' , '" & EndDate & " ') "
                        updateCommand.ExecuteNonQuery()
                    End If

                    ' ''Browse Sponsor Logo and Get the Sql String
                    If fuSponsorsLogo.HasFile = True Then
                        updateCommand = SponsorLogo(updateEventId)
                        updateCommand.Transaction = updateTrans
                        updateCommand.ExecuteNonQuery()
                    End If

                    ' ''Browse Event Logo and Get the Sql String
                    If fuEventsLogo.HasFile = True Then
                        updateCommand = EventLogo(updateEventId)
                        updateCommand.Transaction = updateTrans
                        updateCommand.ExecuteNonQuery()
                    End If

                    updateTrans.Commit()
                    lblMessage.Text = "Event Details Updated... "
                    Response.Redirect("Event.aspx")
                Catch ex As Exception
                    updateTrans.Rollback()
                    lblMessage.Text = ex.Message
                    Exit Sub
                Finally
                    Conn.Close()
                End Try
            Else
                Exit Sub
            End If
        End If

    End Sub
    Protected Function Validate_Form()
        Dim retStatus As Boolean = True
        If txtEventTitle.Text = "" Then
            If lblMessage.Text <> "" Then
                lblMessage.Text = lblMessage.Text + "<BR>" + "* Please Enter Event Title!"
            Else
                lblMessage.Text = "* Please Enter Event Title!"
            End If
            txtEventTitle.Focus()
            retStatus = False
        End If
        If cboCategory.SelectedValue = "Choose a Category" Then
            If lblMessage.Text <> "" Then
                lblMessage.Text = lblMessage.Text + "<BR>" + "* Please Select Category!"
            Else
                lblMessage.Text = "* Please Select Category!"
            End If
            cboCategory.Focus()
            retStatus = False
        End If
        If txtShortDescription.Text = "" Then
            If lblMessage.Text <> "" Then
                lblMessage.Text = lblMessage.Text + "<BR>" + "* Please Enter Short Description!"
            Else
                lblMessage.Text = "* Please Enter Short Description!"
            End If
            txtShortDescription.Focus()
            retStatus = False
        End If
        If cboStartMonth.SelectedValue = "Month" Or cboStartDay.SelectedValue = "Day" Or cboStartYear.SelectedValue = "Year" Or cboEndMonth.SelectedValue = "Month" Or cboEndDay.SelectedValue = "Day" Or cboEndYear.SelectedValue = "Year" Then
            ' ''If the date range grid is loaded with date then dont force date validation
            If grdAnotherDateRange.Rows.Count > 0 Then
                retStatus = True
            Else
                If lblMessage.Text <> "" Then
                    lblMessage.Text = lblMessage.Text + "<BR>" + "* Please Enter a Valid Date Range!"
                Else
                    lblMessage.Text = "* Please Enter a Valid Date Range!"
                End If
                cboStartMonth.Focus()
                retStatus = False
            End If
        Else
            If cboStartMonth.SelectedValue <> "Month" Or cboStartDay.SelectedValue <> "Day" Or cboStartYear.SelectedValue <> "Year" Or cboEndMonth.SelectedValue <> "Month" Or cboEndDay.SelectedValue <> "Day" Or cboEndYear.SelectedValue <> "Year" Then
                Try
                    StartDate = "" & cboStartMonth.SelectedValue & "-" & cboStartDay.SelectedValue & "-" & cboStartYear.SelectedValue & ""
                    EndDate = "" & cboEndMonth.SelectedValue & "-" & cboEndDay.SelectedValue & "-" & cboEndYear.SelectedValue & ""
                    If StartDate > EndDate Then
                        If lblMessage.Text <> "" Then
                            lblMessage.Text = lblMessage.Text + "<BR>" + "* Start Date Should not Greater than End Date!"

                        Else
                            lblMessage.Text = "* Start Date Should not Greater than End Date!"
                        End If
                        cboStartMonth.Focus()
                        retStatus = False
                    End If
                Catch ex As Exception
                    lblMessage.Text = "* Not a Valid Date!"
                    cboStartMonth.Focus()
                    retStatus = False
                    'Exit Function
                End Try
            End If
        End If

        If retStatus = False Then
            Return False
        Else
            Return True
        End If
    End Function
    Protected Sub Bind_AddAother_DateRange_to_Grid()
        If hdnUpdateEventId.Value <> "" Or hdnSubSaveId.Value <> "" Then
            Dim exceptionDateSql As String
            Dim exceptionDateDataSet As New DataSet()
            If hdnUpdateEventId.Value <> "" Then
                exceptionDateSql = "SELECT date_range_id,DATENAME(month,start_date)as Start_Month,DATENAME(day,start_date)as Start_Day,DATENAME(year,start_date)as Start_Year, " & _
                 "DATENAME(month,end_date)as End_Month,DATENAME(day,end_date)as End_Day,DATENAME(year,end_date)as End_Year FROM event_daterange WHERE event_id=" & hdnUpdateEventId.Value & " ORDER BY date_range_id DESC"
            Else
                'In case there is sub save value
                exceptionDateSql = "SELECT date_range_id,DATENAME(month,start_date)as Start_Month,DATENAME(day,start_date)as Start_Day,DATENAME(year,start_date)as Start_Year, " & _
                  "DATENAME(month,end_date)as End_Month,DATENAME(day,end_date)as End_Day,DATENAME(year,end_date)as End_Year FROM event_daterange WHERE event_id=" & hdnSubSaveId.Value & " ORDER BY date_range_id DESC"
            End If
            Dim exceptionDateAdapter As New SqlDataAdapter(exceptionDateSql, Conn)
            Try
                exceptionDateAdapter.Fill(exceptionDateDataSet)
            Catch ex As Exception
                lblMessage.Text = "There is some problem in connecting the database. Please try again later. "
                Exit Sub
            End Try

            If (exceptionDateDataSet.Tables(0).Rows.Count > 0) Then
                grdAnotherDateRange.DataSource = exceptionDateDataSet
                Me.grdAnotherDateRange.DataBind()
                'Putting the serial date range
                For Each gv As GridViewRow In grdAnotherDateRange.Rows
                    Dim lblDateRnjNo As Label = CType(gv.FindControl("lblDateRnjNo"), Label)
                    lblDateRnjNo.Text = gv.RowIndex + 1
                Next
            End If
        End If
        lblMaxDateRange.Text = grdAnotherDateRange.Rows.Count + 1
    End Sub
    Protected Sub btnAddAnotherDate_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnAddAnotherDate.Click
        'Add a new date range
        lblMessage.Text = ""
        If Validate_Form() Then
            hdnSubSave.Value = "Y"
            If hdnUpdateEventId.Value <> "" And hdnSubSave.Value = "Y" Then
                Insert_DB_DateRange(hdnUpdateEventId.Value)
            ElseIf hdnSubSaveId.Value = "" Then
                btnSaveEventDetail_Click(Me.btnAddAnotherDate, e)
            Else
                Insert_DB_DateRange(hdnSubSaveId.Value)
            End If

            Bind_AddAother_DateRange_to_Grid()
            If lblMessage.Text = "" Then
                cboStartMonth.SelectedValue = "Month"
                cboStartDay.SelectedValue = "Day"
                cboStartYear.SelectedValue = "Year"
                cboEndMonth.SelectedValue = "Month"
                cboEndDay.SelectedValue = "Day"
                cboEndYear.SelectedValue = "Year"
            End If
            hdnSubSave.Value = "N"
        End If
    End Sub
    Protected Sub Insert_DB_DateRange(ByVal eventId As Integer)
        lblMessage.Text = ""
        If (Validate_Form()) Then
            If cboStartMonth.SelectedValue <> "Month" Or cboStartDay.SelectedValue <> "Day" Or cboStartYear.SelectedValue <> "Year" Or cboEndMonth.SelectedValue <> "Month" Or cboEndDay.SelectedValue <> "Day" Or cboEndYear.SelectedValue <> "Year" Then
                Dim insEvtDateRangeSqlStr As String = "insert into event_daterange(event_id, start_date, end_date) VALUES " & _
                        "(" & eventId & ", '" & StartDate & " ' , '" & EndDate & " ') "
                Dim insEvtDateRangeCmd As New SqlCommand(insEvtDateRangeSqlStr, Conn)

                If Conn.State <> ConnectionState.Open Then
                    Conn.Open()
                End If
                Try
                    insEvtDateRangeCmd.ExecuteNonQuery()
                Catch ex As Exception
                    lblMessage.Text = "There is some problem in connecting the database. Please try again later. "
                    Exit Sub
                Finally
                    Conn.Close()
                    insEvtDateRangeCmd.CommandText = Nothing
                End Try
            End If
        End If
    End Sub
    Protected Sub btnAddAnotherContact_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnAddAnotherContact.Click
        lblMessage.Text = ""
        hdnSubSave.Value = "Y"
        If hdnUpdateEventId.Value <> "" And hdnSubSave.Value = "Y" Then
            Insert_DB_Contact(hdnUpdateEventId.Value)
        ElseIf hdnSubSaveId.Value = "" Then
            'if event datas are saved and single contact added for first time
            btnSaveEventDetail_Click(Me.btnAddAnotherContact, e)
        Else
            'If event datas are saved and multiple contacts are added
            Insert_DB_Contact(hdnSubSaveId.Value)
        End If
        Bind_Contact_Data()
        If lblMessage.Text = "" Then
            txtContactName.Text = ""
            txtContactEmail.Text = ""
            txtContactPhoneNo.Text = ""
        End If
        hdnSubSave.Value = "N"

    End Sub
    Protected Sub Insert_DB_Contact(ByVal eventId As Integer)
        lblMessage.Text = ""
        If (Validate_Form()) Then
            Dim ContactCommand As SqlCommand = New SqlCommand()
            If Conn.State <> ConnectionState.Open Then
                Conn.Open()
            End If

            ContactCommand.Connection = Conn
            Try
                If txtContactName.Text.Trim <> "" Or txtContactEmail.Text.Trim <> "" Or txtContactPhoneNo.Text.Trim <> "" Then
                    ContactCommand.CommandText = "insert into event_contacts(event_id, contact_name, contact_emailid,contact_phoneno) VALUES " & _
                     "(" & eventId & ", '" & txtContactName.Text.Trim & " ' , '" & txtContactEmail.Text.Trim & " ' , '" & txtContactPhoneNo.Text.Trim & " ') "
                    ContactCommand.ExecuteNonQuery()
                End If
            Catch ex As Exception
                lblMessage.Text = ex.Message
                Exit Sub
            Finally
                Conn.Close()
                ContactCommand.CommandText = Nothing
            End Try
        End If

    End Sub
    Public Sub Bind_Contact_Data()
        If hdnUpdateEventId.Value <> "" Or hdnSubSaveId.Value <> "" Then
            Dim contactSql As String
            If hdnUpdateEventId.Value <> "" Then
                contactSql = "select * from event_contacts where event_id=" & hdnUpdateEventId.Value & ""
            Else
                'In case there is sub save value
                contactSql = "select * from event_contacts where event_id=" & hdnSubSaveId.Value & ""
            End If
            Dim contactAdapter As New SqlDataAdapter(contactSql, Conn)
            Dim contactDataSet As New DataSet()
            'Userhouse_Adapter_no.Fill(Userhouse_DataSet_no, "event_contacts")
            contactAdapter.Fill(contactDataSet)
            If (contactDataSet.Tables(0).Rows.Count > 0) Then
                Me.grdContact.DataSource = contactDataSet
                Me.grdContact.DataBind()
                For Each gv As GridViewRow In grdContact.Rows
                    Dim lblContactNo As Label = CType(gv.FindControl("lblContactNo"), Label)
                    lblContactNo.Text = gv.RowIndex + 1
                Next
            End If
        End If
        lblContNo.Text = grdContact.Rows.Count + 1
    End Sub
    Protected Sub btnAnotherSpLogo_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnAnotherSpLogo.Click
        lblMessage.Text = ""
        If fuSponsorsLogo.HasFile = True Then
            If (Validate_Form()) Then
                hdnSubSave.Value = "Y"
                'For Update
                If hdnUpdateEventId.Value <> "" And hdnSubSave.Value = "Y" Then
                    Insert_DB_Upload_Sponsor_Logo(hdnUpdateEventId.Value)
                ElseIf hdnSubSaveId.Value = "" Then
                    'if event datas are saved and single contact added for first time
                    btnSaveEventDetail_Click(Me.btnAnotherSpLogo, e)
                Else
                    'If event datas are saved and multiple contacts are added
                    Insert_DB_Upload_Sponsor_Logo(hdnSubSaveId.Value)
                End If
                Bind_For_DisplaySponsorLogo()
                hdnSubSave.Value = "N"
            End If
        Else
            lblMessage.Text = "* Please Browse a File!"
            fuSponsorsLogo.Focus()
        End If
    End Sub
    Protected Sub Insert_DB_Upload_Sponsor_Logo(ByVal eventId As Integer)
        Dim spLogoCommand As SqlCommand = New SqlCommand()
        Conn.Open()
        spLogoCommand.Connection = Conn
        Try
            spLogoCommand = SponsorLogo(eventId)
            spLogoCommand.ExecuteNonQuery()
        Catch ex As Exception
            lblMessage.Text = ex.Message
            Exit Sub
        Finally
            Conn.Close()
            spLogoCommand.CommandText = Nothing
        End Try
    End Sub
    Function SponsorLogo(ByVal maxId As Integer) As SqlCommand
        lblMessage.Text = ""
        Dim sponsorSql As String
        Dim imgByte As Byte() = Nothing
        Dim img As FileUpload = CType(fuSponsorsLogo, FileUpload)
        If img.HasFile AndAlso Not img.PostedFile Is Nothing Then
            'To create a PostedFile
            Dim File As HttpPostedFile = fuSponsorsLogo.PostedFile
            'Create byte Array with file len
            imgByte = New Byte(File.ContentLength - 1) {}
            'force the control to load data in array
            File.InputStream.Read(imgByte, 0, File.ContentLength)
            sponsorSql = "INSERT INTO event_sponsors_logo(event_id,sponsor_graphics) VALUES(" & maxId & ", @eimg)"
            Dim cmd As SqlCommand = New SqlCommand(sponsorSql, Conn)
            cmd.Parameters.AddWithValue("@eimg", imgByte)
            Return cmd
        Else
            lblMessage.Text = "* Please Browse a File!"
            fuSponsorsLogo.Focus()
            Return Nothing
        End If
    End Function
    Protected Sub Bind_For_DisplaySponsorLogo()
        If hdnUpdateEventId.Value <> "" Or hdnSubSaveId.Value <> "" Then
            Dim sponsorLogoSql As String
            If hdnUpdateEventId.Value <> "" Then
                sponsorLogoSql = "SELECT * FROM event_sponsors_logo WHERE event_id=" & hdnUpdateEventId.Value.Trim & ""
            Else
                'In case there is sub save value
                sponsorLogoSql = "SELECT * FROM event_sponsors_logo WHERE event_id=" & hdnSubSaveId.Value.Trim & ""
            End If
            Dim sponsorLogoAdapter As New SqlDataAdapter(sponsorLogoSql, Conn)
            Dim sponsorLogoDataTable As New DataTable
            sponsorLogoAdapter.Fill(sponsorLogoDataTable)
            dlSpnLogo.DataSource = sponsorLogoDataTable
            dlSpnLogo.DataBind()
            dlSpnLogo.RepeatColumns = 4
        End If
    End Sub
    Protected Sub DeleteImg(ByVal sender As System.Object, ByVal e As System.Web.UI.WebControls.CommandEventArgs)
        Dim lblImgId As Integer = e.CommandArgument
        Dim delImgCommand As SqlCommand = New SqlCommand()
        Conn.Open()
        delImgCommand.Connection = Conn
        Try
            delImgCommand.CommandText = "DELETE FROM event_sponsors_logo WHERE sponsors_id= " & e.CommandArgument & " "
            delImgCommand.ExecuteNonQuery()
        Catch ex As Exception
            lblMessage.Text = ex.Message
            Exit Sub
        Finally
            Conn.Close()
        End Try
        ' Next
        Bind_For_DisplaySponsorLogo()
    End Sub
    Protected Sub btnAnotherEventLogo_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnAnotherEventLogo.Click
        lblMessage.Text = ""
        If fuEventsLogo.HasFile = True Then
            If (Validate_Form()) Then
                hdnSubSave.Value = "Y"
                'For Update
                If hdnUpdateEventId.Value <> "" And hdnSubSave.Value = "Y" Then
                    Insert_DB_Upload_Event_Logo(hdnUpdateEventId.Value)
                ElseIf hdnSubSaveId.Value = "" Then
                    'if event datas are saved and single contact added for first time
                    btnSaveEventDetail_Click(Me.btnAnotherEventLogo, e)
                Else
                    'If event datas are saved and multiple contacts are added
                    Insert_DB_Upload_Event_Logo(hdnSubSaveId.Value)
                End If
                Bind_For_DisplayEventsLogo()
                hdnSubSave.Value = "N"
            End If
        Else
            lblMessage.Text = "* Please Browse a File!"
            fuEventsLogo.Focus()
        End If
    End Sub
    Protected Sub Insert_DB_Upload_Event_Logo(ByVal eventId As Integer)
        Dim evLogoCommand As SqlCommand = New SqlCommand()
        Conn.Open()
        evLogoCommand.Connection = Conn
        Try
            evLogoCommand = EventLogo(eventId)
            evLogoCommand.ExecuteNonQuery()
        Catch ex As Exception
            lblMessage.Text = ex.Message
            Exit Sub
        Finally
            Conn.Close()
            evLogoCommand.CommandText = Nothing
        End Try
    End Sub
    Function EventLogo(ByVal maxId As Integer) As SqlCommand
        lblMessage.Text = ""
        Dim eventSql As String
        Dim imgByte As Byte() = Nothing
        Dim img As FileUpload = CType(fuEventsLogo, FileUpload)
        If img.HasFile AndAlso Not img.PostedFile Is Nothing Then
            'To create a PostedFile
            Dim File As HttpPostedFile = fuEventsLogo.PostedFile
            'Create byte Array with file len
            imgByte = New Byte(File.ContentLength - 1) {}
            'force the control to load data in array
            File.InputStream.Read(imgByte, 0, File.ContentLength)
            eventSql = "INSERT INTO event_logo(event_id,event_graphics) VALUES(" & maxId & ", @eimg)"
            Dim cmd As SqlCommand = New SqlCommand(eventSql, Conn)
            cmd.Parameters.AddWithValue("@eimg", imgByte)
            Return cmd
        Else
            lblMessage.Text = "* Please Browse a File!"
            fuEventsLogo.Focus()
            Return Nothing
        End If
    End Function
    Protected Sub Bind_For_DisplayEventsLogo()
        If hdnUpdateEventId.Value <> "" Or hdnSubSaveId.Value <> "" Then
            Dim eventLogoSql As String
            If hdnUpdateEventId.Value <> "" Then
                eventLogoSql = "SELECT * FROM event_logo WHERE event_id=" & hdnUpdateEventId.Value.Trim & ""
            Else
                'In case there is sub save value
                eventLogoSql = "SELECT * FROM event_logo WHERE event_id=" & hdnSubSaveId.Value.Trim & ""
            End If
            Dim eventLogoAdapter As New SqlDataAdapter(eventLogoSql, Conn)
            Dim eventLogoDataTable As New DataTable
            eventLogoAdapter.Fill(eventLogoDataTable)
            dlEventLogo.DataSource = eventLogoDataTable
            dlEventLogo.DataBind()
            dlEventLogo.RepeatColumns = 4
        End If
    End Sub

    Protected Sub lbtnDelImg_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)

    End Sub

    Protected Sub lbtnEvDelImg_Command(ByVal sender As System.Object, ByVal e As System.Web.UI.WebControls.CommandEventArgs)
        Dim lblImgId As Integer = e.CommandArgument
        Dim delImgCommand As SqlCommand = New SqlCommand()
        Conn.Open()
        delImgCommand.Connection = Conn
        Try
            delImgCommand.CommandText = "DELETE FROM event_logo WHERE event_logo_id= " & e.CommandArgument & " "
            delImgCommand.ExecuteNonQuery()
        Catch ex As Exception
            lblMessage.Text = ex.Message
            Exit Sub
        Finally
            Conn.Close()
        End Try
        Bind_For_DisplayEventsLogo()
    End Sub

    Protected Sub lbtnEvDelImg_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)

    End Sub

    Protected Sub lnkLogout_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lnkLogout.Click
        Session.Abandon()
        Response.Redirect("Login.aspx")
    End Sub
End Class
