       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   WSR04747.                                          
       
      ******************************************************************        
      *  WSR04747  -- CSR04747 T-SQL SP wrapper                        *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION. 
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.    

           EXEC SQL DECLARE RESULTSET_CSR04747 CURSOR FOR
                 CALL "CSR04747" (:lsI-SERV-ORDER-NO,
                                  :lsI-PRIORITY,
                                  :lsI-ACTION-CD,
                                  :lsI-USER-ID,
                                  :lsV-WK-DISTRICT INOUT)
		    END-EXEC
         01  V_RETURN_CODE_CSR04747             PIC S9(9) COMP VALUE 0. 
         01  V_OUT_WORK_DISTRICT_CSR04747       PIC x(40). 


       LINKAGE SECTION.                                                 
       01  lsI-SERV-ORDER-NO           PIC X(13).
       01  lsI-PRIORITY                PIC X(1).
       01  lsI-ACTION-CD               PIC X(1).
       01  lsI-USER-ID                 PIC X(7).
       01  lsV-WK-DISTRICT             PIC X(40).
       01  ls-RETURN-CODE              PIC S9(9) BINARY.
       01  ls-OUT-WORK-DISTRICT        PIC X(40).
                                                                        
       PROCEDURE DIVISION USING lsI-SERV-ORDER-NO,
                  lsI-PRIORITY,
                  lsI-ACTION-CD,
                  lsI-USER-ID,
                  lsV-WK-DISTRICT,
                  ls-RETURN-CODE,
                  ls-OUT-WORK-DISTRICT.
			
            EXEC SQL 
                OPEN RESULTSET_CSR04747
            END-EXEC
            
      *     Consume returned result set. 
      *     Do nothing with result set as it is not used by callers.	  
            EXEC SQL FETCH RESULTSET_CSR04747 INTO
               :V_RETURN_CODE_CSR04747,
			   :V_OUT_WORK_DISTRICT_CSR04747
            END-EXEC  
            
            MOVE V_RETURN_CODE_CSR04747 TO ls-RETURN-CODE
            MOVE V_OUT_WORK_DISTRICT_CSR04747 TO ls-OUT-WORK-DISTRICT
			
            EXEC SQL 
                CLOSE RESULTSET_CSR04747
            END-EXEC                                                                                   
            .                                                  
      ************************ End of Program **************************        
