       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   WSR04642.                                          
       
      ******************************************************************        
      *  WSR04642  -- CSR04642 T-SQL SP wrapper                        *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION. 
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.    

           EXEC SQL DECLARE RESULTSET_CSR04642 CURSOR FOR
              CALL "CSR04642" ( :lsI-APPL-PGM-ID,
                            :lsI-UPDT-ACTION-IND,
                            :lsI-USERID,
                            :lsI-ACCOUNT-NO,
                            :lsI-PREMISE-NO,
                            :lsI-CUSTOMER-NO,
                            :lsI-COMPANY-NO,
                            :lsI-CODE-UTIL-TYPE,
                            :lsI-IC-NO,
                            :lsI-RATE-PLAN-NO,
                            :lsI-CODE-REVENUE-CLASS,
                            :lsI-CODE-SIC-NO,
                            :lsI-NAICS-CD,
                            :lsI-SEASONAL-USE-CODE,
                            :lsI-ZERO-USE-INVEST-DT,
                            :lsI-READ-CYCLE,
                            :lsI-READ-ROUTE,
                            :lsI-CODE-MTR-READ-FREQ,
                            :lsI-CODE-ESTIMATE-OK,
                            :lsI-PERSONAL-CNTCT-CD,
                            :lsI-ALTERNATE-FUEL-CD,
                            :lsI-PRTY-SVC-CAT-CD,
                            :lsI-GAS-BASE-USE,
                            :lsI-GAS-BASE-LAST-UPDT,
                            :lsI-CALC-ACT-TYPE-CD,
                            :lsI-BILL-CYCLE,
                            :lsI-PRORATE-CD,
                            :lsI-DELETE-SUBDSN-FL,
                            :lsI-WQ-COMMENT,
                            :lsI-WQ-CREATE-FL )
		    END-EXEC

         01 V_RETURN_CODE_CSR04642  PIC S9(9) COMP. 
         01 V_OUT_S-RETURN-CODE               PIC S9(09) COMP.
         01 V_OUT_S-APPL-RETURN-CODE          PIC S9(09) COMP.
         01 V_OUT_S-BUS-RULE-ID               PIC X(10).
         01 V_OUT_S-BUS-RULE-RESULT-CD        PIC X(08).
         01 V_OUT_S-BUS-RULE-XREF-ID          PIC X(26).
         01 V_OUT_S-WQ-CREATED-FLAG           PIC X(01).


       LINKAGE SECTION.                                                 
        01  lsI-APPL-PGM-ID             PIC X(8).
        01  lsI-UPDT-ACTION-IND         PIC X(1).
        01  lsI-USERID                  PIC X(7).
        01  lsI-ACCOUNT-NO              PIC S9(13)  COMP-3.
        01  lsI-PREMISE-NO              PIC X(10).
        01  lsI-CUSTOMER-NO             PIC X(10).
        01  lsI-COMPANY-NO              PIC X(2).
        01  lsI-CODE-UTIL-TYPE          PIC X(1).
        01  lsI-IC-NO                   PIC S9(4) BINARY.
        01  lsI-RATE-PLAN-NO            PIC X(3).
        01  lsI-CODE-REVENUE-CLASS      PIC X(3).
        01  lsI-CODE-SIC-NO             PIC X(4).
        01  lsI-NAICS-CD                PIC X(6).
        01  lsI-SEASONAL-USE-CODE       PIC X(2).
        01  lsI-ZERO-USE-INVEST-DT      PIC X(10).
        01  lsI-READ-CYCLE              PIC X(2).
        01  lsI-READ-ROUTE              PIC S9(4) BINARY.
        01  lsI-CODE-MTR-READ-FREQ      PIC X(3).
        01  lsI-CODE-ESTIMATE-OK        PIC X(1).
        01  lsI-PERSONAL-CNTCT-CD       PIC X(1).
        01  lsI-ALTERNATE-FUEL-CD       PIC X(1).
        01  lsI-PRTY-SVC-CAT-CD         PIC X(2).
        01  lsI-GAS-BASE-USE            PIC S9(9)  COMP-3.
        01  lsI-GAS-BASE-LAST-UPDT      PIC X(10).
        01  lsI-CALC-ACT-TYPE-CD        PIC X(1).
        01  lsI-BILL-CYCLE              PIC X(2).
        01  lsI-PRORATE-CD              PIC X(1).
        01  lsI-DELETE-SUBDSN-FL        PIC X(1).
        01  lsI-WQ-COMMENT              PIC X(210).
        01  lsI-WQ-CREATE-FL            PIC X(1).

                                                                        
       PROCEDURE DIVISION USING  lsI-APPL-PGM-ID,
                                 lsI-UPDT-ACTION-IND,
                                 lsI-USERID,
                                 lsI-ACCOUNT-NO,
                                 lsI-PREMISE-NO,
                                 lsI-CUSTOMER-NO,
                                 lsI-COMPANY-NO,
                                 lsI-CODE-UTIL-TYPE,
                                 lsI-IC-NO,
                                 lsI-RATE-PLAN-NO,
                                 lsI-CODE-REVENUE-CLASS,
                                 lsI-CODE-SIC-NO,
                                 lsI-NAICS-CD,
                                 lsI-SEASONAL-USE-CODE,
                                 lsI-ZERO-USE-INVEST-DT,
                                 lsI-READ-CYCLE,
                                 lsI-READ-ROUTE,
                                 lsI-CODE-MTR-READ-FREQ,
                                 lsI-CODE-ESTIMATE-OK,
                                 lsI-PERSONAL-CNTCT-CD,
                                 lsI-ALTERNATE-FUEL-CD,
                                 lsI-PRTY-SVC-CAT-CD,
                                 lsI-GAS-BASE-USE,
                                 lsI-GAS-BASE-LAST-UPDT,
                                 lsI-CALC-ACT-TYPE-CD,
                                 lsI-BILL-CYCLE,
                                 lsI-PRORATE-CD,
                                 lsI-DELETE-SUBDSN-FL,
                                 lsI-WQ-COMMENT,
                                 lsI-WQ-CREATE-FL.
 
			
            EXEC SQL 
                OPEN RESULTSET_CSR04642
            END-EXEC
            
      *     Consume returned result set. 
      *     Do nothing with result set as it is not used by callers.	  
            EXEC SQL FETCH RESULTSET_CSR04642 INTO
               :V_RETURN_CODE_CSR04642,
			   :V_OUT_S-RETURN-CODE,
			   :V_OUT_S-APPL-RETURN-CODE,
			   :V_OUT_S-BUS-RULE-ID,
			   :V_OUT_S-BUS-RULE-RESULT-CD,
			   :V_OUT_S-BUS-RULE-XREF-ID,
			   :V_OUT_S-WQ-CREATED-FLAG
			   
            END-EXEC  		           
			
            EXEC SQL 
                CLOSE RESULTSET_CSR04642
            END-EXEC                                                                                   
            .                                                  
      ************************ End of Program **************************        
