       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   WSR02545.                                          
       
      ******************************************************************        
      *  WSR02545  -- CSR02545 T-SQL SP wrapper                        *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION. 
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.    

           EXEC SQL DECLARE RESULTSET_CSR02545 CURSOR FOR
                 CALL "CSR02545" (:lsACCOUNT_NO)
		    END-EXEC
			
         01  V_RETURN_CODE_CSR02545     PIC S9(9) COMP VALUE 0. 
         01  V_ACCT_STATUS     PIC X(1).                                    
         01  V_SERVICE_DATE    PIC X(10).                                   
         01  V_NO_RET_CHECKS   PIC S9(09) USAGE COMP.                                 
         01  V_NO_DNP          PIC S9(09) USAGE COMP.                                        
         01  V_NO_30_DAY       PIC S9(09) USAGE COMP.                                     
         01  V_ARREARS_HIST    PIC S9(09) USAGE COMP.                                  
         01  V_ACCOUNT_TYPE_CD PIC X(1).   
         01  V_FINAL_BILL_AMT  PIC S9(5)  COMP-3.                              
         01  V_SERV_END_DATE   PIC X(10).                                  
         01  V_FINAL_BILL_PAID PIC X(3).                                
         01  V_ADDR_LINE1      PIC X(50).                                    
         01  V_ADDR_LINE2      PIC X(50).                                   
         01  V_ADDR_LINE3      PIC X(50).                                   
         01  V_ADDR_LINE4      PIC X(50).                                   
         01  V_ADDR_LINE5      PIC X(50).                                 
         01  V_ADDR_LINE6      PIC X(50).	
		 
       LINKAGE SECTION.                                                 
       01  lsACCOUNT_NO        PIC X(13).       
       01  lsCSR02545_RET_CODE PIC S9(09) USAGE COMP.
       01  lsV_ACCT_STATUS     PIC X(1).                                    
       01  lsV_SERVICE_DATE    PIC X(10).                                   
       01  lsV_NO_RET_CHECKS   PIC S9(09) USAGE COMP.                                 
       01  lsV_NO_DNP          PIC S9(09) USAGE COMP.                                        
       01  lsV_NO_30_DAY       PIC S9(09) USAGE COMP.                                     
       01  lsV_ARREARS_HIST    PIC S9(09) USAGE COMP.                                  
       01  lsV_ACCOUNT_TYPE_CD PIC X(1).   
       01  lsV_FINAL_BILL_AMT  PIC S9(5)  COMP-3.                              
       01  lsV_SERV_END_DATE   PIC X(10).                                  
       01  lsV_FINAL_BILL_PAID PIC X(3).                                
       01  lsV_ADDR_LINE1      PIC X(50).                                    
       01  lsV_ADDR_LINE2      PIC X(50).                                   
       01  lsV_ADDR_LINE3      PIC X(50).                                   
       01  lsV_ADDR_LINE4      PIC X(50).                                   
       01  lsV_ADDR_LINE5      PIC X(50).                                 
       01  lsV_ADDR_LINE6      PIC X(50).      
	   
       PROCEDURE DIVISION USING lsACCOUNT_NO,       
             lsCSR02545_RET_CODE,
             lsV_ACCT_STATUS,                                    
             lsV_SERVICE_DATE,                                   
             lsV_NO_RET_CHECKS,                                 
             lsV_NO_DNP,                                        
             lsV_NO_30_DAY,                                     
             lsV_ARREARS_HIST,                                  
             lsV_ACCOUNT_TYPE_CD,   
             lsV_FINAL_BILL_AMT,                              
             lsV_SERV_END_DATE,                                  
             lsV_FINAL_BILL_PAID,                                
             lsV_ADDR_LINE1,                                    
             lsV_ADDR_LINE2,                                   
             lsV_ADDR_LINE3,                                   
             lsV_ADDR_LINE4,                                   
             lsV_ADDR_LINE5,                                 
             lsV_ADDR_LINE6.                
			
            EXEC SQL 
                OPEN RESULTSET_CSR02545
            END-EXEC
            
      *     Consume returned result set. 
      *     Do nothing with result set as it is not used by callers.	  
            EXEC SQL FETCH RESULTSET_CSR02545 INTO
               :V_RETURN_CODE_CSR02545,
               :V_ACCT_STATUS,                                    
               :V_SERVICE_DATE,                                   
               :V_NO_RET_CHECKS,                                 
               :V_NO_DNP,                                        
               :V_NO_30_DAY,                                     
               :V_ARREARS_HIST,                                  
               :V_ACCOUNT_TYPE_CD,   
               :V_FINAL_BILL_AMT,                              
               :V_SERV_END_DATE,                                  
               :V_FINAL_BILL_PAID,                                
               :V_ADDR_LINE1,                                    
               :V_ADDR_LINE2,                                   
               :V_ADDR_LINE3,                                   
               :V_ADDR_LINE4,                                   
               :V_ADDR_LINE5,                                 
               :V_ADDR_LINE6    
            END-EXEC  
            
            MOVE V_RETURN_CODE_CSR02545 TO lsCSR02545_RET_CODE
            MOVE V_ACCT_STATUS	  TO 	lsV_ACCT_STATUS	
            MOVE V_SERVICE_DATE	  TO 	lsV_SERVICE_DATE	
            MOVE V_NO_RET_CHECKS  TO 	lsV_NO_RET_CHECKS	
            MOVE V_NO_DNP	  TO 	lsV_NO_DNP	
            MOVE V_NO_30_DAY  TO 	lsV_NO_30_DAY	
            MOVE V_ARREARS_HIST     TO 	lsV_ARREARS_HIST	
            MOVE V_ACCOUNT_TYPE_CD  TO 	lsV_ACCOUNT_TYPE_CD	
            MOVE V_FINAL_BILL_AMT   TO 	lsV_FINAL_BILL_AMT	
            MOVE V_SERV_END_DATE    TO 	lsV_SERV_END_DATE	
            MOVE V_FINAL_BILL_PAID  TO 	lsV_FINAL_BILL_PAID	
            MOVE V_ADDR_LINE1  TO 	lsV_ADDR_LINE1	
            MOVE V_ADDR_LINE2  TO 	lsV_ADDR_LINE2	
            MOVE V_ADDR_LINE3  TO 	lsV_ADDR_LINE3	
            MOVE V_ADDR_LINE4  TO 	lsV_ADDR_LINE4	
            MOVE V_ADDR_LINE5  TO 	lsV_ADDR_LINE5	
            MOVE V_ADDR_LINE6  TO 	lsV_ADDR_LINE6					

            EXEC SQL 
                CLOSE RESULTSET_CSR02545
            END-EXEC                                                                                   
            .                                                  
      ************************ End of Program **************************        
