       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   WSR02337.                                          
       
      ******************************************************************        
      *  WSR02337  -- CSR02337 T-SQL SP wrapper                        *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION. 
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.    

           EXEC SQL DECLARE RESULTSET_CSR02337 CURSOR FOR
                 CALL "CSR02337" (:lsCUST_NO,                   
                                  :lsUSER_ID,                    
                                  :lsADDRESS_TYPE,               
                                  :lsACCOUNT_NO)
		    END-EXEC
			
         01  V_RETURN_CODE_CSR02337     PIC S9(9) COMP VALUE 0. 
         01  V_CODE_ACCT_STAT PIC X(1).                                  
         01  V_COMPANY_NO PIC X(2).                                     
         01  V_ADDR_LINE_1 PIC X(50).                                    
         01  V_ADDR_LINE_2 PIC X(50).                                    
         01  V_ADDR_LINE_3 PIC X(50).                                    
         01  V_ADDR_LINE_4 PIC X(50).                                   
         01  V_ADDR_LINE_5 PIC X(50).                                     
         01  V_ADDR_LINE_6 PIC X(50).                                    
         01  V_NAME PIC X(50).                                            
         01  V_USER_NAME PIC X(50).                                       
         01  V_SERV_ADDR PIC X(50).                                       
         01  V_CONTACT_POSITION PIC X(3).                                 
         01  V_CONTACT_TYPE PIC X(2).                                    
         01  V_FREE_FORM PIC X(50).                                     
         01  V_CIG_ACCOUNT PIC X(1).  
		 
       LINKAGE SECTION.                                                 
       01  lsCUST_NO PIC X(10).                   
       01  lsUSER_ID PIC X(7).                    
       01  lsADDRESS_TYPE PIC X(1).               
       01  lsACCOUNT_NO PIC X(13).    
       01  lsCSR02337_RET_CODE PIC S9(09) USAGE COMP. 
       01  lsV_CODE_ACCT_STAT PIC X(1).                                  
       01  lsV_COMPANY_NO PIC X(2).                                     
       01  lsV_ADDR_LINE_1 PIC X(50).                                    
       01  lsV_ADDR_LINE_2 PIC X(50).                                    
       01  lsV_ADDR_LINE_3 PIC X(50).                                    
       01  lsV_ADDR_LINE_4 PIC X(50).                                   
       01  lsV_ADDR_LINE_5 PIC X(50).                                     
       01  lsV_ADDR_LINE_6 PIC X(50).                                    
       01  lsV_NAME PIC X(50).                                            
       01  lsV_USER_NAME PIC X(50).                                       
       01  lsV_SERV_ADDR PIC X(50).                                       
       01  lsV_CONTACT_POSITION PIC X(3).                                 
       01  lsV_CONTACT_TYPE PIC X(2).                                    
       01  lsV_FREE_FORM PIC X(50).                                     
       01  lsV_CIG_ACCOUNT PIC X(1).   	 
	   
       PROCEDURE DIVISION USING lsCUST_NO,                   
            lsUSER_ID,                    
            lsADDRESS_TYPE,               
            lsACCOUNT_NO,    
            lsCSR02337_RET_CODE, 
            lsV_CODE_ACCT_STAT,                                  
            lsV_COMPANY_NO,                                     
            lsV_ADDR_LINE_1,                                    
            lsV_ADDR_LINE_2,                                    
            lsV_ADDR_LINE_3,                                    
            lsV_ADDR_LINE_4,                                   
            lsV_ADDR_LINE_5,                                     
            lsV_ADDR_LINE_6,                                    
            lsV_NAME,                                            
            lsV_USER_NAME,                                       
            lsV_SERV_ADDR,                                       
            lsV_CONTACT_POSITION,                                 
            lsV_CONTACT_TYPE,                                    
            lsV_FREE_FORM,                                     
            lsV_CIG_ACCOUNT.               
			
            EXEC SQL 
                OPEN RESULTSET_CSR02337
            END-EXEC
            
      *     Consume returned result set. 
      *     Do nothing with result set as it is not used by callers.	  
            EXEC SQL FETCH RESULTSET_CSR02337 INTO
               :V_RETURN_CODE_CSR02337,
               :V_CODE_ACCT_STAT,
               :V_COMPANY_NO,
               :V_ADDR_LINE_1,
               :V_ADDR_LINE_2,
               :V_ADDR_LINE_3,
               :V_ADDR_LINE_4,
               :V_ADDR_LINE_5,
               :V_ADDR_LINE_6,
               :V_NAME ,
               :V_USER_NAME,
               :V_SERV_ADDR,
               :V_CONTACT_POSITION,
               :V_CONTACT_TYPE,
               :V_FREE_FORM,
               :V_CIG_ACCOUNT          
			END-EXEC 
			
            MOVE V_RETURN_CODE_CSR02337 TO lsCSR02337_RET_CODE
            MOVE V_CODE_ACCT_STAT   TO 	lsV_CODE_ACCT_STAT
            MOVE V_COMPANY_NO   TO 		lsV_COMPANY_NO
            MOVE V_ADDR_LINE_1  TO 		lsV_ADDR_LINE_1
            MOVE V_ADDR_LINE_2  TO 		lsV_ADDR_LINE_2
            MOVE V_ADDR_LINE_3  TO 		lsV_ADDR_LINE_3
            MOVE V_ADDR_LINE_4  TO 		lsV_ADDR_LINE_4
            MOVE V_ADDR_LINE_5  TO 		lsV_ADDR_LINE_5
            MOVE V_ADDR_LINE_6  TO 		lsV_ADDR_LINE_6
            MOVE V_NAME         TO 		lsV_NAME
            MOVE V_USER_NAME    TO 		lsV_USER_NAME
            MOVE V_SERV_ADDR    TO 		lsV_SERV_ADDR
            MOVE V_CONTACT_POSITION  TO lsV_CONTACT_POSITION
            MOVE V_CONTACT_TYPE  TO 	lsV_CONTACT_TYPE
            MOVE V_FREE_FORM     TO 	lsV_FREE_FORM
            MOVE V_CIG_ACCOUNT   TO 	lsV_CIG_ACCOUNT 	

            EXEC SQL 
                CLOSE RESULTSET_CSR02337
            END-EXEC                                                                                   
            .                                                  
      ************************ End of Program **************************        
