       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   WSR02037.                                          
       
      ******************************************************************        
      *  WSR02037  -- CSR02037 T-SQL SP wrapper                        *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION. 
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.    

           EXEC SQL DECLARE RESULTSET_CSR02037 CURSOR FOR
                 CALL "CSR02037" (:lsPANEL_NO_037,                     
                 :lsMODIFY_037,                         
                 :lsBYPASS_037,                         
                 :lsPREMISE_NO_037,                 
                 :lsADDR_PREFIX_1_037,           
                 :lsADDR_PREFIX_2_037,           
                 :lsADDR_USAGE_CD_037,           
                 :lsADDRESS_OVERFLOW_037,     
                 :lsCARRIER_ROUTE_037,           
                 :lsHOUSE_NO_037,                     
                 :lsSTREET_LOCATION_1_037,   
                 :lsSTREET_LOCATION_2_037,   
                 :lsSTREET_NAME_037,               
                 :lsSTREET_SUFFIX_037,           
                 :lsADDR_SUFFIX_037,               
                 :lsZIP_CODE_037,                     
                 :lsZIP_CODE_PLUS_FOUR_037, 
                 :lsZIP_CODE_TOKEN_037,         
                 :lsCITY_037,                             
                 :lsSTATE_037,                           
                 :lsLOCAL_OFFICE_037,             
                 :lsCOMPANY_NO_037,                 
                 :lsSUBDIVISION_ID_037,         
                 :lsLOT_037,                               
                 :lsBLOCK_037,                           
                 :lsCOUNTY_037,                         
                 :lsLOCATOR_ID_037,                 
                 :lsPERSONAL_CNTCT_CD_037,   
                 :lsPREMISE_DESC_037,             
                 :lsCOMPLEX_TYPE_037,             
                 :lsCOMPLEX_NAME_037,             
                 :lsCITY_GATE_ID_037,             
                 :lsREAD_ROUTE_037,                 
                 :lsGAS_LEAL_SURVEY_DT_037, 
                 :lsGAS_LEAK_SURVEY_FQ_037, 
                 :lsREV_DISTRICT_CD_037,       
                 :lsCOMMENT_TEXT_037,             
                 :lsUSERID_037,                         
                 :lsDELIVERY_POINT_037,         
                 :lsCROSS_STREET_1,                 
                 :lsCROSS_STREET_2)
		    END-EXEC
			
         01  V_RETURN_CODE_CSR02037             PIC S9(9) COMP VALUE 0. 
         01  V_R_PREMISE_NO              PIC X(10).
         01  V_R_ADDR_PREFIX_1           PIC X(03).                        
         01  V_R_ADDR_PREFIX_2           PIC X(02).                        
         01  V_R_ADDR_SUFFIX             PIC X(02).                       
         01  V_R_ADDR_OVERFLOW           PIC X(35).                        
         01  V_R_HOUSE_NO                PIC X(15).                        
         01  V_R_STREET_LOCATION_1       PIC X(04).                        
         01  V_R_STREET_LOCATION_2       PIC X(11).                        
         01  V_R_STREET_NAME             PIC X(30).                        
         01  V_R_STREET_SUFFIX           PIC X(04).                        
         01  V_R_CITY                    PIC X(26).                        
         01  V_R_STATE                   PIC X(02).                        
         01  V_R_ZIP_CODE                PIC X(05).                        
         01  V_R_ZIP_CODE_PLUS_4         PIC X(04).                        
         01  V_R_CARRIER_ROUTE           PIC X(04).                        
         01  V_R_ZIP_TABLE_UPDATE        PIC X(01).                       
         01  V_R_DELIVERY_POINT          PIC X(2).  	
		 
       LINKAGE SECTION.                                                 
       01  lsPANEL_NO_037           PIC X(8).              
       01  lsMODIFY_037             PIC X(1).                
       01  lsBYPASS_037             PIC X(1).                
       01  lsPREMISE_NO_037         PIC X(10).           
       01  lsADDR_PREFIX_1_037      PIC X(3).         
       01  lsADDR_PREFIX_2_037      PIC X(2).         
       01  lsADDR_USAGE_CD_037      PIC X(1).         
       01  lsADDRESS_OVERFLOW_037   PIC X(35).     
       01  lsCARRIER_ROUTE_037      PIC X(4).         
       01  lsHOUSE_NO_037           PIC X(15).             
       01  lsSTREET_LOCATION_1_037  PIC X(4).     
       01  lsSTREET_LOCATION_2_037  PIC X(11).    
       01  lsSTREET_NAME_037        PIC X(30).          
       01  lsSTREET_SUFFIX_037      PIC X(4).         
       01  lsADDR_SUFFIX_037        PIC X(2).           
       01  lsZIP_CODE_037           PIC X(5).              
       01  lsZIP_CODE_PLUS_FOUR_037 PIC X(4).    
       01  lsZIP_CODE_TOKEN_037     PIC X(1).        
       01  lsCITY_037               PIC X(26).                 
       01  lsSTATE_037              PIC X(2).                 
       01  lsLOCAL_OFFICE_037       PIC X(3).          
       01  lsCOMPANY_NO_037         PIC X(2).            
       01  lsSUBDIVISION_ID_037     PIC X(3).        
       01  lsLOT_037                PIC X(5).                   
       01  lsBLOCK_037              PIC X(5).                 
       01  lsCOUNTY_037             PIC X(3).                
       01  lsLOCATOR_ID_037         PIC X(9).            
       01  lsPERSONAL_CNTCT_CD_037  PIC X(1).     
       01  lsPREMISE_DESC_037       PIC X(15).         
       01  lsCOMPLEX_TYPE_037       PIC X(15).         
       01  lsCOMPLEX_NAME_037       PIC X(22).         
       01  lsCITY_GATE_ID_037       PIC X(7).          
       01  lsREAD_ROUTE_037         PIC X(4).            
       01  lsGAS_LEAL_SURVEY_DT_037 PIC X(10).   
       01  lsGAS_LEAK_SURVEY_FQ_037 PIC X(2).    
       01  lsREV_DISTRICT_CD_037    PIC X(3).       
       01  lsCOMMENT_TEXT_037       PIC X(210).        
       01  lsUSERID_037             PIC X(7).                
       01  lsDELIVERY_POINT_037     PIC X(2).        
       01  lsCROSS_STREET_1         PIC X(35).           
       01  lsCROSS_STREET_2         PIC X(35).      
       01  lsR_RETURN_CODE             PIC S9(09) USAGE COMP. 
       01  lsR_PREMISE_NO              PIC X(10).
       01  lsR_ADDR_PREFIX_1           PIC X(03).                        
       01  lsR_ADDR_PREFIX_2           PIC X(02).                        
       01  lsR_ADDR_SUFFIX             PIC X(02).                       
       01  lsR_ADDR_OVERFLOW           PIC X(35).                        
       01  lsR_HOUSE_NO                PIC X(15).                        
       01  lsR_STREET_LOCATION_1       PIC X(04).                        
       01  lsR_STREET_LOCATION_2       PIC X(11).                        
       01  lsR_STREET_NAME             PIC X(30).                        
       01  lsR_STREET_SUFFIX           PIC X(04).                        
       01  lsR_CITY                    PIC X(26).                        
       01  lsR_STATE                   PIC X(02).                        
       01  lsR_ZIP_CODE                PIC X(05).                        
       01  lsR_ZIP_CODE_PLUS_4         PIC X(04).                        
       01  lsR_CARRIER_ROUTE           PIC X(04).                        
       01  lsR_ZIP_TABLE_UPDATE        PIC X(01).                       
       01  lsR_DELIVERY_POINT          PIC X(2).  
 
                                                                        
       PROCEDURE DIVISION USING                  lsPANEL_NO_037,                     
                 lsMODIFY_037,                         
                 lsBYPASS_037,                         
                 lsPREMISE_NO_037,                 
                 lsADDR_PREFIX_1_037,           
                 lsADDR_PREFIX_2_037,           
                 lsADDR_USAGE_CD_037,           
                 lsADDRESS_OVERFLOW_037,     
                 lsCARRIER_ROUTE_037,           
                 lsHOUSE_NO_037,                     
                 lsSTREET_LOCATION_1_037,   
                 lsSTREET_LOCATION_2_037,   
                 lsSTREET_NAME_037,               
                 lsSTREET_SUFFIX_037,           
                 lsADDR_SUFFIX_037,               
                 lsZIP_CODE_037,                     
                 lsZIP_CODE_PLUS_FOUR_037, 
                 lsZIP_CODE_TOKEN_037,         
                 lsCITY_037,                             
                 lsSTATE_037,                           
                 lsLOCAL_OFFICE_037,             
                 lsCOMPANY_NO_037,                 
                 lsSUBDIVISION_ID_037,         
                 lsLOT_037,                               
                 lsBLOCK_037,                           
                 lsCOUNTY_037,                         
                 lsLOCATOR_ID_037,                 
                 lsPERSONAL_CNTCT_CD_037,   
                 lsPREMISE_DESC_037,             
                 lsCOMPLEX_TYPE_037,             
                 lsCOMPLEX_NAME_037,             
                 lsCITY_GATE_ID_037,             
                 lsREAD_ROUTE_037,                 
                 lsGAS_LEAL_SURVEY_DT_037, 
                 lsGAS_LEAK_SURVEY_FQ_037, 
                 lsREV_DISTRICT_CD_037,       
                 lsCOMMENT_TEXT_037,             
                 lsUSERID_037,                         
                 lsDELIVERY_POINT_037,         
                 lsCROSS_STREET_1,                 
                 lsCROSS_STREET_2,            
                 lsR_RETURN_CODE,             
                 lsR_PREMISE_NO,             
                 lsR_ADDR_PREFIX_1,                            
                 lsR_ADDR_PREFIX_2,                            
                 lsR_ADDR_SUFFIX,                             
                 lsR_ADDR_OVERFLOW,                            
                 lsR_HOUSE_NO,                                 
                 lsR_STREET_LOCATION_1,                        
                 lsR_STREET_LOCATION_2,                        
                 lsR_STREET_NAME,                              
                 lsR_STREET_SUFFIX,                            
                 lsR_CITY,                                     
                 lsR_STATE,                                    
                 lsR_ZIP_CODE,                                 
                 lsR_ZIP_CODE_PLUS_4,                          
                 lsR_CARRIER_ROUTE,                            
                 lsR_ZIP_TABLE_UPDATE,                        
                 lsR_DELIVERY_POINT.         
			
            EXEC SQL 
                OPEN RESULTSET_CSR02037
            END-EXEC
            
      *     Consume returned result set. 
      *     Do nothing with result set as it is not used by callers.	  
            EXEC SQL FETCH RESULTSET_CSR02037 INTO
               :V_RETURN_CODE_CSR02037,
			   :V_R_PREMISE_NO,
			   :V_R_ADDR_PREFIX_1,
			   :V_R_ADDR_PREFIX_2,
			   :V_R_ADDR_SUFFIX ,
			   :V_R_ADDR_OVERFLOW,
			   :V_R_HOUSE_NO,
			   :V_R_STREET_LOCATION_1,
			   :V_R_STREET_LOCATION_2,
			   :V_R_STREET_NAME,
			   :V_R_STREET_SUFFIX,
			   :V_R_CITY,
			   :V_R_STATE,
			   :V_R_ZIP_CODE,
			   :V_R_ZIP_CODE_PLUS_4,
			   :V_R_CARRIER_ROUTE,
			   :V_R_ZIP_TABLE_UPDATE,
			   :V_R_DELIVERY_POINT
            END-EXEC  
            
            MOVE V_RETURN_CODE_CSR02037 TO lsR_RETURN_CODE
            MOVE V_R_PREMISE_NO         TO lsR_PREMISE_NO                         
            MOVE V_R_ADDR_PREFIX_1      TO lsR_ADDR_PREFIX_1                      
            MOVE V_R_ADDR_PREFIX_2      TO lsR_ADDR_PREFIX_2                      
            MOVE V_R_ADDR_SUFFIX        TO lsR_ADDR_SUFFIX                        
            MOVE V_R_ADDR_OVERFLOW      TO lsR_ADDR_OVERFLOW                      
            MOVE V_R_HOUSE_NO           TO lsR_HOUSE_NO                           
            MOVE V_R_STREET_LOCATION_1  TO lsR_STREET_LOCATION_1                  
            MOVE V_R_STREET_LOCATION_2  TO lsR_STREET_LOCATION_2                  
            MOVE V_R_STREET_NAME        TO lsR_STREET_NAME                        
            MOVE V_R_STREET_SUFFIX      TO lsR_STREET_SUFFIX                      
            MOVE V_R_CITY               TO lsR_CITY                               
            MOVE V_R_STATE              TO lsR_STATE                              
            MOVE V_R_ZIP_CODE           TO lsR_ZIP_CODE                           
            MOVE V_R_ZIP_CODE_PLUS_4    TO lsR_ZIP_CODE_PLUS_4                    
            MOVE V_R_CARRIER_ROUTE      TO lsR_CARRIER_ROUTE                      
            MOVE V_R_ZIP_TABLE_UPDATE   TO lsR_ZIP_TABLE_UPDATE                   
            MOVE V_R_DELIVERY_POINT     TO lsR_DELIVERY_POINT                     
  
            EXEC SQL 
                CLOSE RESULTSET_CSR02037
            END-EXEC                                                                                   
            .                                                  
      ************************ End of Program **************************        
