       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   WSR00443.                                          
       
      ******************************************************************        
      *  WSR00443  -- CSR00443 T-SQL SP wrapper                        *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION. 
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.    

           EXEC SQL DECLARE RESULTSET_CSR00443 CURSOR FOR
                 CALL "CSR00443" (:lsV-TRANSACTION-IDEN,
                                  :lsV-ACCOUNT-NUMBER,
                                  :lsV-TRANSACTION-DAT1,
                                  :lsV-TRANSACTION-DAT2,
                                  :lsV-TRANSACTION-DAT3,
                                  :lsV-TRANSACTION-DAT4 )
		    END-EXEC
         01  V_LOCAL_ERROR_CSR00443             PIC S9(9) COMP VALUE 0. 


       LINKAGE SECTION.                                                 
       01  lsV-TRANSACTION-IDEN        PIC X(4).
       01  lsV-ACCOUNT-NUMBER          PIC X(13).
       01  lsV-TRANSACTION-DAT1.
           49 lsV-TRANSACTION-DAT1-LNG      PIC S9(4) BINARY.
           49 lsV-TRANSACTION-DAT1-TXT      PIC X(255).
       01  lsV-TRANSACTION-DAT2.
           49 lsV-TRANSACTION-DAT2-LNG      PIC S9(4) BINARY.
           49 lsV-TRANSACTION-DAT2-TXT      PIC X(255).
       01  lsV-TRANSACTION-DAT3.
           49 lsV-TRANSACTION-DAT3-LNG      PIC S9(4) BINARY.
           49 lsV-TRANSACTION-DAT3-TXT      PIC X(255).
       01  lsV-TRANSACTION-DAT4.
           49 lsV-TRANSACTION-DAT4-LNG      PIC S9(4) BINARY.
           49 lsV-TRANSACTION-DAT4-TXT      PIC X(255).
                                                                        
       PROCEDURE DIVISION USING lsV-TRANSACTION-IDEN,
             lsV-ACCOUNT-NUMBER,
             lsV-TRANSACTION-DAT1,
             lsV-TRANSACTION-DAT2,
             lsV-TRANSACTION-DAT3,
             lsV-TRANSACTION-DAT4.
            			
            EXEC SQL 
                OPEN RESULTSET_CSR00443
            END-EXEC
            
      *     Consume returned result set. 
      *     Do nothing with result set as it is not used by callers.	  
            EXEC SQL FETCH RESULTSET_CSR00443 INTO
               :V_LOCAL_ERROR_CSR00443
            END-EXEC  
            
            EXEC SQL 
                CLOSE RESULTSET_CSR00443
            END-EXEC                                                                                   
            .                                                  
      ************************ End of Program **************************        
