       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   WSR00225.                                          
       
      ******************************************************************        
      *  WSR00225  -- CSR00225 T-SQL SP wrapper                        *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION. 
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.    

           EXEC SQL DECLARE RESULTSET_CSR00225 CURSOR FOR
                 CALL "CSR00225" (:lsV-PREMISE-NO,
                                  :lsV-ORDER-TYPE-CD,
                                  :lsV-SCHEDULED-DATE,
                                  :lsV-ORDER-NO,
                                  :lsV-ORDER-TYPE-OUT )
		    END-EXEC
         01  V_LOCAL_ERROR_CSR00225             PIC S9(9) COMP VALUE 0. 


       LINKAGE SECTION.                                                 
       01  lsV-PREMISE-NO              PIC S9(10)  COMP-3.
       01  lsV-ORDER-TYPE-CD           PIC X(5).
       01  lsV-SCHEDULED-DATE          PIC X(26).
       01  lsV-ORDER-NO                PIC S9(13)  COMP-3.
       01  lsV-ORDER-TYPE-OUT          PIC X(5). 
                                                                        
       PROCEDURE DIVISION USING lsV-PREMISE-NO,
                  lsV-ORDER-TYPE-CD,
                  lsV-SCHEDULED-DATE,
                  lsV-ORDER-NO,
                  lsV-ORDER-TYPE-OUT.  
            			
            EXEC SQL 
                OPEN RESULTSET_CSR00225
            END-EXEC
            
      *     Consume returned result set. 
      *     Do nothing with result set as it is not used by callers.	  
            EXEC SQL FETCH RESULTSET_CSR00225 INTO
               :V_LOCAL_ERROR_CSR00225
            END-EXEC  
            
            EXEC SQL 
                CLOSE RESULTSET_CSR00225
            END-EXEC                                                                                   
            .                                                  
      ************************ End of Program **************************        
