       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   WSR00204.                                          
       
      ******************************************************************        
      *  WSR00204  -- CSR00204 T-SQL SP wrapper                        *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION. 
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.    

           EXEC SQL DECLARE RESULTSET_CSR00204 CURSOR FOR
                 CALL "CSR00204" (:lsV_SERV_ORDER_NO,    
				                  :lsV_AMOUNT_DISC_BAL,  
				                  :lsV_SECURITIES_TOT_A, 
				                  :lsV_CUR_MTH_ARREARSZ, 
				                  :lsV_CREDIT_GROUP,     
                                  :lsV_DNP_CNCL_REASONZ )
		    END-EXEC
         01  V_RETURN_CODE_CSR00204             PIC S9(9) COMP VALUE 0. 

       LINKAGE SECTION.                                                 
       01  lsV_SERV_ORDER_NO    PIC X(13).
       01  lsV_AMOUNT_DISC_BAL  PIC S9(11)V9(2) COMP-3.
       01  lsV_SECURITIES_TOT_A PIC S9(11)V9(2) COMP-3.
       01  lsV_CUR_MTH_ARREARSZ PIC X(1).
       01  lsV_CREDIT_GROUP     PIC X(1).
       01  lsV_DNP_CNCL_REASONZ PIC X(1).
                                                                        
       PROCEDURE DIVISION USING lsV_SERV_ORDER_NO,    
	                            lsV_AMOUNT_DISC_BAL,
	                            lsV_SECURITIES_TOT_A, 
	                            lsV_CUR_MTH_ARREARSZ, 
	                            lsV_CREDIT_GROUP,     
	                            lsV_DNP_CNCL_REASONZ.
								
            EXEC SQL 
                OPEN RESULTSET_CSR00204
            END-EXEC
            
      *     Consume returned result set. 
      *     Do nothing with result set as it is not used by callers.	  
            EXEC SQL FETCH RESULTSET_CSR00204 INTO
               :V_RETURN_CODE_CSR00204
            END-EXEC  
            		
            EXEC SQL 
                CLOSE RESULTSET_CSR00204
            END-EXEC                                                                                   
            .                                                  
      ************************ End of Program **************************        
