       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   WSR00092.                                          
       
      ******************************************************************        
      *  WSR00092  -- CSR00092 T-SQL SP wrapper                        *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION. 
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.    

           EXEC SQL DECLARE RESULTSET_CSR00092 CURSOR FOR
                 CALL "CSR00092" (:lsV_SERV_ORDER_NO,
	                              :lsV_SERV_ORDER_STATU,
	                              :lsV_REQUIREMENT_CD,   
	                              :lsV_USERID,           
	                              :lsV_WANTED_DATE,      
	                              :lsV_PANEL,            
                                  :lsV_UPDATE_STATUS
                                  )
		    END-EXEC
         01  V_RETURN_CODE_CSR00092             PIC S9(9) COMP VALUE 0. 

       LINKAGE SECTION.                                                 
       01  lsV_SERV_ORDER_NO    PIC X(13).
       01  lsV_SERV_ORDER_STATU PIC X(2).
       01  lsV_REQUIREMENT_CD   PIC X(3).
       01  lsV_USERID           PIC X(7).
       01  lsV_WANTED_DATE      PIC X(26).
       01  lsV_PANEL            PIC X(4).
       01  lsV_UPDATE_STATUS    PIC X(2).
                                                                        
       PROCEDURE DIVISION USING lsV_SERV_ORDER_NO,
	                            lsV_SERV_ORDER_STATU,
	                            lsV_REQUIREMENT_CD,   
	                            lsV_USERID,           
	                            lsV_WANTED_DATE,      
	                            lsV_PANEL,            
                                lsV_UPDATE_STATUS.    
			
            EXEC SQL 
                OPEN RESULTSET_CSR00092
            END-EXEC
            
      *     Consume returned result set. 
      *     Do nothing with result set as it is not used by callers.	  
            EXEC SQL FETCH RESULTSET_CSR00092 INTO
               :V_RETURN_CODE_CSR00092
            END-EXEC             
			
            EXEC SQL 
                CLOSE RESULTSET_CSR00092
            END-EXEC                                                                                   
            .                                                  
      ************************ End of Program **************************        
