       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   WSR00063.                                          
       
      ******************************************************************        
      *  WSR00063  -- CSR00063 T-SQL SP wrapper                        *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION. 
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.    

           EXEC SQL DECLARE RESULTSET_CSR00063 CURSOR FOR
                 CALL "CSR00063" (:lsV-LOCAL-OFFICE,
                                  :lsV-PREMISE-NO,
                                  :lsV-ACCOUNT-NO,
                                  :lsV-SERV-ORDER-NO,
                                  :lsV-ORDER-TYPE-CD,
                                  :lsV-STD-CHG-AMOUNT,
                                  :lsV-CODE-UTIL-TYPE,
                                  :lsV-OLD-ACCOUNT-STAT,
                                  :lsV-WORK-PERIOD-CD, 
                                  :lsV-WAIVER-TYPE-CD,
                                  :lsV-ACCOUNT-TYPE-COD )
		    END-EXEC
         01  V_LOCAL_ERROR_CSR00063             PIC S9(9) COMP VALUE 0. 


       LINKAGE SECTION.                                                 
       01  lsV-LOCAL-OFFICE            PIC X(3).
       01  lsV-PREMISE-NO              PIC S9(10)  COMP-3.
       01  lsV-ACCOUNT-NO              PIC S9(13)  COMP-3.
       01  lsV-SERV-ORDER-NO           PIC S9(13)  COMP-3.
       01  lsV-ORDER-TYPE-CD           PIC X(5).
       01  lsV-STD-CHG-AMOUNT          PIC S9(7)V9(2)  COMP-3.
       01  lsV-CODE-UTIL-TYPE          PIC X(1).
       01  lsV-OLD-ACCOUNT-STAT        PIC X(1).
       01  lsV-WORK-PERIOD-CD          PIC X(1).
       01  lsV-WAIVER-TYPE-CD          PIC X(1).
       01  lsV-ACCOUNT-TYPE-COD        PIC X(1).		 

                                                                        
       PROCEDURE DIVISION USING   lsV-LOCAL-OFFICE,
                   lsV-PREMISE-NO,
                   lsV-ACCOUNT-NO,
                   lsV-SERV-ORDER-NO,
                   lsV-ORDER-TYPE-CD,
                   lsV-STD-CHG-AMOUNT,
                   lsV-CODE-UTIL-TYPE,
                   lsV-OLD-ACCOUNT-STAT,
                   lsV-WORK-PERIOD-CD, 
                   lsV-WAIVER-TYPE-CD,
                   lsV-ACCOUNT-TYPE-COD.
            
			
            EXEC SQL 
                OPEN RESULTSET_CSR00063
            END-EXEC
            
      *     Consume returned result set. 
      *     Do nothing with result set as it is not used by callers.	  
            EXEC SQL FETCH RESULTSET_CSR00063 INTO
               :V_LOCAL_ERROR_CSR00063
            END-EXEC  
            
            EXEC SQL 
                CLOSE RESULTSET_CSR00063
            END-EXEC                                                                                   
            .                                                  
      ************************ End of Program **************************        
