       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   WSR00062.                                          
       
      ******************************************************************        
      *  WSR00062  -- CSR00062 T-SQL SP wrapper                        *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION. 
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.    

           EXEC SQL DECLARE RESULTSET_CSR00062 CURSOR FOR
                 CALL "CSR00062" ( :lsV-PREMISE-NO      ,
                 :lsV-ACCOUNT-NO      ,
                 :lsV-ACCOUNT-NO-PRIOR,
                 :lsV-ORDER-TYPE-CD   ,
                 :lsV-LOCAL-OFFICE    ,
                 :lsV-PHONE-NO-EXT    ,
                 :lsV-PHONE-NO        ,
                 :lsV-ORDER-PLACED-BY ,
                 :lsV-ORDER-RECVED-BY ,
                 :lsV-WANTED-BY-DATE  ,
                 :lsV-DATE-FORECAST-DN,
                 :lsV-ORDER-REASON    ,
                 :lsV-BACK-DATED-IND  ,
                 :lsV-RESP-AREA-ID    ,
                 :lsV-CALL-BEFORE-MIN ,
                 :lsV-NOTIFY-CUST-IND ,
                 :lsV-NOTIFY-CSR-IND  ,
                 :lsV-BREAKERS-OFF    ,
                 :lsV-DEPOSIT-AMT     ,
                 :lsV-AMT-DNP-AT-BILLI,
                 :lsV-INIT-BY-CNTRCT  ,
                 :lsV-WORK-AREA-ID    ,
                 :lsV-ORDER-PRIORITY  ,
                 :lsV-ORDER-STATE-CD  ,
                 :lsV-VERIFY-RATE     ,
                 :lsV-ASSIGNED-DATETIM,
                 :lsV-SO-EST-LABOR-HR ,
                 :lsV-SERV-ORDER-NO   INOUT,
                 :lsV-ACCT-STATUS     ,
                 :lsV-REORDER-FLAG    ,
                 :lsV-COMPANY-NO      ,
                 :lsV-CODE-KEY-FIELD  ,
                 :lsV-RCC-CODE        ,
                 :lsV-PRICE-PER-SERV  ,
                 :lsV-ACCOUNT-TYPE-COD,
                 :lsV-CUST-CNT-ID     ,
                 :lsV-BUSINESS-UNIT   ,
                 :lsV-OPTIMIZE-ORDER )
		    END-EXEC
         01  V_LOCAL_ERROR_CSR00062             PIC S9(9) COMP VALUE 0. 


       LINKAGE SECTION.                                                 
		 
       01  lsV-PREMISE-NO              PIC S9(10)  COMP-3.
       01  lsV-ACCOUNT-NO              PIC S9(13)  COMP-3.
       01  lsV-ACCOUNT-NO-PRIOR        PIC S9(13)  COMP-3.
       01  lsV-ORDER-TYPE-CD           PIC X(5).
       01  lsV-LOCAL-OFFICE            PIC X(3).
       01  lsV-PHONE-NO-EXT            PIC X(6).
       01  lsV-PHONE-NO                PIC X(10).
       01  lsV-ORDER-PLACED-BY         PIC X(25).
       01  lsV-ORDER-RECVED-BY         PIC X(7).
       01  lsV-WANTED-BY-DATE          PIC X(26).
       01  lsV-DATE-FORECAST-DN        PIC X(10).
       01  lsV-ORDER-REASON            PIC X(2).
       01  lsV-BACK-DATED-IND          PIC X(1).
       01  lsV-RESP-AREA-ID            PIC X(4).
       01  lsV-CALL-BEFORE-MIN         PIC X(3).
       01  lsV-NOTIFY-CUST-IND         PIC X(1).
       01  lsV-NOTIFY-CSR-IND          PIC X(1).
       01  lsV-BREAKERS-OFF            PIC X(1).
       01  lsV-DEPOSIT-AMT             PIC S9(9)V9(2)  COMP-3.
       01  lsV-AMT-DNP-AT-BILLI        PIC S9(9)V9(2)  COMP-3.
       01  lsV-INIT-BY-CNTRCT          PIC X(1).
       01  lsV-WORK-AREA-ID            PIC X(12).
       01  lsV-ORDER-PRIORITY          PIC S9(4) BINARY.
       01  lsV-ORDER-STATE-CD          PIC X(1).
       01  lsV-VERIFY-RATE             PIC X(1).
       01  lsV-ASSIGNED-DATETIM        PIC X(26).
       01  lsV-SO-EST-LABOR-HR         PIC S9(5)V9(1)  COMP-3.
       01  lsV-SERV-ORDER-NO           PIC S9(13)  COMP-3.
       01  lsV-ACCT-STATUS             PIC X(1).
       01  lsV-REORDER-FLAG            PIC X(1).
       01  lsV-COMPANY-NO              PIC X(2).
       01  lsV-CODE-KEY-FIELD          PIC X(1).
       01  lsV-RCC-CODE                PIC X(3).
       01  lsV-PRICE-PER-SERV          PIC S9(3)V9(6)  COMP-3.
       01  lsV-ACCOUNT-TYPE-COD        PIC X(1).
       01  lsV-CUST-CNT-ID             PIC X(10).
       01  lsV-BUSINESS-UNIT           PIC X(3).
       01  lsV-OPTIMIZE-ORDER          PIC X(1).
                                                                        
       PROCEDURE DIVISION USING  lsV-PREMISE-NO      ,
                 lsV-ACCOUNT-NO      ,
                 lsV-ACCOUNT-NO-PRIOR,
                 lsV-ORDER-TYPE-CD   ,
                 lsV-LOCAL-OFFICE    ,
                 lsV-PHONE-NO-EXT    ,
                 lsV-PHONE-NO        ,
                 lsV-ORDER-PLACED-BY ,
                 lsV-ORDER-RECVED-BY ,
                 lsV-WANTED-BY-DATE  ,
                 lsV-DATE-FORECAST-DN,
                 lsV-ORDER-REASON    ,
                 lsV-BACK-DATED-IND  ,
                 lsV-RESP-AREA-ID    ,
                 lsV-CALL-BEFORE-MIN ,
                 lsV-NOTIFY-CUST-IND ,
                 lsV-NOTIFY-CSR-IND  ,
                 lsV-BREAKERS-OFF    ,
                 lsV-DEPOSIT-AMT     ,
                 lsV-AMT-DNP-AT-BILLI,
                 lsV-INIT-BY-CNTRCT  ,
                 lsV-WORK-AREA-ID    ,
                 lsV-ORDER-PRIORITY  ,
                 lsV-ORDER-STATE-CD  ,
                 lsV-VERIFY-RATE     ,
                 lsV-ASSIGNED-DATETIM,
                 lsV-SO-EST-LABOR-HR ,
                 lsV-SERV-ORDER-NO   ,
                 lsV-ACCT-STATUS     ,
                 lsV-REORDER-FLAG    ,
                 lsV-COMPANY-NO      ,
                 lsV-CODE-KEY-FIELD  ,
                 lsV-RCC-CODE        ,
                 lsV-PRICE-PER-SERV  ,
                 lsV-ACCOUNT-TYPE-COD,
                 lsV-CUST-CNT-ID     ,
                 lsV-BUSINESS-UNIT   ,
                 lsV-OPTIMIZE-ORDER.
            
            EXEC SQL 
                OPEN RESULTSET_CSR00062
            END-EXEC
            			
      *     Consume returned result set. 
      *     Do nothing with result set as it is not used by callers.	  
            EXEC SQL FETCH RESULTSET_CSR00062 INTO
               :V_LOCAL_ERROR_CSR00062
            END-EXEC  
            
            EXEC SQL 
               CLOSE RESULTSET_CSR00062
            END-EXEC                                                                                   
            .                                                  
      ************************ End of Program **************************        
