       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   WSR00061.                                          
       
      ******************************************************************        
      *  WSR00061  -- CSR00061 T-SQL SP wrapper                        *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION. 
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.    

           EXEC SQL DECLARE RESULTSET_CSR00061 CURSOR FOR
                 CALL "CSR00061" (:lsV_PREMISE_NO,       
	                              :lsV_ACCOUNT_NO,       
	                              :lsV_ACCOUNT_NO_PRIOR, 
	                              :lsV_SERV_ORDER_NO,    
	                              :lsV_ORDER_TYPE_CD,    
	                              :lsV_LOCAL_OFFICE,     
	                              :lsV_PHONE_NO_EXT,     
	                              :lsV_PHONE_NO,         
	                              :lsV_ORDER_PLACED_BY,  
	                              :lsV_ORDER_RECVED_BY,  
	                              :lsV_WANTED_BY_DATE,   
	                              :lsV_ASSIGNED_DATETIM, 
	                              :lsV_ORDER_REASON,     
	                              :lsV_BACK_DATED_IND,   
	                              :lsV_RESP_AREA_ID,     
	                              :lsV_CALL_BEFORE_MIN,  
	                              :lsV_NOTIFY_CUST_IND,  
	                              :lsV_NOTIFY_CSR_IND,   
	                              :lsV_BREAKERS_OFF,     
	                              :lsV_DEPOSIT_AMT,      
	                              :lsV_INIT_BY_CNTRCT,   
	                              :lsV_WORK_AREA_ID,     
	                              :lsV_ORDER_PRIORITY,   
	                              :lsV_ORDER_STATE_CD,   
	                              :lsV_WORK_TYPE_CD,     
	                              :lsV_CODE_UTIL_TYPE,  
	                              :lsV_STD_CHG_AMT,      
	                              :lsV_VERIFY_RATE,      
	                              :lsV_PANEL_NO,         
	                              :lsV_USER_ID,          
	                              :lsV_SO_EST_LABOR_HR,  
	                              :lsV_ACCT_STATUS,      
	                              :lsV_REORDER_FLAG,     
	                              :lsV_COMPANY_NO,       
	                              :lsV_OLD_ACCOUNT_STAT, 
	                              :lsV_CODE_KEY_FIELD,   
	                              :lsV_DATE_FORECAST_DN, 
	                              :lsV_AMT_DNP_AT_BILLI, 
	                              :lsV_PRICE_PER_SERV,   
	                              :lsV_ACCOUNT_TYPE_COD, 
	                              :lsV_WORK_PERIOD_CD,   
	                              :lsV_WAIVER_TYPE_CD,   
	                              :lsV_BUSINESS_UNIT,    
	                              :lsV_OPTIMIZE_ORDER   
                                  )
		    END-EXEC
         01  V_RETURN_CODE_CSR00061        PIC S9(9) COMP VALUE 0.
         01  V_M_SERV_ORDER_NO_CSR00061    PIC S9(13) COMP-3.		 

       LINKAGE SECTION.                                                 
       
       01 lsV_PREMISE_NO       PIC X(10).
       01 lsV_ACCOUNT_NO       PIC X(13).
       01 lsV_ACCOUNT_NO_PRIOR PIC X(13).
       01 lsV_SERV_ORDER_NO    PIC X(13).
       01 lsV_ORDER_TYPE_CD    PIC X(5).
       01 lsV_LOCAL_OFFICE     PIC X(3).
       01 lsV_PHONE_NO_EXT     PIC X(6).
       01 lsV_PHONE_NO         PIC X(10).
       01 lsV_ORDER_PLACED_BY  PIC X(25).
       01 lsV_ORDER_RECVED_BY  PIC X(7).
       01 lsV_WANTED_BY_DATE   PIC X(10).
       01 lsV_ASSIGNED_DATETIM PIC X(26).
       01 lsV_ORDER_REASON     PIC X(1).
       01 lsV_BACK_DATED_IND   PIC X(1).
       01 lsV_RESP_AREA_ID     PIC X(3).
       01 lsV_CALL_BEFORE_MIN  PIC X(3).
       01 lsV_NOTIFY_CUST_IND  PIC X(1).
       01 lsV_NOTIFY_CSR_IND   PIC X(1).
       01 lsV_BREAKERS_OFF     PIC X(1).
       01 lsV_DEPOSIT_AMT      PIC S9(11)V9(2) COMP-3.
       01 lsV_INIT_BY_CNTRCT   PIC X(1).
       01 lsV_WORK_AREA_ID     PIC X(12).
       01 lsV_ORDER_PRIORITY   PIC S9(4) BINARY.
       01 lsV_ORDER_STATE_CD   PIC X(1).
       01 lsV_WORK_TYPE_CD     PIC X(3).
       01 lsV_CODE_UTIL_TYPE   PIC X(1).
       01 lsV_STD_CHG_AMT      PIC S9(9)V9(2) COMP-3.
       01 lsV_VERIFY_RATE      PIC X(1).
       01 lsV_PANEL_NO         PIC X(4).
       01 lsV_USER_ID          PIC X(7).
       01 lsV_SO_EST_LABOR_HR  PIC S9(3)V9(1) COMP-3.
       01 lsV_ACCT_STATUS      PIC X(1).
       01 lsV_REORDER_FLAG     PIC X(1).
       01 lsV_COMPANY_NO       PIC X(2).
       01 lsV_OLD_ACCOUNT_STAT PIC X(1).
       01 lsV_CODE_KEY_FIELD   PIC X(1).
       01 lsV_DATE_FORECAST_DN PIC X(10).
       01 lsV_AMT_DNP_AT_BILLI PIC S9(11)V9(2) COMP-3.
       01 lsV_PRICE_PER_SERV   PIC S9(9)V9(6) COMP-3.
       01 lsV_ACCOUNT_TYPE_COD PIC X(1).
       01 lsV_WORK_PERIOD_CD   PIC X(1).
       01 lsV_WAIVER_TYPE_CD   PIC X(1).
       01 lsV_BUSINESS_UNIT    PIC X(3).
       01 lsV_OPTIMIZE_ORDER   PIC X(1).
       01 lsO_V_NO_ERROR       PIC S9(9) COMP.
       01 lsO_V_M_SERV_ORDER_NO  PIC S9(13) COMP-3.
			
       PROCEDURE DIVISION USING lsV_PREMISE_NO,       
	                            lsV_ACCOUNT_NO,       
	                            lsV_ACCOUNT_NO_PRIOR, 
	                            lsV_SERV_ORDER_NO,    
	                            lsV_ORDER_TYPE_CD,    
	                            lsV_LOCAL_OFFICE,     
	                            lsV_PHONE_NO_EXT,     
	                            lsV_PHONE_NO,         
	                            lsV_ORDER_PLACED_BY,  
	                            lsV_ORDER_RECVED_BY,  
	                            lsV_WANTED_BY_DATE,   
	                            lsV_ASSIGNED_DATETIM, 
	                            lsV_ORDER_REASON,     
	                            lsV_BACK_DATED_IND,   
	                            lsV_RESP_AREA_ID,     
	                            lsV_CALL_BEFORE_MIN,  
	                            lsV_NOTIFY_CUST_IND,  
	                            lsV_NOTIFY_CSR_IND,   
	                            lsV_BREAKERS_OFF,     
	                            lsV_DEPOSIT_AMT,      
	                            lsV_INIT_BY_CNTRCT,   
	                            lsV_WORK_AREA_ID,     
	                            lsV_ORDER_PRIORITY,   
	                            lsV_ORDER_STATE_CD,   
	                            lsV_WORK_TYPE_CD,     
	                            lsV_CODE_UTIL_TYPE,  
	                            lsV_STD_CHG_AMT,      
	                            lsV_VERIFY_RATE,      
	                            lsV_PANEL_NO,         
	                            lsV_USER_ID,          
	                            lsV_SO_EST_LABOR_HR,  
	                            lsV_ACCT_STATUS,      
	                            lsV_REORDER_FLAG,     
	                            lsV_COMPANY_NO,       
	                            lsV_OLD_ACCOUNT_STAT, 
	                            lsV_CODE_KEY_FIELD,   
	                            lsV_DATE_FORECAST_DN, 
	                            lsV_AMT_DNP_AT_BILLI, 
	                            lsV_PRICE_PER_SERV,   
	                            lsV_ACCOUNT_TYPE_COD, 
	                            lsV_WORK_PERIOD_CD,   
	                            lsV_WAIVER_TYPE_CD,   
	                            lsV_BUSINESS_UNIT,    
	                            lsV_OPTIMIZE_ORDER,   
	                            lsO_V_NO_ERROR,       
	                            lsO_V_M_SERV_ORDER_NO.

			
            EXEC SQL 
                OPEN RESULTSET_CSR00061
            END-EXEC
            
      *     Consume returned result set. 
      *     Do nothing with result set as it is not used by callers.	  
            EXEC SQL FETCH RESULTSET_CSR00061 INTO
               :V_RETURN_CODE_CSR00061,
			   :V_M_SERV_ORDER_NO_CSR00061
            END-EXEC  
            
            MOVE V_RETURN_CODE_CSR00061 TO lsO_V_NO_ERROR
            MOVE V_M_SERV_ORDER_NO_CSR00061 TO lsO_V_M_SERV_ORDER_NO
			
            EXEC SQL 
                CLOSE RESULTSET_CSR00061
            END-EXEC                                                                                   
            .                                                  
      ************************ End of Program **************************        
