       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04921.                                         
       AUTHOR.        VENKAT PONNEKANTI                                 
COB303 DATE-WRITTEN.  JAN 09, 2017.                                     
       DATE-COMPILED.                                                   
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      * UPDATES CSS_BATCH_EMAIL STATUS FOR REAL-TIME NOTIFICATIONS     *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      * BUSS-OP: UPDCUSTREALTIMENOTIFICATIONS                          *        
      *                                                                *        
      ******************************************************************        
      *                     PROGRAM MODIFICATION LOG                   *        
      ******************************************************************        
      * -------- -------- -------------------------------------------- *        
      *   DATE   INITIALS COMMENTS                                     *        
      * -------- -------- -------------------------------------------- *        
P00948* 01/09/17 VENKAT.P INITIAL IMPLEMENTATION.                      *        
      *                                                                *        
      ******************************************************************        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      ******************************************************************        
      * 0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION              *        
      * 1000 - 1999  INPUT PROCESSING CONTROL PATH                     *        
      * 2000 - 2999  OUTPUT PROCESSING CONTROL PATH                    *        
      * 3000 - 4999  NOT USED                                          *        
      * 5000 - 5999  COMMON PROGRAM MODULES                            *        
      * 6000 - 6999  COMMON SYSTEM MODULES                             *        
      * 7000 - 7999  INPUT MODULES                                     *        
      * 8000 - 8999  OUTPUT MODULES                                    *        
      * 9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES              *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04921'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40) VALUE                  
           'WORKING STORAGE FOR CSR04921 STARTS HERE'.                  
      *                                                                         
       01 WS-MISC.                                                      
          05 PROGRAM-NAME              PIC X(08)   VALUE 'CSR04921'.    
      *                                                                         
       01 GTT-RETURN-FIELDS.                                            
          05 S-APPL-RETURN-CODE        PIC X(10)   VALUE SPACES.        
          05 S-RETURN-CODE             PIC S9(9)   COMP  VALUE 0.       
      *                                                                         
       01 SWITCHES.                                                     
          05 SEND-DONE-SW              PIC X(01)   VALUE 'Y'.           
             88 SEND-DONE-ERROR                    VALUE 'N'.           
             88 SEND-DONE-OK                       VALUE 'Y'.           
      *                                                                         
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_BATCH_EMAIL - AE                                           *        
      ******************************************************************        
      *                                                                 00782400
           EXEC SQL                                                     00780200
                INCLUDE TBBEMAIL                                        00782200
           END-EXEC.                                                    00782300
      *                                                                 00782400
      ******************************************************************        
      * ERROR HANDLING                                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                            *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                 03050835
      ******************************************************************03050842
      * DECLARE RESULT SET CURSORS                                     *03050843
      ******************************************************************03050844
      *                                                                 03050850
           EXEC SQL                                                     
                DECLARE C1 CURSOR  FOR                       
                SELECT                                                  
                     :S-APPL-RETURN-CODE    AS APPL_RETURN_CODE         
                    ,:S-RETURN-CODE         AS RETURN_CODE              
                FROM                                                    
                     CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*              :S-APPL-RETURN-CODE    AS APPL_RETURN_CODE                 
MFA-TR*             ,:S-RETURN-CODE         AS RETURN_CODE                      
MFA-TR*         FROM                                                            
MFA-TR*              SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  PARM-APPL-NAME              PIC X(08).                       
       01  PARM-EMAIL-ID               PIC S9(9) COMP.                  
       01  PARM-PROCESSED-CD           PIC X(01).                       
       01  PARM-VENDOR-RESP-TXT        PIC X(250).                      
       01  PARM-VENDOR-RESP-LEN        PIC S9(9) COMP.                  
      *                                                                         
       PROCEDURE DIVISION USING PARM-APPL-NAME                          
                                PARM-EMAIL-ID                           
                                PARM-PROCESSED-CD                       
                                PARM-VENDOR-RESP-TXT                    
                                PARM-VENDOR-RESP-LEN.                   
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS.                                
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE PARM-EMAIL-ID               TO AE-BATCH-EMAIL-ID        
           MOVE PARM-PROCESSED-CD           TO AE-PROCESSED-CD          
           MOVE PARM-VENDOR-RESP-TXT        TO AE-VENDOR-RESP-DATA-TEXT 
           MOVE PARM-VENDOR-RESP-LEN        TO AE-VENDOR-RESP-DATA-LEN. 
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           PERFORM 8000-UPD-BATCH-EMAIL     THRU 8000-EXIT.             
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8000-UPD-BATCH-EMAIL                                           *        
      ******************************************************************        
      *                                                                         
       8000-UPD-BATCH-EMAIL.                                            
      *                                                                         
           MOVE '8000'                      TO ACTIVE-PARAGRAPH         
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_BATCH_EMAIL                                   
                  SET PROCESSED_CD     = :AE-PROCESSED-CD               
                     ,PROCESSED_DT     = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                   
                     ,VENDOR_RESP_DATA = :AE-VENDOR-RESP-DATA           
                WHERE BATCH_EMAIL_ID   = :AE-BATCH-EMAIL-ID             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_BATCH_EMAIL                                           
MFA-TR*           SET PROCESSED_CD     = :AE-PROCESSED-CD                       
MFA-TR*              ,PROCESSED_DT     = CURRENT DATE                           
MFA-TR*              ,VENDOR_RESP_DATA = :AE-VENDOR-RESP-DATA                   
MFA-TR*         WHERE BATCH_EMAIL_ID   = :AE-BATCH-EMAIL-ID                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE ' CSS_BATCH_EMAIL'       TO TABLE-1                  
              MOVE 'BATCH_EMAIL_ID'         TO TABLE-ELEMENT-1          
              MOVE AE-BATCH-EMAIL-ID        TO HOSTVAR-ELEMENT-1        
              MOVE 'PROCESSED_CD'           TO TABLE-ELEMENT-2          
              MOVE AE-PROCESSED-CD          TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07942004
      ******************************************************************13990524
      * 8900-SEND-DONE.                                                *13990624
      ******************************************************************13990724
      *                                                                 13990824
       8900-SEND-DONE.                                                  
      *                                                                 13991024
           EXEC SQL                                                     
                OPEN C1                                                 
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                 13991624
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************14009327
      * 9000-SEND-ERROR-RESULT                                         *14009427
      ******************************************************************14009527
      *                                                                 14009528
       9000-SEND-ERROR-RESULT.                                          
      *                                                                 14009727
           MOVE 'N'                   TO SEND-DONE-SW.                  
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
      *                                                                 14010932
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
      *                                                                 14011337
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14012232
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
      *                                                                         
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
      *                                                                         
       9700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
      *                                                                         
           PERFORM 8900-SEND-DONE THRU 8900-EXIT                        
           
MSQ016        GOBACK.                                                    
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
