       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04920.                                         
       AUTHOR.        VENKAT PONNEKANTI                                 
COB303 DATE-WRITTEN.  JAN 06, 2017.                                     
       DATE-COMPILED.                                                   
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      * RETRIEVES REAL TIME EMAILS FROM CSS_BATCH_EMAIL                *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *    - PARM-APPL-NAME                                            *        
      *    - PARM-EMAIL-EVENT-CD (OPTIONAL)                            *        
      *      WHEN ' ' SENDS ALL EMAIL EVENT TYPES                      *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      * - RESULT SET#1:                                                *        
      *   EMAIL EVENTS FROM CSS_BATCH_EMAIL TABLE                      *        
      * - RESULT SET#2:                                                *        
      *   EMAIL EVENT DATA IN THE SAME ORDER AS LISTED IN TEMPLATE     *        
      * - RESULT SET#3:                                                *        
      *   LOG ENTRIES OF EMAIL PROCESSING ERRORS                       *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      * BUSS-OP: GETCUSTREALTIMENOTIFICATIONS                          *        
      *                                                                *        
      ******************************************************************        
      *                     PROGRAM MODIFICATION LOG                   *        
      ******************************************************************        
      * -------- -------- -------------------------------------------- *        
      *   DATE   INITIALS COMMENTS                                     *        
      * -------- -------- -------------------------------------------- *        
P00948* 01/07/17 VENKAT.P INITIAL IMPLEMENTATION.                      *        
P00948* 03/22/17 VENKAT.P UPDATE E-MAIL EVENT AS EXTRACTED             *        
      *                                                                *        
      ******************************************************************        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      ******************************************************************        
      * 0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION              *        
      * 1000 - 1999  INPUT PROCESSING CONTROL PATH                     *        
      * 2000 - 2999  OUTPUT PROCESSING CONTROL PATH                    *        
      * 3000 - 4999  NOT USED                                          *        
      * 5000 - 5999  COMMON PROGRAM MODULES                            *        
      * 6000 - 6999  COMMON SYSTEM MODULES                             *        
      * 7000 - 7999  INPUT MODULES                                     *        
      * 8000 - 8999  OUTPUT MODULES                                    *        
      * 9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES              *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04920'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40) VALUE                  
           'WORKING STORAGE FOR CSR04920 STARTS HERE'.                  
      *                                                                         
       01 WS-MISC.                                                      
          05 PROGRAM-NAME              PIC X(08)   VALUE 'CSR04920'.    
          05 WS-PGRMNAME               PIC X(08)   VALUE 'CSR04920'.    
          05 WS-ACCOUNT-NO-X           PIC X(13)   VALUE SPACES.        
          05 WS-ACCOUNT-NO REDEFINES WS-ACCOUNT-NO-X.                   
             10 WS-ACCOUNT-NO-9        PIC X(09).                       
             10 FILLER                 PIC X(04).                       
          05 WS-EMAIL-EVENT-SRCH       PIC X(05)   VALUE '%%%%%'.       
          05 WS-SERV-ADDRESS           PIC X(80)   VALUE SPACES.        
          05 WS-CUST-NAME              PIC X(70)   VALUE SPACES.        
      *                                                                         
       01 WS-COUNTERS.                                                  
          05 CTR-ROWS-R1               PIC S9(9)   COMP  VALUE 0.       
          05 CTR-ROWS-R2               PIC S9(9)   COMP  VALUE 0.       
          05 CTR-ROWS-R3               PIC S9(9)   COMP  VALUE 0.       
      *                                                                         
       01 WS-SWITCHES.                                                  
          05 ALL-DONE-SW-1             PIC X(01)   VALUE 'N'.           
             88 NOT-ALL-DONE-1                     VALUE 'N'.           
             88 ALL-DONE-1                         VALUE 'Y'.           
          05 ALL-DONE-SW-2             PIC X(01)   VALUE 'N'.           
             88 NOT-ALL-DONE-2                     VALUE 'N'.           
             88 ALL-DONE-2                         VALUE 'Y'.           
      *                                                                         
       01 GTT-RETURN-FIELDS.                                            
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE          PIC S9(9)    COMP VALUE 0.       
             10 S-ACCOUNT-NO           PIC X(13)   VALUE SPACES.        
             10 S-COMPANY-NAME         PIC X(40)   VALUE SPACES.        
             10 S-CUSTOMER-NO          PIC X(10)   VALUE SPACES.        
             10 S-EMAIL-TO-ADDR        PIC X(100)  VALUE SPACES.        
             10 S-EMAIL-CC-ADDR        PIC X(100)  VALUE SPACES.        
             10 S-DISP-PREF-CD         PIC X(01)   VALUE SPACES.        
             10 S-EMAIL-EVENT-CD       PIC X(05)   VALUE SPACES.        
             10 S-CUST-NAME            PIC X(70)   VALUE SPACES.        
             10 S-USER-ID              PIC X(10)   VALUE SPACES.        
             10 S-EMAIL-IMAGE-FL       PIC X(01)   VALUE SPACES.        
             10 S-BATCH-EMAIL-ID       PIC S9(9)    COMP VALUE 0.       
      *                                                                         
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2        PIC S9(9)    COMP VALUE 0.       
             10 S-BATCH-EMAIL-ID-2     PIC S9(9)    COMP VALUE 0.       
             10 S-SERIAL-NO            PIC S9(9)    COMP VALUE 0.       
             10 S-FIELD-VALUE-TX       PIC X(250)  VALUE SPACES.        
      *                                                                         
          05 GTT-RETURN-FIELDS-3.                                       
             10 S-RETURN-CODE-3        PIC S9(9)    COMP VALUE 0.       
             10 S-BATCH-EMAIL-ID-3     PIC S9(9)    COMP VALUE 0.       
             10 S-VENDOR-RESP-TX       PIC X(250)  VALUE SPACES.        
      *                                                                         
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_BATCH_EMAIL - AE                                           *        
      ******************************************************************        
      *                                                                 00782400
           EXEC SQL                                                     00780200
                INCLUDE TBBEMAIL                                        00782200
           END-EXEC.                                                    00782300
      *                                                                         
      ******************************************************************        
      * CSS_ACCOUNT - AT                                               *        
      ******************************************************************        
      *                                                                 00782400
           EXEC SQL                                                     00780200
                INCLUDE TBACCT                                          00782200
           END-EXEC.                                                    00782300
      *                                                                 00782400
      ******************************************************************        
      * CSS_ZIP_CODE - A4                                              *        
      ******************************************************************        
      *                                                                 00782400
           EXEC SQL                                                     00780200
                INCLUDE TBZIPCD                                         00782200
           END-EXEC.                                                    00782300
      *                                                                 00782400
      ******************************************************************        
      * CSS_CUSTOMER - CU                                              *        
      ******************************************************************        
      *                                                                 00782400
           EXEC SQL                                                     00780200
                INCLUDE TBCUST                                          00782200
           END-EXEC.                                                    00782300
      *                                                                 00782400
      ******************************************************************        
      * CSS_NAME - DQ                                                  *        
      ******************************************************************        
      *                                                                 00782400
           EXEC SQL                                                     00780200
                INCLUDE TBNAME                                          00782200
           END-EXEC.                                                    00782300
      *                                                                 00782400
      ******************************************************************        
      * CSS_ADDR_FORMATTED - DY                                        *        
      ******************************************************************        
      *                                                                 00782400
           EXEC SQL                                                     00780200
                INCLUDE TBADRFMT                                        00782200
           END-EXEC.                                                    00782300
      *                                                                         
      ******************************************************************        
      * CSS_BTCH_EMAIL_DET - JK                                        *        
      ******************************************************************        
      *                                                                 00782400
           EXEC SQL                                                     00780200
                INCLUDE TBBTEDET                                        00782200
           END-EXEC.                                                    00782300
      *                                                                 00782400
      ******************************************************************        
      * CSS_CUST_EMAIL - NE                                            *        
      ******************************************************************        
      *                                                                 00782400
           EXEC SQL                                                     00780200
                INCLUDE TBCSTEML                                        00782200
           END-EXEC.                                                    00782300
      *                                                                 00782400
      ******************************************************************        
      * CSS_PREMISE - PR                                               *        
      ******************************************************************        
      *                                                                 00782400
           EXEC SQL                                                     00780200
                INCLUDE TBPREM                                          00782200
           END-EXEC.                                                    00782300
      *                                                                 00782400
      ******************************************************************        
      * CSS_EMAIL_EVENT - 2T                                           *        
      ******************************************************************        
      *                                                                 00782400
           EXEC SQL                                                     00780200
                INCLUDE  TBEMEVNT                                       00782200
           END-EXEC.                                                    00782300
      *                                                                 00782400
      ******************************************************************        
      * ERROR HANDLING                                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                            *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      ******************************************************************        
      * REAL TIME EMAIL CURSOR                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
                DECLARE EMAIL_EVENTS_CUR CURSOR FOR                     
                 SELECT  AE.BATCH_EMAIL_ID                              
                        ,AE.ACCOUNT_NO                                  
                        ,AE.CUSTOMER_NO                                 
                        ,AE.EMAIL_EVENT_CD                              
                        ,AE.COMPANY_NO                                  
                        ,[2T].EVENT_VENDOR_NM                             
                   FROM  CSS_EMAIL_EVENT [2T] WITH(READUNCOMMITTED)             
                        ,CSS_BATCH_EMAIL AE WITH(READUNCOMMITTED)               
                  WHERE [2T].EVENT_CHANNEL_CD  = 'T'                      
                    AND [2T].EVENT_PROCESS_CD  = 'R'                      
                    AND [2T].EVENT_STATUS_CD   = 'A'                      
                    AND [2T].COMPANY_NO        = AE.COMPANY_NO            
                    AND [2T].EMAIL_EVENT_CD    = AE.EMAIL_EVENT_CD        
                    AND AE.EMAIL_EVENT_CD LIKE :WS-EMAIL-EVENT-SRCH     
                    AND (AE.PROCESSED_CD     = '' OR                    
                         AE.PROCESSED_CD    IS NULL)                    
                    FOR READ ONLY                                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE EMAIL_EVENTS_CUR CURSOR FOR                             
MFA-TR*          SELECT  AE.BATCH_EMAIL_ID                                      
MFA-TR*                 ,AE.ACCOUNT_NO                                          
MFA-TR*                 ,AE.CUSTOMER_NO                                         
MFA-TR*                 ,AE.EMAIL_EVENT_CD                                      
MFA-TR*                 ,AE.COMPANY_NO                                          
MFA-TR*                 ,2T.EVENT_VENDOR_NM                                     
MFA-TR*            FROM  CSS_EMAIL_EVENT 2T                                     
MFA-TR*                 ,CSS_BATCH_EMAIL AE                                     
MFA-TR*           WHERE 2T.EVENT_CHANNEL_CD  = 'T'                              
MFA-TR*             AND 2T.EVENT_PROCESS_CD  = 'R'                              
MFA-TR*             AND 2T.EVENT_STATUS_CD   = 'A'                              
MFA-TR*             AND 2T.COMPANY_NO        = AE.COMPANY_NO                    
MFA-TR*             AND 2T.EMAIL_EVENT_CD    = AE.EMAIL_EVENT_CD                
MFA-TR*             AND AE.EMAIL_EVENT_CD LIKE :WS-EMAIL-EVENT-SRCH     H       
MFA-TR*             AND (AE.PROCESSED_CD     = '' OR                            
MFA-TR*                  AE.PROCESSED_CD    IS NULL)                            
MFA-TR*             FOR FETCH ONLY                                              
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * EMAIL DETAILS CUSRSOR                                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
                DECLARE EMAIL_EVENT_DTLS_CUR CURSOR FOR                 
                 SELECT  LTRIM(RTRIM(FIELD_NAME_TX))                           
                        ,LTRIM(RTRIM(FIELD_VALUE_TX))                          
                   FROM  CSS_BTCH_EMAIL_DET JK WITH(READUNCOMMITTED)            
                  WHERE JK.BATCH_EMAIL_ID    = :JK-BATCH-EMAIL-ID       
                  ORDER BY 1                                            
                    FOR READ ONLY                                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE EMAIL_EVENT_DTLS_CUR CURSOR FOR                         
MFA-TR*          SELECT  STRIP(FIELD_NAME_TX)                                   
MFA-TR*                 ,STRIP(FIELD_VALUE_TX)                                  
MFA-TR*            FROM  CSS_BTCH_EMAIL_DET JK                                  
MFA-TR*           WHERE JK.BATCH_EMAIL_ID    = :JK-BATCH-EMAIL-ID               
MFA-TR*           ORDER BY 1                                                    
MFA-TR*             FOR FETCH ONLY                                              
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  PARM-APPL-NAME                   PIC X(08).                  
       01  PARM-EMAIL-EVENT-CD              PIC X(05).                  
      *                                                                         
       PROCEDURE DIVISION USING PARM-APPL-NAME                          
                                PARM-EMAIL-EVENT-CD.                    
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS.                                
           PERFORM 0101-DECLARE-GTT-R1      THRU 0101-EXIT.             
           PERFORM 0102-DECLARE-GTT-R2      THRU 0102-EXIT.             
           PERFORM 0103-DECLARE-GTT-R3      THRU 0103-EXIT.             
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0101-DECLARE-GTT-R1                                            *        
      ******************************************************************        
      *                                                                         
       0101-DECLARE-GTT-R1.                                             
      *                                                                         
           MOVE '0101'                      TO ACTIVE-PARAGRAPH         
      *                                                                 33800000
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04920_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04920_R1
              (                                                          
                  RETURN_CODE              INT                      
                 ,ACCOUNT_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2          
                 ,COMPANY_NAME CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2        
                 ,CUSTOMER_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                 ,EMAIL_TO_ADDR CHAR(100)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,EMAIL_CC_ADDR CHAR(100)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,DISP_PREF_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
                 ,EMAIL_EVENT_CD CHAR(05)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,CUST_NAME CHAR(70)  COLLATE LATIN1_GENERAL_100_BIN2           
                 ,USER_ID CHAR(06)  COLLATE LATIN1_GENERAL_100_BIN2             
                 ,EMAIL_IMAGE_FL CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,BATCH_EMAIL_ID           INT                      
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF SQLSTATE = '42710'                                        
              PERFORM 8001A-DEL-GTT-R1      THRU 8001A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL              
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE 'CSR04920_R1'         TO TABLE-1                  
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT *                                                 
                 FROM #CSR04920_R1                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT *                                                         
MFA-TR*          FROM SESSION.CSR04920_R1                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0101-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0102-DECLARE-GTT-R2                                            *        
      ******************************************************************        
      *                                                                         
       0102-DECLARE-GTT-R2.                                             
      *                                                                         
           MOVE '0102'                      TO ACTIVE-PARAGRAPH         
      *                                                                 33800000
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04920_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04920_R2
              (                                                          
                  RETURN_CODE              INT                      
                 ,BATCH_EMAIL_ID           INT                      
                 ,SERIAL_NO                INT                      
                 ,FIELD_VALUE_TX CHAR(250)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF SQLSTATE = '42710'                                        
              PERFORM 8002A-DEL-GTT-R2      THRU 8002A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL              
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE 'CSR04920_R2'         TO TABLE-1                  
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C2 CURSOR  FOR                        
               SELECT *                                                 
                 FROM #CSR04920_R2                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT *                                                         
MFA-TR*          FROM SESSION.CSR04920_R2                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0102-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0103-DECLARE-GTT-R3                                            *        
      ******************************************************************        
      *                                                                         
       0103-DECLARE-GTT-R3.                                             
      *                                                                         
           MOVE '0103'                      TO ACTIVE-PARAGRAPH         
      *                                                                 33800000
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04920_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04920_R3
              (                                                          
                  RETURN_CODE              INT                      
                 ,BATCH_EMAIL_ID           INT                      
                 ,VENDOR_RESP_TX CHAR(250)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF SQLSTATE = '42710'                                        
              PERFORM 8003A-DEL-GTT-R3      THRU 8003A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL              
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE 'CSR04920_R3'         TO TABLE-1                  
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C3 CURSOR  FOR                        
               SELECT *                                                 
                 FROM #CSR04920_R3                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C3 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT *                                                         
MFA-TR*          FROM SESSION.CSR04920_R3                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0103-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
      *                                                                         
           IF PARM-EMAIL-EVENT-CD > SPACES                              
              MOVE PARM-EMAIL-EVENT-CD      TO WS-EMAIL-EVENT-SRCH      
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           PERFORM 2100-GET-EMAIL-EVENTS    THRU 2100-EXIT.             
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-GET-EMAIL-EVENTS.                                         *        
      ******************************************************************        
      *                                                                         
       2100-GET-EMAIL-EVENTS.                                           
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           PERFORM 7000-OPEN-EMAIL-EVENTS-CUR   THRU 7000-EXIT.         
           SET NOT-ALL-DONE-1                   TO TRUE.                
           PERFORM 7010-FETCH-EMAIL-EVENTS-CUR  THRU 7010-EXIT.         
      *                                                                         
           PERFORM UNTIL ALL-DONE-1                                     
              MOVE AE-BATCH-EMAIL-ID            TO S-BATCH-EMAIL-ID     
                                                   S-BATCH-EMAIL-ID-2   
                                                   S-BATCH-EMAIL-ID-3   
                                                   JK-BATCH-EMAIL-ID    
              MOVE AE-ACCOUNT-NO                TO S-ACCOUNT-NO         
              MOVE 2T-EVENT-VENDOR-NM           TO S-COMPANY-NAME       
              MOVE AE-CUSTOMER-NO               TO S-CUSTOMER-NO        
                                                   NE-CUSTOMER-NO       
                                                   CU-CUSTOMER-NO       
              PERFORM 7110-SEL-EMAIL-ID         THRU 7110-EXIT          
              MOVE NE-EMAIL-ADDRESS-TX-TEXT(1:NE-EMAIL-ADDRESS-TX-LEN)  
                                                TO S-EMAIL-TO-ADDR      
              MOVE SPACE                        TO S-EMAIL-CC-ADDR      
              MOVE NE-EMAIL-DISP-PREF-CD        TO S-DISP-PREF-CD       
              MOVE AE-EMAIL-EVENT-CD            TO S-EMAIL-EVENT-CD     
              PERFORM 7120-SEL-CUST-NAME        THRU 7120-EXIT          
              MOVE WS-CUST-NAME                 TO S-CUST-NAME          
              MOVE 'SYSTEM'                     TO S-USER-ID            
              MOVE 'Y'                          TO S-EMAIL-IMAGE-FL     
              PERFORM 8001-INSERT-GTT-R1        THRU 8001-EXIT          
      *                                                                         
              PERFORM 2200-LOAD-EVENT-DATA      THRU 2200-EXIT          
      *                                                                         
              MOVE 'G'                          TO AE-PROCESSED-CD      
              PERFORM 8000-UPD-BATCH-EMAIL      THRU 8000-EXIT          
      *                                                                         
              PERFORM 7010-FETCH-EMAIL-EVENTS-CUR                       
                                                THRU 7010-EXIT          
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7020-CLOSE-EMAIL-EVENTS-CUR  THRU 7020-EXIT.         
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-LOAD-EVENT-DATA                                           *        
      ******************************************************************        
      *                                                                         
       2200-LOAD-EVENT-DATA.                                            
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS-2.                              
      *                                                                         
           EVALUATE AE-EMAIL-EVENT-CD                                   
               WHEN 'CIS58'                                             
                    PERFORM 2300-LOAD-EVENT-DATA-CIS58 THRU 2300-EXIT   
           END-EVALUATE.                                                
      *                                                                         
           PERFORM 2400-GET-EMAIL-EVENT-DTLS    THRU 2400-EXIT.         
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2300-LOAD-EVENT-DATA-CIS58                                     *        
      ******************************************************************        
      *                                                                         
       2300-LOAD-EVENT-DATA-CIS58.                                      
      *                                                                         
           MOVE JK-BATCH-EMAIL-ID            TO S-BATCH-EMAIL-ID        
      * SERVICE ADDRESS                                                         
           MOVE AE-ACCOUNT-NO                TO AT-ACCOUNT-NO           
                                                WS-ACCOUNT-NO-X         
           PERFORM 7100-SELECT-ACCOUNT       THRU 7100-EXIT             
           MOVE AT-PREMISE-NO                TO PR-PREMISE-NO           
           PERFORM 7130-GET-SERV-ADDRESS     THRU 7130-EXIT             
           ADD +1                            TO S-SERIAL-NO             
           MOVE WS-SERV-ADDRESS              TO S-FIELD-VALUE-TX        
           PERFORM 8002-INSERT-GTT-R2        THRU 8002-EXIT             
      * ACCOUNT NUMBER                                                          
           ADD +1                            TO S-SERIAL-NO             
           MOVE '*********'                  TO WS-ACCOUNT-NO-9         
           MOVE WS-ACCOUNT-NO                TO S-FIELD-VALUE-TX        
           PERFORM 8002-INSERT-GTT-R2        THRU 8002-EXIT             
      * CUSTOMER NAME                                                           
           ADD +1                            TO S-SERIAL-NO             
           MOVE S-CUST-NAME                  TO S-FIELD-VALUE-TX        
           PERFORM 8002-INSERT-GTT-R2        THRU 8002-EXIT.            
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2400-GET-EMAIL-EVENT-DTLS.                                     *        
      ******************************************************************        
      *                                                                         
       2400-GET-EMAIL-EVENT-DTLS.                                       
      *                                                                         
           PERFORM 7200-OPEN-EMAIL-EVENT-DTLS   THRU 7200-EXIT.         
           SET NOT-ALL-DONE-2                   TO TRUE.                
           PERFORM 7210-FETCH-EMAIL-EVENT-DTLS  THRU 7210-EXIT.         
      *                                                                         
           PERFORM UNTIL ALL-DONE-2                                     
              ADD +1                            TO S-SERIAL-NO          
              MOVE SPACES                       TO S-FIELD-VALUE-TX     
              MOVE JK-FIELD-VALUE-TX-TEXT(1:JK-FIELD-VALUE-TX-LEN)      
                                                TO S-FIELD-VALUE-TX     
              PERFORM 8002-INSERT-GTT-R2        THRU 8002-EXIT          
              PERFORM 7210-FETCH-EMAIL-EVENT-DTLS THRU 7210-EXIT        
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7220-CLOSE-EMAIL-EVENT-DTLS  THRU 7220-EXIT.         
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7000-OPEN-EMAIL-EVENTS-CUR                                     *        
      ******************************************************************        
      *                                                                 12220000
       7000-OPEN-EMAIL-EVENTS-CUR.                                      
      *                                                                 12220000
           MOVE '7000'                      TO ACTIVE-PARAGRAPH         
      *                                                                 33800000
           EXEC SQL                                                     
              OPEN EMAIL_EVENTS_CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12220000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 12220000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'EMAIL_EVENTS_CUR'       TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                 12220000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12220000
      ******************************************************************        
      * 7010-FETCH-EMAIL-EVENTS-CUR                                    *        
      ******************************************************************        
      *                                                                 12220000
       7010-FETCH-EMAIL-EVENTS-CUR.                                     
      *                                                                 12220000
           MOVE '7010'                      TO ACTIVE-PARAGRAPH         
      *                                                                 33800000
           EXEC SQL                                                     
             FETCH EMAIL_EVENTS_CUR                                     
              INTO :AE-BATCH-EMAIL-ID                                   
                  ,:AE-ACCOUNT-NO                                       
                  ,:AE-CUSTOMER-NO                                      
                  ,:AE-EMAIL-EVENT-CD                                   
                  ,:AE-COMPANY-NO                                       
                  ,:2T-EVENT-VENDOR-NM                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12220000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 12220000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 SET ALL-DONE-1             TO TRUE                     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'EMAIL_EVENTS_CUR'       TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 33800000
      ******************************************************************33760000
      * 7020-CLOSE-EMAIL-EVENTS-CUR                                    *33770000
      ******************************************************************33780000
      *                                                                 33800000
       7020-CLOSE-EMAIL-EVENTS-CUR.                                     
      *                                                                 33800000
           MOVE '7020'                      TO ACTIVE-PARAGRAPH         
      *                                                                 33800000
           EXEC SQL                                                     
              CLOSE EMAIL_EVENTS_CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 33800000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 33800000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'EMAIL_EVENTS_CUR'       TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                 11630000
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-SELECT-ACCOUNT                                            *        
      ******************************************************************        
      *                                                                 12220000
       7100-SELECT-ACCOUNT.                                             
      *                                                                 10120000
           MOVE '7100'                      TO ACTIVE-PARAGRAPH         
      *                                                                 10120000
           EXEC SQL                                                     
                SELECT  PREMISE_NO                                      
                  INTO  :AT-PREMISE-NO                                  
                  FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                        
                 WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     10130000
MFA-TR*         SELECT  PREMISE_NO                                      10150000
MFA-TR*           INTO  :AT-PREMISE-NO                                  10170000
MFA-TR*           FROM CSS_ACCOUNT                                      10180000
MFA-TR*          WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                    10190000
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                    10200000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 10210000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 10230000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7110-SEL-EMAIL-ID.                                            *         
      *****************************************************************         
      *                                                                         
       7110-SEL-EMAIL-ID.                                               
      *                                                                         
           MOVE '7110'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
                SELECT  EMAIL_DISP_PREF_CD                              
                       ,EMAIL_ADDRESS_TX                                
                  INTO  :NE-EMAIL-DISP-PREF-CD                          
                       ,:NE-EMAIL-ADDRESS-TX                            
                  FROM CSS_CUST_EMAIL WITH(READUNCOMMITTED)                     
                 WHERE CUSTOMER_NO    = :NE-CUSTOMER-NO                 
                   AND EMAIL_TYPE_CD  = 'P1'                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07457000
MFA-TR*         SELECT  EMAIL_DISP_PREF_CD                              07457000
MFA-TR*                ,EMAIL_ADDRESS_TX                                07457000
MFA-TR*           INTO  :NE-EMAIL-DISP-PREF-CD                          07457000
MFA-TR*                ,:NE-EMAIL-ADDRESS-TX                            07457000
MFA-TR*           FROM CSS_CUST_EMAIL                                   07457000
MFA-TR*          WHERE CUSTOMER_NO    = :NE-CUSTOMER-NO                 07457000
MFA-TR*            AND EMAIL_TYPE_CD  = 'P1'                            07457000
MFA-TR*           WITH UR                                               07457000
MFA-TR*        QUERYNO 7110                                                     
MFA-TR*    END-EXEC.                                                    07464000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE =  NOT-FOUND                     
                 MOVE 'PRIMARY EMAIL ADDRESS NOT FOUND'                 
                                            TO S-VENDOR-RESP-TX         
                 PERFORM 8003-INSERT-GTT-R3 THRU 8003-EXIT              
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_CUST_EMAIL'         TO TABLE-1                  
              MOVE 'CUSTOMER-NO'            TO TABLE-ELEMENT-1          
              MOVE NE-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7120-SEL-CUST-NAME                                             *        
      ******************************************************************        
      *                                                                 12220000
       7120-SEL-CUST-NAME.                                              
      *                                                                 12220000
           MOVE '7120'                      TO ACTIVE-PARAGRAPH         
      *                                                                 12220000
           EXEC SQL                                                     
                SELECT TOP(1) LTRIM(RTRIM(LAST_NAME)) + ', ' + 
           LTRIM(RTRIM(FIRST_NAME)) + ' ' + CIS.SUBSTR3$(LTRIM(RTRIM(
           MIDDLE_NAME)), 1, 1),
              FULL_NAME,
              NAME_FORMAT                                     
                  INTO :WS-CUST-NAME,                                   
                       :DQ-FULL-NAME,                                   
                       :DQ-NAME-FORMAT                                  
                  FROM CSS_CUSTOMER CU WITH(READUNCOMMITTED),                   
                       CSS_NAME DQ WITH(READUNCOMMITTED)                        
                 WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                    
                   AND CU.NAME_ID  = DQ.NAME_ID                         
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  STRIP(LAST_NAME)  || ', ' ||                            
MFA-TR*                 STRIP(FIRST_NAME) || ' '  ||                            
MFA-TR*                 SUBSTR(STRIP(MIDDLE_NAME), 1, 1)                        
MFA-TR*                ,FULL_NAME                                               
MFA-TR*                ,NAME_FORMAT                                             
MFA-TR*           INTO :WS-CUST-NAME,                                           
MFA-TR*                :DQ-FULL-NAME,                                           
MFA-TR*                :DQ-NAME-FORMAT                                          
MFA-TR*           FROM CSS_CUSTOMER CU,                                         
MFA-TR*                CSS_NAME DQ                                              
MFA-TR*          WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                            
MFA-TR*            AND CU.NAME_ID  = DQ.NAME_ID                                 
MFA-TR*          FETCH FIRST 1 ROWS ONLY                                        
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7120                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12220000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 12220000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF DQ-NAME-FORMAT = 'B'                                
                    MOVE DQ-FULL-NAME       TO WS-CUST-NAME             
                 END-IF                                                 
              ELSE                                                      
                 MOVE SPACES                TO WS-CUST-NAME             
                 MOVE 'CUSTOMER NAME NOT FOUND'                         
                                            TO S-VENDOR-RESP-TX         
                 PERFORM 8003-INSERT-GTT-R3 THRU 8003-EXIT              
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_CUSTOMER'           TO TABLE-1                  
              MOVE 'CSS_NAME'               TO TABLE-2                  
              MOVE 'CUSTOMER_NO'            TO TABLE-ELEMENT-1          
              MOVE CU-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                 12220000
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12220000
      ******************************************************************        
      * 7130-GET-SERV-ADDRESS                                          *        
      ******************************************************************        
      *                                                                 12220000
       7130-GET-SERV-ADDRESS.                                           
      *                                                                 12220000
           MOVE '7130'                      TO ACTIVE-PARAGRAPH         
      *                                                                 12220000
           EXEC SQL                                                     
                SELECT TOP(1) RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(
           RTRIM(ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + 
           ' ' + LTRIM(RTRIM(CIS.SUBSTR3(STREET_NAME,1,1)) + 
           '**********. ' + LTRIM(RTRIM(TOWN) + ', ' + LTRIM(RTRIM(
           STATE) + ' ' + LTRIM(RTRIM(DY.ZIP_CODE)))))))))                 
                  INTO :WS-SERV-ADDRESS                                 
                  FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),             
                       CSS_ZIP_CODE A4 WITH(READUNCOMMITTED),                   
                       CSS_PREMISE PR WITH(READUNCOMMITTED)                     
                 WHERE PREMISE_NO        = :PR-PREMISE-NO               
                   AND PR.ADDRESS_ID     = DY.ADDRESS_ID                
                   AND DY.ZIP_CODE       = A4.ZIP_CODE                  
                   AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN            
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT RTRIM(LTRIM(RTRIM(HOUSE_NO)    || ' '  ||        00010002
MFA-TR*                LTRIM(RTRIM(ADDR_PREFIX_1)     || ' '  ||        00020002
MFA-TR*                LTRIM(RTRIM(ADDR_PREFIX_2)     || ' '  ||        00030002
MFA-TR*                LTRIM(RTRIM(SUBSTR(STREET_NAME,1,1))             00040002
MFA-TR*                                     || '**********. ' ||        00040002
MFA-TR*                LTRIM(RTRIM(TOWN)              || ', ' ||        00090006
MFA-TR*                LTRIM(RTRIM(STATE)             || ' '  ||        00100002
MFA-TR*                LTRIM(RTRIM(DY.ZIP_CODE)))))))))                 00110004
MFA-TR*           INTO :WS-SERV-ADDRESS                                         
MFA-TR*           FROM CSS_ADDR_FORMATTED DY,                           00130001
MFA-TR*                CSS_ZIP_CODE A4,                                 00140001
MFA-TR*                CSS_PREMISE PR                                   00150001
MFA-TR*          WHERE PREMISE_NO        = :PR-PREMISE-NO               00160000
MFA-TR*            AND PR.ADDRESS_ID     = DY.ADDRESS_ID                00170000
MFA-TR*            AND DY.ZIP_CODE       = A4.ZIP_CODE                  00180000
MFA-TR*            AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN            00190000
MFA-TR*          FETCH FIRST 1 ROWS ONLY                                00200000
MFA-TR*           WITH UR                                               00210000
MFA-TR*        QUERYNO 7130                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE =  NOT-FOUND                     
                 MOVE 'SERVICE ADDRESS NOT FOUND'                       
                                            TO S-VENDOR-RESP-TX         
                 PERFORM 8003-INSERT-GTT-R3 THRU 8003-EXIT              
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_PREMISE'            TO TABLE-1                  
              MOVE 'CSS_ADDR_FORMATTED'     TO TABLE-2                  
              MOVE 'CSS_ZIP-CODE'           TO TABLE-3                  
              MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-1          
              MOVE PR-PREMISE-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                 12220000
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12220000
      ******************************************************************        
      * 7200-OPEN-EMAIL-EVENT-DTLS.                                    *        
      ******************************************************************        
      *                                                                 12220000
       7200-OPEN-EMAIL-EVENT-DTLS.                                      
      *                                                                 12220000
           MOVE '7200'                      TO ACTIVE-PARAGRAPH         
      *                                                                 12220000
           EXEC SQL                                                     
              OPEN EMAIL_EVENT_DTLS_CUR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12220000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 12220000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'EMAIL_EVENT_DTLS_CUR'   TO TABLE-1                  
              MOVE 'ACCOUNT-NO'             TO TABLE-ELEMENT-1          
              MOVE AE-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'CUSTOMER-NO'            TO TABLE-ELEMENT-2          
              MOVE AE-CUSTOMER-NO           TO HOSTVAR-ELEMENT-2        
              MOVE 'BATCH_EMAIL_ID'         TO TABLE-ELEMENT-3          
              MOVE JK-BATCH-EMAIL-ID        TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                 12220000
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12220000
      ******************************************************************        
      * 7210-FETCH-EMAIL-EVENT-DTLS                                    *        
      ******************************************************************        
      *                                                                 12220000
       7210-FETCH-EMAIL-EVENT-DTLS.                                     
      *                                                                 12220000
           MOVE '7210'                      TO ACTIVE-PARAGRAPH         
      *                                                                 12220000
           EXEC SQL                                                     
             FETCH EMAIL_EVENT_DTLS_CUR                                 
              INTO :JK-FIELD-NAME-TX                                    
                  ,:JK-FIELD-VALUE-TX                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12220000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 12220000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 SET ALL-DONE-2             TO TRUE                     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7210'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'EMAIL_EVENT_DTLS_CUR'   TO TABLE-1                  
              MOVE 'ACCOUNT-NO'             TO TABLE-ELEMENT-1          
              MOVE AE-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'CUSTOMER-NO'            TO TABLE-ELEMENT-2          
              MOVE AE-CUSTOMER-NO           TO HOSTVAR-ELEMENT-2        
              MOVE 'BATCH_EMAIL_ID'         TO TABLE-ELEMENT-3          
              MOVE JK-BATCH-EMAIL-ID        TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 33800000
      ******************************************************************33760000
      * 7220-CLOSE-EMAIL-EVENT-DTLS                                    *33770000
      ******************************************************************33780000
      *                                                                 33800000
       7220-CLOSE-EMAIL-EVENT-DTLS.                                     
      *                                                                 33800000
           MOVE '7220'                      TO ACTIVE-PARAGRAPH         
      *                                                                 12220000
           EXEC SQL                                                     
              CLOSE EMAIL_EVENT_DTLS_CUR                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 33800000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 33800000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'EMAIL_EVENT_DTLS_CUR'   TO TABLE-1                  
              MOVE 'ACCOUNT-NO'             TO TABLE-ELEMENT-1          
              MOVE AE-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'CUSTOMER-NO'            TO TABLE-ELEMENT-2          
              MOVE AE-CUSTOMER-NO           TO HOSTVAR-ELEMENT-2        
              MOVE 'BATCH_EMAIL_ID'         TO TABLE-ELEMENT-3          
              MOVE JK-BATCH-EMAIL-ID        TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                 11630000
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8000-UPD-BATCH-EMAIL                                           *        
      ******************************************************************        
      *                                                                         
       8000-UPD-BATCH-EMAIL.                                            
      *                                                                         
           MOVE '8000'                      TO ACTIVE-PARAGRAPH         
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_BATCH_EMAIL                                   
                  SET PROCESSED_CD     = :AE-PROCESSED-CD               
                     ,PROCESSED_DT     = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                   
                WHERE BATCH_EMAIL_ID   = :AE-BATCH-EMAIL-ID             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_BATCH_EMAIL                                           
MFA-TR*           SET PROCESSED_CD     = :AE-PROCESSED-CD                       
MFA-TR*              ,PROCESSED_DT     = CURRENT DATE                           
MFA-TR*         WHERE BATCH_EMAIL_ID   = :AE-BATCH-EMAIL-ID                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE ' CSS_BATCH_EMAIL'       TO TABLE-1                  
              MOVE 'BATCH_EMAIL_ID'         TO TABLE-ELEMENT-1          
              MOVE AE-BATCH-EMAIL-ID        TO HOSTVAR-ELEMENT-1        
              MOVE 'PROCESSED_CD'           TO TABLE-ELEMENT-2          
              MOVE AE-PROCESSED-CD          TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07942004
      *                                                                         
      ******************************************************************        
      * 8001A-DEL-GTT-R1.                                              *        
      ******************************************************************        
      *                                                                 11630000
       8001A-DEL-GTT-R1.                                                
      *                                                                 11630000
           MOVE '8001A'                     TO ACTIVE-PARAGRAPH         
      *                                                                 11630000
           EXEC SQL                                                     
               DELETE FROM #CSR04920_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04920_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11630000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 11630000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE ZEROES                   TO WS-ACTIVE-RETURN-CODE    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE WS-ACTIVE-RETURN-CODE    TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'DELETE'                 TO ABEND-FUNCTION           
              MOVE 'CSR04920_R1'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                 11630000
       8001A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8001-INSERT-GTT-R1.                                            *        
      ******************************************************************        
      *                                                                         
       8001-INSERT-GTT-R1.                                              
      *                                                                         
           MOVE '8001'                      TO ACTIVE-PARAGRAPH         
      *                                                                 11630000
           EXEC SQL                                                     
             INSERT INTO #CSR04920_R1                            
             (                                                          
               RETURN_CODE                                              
              ,ACCOUNT_NO                                               
              ,COMPANY_NAME                                             
              ,CUSTOMER_NO                                              
              ,EMAIL_TO_ADDR                                            
              ,EMAIL_CC_ADDR                                            
              ,DISP_PREF_CD                                             
              ,EMAIL_EVENT_CD                                           
              ,CUST_NAME                                                
              ,USER_ID                                                  
              ,EMAIL_IMAGE_FL                                           
              ,BATCH_EMAIL_ID                                           
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE                                            
             ,:S-ACCOUNT-NO                                             
             ,:S-COMPANY-NAME                                           
             ,:S-CUSTOMER-NO                                            
             ,:S-EMAIL-TO-ADDR                                          
             ,:S-EMAIL-CC-ADDR                                          
             ,:S-DISP-PREF-CD                                           
             ,:S-EMAIL-EVENT-CD                                         
             ,:S-CUST-NAME                                              
             ,:S-USER-ID                                                
             ,:S-EMAIL-IMAGE-FL                                         
             ,:S-BATCH-EMAIL-ID                                         
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04920_R1                                    
MFA-TR*      (                                                                  
MFA-TR*        RETURN_CODE                                                      
MFA-TR*       ,ACCOUNT_NO                                                       
MFA-TR*       ,COMPANY_NAME                                                     
MFA-TR*       ,CUSTOMER_NO                                                      
MFA-TR*       ,EMAIL_TO_ADDR                                                    
MFA-TR*       ,EMAIL_CC_ADDR                                                    
MFA-TR*       ,DISP_PREF_CD                                                     
MFA-TR*       ,EMAIL_EVENT_CD                                                   
MFA-TR*       ,CUST_NAME                                                        
MFA-TR*       ,USER_ID                                                          
MFA-TR*       ,EMAIL_IMAGE_FL                                                   
MFA-TR*       ,BATCH_EMAIL_ID                                                   
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      ,:S-ACCOUNT-NO                                                     
MFA-TR*      ,:S-COMPANY-NAME                                                   
MFA-TR*      ,:S-CUSTOMER-NO                                                    
MFA-TR*      ,:S-EMAIL-TO-ADDR                                                  
MFA-TR*      ,:S-EMAIL-CC-ADDR                                                  
MFA-TR*      ,:S-DISP-PREF-CD                                                   
MFA-TR*      ,:S-EMAIL-EVENT-CD                                                 
MFA-TR*      ,:S-CUST-NAME                                                      
MFA-TR*      ,:S-USER-ID                                                        
MFA-TR*      ,:S-EMAIL-IMAGE-FL                                                 
MFA-TR*      ,:S-BATCH-EMAIL-ID                                                 
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              ADD +1                        TO  CTR-ROWS-R1             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSR04920_R1'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                 34110000
       8001-EXIT.                                                       
           EXIT.                                                        
      *                                                                 34110000
      ******************************************************************        
      * 8002A-DEL-GTT-R2.                                              *        
      ******************************************************************        
      *                                                                 11630000
       8002A-DEL-GTT-R2.                                                
      *                                                                 11630000
           MOVE '8002A'                     TO ACTIVE-PARAGRAPH         
      *                                                                 11630000
           EXEC SQL                                                     
               DELETE FROM #CSR04920_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04920_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11630000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 11630000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE ZEROES                   TO WS-ACTIVE-RETURN-CODE    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE WS-ACTIVE-RETURN-CODE    TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'DELETE'                 TO ABEND-FUNCTION           
              MOVE 'CSR04920_R2'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                 11630000
       8002A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8002-INSERT-GTT-R2.                                            *        
      ******************************************************************        
      *                                                                         
       8002-INSERT-GTT-R2.                                              
      *                                                                         
           MOVE '8002'                      TO ACTIVE-PARAGRAPH         
      *                                                                 11630000
           EXEC SQL                                                     
             INSERT INTO #CSR04920_R2                            
             (                                                          
               RETURN_CODE                                              
              ,BATCH_EMAIL_ID                                           
              ,SERIAL_NO                                                
              ,FIELD_VALUE_TX                                           
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE-2                                          
             ,:S-BATCH-EMAIL-ID                                         
             ,:S-SERIAL-NO                                              
             ,:S-FIELD-VALUE-TX                                         
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04920_R2                                    
MFA-TR*      (                                                                  
MFA-TR*        RETURN_CODE                                                      
MFA-TR*       ,BATCH_EMAIL_ID                                                   
MFA-TR*       ,SERIAL_NO                                                        
MFA-TR*       ,FIELD_VALUE_TX                                                   
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE-2                                                  
MFA-TR*      ,:S-BATCH-EMAIL-ID                                                 
MFA-TR*      ,:S-SERIAL-NO                                                      
MFA-TR*      ,:S-FIELD-VALUE-TX                                                 
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              ADD +1                        TO  CTR-ROWS-R2             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSR04920_R2'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                 34110000
       8002-EXIT.                                                       
           EXIT.                                                        
      *                                                                 34110000
      ******************************************************************        
      * 8003A-DEL-GTT-R3.                                              *        
      ******************************************************************        
      *                                                                 11630000
       8003A-DEL-GTT-R3.                                                
      *                                                                 11630000
           MOVE '8003A'                     TO ACTIVE-PARAGRAPH         
      *                                                                 11630000
           EXEC SQL                                                     
               DELETE FROM #CSR04920_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04920_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11630000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 11630000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE ZEROES                   TO WS-ACTIVE-RETURN-CODE    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE WS-ACTIVE-RETURN-CODE    TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'DELETE'                 TO ABEND-FUNCTION           
              MOVE 'CSR04920_R3'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                 11630000
       8003A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8003-INSERT-GTT-R3.                                            *        
      ******************************************************************        
      *                                                                         
       8003-INSERT-GTT-R3.                                              
      *                                                                         
           MOVE '8003'                      TO ACTIVE-PARAGRAPH         
      *                                                                 11630000
           EXEC SQL                                                     
             INSERT INTO #CSR04920_R3                            
             (                                                          
               RETURN_CODE                                              
              ,BATCH_EMAIL_ID                                           
              ,VENDOR_RESP_TX                                           
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE-3                                          
             ,:S-BATCH-EMAIL-ID-3                                       
             ,:S-VENDOR-RESP-TX                                         
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04920_R3                                    
MFA-TR*      (                                                                  
MFA-TR*        RETURN_CODE                                                      
MFA-TR*       ,BATCH_EMAIL_ID                                                   
MFA-TR*       ,VENDOR_RESP_TX                                                   
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE-3                                                  
MFA-TR*      ,:S-BATCH-EMAIL-ID-3                                               
MFA-TR*      ,:S-VENDOR-RESP-TX                                                 
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              ADD +1                        TO  CTR-ROWS-R2             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSR04920_R3'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                 34110000
       8003-EXIT.                                                       
           EXIT.                                                        
      *                                                                 34110000
      ******************************************************************34120000
      * 8800-CHECK-RESULTS.                                            *34130000
      ******************************************************************34140000
      *                                                                 34150000
       8800-CHECK-RESULTS.                                              
      *                                                                 34170000
           IF CTR-ROWS-R1  = 0                                          
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE 100                       TO S-RETURN-CODE           
              PERFORM 8001-INSERT-GTT-R1     THRU 8001-EXIT             
           END-IF.                                                      
      *                                                                 34230000
           IF CTR-ROWS-R2  = 0                                          
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE 100                       TO S-RETURN-CODE-2         
              PERFORM 8002-INSERT-GTT-R2     THRU 8002-EXIT             
           END-IF.                                                      
      *                                                                 36650000
           IF CTR-ROWS-R3  = 0                                          
              INITIALIZE GTT-RETURN-FIELDS-3                            
              MOVE 100                       TO S-RETURN-CODE-3         
              PERFORM 8003-INSERT-GTT-R3     THRU 8003-EXIT             
           END-IF.                                                      
      *                                                                 36650000
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 36680000
      ******************************************************************        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
      *                                                                 36680000
       8900-SEND-DONE.                                                  
      *                                                                 36680000
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 34660000
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 34660000
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                 34660000
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE            
                                               S-RETURN-CODE-2          
                                               S-RETURN-CODE-3          
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
      *                                                                         
           PERFORM 8001A-DEL-GTT-R1         THRU 8001A-EXIT             
           PERFORM 8001-INSERT-GTT-R1       THRU 8001-EXIT.             
      *                                                                         
           PERFORM 8002A-DEL-GTT-R2         THRU 8002A-EXIT             
           PERFORM 8002-INSERT-GTT-R2       THRU 8002-EXIT.             
      *                                                                         
           PERFORM 8003A-DEL-GTT-R3         THRU 8003A-EXIT             
           PERFORM 8003-INSERT-GTT-R3       THRU 8003-EXIT.             
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
      *                                                                         
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
      *                                                                         
       9700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
      *                                                                         
           PERFORM 8800-CHECK-RESULTS    THRU 8800-EXIT.                
      *                                                                         
           IF CTR-ROWS-R1 < 1 AND CTR-ROWS-R2 < 1 AND CTR-ROWS-R3 < 1   
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '9999-END-PROGRAM'    TO ABEND-FUNCTION              
              MOVE 'PROGRAMMER LOGIC'    TO TABLE-1                     
              MOVE 'FAILED TO SEND'      TO TABLE-ELEMENT-1             
              MOVE 'RESULT SET'          TO HOSTVAR-ELEMENT-1           
              MOVE -1                    TO WS-ACTIVE-RETURN-CODE       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           ELSE                                                         
              PERFORM 8900-SEND-DONE     THRU 8900-EXIT                 
           END-IF.                                                      
      *                                                                 36950000
           
MSQ016        GOBACK.                                                    
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
