                                                                        
       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR04919.                                            
       DATE-WRITTEN. 11/17/16.                                          
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A COBOL STORED PROCEDURE CALLED FROM CRYSTAL  *        
      *  REPORTS                                                       *        
      *                                                                *        
      *  THIS PROGRAM SELECTS FORCED OFF ACCOUNTS FOR IVR CALLS        *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  11/16/16  SC41135    INITIAL VERSION                          *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04919'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(45) VALUE   
           'WORKING STORAGE FOR SP CSR04919 STARTS HERE'.               
                                                                        
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCSTPHN                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK                                    *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  MESSAGE-FIELDS.                                              
            05  MSG-TYPE                     PIC S9(9) COMP.            
            05  MSG-SEVERITY                 PIC S9(9) COMP VALUE 11.   
            05  MSG-NR                       PIC S9(9) COMP VALUE  2.   
            05  MSG-RPC                      PIC X(4)  VALUE 'S200'.    
            05  MSG-RPC                      PIC X(8)  VALUE 'CSR04919'.
            05  MSG-RPC-L                    PIC S9(9) COMP.            
            05  MSG-TEXT                     PIC X(100).                
            05  MSG-TEXT-L                   PIC S9(9) COMP.            
            05  MSG-SQL-ERROR.                                          
                10  FILLER                   PIC X(10)                  
                                             VALUE 'SQLCODE = '.        
                10  MSG-SQL-ERROR-C          PIC -9(3) DISPLAY.         
                10  FILLER                   PIC X(16)                  
                                             VALUE ', ERROR TOKENS: '.  
                10  MSG-SQL-ERROR-K          PIC X(70).                 
                10  MSG-SQL-ERROR-K-CHARS                               
                                             REDEFINES MSG-SQL-ERROR-K  
                                             OCCURS 70 TIMES            
                                             PIC X.                     
            05  MSG-SQL-ERROR-SS             PIC S9(4) COMP.            
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  RS-ACCOUNT-NO            PIC X(13) VALUE SPACES.         
           05  RS-PHONE-NO              PIC X(10) VALUE SPACES.         
           05  RS-CUSTOMER-NO           PIC X(10) VALUE SPACES.         
           05  RS-DATE-RECVED           PIC X(26) VALUE SPACES.         
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26) VALUE                 
                                        'SESSION.CSR04919_R1'.          
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-ACCOUNT-NO           PIC X(13) VALUE SPACES.           
           05  S-PHONE-NO             PIC X(10) VALUE SPACES.           
           05  S-CUSTOMER-NO          PIC X(10) VALUE SPACES.           
           05  S-DATE-RECVED          PIC X(26) VALUE SPACES.           
                                                                        
       01  SWITCHES.                                                    
            05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.            
                88 SEND-DONE-ERROR                VALUE 'N'.            
                88 SEND-DONE-OK                   VALUE 'Y'.            
       01  WS-CURRENT-TIMESTMP         PIC X(26) VALUE SPACES.          
       01  WS-PRV-RUN-TIME             PIC X(26) VALUE SPACES.          
       01  WS-NULL-IND                   PIC S9(4) COMP VALUE 0.        
       01  WS-SQLSTATE                  PIC X(05) VALUE SPACES.         
       01  CTR-ROWS                     PIC S9(9) COMP VALUE 0.         
       01  WS-NO-MORE-ROWS              PIC X(01) VALUE 'N'.            
          88 NO-MORE-ROWS               VALUE 'Y'.                      
       01  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04919'.     
                                                                        
                                                                        
           EXEC SQL                                                     
               DECLARE ORDER_CURSOR CURSOR FOR                          
                   SELECT VO.ACCOUNT_NO_PRIOR,                          
                          REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.DATE_RECVED, 121), ' ', '-'), ':', '.') DATE_RECVED,             
                          CU.CUSTOMER_NO                                
                      FROM CSS_SO_DATA VO WITH(READUNCOMMITTED),                
                          CSS_ACCOUNT AT WITH(READUNCOMMITTED),                 
                          CSS_CUSTOMER CU WITH(READUNCOMMITTED),                
                          CSS_PREMISE PR WITH(READUNCOMMITTED),                 
                          CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)           
                     WHERE ORDER_REASON         = 'F'                   
                       AND ORDER_STATE_CD       <> 'C'                  
                       AND DATE_RECVED          > CIS.CHAR2TIMESTAMP(
                                                       :WS-PRV-RUN-TIME
              )      
                       AND ACCOUNT_NO_PRIOR     = AT.ACCOUNT_NO         
                       AND AT.COMPANY_NO        = '01'                  
                       AND AT.CUSTOMER_NO       = CU.CUSTOMER_NO        
                       AND AT.PREMISE_NO        = PR.PREMISE_NO         
                       AND PR.ADDRESS_ID        = DY.ADDRESS_ID         
                       AND DY.STREET_LOCATION_1 <> 'APT'                
                      FOR READ ONLY                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE ORDER_CURSOR CURSOR FOR                                  
MFA-TR*            SELECT VO.ACCOUNT_NO_PRIOR,                                  
MFA-TR*                   VO.DATE_RECVED,                                       
MFA-TR*                   CU.CUSTOMER_NO                                        
MFA-TR*               FROM CSS_SO_DATA VO,                                      
MFA-TR*                   CSS_ACCOUNT AT,                                       
MFA-TR*                   CSS_CUSTOMER CU,                                      
MFA-TR*                   CSS_PREMISE PR,                                       
MFA-TR*                   CSS_ADDR_FORMATTED DY                                 
MFA-TR*              WHERE ORDER_REASON         = 'F'                           
MFA-TR*                AND ORDER_STATE_CD       <> 'C'                          
MFA-TR*                AND DATE_RECVED          > :WS-PRV-RUN-TIME              
MFA-TR*                AND ACCOUNT_NO_PRIOR     = AT.ACCOUNT_NO                 
MFA-TR*                AND AT.COMPANY_NO        = '01'                          
MFA-TR*                AND AT.CUSTOMER_NO       = CU.CUSTOMER_NO                
MFA-TR*                AND AT.PREMISE_NO        = PR.PREMISE_NO                 
MFA-TR*                AND PR.ADDRESS_ID        = DY.ADDRESS_ID                 
MFA-TR*                AND DY.STREET_LOCATION_1 <> 'APT'                        
MFA-TR*               FOR FETCH ONLY                                            
MFA-TR*               WITH UR                                                   
MFA-TR*               QUERYNO 7310                                              
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
            PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                 
            PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                 
            PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                 
            IF CTR-ROWS < 1                                             
               INITIALIZE GTT-RETURN-FIELDS                             
               MOVE  100 TO RS-RETURN-CODE                              
               PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                
               PERFORM 8100-SEND-RESULT THRU 8100-EXIT                  
            END-IF.                                                     
            PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                 
                                                                        
       0000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
            PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT.                  
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
                 SELECT  RETURN_CODE                                    
                        ,ACCOUNT_NO                                     
                        ,PHONE_NO                                       
                        ,DATE_RECVED                                    
                        ,CUSTOMER_NO                                    
                 FROM #CSR04919_R1                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*          SELECT  RETURN_CODE                                            
MFA-TR*                 ,ACCOUNT_NO                                             
MFA-TR*                 ,PHONE_NO                                               
MFA-TR*                 ,DATE_RECVED                                            
MFA-TR*                 ,CUSTOMER_NO                                            
MFA-TR*          FROM SESSION.CSR04919_R1                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *0100A-DECLARE-GTT************************************************        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04919_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04919_R1
              (                                                       
                   RETURN_CODE           INT                        
                  ,ACCOUNT_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,PHONE_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
                  ,DATE_RECVED CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,CUSTOMER_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

     *                                                                  
             MOVE SQLSTATE              TO WS-SQLSTATE.                 
             MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.       
     *                                                                  
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
               NEXT SENTENCE                                            
             ELSE                                                       
               MOVE PROGRAM-NAME      TO ABEND-PROGRAM                  
               MOVE SQLCODE           TO ABEND-SQLCODE                  
               MOVE SQLSTATE           TO ABEND-SQLSTATE                
               MOVE '0100A'            TO ACTIVE-PARAGRAPH              
               MOVE 'DECLARE GTT'      TO ABEND-FUNCTION                
               MOVE SPACES             TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
               MOVE 'CSR04919_R1'      TO TABLE-1                       
               MOVE SPACES             TO TABLE-ELEMENT-1               
               MOVE SPACES             TO HOSTVAR-ELEMENT-1             
               PERFORM 9900-SQL-ERROR-ROUTINE                           
                                       THRU  9900-EXIT                  
           END-IF
           END-IF.                                                      
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
    ********************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
             PERFORM 7100-GET-RUN-TIME        THRU 7100-EXIT.           
                                                                        
       1000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
             PERFORM 5000-GET-ORDERS            THRU 5000-EXIT.         
             PERFORM 5010-UPDATE-JOB-PARM       THRU 5010-EXIT.         
                                                                        
       2000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 5000-GET-ORDERS.                                               *        
      ******************************************************************        
       5000-GET-ORDERS.                                                 
                                                                        
            PERFORM 7300-OPEN-ORDER-CURSOR      THRU 7300-EXIT.         
            PERFORM 7310-FETCH-ORDER-CURSOR     THRU 7310-EXIT.         
            PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND         
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
               MOVE CU-CUSTOMER-NO  TO  CB-CUSTOMER-NO                  
               MOVE SPACES          TO  CB-PHONE-NO                     
               MOVE SPACES          TO  CB-PHONE-TYPE                   
               PERFORM 5500-GET-PHONE-NO        THRU 5500-EXIT          
                IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL          
                  MOVE VO-ACCOUNT-NO-PRIOR   TO RS-ACCOUNT-NO           
                  MOVE VO-DATE-RECVED        TO RS-DATE-RECVED          
                  MOVE CB-PHONE-NO           TO RS-PHONE-NO             
                  MOVE CB-CUSTOMER-NO        TO RS-CUSTOMER-NO          
                END-IF                                                  
             END-IF                                                     
               MOVE 0 TO RS-RETURN-CODE                                 
               PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT       
               PERFORM  8100-SEND-RESULT          THRU 8100-EXIT        
               PERFORM 7310-FETCH-ORDER-CURSOR    THRU 7310-EXIT        
            END-PERFORM                                                 
                                                                        
              PERFORM 7320-CLOSE-ORDER-CURSOR THRU 7320-EXIT.           
                                                                        
       5000-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
      ******************************************************************        
      * 5500-GET-PHONE-NO.                                             *        
      ******************************************************************        
       5500-GET-PHONE-NO.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) PHONE_NO,
              PHONE_TYPE                                        
                 INTO :CB-PHONE-NO                                      
                     ,:CB-PHONE-TYPE                                    
                FROM CSS_CUST_PHONE WITH(READUNCOMMITTED)                       
                  WHERE CUSTOMER_NO = :CB-CUSTOMER-NO                   
                  ORDER BY                                              
                  CASE PHONE_TYPE                                       
                    WHEN 'H1' THEN 1                                    
                    WHEN 'A1' THEN 2                                    
                    WHEN 'W1' THEN 3                                    
                   ELSE 4                                               
                  END                                                   
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PHONE_NO                                                  
MFA-TR*              ,PHONE_TYPE                                                
MFA-TR*          INTO :CB-PHONE-NO                                              
MFA-TR*              ,:CB-PHONE-TYPE                                            
MFA-TR*         FROM CSS_CUST_PHONE                                             
MFA-TR*           WHERE CUSTOMER_NO = :CB-CUSTOMER-NO                           
MFA-TR*           ORDER BY                                                      
MFA-TR*           CASE PHONE_TYPE                                               
MFA-TR*             WHEN 'H1' THEN 1                                            
MFA-TR*             WHEN 'A1' THEN 2                                            
MFA-TR*             WHEN 'W1' THEN 3                                            
MFA-TR*            ELSE 4                                                       
MFA-TR*           END                                                           
MFA-TR*            FETCH FIRST 1 ROW ONLY                                       
MFA-TR*            WITH UR                                                      
MFA-TR*            QUERYNO 5500                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                    
                                                                        
              EVALUATE WS-ACTIVE-RETURN-CODE                            
                  WHEN SUCCESSFUL-CALL                                  
                  WHEN NOT-FOUND                                        
                      GO TO 5500-EXIT                                   
                  WHEN OTHER                                            
                      MOVE PROGRAM-NAME         TO ABEND-PROGRAM        
                      MOVE '5500'               TO ACTIVE-PARAGRAPH     
                      MOVE 'SELECT'             TO ABEND-FUNCTION       
                      MOVE SPACES               TO ABEND-SQL-PREDICATES 
                                                  ABEND-TABLES          
                   MOVE 'CSS_CUST_PHONE'         TO TABLE-1             
                   MOVE 'CUSTOMER_NO'            TO TABLE-ELEMENT-1     
                   MOVE CB-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1   
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       5500-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
       7300-OPEN-ORDER-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               OPEN ORDER_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7300'                  TO ACTIVE-PARAGRAPH         
               MOVE 'OPEN'                  TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_SO_DATA'           TO TABLE-1                  
               MOVE 'CSS_ACCOUNT'           TO TABLE-2                  
               MOVE 'ACCOUNT_NO_PRIOR'      TO TABLE-ELEMENT-1          
               MOVE VO-ACCOUNT-NO-PRIOR     TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7310-FETCH-ORDER-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               FETCH ORDER_CURSOR                                       
               INTO :VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-DATE-RECVED :WS-NULL-IND                         
                   ,:CU-CUSTOMER-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
                IF WS-NULL-IND   < 0                                    
                   MOVE SPACES TO VO-DATE-RECVED                        
                END-IF                                                  
             WHEN NOT-FOUND                                             
                   GO TO 7310-EXIT                                      
             WHEN OTHER                                                 
                   MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
                   MOVE '7310'                   TO ACTIVE-PARAGRAPH    
                   MOVE 'FETCH'                  TO ABEND-FUNCTION      
                   MOVE SPACES                   TO ABEND-SQL-PREDICATES
                                                   ABEND-TABLES         
                   MOVE 'CSS_SO_DATA'            TO TABLE-1             
                   MOVE 'ACCOUNT_NO_PRIOR'       TO TABLE-ELEMENT-1     
                   MOVE VO-ACCOUNT-NO-PRIOR      TO HOSTVAR-ELEMENT-1   
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7310-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
       7320-CLOSE-ORDER-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE ORDER_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7320'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CLOSE'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_SO_DATA'           TO TABLE-1                  
               MOVE 'CSS_ACCOUNT'           TO TABLE-2                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE VO-ACCOUNT-NO-PRIOR     TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7100-GET-RUN-TIME.                                             *        
      ******************************************************************        
       7100-GET-RUN-TIME.                                               
                                                                        
            EXEC SQL                                                    
                 SELECT PARM_DATA                                       
                    INTO :G6-PARM-DATA                                  
                  FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                       
                 WHERE PROGRAM_NAME = 'CSR04919'                        
                     AND COMPANY_NO = '01'                              
                     AND CMND_CODE = 'DATE'                             
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*          SELECT PARM_DATA                                               
MFA-TR*             INTO :G6-PARM-DATA                                          
MFA-TR*           FROM CSS_JOB_PARM                                             
MFA-TR*          WHERE PROGRAM_NAME = 'CSR04919'                                
MFA-TR*              AND COMPANY_NO = '01'                                      
MFA-TR*              AND CMND_CODE = 'DATE'                                     
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7100                                                   
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                MOVE G6-PARM-DATA TO WS-PRV-RUN-TIME                    
             ELSE                                                       
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_JOB_PARM'        TO TABLE-1                     
              MOVE 'PROGRAM_NAME'        TO TABLE-ELEMENT-1             
              MOVE 'CSR04919'            TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 5010-UPDATE-JOB-PARM.                                          *        
      ******************************************************************        
       5010-UPDATE-JOB-PARM.                                            
                                                                        
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTMP           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTMP  = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            EXEC SQL                                                    
                 UPDATE CSS_JOB_PARM                                    
                    SET PARM_DATA = :WS-CURRENT-TIMESTMP                
                 WHERE PROGRAM_NAME = 'CSR04919'                        
                     AND COMPANY_NO = '01'                              
                     AND CMND_CODE = 'DATE'                             
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '5010'                TO ACTIVE-PARAGRAPH           
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE 'CSS_JOB_PARM'        TO TABLE-1                    
               MOVE 'PROGRAM_NAME'        TO TABLE-ELEMENT-1            
               MOVE  'CSR04919'           TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5010-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *2000A-MOVE-RESULT.                                              *        
      *****************************************************************         
       2000A-MOVE-RESULT.                                               
           MOVE RS-RETURN-CODE              TO S-RETURN-CODE.           
           MOVE RS-ACCOUNT-NO               TO S-ACCOUNT-NO.            
           MOVE RS-PHONE-NO                 TO S-PHONE-NO.              
           MOVE RS-CUSTOMER-NO              TO S-CUSTOMER-NO.           
           MOVE RS-DATE-RECVED              TO S-DATE-RECVED.           
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
                                                                        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04919_R1                            
             (                                                          
              RETURN_CODE,                                              
              ACCOUNT_NO,                                               
              PHONE_NO,                                                 
              DATE_RECVED,                                              
              CUSTOMER_NO                                               
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE,                                          
               :S-ACCOUNT-NO,                                           
               :S-PHONE-NO,                                             
               :S-DATE-RECVED,                                          
               :S-CUSTOMER-NO                                           
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04919_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       ACCOUNT_NO,                                                       
MFA-TR*       PHONE_NO,                                                         
MFA-TR*       DATE_RECVED,                                                      
MFA-TR*       CUSTOMER_NO                                                       
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE,                                                  
MFA-TR*        :S-ACCOUNT-NO,                                                   
MFA-TR*        :S-PHONE-NO,                                                     
MFA-TR*        :S-DATE-RECVED,                                                  
MFA-TR*        :S-CUSTOMER-NO                                                   
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04919_R1'        TO TABLE-1                      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      **8000A-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04919_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04919_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8000A'              TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
               MOVE 'CSR04919_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
                                                                        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
      *    COPY CPD00302.                                                       
           EXEC SQL                                                             
              INCLUDE CPD00320                                                  
           END-EXEC.                                                            
                                                                        
