       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR04918.                                            
       DATE-WRITTEN. SEP 22, 2016.                                      
       AUTHOR. VIDHU VALSARAJAN.                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *    THIS PROGRAM RETRIEVES IF METER QUALIFIES FOR SAMPLE TEST   *        
      *                                                                *        
      ******************************************************************        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P01176*  11/12/07  VV90387    INITIAL CODE.                            *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04918'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04918 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    SQL COMMUNICATION AREA                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_SO_ORDER_INST  (PREFIX = VI)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBSOODR                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_SO_DATA        (PREFIX = VO)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SQL COMMUNICATION AREA                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CLS00076                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
           COPY CCA00001.                                                       
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04918'.      
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
           05  WS-RCVPRM               PIC X(20)      VALUE SPACES.     
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MISCELLANEOUS.                                            
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-SERV-ORDER-NO        PIC X(13) VALUE SPACES.          
           05  WS-SERV-ORDER-NO-NUM    REDEFINES WS-SERV-ORDER-NO       
                                       PIC 9(13).                       
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-SAMPLE-TEST-FL       PIC X(01)      VALUE SPACES.      
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW            PIC X(01)      VALUE 'N'.         
               88 NOT-ALL-DONE                       VALUE 'N'.         
               88 ALL-DONE                           VALUE 'Y'.         
           05  SEND-DONE-SW           PIC X(01)      VALUE 'Y'.         
               88 SEND-DONE-ERROR                    VALUE 'N'.         
               88 SEND-DONE-OK                       VALUE 'Y'.         
                                                                        
       01  DYNAMIC-CALLS.                                               
           05  MCSCB076               PIC X(08) VALUE 'MCSCB076'.       
                                                                        
HPCCDM*EJECT                                                                    
                                                                        
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18)       VALUE SPACES.  
           10  S-SQLCODE                 PIC S9(9) COMP  VALUE 0.       
           10  S-SQLSTATE                PIC X(5)        VALUE ' '.     
           10  S-TABLE-NAME              PIC X(18)       VALUE SPACES.  
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-RETURN-CODE            PIC S9(9) COMP  VALUE 0.       
           10  WS-SQLSTATE               PIC X(05)       VALUE SPACES.  
                                                                        
                                                                        
      *****************************************************************         
      * CURSOR FOR FETCHING ALL ORDER_INSTR ROWS WITH MCU/MCB/RMT     *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE SAMPLE-TEST-CURSOR CURSOR FOR                     
               SELECT VI.SERV_ORDER_NO,                                 
                      VI.SO_INST_SEQ_NO,                                
                      VI.CODE_UTIL_TYPE,                                
                      VI.METER_NO,                                      
                      VO.COMPANY_NO                                     
                 FROM CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED),               
                      CSS_SO_DATA VO WITH(READUNCOMMITTED)                      
                WHERE VI.SERV_ORDER_NO  = VO.SERV_ORDER_NO              
                  AND VI.SERV_ORDER_NO  = :VI-SERV-ORDER-NO             
                  AND VI.WORK_TYPE_CD   IN ('MCU','MCB','RMT')          
                  AND VI.SAMPLE_TEST_FL = 'Y'                           
                ORDER BY SO_INST_SEQ_NO                                 
                FOR READ ONLY                                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE SAMPLE-TEST-CURSOR CURSOR FOR                             
MFA-TR*        SELECT VI.SERV_ORDER_NO,                                         
MFA-TR*               VI.SO_INST_SEQ_NO,                                        
MFA-TR*               VI.CODE_UTIL_TYPE,                                        
MFA-TR*               VI.METER_NO,                                              
MFA-TR*               VO.COMPANY_NO                                             
MFA-TR*          FROM CSS_SO_ORDER_INST VI,                                     
MFA-TR*               CSS_SO_DATA VO                                            
MFA-TR*         WHERE VI.SERV_ORDER_NO  = VO.SERV_ORDER_NO                      
MFA-TR*           AND VI.SERV_ORDER_NO  = :VI-SERV-ORDER-NO                     
MFA-TR*           AND VI.WORK_TYPE_CD   IN ('MCU','MCB','RMT')                  
MFA-TR*           AND VI.SAMPLE_TEST_FL = 'Y'                                   
MFA-TR*         ORDER BY SO_INST_SEQ_NO                                         
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*       QUERYNO 7700                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-COMPANY-NO               PIC X(02).                     
       01  LINK-ACCOUNT-NO               PIC X(13).                     
       01  LINK-UTIL-TYPE                PIC X(01).                     
       01  LINK-METER-NO                 PIC X(09).                     
       01  LINK-CALL-TYPE                PIC X(01).                     
       01  LINK-EVENT-TMST               PIC X(26).                     
       01  LINK-SERV-ORDER-NO            PIC X(13).                     
                                                                        
       PROCEDURE DIVISION USING          LINK-COMPANY-NO                
                                        ,LINK-ACCOUNT-NO                
                                        ,LINK-UTIL-TYPE                 
                                        ,LINK-METER-NO                  
                                        ,LINK-CALL-TYPE                 
                                        ,LINK-EVENT-TMST                
                                        ,LINK-SERV-ORDER-NO.            
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM.                     *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     1. DECLARE CURSOR                                          *        
      *     2. RECEIVE INPUT PARAMETRS                                 *        
      *     3. INITIALIZE OUTPUT PARAMETERS                            *        
      *                                                                *        
      *     CALLED BY: 0000-MAINLINE                                   *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
              SELECT :S-RETURN-CODE          AS RETURN_CODE             
                    ,:S-SAMPLE-TEST-FL       AS SAMPLE_TEST_FL          
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*       SELECT :S-RETURN-CODE          AS RETURN_CODE                     
MFA-TR*             ,:S-SAMPLE-TEST-FL       AS SAMPLE_TEST_FL                  
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
           INITIALIZE                           S-RETURN-CODE           
                                                S-SAMPLE-TEST-FL.       
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     RECEIVE PARARMETERS AND MOVE TO NUMERIC FIELDS.            *        
      *                                                                *        
      *     CALLED BY: 0000-MAINLINE                                   *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           MOVE LINK-COMPANY-NO          TO CLS76-COMPANY-NO.           
           MOVE LINK-ACCOUNT-NO          TO CLS76-ACCOUNT-NO.           
           MOVE LINK-UTIL-TYPE           TO CLS76-UTILITY-TYPE.         
           MOVE LINK-METER-NO            TO CLS76-METER-NO.             
           MOVE LINK-CALL-TYPE           TO CLS76-CALL-TYPE.            
           MOVE LINK-EVENT-TMST          TO CLS76-EVENT-TIMESTAMP.      
           MOVE LINK-SERV-ORDER-NO       TO WS-SERV-ORDER-NO.           
           MOVE WS-SERV-ORDER-NO-NUM     TO VI-SERV-ORDER-NO.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *      SET UP PARAMETERS TO BE RETURNED.                         *        
      *                                                                *        
      *      CALLED BY: 0000-MAINLINE                                  *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 7100-OPEN-SAMPLE-TEST-CURSOR        THRU 7100-EXIT.  
           PERFORM 7101-FETCH-SAMPLE-TEST-CURSOR       THRU 7101-EXIT.  
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              MOVE VI-CODE-UTIL-TYPE          TO CLS76-UTILITY-TYPE     
              MOVE VI-METER-NO                TO CLS76-METER-NO         
              MOVE VO-COMPANY-NO              TO CLS76-COMPANY-NO       
              PERFORM 2200-BUILD-RESULT                THRU 2200-EXIT   
              MOVE SPACES                     TO CLS76-UTILITY-TYPE     
                                                 CLS76-METER-NO         
                                                 CLS76-COMPANY-NO       
              PERFORM 7101-FETCH-SAMPLE-TEST-CURSOR    THRU 7101-EXIT   
           END-PERFORM.                                                 
           PERFORM 7102-CLOSE-SAMPLE-TEST-CURSOR       THRU 7102-EXIT.  
           PERFORM 8100-SEND-RESULT                    THRU 8100-EXIT.  
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *     BUILD THE RESULT SET.                                      *        
      *                                                                *        
      *     CALLED BY:  2000-PROCESS-OUTPUT                            *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
           CALL MCSCB076   USING CLS00076-FIELDS,                       
                                 ABEND-FILE.                            
                                                                        
           MOVE CLS76-RETURN-CODE         TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = 0                                 
              MOVE WS-ACTIVE-RETURN-CODE  TO S-RETURN-CODE              
              MOVE CLS76-FLAG-MTR-QUALIFY TO S-SAMPLE-TEST-FL           
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '2200'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CALL'                 TO ABEND-FUNCTION             
              MOVE 'MCSCB076'             TO TABLE-1                    
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * CURSOR DECLARATIONS                                            *        
      ******************************************************************        
       7100-OPEN-SAMPLE-TEST-CURSOR.                                    
                                                                        
           EXEC SQL                                                     
               OPEN SAMPLE-TEST-CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7100'               TO ACTIVE-PARAGRAPH        
                   MOVE 'OPEN'               TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_SO_ORDER_INST'  TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-2       
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7101-FETCH-SAMPLE-TEST-CURSOR.                                   
                                                                        
           EXEC SQL                                                     
               FETCH SAMPLE-TEST-CURSOR                                 
                INTO :VI-SERV-ORDER-NO,                                 
                     :VI-SO-INST-SEQ-NO,                                
                     :VI-CODE-UTIL-TYPE,                                
                     :VI-METER-NO,                                      
                     :VO-COMPANY-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7101'               TO ACTIVE-PARAGRAPH        
                   MOVE 'FETCH'              TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_SO_ORDER_INST'  TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-2       
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7101-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7102-CLOSE-SAMPLE-TEST-CURSOR.                                   
                                                                        
           EXEC SQL                                                     
               CLOSE SAMPLE-TEST-CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7102'              TO ACTIVE-PARAGRAPH         
                   MOVE 'CLOSE'             TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VI-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-2        
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7102-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
                                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     00000100
               INCLUDE CPD00321                                         00000200
           END-EXEC.                                                    00000300
