       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04916.                                      
COB303 DATE-WRITTEN.     AUG 24, 2016.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES THE USER CATEGORY AND RESPONSIBLE AREA *        
      *  RELATIONSHIP BASED ON THE RESP AREA ID.                       *        
      *                                                                *        
      *  RESULT 1: CONTAIN ALL USER DETAIL WHICH FALLS UNDER SELECTED  *        
      *            RESP AREA ID.                                       *        
      *  RESULT 2: THIS WILL HAVE ASSIGNED OR UN-ASSIGNED CATEGORY     *        
      *            DETAILS FOR THE USERS.                              *        
      *  RESULT 3: ASSIGED OR UN-ASSIGNED CATEGORY DETAILS FOR THE     *        
      *            SELECTED RESP AREA ID.                              *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00899*  08/24/16  MR7E794    NEW PROGRAM.                             *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      *  PARAMETERS:                                                            
      *                                                                         
      *  INPUT PARAMETERS.                                                      
      *           I_RESP_AREA_ID               CHAR(03)                         
      *                                                                         
      *  RESULT SET 1.                                                          
      *           RETURN_CODE                  INTEGER                          
      *           USER_ID                      CHAR(07)                         
      *           WQ_REASSIGN_IND              CHAR(01)                         
      *           WQ_RECIPIENT_IND             CHAR(01)                         
      *                                                                         
      *  RESULT SET 2.                                                          
      *           RETURN_CODE                  INTEGER                          
      *           USER_ID                      CHAR(07)                         
      *           RESP_AREA_ID                 CHAR(03)                         
      *           CATEGORY_ID                  SMALLINT                         
      *           CATEGORY_NAME                CHAR(55)                         
      *           WQ_RETENTION_DAYS            SMALLINT                         
      *           WORK_ASSIGNED_FLAG           CHAR(01)                         
      *                                                                         
      *  RESULT SET 3.                                                          
      *           RETURN_CODE                  INTEGER                          
      *           CATEGORY_ID                  SMALLINT                         
      *           CATEGORY_NAME                CHAR(55)                         
      *           WQ_RETENTION_DAYS            SMALLINT                         
      *           WORK_ASSIGNED_FLAG           CHAR(01)                         
      *           COMPANY_NO                   CHAR(02)                         
      *           USER_ASSIGNED_FL             CHAR(01)                         
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04916'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04916 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *--------< CSS_USER_PROFILE       PF                                      
           EXEC SQL                                                             
              INCLUDE  TBUSRPRF                                                 
           END-EXEC.                                                            
                                                                        
      *--------< CSS_WQ_CATEGORY        C3                                      
           EXEC SQL                                                             
              INCLUDE TBWQCAT                                                   
           END-EXEC.                                                            
                                                                        
      *--------< SS_DELINQUENCY         C8                                      
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *--------<COMMON SYSTEM AREA >                                            
           COPY CCA00001.                                                       
      *--------< ERROR HANDLING >                                               
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >               
           COPY CWS00027.                                                       
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
                                                                        
      * WORKING STORAGE FOR CPD0309A                                            
      *    EXEC SQL                                                             
      *       INCLUDE CWS00309                                                  
      *    END-EXEC.                                                            
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
      *                                                                         
       01  WS-GTT-MISC-FIELDS.                                          
           05  WS-GTT-NAME              PIC X(19)  VALUE SPACES.        
                                                                        
       01  GTT-RETURN-FIELDS-1.                                         
           05  S-RETURN-CODE-1           PIC S9(04)  COMP VALUE 0.      
           05  S-USER-ID-1               PIC X(7)    VALUE SPACES.      
           05  S-WQ-REASSIGN-IND-1       PIC X(1)    VALUE SPACES.      
           05  S-WQ-RECIPIENT-IND-1      PIC X(1)    VALUE SPACES.      
      *                                                                         
       01  GTT-RETURN-FIELDS-2.                                         
           05  S-RETURN-CODE-2           PIC S9(04)    COMP VALUE 0.    
           05  S-USER-ID-2               PIC X(7)    VALUE SPACES.      
           05  S-RESP-AREA-ID-2          PIC X(03)   VALUE SPACES.      
           05  S-CATEGORY-ID-2           PIC S9(4)   COMP VALUE 0.      
           05  S-CATEGORY-NAME-2         PIC X(55)   VALUE SPACES.      
           05  S-WQ-RETENTION-DAYS-2     PIC S9(4)   COMP VALUE 0.      
           05  S-WQ-ASSIGNED-FLAG-2      PIC X(01)   VALUE SPACES.      
      *                                                                         
       01  GTT-RETURN-FIELDS-3.                                         
           05  S-RETURN-CODE-3           PIC S9(04)    COMP VALUE 0.    
           05  S-CATEGORY-ID-3           PIC S9(4)   COMP VALUE 0.      
           05  S-CATEGORY-NAME-3         PIC X(55)   VALUE SPACES.      
           05  S-WQ-RETENTION-DAYS-3     PIC S9(4)   COMP VALUE 0.      
           05  S-WQ-ASSIGNED-FLAG-3      PIC X(01)   VALUE SPACES.      
           05  S-COMPANY-NO-3            PIC X(02)   VALUE SPACES.      
           05  S-USER-ASSIGNED-FLAG-3    PIC X(01)   VALUE SPACES.      
      *                                                                         
       01  GENERAL-WORKING-STORAGE.                                     
           05  WS-SQLSTATE               PIC X(05) VALUE '     '.       
           05  WS-RET-CHK-CNT            PIC S9(4) COMP VALUE 0.        
           05  WS-SEND-CODE              PIC X(2)  OCCURS 5.            
           05  WS-PREV-USER-ID           PIC X(07) VALUE SPACES.        
           05  WS-INPUT-RESP-AREA-ID     PIC X(03) VALUE SPACES.        
           05  WS-COMPANY-NO             PIC X(02) VALUE SPACES.        
           05  WS-DISP-CD1               PIC X(01) VALUE SPACES.        
           05  WS-DISP-CD2               PIC X(01) VALUE SPACES.        
           05  WS-CATEGORY-ID            PIC ZZZ9.                      
           05  WS-CATEGORY-NAME-ID       PIC X(55) VALUE SPACES.        
           05  WS-DATABASE               PIC 9(01) VALUE 0.             
               88  CSR-DATABASE                    VALUE 1.             
               88  SEB-DATABASE                    VALUE 2.             
      *                                                                         
       01 WS-COUNTERS.                                                  
          05 CTR-ROWS-1                 PIC S9(9) COMP VALUE 0.         
          05 CTR-ROWS-2                 PIC S9(9) COMP VALUE 0.         
          05 CTR-ROWS-3                 PIC S9(9) COMP VALUE 0.         
                                                                        
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME              PIC X(08) VALUE 'CSR04916'.    
           05  WS-NO                     PIC X(02) VALUE 'NO'.          
           05  WS-B                      PIC X(1)  VALUE 'B'.           
           05  WS-C                      PIC X(1)  VALUE 'C'.           
           05  WS-S                      PIC X(1)  VALUE 'S'.           
                                                                        
       01  WS-SWITCHES.                                                 
           05 SEND-DONE-SW               PIC X(01) VALUE 'Y'.           
              88 SEND-DONE-ERROR                   VALUE 'N'.           
              88 SEND-DONE-OK                      VALUE 'Y'.           
           05 WS-NO-MORE-ROWS            PIC X(01) VALUE 'N'.           
              88 NO-MORE-ROWS                      VALUE 'Y'.           
           05 WS-NO-MORE-ROWS-C3         PIC X(01) VALUE 'N'.           
              88 NO-MORE-ROWS-C3                   VALUE 'Y'.           
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
      *----< CURSOR FOR WQ CATEGORY                                             
           EXEC SQL DECLARE WQ-CATEGORY-CURSOR CURSOR FOR               
              SELECT PF.USER_ID AS WORKER                               
                    ,PF.WQ_REASSIGN_IND                                 
                    ,PF.WQ_RECIPIENT_IND                                
                    ,C3.CATEGORY_NAME                                   
                    ,C3.CATEGORY_ID                                     
                    ,C3.WQ_RETENTION_DAYS                               
              FROM   CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                  
                    ,CSS_WQ_AREA_CAT  AC WITH(READUNCOMMITTED)                  
                    ,CSS_WQ_CATEGORY  C3 WITH(READUNCOMMITTED)                  
              WHERE PF.RESP_AREA_ID  = :PF-RESP-AREA-ID                 
              AND   PF.RESP_AREA_ID  = AC.RESP_AREA_ID                  
              AND   AC.CATEGORY_ID   = C3.CATEGORY_ID                   
              AND   C3.WQ_DISPLAY_CD IN (:WS-DISP-CD1,:WS-DISP-CD2)     
              ORDER BY USER_ID                                          
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE WQ-CATEGORY-CURSOR CURSOR FOR                       
MFA-TR*       SELECT PF.USER_ID AS WORKER                                       
MFA-TR*             ,PF.WQ_REASSIGN_IND                                         
MFA-TR*             ,PF.WQ_RECIPIENT_IND                                        
MFA-TR*             ,C3.CATEGORY_NAME                                           
MFA-TR*             ,C3.CATEGORY_ID                                             
MFA-TR*             ,C3.WQ_RETENTION_DAYS                                       
MFA-TR*       FROM   CSS_USER_PROFILE PF                                        
MFA-TR*             ,CSS_WQ_AREA_CAT  AC                                        
MFA-TR*             ,CSS_WQ_CATEGORY  C3                                        
MFA-TR*       WHERE PF.RESP_AREA_ID  = :PF-RESP-AREA-ID                         
MFA-TR*       AND   PF.RESP_AREA_ID  = AC.RESP_AREA_ID                          
MFA-TR*       AND   AC.CATEGORY_ID   = C3.CATEGORY_ID                           
MFA-TR*       AND   C3.WQ_DISPLAY_CD IN (:WS-DISP-CD1,:WS-DISP-CD2)             
MFA-TR*       ORDER BY USER_ID                                                  
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *----< CURSOR FOR WQ AREA CATEGORY                                        
      *                                                                         
           EXEC SQL DECLARE WQ-AREA-CAT-CURSOR CURSOR FOR               
              SELECT C3.CATEGORY_ID                                     
                    ,C3.CATEGORY_NAME                                   
                    ,C3.WQ_RETENTION_DAYS                               
              FROM  CSS_WQ_CATEGORY C3 WITH(READUNCOMMITTED)                    
              WHERE C3.WQ_DISPLAY_CD IN (:WS-DISP-CD1,:WS-DISP-CD2)     
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE WQ-AREA-CAT-CURSOR CURSOR FOR                       
MFA-TR*       SELECT C3.CATEGORY_ID                                             
MFA-TR*             ,C3.CATEGORY_NAME                                           
MFA-TR*             ,C3.WQ_RETENTION_DAYS                                       
MFA-TR*       FROM  CSS_WQ_CATEGORY C3                                          
MFA-TR*       WHERE C3.WQ_DISPLAY_CD IN (:WS-DISP-CD1,:WS-DISP-CD2)             
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-RESP-AREA-ID             PIC X(03).                     
                                                                        
       PROCEDURE DIVISION USING  PARM-RESP-AREA-ID.                     
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
           
MSQ016        GOBACK.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           INITIALIZE GENERAL-WORKING-STORAGE.                          
           INITIALIZE CSRERLOG-P.                                       
                                                                        
           PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
           PERFORM 0100B-DECLARE-GTT     THRU 0100B-EXIT.               
           PERFORM 0100C-DECLARE-GTT     THRU 0100C-EXIT.               
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      *  0100A-DECLARE-GTT.  GET USER ID                            *           
      ***************************************************************           
      *                                                                         
       0100A-DECLARE-GTT.                                               
      *                                                                         
           MOVE '0100A'                  TO ACTIVE-PARAGRAPH.           
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04916_R1'            
                                         TO S-SQL-STATEMENT-V.          
           MOVE 'SESSION.CSR04916_R1'    TO WS-GTT-NAME.                
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04916_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04916_R1
              (                                                        
                    RETURN_CODE            INT                      
                   ,USER_ID CHAR(7)  COLLATE LATIN1_GENERAL_100_BIN2            
                   ,WQ_REASSIGN_IND CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                      
                   ,WQ_RECIPIENT_IND CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                      
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
               PERFORM 8000A-DEL-GTT-ROWS      THRU 8000A-EXIT          
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE 'DECLARE GTT'     TO ABEND-FUNCTION             
                   MOVE SPACES            TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                   MOVE WS-GTT-NAME       TO TABLE-1                    
                   MOVE SPACES            TO TABLE-ELEMENT-1            
                   MOVE SPACES            TO HOSTVAR-ELEMENT-1          
                   MOVE WS-ACTIVE-RETURN-CODE TO ABEND-SQLCODE          
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
                                                                        
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                    RETURN_CODE                                         
                   ,LTRIM(RTRIM(USER_ID))               AS WORKER              
                   ,LTRIM(RTRIM(WQ_REASSIGN_IND))       AS REASSIGN            
                   ,LTRIM(RTRIM(WQ_RECIPIENT_IND))      AS AVAILABLE           
               FROM                                                     
                   #CSR04916_R1                                  
                ORDER BY USER_ID ASC                                    
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,STRIP(USER_ID)               AS WORKER                      
MFA-TR*            ,STRIP(WQ_REASSIGN_IND)       AS REASSIGN                    
MFA-TR*            ,STRIP(WQ_RECIPIENT_IND)      AS AVAILABLE                   
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04916_R1                                          
MFA-TR*         ORDER BY USER_ID ASC                                            
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      *  0100B-DECLARE-GTT.  GET WQ CATEGORY DETAILS                *           
      ***************************************************************           
      *                                                                         
       0100B-DECLARE-GTT.                                               
      *                                                                         
           MOVE '0100B'                  TO ACTIVE-PARAGRAPH.           
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04916_R2'            
                                         TO S-SQL-STATEMENT-V.          
           MOVE 'SESSION.CSR04916_R2'    TO WS-GTT-NAME.                
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04916_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04916_R2
              (                                                        
                    RETURN_CODE            INT                      
                   ,USER_ID CHAR(07)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,RESP_AREA_ID CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,CATEGORY_ID            SMALLINT                     
                   ,CATEGORY_NAME CHAR(55)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,WQ_RETENTION_DAYS      SMALLINT                     
                   ,WORK_ASSIGNED_FLAG CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
               PERFORM 8000B-DEL-GTT-ROWS      THRU 8000B-EXIT          
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE 'DECLARE GTT'     TO ABEND-FUNCTION             
                   MOVE SPACES            TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                   MOVE WS-GTT-NAME       TO TABLE-1                    
                   MOVE SPACES            TO TABLE-ELEMENT-1            
                   MOVE SPACES            TO HOSTVAR-ELEMENT-1          
                   MOVE WS-ACTIVE-RETURN-CODE TO ABEND-SQLCODE          
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
                                                                        
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                    RETURN_CODE                                         
                   ,USER_ID                 AS USER_ID                  
                   ,RESP_AREA_ID            AS CAT_RESP_AREA_ID         
                   ,CATEGORY_ID             AS CATEGORY_ID              
                   ,CATEGORY_NAME           AS CATEGORY_NAME            
                   ,WQ_RETENTION_DAYS       AS WQ_RETENTION_DAYS        
                   ,WORK_ASSIGNED_FLAG      AS WORK_ASSIGNED_FLAG       
               FROM                                                     
                   #CSR04916_R2                                  
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,USER_ID                 AS USER_ID                          
MFA-TR*            ,RESP_AREA_ID            AS CAT_RESP_AREA_ID                 
MFA-TR*            ,CATEGORY_ID             AS CATEGORY_ID                      
MFA-TR*            ,CATEGORY_NAME           AS CATEGORY_NAME                    
MFA-TR*            ,WQ_RETENTION_DAYS       AS WQ_RETENTION_DAYS                
MFA-TR*            ,WORK_ASSIGNED_FLAG      AS WORK_ASSIGNED_FLAG               
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04916_R2                                          
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      *  0100C-DECLARE-GTT.  GET WQ AREA CATEGORY DETAILS           *           
      ***************************************************************           
      *                                                                         
       0100C-DECLARE-GTT.                                               
      *                                                                         
           MOVE '0100C'                  TO ACTIVE-PARAGRAPH.           
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04916_R3'            
                                         TO S-SQL-STATEMENT-V.          
           MOVE 'SESSION.CSR04916_R3'    TO WS-GTT-NAME.                
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04916_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04916_R3
              (                                                        
                    RETURN_CODE            INT                      
                   ,CATEGORY_ID            SMALLINT                     
                   ,CATEGORY_NAME CHAR(55)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,WQ_RETENTION_DAYS      SMALLINT                     
                   ,WORK_ASSIGNED_FLAG CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,USER_ASSIGNED_FLAG CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
               PERFORM 8000C-DEL-GTT-ROWS      THRU 8000C-EXIT          
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE 'DECLARE GTT'     TO ABEND-FUNCTION             
                   MOVE SPACES            TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                   MOVE WS-GTT-NAME       TO TABLE-1                    
                   MOVE SPACES            TO TABLE-ELEMENT-1            
                   MOVE SPACES            TO HOSTVAR-ELEMENT-1          
                   MOVE WS-ACTIVE-RETURN-CODE TO ABEND-SQLCODE          
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
                                                                        
               DECLARE C3 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT DISTINCT                                          
                    RETURN_CODE                                         
                   ,CATEGORY_ID             AS CATEGORY_ID              
                   ,CATEGORY_NAME           AS CATEGORY_NAME            
                   ,WQ_RETENTION_DAYS       AS WQ_RETENTION_DAYS        
                   ,WORK_ASSIGNED_FLAG      AS WORK_ASSIGNED_FLAG       
                   ,COMPANY_NO              AS COMPANY_NO               
                   ,USER_ASSIGNED_FLAG      AS USER_ASSIGNED_FLAG       
               FROM                                                     
                   #CSR04916_R3                                  
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT DISTINCT                                                  
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,CATEGORY_ID             AS CATEGORY_ID                      
MFA-TR*            ,CATEGORY_NAME           AS CATEGORY_NAME                    
MFA-TR*            ,WQ_RETENTION_DAYS       AS WQ_RETENTION_DAYS                
MFA-TR*            ,WORK_ASSIGNED_FLAG      AS WORK_ASSIGNED_FLAG               
MFA-TR*            ,COMPANY_NO              AS COMPANY_NO                       
MFA-TR*            ,USER_ASSIGNED_FLAG      AS USER_ASSIGNED_FLAG               
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04916_R3                                          
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100C-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-RESP-AREA-ID     TO PF-RESP-AREA-ID                
                                         WS-INPUT-RESP-AREA-ID.         
                                                                        
           PERFORM 7000-DETERMINE-REGION THRU 7000-EXIT.                
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
           MOVE WS-B            TO WS-DISP-CD1.                         
           IF CSR-DATABASE                                              
               MOVE WS-C        TO WS-DISP-CD2                          
           ELSE                                                         
               MOVE WS-S        TO WS-DISP-CD2                          
           END-IF.                                                      
                                                                        
           PERFORM 7600-SELECT-COMPANY-NO        THRU 7600-EXIT.        
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           INITIALIZE                            GTT-RETURN-FIELDS-1    
                                                 GTT-RETURN-FIELDS-2    
                                                 GTT-RETURN-FIELDS-3.   
                                                                        
      *----< GET WQ CATEGORY CURSOR                                             
           PERFORM 7050-OPEN-WQ-CATEGORY-CURSOR  THRU 7050-EXIT.        
           PERFORM 7100-FETCH-WQ-CATEGORY-CURSOR THRU 7100-EXIT.        
           PERFORM 2200-BUILD-RESULT             THRU 2200-EXIT         
                    UNTIL NO-MORE-ROWS.                                 
           PERFORM 7150-CLOSE-WQ-CATEGORY-CURSOR THRU 7150-EXIT.        
                                                                        
      *----< GET WQ CATEGORY NOTIN WQ_AREA_CAT CURSOR                           
           PERFORM 7200-OPEN-WQ-AREA-CAT-CURSOR  THRU 7200-EXIT.        
           PERFORM 7250-FETCH-WQ-AREA-CAT-CURSOR THRU 7250-EXIT.        
           PERFORM 2500-BUILD-RESULT-3           THRU 2500-EXIT         
                    UNTIL NO-MORE-ROWS-C3.                              
           PERFORM 7300-CLOSE-WQ-AREA-CAT-CURSOR THRU 7300-EXIT.        
                                                                        
      *--------< IF NOTHING HAS BEEN FOUND, THEN SO FAR NOTHING HAS >           
      *--------< BEEN SENT BACK. SEND BACK A SUCCESSFUL MESSAGE     >           
           IF CTR-ROWS-1 = 0 AND CTR-ROWS-2 = 0 AND CTR-ROWS-3 = 0      
                 MOVE ZERO                TO S-RETURN-CODE-1            
                                             S-RETURN-CODE-2            
                                             S-RETURN-CODE-3            
                 PERFORM 8100-SEND-RESULT-R1 THRU 8100-EXIT             
                 PERFORM 8200-SEND-RESULT-R2 THRU 8200-EXIT             
                 PERFORM 8300-SEND-RESULT-R3 THRU 8300-EXIT             
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
             PERFORM 2300-PROCESS-WQ-CATEGORY      THRU 2300-EXIT.      
             PERFORM 2400-PROCESS-WQ-ASSIGN-DET    THRU 2400-EXIT.      
                                                                        
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2300-PROCESS-WQ-CATEGORY.                                      *        
      ******************************************************************        
       2300-PROCESS-WQ-CATEGORY.                                        
                                                                        
             IF PF-USER-ID NOT EQUAL WS-PREV-USER-ID                    
                MOVE PF-USER-ID          TO S-USER-ID-1                 
                MOVE PF-USER-ID          TO WS-PREV-USER-ID             
                MOVE PF-WQ-REASSIGN-IND  TO S-WQ-REASSIGN-IND-1         
                MOVE PF-WQ-RECIPIENT-IND TO S-WQ-RECIPIENT-IND-1        
                PERFORM 8100-SEND-RESULT-R1 THRU 8100-EXIT              
             END-IF.                                                    
                                                                        
       2300-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2400-PROCESS-WQ-ASSIGN-DET                                     *        
      ******************************************************************        
       2400-PROCESS-WQ-ASSIGN-DET.                                      
                                                                        
            MOVE ZEROES               TO WS-CATEGORY-ID                 
            MOVE SPACES               TO WS-CATEGORY-NAME-ID            
            MOVE PF-USER-ID           TO S-USER-ID-2                    
            MOVE PF-RESP-AREA-ID      TO S-RESP-AREA-ID-2               
            MOVE C3-CATEGORY-ID       TO S-CATEGORY-ID-2                
                                         S-CATEGORY-ID-3                
                                         WS-CATEGORY-ID                 
            STRING C3-CATEGORY-NAME   DELIMITED BY '   '                
                   '-'                DELIMITED BY SIZE                 
                   WS-CATEGORY-ID     DELIMITED BY SIZE                 
              INTO  WS-CATEGORY-NAME-ID                                 
                                                                        
            MOVE WS-CATEGORY-NAME-ID  TO S-CATEGORY-NAME-2              
                                         S-CATEGORY-NAME-3              
            MOVE C3-WQ-RETENTION-DAYS TO S-WQ-RETENTION-DAYS-2          
                                         S-WQ-RETENTION-DAYS-3          
            MOVE WS-N                 TO S-WQ-ASSIGNED-FLAG-2           
            PERFORM 7400-SELECT-WORK-CATEGORY THRU 7400-EXIT            
            PERFORM 8200-SEND-RESULT-R2 THRU 8200-EXIT                  
                                                                        
            PERFORM 7100-FETCH-WQ-CATEGORY-CURSOR THRU 7100-EXIT.       
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2500-BUILD-RESULT-3                                            *        
      ******************************************************************        
       2500-BUILD-RESULT-3.                                             
                                                                        
            MOVE ZEROES               TO WS-CATEGORY-ID                 
            MOVE SPACES               TO WS-CATEGORY-NAME-ID            
            MOVE WS-N                 TO S-WQ-ASSIGNED-FLAG-3           
            MOVE WS-N                 TO S-USER-ASSIGNED-FLAG-3         
                                                                        
            MOVE C3-CATEGORY-ID       TO S-CATEGORY-ID-3                
                                         WS-CATEGORY-ID                 
            STRING C3-CATEGORY-NAME   DELIMITED BY '   '                
                   '-'                DELIMITED BY SIZE                 
                   WS-CATEGORY-ID     DELIMITED BY SIZE                 
              INTO  WS-CATEGORY-NAME-ID                                 
                                                                        
            MOVE WS-CATEGORY-NAME-ID  TO S-CATEGORY-NAME-3              
            MOVE C3-WQ-RETENTION-DAYS TO S-WQ-RETENTION-DAYS-3          
            MOVE WS-COMPANY-NO        TO S-COMPANY-NO-3                 
                                                                        
            PERFORM 7500-SELECT-USER-ASGN-FLG     THRU 7500-EXIT        
            PERFORM 7550-GET-CATEGORY-ASIGND-FL   THRU 7550-EXIT        
            PERFORM 8300-SEND-RESULT-R3           THRU 8300-EXIT        
                                                                        
            PERFORM 7250-FETCH-WQ-AREA-CAT-CURSOR THRU 7250-EXIT.       
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-DETERMINE-REGION                                          *        
      ******************************************************************        
       7000-DETERMINE-REGION.                                           
           MOVE '7000'                TO ACTIVE-PARAGRAPH.              
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
              INTO :C8-DELINQ-VALUE                                     
              FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                        
              WHERE DELINQ_CD  = 'DATABASE'                             
              AND   COMPANY_NO = '01'                                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*       INTO :C8-DELINQ-VALUE                                             
MFA-TR*       FROM CSS_DELINQUENCY                                              
MFA-TR*       WHERE DELINQ_CD  = 'DATABASE'                                     
MFA-TR*       AND   COMPANY_NO = '01'                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_DELINQUENCY'     TO TABLE-1                     
              MOVE 'DELINQ_VALUE'        TO TABLE-ELEMENT-1             
              MOVE 'DATABASE'            TO HOSTVAR-ELEMENT-1           
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2             
              MOVE WS-COMPANY-NO         TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7050-OPEN-WQ-CATEGORY-CURSOR                                   *        
      ******************************************************************        
       7050-OPEN-WQ-CATEGORY-CURSOR.                                    
                                                                        
           MOVE '7050'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              OPEN WQ-CATEGORY-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_USER_PROFILE'         TO TABLE-1                
              MOVE 'RESP_AREA_ID'             TO TABLE-ELEMENT-1        
              MOVE PF-RESP-AREA-ID            TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-FETCH-WQ-CATEGORY-CURSOR                                  *        
      ******************************************************************        
      *                                                                         
       7100-FETCH-WQ-CATEGORY-CURSOR.                                   
                                                                        
           MOVE '7100'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           EXEC SQL                                                     
              FETCH  WQ-CATEGORY-CURSOR                                 
                INTO :PF-USER-ID,                                       
                     :PF-WQ-REASSIGN-IND,                               
                     :PF-WQ-RECIPIENT-IND,                              
                     :C3-CATEGORY-NAME,                                 
                     :C3-CATEGORY-ID,                                   
                     :C3-WQ-RETENTION-DAYS                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'Y'                     TO WS-NO-MORE-ROWS        
              ELSE                                                      
                 MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
                 MOVE 'FETCH'                 TO ABEND-FUNCTION         
                 MOVE SPACES                  TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                 MOVE 'CSS_USER_PROFILE'      TO TABLE-1                
                 MOVE 'RESP_AREA_ID'          TO TABLE-ELEMENT-1        
                 MOVE PF-RESP-AREA-ID         TO HOSTVAR-ELEMENT-1      
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
           END-IF
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7150-CLOSE-WQ-CATEGORY-CURSOR                                  *        
      ******************************************************************        
       7150-CLOSE-WQ-CATEGORY-CURSOR.                                   
                                                                        
           MOVE '7150'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              CLOSE  WQ-CATEGORY-CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_USER_PROFILE'         TO TABLE-1                
              MOVE 'RESP_AREA_ID'             TO TABLE-ELEMENT-1        
              MOVE PF-RESP-AREA-ID            TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-OPEN-WQ-AREA-CAT-CURSOR                                   *        
      ******************************************************************        
       7200-OPEN-WQ-AREA-CAT-CURSOR.                                    
                                                                        
           MOVE '7200'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              OPEN WQ-AREA-CAT-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_WQ_CATEGORY'          TO TABLE-1                
              MOVE 'CATEGORY_ID'              TO TABLE-ELEMENT-1        
              MOVE C3-CATEGORY-ID             TO HOSTVAR-ELEMENT-1      
              MOVE 'CSS_WQ_AREA_CAT'          TO TABLE-2                
              MOVE 'RESP_AREA_ID'             TO TABLE-ELEMENT-2        
              MOVE WS-INPUT-RESP-AREA-ID      TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7250-FETCH-WQ-AREA-CAT-CURSOR                                  *        
      ******************************************************************        
      *                                                                         
       7250-FETCH-WQ-AREA-CAT-CURSOR.                                   
                                                                        
           MOVE '7250'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           EXEC SQL                                                     
              FETCH  WQ-AREA-CAT-CURSOR                                 
                INTO :C3-CATEGORY-ID,                                   
                     :C3-CATEGORY-NAME,                                 
                     :C3-WQ-RETENTION-DAYS                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'Y'                     TO WS-NO-MORE-ROWS-C3     
              ELSE                                                      
                 MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
                 MOVE 'FETCH'                 TO ABEND-FUNCTION         
                 MOVE SPACES                  TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                 MOVE 'CSS_WQ_CATEGORY'       TO TABLE-1                
                 MOVE 'CATEGORY_ID'           TO TABLE-ELEMENT-1        
                 MOVE C3-CATEGORY-ID          TO HOSTVAR-ELEMENT-1      
                 MOVE 'CSS_WQ_AREA_CAT'       TO TABLE-2                
                 MOVE 'RESP_AREA_ID'          TO TABLE-ELEMENT-2        
                 MOVE WS-INPUT-RESP-AREA-ID   TO HOSTVAR-ELEMENT-2      
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
           END-IF
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-CLOSE-WQ-AREA-CAT-CURSOR                                  *        
      ******************************************************************        
       7300-CLOSE-WQ-AREA-CAT-CURSOR.                                   
                                                                        
           MOVE '7300'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              CLOSE  WQ-AREA-CAT-CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_WQ_CATEGORY'          TO TABLE-1                
              MOVE 'CATEGORY_ID'              TO TABLE-ELEMENT-1        
              MOVE C3-CATEGORY-ID             TO HOSTVAR-ELEMENT-1      
              MOVE 'CSS_WQ_AREA_CAT'          TO TABLE-2                
              MOVE 'RESP_AREA_ID'             TO TABLE-ELEMENT-2        
              MOVE WS-INPUT-RESP-AREA-ID      TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7400-SELECT-WORK-CATEGORY                                      *        
      ******************************************************************        
                                                                        
       7400-SELECT-WORK-CATEGORY.                                       
                                                                        
           MOVE '7400'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
              INTO :S-WQ-ASSIGNED-FLAG-2                                
              FROM CSS_WQ_U_CATEGORY WITH(READUNCOMMITTED)                      
              WHERE USER_ID     = :PF-USER-ID                           
              AND   CATEGORY_ID = :C3-CATEGORY-ID                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*       INTO :S-WQ-ASSIGNED-FLAG-2                                        
MFA-TR*       FROM CSS_WQ_U_CATEGORY                                            
MFA-TR*       WHERE USER_ID     = :PF-USER-ID                                   
MFA-TR*       AND   CATEGORY_ID = :C3-CATEGORY-ID                               
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7400                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_WQ_U_CATEGORY'        TO TABLE-1                
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-1        
              MOVE PF-USER-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE 'CATEGORY_ID'              TO TABLE-ELEMENT-2        
              MOVE C3-CATEGORY-ID             TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7500-SELECT-USER-ASGN-FLG.                                     *        
      ******************************************************************        
                                                                        
       7500-SELECT-USER-ASGN-FLG.                                       
                                                                        
           MOVE '7500'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
              INTO :S-USER-ASSIGNED-FLAG-3                              
              FROM CSS_WQ_U_CATEGORY WC WITH(READUNCOMMITTED)                   
                  ,CSS_USER_PROFILE  PF WITH(READUNCOMMITTED)                   
              WHERE WC.USER_ID        =  PF.USER_ID                     
              AND   WC.CATEGORY_ID    = :C3-CATEGORY-ID                 
              AND   PF.RESP_AREA_ID   = :PF-RESP-AREA-ID                
              AND   PF.USER_STATUS_CD <> 'D'                            
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*       INTO :S-USER-ASSIGNED-FLAG-3                                      
MFA-TR*       FROM CSS_WQ_U_CATEGORY WC                                         
MFA-TR*           ,CSS_USER_PROFILE  PF                                         
MFA-TR*       WHERE WC.USER_ID        =  PF.USER_ID                             
MFA-TR*       AND   WC.CATEGORY_ID    = :C3-CATEGORY-ID                         
MFA-TR*       AND   PF.RESP_AREA_ID   = :PF-RESP-AREA-ID                        
MFA-TR*       AND   PF.USER_STATUS_CD <> 'D'                                    
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_WQ_U_CATEGORY'        TO TABLE-1                
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-1        
              MOVE PF-USER-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE 'CATEGORY_ID'              TO TABLE-ELEMENT-2        
              MOVE C3-CATEGORY-ID             TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7550-GET-CATEGORY-ASIGND-FL.                                   *        
      ******************************************************************        
       7550-GET-CATEGORY-ASIGND-FL.                                     
           MOVE '7550'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
            SELECT TOP(1) 'Y'                                                  
            INTO :S-WQ-ASSIGNED-FLAG-3                                  
            FROM CSS_WQ_AREA_CAT AC WITH(READUNCOMMITTED)                       
            WHERE AC.CATEGORY_ID    = :C3-CATEGORY-ID                   
            AND   AC.RESP_AREA_ID   = :WS-INPUT-RESP-AREA-ID            
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT 'Y'                                                          
MFA-TR*     INTO :S-WQ-ASSIGNED-FLAG-3                                          
MFA-TR*     FROM CSS_WQ_AREA_CAT AC                                             
MFA-TR*     WHERE AC.CATEGORY_ID    = :C3-CATEGORY-ID                           
MFA-TR*     AND   AC.RESP_AREA_ID   = :WS-INPUT-RESP-AREA-ID                    
MFA-TR*     FETCH FIRST ROW ONLY                                                
MFA-TR*     WITH UR                                                             
MFA-TR*     QUERYNO 7550                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_WQ_AREA_CAT'          TO TABLE-1                
              MOVE 'RESP AREA ID'             TO TABLE-ELEMENT-1        
              MOVE WS-INPUT-RESP-AREA-ID      TO HOSTVAR-ELEMENT-1      
              MOVE 'CATEGORY_ID'              TO TABLE-ELEMENT-2        
              MOVE C3-CATEGORY-ID             TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7600-SELECT-COMPANY-NO.                                        *        
      ******************************************************************        
                                                                        
       7600-SELECT-COMPANY-NO.                                          
                                                                        
           MOVE '7600'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT COMPANY_NO                                         
              INTO :WS-COMPANY-NO                                       
              FROM CSS_RESP_AREA WITH(READUNCOMMITTED)                          
              WHERE RESP_AREA_ID   = :PF-RESP-AREA-ID                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COMPANY_NO                                                 
MFA-TR*       INTO :WS-COMPANY-NO                                               
MFA-TR*       FROM CSS_RESP_AREA                                                
MFA-TR*       WHERE RESP_AREA_ID   = :PF-RESP-AREA-ID                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7600                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_RESP_AREA'            TO TABLE-1                
              MOVE 'RESP_AREA_ID'             TO TABLE-ELEMENT-1        
              MOVE PF-RESP-AREA-ID            TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8000A-DEL-GTT-ROWS.                                            *        
      ******************************************************************        
      *                                                                         
       8000A-DEL-GTT-ROWS.                                              
      *                                                                         
           MOVE '8000A'                      TO ACTIVE-PARAGRAPH.       
           EXEC SQL                                                     
               DELETE FROM #CSR04916_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04916_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1.        
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1         
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE WS-ACTIVE-RETURN-CODE TO ABEND-SQLCODE         
                    MOVE SQLSTATE            TO ABEND-SQLSTATE          
                    MOVE 'DELETE'            TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CSR04916_R1'       TO TABLE-1                 
                    MOVE SPACES              TO TABLE-ELEMENT-1         
                    MOVE SPACES              TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8000B-DEL-GTT-ROWS.                                            *        
      ******************************************************************        
      *                                                                         
       8000B-DEL-GTT-ROWS.                                              
      *                                                                         
           MOVE '8000B'                      TO ACTIVE-PARAGRAPH.       
           EXEC SQL                                                     
               DELETE FROM #CSR04916_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04916_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-2.        
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-2         
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE WS-ACTIVE-RETURN-CODE TO ABEND-SQLCODE         
                    MOVE SQLSTATE            TO ABEND-SQLSTATE          
                    MOVE 'DELETE'            TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CSR04916_R2'       TO TABLE-1                 
                    MOVE SPACES              TO TABLE-ELEMENT-1         
                    MOVE SPACES              TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       8000B-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8000C-DEL-GTT-ROWS.                                            *        
      ******************************************************************        
      *                                                                         
       8000C-DEL-GTT-ROWS.                                              
      *                                                                         
           MOVE '8000C'                      TO ACTIVE-PARAGRAPH.       
           EXEC SQL                                                     
               DELETE FROM #CSR04916_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04916_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-3.        
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-3         
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE WS-ACTIVE-RETURN-CODE TO ABEND-SQLCODE         
                    MOVE SQLSTATE            TO ABEND-SQLSTATE          
                    MOVE 'DELETE'            TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CSR04916_R3'       TO TABLE-1                 
                    MOVE SPACES              TO TABLE-ELEMENT-1         
                    MOVE SPACES              TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       8000C-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8100-SEND-RESULT-R1                                            *        
      ******************************************************************        
       8100-SEND-RESULT-R1.                                             
     *                                                                  
           MOVE '8100'                    TO ACTIVE-PARAGRAPH.          
           EXEC SQL                                                     
               INSERT INTO #CSR04916_R1                          
                  (                                                     
                    RETURN_CODE                                         
                   ,USER_ID                                             
                   ,WQ_REASSIGN_IND                                     
                   ,WQ_RECIPIENT_IND                                    
                  )                                                     
               VALUES                                                   
                  (                                                     
                   :S-RETURN-CODE-1                                     
                  ,:S-USER-ID-1                                         
                  ,:S-WQ-REASSIGN-IND-1                                 
                  ,:S-WQ-RECIPIENT-IND-1                                
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR04916_R1                                  
MFA-TR*           (                                                             
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,USER_ID                                                     
MFA-TR*            ,WQ_REASSIGN_IND                                             
MFA-TR*            ,WQ_RECIPIENT_IND                                            
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*           (                                                             
MFA-TR*            :S-RETURN-CODE-1                                             
MFA-TR*           ,:S-USER-ID-1                                                 
MFA-TR*           ,:S-WQ-REASSIGN-IND-1                                         
MFA-TR*           ,:S-WQ-RECIPIENT-IND-1                                        
MFA-TR*           )                                                             
MFA-TR*     END-EXEC                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                       
                            S-RETURN-CODE-1.                            
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               ADD 1 TO CTR-ROWS-1                                      
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'INSERT'              TO ABEND-FUNCTION             
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSR04916_R1'         TO TABLE-1                    
               MOVE SPACES                TO TABLE-ELEMENT-1            
               MOVE SPACES                TO HOSTVAR-ELEMENT-1          
               MOVE WS-ACTIVE-RETURN-CODE TO ABEND-SQLCODE              
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8200-SEND-RESULT-R2                                            *        
      ******************************************************************        
       8200-SEND-RESULT-R2.                                             
     *                                                                  
           MOVE '8200'                    TO ACTIVE-PARAGRAPH.          
           EXEC SQL                                                     
               INSERT INTO #CSR04916_R2                          
                  (                                                     
                    RETURN_CODE                                         
                   ,USER_ID                                             
                   ,RESP_AREA_ID                                        
                   ,CATEGORY_ID                                         
                   ,CATEGORY_NAME                                       
                   ,WQ_RETENTION_DAYS                                   
                   ,WORK_ASSIGNED_FLAG                                  
                  )                                                     
               VALUES                                                   
                  (                                                     
                   :S-RETURN-CODE-2                                     
                  ,:S-USER-ID-2                                         
                  ,:S-RESP-AREA-ID-2                                    
                  ,:S-CATEGORY-ID-2                                     
                  ,:S-CATEGORY-NAME-2                                   
                  ,:S-WQ-RETENTION-DAYS-2                               
                  ,:S-WQ-ASSIGNED-FLAG-2                                
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR04916_R2                                  
MFA-TR*           (                                                             
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,USER_ID                                                     
MFA-TR*            ,RESP_AREA_ID                                                
MFA-TR*            ,CATEGORY_ID                                                 
MFA-TR*            ,CATEGORY_NAME                                               
MFA-TR*            ,WQ_RETENTION_DAYS                                           
MFA-TR*            ,WORK_ASSIGNED_FLAG                                          
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*           (                                                             
MFA-TR*            :S-RETURN-CODE-2                                             
MFA-TR*           ,:S-USER-ID-2                                                 
MFA-TR*           ,:S-RESP-AREA-ID-2                                            
MFA-TR*           ,:S-CATEGORY-ID-2                                             
MFA-TR*           ,:S-CATEGORY-NAME-2                                           
MFA-TR*           ,:S-WQ-RETENTION-DAYS-2                                       
MFA-TR*           ,:S-WQ-ASSIGNED-FLAG-2                                        
MFA-TR*           )                                                             
MFA-TR*     END-EXEC                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                       
                            S-RETURN-CODE-2.                            
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               ADD 1 TO CTR-ROWS-2                                      
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04916_R2'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8300-SEND-RESULT-R3                                            *        
      ******************************************************************        
       8300-SEND-RESULT-R3.                                             
     *                                                                  
           MOVE '8300'                   TO ACTIVE-PARAGRAPH.           
           EXEC SQL                                                     
               INSERT INTO #CSR04916_R3                          
                  (                                                     
                    RETURN_CODE                                         
                   ,CATEGORY_ID                                         
                   ,CATEGORY_NAME                                       
                   ,WQ_RETENTION_DAYS                                   
                   ,WORK_ASSIGNED_FLAG                                  
                   ,COMPANY_NO                                          
                   ,USER_ASSIGNED_FLAG                                  
                  )                                                     
               VALUES                                                   
                  (                                                     
                   :S-RETURN-CODE-3                                     
                  ,:S-CATEGORY-ID-3                                     
                  ,:S-CATEGORY-NAME-3                                   
                  ,:S-WQ-RETENTION-DAYS-3                               
                  ,:S-WQ-ASSIGNED-FLAG-3                                
                  ,:S-COMPANY-NO-3                                      
                  ,:S-USER-ASSIGNED-FLAG-3                              
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR04916_R3                                  
MFA-TR*           (                                                             
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,CATEGORY_ID                                                 
MFA-TR*            ,CATEGORY_NAME                                               
MFA-TR*            ,WQ_RETENTION_DAYS                                           
MFA-TR*            ,WORK_ASSIGNED_FLAG                                          
MFA-TR*            ,COMPANY_NO                                                  
MFA-TR*            ,USER_ASSIGNED_FLAG                                          
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*           (                                                             
MFA-TR*            :S-RETURN-CODE-3                                             
MFA-TR*           ,:S-CATEGORY-ID-3                                             
MFA-TR*           ,:S-CATEGORY-NAME-3                                           
MFA-TR*           ,:S-WQ-RETENTION-DAYS-3                                       
MFA-TR*           ,:S-WQ-ASSIGNED-FLAG-3                                        
MFA-TR*           ,:S-COMPANY-NO-3                                              
MFA-TR*           ,:S-USER-ASSIGNED-FLAG-3                                      
MFA-TR*           )                                                             
MFA-TR*     END-EXEC                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                       
                            S-RETURN-CODE-3.                            
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               ADD 1 TO CTR-ROWS-3                                      
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04916_R3'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8800-CHECK-RESULTS.                                            *        
      ******************************************************************        
      *                                                                         
       8800-CHECK-RESULTS.                                              
      *                                                                         
           IF CTR-ROWS-1    <= 0                                        
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE 100                       TO S-RETURN-CODE-1         
              PERFORM 8100-SEND-RESULT-R1     THRU 8100-EXIT            
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-2    <= 0                                        
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE 100                       TO S-RETURN-CODE-2         
              PERFORM 8200-SEND-RESULT-R2     THRU 8200-EXIT            
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-3    <= 0                                        
              INITIALIZE GTT-RETURN-FIELDS-3                            
              MOVE 100                       TO S-RETURN-CODE-3         
              PERFORM 8300-SEND-RESULT-R3     THRU 8300-EXIT            
           END-IF.                                                      
      *                                                                         
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
      *                                                                         
       8900-SEND-DONE.                                                  
      *                                                                         
           MOVE '8900'                       TO ACTIVE-PARAGRAPH.       
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE WS-ACTIVE-RETURN-CODE     TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSR04916_R1'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE WS-ACTIVE-RETURN-CODE     TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSR04916_R2'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE WS-ACTIVE-RETURN-CODE     TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSR04916_R3'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT.                                        *        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           MOVE WS-NO                        TO SEND-DONE-SW.           
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1                               
                      GTT-RETURN-FIELDS-2                               
                      GTT-RETURN-FIELDS-3.                              
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE        TO ABEND-SQLCODE           
                                                S-RETURN-CODE-1         
                                                S-RETURN-CODE-2         
                                                S-RETURN-CODE-3.        
           MOVE SQLERRMC                     TO ABEND-SQLERRMC.         
      *                                                                         
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'                TO ABEND-FUNCTION          
           END-IF.                                                      
      *                                                                         
           PERFORM 0100A-DECLARE-GTT          THRU 0100A-EXIT.          
           PERFORM 0100B-DECLARE-GTT          THRU 0100B-EXIT.          
           PERFORM 0100C-DECLARE-GTT          THRU 0100C-EXIT.          
      *                                                                         
           PERFORM 8100-SEND-RESULT-R1        THRU 8100-EXIT.           
           PERFORM 8200-SEND-RESULT-R2        THRU 8200-EXIT.           
           PERFORM 8300-SEND-RESULT-R3        THRU 8300-EXIT.           
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * INCLUDE CPD0023C FOR 9700- ERROR HANDLING                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                                 
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                      *                
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
      *                                                                         
           PERFORM 8800-CHECK-RESULTS         THRU 8800-EXIT.           
           PERFORM 8900-SEND-DONE             THRU 8900-EXIT.           
                                                                        
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
