       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04915.                                      
COB303 DATE-WRITTEN.     AUG 01, 2016.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES STA, MED CERT AND ACCOUNT DATA FOR IVR.*        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  08/01/16  MJ13662    CREATED.                                 *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      *  PARAMETERS:                                                            
      *                                                                         
      *  INPUT PARAMETERS.                                                      
      *           I_ACCOUNT_NO                 CHAR(13)                         
      *           I_STA_MEDCERT_FLAG           CHAR(01)                         
      *           I_ACCT_DETAILS_FLAG          CHAR(01)                         
      *                                                                         
      *  RESULT SET 1.                                                          
      *           RETURN_CODE                  INTEGER                          
      *           ARNGMT_STATUS                CHAR(01)                         
      *           ARNGMT_TYPE                  CHAR(01)                         
      *           ARNGMT_SORT_KEY              CHAR(01)                         
      *           ARNGMT_SORT_DATE             DATE                             
      *                                                                         
      *  RESULT SET 2.                                                          
      *           RETURN_CODE                  INTEGER                          
      *           LAST_PYMT_AMT                PIC S9(9)V99 USAGE COMP-3        
      *           LAST_PYMT_DATE_2             PIC X(10)                        
      *           RET_CHK_CNT_2                PIC S9(4)                        
      *           DPP_IND_2                    PIC X(01)                        
      *           EPP_IND_2                    PIC X(01)                        
      *           UTIL_ARREARS_2               PIC S9(9)V99 USAGE COMP-3        
      *           UTIL_BILLED_BAL_2            PIC S9(9)V99 USAGE COMP-3        
      *           UTIL_CUR_CHRG_2              PIC S9(9)V99 USAGE COMP-3        
      *           TOTAL_BILLED_BAL_2           PIC S9(9)V99 USAGE COMP-3        
      *           NEXT_BILL_DATE_2             PIC X(10)                        
      *           FULL_BALANCE_2               PIC S9(9)V99 USAGE COMP-3        
      *           CURRENT_DUE_DATE_2           PIC X(10)                        
      *           BILLED_AMT_A_2               PIC S9(9)V99 USAGE COMP-3        
      *           BILLED_DUE_A_2               PIC X(10)                        
      *           FIRST_DUE_B_2                PIC X(10)                        
      *           DNP_DATE_D_2                 PIC X(10)                        
      *           SPECIAL_TYPE_2               PIC X(1)                         
      *           SECOND_AMT_C_2               PIC S9(9)V99 USAGE COMP-3        
      *           SECOND_DUE_C_2               PIC X(10)                        
      *           DNP_AMT_D_2                  PIC S9(9)V99 USAGE COMP-3        
      *           DNP_AMT_G_2                  PIC S9(9)V99 USAGE COMP-3        
      *           DNP_DATE_G_2                 PIC X(10)                        
      *           AMT_NOTICE_H_2               PIC S9(9)V99 USAGE COMP-3        
      *           AVOIDLPC_DATE_H_2            PIC X(10)                        
      *           AMT_NOTICE_I_2               PIC S9(9)V99 USAGE COMP-3        
      *           AVOIDLPC_DATE_I_2            PIC X(10)                        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  08/01/16  MJ13662    PROCEDURE ORIGINNALLY CODED.             *        
      *                       APPL 5460 - ACT238                       *        
AP5744*  01/30/17  MJ13662    WS-DATE-NOTICE-DUE-A WAS NULL THEREFORE I*        
AP5744*                       CHANGED THE COMPARE TO > SPACES INSTEAD  *        
AP5744*                       OF = SPACES.                             *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04915'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04915 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *--------< CSS_ACCOUNT            AT                                      
           EXEC SQL                                                             
              INCLUDE  TBACCT                                                   
           END-EXEC.                                                            
                                                                        
      *--------< CSS_MNT_TRANS_HIST     MH                                      
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      *--------< CSS_CUST_ALERT         CA                                      
           EXEC SQL                                                             
              INCLUDE TBCSTALT                                                  
           END-EXEC.                                                            
                                                                        
      *--------< CSS_NSF_HIST           NH                                      
           EXEC SQL                                                             
              INCLUDE TBNSFHST                                                  
           END-EXEC.                                                            
                                                                        
      *--------< CSS_BILL_WINDOW        BN                                      
           EXEC SQL                                                             
              INCLUDE TBBILWDW                                                  
           END-EXEC.                                                            
                                                                        
      *                                                                         
      ******************************************************************06330000
      * CSS_CRED_ARNGMENT  - X1                                        *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCRARNG                                                  
           END-EXEC.                                                            
      *                                                                         
      *--------< WORKING STORAGE WS-CODES-DATA-PRESENT >                        
           EXEC SQL                                                             
              INCLUDE CWS00056                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *--------<COMMON SYSTEM AREA >                                            
           COPY CCA00001.                                                       
      *--------< ERROR HANDLING >                                               
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >               
           COPY CWS00027.                                                       
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
                                                                        
      *****************************************************************         
      *    COPY BOOKS USED FOR CPD00068.                                        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00068                                                  
           END-EXEC.                                                            
      *                                                                         
      * WORKING STORAGE FOR CPD0309A                                            
           EXEC SQL                                                             
              INCLUDE CWS00309                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
      *                                                                         
       01  WS-GTT-MISC-FIELDS.                                          
           05  WS-GTT-NAME              PIC X(19)  VALUE SPACES.        
                                                                        
       01  RS-RETURN-CODE               PIC S9(04) COMP VALUE 0.        
                                                                        
       01  GTT-RETURN-FIELDS-1.                                         
           05  S-RETURN-CODE-1           PIC S9(04)  COMP VALUE 0.      
           05  S-ARNGMT-TYPE-1           PIC X(1)    VALUE SPACE.       
           05  S-ARNGMT-STATUS-1         PIC X(1)    VALUE SPACE.       
           05  S-ARNGMT-SORT-KEY-1       PIC X(1)    VALUE SPACE.       
           05  S-ARNGMT-S-DATE-1         PIC X(10)   VALUE SPACE.       
      *                                                                         
       01  GTT-RETURN-FIELDS-2.                                         
           05  S-RETURN-CODE-2           PIC S9(04)    COMP VALUE 0.    
           05  S-LAST-PYMT-AMT-2         PIC S9(09)V99 COMP-3 VALUE +0. 
           05  S-LAST-PYMT-DATE-2        PIC X(10)   VALUE SPACE.       
           05  S-RET-CHK-CNT-2           PIC S9(4)     COMP VALUE 0.    
           05  S-DPP-IND-2               PIC X(01)   VALUE SPACE.       
           05  S-EPP-IND-2               PIC X(01)   VALUE SPACE.       
           05  S-UTIL-ARREARS-2          PIC S9(09)V99 COMP-3 VALUE +0. 
           05  S-UTIL-BILLED-BAL-2       PIC S9(09)V99 COMP-3 VALUE +0. 
           05  S-UTIL-CUR-CHRG-2         PIC S9(09)V99 COMP-3 VALUE +0. 
           05  S-TOTAL-BILLED-BAL-2      PIC S9(09)V99 COMP-3 VALUE +0. 
           05  S-NEXT-BILL-DATE-2        PIC X(10)   VALUE SPACE.       
           05  S-FULL-BALANCE-2          PIC S9(09)V99 COMP-3 VALUE +0. 
           05  S-CURRENT-DUE-DATE-2      PIC X(10)   VALUE SPACE.       
           05  S-BILLED-AMT-A-2          PIC S9(09)V99 COMP-3 VALUE +0. 
           05  S-BILLED-DUE-A-2          PIC X(10)   VALUE SPACE.       
           05  S-FIRST-DUE-B-2           PIC X(10)   VALUE SPACE.       
           05  S-DNP-DATE-D-2            PIC X(10)   VALUE SPACE.       
           05  S-SPECIAL-TYPE-2          PIC X(01)   VALUE SPACE.       
           05  S-SECOND-AMT-C-2          PIC S9(09)V99 COMP-3 VALUE +0. 
           05  S-SECOND-DUE-C-2          PIC X(10)   VALUE SPACE.       
           05  S-DNP-AMT-D-2             PIC S9(09)V99 COMP-3 VALUE +0. 
           05  S-DNP-AMT-G-2             PIC S9(09)V99 COMP-3 VALUE +0. 
           05  S-DNP-DATE-G-2            PIC X(10)   VALUE SPACE.       
           05  S-AMT-NOTICE-H-2          PIC S9(09)V99 COMP-3 VALUE +0. 
           05  S-AVOIDLPC-DATE-H-2       PIC X(10)   VALUE SPACE.       
           05  S-AMT-NOTICE-I-2          PIC S9(09)V99 COMP-3 VALUE +0. 
           05  S-AVOIDLPC-DATE-I-2       PIC X(10)   VALUE SPACE.       
           05  S-AMT-NOTICE-N-2          PIC S9(09)V99 COMP-3 VALUE +0. 
      *                                                                         
       01  GENERAL-WORKING-STORAGE.                                     
           05  WS-SQLSTATE               PIC X(05) VALUE '     '.       
           05  WS-LAST-PYMT-DATE-NI      PIC S9(4) COMP.                
           05  WS-DATE-EXTRACT-NI        PIC S9(4) COMP.                
           05  WS-BILL-DAY-00-NI         PIC S9(4) COMP.                
           05  WS-BILL-DAY-30-NI         PIC S9(4) COMP.                
           05  WS-BILL-DAY-60-NI         PIC S9(4) COMP.                
           05  WS-BILL-DAY-90-NI         PIC S9(4) COMP.                
           05  WS-ACCT-FINALED-DT-NI     PIC S9(4) COMP.                
           05  WS-RET-CHK-CNT            PIC S9(4) COMP VALUE 0.        
           05  WS-ONE-YEAR-AGO           PIC X(10) VALUE SPACES.        
           05  WS-ACCOUNT-NUM            PIC X(13).                     
           05  WS-ACCOUNT-DEC REDEFINES WS-ACCOUNT-NUM                  
                                         PIC 9(13).                     
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.      
           05  WS-SEND-CODE              PIC X(2) OCCURS 5.             
           05  WS-MED-CERT-DAYS          PIC S9(9) COMP VALUE 0.        
           05  WS-MED-RETURN-CODE        PIC S9(9) COMP VALUE 0.        
           05  WS-CURRENT-DATE           PIC X(10) VALUE SPACES.        
       01 WS-COUNTERS.                                                  
          05 CTR-ROWS-1                 PIC S9(9) COMP VALUE 0.         
          05 CTR-ROWS-2                 PIC S9(9) COMP VALUE 0.         
                                                                        
       01  WS-LITERALS.                                                 
           05  MCSCB068                  PIC X(8)  VALUE 'MCSCB068'.    
           05  WS-A                      PIC X(1)  VALUE 'A'.           
           05  WS-C                      PIC X(1)  VALUE 'C'.           
           05  WS-M                      PIC X(1)  VALUE 'M'.           
           05  PROGRAM-NAME              PIC X(08) VALUE 'CSR04915'.    
           05  WS-NO                     PIC X(02) VALUE 'NO'.          
           05  WS-DATE-FORMAT-USA.                                      
              10  WS-DATE-FMT-MM       PIC X(02).                       
              10  FILLER               PIC X(01)   VALUE '/'.           
              10  WS-DATE-FMT-DD       PIC X(02).                       
              10  FILLER               PIC X(01)   VALUE '/'.           
              10  WS-DATE-FMT-CCYY     PIC X(04).                       
                                                                        
       01  WS-SWITCHES.                                                 
           05 SEND-DONE-SW               PIC X(01) VALUE 'Y'.           
              88 SEND-DONE-ERROR                   VALUE 'N'.           
              88 SEND-DONE-OK                      VALUE 'Y'.           
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
      *----< CURSOR FOR MEDICAL CERTIFICATE ID                                  
           EXEC SQL DECLARE MED-CERT-ID-CURSOR CURSOR FOR               
              SELECT COALESCE(CIS.CHAR2$DATE(
           CA.DATE_ALERT,'USA'),'01/01/1950'),
                     CIS.DAYS(CA.DATE_EXPIRE) - CIS.DAYS(
           CAST(SYSDATETIMEOFFSET() AS DATE))          
                FROM CSS_MNT_TRANS_HIST MH WITH(READUNCOMMITTED),               
                     CSS_CUST_ALERT     CA WITH(READUNCOMMITTED)                
               WHERE CA.ACCOUNT_NO        = :CA-ACCOUNT-NO              
                 AND MH.ACCOUNT_NO        = :CA-ACCOUNT-NO              
                 AND MH.APPL_PROGRAM_ID   = 'PANEL269'                  
                 AND MH.TRANS_HIST_SEQ_NO =  CA.CUST_ALERT_SEQ_NO       
               ORDER BY MH.TRANS_HIST_SEQ_NO DESC                       
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL DECLARE MED-CERT-ID-CURSOR CURSOR FOR                       
MFA-TR*       SELECT IFNULL(CHAR(DATE(CA.DATE_ALERT),USA),'01/01/1950'),        
MFA-TR*              DAYS(CA.DATE_EXPIRE) - DAYS(CURRENT DATE)                  
MFA-TR*         FROM CSS_MNT_TRANS_HIST MH,                                     
MFA-TR*              CSS_CUST_ALERT     CA                                      
MFA-TR*        WHERE CA.ACCOUNT_NO        = :CA-ACCOUNT-NO                      
MFA-TR*          AND MH.ACCOUNT_NO        = :CA-ACCOUNT-NO                      
MFA-TR*          AND MH.APPL_PROGRAM_ID   = 'PANEL269'                          
MFA-TR*          AND MH.TRANS_HIST_SEQ_NO =  CA.CUST_ALERT_SEQ_NO               
MFA-TR*        ORDER BY MH.TRANS_HIST_SEQ_NO DESC                               
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                         
HPCCDM*EJECT                                                                    
      *                                                                         
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NUM              PIC X(13).                     
       01  PARM-STA-MEDCERT-FLAG         PIC X(01).                     
       01  PARM-ACCT-DETAILS-FLAG        PIC X(01).                     
      *                                                                         
       PROCEDURE DIVISION USING  PARM-ACCOUNT-NUM                       
                                 PARM-STA-MEDCERT-FLAG                  
                                 PARM-ACCT-DETAILS-FLAG.                
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
           
MSQ016        GOBACK.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           INITIALIZE GENERAL-WORKING-STORAGE.                          
           INITIALIZE CSRERLOG-P.                                       
                                                                        
           PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
           PERFORM 0100B-DECLARE-GTT     THRU 0100B-EXIT.               
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      *  0100A-DECLARE-GTT.  STA AND MEDICAL CERTIFICATE            *           
      ***************************************************************           
      *                                                                         
       0100A-DECLARE-GTT.                                               
      *                                                                         
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04915_R1'            
                                         TO S-SQL-STATEMENT-V.          
           MOVE 'SESSION.CSR04915_R1'    TO WS-GTT-NAME.                
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04915_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04915_R1
              (                                                        
                    RETURN_CODE            INT                      
                   ,ARNGMT_TYPE CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,ARNGMT_STATUS CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                      
                   ,ARNGMT_SORT_KEY CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                      
                   ,ARNGMT_S_DATE          DATE                         
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
               PERFORM 8000A-DEL-GTT-ROWS      THRU 8000A-EXIT          
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '0100A'           TO ACTIVE-PARAGRAPH           
                   MOVE 'DECLARE GTT'     TO ABEND-FUNCTION             
                   MOVE SPACES            TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                   MOVE WS-GTT-NAME       TO TABLE-1                    
                   MOVE SPACES            TO TABLE-ELEMENT-1            
                   MOVE SPACES            TO HOSTVAR-ELEMENT-1          
                   MOVE SQLCODE           TO ABEND-SQLCODE              
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
                                                                        
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                    RETURN_CODE                                         
                   ,LTRIM(RTRIM(ARNGMT_TYPE))           AS ARNGMT_TYPE         
                   ,LTRIM(RTRIM(ARNGMT_STATUS))         AS ARNGMT_STATUS       
                   ,LTRIM(RTRIM(ARNGMT_SORT_KEY))       AS 
           ARNGMT_SORT_KEY     
                   ,CIS.CHAR2$DATE(ARNGMT_S_DATE,'USA')      AS 
           ARNGMT_SORT_DATE    
               FROM                                                     
                   #CSR04915_R1                                  
                ORDER BY ARNGMT_SORT_KEY  ASC                           
                        ,ARNGMT_S_DATE DESC                             
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,STRIP(ARNGMT_TYPE)           AS ARNGMT_TYPE                 
MFA-TR*            ,STRIP(ARNGMT_STATUS)         AS ARNGMT_STATUS               
MFA-TR*            ,STRIP(ARNGMT_SORT_KEY)       AS ARNGMT_SORT_KEY             
MFA-TR*            ,CHAR(ARNGMT_S_DATE,USA)      AS ARNGMT_SORT_DATE            
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04915_R1                                          
MFA-TR*         ORDER BY ARNGMT_SORT_KEY  ASC                                   
MFA-TR*                 ,ARNGMT_S_DATE DESC                                     
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      *  0100B-DECLARE-GTT.  ACCOUNT DETAILS                        *           
      ***************************************************************           
      *                                                                         
       0100B-DECLARE-GTT.                                               
      *                                                                         
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04915_R2'            
                                         TO S-SQL-STATEMENT-V.          
           MOVE 'SESSION.CSR04915_R2'    TO WS-GTT-NAME.                
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04915_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04915_R2
              (                                                        
                    RETURN_CODE            INT                      
                   ,LAST_PYMT_AMT          DECIMAL(9,2)                 
                   ,LAST_PYMT_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,RET_CHK_CNT            SMALLINT                     
                   ,DPP_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,EPP_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,UTIL_ARREARS           DECIMAL(9,2)                 
                   ,UTIL_BILLED_BAL        DECIMAL(9,2)                 
                   ,UTIL_CUR_CHRG          DECIMAL(9,2)                 
                   ,TOTAL_BILLED_BAL       DECIMAL(9,2)                 
                   ,NEXT_BILL_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,FULL_BALANCE           DECIMAL(9,2)                 
                   ,CURRENT_DUE_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,BILLED_AMT_A           DECIMAL(9,2)                 
                   ,BILLED_DUE_A CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,FIRST_DUE_B CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,DNP_DATE_D CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,SPECIAL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,SECOND_AMT_C           DECIMAL(9,2)                 
                   ,SECOND_DUE_C CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,DNP_AMT_D              DECIMAL(9,2)                 
                   ,DNP_AMT_G              DECIMAL(9,2)                 
                   ,DNP_DATE_G CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,AMT_NOTICE_H           DECIMAL(9,2)                 
                   ,AVOIDLPC_DATE_H CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,AMT_NOTICE_I           DECIMAL(9,2)                 
                   ,AVOIDLPC_DATE_I CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,AMT_NOTICE_N           DECIMAL(9,2)                 
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
               PERFORM 8000B-DEL-GTT-ROWS      THRU 8000B-EXIT          
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '0100B'           TO ACTIVE-PARAGRAPH           
                   MOVE 'DECLARE GTT'     TO ABEND-FUNCTION             
                   MOVE SPACES            TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                   MOVE WS-GTT-NAME       TO TABLE-1                    
                   MOVE SPACES            TO TABLE-ELEMENT-1            
                   MOVE SPACES            TO HOSTVAR-ELEMENT-1          
                   MOVE SQLCODE           TO ABEND-SQLCODE              
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
                                                                        
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                    RETURN_CODE                                         
                   ,LAST_PYMT_AMT           AS LAST_PYMT_AMT            
                   ,LTRIM(RTRIM(LAST_PYMT_DATE))   AS LAST_PYMT_DATE           
                   ,LTRIM(RTRIM(RET_CHK_CNT))      AS RET_CHK_CNT              
                   ,LTRIM(RTRIM(DPP_IND))          AS DPP_IND                  
                   ,LTRIM(RTRIM(EPP_IND))          AS EPP_IND                  
                   ,UTIL_ARREARS            AS UTIL_ARREARS             
                   ,UTIL_BILLED_BAL         AS UTIL_BILLED_BAL          
                   ,UTIL_CUR_CHRG           AS UTIL_CUR_CHRG            
                   ,TOTAL_BILLED_BAL        AS TOTAL_BILLED_BAL         
                   ,LTRIM(RTRIM(NEXT_BILL_DATE))   AS NEXT_BILL_DATE           
                   ,FULL_BALANCE            AS FULL_BALANCE             
                   ,LTRIM(RTRIM(CURRENT_DUE_DATE)) AS CURRENT_DUE_DATE         
                   ,BILLED_AMT_A            AS BILLED_AMT_A             
                   ,LTRIM(RTRIM(BILLED_DUE_A))     AS BILLED_DUE_A             
                   ,LTRIM(RTRIM(FIRST_DUE_B))      AS FIRST_DUE_B              
                   ,LTRIM(RTRIM(DNP_DATE_D))       AS DNP_DATE_D               
                   ,LTRIM(RTRIM(SPECIAL_TYPE))     AS SPECIAL_TYPE             
                   ,SECOND_AMT_C            AS SECOND_AMT_C             
                   ,LTRIM(RTRIM(SECOND_DUE_C))     AS SECOND_DUE_C             
                   ,DNP_AMT_D               AS DNP_AMT_D                
                   ,DNP_AMT_G               AS DNP_AMT_G                
                   ,LTRIM(RTRIM(DNP_DATE_G))       AS DNP_DATE_G               
                   ,AMT_NOTICE_H            AS AMT_NOTICE_H             
                   ,LTRIM(RTRIM(AVOIDLPC_DATE_H))  AS AVOIDLPC_DATE_H          
                   ,AMT_NOTICE_I            AS AMT_NOTICE_I             
                   ,LTRIM(RTRIM(AVOIDLPC_DATE_I))  AS AVOIDLPC_DATE_I          
                   ,AMT_NOTICE_N            AS AMT_NOTICE_N             
               FROM                                                     
                   #CSR04915_R2                                  
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,LAST_PYMT_AMT           AS LAST_PYMT_AMT                    
MFA-TR*            ,STRIP(LAST_PYMT_DATE)   AS LAST_PYMT_DATE                   
MFA-TR*            ,STRIP(RET_CHK_CNT)      AS RET_CHK_CNT                      
MFA-TR*            ,STRIP(DPP_IND)          AS DPP_IND                          
MFA-TR*            ,STRIP(EPP_IND)          AS EPP_IND                          
MFA-TR*            ,UTIL_ARREARS            AS UTIL_ARREARS                     
MFA-TR*            ,UTIL_BILLED_BAL         AS UTIL_BILLED_BAL                  
MFA-TR*            ,UTIL_CUR_CHRG           AS UTIL_CUR_CHRG                    
MFA-TR*            ,TOTAL_BILLED_BAL        AS TOTAL_BILLED_BAL                 
MFA-TR*            ,STRIP(NEXT_BILL_DATE)   AS NEXT_BILL_DATE                   
MFA-TR*            ,FULL_BALANCE            AS FULL_BALANCE                     
MFA-TR*            ,STRIP(CURRENT_DUE_DATE) AS CURRENT_DUE_DATE                 
MFA-TR*            ,BILLED_AMT_A            AS BILLED_AMT_A                     
MFA-TR*            ,STRIP(BILLED_DUE_A)     AS BILLED_DUE_A                     
MFA-TR*            ,STRIP(FIRST_DUE_B)      AS FIRST_DUE_B                      
MFA-TR*            ,STRIP(DNP_DATE_D)       AS DNP_DATE_D                       
MFA-TR*            ,STRIP(SPECIAL_TYPE)     AS SPECIAL_TYPE                     
MFA-TR*            ,SECOND_AMT_C            AS SECOND_AMT_C                     
MFA-TR*            ,STRIP(SECOND_DUE_C)     AS SECOND_DUE_C                     
MFA-TR*            ,DNP_AMT_D               AS DNP_AMT_D                        
MFA-TR*            ,DNP_AMT_G               AS DNP_AMT_G                        
MFA-TR*            ,STRIP(DNP_DATE_G)       AS DNP_DATE_G                       
MFA-TR*            ,AMT_NOTICE_H            AS AMT_NOTICE_H                     
MFA-TR*            ,STRIP(AVOIDLPC_DATE_H)  AS AVOIDLPC_DATE_H                  
MFA-TR*            ,AMT_NOTICE_I            AS AMT_NOTICE_I                     
MFA-TR*            ,STRIP(AVOIDLPC_DATE_I)  AS AVOIDLPC_DATE_I                  
MFA-TR*            ,AMT_NOTICE_N            AS AMT_NOTICE_N                     
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04915_R2                                          
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NUM      TO WS-ACCOUNT-NUM.                
           MOVE WS-ACCOUNT-DEC        TO WS-ACCOUNT-NO                  
                                         CA-ACCOUNT-NO                  
                                         X1-ACCOUNT-NO                  
                                         AT-ACCOUNT-NO.                 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           INITIALIZE                            GTT-RETURN-FIELDS-1    
                                                 GTT-RETURN-FIELDS-2.   
                                                                        
           PERFORM 2200-BUILD-RESULT             THRU 2200-EXIT.        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
      *----< SELECT ACCOUNT >                                                   
           PERFORM 7000-SELECT-ACCOUNT                 THRU 7000-EXIT.  
           MOVE AT-CODES-DATA-PRESENT     TO WS-CODES-DATA-PRESENT.     
                                                                        
      *----< GET THE MEDICAL CERTIFICATE INFORMATION >                          
              IF PARM-STA-MEDCERT-FLAG = 'Y'                            
                 PERFORM 7020-OPEN-MED-CERT-ID-CURSOR  THRU 7020-EXIT   
                 PERFORM 7120-FETCH-MED-CERT-ID-CURSOR THRU 7120-EXIT   
                 PERFORM 2250-PROCESS-MED-CERT         THRU 2250-EXIT   
                    UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND             
                 PERFORM 7220-CLOSE-MED-CERT-ID-CURSOR THRU 7220-EXIT   
                                                                        
      *----< BUILD CDD/CDDA/NEW STA/STAA/STF/STFA  DETAIL         ---->         
                 IF WS-CODE-CRED-ARNG = 'A' OR                          
                    WS-CODE-STA-ACCT  = 'A'                             
                    PERFORM 7610-GET-ACTIVE-ARNG-INFO                   
                       THRU 7610-EXIT                                   
                    IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL     
                        MOVE ZERO      TO S-RETURN-CODE-1               
                        STRING FUNCTION CURRENT-DATE (1:4)              
                            '-'                                         
                            FUNCTION CURRENT-DATE (5:2)                 
                            '-'                                         
                            FUNCTION CURRENT-DATE (7:2)                 
                            DELIMITED BY SIZE                           
                            INTO S-ARNGMT-S-DATE-1                      
                        EVALUATE X1-ARNG-TYPE                           
                           WHEN 'CDD'                                   
                           WHEN 'CDDA'                                  
                              MOVE 'D'       TO S-ARNGMT-TYPE-1         
                           WHEN 'STA'                                   
                              MOVE 'S'       TO S-ARNGMT-TYPE-1         
                           WHEN 'STAA'                                  
                              MOVE 'T'       TO S-ARNGMT-TYPE-1         
                           WHEN 'STF'                                   
                              MOVE 'F'       TO S-ARNGMT-TYPE-1         
                           WHEN 'STFA'                                  
                              MOVE 'G'       TO S-ARNGMT-TYPE-1         
                        END-EVALUATE                                    
                        MOVE 'A'       TO S-ARNGMT-STATUS-1             
                        MOVE ' '       TO S-ARNGMT-SORT-KEY-1           
                        PERFORM 8100-SEND-RESULT-R1  THRU 8100-EXIT     
                    END-IF                                              
                 END-IF                                                 
              END-IF.                                                   
                                                                        
              IF PARM-ACCT-DETAILS-FLAG  = 'Y'                          
                 PERFORM 7503-CALCULATE-TODAY    THRU 7503-EXIT         
                 PERFORM 2500-ACCOUNT-DETAILS    THRU 2500-EXIT         
              ELSE                                                      
                 MOVE ZERO                TO S-RETURN-CODE-2            
              END-IF                                                    
                                                                        
      *--------< IF NOTHING HAS BEEN FOUND, THEN SO FAR NOTHING HAS >           
      *--------< BEEN SENT BACK. SEND BACK A SUCCESSFUL MESSAGE     >           
              IF CTR-ROWS-1 = 0 AND CTR-ROWS-2 = 0                      
                 MOVE ZERO                TO S-RETURN-CODE-1            
                                             S-RETURN-CODE-2            
                 MOVE '1950-01-01'        TO S-ARNGMT-S-DATE-1          
                 MOVE ' '                 TO S-ARNGMT-SORT-KEY-1        
                 PERFORM 8100-SEND-RESULT-R1 THRU 8100-EXIT             
                 PERFORM 8200-SEND-RESULT-R2 THRU 8200-EXIT             
              END-IF.                                                   
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2250-PROCESS-MED-CERT                                          *        
      *     FETCHES ALL MEDICAL CERTIFICATES                           *        
      ******************************************************************        
       2250-PROCESS-MED-CERT.                                           
                                                                        
      *-----< FETCH MEDICAL CERTIFICATES                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               MOVE CA-DATE-ALERT       TO S-ARNGMT-S-DATE-1            
               MOVE WS-M                TO S-ARNGMT-TYPE-1              
               IF WS-MED-CERT-DAYS > 0                                  
                  MOVE WS-A             TO S-ARNGMT-STATUS-1            
                  MOVE '1'              TO S-ARNGMT-SORT-KEY-1          
               ELSE                                                     
                  MOVE WS-C             TO S-ARNGMT-STATUS-1            
                  MOVE '3'              TO S-ARNGMT-SORT-KEY-1          
               END-IF                                                   
           ELSE                                                         
               MOVE SPACES              TO S-ARNGMT-TYPE-1              
                                           S-ARNGMT-STATUS-1            
                                           S-ARNGMT-SORT-KEY-1          
                                           S-ARNGMT-S-DATE-1            
           END-IF.                                                      
      *                                                                         
           PERFORM 8100-SEND-RESULT-R1 THRU 8100-EXIT.                  
      *                                                                         
           PERFORM 7120-FETCH-MED-CERT-ID-CURSOR THRU 7120-EXIT.        
                                                                        
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  2500-ACCOUNT-DETAILS.                                         *        
      ******************************************************************        
      *                                                                         
       2500-ACCOUNT-DETAILS.                                            
      *                                                                         
           IF AT-LAST-PYMT-DATE > SPACES                                
              MOVE AT-LAST-PYMT-DATE(1:4)  TO WS-DATE-FMT-CCYY          
              MOVE AT-LAST-PYMT-DATE(6:2)  TO WS-DATE-FMT-MM            
              MOVE AT-LAST-PYMT-DATE(9:2)  TO WS-DATE-FMT-DD            
              MOVE WS-DATE-FORMAT-USA      TO S-LAST-PYMT-DATE-2        
           ELSE                                                         
              MOVE SPACES                  TO S-LAST-PYMT-DATE-2        
           END-IF.                                                      
                                                                        
           MOVE AT-LAST-PYMT-AMOUNT        TO S-LAST-PYMT-AMT-2.        
                                                                        
           PERFORM 7400-CALCULATE-ONE-YEAR-AGO THRU 7400-EXIT.          
           PERFORM 7500-CALC-NO-OF-RET-CHKS    THRU 7500-EXIT.          
           MOVE WS-RET-CHK-CNT             TO S-RET-CHK-CNT-2.          
                                                                        
           MOVE WS-CODE-DPP-ACCT           TO S-DPP-IND-2.              
           MOVE WS-CODE-BUDGET             TO S-EPP-IND-2.              
                                                                        
           PERFORM 5900-NEXT-BILL-DATE THRU 5900-NEXT-BILL-DATE-EXIT.   
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
                OR WS-DATE-EXTRACT-NI = -1                              
              MOVE SPACES                  TO S-NEXT-BILL-DATE-2        
           ELSE                                                         
              MOVE BN-DATE-EXTRACT(1:4)    TO WS-DATE-FMT-CCYY          
              MOVE BN-DATE-EXTRACT(6:2)    TO WS-DATE-FMT-MM            
              MOVE BN-DATE-EXTRACT(9:2)    TO WS-DATE-FMT-DD            
              MOVE WS-DATE-FORMAT-USA      TO S-NEXT-BILL-DATE-2        
           END-IF.                                                      
                                                                        
      * SET CPD00068 SWITCHES THAT ARE NEEDED                                   
           MOVE 'Y' TO CALC-BALANCE-SW                                  
                       LOAD-WS-AMOUNTS-SW                               
                       LOAD-DUE-DATES-SW                                
                       LOAD-DNP-DATE-SW                                 
                       CALC-DNP-BAL-SW                                  
                       CALC-ARREARS-SW                                  
                       CALC-PAST-DUE-SW.                                
                                                                        
           MOVE PROGRAM-NAME               TO WS-CPD00068-CALLING-PGM.  
           MOVE SPACES                     TO WS-PANEL-NUM-CPD68.       
           MOVE SPACES                     TO ABEND-FUNCTION .          
           MOVE AT-CODES-DATA-PRESENT      TO WS-CODES-DATA-PRESENT.    
           PERFORM 9500-CALL-CPD00068      THRU 9500-EXIT.              
                                                                        
           MOVE WS-AMT-FULL-BALANCE        TO S-FULL-BALANCE-2.         
           MOVE WS-TOTAL-BALANCE           TO S-TOTAL-BILLED-BAL-2.     
           MOVE WS-AMT-ARREARS-UTL         TO S-UTIL-ARREARS-2.         
           MOVE WS-TOTAL-BALANCE-UTL       TO S-UTIL-BILLED-BAL-2.      
           MOVE WS-CURR-CHARGES-UTL        TO S-UTIL-CUR-CHRG-2.        
                                                                        
           IF WS-DATE-BILL-DUE > SPACES                                 
              MOVE WS-DATE-BILL-DUE(1:4)  TO WS-DATE-FMT-CCYY           
              MOVE WS-DATE-BILL-DUE(6:2)  TO WS-DATE-FMT-MM             
              MOVE WS-DATE-BILL-DUE(9:2)  TO WS-DATE-FMT-DD             
              MOVE WS-DATE-FORMAT-USA     TO S-CURRENT-DUE-DATE-2       
           ELSE                                                         
              MOVE SPACES                 TO S-CURRENT-DUE-DATE-2       
           END-IF.                                                      
                                                                        
AP5744     IF WS-DATE-NOTICE-DUE-A > SPACES                             
AP5744        MOVE WS-DATE-NOTICE-DUE-A(1:4) TO WS-DATE-FMT-CCYY        
AP5744        MOVE WS-DATE-NOTICE-DUE-A(6:2) TO WS-DATE-FMT-MM          
AP5744        MOVE WS-DATE-NOTICE-DUE-A(9:2) TO WS-DATE-FMT-DD          
AP5744        MOVE WS-DATE-FORMAT-USA        TO S-BILLED-DUE-A-2        
AP5744     ELSE                                                         
AP5744        MOVE SPACES                    TO S-BILLED-DUE-A-2        
AP5744     END-IF.                                                      
                                                                        
           MOVE WS-AMT-NOTICE-A              TO S-BILLED-AMT-A-2.       
                                                                        
           IF WS-DATE-NOTICE-DUE-B = SPACES                             
              MOVE WS-DATE-NOTICE-DUE-B      TO S-FIRST-DUE-B-2         
           ELSE                                                         
              MOVE WS-DATE-NOTICE-DUE-B(1:4) TO WS-DATE-FMT-CCYY        
              MOVE WS-DATE-NOTICE-DUE-B(6:2) TO WS-DATE-FMT-MM          
              MOVE WS-DATE-NOTICE-DUE-B(9:2) TO WS-DATE-FMT-DD          
              MOVE WS-DATE-FORMAT-USA        TO S-FIRST-DUE-B-2         
           END-IF.                                                      
                                                                        
           IF WS-CODE-SPECIAL-TYPE-E > SPACES                           
              MOVE WS-CODE-SPECIAL-TYPE-E  TO S-SPECIAL-TYPE-2          
           ELSE                                                         
              IF WS-CODE-SPECIAL-TYPE-F > SPACES                        
                 MOVE WS-CODE-SPECIAL-TYPE-F TO S-SPECIAL-TYPE-2        
              ELSE                                                      
                 MOVE WS-CODE-SPECIAL-TYPE-G TO S-SPECIAL-TYPE-2        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-DATE-NOTICE-DUE-C = SPACES                             
              MOVE WS-DATE-NOTICE-DUE-C      TO S-SECOND-DUE-C-2        
           ELSE                                                         
              MOVE WS-DATE-NOTICE-DUE-C(1:4) TO WS-DATE-FMT-CCYY        
              MOVE WS-DATE-NOTICE-DUE-C(6:2) TO WS-DATE-FMT-MM          
              MOVE WS-DATE-NOTICE-DUE-C(9:2) TO WS-DATE-FMT-DD          
              MOVE WS-DATE-FORMAT-USA        TO S-SECOND-DUE-C-2        
           END-IF.                                                      
                                                                        
           MOVE WS-AMT-NOTICE-C              TO S-SECOND-AMT-C-2.       
                                                                        
           IF WS-DATE-CREDIT-ACTION-D = SPACES                          
              MOVE WS-DATE-CREDIT-ACTION-D   TO S-DNP-DATE-D-2          
           ELSE                                                         
              MOVE WS-DATE-CREDIT-ACTION-D(1:4) TO WS-DATE-FMT-CCYY     
              MOVE WS-DATE-CREDIT-ACTION-D(6:2) TO WS-DATE-FMT-MM       
              MOVE WS-DATE-CREDIT-ACTION-D(9:2) TO WS-DATE-FMT-DD       
              MOVE WS-DATE-FORMAT-USA           TO S-DNP-DATE-D-2       
           END-IF.                                                      
                                                                        
           MOVE WS-AMT-NOTICE-D                 TO S-DNP-AMT-D-2.       
                                                                        
           IF WS-DATE-CREDIT-ACTION-G = SPACES OR LOW-VALUES            
              MOVE SPACES                       TO S-DNP-DATE-G-2       
           ELSE                                                         
              MOVE WS-DATE-CREDIT-ACTION-G(1:4) TO WS-DATE-FMT-CCYY     
              MOVE WS-DATE-CREDIT-ACTION-G(6:2) TO WS-DATE-FMT-MM       
              MOVE WS-DATE-CREDIT-ACTION-G(9:2) TO WS-DATE-FMT-DD       
              MOVE WS-DATE-FORMAT-USA           TO S-DNP-DATE-G-2       
           END-IF.                                                      
                                                                        
           MOVE WS-AMT-NOTICE-G             TO S-DNP-AMT-G-2.           
                                                                        
           IF WS-DATE-CREDIT-ACTION-H = SPACES                          
              MOVE WS-DATE-CREDIT-ACTION-H  TO S-AVOIDLPC-DATE-H-2      
           ELSE                                                         
              MOVE WS-DATE-CREDIT-ACTION-H(1:4) TO WS-DATE-FMT-CCYY     
              MOVE WS-DATE-CREDIT-ACTION-H(1:4) TO WS-DATE-FMT-MM       
              MOVE WS-DATE-CREDIT-ACTION-H(1:4) TO WS-DATE-FMT-DD       
              MOVE WS-DATE-FORMAT-USA           TO S-AVOIDLPC-DATE-H-2  
           END-IF.                                                      
                                                                        
           MOVE WS-AMT-NOTICE-H             TO S-AMT-NOTICE-H-2.        
                                                                        
           IF WS-DATE-CREDIT-ACTION-I = SPACES                          
              MOVE WS-DATE-CREDIT-ACTION-I  TO S-AVOIDLPC-DATE-I-2      
           ELSE                                                         
              MOVE WS-DATE-CREDIT-ACTION-I(1:4) TO WS-DATE-FMT-CCYY     
              MOVE WS-DATE-CREDIT-ACTION-I(6:2) TO WS-DATE-FMT-MM       
              MOVE WS-DATE-CREDIT-ACTION-I(9:2) TO WS-DATE-FMT-DD       
              MOVE WS-DATE-FORMAT-USA       TO S-AVOIDLPC-DATE-I-2      
           END-IF.                                                      
                                                                        
           MOVE WS-AMT-NOTICE-I             TO S-AMT-NOTICE-I-2.        
                                                                        
           MOVE WS-AMT-NOTICE-N             TO S-AMT-NOTICE-N-2.        
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * NEXT BILL DATE                                                          
           EXEC SQL                                                             
              INCLUDE CPD0309A                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7000-SELECT-ACCOUNT                                            *        
      ******************************************************************        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           MOVE '7000'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
                SELECT                                                  
                     AT.CODES_DATA_PRESENT,                             
                     AT.LAST_PYMT_DATE,                                 
                     AT.LAST_PYMT_AMOUNT,                               
                     AT.CODE_BILL_FREQ,                                 
                     AT.REV_MTH_LST_NRML,                               
                     AT.BILL_CYCLE,                                     
                     AT.LAST_NRML_BILL_NO,                              
                     AT.CODE_DISC_OK,                                   
                     AT.DATE_BILL_DAY_00,                               
                     AT.DATE_BILL_DAY_30,                               
                     AT.DATE_BILL_DAY_60,                               
                     AT.DATE_BILL_DAY_90,                               
                     AT.CREDIT_GROUP,                                   
                     AT.TOTAL_AR_BALANCE,                               
                     AT.CODE_STATUS_REASON,                             
                     AT.CODE_ACCT_STAT,                                 
                     REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.ACCT_FINALED_DT, 121), ' ', '-'), ':', '.') 
           ACCT_FINALED_DT,                                
                     AT.CREDIT_STATUS_CODE,                             
                     AT.BILL_CYCLE,                                     
                     REPLACE(REPLACE(CONVERT(CHAR(26), AT.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,                        
                     AT.MST_SUB_ACCT_IND,                               
                     AT.NOTICE_EXEMPT_CD,                               
                     AT.COMPANY_NO,                                     
                     AT.LOCAL_OFFICE,                                   
                     AT.BANKRUPTCY_IND,                                 
                     AT.IVR_EXEMPT_CD,                                  
                     AT.ADDRESS_ID                                      
                INTO :AT-CODES-DATA-PRESENT,                            
                     :AT-LAST-PYMT-DATE :WS-LAST-PYMT-DATE-NI,           
                     :AT-LAST-PYMT-AMOUNT,                              
                     :AT-CODE-BILL-FREQ,                                
                     :AT-REV-MTH-LST-NRML,                              
                     :AT-BILL-CYCLE,                                    
                     :AT-LAST-NRML-BILL-NO,                             
                     :AT-CODE-DISC-OK,                                  
                     :AT-DATE-BILL-DAY-00 :WS-BILL-DAY-00-NI,            
                     :AT-DATE-BILL-DAY-30 :WS-BILL-DAY-30-NI,            
                     :AT-DATE-BILL-DAY-60 :WS-BILL-DAY-60-NI,            
                     :AT-DATE-BILL-DAY-90 :WS-BILL-DAY-90-NI,            
                     :AT-CREDIT-GROUP,                                  
                     :AT-TOTAL-AR-BALANCE,                              
                     :AT-CODE-STATUS-REASON,                            
                     :AT-CODE-ACCT-STAT,                                
                     :AT-ACCT-FINALED-DT :WS-ACCT-FINALED-DT-NI,         
                     :AT-CREDIT-STATUS-CODE,                            
                     :AT-BILL-CYCLE,                                    
                     :AT-LAST-UPDATE-TS,                                
                     :AT-MST-SUB-ACCT-IND,                              
                     :AT-NOTICE-EXEMPT-CD,                              
                     :AT-COMPANY-NO,                                    
                     :AT-LOCAL-OFFICE,                                  
                     :AT-BANKRUPTCY-IND,                                
                     :AT-IVR-EXEMPT-CD,                                 
                     :AT-ADDRESS-ID                                     
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*              AT.CODES_DATA_PRESENT,                                     
MFA-TR*              AT.LAST_PYMT_DATE,                                         
MFA-TR*              AT.LAST_PYMT_AMOUNT,                                       
MFA-TR*              AT.CODE_BILL_FREQ,                                         
MFA-TR*              AT.REV_MTH_LST_NRML,                                       
MFA-TR*              AT.BILL_CYCLE,                                             
MFA-TR*              AT.LAST_NRML_BILL_NO,                                      
MFA-TR*              AT.CODE_DISC_OK,                                           
MFA-TR*              AT.DATE_BILL_DAY_00,                                       
MFA-TR*              AT.DATE_BILL_DAY_30,                                       
MFA-TR*              AT.DATE_BILL_DAY_60,                                       
MFA-TR*              AT.DATE_BILL_DAY_90,                                       
MFA-TR*              AT.CREDIT_GROUP,                                           
MFA-TR*              AT.TOTAL_AR_BALANCE,                                       
MFA-TR*              AT.CODE_STATUS_REASON,                                     
MFA-TR*              AT.CODE_ACCT_STAT,                                         
MFA-TR*              AT.ACCT_FINALED_DT,                                        
MFA-TR*              AT.CREDIT_STATUS_CODE,                                     
MFA-TR*              AT.BILL_CYCLE,                                             
MFA-TR*              AT.LAST_UPDATE_TS,                                         
MFA-TR*              AT.MST_SUB_ACCT_IND,                                       
MFA-TR*              AT.NOTICE_EXEMPT_CD,                                       
MFA-TR*              AT.COMPANY_NO,                                             
MFA-TR*              AT.LOCAL_OFFICE,                                           
MFA-TR*              AT.BANKRUPTCY_IND,                                         
MFA-TR*              AT.IVR_EXEMPT_CD,                                          
MFA-TR*              AT.ADDRESS_ID                                              
MFA-TR*         INTO :AT-CODES-DATA-PRESENT,                                    
MFA-TR*              :AT-LAST-PYMT-DATE:WS-LAST-PYMT-DATE-NI,                   
MFA-TR*              :AT-LAST-PYMT-AMOUNT,                                      
MFA-TR*              :AT-CODE-BILL-FREQ,                                        
MFA-TR*              :AT-REV-MTH-LST-NRML,                                      
MFA-TR*              :AT-BILL-CYCLE,                                            
MFA-TR*              :AT-LAST-NRML-BILL-NO,                                     
MFA-TR*              :AT-CODE-DISC-OK,                                          
MFA-TR*              :AT-DATE-BILL-DAY-00:WS-BILL-DAY-00-NI,                    
MFA-TR*              :AT-DATE-BILL-DAY-30:WS-BILL-DAY-30-NI,                    
MFA-TR*              :AT-DATE-BILL-DAY-60:WS-BILL-DAY-60-NI,                    
MFA-TR*              :AT-DATE-BILL-DAY-90:WS-BILL-DAY-90-NI,                    
MFA-TR*              :AT-CREDIT-GROUP,                                          
MFA-TR*              :AT-TOTAL-AR-BALANCE,                                      
MFA-TR*              :AT-CODE-STATUS-REASON,                                    
MFA-TR*              :AT-CODE-ACCT-STAT,                                        
MFA-TR*              :AT-ACCT-FINALED-DT:WS-ACCT-FINALED-DT-NI,                 
MFA-TR*              :AT-CREDIT-STATUS-CODE,                                    
MFA-TR*              :AT-BILL-CYCLE,                                            
MFA-TR*              :AT-LAST-UPDATE-TS,                                        
MFA-TR*              :AT-MST-SUB-ACCT-IND,                                      
MFA-TR*              :AT-NOTICE-EXEMPT-CD,                                      
MFA-TR*              :AT-COMPANY-NO,                                            
MFA-TR*              :AT-LOCAL-OFFICE,                                          
MFA-TR*              :AT-BANKRUPTCY-IND,                                        
MFA-TR*              :AT-IVR-EXEMPT-CD,                                         
MFA-TR*              :AT-ADDRESS-ID                                             
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO            WS-ACTIVE-RETURN-CODE             
                                      S-RETURN-CODE-1                   
                                      S-RETURN-CODE-2.                  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-LAST-PYMT-DATE-NI < 0 THEN                          
                  MOVE SPACES                 TO AT-LAST-PYMT-DATE      
              END-IF                                                    
              IF WS-BILL-DAY-00-NI    < 0 THEN                          
                  MOVE SPACES                 TO AT-DATE-BILL-DAY-00    
              END-IF                                                    
              IF WS-BILL-DAY-30-NI    < 0 THEN                          
                  MOVE SPACES                 TO AT-DATE-BILL-DAY-30    
              END-IF                                                    
              IF WS-BILL-DAY-60-NI    < 0 THEN                          
                  MOVE SPACES                 TO AT-DATE-BILL-DAY-60    
              END-IF                                                    
              IF WS-BILL-DAY-90-NI    < 0 THEN                          
                  MOVE SPACES                 TO AT-DATE-BILL-DAY-90    
              END-IF                                                    
              IF WS-ACCT-FINALED-DT-NI < 0 THEN                         
                  MOVE SPACES                 TO AT-ACCT-FINALED-DT     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7020-OPEN-MED-CERT-ID-CURSOR                                   *        
      ******************************************************************        
       7020-OPEN-MED-CERT-ID-CURSOR.                                    
                                                                        
           MOVE '7020'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              OPEN MED-CERT-ID-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
              MOVE 'CSS_CUST_ALERT'           TO TABLE-2                
              MOVE 'APPL_PROGRAM_ID'          TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'CSR04915'                 TO HOSTVAR-ELEMENT-1      
              MOVE CA-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7120-FETCH-MEDICAL-CERT-ID                                     *        
      ******************************************************************        
      *                                                                         
       7120-FETCH-MED-CERT-ID-CURSOR.                                   
                                                                        
           MOVE '7120'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           EXEC SQL                                                     
              FETCH  MED-CERT-ID-CURSOR                                 
                INTO :CA-DATE-ALERT,                                    
                     :WS-MED-CERT-DAYS                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
              MOVE 'CSS_CUST_ALERT'           TO TABLE-2                
              MOVE 'APPL_PROGRAM_ID'          TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'CSR04915'                 TO HOSTVAR-ELEMENT-1      
              MOVE CA-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7220-CLOSE-MED-CERT-ID-CURSOR                                  *        
      ******************************************************************        
       7220-CLOSE-MED-CERT-ID-CURSOR.                                   
                                                                        
           MOVE '7220'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              CLOSE  MED-CERT-ID-CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
              MOVE 'APPL_PROGRAM_ID'          TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'CSR04915'                 TO HOSTVAR-ELEMENT-1      
              MOVE CA-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7400-CALCULATE-ONE-YEAR-AGO                                    *        
      ******************************************************************        
                                                                        
       7400-CALCULATE-ONE-YEAR-AGO.                                     
                                                                        
           MOVE '7400'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( MONTH, -12, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-ONE-YEAR-AGO            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-ONE-YEAR-AGO = CURRENT DATE - 12 MONTH                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SET'                      TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7500-CALC-NO-OF-RET-CHKS                                       *        
      ******************************************************************        
                                                                        
       7500-CALC-NO-OF-RET-CHKS.                                        
                                                                        
           MOVE '7500'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
              INTO  :WS-RET-CHK-CNT                                     
              FROM   CSS_NSF_HIST NH WITH(READUNCOMMITTED)                      
              WHERE  NH.ACCOUNT_NO      = :AT-ACCOUNT-NO                
              AND    NH.NSF_STATUS_CD   = :WS-C                         
              AND    NH.DATE_TRAN       > IIF(TRY_CONVERT(DATE, 
                                                       :WS-ONE-YEAR-AGO
              ) IS NULL OR (PATINDEX('%.%', :WS-ONE-YEAR-AGO
              ) <> 0) OR (LEN(:WS-ONE-YEAR-AGO) <> 10), CIS.CHAR2DATE(
                                                       :WS-ONE-YEAR-AGO
              ), CONVERT(DATE, :WS-ONE-YEAR-AGO) )              
                                                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*       INTO  :WS-RET-CHK-CNT                                             
MFA-TR*       FROM   CSS_NSF_HIST NH                                            
MFA-TR*       WHERE  NH.ACCOUNT_NO      = :AT-ACCOUNT-NO                        
MFA-TR*       AND    NH.NSF_STATUS_CD   = :WS-C                                 
MFA-TR*       AND    NH.DATE_TRAN       > :WS-ONE-YEAR-AGO                      
MFA-TR*       WITH   UR                                                         
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           OR                         NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_NSF_HIST'             TO TABLE-1                
              MOVE 'ACCOUNT-NO'               TO TABLE-ELEMENT-1        
              MOVE 'DATE_TRAN'                TO TABLE-ELEMENT-2        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE WS-ONE-YEAR-AGO            TO HOSTVAR-ELEMENT-2      
                                                                        
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7503-CALCULATE-TODAY                                           *        
      ******************************************************************        
                                                                        
       7503-CALCULATE-TODAY.                                            
                                                                        
           MOVE '7503'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-DATE = CURRENT DATE                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SET'                      TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7503-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************16234000
      * 7610-GET-ACTIVE-ARNG-INFO                                      *16240000
      *  GET ACTIVE ARNG INFO.                                         *16260000
      ******************************************************************16290000
                                                                        
       7610-GET-ACTIVE-ARNG-INFO.                                       
      *                                                                 16310000
           EXEC SQL                                                     
              SELECT TOP(1) X1.ARNG_TYPE,
              X1.ARNG_SETUP_DT                                   
                 INTO :X1-ARNG-TYPE                                     
                    , :X1-ARNG-SETUP-DT                                 
                FROM CSS_CRED_ARNGMENT X1 WITH(READUNCOMMITTED)                 
               WHERE X1.ACCOUNT_NO     =  :X1-ACCOUNT-NO                
                 AND X1.ARNG_STATUS_CD =  'A'                           
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     16320000
MFA-TR*       SELECT X1.ARNG_TYPE                                       16330000
MFA-TR*             ,X1.ARNG_SETUP_DT                                   16330000
MFA-TR*          INTO :X1-ARNG-TYPE                                             
MFA-TR*             , :X1-ARNG-SETUP-DT                                 16330000
MFA-TR*         FROM CSS_CRED_ARNGMENT X1                               16350000
MFA-TR*        WHERE X1.ACCOUNT_NO     =  :X1-ACCOUNT-NO                16390000
MFA-TR*          AND X1.ARNG_STATUS_CD =  'A'                           16420000
MFA-TR*       FETCH FIRST 1 ROW ONLY                                            
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7610                                                      
MFA-TR*    END-EXEC.                                                    16430000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 16440000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 16460000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7610'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_CRED_ARNGMENT'       TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE X1-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                 16590000
       7610-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8000A-DEL-GTT-ROWS.                                            *        
      ******************************************************************        
      *                                                                         
       8000A-DEL-GTT-ROWS.                                              
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04915_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04915_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1.        
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1         
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE SQLCODE             TO ABEND-SQLCODE           
                    MOVE SQLSTATE            TO ABEND-SQLSTATE          
                    MOVE '8000A'             TO ACTIVE-PARAGRAPH        
                    MOVE 'DELETE'            TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CSR04915_R1'       TO TABLE-1                 
                    MOVE SPACES              TO TABLE-ELEMENT-1         
                    MOVE SPACES              TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8000B-DEL-GTT-ROWS.                                            *        
      ******************************************************************        
      *                                                                         
       8000B-DEL-GTT-ROWS.                                              
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04915_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04915_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-2.        
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-2         
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE SQLCODE             TO ABEND-SQLCODE           
                    MOVE SQLSTATE            TO ABEND-SQLSTATE          
                    MOVE '8000B'             TO ACTIVE-PARAGRAPH        
                    MOVE 'DELETE'            TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CSR04915_R2'       TO TABLE-1                 
                    MOVE SPACES              TO TABLE-ELEMENT-1         
                    MOVE SPACES              TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       8000B-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8100-SEND-RESULT-R1                                            *        
      ******************************************************************        
       8100-SEND-RESULT-R1.                                             
     *                                                                  
           EXEC SQL                                                     
               INSERT INTO #CSR04915_R1                          
                  (                                                     
                    RETURN_CODE                                         
                   ,ARNGMT_TYPE                                         
                   ,ARNGMT_STATUS                                       
                   ,ARNGMT_SORT_KEY                                     
                   ,ARNGMT_S_DATE                                       
                  )                                                     
               VALUES                                                   
                  (                                                     
                   :S-RETURN-CODE-1                                     
                  ,:S-ARNGMT-TYPE-1                                     
                  ,:S-ARNGMT-STATUS-1                                   
                  ,:S-ARNGMT-SORT-KEY-1                                 
                  ,IIF(TRY_CONVERT(DATE, :S-ARNGMT-S-DATE-1
              ) IS NULL OR (PATINDEX('%.%', :S-ARNGMT-S-DATE-1
              ) <> 0) OR (LEN(:S-ARNGMT-S-DATE-1
              ) <> 10), CIS.CHAR2DATE(:S-ARNGMT-S-DATE-1
              ), CONVERT(DATE, :S-ARNGMT-S-DATE-1) )                           
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR04915_R1                                  
MFA-TR*           (                                                             
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,ARNGMT_TYPE                                                 
MFA-TR*            ,ARNGMT_STATUS                                               
MFA-TR*            ,ARNGMT_SORT_KEY                                             
MFA-TR*            ,ARNGMT_S_DATE                                               
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*           (                                                             
MFA-TR*            :S-RETURN-CODE-1                                             
MFA-TR*           ,:S-ARNGMT-TYPE-1                                             
MFA-TR*           ,:S-ARNGMT-STATUS-1                                           
MFA-TR*           ,:S-ARNGMT-SORT-KEY-1                                         
MFA-TR*           ,:S-ARNGMT-S-DATE-1                                           
MFA-TR*           )                                                             
MFA-TR*     END-EXEC                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                       
                            S-RETURN-CODE-1.                            
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               ADD 1 TO CTR-ROWS-1                                      
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8100'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04915_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               MOVE SQLCODE              TO ABEND-SQLCODE               
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8200-SEND-RESULT-R2                                            *        
      ******************************************************************        
       8200-SEND-RESULT-R2.                                             
     *                                                                  
           EXEC SQL                                                     
               INSERT INTO #CSR04915_R2                          
                  (                                                     
                    RETURN_CODE                                         
                   ,LAST_PYMT_AMT                                       
                   ,LAST_PYMT_DATE                                      
                   ,RET_CHK_CNT                                         
                   ,DPP_IND                                             
                   ,EPP_IND                                             
                   ,UTIL_ARREARS                                        
                   ,UTIL_BILLED_BAL                                     
                   ,UTIL_CUR_CHRG                                       
                   ,TOTAL_BILLED_BAL                                    
                   ,NEXT_BILL_DATE                                      
                   ,FULL_BALANCE                                        
                   ,CURRENT_DUE_DATE                                    
                   ,BILLED_AMT_A                                        
                   ,BILLED_DUE_A                                        
                   ,FIRST_DUE_B                                         
                   ,DNP_DATE_D                                          
                   ,SPECIAL_TYPE                                        
                   ,SECOND_AMT_C                                        
                   ,SECOND_DUE_C                                        
                   ,DNP_AMT_D                                           
                   ,DNP_AMT_G                                           
                   ,DNP_DATE_G                                          
                   ,AMT_NOTICE_H                                        
                   ,AVOIDLPC_DATE_H                                     
                   ,AMT_NOTICE_I                                        
                   ,AVOIDLPC_DATE_I                                     
                   ,AMT_NOTICE_N                                        
                  )                                                     
               VALUES                                                   
                  (                                                     
                   :S-RETURN-CODE-2                                     
                  ,:S-LAST-PYMT-AMT-2                                   
                  ,:S-LAST-PYMT-DATE-2                                  
                  ,:S-RET-CHK-CNT-2                                     
                  ,:S-DPP-IND-2                                         
                  ,:S-EPP-IND-2                                         
                  ,:S-UTIL-ARREARS-2                                    
                  ,:S-UTIL-BILLED-BAL-2                                 
                  ,:S-UTIL-CUR-CHRG-2                                   
                  ,:S-TOTAL-BILLED-BAL-2                                
                  ,:S-NEXT-BILL-DATE-2                                  
                  ,:S-FULL-BALANCE-2                                    
                  ,:S-CURRENT-DUE-DATE-2                                
                  ,:S-BILLED-AMT-A-2                                    
                  ,:S-BILLED-DUE-A-2                                    
                  ,:S-FIRST-DUE-B-2                                     
                  ,:S-DNP-DATE-D-2                                      
                  ,:S-SPECIAL-TYPE-2                                    
                  ,:S-SECOND-AMT-C-2                                    
                  ,:S-SECOND-DUE-C-2                                    
                  ,:S-DNP-AMT-D-2                                       
                  ,:S-DNP-AMT-G-2                                       
                  ,:S-DNP-DATE-G-2                                      
                  ,:S-AMT-NOTICE-H-2                                    
                  ,:S-AVOIDLPC-DATE-H-2                                 
                  ,:S-AMT-NOTICE-I-2                                    
                  ,:S-AVOIDLPC-DATE-I-2                                 
                  ,:S-AMT-NOTICE-N-2                                    
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR04915_R2                                  
MFA-TR*           (                                                             
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,LAST_PYMT_AMT                                               
MFA-TR*            ,LAST_PYMT_DATE                                              
MFA-TR*            ,RET_CHK_CNT                                                 
MFA-TR*            ,DPP_IND                                                     
MFA-TR*            ,EPP_IND                                                     
MFA-TR*            ,UTIL_ARREARS                                                
MFA-TR*            ,UTIL_BILLED_BAL                                             
MFA-TR*            ,UTIL_CUR_CHRG                                               
MFA-TR*            ,TOTAL_BILLED_BAL                                            
MFA-TR*            ,NEXT_BILL_DATE                                              
MFA-TR*            ,FULL_BALANCE                                                
MFA-TR*            ,CURRENT_DUE_DATE                                            
MFA-TR*            ,BILLED_AMT_A                                                
MFA-TR*            ,BILLED_DUE_A                                                
MFA-TR*            ,FIRST_DUE_B                                                 
MFA-TR*            ,DNP_DATE_D                                                  
MFA-TR*            ,SPECIAL_TYPE                                                
MFA-TR*            ,SECOND_AMT_C                                                
MFA-TR*            ,SECOND_DUE_C                                                
MFA-TR*            ,DNP_AMT_D                                                   
MFA-TR*            ,DNP_AMT_G                                                   
MFA-TR*            ,DNP_DATE_G                                                  
MFA-TR*            ,AMT_NOTICE_H                                                
MFA-TR*            ,AVOIDLPC_DATE_H                                             
MFA-TR*            ,AMT_NOTICE_I                                                
MFA-TR*            ,AVOIDLPC_DATE_I                                             
MFA-TR*            ,AMT_NOTICE_N                                                
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*           (                                                             
MFA-TR*            :S-RETURN-CODE-2                                             
MFA-TR*           ,:S-LAST-PYMT-AMT-2                                           
MFA-TR*           ,:S-LAST-PYMT-DATE-2                                          
MFA-TR*           ,:S-RET-CHK-CNT-2                                             
MFA-TR*           ,:S-DPP-IND-2                                                 
MFA-TR*           ,:S-EPP-IND-2                                                 
MFA-TR*           ,:S-UTIL-ARREARS-2                                            
MFA-TR*           ,:S-UTIL-BILLED-BAL-2                                         
MFA-TR*           ,:S-UTIL-CUR-CHRG-2                                           
MFA-TR*           ,:S-TOTAL-BILLED-BAL-2                                        
MFA-TR*           ,:S-NEXT-BILL-DATE-2                                          
MFA-TR*           ,:S-FULL-BALANCE-2                                            
MFA-TR*           ,:S-CURRENT-DUE-DATE-2                                        
MFA-TR*           ,:S-BILLED-AMT-A-2                                            
MFA-TR*           ,:S-BILLED-DUE-A-2                                            
MFA-TR*           ,:S-FIRST-DUE-B-2                                             
MFA-TR*           ,:S-DNP-DATE-D-2                                              
MFA-TR*           ,:S-SPECIAL-TYPE-2                                            
MFA-TR*           ,:S-SECOND-AMT-C-2                                            
MFA-TR*           ,:S-SECOND-DUE-C-2                                            
MFA-TR*           ,:S-DNP-AMT-D-2                                               
MFA-TR*           ,:S-DNP-AMT-G-2                                               
MFA-TR*           ,:S-DNP-DATE-G-2                                              
MFA-TR*           ,:S-AMT-NOTICE-H-2                                            
MFA-TR*           ,:S-AVOIDLPC-DATE-H-2                                         
MFA-TR*           ,:S-AMT-NOTICE-I-2                                            
MFA-TR*           ,:S-AVOIDLPC-DATE-I-2                                         
MFA-TR*           ,:S-AMT-NOTICE-N-2                                            
MFA-TR*           )                                                             
MFA-TR*     END-EXEC                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                       
                            S-RETURN-CODE-2.                            
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               ADD 1 TO CTR-ROWS-2                                      
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8200'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04915_R2'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8800-CHECK-RESULTS.                                            *        
      ******************************************************************        
      *                                                                         
       8800-CHECK-RESULTS.                                              
      *                                                                         
           IF CTR-ROWS-1    <= 0                                        
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE 100                       TO S-RETURN-CODE-1         
              PERFORM 8100-SEND-RESULT-R1     THRU 8100-EXIT            
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-2    <= 0                                        
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE 100                       TO S-RETURN-CODE-2         
              PERFORM 8200-SEND-RESULT-R2     THRU 8200-EXIT            
           END-IF.                                                      
      *                                                                         
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
      *                                                                         
       8900-SEND-DONE.                                                  
      *                                                                         
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '8900'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSR04915_R1'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '8900'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSR04915_R2'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT.                                        *        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           MOVE WS-NO                        TO SEND-DONE-SW.           
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1                               
                      GTT-RETURN-FIELDS-2.                              
                                                                        
           MOVE '1950-01-01'    TO S-ARNGMT-S-DATE-1.                   
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE        TO ABEND-SQLCODE           
                                                S-RETURN-CODE-1         
                                                S-RETURN-CODE-2.        
           MOVE SQLERRMC                     TO ABEND-SQLERRMC.         
      *                                                                         
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'                TO ABEND-FUNCTION          
           END-IF.                                                      
      *                                                                         
           PERFORM 0100A-DECLARE-GTT          THRU 0100A-EXIT.          
           PERFORM 0100B-DECLARE-GTT          THRU 0100B-EXIT.          
      *                                                                         
           PERFORM 8100-SEND-RESULT-R1        THRU 8100-EXIT.           
           PERFORM 8200-SEND-RESULT-R2        THRU 8200-EXIT.           
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
       9500-CALL-CPD00068.                                              
                                                                        
           CALL MCSCB068  USING  CWS00068-FIELDS                        
                                 WS-CODES-DATA-PRESENT                  
                                 DCLCSS-ACCOUNT                         
                                 ABEND-FILE                             
                                 RS-RETURN-CODE.                        
           MOVE RS-RETURN-CODE           TO WS-ACTIVE-RETURN-CODE,      
                                            SQLCODE.                    
           IF ABEND-FUNCTION  > SPACES                                  
              IF ABEND-FUNCTION EQUAL 'BADDATA'                         
                 MOVE -1                  TO S-RETURN-CODE-1,           
                                             WS-ACTIVE-RETURN-CODE      
              END-IF                                                    
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       9500-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * INCLUDE CPD0023C FOR 9700- ERROR HANDLING                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                                 
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                      *                
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
      *                                                                         
           PERFORM 8800-CHECK-RESULTS         THRU 8800-EXIT            
           PERFORM 8900-SEND-DONE             THRU 8900-EXIT            
                                                                        
           
MSQ016        GOBACK.                                                    
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
