       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04914.                                         
COB303 DATE-WRITTEN.  JULY 2016.                                        
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE IS USED TO UPDATE,DELETE OR INSERT ROWS INTO   *        
      *  CSS_PREM_DER_DET TABLE FROM FRONT END                         *        
      *                                                                *        
      ******************************************************************        
      *--                                                            --*        
      *--  PARAMETERS                                                --*        
      *--                                                            --*        
      *--      INPUT                                                 --*        
      *--            I_UPDATE_TYPE        CHAR(01)                   --*        
      *--            I_ACCOUNT_NO         DECIMAL(13,0)              --*        
      *--            I_DER_SEQ_NO         SMALLINT                   --*        
      *--            I_DER_PGM_TYPE_CD    CHAR(5)                    --*        
      *--            I_DER_APPROVAL_DT    DATE                       --*        
      *--            I_PANEL_TYPE_CD      CHAR(2)                    --*        
      *--            I_INVERTER_TYPE_CD   CHAR(2)                    --*        
      *--            I_INTERCONNECT_DT    DATE                       --*        
      *--            I_INVERTER_SYST_SIZE DECIMAL(7,3)               --*        
      *--            I_CONFIG_TYPE_CD     CHAR(2)                    --*        
      *--            I_DER_STATUS_CD      CHAR(1)                    --*        
      *--            I_DER_STATUS_CHG_DT  DATE                       --*        
      *--            I_DER_CONTRCT_END_DT DATE                       --*        
      *--            I_DER_OWNER_CD       CHAR(2)                    --*        
      *--            I_INCENTIVE_ACCT_NO  DECIMAL(13,0)              --*        
      *--            I_USERID             CHAR(7)                    --*        
      *--            I_PREM_PGM_START_DT  CHAR(10)                   --*        
      *--            I_INCENTIVE_END_DT   CHAR(10)                   --*        
      *--                                                            --*        
      *--                                                            --*        
      *--  RESULT SET                                                --*        
      *--                                                            --*        
      *--  CSR04914_R1 - Premise Distributed Energy Resource details --*        
      *--                                                            --*        
      *--           RETURN_CODE             INTEGER                  --*        
      *--           APPL_RETURN_CODE        INTEGER                  --*        
      *--           BUS_RULE_ID             CHAR(10)                 --*        
      *--           BUS_RULE_RESULT_CD      CHAR(10)                 --*        
      *--           BUS_RULE_XREF_ID        CHAR(26)                 --*        
      *--                                                            --*        
      ******************************************************************        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
I02104*  07/22/16  AK7T405   INITIAL VERSION.                          *        
I02105*  02/13/17  MS7M727   TO INSERT DATA INTO CSS_PREM_DER_DET      *        
I02105*                      TABLE WHEN DER_STATUS_CD IS 'P'           *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04914'.
MSQ017     COPY MFASQLM.
      *                                                                         
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPRDERD                                                  
           END-EXEC.                                                            
      *                                                                         
I02105***************************************************************** *       
I02105*   CSS_ACCOUNT - AT                                            *         
I02105***************************************************************** *       
I02105*                                                                         
I02105     EXEC SQL                                                             
I02105        INCLUDE TBACCT                                                    
I02105     END-EXEC.                                                            
I02105*                                                                         
I02105***************************************************************** *       
I02105* CSS_SO_DATA VO                                                          
I02105***************************************************************** *       
I02105     EXEC SQL                                                             
I02105        INCLUDE TBSODAT                                                   
I02105     END-EXEC.                                                            
I02105*                                                                         
I02105***************************************************************** *       
I02105* HST_SO_DATA YV                                                          
I02105***************************************************************** *       
I02105     EXEC SQL                                                             
I02105        INCLUDE TBHSTDAT                                                  
I02105     END-EXEC.                                                            
I02105*                                                                         
I02105***************************************************************** *       
I02105* CSS_DER_PROGRAM 6D                                                      
I02105***************************************************************** *       
I02105     EXEC SQL                                                             
I02105        INCLUDE TBDPROG                                                   
I02105     END-EXEC.                                                            
I02105*                                                                         
I02105****************************************************************  *       
I02105* CSS_DELINQUENCY C8                                                      
I02105***************************************************************** *       
I02105     EXEC SQL                                                             
I02105        INCLUDE TBDELQ                                                    
I02105     END-EXEC.                                                            
I02105*                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
           COPY CWS00038.                                                       
           COPY CWS00303.                                                       
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1               PIC S9(9) COMP VALUE 0.       
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                  PIC X(18) VALUE SPACES.       
           10  S-SQLCODE                  PIC S9(9) COMP VALUE 0.       
           10  S-SQLSTATE                 PIC X(5)  VALUE ' '.          
           10  S-TABLE-NAME               PIC X(18) VALUE SPACES.       
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L     PIC S9(4) USAGE COMP.         
               49  S-HOST-VARIABLES-V     PIC X(255).                   
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L      PIC S9(4) USAGE COMP.         
               49  S-SQL-STATEMENT-V      PIC X(255).                   
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L    PIC S9(4) USAGE COMP.         
               49  S-SQL-DESCRIPTION-V    PIC X(255).                   
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L    PIC S9(4) USAGE COMP.         
               49  WS-ABEND-SQLERRMC-L    PIC S9(4) USAGE COMP.         
               49  WS-ABEND-SQLERRMC-V    PIC X(255).                   
                                                                        
       01  WS-MISC-FIELDS.                                              
           05  WS-SQLSTATE                PIC X(05) VALUE SPACES.       
           05  WS-GTT-NAME                PIC X(26) VALUE SPACES.       
           05  WS-ERR-INSRT-R1            PIC X(01) VALUE 'N'.          
           05  WS-APPL-RETURN-CODE        PIC S9(04) COMP VALUE 0.      
I02105     05  WS-COMPLETED-DT            PIC X(10) VALUE SPACES.       
I02105     05  WS-CURRENT-DATE            PIC X(10) VALUE SPACES.       
I02105     05  WS-DER-PGM-TYPE-CD         PIC X(05) VALUE SPACES.       
I02105     05  WS-INACTIVE                PIC X(01) VALUE 'I'.          
I02105     05  WS-ACTIVE                  PIC X(01) VALUE 'A'.          
I02105     05  WS-COMPANY-NO              PIC 9(02) VALUE 01.           
I02105     05  WS-DELINQ-CD               PIC X(20) VALUE               
I02105                                       'SOLAR-INCT-END-DT'.       
COB305     05 WS-DELINQ-VALUE        PIC S9(09) COMP-3 VALUE 0.            
I02105     05  WS-NULL-IND1               PIC S9(04) COMP VALUE 0.      
I02105     05  WS-NULL-IND2               PIC S9(04) COMP VALUE 0.      
I02105     05  WS-NULL-IND3               PIC S9(04) COMP VALUE 0.      
I02105     05  WS-NULL-IND4               PIC S9(04) COMP VALUE 0.      
I02105     05  WS-NULL-IND5               PIC S9(04) COMP VALUE 0.      
I02105     05  WS-NULL-IND6               PIC S9(04) COMP VALUE 0.      
I02105     05  WS-NULL-IND7               PIC S9(04) COMP VALUE 0.      
I02105     05  WS-NULL-IND8               PIC S9(04) COMP VALUE 0.      
I02105     05  WS-NULL-IND9               PIC S9(04) COMP VALUE 0.      
I02105     05  WS-NULL-IND10              PIC S9(04) COMP VALUE 0.      
I02105     05  WS-NULL-IND11              PIC S9(04) COMP VALUE 0.      
I02105     05  WS-NULL-IND12              PIC S9(04) COMP VALUE 0.      
I02105     05  WS-INC-END-DT              PIC X(10)  VALUE SPACES.      
                                                                        
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE                PIC S9(04) COMP VALUE 0.      
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1           PIC S9(04) COMP VALUE 0.      
             10 S-APPL-RETURN-CODE-1      PIC S9(04) COMP VALUE 0.      
             10 S-RS1-BUS-RULE-ID         PIC X(10)  VALUE SPACES.      
             10 S-RS1-BUS-RULE-RESULT-CD  PIC X(10)  VALUE SPACES.      
             10 S-RS1-BUS-RULE-XREF-ID    PIC X(26)  VALUE SPACES.      
      *                                                                         
       01  WS-PROGRAM-NAME.                                             
           05  PROGRAM-NAME               PIC X(08)  VALUE 'CSR04914'.  
           05  WS-PGRMNAME                PIC X(08)  VALUE 'CSR04914'.  
      *                                                                         
       01  STORAGE-FIELDS.                                              
           05  WS-PARM-FIELDS.                                          
COB305         10 WS-PREMISE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.     
               10 WS-PARM-TYPE            PIC X(01).                    
               10 WS-SEQUENCE-NO          PIC 9(02).                    
               10 WS-MAX-SEQ-NO           PIC S9(4) USAGE COMP VALUE 0. 
           05  WS-CURRENT-TIMESTAMP       PIC X(26) VALUE SPACES.       
           05  WS-RESP-AREA-ID            PIC X(03) VALUE SPACES.       
           05  WS-LITERALS.                                             
               10 WS-I                    PIC X(01) VALUE 'I'.          
               10 WS-U                    PIC X(01) VALUE 'U'.          
               10 WS-D                    PIC X(01) VALUE 'D'.          
I02105         10 WS-P                    PIC X(01) VALUE 'P'.          
           05  WS-DER-SEQ-NO              PIC 9(10).                    
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01 PARM-UPDATE-TYPE                PIC  X(01).                   
COB305 01 PARM-ACCOUNT-NO        PIC  S9(13) COMP-3 VALUE 0.           
       01 PARM-DER-SEQ-NO                 PIC  S9(4) USAGE COMP.        
       01 PARM-DER-PGM-TYPE-CD            PIC  X(05).                   
       01 PARM-DER-APPROVAL-DT            PIC  X(10).                   
       01 PARM-PANEL-TYPE-CD              PIC  X(02).                   
       01 PARM-INVERTER-TYPE-CD           PIC  X(02).                   
       01 PARM-INTERCONNECT-DT            PIC  X(10).                   
COB305 01 PARM-INVERTER-SYST-SIZE        PIC  S9(4)V9(03) COMP-3 
COB305       VALUE 0.      
       01 PARM-CONFIG-TYPE-CD             PIC  X(02).                   
       01 PARM-DER-STATUS-CD              PIC  X(01).                   
       01 PARM-DER-STATUS-CHG-DT          PIC  X(10).                   
       01 PARM-DER-CONTRCT-END-DT         PIC  X(10).                   
       01 PARM-DER-OWNER-CD               PIC  X(02).                   
COB305 01 PARM-INCENTIVE-ACCT-NO        PIC  S9(13) COMP-3 VALUE 0.           
       01 PARM-USERID                     PIC  X(07).                   
       01 PARM-PREM-PGM-START-DT          PIC  X(10).                   
       01 PARM-INCENTIVE-END-DT           PIC  X(10).                   
                                                                        
      *                                                                         
       PROCEDURE DIVISION USING  PARM-UPDATE-TYPE                       
                                ,PARM-ACCOUNT-NO                        
                                ,PARM-DER-SEQ-NO                        
                                ,PARM-DER-PGM-TYPE-CD                   
                                ,PARM-DER-APPROVAL-DT                   
                                ,PARM-PANEL-TYPE-CD                     
                                ,PARM-INVERTER-TYPE-CD                  
                                ,PARM-INTERCONNECT-DT                   
                                ,PARM-INVERTER-SYST-SIZE                
                                ,PARM-CONFIG-TYPE-CD                    
                                ,PARM-DER-STATUS-CD                     
                                ,PARM-DER-STATUS-CHG-DT                 
                                ,PARM-DER-CONTRCT-END-DT                
                                ,PARM-DER-OWNER-CD                      
                                ,PARM-INCENTIVE-ACCT-NO                 
                                ,PARM-USERID                            
                                ,PARM-PREM-PGM-START-DT                 
                                ,PARM-INCENTIVE-END-DT.                 
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE                THRU 0100-EXIT.       
           PERFORM 1000-PROCESS-INPUT             THRU 1000-EXIT.       
           PERFORM 2000-PROCESS-OUTPUT            THRU 2000-EXIT.       
           PERFORM 9999-END-PROGRAM               THRU 9999-EXIT.       
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
      *                                                                         
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
      *                                                                         
           PERFORM 0100A-DECLARE-GTT-R1           THRU 0100A-EXIT.      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT-R1                                           *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT-R1.                                            
      *                                                                         
           MOVE 'SESSION.CSR04914_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04914_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04914_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_RESULT_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS          THRU 8000A-EXIT       
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(BUS_RULE_ID))          AS BUS_RULE_ID       
                      ,LTRIM(RTRIM(BUS_RULE_RESULT_CD))   AS 
           BUS_RULE_RESULT_CD
                      ,LTRIM(RTRIM(BUS_RULE_XREF_ID))     AS 
           BUS_RULE_XREF_ID  
                  FROM #CSR04914_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(BUS_RULE_ID)          AS BUS_RULE_ID               
MFA-TR*               ,STRIP(BUS_RULE_RESULT_CD)   AS BUS_RULE_RESULT_CD        
MFA-TR*               ,STRIP(BUS_RULE_XREF_ID)     AS BUS_RULE_XREF_ID          
MFA-TR*           FROM SESSION.CSR04914_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *                                                                         
       0100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE PARM-UPDATE-TYPE         TO WS-PARM-TYPE.               
           IF PARM-DER-STATUS-CD EQUAL 'P'                              
              MOVE PARM-DER-STATUS-CD    TO WS-PARM-TYPE                
           END-IF                                                       
           PERFORM 1100-VALIDATE-INPUT             THRU 1100-EXIT.      
      *                                                                         
I02105     MOVE PARM-ACCOUNT-NO          TO AT-ACCOUNT-NO               
           MOVE PARM-PANEL-TYPE-CD       TO 6B-PANEL-TYPE-CD.           
           MOVE PARM-INVERTER-TYPE-CD    TO 6B-INVERTER-TYPE-CD.        
           MOVE PARM-INVERTER-SYST-SIZE  TO 6B-INVERTER-SYST-SIZE.      
           MOVE PARM-CONFIG-TYPE-CD      TO 6B-CONFIG-TYPE-CD.          
           MOVE PARM-DER-OWNER-CD        TO 6B-DER-OWNER-CD.            
           MOVE PARM-USERID              TO 6B-LAST-UPDATE-USERID.      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
I02105***************************************************************** *       
I02105* 1100-VALIDATE-INPUT                                           *         
I02105***************************************************************** *       
I02105*                                                                         
I02105 1100-VALIDATE-INPUT.                                             
I02105*                                                                         
I02105* VALIDATE PROGRAM TYPE CODE                                              
I02105*                                                                         
I02105     PERFORM 7100-GET-DER-CNT-END-DETAILS    THRU 7100-EXIT       
I02105     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
I02105        MOVE 6D-DER-PGM-TYPE-CD     TO 6B-DER-PGM-TYPE-CD         
I02105     ELSE                                                         
I02105         MOVE 5000                  TO WS-ACTIVE-RETURN-CODE      
I02105         PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT       
I02105     END-IF                                                       
I02105                                                                  
I02105     MOVE ZEROES                       TO 6B-INCENTIVE-ACCT-NO    
I02105* VALIDATE INCENTIVE ACCOUNT NO                                           
I02105     IF PARM-INCENTIVE-ACCT-NO > 0                                
I02105        MOVE PARM-INCENTIVE-ACCT-NO    TO AT-ACCOUNT-NO           
I02105        PERFORM 7200-VALIDATE-ACCOUNT-NO     THRU 7200-EXIT       
I02105        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
I02105           MOVE PARM-INCENTIVE-ACCT-NO TO 6B-INCENTIVE-ACCT-NO    
I02105        ELSE                                                      
I02105           MOVE 5100                   TO WS-ACTIVE-RETURN-CODE   
I02105           PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT       
I02105        END-IF                                                    
I02105     END-IF                                                       
I02105*                                                                         
I02105     IF PARM-ACCOUNT-NO > 0                                       
I02105        MOVE PARM-ACCOUNT-NO           TO AT-ACCOUNT-NO           
I02105        PERFORM 7200-VALIDATE-ACCOUNT-NO     THRU 7200-EXIT       
I02105        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
I02105           MOVE AT-PREMISE-NO          TO VO-PREMISE-NO           
I02105                                          6B-PREMISE-NO           
I02105        ELSE                                                      
I02105           MOVE 5200                   TO WS-ACTIVE-RETURN-CODE   
I02105           PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT       
I02105        END-IF                                                    
I02105     ELSE                                                         
I02105        MOVE 5200                      TO WS-ACTIVE-RETURN-CODE   
I02105        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
I02105     END-IF                                                       
I02105*                                                                         
I02105     IF WS-PARM-TYPE = WS-P                                       
I02105        MOVE SPACES                TO 6B-INTERCONNECT-DT          
I02105                                      6B-DER-CONTRCT-END-DT       
I02105                                      6B-PREM-PGM-START-DT        
I02105                                      6B-INCENTIVE-END-DT         
I02105                                      6B-DER-APPROVAL-DT          
I02105        MOVE -1                    TO WS-NULL-IND5                
I02105                                      WS-NULL-IND7                
I02105                                      WS-NULL-IND9                
I02105                                      WS-NULL-IND10               
I02105                                      WS-NULL-IND11               
I02105     END-IF.                                                      
I02105*                                                                         
I02105*                                                                         
I02105 1100-EXIT.                                                       
I02105     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
        2000-PROCESS-OUTPUT.                                            
      *                                                                         
I02105     PERFORM 7500-GET-CURRENT-DATE           THRU 7500-EXIT.      
I02105     MOVE WS-CURRENT-DATE          TO 6B-DER-STATUS-CHG-DT        
      *                                                                         
I02105     IF WS-PARM-TYPE = WS-P                                       
I02105        MOVE PARM-DER-STATUS-CD    TO 6B-DER-STATUS-CD            
I02105        PERFORM 7300-GET-SEQ-NO-PEND         THRU 7300-EXIT       
I02105        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
I02105           IF WS-NULL-IND12 < 0                                   
I02105              MOVE PARM-DER-SEQ-NO TO 6B-DER-SEQ-NO               
I02105           END-IF                                                 
I02105           PERFORM 8100-UPDATE-PREM-DER-DET  THRU 8100-EXIT       
I02105        ELSE                                                      
I02105           PERFORM 7400-GET-MAX-SEQ-NO       THRU 7400-EXIT       
I02105           COMPUTE WS-DER-SEQ-NO = WS-MAX-SEQ-NO + 1              
I02105           MOVE WS-DER-SEQ-NO      TO 6B-DER-SEQ-NO               
I02105           PERFORM 8200-INSERT-PERM-DER-DET  THRU 8200-EXIT       
I02105        END-IF                                                    
I02105     END-IF.                                                      
      *                                                                         
           PERFORM 8010-INSERT-GTT-R1              THRU 8010-EXIT.      
      *                                                                         
       2000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
I02105***************************************************************** *       
I02105* 7100-GET-DER-CNT-END-DETAILS                                  *         
I02105***************************************************************** *       
I02105*                                                                         
I02105 7100-GET-DER-CNT-END-DETAILS.                                    
I02105*                                                                         
I02105     EXEC SQL                                                     
I02105        SELECT TOP(1) DER_PGM_END_DT,
              DER_PGM_TYPE_CD                                    
I02105          INTO :6B-DER-CONTRCT-END-DT :WS-NULL-IND4                
I02105              ,:6D-DER-PGM-TYPE-CD                                
I02105          FROM CSS_DER_PROGRAM WITH(READUNCOMMITTED)                      
I02105         WHERE DER_PGM_TYPE_CD = :PARM-DER-PGM-TYPE-CD            
I02105                                              
I02105                                                           
I02105                                                      
I02105     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DER_PGM_END_DT                                             
MFA-TR*             ,DER_PGM_TYPE_CD                                            
MFA-TR*         INTO :6B-DER-CONTRCT-END-DT:WS-NULL-IND4                        
MFA-TR*             ,:6D-DER-PGM-TYPE-CD                                        
MFA-TR*         FROM CSS_DER_PROGRAM                                            
MFA-TR*        WHERE DER_PGM_TYPE_CD = :PARM-DER-PGM-TYPE-CD                    
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I02105                                                                  
I02105     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
I02105                                                                  
I02105     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
I02105        CONTINUE                                                  
I02105     ELSE                                                         
I02105         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
I02105         MOVE SQLSTATE             TO ABEND-SQLSTATE              
I02105         MOVE '7100'               TO ACTIVE-PARAGRAPH            
I02105         MOVE 'SELECT'             TO ABEND-FUNCTION              
I02105         MOVE 'CSS_DER_PROGRAM'    TO TABLE-1                     
I02105         MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1             
I02105         MOVE 6D-DER-PGM-TYPE-CD   TO HOSTVAR-ELEMENT-1           
I02105         PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT       
I02105     END-IF.                                                      
I02105*                                                                         
I02105 7100-EXIT.                                                       
I02105     EXIT.                                                        
I02105*                                                                         
I02105***************************************************************** *       
I02105* 7200-VALIDATE-ACCOUNT-NO                                                
I02105***************************************************************** *       
I02105*                                                                         
I02105 7200-VALIDATE-ACCOUNT-NO.                                        
I02105*                                                                         
I02105     EXEC SQL                                                     
I02105        SELECT AT.ACCOUNT_NO                                      
I02105              ,AT.PREMISE_NO                                      
I02105          INTO :AT-ACCOUNT-NO                                     
I02105              ,:AT-PREMISE-NO                                     
I02105          FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
I02105         WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
I02105                                                           
I02105                                                      
I02105     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.ACCOUNT_NO                                              
MFA-TR*             ,AT.PREMISE_NO                                              
MFA-TR*         INTO :AT-ACCOUNT-NO                                             
MFA-TR*             ,:AT-PREMISE-NO                                             
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I02105*                                                                         
I02105     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
I02105*                                                                         
I02105     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
I02105        CONTINUE                                                  
I02105     ELSE                                                         
I02105        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
I02105        MOVE '7200'                TO ACTIVE-PARAGRAPH            
I02105        MOVE 'SELECT'              TO ABEND-FUNCTION              
I02105        MOVE SPACES                TO ABEND-SQL-PREDICATES        
I02105                                      ABEND-TABLES                
I02105        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
I02105        MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
I02105        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
I02105     END-IF.                                                      
I02105*                                                                         
I02105 7200-EXIT.                                                       
I02105     EXIT.                                                        
I02105*                                                                         
I02105*****************************************************************         
I02105* 7300-GET-SEQ-NO-PEND                                         *          
I02105*  GETS THE LATEST DER_SEQ_NO AND INCREMENTS  BY 1            *           
I02105******************************************************************        
I02105*                                                                         
I02105 7300-GET-SEQ-NO-PEND.                                            
I02105                                                                  
I02105     EXEC SQL                                                     
I02105            SELECT DER_SEQ_NO                                     
I02105              INTO :6B-DER-SEQ-NO :WS-NULL-IND12                   
I02105              FROM CSS_PREM_DER_DET WITH(READUNCOMMITTED)                 
I02105             WHERE PREMISE_NO    = :6B-PREMISE-NO                 
I02105               AND DER_STATUS_CD = :WS-P                          
I02105                                                           
I02105     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*           SELECT DER_SEQ_NO                                             
MFA-TR*             INTO :6B-DER-SEQ-NO:WS-NULL-IND12                           
MFA-TR*             FROM CSS_PREM_DER_DET                                       
MFA-TR*            WHERE PREMISE_NO    = :6B-PREMISE-NO                         
MFA-TR*              AND DER_STATUS_CD = :WS-P                                  
MFA-TR*             WITH UR                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I02105     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
I02105                                         S-RETURN-CODE-1.         
I02105                                                                  
I02105     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
I02105        CONTINUE                                                  
I02105     ELSE                                                         
I02105        MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
I02105        MOVE '7300'                TO  ACTIVE-PARAGRAPH           
I02105        MOVE 'SELECT'              TO  ABEND-FUNCTION             
I02105        MOVE SPACES                TO  ABEND-SQL-PREDICATES       
I02105                                       ABEND-TABLES               
I02105        MOVE 'CSR04714_R1'         TO  TABLE-1                    
I02105        MOVE 'PREMISE-NO'          TO  TABLE-ELEMENT-1            
I02105        MOVE 6B-PREMISE-NO         TO  HOSTVAR-ELEMENT-1          
I02105        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
I02105     END-IF.                                                      
I02105*                                                                         
I02105 7300-EXIT.                                                       
I02105     EXIT.                                                        
I02105*                                                                         
I02105*****************************************************************         
I02105* 7400-GET-MAX-SEQ-NO                                          *          
I02105*   GETS THE LATEST DER_SEQ_NO AND INCREMENTS  BY 1            *          
I02105*****************************************************************         
I02105*                                                                         
I02105 7400-GET-MAX-SEQ-NO.                                             
I02105                                                                  
I02105     EXEC SQL                                                     
I02105            SELECT MAX(DER_SEQ_NO)                                
I02105              INTO :WS-MAX-SEQ-NO :WS-NULL-IND12                   
I02105              FROM CSS_PREM_DER_DET WITH(READUNCOMMITTED)                 
I02105             WHERE PREMISE_NO    = :6B-PREMISE-NO                 
I02105                                                           
I02105     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*           SELECT MAX(DER_SEQ_NO)                                        
MFA-TR*             INTO :WS-MAX-SEQ-NO:WS-NULL-IND12                           
MFA-TR*             FROM CSS_PREM_DER_DET                                       
MFA-TR*            WHERE PREMISE_NO    = :6B-PREMISE-NO                         
MFA-TR*             WITH UR                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I02105     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
I02105                                         S-RETURN-CODE-1.         
I02105                                                                  
I02105     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
I02105        CONTINUE                                                  
I02105     ELSE                                                         
I02105        MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
I02105        MOVE '7400'                TO  ACTIVE-PARAGRAPH           
I02105        MOVE 'SELECT'              TO  ABEND-FUNCTION             
I02105        MOVE SPACES                TO  ABEND-SQL-PREDICATES       
I02105                                       ABEND-TABLES               
I02105        MOVE 'CSR04714_R1'         TO  TABLE-1                    
I02105        MOVE 'PREMISE-NO'          TO  TABLE-ELEMENT-1            
I02105        MOVE 6B-PREMISE-NO         TO  HOSTVAR-ELEMENT-1          
I02105        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
I02105     END-IF.                                                      
I02105*                                                                         
I02105 7400-EXIT.                                                       
I02105     EXIT.                                                        
I02105*                                                                         
I02105***************************************************************** *       
I02105* 7500-GET-CURRENT-DATE                                         *         
I02105***************************************************************** *       
I02105*                                                                         
I02105 7500-GET-CURRENT-DATE.                                           
I02105*                                                                         
I02105     EXEC SQL                                                     
I02105          SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
I02105     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I02105                                                                  
I02105     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
I02105                                      S-RETURN-CODE-1             
I02105                                                                  
I02105     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
I02105        CONTINUE                                                  
I02105     ELSE                                                         
I02105        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
I02105        MOVE '7500'                TO ACTIVE-PARAGRAPH            
I02105        MOVE 'SELECT'              TO ABEND-FUNCTION              
I02105        MOVE 'CURRENT DATE'        TO TABLE-1                     
I02105        MOVE 'CURRENT_DATE'        TO TABLE-ELEMENT-1             
I02105        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
I02105     END-IF.                                                      
I02105*                                                                         
I02105 7500-EXIT.                                                       
I02105     EXIT.                                                        
I02105*                                                                         
      *****************************************************************         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *                                                               *         
      *****************************************************************         
      *                                                                         
       8000A-DEL-GTT-ROWS.                                              
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04914_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04914_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000A'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04914_R1'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT       
           END-EVALUATE.                                                
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8010-INSERT-GTT-R1.                                            *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       8010-INSERT-GTT-R1.                                              
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO #CSR04914_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,BUS_RULE_ID                                          
                  ,BUS_RULE_RESULT_CD                                   
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-1                                     
                  ,:S-APPL-RETURN-CODE-1                                
                  ,:S-RS1-BUS-RULE-ID                                   
                  ,:S-RS1-BUS-RULE-RESULT-CD                            
                  ,:S-RS1-BUS-RULE-XREF-ID                              
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04914_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,BUS_RULE_RESULT_CD                                           
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-1                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-1                                        
MFA-TR*           ,:S-RS1-BUS-RULE-ID                                           
MFA-TR*           ,:S-RS1-BUS-RULE-RESULT-CD                                    
MFA-TR*           ,:S-RS1-BUS-RULE-XREF-ID                                      
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS-RS1               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8010'                TO ACTIVE-PARAGRAPH            
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04914_R1'         TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                         
        8010-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8100-UPDATE-PREM-DER-DET.                                     **        
      *  THIS PARA UPDATES THE PREMISE DETAILS                        **        
      ******************************************************************        
       8100-UPDATE-PREM-DER-DET.                                        
      *                                                                         
           EXEC SQL                                                     
            UPDATE CSS_PREM_DER_DET                                     
              SET DER_PGM_TYPE_CD    = :6B-DER-PGM-TYPE-CD              
                 ,LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()                
                 ,LAST_UPDATE_USERID = :6B-LAST-UPDATE-USERID           
                 ,PREM_PGM_START_DT  = IIF(TRY_CONVERT(DATE, 
                                                 :6B-PREM-PGM-START-DT 
                                                         :WS-NULL-IND10
              ) IS NULL OR (PATINDEX('%.%', :6B-PREM-PGM-START-DT 
                                                         :WS-NULL-IND10
              ) <> 0) OR (LEN(:6B-PREM-PGM-START-DT :WS-NULL-IND10
              ) <> 10), CIS.CHAR2DATE(:6B-PREM-PGM-START-DT 
                                                         :WS-NULL-IND10
              ), CONVERT(DATE, :6B-PREM-PGM-START-DT :WS-NULL-IND10) )         
                 ,INCENTIVE_ACCT_NO  = :6B-INCENTIVE-ACCT-NO            
            WHERE PREMISE_NO         = :6B-PREMISE-NO                   
              AND  DER_SEQ_NO        = :6B-DER-SEQ-NO                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     UPDATE CSS_PREM_DER_DET                                             
MFA-TR*       SET DER_PGM_TYPE_CD    = :6B-DER-PGM-TYPE-CD                      
MFA-TR*          ,LAST_UPDATE_TS     = CURRENT TIMESTAMP                        
MFA-TR*          ,LAST_UPDATE_USERID = :6B-LAST-UPDATE-USERID                   
MFA-TR*          ,PREM_PGM_START_DT  = :6B-PREM-PGM-START-DT                    
MFA-TR*                                :WS-NULL-IND10                           
MFA-TR*          ,INCENTIVE_ACCT_NO  = :6B-INCENTIVE-ACCT-NO                    
MFA-TR*     WHERE PREMISE_NO         = :6B-PREMISE-NO                           
MFA-TR*       AND  DER_SEQ_NO        = :6B-DER-SEQ-NO                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8100'                  TO ACTIVE-PARAGRAPH         
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_PREM_DER_DET'      TO TABLE-1                  
               MOVE 'DER_SEQ_NO'            TO TABLE-ELEMENT-1          
               MOVE 'PREMISE-NO'            TO TABLE-ELEMENT-2          
               MOVE WS-SEQUENCE-NO          TO HOSTVAR-ELEMENT-1        
               MOVE WS-PREMISE-NO           TO HOSTVAR-ELEMENT-2        
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8200-INSERT-PERM-DER-DET                                       *        
      *      -- THIS PARA INSERTS NEW PREMISE DETAILS                  *        
      ******************************************************************        
      *                                                                         
       8200-INSERT-PERM-DER-DET.                                        
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO CSS_PREM_DER_DET                            
                            ( PREMISE_NO                                
                             ,DER_SEQ_NO                                
                             ,DER_PGM_TYPE_CD                           
                             ,DER_APPROVAL_DT                           
                             ,PANEL_TYPE_CD                             
                             ,INVERTER_TYPE_CD                          
                             ,INTERCONNECT_DT                           
                             ,INVERTER_SYST_SIZE                        
                             ,CONFIG_TYPE_CD                            
                             ,DER_STATUS_CD                             
                             ,DER_STATUS_CHG_DT                         
                             ,DER_CONTRCT_END_DT                        
                             ,DER_OWNER_CD                              
                             ,INCENTIVE_ACCT_NO                         
                             ,LAST_UPDATE_TS                            
                             ,LAST_UPDATE_USERID                        
                             ,PREM_PGM_START_DT                         
                             ,INCENTIVE_END_DT)                         
                     VALUES (                                           
                              :6B-PREMISE-NO                            
                             ,:6B-DER-SEQ-NO                            
                             ,:6B-DER-PGM-TYPE-CD                       
                             ,IIF(TRY_CONVERT(DATE, :6B-DER-APPROVAL-DT 
                                                    :WS-NULL-IND5
              ) IS NULL OR (PATINDEX('%.%', :6B-DER-APPROVAL-DT 
                                                          :WS-NULL-IND5
              ) <> 0) OR (LEN(:6B-DER-APPROVAL-DT :WS-NULL-IND5
              ) <> 10), CIS.CHAR2DATE(:6B-DER-APPROVAL-DT :WS-NULL-IND5
              ), CONVERT(DATE, :6B-DER-APPROVAL-DT :WS-NULL-IND5) )          
                             ,:6B-PANEL-TYPE-CD                         
                             ,:6B-INVERTER-TYPE-CD                      
                             ,IIF(TRY_CONVERT(DATE, :6B-INTERCONNECT-DT 
                                                    :WS-NULL-IND7
              ) IS NULL OR (PATINDEX('%.%', :6B-INTERCONNECT-DT 
                                                          :WS-NULL-IND7
              ) <> 0) OR (LEN(:6B-INTERCONNECT-DT :WS-NULL-IND7
              ) <> 10), CIS.CHAR2DATE(:6B-INTERCONNECT-DT :WS-NULL-IND7
              ), CONVERT(DATE, :6B-INTERCONNECT-DT :WS-NULL-IND7) )          
                             ,:6B-INVERTER-SYST-SIZE                    
                             ,:6B-CONFIG-TYPE-CD                        
                             ,:6B-DER-STATUS-CD                         
                             ,IIF(TRY_CONVERT(DATE, 
                                                 :6B-DER-STATUS-CHG-DT 
                                                    :WS-NULL-IND8
              ) IS NULL OR (PATINDEX('%.%', :6B-DER-STATUS-CHG-DT 
                                                          :WS-NULL-IND8
              ) <> 0) OR (LEN(:6B-DER-STATUS-CHG-DT :WS-NULL-IND8
              ) <> 10), CIS.CHAR2DATE(:6B-DER-STATUS-CHG-DT 
                                                          :WS-NULL-IND8
              ), CONVERT(DATE, :6B-DER-STATUS-CHG-DT :WS-NULL-IND8) )        
                             ,IIF(TRY_CONVERT(DATE, 
                                                :6B-DER-CONTRCT-END-DT 
                                                    :WS-NULL-IND9
              ) IS NULL OR (PATINDEX('%.%', :6B-DER-CONTRCT-END-DT 
                                                          :WS-NULL-IND9
              ) <> 0) OR (LEN(:6B-DER-CONTRCT-END-DT :WS-NULL-IND9
              ) <> 10), CIS.CHAR2DATE(:6B-DER-CONTRCT-END-DT 
                                                          :WS-NULL-IND9
              ), CONVERT(DATE, :6B-DER-CONTRCT-END-DT :WS-NULL-IND9) )       
                             ,:6B-DER-OWNER-CD                          
                             ,:6B-INCENTIVE-ACCT-NO                     
                             , CIS.CURRENT$TIMESTAMP()                        
                             ,:6B-LAST-UPDATE-USERID                    
                             ,IIF(TRY_CONVERT(DATE, 
                                                 :6B-PREM-PGM-START-DT 
                                                    :WS-NULL-IND10
              ) IS NULL OR (PATINDEX('%.%', :6B-PREM-PGM-START-DT 
                                                         :WS-NULL-IND10
              ) <> 0) OR (LEN(:6B-PREM-PGM-START-DT :WS-NULL-IND10
              ) <> 10), CIS.CHAR2DATE(:6B-PREM-PGM-START-DT 
                                                         :WS-NULL-IND10
              ), CONVERT(DATE, :6B-PREM-PGM-START-DT :WS-NULL-IND10) )       
                             ,IIF(TRY_CONVERT(DATE, 
                                                  :6B-INCENTIVE-END-DT 
                                                    :WS-NULL-IND11
              ) IS NULL OR (PATINDEX('%.%', :6B-INCENTIVE-END-DT 
                                                         :WS-NULL-IND11
              ) <> 0) OR (LEN(:6B-INCENTIVE-END-DT :WS-NULL-IND11
              ) <> 10), CIS.CHAR2DATE(:6B-INCENTIVE-END-DT 
                                                         :WS-NULL-IND11
              ), CONVERT(DATE, :6B-INCENTIVE-END-DT :WS-NULL-IND11) )        
                            )                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_PREM_DER_DET                                    
MFA-TR*                     ( PREMISE_NO                                        
MFA-TR*                      ,DER_SEQ_NO                                        
MFA-TR*                      ,DER_PGM_TYPE_CD                                   
MFA-TR*                      ,DER_APPROVAL_DT                                   
MFA-TR*                      ,PANEL_TYPE_CD                                     
MFA-TR*                      ,INVERTER_TYPE_CD                                  
MFA-TR*                      ,INTERCONNECT_DT                                   
MFA-TR*                      ,INVERTER_SYST_SIZE                                
MFA-TR*                      ,CONFIG_TYPE_CD                                    
MFA-TR*                      ,DER_STATUS_CD                                     
MFA-TR*                      ,DER_STATUS_CHG_DT                                 
MFA-TR*                      ,DER_CONTRCT_END_DT                                
MFA-TR*                      ,DER_OWNER_CD                                      
MFA-TR*                      ,INCENTIVE_ACCT_NO                                 
MFA-TR*                      ,LAST_UPDATE_TS                                    
MFA-TR*                      ,LAST_UPDATE_USERID                                
MFA-TR*                      ,PREM_PGM_START_DT                                 
MFA-TR*                      ,INCENTIVE_END_DT)                                 
MFA-TR*              VALUES (                                                   
MFA-TR*                       :6B-PREMISE-NO                                    
MFA-TR*                      ,:6B-DER-SEQ-NO                                    
MFA-TR*                      ,:6B-DER-PGM-TYPE-CD                               
MFA-TR*                      ,:6B-DER-APPROVAL-DT:WS-NULL-IND5                  
MFA-TR*                      ,:6B-PANEL-TYPE-CD                                 
MFA-TR*                      ,:6B-INVERTER-TYPE-CD                              
MFA-TR*                      ,:6B-INTERCONNECT-DT:WS-NULL-IND7                  
MFA-TR*                      ,:6B-INVERTER-SYST-SIZE                            
MFA-TR*                      ,:6B-CONFIG-TYPE-CD                                
MFA-TR*                      ,:6B-DER-STATUS-CD                                 
MFA-TR*                      ,:6B-DER-STATUS-CHG-DT:WS-NULL-IND8                
MFA-TR*                      ,:6B-DER-CONTRCT-END-DT:WS-NULL-IND9               
MFA-TR*                      ,:6B-DER-OWNER-CD                                  
MFA-TR*                      ,:6B-INCENTIVE-ACCT-NO                             
MFA-TR*                      , CURRENT TIMESTAMP                                
MFA-TR*                      ,:6B-LAST-UPDATE-USERID                            
MFA-TR*                      ,:6B-PREM-PGM-START-DT:WS-NULL-IND10               
MFA-TR*                      ,:6B-INCENTIVE-END-DT:WS-NULL-IND11                
MFA-TR*                     )                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8200'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                             ABEND-TABLES               
               MOVE 'CSS_PREM_DER_DET'   TO TABLE-1                     
               MOVE 'DER_SEQ_NO'         TO TABLE-ELEMENT-1             
               MOVE PARM-DER-SEQ-NO      TO HOSTVAR-ELEMENT-1           
               MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-2             
               MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2           
               PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT       
               PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
      *                                                                         
       8900-SEND-DONE.                                                  
      *                                                                         
                                                                        
           MOVE PROGRAM-NAME             TO ABEND-PROGRAM               
           MOVE '8900'                   TO ACTIVE-PARAGRAPH            
           MOVE 'OPEN'                   TO ABEND-FUNCTION              
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04914_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1.         
           MOVE WS-APPL-RETURN-CODE         TO S-APPL-RETURN-CODE-1.    
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1           THRU 0100A-EXIT.      
           PERFORM 8010-INSERT-GTT-R1             THRU 8010-EXIT.       
                                                                        
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
      *                                                                         
       9700-PROCESS-ABEND.                                              
      *                                                                         
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT         THRU 9000-EXIT.       
           PERFORM 9900-SQL-ERROR-ROUTINE         THRU 9900-EXIT.       
      *                                                                         
       9700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
      *                                                                         
                                                                        
           PERFORM 8900-SEND-DONE                THRU 8900-EXIT         
                                                                        
           
MSQ016        GOBACK.                                                    
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
