       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04913.                                         
COB303 DATE-WRITTEN.  JULY 2016.                                        
       DATE-COMPILED.                                                   
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *  THIS PROCEDURE IS USED TO POST MOD VOUCHER REIMBURSEMENTS.    *        
      *  AS THE PAYMENTS ARE POSTED USING THE GL ACCT NO OF THE AGENCY *        
      *  MAKING THE PAYMENT AND NO CUSTOMER ACCOUNT IS INVOLVED, CASH  *        
      *  JOURNAL FORMAT 201 IS USED.                                   *        
      *                                                                *        
      *  THIS IS A CLONE OF CSR02319                                   *        
      *                                                                *        
      *                                                                *        
      *  BUSOP NAME: REQUUPDVOUCHERREIMBURSEMENT BUSINESSOP            *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
PRJ586*  07/13/2016  CB18344  INITIAL VERSION OF MOD VOUCHER           *        
PRJ586*                       REIMBURSEMENT PROCESS                    *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04913'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04913 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
      *-- AL CSS_AR_LOCKOUT                                                     
           EXEC SQL                                                             
              INCLUDE TBARLOCK                                                  
           END-EXEC.                                                            
                                                                        
      *-- AR CSS_AR_TRANS_HIST                                                  
           EXEC SQL                                                             
              INCLUDE TBARHIST                                                  
           END-EXEC.                                                            
                                                                        
      *-- AU CSS_AR_TRN_HST_DET                                                 
           EXEC SQL                                                             
              INCLUDE TBARHDT                                                   
           END-EXEC.                                                            
                                                                        
      *-- CJ CSS_CSH_DRWR_JRNL                                                  
           EXEC SQL                                                             
              INCLUDE TBCDJRNL                                                  
           END-EXEC.                                                            
                                                                        
      *-- CS CSS_CSH_DRWR_CNTL                                                  
           EXEC SQL                                                             
              INCLUDE TBCDCNTL                                                  
           END-EXEC.                                                            
                                                                        
      *-- BC CSS_BCH_JRNL_CNTL                                                  
           EXEC SQL                                                             
              INCLUDE TBBJCNTL                                                  
           END-EXEC.                                                            
                                                                        
      *-- BJ CSS_BATCH_JRNL                                                     
           EXEC SQL                                                             
              INCLUDE TBBTJRNL                                                  
           END-EXEC.                                                            
                                                                        
      *-- GO CSS_GL_ACCT_NO                                                     
           EXEC SQL                                                             
              INCLUDE TBGLATNO                                                  
           END-EXEC.                                                            
                                                                        
      *-- I5 CSS_LIEAP_AGENCY                                                   
           EXEC SQL                                                             
              INCLUDE TBLIAGCY                                                  
           END-EXEC.                                                            
                                                                        
      *-- LI CSS_LIEAP                                                          
           EXEC SQL                                                             
              INCLUDE TBLIEAP                                                   
           END-EXEC.                                                            
                                                                        
      *-- MJ CSS_MISC_JRNL                                                      
           EXEC SQL                                                             
              INCLUDE TBMSJRNL                                                  
           END-EXEC.                                                            
                                                                        
      *-- PF CSS_USER_PROFILE                                                   
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      *-- COPYBOOK TO DECLARE JOURNAL VARIABLES AND CWS-13 VARIABLES            
           EXEC SQL                                                             
              INCLUDE CWS0013B                                                  
           END-EXEC.                                                            
                                                                        
      *-- COPYBOOK TO DECLARE WS VARIABLES FOR PAYMENT ROUTINE                  
           EXEC SQL                                                             
              INCLUDE CWS00017                                                  
           END-EXEC.                                                            
                                                                        
      *-- COPYBOOK TO DECLARE WS VARIABLES FOR GENERAL LEDGERS                  
           EXEC SQL                                                             
              INCLUDE CWS00061                                                  
           END-EXEC.                                                            
                                                                        
      *-- COPYBOOK TO DECLARE CHARGE OFF RECEIVABLES                            
           EXEC SQL                                                             
              INCLUDE CWS00073                                                  
           END-EXEC.                                                            
                                                                        
      *-- COPYBOOK FOR LINKAGE SECTION VARIABLES FOR SCSCO061                   
           EXEC SQL                                                             
              INCLUDE CWS0061L                                                  
           END-EXEC.                                                            
                                                                        
      *-- SQL COMMUNICATION AREA                                                
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *-- ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >                      
           COPY CWS00027.                                                       
      *-- SUPPORTS DB2 AND SQL ERROR CHECKING                                   
           COPY CWS00303.                                                       
           COPY CWS00100.                                                       
      *-- COPYBOOK TO DECLARE 101 JOURNAL VARIABLES                             
           COPY CJF00101.                                                       
                                                                        
      ******************************************************************        
      * WORKING STORAGE FOR JOURNALING                                 *        
      ******************************************************************        
                                                                        
       01  AR-TRANSACTION-STORAGE.                                      
           05  CURRENT-TIMESTAMP       PIC X(26).                       
           05  CURRENT-DATE            PIC X(10).                       
      *                                                                         
       01  WS-MISC.                                                     
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-SAVE-ROW-COUNT       PIC S9(04) COMP VALUE +0.        
           05  WS-DATE-ORIG-PYMT-IND   PIC S9(04) COMP VALUE +0.        
           05  WS-SUB                  PIC S9(04) COMP VALUE +0.        
           05  WS-CASH-DRAWER.                                          
               10  FILLER              PIC X(05) VALUE 'CASH '.         
               10  WS-CASH-DRAWER-ID   PIC X(01).                       
           05  WS-AMOUNT-LIHEAP        PIC X(11).                       
           05  WS-AMOUNT-LIHEAP-NUM REDEFINES WS-AMOUNT-LIHEAP          
                                       PIC 9(09)V99.                    
           05  WS-AMOUNT-LIHEAP-COMP3  PIC S9(09)V99 COMP-3 VALUE +0.   
           05  WS-COMPANY-NO           PIC X(02).                       
           05  WS-CURRENT1-DATE        PIC X(26) VALUE SPACES.          
           05  WS-CURRENT-DATE         PIC X(10) VALUE SPACES.          
           05  WS-CURRENT-TIMESTAMP    PIC X(26) VALUE SPACES.          
           05  WS-COMMENT-LEN          PIC 9(04) VALUE 0.               
           05  WS-COMMENT-LEN-NUM      PIC S9(04) COMP VALUE 0.         
           05  WS-COMMENT-TEXT         PIC X(25) VALUE SPACES.          
           05  WS-GL-ACCT-NO           PIC X(07) VALUE SPACES.          
           05  WS-GL-ACCT-NO-NUM  REDEFINES WS-GL-ACCT-NO               
                                       PIC 9(07).                       
           05  WS-GL-ACCT-DEBIT        PIC S9(03)V9(04) COMP-3 VALUE 0. 
           05  WS-LOCAL-OFFICE         PIC X(03) VALUE SPACES .         
           05  WS-EIBRESP              PIC S9(8) COMP SYNC VALUE ZERO.  
           05  WS-RCV-TYPE             PIC S9(04) COMP.                 
           05  WS-UPDATE-TYPE          PIC X(01) VALUE SPACES.          
           05  WS-LIHEAP-INFO.                                          
               10 WS-LIHEAP-COMPANY-NO PIC X(02).                       
               10 WS-LIHEAP-LOCAL-OFF  PIC X(03).                       
               10 WS-LIHEAP-AGENCY-ID  PIC X(05).                       
               10 WS-LIHEAP-GL-ACCT-NO PIC X(07).                       
      *                                                                         
       01  WS-LITERAL.                                                  
           05  WS-A                    PIC X(01) VALUE 'A'.             
           05  WS-C                    PIC X(01) VALUE 'C'.             
           05  WS-R                    PIC X(01) VALUE 'R'.             
           05  WS-U                    PIC X(01) VALUE 'U'.             
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04913'.      
           05  MCSCO061                PIC X(08) VALUE 'MCSCO061'.      
           05  WS-CHRG-OFF-ACCT        PIC X(01) VALUE 'N'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO-ERROR             PIC X(05) VALUE 'NOERR'.         
           05  WS-DEBIT                PIC X(01) VALUE 'D'.             
           05  WS-CREDIT               PIC X(01) VALUE 'C'.             
           05  WS-VALID-CO             PIC X(01) VALUE 'N'.             
           05  WS-SCEG                 PIC X(02) VALUE '01'.            
           05  WS-PSNC                 PIC X(02) VALUE '26'.            
      *                                                                         
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
      *                                                                         
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-ERROR-MESSAGE        PIC X(05) VALUE 'NOERR'.         
           05  RS-ADV-COLL-TIMESTAMP   PIC X(26) VALUE SPACES.          
           05  RS-ENTRY-NO             PIC S9(9) COMP VALUE 0.          
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
           05  S-ERROR-MESSAGE         PIC X(05) VALUE 'NOERR'.         
           05  S-ADV-COLL-TIMESTAMP    PIC X(26) VALUE SPACES.          
           05  S-ENTRY-NO              PIC S9(9) COMP VALUE 0.          
      *                                                                         
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
      *                                                                         
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
      *                                                                         
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
      *                                                                         
      *-- DECLARE ERROR HANDLING VARIABLES                                      
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18) VALUE SPACES.          
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)  VALUE ' '.             
           10  S-TABLE-NAME            PIC X(18) VALUE SPACES.          
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L PIC S9(4) USAGE COMP.            
               49  WS-ABEND-SQLERRMC-V PIC X(255).                      
           10  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
      *                                                                         
       LINKAGE SECTION.                                                 
       01  PARM-UPDATE-TYPE            PIC  X(01).                      
       01  PARM-COMPANY-NO             PIC  X(02).                      
       01  PARM-AMT-LIHEAP             PIC  X(11).                      
       01  PARM-USER-ID                PIC  X(07).                      
       01  PARM-CODE-AGENCY-ID         PIC  X(05).                      
       01  PARM-GL-ACCT-NO             PIC  X(07).                      
       01  PARM-CHECK-NO               PIC  X(09).                      
       01  PARM-DATE-CASH-REPORT       PIC  X(10).                      
       01  PARM-CASH-COMPANY-NO        PIC  X(02).                      
       01  PARM-CASH-LOCAL-OFFICE      PIC  X(03).                      
       01  PARM-CASH-DRAWER-ID         PIC  S9(04) COMP.                
       01  PARM-CASH-REPORT-NO         PIC  X(03).                      
       01  PARM-CURRENCY-TYPE          PIC  X(01) VALUE SPACES.         
       01  PARM-CODE-PYMT-FACILITY     PIC  X(01) VALUE SPACES.         
      *                                                                         
       PROCEDURE DIVISION USING                                         
                PARM-UPDATE-TYPE                                        
                PARM-COMPANY-NO                                         
                PARM-AMT-LIHEAP                                         
                PARM-USER-ID                                            
                PARM-CODE-AGENCY-ID                                     
                PARM-GL-ACCT-NO                                         
                PARM-CHECK-NO                                           
                PARM-DATE-CASH-REPORT                                   
                PARM-CASH-COMPANY-NO                                    
                PARM-CASH-LOCAL-OFFICE                                  
                PARM-CASH-DRAWER-ID                                     
                PARM-CASH-REPORT-NO                                     
                PARM-CURRENCY-TYPE                                      
                PARM-CODE-PYMT-FACILITY.                                
      *                                                                         
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
             SELECT                                                     
              :S-RETURN-CODE              AS    RETURN_CODE             
             ,:S-ERROR-MESSAGE            AS    ERROR_MESSAGE           
             ,:S-ADV-COLL-TIMESTAMP       AS    ADV_COLL_TIMESTAMP      
             ,:S-ENTRY-NO                 AS    ENTRY_NO                
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :S-RETURN-CODE              AS    RETURN_CODE                     
MFA-TR*      ,:S-ERROR-MESSAGE            AS    ERROR_MESSAGE                   
MFA-TR*      ,:S-ADV-COLL-TIMESTAMP       AS    ADV_COLL_TIMESTAMP              
MFA-TR*      ,:S-ENTRY-NO                 AS    ENTRY_NO                        
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE PARM-COMPANY-NO          TO WS-COMPANY-NO.              
           PERFORM 7200-GET-LOCAL-OFFICE THRU 7200-EXIT.                
           MOVE PARM-UPDATE-TYPE         TO WS-UPDATE-TYPE.             
           MOVE PARM-GL-ACCT-NO          TO WS-GL-ACCT-NO.              
                                                                        
      ******************************************************************        
      *    FOR MOD VOUCHER REIMBURSEMENTS, THE CHECK NUMBER IS STORED           
      *    IN THE METER NO FIELD ON THE CSS_CSH_DRWR_JRNL TABLE                 
      ******************************************************************        
                                                                        
           MOVE PARM-CHECK-NO            TO CJ-METER-NO.                
           IF WS-UPDATE-TYPE = WS-U                                     
              MOVE WS-COMPANY-NO         TO WS-LIHEAP-COMPANY-NO        
              MOVE WS-LOCAL-OFFICE       TO WS-LIHEAP-LOCAL-OFF         
              MOVE PARM-CODE-AGENCY-ID   TO WS-LIHEAP-AGENCY-ID         
              MOVE WS-GL-ACCT-NO         TO WS-LIHEAP-GL-ACCT-NO        
              MOVE +17                   TO CJ-TRAN-COMMENT-LEN         
              MOVE WS-LIHEAP-INFO        TO CJ-TRAN-COMMENT-TEXT        
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2200-BUILD-RESULT                                    *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEM BACK                                       *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
                                                                        
      ******************************************************************        
      * DO NOT PROCEED IF SYSTEM IS LOCKED                                      
      ******************************************************************        
                                                                        
           PERFORM 7999-SELECT-AL THRU 7999-SELECT-AL-EXIT.             
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
              MOVE 5000 TO RS-RETURN-CODE                               
              PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT  THRU 8100-EXIT                  
              PERFORM 9999-END-PROGRAM  THRU 9999-EXIT                  
           END-IF.                                                      
                                                                        
           PERFORM 2200-PROCESS THRU 2200-EXIT.                         
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2000A-MOVE-RESULT.                                            *         
      *****************************************************************         
      *                                                                         
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE  RS-RETURN-CODE           TO S-RETURN-CODE.             
           MOVE  RS-ERROR-MESSAGE         TO S-ERROR-MESSAGE.           
           MOVE  RS-ADV-COLL-TIMESTAMP    TO S-ADV-COLL-TIMESTAMP.      
           MOVE  RS-ENTRY-NO              TO S-ENTRY-NO.                
      *                                                                         
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-PROCESS                                                   *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
      *                                                                         
       2200-PROCESS.                                                    
      *                                                                         
           MOVE '2200'              TO ACTIVE-PARAGRAPH.                
                                                                        
      ******************************************************************        
      * MOVE NUMERIC FIELD AMONG WORKING STORAGE FIELDS BECAUSE THEY            
      * WERE PASSED AS CHARACTER, NOT NUMERIC.                                  
      ******************************************************************        
                                                                        
           MOVE PARM-AMT-LIHEAP        TO WS-AMOUNT-LIHEAP.             
           MOVE WS-AMOUNT-LIHEAP-NUM   TO WS-AMOUNT-LIHEAP-COMP3.       
           MOVE WS-AMOUNT-LIHEAP-COMP3 TO WS-AMT-LIHEAP.                
                                                                        
      ******************************************************************        
      * GET G/L ACCOUNT NUMBER                                         *        
      ******************************************************************        
                                                                        
           PERFORM 2205-LOAD-GL-NUMBERS THRU 2205-EXIT.                 
                                                                        
      ******************************************************************        
      * CREDIT CORRECT G/L ACCT NUMBER                                 *        
      ******************************************************************        
                                                                        
           COMPUTE                                                      
                     WS-GL-ACCT-DEBIT = WS-GL-ACCT-NO-NUM / 10000       
           END-COMPUTE.                                                 
           MOVE WS-GL-ACCT-DEBIT TO GO-GL-ACCT-NO.                      
           MOVE GO-GL-ACCT-NO TO WS-PAR-GEN-LEDG-DB.                    
           PERFORM 7000-GET-DATE THRU 7000-EXIT.                        
           IF WS-UPDATE-TYPE = WS-R                                     
              MOVE WS-YES TO CJ-REVERSED-FL                             
           END-IF.                                                      
           PERFORM 5000-UPDATE THRU 5000-EXIT.                          
                                                                        
           MOVE  WS-NO-ERROR TO RS-ERROR-MESSAGE.                       
                                                                        
           PERFORM 5750-JOURNAL-FORMAT-201-CREDIT THRU 5750-EXIT .      
                                                                        
      ******************************************************************        
      *    THE TWO WS-UPDATE-TYPE IF STATEMENTS WEREN'T COMBINED SO             
      *    THE REVERSED FLAG WOULD BE UPDATED ON BOTH THE PAYMENT               
      *    AND THE REVERSAL ROW ON THE MY DRAWER PAGE.                          
      ******************************************************************        
                                                                        
           IF WS-UPDATE-TYPE = 'R'                                      
              PERFORM 7100-UPDATE-REVERSED-FL THRU 7100-EXIT            
           END-IF.                                                      
           MOVE WS-JRNL-NO-ITEMS-CNTRL TO RS-ENTRY-NO.                  
           PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT.                   
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2205-LOAD-GL-NUMBERS                                           *        
      *     CALLED FROM 2200-PROCESS                                   *        
      *     LOAD ALL G/L NUMBERS INCLUDING CHARGE OFFS.                *        
      ******************************************************************        
      *                                                                         
       2205-LOAD-GL-NUMBERS.                                            
           PERFORM 9350-LINK-SCSCO061     THRU 9350-EXIT.               
      *                                                                         
           SET WS-GL-SUB TO 1.                                          
      *                                                                         
       2205-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5000-UPDATE                                                    *        
      *     CALLED FROM 2200-PROCESS                                   *        
      ******************************************************************        
      *                                                                         
       5000-UPDATE.                                                     
      *                                                                         
           MOVE '5000'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           MOVE WS-COMPANY-NO TO WS-100-COMPANY-NO.                     
                                                                        
      ******************************************************************        
      * THESE FIELDS WERE POPULATED BY CALLING CPD00020 (PARAGRAPH 5970)        
      * TO ACCESS APPLICATION TABLE 50.                                         
      ******************************************************************        
                                                                        
           MOVE 9             TO WS-TRAN-OPER-LEVEL.                    
           MOVE 1             TO WS-TRAN-OCAP-FIELD.                    
           MOVE 1             TO WS-TRAN-OCAP-VALUE.                    
           MOVE WS-C          TO WS-TRAN-JRNL-TYPE.                     
           MOVE WS-N          TO WS-TRAN-HOLD-EXEMPT-FLAG.              
                                                                        
      ******************************************************************        
      * THESE FIELDS WERE POPULATED BY CALLING CPD00021 (PARAGRAPH 5980)        
      * TO VERIFY USER-ID.                            *                         
      ******************************************************************        
                                                                        
           MOVE PARM-USER-ID       TO WS-JRNL-OL-TEMP-ID.               
           MOVE WS-JRNL-CK-OPER-ID TO WS-JRNL-OPERATION-RQST.           
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
           MOVE WS-JRNL-OL-OPR-LOC TO WS-TERM-LOC.                      
                                                                        
      ******************************************************************        
      * THESE FIELDS ARE REQUIRED FOR THE FIELD CASH SYSTEM                     
      ******************************************************************        
                                                                        
           MOVE PARM-CASH-COMPANY-NO   TO   WS-JRNL-OL-COMPANY.         
           MOVE PARM-CASH-LOCAL-OFFICE TO   WS-JRNL-OL-LOC-OFF.         
           MOVE PARM-CASH-REPORT-NO    TO   WS-JRNL-OL-REPORT-NO.       
           MOVE PARM-DATE-CASH-REPORT  TO   WS-JRNL-OL-REPORT-DT.       
           MOVE PARM-CASH-DRAWER-ID    TO   WS-JRNL-OL-CASH-DRWR.       
                                                                        
           MOVE WS-TERM-LOC                TO WS-JRNL-OL-TERM-LOC       
                                              WS-JRNL-OL-CASH-LOC       
                                              WS-JRNL-OL-OPR-LOC.       
           MOVE WS-JRNL-VALIDATE-OPER TO WS-JRNL-OPERATION-RQST.        
           MOVE WS-C                  TO WS-JRNL-SOURCE-CODE.           
           MOVE PARM-CODE-PYMT-FACILITY                                 
                                      TO WS-JRNL-CODE-PYMT-FACILITY.    
           IF CASH-TRANSACTION                                          
              MOVE WS-JRNL-CASH-UPDATE     TO WS-JRNL-OL-AUTH-TYPE      
           ELSE                                                         
              MOVE WS-JRNL-NON-CASH-UPDATE TO WS-JRNL-OL-AUTH-TYPE      
           END-IF.                                                      
           PERFORM 6400-ONLINE-JRNL-ROUTINE  THRU 6400-EXIT.            
                                                                        
           MOVE WS-A                   TO WS-100-JRNL-SORT-ID.          
           MOVE WS-COMPANY-NO          TO WS-100-COMPANY-NO.            
           MOVE 9999999999999          TO WS-100-ACCT-NO.               
           MOVE 9999999999             TO WS-100-CUSTOMER-NO.           
           MOVE 9999999999             TO WS-100-PREMISE-NO.            
           MOVE 'S319'                 TO WS-100-CODE-TERMINAL-TRAN.    
           ADD 1                       TO WS-100-JRNL-TRAN-APPL-NO.     
           MOVE WS-CURRENT-DATE        TO WS-100-DATE-LAST-ACTION.      
           MOVE 'C'                    TO WS-100-CODE-ENTRY-SOURCE.     
           MOVE WS-LOCAL-OFFICE        TO WS-100-LOCAL-OFFICE-CD        
                                          WS-JRNL-OL-CASH-LOC.          
           MOVE SPACES                 TO WS-100-TRANS-ERRORS.          
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CPD0006A                                                       *        
      *     6400-ONLINE-JRNL-ROUTINE                                   *        
      *     6415-SELECT-TERMOP.                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD0006A                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 5750-JOURNAL-FORMAT-201.                                       *        
      *     CALLED FROM 2200-PROCESS                                   *        
      *    -- THIS MODULE WRITES A FORMAT 201 JOURNAL                  *        
      ******************************************************************        
      *                                                                         
       5750-JOURNAL-FORMAT-201-CREDIT.                                  
      *                                                                         
           IF WS-UPDATE-TYPE = WS-U                                     
              MOVE GO-GL-ACCT-NO             TO WS-101-ACCT-GEN-LED-CR  
              MOVE WS-CLR-CASH-GL-NO (WS-GL-SUB)                        
                                             TO WS-101-ACCT-GEN-LED-DR  
           ELSE                                                         
              MOVE GO-GL-ACCT-NO             TO WS-101-ACCT-GEN-LED-DR  
              MOVE WS-CLR-CASH-GL-NO (WS-GL-SUB)                        
                                             TO WS-101-ACCT-GEN-LED-CR  
           END-IF.                                                      
                                                                        
           MOVE WS-101-ACCT-GEN-LED-DR TO WS-GEN-LED-NO-AR-TEST.        
           IF WS-101-ACCT-GEN-LED-DR EQUAL                              
                       WS-CLR-CASH-GL-NO (WS-GL-SUB)                    
              MOVE WS-AMOUNT-LIHEAP-COMP3   TO WS-JRNL-CASH-DEBIT-AMT   
           ELSE                                                         
              IF  WS-GEN-LED-ACCT-TEST EQUAL 142                        
              AND WS-GEN-LED-SUB-TEST < 4200                            
                  MOVE WS-AMOUNT-LIHEAP-COMP3 TO WS-JRNL-RCV-DEBIT-AMT  
              ELSE                                                      
                  MOVE WS-AMOUNT-LIHEAP-COMP3                           
                                            TO WS-JRNL-GEN-LEG-DEBIT-AMT
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE WS-101-ACCT-GEN-LED-CR TO WS-GEN-LED-NO-AR-TEST         
           IF WS-101-ACCT-GEN-LED-CR EQUAL                              
                       WS-CLR-CASH-GL-NO (WS-GL-SUB)                    
              MOVE WS-AMOUNT-LIHEAP-COMP3    TO WS-JRNL-CASH-CREDIT-AMT 
           ELSE                                                         
              IF  WS-GEN-LED-ACCT-TEST EQUAL 142                        
              AND WS-GEN-LED-SUB-TEST < 4200                            
                  MOVE WS-AMOUNT-LIHEAP-COMP3  TO WS-JRNL-RCV-CREDIT-AMT
              ELSE                                                      
                  MOVE WS-AMOUNT-LIHEAP-COMP3  TO                       
                                            WS-JRNL-GEN-LEG-CREDIT-AMT  
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE 101                     TO WS-101-JRNL-FORMAT-NO.       
                                                                        
           MOVE SPACES                  TO WS-101-CASH-DRAWER-USED.     
      *                                                                         
           MOVE WS-AMOUNT-LIHEAP-COMP3  TO WS-101-AMT-POSTED            
                                           WS-101-AMOUNT-ENTERED.       
           MOVE SPACES                  TO WS-101-AR-AGE.               
           MOVE WS-CURRENT-DATE         TO WS-101-DATE-AR-BILLED.       
           MOVE 0                       TO WS-101-ITEM-ID-NO.           
           MOVE 0                       TO WS-101-DETAIL-END-BAL.       
           MOVE 0                       TO WS-101-DETAIL-END-AR-BAL.    
           MOVE 0                       TO WS-101-ACCT-END-AR-BAL.      
           MOVE SPACES                  TO WS-101-FUNCTION-CODE.        
           MOVE SPACES                  TO WS-101-CODE-REVENUE-DISTRICT.
           MOVE SPACES                  TO WS-101-CODE-EMPL-ACCT.       
           MOVE SPACES                  TO WS-101-CODE-COMPANY-ACCT.    
           MOVE SPACES                  TO WS-101-CODE-ACCOUNT-STATUS.  
           MOVE SPACES                  TO WS-101-CODE-PREMISE-STATUS.  
                                                                        
      ******************************************************************        
      * POPULATE CWS0013B VARIABLES.                                            
      ******************************************************************        
                                                                        
           MOVE PARM-CODE-PYMT-FACILITY TO WS-JRNL-CODE-PYMT-FACILITY.  
           MOVE CJF00101                TO WS-100-USER-DEFINED-AREA.    
                                                                        
           IF WS-COMPANY-NO = WS-PSNC                                   
              MOVE '298' TO WS-100-LOCAL-OFFICE-CD                      
           ELSE                                                         
              MOVE '998' TO WS-100-LOCAL-OFFICE-CD                      
           END-IF.                                                      
                                                                        
           MOVE WS-A                   TO WS-100-JRNL-SORT-ID.          
                                                                        
           MOVE WS-JRNL-ONLY           TO WS-JRNL-OPERATION-RQST.       
           MOVE PARM-CURRENCY-TYPE     TO WS-JRNL-CURRENCY-TYPE.        
                                                                        
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
                                                                        
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
           MOVE WS-JRNL-CNTRL-ONLY     TO WS-JRNL-OPERATION-RQST.       
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
                                                                        
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       5750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7000-GET-DATE                                                  *        
      *     CALLED FROM 2200-PROCESS                                   *        
      ******************************************************************        
      *                                                                         
       7000-GET-DATE.                                                   
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE WS-CURRENT-TIMESTAMP  TO RS-ADV-COLL-TIMESTAMP.         
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-UPDATE-REVERSED-FL                                        *        
      *     CALLED FROM 2200-PROCESS                                   *        
      * UPDATES REVERSED FLAG ON CSS_CSH_DRWR_JRNL ROWS                *        
      ******************************************************************        
      *                                                                         
       7100-UPDATE-REVERSED-FL.                                         
      *                                                                         
      ******************************************************************        
      *    FOR MOD VOUCHER REIMBURSEMENTS, THE CHECK NUMBER IS STORED           
      *    IN THE METER NO FIELD ON THE CSS_CSH_DRWR_JRNL TABLE                 
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
             UPDATE CSS_CSH_DRWR_JRNL                                   
                SET REVERSED_FL = 'Y'                                   
              WHERE CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO             
                AND CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE           
                AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )            
                AND CASH_DRAWER_ID    = :CS-CASH-DRAWER-ID              
                AND METER_NO          = :CJ-METER-NO                    
                AND (CIS.SUBSTR3(TRAN_COMMENT,1,2)) = :PARM-COMPANY-NO       
                AND (CIS.SUBSTR3(TRAN_COMMENT,3,3)) = :WS-LOCAL-OFFICE       
                AND (CIS.SUBSTR3(TRAN_COMMENT,6,5)) = 
                                                   :PARM-CODE-AGENCY-ID   
                AND (CIS.SUBSTR3(TRAN_COMMENT,11,7)) = :PARM-GL-ACCT-NO      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_CSH_DRWR_JRNL                                           
MFA-TR*         SET REVERSED_FL = 'Y'                                           
MFA-TR*       WHERE CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO                     
MFA-TR*         AND CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE                   
MFA-TR*         AND DATE_CASH_REPORT  = :CS-DATE-CASH-REPORT                    
MFA-TR*         AND CASH_DRAWER_ID    = :CS-CASH-DRAWER-ID                      
MFA-TR*         AND METER_NO          = :CJ-METER-NO                            
MFA-TR*         AND (SUBSTR(TRAN_COMMENT,1,2)) = :PARM-COMPANY-NO               
MFA-TR*         AND (SUBSTR(TRAN_COMMENT,3,3)) = :WS-LOCAL-OFFICE               
MFA-TR*         AND (SUBSTR(TRAN_COMMENT,6,5)) = :PARM-CODE-AGENCY-ID           
MFA-TR*         AND (SUBSTR(TRAN_COMMENT,11,7)) = :PARM-GL-ACCT-NO              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_CSH_DRWR_JRNL'   TO TABLE-1                     
              MOVE 'CASH_LOCAL_OFFICE'   TO TABLE-ELEMENT-1             
              MOVE 'DATE_CASH_REPORT'    TO TABLE-ELEMENT-2             
              MOVE 'CASH_DRAWER_ID'      TO TABLE-ELEMENT-3             
              MOVE 'METER_NO'            TO TABLE-ELEMENT-4             
              MOVE CS-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-1           
              MOVE CS-DATE-CASH-REPORT   TO HOSTVAR-ELEMENT-2           
              MOVE CS-CASH-DRAWER-ID     TO HOSTVAR-ELEMENT-3           
              MOVE CJ-METER-NO           TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-GET-LOCAL-OFFICE                                          *        
      ******************************************************************        
      *                                                                         
       7200-GET-LOCAL-OFFICE.                                           
                                                                        
           MOVE '7200' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               SELECT LOCAL_OFFICE                                      
                 INTO :WS-LOCAL-OFFICE                                  
                 FROM CSS_LIEAP_AGENCY WITH(READUNCOMMITTED)                    
                WHERE CODE_AGENCY_ID    = :PARM-CODE-AGENCY-ID          
                                                                 
                                                            
              END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LOCAL_OFFICE                                              
MFA-TR*          INTO :WS-LOCAL-OFFICE                                          
MFA-TR*          FROM CSS_LIEAP_AGENCY                                          
MFA-TR*         WHERE CODE_AGENCY_ID    = :PARM-CODE-AGENCY-ID                  
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                    
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE 'SELECT'             TO ABEND-FUNCTION            
                 MOVE 'CSS_LIEAP_AGENCY'   TO TABLE-1                   
                 MOVE 'CODE_AGENCY_ID'     TO TABLE-ELEMENT-2           
                 MOVE PARM-CODE-AGENCY-ID  TO HOSTVAR-ELEMENT-2         
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF.                                                   
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7999-SELECT-AL                                                 *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00075                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9350-LINK-SCSCO061.                                            *        
      *     CALLED FROM 2205-LOAD-GL-NUMBERS                           *        
      * LOADING GL NUMBERS - CALLS THE SUBPROGRAM SCSCO061             *        
      ******************************************************************        
      *                                                                         
       9350-LINK-SCSCO061.                                              
      *                                                                         
           MOVE SPACES                        TO ABEND-FUNCTION.        
           PERFORM 9400-CALL-CPD00061         THRU 9400-EXIT.           
           MOVE RS-RETURN-CODE                TO WS-ACTIVE-RETURN-CODE  
                                                 SQLCODE.               
           IF ABEND-FUNCTION  > SPACES                                  
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       9350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9400-CALL-CPD00061 - CALLS THE COPYBOOK CPD00061               *        
      *     CALLED FROM 9350-LINK-SCSCO061                             *        
      ******************************************************************        
      *                                                                         
       9400-CALL-CPD00061.                                              
      *                                                                         
           CALL MCSCO061  USING  WS-GL-ACCT-NAME                        
                                 WS-GL-ACCT-MAJOR-FIELDS                
                                 WS-VALID-COMPANY-NOS                   
                                 WS-GL-NAME-INFO                        
                                 WS-GL-ACCT-NO-TABLE                    
                                 ABEND-FILE                             
                                 RS-RETURN-CODE.                        
           MOVE RS-RETURN-CODE            TO WS-ACTIVE-RETURN-CODE      
                                             S-RETURN-CODE.             
           IF ABEND-FUNCTION  > SPACES                                  
              IF ABEND-FUNCTION EQUAL 'BADDATA'                         
                 MOVE -1                  TO RS-RETURN-CODE             
                                             WS-ACTIVE-RETURN-CODE      
              END-IF                                                    
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
              PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
           END-IF.                                                      
      *                                                                         
       9400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      * CPD0023C                                                       *        
      *     9700-PROCESS-AGEND                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
      *                                                                         
       8100-SEND-RESULT.                                                
      *                                                                         
             ADD 1 TO CTR-ROWS.                                         
      *                                                                         
       8100-EXIT.                                                       
              EXIT.                                                     
      *                                                                         
      ******************************************************************        
      * 8900-SEND-DONE                                                 *        
      * 9000-SEND-ERROR-RESULT                                         *        
      * 9999-END-PROGRAM                                               *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00321                                                 
           END-EXEC.                                                            
