       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04912.                                          
COB303 DATE-WRITTEN.     MAY 23,2016.                                   
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      ***              SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES DETAILS FROM CSS_DER_PROGRAM,          *        
      *  CSS_PREM_DER_DET TABLE FOR THE PREMISE.                       *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   -----------------------------------------*        
I02104*  05/23/16  VK7L032    INITIALLY CODED.                         *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04912'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04912 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBDPROG                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBPRDERD                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *--------< ERROR HANDLING >                                               
      *    COPY CWS00010.                                                       
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
                                                                        
       01  WS-MISC.                                                     
           05 PROGRAM-NAME            PIC X(08) VALUE 'CSR04912'.       
           05 WS-GTT-NAME             PIC X(19) VALUE SPACES.           
           05 WS-SQLSTATE             PIC X(05) VALUE SPACES.           
           05 WS-NULL-IND-1           PIC S9(04) COMP VALUE 0.          
           05 WS-NULL-IND-2           PIC S9(04) COMP VALUE 0.          
           05 WS-NULL-IND-3           PIC S9(04) COMP VALUE 0.          
           05 WS-NULL-IND-4           PIC S9(04) COMP VALUE 0.          
           05 WS-NULL-IND-5           PIC S9(04) COMP VALUE 0.          
           05 WS-NULL-IND-6           PIC S9(04) COMP VALUE 0.          
       01  GTT-MISC-FIELDS-1.                                           
           05  GTT-NAME-1             PIC X(26)                         
                                      VALUE 'SESSION.CSR04912_R1'.      
           05  GTT-ROW-1.                                               
               49 GTT-ROW-LEN-1       PIC S9(04) COMP.                  
               49 GTT-ROW-CHAR-1      PIC X(1024).                      
           05  GTT-SQLCODE-1          PIC S9(09) COMP.                  
      *                                                                         
       01  GTT-MISC-FIELDS-2.                                           
           05  GTT-NAME-2             PIC X(26)                         
                                      VALUE 'SESSION.CSR04912_R2'.      
           05  GTT-ROW-2.                                               
               49 GTT-ROW-LEN-2       PIC S9(04) COMP.                  
               49 GTT-ROW-CHAR-2      PIC X(1024).                      
           05  GTT-SQLCODE-2          PIC S9(9) COMP.                   
      *                                                                         
           05  SEND-DONE-SW           PIC X(01) VALUE 'Y'.              
               88 SEND-DONE-ERROR               VALUE 'N'.              
               88 SEND-DONE-OK                  VALUE 'Y'.              
      *                                                                         
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC               PIC S9(9) COMP.                   
           05  SNA-CONNECTION-NAME    PIC X(8)  VALUE SPACES.           
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN             PIC S9(9) COMP VALUE 1.           
           05  CTR-ROWS-1             PIC S9(9) COMP VALUE 0.           
           05  CTR-ROWS-2             PIC S9(9) COMP VALUE 0.           
           05  WS-ROW-COUNT           PIC S9(9) COMP VALUE 0.           
      *                                                                         
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
      *                                                                         
       01  TDS-RETURN-FIELDS-1.                                         
           05 RS1-RETURN-CODE         PIC S9(9) COMP VALUE 0.           
COB305     05 RS1-PREMISE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.         
           05 RS1-DER-SEQ-NO          PIC S9(4) USAGE COMP.             
           05 RS1-DER-PGM-TYPE-CD     PIC X(5).                         
           05 RS1-DER-APPROVAL-DT     PIC X(10).                        
           05 RS1-PANEL-TYPE-CD       PIC X(2).                         
           05 RS1-INVERTER-TYPE-CD    PIC X(2).                         
           05 RS1-INTERCONNECT-DT     PIC X(10).                        
COB305     05 RS1-INVERTER-SYST-SIZE        PIC S9(4)V9(3) USAGE COMP-3 
COB305       VALUE 0.      
           05 RS1-CONFIG-TYPE-CD      PIC X(2).                         
           05 RS1-DER-STATUS-CD       PIC X(1).                         
           05 RS1-DER-STATUS-CHG-DT   PIC X(10).                        
           05 RS1-DER-CONTRCT-END-DT  PIC X(10).                        
           05 RS1-DER-OWNER-CD        PIC X(2).                         
COB305     05 RS1-INCENTIVE-ACCT-NO        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.         
           05 RS1-DER-PGM-START-DT    PIC X(10).                        
           05 RS1-DER-PGM-END-DT      PIC X(10).                        
           05 RS1-DER-PGM-TYPE-DESC   PIC X(50).                        
           05 RS1-BCA-ELIGIBLE-FL     PIC X(1).                         
           05 RS1-PBI-ELIGIBLE-FL     PIC X(1).                         
           05 RS1-PREM-PGM-START-DT   PIC X(10).                        
           05 RS1-INCENTIVE-END-DT    PIC X(10).                        
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05 GTT-RETURN-FIELDS-1.                                      
              10 S1-RETURN-CODE        PIC S9(9) COMP VALUE 0.          
COB305        10 S1-PREMISE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.        
              10 S1-DER-SEQ-NO         PIC S9(4) USAGE COMP.            
              10 S1-DER-PGM-TYPE-CD    PIC X(5).                        
              10 S1-DER-APPROVAL-DT    PIC X(10).                       
              10 S1-PANEL-TYPE-CD      PIC X(2).                        
              10 S1-INVERTER-TYPE-CD   PIC X(2).                        
              10 S1-INTERCONNECT-DT    PIC X(10).                       
COB305        10 S1-INVERTER-SYST-SIZE        PIC S9(4)V9(3) 
COB305           USAGE COMP-3 VALUE 0.     
              10 S1-CONFIG-TYPE-CD     PIC X(2).                        
              10 S1-DER-STATUS-CD      PIC X(1).                        
              10 S1-DER-STATUS-CHG-DT  PIC X(10).                       
              10 S1-DER-CONTRCT-END-DT PIC X(10).                       
              10 S1-DER-OWNER-CD       PIC X(2).                        
COB305        10 S1-INCENTIVE-ACCT-NO        PIC S9(13)V USAGE COMP-3 
COB305           VALUE 0.        
              10 S1-DER-PGM-START-DT   PIC X(10).                       
              10 S1-DER-PGM-END-DT     PIC X(10).                       
              10 S1-DER-PGM-TYPE-DESC  PIC X(50).                       
              10 S1-BCA-ELIGIBLE-FL    PIC X(1).                        
              10 S1-PBI-ELIGIBLE-FL    PIC X(1).                        
              10 S1-PREM-PGM-START-DT  PIC X(10).                       
              10 S1-INCENTIVE-END-DT   PIC X(10).                       
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
           10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
      *                                                                         
       01  PARM-FIELDS.                                                 
           05  PARM-PREMISE-NO-TEMP    PIC X(10).                       
           05  PARM-PREMISE-NO-NUM     REDEFINES PARM-PREMISE-NO-TEMP   
                                       PIC 9(10).                       
      ******************************************************************01014000
      *  CURSOR DECLARATION FOR THE CSS_PREM_DER_DET TABLE.            *01016000
      ******************************************************************01020000
           EXEC SQL                                                     
            DECLARE PREM_CSR CURSOR FOR                                 
             SELECT [6B].PREMISE_NO                                       
                   ,[6B].DER_SEQ_NO                                       
                   ,[6B].DER_PGM_TYPE_CD                                  
                   ,[6B].DER_APPROVAL_DT                                  
                   ,[6B].PANEL_TYPE_CD                                    
                   ,[6B].INVERTER_TYPE_CD                                 
                   ,[6B].INTERCONNECT_DT                                  
                   ,[6B].INVERTER_SYST_SIZE                               
                   ,[6B].CONFIG_TYPE_CD                                   
                   ,[6B].DER_STATUS_CD                                    
                   ,[6B].DER_STATUS_CHG_DT                                
                   ,[6B].DER_CONTRCT_END_DT                               
                   ,[6B].DER_OWNER_CD                                     
                   ,[6B].INCENTIVE_ACCT_NO                                
                   ,[6B].PREM_PGM_START_DT                                
                   ,[6B].INCENTIVE_END_DT                                 
                   ,[6D].DER_PGM_START_DT                                 
                   ,[6D].DER_PGM_END_DT                                   
                   ,[6D].DER_PGM_TYPE_DESC                                
                   ,[6D].BCA_ELIGIBLE_FL                                  
                   ,[6D].PBI_ELIGIBLE_FL                                  
               FROM CSS_PREM_DER_DET [6B] WITH(READUNCOMMITTED)                 
                   ,CSS_DER_PROGRAM  [6D] WITH(READUNCOMMITTED)                 
              WHERE PREMISE_NO = :6B-PREMISE-NO                         
                AND [6B].DER_PGM_TYPE_CD = [6D].DER_PGM_TYPE_CD             
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                     01021000
MFA-TR*     DECLARE PREM_CSR CURSOR FOR                                 01022000
MFA-TR*      SELECT 6B.PREMISE_NO                                               
MFA-TR*            ,6B.DER_SEQ_NO                                               
MFA-TR*            ,6B.DER_PGM_TYPE_CD                                          
MFA-TR*            ,6B.DER_APPROVAL_DT                                          
MFA-TR*            ,6B.PANEL_TYPE_CD                                            
MFA-TR*            ,6B.INVERTER_TYPE_CD                                         
MFA-TR*            ,6B.INTERCONNECT_DT                                          
MFA-TR*            ,6B.INVERTER_SYST_SIZE                                       
MFA-TR*            ,6B.CONFIG_TYPE_CD                                           
MFA-TR*            ,6B.DER_STATUS_CD                                            
MFA-TR*            ,6B.DER_STATUS_CHG_DT                                        
MFA-TR*            ,6B.DER_CONTRCT_END_DT                                       
MFA-TR*            ,6B.DER_OWNER_CD                                             
MFA-TR*            ,6B.INCENTIVE_ACCT_NO                                        
MFA-TR*            ,6B.PREM_PGM_START_DT                                        
MFA-TR*            ,6B.INCENTIVE_END_DT                                         
MFA-TR*            ,6D.DER_PGM_START_DT                                         
MFA-TR*            ,6D.DER_PGM_END_DT                                           
MFA-TR*            ,6D.DER_PGM_TYPE_DESC                                        
MFA-TR*            ,6D.BCA_ELIGIBLE_FL                                          
MFA-TR*            ,6D.PBI_ELIGIBLE_FL                                          
MFA-TR*        FROM CSS_PREM_DER_DET 6B                                         
MFA-TR*            ,CSS_DER_PROGRAM  6D                                         
MFA-TR*       WHERE PREMISE_NO = :6B-PREMISE-NO                                 
MFA-TR*         AND 6B.DER_PGM_TYPE_CD = 6D.DER_PGM_TYPE_CD                     
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
HPCCDM*    EJECT                                                        02620001
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01 PARM-PREMISE-NO           PIC X(10).                          
      *                                                                         
       PROCEDURE DIVISION USING  PARM-PREMISE-NO.                       
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
           EXEC SQL                                                     
                DECLARE C1 CURSOR  FOR                       
                SELECT                                                  
                      RETURN_CODE                                       
                     ,PREMISE_NO                                        
                     ,DER_SEQ_NO                                        
                     ,DER_PGM_TYPE_CD                                   
                     ,DER_APPROVAL_DT                                   
                     ,PANEL_TYPE_CD                                     
                     ,INVERTER_TYPE_CD                                  
                     ,INTERCONNECT_DT                                   
                     ,INVERTER_SYST_SIZE                                
                     ,CONFIG_TYPE_CD                                    
                     ,DER_STATUS_CD                                     
                     ,DER_STATUS_CHG_DT                                 
                     ,DER_CONTRCT_END_DT                                
                     ,DER_OWNER_CD                                      
                     ,INCENTIVE_ACCT_NO                                 
                     ,PREM_PGM_START_DT                                 
                     ,INCENTIVE_END_DT                                  
                     ,DER_PGM_START_DT                                  
                     ,DER_PGM_END_DT                                    
                     ,DER_PGM_TYPE_DESC                                 
                     ,BCA_ELIGIBLE_FL                                   
                     ,PBI_ELIGIBLE_FL                                   
                FROM                                                    
                     #CSR04912_R1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*               RETURN_CODE                                               
MFA-TR*              ,PREMISE_NO                                                
MFA-TR*              ,DER_SEQ_NO                                                
MFA-TR*              ,DER_PGM_TYPE_CD                                           
MFA-TR*              ,DER_APPROVAL_DT                                           
MFA-TR*              ,PANEL_TYPE_CD                                             
MFA-TR*              ,INVERTER_TYPE_CD                                          
MFA-TR*              ,INTERCONNECT_DT                                           
MFA-TR*              ,INVERTER_SYST_SIZE                                        
MFA-TR*              ,CONFIG_TYPE_CD                                            
MFA-TR*              ,DER_STATUS_CD                                             
MFA-TR*              ,DER_STATUS_CHG_DT                                         
MFA-TR*              ,DER_CONTRCT_END_DT                                        
MFA-TR*              ,DER_OWNER_CD                                              
MFA-TR*              ,INCENTIVE_ACCT_NO                                         
MFA-TR*              ,PREM_PGM_START_DT                                         
MFA-TR*              ,INCENTIVE_END_DT                                          
MFA-TR*              ,DER_PGM_START_DT                                          
MFA-TR*              ,DER_PGM_END_DT                                            
MFA-TR*              ,DER_PGM_TYPE_DESC                                         
MFA-TR*              ,BCA_ELIGIBLE_FL                                           
MFA-TR*              ,PBI_ELIGIBLE_FL                                           
MFA-TR*         FROM                                                            
MFA-TR*              SESSION.CSR04912_R1                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
      *                                                                         
           MOVE 'SESSION.CSR04912_R1'     TO WS-GTT-NAME.               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04912_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04912_R1
              (                                                       
                     RETURN_CODE         INT                        
                    ,PREMISE_NO          DECIMAL(10,0)                 
                    ,DER_SEQ_NO          SMALLINT                       
                    ,DER_PGM_TYPE_CD CHAR(5)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                    ,DER_APPROVAL_DT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                    ,PANEL_TYPE_CD CHAR(2)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                    ,INVERTER_TYPE_CD CHAR(2)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                    ,INTERCONNECT_DT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                    ,INVERTER_SYST_SIZE  DECIMAL(7,3)                  
                    ,CONFIG_TYPE_CD CHAR(2)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                    ,DER_STATUS_CD CHAR(1)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                    ,DER_STATUS_CHG_DT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                    ,DER_CONTRCT_END_DT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                    ,DER_OWNER_CD CHAR(2)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                    ,INCENTIVE_ACCT_NO   DECIMAL(13,0)                 
                    ,PREM_PGM_START_DT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                    ,INCENTIVE_END_DT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                    ,DER_PGM_START_DT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                    ,DER_PGM_END_DT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                    ,DER_PGM_TYPE_DESC CHAR(50)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                    ,BCA_ELIGIBLE_FL CHAR(1)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                    ,PBI_ELIGIBLE_FL CHAR(1)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
               PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT            
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                      NEXT SENTENCE                                     
               ELSE                                                     
                  MOVE PROGRAM-NAME      TO ABEND-PROGRAM               
                  MOVE SQLCODE           TO ABEND-SQLCODE               
                  MOVE SQLSTATE          TO ABEND-SQLSTATE              
                  MOVE '0100A'           TO ACTIVE-PARAGRAPH            
                  MOVE 'DECLARE GTT'     TO ABEND-FUNCTION              
                  MOVE SPACES            TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                  MOVE 'CSR04912_R1'     TO TABLE-1                     
                  MOVE SPACES            TO TABLE-ELEMENT-1             
                  MOVE SPACES            TO HOSTVAR-ELEMENT-1           
                  PERFORM 9900-SQL-ERROR-ROUTINE                        
                                          THRU  9900-EXIT               
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       0100A-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLS 1100-RECEIVE-PARMS                                   *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000'                    TO ACTIVE-PARAGRAPH.          
           MOVE PARM-PREMISE-NO           TO PARM-PREMISE-NO-TEMP.      
           INITIALIZE TDS-RETURN-FIELDS-1.                              
           PERFORM 2100-BUILD-RESULT-DATA        THRU 2100-EXIT.        
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2000A-MOVE-RESULT                                               *        
      ******************************************************************        
      *                                                                         
       2000A-MOVE-RESULT.                                               
      *                                                                         
            MOVE RS1-RETURN-CODE          TO S1-RETURN-CODE.            
            MOVE RS1-PREMISE-NO           TO S1-PREMISE-NO.             
            MOVE RS1-DER-SEQ-NO           TO S1-DER-SEQ-NO.             
            MOVE RS1-DER-PGM-TYPE-CD      TO S1-DER-PGM-TYPE-CD.        
            MOVE RS1-DER-APPROVAL-DT      TO S1-DER-APPROVAL-DT.        
            MOVE RS1-PANEL-TYPE-CD        TO S1-PANEL-TYPE-CD.          
            MOVE RS1-INVERTER-TYPE-CD     TO S1-INVERTER-TYPE-CD.       
            MOVE RS1-INTERCONNECT-DT      TO S1-INTERCONNECT-DT.        
            MOVE RS1-INVERTER-SYST-SIZE   TO S1-INVERTER-SYST-SIZE.     
            MOVE RS1-CONFIG-TYPE-CD       TO S1-CONFIG-TYPE-CD.         
            MOVE RS1-DER-STATUS-CD        TO S1-DER-STATUS-CD.          
            MOVE RS1-DER-STATUS-CHG-DT    TO S1-DER-STATUS-CHG-DT.      
            MOVE RS1-DER-CONTRCT-END-DT   TO S1-DER-CONTRCT-END-DT.     
            MOVE RS1-DER-OWNER-CD         TO S1-DER-OWNER-CD.           
            MOVE RS1-INCENTIVE-ACCT-NO    TO S1-INCENTIVE-ACCT-NO.      
            MOVE RS1-DER-PGM-START-DT     TO S1-DER-PGM-START-DT.       
            MOVE RS1-DER-PGM-END-DT       TO S1-DER-PGM-END-DT.         
            MOVE RS1-DER-PGM-TYPE-DESC    TO S1-DER-PGM-TYPE-DESC.      
            MOVE RS1-BCA-ELIGIBLE-FL      TO S1-BCA-ELIGIBLE-FL.        
            MOVE RS1-PBI-ELIGIBLE-FL      TO S1-PBI-ELIGIBLE-FL.        
            MOVE RS1-PREM-PGM-START-DT    TO S1-PREM-PGM-START-DT.      
            MOVE RS1-INCENTIVE-END-DT     TO S1-INCENTIVE-END-DT.       
      *                                                                         
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    2100-BUILD-RESULT-DATA                                      *        
      *    CALLED FROM 2000-PROCESS-OUTPUT                             *        
      *    OPENS AND CLOSES THE AT CURSOR                              *        
      ******************************************************************        
      *                                                                         
       2100-BUILD-RESULT-DATA.                                          
      *                                                                         
           MOVE PARM-PREMISE-NO-NUM      TO 6B-PREMISE-NO.              
           PERFORM 7100-OPEN-PREM-CSR       THRU 7100-EXIT.             
           PERFORM 7200-FETCH-PREM-CSR      THRU 7200-EXIT.             
           PERFORM 2200-PROCESS-PREM-CSR    THRU 2200-EXIT              
             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.               
           PERFORM 7300-CLOSE-PREM-CSR      THRU 7300-EXIT.             
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2200-PROCESS-PREM-CSR.                                           
      *                                                                         
           MOVE '2200'                   TO ACTIVE-PARAGRAPH.           
           MOVE 6B-PREMISE-NO            TO RS1-PREMISE-NO.             
           MOVE 6B-DER-SEQ-NO            TO RS1-DER-SEQ-NO.             
           MOVE 6B-DER-PGM-TYPE-CD       TO RS1-DER-PGM-TYPE-CD.        
           MOVE 6B-DER-APPROVAL-DT       TO RS1-DER-APPROVAL-DT.        
           MOVE 6B-PANEL-TYPE-CD         TO RS1-PANEL-TYPE-CD.          
           MOVE 6B-INVERTER-TYPE-CD      TO RS1-INVERTER-TYPE-CD.       
           MOVE 6B-INTERCONNECT-DT       TO RS1-INTERCONNECT-DT.        
           MOVE 6B-INVERTER-SYST-SIZE    TO RS1-INVERTER-SYST-SIZE.     
           MOVE 6B-CONFIG-TYPE-CD        TO RS1-CONFIG-TYPE-CD.         
           MOVE 6B-DER-STATUS-CD         TO RS1-DER-STATUS-CD.          
           MOVE 6B-DER-STATUS-CHG-DT     TO RS1-DER-STATUS-CHG-DT.      
           MOVE 6B-DER-CONTRCT-END-DT    TO RS1-DER-CONTRCT-END-DT.     
           MOVE 6B-DER-OWNER-CD          TO RS1-DER-OWNER-CD.           
           MOVE 6B-INCENTIVE-ACCT-NO     TO RS1-INCENTIVE-ACCT-NO.      
           MOVE 6B-PREM-PGM-START-DT     TO RS1-PREM-PGM-START-DT.      
           MOVE 6B-INCENTIVE-END-DT      TO RS1-INCENTIVE-END-DT.       
           MOVE 6D-DER-PGM-START-DT      TO RS1-DER-PGM-START-DT.       
           MOVE 6D-DER-PGM-END-DT        TO RS1-DER-PGM-END-DT.         
           MOVE 6D-DER-PGM-TYPE-DESC     TO RS1-DER-PGM-TYPE-DESC.      
           MOVE 6D-BCA-ELIGIBLE-FL       TO RS1-BCA-ELIGIBLE-FL.        
           MOVE 6D-PBI-ELIGIBLE-FL       TO RS1-PBI-ELIGIBLE-FL.        
           PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT.            
           PERFORM 8100-SEND-RESULT         THRU 8100-EXIT.             
           PERFORM 7200-FETCH-PREM-CSR      THRU 7200-EXIT.             
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-OPEN-PREM-CSR.                                            *        
      ******************************************************************        
       7100-OPEN-PREM-CSR.                                              
                                                                        
           EXEC SQL                                                     
               OPEN PREM_CSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_PREM_DER_DET'       TO TABLE-1                  
              MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT                            
                                         THRU 9000-EXIT                 
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                         THRU 9900-EXIT                 
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-FETCH-PREM-CSR.                                           *        
      ******************************************************************        
       7200-FETCH-PREM-CSR.                                             
                                                                        
           EXEC SQL                                                     
               FETCH  PREM_CSR                                          
                INTO :6B-PREMISE-NO                                     
                    ,:6B-DER-SEQ-NO                                     
                    ,:6B-DER-PGM-TYPE-CD                                
                    ,:6B-DER-APPROVAL-DT :WS-NULL-IND-1                  
                    ,:6B-PANEL-TYPE-CD                                  
                    ,:6B-INVERTER-TYPE-CD                               
                    ,:6B-INTERCONNECT-DT :WS-NULL-IND-2                  
                    ,:6B-INVERTER-SYST-SIZE                             
                    ,:6B-CONFIG-TYPE-CD                                 
                    ,:6B-DER-STATUS-CD                                  
                    ,:6B-DER-STATUS-CHG-DT                              
                    ,:6B-DER-CONTRCT-END-DT :WS-NULL-IND-3               
                    ,:6B-DER-OWNER-CD                                   
                    ,:6B-INCENTIVE-ACCT-NO :WS-NULL-IND-4                
                    ,:6B-PREM-PGM-START-DT :WS-NULL-IND-5                
                    ,:6B-INCENTIVE-END-DT :WS-NULL-IND-6                 
                    ,:6D-DER-PGM-START-DT                               
                    ,:6D-DER-PGM-END-DT                                 
                    ,:6D-DER-PGM-TYPE-DESC                              
                    ,:6D-BCA-ELIGIBLE-FL                                
                    ,:6D-PBI-ELIGIBLE-FL                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-NULL-IND-1 < 0                                      
                 MOVE SPACES               TO 6B-DER-APPROVAL-DT        
              END-IF                                                    
              IF WS-NULL-IND-2 < 0                                      
                 MOVE SPACES               TO 6B-INTERCONNECT-DT        
              END-IF                                                    
              IF WS-NULL-IND-3 < 0                                      
                 MOVE SPACES               TO 6B-DER-CONTRCT-END-DT     
              END-IF                                                    
              IF WS-NULL-IND-4 < 0                                      
                 MOVE ZEROES               TO 6B-INCENTIVE-ACCT-NO      
              END-IF                                                    
              IF WS-NULL-IND-5 < 0                                      
                 MOVE SPACES               TO 6B-PREM-PGM-START-DT      
              END-IF                                                    
              IF WS-NULL-IND-6 < 0                                      
                 MOVE SPACES               TO 6B-INCENTIVE-END-DT       
              END-IF                                                    
           ELSE                                                         
              MOVE SQLCODE                 TO ABEND-SQLCODE             
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7200'                  TO ACTIVE-PARAGRAPH          
              MOVE 'FETCH'                 TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_PREM_DER_DET'      TO TABLE-1                   
              MOVE 'PREMISE_NO'            TO TABLE-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT                            
                                         THRU 9000-EXIT                 
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                         THRU 9900-EXIT                 
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-CLOSE-PREM-CSR.                                           *        
      *                                                                *        
      ******************************************************************        
       7300-CLOSE-PREM-CSR.                                             
                                                                        
           EXEC SQL                                                     
               CLOSE PREM_CSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7300'               TO ACTIVE-PARAGRAPH            
               MOVE 'CLOSE'              TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSS_PREM_DER_DET'   TO TABLE-1                     
               MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT                            
                                         THRU 9000-EXIT                 
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                         THRU 9900-EXIT                 
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *8000A-DELETE-GTT-ROWS                                           *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
           MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM #CSR04912_R1                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM SESSION.CSR04912_R1                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE '8000A'               TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04912_R1'         TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT                            
                                         THRU 9000-EXIT                 
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                         THRU 9900-EXIT                 
           END-IF.                                                      
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *8100-SEND-RESULT                                                *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO #CSR04912_R1                         
                (                                                       
                 RETURN_CODE                                            
                ,PREMISE_NO                                             
                ,DER_SEQ_NO                                             
                ,DER_PGM_TYPE_CD                                        
                ,DER_APPROVAL_DT                                        
                ,PANEL_TYPE_CD                                          
                ,INVERTER_TYPE_CD                                       
                ,INTERCONNECT_DT                                        
                ,INVERTER_SYST_SIZE                                     
                ,CONFIG_TYPE_CD                                         
                ,DER_STATUS_CD                                          
                ,DER_STATUS_CHG_DT                                      
                ,DER_CONTRCT_END_DT                                     
                ,DER_OWNER_CD                                           
                ,INCENTIVE_ACCT_NO                                      
                ,DER_PGM_START_DT                                       
                ,DER_PGM_END_DT                                         
                ,DER_PGM_TYPE_DESC                                      
                ,BCA_ELIGIBLE_FL                                        
                ,PBI_ELIGIBLE_FL                                        
                ,PREM_PGM_START_DT                                      
                ,INCENTIVE_END_DT                                       
                )                                                       
                VALUES                                                  
                (                                                       
                 :S1-RETURN-CODE                                        
                ,:S1-PREMISE-NO                                         
                ,:S1-DER-SEQ-NO                                         
                ,:S1-DER-PGM-TYPE-CD                                    
                ,:S1-DER-APPROVAL-DT                                    
                ,:S1-PANEL-TYPE-CD                                      
                ,:S1-INVERTER-TYPE-CD                                   
                ,:S1-INTERCONNECT-DT                                    
                ,:S1-INVERTER-SYST-SIZE                                 
                ,:S1-CONFIG-TYPE-CD                                     
                ,:S1-DER-STATUS-CD                                      
                ,:S1-DER-STATUS-CHG-DT                                  
                ,:S1-DER-CONTRCT-END-DT                                 
                ,:S1-DER-OWNER-CD                                       
                ,:S1-INCENTIVE-ACCT-NO                                  
                ,:S1-DER-PGM-START-DT                                   
                ,:S1-DER-PGM-END-DT                                     
                ,:S1-DER-PGM-TYPE-DESC                                  
                ,:S1-BCA-ELIGIBLE-FL                                    
                ,:S1-PBI-ELIGIBLE-FL                                    
                ,:S1-PREM-PGM-START-DT                                  
                ,:S1-INCENTIVE-END-DT                                   
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04912_R1                                 
MFA-TR*         (                                                       01670000
MFA-TR*          RETURN_CODE                                                    
MFA-TR*         ,PREMISE_NO                                                     
MFA-TR*         ,DER_SEQ_NO                                                     
MFA-TR*         ,DER_PGM_TYPE_CD                                                
MFA-TR*         ,DER_APPROVAL_DT                                                
MFA-TR*         ,PANEL_TYPE_CD                                                  
MFA-TR*         ,INVERTER_TYPE_CD                                               
MFA-TR*         ,INTERCONNECT_DT                                                
MFA-TR*         ,INVERTER_SYST_SIZE                                             
MFA-TR*         ,CONFIG_TYPE_CD                                                 
MFA-TR*         ,DER_STATUS_CD                                                  
MFA-TR*         ,DER_STATUS_CHG_DT                                              
MFA-TR*         ,DER_CONTRCT_END_DT                                             
MFA-TR*         ,DER_OWNER_CD                                                   
MFA-TR*         ,INCENTIVE_ACCT_NO                                              
MFA-TR*         ,DER_PGM_START_DT                                               
MFA-TR*         ,DER_PGM_END_DT                                                 
MFA-TR*         ,DER_PGM_TYPE_DESC                                              
MFA-TR*         ,BCA_ELIGIBLE_FL                                                
MFA-TR*         ,PBI_ELIGIBLE_FL                                                
MFA-TR*         ,PREM_PGM_START_DT                                              
MFA-TR*         ,INCENTIVE_END_DT                                               
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                       01670000
MFA-TR*          :S1-RETURN-CODE                                                
MFA-TR*         ,:S1-PREMISE-NO                                                 
MFA-TR*         ,:S1-DER-SEQ-NO                                                 
MFA-TR*         ,:S1-DER-PGM-TYPE-CD                                            
MFA-TR*         ,:S1-DER-APPROVAL-DT                                            
MFA-TR*         ,:S1-PANEL-TYPE-CD                                              
MFA-TR*         ,:S1-INVERTER-TYPE-CD                                           
MFA-TR*         ,:S1-INTERCONNECT-DT                                            
MFA-TR*         ,:S1-INVERTER-SYST-SIZE                                         
MFA-TR*         ,:S1-CONFIG-TYPE-CD                                             
MFA-TR*         ,:S1-DER-STATUS-CD                                              
MFA-TR*         ,:S1-DER-STATUS-CHG-DT                                          
MFA-TR*         ,:S1-DER-CONTRCT-END-DT                                         
MFA-TR*         ,:S1-DER-OWNER-CD                                               
MFA-TR*         ,:S1-INCENTIVE-ACCT-NO                                          
MFA-TR*         ,:S1-DER-PGM-START-DT                                           
MFA-TR*         ,:S1-DER-PGM-END-DT                                             
MFA-TR*         ,:S1-DER-PGM-TYPE-DESC                                          
MFA-TR*         ,:S1-BCA-ELIGIBLE-FL                                            
MFA-TR*         ,:S1-PBI-ELIGIBLE-FL                                            
MFA-TR*         ,:S1-PREM-PGM-START-DT                                          
MFA-TR*         ,:S1-INCENTIVE-END-DT                                           
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                ADD +1                    TO CTR-ROWS-1                 
           ELSE                                                         
                MOVE PROGRAM-NAME         TO ABEND-PROGRAM              
                MOVE SQLCODE              TO ABEND-SQLCODE              
                MOVE '8100'               TO ACTIVE-PARAGRAPH           
                MOVE 'INSERT'             TO ABEND-FUNCTION             
                MOVE SPACES               TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                MOVE 'CSR04912_R1'        TO TABLE-1                    
                MOVE SPACES               TO TABLE-ELEMENT-1            
                MOVE SPACES               TO HOSTVAR-ELEMENT-1          
                PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   8900-SEND-DONE                                               *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
      *                                                                         
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S1-RETURN-CODE                 
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
      *                                                                         
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
           END-IF.                                                      
      *                                                                         
           PERFORM 0100A-DECLARE-GTT  THRU 0100A-EXIT.                  
           PERFORM 8100-SEND-RESULT   THRU 8100-EXIT.                   
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   9999-END-PROGRAM                                             *        
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS-1 < 1                                            
      ******************************************************************        
      *         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!     *        
      ******************************************************************        
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
      *    EXEC SQL                                                             
      *       INCLUDE CPD00300                                                  
      *    END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE CPDSP300                                                
           END-EXEC.                                                            
