       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04911.                                         
       AUTHOR.        AARON ABRAHAM                                     
COB303 DATE-WRITTEN.  JAN 29, 2016.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *  This procedure is used to refund Credit Balance and it is     *        
      *  being called from Issue Refund view.                          *        
      *                                                                *        
      *  # Main program CSR04888                                       *        
      *  # Cloned from CSR02184                                        *        
      *  # Removed Update and Disapprove related logic                 *        
      *  # Write Journals and transaction history                      *        
      *  # Invoked from Account Receivable Solution/Refunds Project    *        
      *  # BusOp Name: RequUpdIssueRefund                              *00001600
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      * ---------- -------- ------------------------------------------ *        
      *    DATE    INITIALS COMMENTS                                   *        
      * ---------- -------- ------------------------------------------ *        
P00870* 01/29/2016 AA97148  INITIAL IMPLEMENTATION.                    *        
      ******************************************************************        
      ******************************************************************00650000
      *                                                                *00660000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00670000
      *                                                                *00680000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00690000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00700000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00710000
      *  3000 - 4999  NOT USED                                         *00720000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00730000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00740000
      *  7000 - 7999  INPUT MODULES                                    *00750000
      *  8000 - 8999  OUTPUT MODULES                                   *00760000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00770000
      *                                                                *00780000
      ******************************************************************00790000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04911'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04911 STARTS HERE'.                  
                                                                        
      ******************************************************************00880000
      *    DB2 INCLUDES                                                *00890000
      ******************************************************************00900000
                                                                        
           EXEC SQL                                                     00920000
              INCLUDE SQLCA                                             00930000
           END-EXEC.                                                    00940000
                                                                        
      ******************************************************************        
      * CSS_REFUND            - RN                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01000000
              INCLUDE TBREFUND                                          01010000
           END-EXEC.                                                    01020000
                                                                        
      ******************************************************************        
      * CSS_AR_TRANS_HIST     - AR                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01040000
              INCLUDE TBARHIST                                          01050000
           END-EXEC.                                                    01060000
                                                                        
      ******************************************************************        
      * CSS_AR_TRN_HST_DET    - AU                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01080000
              INCLUDE TBARHDT                                           01090000
           END-EXEC.                                                    01100000
                                                                        
      ******************************************************************        
      * CSS_ACCOUNT           - AT                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01200000
              INCLUDE TBACCT                                            01210000
           END-EXEC.                                                    01220000
                                                                        
      ******************************************************************        
      * CSS_AR_LOCKOUT        - AL                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01240000
              INCLUDE TBARLOCK                                          01250000
           END-EXEC.                                                    01260000
                                                                        
      ******************************************************************        
      * CSS_PREMISE           - PR                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01280000
              INCLUDE TBPREM                                            01290000
           END-EXEC.                                                    01300000
                                                                        
      ******************************************************************        
      * CSS_ADDR_FORMATTED    - DY                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01320000
              INCLUDE TBADRFMT                                          01330000
           END-EXEC.                                                    01340000
                                                                        
      ******************************************************************        
      * CSS_ADDR_FREEFORM     - DZ                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01360000
              INCLUDE TBADRFRE                                          01370000
           END-EXEC.                                                    01380000
                                                                        
      ******************************************************************        
      * CSS_ZIP_CODE          - A4                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01400000
              INCLUDE TBZIPCD                                           01410000
           END-EXEC.                                                    01420000
                                                                        
      ******************************************************************        
      * CSS_GL_ACCT_NO        - GO                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01440000
               INCLUDE TBGLATNO                                         01450000
           END-EXEC.                                                    01460000
                                                                        
      ******************************************************************        
      * CSS_ADDR_ID_CNTL      - I8                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01480000
              INCLUDE TBADDRID                                          01490000
           END-EXEC.                                                    01500000
                                                                        
      ******************************************************************        
      * CSS_MT_TRN_HST_DET    - MI                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01520000
              INCLUDE TBMNHDT                                           01530000
           END-EXEC.                                                    01540000
                                                                        
      ******************************************************************        
      * CSS_MNT_TRANS_HIST    - MH                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01560000
              INCLUDE TBMNHIST                                          01570000
           END-EXEC.                                                    01580000
                                                                        
      ******************************************************************        
      * CSS_USER_PROFILE      - PF                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01600000
              INCLUDE TBUSRPRF                                          01610000
           END-EXEC.                                                    01620000
                                                                        
      ******************************************************************        
      * CSS_AR_CNTL           - AC                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01640000
              INCLUDE TBARCNTL                                          01650000
           END-EXEC.                                                    01660000
                                                                        
      ******************************************************************        
      * CSS_DEP_ON_HAND       - DO                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01720000
              INCLUDE TBDEPHND                                          01730000
           END-EXEC.                                                    01740000
                                                                        
      ******************************************************************        
      * CSS_BATCH_JRNL        - BJ                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01760000
              INCLUDE TBBTJRNL                                          01770000
           END-EXEC.                                                    01780000
                                                                        
      ******************************************************************        
      * CSS_CSH_DRWR_JRNL     - CJ                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01800000
              INCLUDE TBCDJRNL                                          01810000
           END-EXEC.                                                    01820000
                                                                        
      ******************************************************************        
      * CSS_RESP_AREA         - C1                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01840000
              INCLUDE TBRSAREA                                          01850000
           END-EXEC.                                                    01860000
                                                                        
      ******************************************************************        
      * CSS_CUSTOMER          - CU                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01960000
              INCLUDE TBCUST                                            01970000
           END-EXEC.                                                    01980000
                                                                        
      ******************************************************************02120000
      * CSS_BCH_JRNL_CNTL     - BC                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     02000000
              INCLUDE TBBJCNTL                                          02010000
           END-EXEC.                                                    02020000
                                                                        
      ******************************************************************        
      * CSS_CSH_DRWR_CNTL     - CS                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     02040000
              INCLUDE TBCDCNTL                                          02050000
           END-EXEC.                                                    02060000
                                                                        
      ******************************************************************        
      * CSS_MISC_JRNL         - MJ                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     02080000
              INCLUDE TBMSJRNL                                          02090000
           END-EXEC.                                                    02100000
                                                                        
      ******************************************************************02120000
      *    COBOL WORKING STORAGE COPY BOOKS                            *02130000
      ******************************************************************02140000
                                                                        
      ******************************************************************        
      * ERROR HANDLING                                                 *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                               02320000
                                                                        
      ******************************************************************        
      * WORKING STORAGE COPYBOOKS FOR CPD00068                         *        
      ******************************************************************        
                                                                        
           COPY CWS00056.                                               02340000
                                                                        
      *****************************************************************         
      *    WORKING STORAGE FOR CPDKR363                                         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     01670000
              INCLUDE CWSKR363                                          01680000
           END-EXEC.                                                    01690000
                                                                        
      ******************************************************************        
      * WS FOR CPD00071                                                *        
      ******************************************************************        
                                                                        
           COPY CWS00071.                                               02360000
                                                                        
      ******************************************************************        
      * CASH JOURNAL OF FORMAT 101                                     *        
      ******************************************************************        
                                                                        
           COPY CJF00101.                                               02380000
           COPY CJF00113.                                               02390000
                                                                        
      ******************************************************************        
      * WS FOR CPD00182                                                *        
      ******************************************************************        
                                                                        
           COPY CWS00182.                                                       
                                                                        
      ******************************************************************        
      * WS FOR CPD0013B                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     02410000
              INCLUDE CWS0013B                                          02420000
           END-EXEC.                                                    02430000
                                                                        
      ******************************************************************        
      * WS FOR CPD00090                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     02450000
              INCLUDE CWS0090A                                          02460000
           END-EXEC.                                                    02470000
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05 WS-RN-NULL-ITEM               PIC S9(4) COMP.             
           05 WS-RN-NULL-IND-1              PIC S9(4) COMP.             
           05 WS-RN-NULL-IND-2              PIC S9(4) COMP.             
           05 WS-RN-NULL-IND-3              PIC S9(4) COMP.             
           05 WS-RN-NULL-IND-4              PIC S9(4) COMP.             
           05 WS-RN-NULL-IND-5              PIC S9(4) COMP.             
           05 WS-RN-NULL-IND-6              PIC S9(4) COMP.             
           05 WS-RN-NULL-IND-7              PIC S9(4) COMP.             
           05 WS-RN-NULL-IND-8              PIC S9(4) COMP.             
           05 WS-RN-NULL-IND-9              PIC S9(4) COMP.             
           05 WS-RN-NULL-IND-10             PIC S9(4) COMP.             
           05 WS-RN-NULL-IND-11             PIC S9(4) COMP.             
           05 WS-RN-NULL-IND-12             PIC S9(4) COMP.             
           05 WS-RN-NULL-IND-13             PIC S9(4) COMP.             
           05 WS-RN-NULL-IND-14             PIC S9(4) COMP.             
           05 WS-AR-NULL-IND-1              PIC S9(4) COMP.             
           05 WS-AR-NULL-IND-2              PIC S9(4) COMP.             
           05 WS-AR-NULL-IND-3              PIC S9(4) COMP.             
                                                                        
       01  WS-MISC.                                                     
COB305     05 WS-PREMISE-NO        PIC S9(10)V COMP-3 VALUE 0.           
           05 WS-INDEX                   PIC S9(04) COMP VALUE 0.       
           05 WS-USER-ID                 PIC X(7).                      
           05 WS-REFUND-EXISTS           PIC S9(04) COMP VALUE 0.       
           05 PROGRAM-NAME               PIC X(08) VALUE 'CSR02184'.    
           05 WS-ADD-STR.                                               
              10 F                       PIC X(03) VALUE 'AR-'.         
              10 WS-ADD-RECVBL           PIC X(03).                     
           05 WS-UNPACK-ALPHA-NUM.                                      
              10 WS-UNPACK-NUMBER        PIC 9(10).                     
           05 WS-UNPACK-ALPHA-NUM4.                                     
              10 WS-UNPACK-NUMBER4       PIC 9(04).                     
           05 WS-UNPACK-VALUES.                                         
              10 WS-UNPACK-VALUES-N      PIC 9(11)V9(2).                
           05 WS-LAST-UPDATE-TS          PIC X(26).                     
           05 RS-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
           05 WS-ADDRESS-CHANGED-FL      PIC X(01) VALUE SPACES.        
                                                                        
       01  WS-REFUND-TABLE.                                             
           05 WS-ACTION-CODE             PIC X(1).                      
           05 WS-PARM-ACCOUNT-NO         PIC X(13).                     
           05 WS-ACCOUNT-NO-NUM REDEFINES WS-PARM-ACCOUNT-NO            
                                         PIC 9(13).                     
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13)V COMP-3 VALUE 0.            
           05 WS-TRANS-HIST-SEQ-NO       PIC X(26).                     
                                                                        
           05 WS-AMT-REFUNDED            PIC X(11).                     
           05 WS-AMT-REFUNDED-NUM REDEFINES WS-AMT-REFUNDED             
                                         PIC 9(09)V99.                  
           05 WS-RFND-CHECK-AMT          PIC S9(09)V99 COMP-3 VALUE 0.  
           05 WS-RFND-CASH-AMT           PIC S9(09)V99 COMP-3 VALUE 0.  
           05 WS-RECVBL-RFND-AMT         PIC S9(09)V99 COMP-3 VALUE 0.  
                                                                        
           05 WS-LENGTH                  PIC X(04).                     
           05 WS-LENGTH-NUM       REDEFINES WS-LENGTH                   
                                         PIC 9(04).                     
           05 WS-CASH-DRWR               PIC X(04).                     
           05 WS-CASH-DRWR-NUM    REDEFINES WS-CASH-DRWR                
                                         PIC 9(04).                     
           05 WS-TRANS-COMMENTS-TEXT     PIC X(210).                    
           05 WS-TRANS-COMMENTS-LEN      PIC S9(4) COMP.                
           05 WS-ITEM-ID                 PIC X(09).                     
           05 WS-ITEM-ID-NUM   REDEFINES WS-ITEM-ID                     
                                         PIC 9(09).                     
           05 WS-CIA-ITEM-ID-NUM         PIC 9(09).                     
           05 WS-RFND-AMT                PIC X(11).                     
           05 WS-RFND-AMT-NUM  REDEFINES WS-RFND-AMT                    
                                         PIC 9(09)V99.                  
                                                                        
       01  CASH-DRAWER-JOURNALING.                                      
           05  WS-CASH-DRAWER.                                          
               10  WS-CD-COMPANY-NO      PIC X(02).                     
               10  WS-CD-LOCAL-OFFICE    PIC X(03).                     
               10  WS-CD-REPORT-NO       PIC X(03).                     
               10  WS-CD-REPORT-DATE     PIC X(10).                     
               10  WS-CASH-DRAWER-ID     PIC S9(04) COMP.               
                                                                        
       01  WS-MNT-TRANS-HIST.                                           
           05  WS-USERID                  PIC X(08)  VALUE SPACES.      
           05  WS-CURRENT-DATE            PIC X(10)  VALUE SPACES.      
           05  WS-CURRENT-TIMESTAMP       PIC X(26)  VALUE SPACES.      
           05  WS-PANEL-NO                PIC X(09)  VALUE 'PANEL275 '. 
           05  WS-RESP-AREA-ID            PIC X(03)   VALUE SPACES.     
COB305     05 WS-PREMISE-NO-COMP        PIC S9(10) COMP-3 VALUE 0.           
                                                                        
       01  WS-MNT-TRANS-DET.                                            
           05  WS-CODE-TRAN-TYPE          PIC X(01)   VALUE 'F'.        
           05  WS-TRAN-APPL-NO            PIC S9(02)  VALUE 0.          
           05  WS-TABLE-ID                PIC X(02)   VALUE SPACES.     
           05  WS-COLUMN-DESC             PIC X(15)   VALUE SPACES.     
           05  WS-CHG-COLUMN-VALUE-TEXT   PIC X(30)   VALUE SPACES.     
           05  WS-CHG-COLUMN-VALUE-LEN    PIC S9(02)  VALUE 0.          
           05  WS-PRV-COLUMN-VALUE-TEXT   PIC X(30)   VALUE SPACES.     
           05  WS-PRV-COLUMN-VALUE-LEN    PIC S9(02)  VALUE 0.          
                                                                        
      ***************************************************************   03660000
      * COPYCODE WORKING STORAGE VARIABLES.                             03670000
      ***************************************************************   03680000
       01  WS-AR-TRN-HST-DET-TABLE.                                     
           05 WS-REFUND-AMT              PIC S9(9)V99  COMP-3 VALUE 0.  
           05 WS-AMOUNT-DIFF             PIC S9(9)V99  COMP-3 VALUE 0.  
           05 WS-AU-TRAN-APPL-NO         PIC S9(4) COMP VALUE 0.        
           05 WS-CHECK-CASH-IND          PIC X(1)       VALUE SPACES.   
           05 WS-END-OF-PROCESS          PIC X(1)       VALUE 'F'.      
           05 WS-GLED-ACCT-NO            PIC S9(3)V9999 COMP-3 VALUE 0. 
           05 WS-GLED-ACCT-NAME          PIC X(10) VALUE SPACES.        
           05 WS-SEARCH-ACCT-NAME        PIC X(10) VALUE SPACES.        
           05 WS-PYMT-PRIORITY-LVL       PIC S9(4) COMP VALUE ZERO.     
           05 WS-INSERT-DEP-REQ          PIC X(1)  VALUE 'N'.           
           05 WS-BAL-NEGETIVE            PIC X(1)  VALUE 'F'.           
           05 WS-SUMM-BAL-NEGV           PIC X(1)  VALUE 'F'.           
           05 WS-SUMM-FLAG               PIC X(3)  VALUE SPACES.        
           05 WS-AC-SUMM-ITEM-ID         PIC S9(9) USAGE COMP VALUE 0.  
           05 WS-AC-SUMM-UNUSED-CR       PIC S9(9)V99  COMP-3 VALUE 0.  
                                                                        
       01  WS-RET-CODE.                                                 
           05 WS-CREDIT-BAL-LESS-RET-CODE   PIC S9(9) COMP VALUE  -051. 
           05 WS-DEP-REFUNDED-RET-CODE      PIC S9(9) COMP VALUE  -052. 
           05 WS-NOT-DEP-ON-HAND-RET-CODE   PIC S9(9) COMP VALUE  -053. 
                                                                        
       01  WS-GL-PPL-TABLE.                                             
           05  WS-PPL-AR-TYPE-NSC         PIC S9(4) COMP VALUE  +019.   
           05  WS-PPL-AR-TYPE-NSA         PIC S9(4) COMP VALUE  +020.   
           05  WS-PPL-AR-TYPE-NSN         PIC S9(4) COMP VALUE  +029.   
           05  WS-PPL-AR-TYPE-LPC         PIC S9(4) COMP VALUE  +030.   
           05  WS-PPL-AR-TYPE-LPN         PIC S9(4) COMP VALUE  +039.   
           05  WS-PPL-AR-TYPE-UTE         PIC S9(4) COMP VALUE  +040.   
           05  WS-PPL-AR-TYPE-UTG         PIC S9(4) COMP VALUE  +045.   
           05  WS-PPL-AR-TYPE-EPP         PIC S9(4) COMP VALUE  +050.   
           05  WS-PPL-AR-TYPE-CCC         PIC S9(4) COMP VALUE  +060.   
           05  WS-PPL-AR-TYPE-CIA         PIC S9(4) COMP VALUE  +070.   
           05  WS-PPL-AR-TYPE-DEP         PIC S9(4) COMP VALUE  +080.   
           05  WS-PPL-AR-TYPE-DFA         PIC S9(4) COMP VALUE  +090.   
           05  WS-PPL-AR-TYPE-CNT         PIC S9(4) COMP VALUE  +100.   
           05  WS-PPL-AR-TYPE-RVC         PIC S9(4) COMP VALUE  +110.   
           05  WS-PPL-AR-TYPE-PJS         PIC S9(4) COMP VALUE  +129.   
           05  WS-PPL-AR-TYPE-ADJ         PIC S9(4) COMP VALUE  +999.   
      ***************************************************************** 04140000
      * END OF COPYCODE WORKING STORAGE VARIABLES.                      04150000
      ***************************************************************** 04160000
                                                                        
       01  SWITCHES.                                                    
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
            05 S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
            05 S-APPL-RETURN-CODE     PIC X(10) VALUE SPACES.           
            05 S-AT-LAST-UPDATE-TS    PIC X(26) VALUE SPACE.            
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO              PIC X(13) VALUE SPACES.         
       01  PARM-ACTION-CODE             PIC X(1)  VALUE SPACES.         
       01  PARM-TRANS-HIST-SEQ-NO       PIC X(26) VALUE SPACES.         
       01  PARM-RFND-CHECK-AMT          PIC X(11) VALUE SPACES.         
       01  PARM-RFND-CASH-AMT           PIC X(11) VALUE SPACES.         
       01  PARM-CHECK-ISS-REAS-CD       PIC X(2)  VALUE SPACES.         
       01  PARM-CHECK-STATUS-CD         PIC X(1)  VALUE SPACES.         
       01  PARM-ITEM-ID                 PIC X(09) VALUE SPACES.         
       01  PARM-COMMENTS-TEXT           PIC X(72) VALUE SPACES.         
       01  PARM-COMMENTS-LEN            PIC X(4)  VALUE SPACES.         
       01  PARM-REQST-DT-CHANGED        PIC X(01) VALUE SPACES.         
       01  PARM-REQUEST-DT              PIC X(10) VALUE SPACES.         
       01  PARM-PANEL-NO                PIC X(04) VALUE SPACES.         
       01  PARM-GS-USER-ID              PIC X(7)  VALUE SPACES.         
       01  PARM-TRANS-COMMENTS          PIC X(210) VALUE SPACES.        
       01  PARM-TRANS-COMMENTS-LEN      PIC X(4)  VALUE SPACES.         
       01  PARM-CASH-COMPANY-NO         PIC X(02) VALUE SPACES.         
       01  PARM-CASH-LOCAL-OFFICE       PIC X(03) VALUE SPACES.         
       01  PARM-CASH-REPORT-NO          PIC X(03) VALUE SPACES.         
       01  PARM-DATE-CASH-REPORT        PIC X(10) VALUE SPACES.         
       01  PARM-CASH-DRAWER-ID          PIC X(4)  VALUE SPACES.         
       01  PARM-CSR-PC-ID               PIC X(4)  VALUE SPACES.         
       01  PARM-LAST-UPDATE-TS-AT       PIC X(26) VALUE SPACES.         
       01  PARM-ADDRESS-CHANGED-FL      PIC X(01) VALUE SPACES.         
       01  PARM-ADDRESS-FORMAT          PIC X(01) VALUE SPACES.         
       01  PARM-FMT-HOUSE-NO            PIC X(15) VALUE SPACES.         
       01  PARM-FMT-ADDR-PREFIX-1       PIC X(03) VALUE SPACES.         
       01  PARM-FMT-ADDR-PREFIX-2       PIC X(02) VALUE SPACES.         
       01  PARM-FMT-STREET-NAME         PIC X(30) VALUE SPACES.         
       01  PARM-FMT-STREET-SUFFIX       PIC X(04) VALUE SPACES.         
       01  PARM-FMT-ADDR-SUFFIX         PIC X(02) VALUE SPACES.         
       01  PARM-FMT-STREET-LOCATION-1   PIC X(04) VALUE SPACES.         
       01  PARM-FMT-STREET-LOCATION-2   PIC X(11) VALUE SPACES.         
       01  PARM-FF-ADDR-STREET          PIC X(55) VALUE SPACES.         
       01  PARM-FF-ADDRESS-OVERFLOW     PIC X(35) VALUE SPACES.         
       01  PARM-FF-ADDR-COUNTRY         PIC X(35) VALUE SPACES.         
       01  PARM-FF-ADDRESS-CITY-STATE   PIC X(30) VALUE SPACES.         
       01  PARM-CITY                    PIC X(26) VALUE SPACES.         
       01  PARM-STATE                   PIC X(02) VALUE SPACES.         
       01  PARM-ZIP-CODE                PIC X(05) VALUE SPACES.         
       01  PARM-ZIP-CODE-PLUS-FOUR      PIC X(04) VALUE SPACES.         
                                                                        
       PROCEDURE DIVISION USING                                         
                PARM-ACCOUNT-NO                                         
               ,PARM-ACTION-CODE                                        
               ,PARM-TRANS-HIST-SEQ-NO                                  
               ,PARM-RFND-CHECK-AMT                                     
               ,PARM-RFND-CASH-AMT                                      
               ,PARM-CHECK-ISS-REAS-CD                                  
               ,PARM-CHECK-STATUS-CD                                    
               ,PARM-ITEM-ID                                            
               ,PARM-COMMENTS-TEXT                                      
               ,PARM-COMMENTS-LEN                                       
               ,PARM-REQST-DT-CHANGED                                   
               ,PARM-REQUEST-DT                                         
               ,PARM-PANEL-NO                                           
               ,PARM-GS-USER-ID                                         
               ,PARM-TRANS-COMMENTS                                     
               ,PARM-TRANS-COMMENTS-LEN                                 
               ,PARM-CASH-COMPANY-NO                                    
               ,PARM-CASH-LOCAL-OFFICE                                  
               ,PARM-CASH-REPORT-NO                                     
               ,PARM-DATE-CASH-REPORT                                   
               ,PARM-CASH-DRAWER-ID                                     
               ,PARM-CSR-PC-ID                                          
               ,PARM-LAST-UPDATE-TS-AT                                  
               ,PARM-ADDRESS-CHANGED-FL                                 
               ,PARM-ADDRESS-FORMAT                                     
               ,PARM-FMT-HOUSE-NO                                       
               ,PARM-FMT-ADDR-PREFIX-1                                  
               ,PARM-FMT-ADDR-PREFIX-2                                  
               ,PARM-FMT-STREET-NAME                                    
               ,PARM-FMT-STREET-SUFFIX                                  
               ,PARM-FMT-ADDR-SUFFIX                                    
               ,PARM-FMT-STREET-LOCATION-1                              
               ,PARM-FMT-STREET-LOCATION-2                              
               ,PARM-FF-ADDR-STREET                                     
               ,PARM-FF-ADDRESS-OVERFLOW                                
               ,PARM-FF-ADDR-COUNTRY                                    
               ,PARM-FF-ADDRESS-CITY-STATE                              
               ,PARM-CITY                                               
               ,PARM-STATE                                              
               ,PARM-ZIP-CODE                                           
               ,PARM-ZIP-CODE-PLUS-FOUR.                                
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      ******************************************************************05170000
      * 0000-MAINLINE                                                  *05180000
      ******************************************************************05250000
                                                                        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 8100-SEND-RESULT    THRU 8100-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05360000
      * 0100-INITIALIZE                                                *05370000
      ******************************************************************05480000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
                SELECT                                                  
                   :S-RETURN-CODE               AS RETURN_CODE          
                   ,LTRIM(RTRIM(:S-APPL-RETURN-CODE))  AS 
           APPL_RETURN_CODE     
                   ,LTRIM(RTRIM(:S-AT-LAST-UPDATE-TS)) AS 
           AT_LAST_UPDATE_TS    
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*         SELECT                                                          
MFA-TR*            :S-RETURN-CODE               AS RETURN_CODE                  
MFA-TR*            ,STRIP(:S-APPL-RETURN-CODE)  AS APPL_RETURN_CODE             
MFA-TR*            ,STRIP(:S-AT-LAST-UPDATE-TS) AS AT_LAST_UPDATE_TS            
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05770000
      * 1000-PROCESS-INPUT                                             *05780000
      ******************************************************************05840000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           INITIALIZE SCSCA182-LINK-RECORD.                             
           MOVE PARM-ACCOUNT-NO       TO SCSCA182-ACCOUNT-NO.           
                                                                        
           MOVE PARM-ACCOUNT-NO       TO WS-PARM-ACCOUNT-NO.            
           MOVE WS-ACCOUNT-NO-NUM     TO WS-ACCOUNT-NO-COMP3            
                                         RN-ACCOUNT-NO.                 
           MOVE PARM-ACTION-CODE      TO WS-ACTION-CODE.                
           MOVE PARM-TRANS-HIST-SEQ-NO TO WS-TRANS-HIST-SEQ-NO.         
                                                                        
           MOVE PARM-RFND-CHECK-AMT   TO WS-AMT-REFUNDED.               
           IF WS-AMT-REFUNDED-NUM > 0                                   
              MOVE WS-AMT-REFUNDED-NUM   TO WS-RFND-CHECK-AMT           
           END-IF.                                                      
                                                                        
           MOVE PARM-RFND-CASH-AMT    TO WS-AMT-REFUNDED.               
           IF WS-AMT-REFUNDED-NUM > 0                                   
              MOVE WS-AMT-REFUNDED-NUM   TO WS-RFND-CASH-AMT            
           END-IF.                                                      
                                                                        
           MOVE PARM-CHECK-ISS-REAS-CD TO RN-CHECK-ISS-REAS-CD.         
           MOVE PARM-CHECK-STATUS-CD   TO RN-CHECK-STATUS-CD.           
           MOVE PARM-PANEL-NO          TO RN-PANEL-NO.                  
                                                                        
           MOVE PARM-ITEM-ID           TO PARM-COMMENTS-TEXT.           
           MOVE PARM-COMMENTS-TEXT     TO RN-COMMENTS-TEXT.             
           MOVE '0009'                 TO PARM-COMMENTS-LEN.            
                                                                        
           MOVE PARM-COMMENTS-LEN      TO WS-LENGTH.                    
           MOVE WS-LENGTH-NUM          TO RN-COMMENTS-LEN.              
           MOVE PARM-REQUEST-DT        TO RN-REQUEST-DT                 
           MOVE PARM-GS-USER-ID        TO WS-USER-ID  AR-USER-ID.       
           MOVE PARM-TRANS-COMMENTS    TO WS-TRANS-COMMENTS-TEXT.       
           MOVE PARM-TRANS-COMMENTS-LEN TO WS-LENGTH.                   
           MOVE WS-LENGTH-NUM          TO WS-TRANS-COMMENTS-LEN.        
                                                                        
           MOVE PARM-CASH-COMPANY-NO   TO WS-CD-COMPANY-NO.             
           MOVE PARM-CASH-LOCAL-OFFICE TO WS-CD-LOCAL-OFFICE.           
           MOVE PARM-CASH-REPORT-NO    TO WS-CD-REPORT-NO.              
           MOVE PARM-DATE-CASH-REPORT  TO WS-CD-REPORT-DATE.            
           MOVE PARM-CASH-DRAWER-ID    TO WS-CASH-DRWR.                 
           MOVE WS-CASH-DRWR-NUM       TO WS-CASH-DRAWER-ID.            
           MOVE PARM-CSR-PC-ID         TO WS-JRNL-OL-CSR-PC-ID.         
           MOVE PARM-ADDRESS-CHANGED-FL     TO WS-ADDRESS-CHANGED-FL.   
           MOVE PARM-ADDRESS-FORMAT         TO WS-KR363-ADDRESS-FORMAT. 
           MOVE PARM-FMT-HOUSE-NO           TO WS-KR363-FMT-HOUSE-NO.   
           MOVE PARM-FMT-ADDR-PREFIX-1   TO WS-KR363-FMT-ADDR-PREFIX-1. 
           MOVE PARM-FMT-ADDR-PREFIX-2   TO WS-KR363-FMT-ADDR-PREFIX-2. 
           MOVE PARM-FMT-STREET-NAME     TO WS-KR363-FMT-STREET-NAME.   
           MOVE PARM-FMT-STREET-SUFFIX   TO WS-KR363-FMT-STREET-SUFFIX. 
           MOVE PARM-FMT-ADDR-SUFFIX     TO WS-KR363-FMT-ADDR-SUFFIX.   
           MOVE PARM-FMT-STREET-LOCATION-1  TO                          
                                            WS-KR363-FMT-STREET-LOC-1.  
           MOVE PARM-FMT-STREET-LOCATION-2  TO                          
                                            WS-KR363-FMT-STREET-LOC-2.  
           MOVE PARM-FF-ADDR-STREET         TO WS-KR363-FF-ADDR-STREET. 
           MOVE PARM-FF-ADDRESS-OVERFLOW    TO                          
                                            WS-KR363-FF-ADDR-OVERFLOW.  
           MOVE PARM-FF-ADDR-COUNTRY        TO WS-KR363-FF-ADDR-COUNTRY.
           MOVE PARM-FF-ADDRESS-CITY-STATE  To                          
                                            WS-KR363-FF-ADDR-CITY-STATE.
           MOVE PARM-CITY                   TO WS-KR363-CITY.           
           MOVE PARM-STATE                  TO WS-KR363-STATE.          
           MOVE PARM-ZIP-CODE               TO WS-KR363-ZIP-CODE.       
           MOVE PARM-ZIP-CODE-PLUS-FOUR  TO WS-KR363-ZIP-CODE-PLUS-FOUR.
           MOVE PARM-ITEM-ID                TO WS-ITEM-ID.              
           MOVE WS-ITEM-ID                  TO WS-CIA-ITEM-ID-NUM.      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09480000
      * 2000-PROCESS-OUTPUT.                                           *09490000
      ******************************************************************09560000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
                                                                        
           PERFORM 5000-PROCESS-REFUND           THRU 5000-EXIT.        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************       10650000
      * 5000-PROCESS-REFUND.                                            10660000
      ******************************@****************************       10670000
                                                                        
       5000-PROCESS-REFUND.                                             
           MOVE '5000'                      TO ACTIVE-PARAGRAPH.        
                                                                        
      *AR Lockout validation                                            10710000
           PERFORM 7999-SELECT-AL THRU 7999-SELECT-AL-EXIT.             
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
              MOVE 0    TO S-RETURN-CODE                                
              MOVE 5000 TO S-APPL-RETURN-CODE                           
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF.                                                      
                                                                        
      *Account Transfer validation                                      10710000
           MOVE WS-ACCOUNT-NO-COMP3  TO AT-ACCOUNT-NO.                  
           PERFORM 7999-SELECT-TRANSFER-IND                             
              THRU 7999-SELECT-TRANSFER-IND-EXIT.                       
           IF AT-ACCT-XFER-TO > ZERO                                    
              MOVE 0    TO S-RETURN-CODE                                
              MOVE 5001 TO S-APPL-RETURN-CODE                           
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF.                                                      
                                                                        
           PERFORM 7800-GET-ACCOUNT-INFO  THRU 7800-KR364-EXIT.         
           MOVE AT-CODES-DATA-PRESENT       TO WS-CODES-DATA-PRESENT.   
      * Timestamp validation                                                    
           IF PARM-LAST-UPDATE-TS-AT = AT-LAST-UPDATE-TS                
              CONTINUE                                                  
           ELSE                                                         
              MOVE 0                         TO S-RETURN-CODE           
              MOVE 5272                      TO S-APPL-RETURN-CODE      
              PERFORM 8100-SEND-RESULT       THRU 8100-EXIT             
              PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
           END-IF                                                       
                                                                        
           MOVE WS-ACCOUNT-NO-COMP3       TO RN-ACCOUNT-NO              
                                             AR-ACCOUNT-NO              
                                             AU-ACCOUNT-NO.             
           PERFORM 7000-GET-CURRENT-DATE  THRU 7000-EXIT.               
           PERFORM 7010-ACCEPT-TIMESTAMP  THRU 7010-KR364-EXIT.         
           MOVE 0                         TO WS-TRAN-APPL-NO.           
           MOVE WS-CURRENT-TIMESTAMP      TO RN-TRANS-HIST-SEQ-NO       
                                             AR-TRANS-HIST-SEQ-NO       
                                             AU-TRANS-HIST-SEQ-NO       
                                             S-AT-LAST-UPDATE-TS.       
           PERFORM 7010-GET-RESP-AREA-ID  THRU 7010-EXIT.               
                                                                        
           PERFORM 5950-SET-MNT-TRANS-VARS   THRU 5950-EXIT.            
                                                                        
           IF WS-ACTION-CODE = 'I'                                      
              PERFORM 5005-CLEAR-NULL-DATES  THRU 5005-EXIT             
                                                                        
              IF WS-RFND-CHECK-AMT > 0                                  
                 MOVE WS-RFND-CHECK-AMT      TO RN-AMT-REFUNDED         
                 MOVE 'M'                    TO RN-MANUAL-INDICATOR     
                 PERFORM 5010-INSERT-REFUND  THRU 5010-EXIT             
              END-IF                                                    
                                                                        
              IF WS-RFND-CASH-AMT > 0                                   
                 MOVE WS-RFND-CASH-AMT       TO RN-AMT-REFUNDED         
                 MOVE 'C'                    TO RN-MANUAL-INDICATOR     
                 PERFORM 5010-INSERT-REFUND  THRU 5010-EXIT             
              END-IF                                                    
                                                                        
              IF PARM-CHECK-STATUS-CD = 'A' OR 'I'                      
                 PERFORM 5200-CRED-BAL-JRNL-PROCESS THRU 5200-KR364-EXIT
              END-IF                                                    
                                                                        
              IF WS-RFND-CHECK-AMT > 0                                  
                 MOVE 'A'                        TO WS-CODE-CHECK-REFUND
                 PERFORM 7010-ACCEPT-TIMESTAMP   THRU 7010-KR364-EXIT   
                 MOVE WS-CURRENT-TIMESTAMP       TO AT-LAST-UPDATE-TS   
                                                    S-AT-LAST-UPDATE-TS 
                 PERFORM 7820-UPDATE-CODES       THRU 7820-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************12170000
      * 5005 CLEAL NULL DATES                                          *12180000
      ******************************************************************12230000
                                                                        
       5005-CLEAR-NULL-DATES.                                           
                                                                        
           MOVE '5005'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           MOVE -1                          TO WS-RN-NULL-IND-4.        
           MOVE -1                          TO WS-RN-NULL-IND-5.        
           MOVE -1                          TO WS-RN-NULL-IND-6.        
           MOVE -1                          TO WS-RN-NULL-IND-7.        
           MOVE -1                          TO WS-RN-NULL-IND-8.        
           MOVE -1                          TO WS-RN-NULL-IND-9.        
           MOVE -1                          TO WS-RN-NULL-IND-10.       
           MOVE -1                          TO WS-RN-NULL-IND-11.       
           MOVE -1                          TO WS-RN-NULL-IND-12.       
           MOVE -1                          TO WS-RN-NULL-IND-13.       
                                                                        
       5005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************12400000
      * 5010 INSERT REFUND.                                            *12410000
      ******************************************************************12460000
                                                                        
       5010-INSERT-REFUND.                                              
                                                                        
           MOVE '5010'                      TO ACTIVE-PARAGRAPH.        
           PERFORM 7020-GET-REFUND-ITEM-ID  THRU 7020-EXIT.             
           MOVE WS-CURRENT-TIMESTAMP        TO RN-TRANS-HIST-SEQ-NO.    
                                                                        
           IF RN-CHECK-STATUS-CD = 'R'                                  
              MOVE SPACES                   TO RN-USER-ID-APPRVD-BY     
              MOVE WS-USER-ID               TO RN-USER-ID-RQSTED-BY     
              MOVE -1                       TO WS-RN-NULL-IND-1         
           ELSE                                                         
              IF RN-CHECK-STATUS-CD = 'A' OR 'I'                        
                 IF PARM-ACTION-CODE = 'I'                              
                    MOVE WS-USER-ID         TO RN-USER-ID-APPRVD-BY     
                                               RN-USER-ID-RQSTED-BY     
                    MOVE 0                  TO WS-RN-NULL-IND-1         
                    MOVE WS-CURRENT-DATE    TO RN-DATE-REFUNDED         
                                               RN-REQUEST-DT            
                 ELSE                                                   
                    MOVE WS-USER-ID         TO RN-USER-ID-APPRVD-BY     
                    MOVE -1                 TO WS-RN-NULL-IND-1         
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE AT-LOCAL-OFFICE             TO RN-LOCAL-OFFICE.         
                                                                        
           IF WS-ADDRESS-CHANGED-FL = 'Y'                               
              MOVE 'I'                      TO WS-KR363-ACTION-FLAG     
              PERFORM 5100-ADDRESS-PROCESS     THRU 5100-KR363-EXIT     
              MOVE WS-90-NEW-ADDRESS-ID     TO RN-ADDRESS-ID            
           ELSE                                                         
              MOVE 0                        TO RN-ADDRESS-ID            
           END-IF.                                                      
                                                                        
           MOVE 0                           TO RN-REFUND-CHECK-NO.      
           MOVE 0                           TO RN-DEPOSIT-CERT-NO.      
           MOVE SPACE                       TO RN-RETURNED-REASON.      
           MOVE WS-CURRENT-DATE             TO RN-REFUND-STATUS-DT.     
                                                                        
           PERFORM 8010-INSERT-REFUND       THRU 8010-EXIT.             
                                                                        
       5010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5100-ADDRESS-PROCESS                                           *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01670000
              INCLUDE CPDKR363                                          01680000
           END-EXEC.                                                    01690000
                                                                        
      ******************************************************************        
      * 5200-CRED-BAL-JRNL-PROCESS.                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDKR364                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************24940000
      * 5950-SET-MNT-TRANS-VARS                                        *24950000
      ******************************************************************25010000
                                                                        
       5950-SET-MNT-TRANS-VARS.                                         
                                                                        
           MOVE '5950'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           MOVE WS-CURRENT-TIMESTAMP        TO MH-TRANS-HIST-SEQ-NO.    
           MOVE WS-CURRENT-DATE             TO MH-DATE-TRANS.           
           MOVE WS-CODE-TRAN-TYPE           TO MH-CODE-TRAN-TYPE.       
           MOVE PF-RESP-AREA-ID             TO MH-RESP-AREA-ID.         
           MOVE WS-ACCOUNT-NO-COMP3         TO MH-ACCOUNT-NO.           
           MOVE 0                           TO MH-CUSTOMER-NO.          
           MOVE 0                           TO MH-PREMISE-NO.           
           MOVE WS-USERID                   TO MH-USER-ID.              
           MOVE WS-PANEL-NO                 TO MH-APPL-PROGRAM-ID.      
           IF WS-TRANS-COMMENTS-LEN > 0                                 
              MOVE WS-TRANS-COMMENTS-TEXT   TO MH-TRAN-COMMENT-TEXT     
              MOVE WS-TRANS-COMMENTS-LEN    TO MH-TRAN-COMMENT-LEN      
           ELSE                                                         
              MOVE SPACES                   TO MH-TRAN-COMMENT-TEXT     
              MOVE 0                        TO MH-TRAN-COMMENT-LEN      
           END-IF                                                       
                                                                        
           MOVE WS-TABLE-ID                 TO MI-TABLE-ID.             
           MOVE WS-COLUMN-DESC              TO MI-COLUMN-DESC.          
           MOVE WS-CURRENT-TIMESTAMP        TO MI-TRANS-HIST-SEQ-NO.    
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE WS-PRV-COLUMN-VALUE-TEXT    TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE WS-PRV-COLUMN-VALUE-LEN     TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE WS-CHG-COLUMN-VALUE-TEXT    TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE WS-CHG-COLUMN-VALUE-LEN     TO MI-CHG-COLUMN-VALUE-LEN. 
                                                                        
       5950-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6202-GET-NEW-ADDRESS-ID                                        *        
      ******************************************************************        
                                                                        
            EXEC SQL                                                    25490000
               INCLUDE CPD00090                                         25500000
            END-EXEC.                                                   25510000
                                                                        
      ******************************************************************        
      * 6210-CALCULATE-CHECK-DIGIT                                     *        
      ******************************************************************        
                                                                        
            COPY CPD00071.                                              25390000
                                                                        
      ******************************************************************        
      * 6400-ONLINE-JRNL-ROUTINE                                       *        
      ******************************************************************        
                                                                        
            EXEC SQL                                                    25350000
               INCLUDE CPD0006A                                         25360000
            END-EXEC.                                                   25370000
                                                                        
                                                                        
      ******************************************************************        
      * 6530-LOAD-MNT-TRANS-HIST                                       *        
      ******************************************************************        
                                                                        
            EXEC SQL                                                    25450000
               INCLUDE CPD00067                                         25460000
            END-EXEC.                                                   25470000
                                                                        
      ******************************************************************25540000
      * 7000-GET-CURRENT-DATE                                          *25550000
      ******************************************************************25580000
                                                                        
       7000-GET-CURRENT-DATE.                                           
                                                                        
           MOVE '7000'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
                 SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     25630000
MFA-TR*          SET :WS-CURRENT-DATE = CURRENT DATE                    25640000
MFA-TR*    END-EXEC.                                                    25650000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE PARM-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************26860000
      * 7010-GET-RESP-AREA-ID                                          *26870000
      ******************************************************************26900000
                                                                        
       7010-GET-RESP-AREA-ID.                                           
                                                                        
           MOVE '7010'                      TO ACTIVE-PARAGRAPH.        
           MOVE WS-USER-ID                  TO PF-USER-ID.              
                                                                        
           EXEC SQL                                                     
               SELECT RESP_AREA_ID                                      
                 INTO :PF-RESP-AREA-ID                                  
                 FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
                WHERE USER_ID = :PF-USER-ID                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     26960000
MFA-TR*        SELECT RESP_AREA_ID                                      26970000
MFA-TR*          INTO :PF-RESP-AREA-ID                                  26980000
MFA-TR*          FROM CSS_USER_PROFILE                                  26990000
MFA-TR*         WHERE USER_ID = :PF-USER-ID                             27000000
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7010                                                      
MFA-TR*    END-EXEC.                                                    27010000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7010'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_USER_PROFILE  '     TO TABLE-1                  
              MOVE 'USER_ID'                TO TABLE-ELEMENT-1          
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2          
              MOVE PF-USER-ID               TO HOSTVAR-ELEMENT-1        
              MOVE PARM-ACCOUNT-NO          TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************27270000
      * 7020-GET-REFUND-ITEM-ID.                                       *27280000
      ******************************************************************27300000
                                                                        
       7020-GET-REFUND-ITEM-ID.                                         
                                                                        
           MOVE '7020'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               SELECT MAX(REFUND_ITEM_ID)                               
                 INTO :RN-REFUND-ITEM-ID :WS-RN-NULL-ITEM                
                 FROM CSS_REFUND WITH(READUNCOMMITTED)                          
                WHERE ACCOUNT_NO = :RN-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     27340000
MFA-TR*        SELECT MAX(REFUND_ITEM_ID)                               27350000
MFA-TR*          INTO :RN-REFUND-ITEM-ID:WS-RN-NULL-ITEM                27360000
MFA-TR*          FROM CSS_REFUND                                        27370000
MFA-TR*         WHERE ACCOUNT_NO = :RN-ACCOUNT-NO                       27380000
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7020                                                      
MFA-TR*    END-EXEC.                                                    27390000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-RN-NULL-ITEM = -1                                   
                 MOVE 1                     TO RN-REFUND-ITEM-ID        
              ELSE                                                      
                 COMPUTE RN-REFUND-ITEM-ID = RN-REFUND-ITEM-ID + 1      
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7020'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_REFUND'             TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE RN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7820-UPDATE-CODES                                                       
      ******************************************************************        
                                                                        
       7820-UPDATE-CODES.                                               
                                                                        
           MOVE WS-CODES-DATA-PRESENT  TO AT-CODES-DATA-PRESENT.        
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
              SET    CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT,       
                     LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :AT-LAST-UPDATE-TS
              )            
              WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     29200000
MFA-TR*       UPDATE CSS_ACCOUNT                                        29210000
MFA-TR*       SET    CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT,       29220000
MFA-TR*              LAST_UPDATE_TS     = :AT-LAST-UPDATE-TS                    
MFA-TR*       WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        29230000
MFA-TR*    END-EXEC.                                                    29240000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7820'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'LAST_UPDATE_TS'         TO TABLE-ELEMENT-2          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE AT-LAST-UPDATE-TS        TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7820-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************34450000
      *  7999-SELECT-AL                                                *34460000
      ******************************************************************34470000
                                                                        
           EXEC SQL                                                     34490000
              INCLUDE CPD00075                                          34500000
           END-EXEC.                                                    34510000
                                                                        
      ******************************************************************        
      * 7999-SELECT-TRANSFER-IND                                       *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     34530000
              INCLUDE CPD00307                                          34540000
           END-EXEC.                                                    34550000
                                                                        
      ******************************************************************29790000
      * 8010-INSERT-REFUND.                                            *29800000
      ******************************************************************29820000
                                                                        
       8010-INSERT-REFUND.                                              
                                                                        
           MOVE '8010'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_REFUND                                  
                       (REFUND_ITEM_ID,                                 
                        REFUND_CHECK_NO,                                
                        DEPOSIT_CERT_NO,                                
                        LOCAL_OFFICE,                                   
                        AMT_REFUNDED,                                   
                        DATE_REFUNDED,                                  
                        REQUEST_DT,                                     
                        CHECK_STATUS_CD,                                
                        CHECK_ISS_REAS_CD,                              
                        ORIGINAL_CHECK_NO,                              
                        RETURNED_REASON,                                
                        MANUAL_INDICATOR,                               
                        USER_ID_APPRVD_BY,                              
                        REFUND_STATUS_DT,                               
                        USER_ID_RQSTED_BY,                              
                        ACCOUNT_NO,                                     
                        COMMENTS,                                       
                        PANEL_NO,                                       
                        ADDRESS_ID,                                     
                        TRANS_HIST_SEQ_NO,                              
                        CLEARED_DT,                                     
                        DATE_CHECK_VOIDED,                              
                        STOP_REQUEST_DT,                                
                        STOP_CONFIRM_DT,                                
                        CHECK_REMAIL_DT,                                
                        REISSUED_DATE,                                  
                        RETURNED_DATE,                                  
                        DATE_APPROPRIATED,                              
                        DATE_ESCHEATED,                                 
                        DATE_CANCELLED)                                 
                VALUES                                                  
                      (:RN-REFUND-ITEM-ID,                              
                       :RN-REFUND-CHECK-NO,                             
                       :RN-DEPOSIT-CERT-NO,                             
                       :RN-LOCAL-OFFICE,                                
                       :RN-AMT-REFUNDED,                                
                       IIF(TRY_CONVERT(DATE, :RN-DATE-REFUNDED 
                                             :WS-RN-NULL-IND-1
              ) IS NULL OR (PATINDEX('%.%', :RN-DATE-REFUNDED 
                                                      :WS-RN-NULL-IND-1
              ) <> 0) OR (LEN(:RN-DATE-REFUNDED :WS-RN-NULL-IND-1
              ) <> 10), CIS.CHAR2DATE(:RN-DATE-REFUNDED 
                                                      :WS-RN-NULL-IND-1
              ), CONVERT(DATE, :RN-DATE-REFUNDED :WS-RN-NULL-IND-1) ),         
                       IIF(TRY_CONVERT(DATE, :RN-REQUEST-DT 
                                             :WS-RN-NULL-IND-2
              ) IS NULL OR (PATINDEX('%.%', :RN-REQUEST-DT 
                                                      :WS-RN-NULL-IND-2
              ) <> 0) OR (LEN(:RN-REQUEST-DT :WS-RN-NULL-IND-2
              ) <> 10), CIS.CHAR2DATE(:RN-REQUEST-DT :WS-RN-NULL-IND-2
              ), CONVERT(DATE, :RN-REQUEST-DT :WS-RN-NULL-IND-2) ),            
                       :RN-CHECK-STATUS-CD,                             
                       :RN-CHECK-ISS-REAS-CD,                           
                       :RN-ORIGINAL-CHECK-NO,                           
                       :RN-RETURNED-REASON,                             
                       :RN-MANUAL-INDICATOR,                            
                       :RN-USER-ID-APPRVD-BY,                           
                       IIF(TRY_CONVERT(DATE, :RN-REFUND-STATUS-DT 
                                             :WS-RN-NULL-IND-3
              ) IS NULL OR (PATINDEX('%.%', :RN-REFUND-STATUS-DT 
                                                      :WS-RN-NULL-IND-3
              ) <> 0) OR (LEN(:RN-REFUND-STATUS-DT :WS-RN-NULL-IND-3
              ) <> 10), CIS.CHAR2DATE(:RN-REFUND-STATUS-DT 
                                                      :WS-RN-NULL-IND-3
              ), CONVERT(DATE, :RN-REFUND-STATUS-DT :WS-RN-NULL-IND-3
              ) ),           
                       :RN-USER-ID-RQSTED-BY,                           
                       :RN-ACCOUNT-NO,                                  
                       :RN-COMMENTS,                                    
                       :RN-PANEL-NO,                                    
                       :RN-ADDRESS-ID,                                  
                       CIS.CHAR2TIMESTAMP(:RN-TRANS-HIST-SEQ-NO),               
                       IIF(TRY_CONVERT(DATE, :RN-CLEARED-DT 
                                             :WS-RN-NULL-IND-4
              ) IS NULL OR (PATINDEX('%.%', :RN-CLEARED-DT 
                                                      :WS-RN-NULL-IND-4
              ) <> 0) OR (LEN(:RN-CLEARED-DT :WS-RN-NULL-IND-4
              ) <> 10), CIS.CHAR2DATE(:RN-CLEARED-DT :WS-RN-NULL-IND-4
              ), CONVERT(DATE, :RN-CLEARED-DT :WS-RN-NULL-IND-4) ),            
                       IIF(TRY_CONVERT(DATE, :RN-DATE-CHECK-VOIDED 
                                             :WS-RN-NULL-IND-5
              ) IS NULL OR (PATINDEX('%.%', :RN-DATE-CHECK-VOIDED 
                                                      :WS-RN-NULL-IND-5
              ) <> 0) OR (LEN(:RN-DATE-CHECK-VOIDED :WS-RN-NULL-IND-5
              ) <> 10), CIS.CHAR2DATE(:RN-DATE-CHECK-VOIDED 
                                                      :WS-RN-NULL-IND-5
              ), CONVERT(DATE, :RN-DATE-CHECK-VOIDED :WS-RN-NULL-IND-5
              ) ),          
                       IIF(TRY_CONVERT(DATE, :RN-STOP-REQUEST-DT 
                                             :WS-RN-NULL-IND-6
              ) IS NULL OR (PATINDEX('%.%', :RN-STOP-REQUEST-DT 
                                                      :WS-RN-NULL-IND-6
              ) <> 0) OR (LEN(:RN-STOP-REQUEST-DT :WS-RN-NULL-IND-6
              ) <> 10), CIS.CHAR2DATE(:RN-STOP-REQUEST-DT 
                                                      :WS-RN-NULL-IND-6
              ), CONVERT(DATE, :RN-STOP-REQUEST-DT :WS-RN-NULL-IND-6
              ) ),            
                       IIF(TRY_CONVERT(DATE, :RN-STOP-CONFIRM-DT 
                                             :WS-RN-NULL-IND-7
              ) IS NULL OR (PATINDEX('%.%', :RN-STOP-CONFIRM-DT 
                                                      :WS-RN-NULL-IND-7
              ) <> 0) OR (LEN(:RN-STOP-CONFIRM-DT :WS-RN-NULL-IND-7
              ) <> 10), CIS.CHAR2DATE(:RN-STOP-CONFIRM-DT 
                                                      :WS-RN-NULL-IND-7
              ), CONVERT(DATE, :RN-STOP-CONFIRM-DT :WS-RN-NULL-IND-7
              ) ),            
                       IIF(TRY_CONVERT(DATE, :RN-CHECK-REMAIL-DT 
                                             :WS-RN-NULL-IND-8
              ) IS NULL OR (PATINDEX('%.%', :RN-CHECK-REMAIL-DT 
                                                      :WS-RN-NULL-IND-8
              ) <> 0) OR (LEN(:RN-CHECK-REMAIL-DT :WS-RN-NULL-IND-8
              ) <> 10), CIS.CHAR2DATE(:RN-CHECK-REMAIL-DT 
                                                      :WS-RN-NULL-IND-8
              ), CONVERT(DATE, :RN-CHECK-REMAIL-DT :WS-RN-NULL-IND-8
              ) ),            
                       IIF(TRY_CONVERT(DATE, :RN-REISSUED-DATE 
                                             :WS-RN-NULL-IND-9
              ) IS NULL OR (PATINDEX('%.%', :RN-REISSUED-DATE 
                                                      :WS-RN-NULL-IND-9
              ) <> 0) OR (LEN(:RN-REISSUED-DATE :WS-RN-NULL-IND-9
              ) <> 10), CIS.CHAR2DATE(:RN-REISSUED-DATE 
                                                      :WS-RN-NULL-IND-9
              ), CONVERT(DATE, :RN-REISSUED-DATE :WS-RN-NULL-IND-9) ),         
                       IIF(TRY_CONVERT(DATE, :RN-RETURNED-DATE 
                                             :WS-RN-NULL-IND-10
              ) IS NULL OR (PATINDEX('%.%', :RN-RETURNED-DATE 
                                                     :WS-RN-NULL-IND-10
              ) <> 0) OR (LEN(:RN-RETURNED-DATE :WS-RN-NULL-IND-10
              ) <> 10), CIS.CHAR2DATE(:RN-RETURNED-DATE 
                                                     :WS-RN-NULL-IND-10
              ), CONVERT(DATE, :RN-RETURNED-DATE :WS-RN-NULL-IND-10) ),        
                       IIF(TRY_CONVERT(DATE, :RN-DATE-APPROPRIATED 
                                             :WS-RN-NULL-IND-11
              ) IS NULL OR (PATINDEX('%.%', :RN-DATE-APPROPRIATED 
                                                     :WS-RN-NULL-IND-11
              ) <> 0) OR (LEN(:RN-DATE-APPROPRIATED :WS-RN-NULL-IND-11
              ) <> 10), CIS.CHAR2DATE(:RN-DATE-APPROPRIATED 
                                                     :WS-RN-NULL-IND-11
              ), CONVERT(DATE, :RN-DATE-APPROPRIATED :WS-RN-NULL-IND-11
              ) ),         
                       IIF(TRY_CONVERT(DATE, :RN-DATE-ESCHEATED 
                                             :WS-RN-NULL-IND-12
              ) IS NULL OR (PATINDEX('%.%', :RN-DATE-ESCHEATED 
                                                     :WS-RN-NULL-IND-12
              ) <> 0) OR (LEN(:RN-DATE-ESCHEATED :WS-RN-NULL-IND-12
              ) <> 10), CIS.CHAR2DATE(:RN-DATE-ESCHEATED 
                                                     :WS-RN-NULL-IND-12
              ), CONVERT(DATE, :RN-DATE-ESCHEATED :WS-RN-NULL-IND-12
              ) ),            
                       IIF(TRY_CONVERT(DATE, :RN-DATE-CANCELLED 
                                             :WS-RN-NULL-IND-13
              ) IS NULL OR (PATINDEX('%.%', :RN-DATE-CANCELLED 
                                                     :WS-RN-NULL-IND-13
              ) <> 0) OR (LEN(:RN-DATE-CANCELLED :WS-RN-NULL-IND-13
              ) <> 10), CIS.CHAR2DATE(:RN-DATE-CANCELLED 
                                                     :WS-RN-NULL-IND-13
              ), CONVERT(DATE, :RN-DATE-CANCELLED :WS-RN-NULL-IND-13
              ) ))            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     29860000
MFA-TR*         INSERT INTO CSS_REFUND                                  29870000
MFA-TR*                (REFUND_ITEM_ID,                                 29880000
MFA-TR*                 REFUND_CHECK_NO,                                29890000
MFA-TR*                 DEPOSIT_CERT_NO,                                29900000
MFA-TR*                 LOCAL_OFFICE,                                   29910000
MFA-TR*                 AMT_REFUNDED,                                   29920000
MFA-TR*                 DATE_REFUNDED,                                  29930000
MFA-TR*                 REQUEST_DT,                                     29940000
MFA-TR*                 CHECK_STATUS_CD,                                29950000
MFA-TR*                 CHECK_ISS_REAS_CD,                              29960000
MFA-TR*                 ORIGINAL_CHECK_NO,                              29970000
MFA-TR*                 RETURNED_REASON,                                29980000
MFA-TR*                 MANUAL_INDICATOR,                               29990000
MFA-TR*                 USER_ID_APPRVD_BY,                              30000000
MFA-TR*                 REFUND_STATUS_DT,                               30010000
MFA-TR*                 USER_ID_RQSTED_BY,                              30020000
MFA-TR*                 ACCOUNT_NO,                                     30030000
MFA-TR*                 COMMENTS,                                       30040000
MFA-TR*                 PANEL_NO,                                       30050000
MFA-TR*                 ADDRESS_ID,                                     30060000
MFA-TR*                 TRANS_HIST_SEQ_NO,                              30070000
MFA-TR*                 CLEARED_DT,                                     30080000
MFA-TR*                 DATE_CHECK_VOIDED,                              30090000
MFA-TR*                 STOP_REQUEST_DT,                                30100000
MFA-TR*                 STOP_CONFIRM_DT,                                30110000
MFA-TR*                 CHECK_REMAIL_DT,                                30120000
MFA-TR*                 REISSUED_DATE,                                  30130000
MFA-TR*                 RETURNED_DATE,                                  30140000
MFA-TR*                 DATE_APPROPRIATED,                              30150000
MFA-TR*                 DATE_ESCHEATED,                                 30160000
MFA-TR*                 DATE_CANCELLED)                                 30170000
MFA-TR*         VALUES                                                  30180000
MFA-TR*               (:RN-REFUND-ITEM-ID,                              30190000
MFA-TR*                :RN-REFUND-CHECK-NO,                             30200000
MFA-TR*                :RN-DEPOSIT-CERT-NO,                             30210000
MFA-TR*                :RN-LOCAL-OFFICE,                                30220000
MFA-TR*                :RN-AMT-REFUNDED,                                30230000
MFA-TR*                :RN-DATE-REFUNDED:WS-RN-NULL-IND-1,              30240000
MFA-TR*                :RN-REQUEST-DT:WS-RN-NULL-IND-2,                 30250000
MFA-TR*                :RN-CHECK-STATUS-CD,                             30260000
MFA-TR*                :RN-CHECK-ISS-REAS-CD,                           30270000
MFA-TR*                :RN-ORIGINAL-CHECK-NO,                           30280000
MFA-TR*                :RN-RETURNED-REASON,                             30290000
MFA-TR*                :RN-MANUAL-INDICATOR,                            30300000
MFA-TR*                :RN-USER-ID-APPRVD-BY,                           30310000
MFA-TR*                :RN-REFUND-STATUS-DT:WS-RN-NULL-IND-3,           30320000
MFA-TR*                :RN-USER-ID-RQSTED-BY,                           30330000
MFA-TR*                :RN-ACCOUNT-NO,                                  30340000
MFA-TR*                :RN-COMMENTS,                                    30350000
MFA-TR*                :RN-PANEL-NO,                                    30360000
MFA-TR*                :RN-ADDRESS-ID,                                  30370000
MFA-TR*                :RN-TRANS-HIST-SEQ-NO,                           30380000
MFA-TR*                :RN-CLEARED-DT:WS-RN-NULL-IND-4,                 30390000
MFA-TR*                :RN-DATE-CHECK-VOIDED:WS-RN-NULL-IND-5,          30400000
MFA-TR*                :RN-STOP-REQUEST-DT:WS-RN-NULL-IND-6,            30410000
MFA-TR*                :RN-STOP-CONFIRM-DT:WS-RN-NULL-IND-7,            30420000
MFA-TR*                :RN-CHECK-REMAIL-DT:WS-RN-NULL-IND-8,            30430000
MFA-TR*                :RN-REISSUED-DATE:WS-RN-NULL-IND-9,              30440000
MFA-TR*                :RN-RETURNED-DATE:WS-RN-NULL-IND-10,             30450000
MFA-TR*                :RN-DATE-APPROPRIATED:WS-RN-NULL-IND-11,         30460000
MFA-TR*                :RN-DATE-ESCHEATED:WS-RN-NULL-IND-12,            30470000
MFA-TR*                :RN-DATE-CANCELLED:WS-RN-NULL-IND-13)            30480000
MFA-TR*    END-EXEC.                                                    30490000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8010'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'CSS_REFUND'             TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'DATE_APPROPRIATED'      TO TABLE-ELEMENT-2          
              MOVE 'DATE_ESCHEATED'         TO TABLE-ELEMENT-3          
              MOVE 'DATE_CANCELLED'         TO TABLE-ELEMENT-4          
              MOVE WS-ACCOUNT-NO-COMP3      TO HOSTVAR-ELEMENT-1        
              MOVE RN-DATE-APPROPRIATED     TO HOSTVAR-ELEMENT-2        
              MOVE RN-DATE-ESCHEATED        TO HOSTVAR-ELEMENT-3        
              MOVE RN-DATE-CANCELLED        TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
                                                                        
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************34580000
      * 9900-SQL-ERROR-ROUTINE                                         *34590000
      ******************************************************************34600000
                                                                        
           EXEC SQL                                                     34610000
              INCLUDE CPDSP300                                          34620000
           END-EXEC.                                                    34630000
                                                                        
      ******************************************************************        
      * 9700-PROCESS-ABEND                                             *        
      ******************************************************************        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************34650000
      *  8100-SEND-RESULT                                              *34660000
      ******************************************************************34670000
                                                                        
       8100-SEND-RESULT.                                                
                                                                        
             ADD 1 TO CTR-ROWS.                                         
                                                                        
       8100-EXIT.                                                       
              EXIT.                                                     
                                                                        
      ******************************************************************        
      * 8900-SEND-DONE                                                 *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00000100
               INCLUDE CPD00321                                         00000200
           END-EXEC.                                                    00000300
                                                                        
