       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04910.                                         
       AUTHOR.        AARON ABRAHAM                                     
COB303 DATE-WRITTEN.  JAN 26, 2016.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *  This procedure is used to refund Previous Payment and it is   *        
      *  being called from Issue Refund view.                          *        
      *                                                                *        
      *  # Main program CSR04888                                       *        
      *  # Cloned from CSR02135                                        *        
      *  # Removed Update and Disapprove related logic                 *        
      *  # Write Journals and transaction history                      *        
      *  # Invoked from Account Receivable Solution/Refunds Project    *        
      *  # BusOp Name: RequUpdIssueRefund                              *00001600
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      * ---------- -------- ------------------------------------------ *        
      *    DATE    INITIALS COMMENTS                                   *        
      * ---------- -------- ------------------------------------------ *        
P00870* 10/02/2015 AA97148  INITIAL IMPLEMENTATION.                    *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04910'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04910 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_BUDGET_PLAN       - BU                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBGTPLN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CHRG_OFF          - CO                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCHGOFF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CNT_DETAIL        - EA                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCNTDET                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CRED_COLL         - CL                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCRCOLL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_FINAL_WO          - FW                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBFINLWO                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_BUDGET_HIST       - BH                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBGTHST                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_REFUND            - RN                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBREFUND                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_AR_TRANS_HIST     - AR                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBARHIST                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_AR_TRN_HST_DET    - AU                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBARHDT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_ACCOUNT           - AT                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_AR_LOCKOUT        - AL                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBARLOCK                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_PREMISE           - PR                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_ADDR_FORMATTED    - DY                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_ADDR_FREEFORM     - DZ                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_ZIP_CODE          - A4                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_GL_ACCT_NO        - GO                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBGLATNO                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_ADDR_ID_CNTL      - I8                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADDRID                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_MT_TRN_HST_DET    - MI                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_MNT_TRANS_HIST    - MH                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_USER_PROFILE      - PF                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_AR_CNTL           - AC                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_DFA_RECVBLE       - DV                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBDFARCV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_DFA_ACCT          - DA                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBDFAACT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_DEP_PAY_HST       - DP                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBDEPHST                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_DEP_ON_HAND       - DO                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBDEPHND                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_BATCH_JRNL        - BJ                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBTJRNL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CSH_DRWR_JRNL     - CJ                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCDJRNL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_RESP_AREA         - C1                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRSAREA                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CONTRACT          - CT                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCNTRCT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_DEP_REQ           - DR                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBDEPREQ                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CUSTOMER          - CU                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_PROJ_SHARE        - PJ                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPRJSHR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_BCH_JRNL_CNTL     - BC                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBJCNTL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CSH_DRWR_CNTL     - CS                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCDCNTL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_MISC_JRNL         - MJ                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMSJRNL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_JOB_PARM          - G6                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_RATE_PLAN_DESC    - RD                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
             INCLUDE TBRTDESC                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_UTIL_ENVRNMT      - UT                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CONNECT_CHRG      - CC                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01020000
              INCLUDE TBCCCHRG                                          01030000
           END-EXEC.                                                    01040000
                                                                        
      ******************************************************************        
      * CSS_LOCAL_OFFICE      - B1                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01532000
              INCLUDE TBLOCOFC                                          01533000
           END-EXEC.                                                    01534000
                                                                        
      ******************************************************************        
      * CSS_DELINQUENCY       - C8                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01532000
              INCLUDE TBDELQ                                            01533000
           END-EXEC.                                                    01534000
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      * ERROR HANDLING                                                 *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      * WORKING STORAGE COPYBOOKS FOR CPD00068                         *        
      ******************************************************************        
                                                                        
           COPY CWS00056.                                                       
                                                                        
      ******************************************************************        
      * CASH JOURNAL OF FORMAT 101                                     *        
      ******************************************************************        
                                                                        
           COPY CJF00101.                                                       
           COPY CJF00113.                                                       
                                                                        
      ******************************************************************        
      * WS FOR REFUND CPD CPD00116                                     *        
      ******************************************************************        
           COPY CJF00113.                                                       
           EXEC SQL                                                             
              INCLUDE CWS0116A                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * WS FOR CPD00077 CPYC                                           *        
      ******************************************************************        
                                                                        
           COPY CWS00077.                                                       
                                                                        
      ******************************************************************        
      * NEEDED FOR PAYMENT APPLICATION ROUTINE                         *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00017                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * WS FOR GENERAL LEDGER MNEMONICS AND NUMBERS                    *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWS00061                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * WS FOR CPD0013B                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS0013B                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * WS FOR CPD00090                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS0090A                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    WORKING STORAGE FOR CPDKR363                                         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     01670000
              INCLUDE CWSKR363                                          01680000
           END-EXEC.                                                    01690000
                                                                        
      ******************************************************************        
      * WS FOR CPD00071                                                *        
      ******************************************************************        
                                                                        
           COPY CWS00071.                                                       
                                                                        
      ******************************************************************        
      * WS FOR SCSCA225                                                *        
      ******************************************************************        
                                                                        
           COPY CWSCA225.                                                       
                                                                        
      ******************************************************************        
      * WS FOR SCSCA224                                                *        
      ******************************************************************        
                                                                        
           COPY CWSCA224.                                                       
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05 WS-RN-NULL-ITEM               PIC S9(4) COMP.             
           05 WS-RN-NULL-IND-1              PIC S9(4) COMP.             
           05 WS-RN-NULL-IND-2              PIC S9(4) COMP.             
           05 WS-RN-NULL-IND-3              PIC S9(4) COMP.             
           05 WS-RN-NULL-IND-4              PIC S9(4) COMP.             
           05 WS-RN-NULL-IND-5              PIC S9(4) COMP.             
           05 WS-RN-NULL-IND-6              PIC S9(4) COMP.             
           05 WS-RN-NULL-IND-7              PIC S9(4) COMP.             
           05 WS-RN-NULL-IND-8              PIC S9(4) COMP.             
           05 WS-RN-NULL-IND-9              PIC S9(4) COMP.             
           05 WS-RN-NULL-IND-10             PIC S9(4) COMP.             
           05 WS-RN-NULL-IND-11             PIC S9(4) COMP.             
           05 WS-RN-NULL-IND-12             PIC S9(4) COMP.             
           05 WS-RN-NULL-IND-13             PIC S9(4) COMP.             
           05 WS-RN-NULL-IND-14             PIC S9(4) COMP.             
           05 WS-AR-NULL-IND-1              PIC S9(4) COMP.             
           05 WS-AR-NULL-IND-2              PIC S9(4) COMP.             
           05 WS-AR-NULL-IND-3              PIC S9(4) COMP.             
                                                                        
       01  WS-MISC.                                                     
COB305     05 WS-PREMISE-NO        PIC S9(10)V COMP-3 VALUE 0.           
           05 WS-UPD-AR                  PIC X(1) VALUE 'Y'.            
           05 WS-FLAG                    PIC X(1) VALUE SPACES.         
           05 WS-USER-ID                 PIC X(7).                      
           05 WS-REFUND-EXISTS           PIC S9(04) COMP VALUE 0.       
           05 WS-REQ-EXISTS              PIC X(01) VALUE 'N'.           
           05 WS-REFUND-ITEM-ID          PIC S9(9) USAGE COMP.          
           05 WS-MANUAL-INDICATOR        PIC X(01).                     
           05 PROGRAM-NAME               PIC X(08) VALUE 'CSR04910'.    
           05 WS-UNPACK-ALPHA-NUM.                                      
              10 WS-UNPACK-NUMBER        PIC 9(10).                     
           05 WS-UNPACK-ALPHA-NUM4.                                     
              10 WS-UNPACK-NUMBER4       PIC 9(04).                     
           05 WS-UNPACK-VALUES.                                         
              10 WS-UNPACK-VALUES-N      PIC 9(11)V9(2).                
           05 RS-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
           05 WS-ADDRESS-CHANGED-FL      PIC X(01)  VALUE SPACES.       
                                                                        
       01  WS-REFUND-TABLE.                                             
           05 WS-ACTION-CODE             PIC X(1).                      
           05 WS-PARM-ACCOUNT-NO         PIC X(13).                     
           05 WS-ACCOUNT-NO-NUM REDEFINES WS-PARM-ACCOUNT-NO            
                                         PIC 9(13).                     
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13)V COMP-3 VALUE 0.            
           05 WS-PREV-TRANS-HIST-SEQ-NO  PIC X(26).                     
           05 WS-TRANS-HIST-SEQ-NO       PIC X(26).                     
           05 WS-AMT-REFUNDED            PIC X(11).                     
           05 WS-AMT-REFUNDED-NUM REDEFINES WS-AMT-REFUNDED             
                                         PIC 9(09)V99.                  
           05 WS-TOT-ORIG-AMT-X          PIC X(11).                     
           05 WS-TOT-ORIG-AMT-NUM REDEFINES WS-TOT-ORIG-AMT-X           
                                         PIC 9(09)V99.                  
           05 WS-TOTAL-ORIG-AMT          PIC S9(9)V99  COMP-3 VALUE 0.  
           05 WS-AMT-POSTED              PIC X(11).                     
           05 WS-AMT-POSTED-NUM   REDEFINES WS-AMT-POSTED               
                                         PIC 9(09)V99.                  
           05 WS-LENGTH                  PIC X(04).                     
           05 WS-LENGTH-NUM       REDEFINES WS-LENGTH                   
                                         PIC 9(04).                     
           05 WS-CASH-DRWR               PIC X(04).                     
           05 WS-CASH-DRWR-NUM    REDEFINES WS-CASH-DRWR                
                                         PIC 9(04).                     
           05 WS-COMPANY-NO              PIC X(2).                      
           05  MCSCB077                  PIC X(08)  VALUE 'MCSCB077'.   
           05 WS-LOCAL-OFFICE            PIC X(3).                      
           05 WS-CHECK-STATUS-CD         PIC X(1).                      
           05 WS-REF-COMMENTS            PIC X(72).                     
           05 WS-TRANS-COMMENTS          PIC X(210).                    
           05 WS-TRANS-COMMENTS-LEN      PIC S9(4) COMP.                
           05  MCSCB225                 PIC X(8) VALUE  'MCSCB225'.     
           05  MCSCB224                 PIC X(8) VALUE  'MCSCB224'.     
                                                                        
       01  WS-MNT-TRANS-HIST.                                           
           05  WS-USERID                  PIC X(08)  VALUE SPACES.      
           05  WS-CURRENT-DATE            PIC X(10)  VALUE SPACES.      
           05  WS-CURRENT-TIMESTAMP       PIC X(26)  VALUE SPACES.      
           05  WS-PANEL-NO                PIC X(09)  VALUE 'PANEL111'.  
           05  WS-RESP-AREA-ID            PIC X(03)   VALUE SPACES.     
COB305     05 WS-PREMISE-NO-COMP        PIC S9(10) COMP-3 VALUE 0.           
                                                                        
       01  WS-MNT-TRANS-DET.                                            
           05  WS-CODE-TRAN-TYPE          PIC X(01)   VALUE 'F'.        
           05  WS-TRAN-APPL-NO            PIC S9(02)  VALUE 0.          
           05  WS-TABLE-ID                PIC X(02)   VALUE SPACES.     
           05  WS-COLUMN-DESC             PIC X(15)   VALUE SPACES.     
           05  WS-CHG-COLUMN-VALUE-TEXT   PIC X(30)   VALUE SPACES.     
           05  WS-CHG-COLUMN-VALUE-LEN    PIC S9(02)  VALUE 0.          
           05  WS-PRV-COLUMN-VALUE-TEXT   PIC X(30)   VALUE SPACES.     
           05  WS-PRV-COLUMN-VALUE-LEN    PIC S9(02)  VALUE 0.          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  PROCESS-ONCE-SW         PIC X(01) VALUE 'N'.             
               88 PROCESS-ONCE                   VALUE 'Y'.             
           05  WS-UTIL-ACCOUNT          PIC X.                          
               88  UTIL-EXISTS          VALUE 'Y'.                      
               88  NO-UTIL-EXISTS       VALUE 'N'.                      
                                                                        
           05  WS-VALID-RATE-FL         PIC X.                          
               88  VALID-RATE           VALUE 'Y'.                      
               88  NOT-VALID-RATE       VALUE 'N'.                      
                                                                        
           05  WS-DATABASE-COG          PIC 9(01) VALUE ZERO.           
               88  CSR-DATABASE-COG     VALUE 1.                        
               88  SEB-DATABASE-COG     VALUE 2.                        
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
            05 S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
            05 S-APPL-RETURN-CODE      PIC X(10) VALUE SPACES.          
            05 S-AT-LAST-UPDATE-TS     PIC X(26) VALUE SPACE.           
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO              PIC X(13) VALUE SPACES.         
       01  PARM-ACTION-CODE             PIC X(1)  VALUE SPACES.         
       01  PARM-PREV-TRN-SEQ-NO         PIC X(26) VALUE SPACES.         
       01  PARM-PREV-DATE-TRANS         PIC X(10) VALUE SPACES.         
       01  PARM-AMT-REFUNDED            PIC X(11) VALUE SPACES.         
       01  PARM-TOTAL-ORIG-AMT          PIC X(11) VALUE SPACES.         
       01  PARM-CHECK-ISS-REAS-CD       PIC X(2)  VALUE SPACES.         
       01  PARM-CHECK-STATUS-CD         PIC X(1)  VALUE SPACES.         
       01  PARM-COMMENTS-TEXT           PIC X(72) VALUE SPACES.         
       01  PARM-COMMENTS-LEN            PIC X(4)  VALUE SPACES.         
       01  PARM-MANUAL-INDICATOR        PIC X(1)  VALUE SPACES.         
       01  PARM-REQUEST-DT              PIC X(10) VALUE SPACES.         
       01  PARM-GS-USER-ID              PIC X(7)  VALUE SPACES.         
       01  PARM-TRANS-COMMENTS          PIC X(210) VALUE SPACES.        
       01  PARM-TRANS-COMMENTS-LEN      PIC X(4)  VALUE SPACES.         
       01  PARM-CASH-COMPANY-NO         PIC X(02) VALUE SPACES.         
       01  PARM-CASH-LOCAL-OFFICE       PIC X(03) VALUE SPACES.         
       01  PARM-CASH-REPORT-NO          PIC X(03) VALUE SPACES.         
       01  PARM-DATE-CASH-REPORT        PIC X(10) VALUE SPACES.         
       01  PARM-CASH-DRAWER-ID          PIC X(4)  VALUE SPACES.         
       01  PARM-ADDRESS-CHANGED-FL      PIC X(01) VALUE SPACES.         
       01  PARM-ADDRESS-FORMAT          PIC X(01) VALUE SPACES.         
       01  PARM-FMT-HOUSE-NO            PIC X(15) VALUE SPACES.         
       01  PARM-FMT-ADDR-PREFIX-1       PIC X(03) VALUE SPACES.         
       01  PARM-FMT-ADDR-PREFIX-2       PIC X(02) VALUE SPACES.         
       01  PARM-FMT-STREET-NAME         PIC X(30) VALUE SPACES.         
       01  PARM-FMT-STREET-SUFFIX       PIC X(04) VALUE SPACES.         
       01  PARM-FMT-ADDR-SUFFIX         PIC X(02) VALUE SPACES.         
       01  PARM-FMT-STREET-LOCATION-1   PIC X(04) VALUE SPACES.         
       01  PARM-FMT-STREET-LOCATION-2   PIC X(11) VALUE SPACES.         
       01  PARM-FF-ADDR-STREET          PIC X(55) VALUE SPACES.         
       01  PARM-FF-ADDRESS-OVERFLOW     PIC X(35) VALUE SPACES.         
       01  PARM-FF-ADDR-COUNTRY         PIC X(35) VALUE SPACES.         
       01  PARM-FF-ADDRESS-CITY-STATE   PIC X(30) VALUE SPACES.         
       01  PARM-CITY                    PIC X(26) VALUE SPACES.         
       01  PARM-STATE                   PIC X(02) VALUE SPACES.         
       01  PARM-ZIP-CODE                PIC X(05) VALUE SPACES.         
       01  PARM-ZIP-CODE-PLUS-FOUR      PIC X(04) VALUE SPACES.         
       01  PARM-LAST-UPDATE-TS-AT       PIC X(26) VALUE SPACES.         
                                                                        
       PROCEDURE DIVISION USING                                         
                PARM-ACCOUNT-NO                                         
               ,PARM-ACTION-CODE                                        
               ,PARM-PREV-TRN-SEQ-NO                                    
               ,PARM-PREV-DATE-TRANS                                    
               ,PARM-AMT-REFUNDED                                       
               ,PARM-TOTAL-ORIG-AMT                                     
               ,PARM-CHECK-ISS-REAS-CD                                  
               ,PARM-CHECK-STATUS-CD                                    
               ,PARM-COMMENTS-TEXT                                      
               ,PARM-COMMENTS-LEN                                       
               ,PARM-MANUAL-INDICATOR                                   
               ,PARM-REQUEST-DT                                         
               ,PARM-GS-USER-ID                                         
               ,PARM-TRANS-COMMENTS                                     
               ,PARM-TRANS-COMMENTS-LEN                                 
               ,PARM-CASH-COMPANY-NO                                    
               ,PARM-CASH-LOCAL-OFFICE                                  
               ,PARM-CASH-REPORT-NO                                     
               ,PARM-DATE-CASH-REPORT                                   
               ,PARM-CASH-DRAWER-ID                                     
               ,PARM-ADDRESS-CHANGED-FL                                 
               ,PARM-ADDRESS-FORMAT                                     
               ,PARM-FMT-HOUSE-NO                                       
               ,PARM-FMT-ADDR-PREFIX-1                                  
               ,PARM-FMT-ADDR-PREFIX-2                                  
               ,PARM-FMT-STREET-NAME                                    
               ,PARM-FMT-STREET-SUFFIX                                  
               ,PARM-FMT-ADDR-SUFFIX                                    
               ,PARM-FMT-STREET-LOCATION-1                              
               ,PARM-FMT-STREET-LOCATION-2                              
               ,PARM-FF-ADDR-STREET                                     
               ,PARM-FF-ADDRESS-OVERFLOW                                
               ,PARM-FF-ADDR-COUNTRY                                    
               ,PARM-FF-ADDRESS-CITY-STATE                              
               ,PARM-CITY                                               
               ,PARM-STATE                                              
               ,PARM-ZIP-CODE                                           
               ,PARM-ZIP-CODE-PLUS-FOUR                                 
               ,PARM-LAST-UPDATE-TS-AT.                                 

SCA006        SET WS-GL-SUB TO 1.
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 8100-SEND-RESULT    THRU 8100-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
                SELECT                                                  
                  :S-RETURN-CODE               AS RETURN_CODE           
                  ,LTRIM(RTRIM(:S-APPL-RETURN-CODE))  AS 
           APPL_RETURN_CODE      
                  ,LTRIM(RTRIM(:S-AT-LAST-UPDATE-TS)) AS 
           AT_LAST_UPDATE_TS     
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*         SELECT                                                          
MFA-TR*           :S-RETURN-CODE               AS RETURN_CODE                   
MFA-TR*           ,STRIP(:S-APPL-RETURN-CODE)  AS APPL_RETURN_CODE              
MFA-TR*           ,STRIP(:S-AT-LAST-UPDATE-TS) AS AT_LAST_UPDATE_TS             
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************@***********************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO       TO WS-PARM-ACCOUNT-NO.            
           MOVE WS-ACCOUNT-NO-NUM     TO WS-ACCOUNT-NO-COMP3            
                                         RN-ACCOUNT-NO.                 
           MOVE PARM-ACTION-CODE      TO WS-ACTION-CODE.                
           MOVE PARM-PREV-TRN-SEQ-NO  TO WS-PREV-TRANS-HIST-SEQ-NO      
                                         WS-INPUT-TRANS-HIST-SEQ-NO     
                                         WS-TRANS-HIST-SEQ-NO.          
           MOVE PARM-PREV-DATE-TRANS  TO WS-PREV-DATE-TRANS.            
                                                                        
           MOVE PARM-AMT-REFUNDED     TO WS-AMT-REFUNDED.               
           MOVE WS-AMT-REFUNDED-NUM   TO RN-AMT-REFUNDED.               
                                                                        
           MOVE PARM-TOTAL-ORIG-AMT   TO WS-TOT-ORIG-AMT-X.             
           MOVE WS-TOT-ORIG-AMT-NUM   TO WS-TOTAL-ORIG-AMT.             
                                                                        
           MOVE PARM-CHECK-ISS-REAS-CD TO RN-CHECK-ISS-REAS-CD.         
           MOVE PARM-CHECK-STATUS-CD   TO RN-CHECK-STATUS-CD            
                                          WS-CHECK-STATUS-CD.           
                                                                        
           MOVE PARM-PREV-DATE-TRANS  TO PARM-COMMENTS-TEXT.            
           MOVE '0010'                TO PARM-COMMENTS-LEN.             
           MOVE PARM-COMMENTS-TEXT     TO RN-COMMENTS-TEXT              
                                          WS-REF-COMMENTS.              
           MOVE PARM-COMMENTS-LEN      TO WS-LENGTH.                    
           MOVE WS-LENGTH-NUM          TO RN-COMMENTS-LEN.              
           MOVE PARM-MANUAL-INDICATOR  TO RN-MANUAL-INDICATOR.          
           IF PARM-REQUEST-DT    EQUAL SPACES                           
              MOVE -1         TO WS-RN-NULL-IND-2                       
           ELSE                                                         
              MOVE  0         TO WS-RN-NULL-IND-2                       
              MOVE PARM-REQUEST-DT        TO RN-REQUEST-DT              
           END-IF                                                       
           MOVE PARM-GS-USER-ID        TO RN-USER-ID-RQSTED-BY          
                                          WS-USER-ID  AR-USER-ID.       
                                                                        
           MOVE PARM-TRANS-COMMENTS         TO WS-TRANS-COMMENTS.       
           MOVE PARM-TRANS-COMMENTS-LEN     TO WS-LENGTH.               
           MOVE WS-LENGTH-NUM               TO WS-TRANS-COMMENTS-LEN.   
                                                                        
           MOVE PARM-CASH-COMPANY-NO        TO WS-CD-COMPANY-NO.        
           MOVE PARM-CASH-LOCAL-OFFICE      TO WS-CD-LOCAL-OFFICE.      
           MOVE PARM-CASH-REPORT-NO         TO WS-CD-REPORT-NO.         
           MOVE PARM-DATE-CASH-REPORT       TO WS-CD-REPORT-DATE.       
           MOVE PARM-CASH-DRAWER-ID         TO WS-CASH-DRWR.            
           MOVE WS-CASH-DRWR-NUM            TO WS-CASH-DRAWER-ID.       
           MOVE PARM-ADDRESS-CHANGED-FL     TO WS-ADDRESS-CHANGED-FL.   
           MOVE PARM-ADDRESS-FORMAT         TO WS-KR363-ADDRESS-FORMAT. 
           MOVE PARM-FMT-HOUSE-NO           TO WS-KR363-FMT-HOUSE-NO    
           MOVE PARM-FMT-ADDR-PREFIX-1   TO WS-KR363-FMT-ADDR-PREFIX-1. 
           MOVE PARM-FMT-ADDR-PREFIX-2   TO WS-KR363-FMT-ADDR-PREFIX-2. 
           MOVE PARM-FMT-STREET-NAME        TO WS-KR363-FMT-STREET-NAME.
           MOVE PARM-FMT-STREET-SUFFIX   TO WS-KR363-FMT-STREET-SUFFIX. 
           MOVE PARM-FMT-ADDR-SUFFIX        TO WS-KR363-FMT-ADDR-SUFFIX.
           MOVE PARM-FMT-STREET-LOCATION-1  TO                          
                                            WS-KR363-FMT-STREET-LOC-1.  
           MOVE PARM-FMT-STREET-LOCATION-2  TO                          
                                            WS-KR363-FMT-STREET-LOC-2.  
           MOVE PARM-FF-ADDR-STREET         TO WS-KR363-FF-ADDR-STREET. 
           MOVE PARM-FF-ADDRESS-OVERFLOW TO WS-KR363-FF-ADDR-OVERFLOW.  
           MOVE PARM-FF-ADDR-COUNTRY        TO WS-KR363-FF-ADDR-COUNTRY.
           MOVE PARM-FF-ADDRESS-CITY-STATE  To                          
                                            WS-KR363-FF-ADDR-CITY-STATE.
           MOVE PARM-CITY                   TO WS-KR363-CITY.           
           MOVE PARM-STATE                  TO WS-KR363-STATE.          
           MOVE PARM-ZIP-CODE               TO WS-KR363-ZIP-CODE.       
           MOVE PARM-ZIP-CODE-PLUS-FOUR  TO WS-KR363-ZIP-CODE-PLUS-FOUR.
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
                                                                        
           PERFORM 5000-PROCESS-REFUND           THRU 5000-EXIT.        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************               
      * 5000-PROCESS-REFUND.                                                    
      ***********************************************************               
                                                                        
       5000-PROCESS-REFUND.                                             
                                                                        
           MOVE '5000'                      TO ACTIVE-PARAGRAPH.        
                                                                        
      *AR logout validation                                                     
           PERFORM 7999-SELECT-AL THRU 7999-SELECT-AL-EXIT.             
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
              MOVE 0    TO S-RETURN-CODE                                
              MOVE 5000 TO S-APPL-RETURN-CODE                           
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF.                                                      
                                                                        
      *Account transfer validation                                              
           MOVE WS-ACCOUNT-NO-COMP3  TO AT-ACCOUNT-NO.                  
           PERFORM 7999-SELECT-TRANSFER-IND                             
              THRU 7999-SELECT-TRANSFER-IND-EXIT.                       
           IF AT-ACCT-XFER-TO > ZERO                                    
              MOVE 0    TO S-RETURN-CODE                                
              MOVE 5001 TO S-APPL-RETURN-CODE                           
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF.                                                      
                                                                        
           PERFORM 7800-GET-ACCOUNT-INFO    THRU 7800-EXIT.             
           MOVE AT-CODES-DATA-PRESENT       TO WS-CODES-DATA-PRESENT.   
      * Timestamp validation                                                    
           IF PARM-LAST-UPDATE-TS-AT = AT-LAST-UPDATE-TS                
              CONTINUE                                                  
           ELSE                                                         
              MOVE 0       TO S-RETURN-CODE                             
              MOVE 5272    TO S-APPL-RETURN-CODE                        
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF.                                                      
                                                                        
           MOVE WS-ACCOUNT-NO-COMP3       TO RN-ACCOUNT-NO              
                                             AR-ACCOUNT-NO              
                                             AU-ACCOUNT-NO.             
           PERFORM 7000-GET-CURRENT-DATE  THRU 7000-EXIT.               
           PERFORM 7010-ACCEPT-TIMESTAMP  THRU 7010-EXIT.               
           MOVE 0                         TO WS-TRAN-APPL-NO.           
           MOVE 'Y'                       TO WS-UPD-AR.                 
           MOVE 'Y'                       TO WS-FLAG.                   
           MOVE WS-CURRENT-TIMESTAMP      TO RN-TRANS-HIST-SEQ-NO       
                                             AR-TRANS-HIST-SEQ-NO       
                                             AU-TRANS-HIST-SEQ-NO       
                                             S-AT-LAST-UPDATE-TS.       
           PERFORM 7030-GET-RESP-AREA-ID  THRU 7030-EXIT.               
                                                                        
           PERFORM 7110-GET-AR-TRANS      THRU 7110-EXIT.               
           PERFORM 5950-SET-MNT-TRANS-VARS   THRU 5950-EXIT.            
           IF WS-ACTION-CODE = 'I'                                      
              PERFORM 5005-CLEAR-NULL-DATES  THRU 5005-EXIT             
              PERFORM 5010-INSERT-REFUND     THRU 5010-EXIT             
              MOVE 'A'      TO WS-CODE-CHECK-REFUND                     
              PERFORM 7820-UPDATE-CODES  THRU 7820-EXIT                 
              IF PARM-CHECK-STATUS-CD = 'A' OR 'I'                      
                 PERFORM 5040-INSERT-AR-TRANS-HIST   THRU 5040-EXIT     
                                                                        
                 IF RN-AMT-REFUNDED = WS-TOTAL-ORIG-AMT                 
                    PERFORM 7110-GET-AR-TRANS        THRU 7110-EXIT     
                    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL          
                       PERFORM 5050-UPDATE-AR-TRANS-HIST THRU 5050-EXIT 
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5005 CLEAN NULL DATES                                          *        
      ******************************************************************        
                                                                        
       5005-CLEAR-NULL-DATES.                                           
           MOVE '5005'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           MOVE -1                          TO WS-RN-NULL-IND-4.        
           MOVE -1                          TO WS-RN-NULL-IND-5.        
           MOVE -1                          TO WS-RN-NULL-IND-6.        
           MOVE -1                          TO WS-RN-NULL-IND-7.        
           MOVE -1                          TO WS-RN-NULL-IND-8.        
           MOVE -1                          TO WS-RN-NULL-IND-9.        
           MOVE -1                          TO WS-RN-NULL-IND-10.       
           MOVE -1                          TO WS-RN-NULL-IND-11.       
           MOVE -1                          TO WS-RN-NULL-IND-12.       
           MOVE -1                          TO WS-RN-NULL-IND-13.       
                                                                        
       5005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5010 INSERT REFUND.                                            *        
      ******************************************************************        
                                                                        
       5010-INSERT-REFUND.                                              
           MOVE '5010'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 7040-GET-REFUND-ITEM-ID  THRU 7040-EXIT.             
           MOVE WS-TRANS-HIST-SEQ-NO        TO RN-TRANS-HIST-SEQ-NO.    
                                                                        
           MOVE WS-LOCAL-OFFICE             TO RN-LOCAL-OFFICE.         
           MOVE 0                           TO WS-RN-NULL-IND-1         
           MOVE WS-CURRENT-DATE             TO RN-DATE-REFUNDED         
           IF RN-CHECK-STATUS-CD = 'A' OR 'I'                           
              MOVE WS-USER-ID               TO RN-USER-ID-APPRVD-BY     
              MOVE WS-CURRENT-DATE          TO RN-REQUEST-DT            
           ELSE                                                         
              MOVE SPACES                   TO RN-USER-ID-APPRVD-BY     
           END-IF.                                                      
           MOVE WS-USER-ID                  TO RN-USER-ID-RQSTED-BY.    
           MOVE 'P111'                      TO RN-PANEL-NO.             
                                                                        
           IF WS-ADDRESS-CHANGED-FL = 'Y'                               
              MOVE 'I'                      TO WS-KR363-ACTION-FLAG     
              PERFORM 5100-ADDRESS-PROCESS     THRU 5100-KR363-EXIT     
              MOVE WS-90-NEW-ADDRESS-ID     TO RN-ADDRESS-ID            
           ELSE                                                         
              MOVE 0                        TO RN-ADDRESS-ID            
           END-IF.                                                      
                                                                        
           MOVE 0                           TO RN-REFUND-CHECK-NO.      
           MOVE 0                           TO RN-DEPOSIT-CERT-NO.      
           MOVE WS-CURRENT-DATE             TO RN-REFUND-STATUS-DT.     
                                                                        
           PERFORM 8010-INSERT-REFUND       THRU 8010-EXIT.             
                                                                        
       5010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5040 INSERT AR-TRANS-HIST                                      *        
      ******************************************************************        
                                                                        
       5040-INSERT-AR-TRANS-HIST.                                       
                                                                        
           MOVE '5040'                      TO ACTIVE-PARAGRAPH.        
           MOVE WS-CURRENT-TIMESTAMP        TO AR-TRANS-HIST-SEQ-NO     
                                               AU-TRANS-HIST-SEQ-NO.    
           MOVE WS-CURRENT-DATE             TO AR-DATE-TRANS.           
           MOVE 'R'                         TO AR-CODE-TRAN-TYPE.       
           MOVE RN-AMT-REFUNDED             TO AR-AMT-ORIG-ENTERED.     
           MOVE WS-RESP-AREA-ID             TO AR-RESP-AREA-ID.         
           MOVE WS-USER-ID                  TO AR-USER-ID.              
           IF PARM-CHECK-ISS-REAS-CD = 'P'                              
              MOVE 'PANEL111A'              TO AR-APPL-PROGRAM-ID       
           ELSE                                                         
              MOVE 'PANEL111'               TO AR-APPL-PROGRAM-ID       
           END-IF.                                                      
           MOVE WS-PREV-DATE-TRANS          TO AR-DATE-ORIG-PYMT.       
           MOVE 'Y'                      TO AR-PYMT-REFUNDED-IND        
           MOVE WS-TRANS-COMMENTS        TO AR-TRAN-COMMENT-TEXT.       
           MOVE WS-TRANS-COMMENTS-LEN    TO AR-TRAN-COMMENT-LEN.        
           IF PARM-MANUAL-INDICATOR = 'C'                               
              STRING 'PAYMENT LOCAL OFFICE:',WS-CD-LOCAL-OFFICE,        
                 '; REPORT DATE:',WS-CD-REPORT-DATE,                    
                 '; BATCH NO:',WS-CD-REPORT-NO,';',WS-TRANS-COMMENTS    
                 DELIMITED BY SIZE INTO AR-TRAN-COMMENT-TEXT            
              ADD +63                       TO  AR-TRAN-COMMENT-LEN     
           END-IF.                                                      
           MOVE AT-TOTAL-AR-BALANCE         TO AR-AMT-BILLED-UNPAID.    
           ADD  RN-AMT-REFUNDED             TO AR-AMT-BILLED-UNPAID.    
           MOVE SPACES                      TO AR-RECORD-ONLY-FL.       
           MOVE WS-COMPANY-NO               TO AR-COMPANY-NO.           
           MOVE SPACES                      TO AR-PYMT-FACILITY-CD.     
                                                                        
           IF PARM-MANUAL-INDICATOR = 'M'                               
              MOVE 'CHK'                    TO WS-CHECK-CASH-IND        
                                                                        
              MOVE '01'                     TO AR-CASH-COMPANY-NO       
                                               WS-CD-COMPANY-NO         
              MOVE '998'                    TO AR-CASH-LOCAL-OFFICE     
                                               WS-CD-LOCAL-OFFICE       
              MOVE '998'                    TO AR-CASH-REPORT-NO        
                                               WS-CD-REPORT-NO          
              MOVE WS-CURRENT-DATE          TO AR-DATE-CASH-REPORT      
                                               WS-CD-REPORT-DATE        
              MOVE 9999                     TO AR-CASH-DRAWER-ID        
                                               WS-CASH-DRAWER-ID        
           ELSE                                                         
              IF PARM-MANUAL-INDICATOR = 'C'                            
                 MOVE 'CSH'                 TO WS-CHECK-CASH-IND        
                                                                        
                 MOVE WS-CD-COMPANY-NO      TO AR-CASH-COMPANY-NO       
                 MOVE WS-CD-LOCAL-OFFICE    TO AR-CASH-LOCAL-OFFICE     
                 MOVE WS-CD-REPORT-NO       TO AR-CASH-REPORT-NO        
                 MOVE WS-CD-REPORT-DATE     TO AR-DATE-CASH-REPORT      
                 MOVE WS-CASH-DRAWER-ID     TO AR-CASH-DRAWER-ID        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE 'F'                         TO WS-PART-CASH-PROCESS-FLG.
           IF WS-FLAG = 'Y'                                             
              PERFORM 8020-INSERT-AR-TRANS-HIST THRU 8020-EXIT          
           END-IF.                                                      
                                                                        
           MOVE RN-AMT-REFUNDED             TO WS-AMOUNT-REFUNDED.      
           MOVE 'S135'                      TO WS-CSH-DRWR-TRAN-ID      
                                                                        
           PERFORM 6904-INSERT-AR-DETAILS   THRU 6904-EXIT.             
                                                                        
       5040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5050 UPDATE AR-TRANS-HIST                                      *        
      ******************************************************************        
                                                                        
       5050-UPDATE-AR-TRANS-HIST.                                       
                                                                        
           MOVE '5050'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           IF PARM-CHECK-STATUS-CD = 'D'                                
              MOVE SPACE                    TO AR-PYMT-REFUNDED-IND     
           ELSE                                                         
              MOVE 'Y'                      TO AR-PYMT-REFUNDED-IND     
           END-IF.                                                      
                                                                        
           PERFORM 8050-UPDATE-AR-TRANS-HIST THRU 8050-EXIT.            
                                                                        
       5050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5100-ADDRESS-PROCESS                                           *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01670000
              INCLUDE CPDKR363                                          01680000
           END-EXEC.                                                    01690000
                                                                        
      ******************************************************************        
      * 5950 SET MNT TRANS VARS                                        *        
      ******************************************************************        
                                                                        
       5950-SET-MNT-TRANS-VARS.                                         
                                                                        
           MOVE SPACES                      TO WS-TABLE-ID.             
           MOVE '5950'                      TO ACTIVE-PARAGRAPH.        
           MOVE WS-CURRENT-TIMESTAMP        TO MH-TRANS-HIST-SEQ-NO.    
           MOVE WS-CURRENT-DATE             TO MH-DATE-TRANS.           
           MOVE WS-CODE-TRAN-TYPE           TO MH-CODE-TRAN-TYPE.       
           MOVE WS-RESP-AREA-ID             TO MH-RESP-AREA-ID.         
           MOVE WS-ACCOUNT-NO-COMP3         TO MH-ACCOUNT-NO.           
           MOVE 0                           TO MH-CUSTOMER-NO.          
           MOVE 0                           TO MH-PREMISE-NO.           
           MOVE WS-USERID                   TO MH-USER-ID.              
           MOVE WS-PANEL-NO                 TO MH-APPL-PROGRAM-ID.      
           IF WS-TRANS-COMMENTS-LEN > 0                                 
              MOVE WS-TRANS-COMMENTS        TO MH-TRAN-COMMENT-TEXT     
              MOVE WS-TRANS-COMMENTS-LEN    TO MH-TRAN-COMMENT-LEN      
           ELSE                                                         
              MOVE SPACES                   TO MH-TRAN-COMMENT-TEXT     
              MOVE 0                        TO MH-TRAN-COMMENT-LEN      
           END-IF                                                       
                                                                        
           MOVE WS-TABLE-ID                 TO MI-TABLE-ID.             
           MOVE WS-COLUMN-DESC              TO MI-COLUMN-DESC.          
           MOVE WS-CURRENT-TIMESTAMP        TO MI-TRANS-HIST-SEQ-NO.    
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE WS-PRV-COLUMN-VALUE-TEXT    TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE WS-PRV-COLUMN-VALUE-LEN     TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE WS-CHG-COLUMN-VALUE-TEXT    TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE WS-CHG-COLUMN-VALUE-LEN     TO MI-CHG-COLUMN-VALUE-LEN. 
                                                                        
       5950-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6202-GET-NEW-ADDRESS-ID                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00090                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 6210-CALCULATE-CHECK-DIGIT                                     *        
      ******************************************************************        
                                                                        
           COPY CPD00071.                                                       
                                                                        
      ******************************************************************        
      * 6400-ONLINE-JRNL-ROUTINE                                       *        
      ******************************************************************        
                                                                        
            EXEC SQL                                                            
               INCLUDE CPD0006A                                                 
            END-EXEC.                                                           
                                                                        
      ******************************************************************        
      * 6530-LOAD-MNT-TRANS-HIST                                       *        
      ******************************************************************        
                                                                        
            EXEC SQL                                                            
               INCLUDE CPD00067                                                 
            END-EXEC.                                                           
                                                                        
      ******************************************************************        
      * 6904-INSERT-AR-DETAILS                                         *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00116                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 7000-GET-CURRENT-DATE                                          *        
      ******************************************************************        
                                                                        
       7000-GET-CURRENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'PARM-ACCOUNT-NO'        TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT                            
                                          THRU 9000-EXIT                
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                          THRU 9900-EXIT
           END-IF.               
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7010 ACCEPT TIMESTAMP                                          *        
      ******************************************************************        
                                                                        
       7010-ACCEPT-TIMESTAMP.                                           
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7010'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'PARM-ACCOUNT-NO'        TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT                            
                                          THRU 9000-EXIT                
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                          THRU 9900-EXIT                
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7110-GET-AR-TRANS                                              *        
      ******************************************************************        
                                                                        
       7110-GET-AR-TRANS.                                               
                                                                        
           MOVE WS-ACCOUNT-NO-COMP3         TO AR-ACCOUNT-NO.           
           MOVE WS-PREV-DATE-TRANS          TO AR-DATE-TRANS.           
           MOVE WS-TRANS-HIST-SEQ-NO        TO AR-TRANS-HIST-SEQ-NO.    
                                                                        
           EXEC SQL                                                     
                SELECT CODE_TRAN_TYPE,                                  
                       RESP_AREA_ID,                                    
                       USER_ID                                          
                  INTO :AR-CODE-TRAN-TYPE,                              
                       :AR-RESP-AREA-ID,                                
                       :AR-USER-ID                                      
                  FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                  
                 WHERE ACCOUNT_NO        =  :AR-ACCOUNT-NO              
                   AND ( CODE_TRAN_TYPE  =  'P' OR                      
                       ( CODE_TRAN_TYPE  =  'I' AND                     
                         APPL_PROGRAM_ID IN ('PANEL310A',               
                         'PANEL310B','PANEL310C','PANEL310D',           
                         'PANEL310E','PANEL310F','PANEL310G',           
                         'PANEL310H','PANEL310I')))                     
                   AND DATE_TRANS        =  IIF(TRY_CONVERT(DATE, 
                                                         :AR-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS
              ) <> 0) OR (LEN(:AR-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :AR-DATE-TRANS
              ), CONVERT(DATE, :AR-DATE-TRANS) )              
                   AND TRANS_HIST_SEQ_NO =  CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT CODE_TRAN_TYPE,                                          
MFA-TR*                RESP_AREA_ID,                                            
MFA-TR*                USER_ID                                                  
MFA-TR*           INTO :AR-CODE-TRAN-TYPE,                                      
MFA-TR*                :AR-RESP-AREA-ID,                                        
MFA-TR*                :AR-USER-ID                                              
MFA-TR*           FROM CSS_AR_TRANS_HIST                                        
MFA-TR*          WHERE ACCOUNT_NO        =  :AR-ACCOUNT-NO                      
MFA-TR*            AND ( CODE_TRAN_TYPE  =  'P' OR                              
MFA-TR*                ( CODE_TRAN_TYPE  =  'I' AND                             
MFA-TR*                  APPL_PROGRAM_ID IN ('PANEL310A',                       
MFA-TR*                  'PANEL310B','PANEL310C','PANEL310D',                   
MFA-TR*                  'PANEL310E','PANEL310F','PANEL310G',                   
MFA-TR*                  'PANEL310H','PANEL310I')))                             
MFA-TR*            AND DATE_TRANS        =  :AR-DATE-TRANS                      
MFA-TR*            AND TRANS_HIST_SEQ_NO =  :AR-TRANS-HIST-SEQ-NO               
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7110                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7110'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_AR_TRANS_HIST'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'TRANS_HIST_SEQ_NO'      TO TABLE-ELEMENT-2          
              MOVE 'DATE_TRANS'             TO TABLE-ELEMENT-3          
              MOVE AR-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE AR-TRANS-HIST-SEQ-NO     TO HOSTVAR-ELEMENT-2        
              MOVE AR-DATE-TRANS            TO HOSTVAR-ELEMENT-3        
              PERFORM 9000-SEND-ERROR-RESULT                            
                                          THRU 9000-EXIT                
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                          THRU 9900-EXIT                
           END-IF.                                                      
           IF AR-CODE-TRAN-TYPE = 'I'                                   
              MOVE 'Y' TO WS-116-REFUND-CREDIT                          
           ELSE                                                         
              MOVE 'N' TO WS-116-REFUND-CREDIT                          
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7030 GET RESP AREA ID                                          *        
      ******************************************************************        
                                                                        
       7030-GET-RESP-AREA-ID.                                           
                                                                        
           EXEC SQL                                                     
               SELECT RESP_AREA_ID                                      
                 INTO :WS-RESP-AREA-ID                                  
                 FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
                WHERE USER_ID = :WS-USER-ID                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RESP_AREA_ID                                              
MFA-TR*          INTO :WS-RESP-AREA-ID                                          
MFA-TR*          FROM CSS_USER_PROFILE                                          
MFA-TR*         WHERE USER_ID = :WS-USER-ID                                     
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7030                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7030'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT '                TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_USER_PROFILE  '     TO TABLE-1                  
              MOVE 'USER_ID'                TO TABLE-ELEMENT-1          
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2          
              MOVE WS-USER-ID               TO HOSTVAR-ELEMENT-1        
              MOVE PARM-ACCOUNT-NO          TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT                            
                                          THRU 9000-EXIT                
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                          THRU 9900-EXIT                
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7040 GET REFUND ITEM ID.                                       *        
      ******************************************************************        
                                                                        
       7040-GET-REFUND-ITEM-ID.                                         
                                                                        
           EXEC SQL                                                     
               SELECT MAX(REFUND_ITEM_ID)                               
                 INTO :RN-REFUND-ITEM-ID :WS-RN-NULL-ITEM                
                 FROM CSS_REFUND WITH(READUNCOMMITTED)                          
                WHERE ACCOUNT_NO = :RN-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(REFUND_ITEM_ID)                                       
MFA-TR*          INTO :RN-REFUND-ITEM-ID:WS-RN-NULL-ITEM                        
MFA-TR*          FROM CSS_REFUND                                                
MFA-TR*         WHERE ACCOUNT_NO = :RN-ACCOUNT-NO                               
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7040                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-RN-NULL-ITEM = -1                                   
                 MOVE 1                     TO RN-REFUND-ITEM-ID        
              ELSE                                                      
                 COMPUTE RN-REFUND-ITEM-ID = RN-REFUND-ITEM-ID + 1      
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7040'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_REFUND'             TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE RN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT                            
                                          THRU 9000-EXIT                
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                          THRU 9900-EXIT                
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7800-GET-ACCOUNT-INFO                                          *        
      ******************************************************************        
                                                                        
       7800-GET-ACCOUNT-INFO.                                           
           MOVE WS-ACCOUNT-NO-COMP3      TO AT-ACCOUNT-NO               
                                                                        
            EXEC SQL                                                    
               SELECT  COMPANY_NO,                                      
                       LOCAL_OFFICE,                                    
                       TOTAL_AR_BALANCE,                                
                       CODES_DATA_PRESENT,                              
                       REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                 INTO :AT-COMPANY-NO,                                   
                      :AT-LOCAL-OFFICE,                                 
                      :AT-TOTAL-AR-BALANCE,                             
                      :AT-CODES-DATA-PRESENT,                           
                      :AT-LAST-UPDATE-TS                                
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT  COMPANY_NO,                                              
MFA-TR*                LOCAL_OFFICE,                                            
MFA-TR*                TOTAL_AR_BALANCE,                                        
MFA-TR*                CODES_DATA_PRESENT,                                      
MFA-TR*                LAST_UPDATE_TS                                           
MFA-TR*          INTO :AT-COMPANY-NO,                                           
MFA-TR*               :AT-LOCAL-OFFICE,                                         
MFA-TR*               :AT-TOTAL-AR-BALANCE,                                     
MFA-TR*               :AT-CODES-DATA-PRESENT,                                   
MFA-TR*               :AT-LAST-UPDATE-TS                                        
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7800                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               MOVE AT-COMPANY-NO         TO WS-COMPANY-NO              
               MOVE AT-LOCAL-OFFICE       TO WS-LOCAL-OFFICE            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE              
               MOVE '7800'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT            '  TO ABEND-FUNCTION             
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_ACCOUNT       '  TO TABLE-1                    
               MOVE 'ACCOUNT_NO        '  TO TABLE-ELEMENT-1            
               MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7820-UPDATE-CODES                                              *        
      ******************************************************************        
                                                                        
       7820-UPDATE-CODES.                                               
                                                                        
           MOVE WS-CODES-DATA-PRESENT  TO AT-CODES-DATA-PRESENT.        
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
              SET    CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT        
                    ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              )         
              WHERE  ACCOUNT_NO         = :AT-ACCOUNT-NO                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT                                                
MFA-TR*       SET    CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT                
MFA-TR*             ,LAST_UPDATE_TS     = :WS-CURRENT-TIMESTAMP                 
MFA-TR*       WHERE  ACCOUNT_NO         = :AT-ACCOUNT-NO                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE '7820'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7820-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************34450000
      *  7999-SELECT-AL                                                *34460000
      ******************************************************************34470000
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00075                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 7999-SELECT-TRANSFER-IND                                       *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00307                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 8010-INSERT-REFUND.                                            *        
      ******************************************************************        
                                                                        
       8010-INSERT-REFUND.                                              
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_REFUND                                  
                       (REFUND_ITEM_ID,                                 
                        REFUND_CHECK_NO,                                
                        DEPOSIT_CERT_NO,                                
                        LOCAL_OFFICE,                                   
                        AMT_REFUNDED,                                   
                        DATE_REFUNDED,                                  
                        REQUEST_DT,                                     
                        CHECK_STATUS_CD,                                
                        CHECK_ISS_REAS_CD,                              
                        ORIGINAL_CHECK_NO,                              
                        RETURNED_REASON,                                
                        MANUAL_INDICATOR,                               
                        USER_ID_APPRVD_BY,                              
                        REFUND_STATUS_DT,                               
                        USER_ID_RQSTED_BY,                              
                        ACCOUNT_NO,                                     
                        COMMENTS,                                       
                        PANEL_NO,                                       
                        ADDRESS_ID,                                     
                        TRANS_HIST_SEQ_NO,                              
                        CLEARED_DT,                                     
                        DATE_CHECK_VOIDED,                              
                        STOP_REQUEST_DT,                                
                        STOP_CONFIRM_DT,                                
                        CHECK_REMAIL_DT,                                
                        REISSUED_DATE,                                  
                        RETURNED_DATE,                                  
                        DATE_APPROPRIATED,                              
                        DATE_ESCHEATED,                                 
                        DATE_CANCELLED)                                 
                VALUES                                                  
                      (:RN-REFUND-ITEM-ID,                              
                       :RN-REFUND-CHECK-NO,                             
                       :RN-DEPOSIT-CERT-NO,                             
                       :RN-LOCAL-OFFICE,                                
                       :RN-AMT-REFUNDED,                                
                       IIF(TRY_CONVERT(DATE, :RN-DATE-REFUNDED 
                                             :WS-RN-NULL-IND-1
              ) IS NULL OR (PATINDEX('%.%', :RN-DATE-REFUNDED 
                                                      :WS-RN-NULL-IND-1
              ) <> 0) OR (LEN(:RN-DATE-REFUNDED :WS-RN-NULL-IND-1
              ) <> 10), CIS.CHAR2DATE(:RN-DATE-REFUNDED 
                                                      :WS-RN-NULL-IND-1
              ), CONVERT(DATE, :RN-DATE-REFUNDED :WS-RN-NULL-IND-1) ),         
                       IIF(TRY_CONVERT(DATE, :RN-REQUEST-DT 
                                             :WS-RN-NULL-IND-2
              ) IS NULL OR (PATINDEX('%.%', :RN-REQUEST-DT 
                                                      :WS-RN-NULL-IND-2
              ) <> 0) OR (LEN(:RN-REQUEST-DT :WS-RN-NULL-IND-2
              ) <> 10), CIS.CHAR2DATE(:RN-REQUEST-DT :WS-RN-NULL-IND-2
              ), CONVERT(DATE, :RN-REQUEST-DT :WS-RN-NULL-IND-2) ),            
                       :RN-CHECK-STATUS-CD,                             
                       :RN-CHECK-ISS-REAS-CD,                           
                       :RN-ORIGINAL-CHECK-NO,                           
                       :RN-RETURNED-REASON,                             
                       :RN-MANUAL-INDICATOR,                            
                       :RN-USER-ID-APPRVD-BY,                           
                       IIF(TRY_CONVERT(DATE, :RN-REFUND-STATUS-DT 
                                             :WS-RN-NULL-IND-3
              ) IS NULL OR (PATINDEX('%.%', :RN-REFUND-STATUS-DT 
                                                      :WS-RN-NULL-IND-3
              ) <> 0) OR (LEN(:RN-REFUND-STATUS-DT :WS-RN-NULL-IND-3
              ) <> 10), CIS.CHAR2DATE(:RN-REFUND-STATUS-DT 
                                                      :WS-RN-NULL-IND-3
              ), CONVERT(DATE, :RN-REFUND-STATUS-DT :WS-RN-NULL-IND-3
              ) ),           
                       :RN-USER-ID-RQSTED-BY,                           
                       :RN-ACCOUNT-NO,                                  
                       :RN-COMMENTS,                                    
                       :RN-PANEL-NO,                                    
                       :RN-ADDRESS-ID,                                  
                       CIS.CHAR2TIMESTAMP(:RN-TRANS-HIST-SEQ-NO),               
                       IIF(TRY_CONVERT(DATE, :RN-CLEARED-DT 
                                             :WS-RN-NULL-IND-4
              ) IS NULL OR (PATINDEX('%.%', :RN-CLEARED-DT 
                                                      :WS-RN-NULL-IND-4
              ) <> 0) OR (LEN(:RN-CLEARED-DT :WS-RN-NULL-IND-4
              ) <> 10), CIS.CHAR2DATE(:RN-CLEARED-DT :WS-RN-NULL-IND-4
              ), CONVERT(DATE, :RN-CLEARED-DT :WS-RN-NULL-IND-4) ),            
                       IIF(TRY_CONVERT(DATE, :RN-DATE-CHECK-VOIDED 
                                             :WS-RN-NULL-IND-5
              ) IS NULL OR (PATINDEX('%.%', :RN-DATE-CHECK-VOIDED 
                                                      :WS-RN-NULL-IND-5
              ) <> 0) OR (LEN(:RN-DATE-CHECK-VOIDED :WS-RN-NULL-IND-5
              ) <> 10), CIS.CHAR2DATE(:RN-DATE-CHECK-VOIDED 
                                                      :WS-RN-NULL-IND-5
              ), CONVERT(DATE, :RN-DATE-CHECK-VOIDED :WS-RN-NULL-IND-5
              ) ),          
                       IIF(TRY_CONVERT(DATE, :RN-STOP-REQUEST-DT 
                                             :WS-RN-NULL-IND-6
              ) IS NULL OR (PATINDEX('%.%', :RN-STOP-REQUEST-DT 
                                                      :WS-RN-NULL-IND-6
              ) <> 0) OR (LEN(:RN-STOP-REQUEST-DT :WS-RN-NULL-IND-6
              ) <> 10), CIS.CHAR2DATE(:RN-STOP-REQUEST-DT 
                                                      :WS-RN-NULL-IND-6
              ), CONVERT(DATE, :RN-STOP-REQUEST-DT :WS-RN-NULL-IND-6
              ) ),            
                       IIF(TRY_CONVERT(DATE, :RN-STOP-CONFIRM-DT 
                                             :WS-RN-NULL-IND-7
              ) IS NULL OR (PATINDEX('%.%', :RN-STOP-CONFIRM-DT 
                                                      :WS-RN-NULL-IND-7
              ) <> 0) OR (LEN(:RN-STOP-CONFIRM-DT :WS-RN-NULL-IND-7
              ) <> 10), CIS.CHAR2DATE(:RN-STOP-CONFIRM-DT 
                                                      :WS-RN-NULL-IND-7
              ), CONVERT(DATE, :RN-STOP-CONFIRM-DT :WS-RN-NULL-IND-7
              ) ),            
                       IIF(TRY_CONVERT(DATE, :RN-CHECK-REMAIL-DT 
                                             :WS-RN-NULL-IND-8
              ) IS NULL OR (PATINDEX('%.%', :RN-CHECK-REMAIL-DT 
                                                      :WS-RN-NULL-IND-8
              ) <> 0) OR (LEN(:RN-CHECK-REMAIL-DT :WS-RN-NULL-IND-8
              ) <> 10), CIS.CHAR2DATE(:RN-CHECK-REMAIL-DT 
                                                      :WS-RN-NULL-IND-8
              ), CONVERT(DATE, :RN-CHECK-REMAIL-DT :WS-RN-NULL-IND-8
              ) ),            
                       IIF(TRY_CONVERT(DATE, :RN-REISSUED-DATE 
                                             :WS-RN-NULL-IND-9
              ) IS NULL OR (PATINDEX('%.%', :RN-REISSUED-DATE 
                                                      :WS-RN-NULL-IND-9
              ) <> 0) OR (LEN(:RN-REISSUED-DATE :WS-RN-NULL-IND-9
              ) <> 10), CIS.CHAR2DATE(:RN-REISSUED-DATE 
                                                      :WS-RN-NULL-IND-9
              ), CONVERT(DATE, :RN-REISSUED-DATE :WS-RN-NULL-IND-9) ),         
                       IIF(TRY_CONVERT(DATE, :RN-RETURNED-DATE 
                                             :WS-RN-NULL-IND-10
              ) IS NULL OR (PATINDEX('%.%', :RN-RETURNED-DATE 
                                                     :WS-RN-NULL-IND-10
              ) <> 0) OR (LEN(:RN-RETURNED-DATE :WS-RN-NULL-IND-10
              ) <> 10), CIS.CHAR2DATE(:RN-RETURNED-DATE 
                                                     :WS-RN-NULL-IND-10
              ), CONVERT(DATE, :RN-RETURNED-DATE :WS-RN-NULL-IND-10) ),        
                       IIF(TRY_CONVERT(DATE, :RN-DATE-APPROPRIATED 
                                             :WS-RN-NULL-IND-11
              ) IS NULL OR (PATINDEX('%.%', :RN-DATE-APPROPRIATED 
                                                     :WS-RN-NULL-IND-11
              ) <> 0) OR (LEN(:RN-DATE-APPROPRIATED :WS-RN-NULL-IND-11
              ) <> 10), CIS.CHAR2DATE(:RN-DATE-APPROPRIATED 
                                                     :WS-RN-NULL-IND-11
              ), CONVERT(DATE, :RN-DATE-APPROPRIATED :WS-RN-NULL-IND-11
              ) ),         
                       IIF(TRY_CONVERT(DATE, :RN-DATE-ESCHEATED 
                                             :WS-RN-NULL-IND-12
              ) IS NULL OR (PATINDEX('%.%', :RN-DATE-ESCHEATED 
                                                     :WS-RN-NULL-IND-12
              ) <> 0) OR (LEN(:RN-DATE-ESCHEATED :WS-RN-NULL-IND-12
              ) <> 10), CIS.CHAR2DATE(:RN-DATE-ESCHEATED 
                                                     :WS-RN-NULL-IND-12
              ), CONVERT(DATE, :RN-DATE-ESCHEATED :WS-RN-NULL-IND-12
              ) ),            
                       IIF(TRY_CONVERT(DATE, :RN-DATE-CANCELLED 
                                             :WS-RN-NULL-IND-13
              ) IS NULL OR (PATINDEX('%.%', :RN-DATE-CANCELLED 
                                                     :WS-RN-NULL-IND-13
              ) <> 0) OR (LEN(:RN-DATE-CANCELLED :WS-RN-NULL-IND-13
              ) <> 10), CIS.CHAR2DATE(:RN-DATE-CANCELLED 
                                                     :WS-RN-NULL-IND-13
              ), CONVERT(DATE, :RN-DATE-CANCELLED :WS-RN-NULL-IND-13
              ) ))            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_REFUND                                          
MFA-TR*                (REFUND_ITEM_ID,                                         
MFA-TR*                 REFUND_CHECK_NO,                                        
MFA-TR*                 DEPOSIT_CERT_NO,                                        
MFA-TR*                 LOCAL_OFFICE,                                           
MFA-TR*                 AMT_REFUNDED,                                           
MFA-TR*                 DATE_REFUNDED,                                          
MFA-TR*                 REQUEST_DT,                                             
MFA-TR*                 CHECK_STATUS_CD,                                        
MFA-TR*                 CHECK_ISS_REAS_CD,                                      
MFA-TR*                 ORIGINAL_CHECK_NO,                                      
MFA-TR*                 RETURNED_REASON,                                        
MFA-TR*                 MANUAL_INDICATOR,                                       
MFA-TR*                 USER_ID_APPRVD_BY,                                      
MFA-TR*                 REFUND_STATUS_DT,                                       
MFA-TR*                 USER_ID_RQSTED_BY,                                      
MFA-TR*                 ACCOUNT_NO,                                             
MFA-TR*                 COMMENTS,                                               
MFA-TR*                 PANEL_NO,                                               
MFA-TR*                 ADDRESS_ID,                                             
MFA-TR*                 TRANS_HIST_SEQ_NO,                                      
MFA-TR*                 CLEARED_DT,                                             
MFA-TR*                 DATE_CHECK_VOIDED,                                      
MFA-TR*                 STOP_REQUEST_DT,                                        
MFA-TR*                 STOP_CONFIRM_DT,                                        
MFA-TR*                 CHECK_REMAIL_DT,                                        
MFA-TR*                 REISSUED_DATE,                                          
MFA-TR*                 RETURNED_DATE,                                          
MFA-TR*                 DATE_APPROPRIATED,                                      
MFA-TR*                 DATE_ESCHEATED,                                         
MFA-TR*                 DATE_CANCELLED)                                         
MFA-TR*         VALUES                                                          
MFA-TR*               (:RN-REFUND-ITEM-ID,                                      
MFA-TR*                :RN-REFUND-CHECK-NO,                                     
MFA-TR*                :RN-DEPOSIT-CERT-NO,                                     
MFA-TR*                :RN-LOCAL-OFFICE,                                        
MFA-TR*                :RN-AMT-REFUNDED,                                        
MFA-TR*                :RN-DATE-REFUNDED:WS-RN-NULL-IND-1,                      
MFA-TR*                :RN-REQUEST-DT:WS-RN-NULL-IND-2,                         
MFA-TR*                :RN-CHECK-STATUS-CD,                                     
MFA-TR*                :RN-CHECK-ISS-REAS-CD,                                   
MFA-TR*                :RN-ORIGINAL-CHECK-NO,                                   
MFA-TR*                :RN-RETURNED-REASON,                                     
MFA-TR*                :RN-MANUAL-INDICATOR,                                    
MFA-TR*                :RN-USER-ID-APPRVD-BY,                                   
MFA-TR*                :RN-REFUND-STATUS-DT:WS-RN-NULL-IND-3,                   
MFA-TR*                :RN-USER-ID-RQSTED-BY,                                   
MFA-TR*                :RN-ACCOUNT-NO,                                          
MFA-TR*                :RN-COMMENTS,                                            
MFA-TR*                :RN-PANEL-NO,                                            
MFA-TR*                :RN-ADDRESS-ID,                                          
MFA-TR*                :RN-TRANS-HIST-SEQ-NO,                                   
MFA-TR*                :RN-CLEARED-DT:WS-RN-NULL-IND-4,                         
MFA-TR*                :RN-DATE-CHECK-VOIDED:WS-RN-NULL-IND-5,                  
MFA-TR*                :RN-STOP-REQUEST-DT:WS-RN-NULL-IND-6,                    
MFA-TR*                :RN-STOP-CONFIRM-DT:WS-RN-NULL-IND-7,                    
MFA-TR*                :RN-CHECK-REMAIL-DT:WS-RN-NULL-IND-8,                    
MFA-TR*                :RN-REISSUED-DATE:WS-RN-NULL-IND-9,                      
MFA-TR*                :RN-RETURNED-DATE:WS-RN-NULL-IND-10,                     
MFA-TR*                :RN-DATE-APPROPRIATED:WS-RN-NULL-IND-11,                 
MFA-TR*                :RN-DATE-ESCHEATED:WS-RN-NULL-IND-12,                    
MFA-TR*                :RN-DATE-CANCELLED:WS-RN-NULL-IND-13)                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8010'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'CSS_REFUND'             TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'REFUND_ITEM_ID'         TO TABLE-ELEMENT-2          
              MOVE 'REFUND_CHECK_NO'        TO TABLE-ELEMENT-3          
              MOVE 'DEPOSIT_CERT_NO'        TO TABLE-ELEMENT-4          
              MOVE RN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE RN-REFUND-ITEM-ID        TO HOSTVAR-ELEMENT-2        
              MOVE RN-REFUND-CHECK-NO       TO HOSTVAR-ELEMENT-3        
              MOVE RN-DEPOSIT-CERT-NO       TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT                            
                                          THRU 9000-EXIT                
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                          THRU 9900-EXIT                
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8020-INSERT-AR-TRANS-HIST                                      *        
      ******************************************************************        
                                                                        
       8020-INSERT-AR-TRANS-HIST.                                       
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_AR_TRANS_HIST                           
                       (ACCOUNT_NO,                                     
                        TRANS_HIST_SEQ_NO,                              
                        DATE_TRANS,                                     
                        CODE_TRAN_TYPE,                                 
                        AMT_ORIG_ENTERED,                               
                        AMT_BILLED_UNPAID,                              
                        RESP_AREA_ID,                                   
                        APPL_PROGRAM_ID,                                
                        PYMT_FACILITY_CD,                               
                        USER_ID,                                        
                        COMPANY_NO,                                     
                        RECORD_ONLY_FL,                                 
                        DATE_ORIG_PYMT,                                 
                        PYMT_REFUNDED_IND,                              
                        CASH_COMPANY_NO,                                
                        CASH_LOCAL_OFFICE,                              
                        CASH_REPORT_NO,                                 
                        DATE_CASH_REPORT,                               
                        CASH_DRAWER_ID,                                 
                        TRAN_COMMENT)                                   
                VALUES                                                  
                      (:AR-ACCOUNT-NO,                                  
                       CIS.CHAR2TIMESTAMP(:AR-TRANS-HIST-SEQ-NO),               
                       IIF(TRY_CONVERT(DATE, :AR-DATE-TRANS 
                                             :WS-AR-NULL-IND-1
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS 
                                                      :WS-AR-NULL-IND-1
              ) <> 0) OR (LEN(:AR-DATE-TRANS :WS-AR-NULL-IND-1
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-TRANS :WS-AR-NULL-IND-1
              ), CONVERT(DATE, :AR-DATE-TRANS :WS-AR-NULL-IND-1) ),            
                       :AR-CODE-TRAN-TYPE,                              
                       :AR-AMT-ORIG-ENTERED,                            
                       :AR-AMT-BILLED-UNPAID,                           
                       :AR-RESP-AREA-ID,                                
                       :AR-APPL-PROGRAM-ID,                             
                       :AR-PYMT-FACILITY-CD,                            
                       :AR-USER-ID,                                     
                       :AR-COMPANY-NO,                                  
                       :AR-RECORD-ONLY-FL,                              
                       IIF(TRY_CONVERT(DATE, :AR-DATE-ORIG-PYMT 
                                             :WS-AR-NULL-IND-2
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-ORIG-PYMT 
                                                      :WS-AR-NULL-IND-2
              ) <> 0) OR (LEN(:AR-DATE-ORIG-PYMT :WS-AR-NULL-IND-2
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-ORIG-PYMT 
                                                      :WS-AR-NULL-IND-2
              ), CONVERT(DATE, :AR-DATE-ORIG-PYMT :WS-AR-NULL-IND-2) ),        
                       :AR-PYMT-REFUNDED-IND,                           
                       :AR-CASH-COMPANY-NO,                             
                       :AR-CASH-LOCAL-OFFICE,                           
                       :AR-CASH-REPORT-NO,                              
                       IIF(TRY_CONVERT(DATE, :AR-DATE-CASH-REPORT 
                                             :WS-AR-NULL-IND-3
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-CASH-REPORT 
                                                      :WS-AR-NULL-IND-3
              ) <> 0) OR (LEN(:AR-DATE-CASH-REPORT :WS-AR-NULL-IND-3
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-CASH-REPORT 
                                                      :WS-AR-NULL-IND-3
              ), CONVERT(DATE, :AR-DATE-CASH-REPORT :WS-AR-NULL-IND-3
              ) ),           
                       :AR-CASH-DRAWER-ID,                              
                       :AR-TRAN-COMMENT)                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_AR_TRANS_HIST                                   
MFA-TR*                (ACCOUNT_NO,                                             
MFA-TR*                 TRANS_HIST_SEQ_NO,                                      
MFA-TR*                 DATE_TRANS,                                             
MFA-TR*                 CODE_TRAN_TYPE,                                         
MFA-TR*                 AMT_ORIG_ENTERED,                                       
MFA-TR*                 AMT_BILLED_UNPAID,                                      
MFA-TR*                 RESP_AREA_ID,                                           
MFA-TR*                 APPL_PROGRAM_ID,                                        
MFA-TR*                 PYMT_FACILITY_CD,                                       
MFA-TR*                 USER_ID,                                                
MFA-TR*                 COMPANY_NO,                                             
MFA-TR*                 RECORD_ONLY_FL,                                         
MFA-TR*                 DATE_ORIG_PYMT,                                         
MFA-TR*                 PYMT_REFUNDED_IND,                                      
MFA-TR*                 CASH_COMPANY_NO,                                        
MFA-TR*                 CASH_LOCAL_OFFICE,                                      
MFA-TR*                 CASH_REPORT_NO,                                         
MFA-TR*                 DATE_CASH_REPORT,                                       
MFA-TR*                 CASH_DRAWER_ID,                                         
MFA-TR*                 TRAN_COMMENT)                                           
MFA-TR*         VALUES                                                          
MFA-TR*               (:AR-ACCOUNT-NO,                                          
MFA-TR*                :AR-TRANS-HIST-SEQ-NO,                                   
MFA-TR*                :AR-DATE-TRANS:WS-AR-NULL-IND-1,                         
MFA-TR*                :AR-CODE-TRAN-TYPE,                                      
MFA-TR*                :AR-AMT-ORIG-ENTERED,                                    
MFA-TR*                :AR-AMT-BILLED-UNPAID,                                   
MFA-TR*                :AR-RESP-AREA-ID,                                        
MFA-TR*                :AR-APPL-PROGRAM-ID,                                     
MFA-TR*                :AR-PYMT-FACILITY-CD,                                    
MFA-TR*                :AR-USER-ID,                                             
MFA-TR*                :AR-COMPANY-NO,                                          
MFA-TR*                :AR-RECORD-ONLY-FL,                                      
MFA-TR*                :AR-DATE-ORIG-PYMT:WS-AR-NULL-IND-2,                     
MFA-TR*                :AR-PYMT-REFUNDED-IND,                                   
MFA-TR*                :AR-CASH-COMPANY-NO,                                     
MFA-TR*                :AR-CASH-LOCAL-OFFICE,                                   
MFA-TR*                :AR-CASH-REPORT-NO,                                      
MFA-TR*                :AR-DATE-CASH-REPORT:WS-AR-NULL-IND-3,                   
MFA-TR*                :AR-CASH-DRAWER-ID,                                      
MFA-TR*                :AR-TRAN-COMMENT)                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8020'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT '                TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'CSS_AR_TRANS_HIST'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'TRANS_HIST_SEQ_NO'      TO TABLE-ELEMENT-2          
              MOVE 'DATE_TRANS'             TO TABLE-ELEMENT-3          
              MOVE 'CODE_TRAN_TYPE'         TO TABLE-ELEMENT-4          
              MOVE AR-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE AR-TRANS-HIST-SEQ-NO     TO HOSTVAR-ELEMENT-2        
              MOVE AR-DATE-TRANS            TO HOSTVAR-ELEMENT-3        
              MOVE AR-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT                            
                                          THRU 9000-EXIT                
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                          THRU 9900-EXIT                
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8030-UPDATE-REFUND.                                            *        
      ******************************************************************        
                                                                        
       8030-UPDATE-REFUND.                                              
                                                                        
           MOVE WS-ACCOUNT-NO-COMP3         TO RN-ACCOUNT-NO.           
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_REFUND                                       
                SET DATE_REFUNDED     =                                 
                                    IIF(TRY_CONVERT(DATE, 
                                                     :RN-DATE-REFUNDED 
                                                      :WS-RN-NULL-IND-1
              ) IS NULL OR (PATINDEX('%.%', :RN-DATE-REFUNDED 
                                                      :WS-RN-NULL-IND-1
              ) <> 0) OR (LEN(:RN-DATE-REFUNDED :WS-RN-NULL-IND-1
              ) <> 10), CIS.CHAR2DATE(:RN-DATE-REFUNDED 
                                                      :WS-RN-NULL-IND-1
              ), CONVERT(DATE, :RN-DATE-REFUNDED :WS-RN-NULL-IND-1) ), 
                    CHECK_STATUS_CD   = :RN-CHECK-STATUS-CD,            
                    USER_ID_APPRVD_BY = :RN-USER-ID-APPRVD-BY,          
                    ADDRESS_ID        = :RN-ADDRESS-ID,                 
                    TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :RN-TRANS-HIST-SEQ-NO
              ),          
                    COMMENTS          = :RN-COMMENTS                    
                WHERE ACCOUNT_NO        =  :RN-ACCOUNT-NO               
                  AND REFUND_ITEM_ID    =  :RN-REFUND-ITEM-ID           
                  AND PANEL_NO          =  'P111'                       
                  AND TRANS_HIST_SEQ_NO =  CIS.CHAR2TIMESTAMP(
                                                  :WS-TRANS-HIST-SEQ-NO
              )        
                  AND MANUAL_INDICATOR  =  :RN-MANUAL-INDICATOR         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_REFUND                                               
MFA-TR*         SET DATE_REFUNDED     =                                         
MFA-TR*                             :RN-DATE-REFUNDED:WS-RN-NULL-IND-1,         
MFA-TR*             CHECK_STATUS_CD   = :RN-CHECK-STATUS-CD,                    
MFA-TR*             USER_ID_APPRVD_BY = :RN-USER-ID-APPRVD-BY,                  
MFA-TR*             ADDRESS_ID        = :RN-ADDRESS-ID,                         
MFA-TR*             TRANS_HIST_SEQ_NO = :RN-TRANS-HIST-SEQ-NO,                  
MFA-TR*             COMMENTS          = :RN-COMMENTS                            
MFA-TR*         WHERE ACCOUNT_NO        =  :RN-ACCOUNT-NO                       
MFA-TR*           AND REFUND_ITEM_ID    =  :RN-REFUND-ITEM-ID                   
MFA-TR*           AND PANEL_NO          =  'P111'                               
MFA-TR*           AND TRANS_HIST_SEQ_NO =  :WS-TRANS-HIST-SEQ-NO                
MFA-TR*           AND MANUAL_INDICATOR  =  :RN-MANUAL-INDICATOR                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8030'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'CSS_REFUND'             TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'REFUND_ITEM_ID'         TO TABLE-ELEMENT-2          
              MOVE 'MANUAL_INDICATOR'       TO TABLE-ELEMENT-3          
              MOVE 'TRANS_HIST_SEQ_NO'      TO TABLE-ELEMENT-4          
              MOVE RN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE RN-REFUND-ITEM-ID        TO HOSTVAR-ELEMENT-2        
              MOVE RN-MANUAL-INDICATOR      TO HOSTVAR-ELEMENT-3        
              MOVE RN-TRANS-HIST-SEQ-NO     TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT                            
                                          THRU 9000-EXIT                
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                          THRU 9900-EXIT                
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8050-UPDATE-AR-TRANS-HIST                                      *        
      ******************************************************************        
                                                                        
       8050-UPDATE-AR-TRANS-HIST.                                       
                                                                        
           MOVE '8050'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           MOVE WS-ACCOUNT-NO-COMP3         TO AR-ACCOUNT-NO.           
           MOVE WS-PREV-DATE-TRANS          TO AR-DATE-TRANS.           
           MOVE WS-TRANS-HIST-SEQ-NO        TO AR-TRANS-HIST-SEQ-NO.    
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_AR_TRANS_HIST                                
                   SET PYMT_REFUNDED_IND = :AR-PYMT-REFUNDED-IND,       
                       RESP_AREA_ID      = :AR-RESP-AREA-ID,            
                       USER_ID           = :AR-USER-ID                  
                WHERE ACCOUNT_NO        =  :AR-ACCOUNT-NO               
                  AND ( CODE_TRAN_TYPE  =  'P' OR                       
                      ( CODE_TRAN_TYPE  =  'I' AND                      
                        APPL_PROGRAM_ID IN ('PANEL310A',                
                        'PANEL310B','PANEL310C','PANEL310D',            
                        'PANEL310E','PANEL310F','PANEL310G',            
                        'PANEL310H','PANEL310I')))                      
                  AND DATE_TRANS        =  IIF(TRY_CONVERT(DATE, 
                                                         :AR-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS
              ) <> 0) OR (LEN(:AR-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :AR-DATE-TRANS
              ), CONVERT(DATE, :AR-DATE-TRANS) )               
                  AND TRANS_HIST_SEQ_NO =  CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_AR_TRANS_HIST                                        
MFA-TR*            SET PYMT_REFUNDED_IND = :AR-PYMT-REFUNDED-IND,               
MFA-TR*                RESP_AREA_ID      = :AR-RESP-AREA-ID,                    
MFA-TR*                USER_ID           = :AR-USER-ID                          
MFA-TR*         WHERE ACCOUNT_NO        =  :AR-ACCOUNT-NO                       
MFA-TR*           AND ( CODE_TRAN_TYPE  =  'P' OR                               
MFA-TR*               ( CODE_TRAN_TYPE  =  'I' AND                              
MFA-TR*                 APPL_PROGRAM_ID IN ('PANEL310A',                        
MFA-TR*                 'PANEL310B','PANEL310C','PANEL310D',                    
MFA-TR*                 'PANEL310E','PANEL310F','PANEL310G',                    
MFA-TR*                 'PANEL310H','PANEL310I')))                              
MFA-TR*           AND DATE_TRANS        =  :AR-DATE-TRANS                       
MFA-TR*           AND TRANS_HIST_SEQ_NO =  :AR-TRANS-HIST-SEQ-NO                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8050'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'CSS_AR_TRANS_HIST'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'TRANS_HIST_SEQ_NO'      TO TABLE-ELEMENT-2          
              MOVE 'DATE_TRANS'             TO TABLE-ELEMENT-3          
              MOVE 'USER_ID'                TO TABLE-ELEMENT-4          
              MOVE AR-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE AR-TRANS-HIST-SEQ-NO     TO HOSTVAR-ELEMENT-2        
              MOVE AR-DATE-TRANS            TO HOSTVAR-ELEMENT-3        
              MOVE AR-USER-ID               TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT                            
                                          THRU 9000-EXIT                
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                          THRU 9900-EXIT                
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************34650000
      * END-PROGRAM-COPYLIB                                            *34660000
      ******************************************************************34670000
                                                                        
       8100-SEND-RESULT.                                                
                                                                        
             ADD 1 TO CTR-ROWS.                                         
                                                                        
       8100-EXIT.                                                       
              EXIT.                                                     
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * THIS COPYBOOK NEEDS TO BE USED BY PROGRAM WHERE WE ARE         *        
      * RETURNING MULTIPLE ROWS                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00000100
               INCLUDE CPD00321                                         00000200
           END-EXEC.                                                    00000300
                                                                        
