       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04909.                                      
COB303 DATE-WRITTEN.     JUNE 06 2005.                                  
       DATE-COMPILED.                                                   
      ******************************************************************00050000
      ****             SOUTH CAROLINA ELECTRIC & GAS                    00060000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00070000
      *                                                                 00080000
      *  TRANID:        S450                                           *00090000
      *  PROGRAM:       S450                                           *00100000
      *  CALLING SP:    PA_S450                                        *00110000
      *  PANEL NO:      137                                            *00120000
      ******************************************************************00130000
      *                 P R O G R A M  S U M M A R Y                   *00140000
      *                                                                *00150000
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *00160000
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *00170000
      *                                                                *00180000
      *  THIS RPC IS USED TO INSERT, UPDATE AND DELETE JUDGEMENT       *00190000
      *  INFORMATION IN TABLE CSS_JUDGEMENT                            *00180000
      *                                                                *00200000
      ******************************************************************00210000
      *                                                                *00220000
      *                     PROGRAM MODIFICATION LOG                   *00230000
      *                                                                *00240000
      *    DATE    INITIALS   COMMENTS                                 *00250000
      *  --------  --------   ---------------------------------------  *00260000
      *  04/10/01  SS82048    NEW RPC FOR JUDGMENT MAINTENANCE         *00270000
REARCH*  06/06/05  CVNS       RPC TO COBOL SP CONVERSION               *        
REARCH*            CHENNAI                                             *        
A04527*  06/06/13  MC95456    REMOVED UNUSED COPY BOOK CWS00056        *        
P00936*  04/15/16  VV7M728    FILED_CASE_NO LENGTH INCREASED TO 15     *        
P00936*  04/27/16  VK7L032    CLONE OF CSR02450.                       *        
P00936*  07/21/16  MS7M727    ADDED LOGIC FOR AUTO CARD AND E-DRAFT    *        
P00936*                       CANCELLATION                             *        
A05460*  10/07/16  VENKAT.P   ADDED USER ID TO CSR04304 CALL           *        
      ******************************************************************00380000
      *                                                                *00390000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00400000
      *                                                                *00410000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00420000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00430000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00440000
      *  3000 - 4999  NOT USED                                         *00450000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00460000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00470000
      *  7000 - 7999  INPUT MODULES                                    *00480000
      *  8000 - 8999  OUTPUT MODULES                                   *00490000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00500000
      *                                                                *00510000
      ******************************************************************00520000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04909'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR04909 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************00620000
      *    DB2 INCLUDES                                                *00630000
      ******************************************************************00640000
                                                                        
           EXEC SQL                                                     00660000
              INCLUDE SQLCA                                             00670000
           END-EXEC.                                                    00680000
                                                                        
           EXEC SQL                                                     00700000
               INCLUDE TBACCT                                           00710000
           END-EXEC.                                                    00720000
                                                                        
           EXEC SQL                                                     00740000
              INCLUDE TBJDGMNT                                          00750000
           END-EXEC.                                                    00760000
                                                                        
           EXEC SQL                                                     00780000
              INCLUDE TBMODEL                                           00790000
           END-EXEC.                                                    00800000
                                                                        
           EXEC SQL                                                     00820000
              INCLUDE TBMNHDT                                           00830000
           END-EXEC.                                                    00840000
                                                                        
           EXEC SQL                                                     00860000
              INCLUDE TBMNHIST                                          00870000
           END-EXEC.                                                    00880000
                                                                        
P00936     EXEC SQL                                                             
P00936        INCLUDE TBACTATT                                                  
P00936     END-EXEC.                                                            
                                                                        
      ******************************************************************00900000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00910000
      ******************************************************************00920000
                                                                        
REARCH*    COPY SYGWCOB.                                                00940000
REARCH*    COPY SYDBCOB.                                                00950000
           COPY CCA00001.                                               00960000
REARCH*    COPY CWS00010.                                               00970000
           COPY CWS00303.                                               00980000
P00936     COPY CWS00056.                                                       
REARCH*                                                                         
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
REARCH*                                                                         
                                                                        
      ******************************************************************01010000
      *    WORK AREAS                                                  *01020000
      ******************************************************************01030000
                                                                        
REARCH*01  GW-LIB-MISC-FIELDS.                                          01050000
REARCH*    05  GWL-PROC                POINTER.                         01060000
REARCH*    05  GWL-INIT-HANDLE         POINTER.                         01070000
REARCH*    05  GWL-RC                  PIC S9(9) COMP.                  01080000
REARCH*    05  GWL-STATUS-NR           PIC S9(9) COMP.                  01090000
REARCH*    05  GWL-STATUS-DONE         PIC S9(9) COMP.                  01100000
REARCH*    05  GWL-STATUS-COUNT        PIC S9(9) COMP.                  01110000
REARCH*    05  GWL-STATUS-COMM         PIC S9(9) COMP.                  01120000
REARCH*    05  GWL-STATUS-RETURN-CODE  PIC S9(9) COMP.                  01130000
REARCH*    05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  01140000
REARCH*                                                                 01150000
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                 PIC X(26)                       
REARCH                                      VALUE 'SESSION.CSR04909_R1'.
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN           PIC S9(04) COMP.                
REARCH         49 GTT-ROW-CHAR          PIC X(1024).                    
REARCH     05  GTT-SQLCODE              PIC S9(9) COMP.                 
REARCH*                                                                 01150000
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
      **************************************************************    01170000
      *  INPUT - MODE, ACCOUNT NO , DATE-FILED, FILED-CASE-NO,     *    01180000
      *        - TRAN-COMMENT, USER-ID                             *    01180000
      **************************************************************    01200000
       01  PARM-FIELDS.                                                 
REARCH*    05  PARM-L                  PIC S9(9)  USAGE COMP.           01220000
REARCH*    05  PARM-ID1                PIC S9(9)  USAGE COMP VALUE 1.   01230000
REARCH*    05  PARM-JDGMNT-CASE-NO     PIC X(10)  VALUE SPACES.         01250000
REARCH*    05  PARM-DATE-FILED         PIC X(10)  VALUE SPACES.         01270000
REARCH*    05  PARM-USER-ID            PIC X(07)  VALUE SPACES.         01290000
REARCH*    05  PARM-RESP-AREA-ID       PIC X(03)  VALUE SPACES.         01300000
REARCH*    05  PARM-MODE               PIC X(01)  VALUE SPACES.         01310000
REARCH*    05  PARM-ACCOUNT-NO         PIC X(13)  VALUE SPACES.         01320000
           05  PARM-TRANS-COMMENT.                                      
REARCH         10  PARM-TRANS-COMMENT-LEN     PIC  S9(4) COMP           
REARCH                                        SYNC VALUE +0.            
REARCH         10  PARM-TRANS-COMMENT-TEXT    PIC  X(210)               
REARCH                                        VALUE SPACES.             
                                                                        
REARCH*    05  PARM-ACCOUNT-INFO              PIC X(253)                01390000
REARCH*                                       VALUE SPACES.             01400000
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-SUB                  PIC 9(3) VALUE 1.                
           05  WS-JU-JDGMNT-CASE-NO    PIC X(10) VALUE SPACES.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
P00936*01 LOC1 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.            
P00936*01 LOC2 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.            
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04909'.      
                                                                        
           05  WS-MODE                 PIC X(01).                       
               88 NEW-CASE                        VALUE 'N'.            
               88 CASE-NO-UPDATE                  VALUE 'U'.            
               88 UPDATE-ACCTS                    VALUE 'A'.            
                                                                        
           05  WS-ACCOUNT-STRING       PIC X(252) VALUE SPACES.         
           05  WS-ACCOUNT-ARRAY REDEFINES WS-ACCOUNT-STRING.            
               10 WS-ACCOUNT-DETAIL OCCURS 200 TIMES.                   
                  15  WS-ACCOUNT-NUMBER   PIC 9(13).                    
                  15  WS-UPDATE-FLAG      PIC X(01).                    
                      88 SET-JUDGEMENT      VALUE 'S'.                  
                      88 REMOVE-JUDGEMENT   VALUE 'R'.                  
                                                                        
           05  WS-MAX-CASE-NO          PIC X(10) VALUE SPACES.          
           05  WS-MAX-CASE-NO-NUM REDEFINES WS-MAX-CASE-NO              
                                       PIC 9(10).                       
           05  WS-MAX-CASE-IND         PIC S9(04) COMP.                 
                                                                        
           05  WS-AT-ACCOUNT-NUM       PIC 9(13).                       
           05  WS-AT-ACCOUNT-CHAR REDEFINES WS-AT-ACCOUNT-NUM           
                                       PIC X(13).                       
P00936     05  WS-FILED-CASE-NO        PIC X(15)  VALUE SPACES.         
           05  WS-JDGMNT-CASE-NO       PIC X(10)  VALUE SPACES.         
P00936     05  WS-PREV-FILED-CASE-NO   PIC X(15)  VALUE SPACES.         
           05  WS-DATE-FILED           PIC X(10)  VALUE SPACES.         
           05  WS-DATE-JDGMT-FILED     PIC X(10)  VALUE SPACES.         
           05  WS-USER-ID              PIC X(07)  VALUE SPACES.         
           05  WS-RESP-AREA-ID         PIC X(03)  VALUE SPACES.         
           05  WS-PARM-MODE            PIC X(01)  VALUE SPACES.         
           05  WS-ACCOUNT-NO           PIC X(13).                       
           05  WS-ACCOUNT-NUM          REDEFINES WS-ACCOUNT-NO          
                                       PIC 9(13).                       
           05  WS-NULL-IND             PIC S9(4) COMP VALUE +0.         
           05  WS-NULL-IND2            PIC S9(4) COMP VALUE +0.         
           05  WS-NULL-IND3            PIC S9(4) COMP VALUE +0.         
           05  WS-NULL-IND4            PIC S9(4) COMP VALUE +0.         
P00936     05  WS-ACTIVE               PIC X(01) VALUE 'A'.             
P00936     05  WS-AUTO-CARD-EXIST       PIC X(01) VALUE 'N'.            
P00936     05  WS-COMPANY-NO            PIC X(02) VALUE SPACES.         
P00936     05  WS-APPLN-SOURCE          PIC X(08) VALUE SPACES.         
P00936     05  WS-UPDATE-TYPE           PIC X(01) VALUE SPACES.         
P00936     05  WS-STATUS-CODE           PIC X(01) VALUE SPACES.         
P00936     05  WS-DRAFT-CYCLE           PIC X(02) VALUE SPACES.         
P00936     05  WS-REQSTED-DRAFT-DAY     PIC X(02) VALUE SPACES.         
P00936     05  WS-BANK-ID               PIC X(06) VALUE SPACES.         
P00936     05  WS-BANK-ACCOUNT-NAME     PIC X(50) VALUE SPACES.         
P00936     05  WS-BANK-ACCT-NO          PIC X(19) VALUE SPACES.         
P00936     05  WS-ACCT-TYPE-CD          PIC X(01) VALUE SPACES.         
P00936     05  WS-COMMENT-TEXT          PIC X(210) VALUE SPACES.        
P00936     05  WS-COMMENT-LEN           PIC X(04) VALUE SPACES.         
P00936     05  WS-INIT-TYPE-CD          PIC X(02) VALUE SPACES.         
P00936     05  WS-NICKNAME-TEXT         PIC X(50) VALUE SPACES.         
P00936     05  WS-NICKNAME-LEN          PIC X(04) VALUE SPACES.         
P00936     05  WS-CUST-BNK-SEQ-NO       PIC X(09) VALUE SPACES.         
P00936     05  WS-CSR04846-RETURN-CD    PIC S9(9) COMP VALUE 0.         
P00936     05  WS-CSR04304-RETURN-CD    PIC S9(9) COMP VALUE 0.         
P00936     05  WS-CSR04304-ACCT-NO      PIC X(13) VALUE SPACES.         
P00936     05  WS-CSR04304-CMPY-NO      PIC X(04) VALUE SPACES.         
P00936     05  WS-CSR04304-TIMESTMP     PIC X(26) VALUE SPACES.         
P00936     05  WS-APPL-RETURN-CODE      PIC X(10) VALUE SPACES.         
P00936     05  WS-ENROLL-STATUS         PIC X(03) VALUE SPACES.         
P00936     05  WS-CURR-TIMESTMP         PIC X(26) VALUE SPACES.         
P00936     05  WS-RESP-AREA             PIC X(03) VALUE SPACES.         
                                                                        
       01  WS-SYS-DATE.                                                 
           05  WS-SYS-CCYY             PIC X(04).                       
           05  FILLER                  PIC X(01)  VALUE '-'.            
           05  WS-SYS-MONTH            PIC X(02).                       
           05  FILLER                  PIC X(01)  VALUE '-'.            
           05  WS-SYS-DAY              PIC X(02).                       
                                                                        
       01  WS-TMP-DATE.                                                 
           05  WS-TMP-MONTH            PIC X(02).                       
           05  FILLER                  PIC X(01)  VALUE '/'.            
           05  WS-TMP-DAY              PIC X(02).                       
           05  FILLER                  PIC X(01)  VALUE '/'.            
           05  WS-TMP-CCYY             PIC X(04).                       
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-J                    PIC X(01) VALUE 'J'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-JUDGEMENT-IND        PIC X(01)      VALUE SPACES.     
           05  RS-JDGMNT-CASE-NO       PIC X(10)      VALUE SPACES.     
REARCH*                                                                         
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
REARCH     05  S-JUDGEMENT-IND         PIC X(01)      VALUE SPACES.     
REARCH     05  S-JDGMNT-CASE-NO        PIC X(10)      VALUE SPACES.     
REARCH*                                                                 02320000
                                                                        
REARCH*01  CNS-COLUMN-NAMES.                                            02340000
REARCH*    05  CNS-RETURN-CODE         PIC X(11) VALUE 'RETURN_CODE'.   02350000
REARCH*    05  CNS-JUDGEMENT-IND       PIC X(10) VALUE 'JDGMNT_IND'.    02360000
REARCH*    05  CNS-JDGMNT-CASE-NO      PIC X(14) VALUE 'JDGMNT_CASE_NO'.02380000
                                                                        
       01  WS-MNT-TRANS-DET.                                            
           05  WS-CODE-TRAN-TYPE         PIC X(01) VALUE 'B'.           
           05  WS-TRAN-APPL-NO           PIC S9(02) VALUE +1.           
           05  WS-COLUMN-DESC            PIC X(04) VALUE '****'.        
           05  WS-CHG-COLUMN-VALUE-TEXT  PIC X(04)  VALUE '****'.       
           05  WS-CHG-COLUMN-VALUE-LEN   PIC S9(02) VALUE +4.           
           05  WS-PRV-COLUMN-VALUE-TEXT  PIC X(04)  VALUE 'NONE'.       
           05  WS-PRV-COLUMN-VALUE-LEN   PIC S9(02) VALUE +4.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
                                                                        
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
REARCH     10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
REARCH*                                                                         
      ******************************************************************02580000
      *                                                                *02590000
      *  CURSOR DECLARATION FOR THE CSS_ACCOUNT TABLE.                 *02600000
      *  FOR FETCHING ALL ACCOUNTS UNDER THE JUDGEMENT CASE NUMBER     *02610000
      *                                                                *02620000
      ******************************************************************02630000
           EXEC SQL                                                     
               DECLARE AT-CASE-NO-CRSR CURSOR FOR                       
               SELECT ACCOUNT_NO                                        
               FROM CSS_ACCOUNT                                         
               WHERE JUDGEMENT_CASE_NO = :AT-JUDGEMENT-CASE-NO          
           END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE CANCEL_EDRAFT CURSOR
MSQ001          FOR CALL CSR04846 ( 'CIS'
                  , 'C'
                  , :WS-ACCOUNT-NO
                  , 'D'
                  , :WS-DRAFT-CYCLE
                  , :WS-REQSTED-DRAFT-DAY
                  , :WS-BANK-ACCOUNT-NAME
                  , :WS-BANK-ACCT-NO
                  , :WS-ACCT-TYPE-CD
                  , :WS-BANK-ID
                  , :WS-USER-ID
                  , :WS-RESP-AREA-ID
                  , 'BANKRUPTCY SETUP'
                  , '019'
                  , :WS-INIT-TYPE-CD
                  , :WS-NICKNAME-TEXT
                  , :WS-NICKNAME-LEN
                  , :WS-CUST-BNK-SEQ-NO
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE CANCEL_AUTO_CARD CURSOR
MSQ001          FOR CALL CSR04304 ( 'CAN'
                  , :WS-ACCOUNT-NO
                  , :WS-COMPANY-NO
                  , :WS-CURR-TIMESTMP
                  , '$$$'
                  , :WS-USER-ID
                  )
MSQ001        END-EXEC.
                                                    
      *                                                                 02720000
REARCH LINKAGE SECTION.                                                 
P00936 01  PARM-FILED-CASE-NO      PIC X(15).                           
REARCH 01  PARM-JDGMNT-CASE-NO     PIC X(10).                           
REARCH 01  PARM-DATE-FILED         PIC X(10).                           
REARCH 01  PARM-USER-ID            PIC X(07).                           
REARCH 01  PARM-RESP-AREA-ID       PIC X(03).                           
REARCH 01  PARM-MODE               PIC X(01).                           
REARCH 01  PARM-ACCOUNT-NO         PIC X(13).                           
REARCH 01  PARM-TRANS-CMNT-TEXT    PIC X(210).                          
REARCH 01  PARM-TRANS-CMNT-LEN     PIC S9(4) COMP.                      
       01 PARM-ACCOUNT-INFO.                                            
          05  PARM-LENGTH         PIC S9(04) COMP VALUE +0.             
          05  PARM-ACCT-NUM       PIC X(2800).                          
HPCCDM*EJECT                                                            02730000
REARCH*                                                                         
REARCH PROCEDURE DIVISION USING PARM-FILED-CASE-NO                      
REARCH                          PARM-JDGMNT-CASE-NO                     
REARCH                          PARM-DATE-FILED                         
REARCH                          PARM-USER-ID                            
REARCH                          PARM-RESP-AREA-ID                       
REARCH                          PARM-MODE                               
REARCH                          PARM-ACCOUNT-NO                         
REARCH                          PARM-TRANS-CMNT-TEXT                    
REARCH                          PARM-TRANS-CMNT-LEN                     
REARCH                          PARM-ACCOUNT-INFO.                      
      *                                                                 02760000
      ******************************************************************02770000
      * 0000-MAINLINE                                                  *02780000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02790000
      ******************************************************************02800000
      *                                                                 02810000
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02920000
      * 0100-INITIALIZE                                                *02930000
      *                                                                *02940000
      *     1. RESET DB2 ERROR HANDLERS                                *02950000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *02960000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *02970000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*02980000
      *                                                                *02990000
      ******************************************************************03000000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
REARCH*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.     03070000
REARCH*                                                                 03080000
REARCH*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,     03090000
REARCH*                          SNA-CONNECTION-NAME, SNA-SUBC.         03100000
REARCH*                                                                 03110000
REARCH*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                      03120000
                                                                        
REARCH*    IF GWL-RC NOT = TDS-PARM-PRESENT                             03140000
REARCH*       MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     03150000
REARCH*       MOVE '0100'          TO ACTIVE-PARAGRAPH                  03160000
REARCH*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION      03170000
REARCH*       MOVE 'CICS TRANSACTION'   TO TABLE-1                      03180000
REARCH*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE        03190000
REARCH*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            03200000
REARCH*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            03210000
REARCH*    END-IF.                                                      03220000
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH           :S-RETURN-CODE          AS RETURN_CODE                 
REARCH          ,:S-JUDGEMENT-IND        AS JUDGEMENT_IND               
REARCH          ,:S-JDGMNT-CASE-NO       AS JDGMNT_CASE_NO              
REARCH         FROM                                                     
REARCH             CIS.SYSDUMMY1                                     
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*          :S-RETURN-CODE          AS RETURN_CODE                         
MFA-TR*         ,:S-JUDGEMENT-IND        AS JUDGEMENT_IND                       
MFA-TR*         ,:S-JDGMNT-CASE-NO       AS JDGMNT_CASE_NO                      
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03270000
      * 1000-PROCESS-INPUT                                             *03280000
      *                                                                *03290000
      *     1. PROCESS INPUTS.                                         *03300000
      *                                                                *03310000
      ******************************************************************03320000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH*    PERFORM 1100-RECEIVE-PARMS THRU 1100-EXIT.                   03360000
           MOVE PARM-ACCOUNT-NO       TO WS-ACCOUNT-NO.                 
           MOVE WS-ACCOUNT-NUM        TO AT-ACCOUNT-NO.                 
P00936     MOVE PARM-USER-ID          TO WS-USER-ID.                    
           MOVE PARM-MODE             TO WS-MODE.                       
REARCH     MOVE PARM-TRANS-CMNT-TEXT  TO PARM-TRANS-COMMENT-TEXT.       
REARCH     MOVE PARM-TRANS-CMNT-LEN   TO PARM-TRANS-COMMENT-LEN.        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03440000
      * 1100-RECEIVE-PARMS                                             *03450000
      *                                                                *03460000
      *     1. RECEIVE PARMETERS.                                      *03470000
      *                                                                *03480000
      ******************************************************************03490000
                                                                        
REARCH*1100-RECEIVE-PARMS.                                              03510000
                                                                        
REARCH*    MOVE 1                            TO PARM-ID1.               03530000
REARCH*    MOVE LENGTH OF PARM-FILED-CASE-NO TO MAX-LENGTH-PARM.        03540000
REARCH*                                                                 03550000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              03560000
REARCH*                          GWL-RC,                                03570000
REARCH*                          PARM-ID1,                              03580000
REARCH*                          PARM-FILED-CASE-NO,                    03590000
REARCH*                          TDSCHAR,                               03600000
REARCH*                          MAX-LENGTH-PARM,                       03610000
REARCH*                          PARM-L.                                03620000
REARCH*                                                                 03630000
REARCH*    ADD 1                              TO PARM-ID1.              03640000
REARCH*    MOVE LENGTH OF PARM-JDGMNT-CASE-NO TO MAX-LENGTH-PARM.       03650000
REARCH*                                                                 03660000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              03670000
REARCH*                          GWL-RC,                                03680000
REARCH*                          PARM-ID1,                              03690000
REARCH*                          PARM-JDGMNT-CASE-NO,                   03700000
REARCH*                          TDSCHAR,                               03710000
REARCH*                          MAX-LENGTH-PARM,                       03720000
REARCH*                          PARM-L.                                03730000
REARCH*                                                                 03740000
REARCH*    ADD 1                             TO PARM-ID1.               03860000
REARCH*    MOVE LENGTH OF PARM-DATE-FILED    TO MAX-LENGTH-PARM.        03870000
REARCH*                                                                 03880000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              03890000
REARCH*                          GWL-RC,                                03900000
REARCH*                          PARM-ID1,                              03910000
REARCH*                          PARM-DATE-FILED,                       03920000
REARCH*                          TDSCHAR,                               03930000
REARCH*                          MAX-LENGTH-PARM,                       03940000
REARCH*                          PARM-L.                                03950000
REARCH*                                                                 03960000
REARCH*    ADD 1                            TO PARM-ID1.                04080000
REARCH*    MOVE LENGTH OF PARM-USER-ID      TO MAX-LENGTH-PARM.         04090000
REARCH*                                                                 04100000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              04110000
REARCH*                          GWL-RC,                                04120000
REARCH*                          PARM-ID1,                              04130000
REARCH*                          PARM-USER-ID,                          04140000
REARCH*                          TDSCHAR,                               04150000
REARCH*                          MAX-LENGTH-PARM,                       04160000
REARCH*                          PARM-L.                                04170000
REARCH*                                                                 04180000
REARCH*    ADD 1                                TO PARM-ID1.            04190000
REARCH*    MOVE LENGTH OF PARM-RESP-AREA-ID     TO MAX-LENGTH-PARM.     04200000
REARCH*                                                                 04210000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              04220000
REARCH*                          GWL-RC,                                04230000
REARCH*                          PARM-ID1,                              04240000
REARCH*                          PARM-RESP-AREA-ID,                     04250000
REARCH*                          TDSCHAR,                               04260000
REARCH*                          MAX-LENGTH-PARM,                       04270000
REARCH*                          PARM-L.                                04280000
REARCH*                                                                 04290000
REARCH*    ADD 1                             TO PARM-ID1.               04300000
REARCH*    MOVE LENGTH OF PARM-MODE          TO MAX-LENGTH-PARM.        04310000
REARCH*                                                                 04320000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              04330000
REARCH*                          GWL-RC,                                04340000
REARCH*                          PARM-ID1,                              04350000
REARCH*                          PARM-MODE,                             04360000
REARCH*                          TDSCHAR,                               04370000
REARCH*                          MAX-LENGTH-PARM,                       04380000
REARCH*                          PARM-L.                                04390000
REARCH*                                                                 04400000
REARCH*    ADD 1                             TO PARM-ID1.               04410000
REARCH*    MOVE LENGTH OF PARM-ACCOUNT-NO    TO MAX-LENGTH-PARM.        04420000
REARCH*                                                                 04430000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              04440000
REARCH*                          GWL-RC,                                04450000
REARCH*                          PARM-ID1,                              04460000
REARCH*                          PARM-ACCOUNT-NO,                       04470000
REARCH*                          TDSCHAR,                               04480000
REARCH*                          MAX-LENGTH-PARM,                       04490000
REARCH*                          PARM-L.                                04500000
REARCH*                                                                 04510000
REARCH*    ADD 1                                  TO PARM-ID1.          04520000
REARCH*    MOVE LENGTH OF PARM-TRANS-COMMENT-TEXT TO MAX-LENGTH-PARM.   04530000
REARCH*                                                                 04540000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              04550000
REARCH*                          GWL-RC,                                04560000
REARCH*                          PARM-ID1,                              04570000
REARCH*                          PARM-TRANS-COMMENT-TEXT,               04580000
REARCH*                          TDSVARYCHAR,                           04590000
REARCH*                          MAX-LENGTH-PARM,                       04600000
REARCH*                          PARM-L.                                04610000
REARCH*                                                                 04620000
REARCH*    ADD 1                            TO PARM-ID1.                04630000
REARCH*    MOVE LENGTH OF PARM-TRANS-COMMENT-LEN                        04640000
REARCH*                                    TO MAX-LENGTH-PARM.          04650000
REARCH*                                                                 04660000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              04670000
REARCH*                          GWL-RC,                                04680000
REARCH*                          PARM-ID1,                              04690000
REARCH*                          PARM-TRANS-COMMENT-LEN,                04700000
REARCH*                          TDSINT2,                               04710000
REARCH*                          MAX-LENGTH-PARM,                       04720000
REARCH*                          PARM-L.                                04730000
REARCH*                                                                 04740000
REARCH*    ADD 1                            TO PARM-ID1.                04750000
REARCH*    MOVE LENGTH OF PARM-ACCOUNT-INFO TO MAX-LENGTH-PARM.         04760000
REARCH*                                                                 04770000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              04780000
REARCH*                          GWL-RC,                                04790000
REARCH*                          PARM-ID1,                              04800000
REARCH*                          PARM-ACCOUNT-INFO,                     04810000
REARCH*                          TDSCHAR,                               04820000
REARCH*                          MAX-LENGTH-PARM,                       04830000
REARCH*                          PARM-L.                                04840000
REARCH*                                                                 04850000
REARCH*1100-EXIT.                                                       04860000
REARCH*    EXIT.                                                        04870000
                                                                        
      ******************************************************************04890000
      * 2000-PROCESS-OUTPUT.                                           *04900000
      *    CALLS 2100-DESCRIBE-RESULT                                  *04910000
      *          MOVE ALL INPUT FIELDS TO THEIR WS-COUNTERPARTS        *04920000
      *    CALLS 5000-UPDATE                                           *04930000
      *    CALLS 8100-SEND-RESULT                                      *04940000
      ******************************************************************04950000
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000'             TO ACTIVE-PARAGRAPH.                 
REARCH*    PERFORM 2100-DESCRIBE-RESULT THRU 2100-EXIT.                 04980000
REARCH*    PERFORM 2200-DESC-DATA       THRU 2200-EXIT.                 04990000
           PERFORM 5000-UPDATE          THRU 5000-EXIT.                 
REARCH     PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT.                
REARCH     ADD +1                       TO   CTR-ROWS.                  
REARCH*    PERFORM 8100-SEND-RESULT     THRU 8100-EXIT.                 05010000
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH*****************************************************************         
REARCH*                                                               *         
REARCH* 2000A-MOVE-RESULT.                                            *         
REARCH*****************************************************************         
REARCH*                                                                         
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE          TO S-RETURN-CODE.               
REARCH     MOVE RS-JUDGEMENT-IND        TO S-JUDGEMENT-IND.             
REARCH     MOVE RS-JDGMNT-CASE-NO       TO S-JDGMNT-CASE-NO.            
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
                                                                        
      ******************************************************************05050000
      *                                                                *05060000
      * 2100-DESCRIBE-RESULT                                           *05070000
      *                                                                *05080000
      ******************************************************************05090000
REARCH*2100-DESCRIBE-RESULT.                                            05100000
                                                                        
REARCH*    MOVE '2100' TO ACTIVE-PARAGRAPH.                             05120000
REARCH*                                                                 05130000
REARCH*    MOVE 1       TO CTR-COLUMN.                                  05140000
REARCH*    MOVE TDSINT4 TO DB-HOST-TYPE.                                05150000
REARCH*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                              05160000
REARCH*    MOVE LENGTH OF RS-RETURN-CODE      TO WRKLEN1.               05170000
REARCH*    MOVE LENGTH OF CNS-RETURN-CODE     TO WRKLEN2.               05180000
REARCH*                                                                 05190000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05200000
REARCH*                          GWL-RC,                                05210000
REARCH*                          CTR-COLUMN,                            05220000
REARCH*                          DB-HOST-TYPE,                          05230000
REARCH*                          WRKLEN1,                               05240000
REARCH*                          RS-RETURN-CODE,                        05250000
REARCH*                          DB-NULL-INDICATOR,                     05260000
REARCH*                          TDS-FALSE,                             05270000
REARCH*                          DB-CLIENT-TYPE,                        05280000
REARCH*                          WRKLEN1,                               05290000
REARCH*                          CNS-RETURN-CODE,                       05300000
REARCH*                          WRKLEN2.                               05310000
REARCH*                                                                 05320000
REARCH*     PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                    05330000
REARCH*                                                                 05340000
REARCH*2100-EXIT.                                                       05350000
REARCH*    EXIT.                                                        05360000
      *                                                                 05370000
      ******************************************************************05380000
      * 2200-DESC-DATA                                                 *05390000
      *                                                                *05400000
      *     CALLS TDESCRIB                                             *05410000
      *           9100-CHECK-ERROR                                     *05420000
      *                                                                *05430000
      *     CALLED FROM 2000-PROCESS-OUTPUTT                           *05440000
      *                                                                *05450000
      *     DESCRIBE BILLING HEADER RESULT FIELDS TO THE CLIENT        *05460000
      *                                                                *05470000
      ******************************************************************05480000
REARCH*                                                                 05490000
REARCH*2200-DESC-DATA.                                                  05500000
REARCH*    MOVE '2200'                          TO ACTIVE-PARAGRAPH.    05510000
REARCH*                                                                 05520000
REARCH*                                                                 05530000
REARCH*    ADD 1                                TO CTR-COLUMN.          05540000
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.        05550000
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.      05560000
REARCH*    MOVE LENGTH OF RS-JUDGEMENT-IND      TO WRKLEN1.             05570000
REARCH*    MOVE LENGTH OF CNS-JUDGEMENT-IND     TO WRKLEN2.             05580000
REARCH*                                                                 05590000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05600000
REARCH*                          GWL-RC,                                05610000
REARCH*                          CTR-COLUMN,                            05620000
REARCH*                          DB-HOST-TYPE,                          05630000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          RS-JUDGEMENT-IND,                      05650000
REARCH*                          DB-NULL-INDICATOR,                     05660000
REARCH*                          TDS-FALSE,                             05670000
REARCH*                          DB-CLIENT-TYPE,                        05680000
REARCH*                          WRKLEN1,                               05690000
REARCH*                          CNS-JUDGEMENT-IND,                     05700000
REARCH*                          WRKLEN2.                               05710000
REARCH*                                                                 05720000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     05730000
REARCH*                                                                 05740000
REARCH*                                                                 05960000
REARCH*    ADD 1                                TO CTR-COLUMN.          05970000
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.        05980000
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.      05990000
REARCH*    MOVE LENGTH OF RS-JDGMNT-CASE-NO     TO WRKLEN1.             06000000
REARCH*    MOVE LENGTH OF CNS-JDGMNT-CASE-NO    TO WRKLEN2.             06010000
REARCH*                                                                 06020000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              06030000
REARCH*                          GWL-RC,                                06040000
REARCH*                          CTR-COLUMN,                            06050000
REARCH*                          DB-HOST-TYPE,                          06060000
REARCH*                          WRKLEN1,                               06070000
REARCH*                          RS-JDGMNT-CASE-NO,                     06080000
REARCH*                          DB-NULL-INDICATOR,                     06090000
REARCH*                          TDS-FALSE,                             06100000
REARCH*                          DB-CLIENT-TYPE,                        06110000
REARCH*                          WRKLEN1,                               06120000
REARCH*                          CNS-JDGMNT-CASE-NO,                    06130000
REARCH*                          WRKLEN2.                               06140000
REARCH*                                                                 06150000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     06160000
REARCH*                                                                 06170000
REARCH*2200-EXIT.                                                       06180000
REARCH*    EXIT.                                                        06190000
                                                                        
      ***************************************************************   06210000
      *                                                             *   06220000
      * MAIN UPDATE PARAGRAPH.                                      *   06230000
      *                                                             *   06240000
      ***************************************************************   06250000
                                                                        
       5000-UPDATE.                                                     
                                                                        
           MOVE '5000' TO ACTIVE-PARAGRAPH.                             
                                                                        
P00936     PERFORM 7010-GET-CURR-TIME    THRU 7010-EXIT.                
                                                                        
           IF  WS-MODE = 'A' OR WS-MODE = 'N'                           
               PERFORM 5300-PROCESS-JUDGEMENT THRU 5300-EXIT            
               PERFORM 5100-MOVE-TRAN-HEAD THRU 5100-EXIT               
               PERFORM 5200-MOVE-TRAN-DET  THRU 5200-EXIT               
           ELSE                                                         
               IF  WS-MODE = 'U'                                        
                   PERFORM 5100-MOVE-TRAN-HEAD THRU 5100-EXIT           
                   PERFORM 5200-MOVE-TRAN-DET  THRU 5200-EXIT           
                   PERFORM 5300-PROCESS-JUDGEMENT THRU 5300-EXIT        
               END-IF                                                   
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   06460000
      * MOVE FIELDS TO THE MAINTENANCE TRANSACTION HEADER AND       *   06470000
      * CALL COMMON PARAGRAPH FOR WRITING A ROW.                    *   06480000
      ***************************************************************   06490000
                                                                        
       5100-MOVE-TRAN-HEAD.                                             
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :MH-TRANS-HIST-SEQ-NO           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     06530000
MFA-TR*        SET :MH-TRANS-HIST-SEQ-NO =  CURRENT TIMESTAMP           06540000
MFA-TR*    END-EXEC.                                                    06550000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME    TO ABEND-PROGRAM                    
               MOVE '5100'          TO ACTIVE-PARAGRAPH                 
               MOVE 'SET'           TO ABEND-FUNCTION                   
               MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1                  
               MOVE PARM-ACCOUNT-NO TO HOSTVAR-ELEMENT-1                
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-DATE-TRANS                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     06680000
MFA-TR*        SET :MH-DATE-TRANS =  CURRENT DATE                       06690000
MFA-TR*    END-EXEC.                                                    06700000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME    TO ABEND-PROGRAM                    
               MOVE '5100'          TO ACTIVE-PARAGRAPH                 
               MOVE 'SET'           TO ABEND-FUNCTION                   
               MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1                  
               MOVE PARM-ACCOUNT-NO TO HOSTVAR-ELEMENT-1                
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           MOVE 'F'                TO MH-CODE-TRAN-TYPE.                
           MOVE PARM-RESP-AREA-ID  TO MH-RESP-AREA-ID.                  
           MOVE 0                  TO MH-PREMISE-NO.                    
           MOVE 0                  TO MH-CUSTOMER-NO.                   
           MOVE WS-ACCOUNT-NUM     TO MH-ACCOUNT-NO.                    
           MOVE AT-ACCOUNT-NO      TO MH-ACCOUNT-NO.                    
           MOVE PARM-USER-ID       TO MH-USER-ID.                       
           MOVE 'PANEL137'         TO MH-APPL-PROGRAM-ID.               
           MOVE PARM-TRANS-COMMENT TO MH-TRAN-COMMENT.                  
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *************************************************************     06960000
      * CHECK WHETHER ANY OF THE COLUMN VALUES HAVE CHANGED.IF    *     06970000
      * SO THEN WRITE A RECORD IN THE TRANSACTION DETAIL.         *     06980000
      * COLUMN VALUES ARE :                                       *     06990000
      * FOR INSERT : JUDGEMENT-CASE-NO, FILED-CASE-NO, DATE-FILED *     07000000
      *              USER-ID-INIT-BY                              *     07000000
      * FOR UPDATE : FILED-CASE-NO, DATE-FILED                    *     07010000
      * FOR DELETE : FILED-CASE-NO, DATE-FILED                    *     07020000
      *************************************************************     07030000
       5200-MOVE-TRAN-DET.                                              
                                                                        
           MOVE '5200' TO ACTIVE-PARAGRAPH.                             
      *                                                                 07290000
           EVALUATE TRUE                                                
      *                                                                 07290000
               WHEN CASE-NO-UPDATE                                      
                   MOVE PARM-JDGMNT-CASE-NO TO JU-JUDGEMENT-CASE-NO     
                                               AT-JUDGEMENT-CASE-NO     
                   PERFORM 7300-SELECT-JU-ROW    THRU 7300-EXIT         
                   PERFORM 7200-OPEN-AT-CASE-CRSR THRU 7200-EXIT        
                   PERFORM 7210-FETCH-AT-CASE-CRSR THRU 7210-EXIT       
                   PERFORM 5230-JRNL-EXIST-ACCTS THRU  5230-EXIT        
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                   PERFORM 7220-CLOSE-AT-CASE-CRSR THRU 7220-EXIT       
      *                                                                 07290000
              WHEN NEW-CASE                                             
                  PERFORM 5205-JRNL-ACCTS THRU 5205-EXIT                
                  VARYING WS-SUB FROM 1 BY 1                            
SCA006            UNTIL   WS-SUB > 200 OR 
                          WS-ACCOUNT-DETAIL(WS-SUB) = SPACES OR 
                          WS-ACCOUNT-DETAIL(WS-SUB) = LOW-VALUES                
      *                                                                 07290000
              WHEN UPDATE-ACCTS                                         
                  PERFORM 5205-JRNL-ACCTS THRU 5205-EXIT                
                  VARYING WS-SUB FROM 1 BY 1                            
SCA006            UNTIL   WS-SUB > 200 OR 
                          WS-ACCOUNT-DETAIL(WS-SUB) = SPACES OR 
                          WS-ACCOUNT-DETAIL(WS-SUB) = LOW-VALUES                
      *                                                                 07290000
           END-EVALUATE.                                                
      *                                                                 07290000
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   07340000
      *                                                             *   07350000
      *5205-JRNL-ACCTS.                                                 07360000
      ***************************************************************   07370000
       5205-JRNL-ACCTS.                                                 
                                                                        
           MOVE '5205' TO ACTIVE-PARAGRAPH.                             
                                                                        
           IF  SET-JUDGEMENT(WS-SUB)                                    
               PERFORM 5220-JRNL-NEW-ACCTS THRU 5220-EXIT               
           ELSE                                                         
               IF  REMOVE-JUDGEMENT(WS-SUB)                             
                   PERFORM 5210-JRNL-DEL-ACCTS THRU 5210-EXIT           
               END-IF                                                   
           END-IF.                                                      
                                                                        
       5205-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************   07520000
      *                                                             *   07530000
      *5210-JRNL-DEL-ACCTS.                                             07540000
      ***************************************************************   07550000
                                                                        
       5210-JRNL-DEL-ACCTS.                                             
           MOVE '5210' TO ACTIVE-PARAGRAPH.                             
                                                                        
           MOVE WS-ACCOUNT-NUMBER(WS-SUB) TO WS-ACCOUNT-NO.             
           MOVE WS-ACCOUNT-NUM            TO MH-ACCOUNT-NO.             
      *                                                                 07620000
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
           MOVE SPACES               TO MI-TABLE-ID.                    
           MOVE 1                    TO WS-TRAN-APPL-NO.                
           MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO.                
                                                                        
           IF  JU-FILED-CASE-NO > SPACES                                
               MOVE +15                  TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE JU-FILED-CASE-NO     TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT    
               MOVE 'FILED CASE NO'      TO MI-COLUMN-DESC              
               MOVE SPACES               TO MI-TABLE-ID                 
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1                     TO WS-TRAN-APPL-NO             
               MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
           END-IF.                                                      
      *                                                                 07880000
           IF  JU-JUDGEMENT-FILED-DT >  SPACES                          
               MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE JU-JUDGEMENT-FILED-DT TO WS-SYS-DATE                
               MOVE WS-SYS-CCYY          TO WS-TMP-CCYY                 
               MOVE WS-SYS-MONTH         TO WS-TMP-MONTH                
               MOVE WS-SYS-DAY           TO WS-TMP-DAY                  
               MOVE WS-TMP-DATE          TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT    
               MOVE 'JDGMNT FILE DTE'    TO MI-COLUMN-DESC              
               MOVE SPACES               TO MI-TABLE-ID                 
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1                     TO WS-TRAN-APPL-NO             
               MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
           END-IF.                                                      
                                                                        
           PERFORM 5100-MOVE-TRAN-HEAD THRU 5100-EXIT.                  
                                                                        
       5210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   08190000
      *5220-JRNL-NEW-ACCTS.                                         *   08200000
      ***************************************************************   08210000
                                                                        
       5220-JRNL-NEW-ACCTS.                                             
                                                                        
           MOVE '5220' TO ACTIVE-PARAGRAPH.                             
                                                                        
           MOVE WS-ACCOUNT-NUMBER(WS-SUB) TO WS-ACCOUNT-NO.             
           MOVE WS-ACCOUNT-NUM            TO MH-ACCOUNT-NO.             
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
           MOVE SPACES               TO MI-TABLE-ID.                    
           MOVE 1                    TO WS-TRAN-APPL-NO                 
                                                                        
           IF PARM-FILED-CASE-NO NOT = SPACES                           
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +15                   TO MI-PRV-COLUMN-VALUE-LEN     
                                            MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-FILED-CASE-NO    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'FILED CASE NO'       TO MI-COLUMN-DESC              
              MOVE SPACES                TO MI-TABLE-ID                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                      TO WS-TRAN-APPL-NO             
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
           END-IF.                                                      
                                                                        
           IF  PARM-DATE-FILED > SPACES                                 
               MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO            
               MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN    
                                             MI-CHG-COLUMN-VALUE-LEN    
               MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT   
               MOVE PARM-DATE-FILED       TO WS-SYS-DATE                
               MOVE WS-SYS-CCYY           TO WS-TMP-CCYY                
               MOVE WS-SYS-MONTH          TO WS-TMP-MONTH               
               MOVE WS-SYS-DAY            TO WS-TMP-DAY                 
               MOVE WS-TMP-DATE           TO MI-CHG-COLUMN-VALUE-TEXT   
               MOVE 'JDGMNT FILE DT'      TO MI-COLUMN-DESC             
               MOVE SPACES                TO MI-TABLE-ID                
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
           END-IF.                                                      
                                                                        
           MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN        
                                         MI-CHG-COLUMN-VALUE-LEN.       
           PERFORM 5100-MOVE-TRAN-HEAD THRU 5100-EXIT.                  
                                                                        
       5220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   09000000
      * 5230-JRNL-EXIST-ACCTS                                      *    09010000
      ***************************************************************   09020000
                                                                        
       5230-JRNL-EXIST-ACCTS.                                           
                                                                        
           MOVE '5230' TO ACTIVE-PARAGRAPH.                             
                                                                        
           MOVE AT-ACCOUNT-NO        TO MH-ACCOUNT-NO.                  
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
           MOVE SPACES               TO MI-TABLE-ID.                    
           MOVE 1                    TO WS-TRAN-APPL-NO.                
           MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO.                
                                                                        
                                                                        
           IF  JU-FILED-CASE-NO NOT = PARM-FILED-CASE-NO                
               MOVE +15                  TO MI-PRV-COLUMN-VALUE-LEN     
                                            MI-CHG-COLUMN-VALUE-LEN     
               IF  JU-FILED-CASE-NO      > SPACES                       
                   MOVE JU-FILED-CASE-NO TO                             
                                            MI-PRV-COLUMN-VALUE-TEXT    
               ELSE                                                     
                   MOVE '*NEW*'          TO                             
                                            MI-PRV-COLUMN-VALUE-TEXT    
               END-IF                                                   
               IF  PARM-FILED-CASE-NO > SPACES                          
                   MOVE PARM-FILED-CASE-NO                              
                                         TO  MI-CHG-COLUMN-VALUE-TEXT   
               ELSE                                                     
                   MOVE '*DELETED*'      TO                             
                                             MI-CHG-COLUMN-VALUE-TEXT   
               END-IF                                                   
               MOVE 'FILED CASE NO'      TO MI-COLUMN-DESC              
               MOVE SPACES               TO MI-TABLE-ID                 
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1                     TO WS-TRAN-APPL-NO             
               MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
           END-IF.                                                      
                                                                        
           IF  JU-JUDGEMENT-FILED-DT NOT = PARM-DATE-FILED              
               IF  WS-NULL-IND3 = -1 AND                                
                   PARM-DATE-FILED = SPACES                             
                   CONTINUE                                             
               ELSE                                                     
                   MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN 
                                              MI-CHG-COLUMN-VALUE-LEN   
                   IF  WS-NULL-IND3 > -1                                
                       MOVE JU-JUDGEMENT-FILED-DT TO WS-SYS-DATE        
                       MOVE WS-SYS-CCYY           TO WS-TMP-CCYY        
                       MOVE WS-SYS-MONTH          TO WS-TMP-MONTH       
                       MOVE WS-SYS-DAY            TO WS-TMP-DAY         
                       MOVE WS-TMP-DATE           TO                    
                                                MI-PRV-COLUMN-VALUE-TEXT
                   ELSE                                                 
                       MOVE '*NEW*'         TO MI-PRV-COLUMN-VALUE-TEXT 
                   END-IF                                               
                                                                        
                   IF  PARM-DATE-FILED > SPACES                         
                       MOVE PARM-DATE-FILED  TO WS-SYS-DATE             
                       MOVE WS-SYS-CCYY      TO WS-TMP-CCYY             
                       MOVE WS-SYS-MONTH     TO WS-TMP-MONTH            
                       MOVE WS-SYS-DAY       TO WS-TMP-DAY              
                       MOVE WS-TMP-DATE      TO MI-CHG-COLUMN-VALUE-TEXT
                   ELSE                                                 
                       MOVE '*DELETED*'      TO MI-CHG-COLUMN-VALUE-TEXT
                   END-IF                                               
                                                                        
                   MOVE 'JDGMNT FILE DT'     TO MI-COLUMN-DESC          
                   MOVE SPACES               TO MI-TABLE-ID             
                   PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT      
                   ADD 1                     TO WS-TRAN-APPL-NO         
                   MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO              
               END-IF                                                   
           END-IF.                                                      
                                                                        
                                                                        
           PERFORM 7210-FETCH-AT-CASE-CRSR THRU 7210-EXIT.              
           IF  WS-ACTIVE-RETURN-CODE NOT = NOT-FOUND                    
               PERFORM 5100-MOVE-TRAN-HEAD THRU 5100-EXIT               
           END-IF.                                                      
                                                                        
       5230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   09900000
      * 5300-PROCESS-JUDGEMENT                                      *   09910000
      * CALLS 5310-UPDATE-CASE-DETAIL                               *   09920000
      *       5320-UPDATE-ACCTS                                     *   09930000
      ***************************************************************   09940000
       5300-PROCESS-JUDGEMENT.                                          
                                                                        
           MOVE '5300' TO ACTIVE-PARAGRAPH.                             
                                                                        
           IF  PARM-DATE-FILED = SPACES                                 
               MOVE -1 TO WS-NULL-IND                                   
           ELSE                                                         
               MOVE ZERO TO WS-NULL-IND                                 
           END-IF.                                                      
                                                                        
           IF  NEW-CASE                                                 
               IF  PARM-FILED-CASE-NO = SPACES                          
                   MOVE NOT-FOUND             TO WS-ACTIVE-RETURN-CODE  
               ELSE                                                     
                   MOVE PARM-FILED-CASE-NO    TO JU-FILED-CASE-NO       
                   PERFORM 7350-SELECT-JU-ROW THRU 7350-EXIT            
               END-IF                                                   
               IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
                   MOVE JU-JUDGEMENT-CASE-NO  TO WS-MAX-CASE-NO         
                   MOVE WS-MAX-CASE-NO        TO JU-JUDGEMENT-CASE-NO   
                                                 AT-JUDGEMENT-CASE-NO   
               ELSE                                                     
                  PERFORM 7400-SELECT-JU-MAX THRU 7400-EXIT             
                  IF  WS-MAX-CASE-NO = SPACES                           
                      MOVE ZEROES             TO WS-MAX-CASE-NO-NUM     
                  END-IF                                                
                  ADD 1                       TO WS-MAX-CASE-NO-NUM     
                  MOVE WS-MAX-CASE-NO         TO JU-JUDGEMENT-CASE-NO   
                                                 AT-JUDGEMENT-CASE-NO   
                                                 PARM-JDGMNT-CASE-NO    
                 PERFORM 5305-NEW-CASE-DETAIL THRU 5305-EXIT            
              END-IF                                                    
           ELSE                                                         
              MOVE PARM-JDGMNT-CASE-NO TO JU-JUDGEMENT-CASE-NO          
                                          AT-JUDGEMENT-CASE-NO          
                                          WS-MAX-CASE-NO                
           END-IF.                                                      
                                                                        
           IF  CASE-NO-UPDATE                                           
               PERFORM 5310-UPDATE-CASE-DETAIL THRU 5310-EXIT           
           ELSE                                                         
               MOVE PARM-ACCT-NUM     TO WS-ACCOUNT-ARRAY               
               PERFORM 5320-UPDATE-ACCTS THRU 5320-EXIT                 
               VARYING WS-SUB FROM 1 BY 1                               
SCA006         UNTIL WS-SUB > 200 OR 
                     WS-ACCOUNT-DETAIL(WS-SUB) = SPACES OR 
                     WS-ACCOUNT-DETAIL(WS-SUB) = LOW-VALUES                     
               MOVE PARM-JDGMNT-CASE-NO TO AT-JUDGEMENT-CASE-NO         
               PERFORM 7200-OPEN-AT-CASE-CRSR  THRU 7200-EXIT           
               PERFORM 7210-FETCH-AT-CASE-CRSR THRU 7210-EXIT           
               IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
                   MOVE PARM-JDGMNT-CASE-NO TO JU-JUDGEMENT-CASE-NO     
                   PERFORM 8350-DELETE-JU THRU 8350-EXIT                
               END-IF                                                   
               PERFORM 7220-CLOSE-AT-CASE-CRSR THRU 7220-EXIT           
           END-IF.                                                      
                                                                        
           MOVE WS-MAX-CASE-NO        TO RS-JDGMNT-CASE-NO.             
           MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE.                
      *                                                                 10730001
       5300-EXIT.                                                       
            EXIT.                                                       
      *                                                                 10730001
      *****************************************************************         
      * INSERTS A NEW CASE DETAIL IN CSS_JUDGEMENT                    * 10730001
      *****************************************************************         
       5305-NEW-CASE-DETAIL.                                            
                                                                        
           MOVE '5305'         TO ACTIVE-PARAGRAPH.                     
                                                                        
           MOVE PARM-FILED-CASE-NO  TO JU-FILED-CASE-NO.                
           MOVE PARM-DATE-FILED     TO JU-JUDGEMENT-FILED-DT.           
           MOVE PARM-USER-ID        TO JU-USER-ID-INIT-BY.              
           PERFORM 8250-INSERT-JU   THRU 8250-EXIT.                     
      *                                                                 10730001
       5305-EXIT.                                                       
            EXIT.                                                       
      *                                                                 10730001
      ***************************************************************** 10731001
      * 5310-UPDATE-CASE-DETAIL.                                      * 10732001
      *                                                               * 10733001
      * UPDATES THE JUDGEMENT  CASE ON CSS_JUDGEMENT  WITH THE        * 10734001
      * CHANGED INFORMATION.                                          * 10735001
      *                                                               * 10736001
      ***************************************************************** 10737001
      *                                                                 10738001
       5310-UPDATE-CASE-DETAIL.                                         
      *                                                                 10750001
           MOVE '5310'                  TO ACTIVE-PARAGRAPH.            
      *                                                                 10770001
           IF  PARM-FILED-CASE-NO = SPACES                              
               MOVE NOT-FOUND           TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
               MOVE PARM-FILED-CASE-NO  TO JU-FILED-CASE-NO             
               PERFORM 7350-SELECT-JU-ROW  THRU 7350-EXIT               
           END-IF                                                       
      *                                                                 10831000
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
      *                                                                 10841001
               MOVE JU-JUDGEMENT-CASE-NO TO WS-JU-JDGMNT-CASE-NO        
               MOVE PARM-DATE-FILED      TO JU-JUDGEMENT-FILED-DT       
               PERFORM 8200-UPDATE-CASE               THRU 8200-EXIT    
      *                                                                 10891000
               MOVE PARM-JDGMNT-CASE-NO  TO AT-JUDGEMENT-CASE-NO        
               PERFORM 8225-UPDATE-AT                 THRU 8225-EXIT    
      *                                                                 10911000
      *        //DELETE OLD JUDGEMENT CASE NO                           10912000
               IF  PARM-JDGMNT-CASE-NO NOT = WS-JU-JDGMNT-CASE-NO       
                   MOVE PARM-JDGMNT-CASE-NO                             
                                         TO JU-JUDGEMENT-CASE-NO        
                   PERFORM 8350-DELETE-JU             THRU 8350-EXIT    
               END-IF                                                   
           ELSE                                                         
               MOVE PARM-JDGMNT-CASE-NO  TO JU-JUDGEMENT-CASE-NO        
               MOVE PARM-DATE-FILED      TO JU-JUDGEMENT-FILED-DT       
               MOVE PARM-FILED-CASE-NO   TO JU-FILED-CASE-NO            
               PERFORM 8200-UPDATE-CASE                THRU 8200-EXIT   
           END-IF.                                                      
      *                                                                 11021001
       5310-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11050000
       5320-UPDATE-ACCTS.                                               
                                                                        
           MOVE '5320'         TO ACTIVE-PARAGRAPH.                     
                                                                        
           MOVE PARM-FILED-CASE-NO  TO JU-FILED-CASE-NO.                
           MOVE PARM-DATE-FILED     TO JU-JUDGEMENT-FILED-DT.           
           MOVE PARM-USER-ID        TO JU-USER-ID-INIT-BY.              
                                                                        
           IF  SET-JUDGEMENT(WS-SUB)                                    
               PERFORM 5330-SET-UP-JUDGEMENT THRU 5330-EXIT             
           ELSE                                                         
              IF  REMOVE-JUDGEMENT(WS-SUB)                              
                  PERFORM 5340-REMOVE-JUDGEMENT THRU 5340-EXIT          
              END-IF                                                    
           END-IF.                                                      
      *                                                                 11320000
       5320-EXIT.                                                       
            EXIT.                                                       
      *                                                                 11350000
      ******************************************************************11360000
      *  5330-SET-JUDGEMENT.                                           *11370000
      *  SET JUDGEMENT ON AN ACCOUNT                                   *11380000
      ******************************************************************11390000
       5330-SET-UP-JUDGEMENT.                                           
                                                                        
           MOVE '5330'         TO ACTIVE-PARAGRAPH.                     
                                                                        
            MOVE SPACES TO AT-JUDGEMENT-CASE-NO.                        
            MOVE SPACES TO AT-JUDGEMENT-IND.                            
                                                                        
            MOVE WS-ACCOUNT-NUMBER(WS-SUB) TO WS-ACCOUNT-NO.            
            MOVE WS-ACCOUNT-NUM            TO AT-ACCOUNT-NO.            
            PERFORM 7100-SELECT-AT-ROW THRU 7100-EXIT.                  
P00936      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
P00936         MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT      
P00936         MOVE AT-COMPANY-NO         TO WS-COMPANY-NO              
P00936      END-IF.                                                     
            IF (AT-JUDGEMENT-IND = SPACES) OR                           
               (AT-JUDGEMENT-CASE-NO = SPACES) OR                       
               (AT-JUDGEMENT-CASE-NO = LOW-VALUES)                      
                MOVE WS-J            TO AT-JUDGEMENT-IND                
                MOVE WS-MAX-CASE-NO  TO AT-JUDGEMENT-CASE-NO            
                PERFORM 8220-UPDATE-AT THRU 8220-EXIT                   
            ELSE                                                        
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE WS-YES              TO RS-JUDGEMENT-IND             
                                           WS-UPDATE-FLAG(WS-SUB)       
                                                                        
            END-IF.                                                     
                                                                        
P00936      IF SET-JUDGEMENT(WS-SUB)                                    
P00936         PERFORM 5800-CANCEL-E-DRAFT   THRU 5800-EXIT             
P00936         PERFORM 5850-CANCEL-AUTO-CARD THRU 5850-EXIT             
P00936      END-IF.                                                     
                                                                        
       5330-EXIT.                                                       
            EXIT.                                                       
      *                                                                 11650000
      ******************************************************************11660000
      *  5340-REMOVE-JUDGEMENT.                                        *11670000
      *  REMOVE JUDGEMENT ON AN ACCOUNT                                *11680000
      ******************************************************************11690000
       5340-REMOVE-JUDGEMENT.                                           
                                                                        
           MOVE '5340'         TO ACTIVE-PARAGRAPH.                     
                                                                        
           MOVE WS-ACCOUNT-NUMBER(WS-SUB)  TO WS-ACCOUNT-NO.            
           MOVE WS-ACCOUNT-NUM             TO AT-ACCOUNT-NO.            
                                                                        
           PERFORM 7100-SELECT-AT-ROW THRU 7100-EXIT.                   
           IF  (AT-JUDGEMENT-IND = WS-J) AND                            
               (AT-JUDGEMENT-CASE-NO = PARM-JDGMNT-CASE-NO)             
               MOVE SPACES          TO AT-JUDGEMENT-CASE-NO             
                                       AT-JUDGEMENT-IND                 
               PERFORM 8220-UPDATE-AT THRU 8220-EXIT                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE WS-NO                 TO RS-JUDGEMENT-IND            
                                            WS-UPDATE-FLAG(WS-SUB)      
                                                                        
           END-IF.                                                      
                                                                        
       5340-EXIT.                                                       
            EXIT.                                                       
P00936******************************************************************        
P00936* 5800-CANCEL-E-DRAFT                                            *        
P00936******************************************************************        
P00936*                                                                         
P00936 5800-CANCEL-E-DRAFT.                                             
P00936*                                                                         
P00936     IF WS-CODE-BANK-EFT  = WS-ACTIVE                             
P00936                                                                  
P00936        PERFORM 6000-CALL-CSR04846            THRU 6000-EXIT      
P00936        PERFORM 6010-ALLOCATE-CURSOR-CSR04846 THRU 6010-EXIT      
P00936        PERFORM 6020-FETCH-CSR04846           THRU 6020-EXIT      
P00936        PERFORM 6030-CLOSE-CSR04846           THRU 6030-EXIT      
P00936                                                                  
P00936     END-IF.                                                      
P00936*                                                                         
P00936 5800-EXIT.                                                       
P00936     EXIT.                                                        
P00936******************************************************************        
P00936* 5850-CANCEL-AUTO-CARD                                          *        
P00936******************************************************************        
P00936*                                                                         
P00936 5850-CANCEL-AUTO-CARD.                                           
P00936*                                                                         
P00936     MOVE 'N'                     TO WS-AUTO-CARD-EXIST.          
P00936     PERFORM 5900-MOVE-AUTO-CARD-EXIST   THRU 5900-EXIT.          
P00936     PERFORM 7000-CHECK-AUTO-CARD-EXIST  THRU 7000-EXIT.          
P00936*                                                                         
P00936     IF WS-AUTO-CARD-EXIST EQUAL 'Y'                              
P00936*                                                                         
P00936        PERFORM 6040-CALL-CSR04304            THRU 6040-EXIT      
P00936        PERFORM 6050-ALLOCATE-CURSOR-CSR04304 THRU 6050-EXIT      
P00936        PERFORM 6060-FETCH-CSR04304           THRU 6060-EXIT      
P00936*                                                                         
P00936        PERFORM 6070-CLOSE-CSR04304              THRU 6070-EXIT   
P00936      END-IF.                                                     
P00936*                                                                         
P00936 5850-EXIT.                                                       
P00936     EXIT.                                                        
P00936*                                                                         
P00936******************************************************************        
P00936* 5900-MOVE-AUTO-CARD-EXIST                                      *        
P00936******************************************************************        
P00936*                                                                         
P00936 5900-MOVE-AUTO-CARD-EXIST.                                       
P00936*                                                                         
P00936     MOVE WS-ACCOUNT-NO            TO YP-ACCOUNT-NO.              
P00936     MOVE 'AUTO_CARD_PAY'          TO YP-ATTRIBUTE-DESC.          
P00936     MOVE 'AUTOC'                  TO YP-ATTRIBUTE-VALUE-CD.      
P00936     MOVE 'A'                      TO YP-STATUS-CD.               
P00936*                                                                         
P00936 5900-EXIT.                                                       
P00936     EXIT.                                                        
      *                                                                         
P00936******************************************************************        
P00936* 6000-CALL-CSR04846                                             *        
P00936******************************************************************        
P00936*                                                                         
P00936 6000-CALL-CSR04846.                                              
P00936*                                                                         
P00936*    EXEC SQL                                                     
P00936*     CALL CSR04846 ( 'CIS'                                       
P00936*                    ,'C'                                         
P00936*                    ,:WS-ACCOUNT-NO                              
P00936*                    ,'D'                                         
P00936*                    ,:WS-DRAFT-CYCLE                             
P00936*                    ,:WS-REQSTED-DRAFT-DAY                       
P00936*                    ,:WS-BANK-ACCOUNT-NAME                       
P00936*                    ,:WS-BANK-ACCT-NO                            
P00936*                    ,:WS-ACCT-TYPE-CD                            
P00936*                    ,:WS-BANK-ID                                 
P00936*                    ,:WS-USER-ID                                 
P00936*                    ,:WS-RESP-AREA-ID                            
P00936*                    ,'BANKRUPTCY SETUP'                          
P00936*                    ,'019'                                       
P00936*                    ,:WS-INIT-TYPE-CD                            
P00936*                    ,:WS-NICKNAME-TEXT                           
P00936*                    ,:WS-NICKNAME-LEN                            
P00936*                    ,:WS-CUST-BNK-SEQ-NO                         
P00936*                    )                                            
P00936*     END-EXEC.                                                   

MSQ001        EXEC SQL
MSQ001          CLOSE CANCEL_EDRAFT
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN CANCEL_EDRAFT
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR CANCEL_EDRAFT INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
P00936      MOVE SQLCODE                     TO                         
P00936                                        WS-ACTIVE-RETURN-CODE     
P00936                                        S-RETURN-CODE.            
P00936                                                                  
P00936      IF WS-ACTIVE-RETURN-CODE = +466                             
P00936         CONTINUE                                                 
P00936      ELSE                                                        
P00936         MOVE -1                         TO S-RETURN-CODE         
P00936                                            WS-ACTIVE-RETURN-CODE 
P00936         MOVE '6000'                     TO ACTIVE-PARAGRAPH      
P00936         MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
P00936         MOVE 'DB2SP CALL'               TO ABEND-FUNCTION        
P00936         MOVE SQLCODE                    TO ABEND-SQLCODE         
P00936         MOVE 'CSR04846'                 TO TABLE-1               
P00936         MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
P00936         MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
P00936         MOVE 'SQLCODE'                  TO TABLE-ELEMENT-2       
P00936         MOVE SQLCODE                    TO HOSTVAR-ELEMENT-2     
P00936         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
P00936         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
P00936      END-IF.                                                     
P00936*                                                                         
P00936  6000-EXIT.                                                      
P00936     EXIT.                                                        
P00936*                                                                         
P00936******************************************************************        
P00936* 6010-ALLOCATE-CURSOR-CSR04846                                  *        
P00936******************************************************************        
P00936*                                                                         
P00936 6010-ALLOCATE-CURSOR-CSR04846.                                   
P00936*                                                                         
P00936*    EXEC SQL                                                     
P00936*        ASSOCIATE LOCATORS                                       
P00936*        (:LOC1)                                                  
P00936*        WITH PROCEDURE CSR04846                                  
P00936*    END-EXEC.                                                    
P00936                                                                  
P00936*    EXEC SQL                                                     
P00936*        ALLOCATE CANCEL_EDRAFT CURSOR FOR RESULT SET             
P00936*        :LOC1                                                    
P00936*    END-EXEC.                                                    
P00936*                                                                         
P00936 6010-EXIT.                                                       
P00936     EXIT.                                                        
P00936*                                                                         
P00936******************************************************************        
P00936* 6020-FETCH-CSR04846.                                           *        
P00936******************************************************************        
P00936*                                                                         
P00936 6020-FETCH-CSR04846.                                             
P00936*                                                                         
P00936     EXEC SQL                                                     
P00936     FETCH CANCEL_EDRAFT INTO                                     
P00936              :WS-CSR04846-RETURN-CD                              
P00936             ,:WS-APPL-RETURN-CODE                                
P00936     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936                                                                  
P00936     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
P00936                                           S-RETURN-CODE.         
P00936                                                                  
P00936     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00936        CONTINUE                                                  
P00936     ELSE                                                         
P00936        MOVE -1                         TO S-RETURN-CODE          
P00936        MOVE '6020'                     TO ACTIVE-PARAGRAPH       
P00936        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00936        MOVE 'FETCH'                    TO ABEND-FUNCTION         
P00936        MOVE SQLCODE                    TO ABEND-SQLCODE          
P00936        MOVE 'CSR04846'                 TO TABLE-1                
P00936        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
P00936        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
P00936        MOVE 'SQLCODE '                 TO TABLE-ELEMENT-2        
P00936        MOVE SQLCODE                    TO HOSTVAR-ELEMENT-2      
P00936        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00936        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00936     END-IF.                                                      
P00936                                                                  
P00936     IF WS-CSR04846-RETURN-CD EQUAL SUCCESSFUL-CALL               
P00936        CONTINUE                                                  
P00936     ELSE                                                         
P00936        MOVE WS-CSR04846-RETURN-CD TO S-RETURN-CODE               
P00936        MOVE '6020'                TO ACTIVE-PARAGRAPH            
P00936        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00936        MOVE 'DB2SP CALL'          TO ABEND-FUNCTION              
P00936        MOVE SQLCODE               TO ABEND-SQLCODE               
P00936        MOVE 'CSR04846'            TO TABLE-1                     
P00936        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P00936        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P00936        MOVE 'SQLCODE'             TO TABLE-ELEMENT-2             
P00936        MOVE SQLCODE TO HOSTVAR-ELEMENT-2                         
P00936        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00936        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00936     END-IF.                                                      
P00936                                                                  
P00936 6020-EXIT.                                                       
P00936     EXIT.                                                        
P00936*                                                                         
P00936******************************************************************        
P00936* 6030-CLOSE-CSR04846.                                          *         
P00936******************************************************************        
P00936*                                                                         
P00936 6030-CLOSE-CSR04846.                                             
P00936                                                                  
P00936     EXEC SQL                                                     
P00936       CLOSE CANCEL_EDRAFT                                        
P00936     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936                                                                  
P00936     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
P00936                                          S-RETURN-CODE.          
P00936                                                                  
P00936     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00936        CONTINUE                                                  
P00936     ELSE                                                         
P00936        MOVE -1                        TO S-RETURN-CODE           
P00936        MOVE '6030'                    TO ACTIVE-PARAGRAPH        
P00936        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00936        MOVE 'CLOSE'                   TO ABEND-FUNCTION          
P00936        MOVE SQLCODE                   TO ABEND-SQLCODE           
P00936        MOVE 'CSR04846'                TO TABLE-1                 
P00936        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
P00936        MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
P00936        MOVE 'SQLCODE '                TO TABLE-ELEMENT-2         
P00936        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
P00936        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
P00936     END-IF.                                                      
P00936                                                                  
P00936 6030-EXIT.                                                       
P00936     EXIT.                                                        
P00936*                                                                         
P00936******************************************************************        
P00936* 6040-CALL-CSR04304                                             *        
P00936******************************************************************        
P00936*                                                                         
P00936 6040-CALL-CSR04304.                                              
P00936*                                                                         
P00936*    EXEC SQL                                                     
P00936*     CALL CSR04304 ( 'CAN'                                       
P00936*                    ,:WS-ACCOUNT-NO                              
P00936*                    ,:WS-COMPANY-NO                              
P00936*                    ,:WS-CURR-TIMESTMP                           
P00936*                    ,'$$$'                                       
A05460*                    ,:WS-USER-ID                                 
P00936*                    )                                            
P00936*    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE CANCEL_AUTO_CARD
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN CANCEL_AUTO_CARD
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR CANCEL_AUTO_CARD INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
P00936                                                                  
P00936     MOVE SQLCODE                     TO                          
P00936                                       WS-ACTIVE-RETURN-CODE      
P00936                                       S-RETURN-CODE.             
P00936                                                                  
P00936     IF WS-ACTIVE-RETURN-CODE = +466                              
P00936        CONTINUE                                                  
P00936     ELSE                                                         
P00936        MOVE -1                         TO S-RETURN-CODE          
P00936                                           WS-ACTIVE-RETURN-CODE  
P00936        MOVE '6040'                     TO ACTIVE-PARAGRAPH       
P00936        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00936        MOVE 'DB2SP CALL'               TO ABEND-FUNCTION         
P00936        MOVE SQLCODE                    TO ABEND-SQLCODE          
P00936        MOVE 'CSR04304'                 TO TABLE-1                
P00936        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
P00936        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
P00936        MOVE 'SQLCODE'                  TO TABLE-ELEMENT-2        
P00936        MOVE SQLCODE                    TO HOSTVAR-ELEMENT-2      
P00936        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00936        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00936     END-IF.                                                      
P00936*                                                                         
P00936  6040-EXIT.                                                      
P00936     EXIT.                                                        
P00936*                                                                         
P00936******************************************************************        
P00936* 6050-ALLOCATE-CURSOR-CSR04304                                  *        
P00936******************************************************************        
P00936*                                                                         
P00936 6050-ALLOCATE-CURSOR-CSR04304.                                   
P00936*                                                                         
P00936*    EXEC SQL                                                     
P00936*        ASSOCIATE LOCATORS                                       
P00936*        (:LOC2)                                                  
P00936*        WITH PROCEDURE CSR04304                                  
P00936*    END-EXEC.                                                    
P00936                                                                  
P00936*    EXEC SQL                                                     
P00936*        ALLOCATE CANCEL_AUTO_CARD CURSOR FOR RESULT SET          
P00936*        :LOC2                                                    
P00936*    END-EXEC.                                                    
P00936*                                                                         
P00936 6050-EXIT.                                                       
P00936     EXIT.                                                        
P00936*                                                                         
P00936******************************************************************        
P00936* 6060-FETCH-CSR04304                                            *        
P00936******************************************************************        
P00936*                                                                         
P00936 6060-FETCH-CSR04304.                                             
P00936*                                                                         
P00936     EXEC SQL                                                     
P00936     FETCH CANCEL_AUTO_CARD INTO                                  
P00936              :WS-CSR04304-RETURN-CD                              
P00936             ,:WS-CSR04304-ACCT-NO                                
P00936             ,:WS-CSR04304-CMPY-NO                                
P00936             ,:WS-CSR04304-TIMESTMP                               
P00936     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936                                                                  
P00936     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
P00936                                           S-RETURN-CODE.         
P00936                                                                  
P00936     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00936        CONTINUE                                                  
P00936     ELSE                                                         
P00936        MOVE -1                         TO S-RETURN-CODE          
P00936        MOVE '6060'                     TO ACTIVE-PARAGRAPH       
P00936        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00936        MOVE 'FETCH'                    TO ABEND-FUNCTION         
P00936        MOVE SQLCODE                    TO ABEND-SQLCODE          
P00936        MOVE 'CSR04304'                 TO TABLE-1                
P00936        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
P00936        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
P00936        MOVE 'SQLCODE '                 TO TABLE-ELEMENT-2        
P00936        MOVE SQLCODE                    TO HOSTVAR-ELEMENT-2      
P00936        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00936        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00936     END-IF.                                                      
P00936                                                                  
P00936     IF WS-CSR04304-RETURN-CD EQUAL SUCCESSFUL-CALL               
P00936        CONTINUE                                                  
P00936     ELSE                                                         
P00936        MOVE WS-CSR04304-RETURN-CD TO S-RETURN-CODE               
P00936        MOVE '6050'                TO ACTIVE-PARAGRAPH            
P00936        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00936        MOVE 'DB2SP CALL'          TO ABEND-FUNCTION              
P00936        MOVE SQLCODE               TO ABEND-SQLCODE               
P00936        MOVE 'CSR04304'            TO TABLE-1                     
P00936        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P00936        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P00936        MOVE 'SQLCODE'             TO TABLE-ELEMENT-2             
P00936        MOVE SQLCODE               TO HOSTVAR-ELEMENT-2           
P00936        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00936        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00936     END-IF.                                                      
P00936                                                                  
P00936 6060-EXIT.                                                       
P00936     EXIT.                                                        
P00936*                                                                         
P00936******************************************************************        
P00936* 6070-CLOSE-CSR04304.                                          *         
P00936******************************************************************        
P00936*                                                                         
P00936 6070-CLOSE-CSR04304.                                             
P00936                                                                  
P00936     EXEC SQL                                                     
P00936       CLOSE CANCEL_AUTO_CARD                                     
P00936     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936                                                                  
P00936     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
P00936                                          S-RETURN-CODE.          
P00936                                                                  
P00936     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00936        CONTINUE                                                  
P00936     ELSE                                                         
P00936        MOVE -1                        TO S-RETURN-CODE           
P00936        MOVE '6070'                    TO ACTIVE-PARAGRAPH        
P00936        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00936        MOVE 'CLOSE'                   TO ABEND-FUNCTION          
P00936        MOVE SQLCODE                   TO ABEND-SQLCODE           
P00936        MOVE 'CSR04304'                TO TABLE-1                 
P00936        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
P00936        MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
P00936        MOVE 'SQLCODE '                TO TABLE-ELEMENT-2         
P00936        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
P00936        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
P00936     END-IF.                                                      
P00936                                                                  
P00936 6070-EXIT.                                                       
P00936     EXIT.                                                        
P00936*                                                                         
      ****************************************************************  11920000
      * 6530- MAINTENANCE TRANSACTION JOURNALING INCLUDE             *  11930000
      ****************************************************************  11940000
           EXEC SQL                                                     11950000
               INCLUDE CPD00067                                         11960000
           END-EXEC.                                                    11970000
                                                                        
HPCCDM*EJECT                                                            11990000
      ******************************************************************        
      * 7000-CHECK-AUTO-CARD-EXIST                                     *        
      ******************************************************************        
      *                                                                         
       7000-CHECK-AUTO-CARD-EXIST.                                      
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) 'Y'                                                 
               INTO :WS-AUTO-CARD-EXIST                                 
               FROM CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                    
              WHERE ACCOUNT_NO         = :YP-ACCOUNT-NO                 
                AND ATTRIBUTE_DESC     = :YP-ATTRIBUTE-DESC             
                AND ATTRIBUTE_VALUE_CD = :YP-ATTRIBUTE-VALUE-CD         
                AND STATUS_CD          = :YP-STATUS-CD                  
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 'Y'                                                         
MFA-TR*        INTO :WS-AUTO-CARD-EXIST                                         
MFA-TR*        FROM CSS_ACCT_ATTRIBUTE                                          
MFA-TR*       WHERE ACCOUNT_NO         = :YP-ACCOUNT-NO                         
MFA-TR*         AND ATTRIBUTE_DESC     = :YP-ATTRIBUTE-DESC                     
MFA-TR*         AND ATTRIBUTE_VALUE_CD = :YP-ATTRIBUTE-VALUE-CD                 
MFA-TR*         AND STATUS_CD          = :YP-STATUS-CD                          
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              OR NOT-FOUND                                              
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT '             TO ABEND-FUNCTION              
              MOVE 'CSS_ACCT_ATTRIBUTE ' TO TABLE-1                     
              MOVE 'ACCOUNT_NO  '        TO TABLE-ELEMENT-1             
              MOVE YP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00936***************************************************************           
P00936* GET THE CURRENT TIMESTAMP                                   *           
P00936***************************************************************           
P00936 7010-GET-CURR-TIME.                                              
P00936*                                                                         
P00936     EXEC SQL                                                     
P00936          SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURR-TIMESTMP               
P00936     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURR-TIMESTMP = CURRENT TIMESTAMP                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936*                                                                         
P00936     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00936     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00936         NEXT SENTENCE                                            
P00936     ELSE                                                         
P00936         MOVE PROGRAM-NAME    TO ABEND-PROGRAM                    
P00936         MOVE '7010'          TO ACTIVE-PARAGRAPH                 
P00936         MOVE 'SET'           TO ABEND-FUNCTION                   
P00936         MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1                  
P00936         MOVE PARM-ACCOUNT-NO TO HOSTVAR-ELEMENT-1                
P00936         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
P00936         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
P00936     END-IF.                                                      
P00936*                                                                         
P00936 7010-EXIT.                                                       
P00936     EXIT.                                                        
P00936*                                                                         
      ******************************************************************12000000
      *   7100-SELECT-AT-ROW.                                          *12010000
      *                                                                *12020000
      *   THIS PARAGRAPH IS USED TO OBTAIN THE SELECTED ROW FROM THE   *12030000
      *   CSS_ACCOUNT TABLE                                            *12040000
      ******************************************************************12050000
       7100-SELECT-AT-ROW.                                              
                                                                        
           MOVE '7100'         TO ACTIVE-PARAGRAPH.                     
                                                                        
           EXEC SQL                                                     
               SELECT JUDGEMENT_CASE_NO,                                
                      JUDGEMENT_IND,                                    
P00936                CODES_DATA_PRESENT,                               
P00936                COMPANY_NO                                        
               INTO  :AT-JUDGEMENT-CASE-NO,                             
                     :AT-JUDGEMENT-IND,                                 
P00936               :AT-CODES-DATA-PRESENT,                            
P00936               :AT-COMPANY-NO                                     
               FROM  CSS_ACCOUNT                                        
              WHERE  ACCOUNT_NO     = :AT-ACCOUNT-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12180000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 12200000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               OR NOT-FOUND                                             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_ACCOUNT      '   TO TABLE-1                    
               MOVE 'ACCOUNT_NO  '        TO TABLE-ELEMENT-1            
               MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
      *                                                                 12200000
           END-IF.                                                      
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12200000
                                                                        
HPCCDM*EJECT                                                            12700000
                                                                        
      ******************************************************************12720000
      *  OPEN THE CURSOR DECLARED FOR CSS_ACCOUNT TABLE                *12730000
      ******************************************************************12740000
       7200-OPEN-AT-CASE-CRSR.                                          
                                                                        
           MOVE '7200'         TO ACTIVE-PARAGRAPH.                     
                                                                        
           EXEC SQL                                                     
               OPEN AT-CASE-NO-CRSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12820000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 12840000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
REARCH         MOVE 'CSR04909'                 TO ABEND-PROGRAM         
               MOVE '7200'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE 'CSS_ACCOUNT'              TO TABLE-1               
               MOVE 'JUDGEMENT_CASE_NO'        TO TABLE-ELEMENT-1       
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2       
               MOVE AT-JUDGEMENT-CASE-NO       TO HOSTVAR-ELEMENT-1     
               MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 12970000
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12970000
      ******************************************************************12980000
      *  FETCH THE CURSOR DECLARED FOR CSS_ACCOUNT TABLE TO FETCH ACCTS*12990000
      *  ON WHICH HAS THE SAME JUDGEMENT-CASE-NO.                      *        
      ******************************************************************13000000
       7210-FETCH-AT-CASE-CRSR.                                         
                                                                        
           MOVE '7210'   TO ACTIVE-PARAGRAPH.                           
                                                                        
           EXEC SQL                                                     
               FETCH AT-CASE-NO-CRSR                                    
               INTO :AT-ACCOUNT-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13090000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 13110000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR           
                                           NOT-FOUND                    
               NEXT SENTENCE                                            
           ELSE                                                         
REARCH         MOVE 'CSR04909'              TO ABEND-PROGRAM            
               MOVE '7210'                  TO ACTIVE-PARAGRAPH         
               MOVE 'FETCH'                 TO ABEND-FUNCTION           
               MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
               MOVE 'JUDGEMENT_CASE_NO'     TO TABLE-ELEMENT-1          
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-2          
               MOVE AT-JUDGEMENT-CASE-NO    TO HOSTVAR-ELEMENT-1        
               MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 13250000
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13250000
      ******************************************************************13260000
      *                                                                *13270000
      *  CLOSE THE CURSOR DECLARED FOR CSS_ACCOUNT TABLE.              *13280000
      ******************************************************************13290000
       7220-CLOSE-AT-CASE-CRSR.                                         
                                                                        
           MOVE '7220'  TO ACTIVE-PARAGRAPH.                            
                                                                        
           EXEC SQL                                                     
               CLOSE AT-CASE-NO-CRSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13370000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 13390000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
REARCH         MOVE 'CSR04909'              TO ABEND-PROGRAM            
               MOVE '7220'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CLOSE'                 TO ABEND-FUNCTION           
               MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
               MOVE 'JUDGEMENT_CASE_NO'     TO TABLE-ELEMENT-1          
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-2          
               MOVE AT-JUDGEMENT-CASE-NO    TO HOSTVAR-ELEMENT-1        
               MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 13530000
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13530000
HPCCDM*EJECT                                                            13540000
      ******************************************************************13550000
      *   7300-SELECT-JU-ROW.                                          *13560000
      *                                                                *13570000
      *   THIS PARAGRAPH IS USED TO OBTAIN THE SELECTED ROW FROM THE   *13580000
      *   CSS_JUDGEMENT  TABLE                                         *13590000
      ******************************************************************13600000
       7300-SELECT-JU-ROW.                                              
           MOVE '7300'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
               SELECT  FILED_CASE_NO,                                   
                      JUDGEMENT_FILED_DT                                
               INTO  :JU-FILED-CASE-NO,                                 
                     :JU-JUDGEMENT-FILED-DT :WS-NULL-IND3                
               FROM  CSS_JUDGEMENT                                      
              WHERE  JUDGEMENT_CASE_NO = :JU-JUDGEMENT-CASE-NO          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13760000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 13780000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_JUDGEMENT'       TO TABLE-1                     
              MOVE 'JUDGEMENT_CASE_NO'   TO TABLE-ELEMENT-1             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE JU-JUDGEMENT-CASE-NO  TO HOSTVAR-ELEMENT-1           
              MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 13780000
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13780000
      ******************************************************************13920000
      *   7350-SELECT-JU-ROW.                                          *13930000
      *                                                                *13940000
      *   THIS PARAGRAPH IS USED TO OBTAIN THE SELECTED ROW FROM THE   *13950000
      *   CSS_JUDGEMENT  TABLE                                         *13960000
      ******************************************************************13970000
      *                                                                 13971000
       7350-SELECT-JU-ROW.                                              
           MOVE '7350'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
              SELECT JUDGEMENT_CASE_NO                                  
               INTO  :JU-JUDGEMENT-CASE-NO                              
               FROM  CSS_JUDGEMENT                                      
              WHERE FILED_CASE_NO = :JU-FILED-CASE-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14070000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 14090000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
                                       OR NOT-FOUND                     
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_JUDGEMENT'       TO TABLE-1                    
               MOVE 'FILED_CASE_NO'       TO TABLE-ELEMENT-1            
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2            
               MOVE JU-FILED-CASE-NO      TO HOSTVAR-ELEMENT-1          
               MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 14250000
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14250000
HPCCDM*EJECT                                                            14240000
      *                                                                 14250000
      ******************************************************************14260000
      *   7400-SELECT-JU-MAX.                                          *14270000
      *                                                                *14280000
      *   THIS PARAGRAPH IS USED TO OBTAIN THE MAX OF JUDGEMENT-CASE-NO*14290000
      *   FROM CSS_JUDGEMENT TABLE                                     *14300000
      ******************************************************************14310000
       7400-SELECT-JU-MAX.                                              
           MOVE '7400'     TO ACTIVE-PARAGRAPH.                         
                                                                        
           EXEC SQL                                                     
               SELECT  MAX(JUDGEMENT_CASE_NO)                           
               INTO  :WS-MAX-CASE-NO :WS-MAX-CASE-IND                   
               FROM  CSS_JUDGEMENT                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14400000
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 14420000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
                                            OR NOT-FOUND                
               IF  WS-MAX-CASE-IND EQUAL -1                             
                   MOVE SPACES TO WS-MAX-CASE-NO                        
               END-IF                                                   
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_JUDGEMENT'       TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
       7400-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                            14570000
                                                                        
      ****************************************************************  14590000
      *                                                              *  14600000
      * 8200-UPDATE-CASE UPDATES CASE RELATED INFORMATION            *  14610000
      *                                                              *  14620000
      ****************************************************************  14630000
       8200-UPDATE-CASE.                                                
                                                                        
           MOVE '8200'     TO ACTIVE-PARAGRAPH.                         
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_JUDGEMENT                                       
             SET JUDGEMENT_FILED_DT =IIF(TRY_CONVERT(DATE, 
                                                :JU-JUDGEMENT-FILED-DT 
                                                           :WS-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :JU-JUDGEMENT-FILED-DT 
                                                           :WS-NULL-IND
              ) <> 0) OR (LEN(:JU-JUDGEMENT-FILED-DT :WS-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:JU-JUDGEMENT-FILED-DT 
                                                           :WS-NULL-IND
              ), CONVERT(DATE, :JU-JUDGEMENT-FILED-DT :WS-NULL-IND) ),
                 FILED_CASE_NO      =:JU-FILED-CASE-NO                  
             WHERE JUDGEMENT_CASE_NO  = :JU-JUDGEMENT-CASE-NO           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     14680000
MFA-TR*      UPDATE CSS_JUDGEMENT                                       14690000
MFA-TR*      SET JUDGEMENT_FILED_DT =:JU-JUDGEMENT-FILED-DT:WS-NULL-IND,14700000
MFA-TR*          FILED_CASE_NO      =:JU-FILED-CASE-NO                  14710000
MFA-TR*      WHERE JUDGEMENT_CASE_NO  = :JU-JUDGEMENT-CASE-NO           14740000
MFA-TR*    END-EXEC.                                                    14750000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE 'UPDATE'               TO ABEND-FUNCTION            
               MOVE 'CSS_JUDGEMENT'        TO TABLE-1                   
               MOVE 'JUDGEMENT_CASE_NO'    TO TABLE-ELEMENT-1           
               MOVE 'JUDGEMENT_FILED_DT'   TO TABLE-ELEMENT-2           
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-3           
               MOVE JU-JUDGEMENT-CASE-NO   TO HOSTVAR-ELEMENT-1         
               MOVE JU-JUDGEMENT-FILED-DT  TO HOSTVAR-ELEMENT-2         
               MOVE PARM-ACCOUNT-NO        TO HOSTVAR-ELEMENT-3         
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************  14930000
      * 8220-UPDATE-AT                                                  14940000
      ****************************************************************  14950000
       8220-UPDATE-AT.                                                  
                                                                        
           MOVE '8220'     TO ACTIVE-PARAGRAPH.                         
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
               SET JUDGEMENT_CASE_NO  = :AT-JUDGEMENT-CASE-NO,          
                   JUDGEMENT_IND      = :AT-JUDGEMENT-IND               
               WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME              TO   ABEND-PROGRAM        
               MOVE 'UPDATE'                  TO ABEND-FUNCTION         
               MOVE 'CSS_ACCOUNT'             TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE 'JUDGEMENT_CASE_NO'       TO TABLE-ELEMENT-2        
               MOVE 'JUDGEMENT_IND'           TO TABLE-ELEMENT-3        
               MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               MOVE AT-JUDGEMENT-CASE-NO      TO HOSTVAR-ELEMENT-2      
               MOVE AT-JUDGEMENT-IND          TO HOSTVAR-ELEMENT-3      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8220-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************  15240000
      * 8225-UPDATE-AT                                                  15250000
      ****************************************************************  15260000
       8225-UPDATE-AT.                                                  
                                                                        
           MOVE '8225'     TO ACTIVE-PARAGRAPH.                         
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
               SET JUDGEMENT_CASE_NO = :WS-JU-JDGMNT-CASE-NO            
               WHERE JUDGEMENT_CASE_NO  = :AT-JUDGEMENT-CASE-NO         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME              TO   ABEND-PROGRAM        
               MOVE 'UPDATE'                  TO ABEND-FUNCTION         
               MOVE 'CSS_ACCOUNT'             TO TABLE-1                
               MOVE 'JGMNT_CASE_NO OLD'       TO TABLE-ELEMENT-1        
               MOVE 'JGMNT_CASE_NO NEW'       TO TABLE-ELEMENT-2        
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-3        
               MOVE AT-JUDGEMENT-CASE-NO      TO HOSTVAR-ELEMENT-1      
               MOVE WS-JU-JDGMNT-CASE-NO      TO HOSTVAR-ELEMENT-2      
               MOVE PARM-ACCOUNT-NO           TO HOSTVAR-ELEMENT-3      
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8225-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************  15530000
      * 8250-INSERT-ROWS INSERTS ROW IN THE HISTORY TABLE            *  15540000
      ****************************************************************  15550000
       8250-INSERT-JU.                                                  
           MOVE '8250'     TO ACTIVE-PARAGRAPH.                         
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_JUDGEMENT                                
                 (JUDGEMENT_CASE_NO,                                    
                  FILED_CASE_NO,                                        
                  JUDGEMENT_FILED_DT,                                   
                  USER_ID_INIT_BY)                                      
              VALUES (:JU-JUDGEMENT-CASE-NO,                            
                      :JU-FILED-CASE-NO,                                
                      IIF(TRY_CONVERT(DATE, :JU-JUDGEMENT-FILED-DT 
                                            :WS-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :JU-JUDGEMENT-FILED-DT 
                                                           :WS-NULL-IND
              ) <> 0) OR (LEN(:JU-JUDGEMENT-FILED-DT :WS-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:JU-JUDGEMENT-FILED-DT 
                                                           :WS-NULL-IND
              ), CONVERT(DATE, :JU-JUDGEMENT-FILED-DT :WS-NULL-IND) ),         
                      :JU-USER-ID-INIT-BY)                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     15590000
MFA-TR*        INSERT INTO CSS_JUDGEMENT                                15600000
MFA-TR*          (JUDGEMENT_CASE_NO,                                    15610000
MFA-TR*           FILED_CASE_NO,                                        15620000
MFA-TR*           JUDGEMENT_FILED_DT,                                   15630000
MFA-TR*           USER_ID_INIT_BY)                                      15640000
MFA-TR*       VALUES (:JU-JUDGEMENT-CASE-NO,                            15670000
MFA-TR*               :JU-FILED-CASE-NO,                                15680000
MFA-TR*               :JU-JUDGEMENT-FILED-DT:WS-NULL-IND,               15690000
MFA-TR*               :JU-USER-ID-INIT-BY)                              15690000
MFA-TR*    END-EXEC.                                                    15730000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE 'INSERT'               TO ABEND-FUNCTION            
               MOVE 'CSS_JUDGEMENT'        TO TABLE-1                   
               MOVE 'JUDGEMENT_CASE_NO'    TO TABLE-ELEMENT-1           
               MOVE 'FILED_CASE_NO'        TO TABLE-ELEMENT-2           
               MOVE 'JUDGEMENT_FILED_DT'   TO TABLE-ELEMENT-3           
               MOVE 'USER_ID_INIT_BY'      TO TABLE-ELEMENT-4           
               MOVE JU-JUDGEMENT-CASE-NO   TO HOSTVAR-ELEMENT-1         
               MOVE JU-FILED-CASE-NO       TO HOSTVAR-ELEMENT-2         
               MOVE JU-JUDGEMENT-FILED-DT  TO HOSTVAR-ELEMENT-3         
               MOVE JU-USER-ID-INIT-BY     TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       8250-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
      ****************************************************************  15950000
      * 8350-DELETE-ROWS DELETES A ROW FROM THE JUDGEMENT TABLE.     *  15960000
      ****************************************************************  15970000
       8350-DELETE-JU.                                                  
                                                                        
           MOVE '8350'     TO ACTIVE-PARAGRAPH.                         
                                                                        
           EXEC SQL                                                     
               DELETE  FROM CSS_JUDGEMENT                               
               WHERE  JUDGEMENT_CASE_NO = :JU-JUDGEMENT-CASE-NO         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                             OR NOT-FOUND               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO   ABEND-PROGRAM         
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_JUDGEMENT'           TO TABLE-1                 
              MOVE 'JUDGEMENT_CASE_NO'       TO TABLE-ELEMENT-1         
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2         
              MOVE JU-JUDGEMENT-CASE-NO      TO HOSTVAR-ELEMENT-1       
              MOVE PARM-ACCOUNT-NO           TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
       8350-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
      ******************************************************************16250000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     16260000
      ******************************************************************16270000
REARCH*    EXEC SQL                                                     16280000
REARCH*        INCLUDE CPD00300                                         16290000
REARCH*    END-EXEC.                                                    16300000
REARCH*                                                                         
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CPDSP300                                                 
REARCH     END-EXEC.                                                            
                                                                        
      ******************************************************************16320000
      *       END PROGRAM COPYLIB                                      *16330000
      ******************************************************************16340000
REARCH*    COPY CPD00302.                                               16350000
REARCH*                                                                         
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CPD00321                                                 
REARCH     END-EXEC.                                                            
                                                                        
                                                                        
