       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04908.                                      
COB303 DATE-WRITTEN.     SEPTEMBER 29 1995.                             
       DATE-COMPILED.                                                   
      ******************************************************************        
      *****************SOUTH CAROLINA ELECTRIC & GAS********************        
      *                                                                *        
      *  PANEL   : BANKRUPTCY/JUDGEMENT                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM UPDATES CSS_ACCOUNT,CSS_BANKRUPTCY               *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00936*  04/30/16  VK7L032    CLONE OF CSR02193.                       *        
A05460*  10/07/16  VENKAT.P   ADDED USER ID TO CSR04304 CALL           *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04908'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04908 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBNKRPT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      *  KD - CSS_FIN_WO_ACTION                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBFWACTN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  KV - CSS_FW_ATTRIB_DESC                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBATTDES                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  IZ - CSS_FIN_WO_COLLECT                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBFWCLAG                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  J8 - CSS_HOLIDAY                                              *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBHLDAY                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  FW - CSS_FINAL_WO                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBFINLWO                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  LR - CSS_REG_PROFILE                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBREGPRF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  PF - CSS_USER_PROFILE                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  YP - CSS_ACCT_ATTRIBUTE                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACTATT                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *  KA - CSS_FW_FCST_OPTION                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPATHAS                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *  CZ - CSS_CREDIT_PROFILE                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCRPROF                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *  CO - CSS_CHRG_OFF                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCHGOFF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_DELINQUENCY      - C8                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
           EXEC SQL                                                             
             INCLUDE CWSX0010                                                   
           END-EXEC.                                                            
           COPY CWS00303.                                                       
           COPY CWS00056.                                                       
      ****** CWS00315 CONTAINS WS FOR FINDING NEXT BUSINESS DAY ****            
           EXEC SQL                                                             
               INCLUDE CWS00315                                                 
           END-EXEC.                                                            
                                                                        
      ****** CWS00908                                                           
           EXEC SQL                                                             
               INCLUDE CWS00908                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
       01  GTT-MISC-FIELDS.                                             
           05  GTT-NAME                PIC X(26) VALUE                  
                                             'SESSION.CSR04908_R1'.     
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN          PIC S9(04) COMP.                 
               49 GTT-ROW-CHAR         PIC X(1024).                     
           05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
      **************************************************************            
      *  INPUT - MODE, ACCOUNT NO , DATE-TRAN, TRAN-COMMENT,      *             
      *          RETURN-AMT,WAIVER-REASON-CODE, WAIVER-COMMENT     *            
      **************************************************************            
       01  PARM-FIELDS.                                                 
           05  PARM-TRANS-COMMENT.                                      
               10  PARM-TRANS-COMMENT-LEN     PIC  S9(4) COMP           
                                              SYNC VALUE +0.            
               10  PARM-TRANS-COMMENT-TEXT    PIC  X(210)               
                                              VALUE SPACES.             
                                                                        
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-SUB                  PIC 9(3) VALUE 1.                
           05  WS-BQ-BNKRPT-CASE-NO    PIC X(10) VALUE SPACES.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04908'.      
           05  WS-COMPANY-NO           PIC X(02)   VALUE SPACES.        
               88 SCEG                               VALUE '01'.        
               88 PSNC                               VALUE '26'.        
           05  WS-DATABASE               PIC 9(01)   VALUE 0.           
               88 CSR-DATABASE                       VALUE 1.           
               88 SEB-DATABASE                       VALUE 2.           
           05  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
                                                                        
           05  WS-NSC-REMOVE-FL        PIC X(01) VALUE 'Y'.             
           05  WS-EXISTS-FL            PIC X(01) VALUE 'N'.             
           05  WS-ROW-EXISTS-FL        PIC X(01) VALUE 'N'.             
           05  WS-NSF-STATUS-CD        PIC X(01) VALUE 'P'.             
                                                                        
           05  WS-MODE                 PIC X(01).                       
               88 NEW-CASE                        VALUE 'N'.            
               88 CASE-NO-UPDATE                  VALUE 'U'.            
               88 UPDATE-ACCTS                    VALUE 'A'.            
                                                                        
           05  WS-ACCOUNT-STRING       PIC X(252) VALUE SPACES.         
           05  WS-ACCOUNT-ARRAY REDEFINES WS-ACCOUNT-STRING.            
               10 WS-ACCOUNT-DETAIL OCCURS 200 TIMES.                   
                  15  WS-ACCOUNT-NUMBER   PIC 9(13).                    
                  15  WS-UPDATE-FLAG      PIC X(01).                    
                      88 SET-BANKRUPTCY     VALUE 'S'.                  
                      88 REMOVE-BANKRUPTCY  VALUE 'R'.                  
                                                                        
           05  WS-MAX-CASE-NO          PIC X(10) VALUE SPACES.          
           05  WS-MAX-CASE-NO-NUM REDEFINES WS-MAX-CASE-NO              
                                       PIC 9(10).                       
           05  WS-MAX-CASE-IND         PIC S9(04) COMP.                 
                                                                        
           05  WS-AT-ACCOUNT-NUM       PIC 9(13).                       
           05  WS-AT-ACCOUNT-CHAR REDEFINES WS-AT-ACCOUNT-NUM           
                                       PIC X(13).                       
           05  WS-HASH                 PIC X(01)  VALUE '#'.            
           05  WS-FILED-CASE-NO        PIC X(15)  VALUE SPACES.         
           05  WS-BNKRPT-CASE-NO       PIC X(10)  VALUE SPACES.         
           05  WS-PREV-FILED-CASE-NO   PIC X(15)  VALUE SPACES.         
           05  WS-CHAPTER              PIC X(02)  VALUE SPACES.         
           05  WS-BANKRUPTCY-CHAPTER   PIC X(02)  VALUE SPACES.         
           05  WS-DATE-FILED           PIC X(10)  VALUE SPACES.         
           05  WS-DATE-BNKRPT-FILED    PIC X(10)  VALUE SPACES.         
           05  WS-DATE-RECEIVED        PIC X(10)  VALUE SPACES.         
           05  WS-RECEIVED-DATE        PIC X(10)  VALUE SPACES.         
           05  WS-USER-ID              PIC X(07)  VALUE SPACES.         
           05  WS-RESP-AREA-ID         PIC X(03)  VALUE SPACES.         
           05  WS-PARM-MODE            PIC X(01)  VALUE SPACES.         
           05  WS-ACCOUNT-NO           PIC X(13).                       
           05  WS-ACCOUNT-NUM          REDEFINES WS-ACCOUNT-NO          
                                       PIC 9(13).                       
           05  WS-NULL-IND             PIC S9(4) COMP VALUE +0.         
           05  WS-NULL-IND2            PIC S9(4) COMP VALUE +0.         
           05  WS-NULL-IND3            PIC S9(4) COMP VALUE +0.         
           05  WS-NULL-IND4            PIC S9(4) COMP VALUE +0.         
           05  WS-WORK-DATE             PIC X(10) VALUE SPACES.         
           05  WS-NEXT-WORK-DATE        PIC X(10) VALUE SPACES.         
           05  WS-ACTION-DATE           PIC X(10) VALUE SPACES.         
           05  WS-SEQ-NO                PIC S9(9) COMP VALUE 0.         
           05  WS-PREV-WITHDRAW-DT      PIC X(10) VALUE SPACES.         
           05  WS-NEW-WITHDRAW-DT       PIC X(10) VALUE SPACES.         
           05  WS-PREV-WITHDRAW-AM      PIC 9(09).99  VALUE SPACES.     
           05  WS-NEW-WITHDRAW-AM       PIC 9(09).99  VALUE SPACES.     
           05  WS-WO-BAL                PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-UPDT-PLMT-TYPE        PIC X(05) VALUE SPACES.         
           05  WS-PARM-DATA             PIC X(80) VALUE SPACES.         
           05  WS-LAST-RUN-DATE-PARM.                                   
               10 FILLER               PIC X(14) VALUE 'LAST RUN DATE='.
               10 WS-LAST-RUN-DATE     PIC X(10) VALUE SPACES.          
               10 FILLER               PIC X(56) VALUE SPACES.          
           05  WS-ADJ-DAY               PIC S9(4) COMP VALUE +0.        
           05  WS-CA-ACTION-DATE        PIC X(10) VALUE SPACES.         
           05  WS-CB-ACTION-DATE        PIC X(10) VALUE SPACES.         
           05  WS-ACTN-TYPE-CD          PIC X(05) VALUE SPACES.         
           05  WS-CAEXEMPT              PIC X(08) VALUE 'CAEXEMPT'.     
           05  WS-CBEXEMPT              PIC X(08) VALUE 'CBEXEMPT'.     
           05  WS-NO-MORE-DATA          PIC X(01) VALUE 'N'.            
               88 NO-MORE-DATA          VALUE 'Y'.                      
           05  WS-FINAL-RUN-DATE        PIC X(80) VALUE SPACES.         
           05  WS-UPDATE-ID             PIC X(07) VALUE 'SYSTEM'.       
           05  WS-PANEL-NO              PIC X(09)  VALUE 'PANEL135 '.   
           05  WS-TRAN-TYPE-FLAG        PIC X(01) VALUE 'F'.            
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  WS-TRAN-FLAG             PIC X(01) VALUE 'N'.            
                                                                        
       01  CN-CONSTANTS.                                                
           05  CN-EQUAL               PIC X VALUE '='.                  
           05  CN-SPACES              PIC X VALUE SPACES.               
                                                                        
                                                                        
       01  WS-SYS-DATE.                                                 
           05  WS-SYS-CCYY             PIC X(04).                       
           05  FILLER                  PIC X(01)  VALUE '-'.            
           05  WS-SYS-MONTH            PIC X(02).                       
           05  FILLER                  PIC X(01)  VALUE '-'.            
           05  WS-SYS-DAY              PIC X(02).                       
                                                                        
       01  WS-TMP-DATE.                                                 
           05  WS-TMP-MONTH            PIC X(02).                       
           05  FILLER                  PIC X(01)  VALUE '/'.            
           05  WS-TMP-DAY              PIC X(02).                       
           05  FILLER                  PIC X(01)  VALUE '/'.            
           05  WS-TMP-CCYY             PIC X(04).                       
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-BNK                  PIC X(01) VALUE 'B'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-BANKRUPTCY-IND       PIC X(01)      VALUE SPACES.      
           05  S-ACCOUNT-INFO         PIC X(253)     VALUE SPACES.      
           05  S-BNKRPT-CASE-NO       PIC X(10)      VALUE SPACES.      
                                                                        
       01  WS-MNT-TRANS-DET.                                            
           05  WS-CODE-TRAN-TYPE         PIC X(01) VALUE 'B'.           
           05  WS-TRAN-APPL-NO           PIC S9(02) VALUE 0.            
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
           10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
                                                                        
      ******************************************************************        
      *                                                                *        
      *  CURSOR DECLARATION FOR THE CSS_ACCOUNT TABLE.                 *        
      *  FOR FETCHING ALL ACCOUNTS UNDER THE BANKRUPTCY CASE NUMBER    *        
      *                                                                *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE AT-CASE-NO-CRSR CURSOR FOR                       
               SELECT ACCOUNT_NO                                        
               FROM CSS_ACCOUNT                                         
               WHERE BNKRPT_CASE_NO = :AT-BNKRPT-CASE-NO                
               AND   BANKRUPTCY_IND  = 'B'                              
           END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE CANCEL_EDRAFT CURSOR
MSQ001          FOR CALL CSR04846 ( 'CIS'
                  , 'C'
                  , :WS-ACCOUNT-NO
                  , 'D'
                  , :WS-DRAFT-CYCLE
                  , :WS-REQSTED-DRAFT-DAY
                  , :WS-BANK-ACCOUNT-NAME
                  , :WS-BANK-ACCT-NO
                  , :WS-ACCT-TYPE-CD
                  , :WS-BANK-ID
                  , :WS-USER-ID
                  , :WS-RESP-AREA-ID
                  , 'BANKRUPTCY SETUP'
                  , '019'
                  , :WS-INIT-TYPE-CD
                  , :WS-NICKNAME-TEXT
                  , :WS-NICKNAME-LEN
                  , :WS-CUST-BNK-SEQ-NO
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE CANCEL_AUTO_CARD CURSOR
MSQ001          FOR CALL CSR04304 ( 'CAN'
                  , :WS-ACCOUNT-NO
                  , :WS-COMPANY-NO
                  , :WS-CURR-TIMESTMP
                  , '$$$'
                  , :WS-USER-ID
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE CANCEL_DNP CURSOR
MSQ001          FOR CALL CSR00125                                       
P00936                 ( :PARM-ACCOUNT-NO
                  , :WS-PREMISE-NO-C
                  , :WS-USER-ID
                  , :WS-REMARKS-TX
                  , 'Y'
                  , :WS-SO-SELECT-UPDATE
                  , '269'
                  , 'A'
                  , 'R'
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE C4 CURSOR
MSQ001          FOR CALL CSR00423                                            
P00936              ( :WS-SERV-ORDER-NO-D
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE C3 CURSOR
MSQ001          FOR CALL CSR04675                                            
P00936              ( :WS-WQ-ITEM-ID
                  , :WS-WQ-ROUTING-CATGRY
                  , :WS-WQ-LOCAL-OFFICE
                  , :WS-WQ-USER-ID-ORIG
                  , :WS-WQ-USER-ID-ASGN
                  , :WS-WQ-RESP-AREA-ID
                  , :WS-WQ-CATEGORY-ID
                  , :WS-WQ-ACCOUNT-NO
                  , :WS-WQ-PREMISE-NO
                  , :WS-WQ-CUSTOMER-NO
                  , :WS-WQ-SERV-ORDER-NO
                  , :WS-WQ-COMMENT
                  , :WS-WQ-DATE-REQUIRED
                  , :WS-WQ-DATE-CREATED
                  , :WS-WQ-PRIORITY
                  , :WS-WQ-FREE-FORM-AREA
                  , :WS-WQ-CREATED-BY
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE C2 CURSOR
MSQ001          FOR CALL CSR02122                                       
P00936                  ( :PARM-ACCOUNT-NO
                  , :WS-PREMISE-NO-C
                  , :WS-ORDER-REASON-BD
                  , 'R'
                  , :WS-PENDING-DNP-FLAG-BD
                  , :WS-UPDATE-PROFILE
                  , :WS-AMOUNT-DISC-BAL
                  , '269'
                  , :WS-ORDER-TYPE-CD-BD
                  , :WS-REMARKS-TX
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE PENDING_NOTICE CURSOR
MSQ001          FOR CALL CSR01556                                       
P00936                 ( :PARM-ACCOUNT-NO
                  , :WS-PREMISE-NO-C
                  , :WS-USER-ID
                  , :WS-REMARKS-TX
                  , 'Y'
                  , :WS-SO-SELECT-UPDATE
                  , '269'
                  , 'A'
                  , ' '
                  )
MSQ001        END-EXEC.
                                                    
      *                                                                         
HPCCDM*EJECT                                                                    
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01 PARM-FILED-CASE-NO      PIC X(15).                            
       01 PARM-BNKRPT-CASE-NO     PIC X(10).                            
       01 PARM-CHAPTER            PIC X(02).                            
       01 PARM-DATE-FILED         PIC X(10).                            
       01 PARM-DATE-RECEIVED      PIC X(10).                            
       01 PARM-USER-ID            PIC X(07).                            
       01 PARM-RESP-AREA-ID       PIC X(03).                            
       01 PARM-MODE               PIC X(01).                            
       01 PARM-ACCOUNT-NO         PIC X(13).                            
       01 PARM-TRANS-CMNT-TEXT    PIC X(210).                           
       01 PARM-TRANS-CMNT-LEN     PIC S9(4) COMP.                       
       01 PARM-ACCOUNT-INFO.                                            
          05  PARM-LENGTH         PIC S9(04) COMP VALUE +0.             
          05  PARM-ACCT-NUM       PIC X(2800).                          
      *                                                                         
       PROCEDURE DIVISION USING  PARM-FILED-CASE-NO                     
                                 PARM-BNKRPT-CASE-NO                    
                                 PARM-CHAPTER                           
                                 PARM-DATE-FILED                        
                                 PARM-DATE-RECEIVED                     
                                 PARM-USER-ID                           
                                 PARM-RESP-AREA-ID                      
                                 PARM-MODE                              
                                 PARM-ACCOUNT-NO                        
                                 PARM-TRANS-CMNT-TEXT                   
                                 PARM-TRANS-CMNT-LEN                    
                                 PARM-ACCOUNT-INFO.                     
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. DECLARE C1 CURSOR FOR RETURN VALUES.                    *        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
                DECLARE C1 CURSOR  FOR                       
                SELECT                                                  
                     :S-RETURN-CODE         AS RETURN_CODE              
                    ,:S-BANKRUPTCY-IND      AS BANKRUPTCY_IND           
                    ,:S-ACCOUNT-INFO        AS ACCOUNT_INFO             
                    ,:S-BNKRPT-CASE-NO      AS BNKRPT_CASE_NO           
                FROM                                                    
                     CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*              :S-RETURN-CODE         AS RETURN_CODE                      
MFA-TR*             ,:S-BANKRUPTCY-IND      AS BANKRUPTCY_IND                   
MFA-TR*             ,:S-ACCOUNT-INFO        AS ACCOUNT_INFO                     
MFA-TR*             ,:S-BNKRPT-CASE-NO      AS BNKRPT_CASE_NO                   
MFA-TR*         FROM                                                            
MFA-TR*              SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. PROCESS INPUTS.                                         *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO       TO WS-ACCOUNT-NO.                 
           MOVE PARM-USER-ID          TO WS-USER-ID.                    
           MOVE WS-ACCOUNT-NUM        TO AT-ACCOUNT-NO.                 
           MOVE PARM-MODE             TO WS-MODE.                       
           MOVE PARM-TRANS-CMNT-LEN   TO PARM-TRANS-COMMENT-LEN.        
           MOVE PARM-TRANS-CMNT-TEXT  TO PARM-TRANS-COMMENT-TEXT.       
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *    CALLS 5000-UPDATE                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000'             TO ACTIVE-PARAGRAPH.                 
           PERFORM 5000-UPDATE          THRU 5000-EXIT.                 
           ADD +1                       TO CTR-ROWS.                    
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      *                                                             *           
      * MAIN UPDATE PARAGRAPH.                                      *           
      *                                                             *           
      ***************************************************************           
       5000-UPDATE.                                                     
                                                                        
           MOVE '5000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 7010-GET-CURRENT-DATE                                
              THRU 7010-EXIT                                            
           MOVE WS-CURRENT-DATE                TO WS-NEW-BUSINESS-DAY   
           MOVE '01'                           TO WS-COMPANY-NO         
           PERFORM 6500-GET-NEXT-BUSINESS-DAY                           
              THRU 6500-NEXT-BUSINESS-DAY-EXIT                          
             UNTIL NEXT-BUSINESS-DAY-FOUND                              
           MOVE WS-NEW-BUSINESS-DAY      TO WS-NEXT-WORK-DATE           
                                                                        
           IF WS-MODE = 'A' OR WS-MODE = 'N'                            
              PERFORM 5300-PROCESS-BANKRUPTCY THRU 5300-EXIT            
              PERFORM 5100-MOVE-TRAN-HEAD THRU 5100-EXIT                
              PERFORM 5200-MOVE-TRAN-DET  THRU 5200-EXIT                
           ELSE                                                         
              IF WS-MODE = 'U'                                          
                 PERFORM 5100-MOVE-TRAN-HEAD THRU 5100-EXIT             
                 PERFORM 5200-MOVE-TRAN-DET  THRU 5200-EXIT             
                 PERFORM 5300-PROCESS-BANKRUPTCY THRU 5300-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5030-GET-LAST-RUN-DT.                                          *        
      ******************************************************************        
       5030-GET-LAST-RUN-DT.                                            
      *                                                                         
           IF LR-REG-GROUP-CD = '100' THEN                              
               MOVE +100                    TO WS-SEQ-NO                
           ELSE                                                         
              IF LR-REG-GROUP-CD = '200' THEN                           
                 MOVE +200                  TO WS-SEQ-NO                
              ELSE                                                      
                 MOVE +10                   TO WS-SEQ-NO                
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7040-SELECT-LAST-RUN-DT  THRU 7040-EXIT.             
                                                                        
           MOVE WS-PARM-DATA                TO WS-LAST-RUN-DATE-PARM.   
                                                                        
           MOVE WS-LAST-RUN-DATE            TO WS-FINAL-RUN-DATE.       
                                                                        
       5030-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ***************************************************************           
      * MOVE FIELDS TO THE MAINTENANCE TRANSACTION HEADER AND       *           
      * CALL COMMON PARAGRAPH FOR WRITING A ROW.                    *           
      ***************************************************************           
       5100-MOVE-TRAN-HEAD.                                             
                                                                        
           PERFORM 5150-GET-CURR-TIME THRU 5150-EXIT.                   
                                                                        
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-DATE-TRANS                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :MH-DATE-TRANS =  CURRENT DATE                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME    TO ABEND-PROGRAM                    
               MOVE '5100'          TO ACTIVE-PARAGRAPH                 
               MOVE 'SET'           TO ABEND-FUNCTION                   
               MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1                  
               MOVE PARM-ACCOUNT-NO TO HOSTVAR-ELEMENT-1                
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           MOVE 'F'                TO MH-CODE-TRAN-TYPE.                
           MOVE PARM-RESP-AREA-ID  TO MH-RESP-AREA-ID.                  
           MOVE 0                  TO MH-PREMISE-NO.                    
           MOVE 0                  TO MH-CUSTOMER-NO.                   
           MOVE AT-ACCOUNT-NO      TO MH-ACCOUNT-NO.                    
           MOVE PARM-USER-ID       TO MH-USER-ID.                       
           MOVE 'PANEL135'         TO MH-APPL-PROGRAM-ID.               
           MOVE PARM-TRANS-COMMENT TO MH-TRAN-COMMENT.                  
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * GET THE CURRENT TIMESTAMP FOR TRANS HIST SEQUENCE NUMBER.   *           
      ***************************************************************           
       5150-GET-CURR-TIME.                                              
      *                                                                         
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :MH-TRANS-HIST-SEQ-NO           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :MH-TRANS-HIST-SEQ-NO =  CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME    TO ABEND-PROGRAM                    
               MOVE '5150'          TO ACTIVE-PARAGRAPH                 
               MOVE 'SET'           TO ABEND-FUNCTION                   
               MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1                  
               MOVE PARM-ACCOUNT-NO TO HOSTVAR-ELEMENT-1                
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       5150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      * CHECK WHETHER ANY OF THE COLUMN VALUES HAVE CHANGED.IF    *             
      * SO THEN WRITE A RECORD IN THE TRANSACTION DETAIL.         *             
      * COLUMN VALUES ARE :                                       *             
      * FOR INSERT : COMMENT,DATE-TRAN, CHECK-AMT, SEND-NOTICE-CD *             
      * FOR UPDATE : CHECK-AMT, SEND-NOTICE-CD,                   *             
      * FOR DELETE : COMMENT,DATE-TRAN, CHECK-AMT, SEND-NOTICE-CD *             
      *************************************************************             
       5200-MOVE-TRAN-DET.                                              
                                                                        
           MOVE '5200' TO ACTIVE-PARAGRAPH.                             
                                                                        
           IF CASE-NO-UPDATE                                            
              MOVE PARM-BNKRPT-CASE-NO TO BQ-BNKRPT-CASE-NO             
                                          AT-BNKRPT-CASE-NO             
              PERFORM 7300-SELECT-BQ-ROW    THRU 7300-EXIT              
              PERFORM 7200-OPEN-AT-CASE-CRSR THRU 7200-EXIT             
              PERFORM 7210-FETCH-AT-CASE-CRSR THRU 7210-EXIT            
              PERFORM 5230-JRNL-EXIST-ACCTS THRU  5230-EXIT             
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
              PERFORM 7220-CLOSE-AT-CASE-CRSR THRU 7220-EXIT            
           ELSE                                                         
           IF NEW-CASE                                                  
              PERFORM 5205-JRNL-ACCTS THRU 5205-EXIT                    
              VARYING WS-SUB FROM 1 BY 1                                
SCA006        UNTIL   WS-SUB > 200 OR 
                      WS-ACCOUNT-DETAIL(WS-SUB) = SPACES OR 
                      WS-ACCOUNT-DETAIL(WS-SUB) = LOW-VALUES                    
           ELSE                                                         
           IF UPDATE-ACCTS                                              
              PERFORM 5205-JRNL-ACCTS THRU 5205-EXIT                    
              VARYING WS-SUB FROM 1 BY 1                                
SCA006        UNTIL   WS-SUB > 200 OR 
                      WS-ACCOUNT-DETAIL(WS-SUB) = SPACES OR 
                      WS-ACCOUNT-DETAIL(WS-SUB) = LOW-VALUES                    
                                                                        
           END-IF
           END-IF
           END-IF.                                                      
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      *                                                             *           
      *5205-JRNL-ACCTS.                                                         
      ***************************************************************           
       5205-JRNL-ACCTS.                                                 
                                                                        
           MOVE '5205' TO ACTIVE-PARAGRAPH.                             
                                                                        
           PERFORM 5150-GET-CURR-TIME       THRU 5150-EXIT.             
                                                                        
           IF SET-BANKRUPTCY(WS-SUB)                                    
              PERFORM 5220-JRNL-NEW-ACCTS   THRU 5220-EXIT              
           ELSE                                                         
              IF REMOVE-BANKRUPTCY(WS-SUB)                              
                 PERFORM 5210-JRNL-DEL-ACCTS THRU 5210-EXIT             
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5205-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************           
      *                                                             *           
      *5210-JRNL-DEL-ACCTS.                                                     
      ***************************************************************           
       5210-JRNL-DEL-ACCTS.                                             
           MOVE '5210' TO ACTIVE-PARAGRAPH.                             
                                                                        
           MOVE WS-ACCOUNT-NUMBER(WS-SUB) TO WS-ACCOUNT-NO.             
           MOVE WS-ACCOUNT-NUM            TO MH-ACCOUNT-NO.             
      *                                                                         
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
           MOVE SPACES               TO MI-TABLE-ID.                    
           MOVE 1                    TO WS-TRAN-APPL-NO.                
           MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO.                
                                                                        
           IF BQ-BANKRUPTCY-CHAPTER > SPACES                            
              MOVE +12                   TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE BQ-BANKRUPTCY-CHAPTER TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE 'BNKRPT CHPTR'        TO MI-COLUMN-DESC              
              MOVE SPACES                TO MI-TABLE-ID                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                      TO WS-TRAN-APPL-NO             
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
           END-IF.                                                      
                                                                        
           IF BQ-FILED-CASE-NO > SPACES                                 
              MOVE +15                  TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE BQ-FILED-CASE-NO     TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT     
              MOVE 'FILED CASE NO'      TO MI-COLUMN-DESC               
              MOVE SPACES               TO MI-TABLE-ID                  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                     TO WS-TRAN-APPL-NO              
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
           END-IF.                                                      
      *                                                                         
           IF BQ-DATE-BNKRPT-FILED > SPACES                             
              MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE BQ-DATE-BNKRPT-FILED TO WS-SYS-DATE                  
              MOVE WS-SYS-CCYY          TO WS-TMP-CCYY                  
              MOVE WS-SYS-MONTH         TO WS-TMP-MONTH                 
              MOVE WS-SYS-DAY           TO WS-TMP-DAY                   
              MOVE WS-TMP-DATE          TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT     
              MOVE 'BNKRPT FILE DTE'    TO MI-COLUMN-DESC               
              MOVE SPACES               TO MI-TABLE-ID                  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                     TO WS-TRAN-APPL-NO              
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
           END-IF.                                                      
                                                                        
           MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN.        
           MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN.        
           MOVE BQ-RECEIVED-DATE     TO WS-SYS-DATE.                    
           MOVE WS-SYS-CCYY          TO WS-TMP-CCYY.                    
           MOVE WS-SYS-MONTH         TO WS-TMP-MONTH.                   
           MOVE WS-SYS-DAY           TO WS-TMP-DAY.                     
           MOVE WS-TMP-DATE          TO MI-PRV-COLUMN-VALUE-TEXT.       
           MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT.       
           MOVE 'RECEIVED DATE'      TO MI-COLUMN-DESC.                 
           MOVE SPACES               TO MI-TABLE-ID.                    
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
                                                                        
       5210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      *5220-JRNL-NEW-ACCTS.                                                     
      ***************************************************************           
       5220-JRNL-NEW-ACCTS.                                             
                                                                        
           MOVE '5220' TO ACTIVE-PARAGRAPH.                             
                                                                        
           MOVE WS-ACCOUNT-NUMBER(WS-SUB) TO WS-ACCOUNT-NO.             
                                                                        
           MOVE WS-ACCOUNT-NUM            TO MH-ACCOUNT-NO.             
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
           MOVE SPACES               TO MI-TABLE-ID.                    
                                                                        
                                                                        
                                                                        
                                                                        
           IF PARM-CHAPTER NOT = SPACES                                 
              MOVE 1                  TO WS-TRAN-APPL-NO                
              MOVE WS-TRAN-APPL-NO    TO MI-TRAN-APPL-NO                
              MOVE +10                TO MI-PRV-COLUMN-VALUE-LEN        
                                         MI-CHG-COLUMN-VALUE-LEN        
              MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT       
              MOVE PARM-CHAPTER       TO MI-CHG-COLUMN-VALUE-TEXT       
              MOVE 'BNKRPT CHPTR'     TO MI-COLUMN-DESC                 
              MOVE SPACES             TO MI-TABLE-ID                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-FILED-CASE-NO NOT = SPACES                           
              IF PARM-CHAPTER NOT = SPACES                              
                 ADD 1                   TO WS-TRAN-APPL-NO             
              ELSE                                                      
                 MOVE 1                  TO WS-TRAN-APPL-NO             
              END-IF                                                    
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +15                   TO MI-PRV-COLUMN-VALUE-LEN     
                                            MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-FILED-CASE-NO    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'FILED CASE NO'       TO MI-COLUMN-DESC              
              MOVE SPACES                TO MI-TABLE-ID                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-CHAPTER NOT = SPACES  OR                             
              PARM-FILED-CASE-NO NOT = SPACES                           
                 ADD 1                   TO WS-TRAN-APPL-NO             
                 MOVE WS-TRAN-APPL-NO    TO MI-TRAN-APPL-NO             
           END-IF.                                                      
           IF PARM-CHAPTER = SPACES AND                                 
              PARM-FILED-CASE-NO = SPACES                               
                 MOVE 1                  TO WS-TRAN-APPL-NO             
                 MOVE WS-TRAN-APPL-NO    TO MI-TRAN-APPL-NO             
           END-IF.                                                      
                                                                        
           IF PARM-DATE-FILED > SPACES                                  
              MOVE +15                   TO MI-PRV-COLUMN-VALUE-LEN     
                                            MI-CHG-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE PARM-DATE-FILED       TO WS-SYS-DATE                 
              MOVE WS-SYS-CCYY           TO WS-TMP-CCYY                 
              MOVE WS-SYS-MONTH          TO WS-TMP-MONTH                
              MOVE WS-SYS-DAY            TO WS-TMP-DAY                  
              MOVE WS-TMP-DATE           TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE 'BNKRPT FILE DTE'     TO MI-COLUMN-DESC              
              MOVE SPACES                TO MI-TABLE-ID                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                      TO WS-TRAN-APPL-NO             
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
           END-IF.                                                      
                                                                        
           MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN        
                                         MI-CHG-COLUMN-VALUE-LEN.       
           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE PARM-DATE-RECEIVED    TO WS-SYS-DATE.                   
           MOVE WS-SYS-CCYY           TO WS-TMP-CCYY.                   
           MOVE WS-SYS-MONTH          TO WS-TMP-MONTH.                  
           MOVE WS-SYS-DAY            TO WS-TMP-DAY.                    
           MOVE WS-TMP-DATE           TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE 'RECEIVED DATE'       TO MI-COLUMN-DESC.                
           MOVE SPACES                TO MI-TABLE-ID.                   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           PERFORM 5100-MOVE-TRAN-HEAD THRU 5100-EXIT.                  
           IF WS-UPDT-PLMT-TYPE > SPACES                                
              MOVE +10                TO MI-PRV-COLUMN-VALUE-LEN        
                                            MI-CHG-COLUMN-VALUE-LEN     
              MOVE 'AT'                  TO KV-FW-ATTRIB-TYPE-CD        
              MOVE WS-UPDT-PLMT-TYPE     TO KV-FW-ATTR-VALUE-CD         
                                                                        
              PERFORM 7250-SELECT-ACTION-DESC                           
                                         THRU 7250-EXIT                 
              MOVE 'ACTION TYPE'         TO MI-COLUMN-DESC              
              MOVE KV-FW-ATTR-VALUE-DESC TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE LENGTH OF KV-FW-ATTR-VALUE-DESC                      
                                            TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '*UPDATED*'           TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN     
                                                                        
              ADD 1                      TO WS-TRAN-APPL-NO             
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              PERFORM 6530-LOAD-MNT-TRANS-HIST                          
                                            THRU 6530-EXIT              
              ADD 1                      TO WS-TRAN-APPL-NO             
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF WS-PREV-WITHDRAW-DT > '1900-01-01'                     
                 MOVE WS-PREV-WITHDRAW-DT TO WS-SYS-DATE                
                 MOVE WS-SYS-CCYY     TO WS-TMP-CCYY                    
                 MOVE WS-SYS-MONTH    TO WS-TMP-MONTH                   
                 MOVE WS-SYS-DAY      TO WS-TMP-DAY                     
                 MOVE WS-TMP-DATE     TO MI-PRV-COLUMN-VALUE-TEXT       
                 MOVE +10             TO MI-PRV-COLUMN-VALUE-LEN        
              ELSE                                                      
                  MOVE '*NEW*'        TO MI-PRV-COLUMN-VALUE-TEXT       
                  MOVE +5             TO MI-PRV-COLUMN-VALUE-LEN        
              END-IF                                                    
              MOVE WS-NEW-WITHDRAW-DT TO WS-SYS-DATE                    
              MOVE WS-SYS-CCYY        TO WS-TMP-CCYY                    
              MOVE WS-SYS-MONTH       TO WS-TMP-MONTH                   
              MOVE WS-SYS-DAY         TO WS-TMP-DAY                     
              MOVE WS-TMP-DATE        TO MI-CHG-COLUMN-VALUE-TEXT       
              MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE 'WITHDRAW DATE'    TO MI-COLUMN-DESC                 
              MOVE SPACES             TO MI-TABLE-ID                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                      TO WS-TRAN-APPL-NO             
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE WS-PREV-WITHDRAW-AM TO MI-PRV-COLUMN-VALUE-TEXT      
              MOVE +4                  TO MI-PRV-COLUMN-VALUE-LEN       
              MOVE WS-NEW-WITHDRAW-AM  TO MI-CHG-COLUMN-VALUE-TEXT      
              MOVE +12                 TO MI-CHG-COLUMN-VALUE-LEN       
              MOVE 'WITHDRAW AMT'     TO MI-COLUMN-DESC                 
              MOVE SPACES             TO MI-TABLE-ID                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              MOVE SPACES             TO WS-UPDT-PLMT-TYPE              
                                         WS-PREV-WITHDRAW-DT            
                                         WS-NEW-WITHDRAW-DT             
              MOVE ZEROES             TO WS-PREV-WITHDRAW-AM            
                                         WS-NEW-WITHDRAW-AM             
           END-IF.                                                      
       5220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 5230-JRNL-EXIST-ACCTS                                      *            
      ***************************************************************           
       5230-JRNL-EXIST-ACCTS.                                           
                                                                        
           MOVE '5230' TO ACTIVE-PARAGRAPH.                             
                                                                        
           MOVE AT-ACCOUNT-NO        TO MH-ACCOUNT-NO.                  
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
           MOVE SPACES               TO MI-TABLE-ID.                    
           MOVE 1                    TO WS-TRAN-APPL-NO.                
           MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO.                
                                                                        
           IF BQ-BANKRUPTCY-CHAPTER  NOT = PARM-CHAPTER                 
      *       BQ-BANKRUPTCY-CHAPTER  NOT = SPACES                               
              MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN     
                                            MI-CHG-COLUMN-VALUE-LEN     
              IF BQ-BANKRUPTCY-CHAPTER > SPACES                         
                 MOVE BQ-BANKRUPTCY-CHAPTER TO                          
                                            MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE '*NEW*'               TO                          
                                            MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
                                                                        
              MOVE PARM-CHAPTER          TO                             
                                            MI-CHG-COLUMN-VALUE-TEXT    
              MOVE 'BNKRPT CHPTR'        TO MI-COLUMN-DESC              
              MOVE SPACES                TO MI-TABLE-ID                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                    TO WS-TRAN-APPL-NO               
              MOVE WS-TRAN-APPL-NO     TO MI-TRAN-APPL-NO               
           END-IF.                                                      
                                                                        
           IF BQ-FILED-CASE-NO NOT = PARM-FILED-CASE-NO                 
              MOVE +15                  TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
              IF BQ-FILED-CASE-NO      > SPACES                         
                 MOVE BQ-FILED-CASE-NO      TO                          
                                            MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE '*NEW*'               TO                          
                                            MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF PARM-FILED-CASE-NO > SPACES                            
                 MOVE PARM-FILED-CASE-NO    TO                          
                                            MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE '*DELETED*'           TO                          
                                            MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'FILED CASE NO'      TO MI-COLUMN-DESC               
              MOVE SPACES               TO MI-TABLE-ID                  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                     TO WS-TRAN-APPL-NO              
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
           END-IF.                                                      
                                                                        
           IF BQ-DATE-BNKRPT-FILED NOT = PARM-DATE-FILED                
              IF WS-NULL-IND3 = -1 AND                                  
                 PARM-DATE-FILED = SPACES                               
                 CONTINUE                                               
              ELSE                                                      
                 MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
                 IF WS-NULL-IND3 > -1                                   
                    MOVE BQ-DATE-BNKRPT-FILED  TO WS-SYS-DATE           
                    MOVE WS-SYS-CCYY     TO WS-TMP-CCYY                 
                    MOVE WS-SYS-MONTH    TO WS-TMP-MONTH                
                    MOVE WS-SYS-DAY      TO WS-TMP-DAY                  
                    MOVE WS-TMP-DATE     TO MI-PRV-COLUMN-VALUE-TEXT    
                 ELSE                                                   
                    MOVE '*NEW*'         TO MI-PRV-COLUMN-VALUE-TEXT    
                 END-IF                                                 
                                                                        
                 IF PARM-DATE-FILED > SPACES                            
                    MOVE PARM-DATE-FILED  TO WS-SYS-DATE                
                    MOVE WS-SYS-CCYY      TO WS-TMP-CCYY                
                    MOVE WS-SYS-MONTH     TO WS-TMP-MONTH               
                    MOVE WS-SYS-DAY       TO WS-TMP-DAY                 
                    MOVE WS-TMP-DATE      TO MI-CHG-COLUMN-VALUE-TEXT   
                 ELSE                                                   
                    MOVE '*DELETED*'      TO MI-CHG-COLUMN-VALUE-TEXT   
                 END-IF                                                 
                                                                        
                 MOVE 'BNKRPT FILE DTE'    TO MI-COLUMN-DESC            
                 MOVE SPACES               TO MI-TABLE-ID               
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                     TO WS-TRAN-APPL-NO           
                 MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF BQ-RECEIVED-DATE NOT = PARM-DATE-RECEIVED                 
              MOVE +10              TO MI-PRV-COLUMN-VALUE-LEN          
                                       MI-CHG-COLUMN-VALUE-LEN          
              MOVE BQ-RECEIVED-DATE TO WS-SYS-DATE                      
              MOVE WS-SYS-CCYY      TO WS-TMP-CCYY                      
              MOVE WS-SYS-MONTH     TO WS-TMP-MONTH                     
              MOVE WS-SYS-DAY       TO WS-TMP-DAY                       
              MOVE WS-TMP-DATE      TO MI-PRV-COLUMN-VALUE-TEXT         
              MOVE PARM-DATE-RECEIVED   TO WS-SYS-DATE                  
              MOVE WS-SYS-CCYY      TO WS-TMP-CCYY                      
              MOVE WS-SYS-MONTH     TO WS-TMP-MONTH                     
              MOVE WS-SYS-DAY       TO WS-TMP-DAY                       
              MOVE WS-TMP-DATE      TO MI-CHG-COLUMN-VALUE-TEXT         
              MOVE 'RECEIVED DATE'  TO MI-COLUMN-DESC                   
              MOVE SPACES           TO MI-TABLE-ID                      
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                 TO WS-TRAN-APPL-NO                  
              MOVE WS-TRAN-APPL-NO  TO MI-TRAN-APPL-NO                  
           END-IF.                                                      
                                                                        
           PERFORM 7210-FETCH-AT-CASE-CRSR THRU 7210-EXIT.              
           IF WS-ACTIVE-RETURN-CODE NOT = NOT-FOUND                     
              PERFORM 5100-MOVE-TRAN-HEAD THRU 5100-EXIT                
           END-IF.                                                      
                                                                        
       5230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5240-UPDATE-PREPROCESS.                                        *        
      ******************************************************************        
       5240-UPDATE-PREPROCESS.                                          
                                                                        
           IF WS-TRAN-FLAG = 'N'                                        
               MOVE 1                      TO WS-TRAN-APPL-NO           
               PERFORM 5100-MOVE-TRAN-HEAD THRU 5100-EXIT               
           END-IF.                                                      
           MOVE YP-ATTRIBUTE-DESC           TO MI-COLUMN-DESC.          
           MOVE +5                          TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE '*NEW*'                     TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE +8                          TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE 'BANKRUPT'                  TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE SPACES                      TO MI-TABLE-ID.             
           MOVE 'BANKRUPTCY NOTIFICATION RECEIVED.'                     
                                            TO MH-TRAN-COMMENT-TEXT.    
           MOVE +33                         TO MH-TRAN-COMMENT-LEN.     
           MOVE 'PANEL490'                  TO MH-APPL-PROGRAM-ID.      
           PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT.             
           MOVE 'Y'                         TO WS-TRAN-FLAG.            
                                                                        
       5240-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 5250-UPDATE-PREPROCESS-DELETE.                                 *        
      ******************************************************************        
       5250-UPDATE-PREPROCESS-DELETE.                                   
      *                                                                         
           IF WS-TRAN-FLAG = 'N'                                        
               MOVE 1                      TO WS-TRAN-APPL-NO           
               PERFORM 5100-MOVE-TRAN-HEAD THRU 5100-EXIT               
           END-IF.                                                      
           MOVE YP-ATTRIBUTE-DESC           TO MI-COLUMN-DESC.          
           MOVE +11                         TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE '**DELETED**'               TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE +8                          TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE 'BANKRUPT'                  TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE SPACES                      TO MI-TABLE-ID.             
           MOVE 'BANKRUPTCY DISMISSED - OK TO COLLECT.'                 
                                            TO MH-TRAN-COMMENT-TEXT.    
           MOVE +38                         TO MH-TRAN-COMMENT-LEN.     
           MOVE 'PANEL490'                  TO MH-APPL-PROGRAM-ID.      
           PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT.             
           MOVE 'Y'                         TO WS-TRAN-FLAG.            
      *                                                                         
       5250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * 5300-PROCESS-BANKRUPTCY                                     *           
      * CALLS 5310-UPDATE-CASE-DETAIL                               *           
      *       5320-UPDATE-ACCTS                                     *           
      ***************************************************************           
       5300-PROCESS-BANKRUPTCY.                                         
                                                                        
           MOVE '5300' TO ACTIVE-PARAGRAPH.                             
                                                                        
           IF PARM-DATE-FILED = SPACES                                  
              MOVE -1 TO WS-NULL-IND                                    
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND                                  
           END-IF.                                                      
                                                                        
           IF PARM-DATE-RECEIVED = SPACES                               
              MOVE -1 TO WS-NULL-IND2                                   
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND2                                 
           END-IF.                                                      
                                                                        
           IF NEW-CASE                                                  
              IF PARM-FILED-CASE-NO = SPACES                            
                 MOVE NOT-FOUND TO WS-ACTIVE-RETURN-CODE                
              ELSE                                                      
                 MOVE PARM-FILED-CASE-NO  TO BQ-FILED-CASE-NO           
                 PERFORM 7350-SELECT-BQ-ROW THRU 7350-EXIT              
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE BQ-BNKRPT-CASE-NO TO WS-MAX-CASE-NO               
                 MOVE WS-MAX-CASE-NO  TO BQ-BNKRPT-CASE-NO              
                                         AT-BNKRPT-CASE-NO              
              ELSE                                                      
                 PERFORM 7400-SELECT-BQ-MAX THRU 7400-EXIT              
                 IF WS-MAX-CASE-NO = SPACES                             
                    MOVE ZEROES TO WS-MAX-CASE-NO-NUM                   
                 END-IF                                                 
                 ADD 1                TO WS-MAX-CASE-NO-NUM             
                 MOVE WS-MAX-CASE-NO  TO BQ-BNKRPT-CASE-NO              
                                         AT-BNKRPT-CASE-NO              
                 PERFORM 5305-NEW-CASE-DETAIL THRU 5305-EXIT            
              END-IF                                                    
           ELSE                                                         
              MOVE PARM-BNKRPT-CASE-NO TO BQ-BNKRPT-CASE-NO             
                                          AT-BNKRPT-CASE-NO             
                                          WS-MAX-CASE-NO                
           END-IF.                                                      
                                                                        
           IF CASE-NO-UPDATE                                            
              PERFORM 5310-UPDATE-CASE-DETAIL THRU 5310-EXIT            
           ELSE                                                         
              MOVE PARM-ACCT-NUM       TO WS-ACCOUNT-ARRAY              
              PERFORM 5320-UPDATE-ACCTS THRU 5320-EXIT                  
              VARYING WS-SUB FROM 1 BY 1                                
SCA006        UNTIL WS-SUB > 200 OR 
                    WS-ACCOUNT-DETAIL(WS-SUB) = SPACES OR 
                    WS-ACCOUNT-DETAIL(WS-SUB) = LOW-VALUES                 
              MOVE PARM-BNKRPT-CASE-NO TO AT-BNKRPT-CASE-NO             
              PERFORM 7200-OPEN-AT-CASE-CRSR  THRU 7200-EXIT            
              PERFORM 7210-FETCH-AT-CASE-CRSR THRU 7210-EXIT            
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE PARM-BNKRPT-CASE-NO TO BQ-BNKRPT-CASE-NO          
                 PERFORM 8350-DELETE-BQ THRU 8350-EXIT                  
              END-IF                                                    
              PERFORM 7220-CLOSE-AT-CASE-CRSR THRU 7220-EXIT            
           END-IF.                                                      
                                                                        
           MOVE WS-MAX-CASE-NO        TO S-BNKRPT-CASE-NO.              
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE.                 
       5300-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 5305-NEW-CASE-DETAIL.                                                   
      * ADD NEW BANKRUPTCY CASE ON CSS_BANKRUPTCY WITH THE PARM INFO            
      *****************************************************************         
       5305-NEW-CASE-DETAIL.                                            
                                                                        
           MOVE '5305'         TO ACTIVE-PARAGRAPH.                     
                                                                        
           MOVE PARM-FILED-CASE-NO  TO BQ-FILED-CASE-NO.                
           MOVE PARM-CHAPTER        TO BQ-BANKRUPTCY-CHAPTER.           
           MOVE PARM-DATE-FILED     TO BQ-DATE-BNKRPT-FILED.            
           MOVE PARM-DATE-RECEIVED  TO BQ-RECEIVED-DATE.                
           MOVE PARM-USER-ID        TO BQ-USER-ID-INIT-BY.              
           PERFORM 8250-INSERT-BQ  THRU 8250-EXIT.                      
       5305-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      * 5310-UPDATE-CASE-DETAIL                                                 
      *                                                                         
      * UPDATES THE BANKRUPTCY CASE ON CSS_BANKRUPTCY WITH THE                  
      * CHANGED INFORMATION.                                                    
      *                                                                         
      *****************************************************************         
       5310-UPDATE-CASE-DETAIL.                                         
      *                                                                         
           MOVE '5310'                  TO ACTIVE-PARAGRAPH.            
      *                                                                         
           IF PARM-FILED-CASE-NO = SPACES                               
              MOVE NOT-FOUND            TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PARM-FILED-CASE-NO   TO BQ-FILED-CASE-NO             
              PERFORM 7350-SELECT-BQ-ROW              THRU 7350-EXIT    
           END-IF                                                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
      *                                                                         
               MOVE BQ-BNKRPT-CASE-NO   TO WS-BQ-BNKRPT-CASE-NO         
               MOVE PARM-CHAPTER        TO BQ-BANKRUPTCY-CHAPTER        
               MOVE PARM-DATE-FILED     TO BQ-DATE-BNKRPT-FILED         
               MOVE PARM-DATE-RECEIVED  TO BQ-RECEIVED-DATE             
               PERFORM 8200-UPDATE-CASE               THRU 8200-EXIT    
      *                                                                         
               MOVE PARM-BNKRPT-CASE-NO TO AT-BNKRPT-CASE-NO            
               PERFORM 8225-UPDATE-AT                 THRU 8225-EXIT    
      *                                                                         
      *        //DELETE OLD BANKRUPT CASE NO                                    
               IF PARM-BNKRPT-CASE-NO NOT = WS-BQ-BNKRPT-CASE-NO        
                   MOVE PARM-BNKRPT-CASE-NO                             
                                        TO BQ-BNKRPT-CASE-NO            
                   PERFORM 8350-DELETE-BQ             THRU 8350-EXIT    
               END-IF                                                   
           ELSE                                                         
              MOVE PARM-BNKRPT-CASE-NO TO BQ-BNKRPT-CASE-NO             
              MOVE PARM-CHAPTER        TO BQ-BANKRUPTCY-CHAPTER         
              MOVE PARM-DATE-FILED     TO BQ-DATE-BNKRPT-FILED          
              MOVE PARM-DATE-RECEIVED  TO BQ-RECEIVED-DATE              
              MOVE PARM-FILED-CASE-NO  TO BQ-FILED-CASE-NO              
              PERFORM 8200-UPDATE-CASE                THRU 8200-EXIT    
           END-IF.                                                      
      *                                                                         
       5310-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      * 5320-UPDATE-ACCTS.                                                      
      *****************************************************************         
       5320-UPDATE-ACCTS.                                               
           MOVE '5320'         TO ACTIVE-PARAGRAPH.                     
                                                                        
           MOVE PARM-FILED-CASE-NO  TO BQ-FILED-CASE-NO.                
           MOVE PARM-CHAPTER        TO BQ-BANKRUPTCY-CHAPTER.           
           MOVE PARM-DATE-FILED     TO BQ-DATE-BNKRPT-FILED.            
           MOVE PARM-DATE-RECEIVED  TO BQ-RECEIVED-DATE.                
           MOVE PARM-USER-ID        TO BQ-USER-ID-INIT-BY.              
                                                                        
           IF SET-BANKRUPTCY(WS-SUB)                                    
              PERFORM 5330-SET-UP-BANKRUPTCY THRU 5330-EXIT             
           ELSE                                                         
              IF REMOVE-BANKRUPTCY(WS-SUB)                              
                 PERFORM 5340-REMOVE-BANKRUPTCY THRU 5340-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7150-SELECT-AT-ROW THRU 7150-EXIT.                   
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT       
              MOVE AT-ACCOUNT-NO TO WS-AT-ACCOUNT-NUM                   
              STRING WS-AT-ACCOUNT-CHAR WS-CODE-PENDING-DNP             
                     WS-HASH DELIMITED BY SIZE                          
              INTO   S-ACCOUNT-INFO                                     
           END-IF.                                                      
P00936     IF WS-UPDATE-FLAG(WS-SUB) = 'S'                              
P00936        PERFORM 5960-WORK-QUEUE-BANKRUPTCY THRU 5960-EXIT         
           END-IF.                                                      
           MOVE 'DATABASE'                   TO C8-DELINQ-CD.           
           PERFORM 7750-GET-DEL-VALUES          THRU 7750-EXIT.         
           MOVE C8-DELINQ-VALUE              TO WS-DATABASE.            
           PERFORM 5600A-CANCEL-DNP               THRU 5600A-EXIT.      
           IF (CSR-DATABASE AND PSNC)                                   
               PERFORM 5700A-CANCEL-NOTICES       THRU 5700A-EXIT       
           END-IF.                                                      
                                                                        
           IF SET-BANKRUPTCY(WS-SUB)                                    
              PERFORM 5800-CANCEL-E-DRAFT   THRU 5800-EXIT              
              PERFORM 5850-CANCEL-AUTO-CARD THRU 5850-EXIT              
           END-IF.                                                      
                                                                        
       5320-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *  5330-SET-BANKRUPTCY.                                          *        
      *  SET BANKRUPTCY ON AN ACCOUNT                                  *        
      ******************************************************************        
       5330-SET-UP-BANKRUPTCY.                                          
                                                                        
           MOVE '5330'         TO ACTIVE-PARAGRAPH.                     
                                                                        
            MOVE SPACES TO AT-BANKRUPTCY-IND.                           
            MOVE SPACES TO AT-BNKRPT-CASE-NO.                           
                                                                        
            MOVE WS-ACCOUNT-NUMBER(WS-SUB) TO WS-ACCOUNT-NO.            
            MOVE WS-ACCOUNT-NUM            TO AT-ACCOUNT-NO.            
            PERFORM 7100-SELECT-AT-ROW    THRU 7100-EXIT.               
            IF (AT-BANKRUPTCY-IND = SPACES) OR                          
               (AT-BNKRPT-CASE-NO = SPACES OR                           
                AT-BNKRPT-CASE-NO = LOW-VALUES)                         
                MOVE WS-BNK          TO AT-BANKRUPTCY-IND               
                MOVE WS-MAX-CASE-NO  TO AT-BNKRPT-CASE-NO               
                MOVE 'G'             TO AT-CODE-PERM-BILL               
                IF AT-CODE-ACCT-STAT = 'B' OR 'S'                       
                   IF AT-CODE-STATUS-REASON NOT EQUAL 'E'               
                      MOVE 'E'       TO AT-CODE-STATUS-REASON           
                   END-IF                                               
                END-IF                                                  
                PERFORM 8220-UPDATE-AT THRU 8220-EXIT                   
                PERFORM 7050-GET-REG-GROUP                              
                   THRU 7050-EXIT                                       
                PERFORM 5400-UPDATE-FB-WO                               
                   THRU 5400-EXIT                                       
                IF AT-CODE-ACCT-STAT = 'A' OR 'P'                       
                   PERFORM 5510-SET-CACB-EXEMPTION THRU 5510-EXIT       
                END-IF                                                  
            ELSE                                                        
               MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE              
               MOVE WS-YES              TO S-BANKRUPTCY-IND             
                                           WS-UPDATE-FLAG(WS-SUB)       
            END-IF.                                                     
                                                                        
                                                                        
       5330-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *  5340-REMOVE-BANKRUPTCY.                                       *        
      *  REMOVE BANKRUPTCY ON AN ACCOUNT                               *        
      ******************************************************************        
       5340-REMOVE-BANKRUPTCY.                                          
                                                                        
           MOVE '5340'         TO ACTIVE-PARAGRAPH.                     
                                                                        
           MOVE WS-ACCOUNT-NUMBER(WS-SUB)  TO WS-ACCOUNT-NO.            
           MOVE WS-ACCOUNT-NUM             TO AT-ACCOUNT-NO.            
           MOVE 'N' TO WS-TRAN-FLAG.                                    
                                                                        
           PERFORM 7100-SELECT-AT-ROW THRU 7100-EXIT.                   
           IF (AT-BANKRUPTCY-IND = 'B')                                 
              AND AT-BNKRPT-CASE-NO = PARM-BNKRPT-CASE-NO               
              MOVE SPACES          TO AT-BANKRUPTCY-IND                 
                                      AT-BNKRPT-CASE-NO                 
              MOVE 'A'             TO AT-CODE-PERM-BILL                 
              IF AT-CODE-ACCT-STAT = 'B' OR 'S'                         
                 PERFORM 7050-GET-REG-GROUP                             
                    THRU 7050-EXIT                                      
                 PERFORM 7670-SELECT-FINAL-WO THRU 7670-EXIT            
                 PERFORM 7410-SELECT-CREDIT-PROFILE THRU 7410-EXIT      
                 IF AT-CODE-STATUS-REASON = 'E'                         
                    MOVE 'A'       TO AT-CODE-STATUS-REASON             
                 END-IF                                                 
                 PERFORM 5410-SET-FBWO-PATH   THRU 5410-EXIT            
              END-IF                                                    
              PERFORM 5520-UNSET-CACB-EXEMPTION THRU 5520-EXIT          
              PERFORM 8220-UPDATE-AT THRU 8220-EXIT                     
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE               
              MOVE WS-NO                 TO S-BANKRUPTCY-IND            
                                            WS-UPDATE-FLAG(WS-SUB)      
           END-IF.                                                      
                                                                        
       5340-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 5400-UPDATE-FB-WO.                                             *        
      ******************************************************************        
       5400-UPDATE-FB-WO.                                               
      *                                                                         
           PERFORM 7670-SELECT-FINAL-WO           THRU 7670-EXIT.       
           PERFORM 7410-SELECT-CREDIT-PROFILE     THRU 7410-EXIT.       
           IF AT-CODE-ACCT-STAT = 'B'                                   
              PERFORM 5500-PROCESS-FINAL-STATUS   THRU 5500-EXIT        
              PERFORM 5410-SET-FBWO-PATH          THRU 5410-EXIT        
           ELSE                                                         
              IF AT-CODE-ACCT-STAT = 'S'                                
                 PERFORM 5600-PROCESS-WRITE-OFF   THRU 5600-EXIT        
                 PERFORM 5410-SET-FBWO-PATH       THRU 5410-EXIT        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       5400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 5410-SET-FBWO-PATH.                                                     
      *****************************************************************         
       5410-SET-FBWO-PATH.                                              
      *                                                                         
           MOVE AT-CODE-STATUS-REASON          TO KA-CODE-STATUS-REASON 
           MOVE CZ-BHV-RATING-HIST(1:1)        TO KA-BHV-SCORE-RATING   
           MOVE FW-GUARANTEED-IND              TO KA-GUARANTEED-IND     
           MOVE AT-COMPANY-NO                  TO KA-COMPANY-NO         
           MOVE LR-REG-GROUP-CD                TO KA-REG-GROUP-CD       
           IF  AT-CREDIT-GROUP = 'D'                                    
               MOVE 'N'                        TO KA-FW-ACCT-TYPE-CD    
           ELSE                                                         
               MOVE 'U'                        TO KA-FW-ACCT-TYPE-CD    
           END-IF                                                       
           PERFORM 7060-SELECT-FW-PATH         THRU 7060-EXIT           
           MOVE KA-FW-PATH-TYPE-CD             TO FW-FW-PATH-TYPE-CD    
           PERFORM 8060-UPDATE-FIN-WO          THRU 8060-EXIT.          
      *                                                                         
       5410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5500-PROCESS-FINAL-STATUS.                             *                
      ******************************************************************        
       5500-PROCESS-FINAL-STATUS.                                       
                                                                        
           MOVE WS-NEXT-WORK-DATE              TO KD-FW-ACTION-DT       
           PERFORM 8400-UPD-FIN-WO-ACTION      THRU 8400-EXIT.          
           PERFORM 8310-DELETE-FUT-ACTION      THRU 8310-EXIT.          
           PERFORM 5510-SET-CACB-EXEMPTION     THRU 5510-EXIT.          
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5510-SET-CACB-EXEMPTION.                                     *          
      ******************************************************************        
       5510-SET-CACB-EXEMPTION.                                         
           MOVE 'CAEXEMPT'                     TO YP-ATTRIBUTE-DESC.    
           PERFORM 7510-CHK-ACCT-ATTRIBUTE     THRU 7510-EXIT.          
           IF  WS-EXISTS-FL = 'N'                                       
               MOVE AT-ACCOUNT-NO              TO YP-ACCOUNT-NO         
               MOVE WS-CURRENT-DATE            TO YP-ATTRIBUTE-VALUE-DT 
               MOVE 'B'                        TO YP-ATTRIBUTE-VALUE-CD 
               IF  WS-ROW-EXISTS-FL = 'N'                               
                   PERFORM 8520-INSERT-ACCT-ATTRIBUTE                   
                      THRU 8520-EXIT                                    
               ELSE                                                     
                   PERFORM 8530-UPDATE-ACCT-ATTRIBUTE                   
                      THRU 8530-EXIT                                    
               END-IF                                                   
               PERFORM 5240-UPDATE-PREPROCESS                           
                  THRU 5240-EXIT                                        
           END-IF.                                                      
           MOVE 'CBEXEMPT'                     TO YP-ATTRIBUTE-DESC.    
           PERFORM 7510-CHK-ACCT-ATTRIBUTE     THRU 7510-EXIT.          
           IF  WS-EXISTS-FL = 'N'                                       
               MOVE AT-ACCOUNT-NO              TO YP-ACCOUNT-NO         
               MOVE WS-CURRENT-DATE            TO YP-ATTRIBUTE-VALUE-DT 
               MOVE 'B'                        TO YP-ATTRIBUTE-VALUE-CD 
               IF  WS-ROW-EXISTS-FL = 'N'                               
                   PERFORM 8520-INSERT-ACCT-ATTRIBUTE                   
                      THRU 8520-EXIT                                    
               ELSE                                                     
                   PERFORM 8530-UPDATE-ACCT-ATTRIBUTE                   
                      THRU 8530-EXIT                                    
               END-IF                                                   
               PERFORM 5240-UPDATE-PREPROCESS                           
                  THRU 5240-EXIT                                        
           END-IF.                                                      
           MOVE 'N' TO WS-TRAN-FLAG.                                    
      *                                                                         
       5510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5520-UNSET-CACB-EXEMPTION.                                    *         
      ******************************************************************        
       5520-UNSET-CACB-EXEMPTION.                                       
           MOVE 'CAEXEMPT'                     TO YP-ATTRIBUTE-DESC.    
           PERFORM 7510-CHK-ACCT-ATTRIBUTE     THRU 7510-EXIT.          
           IF  WS-EXISTS-FL = 'Y'                                       
               IF YP-ATTRIBUTE-VALUE-CD = 'B'                           
                  MOVE AT-ACCOUNT-NO           TO YP-ACCOUNT-NO         
                  MOVE WS-CURRENT-DATE         TO YP-ATTRIBUTE-VALUE-DT 
                  MOVE SPACES                  TO YP-ATTRIBUTE-VALUE-CD 
                  PERFORM 8530-UPDATE-ACCT-ATTRIBUTE                    
                     THRU 8530-EXIT                                     
                  PERFORM 5250-UPDATE-PREPROCESS-DELETE                 
                     THRU 5250-EXIT                                     
               END-IF                                                   
           END-IF.                                                      
           MOVE 'CBEXEMPT'                     TO YP-ATTRIBUTE-DESC.    
           PERFORM 7510-CHK-ACCT-ATTRIBUTE     THRU 7510-EXIT.          
           IF  WS-EXISTS-FL = 'Y'                                       
               IF YP-ATTRIBUTE-VALUE-CD = 'B'                           
                  MOVE AT-ACCOUNT-NO           TO YP-ACCOUNT-NO         
                  MOVE WS-CURRENT-DATE         TO YP-ATTRIBUTE-VALUE-DT 
                  MOVE SPACES                  TO YP-ATTRIBUTE-VALUE-CD 
                  PERFORM 8530-UPDATE-ACCT-ATTRIBUTE                    
                     THRU 8530-EXIT                                     
                  PERFORM 5250-UPDATE-PREPROCESS-DELETE                 
                     THRU 5250-EXIT                                     
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       5520-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 5600-PROCESS-WRITE-OFF.                                        *        
      ******************************************************************        
       5600-PROCESS-WRITE-OFF.                                          
      *                                                                         
           PERFORM 5030-GET-LAST-RUN-DT THRU 5030-EXIT                  
           EVALUATE FW-COLLECT-STATUS-CD                                
              WHEN 'U'                                                  
                 MOVE AT-ACCOUNT-NO             TO KD-ACCOUNT-NO        
                 PERFORM 8310-DELETE-FUT-ACTION THRU 8310-EXIT          
                 MOVE WS-FINAL-RUN-DATE         TO KD-FW-ACTION-DT      
                 PERFORM 8300-DELETE-FUT-PLMTS  THRU 8300-EXIT          
                 PERFORM 5510-SET-CACB-EXEMPTION THRU 5510-EXIT         
              WHEN 'F'                                                  
              WHEN 'H'                                                  
              WHEN 'J'                                                  
              WHEN 'D'                                                  
                  PERFORM 5700-PROCESS-PLACD-ACCTS THRU 5700-EXIT       
              WHEN OTHER                                                
                  MOVE AT-ACCOUNT-NO              TO KD-ACCOUNT-NO      
                  PERFORM 8310-DELETE-FUT-ACTION  THRU 8310-EXIT        
                  MOVE WS-FINAL-RUN-DATE          TO KD-FW-ACTION-DT    
                  PERFORM 8300-DELETE-FUT-PLMTS   THRU 8300-EXIT        
                  PERFORM 5510-SET-CACB-EXEMPTION THRU 5510-EXIT        
           END-EVALUATE.                                                
                                                                        
       5600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *5700-PROCESS-PLCD-ACCTS.                                        *        
      ******************************************************************        
       5700-PROCESS-PLACD-ACCTS.                                        
      *                                                                         
           EVALUATE FW-COLLECT-STATUS-CD                                
               WHEN 'F'                                                 
                   MOVE '1PLMT'          TO WS-ACTN-TYPE-CD             
               WHEN 'H'                                                 
                   MOVE '2PLMT'          TO WS-ACTN-TYPE-CD             
               WHEN 'J'                                                 
                   MOVE '3PLMT'          TO WS-ACTN-TYPE-CD             
               WHEN 'D'                                                 
                   MOVE 'ATY'            TO WS-ACTN-TYPE-CD             
           END-EVALUATE                                                 
           PERFORM 7680-SEL-CA-WITHDRAW-DATE THRU 7680-EXIT             
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           AND IZ-WITHDRAW-REASON-CD= SPACES                            
      *    MNT ROW DET FOR WITHDRAW DATE UPDATE WILL BE DONE IN 5220-           
              PERFORM 7700-GET-WO-BAL THRU 7700-EXIT                    
              MOVE IZ-WITHDRAW-AM TO WS-PREV-WITHDRAW-AM                
              MOVE WS-WO-BAL      TO IZ-WITHDRAW-AM                     
                                     WS-NEW-WITHDRAW-AM                 
              MOVE IZ-WITHDRAW-DT  TO WS-PREV-WITHDRAW-DT               
              MOVE WS-CURRENT-DATE TO WS-NEW-WITHDRAW-DT                
              MOVE WS-ACTN-TYPE-CD TO WS-UPDT-PLMT-TYPE                 
      *                                                                         
              PERFORM 8500-UPD-FIN-COLLECT   THRU 8500-EXIT             
           END-IF                                                       
           MOVE AT-ACCOUNT-NO              TO KD-ACCOUNT-NO             
           PERFORM 8310-DELETE-FUT-ACTION  THRU 8310-EXIT               
           MOVE WS-FINAL-RUN-DATE          TO KD-FW-ACTION-DT           
           PERFORM 8300-DELETE-FUT-PLMTS   THRU 8300-EXIT               
           PERFORM 5510-SET-CACB-EXEMPTION THRU 5510-EXIT.              
                                                                        
       5700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5800-CANCEL-E-DRAFT                                            *        
      ******************************************************************        
      *                                                                         
       5800-CANCEL-E-DRAFT.                                             
      *                                                                         
           IF WS-CODE-BANK-EFT  = WS-ACTIVE                             
      *                                                                         
              PERFORM 6000-CALL-CSR04846            THRU 6000-EXIT      
              PERFORM 6010-ALLOCATE-CURSOR-CSR04846 THRU 6010-EXIT      
              PERFORM 6020-FETCH-CSR04846           THRU 6020-EXIT      
              PERFORM 6030-CLOSE-CSR04846           THRU 6030-EXIT      
      *                                                                         
           END-IF.                                                      
      *                                                                         
       5800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5850-CANCEL-AUTO-CARD                                          *        
      ******************************************************************        
      *                                                                         
       5850-CANCEL-AUTO-CARD.                                           
      *                                                                         
           MOVE 'N'                     TO WS-AUTO-CARD-EXIST.          
           PERFORM 5900-MOVE-AUTO-CARD-EXIST   THRU 5900-EXIT.          
           PERFORM 7000-CHECK-AUTO-CARD-EXIST  THRU 7000-EXIT.          
      *                                                                         
           IF WS-AUTO-CARD-EXIST EQUAL 'Y'                              
      *                                                                         
              PERFORM 6040-CALL-CSR04304            THRU 6040-EXIT      
              PERFORM 6050-ALLOCATE-CURSOR-CSR04304 THRU 6050-EXIT      
              PERFORM 6060-FETCH-CSR04304           THRU 6060-EXIT      
              PERFORM 6070-CLOSE-CSR04304           THRU 6070-EXIT      
      *                                                                         
           END-IF.                                                      
      *                                                                         
       5850-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5900-MOVE-AUTO-CARD-EXIST                                      *        
      ******************************************************************        
      *                                                                         
       5900-MOVE-AUTO-CARD-EXIST.                                       
      *                                                                         
           MOVE WS-ACCOUNT-NO            TO YP-ACCOUNT-NO.              
           MOVE 'AUTO_CARD_PAY'          TO YP-ATTRIBUTE-DESC.          
           MOVE 'AUTOC'                  TO YP-ATTRIBUTE-VALUE-CD.      
           MOVE 'A'                      TO YP-STATUS-CD.               
      *                                                                         
       5900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 5950-SET-MNT-TRANS-VARS                                        *        
      *      -- THIS MODULE SETS UP THE REMAINING HOST VARIABLES WITH  *        
      *         SYSTEM WORKING STORAGE OR HARD-CODED VALUES FOR        *        
      *         INSERTING INTO THE CSS_MNT_TRANS_HIST AND              *        
      *         CSS_MT_TRN_HST_DET TABLES IN ORDER TO COMPLETE THE     *        
      *         REQUIRED MAINTENANCE TRANSACTION RECORD.               *        
      ******************************************************************        
       5950-SET-MNT-TRANS-VARS.                                         
           MOVE '5950'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD +1                           TO WS-TRAN-APPL-NO.         
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
                                                                        
       5950-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6000-CALL-CSR04846                                             *        
      ******************************************************************        
      *                                                                         
       6000-CALL-CSR04846.                                              
      *                                                                         
      *    EXEC SQL                                                     
      *     CALL CSR04846 ( 'CIS'                                       
      *                    ,'C'                                         
      *                    ,:WS-ACCOUNT-NO                              
      *                    ,'D'                                         
      *                    ,:WS-DRAFT-CYCLE                             
      *                    ,:WS-REQSTED-DRAFT-DAY                       
      *                    ,:WS-BANK-ACCOUNT-NAME                       
      *                    ,:WS-BANK-ACCT-NO                            
      *                    ,:WS-ACCT-TYPE-CD                            
      *                    ,:WS-BANK-ID                                 
      *                    ,:WS-USER-ID                                 
      *                    ,:WS-RESP-AREA-ID                            
      *                    ,'BANKRUPTCY SETUP'                          
      *                    ,'019'                                       
      *                    ,:WS-INIT-TYPE-CD                            
      *                    ,:WS-NICKNAME-TEXT                           
      *                    ,:WS-NICKNAME-LEN                            
      *                    ,:WS-CUST-BNK-SEQ-NO                         
      *                    )                                            
      *     END-EXEC.                                                   

MSQ001        EXEC SQL
MSQ001          CLOSE CANCEL_EDRAFT
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN CANCEL_EDRAFT
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR CANCEL_EDRAFT INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
            MOVE SQLCODE                     TO                         
                                              WS-ACTIVE-RETURN-CODE     
                                              S-RETURN-CODE.            
                                                                        
            IF WS-ACTIVE-RETURN-CODE = +466                             
               CONTINUE                                                 
            ELSE                                                        
               MOVE -1                         TO S-RETURN-CODE         
                                                  WS-ACTIVE-RETURN-CODE 
               MOVE '6000'                     TO ACTIVE-PARAGRAPH      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE 'DB2SP CALL'               TO ABEND-FUNCTION        
               MOVE SQLCODE                    TO ABEND-SQLCODE         
               MOVE 'CSR04846'                 TO TABLE-1               
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
               MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
               MOVE 'SQLCODE'                  TO TABLE-ELEMENT-2       
               MOVE SQLCODE                    TO HOSTVAR-ELEMENT-2     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
      *                                                                         
        6000-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6010-ALLOCATE-CURSOR-CSR04846                                  *        
      ******************************************************************        
      *                                                                         
       6010-ALLOCATE-CURSOR-CSR04846.                                   
      *                                                                         
      *    EXEC SQL                                                     
      *        ASSOCIATE LOCATORS                                       
      *        (:LOC6)                                                  
      *        WITH PROCEDURE CSR04846                                  
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *        ALLOCATE CANCEL_EDRAFT CURSOR FOR RESULT SET             
      *        :LOC6                                                    
      *    END-EXEC.                                                    
      *                                                                         
       6010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6020-FETCH-CSR04846.                                           *        
      ******************************************************************        
      *                                                                         
       6020-FETCH-CSR04846.                                             
      *                                                                         
           EXEC SQL                                                     
           FETCH CANCEL_EDRAFT INTO                                     
                    :WS-CSR04846-RETURN-CD                              
                   ,:WS-APPL-RETURN-CODE                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE -1                         TO S-RETURN-CODE          
              MOVE '6020'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE 'CSR04846'                 TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'SQLCODE '                 TO TABLE-ELEMENT-2        
              MOVE SQLCODE                    TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           IF WS-CSR04846-RETURN-CD EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-CSR04846-RETURN-CD TO S-RETURN-CODE               
              MOVE '6020'                TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'DB2SP CALL'          TO ABEND-FUNCTION              
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE 'CSR04846'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'SQLCODE'             TO TABLE-ELEMENT-2             
              MOVE SQLCODE TO HOSTVAR-ELEMENT-2                         
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       6020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6030-CLOSE-CSR04846.                                          *         
      ******************************************************************        
      *                                                                         
       6030-CLOSE-CSR04846.                                             
                                                                        
           EXEC SQL                                                     
             CLOSE CANCEL_EDRAFT                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE -1                        TO S-RETURN-CODE           
              MOVE '6030'                    TO ACTIVE-PARAGRAPH        
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE 'CSR04846'                TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE 'SQLCODE '                TO TABLE-ELEMENT-2         
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       6030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6040-CALL-CSR04304                                             *        
      ******************************************************************        
      *                                                                         
       6040-CALL-CSR04304.                                              
      *                                                                         
      *    EXEC SQL                                                     
      *     CALL CSR04304 ( 'CAN'                                       
      *                    ,:WS-ACCOUNT-NO                              
      *                    ,:WS-COMPANY-NO                              
      *                    ,:WS-CURR-TIMESTMP                           
      *                    ,'$$$'                                       
A05460*                    ,:WS-USER-ID                                 
      *                    )                                            
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE CANCEL_AUTO_CARD
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN CANCEL_AUTO_CARD
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR CANCEL_AUTO_CARD INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                     TO                          
                                             WS-ACTIVE-RETURN-CODE      
                                             S-RETURN-CODE.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = +466                              
              CONTINUE                                                  
           ELSE                                                         
              MOVE -1                         TO S-RETURN-CODE          
                                                 WS-ACTIVE-RETURN-CODE  
              MOVE '6040'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'DB2SP CALL'               TO ABEND-FUNCTION         
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE 'CSR04304'                 TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'SQLCODE'                  TO TABLE-ELEMENT-2        
              MOVE SQLCODE                    TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
        6040-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6050-ALLOCATE-CURSOR-CSR04304                                  *        
      ******************************************************************        
      *                                                                         
       6050-ALLOCATE-CURSOR-CSR04304.                                   
      *                                                                         
      *    EXEC SQL                                                     
      *        ASSOCIATE LOCATORS                                       
      *        (:LOC7)                                                  
      *        WITH PROCEDURE CSR04304                                  
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *        ALLOCATE CANCEL_AUTO_CARD CURSOR FOR RESULT SET          
      *        :LOC7                                                    
      *    END-EXEC.                                                    
      *                                                                         
       6050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6060-FETCH-CSR04304                                            *        
      ******************************************************************        
      *                                                                         
       6060-FETCH-CSR04304.                                             
      *                                                                         
           EXEC SQL                                                     
           FETCH CANCEL_AUTO_CARD INTO                                  
                    :WS-CSR04304-RETURN-CD                              
                   ,:WS-CSR04304-ACCT-NO                                
                   ,:WS-CSR04304-CMPY-NO                                
                   ,:WS-CSR04304-TIMESTMP                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE -1                         TO S-RETURN-CODE          
              MOVE '6060'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE 'CSR04304'                 TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'SQLCODE '                 TO TABLE-ELEMENT-2        
              MOVE SQLCODE                    TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           IF WS-CSR04304-RETURN-CD EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-CSR04304-RETURN-CD TO S-RETURN-CODE               
              MOVE '6060'                TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'DB2SP CALL'          TO ABEND-FUNCTION              
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE 'CSR04304'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'SQLCODE'             TO TABLE-ELEMENT-2             
              MOVE SQLCODE               TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       6060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6070-CLOSE-CSR04304.                                          *         
      ******************************************************************        
      *                                                                         
       6070-CLOSE-CSR04304.                                             
                                                                        
           EXEC SQL                                                     
             CLOSE CANCEL_AUTO_CARD                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE -1                        TO S-RETURN-CODE           
              MOVE '6070'                    TO ACTIVE-PARAGRAPH        
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE 'CSR04304'                TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE 'SQLCODE '                TO TABLE-ELEMENT-2         
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       6070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 6530- MAINTENANCE TRANSACTION JOURNALING INCLUDE             *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD00067                                                 
           END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
      *                                                                         
      *****************************************************************         
      *    6500-GET-NEXT-BUSINESS-DAY                                **         
      *                                                              **         
      *    COPYBOOK CPD0315B CONTAINS THE LOGIC FOR FINDING          **         
      *    THE NEXT BUSINESS DAY.                                    **         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CPD0315B                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 5960-WORK-QUEUE-BANKRUPTCY                                     *        
      ******************************************************************        
                                                                        
       5960-WORK-QUEUE-BANKRUPTCY.                                      
                                                                        
           MOVE '4'                    TO WS-WQ-ROUTING-CATGRY.         
           MOVE AT-LOCAL-OFFICE        TO WS-WQ-LOCAL-OFFICE.           
           MOVE WS-USER-ID             TO WS-WQ-USER-ID-ORIG.           
           MOVE SPACES                 TO WS-WQ-USER-ID-ASGN.           
           MOVE SPACES                 TO WS-WQ-RESP-AREA-ID.           
           MOVE 54                     TO WS-WQ-CATEGORY-ID.            
           MOVE AT-ACCOUNT-NO          TO WS-WQ-ACCOUNT-NO.             
           MOVE AT-PREMISE-NO          TO WS-WQ-PREMISE-NO.             
           MOVE AT-CUSTOMER-NO         TO WS-WQ-CUSTOMER-NO.            
           MOVE ZEROES                 TO WS-WQ-SERV-ORDER-NO.          
           MOVE 'ACCOUNT FLAGGED FOR BANKRUPTCY'                        
                                       TO WS-COMMENTS.                  
           MOVE WS-COMMENTS            TO WS-WQ-COMMENTS-TEXT.          
           MOVE LENGTH OF WS-COMMENTS  TO WS-WQ-COMMENTS-LEN.           
           MOVE WS-CURR-TIMESTAMP      TO WS-WQ-DATE-REQUIRED           
                                          WS-WQ-DATE-CREATED.           
           MOVE 'N'                    TO WS-WQ-PRIORITY.               
           MOVE ZEROES                 TO WS-WQ-FREE-FORM-LEN           
                                          WS-WQ-ITEM-ID.                
           MOVE SPACES                 TO WS-WQ-FREE-FORM-TEXT.         
                                                                        
           PERFORM 5660-CALL-CSR04675          THRU 5660-EXIT.          
                                                                        
       5960-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-CHECK-AUTO-CARD-EXIST                                     *        
      ******************************************************************        
      *                                                                         
       7000-CHECK-AUTO-CARD-EXIST.                                      
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) 'Y'                                                 
               INTO :WS-AUTO-CARD-EXIST                                 
               FROM CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                    
              WHERE ACCOUNT_NO         = :YP-ACCOUNT-NO                 
                AND ATTRIBUTE_DESC     = :YP-ATTRIBUTE-DESC             
                AND ATTRIBUTE_VALUE_CD = :YP-ATTRIBUTE-VALUE-CD         
                AND STATUS_CD          = :YP-STATUS-CD                  
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 'Y'                                                         
MFA-TR*        INTO :WS-AUTO-CARD-EXIST                                         
MFA-TR*        FROM CSS_ACCT_ATTRIBUTE                                          
MFA-TR*       WHERE ACCOUNT_NO         = :YP-ACCOUNT-NO                         
MFA-TR*         AND ATTRIBUTE_DESC     = :YP-ATTRIBUTE-DESC                     
MFA-TR*         AND ATTRIBUTE_VALUE_CD = :YP-ATTRIBUTE-VALUE-CD                 
MFA-TR*         AND STATUS_CD          = :YP-STATUS-CD                          
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              OR NOT-FOUND                                              
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT '             TO ABEND-FUNCTION              
              MOVE 'CSS_ACCT_ATTRIBUTE ' TO TABLE-1                     
              MOVE 'ACCOUNT_NO  '        TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7010-GET-CURRENT-DATE                                         *         
      *          GETS CURRENT DATE                                    *         
      *****************************************************************         
       7010-GET-CURRENT-DATE.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-DATE,
              :WS-CURR-TIMESTMP                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-DATE  = CURRENT DATE                             
MFA-TR*           ,:WS-CURR-TIMESTMP = CURRENT TIMESTAMP                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT                            
                                         THRU 9000-EXIT                 
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                         THRU 9900-EXIT                 
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7030-GET-NEXT-WORK-DAY                                        *         
      *          GETS NEXT WORKING DAY                                *         
      *****************************************************************         
       7030-GET-NEXT-WORK-DAY.                                          
           EXEC SQL                                                     
              SELECT                                                    
                  DATEADD( DAY, :WS-ADJ-DAY, IIF(TRY_CONVERT(DATE, 
                                                        :WS-ACTION-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTION-DATE
              ) <> 0) OR (LEN(:WS-ACTION-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-ACTION-DATE
              ), CONVERT(DATE, :WS-ACTION-DATE) ) )              
              INTO                                                      
                  :WS-WORK-DATE                                         
              FROM                                                      
                  CIS.SYSDUMMY1                                      
              WHERE                                                     
                  CIS.DAYS(DATEADD( DAY, :WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-ACTION-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTION-DATE
              ) <> 0) OR (LEN(:WS-ACTION-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-ACTION-DATE
              ), CONVERT(DATE, :WS-ACTION-DATE) ) )) -      
                  (CIS.DAYS(DATEADD( DAY, :WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-ACTION-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTION-DATE
              ) <> 0) OR (LEN(:WS-ACTION-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-ACTION-DATE
              ), CONVERT(DATE, :WS-ACTION-DATE
              ) ) )) / 7 * 7) BETWEEN 1 AND 5  
              AND NOT EXISTS                                            
                  (SELECT                                               
                       HOLIDAY_DT                                       
                   FROM                                                 
                       CSS_HOLIDAY                                      
                   WHERE                                                
                       COMPANY_NO = :WS-COMPANY-NO                      
                   AND HOLIDAY_DT =                                     
                              DATEADD( DAY, :WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-ACTION-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTION-DATE
              ) <> 0) OR (LEN(:WS-ACTION-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-ACTION-DATE
              ), CONVERT(DATE, :WS-ACTION-DATE) ) )  
                  )                                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*           DATE(:WS-ACTION-DATE) + :WS-ADJ-DAY DAYS                      
MFA-TR*       INTO                                                              
MFA-TR*           :WS-WORK-DATE                                                 
MFA-TR*       FROM                                                              
MFA-TR*           SYSIBM.SYSDUMMY1                                              
MFA-TR*       WHERE                                                             
MFA-TR*           DAYS(DATE(:WS-ACTION-DATE) + :WS-ADJ-DAY DAYS) -              
MFA-TR*           (INTEGER(DAYS(DATE(:WS-ACTION-DATE)                           
MFA-TR*                  + :WS-ADJ-DAY DAYS) / 7) * 7) BETWEEN 1 AND 5          
MFA-TR*       AND NOT EXISTS                                                    
MFA-TR*           (SELECT                                                       
MFA-TR*                HOLIDAY_DT                                               
MFA-TR*            FROM                                                         
MFA-TR*                CSS_HOLIDAY                                              
MFA-TR*            WHERE                                                        
MFA-TR*                COMPANY_NO = :WS-COMPANY-NO                              
MFA-TR*            AND HOLIDAY_DT =                                             
MFA-TR*                       DATE(:WS-ACTION-DATE) + :WS-ADJ-DAY DAYS          
MFA-TR*           )                                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'ACTION-DATE'         TO TABLE-ELEMENT-1             
              MOVE WS-ACTION-DATE        TO HOSTVAR-ELEMENT-1           
              MOVE 'ADJ-BY'              TO TABLE-ELEMENT-2             
              MOVE WS-ADJ-DAY            TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT                            
                                         THRU 9000-EXIT                 
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                         THRU 9900-EXIT                 
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7040-SELECT-LAST-RUN-DT.                                       *        
      ******************************************************************        
       7040-SELECT-LAST-RUN-DT.                                         
      *                                                                         
            EXEC SQL                                                    
                SELECT TOP(1) PARM_DATA                                         
                INTO                                                    
                     :WS-PARM-DATA                                      
                FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
                WHERE                                                   
                    PROGRAM_NAME = 'PCSCA206'                           
                AND COMPANY_NO   = :WS-COMPANY-NO                       
                AND CMND_CODE    = 'PARM'                               
                AND STATUS       = 'A'                                  
                AND SEQ_NO       = :WS-SEQ-NO                           
                                           
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*              PARM_DATA                                                  
MFA-TR*         INTO                                                            
MFA-TR*              :WS-PARM-DATA                                              
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*         WHERE                                                           
MFA-TR*             PROGRAM_NAME = 'PCSCA206'                                   
MFA-TR*         AND COMPANY_NO   = :WS-COMPANY-NO                               
MFA-TR*         AND CMND_CODE    = 'PARM'                                       
MFA-TR*         AND STATUS       = 'A'                                          
MFA-TR*         AND SEQ_NO       = :WS-SEQ-NO                                   
MFA-TR*         FETCH FIRST 1 ROW ONLY WITH UR                                  
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
                MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE             
                MOVE PROGRAM-NAME          TO ABEND-PROGRAM             
                MOVE '7040'                TO ACTIVE-PARAGRAPH          
                MOVE 'SELECT'              TO ABEND-FUNCTION            
                MOVE SPACES                TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                MOVE 'CSS_JOB_PARM'        TO TABLE-1                   
                MOVE 'PROGRAM_NAME'        TO TABLE-ELEMENT-1           
                MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2           
                MOVE 'SEQ-NO'              TO TABLE-ELEMENT-3           
                MOVE 'PCSCA206'            TO HOSTVAR-ELEMENT-1         
                MOVE WS-COMPANY-NO         TO HOSTVAR-ELEMENT-2         
                MOVE WS-SEQ-NO             TO HOSTVAR-ELEMENT-3         
                PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT         
                PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT         
            END-IF.                                                     
                                                                        
       7040-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *   7050-GET-REG-GROUP.                                          *        
      *                                                                *        
      *   THIS PARAGRAPH IS USED TO GET THE REG-GROUP-CD FROM          *        
      *   CSS_REG_PROFILE.                                             *        
      ******************************************************************        
       7050-GET-REG-GROUP.                                              
                                                                        
           MOVE '7050'         TO ACTIVE-PARAGRAPH.                     
                                                                        
           EXEC SQL                                                     
               SELECT REG_GROUP_CD                                      
               INTO  :LR-REG-GROUP-CD                                   
               FROM  CSS_REG_PROFILE                                    
              WHERE  ACCOUNT_NO     = :AT-ACCOUNT-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                  CONTINUE                                              
              WHEN NOT-FOUND                                            
                  MOVE SPACES            TO LR-REG-GROUP-CD             
              WHEN OTHER                                                
                  MOVE PROGRAM-NAME      TO ABEND-PROGRAM               
                  MOVE 'SELECT'          TO ABEND-FUNCTION              
                  MOVE 'CSS_REG_PROFILE  ' TO TABLE-1                   
                  MOVE 'ACCOUNT_NO  '    TO TABLE-ELEMENT-1             
                  MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1           
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
           END-EVALUATE.                                                
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   7060-SELECT-FW-PATH.                                                  
      *                                                                *        
      *   THIS PARAGRAPH IS USED TO GET THE FW-PATH-TYPE-CD FROM       *        
      *   CSS_FW_FCST_OPTION.                                          *        
      ******************************************************************        
       7060-SELECT-FW-PATH.                                             
                                                                        
           MOVE '7060'         TO ACTIVE-PARAGRAPH.                     
                                                                        
           EXEC SQL                                                     
               SELECT FW_PATH_TYPE_CD                                   
               INTO  :KA-FW-PATH-TYPE-CD                                
               FROM  CSS_FW_FCST_OPTION                                 
              WHERE COMPANY_NO          =:KA-COMPANY-NO                 
                AND REG_GROUP_CD        =:KA-REG-GROUP-CD               
                AND CODE_STATUS_REASON  =:KA-CODE-STATUS-REASON         
                AND BHV_SCORE_RATING    =:KA-BHV-SCORE-RATING           
                AND FW_ACCT_TYPE_CD     =:KA-FW-ACCT-TYPE-CD            
                AND GUARANTEED_IND      =:KA-GUARANTEED-IND             
                AND EFFECTIVE_DT        <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                 
                AND EXPIRATION_DT       >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FW_PATH_TYPE_CD                                           
MFA-TR*        INTO  :KA-FW-PATH-TYPE-CD                                        
MFA-TR*        FROM  CSS_FW_FCST_OPTION                                         
MFA-TR*       WHERE COMPANY_NO          =:KA-COMPANY-NO                         
MFA-TR*         AND REG_GROUP_CD        =:KA-REG-GROUP-CD                       
MFA-TR*         AND CODE_STATUS_REASON  =:KA-CODE-STATUS-REASON                 
MFA-TR*         AND BHV_SCORE_RATING    =:KA-BHV-SCORE-RATING                   
MFA-TR*         AND FW_ACCT_TYPE_CD     =:KA-FW-ACCT-TYPE-CD                    
MFA-TR*         AND GUARANTEED_IND      =:KA-GUARANTEED-IND                     
MFA-TR*         AND EFFECTIVE_DT        <= CURRENT DATE                         
MFA-TR*         AND EXPIRATION_DT       >= CURRENT DATE                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              OR NOT-FOUND                                              
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_FW_FCST_OPTION'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO  '        TO TABLE-ELEMENT-1             
              MOVE 'CODE_STATUS_REASON'  TO TABLE-ELEMENT-2             
              MOVE 'BHV_SCORE_RATING'    TO TABLE-ELEMENT-3             
              MOVE 'FW_ACCT_TYPE_CD'     TO TABLE-ELEMENT-4             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE KA-CODE-STATUS-REASON TO HOSTVAR-ELEMENT-2           
              MOVE KA-BHV-SCORE-RATING   TO HOSTVAR-ELEMENT-3           
              MOVE KA-FW-ACCT-TYPE-CD    TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
C30169 7060-EXIT.                                                       
C30169     EXIT.                                                        
      ******************************************************************        
      *   7100-SELECT-AT-ROW.                                          *        
      *                                                                *        
      *   THIS PARAGRAPH IS USED TO OBTAIN THE SELECTED ROW FROM THE   *        
      *   CSS_ACCOUNT TABLE                                            *        
      ******************************************************************        
       7100-SELECT-AT-ROW.                                              
                                                                        
           MOVE '7100'         TO ACTIVE-PARAGRAPH.                     
                                                                        
           EXEC SQL                                                     
               SELECT BNKRPT_CASE_NO,                                   
                      BANKRUPTCY_IND                                    
                     ,CODE_ACCT_STAT                                    
                     ,COMPANY_NO                                        
                     ,CODE_STATUS_REASON                                
                     ,CREDIT_GROUP                                      
                     ,PREMISE_NO                                        
                     ,CUSTOMER_NO                                       
                     ,LOCAL_OFFICE                                      
               INTO  :AT-BNKRPT-CASE-NO,                                
                     :AT-BANKRUPTCY-IND,                                
                     :AT-CODE-ACCT-STAT,                                
                     :AT-COMPANY-NO,                                    
                     :AT-CODE-STATUS-REASON,                            
                     :AT-CREDIT-GROUP,                                  
                     :AT-PREMISE-NO,                                    
                     :AT-CUSTOMER-NO,                                   
                     :AT-LOCAL-OFFICE                                   
               FROM  CSS_ACCOUNT                                        
              WHERE  ACCOUNT_NO     = :AT-ACCOUNT-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              OR NOT-FOUND                                              
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCOUNT      '   TO TABLE-1                     
              MOVE 'ACCOUNT_NO  '        TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7100-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
                                                                        
      ******************************************************************        
      *   7150-SELECT-AT-ROW.                                          *        
      *                                                                *        
      *   THIS PARAGRAPH IS USED TO OBTAIN THE SELECTED ROW FROM THE   *        
      *   CSS_ACCOUNT TABLE                                            *        
      ******************************************************************        
       7150-SELECT-AT-ROW.                                              
                                                                        
           MOVE '7150'         TO ACTIVE-PARAGRAPH.                     
                                                                        
           EXEC SQL                                                     
               SELECT CODES_DATA_PRESENT,                               
                      COMPANY_NO                                        
               INTO  :AT-CODES-DATA-PRESENT                             
                    ,:AT-COMPANY-NO                                     
               FROM  CSS_ACCOUNT                                        
              WHERE  ACCOUNT_NO  = :AT-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              OR NOT-FOUND                                              
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT '             TO ABEND-FUNCTION              
              MOVE 'CSS_ACCOUNT      '   TO TABLE-1                     
              MOVE 'ACCOUNT_NO  '        TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7150-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
                                                                        
      ******************************************************************        
      *  OPEN THE CURSOR DECLARED FOR CSS_ACCOUNT TABLE                *        
      ******************************************************************        
       7200-OPEN-AT-CASE-CRSR.                                          
                                                                        
           MOVE '7200'         TO ACTIVE-PARAGRAPH.                     
                                                                        
           EXEC SQL                                                     
               OPEN AT-CASE-NO-CRSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
             ELSE                                                       
               MOVE 'CSR04908'              TO ABEND-PROGRAM            
               MOVE '7200'                  TO ACTIVE-PARAGRAPH         
               MOVE 'OPEN'                  TO ABEND-FUNCTION           
               MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
               MOVE 'BNKRPT_CASE_NO'        TO TABLE-ELEMENT-1          
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-2          
               MOVE AT-BNKRPT-CASE-NO       TO HOSTVAR-ELEMENT-1        
               MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  FETCH THE CURSOR DECLARED FOR CSS_CUST_PLAN    TABLE.         *        
      ******************************************************************        
       7210-FETCH-AT-CASE-CRSR.                                         
                                                                        
           MOVE '7210'   TO ACTIVE-PARAGRAPH.                           
                                                                        
           EXEC SQL                                                     
               FETCH AT-CASE-NO-CRSR                                    
               INTO :AT-ACCOUNT-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
                                          NOT-FOUND                     
                 NEXT SENTENCE                                          
             ELSE                                                       
               MOVE 'CSR04908'              TO ABEND-PROGRAM            
               MOVE '7210'                  TO ACTIVE-PARAGRAPH         
               MOVE 'FETCH'                 TO ABEND-FUNCTION           
               MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
               MOVE 'BNKRPT_CASE_NO'        TO TABLE-ELEMENT-1          
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-2          
               MOVE AT-BNKRPT-CASE-NO       TO HOSTVAR-ELEMENT-1        
               MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *  CLOSE THE CURSOR DECLARED FOR CSS_CUST_PLAN TABLE.            *        
      ******************************************************************        
       7220-CLOSE-AT-CASE-CRSR.                                         
                                                                        
           MOVE '7220'  TO ACTIVE-PARAGRAPH.                            
                                                                        
           EXEC SQL                                                     
               CLOSE AT-CASE-NO-CRSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
             ELSE                                                       
               MOVE 'CSR04908'              TO ABEND-PROGRAM            
               MOVE '7220'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CLOSE'                 TO ABEND-FUNCTION           
               MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
               MOVE 'BNKRPT_CASE_NO'        TO TABLE-ELEMENT-1          
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-2          
               MOVE AT-BNKRPT-CASE-NO       TO HOSTVAR-ELEMENT-1        
               MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*EJECT                                                                    
      *                                                                         
       7250-SELECT-ACTION-DESC.                                         
      *                                                                         
           MOVE '7250'                      TO ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
               SELECT                                                   
                   FW_ATTR_VALUE_DESC                                   
               INTO                                                     
                   :KV-FW-ATTR-VALUE-DESC                               
               FROM                                                     
                   CSS_FW_ATTRIB_DESC                                   
               WHERE                                                    
                   FW_ATTRIB_TYPE_CD   = :KV-FW-ATTRIB-TYPE-CD          
               AND FW_ATTR_VALUE_CD    = :KV-FW-ATTR-VALUE-CD           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_FW_ATTRIB_DESC'     TO TABLE-1                  
              MOVE 'FW_ATTRIB_TYPE_CD'      TO TABLE-ELEMENT-1          
              MOVE 'FW_ATTR_VALUE_CD'       TO TABLE-ELEMENT-2          
              MOVE KV-FW-ATTRIB-TYPE-CD     TO HOSTVAR-ELEMENT-1        
              MOVE KV-FW-ATTR-VALUE-CD      TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   7300-SELECT-BQ-ROW.                                          *        
      *                                                                *        
      *   THIS PARAGRAPH IS USED TO OBTAIN THE SELECTED ROW FROM THE   *        
      *   CSS_BANKRUPTCY TABLE                                         *        
      ******************************************************************        
       7300-SELECT-BQ-ROW.                                              
           MOVE '7300'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
               SELECT  FILED_CASE_NO,                                   
                     BANKRUPTCY_CHAPTER,                                
                     DATE_BNKRPT_FILED,                                 
                     RECEIVED_DATE                                      
               INTO  :BQ-FILED-CASE-NO,                                 
                     :BQ-BANKRUPTCY-CHAPTER,                            
                     :BQ-DATE-BNKRPT-FILED :WS-NULL-IND3,                
                     :BQ-RECEIVED-DATE :WS-NULL-IND4                     
               FROM  CSS_BANKRUPTCY                                     
              WHERE  BNKRPT_CASE_NO = :BQ-BNKRPT-CASE-NO                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_BANKRUPTCY'      TO TABLE-1                     
              MOVE 'BANKRPT_CASE_NO'     TO TABLE-ELEMENT-1             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE BQ-BNKRPT-CASE-NO     TO HOSTVAR-ELEMENT-1           
              MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7300-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *   7350-SELECT-BQ-ROW.                                          *        
      *                                                                *        
      *   THIS PARAGRAPH IS USED TO OBTAIN THE SELECTED ROW FROM THE   *        
      *   CSS_BANKRUPTCY TABLE                                         *        
      ******************************************************************        
       7350-SELECT-BQ-ROW.                                              
           MOVE '7350'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
              SELECT BNKRPT_CASE_NO                                     
               INTO  :BQ-BNKRPT-CASE-NO                                 
               FROM  CSS_BANKRUPTCY                                     
              WHERE FILED_CASE_NO = :BQ-FILED-CASE-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                       OR NOT-FOUND                     
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_BANKRUPTCY'      TO TABLE-1                     
              MOVE 'FILED_CASE_NO'       TO TABLE-ELEMENT-1             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE BQ-FILED-CASE-NO      TO HOSTVAR-ELEMENT-1           
              MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7350-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
      *                                                                         
      ******************************************************************        
      *   7400-SELECT-BQ-MAX.                                          *        
      *                                                                *        
      *   THIS PARAGRAPH IS USED TO OBTAIN THE SELECTED ROW FROM THE   *        
      *   CSS_BANKRUPTCY TABLE                                         *        
      ******************************************************************        
       7400-SELECT-BQ-MAX.                                              
           MOVE '7400'     TO ACTIVE-PARAGRAPH.                         
                                                                        
           EXEC SQL                                                     
               SELECT  MAX(BNKRPT_CASE_NO)                              
               INTO  :WS-MAX-CASE-NO :WS-MAX-CASE-IND                   
               FROM  CSS_BANKRUPTCY                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                             OR NOT-FOUND               
              IF WS-MAX-CASE-IND EQUAL -1                               
                 MOVE SPACES TO WS-MAX-CASE-NO                          
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_BANKRUPTCY'      TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7400-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
      ******************************************************************        
      * 7410-SELECT-CREDIT-PROFILE.                                    *        
      ******************************************************************        
       7410-SELECT-CREDIT-PROFILE.                                      
           EXEC SQL                                                     
               SELECT BHV_RATING_HIST                                   
                 INTO :CZ-BHV-RATING-HIST                               
                 FROM CSS_CREDIT_PROFILE                                
                WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE  TO S-RETURN-CODE             
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7410'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
               MOVE 'CSS_CREDIT_PROFILE'   TO TABLE-1                   
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
               MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7510-CHK-ACCT-ATTRIBUTE.                                       *        
      ******************************************************************        
       7510-CHK-ACCT-ATTRIBUTE.                                         
           MOVE 'N' TO WS-EXISTS-FL.                                    
           MOVE 'N' TO WS-ROW-EXISTS-FL.                                
           INITIALIZE YP-ATTRIBUTE-VALUE-CD.                            
           EXEC SQL                                                     
               SELECT ATTRIBUTE_VALUE_CD                                
                     ,'Y'                                               
                 INTO :YP-ATTRIBUTE-VALUE-CD                            
                     ,:WS-ROW-EXISTS-FL                                 
                 FROM CSS_ACCT_ATTRIBUTE                                
                WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                   
                  AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
           EVALUATE WS-ACTIVE-RETURN-CODE                               
           WHEN SUCCESSFUL-CALL                                         
               IF YP-ATTRIBUTE-VALUE-CD > SPACES                        
                  MOVE 'Y' TO WS-EXISTS-FL                              
               END-IF                                                   
           WHEN NOT-FOUND                                               
               CONTINUE                                                 
           WHEN OTHER                                                   
               MOVE WS-ACTIVE-RETURN-CODE  TO S-RETURN-CODE             
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7510'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
               MOVE 'CSS_ACCT_ATTRIBUTE'   TO TABLE-1                   
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
               MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
               MOVE 'ATTRIBUTE_DESC'       TO TABLE-ELEMENT-2           
               MOVE YP-ATTRIBUTE-DESC      TO HOSTVAR-ELEMENT-2         
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-EVALUATE.                                                
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7670-SEL-FINAL-WO.                                             *        
      ******************************************************************        
       7670-SELECT-FINAL-WO.                                            
      *                                                                         
           EXEC SQL                                                     
               SELECT FW.COLLECT_STATUS_CD                              
                     ,FW.GUARANTEED_IND                                 
                 INTO :FW-COLLECT-STATUS-CD                             
                     ,:FW-GUARANTEED-IND                                
                 FROM CSS_FINAL_WO FW                                   
                WHERE FW.ACCOUNT_NO = :AT-ACCOUNT-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7670'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'CSS_FINAL_WO'              TO TABLE-1               
              MOVE 'ACCOUNT_NO'                TO TABLE-ELEMENT-1       
              MOVE AT-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1     
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7670-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7680-SEL-CA-WITHDRAW-DATE.                                     *        
      ******************************************************************        
       7680-SEL-CA-WITHDRAW-DATE.                                       
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) FW_COLL_SEQ_NO,
              COALESCE(WITHDRAW_DT,IIF(TRY_CONVERT(DATE, '1900-01-01'
              ) IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )),
              WITHDRAW_AM,
              WITHDRAW_REASON_CD                                 
                INTO :IZ-FW-COLL-SEQ-NO                                 
                    ,:IZ-WITHDRAW-DT                                    
                    ,:IZ-WITHDRAW-AM                                    
                    ,:IZ-WITHDRAW-REASON-CD                             
                FROM CSS_FIN_WO_COLLECT WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                 
                 AND FW_ACTION_TYPE_CD = :WS-ACTN-TYPE-CD               
                 AND(WITHDRAW_DT       > IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )               
                  OR WITHDRAW_DT IS NULL)                               
                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FW_COLL_SEQ_NO                                             
MFA-TR*             ,IFNULL(WITHDRAW_DT,'1900-01-01')                           
MFA-TR*             ,WITHDRAW_AM                                                
MFA-TR*             ,WITHDRAW_REASON_CD                                         
MFA-TR*         INTO :IZ-FW-COLL-SEQ-NO                                         
MFA-TR*             ,:IZ-WITHDRAW-DT                                            
MFA-TR*             ,:IZ-WITHDRAW-AM                                            
MFA-TR*             ,:IZ-WITHDRAW-REASON-CD                                     
MFA-TR*         FROM CSS_FIN_WO_COLLECT                                         
MFA-TR*        WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                         
MFA-TR*          AND FW_ACTION_TYPE_CD = :WS-ACTN-TYPE-CD                       
MFA-TR*          AND(WITHDRAW_DT       > :WS-CURRENT-DATE                       
MFA-TR*           OR WITHDRAW_DT IS NULL)                                       
MFA-TR*         FETCH FIRST 1 ROW ONLY WITH UR                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE  =  SUCCESSFUL-CALL OR NOT-FOUND    
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7680'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'CSS_FIN_WO_COLLECT'        TO TABLE-1               
              MOVE 'ACCOUNT_NO'                TO TABLE-ELEMENT-1       
              MOVE AT-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1     
              MOVE 'FW_ACTION_TYPE_CD'         TO TABLE-ELEMENT-2       
              MOVE WS-ACTN-TYPE-CD             TO HOSTVAR-ELEMENT-2     
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7680-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7690-SEL-CB-DATE.                                              *        
      ******************************************************************        
       7690-SEL-CB-DATE.                                                
                                                                        
           EXEC SQL                                                     
              SELECT MAX(FW_ACTION_DT)                                  
                INTO :WS-CB-ACTION-DATE                                 
                FROM CSS_FIN_WO_ACTION                                  
               WHERE ACCOUNT_NO        =:AT-ACCOUNT-NO                  
                 AND FW_ACTION_TYPE_CD = 'CREDB'                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7690'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'CSS_FIN_WO_COLLECT'        TO TABLE-1               
              MOVE 'ACCOUNT_NO'                TO TABLE-ELEMENT-1       
              MOVE AT-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1     
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7690-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7700-GET-WO-BAL.                                               *        
      ******************************************************************        
       7700-GET-WO-BAL.                                                 
                                                                        
           EXEC SQL                                                     
              SELECT SUM(AMT_TRANS)                                     
                INTO :WS-WO-BAL                                         
                FROM CSS_CHRG_OFF                                       
               WHERE ACCOUNT_NO        =:AT-ACCOUNT-NO                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7700'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE 'CSS_CHRG_OFF'              TO TABLE-1               
              MOVE 'ACCOUNT_NO'                TO TABLE-ELEMENT-1       
              MOVE AT-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1     
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7750-RETRIEVE-DEL.                                             *        
      * SELECTS VALUES FROM CSS_DELINQUENCY.                           *        
      ******************************************************************        
                                                                        
       7750-GET-DEL-VALUES.                                             
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = :C8-DELINQ-CD                          
                 AND COMPANY_NO = :AT-COMPANY-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*          AND COMPANY_NO = :AT-COMPANY-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7750                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '7750'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
              MOVE 'C8-DELINQ-CD'             TO TABLE-ELEMENT-1        
              MOVE C8-DELINQ-CD               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7750-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *                                                              *          
      * 8060-UPDATE-FIN-WO. UPDATES PATB TYPE CD                     *          
      *                                                              *          
      ****************************************************************          
       8060-UPDATE-FIN-WO.                                              
           MOVE '8060'     TO ACTIVE-PARAGRAPH.                         
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_FINAL_WO                                        
             SET FW_PATH_TYPE_CD    = :FW-FW-PATH-TYPE-CD               
             WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE 'UPDATE'               TO ABEND-FUNCTION             
              MOVE 'CSS_FINAL_WO'         TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              MOVE 'FW_PATH_TYPE_CD'      TO TABLE-ELEMENT-2            
              MOVE FW-FW-PATH-TYPE-CD     TO HOSTVAR-ELEMENT-2          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8060-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      *                                                              *          
      * 8200-UPDATE-CASE UPDATES CASE RELATED INFORMATION            *          
      *                                                              *          
      ****************************************************************          
       8200-UPDATE-CASE.                                                
                                                                        
           MOVE '8200'     TO ACTIVE-PARAGRAPH.                         
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_BANKRUPTCY                                      
             SET BANKRUPTCY_CHAPTER = :BQ-BANKRUPTCY-CHAPTER,           
                 DATE_BNKRPT_FILED  = IIF(TRY_CONVERT(DATE, 
                                                 :BQ-DATE-BNKRPT-FILED 
                                                            :WS-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :BQ-DATE-BNKRPT-FILED 
                                                           :WS-NULL-IND
              ) <> 0) OR (LEN(:BQ-DATE-BNKRPT-FILED :WS-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:BQ-DATE-BNKRPT-FILED 
                                                           :WS-NULL-IND
              ), CONVERT(DATE, :BQ-DATE-BNKRPT-FILED :WS-NULL-IND) ),
                 RECEIVED_DATE      = IIF(TRY_CONVERT(DATE, 
                                                     :BQ-RECEIVED-DATE 
                                                          :WS-NULL-IND2
              ) IS NULL OR (PATINDEX('%.%', :BQ-RECEIVED-DATE 
                                                          :WS-NULL-IND2
              ) <> 0) OR (LEN(:BQ-RECEIVED-DATE :WS-NULL-IND2
              ) <> 10), CIS.CHAR2DATE(:BQ-RECEIVED-DATE :WS-NULL-IND2
              ), CONVERT(DATE, :BQ-RECEIVED-DATE :WS-NULL-IND2) ),   
                 FILED_CASE_NO      = :BQ-FILED-CASE-NO                 
             WHERE BNKRPT_CASE_NO   = :BQ-BNKRPT-CASE-NO                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_BANKRUPTCY                                              
MFA-TR*      SET BANKRUPTCY_CHAPTER = :BQ-BANKRUPTCY-CHAPTER,                   
MFA-TR*          DATE_BNKRPT_FILED  = :BQ-DATE-BNKRPT-FILED:WS-NULL-IND,        
MFA-TR*          RECEIVED_DATE      = :BQ-RECEIVED-DATE:WS-NULL-IND2,           
MFA-TR*          FILED_CASE_NO      = :BQ-FILED-CASE-NO                         
MFA-TR*      WHERE BNKRPT_CASE_NO   = :BQ-BNKRPT-CASE-NO                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE 'UPDATE'               TO ABEND-FUNCTION             
              MOVE 'CSS_BANKRUPTCY'       TO TABLE-1                    
              MOVE 'BNKRPT_CASE_NO'       TO TABLE-ELEMENT-1            
              MOVE 'BANKRUPTCY_CHAPTER'   TO TABLE-ELEMENT-2            
              MOVE 'DATE_BNKRPT_FILED'    TO TABLE-ELEMENT-3            
              MOVE 'RECEIVED_DATE'        TO TABLE-ELEMENT-4            
              MOVE BQ-BNKRPT-CASE-NO      TO HOSTVAR-ELEMENT-1          
              MOVE BQ-BANKRUPTCY-CHAPTER  TO HOSTVAR-ELEMENT-2          
              MOVE BQ-DATE-BNKRPT-FILED   TO HOSTVAR-ELEMENT-3          
              MOVE BQ-RECEIVED-DATE       TO HOSTVAR-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      * 8220-UPDATE-AT                                                          
      ****************************************************************          
       8220-UPDATE-AT.                                                  
                                                                        
           MOVE '8220'     TO ACTIVE-PARAGRAPH.                         
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
               SET BANKRUPTCY_IND  = :AT-BANKRUPTCY-IND,                
                   BNKRPT_CASE_NO  = :AT-BNKRPT-CASE-NO,                
                   CODE_PERM_BILL  = :AT-CODE-PERM-BILL                 
                  ,CODE_STATUS_REASON = :AT-CODE-STATUS-REASON          
               WHERE ACCOUNT_NO    = :AT-ACCOUNT-NO                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO   ABEND-PROGRAM         
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'BANKRUPTCY_IND'          TO TABLE-ELEMENT-2         
              MOVE 'BNKRPT_CASE_NO'          TO TABLE-ELEMENT-3         
              MOVE 'CODE_PERM_BILL'          TO TABLE-ELEMENT-4         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AT-BANKRUPTCY-IND         TO HOSTVAR-ELEMENT-2       
              MOVE AT-BNKRPT-CASE-NO         TO HOSTVAR-ELEMENT-3       
              MOVE AT-CODE-PERM-BILL         TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8220-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      * 8225-UPDATE-AT                                                          
      ****************************************************************          
       8225-UPDATE-AT.                                                  
                                                                        
           MOVE '8225'     TO ACTIVE-PARAGRAPH.                         
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
               SET BNKRPT_CASE_NO  = :WS-BQ-BNKRPT-CASE-NO              
               WHERE BNKRPT_CASE_NO  = :AT-BNKRPT-CASE-NO               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO   ABEND-PROGRAM         
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'BNKRPT_CASE_NO'          TO TABLE-ELEMENT-1         
              MOVE 'BNKRPT_CASE_NO'          TO TABLE-ELEMENT-2         
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-3         
              MOVE AT-BNKRPT-CASE-NO         TO HOSTVAR-ELEMENT-1       
              MOVE WS-BQ-BNKRPT-CASE-NO      TO HOSTVAR-ELEMENT-2       
              MOVE PARM-ACCOUNT-NO           TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8225-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      * 8250-INSERT-ROWS INSERTS ROW IN THE HISTORY TABLE            *          
      ****************************************************************          
       8250-INSERT-BQ.                                                  
           MOVE '8250'     TO ACTIVE-PARAGRAPH.                         
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_BANKRUPTCY                               
                 (BNKRPT_CASE_NO,                                       
                  FILED_CASE_NO,                                        
                  DATE_BNKRPT_FILED,                                    
                  USER_ID_INIT_BY,                                      
                  RECEIVED_DATE,                                        
                  BANKRUPTCY_CHAPTER)                                   
              VALUES (:BQ-BNKRPT-CASE-NO,                               
                      :BQ-FILED-CASE-NO,                                
                      IIF(TRY_CONVERT(DATE, :BQ-DATE-BNKRPT-FILED 
                                            :WS-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :BQ-DATE-BNKRPT-FILED 
                                                           :WS-NULL-IND
              ) <> 0) OR (LEN(:BQ-DATE-BNKRPT-FILED :WS-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:BQ-DATE-BNKRPT-FILED 
                                                           :WS-NULL-IND
              ), CONVERT(DATE, :BQ-DATE-BNKRPT-FILED :WS-NULL-IND) ),          
                      :BQ-USER-ID-INIT-BY :WS-NULL-IND2,                 
                      IIF(TRY_CONVERT(DATE, :BQ-RECEIVED-DATE
              ) IS NULL OR (PATINDEX('%.%', :BQ-RECEIVED-DATE
              ) <> 0) OR (LEN(:BQ-RECEIVED-DATE) <> 10), CIS.CHAR2DATE(
                                                      :BQ-RECEIVED-DATE
              ), CONVERT(DATE, :BQ-RECEIVED-DATE) ),                           
                      :BQ-BANKRUPTCY-CHAPTER)                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_BANKRUPTCY                                       
MFA-TR*          (BNKRPT_CASE_NO,                                               
MFA-TR*           FILED_CASE_NO,                                                
MFA-TR*           DATE_BNKRPT_FILED,                                            
MFA-TR*           USER_ID_INIT_BY,                                              
MFA-TR*           RECEIVED_DATE,                                                
MFA-TR*           BANKRUPTCY_CHAPTER)                                           
MFA-TR*       VALUES (:BQ-BNKRPT-CASE-NO,                                       
MFA-TR*               :BQ-FILED-CASE-NO,                                        
MFA-TR*               :BQ-DATE-BNKRPT-FILED:WS-NULL-IND,                        
MFA-TR*               :BQ-USER-ID-INIT-BY:WS-NULL-IND2,                         
MFA-TR*               :BQ-RECEIVED-DATE,                                        
MFA-TR*               :BQ-BANKRUPTCY-CHAPTER)                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE 'INSERT'               TO ABEND-FUNCTION            
               MOVE 'CSS_BANKRUPTCY'       TO TABLE-1                   
               MOVE 'BNKRPT_CASE_NO'       TO TABLE-ELEMENT-1           
               MOVE 'USER_ID_INIT_BY'      TO TABLE-ELEMENT-2           
               MOVE 'RECEIVED_DATE'        TO TABLE-ELEMENT-3           
               MOVE 'DATE_BNKRPT_FILED'    TO TABLE-ELEMENT-4           
               MOVE BQ-BNKRPT-CASE-NO      TO HOSTVAR-ELEMENT-1         
               MOVE BQ-USER-ID-INIT-BY     TO HOSTVAR-ELEMENT-2         
               MOVE BQ-RECEIVED-DATE       TO HOSTVAR-ELEMENT-3         
               MOVE BQ-DATE-BNKRPT-FILED   TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       8250-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8300-DELETE-FUT-PLMTS.                                         *        
      ******************************************************************        
       8300-DELETE-FUT-PLMTS.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_FIN_WO_ACTION                             
               WHERE ACCOUNT_NO        = :KD-ACCOUNT-NO                 
                 AND FW_ACTION_DT      > IIF(TRY_CONVERT(DATE, 
                                                       :KD-FW-ACTION-DT
              ) IS NULL OR (PATINDEX('%.%', :KD-FW-ACTION-DT
              ) <> 0) OR (LEN(:KD-FW-ACTION-DT) <> 10), CIS.CHAR2DATE(
                                                       :KD-FW-ACTION-DT
              ), CONVERT(DATE, :KD-FW-ACTION-DT) )               
                 AND FW_ACTION_AM      = 0                              
                 AND FW_ACTION_TYPE_CD IN ('1PLMT',                     
                                           '2PLMT',                     
                                           '3PLMT',                     
                                           'ATY',                       
                                           'SAL',                       
                                           'CREDB')                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_FIN_WO_ACTION                                     
MFA-TR*        WHERE ACCOUNT_NO        = :KD-ACCOUNT-NO                         
MFA-TR*          AND FW_ACTION_DT      > :KD-FW-ACTION-DT                       
MFA-TR*          AND FW_ACTION_AM      = 0                                      
MFA-TR*          AND FW_ACTION_TYPE_CD IN ('1PLMT',                             
MFA-TR*                                    '2PLMT',                             
MFA-TR*                                    '3PLMT',                             
MFA-TR*                                    'ATY',                               
MFA-TR*                                    'SAL',                               
MFA-TR*                                    'CREDB')                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'DELETE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_FIN_WO_ACTION'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE KD-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'FW_ACTION_DT'             TO TABLE-ELEMENT-2        
              MOVE KD-FW-ACTION-DT            TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8310-DELETE-FUT-ACTION.                                        *        
      ******************************************************************        
       8310-DELETE-FUT-ACTION.                                          
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_FIN_WO_ACTION                             
               WHERE ACCOUNT_NO        =  :AT-ACCOUNT-NO                
                 AND FW_ACTION_DT      >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )              
                 AND FW_ACTION_TYPE_CD <> 'WO'                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_FIN_WO_ACTION                                     
MFA-TR*        WHERE ACCOUNT_NO        =  :AT-ACCOUNT-NO                        
MFA-TR*          AND FW_ACTION_DT      >= :WS-CURRENT-DATE                      
MFA-TR*          AND FW_ACTION_TYPE_CD <> 'WO'                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8310'                     TO ACTIVE-PARAGRAPH       
              MOVE 'DELETE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_FIN_WO_ACTION'        TO TABLE-1                
              MOVE 'ACCOUNT-NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'FW_ACTION_DT'             TO TABLE-ELEMENT-2        
              MOVE WS-CURRENT-DATE            TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 8350-DELETE-ROWS DELETES A ROW FROM THE BANKRUPTCY TABLE.    *          
      ****************************************************************          
       8350-DELETE-BQ.                                                  
                                                                        
           MOVE '8350'     TO ACTIVE-PARAGRAPH.                         
                                                                        
           EXEC SQL                                                     
               DELETE  FROM CSS_BANKRUPTCY                              
               WHERE  BNKRPT_CASE_NO = :BQ-BNKRPT-CASE-NO               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                             OR NOT-FOUND               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO   ABEND-PROGRAM         
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_BANKRUPTCY'          TO TABLE-1                 
              MOVE 'BNKRPT_CASE_NO'          TO TABLE-ELEMENT-1         
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2         
              MOVE BQ-BNKRPT-CASE-NO         TO HOSTVAR-ELEMENT-1       
              MOVE PARM-ACCOUNT-NO           TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
       8350-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8400-UPD-FIN-WO-ACTION.                                        *        
      ******************************************************************        
       8400-UPD-FIN-WO-ACTION.                                          
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_FIN_WO_ACTION                                 
                  SET FW_ACTION_DT      = IIF(TRY_CONVERT(DATE, 
                                                       :KD-FW-ACTION-DT
              ) IS NULL OR (PATINDEX('%.%', :KD-FW-ACTION-DT
              ) <> 0) OR (LEN(:KD-FW-ACTION-DT) <> 10), CIS.CHAR2DATE(
                                                       :KD-FW-ACTION-DT
              ), CONVERT(DATE, :KD-FW-ACTION-DT) )              
                WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                
                  AND FW_ACTION_TYPE_CD = 'WO'                          
                  AND FW_ACTION_AM = 0                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_FIN_WO_ACTION                                         
MFA-TR*           SET FW_ACTION_DT      = :KD-FW-ACTION-DT                      
MFA-TR*         WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                        
MFA-TR*           AND FW_ACTION_TYPE_CD = 'WO'                                  
MFA-TR*           AND FW_ACTION_AM = 0                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '8400'                      TO ACTIVE-PARAGRAPH      
              MOVE 'UPDATE'                    TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'CSS_FIN_WO_ACTION'         TO TABLE-1               
              MOVE 'ACCOUNT_NO'                TO TABLE-ELEMENT-1       
              MOVE AT-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1     
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8500-UPD-FIN-COLLECT.                                          *        
      ******************************************************************        
       8500-UPD-FIN-COLLECT.                                            
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_FIN_WO_COLLECT                                 
                 SET WITHDRAW_DT         = IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )             
                    ,WITHDRAW_REASON_CD  = 'A'                          
                    ,WITHDRAW_AM         = :IZ-WITHDRAW-AM              
               WHERE ACCOUNT_NO          = :AT-ACCOUNT-NO               
                 AND FW_ACTION_TYPE_CD   = :WS-ACTN-TYPE-CD             
                 AND FW_COLL_SEQ_NO      = :IZ-FW-COLL-SEQ-NO           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_FIN_WO_COLLECT                                         
MFA-TR*          SET WITHDRAW_DT         = :WS-CURRENT-DATE                     
MFA-TR*             ,WITHDRAW_REASON_CD  = 'A'                                  
MFA-TR*             ,WITHDRAW_AM         = :IZ-WITHDRAW-AM                      
MFA-TR*        WHERE ACCOUNT_NO          = :AT-ACCOUNT-NO                       
MFA-TR*          AND FW_ACTION_TYPE_CD   = :WS-ACTN-TYPE-CD                     
MFA-TR*          AND FW_COLL_SEQ_NO      = :IZ-FW-COLL-SEQ-NO                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8500'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_FIN_WO_COLLECT'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'FW_ACTION_TYPE_CD' TO TABLE-ELEMENT-2               
              MOVE WS-ACTN-TYPE-CD     TO HOSTVAR-ELEMENT-2             
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8520-INSERT-ACCT-ATTRIBUTE                                     *        
      ******************************************************************        
       8520-INSERT-ACCT-ATTRIBUTE.                                      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_ACCT_ATTRIBUTE                           
                      (ACCOUNT_NO                                       
                      ,ATTRIBUTE_DESC                                   
                      ,ATTRIBUTE_VALUE_CD                               
                      ,ATTRIBUTE_VALUE_DT                               
                      ,ATTRIBUTE_VALUE_TX)                              
               VALUES (:YP-ACCOUNT-NO                                   
                      ,:YP-ATTRIBUTE-DESC                               
                      ,:YP-ATTRIBUTE-VALUE-CD                           
                      ,IIF(TRY_CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT
              ) IS NULL OR (PATINDEX('%.%', :YP-ATTRIBUTE-VALUE-DT
              ) <> 0) OR (LEN(:YP-ATTRIBUTE-VALUE-DT
              ) <> 10), CIS.CHAR2DATE(:YP-ATTRIBUTE-VALUE-DT
              ), CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT) )                       
                      ,:PARM-TRANS-COMMENT-TEXT)                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_ACCT_ATTRIBUTE                                   
MFA-TR*               (ACCOUNT_NO                                               
MFA-TR*               ,ATTRIBUTE_DESC                                           
MFA-TR*               ,ATTRIBUTE_VALUE_CD                                       
MFA-TR*               ,ATTRIBUTE_VALUE_DT                                       
MFA-TR*               ,ATTRIBUTE_VALUE_TX)                                      
MFA-TR*        VALUES (:YP-ACCOUNT-NO                                           
MFA-TR*               ,:YP-ATTRIBUTE-DESC                                       
MFA-TR*               ,:YP-ATTRIBUTE-VALUE-CD                                   
MFA-TR*               ,:YP-ATTRIBUTE-VALUE-DT                                   
MFA-TR*               ,:PARM-TRANS-COMMENT-TEXT)                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8520'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCT_ATTRIBUTE'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'ATTRIBUTE_DESC'           TO TABLE-ELEMENT-2        
              MOVE 'ATTRIBUTE_VALUE_CD'       TO TABLE-ELEMENT-3        
              MOVE YP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE YP-ATTRIBUTE-DESC          TO HOSTVAR-ELEMENT-2      
              MOVE YP-ATTRIBUTE-VALUE-CD      TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8530-UPDATE-ACCT-ATTRIBUTE                                     *        
      ******************************************************************        
       8530-UPDATE-ACCT-ATTRIBUTE.                                      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCT_ATTRIBUTE                                
                  SET ATTRIBUTE_VALUE_CD = :YP-ATTRIBUTE-VALUE-CD       
                     ,ATTRIBUTE_VALUE_DT = IIF(TRY_CONVERT(DATE, 
                                                 :YP-ATTRIBUTE-VALUE-DT
              ) IS NULL OR (PATINDEX('%.%', :YP-ATTRIBUTE-VALUE-DT
              ) <> 0) OR (LEN(:YP-ATTRIBUTE-VALUE-DT
              ) <> 10), CIS.CHAR2DATE(:YP-ATTRIBUTE-VALUE-DT
              ), CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT) )       
                     ,ATTRIBUTE_VALUE_TX = ' '                          
               WHERE     ACCOUNT_NO =:YP-ACCOUNT-NO                     
                 AND ATTRIBUTE_DESC =:YP-ATTRIBUTE-DESC                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCT_ATTRIBUTE                                        
MFA-TR*           SET ATTRIBUTE_VALUE_CD = :YP-ATTRIBUTE-VALUE-CD               
MFA-TR*              ,ATTRIBUTE_VALUE_DT = :YP-ATTRIBUTE-VALUE-DT               
MFA-TR*              ,ATTRIBUTE_VALUE_TX = ' '                                  
MFA-TR*        WHERE     ACCOUNT_NO =:YP-ACCOUNT-NO                             
MFA-TR*          AND ATTRIBUTE_DESC =:YP-ATTRIBUTE-DESC                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8530'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCT_ATTRIBUTE'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'ATTRIBUTE_DESC'           TO TABLE-ELEMENT-2        
              MOVE 'ATTRIBUTE_VALUE_CD'       TO TABLE-ELEMENT-3        
              MOVE YP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE YP-ATTRIBUTE-DESC          TO HOSTVAR-ELEMENT-2      
              MOVE YP-ATTRIBUTE-VALUE-CD      TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8530-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5600A,5700A PARAS ARE IN COPYBOOK CPD00908*                             
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD00908                                                
           END-EXEC.                                                            
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPDSP300                                                
           END-EXEC.                                                            
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD00321                                                
           END-EXEC.                                                            
                                                                        
