       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04907.                                          
       AUTHOR.       TP7R341.                                           
       DATE-WRITTEN. APRIL 19, 2016.                                    
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM PROCESSES THE ACCOUNT FOR VALIDATING IF          *        
      *  SERVICE CAN BE ADDED OR TRANSFERRED                           *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  04-19-16  TP7R341    INITIAL PROGRAM VERSION.                 *        
      *            APP5460                                             *        
      *  05-02-16  LG41184    FIXES AS PER REQUIREMENTS                *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04907'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                     PIC X(40) VALUE                  
            'WORKING STORAGE FOR CSR04907 STARTS HERE'.                 
      *                                                                         
       01  WS-LITERALS.                                                 
           05 PROGRAM-NAME             PIC X(08) VALUE 'CSR04907'.      
           05 MCSCB068                 PIC X(08) VALUE 'MCSCB068'.      
           05 WS-YES                   PIC X(01) VALUE 'Y'.             
           05 WS-NO                    PIC X(01) VALUE 'N'.             
           05 WS-PARM-ACCOUNT          PIC X(01) VALUE 'C'.             
           05 WS-OTHER-ACCOUNT         PIC X(01) VALUE 'O'.             
           05 WS-NO-ACCOUNT            PIC X(01) VALUE 'N'.             
      *                                                                         
       01  WS-MISC.                                                     
           05 WS-APPL-PGM-ID           PIC X(07).                       
           05 WS-ACCOUNT-NO            PIC X(13).                       
           05 WS-CUSTOMER-NO           PIC X(10).                       
           05 WS-DISCONNECT-HIST-CZ    PIC X(24) VALUE SPACES.          
           05 WS-DISCONNECT-HIST-CZ-R                                   
                                 REDEFINES WS-DISCONNECT-HIST-CZ.       
              10 WS-DISCONNECT-HST     PIC X(01) OCCURS 24 TIMES.       
           05 WS-DISC-EXCEPTN-HIST-CZ  PIC X(24) VALUE SPACES.          
           05 WS-DISC-EXCEPTN-HIST-CZ-R                                 
                                 REDEFINES WS-DISC-EXCEPTN-HIST-CZ.     
              10 WS-DISC-EXCEPTN-HST   PIC X(01) OCCURS 24 TIMES.       
           05 WS-ACCOUNT-TYPE-CODE     PIC X(01) VALUE SPACES.          
           05 WS-MTH                   PIC S9(02) COMP VALUE 0.         
           05 WS-CURRENT-DATE          PIC X(10) VALUE SPACES.          
           05 WS-CURR-ACCT-PASTDUE     PIC X(01) VALUE SPACES.          
           05 WS-OTHER-ACCT-PASTDUE    PIC X(01) VALUE SPACES.          
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
      *                                                                         
       01  WS-SWITCHES.                                                 
           05 ALL-DONE-SW              PIC X(01) VALUE 'N'.             
              88 NOT-ALL-DONE                    VALUE 'N'.             
              88 ALL-DONE                        VALUE 'Y'.             
           05 SEND-DONE-SW             PIC X(01) VALUE 'Y'.             
              88 SEND-DONE-ERROR                 VALUE 'N'.             
              88 SEND-DONE-OK                    VALUE 'Y'.             
           05 PAST-DUE-ACCOUNT         PIC X(01) VALUE ' '.             
              88 CURRENT-ACC                     VALUE 'C'.             
              88 OTHER-ACC                       VALUE 'O'.             
              88 NO-ACC                          VALUE 'N'.             
           05 PAST-DUE-SW              PIC X(01) VALUE ' '.             
              88 CURRENT-ACCT                    VALUE 'C'.             
              88 OTHER-ACCT                      VALUE 'O'.             
              88 NO-ACCT                         VALUE 'N'.             
           05 WS-NO-MORE-ROWS          PIC X(01) VALUE 'N'.             
              88 NO-MORE-ROWS                    VALUE 'Y'.             
           05 REGULATED-ACCOUNT        PIC X(01) VALUE 'Y'.             
           05 WS-DATABASE              PIC 9(01) VALUE 0.               
              88  CSR-DATABASE                   VALUE 1.               
              88  SEB-DATABASE                   VALUE 2.               
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09) COMP VALUE 0.         
           05  S-TRNSFR-SRVC-FLAG      PIC X(01)  VALUE 'Y'.            
           05  S-ADD-SRVC-FLAG         PIC X(01)  VALUE 'Y'.            
           05  S-PAST-DUE-AVLBL-FLG    PIC X(01)  VALUE SPACES.         
      *                                                                         
       01  RESULT-SET-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(09) COMP VALUE 0.         
           05  RS-TRNSFR-SRVC-FLAG     PIC X(01)  VALUE 'Y'.            
           05  RS-ADD-SRVC-FLAG        PIC X(01)  VALUE 'Y'.            
           05  RS-PAST-DUE-AVLBL-FLG   PIC X(01)  VALUE SPACES.         
      *                                                                         
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ACCOUNT AT                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_REG_PROFILE LR                                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBREGPRF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_AR_CNTL AC                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_UTIL_ENVRNMT UT                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ACCT_MKT_TIER DD                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMKTIER                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_CREDIT_PROFILE CZ                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCRPROF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    WORKING STORAGE FOR CODES-DATA-PRESENT                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00056                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    COPYBOOK FOR CALLING CPD00068                               *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CWS00068                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CURSOR DECLARATION TO FETCH ACCOUNTS FOR THE CUSTOMER       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               DECLARE ACCT_NUM_CSR CURSOR FOR                          
                SELECT AT.ACCOUNT_NO                                    
                      ,AT.CODES_DATA_PRESENT                            
                      ,AT.COMPANY_NO                                    
                      ,AT.CODE_ACCT_STAT                                
                  FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
                 WHERE AT.CUSTOMER_NO = :WS-CUSTOMER-NO                 
                   AND AT.CODE_ACCT_STAT = 'A'                          
                   AND AT.ACCOUNT_TYPE_CODE <> 'N'                      
                 ORDER BY AT.ACCOUNT_NO                                 
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE ACCT_NUM_CSR CURSOR FOR                                  
MFA-TR*         SELECT AT.ACCOUNT_NO                                            
MFA-TR*               ,AT.CODES_DATA_PRESENT                                    
MFA-TR*               ,AT.COMPANY_NO                                            
MFA-TR*               ,AT.CODE_ACCT_STAT                                        
MFA-TR*           FROM CSS_ACCOUNT AT                                           
MFA-TR*          WHERE AT.CUSTOMER_NO = :WS-CUSTOMER-NO                         
MFA-TR*            AND AT.CODE_ACCT_STAT = 'A'                                  
MFA-TR*            AND AT.ACCOUNT_TYPE_CODE <> 'N'                              
MFA-TR*          ORDER BY AT.ACCOUNT_NO                                         
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*        QUERYNO 7110                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       01  WS-END                      PIC X(40)                        
           VALUE 'WORKING STORAGE FOR CSR04907 ENDS HERE  '.            
      *                                                                         
       LINKAGE SECTION.                                                 
COB305 01 PARM-ACCOUNT-NO        PIC S9(13) COMP-3 VALUE 0.               
      *                                                                         
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
                                                                        
      ******************************************************************        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
                SELECT :S-RETURN-CODE        AS RETURN_CODE             
                      ,:S-TRNSFR-SRVC-FLAG   AS TRNSFR_SRVC_FLAG        
                      ,:S-ADD-SRVC-FLAG      AS ADD_SRVC_FLAG           
                      ,:S-PAST-DUE-AVLBL-FLG AS PAST_DUE_AVLBL_FLG      
                  FROM CIS.SYSDUMMY1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*         SELECT :S-RETURN-CODE        AS RETURN_CODE                     
MFA-TR*               ,:S-TRNSFR-SRVC-FLAG   AS TRNSFR_SRVC_FLAG                
MFA-TR*               ,:S-ADD-SRVC-FLAG      AS ADD_SRVC_FLAG                   
MFA-TR*               ,:S-PAST-DUE-AVLBL-FLG AS PAST_DUE_AVLBL_FLG              
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE PARM-ACCOUNT-NO               TO WS-ACCOUNT-NO.         
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           PERFORM 2200-ACCOUNT-VALIDATION    THRU 2200-EXIT.           
           PERFORM 2300-PROCESS-VALIDATIONS   THRU 2300-EXIT.           
           PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT.          
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000A-MOVE-RESULT.                                             *        
      ******************************************************************        
      *                                                                         
       2000A-MOVE-RESULT.                                               
      *                                                                         
           MOVE RS-RETURN-CODE                TO S-RETURN-CODE.         
           MOVE RS-TRNSFR-SRVC-FLAG           TO S-TRNSFR-SRVC-FLAG.    
           MOVE RS-ADD-SRVC-FLAG              TO S-ADD-SRVC-FLAG.       
           MOVE RS-PAST-DUE-AVLBL-FLG         TO S-PAST-DUE-AVLBL-FLG.  
           ADD +1                             TO CTR-ROWS.              
      *                                                                         
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2200-ACCOUNT-VALIDATION.                                      *         
      * CHECK IF THE ACCOUNT IS DE-REGULATED AND NON-UTILITY ACCOUNT  *         
      *****************************************************************         
      *                                                                         
       2200-ACCOUNT-VALIDATION.                                         
      *                                                                         
           PERFORM 7120-GET-ACCOUNT-DATA   THRU 7120-EXIT               
           MOVE WS-ACCOUNT-NO              TO LR-ACCOUNT-NO             
           PERFORM 7110-SELECT-REG-PROFILE    THRU 7110-EXIT            
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND AND                     
                               AT-CODE-ACCT-STAT = 'A'                  
              MOVE  AT-ACCOUNT-TYPE-CODE   TO WS-ACCOUNT-TYPE-CODE      
              MOVE  AT-CUSTOMER-NO         TO WS-CUSTOMER-NO            
              MOVE  AT-CODES-DATA-PRESENT  TO WS-CODES-DATA-PRESENT     
           ELSE                                                         
              PERFORM 2350-SET-NO-FLAGS       THRU 2350-EXIT            
              PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT           
              PERFORM 9999-END-PROGRAM        THRU 9999-EXIT            
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2300-PROCESS-VALIDATIONS.                                     *         
      * DO THE VALIDATIONS REQUIRED FOR ALLOWING TRANSFER SERVICE     *         
      *                                          AND ADD  SERVICE     *         
      *****************************************************************         
      *                                                                         
       2300-PROCESS-VALIDATIONS.                                        
      *                                                                         
           MOVE 'N'                           TO WS-NO-MORE-ROWS.       
                                                                        
           PERFORM 7010-OPEN-ACCT-NUM-CSR     THRU 7010-EXIT.           
                                                                        
           PERFORM 7020-FETCH-ACCOUNT         THRU 7020-EXIT.           
                                                                        
           PERFORM 2310-PROCESS-ACCOUNTS      THRU 2310-EXIT            
                   UNTIL NO-MORE-ROWS                                   
                      OR RS-TRNSFR-SRVC-FLAG = 'N'                      
                      OR WS-OTHER-ACCT-PASTDUE = 'Y'.                   
      *               OR RS-ADD-SRVC-FLAG = 'N'.                                
                                                                        
           PERFORM 7030-CLOSE-ACCT-NUM-CSR    THRU 7030-EXIT.           
                                                                        
           PERFORM 2560-SET-DUE-FLAG          THRU 2560-EXIT.           
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2310-PROCESS-ACCOUNTS.                                        *         
      * DO THE VALIDATIONS REQUIRED FOR ALLOWING ADD SERVICE OR       *         
      *                                      TRANSFER SERVICE         *         
      *****************************************************************         
      *                                                                         
       2310-PROCESS-ACCOUNTS.                                           
      *                                                                         
      *  CHECK IF THE ACCOUNT IS RESIDENTIAL/COMMERCIAL                         
           MOVE AT-ACCOUNT-NO              TO LR-ACCOUNT-NO             
           PERFORM 7110-SELECT-REG-PROFILE    THRU 7110-EXIT            
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 7250-CHECK-RESIDENTIAL     THRU 7250-EXIT         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND            
                    (DD-TIER-ACCT-TYPE-CD = 'A' OR 'B' OR 'D' OR 'S')   
      * CHECK IF THE ACCOUNT IS PRE-PAY                               *         
                 IF WS-CODE-PRE-PAY-PLAN = 'A'                          
                    PERFORM 2350-SET-NO-FLAGS    THRU 2350-EXIT         
                 END-IF                                                 
                                                                        
      * CHECK FOR ACTIVE DPP OR DFA                                   *         
                 IF WS-CODE-DFA-ACCT = 'A' OR WS-CODE-DPP-ACCT = 'A'    
                    PERFORM 7130-GET-TRANSFER-BALANCE                   
                                              THRU 7130-EXIT            
                    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL          
                       PERFORM 2350-SET-NO-FLAGS THRU 2350-EXIT         
                    END-IF                                              
                 END-IF                                                 
                                                                        
      * CHECK FOR ACTIVE PAYMENT ARRANGEMENT                          *         
                 IF WS-CODE-STA-ACCT = 'A' OR WS-CODE-CRED-ARNG = 'A'   
                    PERFORM 2350-SET-NO-FLAGS    THRU 2350-EXIT         
                 END-IF                                                 
                                                                        
      *  CHECK IF THE ACCOUNT HAS DISCONNECT HISTORY                            
                 PERFORM 7260-CHECK-DISC-HIST    THRU 7260-EXIT         
                                                                        
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    MOVE CZ-DISCONNECT-HIST   TO WS-DISCONNECT-HIST-CZ  
                                              WS-DISCONNECT-HIST-CZ-R   
                    MOVE CZ-DISC-EXCEPTN-HIST TO WS-DISC-EXCEPTN-HIST-CZ
                                              WS-DISC-EXCEPTN-HIST-CZ-R 
                    PERFORM VARYING WS-MTH FROM 1 BY 1                  
                              UNTIL WS-MTH > 3                          
                       IF ((WS-DISCONNECT-HST(WS-MTH) = '2' OR '3' OR   
                                           '4' OR 'E' OR 'I' OR 'R')    
                       OR (WS-DISC-EXCEPTN-HST(WS-MTH) = '2' OR '3' OR  
                                           '4' OR 'E' OR 'I' OR 'R'))   
                          MOVE WS-NO             TO RS-ADD-SRVC-FLAG    
                       END-IF                                           
                    END-PERFORM                                         
                 END-IF                                                 
                                                                        
                 IF RS-TRNSFR-SRVC-FLAG = 'Y' OR                        
                       RS-ADD-SRVC-FLAG = 'Y'                           
                    PERFORM 2500-PAST-DUE-AVAILABLE THRU 2500-EXIT      
                 END-IF                                                 
                                                                        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7020-FETCH-ACCOUNT         THRU 7020-EXIT.           
      *                                                                         
       2310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2350-SET-NO-FLAGS.                                            *         
      * SET THE TRANSFER SERVICE FLAG AND ADD SERVICE FLAG TO "NO"    *         
      *****************************************************************         
      *                                                                         
       2350-SET-NO-FLAGS.                                               
      *                                                                         
           MOVE WS-NO                       TO RS-TRNSFR-SRVC-FLAG.     
           MOVE WS-NO                       TO RS-ADD-SRVC-FLAG.        
           MOVE SPACES                      TO RS-PAST-DUE-AVLBL-FLG.   
      *                                                                         
       2350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  2500-PAST-DUE-AVAILABLE.                                      *        
      * GET PAST BALANCE DUE FOR THE ACCOUNTS RELATED THE CUSTOMER-NO  *        
      ******************************************************************        
      *                                                                         
       2500-PAST-DUE-AVAILABLE.                                         
      *                                                                         
           MOVE WS-CURRENT-DATE               TO WS-CL-DATE-NOTICE-MAIL 
                                                 WS-CL-DATE-NOTICE-DUE  
                                                 WS-HOLD-DATE.          
           MOVE 'Y'                           TO CALC-PAST-DUE-SW       
                                                 CALC-ARREARS-SW        
                                                 CALC-BALANCE-SW.       
                                                                        
           MOVE PROGRAM-NAME                 TO WS-CPD00068-CALLING-PGM.
           MOVE AT-CODES-DATA-PRESENT         TO WS-CODES-DATA-PRESENT. 
           MOVE SPACES                        TO ABEND-FUNCTION.        
           PERFORM 9500-CALL-CPD00068         THRU 9500-EXIT.           
      *                                                                         
           PERFORM 2550-SET-DUE-SWITCHES      THRU 2550-EXIT.           
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  2550-SET-DUE-SWITCHES.                                        *        
      * SET THE PAST DUE SWITCHES TO "N" OR "Y"                        *        
      ******************************************************************        
      *                                                                         
       2550-SET-DUE-SWITCHES.                                           
      *                                                                         
           IF WS-AMT-PAST-DUE > 25                                      
      *       PERFORM 2350-SET-NO-FLAGS THRU 2350-EXIT                          
              IF AT-ACCOUNT-NO = PARM-ACCOUNT-NO AND                    
                            WS-CURR-ACCT-PASTDUE NOT = 'Y'              
                 MOVE 'Y'               TO WS-CURR-ACCT-PASTDUE         
              END-IF                                                    
                                                                        
              IF AT-ACCOUNT-NO NOT = PARM-ACCOUNT-NO AND                
                            WS-OTHER-ACCT-PASTDUE NOT = 'Y'             
                 MOVE 'Y'               TO WS-OTHER-ACCT-PASTDUE        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  2560-SET-DUE-FLAG.                                            *        
      * SET PAST DUE AVAILABLE FLAG TO "N" OR "O" OR "C"               *        
      ******************************************************************        
      *                                                                         
       2560-SET-DUE-FLAG.                                               
      *                                                                         
           IF WS-OTHER-ACCT-PASTDUE = 'Y' OR WS-CURR-ACCT-PASTDUE = 'Y' 
              MOVE 'N'                     TO RS-TRNSFR-SRVC-FLAG,      
                                              RS-ADD-SRVC-FLAG          
              IF WS-OTHER-ACCT-PASTDUE = 'Y'                            
                 MOVE WS-OTHER-ACCOUNT     TO RS-PAST-DUE-AVLBL-FLG     
              ELSE                                                      
                 IF WS-CURR-ACCT-PASTDUE = 'Y'                          
                    MOVE WS-PARM-ACCOUNT   TO RS-PAST-DUE-AVLBL-FLG     
                 ELSE                                                   
                    MOVE WS-NO-ACCOUNT     TO RS-PAST-DUE-AVLBL-FLG     
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              MOVE WS-NO-ACCOUNT           TO RS-PAST-DUE-AVLBL-FLG     
           END-IF.                                                      
      *                                                                         
       2560-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7010-OPEN-ACCT-NUM-CSR                                        *         
      * OPEN THE ACCT_NUM_CSR CURSOR                                  *         
      *****************************************************************         
      *                                                                         
       7010-OPEN-ACCT-NUM-CSR.                                          
      *                                                                         
           MOVE '7010'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN ACCT_NUM_CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'CUSTOMER-NO'              TO TABLE-ELEMENT-1        
              MOVE AT-CUSTOMER-NO             TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7020-FETCH-ACCOUNT.                                           *         
      * FETCH THE ACCOUNTS FROM THE ACCT_NUM_CSR CURSOR               *         
      *****************************************************************         
      *                                                                         
       7020-FETCH-ACCOUNT.                                              
      *                                                                         
           MOVE '7020'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH  ACCT_NUM_CSR                                       
               INTO :AT-ACCOUNT-NO                                      
                   ,:AT-CODES-DATA-PRESENT                              
                   ,:AT-COMPANY-NO                                      
                   ,:AT-CODE-ACCT-STAT                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 'Y'                     TO WS-NO-MORE-ROWS        
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7030-CLOSE-ACCT-NUM-CSR                                       *         
      *CLOSE THE ACCT_NUM_CSR CURSOR                                  *         
      *****************************************************************         
      *                                                                         
       7030-CLOSE-ACCT-NUM-CSR.                                         
      *                                                                         
           MOVE '7030'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE ACCT_NUM_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'CUSTOMER-NO'              TO TABLE-ELEMENT-1        
              MOVE AT-CUSTOMER-NO             TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7110-SELECT-REG-PROFILE.                                      *         
      * CHECK IF THE ACCOUNT IS SEB DE-REGULATED                      *         
      *****************************************************************         
      *                                                                         
       7110-SELECT-REG-PROFILE.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT LR.ACCOUNT_NO                                      
                INTO :LR-ACCOUNT-NO                                     
                FROM CSS_REG_PROFILE LR                                 
               WHERE LR.ACCOUNT_NO = :LR-ACCOUNT-NO                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LR.ACCOUNT_NO                                              
MFA-TR*         INTO :LR-ACCOUNT-NO                                             
MFA-TR*         FROM CSS_REG_PROFILE LR                                         
MFA-TR*        WHERE LR.ACCOUNT_NO = :LR-ACCOUNT-NO                             
MFA-TR*      QUERYNO 7110                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7110'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_REG_PROFILE'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE LR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7120-GET-ACCOUNT-DATA.                                        *         
      * CHECK IF THE ACCOUNT IS UTILITY ACCOUNT                       *         
      *****************************************************************         
      *                                                                         
       7120-GET-ACCOUNT-DATA.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT  AT.ACCOUNT_TYPE_CODE                              
                     ,AT.CUSTOMER_NO                                    
                     ,AT.CODES_DATA_PRESENT                             
                     ,AT.COMPANY_NO                                     
                     ,AT.NOTICE_EXEMPT_CD                               
                     ,AT.CODE_DISC_OK                                   
                     ,AT.DATE_BILL_DAY_00                               
                     ,AT.DATE_BILL_DAY_30                               
                     ,AT.DATE_BILL_DAY_60                               
                     ,AT.DATE_BILL_DAY_90                               
                     ,AT.LOCAL_OFFICE                                   
                     ,AT.BANKRUPTCY_IND                                 
                     ,AT.CREDIT_GROUP                                   
                     ,AT.CODE_ACCT_STAT                                 
                     ,AT.IVR_EXEMPT_CD                                  
                INTO :AT-ACCOUNT-TYPE-CODE                              
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-CODES-DATA-PRESENT                             
                    ,:AT-COMPANY-NO                                     
                    ,:AT-NOTICE-EXEMPT-CD                               
                    ,:AT-CODE-DISC-OK                                   
                    ,:AT-DATE-BILL-DAY-00                               
                    ,:AT-DATE-BILL-DAY-30                               
                    ,:AT-DATE-BILL-DAY-60                               
                    ,:AT-DATE-BILL-DAY-90                               
                    ,:AT-LOCAL-OFFICE                                   
                    ,:AT-BANKRUPTCY-IND                                 
                    ,:AT-CREDIT-GROUP                                   
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-IVR-EXEMPT-CD                                  
                FROM  CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
               WHERE  AT.ACCOUNT_NO = :WS-ACCOUNT-NO                    
                                                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  AT.ACCOUNT_TYPE_CODE                                      
MFA-TR*              ,AT.CUSTOMER_NO                                            
MFA-TR*              ,AT.CODES_DATA_PRESENT                                     
MFA-TR*              ,AT.COMPANY_NO                                             
MFA-TR*              ,AT.NOTICE_EXEMPT_CD                                       
MFA-TR*              ,AT.CODE_DISC_OK                                           
MFA-TR*              ,AT.DATE_BILL_DAY_00                                       
MFA-TR*              ,AT.DATE_BILL_DAY_30                                       
MFA-TR*              ,AT.DATE_BILL_DAY_60                                       
MFA-TR*              ,AT.DATE_BILL_DAY_90                                       
MFA-TR*              ,AT.LOCAL_OFFICE                                           
MFA-TR*              ,AT.BANKRUPTCY_IND                                         
MFA-TR*              ,AT.CREDIT_GROUP                                           
MFA-TR*              ,AT.CODE_ACCT_STAT                                         
MFA-TR*              ,AT.IVR_EXEMPT_CD                                          
MFA-TR*         INTO :AT-ACCOUNT-TYPE-CODE                                      
MFA-TR*             ,:AT-CUSTOMER-NO                                            
MFA-TR*             ,:AT-CODES-DATA-PRESENT                                     
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*             ,:AT-NOTICE-EXEMPT-CD                                       
MFA-TR*             ,:AT-CODE-DISC-OK                                           
MFA-TR*             ,:AT-DATE-BILL-DAY-00                                       
MFA-TR*             ,:AT-DATE-BILL-DAY-30                                       
MFA-TR*             ,:AT-DATE-BILL-DAY-60                                       
MFA-TR*             ,:AT-DATE-BILL-DAY-90                                       
MFA-TR*             ,:AT-LOCAL-OFFICE                                           
MFA-TR*             ,:AT-BANKRUPTCY-IND                                         
MFA-TR*             ,:AT-CREDIT-GROUP                                           
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-IVR-EXEMPT-CD                                          
MFA-TR*         FROM  CSS_ACCOUNT AT                                            
MFA-TR*        WHERE  AT.ACCOUNT_NO = :WS-ACCOUNT-NO                            
MFA-TR*         WITH  UR                                                        
MFA-TR*      QUERYNO 7120                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7120'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7130-GET-TRANSFER-BALANCE.                                    *         
      * CHECK IF THE ACCOUNT HAS TRANSFER BALANCE > 0                 *         
      *****************************************************************         
      *                                                                         
       7130-GET-TRANSFER-BALANCE.                                       
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) AC.AMT_TRAN_BALANCE                                
                INTO :AC-AMT-TRAN-BALANCE                               
                FROM CSS_AR_CNTL AC WITH(READUNCOMMITTED)                       
               WHERE AC.ACCOUNT_NO = :WS-ACCOUNT-NO                     
                 AND AC.PYMT_PRIORITY_LVL = 90                          
                 AND AC.ITEM_ID           > 0                           
                 AND AC.AMT_TRAN_BALANCE  > 0                           
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AC.AMT_TRAN_BALANCE                                        
MFA-TR*         INTO :AC-AMT-TRAN-BALANCE                                       
MFA-TR*         FROM CSS_AR_CNTL AC                                             
MFA-TR*        WHERE AC.ACCOUNT_NO = :WS-ACCOUNT-NO                             
MFA-TR*          AND AC.PYMT_PRIORITY_LVL = 90                                  
MFA-TR*          AND AC.ITEM_ID           > 0                                   
MFA-TR*          AND AC.AMT_TRAN_BALANCE  > 0                                   
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7130                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7130'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_CNTL'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7250-CHECK-RESIDENTIAL.                                       *         
      * CHECK IF THE ACCOUNT IS RESIDENTIAL OR COMMERCIAL             *         
      * PROGRAM SHOULD NOT PROCESS THE ACCOUNT IF OTHER THAN THE TWO  *         
      *****************************************************************         
      *                                                                         
       7250-CHECK-RESIDENTIAL.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) DD.TIER_ACCT_TYPE_CD                               
                INTO :DD-TIER-ACCT-TYPE-CD                              
                FROM CSS_ACCT_MKT_TIER DD                               
               WHERE DD.ACCOUNT_NO = :AT-ACCOUNT-NO                     
               ORDER BY DD.EFF_START_DT DESC                            
                                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DD.TIER_ACCT_TYPE_CD                                       
MFA-TR*         INTO :DD-TIER-ACCT-TYPE-CD                                      
MFA-TR*         FROM CSS_ACCT_MKT_TIER DD                                       
MFA-TR*        WHERE DD.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*        ORDER BY DD.EFF_START_DT DESC                                    
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*      QUERYNO 7250                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCT_MKT_TIER'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7260-CHECK-DISC-HIST.                                         *         
      * CHECK IF THE ACCOUNT NUMBR HAS DISCONNECT HISTORY OR          *         
      *  DISCONNECT EXCEPTIONAL HISTORY                               *         
      *****************************************************************         
      *                                                                         
       7260-CHECK-DISC-HIST.                                            
      *                                                                         
           EXEC SQL                                                     
               SELECT  CZ.DISCONNECT_HIST                               
                      ,CZ.DISC_EXCEPTN_HIST                             
                 INTO :CZ-DISCONNECT-HIST                               
                     ,:CZ-DISC-EXCEPTN-HIST                             
                 FROM CSS_CREDIT_PROFILE CZ                             
                WHERE CZ.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  CZ.DISCONNECT_HIST                                       
MFA-TR*               ,CZ.DISC_EXCEPTN_HIST                                     
MFA-TR*          INTO :CZ-DISCONNECT-HIST                                       
MFA-TR*              ,:CZ-DISC-EXCEPTN-HIST                                     
MFA-TR*          FROM CSS_CREDIT_PROFILE CZ                                     
MFA-TR*         WHERE CZ.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*       QUERYNO 7260                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CREDIT_PROFILE'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
      *                                                                         
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
      *                                                                         
       8100-SEND-RESULT.                                                
      *                                                                         
              ADD +1                          TO CTR-ROWS.              
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9500-CALL-CPD00068                                             *        
      ******************************************************************        
       9500-CALL-CPD00068.                                              
                                                                        
           CALL MCSCB068  USING  CWS00068-FIELDS                        
                                 WS-CODES-DATA-PRESENT                  
                                 DCLCSS-ACCOUNT                         
                                 ABEND-FILE                             
                                 RS-RETURN-CODE.                        
           MOVE RS-RETURN-CODE                TO WS-ACTIVE-RETURN-CODE, 
                                                 S-RETURN-CODE.         
           IF ABEND-FUNCTION  > SPACES                                  
               IF ABEND-FUNCTION EQUAL 'BADDATA'                        
                  MOVE -1                     TO S-RETURN-CODE,         
                                                 WS-ACTIVE-RETURN-CODE  
               END-IF                                                   
               PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT           
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       9500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9700-PROCESS-ABEND                                             *        
      ******************************************************************        
      *                                                                         
        9700-PROCESS-ABEND.                                             
                                                                        
             PERFORM 2350-SET-NO-FLAGS        THRU 2350-EXIT.           
             PERFORM 8100-SEND-RESULT         THRU 8100-EXIT.           
             PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.           
             PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.           
      *                                                                         
        9700-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00321                                                   
           END-EXEC.                                                            
      *                                                                         
