       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04906.                                         
       AUTHOR.        AARON ABRAHAM.                                    
COB303 DATE-WRITTEN.  APRIL 7, 2016                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  This Procedure is used to delete Returned Payment from History*00180000
      *  View.                                                         *        
      *                                                                *00180000
      *  # Cloned from CSR02162.                                       *        
      *  # Removed Pay correction (Panel 373) related logic            *        
      *  # Reverse the Payment and put money back to the account       *        
      *  # Write Journals and transaction history                      *        
      *  # Call CPD03413 to turndown DNP services                      *        
      *  # Invoked from Payment Solution\Returned Payment Project      *        
      *  # BusOp Name: UPDACCTDELETERETURNEDPYMT                       *00001600
      *                                                                *00210016
      ******************************************************************00220000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE    INITIALS  COMMENTS                                  *00260000
      *  --------  --------  ------------------------------------------*00270000
P00935*  04/07/16  AA97148   PROCEDURE ORIGINALLY CODED.               *        
ACT285*  10/21/16  AA97148   REPLACE CPD03413 WITH NEW COPYBOOK        *        
ACT285*                      CPD03414. Ref:APPL00005460                *        
P00948*  01/01/17  VENKAT.P  SEND DNP CANCEL NOTIFICATION E-MAIL FOR   *        
P00948*                      CUSTOMERS WITH E-MAIL ADDRESS.            *        
      *                                                                *        
      ***************************************************************** 00300000
      ******************************************************************00310000
      *                                                                *00320000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00330000
      *                                                                *00320000
      ******************************************************************00310000
      *                                                                *00340000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00350000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00360000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00370000
      *  3000 - 4999  NOT USED                                         *00380000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00390000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00400000
      *  7000 - 7999  INPUT MODULES                                    *00410000
      *  8000 - 8999  OUTPUT MODULES                                   *00420000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00430000
      *                                                                *00440000
      ******************************************************************00450000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04906'.
MSQ017     COPY MFASQLM.
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04906 STARTS HERE'.                  
                                                                        
      ******************************************************************00540000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00550000
      ******************************************************************00560000
                                                                        
           COPY CWS00004.                                               00610013
           COPY CWS00007.                                               PCS00660
           COPY CWSCA225.                                                       
           COPY CWSCA224.                                                       
           COPY CWS00077.                                                       
                                                                        
      ******************************************************************        
      * WORKING STORAGE AREA USED IN CONJUNCTION WITH CPD00312         *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE CWS10016                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * WS-COMPUTE-REBATE-WORK-AREA                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     PCS00670
              INCLUDE CWS00008                                          PCS00670
           END-EXEC.                                                    PCS00670
                                                                        
      *****************************************************************         
      * WS FOR CODES_DATA_PRESENT                                     *         
      *****************************************************************         
                                                                        
           COPY CWS00056.                                               00640014
                                                                        
      *****************************************************************         
      * SUPPORT DB2 AND SQL ERROR CHECKING                            *         
      *****************************************************************         
                                                                        
           COPY CWS00303.                                               00650013
                                                                        
      *****************************************************************         
      * JOURNAL EXTRACT                                               *         
      *****************************************************************         
                                                                        
           COPY CJF00101.                                               PCS00760
           COPY CJF00105.                                               PCS00760
           COPY CJF00102.                                               PCS00760
                                                                        
ACT285*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
ACT285*    WS VARIABLE FOR COPY BOOK CPD03414                         *         
ACT285*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
ACT285                                                                  
ACT285     EXEC SQL                                                             
ACT285      INCLUDE CWS03414                                                    
ACT285     END-EXEC.                                                            
ACT285                                                                  
      ***************************************************************** 00289904
      * ERROR HANDLING.                                               *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************00670000
      *    WORK AREAS                                                  *00680000
      ******************************************************************00690000
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04906'.     
           05  EIBTRNID                 PIC X(04) VALUE 'S162'.         
           05  MCSCO061                 PIC X(08) VALUE 'MCSCO061'.     
           05  MCSCB225                 PIC X(8) VALUE  'MCSCB225'.     
           05  MCSCB224                 PIC X(8) VALUE  'MCSCB224'.     
           05  WS-WQ-CALL-PGM           PIC X(08) VALUE 'MCSCB077'.     
           05  MCSCB077                 PIC X(08) VALUE 'MCSCB077'.     
           05  SCSCB077                 PIC X(08) VALUE 'SCSCB077'.     
ACT285     05  MCS03414                 PIC X(08) VALUE 'MCS03414'.     
           05  WS-COG-TRAN-TYPE-CD-73   PIC X(1) VALUE  'P'.            
           05  WS-UTIL-ACCOUNT          PIC X.                          
               88  UTIL-EXISTS          VALUE 'Y'.                      
               88  NO-UTIL-EXISTS       VALUE 'N'.                      
      *                                                                         
           05  WS-VALID-RATE-FL         PIC X.                          
               88  VALID-RATE           VALUE 'Y'.                      
               88  NOT-VALID-RATE       VALUE 'N'.                      
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  WS-DATE-ORIG-PYMT-IND    PIC S9(04) COMP VALUE +0.       
           05  WS-CHRG-OFF-ACCT         PIC  X(01) VALUE 'N'.           
           05  WS-CHRG-OFF-IND          PIC  X(01) VALUE 'N'.           
COB305     05 WS-ACTIVE-NSC-AMT        PIC  S999999999V99 USAGE COMP-3 
COB305       VALUE 0.
COB305     05 WS-WO-NSC-AMT        PIC  S999999999V99 USAGE COMP-3 
COB305       VALUE 0.
COB305     05 WS-REMAINING-NSC        PIC  S999999999V99 USAGE COMP-3 
COB305       VALUE 0.
           05  WS-DPP-ACCT-IND          PIC  X(01) VALUE 'N'.           
           05  WS-SUB                   PIC S9(04) COMP VALUE +0.       
           05  WS-FIRST-PAYMENT         PIC  X(01) VALUE 'Y'.           
               88  FIRST-PAYMENT                   VALUE 'Y'.           
                                                                        
           05  WS-ACCOUNT-NO            PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                
                                        PIC 9(13).                      
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13) COMP-3 VALUE 0.             
                                                                        
           05  WS-AMOUNT-CHECK          PIC  X(11).                     
           05  WS-AMOUNT-CHECK-NUM REDEFINES WS-AMOUNT-CHECK            
                                        PIC  9(09)V99.                  
           05  WS-AMOUNT-CHECK-COMP3    PIC S9(09)V99 COMP-3 VALUE +0.  
                                                                        
           05  WS-BILLED-AMT            PIC S9(11)V99 COMP-3 VALUE +0.  
           05  WS-TOTAL-ORIG-AMT        PIC S9(09)V99 COMP-3 VALUE +0.  
                                                                        
           05  WS-AMT-DIFF               PIC  X(11).                    
           05  WS-AMT-DIFF-NUM     REDEFINES WS-AMT-DIFF                
                                         PIC  S9(09)V99.                
           05  WS-CURRENT-DATE           PIC  X(10) VALUE SPACES.       
           05  WS-CURRENT-TIMESTAMP      PIC  X(26) VALUE SPACES.       
           05  WS-PREV-TRANS-HIST-SEQ-NO PIC  X(26) VALUE SPACES.       
           05  WS-TRANS-HIST-SEQ-NO      PIC  X(26) VALUE SPACES.       
           05  WS-FOUND-MULT-BILLS       PIC  S9(04) COMP VALUE -840.   
           05  WS-USER-ID                PIC  X(07) VALUE SPACES.       
           05  WS-GL-OFFSET              PIC  X(10) VALUE 'CSH-OV-SH'.  
           05  WS-NULL-IND               PIC  S9(04) COMP VALUE 0.      
           05  WS-NULL-INDICATOR-1       PIC  S9(04) COMP VALUE 0.      
           05  WS-NULL-INDICATOR-2       PIC  S9(04) COMP VALUE 0.      
           05  WS-NULL-INDICATOR-3       PIC  S9(04) COMP VALUE 0.      
           05  WS-NULL-INDICATOR-4       PIC  S9(04) COMP VALUE 0.      
           05  WS-NSC                    PIC  S9(04) COMP VALUE 19.     
           05  WS-UPDATE-TYPE            PIC  X(01) VALUE SPACES.       
           05  WS-PAYMENT-TYPE           PIC  X(01) VALUE SPACES.       
           05  WS-AMOUNT-DIFF            PIC  X(11) VALUE SPACES.       
           05  WS-NEG-DIFF-FLAG          PIC  X(01) VALUE SPACES.       
      *                                                                         
           05  WS-TRAN-COMMENT-LEN       PIC  9(04) VALUE 0.            
           05  WS-TRAN-COMMENT-LEN-NUM   PIC  S9(04) COMP VALUE 0.      
           05  WS-TRAN-COMMENT-TEXT     PIC  X(210) VALUE SPACES.       
           05  WS-TOTAL-VOUCHER-DT      PIC S9(09) COMP-3 VALUE +0.     
           05  WS-TOTAL-CURRENT-DATE    PIC S9(09) COMP-3 VALUE +0.     
           05  WS-DATE-DIFFERENCE       PIC S9(04) COMP VALUE +0.       
           05  WS-DNP-RET-CODE          PIC S9(4) VALUE 0 COMP.         
           05  WS-PYMT-FACILITY         PIC X(01) VALUE SPACES.         
           05  WS-CPD0010S-CALL-TYPE   PIC X(01) VALUE 'O'.             
               88 WS-CPD0010S-ONLINE-CALL        VALUE 'O'.             
               88 WS-CPD0010S-BATCH-CALL         VALUE 'B'.             
ACT285     05  WS-PYMT-AMOUNT           PIC S9(09)V99 COMP-3 VALUE +0.  
ACT285     05  WS-PROGRAM-NAME          PIC X(08) VALUE SPACES.         
ACT285     05  WS-UPDATE-ACTION-FL      PIC X(01) VALUE SPACES.         
                                                                        
       01  WS-LITERAL.                                                  
           05  WS-A                     PIC X(01) VALUE 'A'.            
           05  WS-C                     PIC X(01) VALUE 'C'.            
           05  WS-D                     PIC X(01) VALUE 'D'.            
           05  WS-U                     PIC X(01) VALUE 'U'.            
           05  WS-N                     PIC X(01) VALUE 'N'.            
           05  WS-S                     PIC X(01) VALUE 'S'.            
           05  WS-Y                     PIC X(01) VALUE 'Y'.            
           05  WS-998                   PIC X(03) VALUE '998'.          
           05  WS-298                   PIC X(03) VALUE '298'.          
           05  WS-SCEG                  PIC X(03) VALUE '01'.           
           05  WS-SEB                   PIC X(03) VALUE '01'.           
           05  WS-PSNC                  PIC X(03) VALUE '26'.           
           05  WS-01                    PIC X(02) VALUE '01'.           
           05  WS-001                   PIC X(03) VALUE '001'.          
           05  WS-9901                  PIC 9(04) VALUE 9901.           
           05  WS-RCV-TYPE              PIC S9(04) COMP.                
           05  WS-NO                    PIC  X(01) VALUE 'N'.           
           05  WS-YES                   PIC  X(01) VALUE 'Y'.           
           05  WS-NO-ERROR              PIC  X(05) VALUE 'NOERR'.       
                                                                        
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(09) COMP   VALUE +0.     
                                                                        
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09) COMP   VALUE +0.      
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     02450012
              INCLUDE SQLCA                                             02460012
           END-EXEC.                                                    02470012
                                                                        
      ******************************************************************        
      * CSS_CNT_DETAIL          - EA                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     02490012
              INCLUDE TBCNTDET                                          02500016
           END-EXEC.                                                    02510012
                                                                        
      ******************************************************************        
      * CSS_BUDGET_HIST         - BH                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     02490012
              INCLUDE TBBGTHST                                          02500016
           END-EXEC.                                                    02510012
                                                                        
      ******************************************************************        
      * CSS_BUDGET_PLAN         - BU                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     02490012
              INCLUDE TBBGTPLN                                          02500016
           END-EXEC.                                                    02510012
                                                                        
      ******************************************************************        
      * CSS_AR_TRANS_HIST       - AR                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     02490012
              INCLUDE TBARHIST                                          02500016
           END-EXEC.                                                    02510012
                                                                        
      ******************************************************************        
      * CSS_ACCOUNT             - AT                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     02530016
              INCLUDE TBACCT                                            02540016
           END-EXEC.                                                    02550016
                                                                        
      ******************************************************************        
      * CSS_CUSTOMER            - CU                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     02570016
              INCLUDE TBCUST                                            02580016
           END-EXEC.                                                    02590016
                                                                        
      ******************************************************************        
      * CSS_PREMISE             - PR                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     02610016
              INCLUDE TBPREM                                            02620016
           END-EXEC.                                                    02630016
                                                                        
      ******************************************************************        
      * CSS_AR_CNTL             - AC                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     02690016
              INCLUDE TBARCNTL                                          02700016
           END-EXEC.                                                    02710016
                                                                        
      ******************************************************************        
      * CSS_CRED_COLL           - CL                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     02730016
              INCLUDE TBCRCOLL                                          02740016
           END-EXEC.                                                    02750016
                                                                        
      ******************************************************************        
      * CSS_CONTRACT            - CT                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00010000
              INCLUDE TBCNTRCT                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      ******************************************************************        
      * CSS_DFA_ACCT            - DA                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00010000
              INCLUDE TBDFAACT                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      ******************************************************************        
      * CSS_DEP_PAY_HST         - DP                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00010000
              INCLUDE TBDEPHST                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      ******************************************************************        
      * CSS_AR_TRN_HST_DET      - AU                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00010000
              INCLUDE TBARHDT                                           00020000
           END-EXEC.                                                    00030000
                                                                        
      ******************************************************************        
      * CSS_CSH_DRWR_CNTL       - CS                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00010000
              INCLUDE TBCDCNTL                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      ******************************************************************        
      * CSS_CSH_DRWR_JRNL       - CJ                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00010000
              INCLUDE TBCDJRNL                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      ******************************************************************        
      * CSS_BCH_JRNL_CNTL       - BC                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00010000
              INCLUDE TBBJCNTL                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      ******************************************************************        
      * CSS_BATCH_JRNL          - BJ                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00010000
              INCLUDE TBBTJRNL                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      ******************************************************************        
      * CSS_MISC_JRNL           - MJ                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00010000
              INCLUDE TBMSJRNL                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      ******************************************************************        
      * CSS_USER_PROFILE        - PF                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00010000
              INCLUDE TBUSRPRF                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      ******************************************************************        
      * CSS_PROJ_SHARE          - PJ                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00010000
              INCLUDE TBPRJSHR                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      ******************************************************************        
      * CSS_DFA_RECVBLE         - DV                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00010000
              INCLUDE TBDFARCV                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      ******************************************************************        
      * CSS_AR_PMT_PRTY         - C9                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00010000
              INCLUDE TBARPMT                                           00020000
           END-EXEC.                                                    00030000
                                                                        
      ******************************************************************        
      * CSS_GL_ACCT_NO          - GO                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00010000
              INCLUDE TBGLATNO                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      ******************************************************************        
      * CSS_DEP_ON_HAND         - DO                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00010000
              INCLUDE TBDEPHND                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      ******************************************************************        
      * CSS_RECONNECT           - DL                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRECNCT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CHRG_OFF            - CO                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCHGOFF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_AR_LOCKOUT          - AL                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBARLOCK                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_DELINQUENCY         - C8                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CREDIT_PROFILE      - CZ                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCRPROF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_UTIL_ENVRNMT        - UT                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_NSF_HIST            - NH                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNSFHST                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_LIEAP               - LI                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBLIEAP                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_LOCAL_OFFICE        - B1                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBLOCOFC                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_BANK                - D1                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBANK                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_BANK_TRANSFER       - YB                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBNKXFR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CONNECT_CHRG        - CC                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCCCHRG                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_RECONNECT_CHRG      - U7                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRCNCHR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************07009200
      * CSS_WO_ARRANGEMENT     - WG                                    *07009300
      ******************************************************************07009400
                                                                        
           EXEC SQL                                                     07009600
               INCLUDE TBWOARGM                                         07009700
           END-EXEC.                                                    07009800
                                                                        
      ******************************************************************07009200
      * CSS_FINAL_WO           - FW                                    *07009300
      ******************************************************************07009400
                                                                        
           EXEC SQL                                                     07009600
               INCLUDE TBFINLWO                                         07009700
           END-EXEC.                                                    07009800
                                                                        
      ******************************************************************07009200
      * CSS_FIN_WO_ACTION      - KD                                    *07009300
      ******************************************************************07009400
                                                                        
           EXEC SQL                                                     07009600
               INCLUDE TBFWACTN                                         07009700
           END-EXEC.                                                    07009800
                                                                        
      ******************************************************************07009200
      * CSS_MNT_TRANS_HIST     - MH                                    *07009300
      ******************************************************************07009400
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************07009200
      * CSS_MT_TRN_HST_DET     - MI                                    *07009300
      ******************************************************************07009400
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_HOLIDAY            - J8                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBHLDAY                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CSH_REPORT_HDR     - YR                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSRPHD                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CASHIER_OFFICE     - Y2                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSHOFF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_JOB_PARM           - G6                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS0013B                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     PCS00710
              INCLUDE CWS00017                                          PCS00710
           END-EXEC.                                                    PCS00710
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00061                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     02930012
              INCLUDE CWS00073                                          02940012
           END-EXEC.                                                    02950012
                                                                        
      ******************************************************************        
      * DECLARE CURSOR TO GET RAYMENT REFUNDED IND                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
             DECLARE TRANS-HIST-CURSOR  CURSOR FOR                      
               SELECT PYMT_REFUNDED_IND                                 
                   FROM CSS_AR_TRANS_HIST                               
                   WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO             
                     AND DATE_TRANS        = IIF(TRY_CONVERT(DATE, 
                                                     :AR-DATE-ORIG-PYMT
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-ORIG-PYMT
              ) <> 0) OR (LEN(:AR-DATE-ORIG-PYMT
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-ORIG-PYMT
              ), CONVERT(DATE, :AR-DATE-ORIG-PYMT) )         
                     AND AMT_ORIG_ENTERED  = :NH-RETURN-CHECK-AMT       
                     AND CODE_TRAN_TYPE    = 'P'                        
                     AND PYMT_REFUNDED_IND = 'Y'                        
               FOR UPDATE OF PYMT_REFUNDED_IND                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE TRANS-HIST-CURSOR  CURSOR FOR                              
MFA-TR*        SELECT PYMT_REFUNDED_IND                                         
MFA-TR*            FROM CSS_AR_TRANS_HIST                                       
MFA-TR*            WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                     
MFA-TR*              AND DATE_TRANS        = :AR-DATE-ORIG-PYMT                 
MFA-TR*              AND AMT_ORIG_ENTERED  = :NH-RETURN-CHECK-AMT               
MFA-TR*              AND CODE_TRAN_TYPE    = 'P'                                
MFA-TR*              AND PYMT_REFUNDED_IND = 'Y'                                
MFA-TR*        FOR UPDATE OF PYMT_REFUNDED_IND                                  
MFA-TR*        QUERYNO 7607                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
        01 CSRERLOG-P.                                                  
            10 S-SP-NAME           PIC X(18) VALUE SPACES.              
            10 S-SQLCODE           PIC S9(9) COMP VALUE 0.              
            10 S-SQLSTATE          PIC X(5)  VALUE ' '.                 
            10 S-TABLE-NAME        PIC X(18) VALUE SPACES.              
            10 S-HOST-VAIABLES.                                         
               49 S-HOST-VARIABLES-L PIC S9(4) USAGE COMP.              
               49 S-HOST-VARIABLES-V PIC X(255).                        
            10 S-SQL-STATEMENT.                                         
               49 S-SQL-STATEMENT-L  PIC S9(4) USAGE COMP.              
               49 S-SQL-STATEMENT-V  PIC X(255).                        
            10 S-SQL-DESCRIPTION.                                       
               49 S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.             
               49 S-SQL-DESCRIPTION-V PIC X(255).                       
                                                                        
       LINKAGE SECTION.                                                 
       01 PARM-ACCOUNT-NO          PIC  X(13).                          
       01 PARM-TRANS-HIST-SEQ-NO   PIC  X(26).                          
       01 PARM-AMT-CHECK           PIC  X(11).                          
       01 PARM-USER-ID             PIC  X(07).                          
       01 PARM-TRAN-COMMENT-LEN    PIC  X(04).                          
       01 PARM-TRAN-COMMENT-TEXT   PIC  X(210).                         
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
                                PARM-TRANS-HIST-SEQ-NO                  
                                PARM-AMT-CHECK                          
                                PARM-USER-ID                            
                                PARM-TRAN-COMMENT-LEN                   
                                PARM-TRAN-COMMENT-TEXT.                 

SCA006        SET WS-GL-SUB TO 1.
      ******************************************************************03030000
      * 0000-MAINLINE                                                  *03040000
      ******************************************************************03060000
                                                                        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03160000
      * 0100-INITIALIZE                                                *03170000
      ******************************************************************03230000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100' TO ACTIVE-PARAGRAPH.                             
                                                                        
      * As cloned SP CSR02162 was called from multiple panels (P182 &           
      * P373), below parm fields were hard coded on Panel 182. Part of          
      * Returned Payment Modernization project we removed these fields          
      * from CPRC and added into Initialize section.                            
           MOVE 'U'                   TO WS-UPDATE-TYPE.                
           MOVE 'C'                   TO WS-PAYMENT-TYPE.               
           MOVE 0                     TO WS-AMT-MONEY-ORDER             
                                         WS-AMT-LIHEAP                  
                                         WS-AMT-CREDIT-CARD             
                                         WS-AMT-CASH.                   
           MOVE '00000000000'         TO WS-AMOUNT-DIFF.                
           MOVE 'N'                   TO WS-NEG-DIFF-FLAG.              
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR CONTINUE END-EXEC.                
           EXEC SQL WHENEVER NOT FOUND CONTINUE END-EXEC.               
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
                SELECT                                                  
                  :S-RETURN-CODE      AS  RETURN_CODE                   
                FROM                                                    
                   CIS.SYSDUMMY1                                     
              END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*         SELECT                                                          
MFA-TR*           :S-RETURN-CODE      AS  RETURN_CODE                           
MFA-TR*         FROM                                                            
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*       END-EXEC.                                                         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
           COPY CPD00010.                                               12160012
                                                                        
      ******************************************************************03800002
      * 2000-PROCESS-OUTPUT.                                           *03810002
      ******************************************************************03880002
                                                                        
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
                                                                        
      ***********                                                               
      * DO NOT PROCEED IF SYSTEM IS LOCKED                                      
      ***********                                                               
           PERFORM 7999-SELECT-AL THRU 7999-SELECT-AL-EXIT              
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
              MOVE 5000 TO RS-RETURN-CODE                               
              PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT         
              ADD +1                            TO CTR-ROWS             
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF.                                                      
                                                                        
           MOVE PARM-ACCOUNT-NO      TO WS-ACCOUNT-NO.                  
           MOVE WS-ACCOUNT-NO-NUM    TO WS-ACCOUNT-NO-COMP3.            
           MOVE WS-ACCOUNT-NO-COMP3  TO AT-ACCOUNT-NO.                  
           PERFORM 7000-SELECT-AT-PR-CU THRU 7000-EXIT.                 
           IF AT-CODE-ACCT-STAT = 'S'                                   
               MOVE 'Y' TO WS-CHRG-OFF-IND                              
           ELSE                                                         
               MOVE 'N' TO WS-CHRG-OFF-IND                              
           END-IF                                                       
                                                                        
           MOVE PARM-TRAN-COMMENT-LEN  TO WS-TRAN-COMMENT-LEN           
           MOVE PARM-TRAN-COMMENT-TEXT TO WS-TRAN-COMMENT-TEXT          
           MOVE WS-TRAN-COMMENT-LEN    TO WS-TRAN-COMMENT-LEN-NUM       
                                                                        
           MOVE WS-TRAN-COMMENT-TEXT    TO AR-TRAN-COMMENT-TEXT         
           MOVE WS-TRAN-COMMENT-LEN-NUM TO AR-TRAN-COMMENT-LEN          
                                                                        
           MOVE WS-TRAN-COMMENT-TEXT   TO WS-PAR-AR-TRAN-COMMENT-TEXT   
           MOVE WS-TRAN-COMMENT-LEN-NUM TO                              
                                          WS-PAR-AR-TRAN-COMMENT-LEN    
           PERFORM 2200-PROCESS THRU 2200-EXIT.                         
      *                                                                         
           PERFORM 8999-ISSUE-COMMIT      THRU 8999-EXIT.               
                                                                        
           PERFORM 2950-PROCESS-DNP-RECONNECT THRU 2950-EXIT.           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2000A-MOVE-RESULT.                                                       
      ******************************************************************        
                                                                        
       2000A-MOVE-RESULT.                                               
                                                                        
            MOVE RS-RETURN-CODE             TO S-RETURN-CODE.           
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-PROCESS                                                   *        
      ******************************************************************        
                                                                        
       2200-PROCESS.                                                    
                                                                        
      *******                                                           10740016
      * GET INFORMATION FROM ACCOUNT, PREMISE, AND CUSTOMER TABLE       10750016
      *******                                                           10760016
           MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT.         
           IF WS-CODE-DPP-ACCT = 'A'                                    
              MOVE 'Y'   TO WS-DPP-ACCT-IND                             
           END-IF.                                                      
                                                                        
           IF CU-CODE-CUST-STATUS EQUAL WS-S                            
              MOVE WS-Y TO WS-CHRG-OFF-ACCT
           END-IF.                            
                                                                        
      *******                                                           10740016
      * SET RECONNECT FLAG                                                      
      *******                                                           10740016
           MOVE AT-ACCOUNT-NO TO DL-ACCOUNT-NO.                         
           PERFORM 7170-SELECT-RECONNECT THRU 7170-EXIT.                
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE WS-Y       TO WS-PAR-RECONNECT-EXIST
           END-IF.                
                                                                        
      *******                                                           10740016
      * MOVE NUMERIC FIELD AMONG WORKING STORAGE FIELDS BECAUSE THEY            
      * WERE PASSED AS CHARACTER, NOT NUMERIC.                                  
      *******                                                           10740016
           MOVE PARM-AMT-CHECK        TO WS-AMOUNT-CHECK.               
           MOVE WS-AMOUNT-CHECK-NUM   TO WS-AMOUNT-CHECK-COMP3.         
           MOVE WS-AMOUNT-CHECK-COMP3 TO WS-AMT-CHECK.                  
                                                                        
           ADD WS-AMOUNT-CHECK-COMP3                                    
               WS-AMT-MONEY-ORDER                                       
               WS-AMT-LIHEAP                                            
               WS-AMT-CASH                                              
               WS-AMT-CREDIT-CARD GIVING WS-PAYMENT-AMOUNT              
                                             WS-PAYMENT-AMOUNT-TOTAL.   
                                                                        
      *******                                                           10740016
      * GET G/L ACCOUNT NUMBER                                                  
      *******                                                           10760016
           PERFORM 2205-LOAD-GL-NUMBERS THRU 2205-EXIT.                 
                                                                        
      ******************                                                PCS05720
      * DEBIT CASH                                                              
      ******************                                                PCS05720
           MOVE WS-CLR-CASH-GL-NO (WS-GL-SUB) TO WS-PAR-GEN-LEDG-DB.    
                                                                        
      ******************                                                PCS05720
      * LOAD DIRECTED PAYMENT OR PAYMENT PRIORITY TABLE                         
      * HOWEVER, IF RECONNECT ROW EXISTS, PAYMENT PRIORITY TABLE                
      * WILL BE USED TO APPLY PAYMENT EVEN WHEN DIRECTED IS SPECIFIED           
      ******************                                                PCS05720
                                                                        
           MOVE WS-UPDATE-TYPE TO WS-PAR-UPDATE-TYPE.                   
           MOVE WS-NO  TO WS-IS-THIS-DIRECTED-PYMT.                     
           PERFORM 2210-LOAD-PYMT-PRIORITY THRU 2210-EXIT.              
                                                                        
           PERFORM 7610-GET-CURRENT-TIMESTAMP THRU 7610-EXIT            
                                                                        
           MOVE WS-NO-ERROR    TO WS-PAR-MESSAGE-NO.                    
      *                                                                         
           PERFORM 2400-PROCESS-PANEL182     THRU 2400-EXIT             
      *                                                                         
           PERFORM 5000-UPDATE THRU 5000-EXIT.                          
                                                                        
           MOVE WS-01                    TO YB-CASH-COMPANY-NO.         
           MOVE WS-001                   TO YB-CASH-LOCAL-OFFICE.       
           MOVE WS-CURRENT-DATE          TO YB-DATE-CASH-REPORT.        
           MOVE WS-9901                  TO YB-CASH-DRAWER-ID.          
           MOVE WS-PAYMENT-TYPE          TO YB-CURRENCY-TYPE.           
           MOVE Y2-USER-ID               TO YB-USER-ID.                 
           MOVE D1-BANK-ID               TO YB-BANK-ID.                 
           MOVE WS-AMOUNT-CHECK-NUM      TO YB-TRANSFER-AMT.            
           MOVE WS-D                     TO YB-CODE-DR-CR.              
           MOVE SPACES                   TO YB-TREASURY-EXTR-CD.        
           PERFORM 8300-CREATE-BANK-TRANSFER THRU 8300-EXIT.            
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE.                
                                                                        
           PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT.           
           ADD +1                            TO CTR-ROWS.               
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2205-LOAD-GL-NUMBERS                                           *        
      * LOAD ALL G/L NUMBER, INCLUDEING CHARGED OFF.                   *        
      ******************************************************************        
                                                                        
       2205-LOAD-GL-NUMBERS.                                            
                                                                        
           PERFORM 9350-LINK-SCSCO061     THRU 9350-EXIT.               
                                                                        
           PERFORM VARYING WS-VALID-CO-SUB FROM 1 BY 1                  
              UNTIL WS-VALID-CO-SUB > 5                                 
                 OR WS-VALID-CO-NO (WS-VALID-CO-SUB) = '01'             
                    OR WS-VALID-CO-NO (WS-VALID-CO-SUB) = WS-GL-99      
           IF WS-VALID-CO-NO (WS-VALID-CO-SUB) = '01'                   
              MOVE WS-Y TO WS-COMPANY-IN-TABLE                          
           END-IF                                                       
           END-PERFORM.                                                 
                                                                        
       2205-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2210-LOAD-PYMT-PRIORITY                                        *        
      * LOAD THE PAYMENT PRIORITY TABLE USE WS-UPDATE-TYPE TO DECIDE   *        
      * WHICH SET TO LOAD: B FOR BILLED, A FOR ARREARS, AND U FOR      *        
      * UNDIRECTED.                                                    *        
      * SCHEDULE 1 IS FOR BILLED AND UNDIRECTED DUE TO THE ORDER PAYMENT        
      * IS POSTED.  SCHEDULE 2 IS FOR ARREARS WHICH PAYS OFF ALL 90 DAY*        
      * FIRST, THEN 60 DAYS, ETC.                                      *        
      ******************************************************************        
                                                                        
       2210-LOAD-PYMT-PRIORITY.                                         
                                                                        
           MOVE 1 TO C9-PMT-PRTY-SCHEDULE.                              
                                                                        
           PERFORM 6722B-OPEN-AR-PMT-PRTY  THRU 6722B-EXIT.             
           PERFORM 6722C-FETCH-AR-PMT-PRTY THRU 6722C-EXIT.             
           PERFORM 6722D-LOAD-AR-PMT-PRTY  THRU 6722D-EXIT              
              VARYING WS-PAR-SUB FROM 1 BY 1                            
                 UNTIL WS-PAR-SUB GREATER THAN 52                       
                    OR WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.           
           PERFORM 6722E-CLOSE-AR-PMT-PRTY THRU 6722E-EXIT.             
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2400-PROCESS-PANEL182                                          *        
      * DELETE RETURN CHECK FROM CSS_NSF_HIST TABLE                    *        
      * BASED ON ACCOUNT_NO AND NSF_TIMESTMP                           *        
      ******************************************************************        
                                                                        
       2400-PROCESS-PANEL182.                                           
                                                                        
           MOVE '2400'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           MOVE 'N'             TO WS-NEG-DIFF-FLAG                     
           MOVE WS-AMOUNT-CHECK TO WS-AMT-DIFF-NUM                      
                                                                        
           MOVE PARM-ACCOUNT-NO TO NH-ACCOUNT-NO                        
                                   KD-ACCOUNT-NO                        
                                   AR-ACCOUNT-NO.                       
           MOVE +26 TO KD-FW-ACTION-COMMENTS-LEN.                       
           MOVE PARM-TRANS-HIST-SEQ-NO TO NH-NSF-TIMESTMP               
                                          KD-FW-ACTION-COMMENTS-TEXT.   
           PERFORM 7100-SELECT-NSF-HIST     THRU 7100-EXIT.             
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               PERFORM 7606-SELECT-ORGPYMT-TRANS-HIST THRU 7606-EXIT    
           END-IF.                                                      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               PERFORM 7607A-OPEN-TRANS-HIST-CURSOR   THRU 7607A-EXIT   
               PERFORM 7607B-FETCH-TRANS-HIST-CURSOR  THRU 7607B-EXIT   
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                  PERFORM 7607C-UPDATE-REFIND-TRANS-HIST THRU 7607C-EXIT
               END-IF                                                   
               PERFORM 7607D-CLOSE-TRANS-HIST-CURSOR  THRU 7607D-EXIT   
           END-IF.                                                      
      *                                                                         
           PERFORM 7150-SELECT-BANK-GL      THRU 7150-EXIT.             
      *                                                                         
           MOVE D1-CASH-GL-ACCT-NO     TO WS-PAR-GEN-LEDG-DB.           
      *                                                                         
           MOVE D1-FCS-DEP-BANK-CD     TO WS-PAR-FCS-DEP-BANK-CD.       
           MOVE D1-FCS-DEP-BANK-ST-CD  TO WS-PAR-FCS-DEP-BANK-ST-CD.    
      *                                                                         
           PERFORM 8200-DELETE-RETURN-CHECK  THRU 8200-EXIT.            
           PERFORM 8210-DELETE-FUTURE-DNP    THRU 8210-EXIT.            
           PERFORM 8220-DELETE-FUTURE-NOTICE THRU 8220-EXIT.            
           PERFORM 8225-DELETE-FUTURE-LETTER THRU 8225-EXIT.            
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************00182300
      * CALLS SUB PROGRAMS MCS03413 TO HANDLE DNP/RECONNECT REAL TIME  *00182400
      ******************************************************************00182500
                                                                        
       2950-PROCESS-DNP-RECONNECT.                                      
                                                                        
           MOVE 0                           TO WS-DNP-RET-CODE.         
           MOVE AT-ACCOUNT-NO               TO WS-ACCOUNT-NO-NUM.       
           MOVE 'P'                         TO WS-UPDATE-ACTION-FL.     
ACT285     MOVE 'O'                         TO WS-CALL-TYPE             
ACT285     MOVE 'Y'                         TO WS-CPD68-REQUIRED        
ACT285     MOVE PROGRAM-NAME                TO WS-PROGRAM-NAME          
ACT285     MOVE SPACES                      TO ws-APPL-PROGRAM-ID       
P00948     MOVE 'N'                         TO WS-CNCL-DNP-EMAIL-REQ-FL 
                                                                        
ACT285     PERFORM 9800-CALL-MCS03414       THRU 9800-EXIT.             
                                                                        
           IF WS-DNP-RET-CODE > 0                                       
              MOVE WS-DNP-RET-CODE          TO RS-RETURN-CODE           
           END-IF.                                                      
                                                                        
       2950-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 5000-UPDATE                                                    *        
      ******************************************************************        
                                                                        
       5000-UPDATE.                                                     
                                                                        
           MOVE '5000'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           MOVE WS-01                    TO YR-CASH-COMPANY-NO,         
                                            Y2-CASH-COMPANY-NO.         
           MOVE WS-001                   TO YR-CASH-LOCAL-OFFICE,       
                                            Y2-CASH-LOCAL-OFFICE.       
           PERFORM 7320-SELECT-CASHIER   THRU 7320-EXIT                 
           MOVE Y2-USER-ID               TO YR-USER-ID.                 
           MOVE WS-CURRENT-DATE          TO YR-DATE-CASH-REPORT.        
           MOVE WS-C                     TO YR-STATUS.                  
                                                                        
           PERFORM 7325-SELECT-CASH-REPORT                              
              THRU 7325-EXIT                                            
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 8325-CREATE-CASH-REPORT                           
                 THRU 8325-EXIT                                         
           END-IF.                                                      
                                                                        
           MOVE AT-COMPANY-NO TO WS-100-COMPANY-NO.                     
           MOVE PROGRAM-NAME TO WS-PAR-EIBTRNID                         
      *******************************************************           04991280
      * THESE FILEDS WERE POPULATED BY CALLING CPD00020     *           04991389
      * (PARAGRAPH 5970) TO ACCESS APPLICATION TABLE 50.    *           04991499
      *******************************************************           04991580
           MOVE 9             TO WS-TRAN-OPER-LEVEL.                    
           MOVE 1             TO WS-TRAN-OCAP-FIELD.                    
           MOVE 1             TO WS-TRAN-OCAP-VALUE.                    
           MOVE WS-C          TO WS-TRAN-JRNL-TYPE.                     
           MOVE WS-N          TO WS-TRAN-HOLD-EXEMPT-FLAG.              
                                                                        
      *******************************************************           04992280
      * THESE FILEDS WERE POPULATED BY CALLING CPD00021     *           04992389
      * (PARAGRAPH 5980) TO VERIFY USER-ID.                 *           04992489
      *******************************************************           04992580
           MOVE PARM-USER-ID       TO WS-JRNL-OL-TEMP-ID.               
           MOVE WS-JRNL-CK-OPER-ID TO WS-JRNL-OPERATION-RQST.           
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
           MOVE WS-JRNL-OL-OPR-LOC TO WS-TERM-LOC.                      
                                                                        
      ********************************************************                  
      * THESE ARE THE CHANGES REQUIRED FOR FIELD CASH SYSTEM *                  
      ********************************************************                  
           MOVE WS-01                  TO   WS-JRNL-OL-COMPANY.         
           MOVE '001'                  TO   WS-JRNL-OL-LOC-OFF.         
           MOVE WS-998                 TO   WS-JRNL-OL-REPORT-NO.       
           MOVE WS-CURRENT-DATE        TO   WS-JRNL-OL-REPORT-DT.       
           MOVE 9901                   TO   WS-JRNL-OL-CASH-DRWR.       
                                                                        
                                                                        
           MOVE WS-TERM-LOC                TO WS-JRNL-OL-TERM-LOC       
                                              WS-JRNL-OL-CASH-LOC       
                                              WS-JRNL-OL-OPR-LOC.       
                                                                        
           MOVE WS-JRNL-VALIDATE-OPER TO WS-JRNL-OPERATION-RQST.        
           MOVE WS-C                  TO WS-JRNL-SOURCE-CODE.           
           IF CASH-TRANSACTION                                          
              MOVE WS-JRNL-CASH-UPDATE     TO WS-JRNL-OL-AUTH-TYPE      
           ELSE                                                         
              MOVE WS-JRNL-NON-CASH-UPDATE TO WS-JRNL-OL-AUTH-TYPE      
           END-IF                                                       
           PERFORM 6400-ONLINE-JRNL-ROUTINE  THRU 6400-EXIT.            
                                                                        
           MOVE WS-A            TO WS-100-JRNL-SORT-ID.                 
           MOVE AT-ACCOUNT-NO   TO WS-100-ACCT-NO.                      
           MOVE AT-CUSTOMER-NO  TO WS-100-CUSTOMER-NO.                  
           MOVE AT-PREMISE-NO   TO WS-100-PREMISE-NO.                   
                                                                        
           IF WS-AMT-CASH > 0                                           
              MOVE EIBTRNID        TO WS-100-CODE-TERMINAL-TRAN         
           ELSE                                                         
              MOVE '162B'          TO WS-100-CODE-TERMINAL-TRAN         
           END-IF                                                       
                                                                        
           ADD 1                TO WS-100-JRNL-TRAN-APPL-NO.            
           MOVE WS-CURRENT-DATE TO WS-100-DATE-LAST-ACTION              
                                   AT-DATE-LAST-ACTION.                 
           MOVE WS-C            TO WS-100-CODE-ENTRY-SOURCE.            
           MOVE AT-LOCAL-OFFICE TO WS-100-LOCAL-OFFICE-CD.              
                                                                        
                                                                        
           MOVE WS-JRNL-OL-COMPANY      TO WS-PAR-COMPANY-NO            
           MOVE WS-JRNL-OL-LOC-OFF      TO WS-PAR-LOCAL-OFFICE          
           MOVE WS-JRNL-OL-REPORT-NO    TO WS-PAR-REPORT-NO             
           MOVE WS-JRNL-OL-REPORT-DT    TO WS-PAR-REPORT-DATE           
           MOVE WS-JRNL-OL-CASH-DRWR    TO WS-PAR-CASH-DRAWER           
                                                                        
           MOVE WS-TERM-LOC             TO WS-PAR-ACCESS-LOC            
           MOVE PARM-USER-ID            TO WS-PAR-OPERATOR-ID           
           MOVE PF-RESP-AREA-ID         TO WS-PAR-RESP-AREA             
           MOVE AR-PYMT-FACILITY-CD     TO WS-PAR-PYMT-FACILITY-CD      
           MOVE WS-998                  TO WS-PAR-REPORT-NO             
                                                                        
      *************************************************************             
      * MODIFICATION MADE TO MOVE P TO WS-PAR-CODE-TRAN-TYPE      *             
      * RATHER THAN DEFAULT TO 'P' IN CWS00017.  IT IS NECESSARY  *             
      * TO POPULATE WS-PAR-CODE-TRAN-TYPE OUTSIDE COPYBOOK        *             
      * BECAUSE OTHER PROGRAMS ARE CALLING CPD00010 EVEN THOUGH   *             
      * THEY ARE NOT PAYAMENT POSTING PROGRAM.   CIF - 05/25/95   *             
      *************************************************************             
           MOVE WS-PAR-P                TO WS-PAR-CODE-TRAN-TYPE.       
                                                                        
           MOVE 'I'  TO AR-CODE-TRAN-TYPE                               
                        WS-PAR-CODE-TRAN-TYPE                           
      *                                                                         
           EVALUATE NH-NSF-TYPE-CD                                      
              WHEN 'C'                                                  
                 MOVE 'PANEL182A'         TO WS-PAR-APPL-PROG-ID        
              WHEN 'M'                                                  
                 MOVE 'PANEL182M'         TO WS-PAR-APPL-PROG-ID        
              WHEN OTHER                                                
                 MOVE 'PANEL182B'         TO WS-PAR-APPL-PROG-ID        
           END-EVALUATE                                                 
      *                                                                         
           IF NH-NSF-CHARGE-AMT > 0                                     
              ADD NH-NSF-CHARGE-AMT TO WS-PAYMENT-AMOUNT-TOTAL          
           END-IF                                                       
                                                                        
           MOVE WS-PAYMENT-TYPE           TO WS-JRNL-CURRENCY-TYPE.     
           PERFORM 6792-VALIDATE-OPER         THRU 6792-EXIT            
           MOVE 'N'                           TO WS-PAR-VALIDATE-JRNL   
                                                                        
           PERFORM 6700-APPLY-PAYMENT    THRU 6700-EXIT                 
           PERFORM 5001-CHECK-PAYMENT-RETURN    THRU 5001-EXIT          
                                                                        
           IF NH-NSF-CHARGE-AMT > 0                                     
              MOVE WS-REV-NSC-GL-NO (WS-GL-SUB) TO WS-PAR-GEN-LEDG-DB   
              PERFORM 5020-PAYMENT-NSC       THRU 5020-EXIT             
              IF WS-REMAINING-NSC > 0                                   
                    PERFORM 5030-PAYMENT-REMAINING-NSC THRU 5030-EXIT   
              END-IF                                                    
           END-IF                                                       
                                                                        
           MOVE WS-AMOUNT-DIFF          TO WS-AMT-DIFF                  
                                                                        
           MOVE WS-GL-OFFSET           TO GO-GL-ACCT-NAME.              
           PERFORM 7700-GET-GL-NO      THRU 7700-EXIT.                  
                                                                        
           MOVE GO-GL-ACCT-NO             TO WS-101-ACCT-GEN-LED-CR     
           MOVE WS-CLR-CASH-GL-NO (WS-GL-SUB)                           
                                          TO WS-101-ACCT-GEN-LED-DR     
                                                                        
           IF WS-AMT-DIFF-NUM GREATER THAN 0                            
              PERFORM 5750-JOURNAL-FORMAT-101 THRU 5750-EXIT            
           END-IF.                                                      
                                                                        
           MOVE WS-JRNL-CNTRL-ONLY     TO WS-JRNL-OPERATION-RQST.       
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
                                                                        
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5001-CHECK-PAYMENT-RETURN                                      *        
      ******************************************************************        
                                                                        
       5001-CHECK-PAYMENT-RETURN.                                       
                                                                        
           IF PYMT-WAS-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '5001'                  TO ACTIVE-PARAGRAPH          
              MOVE 'USERABEN'              TO ABEND-FUNCTION            
              MOVE WS-YES                  TO WS-USER-FORCE-ABEND       
              MOVE 'PAYMENT ABEND'         TO DSNTIAR-MESSAGE-1         
              PERFORM 9000A-SEND-ERROR-RESULT THRU 9000A-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       5001-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5020-PAYMENT-NSC                                               *        
      ******************************************************************        
                                                                        
       5020-PAYMENT-NSC.                                                
                                                                        
           MOVE '5020' TO ACTIVE-PARAGRAPH.                             
                                                                        
           MOVE ZERO                     TO WS-AMT-CHECK.               
           MOVE ZERO                     TO WS-AMT-MONEY-ORDER.         
           MOVE ZERO                     TO WS-AMT-LIHEAP.              
           MOVE ZERO                     TO WS-AMT-CASH.                
           MOVE ZERO                     TO WS-AMT-CREDIT-CARD.         
           MOVE WS-D                     TO WS-PAR-UPDATE-TYPE.         
           MOVE WS-YES                   TO WS-IS-THIS-DIRECTED-PYMT.   
           MOVE NH-NSF-CHARGE-AMT        TO WS-PAYMENT-AMOUNT           
                                            WS-PAYMENT-AMOUNT-TOTAL     
                                            WS-AMT-CASH.                
           MOVE 'N'                      TO WS-PAR-APPLYING-CREDIT-SW.  
           MOVE WS-A                     TO WS-PAR-CODE-TRAN-TYPE.      
           MOVE WS-NSC                   TO WS-PAR-TYPE.                
           MOVE ZERO                     TO WS-PAR-TYPE-NO.             
           MOVE SPACES                   TO WS-PAR-PAY-AHEAD.           
           MOVE SPACES                   TO WS-PAR-PAY-CHRG-OFF.        
                                                                        
           MOVE ZERO                     TO WS-ACTIVE-NSC-AMT           
           MOVE ZERO                     TO WS-WO-NSC-AMT               
                                                                        
           PERFORM 7251-SELECT-ACTIVE-NSC THRU 7251-EXIT.               
           IF WS-ACTIVE-NSC-AMT = 0                                     
                      OR WS-NULL-IND < 0                                
               MOVE AC-ACCOUNT-NO TO CO-ACCOUNT-NO                      
               PERFORM 7252-SELECT-WO-NSC THRU 7252-EXIT                
               IF WS-WO-NSC-AMT > 0                                     
                  MOVE 'Y'    TO WS-PAR-PAY-CHRG-OFF                    
                  IF NH-NSF-CHARGE-AMT > WS-WO-NSC-AMT                  
                     MOVE  WS-WO-NSC-AMT     TO WS-PAYMENT-AMOUNT       
                                                WS-PAYMENT-AMOUNT-TOTAL 
                                                WS-AMT-CASH             
                     COMPUTE WS-REMAINING-NSC =  NH-NSF-CHARGE-AMT -    
                             WS-WO-NSC-AMT END-COMPUTE                  
                  ELSE                                                  
                      MOVE ZERO TO WS-REMAINING-NSC                     
                  END-IF                                                
               ELSE                                                     
                  MOVE WS-PAYMENT-AMOUNT TO  WS-REMAINING-NSC           
                  GO TO 5020-EXIT                                       
               END-IF                                                   
           ELSE                                                         
               IF NH-NSF-CHARGE-AMT > WS-ACTIVE-NSC-AMT                 
                  MOVE  WS-ACTIVE-NSC-AMT TO WS-PAYMENT-AMOUNT          
                                             WS-PAYMENT-AMOUNT-TOTAL    
                                             WS-AMT-CASH                
                  COMPUTE WS-REMAINING-NSC =  NH-NSF-CHARGE-AMT -       
                          WS-ACTIVE-NSC-AMT END-COMPUTE                 
               ELSE                                                     
                   MOVE ZERO TO WS-REMAINING-NSC                        
               END-IF                                                   
           END-IF.                                                      
                                                                        
           PERFORM 6700-APPLY-PAYMENT THRU 6700-EXIT.                   
                                                                        
           IF FIRST-PAYMENT                                             
              MOVE WS-NO                   TO WS-FIRST-PAYMENT          
              PERFORM 5001-CHECK-PAYMENT-RETURN THRU 5001-EXIT          
           ELSE                                                         
           IF PYMT-WAS-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '5020'                  TO ACTIVE-PARAGRAPH          
              MOVE 'USERABEN'              TO ABEND-FUNCTION            
              MOVE WS-YES                  TO WS-USER-FORCE-ABEND       
              MOVE 'PAYMENT ABEND'         TO DSNTIAR-MESSAGE-1         
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF
           END-IF.                                                      
                                                                        
       5020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5030-PAYMENT-REMAINING-NSC                                     *        
      ******************************************************************        
                                                                        
       5030-PAYMENT-REMAINING-NSC.                                      
                                                                        
           MOVE '5030' TO ACTIVE-PARAGRAPH.                             
                                                                        
           MOVE ZERO                     TO WS-AMT-CHECK.               
           MOVE ZERO                     TO WS-AMT-MONEY-ORDER.         
           MOVE ZERO                     TO WS-AMT-LIHEAP.              
           MOVE ZERO                     TO WS-AMT-CASH.                
           MOVE ZERO                     TO WS-AMT-CREDIT-CARD.         
           MOVE WS-U                     TO WS-PAR-UPDATE-TYPE.         
           MOVE WS-NO                    TO WS-IS-THIS-DIRECTED-PYMT.   
           MOVE WS-REMAINING-NSC         TO WS-PAYMENT-AMOUNT           
                                            WS-PAYMENT-AMOUNT-TOTAL     
                                            WS-AMT-CHECK.               
           MOVE WS-PAR-NO                TO WS-PAR-APPLYING-CREDIT-SW.  
           MOVE WS-A                     TO WS-PAR-CODE-TRAN-TYPE.      
           MOVE ZERO                     TO WS-PAR-TYPE.                
           MOVE ZERO                     TO WS-PAR-TYPE-NO.             
           MOVE SPACES                   TO WS-PAR-PAY-AHEAD.           
           MOVE SPACES                   TO WS-PAR-PAY-CHRG-OFF.        
           PERFORM 6700-APPLY-PAYMENT THRU 6700-EXIT.                   
                                                                        
           IF FIRST-PAYMENT                                             
              MOVE WS-NO                   TO WS-FIRST-PAYMENT          
              PERFORM 5001-CHECK-PAYMENT-RETURN THRU 5001-EXIT          
           ELSE                                                         
           IF PYMT-WAS-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '5030'                  TO ACTIVE-PARAGRAPH          
              MOVE 'USERABEN'              TO ABEND-FUNCTION            
              MOVE WS-YES                  TO WS-USER-FORCE-ABEND       
              MOVE 'PAYMENT ABEND'         TO DSNTIAR-MESSAGE-1         
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF
           END-IF.                                                      
                                                                        
       5030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 5750-JOURNAL-FORMAT-101.                                    *           
      *    -- THIS MODULE WRITES A FORMAT 101 JOURNAL               *           
      ***************************************************************           
                                                                        
       5750-JOURNAL-FORMAT-101.                                         
                                                                        
           MOVE WS-JRNL-CK-OPER-ID TO WS-JRNL-OPERATION-RQST.           
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
                                                                        
           MOVE WS-JRNL-VALIDATE-OPER TO WS-JRNL-OPERATION-RQST.        
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
                                                                        
           MOVE 'A'                     TO WS-100-JRNL-SORT-ID.         
           MOVE '01'                    TO WS-100-COMPANY-NO.           
           IF AT-COMPANY-NO = WS-SCEG OR WS-SEB                         
              MOVE WS-998                  TO WS-100-LOCAL-OFFICE-CD    
           ELSE                                                         
              IF AT-COMPANY-NO = WS-PSNC                                
                 MOVE WS-298               TO WS-100-LOCAL-OFFICE-CD    
              END-IF                                                    
           END-IF.                                                      
           MOVE 9999999999999           TO WS-100-ACCT-NO.              
           MOVE 9999999999              TO WS-100-CUSTOMER-NO.          
           MOVE 9999999999              TO WS-100-PREMISE-NO.           
           MOVE AU-TRAN-APPL-NO         TO WS-100-JRNL-TRAN-APPL-NO.    
           ADD  1                       TO WS-100-JRNL-TRAN-APPL-NO.    
           MOVE WS-CURRENT-DATE         TO WS-100-DATE-LAST-ACTION.     
           MOVE 'C'                     TO WS-100-CODE-ENTRY-SOURCE.    
           MOVE SPACES                  TO WS-100-TRANS-ERRORS.         
                                                                        
           MOVE 101                     TO WS-101-JRNL-FORMAT-NO.       
                                                                        
           MOVE SPACES                  TO WS-101-CASH-DRAWER-USED      
      *                                                                         
           MOVE WS-AMT-DIFF-NUM         TO WS-101-AMT-POSTED            
                                           WS-101-AMOUNT-ENTERED.       
           MOVE SPACES                  TO WS-101-AR-AGE.               
           MOVE WS-CURRENT-DATE         TO WS-101-DATE-AR-BILLED.       
           MOVE 0                       TO WS-101-ITEM-ID-NO.           
           MOVE 0                       TO WS-101-DETAIL-END-BAL.       
           MOVE 0                       TO WS-101-DETAIL-END-AR-BAL.    
           MOVE 0                       TO WS-101-ACCT-END-AR-BAL.      
           MOVE SPACES                  TO WS-101-FUNCTION-CODE.        
           MOVE SPACES                  TO WS-101-CODE-REVENUE-DISTRICT.
           MOVE SPACES                  TO WS-101-CODE-EMPL-ACCT.       
           MOVE SPACES                  TO WS-101-CODE-COMPANY-ACCT.    
           MOVE SPACES                  TO WS-101-CODE-ACCOUNT-STATUS.  
           MOVE SPACES                  TO WS-101-CODE-PREMISE-STATUS.  
      *                                                                         
      *******************************************************                   
      * POPULATE CWS00013 VARIABLES.                        *                   
      *******************************************************                   
      *                                                                         
           MOVE WS-PAYMENT-TYPE         TO WS-JRNL-CURRENCY-TYPE.       
           MOVE SPACES                  TO WS-JRNL-CODE-PYMT-FACILITY.  
           MOVE CJF00101                TO WS-100-USER-DEFINED-AREA.    
                                                                        
           MOVE WS-JRNL-ONLY           TO WS-JRNL-OPERATION-RQST.       
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
                                                                        
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       5750-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     PCS09350
             INCLUDE CPD00003                                           PCS09350
           END-EXEC.                                                    PCS09350
                                                                        
           EXEC SQL                                                             
             INCLUDE CPD0006A                                           PCS09360
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00008                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD0010S                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00073                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 7000-SELECT-AT-PR-CU                                           *        
      ******************************************************************        
                                                                        
       7000-SELECT-AT-PR-CU.                                            
                                                                        
           EXEC SQL                                                     
              SELECT AT.CUSTOMER_NO,                                    
                     AT.CODE_ACCT_STAT,                                 
                     AT.TOTAL_AR_BALANCE,                               
                     AT.DATE_LAST_ACTION,                               
                     AT.LOCAL_OFFICE,                                   
                     AT.PREMISE_NO,                                     
                     AT.CODES_DATA_PRESENT,                             
                     AT.COMPANY_NO,                                     
                     AT.AR_XFER_IND,                                    
                     AT.ACCT_XFER_TO,                                   
                     AT.BANKRUPTCY_IND,                                 
                     AT.CREDIT_GROUP,                                   
                     AT.DATE_BILL_DAY_00,                               
                     AT.DATE_BILL_DAY_30,                               
                     AT.DATE_BILL_DAY_60,                               
                     AT.DATE_BILL_DAY_90,                               
                     AT.CODE_DISC_OK,                                   
                     AT.NOTICE_EXEMPT_CD,                               
                     AT.IVR_EXEMPT_CD,                                  
                     PR.CODE_PREMISE_STAT,                              
                     PR.REV_DISTRICT_CD,                                
                     CU.CODE_EMPL_ACCT,                                 
                     CU.CODE_CUST_STATUS,                               
                     CAST(SYSDATETIMEOFFSET() AS DATE)                          
             INTO    :AT-CUSTOMER-NO,                                   
                     :AT-CODE-ACCT-STAT,                                
                     :AT-TOTAL-AR-BALANCE,                              
                     :AT-DATE-LAST-ACTION,                              
                     :AT-LOCAL-OFFICE,                                  
                     :AT-PREMISE-NO,                                    
                     :AT-CODES-DATA-PRESENT,                            
                     :AT-COMPANY-NO,                                    
                     :AT-AR-XFER-IND,                                   
                     :AT-ACCT-XFER-TO,                                  
                     :AT-BANKRUPTCY-IND,                                
                     :AT-CREDIT-GROUP,                                  
                     :AT-DATE-BILL-DAY-00 :WS-NULL-INDICATOR-1,          
                     :AT-DATE-BILL-DAY-30 :WS-NULL-INDICATOR-2,          
                     :AT-DATE-BILL-DAY-60 :WS-NULL-INDICATOR-3,          
                     :AT-DATE-BILL-DAY-90 :WS-NULL-INDICATOR-4,          
                     :AT-CODE-DISC-OK,                                  
                     :AT-NOTICE-EXEMPT-CD,                              
                     :AT-IVR-EXEMPT-CD,                                 
                     :PR-CODE-PREMISE-STAT,                             
                     :PR-REV-DISTRICT-CD,                               
                     :CU-CODE-EMPL-ACCT,                                
                     :CU-CODE-CUST-STATUS,                              
                     :WS-CURRENT-DATE                                   
            FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED), CSS_PREMISE PR
                           WITH(READUNCOMMITTED), CSS_CUSTOMER CU
                           WITH(READUNCOMMITTED)        
            WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO AND                   
                  AT.PREMISE_NO  = PR.PREMISE_NO  AND                   
                  AT.CUSTOMER_NO = CU.CUSTOMER_NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     12270014
MFA-TR*       SELECT AT.CUSTOMER_NO,                                    PCS15140
MFA-TR*              AT.CODE_ACCT_STAT,                                 PCS15150
MFA-TR*              AT.TOTAL_AR_BALANCE,                               PCS15160
MFA-TR*              AT.DATE_LAST_ACTION,                               PCS15170
MFA-TR*              AT.LOCAL_OFFICE,                                   12330016
MFA-TR*              AT.PREMISE_NO,                                     PCS15180
MFA-TR*              AT.CODES_DATA_PRESENT,                             PCS15180
MFA-TR*              AT.COMPANY_NO,                                     12350016
MFA-TR*              AT.AR_XFER_IND,                                            
MFA-TR*              AT.ACCT_XFER_TO,                                           
MFA-TR*              AT.BANKRUPTCY_IND,                                 12360016
MFA-TR*              AT.CREDIT_GROUP,                                           
MFA-TR*              AT.DATE_BILL_DAY_00,                                       
MFA-TR*              AT.DATE_BILL_DAY_30,                                       
MFA-TR*              AT.DATE_BILL_DAY_60,                                       
MFA-TR*              AT.DATE_BILL_DAY_90,                                       
MFA-TR*              AT.CODE_DISC_OK,                                           
MFA-TR*              AT.NOTICE_EXEMPT_CD,                                       
MFA-TR*              AT.IVR_EXEMPT_CD,                                          
MFA-TR*              PR.CODE_PREMISE_STAT,                              PCS15210
MFA-TR*              PR.REV_DISTRICT_CD,                                        
MFA-TR*              CU.CODE_EMPL_ACCT,                                 PCS15220
MFA-TR*              CU.CODE_CUST_STATUS,                               PCS15220
MFA-TR*              CURRENT DATE                                               
MFA-TR*      INTO    :AT-CUSTOMER-NO,                                   PCS15230
MFA-TR*              :AT-CODE-ACCT-STAT,                                PCS15150
MFA-TR*              :AT-TOTAL-AR-BALANCE,                              PCS15160
MFA-TR*              :AT-DATE-LAST-ACTION,                              PCS15170
MFA-TR*              :AT-LOCAL-OFFICE,                                  12330016
MFA-TR*              :AT-PREMISE-NO,                                    PCS15180
MFA-TR*              :AT-CODES-DATA-PRESENT,                            PCS15180
MFA-TR*              :AT-COMPANY-NO,                                    12350016
MFA-TR*              :AT-AR-XFER-IND,                                           
MFA-TR*              :AT-ACCT-XFER-TO,                                          
MFA-TR*              :AT-BANKRUPTCY-IND,                                12360016
MFA-TR*              :AT-CREDIT-GROUP,                                          
MFA-TR*              :AT-DATE-BILL-DAY-00:WS-NULL-INDICATOR-1,                  
MFA-TR*              :AT-DATE-BILL-DAY-30:WS-NULL-INDICATOR-2,                  
MFA-TR*              :AT-DATE-BILL-DAY-60:WS-NULL-INDICATOR-3,                  
MFA-TR*              :AT-DATE-BILL-DAY-90:WS-NULL-INDICATOR-4,                  
MFA-TR*              :AT-CODE-DISC-OK,                                          
MFA-TR*              :AT-NOTICE-EXEMPT-CD,                                      
MFA-TR*              :AT-IVR-EXEMPT-CD,                                         
MFA-TR*              :PR-CODE-PREMISE-STAT,                             PCS15210
MFA-TR*              :PR-REV-DISTRICT-CD,                                       
MFA-TR*              :CU-CODE-EMPL-ACCT,                                PCS15220
MFA-TR*              :CU-CODE-CUST-STATUS,                              PCS15220
MFA-TR*              :WS-CURRENT-DATE                                           
MFA-TR*     FROM CSS_ACCOUNT AT, CSS_PREMISE PR, CSS_CUSTOMER CU        PCS15240
MFA-TR*     WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO AND                   PCS15240
MFA-TR*           AT.PREMISE_NO  = PR.PREMISE_NO  AND                   PCS15240
MFA-TR*           AT.CUSTOMER_NO = CU.CUSTOMER_NO                       PCS15240
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                    12490016

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-NULL-INDICATOR-1 < ZERO                             
                 MOVE LOW-VALUES         TO AT-DATE-BILL-DAY-00         
              END-IF                                                    
              IF WS-NULL-INDICATOR-2 < ZERO                             
                 MOVE LOW-VALUES         TO AT-DATE-BILL-DAY-30         
              END-IF                                                    
              IF WS-NULL-INDICATOR-3 < ZERO                             
                 MOVE LOW-VALUES         TO AT-DATE-BILL-DAY-60         
              END-IF                                                    
              IF WS-NULL-INDICATOR-4 < ZERO                             
                 MOVE LOW-VALUES         TO AT-DATE-BILL-DAY-90         
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'CSS_PREMISE'         TO TABLE-2                     
              MOVE 'CSS_CUSTOMER'        TO TABLE-3                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-SELECT-NSF-HIST                                           *        
      ******************************************************************        
                                                                        
       7100-SELECT-NSF-HIST.                                            
                                                                        
           EXEC SQL                                                     
            SELECT NSF_CHARGE_AMT,                                      
                   NSF_TYPE_CD,                                         
                   RETURN_CHECK_AMT,                                    
                   REPLACE(REPLACE(CONVERT(CHAR(26), TRANS_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') TRANS_HIST_SEQ_NO                      
             INTO  :NH-NSF-CHARGE-AMT,                                  
                   :NH-NSF-TYPE-CD,                                     
                   :NH-RETURN-CHECK-AMT,                                
                   :NH-TRANS-HIST-SEQ-NO                                
            FROM CSS_NSF_HIST WITH(READUNCOMMITTED)                             
            WHERE  ACCOUNT_NO        = :NH-ACCOUNT-NO                   
            AND    NSF_TIMESTMP      = CIS.CHAR2TIMESTAMP(
                                                       :NH-NSF-TIMESTMP
              )                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     12270014
MFA-TR*     SELECT NSF_CHARGE_AMT,                                      PCS15140
MFA-TR*            NSF_TYPE_CD,                                                 
MFA-TR*            RETURN_CHECK_AMT,                                            
MFA-TR*            TRANS_HIST_SEQ_NO                                            
MFA-TR*      INTO  :NH-NSF-CHARGE-AMT,                                  PCS15230
MFA-TR*            :NH-NSF-TYPE-CD,                                             
MFA-TR*            :NH-RETURN-CHECK-AMT,                                        
MFA-TR*            :NH-TRANS-HIST-SEQ-NO                                        
MFA-TR*     FROM CSS_NSF_HIST                                           PCS15240
MFA-TR*     WHERE  ACCOUNT_NO        = :NH-ACCOUNT-NO                   PCS15240
MFA-TR*     AND    NSF_TIMESTMP      = :NH-NSF-TIMESTMP                 PCS15240
MFA-TR*     WITH UR                                                     PCS15240
MFA-TR*     QUERYNO 7100                                                        
MFA-TR*    END-EXEC.                                                    12490016

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_NSF_HIST'        TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE NH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7150-SELECT-BANK-GL                                            *        
      * SELECT BANK ID AND BANK-GL-NO FROM CSS_NSF_HIST AND CSS_BANK TO*        
      * DEBIT BANK GL WHILE REVERSING RETURN CHECK                     *        
      ******************************************************************        
                                                                        
       7150-SELECT-BANK-GL.                                             
                                                                        
           MOVE '7150' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               SELECT D1.CASH_GL_ACCT_NO,                               
                      D1.FCS_DEP_BANK_CD,                               
                      D1.FCS_DEP_BANK_ST_CD,                            
                      D1.BANK_ID                                        
               INTO   :D1-CASH-GL-ACCT-NO,                              
                      :D1-FCS-DEP-BANK-CD,                              
                      :D1-FCS-DEP-BANK-ST-CD,                           
                      :D1-BANK-ID                                       
               FROM   CSS_NSF_HIST NH WITH(READUNCOMMITTED), CSS_BANK D1
                           WITH(READUNCOMMITTED)                      
               WHERE  NH.ACCOUNT_NO   = :NH-ACCOUNT-NO                  
               AND    NH.NSF_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                       :NH-NSF-TIMESTMP
              )                
               AND    NH.BANK_ID      = D1.BANK_ID                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT D1.CASH_GL_ACCT_NO,                                       
MFA-TR*               D1.FCS_DEP_BANK_CD,                                       
MFA-TR*               D1.FCS_DEP_BANK_ST_CD,                                    
MFA-TR*               D1.BANK_ID                                                
MFA-TR*        INTO   :D1-CASH-GL-ACCT-NO,                                      
MFA-TR*               :D1-FCS-DEP-BANK-CD,                                      
MFA-TR*               :D1-FCS-DEP-BANK-ST-CD,                                   
MFA-TR*               :D1-BANK-ID                                               
MFA-TR*        FROM   CSS_NSF_HIST NH, CSS_BANK D1                              
MFA-TR*        WHERE  NH.ACCOUNT_NO   = :NH-ACCOUNT-NO                          
MFA-TR*        AND    NH.NSF_TIMESTMP = :NH-NSF-TIMESTMP                        
MFA-TR*        AND    NH.BANK_ID      = D1.BANK_ID                              
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7150                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7150'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_NSF_HIST'        TO TABLE-1                     
              MOVE 'CSS_BANK'            TO TABLE-2                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'NSF_TIMESTMP'        TO TABLE-ELEMENT-2             
              MOVE NH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE NH-NSF-TIMESTMP       TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7170-SELECT-RECONNECT                                          *        
      ******************************************************************        
                                                                        
       7170-SELECT-RECONNECT.                                           
                                                                        
           EXEC SQL                                                     
               SELECT AMT_TOT_RECONNECT                                 
                 INTO :DL-AMT-TOT-RECONNECT                             
              FROM CSS_RECONNECT WITH(READUNCOMMITTED)                          
              WHERE ACCOUNT_NO = :DL-ACCOUNT-NO                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02499031
MFA-TR*        SELECT AMT_TOT_RECONNECT                                         
MFA-TR*          INTO :DL-AMT-TOT-RECONNECT                                     
MFA-TR*       FROM CSS_RECONNECT                                        02504032
MFA-TR*       WHERE ACCOUNT_NO = :DL-ACCOUNT-NO                         02504531
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7170                                                      
MFA-TR*    END-EXEC.                                                    02504731

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7170'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_RECONNECT'       TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE DL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7251-SELECT-ACTIVE-NSC                                         *        
      ******************************************************************        
                                                                        
       7251-SELECT-ACTIVE-NSC.                                          
                                                                        
           EXEC SQL                                                     
               SELECT AMT_AR_DAY_00 +                                   
                      AMT_AR_DAY_30 +                                   
                      AMT_AR_DAY_60 +                                   
                      AMT_AR_DAY_90                                     
               INTO :WS-ACTIVE-NSC-AMT :WS-NULL-IND                      
               FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                           
               WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = 19                             
                 AND ITEM_ID           = 0                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AMT_AR_DAY_00 +                                           
MFA-TR*               AMT_AR_DAY_30 +                                           
MFA-TR*               AMT_AR_DAY_60 +                                           
MFA-TR*               AMT_AR_DAY_90                                             
MFA-TR*        INTO :WS-ACTIVE-NSC-AMT:WS-NULL-IND                              
MFA-TR*        FROM CSS_AR_CNTL                                                 
MFA-TR*        WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                         
MFA-TR*          AND PYMT_PRIORITY_LVL = 19                                     
MFA-TR*          AND ITEM_ID           = 0                                      
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7251                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7251'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
                                                                        
       7251-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7252-SELECT-WO-NSC                                             *        
      ******************************************************************        
                                                                        
       7252-SELECT-WO-NSC.                                              
                                                                        
           EXEC SQL                                                     
               SELECT AMT_TRANS                                         
               INTO :WS-WO-NSC-AMT                                      
               FROM CSS_CHRG_OFF WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO        = :CO-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = 19                             
                 AND ITEM_ID           = 0                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AMT_TRANS                                                 
MFA-TR*        INTO :WS-WO-NSC-AMT                                              
MFA-TR*        FROM CSS_CHRG_OFF                                                
MFA-TR*        WHERE ACCOUNT_NO        = :CO-ACCOUNT-NO                         
MFA-TR*          AND PYMT_PRIORITY_LVL = 19                                     
MFA-TR*          AND ITEM_ID           = 0                                      
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7252                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7252'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CHRG_OFF'        TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE CO-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
                                                                        
       7252-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7320-SELECT-CASHIER                                            *        
      ******************************************************************        
                                                                        
       7320-SELECT-CASHIER.                                             
                                                                        
           MOVE '7320'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
             SELECT USER_ID                                             
               INTO :Y2-USER-ID                                         
               FROM CSS_CASHIER_OFFICE WITH(READUNCOMMITTED)                    
              WHERE CASH_COMPANY_NO    = :Y2-CASH-COMPANY-NO            
                AND CASH_LOCAL_OFFICE  = :Y2-CASH-LOCAL-OFFICE          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT USER_ID                                                     
MFA-TR*        INTO :Y2-USER-ID                                                 
MFA-TR*        FROM CSS_CASHIER_OFFICE                                          
MFA-TR*       WHERE CASH_COMPANY_NO    = :Y2-CASH-COMPANY-NO                    
MFA-TR*         AND CASH_LOCAL_OFFICE  = :Y2-CASH-LOCAL-OFFICE                  
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7320                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7320'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CASHIER_OFFICE'  TO TABLE-1                     
              MOVE 'CASH COMPANY NO'     TO TABLE-ELEMENT-1             
              MOVE 'CASH LOCAL OFFICE'   TO TABLE-ELEMENT-2             
              MOVE Y2-CASH-COMPANY-NO    TO HOSTVAR-ELEMENT-1           
              MOVE Y2-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7325-SELECT-CASH-REPORT                                        *        
      ******************************************************************        
                                                                        
       7325-SELECT-CASH-REPORT.                                         
                                                                        
           MOVE '7325'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
             SELECT USER_ID                                             
               INTO :YR-USER-ID                                         
               FROM CSS_CSH_REPORT_HDR WITH(READUNCOMMITTED)                    
              WHERE CASH_COMPANY_NO    = :YR-CASH-COMPANY-NO            
                AND CASH_LOCAL_OFFICE  = :YR-CASH-LOCAL-OFFICE          
                AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :YR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YR-DATE-CASH-REPORT
              ), CONVERT(DATE, :YR-DATE-CASH-REPORT) )           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT USER_ID                                                     
MFA-TR*        INTO :YR-USER-ID                                                 
MFA-TR*        FROM CSS_CSH_REPORT_HDR                                          
MFA-TR*       WHERE CASH_COMPANY_NO    = :YR-CASH-COMPANY-NO                    
MFA-TR*         AND CASH_LOCAL_OFFICE  = :YR-CASH-LOCAL-OFFICE                  
MFA-TR*         AND DATE_CASH_REPORT   = :YR-DATE-CASH-REPORT                   
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7325                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7325'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CSH_REPORT_HDR'  TO TABLE-1                     
              MOVE 'CASH COMPANY NO'     TO TABLE-ELEMENT-1             
              MOVE 'CASH LOCAL OFFICE'   TO TABLE-ELEMENT-2             
              MOVE 'DATE CASH REPORT'    TO TABLE-ELEMENT-3             
              MOVE YR-CASH-COMPANY-NO    TO HOSTVAR-ELEMENT-1           
              MOVE YR-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-2           
              MOVE YR-DATE-CASH-REPORT   TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7325-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7606-SELECT-ORGPYMT-TRANS-HIST                                 *        
      ******************************************************************        
                                                                        
       7606-SELECT-ORGPYMT-TRANS-HIST.                                  
                                                                        
           MOVE '7606' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               SELECT DATE_ORIG_PYMT                                    
               INTO  :AR-DATE-ORIG-PYMT                                 
               FROM  CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                
                  AND TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :NH-TRANS-HIST-SEQ-NO
              )         
                  AND DATE_ORIG_PYMT    IS NOT NULL                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00210000
MFA-TR*        SELECT DATE_ORIG_PYMT                                            
MFA-TR*        INTO  :AR-DATE-ORIG-PYMT                                         
MFA-TR*        FROM  CSS_AR_TRANS_HIST                                          
MFA-TR*         WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                        
MFA-TR*           AND TRANS_HIST_SEQ_NO = :NH-TRANS-HIST-SEQ-NO                 
MFA-TR*           AND DATE_ORIG_PYMT    IS NOT NULL                             
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7606                                                  
MFA-TR*    END-EXEC.                                                    00480000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7606'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'TRANS_HIST_SEQ_NO'       TO TABLE-ELEMENT-2         
              MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE NH-TRANS-HIST-SEQ-NO      TO HOSTVAR-ELEMENT-2       
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
                                                                        
       7606-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7607A-OPEN-TRANS-HIST-CURSOR                                   *        
      * THIS PARAGRAPH IS USED TO OPEN THE CURSOR USED TO FETCH A ROW  *        
      * AND UPDATE A ROW FROM CSS-AR-TRANS-HIST.                       *        
      ******************************************************************        
                                                                        
       7607A-OPEN-TRANS-HIST-CURSOR.                                    
                                                                        
           MOVE '7607A'              TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
               OPEN TRANS-HIST-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7607A'                    TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST'        TO TABLE-1                
              MOVE 'AR_ACCOUNT-NO'            TO TABLE-ELEMENT-1        
              MOVE AR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7607A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7607B-FETCH-TRANS-HIST-CURSOR                                  *        
      ******************************************************************        
                                                                        
       7607B-FETCH-TRANS-HIST-CURSOR.                                   
                                                                        
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OBTAIN THE NEXT ROW FROM THE      **        
      **  CSS_AR_TTRANS_HIST TABLE.                                   **        
      ******************************************************************        
      *                                                                         
           MOVE '7607B'              TO ACTIVE-PARAGRAPH.               
           EXEC SQL                                                     
               FETCH TRANS-HIST-CURSOR                                  
               INTO :AR-PYMT-REFUNDED-IND                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                         OR NOT-FOUND                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7607B'                    TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST'        TO TABLE-1                
              MOVE 'AR_ACCOUNT_NO'            TO TABLE-ELEMENT-1        
              MOVE AR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7607B-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7607C-UPDATE-REFIND-TRANS-HIST                                *         
      *****************************************************************         
                                                                        
       7607C-UPDATE-REFIND-TRANS-HIST.                                  
                                                                        
           MOVE '7607C' TO ACTIVE-PARAGRAPH.                            
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_AR_TRANS_HIST                                 
                  SET PYMT_REFUNDED_IND = ' '                           
                WHERE CURRENT OF TRANS-HIST-CURSOR                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7607C'                   TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'AMT_ORIG_ENTERED'        TO TABLE-ELEMENT-2         
              MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AR-DATE-ORIG-PYMT         TO HOSTVAR-ELEMENT-2       
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
                                                                        
       7607C-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7607D-CLOSE-TRANS-HIST-CURSOR                                  *        
      ******************************************************************        
                                                                        
       7607D-CLOSE-TRANS-HIST-CURSOR.                                   
                                                                        
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO CLOSE THE CURSOR USED TO FETCH    **        
      **  ROWS FROM THE CSS_AR_TRANS_HIST TABLE                       **        
      ******************************************************************        
      *                                                                         
           MOVE '7607D'              TO ACTIVE-PARAGRAPH.               
           EXEC SQL                                                     
               CLOSE TRANS-HIST-CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '760DC'                    TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST'        TO TABLE-1                
              MOVE 'AR_ACCOUNT_NO'            TO TABLE-ELEMENT-1        
              MOVE AR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7607D-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7610-GET-CURRENT-TIMESTAMP                                     *        
      ******************************************************************        
                                                                        
       7610-GET-CURRENT-TIMESTAMP.                                      
                                                                        
      **************************************************                        
      * CHANGED  BY ABHIJIT GHOSH TO GET THE DATE AND                           
      * TIMESTAMP DIRECTLY WIHTOUT USING CSS_MODEL_SQL                          
      **************************************************                        
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE WS-CURRENT-TIMESTAMP  TO AR-TRANS-HIST-SEQ-NO.          
                                                                        
       7610-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ***************************************************************           
      * 7700-GET-GL-NO                                              *           
      ***************************************************************           
                                                                        
       7700-GET-GL-NO.                                                  
                                                                        
           EXEC SQL                                                     
              SELECT GL_ACCT_NO                                         
                INTO :GO-GL-ACCT-NO                                     
                FROM CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                       
               WHERE COMPANY_NO   = '01'                                
                 AND GL_ACCT_NAME = :GO-GL-ACCT-NAME                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT GL_ACCT_NO                                                 
MFA-TR*         INTO :GO-GL-ACCT-NO                                             
MFA-TR*         FROM CSS_GL_ACCT_NO                                             
MFA-TR*        WHERE COMPANY_NO   = '01'                                        
MFA-TR*          AND GL_ACCT_NAME = :GO-GL-ACCT-NAME                            
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7700                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7700'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_GL_ACCT_NO'      TO TABLE-1                     
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1             
              MOVE 'GL_ACCT_NAME'        TO TABLE-ELEMENT-2             
              MOVE '01'                  TO HOSTVAR-ELEMENT-1           
              MOVE GO-GL-ACCT-NAME       TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9000-EXIT                 
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8200-DELETE-RETURN-CHECK                                       *        
      * DELETE RECORD IN CSS_NSF_HIST FOR AN ACCOUNT AND TIMESTMP      *        
      ******************************************************************        
                                                                        
       8200-DELETE-RETURN-CHECK.                                        
                                                                        
           MOVE '8200'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_NSF_HIST                                 
               WHERE  ACCOUNT_NO        = :NH-ACCOUNT-NO                
               AND    NSF_TIMESTMP      = CIS.CHAR2TIMESTAMP(
                                                       :NH-NSF-TIMESTMP
              )              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_NSF_HIST                                         
MFA-TR*        WHERE  ACCOUNT_NO        = :NH-ACCOUNT-NO                        
MFA-TR*        AND    NSF_TIMESTMP      = :NH-NSF-TIMESTMP                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'DELETE'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_NSF_HIST'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'NSF_TIMESTMP'             TO TABLE-ELEMENT-2        
              MOVE NH-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE NH-NSF-TIMESTMP            TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8210-DELETE-FUTURE-DNP                                         *        
      * DELETE RECORD IN CSS_CRED_COLL FOR AN ACCOUNT                  *        
      ******************************************************************        
                                                                        
       8210-DELETE-FUTURE-DNP.                                          
                                                                        
           MOVE '8210'                   TO ACTIVE-PARAGRAPH.           
           MOVE NH-ACCOUNT-NO            TO CL-ACCOUNT-NO.              
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_CRED_COLL                                
               WHERE  ACCOUNT_NO        = :CL-ACCOUNT-NO                
               AND    CODE_NOTICE_TYPE  = 'H'                           
               AND    DATE_CREDIT_ACTION > CAST(SYSDATETIMEOFFSET() 
           AS DATE)                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_CRED_COLL                                        
MFA-TR*        WHERE  ACCOUNT_NO        = :CL-ACCOUNT-NO                        
MFA-TR*        AND    CODE_NOTICE_TYPE  = 'H'                                   
MFA-TR*        AND    DATE_CREDIT_ACTION > CURRENT DATE                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               OR NOT-FOUND                                             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'DELETE'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CRED_COLL'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE CL-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8220-DELETE-FUTURE-NOTICE                                      *        
      * DELETE RECORD IN CSS_CRED_COLL FOR AN ACCOUNT                  *        
      ******************************************************************        
      *                                                                         
       8220-DELETE-FUTURE-NOTICE.                                       
      *                                                                         
           MOVE '8220'                   TO ACTIVE-PARAGRAPH.           
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM CSS_CRED_COLL                                
               WHERE  ACCOUNT_NO        = :CL-ACCOUNT-NO                
               AND    CODE_NOTICE_TYPE  IN ('N', 'V', 'W')              
               AND    DATE_NOTICE_MAIL  > CAST(SYSDATETIMEOFFSET() 
           AS DATE)                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_CRED_COLL                                        
MFA-TR*        WHERE  ACCOUNT_NO        = :CL-ACCOUNT-NO                        
MFA-TR*        AND    CODE_NOTICE_TYPE  IN ('N', 'V', 'W')                      
MFA-TR*        AND    DATE_NOTICE_MAIL  > CURRENT DATE                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               OR NOT-FOUND                                             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'DELETE'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CRED_COLL'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE CL-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8225-DELETE-FUTURE-LETTER                                      *        
      * DELETE RECORD IN CSS_FIN_WO_ACTION FOR AN ACCOUNT              *        
      ******************************************************************        
                                                                        
       8225-DELETE-FUTURE-LETTER.                                       
                                                                        
           MOVE '8225'                   TO ACTIVE-PARAGRAPH.           
      *                                                                         
           EXEC SQL                                                     
             DELETE FROM CSS_FIN_WO_ACTION                              
             WHERE ACCOUNT_NO       = :KD-ACCOUNT-NO                    
             AND FW_ACTION_TYPE_CD  = '90205'                           
             AND FW_ACTION_COMMENTS = :KD-FW-ACTION-COMMENTS            
             AND FW_ACTION_AM       = (:NH-RETURN-CHECK-AMT +           
                                       :NH-NSF-CHARGE-AMT)              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
              OR NOT-FOUND                                              
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'DELETE'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_FIN_WO_ACTION'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE KD-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'FW-ACTION-COMMENTS'       TO TABLE-ELEMENT-2        
              MOVE KD-FW-ACTION-COMMENTS      TO HOSTVAR-ELEMENT-2      
              MOVE 'RETURN-CHECK-AMT'         TO TABLE-ELEMENT-3        
              MOVE NH-RETURN-CHECK-AMT        TO HOSTVAR-ELEMENT-3-N    
              MOVE 'NSF-CHARGE-AMT'           TO TABLE-ELEMENT-4        
              MOVE NH-NSF-CHARGE-AMT          TO HOSTVAR-ELEMENT-4-N    
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8225-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8300-CREATE-BANK-TRANSFER                                      *        
      ******************************************************************        
                                                                        
       8300-CREATE-BANK-TRANSFER.                                       
                                                                        
           MOVE '8300'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
            INSERT INTO CSS_BANK_TRANSFER                               
                   ( CASH_COMPANY_NO,                                   
                     CASH_LOCAL_OFFICE,                                 
                     DATE_CASH_REPORT,                                  
                     CASH_DRAWER_ID,                                    
                     TRANSFER_TS,                                       
                     CURRENCY_TYPE,                                     
                     USER_ID,                                           
                     BANK_ID,                                           
                     TRANSFER_AMT,                                      
                     CODE_DR_CR,                                        
                     TREASURY_EXTR_CD,                                  
                     BANK_POST_DT)                                      
                     VALUES (                                           
                     :YB-CASH-COMPANY-NO,                               
                     :YB-CASH-LOCAL-OFFICE,                             
                     IIF(TRY_CONVERT(DATE, :YB-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YB-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YB-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YB-DATE-CASH-REPORT
              ), CONVERT(DATE, :YB-DATE-CASH-REPORT) ),                        
                     :YB-CASH-DRAWER-ID,                                
                     CIS.CURRENT$TIMESTAMP(),                                 
                     :YB-CURRENCY-TYPE,                                 
                     :YB-USER-ID,                                       
                     :YB-BANK-ID,                                       
                     :YB-TRANSFER-AMT,                                  
                     :YB-CODE-DR-CR,                                    
                     :YB-TREASURY-EXTR-CD,                              
                     CAST(SYSDATETIMEOFFSET() AS DATE))                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     INSERT INTO CSS_BANK_TRANSFER                                       
MFA-TR*            ( CASH_COMPANY_NO,                                           
MFA-TR*              CASH_LOCAL_OFFICE,                                         
MFA-TR*              DATE_CASH_REPORT,                                          
MFA-TR*              CASH_DRAWER_ID,                                            
MFA-TR*              TRANSFER_TS,                                               
MFA-TR*              CURRENCY_TYPE,                                             
MFA-TR*              USER_ID,                                                   
MFA-TR*              BANK_ID,                                                   
MFA-TR*              TRANSFER_AMT,                                              
MFA-TR*              CODE_DR_CR,                                                
MFA-TR*              TREASURY_EXTR_CD,                                          
MFA-TR*              BANK_POST_DT)                                              
MFA-TR*              VALUES (                                                   
MFA-TR*              :YB-CASH-COMPANY-NO,                                       
MFA-TR*              :YB-CASH-LOCAL-OFFICE,                                     
MFA-TR*              :YB-DATE-CASH-REPORT,                                      
MFA-TR*              :YB-CASH-DRAWER-ID,                                        
MFA-TR*              CURRENT TIMESTAMP,                                         
MFA-TR*              :YB-CURRENCY-TYPE,                                         
MFA-TR*              :YB-USER-ID,                                               
MFA-TR*              :YB-BANK-ID,                                               
MFA-TR*              :YB-TRANSFER-AMT,                                          
MFA-TR*              :YB-CODE-DR-CR,                                            
MFA-TR*              :YB-TREASURY-EXTR-CD,                                      
MFA-TR*              CURRENT DATE)                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8300'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE 'CSS_BANK_TRANSFER'   TO TABLE-1                     
              MOVE 'CASH COMPANY NO'     TO TABLE-ELEMENT-1             
              MOVE 'CASH LOCAL OFFICE'   TO TABLE-ELEMENT-2             
              MOVE 'DATE CASH REPORT'    TO TABLE-ELEMENT-3             
              MOVE 'CASH DRAWER ID'      TO TABLE-ELEMENT-4             
              MOVE YB-CASH-COMPANY-NO    TO HOSTVAR-ELEMENT-1           
              MOVE YB-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-2           
              MOVE YB-DATE-CASH-REPORT   TO HOSTVAR-ELEMENT-3           
              MOVE YB-CASH-DRAWER-ID     TO HOSTVAR-ELEMENT-4           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8325-CREATE-CASH-REPORT                                        *        
      ******************************************************************        
                                                                        
       8325-CREATE-CASH-REPORT.                                         
                                                                        
           MOVE '8325'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_CSH_REPORT_HDR                             
                    ( CASH_COMPANY_NO,                                  
                      CASH_LOCAL_OFFICE,                                
                      DATE_CASH_REPORT,                                 
                      USER_ID,                                          
                      STATUS,                                           
                      CLOSED_TS)                                        
             VALUES ( :YR-CASH-COMPANY-NO                               
                      ,:YR-CASH-LOCAL-OFFICE                            
                      ,IIF(TRY_CONVERT(DATE, :YR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YR-DATE-CASH-REPORT
              ), CONVERT(DATE, :YR-DATE-CASH-REPORT) )                         
                      ,:YR-USER-ID                                      
                      ,:YR-STATUS                                       
                      ,CIS.CURRENT$TIMESTAMP())                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_CSH_REPORT_HDR                                     
MFA-TR*             ( CASH_COMPANY_NO,                                          
MFA-TR*               CASH_LOCAL_OFFICE,                                        
MFA-TR*               DATE_CASH_REPORT,                                         
MFA-TR*               USER_ID,                                                  
MFA-TR*               STATUS,                                                   
MFA-TR*               CLOSED_TS)                                                
MFA-TR*      VALUES ( :YR-CASH-COMPANY-NO                                       
MFA-TR*               ,:YR-CASH-LOCAL-OFFICE                                    
MFA-TR*               ,:YR-DATE-CASH-REPORT                                     
MFA-TR*               ,:YR-USER-ID                                              
MFA-TR*               ,:YR-STATUS                                               
MFA-TR*               ,CURRENT TIMESTAMP)                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8325'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CSH_REPORT_HDR'  TO TABLE-1                     
              MOVE 'CASH COMPANY NO'     TO TABLE-ELEMENT-1             
              MOVE 'CASH LOCAL OFFICE'   TO TABLE-ELEMENT-2             
              MOVE 'DATE CASH REPORT'    TO TABLE-ELEMENT-3             
              MOVE YR-CASH-COMPANY-NO    TO HOSTVAR-ELEMENT-1           
              MOVE YR-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-2           
              MOVE YR-DATE-CASH-REPORT   TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       8325-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8999-ISSUE-COMMIT                                              *        
      ******************************************************************        
                                                                        
       8999-ISSUE-COMMIT.                                               
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00047                                                  
           END-EXEC.                                                            
                                                    
                                                                        
       8999-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     14890000
              INCLUDE CPD00075                                          14900000
           END-EXEC.                                                    14910000
                                                                        
      ******************************************************************14920000
      * 9000A-SEND-ERROR-RESULT                                        *        
      ******************************************************************        
                                                                        
       9000A-SEND-ERROR-RESULT.                                         
                                                                        
           MOVE 'N'           TO SEND-DONE-SW.                          
           MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE.                
           PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT.               
           ADD +1                        TO CTR-ROWS.                   
           PERFORM 8900-SEND-DONE        THRU 8900-EXIT.                
                                                                        
       9000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9350-LINK-SCSCO061.                                            *        
      ******************************************************************        
      *                                                                         
       9350-LINK-SCSCO061.                                              
      *                                                                         
           MOVE SPACES                    TO ABEND-FUNCTION.            
           PERFORM 9400-CALL-CPD00061     THRU 9400-EXIT.               
           MOVE RS-RETURN-CODE            TO WS-ACTIVE-RETURN-CODE,     
                                             SQLCODE.                   
           IF ABEND-FUNCTION  > SPACES                                  
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       9350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9400-CALL-CPD00061                                             *        
      * CALLS THE COPYBOOK CPD00061                                    *        
      ******************************************************************        
      *                                                                         
       9400-CALL-CPD00061.                                              
                                                                        
           CALL MCSCO061  USING  WS-GL-ACCT-NAME                        
                                 WS-GL-ACCT-MAJOR-FIELDS                
                                 WS-VALID-COMPANY-NOS                   
                                 WS-GL-NAME-INFO                        
                                 WS-GL-ACCT-NO-TABLE                    
                                 ABEND-FILE                             
                                 RS-RETURN-CODE.                        
           MOVE RS-RETURN-CODE            TO WS-ACTIVE-RETURN-CODE,     
                                             S-RETURN-CODE.             
                                                                        
             IF ABEND-FUNCTION  > SPACES                                
             IF ABEND-FUNCTION EQUAL 'BADDATA'                          
                MOVE -1                  TO RS-RETURN-CODE,             
                                            WS-ACTIVE-RETURN-CODE       
             END-IF                                                     
             PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT              
             PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT               
             END-IF.                                                    
      *                                                                         
       9400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 36421000
      ******************************************************************14860000
      * 9700-PROCESS-ABEND - COMBINED ERROR ON-LINE/BATCH ERROR HANDLER*14870000
      ******************************************************************14880000
                                                                        
           EXEC SQL                                                     14890000
              INCLUDE CPD0023C                                          14900000
           END-EXEC.                                                    14910000
                                                                        
      ******************************************************************00329700
      * CANCEL DNP OR DNPFB                                            *00329800
      ******************************************************************00329900
                                                                        
ACT285 9800-CALL-MCS03414.                                              
                                                                        
ACT285     CALL MCS03414 USING   WS-ACCOUNT-NO-NUM                      
ACT285                          ,WS-UPDATE-ACTION-FL                    
                                ,WS-PYMT-FACILITY                       
                                ,WS-DNP-RET-CODE                        
ACT285                          ,WS-PYMT-AMOUNT                         
ACT285                          ,WS-PAYMENT-AMOUNT-TOTAL                
ACT285                          ,WS-CALL-TYPE                           
ACT285                          ,WS-CPD68-REQUIRED                      
ACT285                          ,WS-PROGRAM-NAME                        
ACT285                          ,WS-CPD68-ACTN-FL                       
ACT285                          ,WS-CNCL-DNP-ACTN-FL                    
P00948                          ,WS-CNCL-DNP-EMAIL-REQ-FL               
ACT285                          ,WS-SO-UPDT-ACTN-FL                     
ACT285                          ,WS-CRED-ARNG-ACTN-FL                   
ACT285                          ,ws-APPL-PROGRAM-ID                     
                                ,ABEND-FILE.                            
                                                                        
       9800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************14860000
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *14870000
      ******************************************************************14880000
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************14930000
      * END PROGRAM COPYLIB                                            *14940000
      ******************************************************************14950000
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE CPD00312                                                  
           END-EXEC.                                                            
                                                                        
