       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04905.                                         
COB303 DATE-WRITTEN.  MARCH 2016.                                       
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00000600
      *                                                                *00000700
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00000800
      *                                                                *00000900
      ******************************************************************00001000
      *                                                                *00001200
      *                P R O G R A M  S U M M A R Y                    *00001100
      *                                                                *00001200
      ******************************************************************00001000
      *                                                                *00001200
      * THIS PROCEDURE IS USED TO POST PAYMENTS FOR MISC-PAYMENTS,     *00180000
      * CORRECTION,REVERSALS LIKE ARMS,CLAIMS.WRITES JOURNAL AND       *00180000
      * UPDATES THE CONTROL ROW FOR CURRENT BATCH.                     *00180000
      *                                                                *00190002
      *                                                                *00001500
      *  BUSOP NAME: REQUUPDMISCPYMTCORRANDREVERSAL BUSINESSOP          00001600
      *                                                                *00001200
      ******************************************************************00001700
      *                                                                *00001800
      *                     PROGRAM MODIFICATION LOG                   *00001900
      *                                                                *00001800
      ******************************************************************00001700
      *                                                                *00002000
      *    DATE    INITIALS   COMMENTS                                 *00002100
      *  --------  --------   ---------------------------------------  *00002200
PRJ586*  03/30/16  AP40911    INITIAL VERSION OF MISC-PAYMENT,         *00002400
      *                       CORRECTION AND REVERSAL PROCESS.         *        
      *                                                                *00002000
      ******************************************************************00003400
      ******************************************************************00003500
      *                                                                *00003600
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00003700
      *                                                                *00003800
      ******************************************************************00003500
      *                                                                *00004800
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00003900
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00004000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00004100
      *  3000 - 4999  NOT USED                                         *00004200
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00004300
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00004400
      *  7000 - 7999  INPUT MODULES                                    *00004500
      *  8000 - 8999  OUTPUT MODULES                                   *00004600
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00004700
      *                                                                *00004800
      ******************************************************************00004900
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04905'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04905 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
      *-- SQL COMMUNICATION AREA                                                
           EXEC SQL                                                     00600000
              INCLUDE SQLCA                                             00610000
           END-EXEC.                                                    00620000
                                                                        
      *-- CS CSS_CSH_DRWR_CNTL                                                  
           EXEC SQL                                                     00840000
              INCLUDE TBCDCNTL                                          00850000
           END-EXEC.                                                    00860000
                                                                        
      *-- CJ CSS_CSH_DRWR_JRNL                                                  
           EXEC SQL                                                     04420000
              INCLUDE TBCDJRNL                                          04430000
           END-EXEC.                                                    04440000
                                                                        
      *-- GO CSS_GL_ACCT_NO                                                     
           EXEC SQL                                                             
              INCLUDE TBGLATNO                                                  
           END-EXEC.                                                            
                                                                        
      *-- Y2 CSS_CASHIER_OFFICE                                                 
           EXEC SQL                                                     01532000
              INCLUDE TBCSHOFF                                          01533000
           END-EXEC.                                                    01534000
                                                                        
      *-- AL CSS_AR_LOCKOUT                                                     
           EXEC SQL                                                             
              INCLUDE TBARLOCK                                                  
           END-EXEC.                                                            
                                                                        
      *-- PF CSS_USER_PROFIL                                                    
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      *-- BC CSS_BCH_JRNL_CNTL                                                  
           EXEC SQL                                                     00840000
              INCLUDE TBBJCNTL                                          00850000
           END-EXEC.                                                    00860000
                                                                        
      *-- BJ CSS_BATCH_JRNL                                             00870000
           EXEC SQL                                                     04420000
              INCLUDE TBBTJRNL                                          04430000
           END-EXEC.                                                    04440000
                                                                        
      *-- MJ CSS_MISC_JRNL                                                      
           EXEC SQL                                                             
              INCLUDE TBMSJRNL                                                  
           END-EXEC.                                                            
                                                                        
      *-- COPYBOOK FOR ERROR HANDLING                                           
           EXEC SQL                                                     00007000
               INCLUDE CWSX0010                                         00007100
           END-EXEC.                                                    00007200
                                                                        
      *-- COPYBOOK TO DECLARE WS VARIABLES FOR PAYMENT ROUTINE                  
           EXEC SQL                                                     PCS00710
              INCLUDE CWS00017                                          PCS00710
           END-EXEC.                                                    PCS00710
                                                                        
      *-- COPYBOOK TO DECLARE JOURNAL VARIABLES AND CWS-13 VARIABLES            
           EXEC SQL                                                             
              INCLUDE CWS0013B                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
      *-- SUPPORTS DB2 AND SQL ERROR CHECKING                                   
            COPY CWS00303.                                                      
                                                                        
      *-- COPYBOOK TO DECLARE 101 JOURNAL VARIABLES                             
            COPY CJF00101.                                                      
                                                                        
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(8)  VALUE 'CSR04905'.     
           05  WS-UPDATE-TYPE           PIC X(01).                      
COB305     05 WS-ACCOUNT-NO        PIC S9(13) COMP-3 VALUE 0.              
           05  WS-AMOUNT-CHECK          PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-AMOUNT-MORDER         PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-AMOUNT-CASH           PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-GL-ACCT-STRING.                                       
               10 WS-GL-ACCT-NO         PIC 9(03)V9(04).                
           05  WS-PYMT-FACILITY-CODE    PIC X(01).                      
           05  WS-ENTRY-NO              PIC S9(4) COMP  VALUE +0.       
           05  WS-TRAN-COMMENT-LEN      PIC S9(04) COMP.                
           05  WS-TRAN-COMMENT-TEXT     PIC X(210).                     
           05  WS-CLR-CASH              PIC X(10) VALUE 'CLR-CASH'.     
           05  WS-MAX-LEN               PIC S9(4) COMP.                 
           05  WS-VARCHAR               PIC X(255).                     
           05  FILLER REDEFINES WS-VARCHAR.                             
               10 WS-VARCHAR-POS        PIC X(01) OCCURS 255.           
           05  WS-VARCHAR-LEN           PIC S9(4) COMP.                 
           05  CTR-ROWS                 PIC S9(9) COMP VALUE 0.         
                                                                        
       01  WS-DATE-VARIABLES.                                           
           05  WS-CURRENT-DATE          PIC X(10).                      
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-Y                     PIC X(01) VALUE 'Y'.            
           05  WS-N                     PIC X(01) VALUE 'N'.            
           05  WS-A                     PIC X(01) VALUE 'A'.            
           05  WS-C                     PIC X(01) VALUE 'C'.            
           05  WS-M                     PIC X(01) VALUE 'M'.            
           05  WS-P                     PIC X(01) VALUE 'P'.            
           05  WS-R                     PIC X(01) VALUE 'R'.            
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09) COMP VALUE +0.        
           05  S-APPL-RETURN-CODE      PIC S9(009) COMP VALUE +0.       
                                                                        
       01  SWITCHES.                                                    
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                  PIC X(18) VALUE SPACES.       
           10  S-SQLCODE                  PIC S9(9) COMP VALUE 0.       
           10  S-SQLSTATE                 PIC X(05) VALUE ' '.          
           10  S-TABLE-NAME               PIC X(18) VALUE SPACES.       
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L     PIC S9(4) USAGE COMP.         
               49  S-HOST-VARIABLES-V     PIC X(255).                   
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L      PIC S9(4) USAGE COMP.         
               49  S-SQL-STATEMENT-V      PIC X(255).                   
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L    PIC S9(4) USAGE COMP.         
               49  S-SQL-DESCRIPTION-V    PIC X(255).                   
                                                                        
      ******************************************************************06900000
      *          CURSOR FOR CSS_CSH_DRWR_JRNL                          *06910000
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE JOURNAL_CURSOR CURSOR FOR                        
                SELECT CURRENCY_TYPE,                                   
                       TRAN_DATA,                                       
                       CODE_PYMT_FACILITY,                              
                       TRAN_APPL_NO                                     
                  FROM CSS_CSH_DRWR_JRNL WITH(READUNCOMMITTED)                  
                 WHERE CASH_COMPANY_NO      = :CJ-CASH-COMPANY-NO       
                   AND CASH_LOCAL_OFFICE    = :CJ-CASH-LOCAL-OFFICE     
                   AND CASH_REPORT_NO       = :CJ-CASH-REPORT-NO        
                   AND DATE_CASH_REPORT     = IIF(TRY_CONVERT(DATE, 
                                                   :CJ-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CJ-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CJ-DATE-CASH-REPORT
              ), CONVERT(DATE, :CJ-DATE-CASH-REPORT) )      
                   AND CASH_DRAWER_ID       = :CJ-CASH-DRAWER-ID        
                   AND USER_ID              = :CJ-USER-ID               
                   AND ENTRY_NO             = :CJ-ENTRY-NO              
                 FOR READ ONLY                                  
                                                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06920000
MFA-TR*        DECLARE JOURNAL_CURSOR CURSOR FOR                        06930000
MFA-TR*         SELECT CURRENCY_TYPE,                                   06940000
MFA-TR*                TRAN_DATA,                                               
MFA-TR*                CODE_PYMT_FACILITY,                                      
MFA-TR*                TRAN_APPL_NO                                             
MFA-TR*           FROM CSS_CSH_DRWR_JRNL                                        
MFA-TR*          WHERE CASH_COMPANY_NO      = :CJ-CASH-COMPANY-NO               
MFA-TR*            AND CASH_LOCAL_OFFICE    = :CJ-CASH-LOCAL-OFFICE             
MFA-TR*            AND CASH_REPORT_NO       = :CJ-CASH-REPORT-NO                
MFA-TR*            AND DATE_CASH_REPORT     = :CJ-DATE-CASH-REPORT              
MFA-TR*            AND CASH_DRAWER_ID       = :CJ-CASH-DRAWER-ID                
MFA-TR*            AND USER_ID              = :CJ-USER-ID                       
MFA-TR*            AND ENTRY_NO             = :CJ-ENTRY-NO                      
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*      QUERYNO 1                                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-USER-ID             PIC  X(07).                         
       01  PARM-UPDATE-TYPE         PIC  X(01).                         
COB305 01 PARM-ACCOUNT-NO        PIC  S9(13) COMP-3 VALUE 0.                 
COB305 01 PARM-GL-ACCT-NO        PIC  S9(03)V9(04) COMP-3 VALUE 0.           
       01  PARM-FACILITY-CODE       PIC  X(01).                         
COB305 01 PARM-AMT-CHECK        PIC  S9(09)V9(02) COMP-3 VALUE 0.           
COB305 01 PARM-AMT-MONEY-ORDER        PIC  S9(09)V9(02) COMP-3 VALUE 0.         
COB305 01 PARM-AMT-CASH        PIC  S9(09)V9(02) COMP-3 VALUE 0.           
       01  PARM-DATE-CASH-REPORT    PIC  X(10).                         
       01  PARM-CASH-COMPANY-NO     PIC  X(02).                         
       01  PARM-CASH-LOCAL-OFFICE   PIC  X(03).                         
       01  PARM-CASH-DRAWER-ID      PIC  S9(04) COMP.                   
       01  PARM-ENTRY-NO            PIC  X(04).                         
       01  PARM-CASH-REPORT-NO      PIC  X(03).                         
       01  PARM-PAYMENT-TRAN-ID     PIC  X(04).                         
       01  PARM-REVERSED-TRAN-ID    PIC  X(04).                         
       01  PARM-REVSL-CORR-TRAN-ID  PIC  X(04).                         
       01  PARM-CNT-CMMNT-LEN       PIC S9(04) COMP.                    
       01  PARM-CNT-CMMNT-TXT       PIC  X(210).                        
                                                                        
       PROCEDURE DIVISION USING  PARM-USER-ID                           
                                 PARM-UPDATE-TYPE                       
                                 PARM-ACCOUNT-NO                        
                                 PARM-GL-ACCT-NO                        
                                 PARM-FACILITY-CODE                     
                                 PARM-AMT-CHECK                         
                                 PARM-AMT-MONEY-ORDER                   
                                 PARM-AMT-CASH                          
                                 PARM-DATE-CASH-REPORT                  
                                 PARM-CASH-COMPANY-NO                   
                                 PARM-CASH-LOCAL-OFFICE                 
                                 PARM-CASH-DRAWER-ID                    
                                 PARM-ENTRY-NO                          
                                 PARM-CASH-REPORT-NO                    
                                 PARM-PAYMENT-TRAN-ID                   
                                 PARM-REVERSED-TRAN-ID                  
                                 PARM-REVSL-CORR-TRAN-ID                
                                 PARM-CNT-CMMNT-LEN                     
                                 PARM-CNT-CMMNT-TXT.                    
                                                                        
      ******************************************************************02140000
      * 0000-MAINLINE                                                  *02150000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02160000
      ******************************************************************02170000
                                                                        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE              THRU 0100-EXIT          
           PERFORM 1000-PROCESS-INPUT           THRU 1000-EXIT          
           PERFORM 2000-PROCESS-OUTPUT          THRU 2000-EXIT          
           PERFORM 9999-END-PROGRAM             THRU 9999-EXIT          
           .                                                            
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************00074400
      *                                                                *03030000
      * 0100-INITIALIZE                                                *03170000
      * INITIALIZE AND DECLARE OUTPUT CURSOR                           *00074500
      *                                                                *03030000
      ******************************************************************00074600
      *                                                                         
       0100-INITIALIZE.                                                 
           MOVE '0100' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
                DECLARE C1 CURSOR  FOR                       
                SELECT                                                  
                     :S-RETURN-CODE         AS RETURN_CODE              
                    ,:S-APPL-RETURN-CODE    AS APPL_RETURN_CODE         
                FROM                                                    
                     CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*              :S-RETURN-CODE         AS RETURN_CODE                      
MFA-TR*             ,:S-APPL-RETURN-CODE    AS APPL_RETURN_CODE                 
MFA-TR*         FROM                                                            
MFA-TR*              SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************02650000
      * 1000-PROCESS-INPUT                                             *02660000
      *                                                                *02680000
      ******************************************************************02700000
      *                                                                 02710000
       1000-PROCESS-INPUT.                                              
           MOVE '1000'                   TO ACTIVE-PARAGRAPH            
                                                                        
           PERFORM 7100-GET-CURRENT-TIMESTAMP   THRU 7100-EXIT          
                                                                        
           MOVE PARM-UPDATE-TYPE         TO WS-UPDATE-TYPE              
           MOVE PARM-ENTRY-NO            TO WS-ENTRY-NO                 
           MOVE PARM-ACCOUNT-NO          TO WS-ACCOUNT-NO               
           MOVE PARM-GL-ACCT-NO          TO WS-GL-ACCT-NO               
           MOVE PARM-FACILITY-CODE       TO WS-PYMT-FACILITY-CODE       
           MOVE WS-PYMT-FACILITY-CODE    TO WS-JRNL-CODE-PYMT-FACILITY  
           MOVE PARM-AMT-CHECK           TO WS-AMOUNT-CHECK             
           MOVE WS-AMOUNT-CHECK          TO WS-AMT-CHECK                
           MOVE PARM-AMT-MONEY-ORDER     TO WS-AMOUNT-MORDER            
           MOVE WS-AMOUNT-MORDER         TO WS-AMT-MONEY-ORDER          
           MOVE PARM-AMT-CASH            TO WS-AMOUNT-CASH              
           MOVE WS-AMOUNT-CASH           TO WS-AMT-CASH                 
                                                                        
           ADD WS-AMOUNT-CHECK                                          
               WS-AMOUNT-MORDER                                         
               WS-AMOUNT-CASH GIVING WS-PAYMENT-AMOUNT                  
                                      WS-PAYMENT-AMOUNT-TOTAL           
                                                                        
           IF PARM-CNT-CMMNT-LEN = 0                                    
              MOVE +210 TO WS-MAX-LEN                                   
              MOVE PARM-CNT-CMMNT-TXT TO WS-VARCHAR                     
              PERFORM 5900-CALC-VARCHAR-LENGTH THRU 5900-EXIT           
              MOVE WS-VARCHAR-LEN TO PARM-CNT-CMMNT-LEN                 
           END-IF                                                       
           MOVE PARM-CNT-CMMNT-LEN           TO WS-TRAN-COMMENT-LEN     
           MOVE PARM-CNT-CMMNT-TXT           TO WS-TRAN-COMMENT-TEXT    
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02780000
      ******************************************************************05110000
      * 2000-PROCESS-OUTPUT.                                           *05120000
      ******************************************************************05190000
      *                                                                 05200000
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000'                          TO ACTIVE-PARAGRAPH     
           PERFORM 7999-SELECT-AL               THRU 7999-SELECT-AL-EXIT
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
              MOVE 5000                         TO S-APPL-RETURN-CODE   
              ADD +1                            TO CTR-ROWS             
              PERFORM 9999-END-PROGRAM          THRU 9999-EXIT          
           END-IF                                                       
                                                                        
           PERFORM 2200-PROCESS-JOURNAL         THRU 2200-EXIT          
           MOVE ZERO                            TO S-RETURN-CODE        
           ADD +1                               TO CTR-ROWS             
           .                                                            
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02780000
      ******************************************************************05110000
      * 2200-PROCESS-JOURNAL.                                          *05120000
      ******************************************************************05190000
      *                                                                 05200000
       2200-PROCESS-JOURNAL.                                            
                                                                        
           MOVE PARM-CASH-COMPANY-NO    TO WS-100-COMPANY-NO            
                                                                        
           MOVE 9                       TO WS-TRAN-OPER-LEVEL           
           MOVE 1                       TO WS-TRAN-OCAP-FIELD           
           MOVE 1                       TO WS-TRAN-OCAP-VALUE           
           MOVE WS-C                    TO WS-TRAN-JRNL-TYPE            
           MOVE WS-N                    TO WS-TRAN-HOLD-EXEMPT-FLAG     
                                                                        
           MOVE PARM-USER-ID            TO WS-JRNL-OL-TEMP-ID           
           MOVE WS-JRNL-CK-OPER-ID      TO WS-JRNL-OPERATION-RQST       
           MOVE PROGRAM-NAME            TO WS-100-CODE-TERMINAL-TRAN    
                                                                        
           EVALUATE PARM-UPDATE-TYPE                                    
             WHEN WS-P                                                  
               MOVE PARM-PAYMENT-TRAN-ID  TO WS-100-CODE-TERMINAL-TRAN  
             WHEN WS-C                                                  
               MOVE PARM-REVSL-CORR-TRAN-ID TO WS-100-CODE-TERMINAL-TRAN
             WHEN WS-R                                                  
               PERFORM 2300-REVERSAL THRU 2300-EXIT                     
               MOVE PARM-REVSL-CORR-TRAN-ID TO WS-100-CODE-TERMINAL-TRAN
           END-EVALUATE                                                 
                                                                        
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT              
                                                                        
           MOVE PARM-CASH-COMPANY-NO    TO WS-JRNL-OL-COMPANY           
                                           Y2-CASH-COMPANY-NO           
           MOVE PARM-CASH-LOCAL-OFFICE  TO WS-JRNL-OL-LOC-OFF           
                                           WS-JRNL-OL-REPORT-NO         
                                           Y2-CASH-LOCAL-OFFICE         
           PERFORM 7700-GET-LOCAL-OFFICE THRU 7700-EXIT                 
           MOVE PARM-DATE-CASH-REPORT   TO WS-JRNL-OL-REPORT-DT         
           MOVE PARM-CASH-DRAWER-ID     TO WS-JRNL-OL-CASH-DRWR         
                                                                        
           MOVE WS-JRNL-OL-OPR-LOC      TO WS-JRNL-OL-TERM-LOC          
                                           WS-JRNL-OL-CASH-LOC          
           MOVE WS-JRNL-VALIDATE-OPER   TO WS-JRNL-OPERATION-RQST       
           MOVE WS-C                    TO WS-JRNL-SOURCE-CODE          
           MOVE WS-JRNL-CASH-UPDATE     TO WS-JRNL-OL-AUTH-TYPE         
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT              
           IF WS-JRNL-RTRN-CODE = WS-JRNL-INVALID-OPER                  
              MOVE 2000                 TO S-APPL-RETURN-CODE           
                                           WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF                                                       
                                                                        
           MOVE WS-A                    TO WS-100-JRNL-SORT-ID          
           MOVE WS-ACCOUNT-NO           TO WS-100-ACCT-NO               
           MOVE ZEROES                  TO WS-100-CUSTOMER-NO           
           MOVE ZEROES                  TO WS-100-PREMISE-NO            
           ADD 1                        TO WS-100-JRNL-TRAN-APPL-NO     
           MOVE WS-CURRENT-DATE         TO WS-100-DATE-LAST-ACTION      
           MOVE WS-C                    TO WS-100-CODE-ENTRY-SOURCE     
           MOVE Y2-LOCAL-OFFICE         TO WS-100-LOCAL-OFFICE-CD       
           MOVE WS-JRNL-OL-COMPANY      TO WS-PAR-COMPANY-NO            
           MOVE WS-JRNL-OL-LOC-OFF      TO WS-PAR-LOCAL-OFFICE          
           MOVE WS-JRNL-OL-REPORT-NO    TO WS-PAR-REPORT-NO             
           MOVE WS-JRNL-OL-REPORT-DT    TO WS-PAR-REPORT-DATE           
           MOVE WS-JRNL-OL-CASH-DRWR    TO WS-PAR-CASH-DRAWER           
           MOVE WS-TERM-LOC             TO WS-PAR-ACCESS-LOC            
           MOVE PARM-USER-ID            TO WS-PAR-OPERATOR-ID           
           MOVE PF-RESP-AREA-ID         TO WS-PAR-RESP-AREA             
           MOVE WS-TRAN-COMMENT-LEN     TO WS-JRNL-TRAN-COMMENT-LEN     
           MOVE WS-TRAN-COMMENT-TEXT    TO WS-JRNL-TRAN-COMMENT-TEXT    
                                                                        
           PERFORM 2210-MOVE-TRAN-DATA-VALUES THRU 2210-EXIT            
                                                                        
           MOVE WS-CLR-CASH              TO GO-GL-ACCT-NAME             
           PERFORM 7400-GL-ACCT-NO       THRU 7400-EXIT                 
           IF WS-UPDATE-TYPE = WS-P                                     
              MOVE GO-GL-ACCT-NO         TO WS-101-ACCT-GEN-LED-DR      
              MOVE WS-GL-ACCT-NO         TO WS-101-ACCT-GEN-LED-CR      
           ELSE                                                         
              MOVE GO-GL-ACCT-NO         TO WS-101-ACCT-GEN-LED-CR      
              MOVE WS-GL-ACCT-NO         TO WS-101-ACCT-GEN-LED-DR      
           END-IF                                                       
                                                                        
           PERFORM UNTIL WS-PAYMENT-AMOUNT = 0                          
              IF WS-AMT-CHECK > 0                                       
                 MOVE WS-C               TO WS-JRNL-CURRENCY-TYPE       
                 SUBTRACT WS-AMT-CHECK FROM WS-PAYMENT-AMOUNT           
                 MOVE WS-AMT-CHECK       TO WS-101-AMT-POSTED           
                 MOVE 0                  TO WS-AMT-CHECK                
              ELSE                                                      
                 IF WS-AMT-CASH > 0                                     
                    MOVE WS-A            TO WS-JRNL-CURRENCY-TYPE       
                    SUBTRACT WS-AMT-CASH FROM WS-PAYMENT-AMOUNT         
                    MOVE WS-AMT-CASH     TO WS-101-AMT-POSTED           
                    MOVE 0               TO WS-AMT-CASH                 
                 ELSE                                                   
                    IF WS-AMT-MONEY-ORDER > 0                           
                      MOVE WS-M          TO WS-JRNL-CURRENCY-TYPE       
                      SUBTRACT WS-AMT-MONEY-ORDER FROM WS-PAYMENT-AMOUNT
                      MOVE WS-AMT-MONEY-ORDER    TO WS-101-AMT-POSTED   
                      MOVE 0             TO WS-AMT-MONEY-ORDER          
                      END-IF                                            
                 END-IF                                                 
              END-IF                                                    
                                                                        
              MOVE CJF00101             TO WS-100-USER-DEFINED-AREA     
                                                                        
              MOVE WS-JRNL-ONLY         TO WS-JRNL-OPERATION-RQST       
                                                                        
              PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT           
                                                                        
              IF WS-JRNL-RTRN-CODE NOT EQUAL SPACES                     
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE 'USERABEN'           TO ABEND-FUNCTION            
                 MOVE WS-Y                 TO WS-USER-FORCE-ABEND       
                 MOVE 'JOURNAL ABEND'      TO DSNTIAR-MESSAGE-1         
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-PERFORM                                                  
                                                                        
           MOVE WS-JRNL-CNTRL-ONLY      TO WS-JRNL-OPERATION-RQST.      
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
           IF WS-JRNL-RTRN-CODE NOT EQUAL SPACES                        
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'USERABEN'           TO ABEND-FUNCTION               
              MOVE WS-Y                 TO WS-USER-FORCE-ABEND          
              MOVE 'JOURNAL ABEND'      TO DSNTIAR-MESSAGE-1            
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF                                                       
           .                                                            
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02780000
      ******************************************************************05110000
      * 2210-MOVE-TRAN-DATA-VALUES.                                    *05120000
      *                                                                *05130000
      ******************************************************************05190000
      *                                                                 05200000
       2210-MOVE-TRAN-DATA-VALUES.                                      
           INITIALIZE CJF00101                                          
           MOVE 101                      TO WS-101-JRNL-FORMAT-NO       
           MOVE WS-ACCOUNT-NO            TO WS-101-FCS-ACCT-NO(1:13)    
           MOVE WS-GL-ACCT-STRING        TO WS-101-FCS-ACCT-NO(14:7)    
           MOVE WS-PAYMENT-AMOUNT-TOTAL  TO WS-101-AMOUNT-ENTERED       
                                                                        
           MOVE SPACES                   TO WS-101-AR-AGE               
                                            WS-101-CASH-DRAWER-USED     
                                            WS-101-DATE-AR-BILLED       
                                            WS-101-FCS-DEP-BANK-CD      
                                            WS-101-FCS-DEP-BANK-ST-CD   
                                            WS-101-FUNCTION-CODE        
                                            WS-101-CODE-REVENUE-DISTRICT
                                            WS-101-CODE-EMPL-ACCT       
                                            WS-101-CODE-COMPANY-ACCT    
                                            WS-101-CODE-ACCOUNT-STATUS  
                                            WS-101-CODE-PREMISE-STATUS  
           MOVE ZERO                     TO WS-101-ITEM-DETAIL-DATA     
                                            WS-101-ITEM-ID-NO           
                                            WS-101-DETAIL-END-BAL       
                                            WS-101-DETAIL-END-AR-BAL    
                                            WS-101-ACCT-END-AR-BAL      
                                            WS-101-REVENUE-MONTH        
           .                                                            
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02780000
      ******************************************************************05110000
      * 2300-REVERSAL                                                  *05120000
      *                                                                *05130000
      ******************************************************************05190000
      *                                                                 05200000
       2300-REVERSAL.                                                   
           MOVE PARM-CASH-COMPANY-NO     TO  CJ-CASH-COMPANY-NO.        
           MOVE PARM-CASH-LOCAL-OFFICE   TO  CJ-CASH-LOCAL-OFFICE.      
           MOVE PARM-CASH-REPORT-NO      TO  CJ-CASH-REPORT-NO.         
           MOVE PARM-DATE-CASH-REPORT    TO  CJ-DATE-CASH-REPORT.       
           MOVE PARM-CASH-DRAWER-ID      TO  CJ-CASH-DRAWER-ID.         
           MOVE PARM-USER-ID             TO  CJ-USER-ID.                
           MOVE WS-ENTRY-NO              TO  CJ-ENTRY-NO.               
           PERFORM 7500-GET-JOURNAL-ROW THRU 7500-EXIT.                 
                                                                        
                                                                        
           MOVE CJ-TRAN-DATA           TO CJF00101.                     
           MOVE WS-101-FCS-ACCT-NO(14:7) TO WS-GL-ACCT-STRING.          
                                                                        
           MOVE CJ-CODE-PYMT-FACILITY  TO WS-PYMT-FACILITY-CODE.        
           MOVE WS-101-ACCT-GEN-LED-CR TO WS-GL-ACCT-NO.                
                                                                        
           MOVE PARM-REVERSED-TRAN-ID TO CJ-TRAN-ID.                    
           PERFORM 7530-UPDATE-JOURNAL       THRU 7530-EXIT.            
                                                                        
           ADD WS-AMOUNT-CHECK                                          
               WS-AMOUNT-MORDER                                         
               WS-AMOUNT-CASH GIVING WS-PAYMENT-AMOUNT                  
                                     WS-PAYMENT-AMOUNT-TOTAL.           
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * CPD00060                                                       *        
      * 5900-CALC-VARCHAR-LENGTH                                       *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       COPY CPD00060.                                                           
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * CPD0006B                                                       *        
      * 6400-ONLINE-JRNL-ROUTINE                                       *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD0006B                                           PCS09360
           END-EXEC.                                                            
      *                                                                 02780000
      ******************************************************************05110000
      * 7100-GET-CURRENT-TIMESTAMP                                     *05120000
      *                                                                *05130000
      ******************************************************************05190000
      *                                                                 05200000
       7100-GET-CURRENT-TIMESTAMP.                                      
           MOVE '7100'                       TO ACTIVE-PARAGRAPH        
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                       
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE                                              
MFA-TR*            = CURRENT DATE                                               
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE         
               MOVE SPACES                     TO ABEND-TABLES          
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
               MOVE '7100'                     TO ACTIVE-PARAGRAPH      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE 'SET'                      TO ABEND-FUNCTION        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02780000
      ******************************************************************05110000
      * 7400-GL-ACCT-NO                                                *05120000
      *                                                                *05130000
      ******************************************************************05190000
      *                                                                 05200000
       7400-GL-ACCT-NO.                                                 
           MOVE CS-CASH-COMPANY-NO        TO GO-COMPANY-NO              
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) GL_ACCT_NO                                        
                 INTO :GO-GL-ACCT-NO                                    
                 FROM CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                      
                WHERE COMPANY_NO   = '01'                               
                  AND GL_ACCT_NAME = :GO-GL-ACCT-NAME                   
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT GL_ACCT_NO                                                
MFA-TR*          INTO :GO-GL-ACCT-NO                                            
MFA-TR*          FROM CSS_GL_ACCT_NO                                            
MFA-TR*         WHERE COMPANY_NO   = '01'                                       
MFA-TR*           AND GL_ACCT_NAME = :GO-GL-ACCT-NAME                           
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE              
               MOVE '7400'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT            '  TO ABEND-FUNCTION             
               MOVE 'CSS_GL_ACCT_NO    '  TO TABLE-1                    
               MOVE 'COMPANY_NO        '  TO TABLE-ELEMENT-1            
               MOVE '01'                  TO HOSTVAR-ELEMENT-1          
               MOVE 'GL ACCT NAME      '  TO TABLE-ELEMENT-2            
               MOVE GO-GL-ACCT-NAME       TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7500-GET-JOURNAL-ROW                                        *        
      *       SELECT THE CSS_CSH_DRWR_JRNL ROW                         *        
      ******************************************************************        
       7500-GET-JOURNAL-ROW.                                            
                                                                        
           EXEC SQL                                                     
                SELECT CURRENCY_TYPE,                                   
                       TRAN_DATA,                                       
                       CODE_PYMT_FACILITY,                              
                       TRAN_APPL_NO                                     
                  INTO :CJ-CURRENCY-TYPE,                               
                       :CJ-TRAN-DATA,                                   
                       :CJ-CODE-PYMT-FACILITY,                          
                       :CJ-TRAN-APPL-NO                                 
                  FROM CSS_CSH_DRWR_JRNL                                
                 WHERE CASH_COMPANY_NO      = :CJ-CASH-COMPANY-NO       
                   AND CASH_LOCAL_OFFICE    = :CJ-CASH-LOCAL-OFFICE     
                   AND CASH_REPORT_NO       = :CJ-CASH-REPORT-NO        
                   AND DATE_CASH_REPORT     = IIF(TRY_CONVERT(DATE, 
                                                   :CJ-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CJ-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CJ-DATE-CASH-REPORT
              ), CONVERT(DATE, :CJ-DATE-CASH-REPORT) )      
                   AND CASH_DRAWER_ID       = :CJ-CASH-DRAWER-ID        
                   AND USER_ID              = :CJ-USER-ID               
                   AND ENTRY_NO             = :CJ-ENTRY-NO              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT CURRENCY_TYPE,                                   06940000
MFA-TR*                TRAN_DATA,                                               
MFA-TR*                CODE_PYMT_FACILITY,                                      
MFA-TR*                TRAN_APPL_NO                                             
MFA-TR*           INTO :CJ-CURRENCY-TYPE,                                       
MFA-TR*                :CJ-TRAN-DATA,                                           
MFA-TR*                :CJ-CODE-PYMT-FACILITY,                                  
MFA-TR*                :CJ-TRAN-APPL-NO                                         
MFA-TR*           FROM CSS_CSH_DRWR_JRNL                                        
MFA-TR*          WHERE CASH_COMPANY_NO      = :CJ-CASH-COMPANY-NO               
MFA-TR*            AND CASH_LOCAL_OFFICE    = :CJ-CASH-LOCAL-OFFICE             
MFA-TR*            AND CASH_REPORT_NO       = :CJ-CASH-REPORT-NO                
MFA-TR*            AND DATE_CASH_REPORT     = :CJ-DATE-CASH-REPORT              
MFA-TR*            AND CASH_DRAWER_ID       = :CJ-CASH-DRAWER-ID                
MFA-TR*            AND USER_ID              = :CJ-USER-ID                       
MFA-TR*            AND ENTRY_NO             = :CJ-ENTRY-NO                      
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7500'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CASH_DRWR_JRNL'       TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'ENTRY_NO'                 TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CJ-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CJ-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CJ-ENTRY-NO                TO HOSTVAR-ELEMENT-3     
               MOVE CJ-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    7530-UPDATE-JOURNAL                                         *        
      *                                                                *        
      *       UPDATE  CSS_CSH_DRWR_JRNL TABLE                          *        
      *                                                                *        
      ******************************************************************        
       7530-UPDATE-JOURNAL.                                             
           EXEC SQL                                                     
                UPDATE CSS_CSH_DRWR_JRNL                                
                   SET TRAN_ID = :CJ-TRAN-ID,                           
                   REVERSED_FL = :WS-Y                                  
                 WHERE CASH_COMPANY_NO      = :CJ-CASH-COMPANY-NO       
                   AND CASH_LOCAL_OFFICE    = :CJ-CASH-LOCAL-OFFICE     
                   AND CASH_REPORT_NO       = :CJ-CASH-REPORT-NO        
                   AND DATE_CASH_REPORT     = IIF(TRY_CONVERT(DATE, 
                                                   :CJ-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CJ-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CJ-DATE-CASH-REPORT
              ), CONVERT(DATE, :CJ-DATE-CASH-REPORT) )      
                   AND CASH_DRAWER_ID       = :CJ-CASH-DRAWER-ID        
                   AND USER_ID              = :CJ-USER-ID               
                   AND ENTRY_NO             = :CJ-ENTRY-NO              
                   AND TRAN_APPL_NO         = :CJ-TRAN-APPL-NO          
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_CSH_DRWR_JRNL                                        
MFA-TR*            SET TRAN_ID = :CJ-TRAN-ID,                                   
MFA-TR*            REVERSED_FL = :WS-Y                                          
MFA-TR*          WHERE CASH_COMPANY_NO      = :CJ-CASH-COMPANY-NO               
MFA-TR*            AND CASH_LOCAL_OFFICE    = :CJ-CASH-LOCAL-OFFICE             
MFA-TR*            AND CASH_REPORT_NO       = :CJ-CASH-REPORT-NO                
MFA-TR*            AND DATE_CASH_REPORT     = :CJ-DATE-CASH-REPORT              
MFA-TR*            AND CASH_DRAWER_ID       = :CJ-CASH-DRAWER-ID                
MFA-TR*            AND USER_ID              = :CJ-USER-ID                       
MFA-TR*            AND ENTRY_NO             = :CJ-ENTRY-NO                      
MFA-TR*            AND TRAN_APPL_NO         = :CJ-TRAN-APPL-NO                  
MFA-TR*      QUERYNO 7530                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7530'                     TO ACTIVE-PARAGRAPH      
               MOVE 'UPDATE'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                   ABEND-TABLES         
               MOVE 'CSS_CASH_DRWR_JRNL'       TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'ENTRY_NO'                 TO TABLE-ELEMENT-3       
               MOVE 'DATE-CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CJ-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CJ-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CJ-ENTRY-NO                TO HOSTVAR-ELEMENT-3     
               MOVE CJ-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7530-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7700-GET-LOCAL-OFFICE                                          *        
      *                                                                *        
      *    TO GET LOCAL OFFICE                                         *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7700-GET-LOCAL-OFFICE.                                           
                                                                        
           EXEC SQL                                                     
                SELECT LOCAL_OFFICE                                     
                  INTO :Y2-LOCAL-OFFICE                                 
                  FROM CSS_CASHIER_OFFICE WITH(READUNCOMMITTED)                 
                 WHERE CASH_COMPANY_NO   = :Y2-CASH-COMPANY-NO          
                   AND CASH_LOCAL_OFFICE = :Y2-CASH-LOCAL-OFFICE        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT LOCAL_OFFICE                                             
MFA-TR*           INTO :Y2-LOCAL-OFFICE                                         
MFA-TR*           FROM CSS_CASHIER_OFFICE                                       
MFA-TR*          WHERE CASH_COMPANY_NO   = :Y2-CASH-COMPANY-NO                  
MFA-TR*            AND CASH_LOCAL_OFFICE = :Y2-CASH-LOCAL-OFFICE                
MFA-TR*          WITH UR                                                        
MFA-TR*      QUERYNO 7700                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7700'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CASHIER_OFFICE'       TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE Y2-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE Y2-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************12310000
      *                                                                *        
      * CPD00075                                                       *12320000
      * 7999-SELECT-AL                                                 *12320000
      *                                                                *        
      ******************************************************************12310000
      *                                                                 42860000
           EXEC SQL                                                     14890000
              INCLUDE CPD00075                                          14900000
           END-EXEC.                                                    14910000
      *                                                                         
      *                                                                         
      ******************************************************************12310000
      *                                                                *        
      * 8900-SEND-DONE                                                 *12320000
      *                                                                *        
      ******************************************************************12310000
      *                                                                 42860000
       8900-SEND-DONE.                                                  
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************12310000
      *                                                                *        
      * CPD0023C                                                       *12320000
      * 9700-PROCESS-ABEND                                             *12320000
      *                                                                *        
      ******************************************************************12310000
      *                                                                         
           EXEC SQL                                                     14890000
              INCLUDE CPD0023C                                          14900000
           END-EXEC.                                                    14910000
      *                                                                         
      *****************************************************************         
      * SENDS ERROR RESULT                                            *         
      *****************************************************************         
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE                  
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
           END-IF.                                                      
                                                                        
       9000-EXIT.                                                       
      ******************************************************************12310000
      *                                                                *        
      * CPDSP300                                                       *12320000
      * 9900-SQL-ERROR-ROUTINE                                         *12320000
      * 9975-ABEND-CONTROL-TRANSFER                                    *12320000
      *                                                                *        
      ******************************************************************12310000
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * 9999-END-PROGRAM.                                                       
      *****************************************************************         
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
