       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04904.                                         
COB303 DATE-WRITTEN.  MAR 29,2016.                                      
       DATE-COMPILED.                                                   
      *                                                                 00050000
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *                                                                *00100000
      ******************************************************************00110000
      *                 P R O G R A M  S U M M A R Y                   *00120000
      *  THIS PROCEDURE IS USED TO RETRIEVE THE WORK SCHEDULE AND      *00130000
      *  IT SENDS OUT DETAILS FOR THE ACCOUNTS CREDIT GROUP,BILL CYCLE *00140000
      *  COMPANY NO AND REVENUE MONTH AND OTHER DETAILS FOR THREE      *00150000
      *  CONSECUTIVE REVENUE MONTHS AS PREVIOUS REVENUE MONTH IN       *00160000
      *  1ST ROW CURRENT REVUNUE MONTH IN NEXT ROW AND NEXT REVENUE    *00170000
      *  MONTH IN THIRD ROW.                                           *00180000
      *                                                                *00190000
      *  REFERENCE SP CSR02556.                                        *00200000
      *                                                                *00210000
      *---------------------------------------------------------------- 00220000
      *--                                                            -- 00230000
      *--  PARAMETERS:                                               -- 00240000
      *--                                                            -- 00250000
      *--                                                            -- 00260000
      ******************************************************************00270000
      *                                                                *00280000
      *                     PROGRAM MODIFICATION LOG                   *00290000
      *                                                                *00300000
      *    DATE    INITIALS   COMMENTS                                 *00310000
      *  --------  --------   ---------------------------------------  *00320000
      *  03/29/16  SS7F226    PROCEDURE ORIGINALLY CODED.              *00330000
      ******************************************************************00340000
      ******************************************************************00350000
      *                                                                *00360000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00370000
      *                                                                *00380000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00390000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00400000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00410000
      *  3000 - 4999  NOT USED                                         *00420000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00430000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00440000
      *  7000 - 7999  INPUT MODULES                                    *00450000
      *  8000 - 8999  OUTPUT MODULES                                   *00460000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00470000
      *                                                                *00480000
      ******************************************************************00490000
      *                                                                 00500000
       ENVIRONMENT DIVISION.                                            
      *                                                                 00520000
       DATA DIVISION.                                                   
      *                                                                 00540000
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04904'.
MSQ017     COPY MFASQLM.
      *                                                                 00560000
      ******************************************************************00570000
      * WORKING STORAGE COPYBOOKS FOR CPD04353                         *00580000
      ******************************************************************00590000
      *                                                                 00600000
       01 WS-START                      PIC X(40) VALUE                 
            'WORKING STORAGE FOR CSR04904 STARTS HERE'.                 
      *                                                                 00630000
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME               PIC X(08) VALUE 'CSR04904'.     
          05 WS-ZERO                    PIC S9(4) VALUE 0.              
          05 WS-DELINQ-CD               PIC X(08) VALUE 'DATABASE'.     
          05 WS-BALANCE-REG             PIC X(1)  VALUE 'F'.            
          05 WS-BALANCE-DEREG           PIC X(1)  VALUE 'G'.            
          05 WS-ARREARS                 PIC X(1)  VALUE 'A'.            
          05 WS-BALANCE                 PIC X(1)  VALUE 'B'.            
          05 WS-BALANCE-REG             PIC X(1)  VALUE 'F'.            
          05 WS-BALANCE-DEREG           PIC X(1)  VALUE 'G'.            
          05 WS-EXEMPT                  PIC X(1)  VALUE 'C'.            
          05 WS-NON-UTILITY             PIC X(1)  VALUE 'D'.            
          05 WS-NEW                     PIC X(1)  VALUE 'N'.            
          05 WS-RESIDENTIAL             PIC X(1)  VALUE 'R'.            
          05 WS-R                       PIC X(1)  VALUE 'R'.            
          05 WS-O                       PIC X(1)  VALUE 'O'.            
          05 WS-Y                       PIC X(1)  VALUE 'Y'.            
          05 WS-N                       PIC X(1)  VALUE 'N'.            
          05 WS-SPACES                  PIC X(3)  VALUE SPACES.         
      *                                                                 00830000
       01 WS-MISC.                                                      
          05 WS-GTT-NAME                PIC X(19) VALUE SPACES.         
          05 WS-SQLSTATE                PIC X(05) VALUE SPACES.         
          05 WS-CURR-COMPANY-NO         PIC X(02) VALUE SPACES.         
          05 WS-MIN-DATE-EXTRACT        PIC X(10) VALUE SPACES.         
          05 WS-MAX-DATE-EXTRACT        PIC X(10) VALUE SPACES.         
          05 WS-CRED-ACCT-TYPE-CD       PIC X(01) VALUE SPACES.         
          05 WS-REV-MONTH-NO            PIC 9(6)  VALUE 0.              
          05 WS-REV-MONTH-NO1           PIC 9(6)  VALUE 0.              
COB305    05 WS-REV-MONTH-CM        PIC S9(6)V USAGE COMP-3 VALUE 0.        
COB305    05 WS-REV-MONTH-CM1        PIC S9(6)V USAGE COMP-3 VALUE 0.        
          05 WS-NULL-MIN-DATE           PIC S9(4)  COMP.                
          05 WS-NULL-MAX-DATE           PIC S9(4)  COMP.                
          05 WS-NULL-OPTIMUM-READ       PIC S9(4)  COMP.                
          05 WS-NULL-THIRD-PTY-READ     PIC S9(4)  COMP.                
          05 WS-NULL-CURR-CHG-DUE-DT    PIC S9(4)  COMP.                
          05 WS-NULL-DNP-NOTICE-MAIL-DT PIC S9(4)  COMP.                
          05 WS-NULL-DNP-DT             PIC S9(4)  COMP.                
          05 WS-NULL-AVOID-LPC-DT       PIC S9(4)  COMP.                
          05 WS-NULL-ARREARS-DUE-DT     PIC S9(4)  COMP.                
          05 WS-NULL-DNP-NOTICE-DUE-DT  PIC S9(4)  COMP.                
COB305    05 WS-PREV-REV-MNT        PIC S9(6)V USAGE COMP-3 VALUE 0.        
COB305    05 WS-CURR-REV-MNT        PIC S9(6)V USAGE COMP-3 VALUE 0.        
COB305    05 WS-NEXT-REV-MNT        PIC S9(6)V USAGE COMP-3 VALUE 0.        
          05 WS-YEAR-MONTH.                                             
             10  WS-YEAR                PIC 9(04).                      
             10  WS-MONTH               PIC 9(02).                      
          05 WS-YEAR-MONTH1.                                            
             10  WS-YEAR1               PIC 9(04).                      
             10  WS-MONTH1              PIC 9(02).                      
      *                                                                 01170000
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW               PIC X(01) VALUE 'Y'.            
             88 SEND-DONE-ERROR                   VALUE 'N'.            
             88 SEND-DONE-OK                      VALUE 'Y'.            
          05  WS-NO-MORE-RECORDS        PIC X(01) VALUE 'N'.            
              88 NO-MORE-RECORDS                  VALUE 'Y'.            
      *                                                                 01240000
       01 GTT-RETURN-FIELDS.                                            
          05  S-RETURN-CODE             PIC S9(09) COMP VALUE 0.        
          05  S-BILLING-MTH             PIC X(06) VALUE SPACES.         
          05  S-READ-DT                 PIC X(10) VALUE SPACES.         
          05  S-MAIL-DT                 PIC X(10) VALUE SPACES.         
          05  S-BILL-DUE-DT             PIC X(10) VALUE SPACES.         
          05  S-AVOID-LPC-DT            PIC X(10) VALUE SPACES.         
          05  S-FST-NOTICE-DT           PIC X(10) VALUE SPACES.         
          05  S-SCND-NOTICE-DT          PIC X(10) VALUE SPACES.         
          05  S-DNP-DT                  PIC X(10) VALUE SPACES.         
          05  S-FST-NOTICE-DUE-DT       PIC X(10) VALUE SPACES.         
          05  S-SCND-NOTICE-DUE-DT      PIC X(10) VALUE SPACES.         
      *                                                                 01370000
       01 WS-MAIL-DT.                                                   
          05 WS-MAIL-DT-MM              PIC X(02) VALUE SPACES.         
          05 FILLER                     PIC X(01) VALUE '/'.            
          05 WS-MAIL-DT-DD              PIC X(02) VALUE SPACES.         
          05 FILLER                     PIC X(01) VALUE '/'.            
          05 WS-MAIL-DT-YYYY            PIC X(04) VALUE SPACES.         
      *                                                                 01371700
       01 WS-READ-DT-THIRD-PTY.                                         
          05 WS-READ-DT-THIRD-PTY-MM    PIC X(02) VALUE SPACES.         
          05 FILLER                     PIC X(01) VALUE '/'.            
          05 WS-READ-DT-THIRD-PTY-DD    PIC X(02) VALUE SPACES.         
          05 FILLER                     PIC X(01) VALUE '/'.            
          05 WS-READ-DT-THIRD-PTY-YYYY  PIC X(04) VALUE SPACES.         
      *                                                                 01372400
       01 WS-READ-DT-OPTIMUM.                                           
          05 WS-READ-DT-OPTIMUM-MM      PIC X(02) VALUE SPACES.         
          05 FILLER                     PIC X(01) VALUE '/'.            
          05 WS-READ-DT-OPTIMUM-DD      PIC X(02) VALUE SPACES.         
          05 FILLER                     PIC X(01) VALUE '/'.            
          05 WS-READ-DT-OPTIMUM-YYYY    PIC X(04) VALUE SPACES.         
      *                                                                 01374200
       01 WS-BILL-DUE-DT.                                               
          05 WS-BILL-DUE-DT-MM          PIC X(02) VALUE SPACES.         
          05 FILLER                     PIC X(01) VALUE '/'.            
          05 WS-BILL-DUE-DT-DD          PIC X(02) VALUE SPACES.         
          05 FILLER                     PIC X(01) VALUE '/'.            
          05 WS-BILL-DUE-DT-YYYY        PIC X(04) VALUE SPACES.         
      *                                                                 01374900
       01 WS-FST-NOTICE-DT.                                             
          05 WS-FST-NOTICE-DT-MM        PIC X(02) VALUE SPACES.         
          05 FILLER                     PIC X(01) VALUE '/'.            
          05 WS-FST-NOTICE-DT-DD        PIC X(02) VALUE SPACES.         
          05 FILLER                     PIC X(01) VALUE '/'.            
          05 WS-FST-NOTICE-DT-YYYY      PIC X(04) VALUE SPACES.         
      *                                                                 01375600
       01 WS-SCND-NOTICE-DT.                                            
          05 WS-SCND-NOTICE-DT-MM       PIC X(02) VALUE SPACES.         
          05 FILLER                     PIC X(01) VALUE '/'.            
          05 WS-SCND-NOTICE-DT-DD       PIC X(02) VALUE SPACES.         
          05 FILLER                     PIC X(01) VALUE '/'.            
          05 WS-SCND-NOTICE-DT-YYYY     PIC X(04) VALUE SPACES.         
      *                                                                 01376300
       01 WS-DNP-DT.                                                    
          05 WS-DNP-DT-MM               PIC X(02) VALUE SPACES.         
          05 FILLER                     PIC X(01) VALUE '/'.            
          05 WS-DNP-DT-DD               PIC X(02) VALUE SPACES.         
          05 FILLER                     PIC X(01) VALUE '/'.            
          05 WS-DNP-DT-YYYY             PIC X(04) VALUE SPACES.         
      *                                                                 01377000
       01 WS-AVOID-LPC-DT.                                              
          05 WS-AVOID-LPC-DT-MM         PIC X(02) VALUE SPACES.         
          05 FILLER                     PIC X(01) VALUE '/'.            
          05 WS-AVOID-LPC-DT-DD         PIC X(02) VALUE SPACES.         
          05 FILLER                     PIC X(01) VALUE '/'.            
          05 WS-AVOID-LPC-DT-YYYY       PIC X(04) VALUE SPACES.         
      *                                                                 01377700
       01 WS-FST-NOTICE-DUE-DT.                                         
          05 WS-FST-NOTICE-DUE-DT-MM    PIC X(02) VALUE SPACES.         
          05 FILLER                     PIC X(01) VALUE '/'.            
          05 WS-FST-NOTICE-DUE-DT-DD    PIC X(02) VALUE SPACES.         
          05 FILLER                     PIC X(01) VALUE '/'.            
          05 WS-FST-NOTICE-DUE-DT-YYYY  PIC X(04) VALUE SPACES.         
      *                                                                 01378400
       01 WS-SCND-NOTICE-DUE-DT.                                        
          05 WS-SCND-NOTICE-DUE-DT-MM   PIC X(02) VALUE SPACES.         
          05 FILLER                     PIC X(01) VALUE '/'.            
          05 WS-SCND-NOTICE-DUE-DT-DD   PIC X(02) VALUE SPACES.         
          05 FILLER                     PIC X(01) VALUE '/'.            
          05 WS-SCND-NOTICE-DUE-DT-YYYY PIC X(04) VALUE SPACES.         
      *                                                                 01379100
       01  WS-END                    PIC X(40)                          
           VALUE 'WORKING STORAGE FOR CSR04904 ENDS HERE  '.            
      *                                                                 01400000
      ***************************************************************** 01410000
      *    ERROR HANDLING                                               01420000
      ******************************************************************01430000
      *                                                                 01440000
           EXEC SQL                                                     01450000
              INCLUDE CWSX0010                                          01460000
           END-EXEC.                                                    01470000
      *                                                                 01480000
      ***************************************************************** 01490000
      *    COPYBOOK FOR STORED PROCEDURE ERROR PROCESSING               01500000
      ******************************************************************01510000
      *                                                                 01520000
           EXEC SQL                                                     01530000
              INCLUDE CWSSP001                                          01540000
           END-EXEC.                                                    01550000
      *                                                                 01560000
      ******************************************************************01570000
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *01580000
      ******************************************************************01590000
      *                                                                 01600000
           COPY CWS00303.                                               01610000
      *                                                                 01620000
      ******************************************************************01630000
      *    COMMON SYSTEM AREA                                          *01640000
      ******************************************************************01650000
      *                                                                 01660000
           COPY CCA00001.                                               01670000
      *                                                                 01680000
      ******************************************************************01690000
      *   SQL COMMUNICATION AREA                                       *01700000
      ******************************************************************01710000
      *                                                                 01720000
           EXEC SQL                                                     01730000
               INCLUDE SQLCA                                            01740000
           END-EXEC.                                                    01750000
      *                                                                 01760000
      ******************************************************************01770000
      *    CSS_ACCOUNT      -  AT                                      *01780000
      ******************************************************************01790000
      *                                                                 01800000
           EXEC SQL                                                     01810000
                INCLUDE TBACCT                                          01820000
           END-EXEC.                                                    01830000
      *                                                                 01840000
      ******************************************************************01850000
      *    CSS_BILL_WINDOW  -  BN                                      *01860000
      ******************************************************************01870000
      *                                                                 01880000
           EXEC SQL                                                     01890000
                INCLUDE TBBILWDW                                        01900000
           END-EXEC.                                                    01910000
      *                                                                 01920000
      ******************************************************************01930000
      *    CSS_CRED_FORECAST -  CM                                     *01940000
      ******************************************************************01950000
      *                                                                 01960000
           EXEC SQL                                                     01970000
                INCLUDE TBCRFCST                                        01980000
           END-EXEC.                                                    01990000
      *                                                                 02000000
      ******************************************************************02010000
      *    CSS_DELINQUENCY  -  C8                                      *02020000
      ******************************************************************02030000
      *                                                                 02040000
           EXEC SQL                                                     02050000
                INCLUDE TBDELQ                                          02060000
           END-EXEC.                                                    02070000
      *                                                                 02080000
      ******************************************************************02090000
      *    CSS_READ_WINDOW   -  RW                                     *02100000
      ******************************************************************02110000
      *                                                                 02120000
           EXEC SQL                                                     02130000
                INCLUDE TBRDWNDW                                        02140000
           END-EXEC.                                                    02150000
      *                                                                 02160000
       LINKAGE SECTION.                                                 
COB305 01 PARM-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.       
      *                                                                 02190000
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
      *                                                                 02210000
      ******************************************************************02220000
      * 0000-MAINLINE                                                  *02230000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02240000
      ******************************************************************02250000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02350000
      ******************************************************************02360000
      * 0100A-DECLARE-GTT  - PREVIOUS REVENUE MONTH DATA               *02370000
      ******************************************************************02380000
      *                                                                 02390000
       0100A-DECLARE-GTT.                                               
                                                                        
           MOVE 'SESSION.CSR04904_R1'        TO WS-GTT-NAME.            
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04904_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04904_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,BILLING_MTH CHAR(06)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,READ_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,MAIL_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,BILL_DUE_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,AVOID_LPC_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,FST_NOTICE_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,SCND_NOTICE_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DNP_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2            
                   ,FST_NOT_DUE_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,SCN_NOT_DUE_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS       THRU 8000A-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE WS-GTT-NAME        TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,LTRIM(RTRIM(BILLING_MTH))        AS BILLING_MTH         
                      ,LTRIM(RTRIM(READ_DT))            AS READ_DT             
                      ,LTRIM(RTRIM(MAIL_DT))            AS MAIL_DT             
                      ,LTRIM(RTRIM(BILL_DUE_DT))        AS BILL_DUE_DT         
                      ,LTRIM(RTRIM(AVOID_LPC_DT))       AS AVOID_LPC_DT        
                      ,LTRIM(RTRIM(FST_NOTICE_DT))      AS FST_NOTICE_DT       
                      ,LTRIM(RTRIM(SCND_NOTICE_DT))     AS 
           SCND_NOTICE_DT      
                      ,LTRIM(RTRIM(DNP_DT))             AS DNP_DT              
                      ,LTRIM(RTRIM(FST_NOT_DUE_DT))     AS 
           FST_NOT_DUE_DT      
                      ,LTRIM(RTRIM(SCN_NOT_DUE_DT))     AS 
           SCN_NOT_DUE_DT      
                  FROM #CSR04904_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     02850000
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                            02860000
MFA-TR*                          WITH ROWSET POSITIONING FOR            02870000
MFA-TR*         SELECT RETURN_CODE                                      02880000
MFA-TR*               ,STRIP(BILLING_MTH)        AS BILLING_MTH         02890000
MFA-TR*               ,STRIP(READ_DT)            AS READ_DT             02900000
MFA-TR*               ,STRIP(MAIL_DT)            AS MAIL_DT             02910000
MFA-TR*               ,STRIP(BILL_DUE_DT)        AS BILL_DUE_DT         02920000
MFA-TR*               ,STRIP(AVOID_LPC_DT)       AS AVOID_LPC_DT        02930000
MFA-TR*               ,STRIP(FST_NOTICE_DT)      AS FST_NOTICE_DT       02940000
MFA-TR*               ,STRIP(SCND_NOTICE_DT)     AS SCND_NOTICE_DT      02950000
MFA-TR*               ,STRIP(DNP_DT)             AS DNP_DT              02960000
MFA-TR*               ,STRIP(FST_NOT_DUE_DT)     AS FST_NOT_DUE_DT      02970000
MFA-TR*               ,STRIP(SCN_NOT_DUE_DT)     AS SCN_NOT_DUE_DT      02980000
MFA-TR*           FROM SESSION.CSR04904_R1                              02990000
MFA-TR*    END-EXEC.                                                    03000000
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                 03040000
      ******************************************************************03050000
      * A000-PROCESS-INPUT.                                            *03060000
      ******************************************************************03070000
      *                                                                 03080000
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO          TO AT-ACCOUNT-NO.              
                                                                        
           PERFORM 0100A-DECLARE-GTT           THRU 0100A-EXIT.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03180000
      * 2000-PROCESS-OUTPUT.                                           *03190000
      ******************************************************************03200000
      *                                                                 03210000
       2000-PROCESS-OUTPUT.                                             
      *                                                                 03230000
           INITIALIZE                           GTT-RETURN-FIELDS.      
                                                                        
           PERFORM 7000-GET-ACCT-DATA          THRU 7000-EXIT.          
                                                                        
           IF AT-BILL-CYCLE > 20                                        
              MOVE '20'                  TO AT-BILL-CYCLE               
           END-IF                                                       
                                                                        
           IF AT-ACCOUNT-TYPE-CODE  =  WS-RESIDENTIAL                   
               MOVE WS-R                 TO WS-CRED-ACCT-TYPE-CD        
           ELSE                                                         
               MOVE WS-O                 TO WS-CRED-ACCT-TYPE-CD        
           END-IF                                                       
                                                                        
           PERFORM 2110-PROCESS-CRED-DATA      THRU 2110-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03430000
      * 2110-PROCESS-CRED-DATA.                                       * 03440000
      * PROCESS TO GET CRED FORECAST DATA IF AT-REV-MTH-LST-NRML NOT 0 *03450000
      ******************************************************************03460000
      *                                                                 03470000
       2110-PROCESS-CRED-DATA.                                          
                                                                        
      *    PROCESS TO GET CRED FORECAST DATA FOR PREV REVENUE MONTH.    03500000
                                                                        
           INITIALIZE GTT-RETURN-FIELDS                                 
                      DCLCSS-CRED-FORECAST                              
                      WS-REV-MONTH-CM                                   
                                                                        
           IF AT-REV-MTH-LST-NRML <= ZERO                               
                                                                        
              MOVE +100                  TO S-RETURN-CODE               
              PERFORM 8100-SEND-RESULT          THRU 8100-EXIT          
                                                                        
           ELSE                                                         
               PERFORM 2170-FORECAST-PREV-MNT   THRU 2170-EXIT          
                                                                        
           END-IF.                                                      
                                                                        
      *    PROCESS TO GET CRED FORECAST DATA FOR CURRENT REVENUE MONTH. 03660000
                                                                        
           INITIALIZE GTT-RETURN-FIELDS                                 
                      DCLCSS-CRED-FORECAST                              
                      WS-REV-MONTH-CM                                   
                                                                        
           IF AT-REV-MTH-LST-NRML <= ZERO                               
                                                                        
              PERFORM 7120-GET-REVENUE-MONTH    THRU 7120-EXIT          
                                                                        
              MOVE BN-REVENUE-MONTH      TO WS-REV-MONTH-CM             
                                            AT-REV-MTH-LST-NRML         
              MOVE WS-REV-MONTH-CM       TO WS-REV-MONTH-NO             
              MOVE WS-REV-MONTH-NO       TO S-BILLING-MTH               
                                                                        
              PERFORM 2180-FORECAST-CURR-MNT   THRU 2180-EXIT           
                                                                        
           ELSE                                                         
                                                                        
              MOVE AT-REV-MTH-LST-NRML   TO WS-REV-MONTH-CM             
              MOVE WS-REV-MONTH-CM       TO WS-REV-MONTH-NO             
              MOVE WS-REV-MONTH-NO       TO S-BILLING-MTH               
                                                                        
              PERFORM 2180-FORECAST-CURR-MNT   THRU 2180-EXIT           
                                                                        
           END-IF.                                                      
                                                                        
      *    PROCESS TO GET CRED FORECAST DATA FOR NEXT REVENUE MONTH.    03930000
                                                                        
           INITIALIZE GTT-RETURN-FIELDS                                 
                      DCLCSS-CRED-FORECAST                              
                      WS-REV-MONTH-CM                                   
                                                                        
           IF AT-REV-MTH-LST-NRML <= ZERO                               
              MOVE BN-REVENUE-MONTH      TO WS-REV-MONTH-CM             
                                            AT-REV-MTH-LST-NRML         
              PERFORM 2190-FORECAST-NEXT-MNT   THRU 2190-EXIT           
           ELSE                                                         
              PERFORM 2190-FORECAST-NEXT-MNT   THRU 2190-EXIT           
           END-IF.                                                      
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04090000
      ******************************************************************04100000
      * 2120-GET-PREV-REV-MNT.                                         *04110000
      ******************************************************************04120000
      *                                                                 04130000
       2120-GET-PREV-REV-MNT.                                           
      *                                                                 04150000
           MOVE AT-REV-MTH-LST-NRML      TO WS-REV-MONTH-NO.            
                                                                        
           MOVE WS-REV-MONTH-NO          TO WS-YEAR-MONTH.              
                                                                        
           COMPUTE WS-MONTH = WS-MONTH - 1.                             
                                                                        
           IF WS-MONTH = 0                                              
               MOVE 12                   TO WS-MONTH                    
               COMPUTE WS-YEAR = WS-YEAR - 1                            
           END-IF.                                                      
                                                                        
           MOVE WS-YEAR-MONTH            TO WS-REV-MONTH-NO.            
           MOVE WS-REV-MONTH-NO          TO WS-REV-MONTH-CM.            
                                                                        
       2120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04320000
      ******************************************************************04330000
      * 2130-GET-NEXT-REV-MNT.                                         *04340000
      ******************************************************************04350000
      *                                                                 04360000
       2130-GET-NEXT-REV-MNT.                                           
      *                                                                 04380000
           MOVE AT-REV-MTH-LST-NRML      TO WS-REV-MONTH-NO.            
           MOVE WS-REV-MONTH-NO          TO WS-YEAR-MONTH.              
           ADD 1                         TO WS-MONTH.                   
                                                                        
           IF WS-MONTH = 13                                             
               MOVE 1                    TO WS-MONTH                    
               ADD  1                    TO WS-YEAR                     
           END-IF.                                                      
                                                                        
           MOVE WS-YEAR-MONTH            TO WS-REV-MONTH-NO.            
           MOVE WS-REV-MONTH-NO          TO WS-REV-MONTH-CM.            
                                                                        
       2130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04540000
      * 2140-LOAD-BILL-READ-DT.                                        *04550000
      ******************************************************************04560000
      *                                                                 04570000
       2140-LOAD-BILL-READ-DT.                                          
      *                                                                 04590000
           PERFORM 7100-GET-BILL-CYCLE-DT      THRU 7100-EXIT.          
           MOVE WS-MAX-DATE-EXTRACT      TO CM-BILL-DT.                 
           MOVE WS-MIN-DATE-EXTRACT(1:4) TO WS-MAIL-DT-YYYY.            
           MOVE WS-MIN-DATE-EXTRACT(6:2) TO WS-MAIL-DT-MM.              
           MOVE WS-MIN-DATE-EXTRACT(9:2) TO WS-MAIL-DT-DD.              
                                                                        
           IF WS-MAIL-DT  > SPACES                                      
              MOVE WS-MAIL-DT            TO S-MAIL-DT                   
           ELSE                                                         
              MOVE SPACES                TO S-MAIL-DT                   
           END-IF                                                       
                                                                        
           PERFORM 7110-GET-OPTIMUM-RD-DT      THRU 7110-EXIT.          
                                                                        
           IF RW-THIRD-PTY-READ-DT > SPACES                             
              MOVE RW-THIRD-PTY-READ-DT(1:4)                            
                                         TO  WS-READ-DT-THIRD-PTY-YYYY  
              MOVE RW-THIRD-PTY-READ-DT(6:2)                            
                                         TO  WS-READ-DT-THIRD-PTY-MM    
              MOVE RW-THIRD-PTY-READ-DT(9:2)                            
                                         TO  WS-READ-DT-THIRD-PTY-DD    
                                                                        
              IF RW-THIRD-PTY-READ-DT > SPACES                          
                 MOVE WS-READ-DT-THIRD-PTY  TO  S-READ-DT               
              ELSE                                                      
                 MOVE SPACES                TO  S-READ-DT               
              END-IF                                                    
                                                                        
           ELSE                                                         
              MOVE RW-OPTIMUM-READ-DATE(1:4)                            
                                         TO WS-READ-DT-OPTIMUM-YYYY     
              MOVE RW-OPTIMUM-READ-DATE(6:2)                            
                                         TO WS-READ-DT-OPTIMUM-MM       
              MOVE RW-OPTIMUM-READ-DATE(9:2)                            
                                         TO WS-READ-DT-OPTIMUM-DD       
                                                                        
              IF RW-OPTIMUM-READ-DATE > SPACES                          
                 MOVE WS-READ-DT-OPTIMUM TO S-READ-DT                   
              ELSE                                                      
                 MOVE SPACES             TO S-READ-DT                   
              END-IF                                                    
                                                                        
           END-IF.                                                      
                                                                        
       2140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04750000
      * 2150-LOAD-CRED-FORECAST.                                       *04760000
      ******************************************************************04770000
      *                                                                 04780000
       2150-LOAD-CRED-FORECAST.                                         
      *                                                                 04800000
           MOVE WS-REV-MONTH-NO          TO WS-REV-MONTH-CM.            
                                                                        
           MOVE CM-CURR-CHG-DUE-DT(1:4)  TO WS-BILL-DUE-DT-YYYY.        
           MOVE CM-CURR-CHG-DUE-DT(6:2)  TO WS-BILL-DUE-DT-MM.          
           MOVE CM-CURR-CHG-DUE-DT(9:2)  TO WS-BILL-DUE-DT-DD.          
                                                                        
           IF CM-CURR-CHG-DUE-DT > SPACES                               
              MOVE WS-BILL-DUE-DT        TO S-BILL-DUE-DT               
           ELSE                                                         
              MOVE SPACES                TO S-BILL-DUE-DT               
           END-IF.                                                      
                                                                        
           MOVE CM-BILL-DT(1:4)          TO WS-FST-NOTICE-DT-YYYY.      
           MOVE CM-BILL-DT(6:2)          TO WS-FST-NOTICE-DT-MM.        
           MOVE CM-BILL-DT(9:2)          TO WS-FST-NOTICE-DT-DD.        
                                                                        
           IF CM-BILL-DT > SPACES                                       
              MOVE WS-FST-NOTICE-DT      TO S-FST-NOTICE-DT             
           ELSE                                                         
              MOVE WS-FST-NOTICE-DT      TO S-FST-NOTICE-DT             
           END-IF.                                                      
                                                                        
           MOVE CM-DNP-NOTICE-MAIL-DT(1:4) TO WS-SCND-NOTICE-DT-YYYY.   
           MOVE CM-DNP-NOTICE-MAIL-DT(6:2) TO WS-SCND-NOTICE-DT-MM.     
           MOVE CM-DNP-NOTICE-MAIL-DT(9:2) TO WS-SCND-NOTICE-DT-DD.     
                                                                        
           IF CM-DNP-NOTICE-MAIL-DT > SPACES                            
              MOVE WS-SCND-NOTICE-DT     TO S-SCND-NOTICE-DT            
           ELSE                                                         
              MOVE SPACES                TO S-SCND-NOTICE-DT            
           END-IF.                                                      
                                                                        
           MOVE CM-DNP-DT(1:4)           TO WS-DNP-DT-YYYY.             
           MOVE CM-DNP-DT(6:2)           TO WS-DNP-DT-MM.               
           MOVE CM-DNP-DT(9:2)           TO WS-DNP-DT-DD.               
                                                                        
           IF CM-DNP-DT > SPACES                                        
              MOVE WS-DNP-DT             TO S-DNP-DT                    
           ELSE                                                         
              MOVE SPACES                TO S-DNP-DT                    
           END-IF.                                                      
                                                                        
           MOVE CM-AVOID-LPC-DT(1:4)     TO WS-AVOID-LPC-DT-YYYY.       
           MOVE CM-AVOID-LPC-DT(6:2)     TO WS-AVOID-LPC-DT-MM.         
           MOVE CM-AVOID-LPC-DT(9:2)     TO WS-AVOID-LPC-DT-DD.         
                                                                        
           IF CM-AVOID-LPC-DT > SPACES                                  
              MOVE WS-AVOID-LPC-DT       TO S-AVOID-LPC-DT              
           ELSE                                                         
              MOVE SPACES                TO S-AVOID-LPC-DT              
           END-IF.                                                      
                                                                        
           MOVE CM-ARREARS-DUE-DT(1:4)   TO WS-FST-NOTICE-DUE-DT-YYYY.  
           MOVE CM-ARREARS-DUE-DT(6:2)   TO WS-FST-NOTICE-DUE-DT-MM.    
           MOVE CM-ARREARS-DUE-DT(9:2)   TO WS-FST-NOTICE-DUE-DT-DD.    
                                                                        
           IF CM-ARREARS-DUE-DT > SPACES AND AT-CREDIT-GROUP            
              NOT EQUAL WS-EXEMPT                                       
              MOVE WS-FST-NOTICE-DUE-DT  TO S-FST-NOTICE-DUE-DT         
           ELSE                                                         
              MOVE SPACES                TO S-FST-NOTICE-DUE-DT         
           END-IF.                                                      
                                                                        
           MOVE CM-DNP-NOTICE-DUE-DT(1:4) TO WS-SCND-NOTICE-DUE-DT-YYYY.
           MOVE CM-DNP-NOTICE-DUE-DT(6:2) TO WS-SCND-NOTICE-DUE-DT-MM.  
           MOVE CM-DNP-NOTICE-DUE-DT(9:2) TO WS-SCND-NOTICE-DUE-DT-DD.  
                                                                        
           IF CM-DNP-NOTICE-DUE-DT  > SPACES                            
              MOVE WS-SCND-NOTICE-DUE-DT  TO S-SCND-NOTICE-DUE-DT       
           ELSE                                                         
              MOVE SPACES                 TO S-SCND-NOTICE-DUE-DT       
           END-IF.                                                      
                                                                        
           PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.          
                                                                        
       2150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04940000
      ******************************************************************04950000
      * 2160-CALC-REVENUE-MNTH.                                         04960000
      ******************************************************************04970000
      *                                                                 04980000
       2160-CALC-REVENUE-MNTH.                                          
      *                                                                 05000000
           MOVE WS-REV-MONTH-NO          TO WS-REV-MONTH-NO1.           
                                                                        
           MOVE WS-REV-MONTH-NO1         TO WS-YEAR-MONTH1.             
                                                                        
           IF WS-MONTH1 = 12                                            
               MOVE 01                   TO WS-MONTH1                   
               COMPUTE WS-YEAR1 = WS-YEAR1 + 1                          
           ELSE                                                         
               COMPUTE WS-MONTH1 = WS-MONTH1 + 1                        
           END-IF.                                                      
                                                                        
                                                                        
           MOVE WS-YEAR-MONTH1           TO WS-REV-MONTH-NO1.           
           MOVE WS-REV-MONTH-NO1         TO WS-REV-MONTH-CM1.           
                                                                        
       2160-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05180000
      ******************************************************************05190000
      * 2170-FORECAST-PREV-MNT.                                         05200000
      ******************************************************************05210000
      *                                                                 05220000
       2170-FORECAST-PREV-MNT.                                          
      *                                                                 05240000
           PERFORM 2120-GET-PREV-REV-MNT       THRU 2120-EXIT.          
                                                                        
           MOVE WS-REV-MONTH-NO          TO S-BILLING-MTH.              
                                                                        
      * CALCULATE PREVIOUS MONTH + 1                                    05281000
                                                                        
           PERFORM 2160-CALC-REVENUE-MNTH      THRU 2160-EXIT.          
                                                                        
           PERFORM 2140-LOAD-BILL-READ-DT      THRU 2140-EXIT.          
                                                                        
           PERFORM 7010-GET-CRED-FORECAST-DET                           
                                               THRU 7010-EXIT.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE  =  NOT-FOUND                       
              MOVE +100                 TO S-RETURN-CODE                
              PERFORM 8100-SEND-RESULT         THRU 8100-EXIT           
           ELSE                                                         
              PERFORM 7020-GET-CRED-FORECAST-DET1                       
                                               THRU 7020-EXIT           
              PERFORM 2150-LOAD-CRED-FORECAST                           
                                               THRU 2150-EXIT           
           END-IF.                                                      
      *                                                                 05450000
       2170-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05480000
      ******************************************************************05490000
      * 2180-FORECAST-CURR-MNT.                                         05500000
      ******************************************************************05510000
      *                                                                 05520000
       2180-FORECAST-CURR-MNT.                                          
      *                                                                 05540000
      * CALCULATE CURRENT  MONTH + 1                                    05541000
           PERFORM 2160-CALC-REVENUE-MNTH      THRU 2160-EXIT.          
                                                                        
           PERFORM 2140-LOAD-BILL-READ-DT      THRU 2140-EXIT.          
                                                                        
           PERFORM 7010-GET-CRED-FORECAST-DET                           
                                               THRU 7010-EXIT.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE  =  NOT-FOUND                       
              MOVE +100                  TO S-RETURN-CODE               
              PERFORM 8100-SEND-RESULT         THRU 8100-EXIT           
           ELSE                                                         
              PERFORM 7020-GET-CRED-FORECAST-DET1                       
                                               THRU 7020-EXIT           
              PERFORM 2150-LOAD-CRED-FORECAST                           
                                               THRU 2150-EXIT           
           END-IF.                                                      
      *                                                                 05710000
       2180-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05740000
      ******************************************************************05750000
      * 2190-FORECAST-NEXT-MNT.                                         05760000
      ******************************************************************05770000
      *                                                                 05780000
       2190-FORECAST-NEXT-MNT.                                          
      *                                                                 05800000
           PERFORM 2130-GET-NEXT-REV-MNT       THRU 2130-EXIT.          
                                                                        
           MOVE WS-REV-MONTH-NO          TO S-BILLING-MTH.              
                                                                        
      * CALCULATE FUTURE MONTH + 1                                      05841000
                                                                        
           PERFORM 2160-CALC-REVENUE-MNTH      THRU 2160-EXIT.          
                                                                        
           PERFORM 2140-LOAD-BILL-READ-DT      THRU 2140-EXIT.          
                                                                        
           PERFORM 7010-GET-CRED-FORECAST-DET                           
                                               THRU 7010-EXIT.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE  =  NOT-FOUND                       
              MOVE +100               TO S-RETURN-CODE                  
              PERFORM 8100-SEND-RESULT         THRU 8100-EXIT           
           ELSE                                                         
              PERFORM 7020-GET-CRED-FORECAST-DET1                       
                                               THRU 7020-EXIT           
              PERFORM 2150-LOAD-CRED-FORECAST                           
                                               THRU 2150-EXIT           
           END-IF.                                                      
      *                                                                 06010000
       2190-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06040000
      ******************************************************************06050000
      * 7000-GET-ACCT-DATA.                                            *06060000
      ******************************************************************06070000
      *                                                                 06080000
       7000-GET-ACCT-DATA.                                              
      *                                                                 06100000
           EXEC SQL                                                     
              SELECT AT.BILL_CYCLE                                      
                    ,AT.CREDIT_GROUP                                    
                    ,AT.REV_MTH_LST_NRML                                
                    ,AT.COMPANY_NO                                      
                    ,AT.ACCOUNT_TYPE_CODE                               
                INTO :AT-BILL-CYCLE                                     
                    ,:AT-CREDIT-GROUP                                   
                    ,:AT-REV-MTH-LST-NRML                               
                    ,:AT-COMPANY-NO                                     
                    ,:AT-ACCOUNT-TYPE-CODE                              
                FROM CSS_ACCOUNT    AT WITH(READUNCOMMITTED)                    
               WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     06110000
MFA-TR*       SELECT AT.BILL_CYCLE                                      06120000
MFA-TR*             ,AT.CREDIT_GROUP                                    06130000
MFA-TR*             ,AT.REV_MTH_LST_NRML                                06140000
MFA-TR*             ,AT.COMPANY_NO                                      06150000
MFA-TR*             ,AT.ACCOUNT_TYPE_CODE                               06160000
MFA-TR*         INTO :AT-BILL-CYCLE                                     06170000
MFA-TR*             ,:AT-CREDIT-GROUP                                   06180000
MFA-TR*             ,:AT-REV-MTH-LST-NRML                               06190000
MFA-TR*             ,:AT-COMPANY-NO                                     06200000
MFA-TR*             ,:AT-ACCOUNT-TYPE-CODE                              06210000
MFA-TR*         FROM CSS_ACCOUNT    AT                                  06220000
MFA-TR*        WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     06230000
MFA-TR*         WITH UR                                                 06240000
MFA-TR*      QUERYNO 7000                                               06250000
MFA-TR*    END-EXEC.                                                    06260000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 06270000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                 06290000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 06410000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06440000
      ******************************************************************06450000
      * 7010-GET-CRED-FORECAST-DET.                                     06460000
      * CURSOR TO EXTRACT NEEDED CREDIT FORECST VALUES.                 06470000
      ******************************************************************06480000
      *                                                                 06490000
       7010-GET-CRED-FORECAST-DET.                                      
      *                                                                 06510000
           EXEC SQL                                                     
              SELECT TOP(1) CM.REVENUE_MONTH,
              CM.BILL_CYCLE,
              CM.BILL_DT,
              CM.CRED_FORECAST_CD,
              CM.CURR_CHG_DUE_DT,
              CM.DNP_NOTICE_MAIL_DT,
              CM.AVOID_LPC_DT                                    
               INTO  :CM-REVENUE-MONTH                                  
                    ,:CM-BILL-CYCLE                                     
                    ,:CM-BILL-DT                                        
                    ,:CM-CRED-FORECAST-CD                               
                    ,:CM-CURR-CHG-DUE-DT :WS-NULL-CURR-CHG-DUE-DT    
                    ,:CM-DNP-NOTICE-MAIL-DT :WS-NULL-DNP-NOTICE-MAIL-DT 
                    ,:CM-AVOID-LPC-DT :WS-NULL-AVOID-LPC-DT       
                FROM CSS_CRED_FORECAST  CM WITH(READUNCOMMITTED)                
               WHERE CM.REVENUE_MONTH     = :WS-REV-MONTH-CM            
                 AND CM.CREDIT_GROUP_ID   = :WS-SPACES                  
                 AND CM.CRED_ACCT_TYPE_CD = :WS-CRED-ACCT-TYPE-CD       
      *          AND CM.BILL_DT           = :CM-BILL-DT                 06710000
                 AND CM.BILL_CYCLE        = :AT-BILL-CYCLE              
                 AND CM.COMPANY_NO        = :AT-COMPANY-NO              
                 AND CM.CREDIT_GROUP      = :AT-CREDIT-GROUP            
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     06520000
MFA-TR*       SELECT CM.REVENUE_MONTH                                   06530000
MFA-TR*             ,CM.BILL_CYCLE                                      06540000
MFA-TR*             ,CM.BILL_DT                                         06550000
MFA-TR*             ,CM.CRED_FORECAST_CD                                06560000
MFA-TR*             ,CM.CURR_CHG_DUE_DT                                 06570000
MFA-TR*             ,CM.DNP_NOTICE_MAIL_DT                              06580000
MFA-TR*             ,CM.AVOID_LPC_DT                                    06590000
MFA-TR*        INTO  :CM-REVENUE-MONTH                                  06600000
MFA-TR*             ,:CM-BILL-CYCLE                                     06610000
MFA-TR*             ,:CM-BILL-DT                                        06620000
MFA-TR*             ,:CM-CRED-FORECAST-CD                               06630000
MFA-TR*             ,:CM-CURR-CHG-DUE-DT    :WS-NULL-CURR-CHG-DUE-DT    06640000
MFA-TR*             ,:CM-DNP-NOTICE-MAIL-DT :WS-NULL-DNP-NOTICE-MAIL-DT 06650000
MFA-TR*             ,:CM-AVOID-LPC-DT       :WS-NULL-AVOID-LPC-DT       06660000
MFA-TR*         FROM CSS_CRED_FORECAST  CM                              06670000
MFA-TR*        WHERE CM.REVENUE_MONTH     = :WS-REV-MONTH-CM            06680000
MFA-TR*          AND CM.CREDIT_GROUP_ID   = :WS-SPACES                  06690000
MFA-TR*          AND CM.CRED_ACCT_TYPE_CD = :WS-CRED-ACCT-TYPE-CD       06700000
MFA-TR*          AND CM.BILL_DT           = :CM-BILL-DT                 06710000
MFA-TR*          AND CM.BILL_CYCLE        = :AT-BILL-CYCLE              06720000
MFA-TR*          AND CM.COMPANY_NO        = :AT-COMPANY-NO              06730000
MFA-TR*          AND CM.CREDIT_GROUP      = :AT-CREDIT-GROUP            06740000
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                            06750000
MFA-TR*      QUERYNO 7010                                               06760000
MFA-TR*    END-EXEC.                                                    06770000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 06780000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                 06800000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR  NOT-FOUND    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7010'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE 'CSS_CRED_FORECAST'    TO TABLE-1                    
              MOVE 'BILL_CYCLE'           TO TABLE-ELEMENT-1            
              MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-1            
              MOVE 'CREDIT_GROUP'         TO TABLE-ELEMENT-1            
              MOVE 'CRED_ACCT_TYPE_CD'    TO TABLE-ELEMENT-1            
              MOVE  AT-BILL-CYCLE         TO HOSTVAR-ELEMENT-1          
              MOVE  AT-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
              MOVE  AT-CREDIT-GROUP       TO HOSTVAR-ELEMENT-1          
              MOVE  CM-CRED-ACCT-TYPE-CD  TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
      *                                                                 06980000
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07010000
      ******************************************************************07020000
      * 7020-GET-CRED-FORECAST-DET1.                                    07030000
      * CURSOR TO EXTRACT NEEDED CREDIT FORECST VALUES.                 07040000
      ******************************************************************07050000
      *                                                                 07060000
       7020-GET-CRED-FORECAST-DET1.                                     
      *                                                                 07080000
           EXEC SQL                                                     
                                                                        
             SELECT TOP(1) CM.DNP_DT,
              CM.ARREARS_DUE_DT,
              CM.DNP_NOTICE_DUE_DT                               
                                                                        
               INTO  :CM-DNP-DT :WS-NULL-DNP-DT             
                    ,:CM-ARREARS-DUE-DT :WS-NULL-ARREARS-DUE-DT     
                    ,:CM-DNP-NOTICE-DUE-DT :WS-NULL-DNP-NOTICE-DUE-DT  
                                                                        
                FROM CSS_CRED_FORECAST  CM WITH(READUNCOMMITTED)                
               WHERE CM.REVENUE_MONTH     = :WS-REV-MONTH-CM1           
                 AND CM.CREDIT_GROUP_ID   = :WS-SPACES                  
                 AND CM.CRED_ACCT_TYPE_CD = :WS-CRED-ACCT-TYPE-CD       
      *          AND CM.BILL_DT           = :CM-BILL-DT                 07230000
                 AND CM.BILL_CYCLE        = :AT-BILL-CYCLE              
                 AND CM.COMPANY_NO        = :AT-COMPANY-NO              
                 AND CM.CREDIT_GROUP      = :AT-CREDIT-GROUP            
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07090000
MFA-TR*                                                                 07100000
MFA-TR*      SELECT  CM.DNP_DT                                          07110000
MFA-TR*             ,CM.ARREARS_DUE_DT                                  07120000
MFA-TR*             ,CM.DNP_NOTICE_DUE_DT                               07130000
MFA-TR*                                                                 07140000
MFA-TR*        INTO  :CM-DNP-DT             :WS-NULL-DNP-DT             07150000
MFA-TR*             ,:CM-ARREARS-DUE-DT     :WS-NULL-ARREARS-DUE-DT     07160000
MFA-TR*             ,:CM-DNP-NOTICE-DUE-DT  :WS-NULL-DNP-NOTICE-DUE-DT  07170000
MFA-TR*                                                                 07180000
MFA-TR*         FROM CSS_CRED_FORECAST  CM                              07190000
MFA-TR*        WHERE CM.REVENUE_MONTH     = :WS-REV-MONTH-CM1           07200000
MFA-TR*          AND CM.CREDIT_GROUP_ID   = :WS-SPACES                  07210000
MFA-TR*          AND CM.CRED_ACCT_TYPE_CD = :WS-CRED-ACCT-TYPE-CD       07220000
MFA-TR*          AND CM.BILL_DT           = :CM-BILL-DT                 07230000
MFA-TR*          AND CM.BILL_CYCLE        = :AT-BILL-CYCLE              07240000
MFA-TR*          AND CM.COMPANY_NO        = :AT-COMPANY-NO              07250000
MFA-TR*          AND CM.CREDIT_GROUP      = :AT-CREDIT-GROUP            07260000
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                            07270000
MFA-TR*      QUERYNO 7020                                               07280000
MFA-TR*    END-EXEC.                                                    07290000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07300000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                 07320000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR  NOT-FOUND    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7020'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE 'CSS_CRED_FORECAST'    TO TABLE-1                    
              MOVE 'BILL_CYCLE'           TO TABLE-ELEMENT-1            
              MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-1            
              MOVE 'CREDIT_GROUP'         TO TABLE-ELEMENT-1            
              MOVE 'CRED_ACCT_TYPE_CD'    TO TABLE-ELEMENT-1            
              MOVE  AT-BILL-CYCLE         TO HOSTVAR-ELEMENT-1          
              MOVE  AT-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
              MOVE  AT-CREDIT-GROUP       TO HOSTVAR-ELEMENT-1          
              MOVE  CM-CRED-ACCT-TYPE-CD  TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
      *                                                                 07500000
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07530000
      ******************************************************************07540000
      * 7100-GET-BILL-CYCLE-DT.                                        *07550000
      * SELECT EXTRACT DATES FOR THE SPECIFIED BILL CYCLE AND REV MONTH*07560000
      ******************************************************************07570000
      *                                                                 07580000
       7100-GET-BILL-CYCLE-DT.                                          
      *                                                                 07600000
           EXEC SQL                                                     
              SELECT MIN(BN.DATE_EXTRACT)                               
                    ,MAX(BN.DATE_EXTRACT)                               
                INTO :WS-MIN-DATE-EXTRACT :WS-NULL-MIN-DATE             
                    ,:WS-MAX-DATE-EXTRACT :WS-NULL-MAX-DATE             
                FROM CSS_BILL_WINDOW   BN WITH(READUNCOMMITTED)                 
               WHERE BN.REVENUE_MONTH  =  :WS-REV-MONTH-CM              
                 AND BN.BILL_CYCLE     =  :AT-BILL-CYCLE                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07610000
MFA-TR*       SELECT MIN(BN.DATE_EXTRACT)                               07620000
MFA-TR*             ,MAX(BN.DATE_EXTRACT)                               07630000
MFA-TR*         INTO :WS-MIN-DATE-EXTRACT :WS-NULL-MIN-DATE             07640000
MFA-TR*             ,:WS-MAX-DATE-EXTRACT :WS-NULL-MAX-DATE             07650000
MFA-TR*         FROM CSS_BILL_WINDOW   BN                               07660000
MFA-TR*        WHERE BN.REVENUE_MONTH  =  :WS-REV-MONTH-CM              07670000
MFA-TR*          AND BN.BILL_CYCLE     =  :AT-BILL-CYCLE                07680000
MFA-TR*         WITH UR                                                 07690000
MFA-TR*      QUERYNO 7100                                               07700000
MFA-TR*    END-EXEC.                                                    07710000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07720000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                 07740000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-NULL-MIN-DATE < 0  OR WS-NULL-MAX-DATE < 0          
                 MOVE -100                   TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE           
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '7100'                 TO ACTIVE-PARAGRAPH        
                 MOVE 'SELECT'               TO ABEND-FUNCTION          
                 MOVE 'CSS_BILL_WINDOW'      TO TABLE-1                 
                 MOVE 'REVENUE_MONTH'        TO TABLE-ELEMENT-1         
                 MOVE  WS-REV-MONTH-CM       TO HOSTVAR-ELEMENT-1       
                 MOVE 'BILL_CYCLE'           TO TABLE-ELEMENT-2         
                 MOVE  AT-BILL-CYCLE         TO HOSTVAR-ELEMENT-2       
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT            
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7100'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE 'CSS_BILL_WINDOW'      TO TABLE-1                    
              MOVE 'REVENUE_MONTH'        TO TABLE-ELEMENT-1            
              MOVE  WS-REV-MONTH-CM       TO HOSTVAR-ELEMENT-1          
              MOVE 'BILL_CYCLE'           TO TABLE-ELEMENT-2            
              MOVE  AT-BILL-CYCLE         TO HOSTVAR-ELEMENT-2          
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
      *                                                                 08000000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08030000
      ******************************************************************08040000
      * 7110-GET-OPTIMUM-RD-DT.                                        *08050000
      * SELECTS OPTIMUM READ DATE FOR THE GIVEN BILL CYCLE AND REV MTH *08060000
      ******************************************************************08070000
      *                                                                 08080000
       7110-GET-OPTIMUM-RD-DT.                                          
      *                                                                 08100000
           EXEC SQL                                                     
              SELECT RW.OPTIMUM_READ_DATE                               
                    ,RW.THIRD_PTY_READ_DT                               
                INTO :RW-OPTIMUM-READ-DATE :WS-NULL-OPTIMUM-READ        
                    ,:RW-THIRD-PTY-READ-DT :WS-NULL-THIRD-PTY-READ      
                FROM CSS_READ_WINDOW   RW WITH(READUNCOMMITTED)                 
               WHERE RW.REVENUE_MONTH  =  :WS-REV-MONTH-CM              
                 AND RW.READ_CYCLE     =  :AT-BILL-CYCLE                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08110000
MFA-TR*       SELECT RW.OPTIMUM_READ_DATE                               08120000
MFA-TR*             ,RW.THIRD_PTY_READ_DT                               08130000
MFA-TR*         INTO :RW-OPTIMUM-READ-DATE :WS-NULL-OPTIMUM-READ        08140000
MFA-TR*             ,:RW-THIRD-PTY-READ-DT :WS-NULL-THIRD-PTY-READ      08150000
MFA-TR*         FROM CSS_READ_WINDOW   RW                               08160000
MFA-TR*        WHERE RW.REVENUE_MONTH  =  :WS-REV-MONTH-CM              08170000
MFA-TR*          AND RW.READ_CYCLE     =  :AT-BILL-CYCLE                08180000
MFA-TR*         WITH UR                                                 08190000
MFA-TR*      QUERYNO 7110                                               08200000
MFA-TR*    END-EXEC.                                                    08210000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08220000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                 08240000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-NULL-THIRD-PTY-READ  <  0                           
                 MOVE SPACES                 TO RW-THIRD-PTY-READ-DT    
                 MOVE ZERO                   TO WS-NULL-THIRD-PTY-READ  
              END-IF                                                    
              IF WS-NULL-OPTIMUM-READ    <  0                           
                 MOVE -100                   TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE           
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '7110'                 TO ACTIVE-PARAGRAPH        
                 MOVE 'SELECT'               TO ABEND-FUNCTION          
                 MOVE 'CSS_READ_WINDOW'      TO TABLE-1                 
                 MOVE 'REVENUE_MONTH'        TO TABLE-ELEMENT-1         
                 MOVE  WS-REV-MONTH-CM       TO HOSTVAR-ELEMENT-1       
                 MOVE 'BILL_CYCLE'           TO TABLE-ELEMENT-2         
                 MOVE  AT-BILL-CYCLE         TO HOSTVAR-ELEMENT-2       
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT            
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7110'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE 'CSS_READ_WINDOW'      TO TABLE-1                    
              MOVE 'REVENUE_MONTH'        TO TABLE-ELEMENT-1            
              MOVE  WS-REV-MONTH-CM       TO HOSTVAR-ELEMENT-1          
              MOVE 'BILL_CYCLE'           TO TABLE-ELEMENT-2            
              MOVE  AT-BILL-CYCLE         TO HOSTVAR-ELEMENT-2          
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
      *                                                                 08540000
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08570000
      ******************************************************************08580000
      * 7120-GET-REVENUE-MONTH.                                        *08590000
      * SELECT REVENUE MONTH FOR THE SPECIFIED BILL CYCLE              *08600000
      ******************************************************************08610000
      *                                                                 08620000
       7120-GET-REVENUE-MONTH.                                          
      *                                                                 08640000
           EXEC SQL                                                     
              SELECT TOP(1) BN.REVENUE_MONTH                                   
                INTO :BN-REVENUE-MONTH                                  
                FROM CSS_BILL_WINDOW   BN WITH(READUNCOMMITTED)                 
               WHERE BN.DATE_EXTRACT  <=  CAST(SYSDATETIMEOFFSET() 
           AS DATE)                  
                 AND BN.BILL_CYCLE     =  :AT-BILL-CYCLE                
                ORDER BY BN.REVENUE_MONTH DESC                          
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     08650000
MFA-TR*       SELECT BN.REVENUE_MONTH                                   08660000
MFA-TR*         INTO :BN-REVENUE-MONTH                                  08670000
MFA-TR*         FROM CSS_BILL_WINDOW   BN                               08680000
MFA-TR*        WHERE BN.DATE_EXTRACT  <=  CURRENT DATE                  08690000
MFA-TR*          AND BN.BILL_CYCLE     =  :AT-BILL-CYCLE                08700000
MFA-TR*         ORDER BY BN.REVENUE_MONTH DESC                          08710000
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                            08720000
MFA-TR*      QUERYNO 7120                                               08730000
MFA-TR*    END-EXEC.                                                    08740000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08750000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                 08770000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7120'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE 'CSS_BILL_WINDOW'      TO TABLE-1                    
              MOVE 'BILL_CYCLE'           TO TABLE-ELEMENT-1            
              MOVE  AT-BILL-CYCLE         TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
      *                                                                 08890000
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08920000
      ******************************************************************08930000
      * 8000A-DEL-GTT-ROWS.                                            *08940000
      ******************************************************************08950000
      *                                                                 08960000
       8000A-DEL-GTT-ROWS.                                              
      *                                                                 08980000
           EXEC SQL                                                     
               DELETE FROM #CSR04904_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     08990000
MFA-TR*        DELETE FROM SESSION.CSR04904_R1                          09000000
MFA-TR*    END-EXEC.                                                    09010000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 09020000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE.          
      *                                                                 09050000
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE           
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE SQLCODE             TO ABEND-SQLCODE           
                    MOVE SQLSTATE            TO ABEND-SQLSTATE          
                    MOVE '8000A'             TO ACTIVE-PARAGRAPH        
                    MOVE 'DELETE'            TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CSR04904_R1'       TO TABLE-1                 
                    MOVE SPACES              TO TABLE-ELEMENT-1         
                    MOVE SPACES              TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                 09250000
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                 09280000
      ******************************************************************09290000
      * 8100-SEND-RESULT.                                              *09300000
      ******************************************************************09310000
      *                                                                 09320000
       8100-SEND-RESULT.                                                
      *                                                                 09340000
            EXEC SQL                                                    
               INSERT INTO #CSR04904_R1                          
                  (                                                     
                    RETURN_CODE                                         
                   ,BILLING_MTH                                         
                   ,READ_DT                                             
                   ,MAIL_DT                                             
                   ,BILL_DUE_DT                                         
                   ,AVOID_LPC_DT                                        
                   ,FST_NOTICE_DT                                       
                   ,SCND_NOTICE_DT                                      
                   ,DNP_DT                                              
                   ,FST_NOT_DUE_DT                                      
                   ,SCN_NOT_DUE_DT                                      
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE                                      
                   ,:S-BILLING-MTH                                      
                   ,:S-READ-DT                                          
                   ,:S-MAIL-DT                                          
                   ,:S-BILL-DUE-DT                                      
                   ,:S-AVOID-LPC-DT                                     
                   ,:S-FST-NOTICE-DT                                    
                   ,:S-SCND-NOTICE-DT                                   
                   ,:S-DNP-DT                                           
                   ,:S-FST-NOTICE-DUE-DT                                
                   ,:S-SCND-NOTICE-DUE-DT                               
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    09350000
MFA-TR*        INSERT INTO SESSION.CSR04904_R1                          09360000
MFA-TR*           (                                                     09370000
MFA-TR*             RETURN_CODE                                         09380000
MFA-TR*            ,BILLING_MTH                                         09390000
MFA-TR*            ,READ_DT                                             09400000
MFA-TR*            ,MAIL_DT                                             09410000
MFA-TR*            ,BILL_DUE_DT                                         09420000
MFA-TR*            ,AVOID_LPC_DT                                        09430000
MFA-TR*            ,FST_NOTICE_DT                                       09440000
MFA-TR*            ,SCND_NOTICE_DT                                      09450000
MFA-TR*            ,DNP_DT                                              09460000
MFA-TR*            ,FST_NOT_DUE_DT                                      09470000
MFA-TR*            ,SCN_NOT_DUE_DT                                      09480000
MFA-TR*           )                                                     09490000
MFA-TR*        VALUES                                                   09500000
MFA-TR*           (                                                     09510000
MFA-TR*             :S-RETURN-CODE                                      09520000
MFA-TR*            ,:S-BILLING-MTH                                      09530000
MFA-TR*            ,:S-READ-DT                                          09540000
MFA-TR*            ,:S-MAIL-DT                                          09550000
MFA-TR*            ,:S-BILL-DUE-DT                                      09560000
MFA-TR*            ,:S-AVOID-LPC-DT                                     09570000
MFA-TR*            ,:S-FST-NOTICE-DT                                    09580000
MFA-TR*            ,:S-SCND-NOTICE-DT                                   09590000
MFA-TR*            ,:S-DNP-DT                                           09600000
MFA-TR*            ,:S-FST-NOTICE-DUE-DT                                09610000
MFA-TR*            ,:S-SCND-NOTICE-DUE-DT                               09620000
MFA-TR*           )                                                     09630000
MFA-TR*     END-EXEC                                                    09640000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 09650000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
      *                                                                 09680000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8100'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04904_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 09830000
        8100-EXIT.                                                      
            EXIT.                                                       
      *                                                                 09860000
      ******************************************************************09870000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     09880000
      ******************************************************************09890000
           EXEC SQL                                                     09900000
              INCLUDE CPDSP300                                          09910000
           END-EXEC.                                                    09920000
                                                                        
      *                                                                 09940000
      ******************************************************************09950000
      * INCLUDE CPD0023C FOR 9700- ERROR HANDLING                      *09960000
      ******************************************************************09970000
      *                                                                 09980000
           EXEC SQL                                                     09990000
              INCLUDE CPD0023C                                          10000000
           END-EXEC.                                                    10010000
      *                                                                 10020000
      ******************************************************************10030000
      *  THIS COPYBOOK NEEDS TO BE USED BY PROGRAM WHERE WE ARE        *10040000
      *  RETURNING MULTIPLE ROWS.                                      *10050000
      ******************************************************************10060000
           EXEC SQL                                                     10070000
               INCLUDE CPD00320                                         10080000
           END-EXEC.                                                    10090000
