       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04903.                                         
COB303 DATE-WRITTEN.  MAR 07,2016.                                      
       DATE-COMPILED.                                                   
      *                                                                 00050000
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *                                                                *00100000
      ******************************************************************00110000
      *                 P R O G R A M  S U M M A R Y                   *00120000
      *                                                                *00130000
      *  THIS PROGRAM INSERT, UPDATE OR DELETE THE CSS_BTU_FACTOR      *00140000
      *  BASED ON THE ACTION IN THE FIELD SCREEN.                      *00150000
      *                                                                *00160000
      *  CLONED FROM CSR03107,CSR03108 & CSR03109.                     *00170000
      *                                                                *00180000
      *---------------------------------------------------------------- 00190000
      *--                                                            -- 00200000
      *--  PARAMETERS:                                               -- 00210000
      *--                                                            -- 00220000
      *--  RESULT SET.                                               -- 00230000
      *--                                                            -- 00240000
      *--           RETURN_CODE                INTEGER               -- 00250000
      *--                                                            -- 00260000
      ******************************************************************00270000
      *                                                                *00280000
      *                     PROGRAM MODIFICATION LOG                   *00290000
      *                                                                *00300000
      *    DATE    INITIALS   COMMENTS                                 *00310000
      *  --------  --------   ---------------------------------------  *00320000
      *  03/07/15  SS7F226    PROCEDURE ORIGINALLY CODED.              *00330000
      ******************************************************************00340000
      ******************************************************************00350000
      *                                                                *00360000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00370000
      *                                                                *00380000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00390000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00400000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00410000
      *  3000 - 4999  NOT USED                                         *00420000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00430000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00440000
      *  7000 - 7999  INPUT MODULES                                    *00450000
      *  8000 - 8999  OUTPUT MODULES                                   *00460000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00470000
      *                                                                *00480000
      ******************************************************************00490000
      *                                                                 00500000
       ENVIRONMENT DIVISION.                                            
      *                                                                 00520000
       DATA DIVISION.                                                   
      *                                                                 00540000
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04903'.
MSQ017     COPY MFASQLM.
      *                                                                 00560000
      ******************************************************************00570000
      * WORKING STORAGE COPYBOOKS FOR CPD04353                         *00580000
      ******************************************************************00590000
      *                                                                 00600000
       01 WS-START                      PIC X(40) VALUE                 
            'WORKING STORAGE FOR CSR04903 STARTS HERE'.                 
      *                                                                 00630000
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME               PIC X(08) VALUE 'CSR04903'.     
          05 WS-DELINQ-CD               PIC X(08) VALUE 'DATABASE'.     
          05 WS-ZERO                    PIC S9(4) VALUE 0.              
      *                                                                 00680000
       01 WS-MISC.                                                      
          05 WS-GTT-NAME                PIC X(19) VALUE SPACES.         
          05 WS-SQLSTATE                PIC X(05) VALUE SPACES.         
          05 WS-DATABASE                PIC 9(01) VALUE ZERO.           
             88  CSR-DATABASE                     VALUE 1.              
             88  SEB-DATABASE                     VALUE 2.              
          05 WS-CURR-COMPANY-NO         PIC X(02) VALUE SPACES.         
      *                                                                 00760000
       01 WS-COUNTERS.                                                  
          05 CTR-ROWS                   PIC S9(9) COMP VALUE 0.         
      *                                                                 00790000
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW               PIC X(01) VALUE 'Y'.            
             88 SEND-DONE-ERROR                   VALUE 'N'.            
             88 SEND-DONE-OK                      VALUE 'Y'.            
          05 WS-CURR-UPDT-ACTION-IND    PIC X(01) VALUE SPACES.         
             88 BTU-INSERT                        VALUE 'I'.            
             88 BTU-UPDATE                        VALUE 'U'.            
             88 BTU-DELETE                        VALUE 'D'.            
      *                                                                 00880000
       01 GTT-RETURN-FIELDS.                                            
          05  S-RETURN-CODE             PIC S9(09) COMP VALUE 0.        
      *                                                                 00910000
       01  WS-END                    PIC X(40)                          
           VALUE 'WORKING STORAGE FOR CSR04903 ENDS HERE  '.            
      *                                                                 00940000
      ***************************************************************** 00950000
      *    ERROR HANDLING                                               00960000
      ******************************************************************00970000
      *                                                                 00980000
           EXEC SQL                                                     00990000
              INCLUDE CWSX0010                                          01000000
           END-EXEC.                                                    01010000
      *                                                                 01020000
      ******************************************************************01030000
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *01040000
      ******************************************************************01050000
      *                                                                 01060000
           COPY CWS00303.                                               01070000
      *                                                                 01080000
      ******************************************************************01090000
      *   SQL COMMUNICATION AREA                                       *01100000
      ******************************************************************01110000
      *                                                                 01120000
           EXEC SQL                                                     01130000
               INCLUDE SQLCA                                            01140000
           END-EXEC.                                                    01150000
      *                                                                 01160000
      ******************************************************************01170000
      *    CSS_DELINQUENCY  -  C8                                      *01180000
      ******************************************************************01190000
      *                                                                 01200000
           EXEC SQL                                                     01210000
                INCLUDE TBDELQ                                          01220000
           END-EXEC.                                                    01230000
      *                                                                 01240000
      ******************************************************************01250000
      *    CSS_BTU_FACTOR    - TF                                      *01260000
      ******************************************************************01270000
      *                                                                 01280000
           EXEC SQL                                                     01290000
                INCLUDE TBBTUFCT                                        01300000
           END-EXEC.                                                    01310000
      *                                                                 01320000
       LINKAGE SECTION.                                                 
       01  PARM-ACTION-IND              PIC X(01).                      
       01  PARM-COMPANY-NO              PIC X(02).                      
       01  PARM-BTU-DT                  PIC X(10).                      
COB305 01 PARM-MCF-TRANSCO        PIC S9(7)V USAGE COMP-3 VALUE 0.        
COB305 01 PARM-BTU-TRANSCO        PIC S9(3)V9(5) USAGE COMP-3 VALUE 0.    
COB305 01 PARM-MCF-SLLY-BILFF        PIC S9(7)V USAGE COMP-3 VALUE 0.        
COB305 01 PARM-BT-SLLY-BILFF        PIC S9(3)V9(5) USAGE COMP-3 VALUE 0.    
COB305 01 PARM-MCF-SLLY-VPR        PIC S9(7)V USAGE COMP-3 VALUE 0.        
COB305 01 PARM-BT-SLLY-VPR        PIC S9(3)V9(5) USAGE COMP-3 VALUE 0.    
COB305 01 PARM-MCF-TOTAL        PIC S9(7)V USAGE COMP-3 VALUE 0.        
COB305 01 PARM-MMBTU-TOTAL        PIC S9(7)V USAGE COMP-3 VALUE 0.        
COB305 01 PARM-BTU-SNG        PIC S9(3)V9(5) USAGE COMP-3 VALUE 0.    
       01  PARM-LAST-UPDT-USRID         PIC X(07).                      
      *                                                                 01510000
       PROCEDURE DIVISION USING PARM-ACTION-IND                         
                                PARM-COMPANY-NO                         
                                PARM-BTU-DT                             
                                PARM-MCF-TRANSCO                        
                                PARM-BTU-TRANSCO                        
                                PARM-MCF-SLLY-BILFF                     
                                PARM-BT-SLLY-BILFF                      
                                PARM-MCF-SLLY-VPR                       
                                PARM-BT-SLLY-VPR                        
                                PARM-MCF-TOTAL                          
                                PARM-MMBTU-TOTAL                        
                                PARM-BTU-SNG                            
                                PARM-LAST-UPDT-USRID.                   
      *                                                                 01690000
      ******************************************************************01700000
      * 0000-MAINLINE                                                  *01710000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *01720000
      ******************************************************************01730000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
           
MSQ016        GOBACK.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01840000
      ******************************************************************01850000
      * 0100-INITIALIZE                                                *01860000
      ******************************************************************01870000
      *                                                                 01880000
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT :S-RETURN-CODE           AS RETURN_CODE            
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                     01950000
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                         01960000
MFA-TR*       SELECT :S-RETURN-CODE           AS RETURN_CODE            01970000
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                   01980000
MFA-TR*    END-EXEC.                                                    01990000
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02030000
      ******************************************************************02040000
      * 1000-PROCESS-INPUT.                                            *02050000
      ******************************************************************02060000
      *                                                                 02070000
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACTION-IND              TO WS-CURR-UPDT-ACTION-IND.
           MOVE PARM-BTU-DT                  TO TF-BTU-DT.              
           MOVE PARM-MCF-SLLY-BILFF          TO TF-MCF-SALLEY-BOILOFF.  
           MOVE PARM-MCF-TRANSCO             TO TF-MCF-TRANSCO.         
           MOVE PARM-BTU-TRANSCO             TO TF-BTU-TRANSCO.         
           MOVE PARM-MCF-SLLY-VPR            TO TF-MCF-SALLEY-VAPOR.    
           MOVE PARM-BT-SLLY-BILFF           TO TF-BTU-SALLEY-BOILOFF.  
           MOVE PARM-BT-SLLY-VPR             TO TF-BTU-SALLEY-VAPOR.    
           MOVE PARM-MMBTU-TOTAL             TO TF-MMBTU-TOTAL.         
           MOVE PARM-MCF-TOTAL               TO TF-MCF-TOTAL.           
           MOVE PARM-BTU-SNG                 TO TF-BTU-SNG.             
           MOVE PARM-COMPANY-NO              TO TF-COMPANY-NO           
                                                WS-CURR-COMPANY-NO.     
           MOVE PARM-LAST-UPDT-USRID         TO TF-LAST-UPDATE-USERID.  
                                                                        
      *    GET THE DATABASE.                                            02290000
           MOVE WS-DELINQ-CD                 TO C8-DELINQ-CD.           
           MOVE WS-CURR-COMPANY-NO           TO C8-COMPANY-NO.          
           PERFORM 7000-GET-DELINQ-VALUE      THRU 7000-EXIT.           
           MOVE C8-DELINQ-VALUE              TO WS-DATABASE.            
                                                                        
           IF CSR-DATABASE                                              
              PERFORM 2000-PROCESS-OUTPUT     THRU 2000-EXIT            
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02420000
      * 2000-PROCESS-OUTPUT.                                           *02430000
      ******************************************************************02440000
       2000-PROCESS-OUTPUT.                                             
                                                                        
           INITIALIZE                           GTT-RETURN-FIELDS.      
                                                                        
           EVALUATE TRUE                                                
              WHEN BTU-INSERT                                           
                   PERFORM 8100-INSRT-BTU-FACTOR      THRU 8100-EXIT    
              WHEN BTU-UPDATE                                           
                   PERFORM 8200-UPDT-BTU-FACTOR       THRU 8200-EXIT    
              WHEN BTU-DELETE                                           
                   PERFORM 8300-DEL-BTU-FACTOR        THRU 8300-EXIT    
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE.                                                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      * 7000-GET-DELINQ-VALUE.                                         *02640000
      ******************************************************************02650000
      *                                                                 02660000
       7000-GET-DELINQ-VALUE.                                           
      *                                                                 02680000
           EXEC SQL                                                     
              SELECT C8.DELINQ_VALUE                                    
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY  C8 WITH(READUNCOMMITTED)                  
               WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                      
                 AND C8.COMPANY_NO = :C8-COMPANY-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02690000
MFA-TR*       SELECT C8.DELINQ_VALUE                                    02700000
MFA-TR*         INTO :C8-DELINQ-VALUE                                   02710000
MFA-TR*         FROM CSS_DELINQUENCY  C8                                02720000
MFA-TR*        WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                      02730000
MFA-TR*          AND C8.COMPANY_NO = :C8-COMPANY-NO                     02740000
MFA-TR*         WITH UR                                                 02750000
MFA-TR*      QUERYNO 7000                                               02760000
MFA-TR*    END-EXEC.                                                    02770000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 02780000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                 02800000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_DELINQUENCY'         TO TABLE-1                 
              MOVE 'DELINQ_CD'               TO TABLE-ELEMENT-1         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE C8-DELINQ-CD              TO HOSTVAR-ELEMENT-1       
              MOVE C8-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 02940000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02970000
      ******************************************************************02980000
      * 8100-INSRT-BTU-FACTOR.                                         *02990000
      ******************************************************************03000000
      *                                                                 03010000
       8100-INSRT-BTU-FACTOR.                                           
      *                                                                 03030000
            EXEC SQL                                                    
               INSERT INTO CSS_BTU_FACTOR                               
                  (                                                     
                    BTU_DT                                              
                   ,MCF_SALLEY_BOILOFF                                  
                   ,MCF_TRANSCO                                         
                   ,BTU_TRANSCO                                         
                   ,MCF_SALLEY_VAPOR                                    
                   ,BTU_SALLEY_BOILOFF                                  
                   ,BTU_SALLEY_VAPOR                                    
                   ,MMBTU_TOTAL                                         
                   ,MCF_TOTAL                                           
                   ,BTU_SNG                                             
                   ,COMPANY_NO                                          
                   ,LAST_UPDATE_USERID                                  
                   ,LAST_UPDATE_TS                                      
                  )                                                     
               VALUES                                                   
                  (                                                     
                    IIF(TRY_CONVERT(DATE, :TF-BTU-DT
              ) IS NULL OR (PATINDEX('%.%', :TF-BTU-DT) <> 0) OR (LEN(
                                                             :TF-BTU-DT
              ) <> 10), CIS.CHAR2DATE(:TF-BTU-DT), CONVERT(DATE, 
                                                             :TF-BTU-DT
              ) )                                          
                   ,:TF-MCF-SALLEY-BOILOFF                              
                   ,:TF-MCF-TRANSCO                                     
                   ,:TF-BTU-TRANSCO                                     
                   ,:TF-MCF-SALLEY-VAPOR                                
                   ,:TF-BTU-SALLEY-BOILOFF                              
                   ,:TF-BTU-SALLEY-VAPOR                                
                   ,:TF-MMBTU-TOTAL                                     
                   ,:TF-MCF-TOTAL                                       
                   ,:TF-BTU-SNG                                         
                   ,:TF-COMPANY-NO                                      
                   ,:TF-LAST-UPDATE-USERID                              
                   ,CIS.CURRENT$TIMESTAMP()                                   
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                    03040000
MFA-TR*        INSERT INTO CSS_BTU_FACTOR                               03050000
MFA-TR*           (                                                     03060000
MFA-TR*             BTU_DT                                              03070000
MFA-TR*            ,MCF_SALLEY_BOILOFF                                  03080000
MFA-TR*            ,MCF_TRANSCO                                         03100000
MFA-TR*            ,BTU_TRANSCO                                         03120000
MFA-TR*            ,MCF_SALLEY_VAPOR                                    03130000
MFA-TR*            ,BTU_SALLEY_BOILOFF                                  03140000
MFA-TR*            ,BTU_SALLEY_VAPOR                                    03150000
MFA-TR*            ,MMBTU_TOTAL                                         03190000
MFA-TR*            ,MCF_TOTAL                                           03200000
MFA-TR*            ,BTU_SNG                                             03210000
MFA-TR*            ,COMPANY_NO                                          03220000
MFA-TR*            ,LAST_UPDATE_USERID                                  03230000
MFA-TR*            ,LAST_UPDATE_TS                                      03240000
MFA-TR*           )                                                     03250000
MFA-TR*        VALUES                                                   03260000
MFA-TR*           (                                                     03270000
MFA-TR*             :TF-BTU-DT                                          03280000
MFA-TR*            ,:TF-MCF-SALLEY-BOILOFF                              03290000
MFA-TR*            ,:TF-MCF-TRANSCO                                     03310000
MFA-TR*            ,:TF-BTU-TRANSCO                                     03330000
MFA-TR*            ,:TF-MCF-SALLEY-VAPOR                                03340000
MFA-TR*            ,:TF-BTU-SALLEY-BOILOFF                              03350000
MFA-TR*            ,:TF-BTU-SALLEY-VAPOR                                03360000
MFA-TR*            ,:TF-MMBTU-TOTAL                                     03400000
MFA-TR*            ,:TF-MCF-TOTAL                                       03410000
MFA-TR*            ,:TF-BTU-SNG                                         03420000
MFA-TR*            ,:TF-COMPANY-NO                                      03430000
MFA-TR*            ,:TF-LAST-UPDATE-USERID                              03440005
MFA-TR*            ,CURRENT TIMESTAMP                                   03450000
MFA-TR*           )                                                     03460000
MFA-TR*     END-EXEC                                                    03470000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 03480000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                 03500000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                         TO  CTR-ROWS               
           ELSE                                                         
              MOVE PROGRAM-NAME              TO  ABEND-PROGRAM          
              MOVE '8100'                    TO  ACTIVE-PARAGRAPH       
              MOVE SQLCODE                   TO  ABEND-SQLCODE          
              MOVE 'INSERT'                  TO  ABEND-FUNCTION         
              MOVE SPACES                    TO  ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BTU_FACTOR'          TO  TABLE-1                
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 03630000
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03660000
      ******************************************************************03670000
      * 8200-UPDT-BTU-FACTOR.                                          *03680000
      ******************************************************************03690000
      *                                                                 03700000
       8200-UPDT-BTU-FACTOR.                                            
      *                                                                 03720000
           EXEC SQL                                                     
              UPDATE TF                                   
                 SET TF.MCF_SALLEY_BOILOFF    = :TF-MCF-SALLEY-BOILOFF  
                    ,TF.MCF_TRANSCO           = :TF-MCF-TRANSCO         
                    ,TF.BTU_TRANSCO           = :TF-BTU-TRANSCO         
                    ,TF.MCF_SALLEY_VAPOR      = :TF-MCF-SALLEY-VAPOR    
                    ,TF.BTU_SALLEY_BOILOFF    = :TF-BTU-SALLEY-BOILOFF  
                    ,TF.BTU_SALLEY_VAPOR      = :TF-BTU-SALLEY-VAPOR    
                    ,TF.MMBTU_TOTAL           = :TF-MMBTU-TOTAL         
                    ,TF.MCF_TOTAL             = :TF-MCF-TOTAL           
                    ,TF.BTU_SNG               = :TF-BTU-SNG             
                    ,LAST_UPDATE_USERID       = :TF-LAST-UPDATE-USERID  
                    ,LAST_UPDATE_TS           = CIS.CURRENT$TIMESTAMP()       
              FROM CSS_BTU_FACTOR TF
               WHERE TF.COMPANY_NO         = :TF-COMPANY-NO             
                 AND TF.BTU_DT             = IIF(TRY_CONVERT(DATE, 
                                                             :TF-BTU-DT
              ) IS NULL OR (PATINDEX('%.%', :TF-BTU-DT) <> 0) OR (LEN(
                                                             :TF-BTU-DT
              ) <> 10), CIS.CHAR2DATE(:TF-BTU-DT), CONVERT(DATE, 
                                                             :TF-BTU-DT
              ) )                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     03730000
MFA-TR*       UPDATE CSS_BTU_FACTOR  TF                                 03740000
MFA-TR*          SET TF.MCF_SALLEY_BOILOFF    = :TF-MCF-SALLEY-BOILOFF  03750000
MFA-TR*             ,TF.MCF_TRANSCO           = :TF-MCF-TRANSCO         03770000
MFA-TR*             ,TF.BTU_TRANSCO           = :TF-BTU-TRANSCO         03790000
MFA-TR*             ,TF.MCF_SALLEY_VAPOR      = :TF-MCF-SALLEY-VAPOR    03800000
MFA-TR*             ,TF.BTU_SALLEY_BOILOFF    = :TF-BTU-SALLEY-BOILOFF  03810000
MFA-TR*             ,TF.BTU_SALLEY_VAPOR      = :TF-BTU-SALLEY-VAPOR    03820000
MFA-TR*             ,TF.MMBTU_TOTAL           = :TF-MMBTU-TOTAL         03860000
MFA-TR*             ,TF.MCF_TOTAL             = :TF-MCF-TOTAL           03870000
MFA-TR*             ,TF.BTU_SNG               = :TF-BTU-SNG             03880000
MFA-TR*             ,LAST_UPDATE_USERID       = :TF-LAST-UPDATE-USERID  03890005
MFA-TR*             ,LAST_UPDATE_TS           = CURRENT TIMESTAMP       03900005
MFA-TR*        WHERE TF.COMPANY_NO         = :TF-COMPANY-NO             03910000
MFA-TR*          AND TF.BTU_DT             = :TF-BTU-DT                 03920000
MFA-TR*    END-EXEC                                                     03930000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
      *                                                                 03950000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                 03970000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                         TO  CTR-ROWS               
           ELSE                                                         
              MOVE PROGRAM-NAME              TO  ABEND-PROGRAM          
              MOVE '8200'                    TO  ACTIVE-PARAGRAPH       
              MOVE SQLCODE                   TO  ABEND-SQLCODE          
              MOVE 'UPDATE'                  TO  ABEND-FUNCTION         
              MOVE SPACES                    TO  ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BTU_FACTOR'          TO  TABLE-1                
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-1          
              MOVE 'BTU_DT'                 TO TABLE-ELEMENT-2          
              MOVE TF-COMPANY-NO            TO HOSTVAR-ELEMENT-1        
              MOVE TF-BTU-DT                TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 04140000
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04170000
      ******************************************************************04180000
      * 8300-DEL-BTU-FACTOR.                                           *04190000
      ******************************************************************04200000
      *                                                                 04210000
       8300-DEL-BTU-FACTOR.                                             
      *                                                                 04230000
           EXEC SQL                                                     
              DELETE FROM TF                              
              FROM CSS_BTU_FACTOR TF
               WHERE TF.COMPANY_NO         = :TF-COMPANY-NO             
                 AND TF.BTU_DT             = IIF(TRY_CONVERT(DATE, 
                                                             :TF-BTU-DT
              ) IS NULL OR (PATINDEX('%.%', :TF-BTU-DT) <> 0) OR (LEN(
                                                             :TF-BTU-DT
              ) <> 10), CIS.CHAR2DATE(:TF-BTU-DT), CONVERT(DATE, 
                                                             :TF-BTU-DT
              ) )                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     04240000
MFA-TR*       DELETE FROM CSS_BTU_FACTOR   TF                           04250000
MFA-TR*        WHERE TF.COMPANY_NO         = :TF-COMPANY-NO             04260000
MFA-TR*          AND TF.BTU_DT             = :TF-BTU-DT                 04270000
MFA-TR*    END-EXEC.                                                    04280000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 04290000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                 04310000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                         TO  CTR-ROWS               
           ELSE                                                         
              MOVE PROGRAM-NAME              TO  ABEND-PROGRAM          
              MOVE '8300'                    TO  ACTIVE-PARAGRAPH       
              MOVE SQLCODE                   TO  ABEND-SQLCODE          
              MOVE 'DELETE'                  TO  ABEND-FUNCTION         
              MOVE SPACES                    TO  ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BTU_FACTOR'          TO  TABLE-1                
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-1          
              MOVE 'BTU_DT'                 TO TABLE-ELEMENT-2          
              MOVE TF-COMPANY-NO            TO HOSTVAR-ELEMENT-1        
              MOVE TF-BTU-DT                TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 04480000
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04510000
      ******************************************************************04520000
      * INCLUDE CPD0023C FOR 9700- ERROR HANDLING                      *04530000
      ******************************************************************04540000
      *                                                                 04550000
           EXEC SQL                                                     04560000
              INCLUDE CPD0023C                                          04570000
           END-EXEC.                                                    04580000
      *                                                                 04590000
      ******************************************************************04600000
      * 9900-SQL-ERROR-ROUTINE.                                        *04610000
      ******************************************************************04620000
      *                                                                 04630000
           EXEC SQL                                                     04640000
              INCLUDE CPDSP300                                          04650000
           END-EXEC.                                                    04660000
      *                                                                 04670000
      ******************************************************************04680000
      *    END PROGRAM COPYLIB                                         *04690000
      ******************************************************************04700000
      *                                                                 04710000
           EXEC SQL                                                     04720000
             INCLUDE CPD00321                                           04730000
           END-EXEC.                                                    04740000
      *                                                                 04750000
      **********************End Of Program *****************************04760000
