       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04901.                                         
COB303 DATE-WRITTEN.  FEB 17, 2016.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                        SCANA ENERGY                            *        
      ******************************************************************        
      *                 P-R-O-G-R-A-M  S-U-M-M-A-R-Y                   *        
      *                                                                *        
      *  UPDATE ROUTINE CALLED FROM WEB 'TRANSFER SERVICE' PROCESS TO  *        
      *  TRANSFER RATE INFORMATION FROM OLD TO NEW CIS ACCOUNT.        *        
      *                                                                *        
      *  INPUT PARAMETERS                                              *        
      *  ----------------                                              *        
      *             I_XFR_FROM_ACCT_NO         CHAR(13)                *        
      *             I_XFR_TO_ACCT_NO           CHAR(13)                *        
      *             I_SVC_START_DT             CHAR(10)                *        
      *             I_XFR_PROC_EXCP_CD         CHAR(02)                *        
      *             I_USER_ID                  CHAR(07)                *        
      *                                                                *        
      *  OUTPUT PARAMETERS                                             *        
      *  -----------------                                             *        
      *             RETURN_CODE                INTEGER                 *        
      *             APPL_STATUS_CODE           INTEGER                 *        
      *                                                                *        
      *  APPL RETURN CODE                                              *        
      *  -----------------                                             *        
      *  1000 - INPUT VALUE/S INVALID.                                 *        
      ******************************************************************        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *     DATE       INITIALS   COMMENTS                             *        
      *  -----------   --------   ------------------------------       *        
      *  17-FEB-2016   SS45239    INITIAL IMPLEMENTATION.              *        
      *                P00836     MANAGE SERVICE - WEB MOD             *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999   MAIN CONTROL PATH AND INITIALIZATION            *        
      *  1000 - 1999   INPUT PROCESSING CONTROL PATH                   *        
      *  2000 - 2999   OUTPUT PROCESSING CONTROL PATH                  *        
      *  3000 - 4999   NOT USED                                        *        
      *  5000 - 5999   COMMON PROGRAM MODULES                          *        
      *  6000 - 6999   COMMON SYSTEM MODULES                           *        
      *  7000 - 7999   INPUT MODULES                                   *        
      *  8000 - 8999   OUTPUT MODULES                                  *        
      *  9000 - 9999   TERMINATION,ABEND, MESSAGING MODULES            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04901'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                         PIC X(40) VALUE             
                 'WORKING STORAGE FOR CSR04901 STARTS HERE'.            
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES.                                               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCOUNT        AT                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_UTIL_ENVRNMT   UT                                       *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCT_RTPK_AGR  DF                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCTRG                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_FIXED_FCTR     FF                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBFXDFCT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCT_MKT_TIER  DD                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMKTIER                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MNT_TRANS_HIST MH                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MT_TRN_HST_DET MI                                       *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBMNHDT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_JOB_PARM       G6                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BILL_WINDOW    BN                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBILWDW                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SPCL_FCTR      SF                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSPLFTR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CRM_MKT_TIER       IG                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMKTTER                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CRM_TIER_ACCT_TYPE TT                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBTIACTP                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CODE_VALUE     UV                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCDVALU                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCT_ATTRIBUTE YP                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACTATT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING.                        *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS.                                                 *        
      ******************************************************************        
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04901'. 
           05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
           05  WS-GTT-NAME                  PIC X(19) VALUE SPACES.     
           05  MCSCB328                     PIC X(08) VALUE 'MCSCB328'. 
           05  MCSCB326                     PIC X(08) VALUE 'MCSCB326'. 
           05  RETURN-CODE-328              PIC S9(04) COMP VALUE 0.    
           05  RETURN-CODE-326              PIC S9(04) COMP VALUE 0.    
                                                                        
       01  SWITCHES.                                                    
           05  CSR04901-DONE-SW             PIC X(01) VALUE 'N'.        
               88 NOT-ALL-DONE                        VALUE 'N'.        
               88 ALL-DONE                            VALUE 'Y'.        
           05  SEND-DONE-SW                 PIC X(01) VALUE 'Y'.        
               88 SEND-DONE-ERROR                     VALUE 'N'.        
               88 SEND-DONE-OK                        VALUE 'Y'.        
           05  WS-NO-MORE-ROWS              PIC X(01) VALUE 'N'.        
               88 NO-MORE-ROWS                        VALUE 'Y'.        
           05  WS-PNDG-OPTN-FL              PIC X(01) VALUE 'N'.        
               88 PNDG-OPTN-EXISTS                    VALUE 'Y'.        
                                                                        
       01  NULL-INDICATORS.                                             
           05  WS-NULL-IND-01               PIC S9(04) COMP.            
           05  WS-NULL-IND-02               PIC S9(04) COMP.            
           05  WS-NULL-IND-03               PIC S9(04) COMP.            
           05  WS-NULL-IND-04               PIC S9(04) COMP.            
           05  WS-NULL-IND-05               PIC S9(04) COMP.            
           05  WS-NULL-IND-06               PIC S9(04) COMP.            
           05  WS-NULL-IND-07               PIC S9(04) COMP.            
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN               PIC S9(04) COMP.            
               49 GTT-ROW-CHAR              PIC X(1024).                
           05  GTT-SQLCODE                  PIC S9(09) COMP.            
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                   PIC S9(09) COMP VALUE 1.    
           05  CTR-ROWS                     PIC S9(09) COMP VALUE 0.    
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM              PIC S9(09) COMP.            
           05  WRKLEN1                      PIC S9(09) COMP.            
           05  WRKLEN2                      PIC S9(09) COMP.            
           05  WRK-DONE-STATUS              PIC S9(09) COMP.            
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                       PIC X(01) VALUE 'Y'.        
           05  WS-NO                        PIC X(01) VALUE 'N'.        
           05  WS-ZERO                      PIC S9(4) COMP VALUE 0.     
           05  GTT-NAME                     PIC X(26) VALUE             
                                                'SESSION.CSR04901_R1'.  
       01  WS-MISC.                                                     
           05  WS-YES-NULL                  PIC S9(4) VALUE -1.         
           05  WS-XFR-FROM-ACCT-NO          PIC X(13) VALUE SPACES.     
           05  WS-XFR-FROM-ACCT-NUM REDEFINES WS-XFR-FROM-ACCT-NO       
                                            PIC 9(13).                  
           05  WS-XFR-TO-ACCT-NO            PIC X(13) VALUE SPACES.     
           05  WS-XFR-TO-ACCT-NUM   REDEFINES WS-XFR-TO-ACCT-NO         
                                            PIC 9(13).                  
           05  WS-XFR2ACT-NXT-BMTH          PIC X(06) VALUE SPACES.     
           05  WS-NXT-BLMTH         REDEFINES WS-XFR2ACT-NXT-BMTH       
                                            PIC 9(6).                   
           05  WS-REVMTH-DT                 PIC X(10) VALUE SPACES.     
           05  WS-REVMTH-PLUS-DT            PIC X(10) VALUE SPACES.     
           05  WS-REV-MONTH-NUM             PIC 9(06) VALUE ZEROES.     
           05  WS-DURATION-REM-NUM          PIC S9(9) COMP VALUE 0.     
           05  WS-FORMATTED-DATE.                                       
               10  WS-YEAR                  PIC X(04).                  
               10  FILLER                   PIC X(01) VALUE '-'.        
               10  WS-MONTH                 PIC X(02).                  
               10  FILLER                   PIC X(01) VALUE '-'.        
               10  WS-DAY                   PIC X(02).                  
           05  WS-C-OPTN-FCTR-EDT           PIC X(10) VALUE SPACES.     
           05  WS-P-OPTN-FCTR-SDT           PIC X(10) VALUE SPACES.     
           05  WS-NEW-EFF-REV-MTH           PIC 9(06) VALUE ZEROS.      
           05  WS-CURRENT-DATE              PIC X(10) VALUE SPACES.     
           05  WS-CURRENT-TIMESTAMP         PIC X(26) VALUE SPACES.     
           05  WS-COMMON-RUN-DATE           PIC X(10) VALUE SPACES.     
           05  WS-COMMON-REV-MNTH           PIC X(06) VALUE SPACES.     
           05  WS-COMMON-RMTH-NUM   REDEFINES WS-COMMON-REV-MNTH        
                                            PIC 9(6).                   
           05  WS-THERM-PRICE               PIC 9(5)V9(6) VALUE ZEROS.  
           05  WS-THERM-PRICE-A     REDEFINES WS-THERM-PRICE            
                                            PIC X(11).                  
           05  WS-OLD-RTPKG-SEQ-NO          PIC S9(4) USAGE COMP        
                                                      VALUE 0.          
           05  WS-FACTOR-TEXT               PIC 9(9).9(6).              
           05  WS-FACTOR-DISPLAY            PIC -Z(09).9(06).           
           05  WS-DURATION-NO-DISPLAY       PIC Z(04).                  
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE                PIC S9(09) COMP VALUE 0.    
           05  S-APPL-STATUS-CODE           PIC S9(09) COMP VALUE 0.    
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME                   PIC X(18)  VALUE SPACES.    
            10  S-SQLCODE                   PIC S9(9)  COMP VALUE 0.    
            10  S-SQLSTATE                  PIC X(5)   VALUE ' '.       
            10  S-TABLE-NAME                PIC X(18)  VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L      PIC S9(4)  USAGE COMP.      
                49  S-HOST-VARIABLES-V      PIC X(255).                 
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L       PIC S9(4)  USAGE COMP.      
                49  S-SQL-STATEMENT-V       PIC X(255).                 
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L     PIC S9(4)  USAGE COMP.      
                49  S-SQL-DESCRIPTION-V     PIC X(255).                 
                                                                        
      ******************************************************************        
      *    WORKING STORAGE COPYBOOK FOR MCSCB326                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWS00328                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORKING STORAGE COPYBOOK FOR MCSCB326                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWS00326                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CURSOR DECLARATIONS.                                          *        
      ******************************************************************        
      ***GET CURRENT/PENDING RATE PACKAGE AGREEMENTS FROM OLD ACCOUNT           
      ***PROCESS CURRENT RATE FIRST IN THE ORDER                                
           EXEC SQL                                                     
              DECLARE RTPKG_AGRMNTS CURSOR FOR                          
                 SELECT DF.ACCOUNT_NO                                   
                       ,DF.CODE_UTIL_TYPE                               
                       ,DF.IC_NO                                        
                       ,DF.RT_PKG_OPT_SEQ_NO                            
                       ,DF.TRANS_SEQ_ID                                 
                       ,DF.OFFER_CD                                     
                       ,DF.OPTION_CD                                    
                       ,DF.PROMO_CD                                     
                       ,DF.STATUS_CD                                    
                       ,DF.COMM_CHANNEL                                 
                       ,DF.CREATED_USERID                               
                       ,DF.LAST_UPDATE_USERID                           
                       ,DF.OPT_AGRMT_EFF_DT                             
                       ,REPLACE(CONVERT(CHAR(8), DF.OPT_AGRMT_EFF_TM
           , 108), ':', '.') OPT_AGRMT_EFF_TM                             
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), DF.CREATED_TS
           , 121), ' ', '-'), ':', '.') CREATED_TS                             
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           DF.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                       ,DF.COMPANY_NO                                   
                       ,DF.STATUS_EFF_REV_MTH                           
                       ,DF.AGREEMNT_SOURCE_CD                           
                       ,DF.ADJ_TIER_SEQ_NO                              
                       ,DF.OFFER_OPT_START_DT                           
                       ,DF.OFF_OPT_VRSN_NO                              
                       ,DF.STAT_ADJUSTABLE_CD                           
                       ,DF.PRCE_NEGOTIATED_CD                           
                       ,DF.STATUS_CHANGE_DT                             
                       ,DF.AUTO_REN_OPT_IN_FL                           
                   FROM CSS_UTIL_ENVRNMT  UT WITH(READUNCOMMITTED)              
                   JOIN CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)              
                     ON DF.ACCOUNT_NO        =  UT.ACCOUNT_NO           
                    AND DF.CODE_UTIL_TYPE    =  UT.CODE_UTIL_TYPE       
                    AND DF.IC_NO             =  UT.IC_NO                
                    AND DF.RT_PKG_OPT_SEQ_NO =  UT.RT_PKG_OPT_SEQ_NO    
                  WHERE UT.ACCOUNT_NO        = :UT-ACCOUNT-NO           
                                                                        
                  UNION ALL                                             
                                                                        
                 SELECT DF.ACCOUNT_NO                                   
                       ,DF.CODE_UTIL_TYPE                               
                       ,DF.IC_NO                                        
                       ,DF.RT_PKG_OPT_SEQ_NO                            
                       ,DF.TRANS_SEQ_ID                                 
                       ,DF.OFFER_CD                                     
                       ,DF.OPTION_CD                                    
                       ,DF.PROMO_CD                                     
                       ,DF.STATUS_CD                                    
                       ,DF.COMM_CHANNEL                                 
                       ,DF.CREATED_USERID                               
                       ,DF.LAST_UPDATE_USERID                           
                       ,DF.OPT_AGRMT_EFF_DT                             
                       ,REPLACE(CONVERT(CHAR(8), DF.OPT_AGRMT_EFF_TM
           , 108), ':', '.') OPT_AGRMT_EFF_TM                             
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), DF.CREATED_TS
           , 121), ' ', '-'), ':', '.') CREATED_TS                             
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           DF.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                       ,DF.COMPANY_NO                                   
                       ,DF.STATUS_EFF_REV_MTH                           
                       ,DF.AGREEMNT_SOURCE_CD                           
                       ,DF.ADJ_TIER_SEQ_NO                              
                       ,DF.OFFER_OPT_START_DT                           
                       ,DF.OFF_OPT_VRSN_NO                              
                       ,DF.STAT_ADJUSTABLE_CD                           
                       ,DF.PRCE_NEGOTIATED_CD                           
                       ,DF.STATUS_CHANGE_DT                             
                       ,DF.AUTO_REN_OPT_IN_FL                           
                   FROM CSS_UTIL_ENVRNMT  UT WITH(READUNCOMMITTED)              
                   JOIN CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)              
                     ON DF.ACCOUNT_NO        =  UT.ACCOUNT_NO           
                    AND DF.CODE_UTIL_TYPE    =  UT.CODE_UTIL_TYPE       
                    AND DF.IC_NO             =  UT.IC_NO                
                  WHERE UT.ACCOUNT_NO        = :UT-ACCOUNT-NO           
                    AND DF.STATUS_CD         = 'P'                      
                                                                        
                  ORDER BY 4                                            
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE RTPKG_AGRMNTS CURSOR FOR                                  
MFA-TR*          SELECT DF.ACCOUNT_NO                                           
MFA-TR*                ,DF.CODE_UTIL_TYPE                                       
MFA-TR*                ,DF.IC_NO                                                
MFA-TR*                ,DF.RT_PKG_OPT_SEQ_NO                                    
MFA-TR*                ,DF.TRANS_SEQ_ID                                         
MFA-TR*                ,DF.OFFER_CD                                             
MFA-TR*                ,DF.OPTION_CD                                            
MFA-TR*                ,DF.PROMO_CD                                             
MFA-TR*                ,DF.STATUS_CD                                            
MFA-TR*                ,DF.COMM_CHANNEL                                         
MFA-TR*                ,DF.CREATED_USERID                                       
MFA-TR*                ,DF.LAST_UPDATE_USERID                                   
MFA-TR*                ,DF.OPT_AGRMT_EFF_DT                                     
MFA-TR*                ,DF.OPT_AGRMT_EFF_TM                                     
MFA-TR*                ,DF.CREATED_TS                                           
MFA-TR*                ,DF.LAST_UPDATE_TS                                       
MFA-TR*                ,DF.COMPANY_NO                                           
MFA-TR*                ,DF.STATUS_EFF_REV_MTH                                   
MFA-TR*                ,DF.AGREEMNT_SOURCE_CD                                   
MFA-TR*                ,DF.ADJ_TIER_SEQ_NO                                      
MFA-TR*                ,DF.OFFER_OPT_START_DT                                   
MFA-TR*                ,DF.OFF_OPT_VRSN_NO                                      
MFA-TR*                ,DF.STAT_ADJUSTABLE_CD                                   
MFA-TR*                ,DF.PRCE_NEGOTIATED_CD                                   
MFA-TR*                ,DF.STATUS_CHANGE_DT                                     
MFA-TR*                ,DF.AUTO_REN_OPT_IN_FL                                   
MFA-TR*            FROM CSS_UTIL_ENVRNMT  UT                                    
MFA-TR*            JOIN CSS_ACCT_RTPK_AGR DF                                    
MFA-TR*              ON DF.ACCOUNT_NO        =  UT.ACCOUNT_NO                   
MFA-TR*             AND DF.CODE_UTIL_TYPE    =  UT.CODE_UTIL_TYPE               
MFA-TR*             AND DF.IC_NO             =  UT.IC_NO                        
MFA-TR*             AND DF.RT_PKG_OPT_SEQ_NO =  UT.RT_PKG_OPT_SEQ_NO            
MFA-TR*           WHERE UT.ACCOUNT_NO        = :UT-ACCOUNT-NO                   
MFA-TR*                                                                         
MFA-TR*           UNION ALL                                                     
MFA-TR*                                                                         
MFA-TR*          SELECT DF.ACCOUNT_NO                                           
MFA-TR*                ,DF.CODE_UTIL_TYPE                                       
MFA-TR*                ,DF.IC_NO                                                
MFA-TR*                ,DF.RT_PKG_OPT_SEQ_NO                                    
MFA-TR*                ,DF.TRANS_SEQ_ID                                         
MFA-TR*                ,DF.OFFER_CD                                             
MFA-TR*                ,DF.OPTION_CD                                            
MFA-TR*                ,DF.PROMO_CD                                             
MFA-TR*                ,DF.STATUS_CD                                            
MFA-TR*                ,DF.COMM_CHANNEL                                         
MFA-TR*                ,DF.CREATED_USERID                                       
MFA-TR*                ,DF.LAST_UPDATE_USERID                                   
MFA-TR*                ,DF.OPT_AGRMT_EFF_DT                                     
MFA-TR*                ,DF.OPT_AGRMT_EFF_TM                                     
MFA-TR*                ,DF.CREATED_TS                                           
MFA-TR*                ,DF.LAST_UPDATE_TS                                       
MFA-TR*                ,DF.COMPANY_NO                                           
MFA-TR*                ,DF.STATUS_EFF_REV_MTH                                   
MFA-TR*                ,DF.AGREEMNT_SOURCE_CD                                   
MFA-TR*                ,DF.ADJ_TIER_SEQ_NO                                      
MFA-TR*                ,DF.OFFER_OPT_START_DT                                   
MFA-TR*                ,DF.OFF_OPT_VRSN_NO                                      
MFA-TR*                ,DF.STAT_ADJUSTABLE_CD                                   
MFA-TR*                ,DF.PRCE_NEGOTIATED_CD                                   
MFA-TR*                ,DF.STATUS_CHANGE_DT                                     
MFA-TR*                ,DF.AUTO_REN_OPT_IN_FL                                   
MFA-TR*            FROM CSS_UTIL_ENVRNMT  UT                                    
MFA-TR*            JOIN CSS_ACCT_RTPK_AGR DF                                    
MFA-TR*              ON DF.ACCOUNT_NO        =  UT.ACCOUNT_NO                   
MFA-TR*             AND DF.CODE_UTIL_TYPE    =  UT.CODE_UTIL_TYPE               
MFA-TR*             AND DF.IC_NO             =  UT.IC_NO                        
MFA-TR*           WHERE UT.ACCOUNT_NO        = :UT-ACCOUNT-NO                   
MFA-TR*             AND DF.STATUS_CD         = 'P'                              
MFA-TR*                                                                         
MFA-TR*           ORDER BY 4                                                    
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7400                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ***PROCESS FIXED FACTORS ASSOCIATED WITH CURRENT OR PENDING RATE          
      ***PACKAGE AGREEMENTS.                                                    
           EXEC SQL                                                     
              DECLARE OPTN_FCTRS CURSOR FOR                             
                 SELECT FF.FACTOR_ID                                    
                       ,FF.EFF_DATE_FROM                                
                       ,FF.CMPNT_ID_CD                                  
                       ,FF.CODE_SEASON                                  
                       ,FF.INSTR_USE_TYPE_CD                            
                       ,FF.CODE_TIME_PERIOD                             
                       ,FF.EFF_DATE_TO                                  
                       ,FF.FIXED_FCTR_TYP_CD                            
                       ,FF.FACTOR                                       
                       ,FF.FAC_CHRG_BASE_AM                             
                       ,FF.DURATION_REMAIN_NO                           
                       ,FF.BLOCK_NO                                     
                       ,SF.FACTOR_TEXT                                  
                       ,SF.RT_ATTR_INCTV_TYPE                           
                       ,SF.DURATION_TYPE_CD                             
                   FROM CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                 
                       ,CSS_SPCL_FCTR  SF WITH(READUNCOMMITTED)                 
                  WHERE FF.ACCOUNT_NO        = :FF-ACCOUNT-NO           
                    AND FF.CODE_UTIL_TYPE    = :FF-CODE-UTIL-TYPE       
                    AND FF.IC_NO             = :FF-IC-NO                
                    AND FF.RT_PKG_OPT_SEQ_NO = :WS-OLD-RTPKG-SEQ-NO     
                    AND SF.FACTOR_ID         =  FF.FACTOR_ID            
                  ORDER BY FF.FIXED_FCTR_SEQ_NO                         
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE OPTN_FCTRS CURSOR FOR                                     
MFA-TR*          SELECT FF.FACTOR_ID                                            
MFA-TR*                ,FF.EFF_DATE_FROM                                        
MFA-TR*                ,FF.CMPNT_ID_CD                                          
MFA-TR*                ,FF.CODE_SEASON                                          
MFA-TR*                ,FF.INSTR_USE_TYPE_CD                                    
MFA-TR*                ,FF.CODE_TIME_PERIOD                                     
MFA-TR*                ,FF.EFF_DATE_TO                                          
MFA-TR*                ,FF.FIXED_FCTR_TYP_CD                                    
MFA-TR*                ,FF.FACTOR                                               
MFA-TR*                ,FF.FAC_CHRG_BASE_AM                                     
MFA-TR*                ,FF.DURATION_REMAIN_NO                                   
MFA-TR*                ,FF.BLOCK_NO                                             
MFA-TR*                ,SF.FACTOR_TEXT                                          
MFA-TR*                ,SF.RT_ATTR_INCTV_TYPE                                   
MFA-TR*                ,SF.DURATION_TYPE_CD                                     
MFA-TR*            FROM CSS_FIXED_FCTR FF                                       
MFA-TR*                ,CSS_SPCL_FCTR  SF                                       
MFA-TR*           WHERE FF.ACCOUNT_NO        = :FF-ACCOUNT-NO                   
MFA-TR*             AND FF.CODE_UTIL_TYPE    = :FF-CODE-UTIL-TYPE               
MFA-TR*             AND FF.IC_NO             = :FF-IC-NO                        
MFA-TR*             AND FF.RT_PKG_OPT_SEQ_NO = :WS-OLD-RTPKG-SEQ-NO             
MFA-TR*             AND SF.FACTOR_ID         =  FF.FACTOR_ID                    
MFA-TR*           ORDER BY FF.FIXED_FCTR_SEQ_NO                                 
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ***PROCESS ALL OTHER FIXED FACTORS NOT ASSOCIATED WITH CURRENT OR         
      ***PENDING RATE PACKAGE AGREEMENTS.                                       
      ***CSS_JOB_PARM HAS EXCLUSION LIST FOR FACTORS.                           
           EXEC SQL                                                     
              DECLARE OTHER_FCTRS CURSOR FOR                            
                 SELECT FF.FACTOR_ID                                    
                       ,FF.EFF_DATE_FROM                                
                       ,FF.CMPNT_ID_CD                                  
                       ,FF.CODE_SEASON                                  
                       ,FF.INSTR_USE_TYPE_CD                            
                       ,FF.CODE_TIME_PERIOD                             
                       ,FF.EFF_DATE_TO                                  
                       ,FF.FIXED_FCTR_TYP_CD                            
                       ,FF.FACTOR                                       
                       ,FF.FAC_CHRG_BASE_AM                             
                       ,FF.DURATION_REMAIN_NO                           
                       ,FF.BLOCK_NO                                     
                       ,SF.FACTOR_TEXT                                  
                   FROM CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                 
                       ,CSS_SPCL_FCTR  SF WITH(READUNCOMMITTED)                 
                  WHERE FF.ACCOUNT_NO        = :FF-ACCOUNT-NO           
                    AND FF.CODE_UTIL_TYPE    = :FF-CODE-UTIL-TYPE       
                    AND FF.IC_NO             = :FF-IC-NO                
                    AND FF.RT_PKG_OPT_SEQ_NO =  0                       
                    AND FF.EFF_DATE_TO      >=  
           CAST(SYSDATETIMEOFFSET() AS DATE)            
                    AND SF.FACTOR_ID         =  FF.FACTOR_ID            
                    AND SF.SPCL_GROUP_CD NOT IN ('MT','RC')             
                    AND SF.FACTOR_ID     NOT IN                         
                             (SELECT LTRIM(RTRIM(G6.PARM_DATA))                 
                                FROM CSS_JOB_PARM G6
                           WITH(READUNCOMMITTED)                    
                               WHERE G6.PROGRAM_NAME = :PROGRAM-NAME    
                                 AND G6.COMPANY_NO   = '01'             
                                 AND G6.CMND_CODE    = 'PARM'           
                                 AND G6.STATUS       = 'A')             
                  ORDER BY FF.FIXED_FCTR_SEQ_NO                         
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE OTHER_FCTRS CURSOR FOR                                    
MFA-TR*          SELECT FF.FACTOR_ID                                            
MFA-TR*                ,FF.EFF_DATE_FROM                                        
MFA-TR*                ,FF.CMPNT_ID_CD                                          
MFA-TR*                ,FF.CODE_SEASON                                          
MFA-TR*                ,FF.INSTR_USE_TYPE_CD                                    
MFA-TR*                ,FF.CODE_TIME_PERIOD                                     
MFA-TR*                ,FF.EFF_DATE_TO                                          
MFA-TR*                ,FF.FIXED_FCTR_TYP_CD                                    
MFA-TR*                ,FF.FACTOR                                               
MFA-TR*                ,FF.FAC_CHRG_BASE_AM                                     
MFA-TR*                ,FF.DURATION_REMAIN_NO                                   
MFA-TR*                ,FF.BLOCK_NO                                             
MFA-TR*                ,SF.FACTOR_TEXT                                          
MFA-TR*            FROM CSS_FIXED_FCTR FF                                       
MFA-TR*                ,CSS_SPCL_FCTR  SF                                       
MFA-TR*           WHERE FF.ACCOUNT_NO        = :FF-ACCOUNT-NO                   
MFA-TR*             AND FF.CODE_UTIL_TYPE    = :FF-CODE-UTIL-TYPE               
MFA-TR*             AND FF.IC_NO             = :FF-IC-NO                        
MFA-TR*             AND FF.RT_PKG_OPT_SEQ_NO =  0                               
MFA-TR*             AND FF.EFF_DATE_TO      >=  CURRENT DATE                    
MFA-TR*             AND SF.FACTOR_ID         =  FF.FACTOR_ID                    
MFA-TR*             AND SF.SPCL_GROUP_CD NOT IN ('MT','RC')                     
MFA-TR*             AND SF.FACTOR_ID     NOT IN                                 
MFA-TR*                      (SELECT TRIM(G6.PARM_DATA)                         
MFA-TR*                         FROM CSS_JOB_PARM G6                            
MFA-TR*                        WHERE G6.PROGRAM_NAME = :PROGRAM-NAME            
MFA-TR*                          AND G6.COMPANY_NO   = '01'                     
MFA-TR*                          AND G6.CMND_CODE    = 'PARM'                   
MFA-TR*                          AND G6.STATUS       = 'A')                     
MFA-TR*           ORDER BY FF.FIXED_FCTR_SEQ_NO                                 
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7600                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ***PROCESS REQUIRED ACCOUNT ATTRIBUTES                                    
           EXEC SQL                                                     
              DECLARE ACCT_ATTRS CURSOR FOR                             
                 SELECT YP.ACCOUNT_NO                                   
                       ,YP.ATTRIBUTE_DESC                               
                       ,YP.ATTRIBUTE_VALUE_CD                           
                       ,YP.ATTRIBUTE_VALUE_DT                           
                       ,YP.ATTRIBUTE_VALUE_TX                           
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), YP.CREATED_TS
           , 121), ' ', '-'), ':', '.') CREATED_TS                             
                       ,YP.STATUS_CD                                    
                   FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)             
                  WHERE YP.ACCOUNT_NO     =  :YP-ACCOUNT-NO             
                    AND YP.ATTRIBUTE_DESC IN ( 'AGL DISCOUNT SR'        
                                              ,'AUTORENEW_REJE'         
                                              ,'OPTED IN' )             
                    AND YP.STATUS_CD      = 'A'                         
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ACCT_ATTRS CURSOR FOR                                     
MFA-TR*          SELECT YP.ACCOUNT_NO                                           
MFA-TR*                ,YP.ATTRIBUTE_DESC                                       
MFA-TR*                ,YP.ATTRIBUTE_VALUE_CD                                   
MFA-TR*                ,YP.ATTRIBUTE_VALUE_DT                                   
MFA-TR*                ,YP.ATTRIBUTE_VALUE_TX                                   
MFA-TR*                ,YP.CREATED_TS                                           
MFA-TR*                ,YP.STATUS_CD                                            
MFA-TR*            FROM CSS_ACCT_ATTRIBUTE YP                                   
MFA-TR*           WHERE YP.ACCOUNT_NO     =  :YP-ACCOUNT-NO                     
MFA-TR*             AND YP.ATTRIBUTE_DESC IN ( 'AGL DISCOUNT SR'                
MFA-TR*                                       ,'AUTORENEW_REJE'                 
MFA-TR*                                       ,'OPTED IN' )                     
MFA-TR*             AND YP.STATUS_CD      = 'A'                                 
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7700                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-XFR-FROM-ACCT-NO      PIC X(13).                        
       01  PARM-XFR-TO-ACCT-NO        PIC X(13).                        
       01  PARM-SVC-START-DT          PIC X(10).                        
       01  PARM-XFR-PROC-EXCP-CD      PIC X(02).                        
       01  PARM-USER-ID               PIC X(07).                        
                                                                        
       PROCEDURE DIVISION USING PARM-XFR-FROM-ACCT-NO                   
                                PARM-XFR-TO-ACCT-NO                     
                                PARM-SVC-START-DT                       
                                PARM-XFR-PROC-EXCP-CD                   
                                PARM-USER-ID.                           
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *      CONTROLS THE MAIN PATH OF THE PROGRAM.                    *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU  0100-EXIT.         
           PERFORM 1000-PROCESS-INPUT          THRU  1000-EXIT.         
           PERFORM 2000-PROCESS-OUTPUT         THRU  2000-EXIT.         
           PERFORM 9999-END-PROGRAM            THRU  9999-EXIT.         
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL                                                     
              WHENEVER SQLWARNING                                       
                  CONTINUE                                              
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              WHENEVER SQLERROR                                         
                  CONTINUE                                              
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              WHENEVER NOT FOUND                                        
                  CONTINUE                                              
           END-EXEC.                                                    
                                                                        
           PERFORM 0100A-DECLARE-GTT           THRU  0100A-EXIT.        
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT.                                             *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04901_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04901_R1
              (                                                       
                    RETURN_CODE       INT                           
                   ,APPL_STATUS_CODE  INT                           
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS       THRU 8000A-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE GTT-NAME              TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR                              
                                WITH ROWSET POSITIONING FOR             
               SELECT RETURN_CODE      AS RETURN_CODE                   
                     ,APPL_STATUS_CODE AS APPL_STATUS_CODE              
                 FROM #CSR04901_R1                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN                                     
MFA-TR*                         WITH ROWSET POSITIONING FOR                     
MFA-TR*        SELECT RETURN_CODE      AS RETURN_CODE                           
MFA-TR*              ,APPL_STATUS_CODE AS APPL_STATUS_CODE                      
MFA-TR*          FROM SESSION.CSR04901_R1                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-XFR-FROM-ACCT-NO       TO WS-XFR-FROM-ACCT-NO.     
           MOVE PARM-XFR-TO-ACCT-NO         TO WS-XFR-TO-ACCT-NO.       
                                                                        
           PERFORM 1050-VALIDATE-INPUT         THRU  1050-EXIT.         
           PERFORM 7075-GET-CURRENT-DATE       THRU  7075-EXIT.         
                                                                        
           IF PARM-XFR-PROC-EXCP-CD NOT EQUAL 'IV'                      
              PERFORM 1075-SET-PROCESS-PARMS   THRU  1075-EXIT          
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 1050-VALIDATE-INPUT.                                          *         
      *      BASIC INPUT VALIDATIONS.                                 *         
      *****************************************************************         
       1050-VALIDATE-INPUT.                                             
                                                                        
           IF WS-XFR-FROM-ACCT-NUM > WS-ZERO                            
              AND WS-XFR-TO-ACCT-NUM > WS-ZERO                          
                  AND PARM-SVC-START-DT > SPACES                        
              CONTINUE                                                  
           ELSE                                                         
      **** INPUT VALUES ARE INVALID                                             
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '1050'                   TO ACTIVE-PARAGRAPH         
              MOVE 'RECEIVE INPUT'          TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE SPACES                   TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              MOVE +100                     TO S-RETURN-CODE            
              MOVE +1000                    TO S-APPL-STATUS-CODE       
              PERFORM 8100-SEND-RESULT         THRU  8100-EXIT          
              PERFORM 9999-END-PROGRAM         THRU  9999-EXIT          
           END-IF.                                                      
                                                                        
       1050-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 1075-SET-PROCESS-PARMS.                                       *         
      *      GET THE REQUIRED SYSTEM DATES AND PARMETERS.             *         
      *****************************************************************         
       1075-SET-PROCESS-PARMS.                                          
                                                                        
           MOVE PARM-SVC-START-DT           TO BN-DATE-EXTRACT.         
           PERFORM 7000-GET-BILL-WINDOW        THRU  7000-EXIT.         
                                                                        
      *GET COMMON RUN DATE                                                      
           MOVE  10                         TO G6-SEQ-NO.               
           MOVE '01'                        TO G6-COMPANY-NO.           
           MOVE 'DATE'                      TO G6-CMND-CODE.            
           MOVE 'COMMON'                    TO G6-PROGRAM-NAME.         
           PERFORM 7025-SELECT-JOB-PARM        THRU  7025-EXIT.         
           MOVE G6-PARM-DATA(10:10)         TO WS-COMMON-RUN-DATE.      
                                                                        
      *GET COMMON REVENUE MONTH.                                                
           MOVE  20                         TO G6-SEQ-NO.               
           PERFORM 7025-SELECT-JOB-PARM        THRU  7025-EXIT.         
           MOVE G6-PARM-DATA(15:6)          TO WS-COMMON-REV-MNTH.      
                                                                        
           IF BN-REVENUE-MONTH EQUAL ZEROS                              
              MOVE WS-COMMON-REV-MNTH       TO WS-XFR2ACT-NXT-BMTH      
           ELSE                                                         
              MOVE BN-REVENUE-MONTH         TO WS-REV-MONTH-NUM         
              MOVE WS-REV-MONTH-NUM         TO WS-XFR2ACT-NXT-BMTH      
           END-IF.                                                      
                                                                        
       1075-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
      **** GET TRANSFER FROM ACCOUNT DETAILS                                    
           MOVE WS-XFR-FROM-ACCT-NUM        TO AT-ACCOUNT-NO.           
           PERFORM 7100-SELECT-ACCT-DETAILS    THRU  7100-EXIT.         
                                                                        
      **** WHEN INTRO VAR RATE IS EXPIRED ON THE OLD ACCOUNT SET NEW            
      **** ACCOUNT ON VARIABLE RATE                                             
           IF PARM-XFR-PROC-EXCP-CD EQUAL 'IV'                          
              PERFORM 6000-XFER-VAR-RATE       THRU  6000-EXIT          
           ELSE                                                         
      **** PROCESS RATE TRANSFER                                                
              MOVE WS-XFR-TO-ACCT-NUM       TO AT-ACCOUNT-NO            
              PERFORM 7125-GET-ACCOUNT-DETAILS THRU  7125-EXIT          
                                                                        
      **** CREATE UTILITY FOR NEW ACCOUNT                                       
              PERFORM 2100-CREATE-UTIL-ENVRNMT THRU  2100-EXIT          
                                                                        
      **** TRANSFER CURRENT/PENDING RATES W/ASSOCIATED FACTORS                  
              PERFORM 2150-PROCESS-RTPK-AGRMTS THRU  2150-EXIT          
                                                                        
      **** TRANSFER OTHER FACTORS, IF APPLICABLE                                
              PERFORM 2250-PROCESS-OTHER-FCTRS THRU  2250-EXIT          
                                                                        
      **** TRANSFER TIER RANKING DETAILS                                        
              PERFORM 2275-PROCESS-ACCT-MKT-TIER                        
                                               THRU  2275-EXIT          
      **** TRANSFER ACCOUNT ATTRIBUTES                                          
              PERFORM 2280-PROCESS-ACCT-ATTRIBUTES                      
                                               THRU  2280-EXIT          
           END-IF.                                                      
                                                                        
           PERFORM 2400-BUILD-RESULT-SET       THRU  2400-EXIT.         
                                                                        
           IF CTR-ROWS EQUAL ZERO                                       
              MOVE 100                      TO S-RETURN-CODE            
                                               S-APPL-STATUS-CODE       
              PERFORM 8100-SEND-RESULT         THRU  8100-EXIT          
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-CREATE-UTIL-ENVRNMT.                                      *        
      *      CREATE A NEW CSS_UTIL_ENVRNMT ROW.                        *        
      ******************************************************************        
       2100-CREATE-UTIL-ENVRNMT.                                        
                                                                        
           MOVE WS-XFR-TO-ACCT-NUM          TO UT-ACCOUNT-NO.           
           MOVE 'G'                         TO UT-CODE-UTIL-TYPE.       
           MOVE 1                           TO UT-IC-NO                 
                                               UT-RT-PKG-OPT-SEQ-NO.    
      *****RATE/REVENUE CLASS ARE ALREADY POPULATED IN HOST VARIABLES.          
           MOVE AT-PREMISE-NO               TO UT-PREMISE-NO.           
           MOVE 9001                        TO UT-READ-ROUTE.           
           MOVE '01'                        TO UT-READ-CYCLE.           
           MOVE AT-COMPANY-NO               TO UT-COMPANY-NO.           
           MOVE 'M01'                       TO UT-CODE-MTR-READ-FREQ.   
           MOVE 'N'                         TO UT-SPLY-SENSITIVE-IND.   
           MOVE SPACES                      TO UT-CODE-SERVICE-TYPE     
                                               UT-CODE-SIC-NO           
                                               UT-ENERGY-SOURCE         
                                               UT-SEASONAL-USE-CODE     
                                               UT-PRV-RATE-PLAN-NO      
                                               UT-CODE-STAT-TAX-XMT     
                                               UT-CODE-CITY-TAX-XMT     
                                               UT-CODE-OTHR-TAX-XMT     
                                               UT-CODE-XCIS-TAX-XMT     
                                               UT-STATE-TAX-EXMPT-NO    
                                               UT-ALTERNATE-FUEL-CD     
                                               UT-NAICS-CD              
                                               UT-CODE-ESTIMATE-OK      
                                               UT-AUTO-RATE-SW-FL.      
           MOVE ZEROES                      TO UT-CODE-CURTAIL-PRTY     
                                               UT-END-USER-PER-RATE     
                                               UT-TOU-RATE-IND          
                                               UT-GAS-PREV-BASE-USE     
                                               UT-GAS-BASE-USE          
                                               UT-ONERATE-ORIG-MO       
                                               UT-ONERATE-ANNIV-MO.     
           PERFORM 7050-GET-CURRENT-TIMESTAMP  THRU  7050-EXIT.         
           MOVE WS-CURRENT-TIMESTAMP        TO UT-LAST-UPDATE-TS.       
           MOVE WS-YES-NULL                 TO WS-NULL-IND-01           
                                               WS-NULL-IND-02           
                                               WS-NULL-IND-03           
                                               WS-NULL-IND-04.          
           PERFORM 8200-INSERT-UT              THRU  8200-EXIT.         
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2150-PROCESS-RTPK-AGRMTS.                                      *        
      *      PROCESS ALL ACCT RATE PKG AGRMNTS ON XFER FROM ACCOUNT    *        
      ******************************************************************        
       2150-PROCESS-RTPK-AGRMTS.                                        
                                                                        
           MOVE WS-XFR-FROM-ACCT-NUM        TO UT-ACCOUNT-NO.           
           MOVE 1                           TO FF-FIXED-FCTR-SEQ-NO.    
           PERFORM 7400-OPEN-RTPKG-AGRMNTS     THRU  7400-EXIT.         
           PERFORM 7425-FETCH-RTPKG-AGRMNTS    THRU  7425-EXIT.         
                                                                        
      *****AS PER SORT ORDER FOR CURSOR, CURRENT OPTION WILL ALWAYS BE          
      *****PROCESSED FIRST. 'R' - RENEWED STATUS IMPLIES THAT THERE IS          
      *****A PENDING OPTION IS INVARIABLY ASSOCIATED WITH THE ACCOUNT.          
           MOVE 'N'                         TO WS-PNDG-OPTN-FL.         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF DF-STATUS-CD EQUAL 'R'                                 
                 SET PNDG-OPTN-EXISTS       TO TRUE                     
                 PERFORM 2160-FORECAST-DATES   THRU  2160-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
              PERFORM 2175-CREATE-RTPK-AGRMNT  THRU  2175-EXIT          
              PERFORM 2200-PROCESS-OPTN-FCTRS  THRU  2200-EXIT          
              PERFORM 7425-FETCH-RTPKG-AGRMNTS THRU  7425-EXIT          
           END-PERFORM.                                                 
                                                                        
           PERFORM 7450-CLOSE-RTPKG-AGRMNTS    THRU  7450-EXIT.         
                                                                        
       2150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2160-FORECAST-DATES.                                           *        
      *      FORECAST VARIOUS DATES FOR ADJUSTMENTS                    *        
      ******************************************************************        
       2160-FORECAST-DATES.                                             
                                                                        
           PERFORM 7150-GET-MONTHS-REMAINING   THRU 7150-EXIT.          
                                                                        
           IF FF-DURATION-REMAIN-NO > 0                                 
              COMPUTE WS-DURATION-REM-NUM   EQUAL                       
                      FF-DURATION-REMAIN-NO - 1                         
              MOVE WS-XFR2ACT-NXT-BMTH(1:4) TO WS-REVMTH-DT(1:4)        
              MOVE WS-XFR2ACT-NXT-BMTH(5:2) TO WS-REVMTH-DT(6:2)        
              MOVE '01'                     TO WS-REVMTH-DT(9:2)        
              MOVE '-'                      TO WS-REVMTH-DT(5:1)        
                                               WS-REVMTH-DT(8:1)        
              EXEC SQL                                                  
                 SELECT
              DATEADD(MONTH, :WS-DURATION-REM-NUM, 
              IIF(TRY_CONVERT(DATE, :WS-REVMTH-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REVMTH-DT
              ) <> 0) OR (LEN(:WS-REVMTH-DT) <> 10), CIS.CHAR2DATE(
                                                          :WS-REVMTH-DT
              ), CONVERT(DATE, :WS-REVMTH-DT) ))
            INTO
              :WS-REVMTH-PLUS-DT                              
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*       EXEC SQL                                                          
MFA-TR*          VALUES ADD_MONTHS(:WS-REVMTH-DT,:WS-DURATION-REM-NUM)          
MFA-TR*            INTO :WS-REVMTH-PLUS-DT                                      
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE WS-REVMTH-PLUS-DT        TO WS-C-OPTN-FCTR-EDT       
              MOVE '28'                     TO WS-C-OPTN-FCTR-EDT(9:2)  
                                                                        
              MOVE WS-REVMTH-PLUS-DT(1:4)   TO WS-REVMTH-DT(1:4)        
              MOVE WS-REVMTH-PLUS-DT(6:2)   TO WS-REVMTH-DT(6:2)        
              MOVE '01'                     TO WS-REVMTH-DT(9:2)        
              MOVE '-'                      TO WS-REVMTH-DT(5:1)        
                                               WS-REVMTH-DT(8:1)        
              EXEC SQL                                                  
                 SELECT
              DATEADD(MONTH, 1, IIF(TRY_CONVERT(DATE, :WS-REVMTH-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REVMTH-DT
              ) <> 0) OR (LEN(:WS-REVMTH-DT) <> 10), CIS.CHAR2DATE(
                                                          :WS-REVMTH-DT
              ), CONVERT(DATE, :WS-REVMTH-DT) ))
            INTO
              :WS-REVMTH-PLUS-DT                              
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*       EXEC SQL                                                          
MFA-TR*          VALUES ADD_MONTHS(:WS-REVMTH-DT, 1)                            
MFA-TR*            INTO :WS-REVMTH-PLUS-DT                                      
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE WS-REVMTH-PLUS-DT        TO WS-P-OPTN-FCTR-SDT       
              MOVE WS-REVMTH-PLUS-DT(1:4)   TO WS-REV-MONTH-NUM(1:4)    
              MOVE WS-REVMTH-PLUS-DT(6:2)   TO WS-REV-MONTH-NUM(5:2)    
              MOVE WS-REV-MONTH-NUM         TO WS-NEW-EFF-REV-MTH       
           ELSE                                                         
              MOVE WS-XFR2ACT-NXT-BMTH(1:4) TO WS-C-OPTN-FCTR-EDT(1:4)  
                                               WS-REVMTH-DT(1:4)        
              MOVE WS-XFR2ACT-NXT-BMTH(5:2) TO WS-C-OPTN-FCTR-EDT(6:2)  
                                               WS-REVMTH-DT(6:2)        
              MOVE '28'                     TO WS-C-OPTN-FCTR-EDT(9:2)  
              MOVE '-'                      TO WS-C-OPTN-FCTR-EDT(5:1)  
                                               WS-C-OPTN-FCTR-EDT(8:1)  
              MOVE '01'                     TO WS-REVMTH-DT(9:2)        
              MOVE '-'                      TO WS-REVMTH-DT(5:1)        
                                               WS-REVMTH-DT(8:1)        
              EXEC SQL                                                  
                 SELECT
              DATEADD(MONTH, 1, IIF(TRY_CONVERT(DATE, :WS-REVMTH-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REVMTH-DT
              ) <> 0) OR (LEN(:WS-REVMTH-DT) <> 10), CIS.CHAR2DATE(
                                                          :WS-REVMTH-DT
              ), CONVERT(DATE, :WS-REVMTH-DT) ))
            INTO
              :WS-REVMTH-PLUS-DT                              
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*       EXEC SQL                                                          
MFA-TR*          VALUES ADD_MONTHS(:WS-REVMTH-DT, 1)                            
MFA-TR*            INTO :WS-REVMTH-PLUS-DT                                      
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE WS-REVMTH-PLUS-DT        TO WS-P-OPTN-FCTR-SDT       
              MOVE WS-REVMTH-PLUS-DT(1:4)   TO WS-REV-MONTH-NUM(1:4)    
              MOVE WS-REVMTH-PLUS-DT(6:2)   TO WS-REV-MONTH-NUM(5:2)    
              MOVE WS-REV-MONTH-NUM         TO WS-NEW-EFF-REV-MTH       
           END-IF.                                                      
                                                                        
       2160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2175-CREATE-RTPK-AGRMNT.                                       *        
      *      CREATE A NEW CSS_ACCT_RTPK_AGR.                           *        
      ******************************************************************        
       2175-CREATE-RTPK-AGRMNT.                                         
                                                                        
           MOVE WS-XFR-TO-ACCT-NUM          TO DF-ACCOUNT-NO.           
                                                                        
           IF PNDG-OPTN-EXISTS                                          
              MOVE WS-NEW-EFF-REV-MTH       TO DF-STATUS-EFF-REV-MTH    
           END-IF.                                                      
                                                                        
           IF DF-STATUS-CD EQUAL 'P'                                    
              MOVE 2                        TO DF-RT-PKG-OPT-SEQ-NO     
           ELSE                                                         
              MOVE 1                        TO DF-RT-PKG-OPT-SEQ-NO     
           END-IF.                                                      
                                                                        
           MOVE PARM-USER-ID                TO DF-LAST-UPDATE-USERID.   
           PERFORM 7050-GET-CURRENT-TIMESTAMP  THRU  7050-EXIT.         
           MOVE WS-CURRENT-TIMESTAMP        TO DF-LAST-UPDATE-TS.       
                                                                        
           PERFORM 8300-INSERT-DF              THRU  8300-EXIT.         
                                                                        
           INITIALIZE DCLCSS-MNT-TRANS-HIST                             
                      DCLCSS-MT-TRN-HST-DET.                            
                                                                        
           STRING 'TRANSFER RATE FROM '     DELIMITED BY SIZE           
                  PARM-XFR-FROM-ACCT-NO     DELIMITED BY SIZE           
             INTO MH-TRAN-COMMENT-TEXT                                  
           END-STRING.                                                  
                                                                        
           MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                          
                                            TO MH-TRAN-COMMENT-LEN.     
           PERFORM 2300-WRITE-MNT-TRNHST-HDR   THRU  2300-EXIT.         
           PERFORM 2325-WRITE-DF-MNT-TRNHST-DET                         
                                               THRU  2325-EXIT.         
                                                                        
       2175-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-PROCESS-OPTN-FCTRS.                                       *        
      *      PROCESS FIXED FACTORS LINKED TO RT_PKG_OPT_SEQ_NO         *        
      ******************************************************************        
       2200-PROCESS-OPTN-FCTRS.                                         
                                                                        
           MOVE WS-XFR-FROM-ACCT-NUM        TO FF-ACCOUNT-NO.           
           MOVE DF-CODE-UTIL-TYPE           TO FF-CODE-UTIL-TYPE.       
           MOVE DF-IC-NO                    TO FF-IC-NO.                
      **** ATTACH OPTION FACTORS TO THE CORRECT SEQ_NO                          
           MOVE DF-RT-PKG-OPT-SEQ-NO        TO FF-RT-PKG-OPT-SEQ-NO.    
                                                                        
           PERFORM 7500-OPEN-OPTN-FCTRS        THRU  7500-EXIT.         
           PERFORM 7525-FETCH-OPTN-FCTRS       THRU  7525-EXIT.         
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
              PERFORM 2225-CREATE-FIXED-FCTR   THRU  2225-EXIT          
              PERFORM 7525-FETCH-OPTN-FCTRS    THRU  7525-EXIT          
           END-PERFORM.                                                 
                                                                        
           PERFORM 7550-CLOSE-OPTN-FCTRS       THRU  7550-EXIT.         
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2225-CREATE-FIXED-FCTR.                                        *        
      *      CREATE A NEW CSS_FIXED_FCTR.                              *        
      ******************************************************************        
       2225-CREATE-FIXED-FCTR.                                          
                                                                        
           MOVE WS-XFR-TO-ACCT-NUM          TO FF-ACCOUNT-NO.           
                                                                        
           IF PNDG-OPTN-EXISTS                  AND                     
      ********SF-RT-ATTR-INCTV-TYPE > SPACES    AND                             
              SF-DURATION-TYPE-CD     EQUAL 'B' AND                     
              FF-DURATION-REMAIN-NO > ZEROS                             
              EVALUATE DF-STATUS-CD                                     
                  WHEN 'P'                                              
                     MOVE WS-P-OPTN-FCTR-SDT                            
                                            TO FF-EFF-DATE-FROM         
                  WHEN 'R'                                              
                     MOVE WS-C-OPTN-FCTR-EDT                            
                                            TO FF-EFF-DATE-TO           
              END-EVALUATE                                              
           END-IF.                                                      
                                                                        
           PERFORM 7050-GET-CURRENT-TIMESTAMP  THRU  7050-EXIT.         
           MOVE WS-CURRENT-TIMESTAMP        TO FF-LAST-UPDATE-TS.       
                                                                        
           PERFORM 8400-INSERT-FF              THRU  8400-EXIT.         
           ADD 1                            TO FF-FIXED-FCTR-SEQ-NO.    
                                                                        
           INITIALIZE DCLCSS-MNT-TRANS-HIST                             
                      DCLCSS-MT-TRN-HST-DET.                            
                                                                        
           STRING 'FACTOR ID: '             DELIMITED BY SIZE           
                  FF-FACTOR-ID              DELIMITED BY SIZE           
                  ' - '                     DELIMITED BY SIZE           
                  SF-FACTOR-TEXT            DELIMITED BY SIZE           
             INTO MH-TRAN-COMMENT-TEXT                                  
           END-STRING.                                                  
                                                                        
           MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                          
                                            TO MH-TRAN-COMMENT-LEN.     
           PERFORM 2300-WRITE-MNT-TRNHST-HDR   THRU  2300-EXIT.         
           PERFORM 2350-WRITE-FF-MNT-TRNHST-DET                         
                                               THRU  2350-EXIT.         
                                                                        
       2225-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2250-PROCESS-OTHER-FCTRS.                                      *        
      *      PROCESS ALL OTHER FIXED FACTORS.                          *        
      ******************************************************************        
       2250-PROCESS-OTHER-FCTRS.                                        
                                                                        
           MOVE WS-XFR-FROM-ACCT-NUM        TO FF-ACCOUNT-NO.           
           MOVE UT-CODE-UTIL-TYPE           TO FF-CODE-UTIL-TYPE.       
           MOVE UT-IC-NO                    TO FF-IC-NO.                
                                                                        
           MOVE 0                           TO FF-RT-PKG-OPT-SEQ-NO.    
                                                                        
           PERFORM 7600-OPEN-OTHER-FCTRS       THRU  7600-EXIT.         
           PERFORM 7625-FETCH-OTHER-FCTRS      THRU  7625-EXIT.         
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
              PERFORM 2225-CREATE-FIXED-FCTR   THRU  2225-EXIT          
              PERFORM 7625-FETCH-OTHER-FCTRS   THRU  7625-EXIT          
           END-PERFORM.                                                 
                                                                        
           PERFORM 7650-CLOSE-OTHER-FCTRS      THRU  7650-EXIT.         
                                                                        
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2275-PROCESS-ACCT-MKT-TIER.                                    *        
      *      PROCESS ACCOUNT MARKET TIER.                              *        
      ******************************************************************        
       2275-PROCESS-ACCT-MKT-TIER.                                      
                                                                        
      **** GET TRANSFER FROM ACCOUNT MKT TIER DETAILS                           
           MOVE WS-XFR-FROM-ACCT-NUM        TO DD-ACCOUNT-NO.           
           PERFORM 7175-GET-ACCT-MKT-TIER      THRU  7175-EXIT.         
                                                                        
      **** SET TRANSFER TO ACCOUNT ON THE SAME TIER                             
           MOVE WS-XFR-TO-ACCT-NUM          TO DD-ACCOUNT-NO            
           MOVE PARM-USER-ID                TO DD-LAST-UPDATE-USERID.   
           PERFORM 7050-GET-CURRENT-TIMESTAMP  THRU  7050-EXIT.         
           MOVE WS-CURRENT-TIMESTAMP        TO DD-LAST-UPDATE-TS.       
                                                                        
           PERFORM 8500-INSERT-DD              THRU  8500-EXIT.         
                                                                        
           INITIALIZE DCLCSS-MNT-TRANS-HIST                             
                      DCLCSS-MT-TRN-HST-DET.                            
                                                                        
           STRING 'TRANSFER MARKET TIER'    DELIMITED BY SIZE           
             INTO MH-TRAN-COMMENT-TEXT                                  
           END-STRING.                                                  
                                                                        
           MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                          
                                            TO MH-TRAN-COMMENT-LEN.     
           PERFORM 2300-WRITE-MNT-TRNHST-HDR   THRU  2300-EXIT.         
           PERFORM 2375-WRITE-DD-MNT-TRNHST-DET                         
                                               THRU  2375-EXIT.         
                                                                        
       2275-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2280-PROCESS-ACCT-ATTRIBUTES.                                  *        
      *      PROCESS ACCOUNT ATTRIBUTES.                               *        
      ******************************************************************        
       2280-PROCESS-ACCT-ATTRIBUTES.                                    
                                                                        
      **** TRANSFER ACCOUNT ATTRIBUTES                                          
           MOVE WS-XFR-FROM-ACCT-NUM        TO YP-ACCOUNT-NO.           
           PERFORM 7700-OPEN-ACCT-ATTRS        THRU  7700-EXIT.         
           PERFORM 7725-FETCH-ACCT-ATTRS       THRU  7725-EXIT.         
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
              MOVE WS-XFR-TO-ACCT-NUM       TO YP-ACCOUNT-NO            
              PERFORM 8800-INSERT-YP           THRU  8800-EXIT          
                                                                        
              INITIALIZE DCLCSS-MNT-TRANS-HIST                          
                         DCLCSS-MT-TRN-HST-DET                          
                                                                        
              STRING 'TRANSFER ACCOUNT ATTRIBUTE' DELIMITED BY SIZE     
                INTO MH-TRAN-COMMENT-TEXT                               
              END-STRING                                                
                                                                        
              MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                       
                                            TO MH-TRAN-COMMENT-LEN      
              PERFORM 2300-WRITE-MNT-TRNHST-HDR                         
                                               THRU  2300-EXIT          
              PERFORM 2380-WRITE-YP-MNT-TRNHST-DET                      
                                               THRU  2380-EXIT          
              PERFORM 7725-FETCH-ACCT-ATTRS    THRU  7725-EXIT          
           END-PERFORM.                                                 
                                                                        
           PERFORM 7750-CLOSE-ACCT-ATTRS       THRU  7750-EXIT.         
                                                                        
       2280-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2300-WRITE-MNT-TRNHST-HDR.                                     *        
      *      WRITE MAINTENANCE TRANSACTION HISTORY HEADER INFORMATION  *        
      ******************************************************************        
       2300-WRITE-MNT-TRNHST-HDR.                                       
                                                                        
           PERFORM 7050-GET-CURRENT-TIMESTAMP  THRU  7050-EXIT.         
                                                                        
           MOVE WS-CURRENT-TIMESTAMP        TO MH-TRANS-HIST-SEQ-NO.    
           MOVE WS-CURRENT-DATE             TO MH-DATE-TRANS.           
           MOVE 'F'                         TO MH-CODE-TRAN-TYPE.       
           MOVE SPACES                      TO MH-RESP-AREA-ID.         
           MOVE WS-XFR-TO-ACCT-NUM          TO MH-ACCOUNT-NO.           
           MOVE ZEROS                       TO MH-CUSTOMER-NO.          
           MOVE ZEROS                       TO MH-PREMISE-NO.           
           MOVE PARM-USER-ID                TO MH-USER-ID.              
           MOVE PROGRAM-NAME                TO MH-APPL-PROGRAM-ID.      
                                                                        
           PERFORM 8600-INSERT-MNT-TRANS-HDR   THRU  8600-EXIT.         
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2325-WRITE-DF-MNT-TRNHST-DET.                                  *        
      *      WRITE CSS_ACCT_RTPK_AGR TRANSACTION DETAILS.              *        
      ******************************************************************        
       2325-WRITE-DF-MNT-TRNHST-DET.                                    
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
           MOVE +1                          TO MI-TRAN-APPL-NO.         
           MOVE 'OFFER'                     TO MI-COLUMN-DESC.          
           MOVE '**NEW**'                   TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                            TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE DF-OFFER-CD                 TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE SPACES                      TO MI-TABLE-ID.             
           PERFORM 8700-INSERT-MNT-TRANS-DET   THRU  8700-EXIT.         
                                                                        
           ADD  +1                          TO MI-TRAN-APPL-NO.         
           MOVE 'OPTION'                    TO MI-COLUMN-DESC.          
           MOVE '**NEW**'                   TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                            TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE DF-OPTION-CD                TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-CHG-COLUMN-VALUE-LEN. 
           PERFORM 8700-INSERT-MNT-TRANS-DET   THRU  8700-EXIT.         
                                                                        
           ADD  +1                          TO MI-TRAN-APPL-NO.         
           MOVE 'STATUS_CD'                 TO MI-COLUMN-DESC.          
           MOVE '**NEW**'                   TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                            TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE DF-STATUS-CD                TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE 'DF'                        TO MI-TABLE-ID.             
           PERFORM 8700-INSERT-MNT-TRANS-DET   THRU  8700-EXIT.         
                                                                        
           ADD  +1                          TO MI-TRAN-APPL-NO.         
           MOVE 'AUTO_REN_OPT_IN_FL'        TO MI-COLUMN-DESC.          
           MOVE '**NEW**'                   TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                            TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE DF-AUTO-REN-OPT-IN-FL       TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-CHG-COLUMN-VALUE-LEN. 
           PERFORM 8700-INSERT-MNT-TRANS-DET   THRU  8700-EXIT.         
                                                                        
           ADD  +1                          TO MI-TRAN-APPL-NO.         
           MOVE 'EFFECTIVE DATE'            TO MI-COLUMN-DESC.          
           MOVE '**NEW**'                   TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                            TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE DF-OPT-AGRMT-EFF-DT         TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE SPACES                      TO MI-TABLE-ID.             
           PERFORM 8700-INSERT-MNT-TRANS-DET   THRU  8700-EXIT.         
                                                                        
       2325-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2350-WRITE-FF-MNT-TRNHST-DET.                                  *        
      *      WRITE CSS_FIXED_FCTR TRANSACTION DETAILS.                 *        
      ******************************************************************        
       2350-WRITE-FF-MNT-TRNHST-DET.                                    
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
           MOVE +1                          TO MI-TRAN-APPL-NO.         
           MOVE 'FACTOR VALUE'              TO MI-COLUMN-DESC.          
           MOVE '**NEW**'                   TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                            TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE FF-FACTOR                   TO WS-FACTOR-TEXT.          
           MOVE WS-FACTOR-TEXT              TO WS-FACTOR-DISPLAY.       
           MOVE WS-FACTOR-DISPLAY           TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE SPACES                      TO MI-TABLE-ID.             
           PERFORM 8700-INSERT-MNT-TRANS-DET   THRU  8700-EXIT.         
                                                                        
           ADD  +1                          TO MI-TRAN-APPL-NO.         
           MOVE 'DATE FROM'                 TO MI-COLUMN-DESC.          
           MOVE '**NEW**'                   TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                            TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE FF-EFF-DATE-FROM            TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-CHG-COLUMN-VALUE-LEN. 
           PERFORM 8700-INSERT-MNT-TRANS-DET   THRU 8700-EXIT.          
                                                                        
           ADD  +1                          TO MI-TRAN-APPL-NO.         
           MOVE 'DATE TO'                   TO MI-COLUMN-DESC.          
           MOVE '**NEW**'                   TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                            TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE FF-EFF-DATE-TO              TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-CHG-COLUMN-VALUE-LEN. 
           PERFORM 8700-INSERT-MNT-TRANS-DET   THRU  8700-EXIT.         
                                                                        
           ADD  +1                          TO MI-TRAN-APPL-NO.         
           MOVE 'DURATION'                  TO MI-COLUMN-DESC.          
           MOVE '**NEW**'                   TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                            TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE FF-DURATION-REMAIN-NO       TO WS-DURATION-NO-DISPLAY.  
           MOVE WS-DURATION-NO-DISPLAY      TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-CHG-COLUMN-VALUE-LEN. 
           PERFORM 8700-INSERT-MNT-TRANS-DET   THRU  8700-EXIT.         
                                                                        
       2350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2375-WRITE-DD-MNT-TRNHST-DET.                                  *        
      *      WRITE CSS_ACCT_MKT_TIER TRANSACTION DETAILS.              *        
      ******************************************************************        
       2375-WRITE-DD-MNT-TRNHST-DET.                                    
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
           MOVE +1                          TO MI-TRAN-APPL-NO.         
           MOVE 'TIER_CUST_STAT'            TO MI-COLUMN-DESC.          
           MOVE '**NEW**'                   TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                            TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE 'TIER_CUST_STAT_CD'         TO UV-COLUMN-NA-TEXT.       
           MOVE LENGTH OF UV-COLUMN-NA-TEXT TO UV-COLUMN-NA-LEN.        
           MOVE 'CRM_MKT_TIER'              TO UV-TABLE-NA-TEXT.        
           MOVE LENGTH OF UV-TABLE-NA-TEXT  TO UV-TABLE-NA-LEN.         
           MOVE 'ALL'                       TO UV-PROGRAM-ID.           
           MOVE DD-TIER-CUST-STAT-CD        TO UV-CODE-VALUE-TEXT.      
           MOVE LENGTH OF UV-CODE-VALUE-TEXT                            
                                            TO UV-CODE-VALUE-LEN.       
           MOVE AT-COMPANY-NO               TO UV-COMPANY-NO.           
           PERFORM 7675-SEL-CODE-VALUE-DESC    THRU  7675-EXIT.         
           MOVE UV-CODE-SHORT-DESC-TEXT     TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE 'IG'                        TO MI-TABLE-ID.             
           PERFORM 8700-INSERT-MNT-TRANS-DET   THRU  8700-EXIT.         
                                                                        
           ADD  +1                          TO MI-TRAN-APPL-NO.         
           MOVE 'TIER_ACCT_TYPE'            TO MI-COLUMN-DESC.          
           MOVE '**NEW**'                   TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                            TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE TT-TIER-ACCT-DESC           TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE 'TT'                        TO MI-TABLE-ID.             
           PERFORM 8700-INSERT-MNT-TRANS-DET   THRU  8700-EXIT.         
                                                                        
           ADD  +1                          TO MI-TRAN-APPL-NO.         
           MOVE 'TIER RANKING'              TO MI-COLUMN-DESC.          
           MOVE '**NEW**'                   TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                            TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE IG-MKT-TIER-DESC            TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE SPACES                      TO MI-TABLE-ID.             
           PERFORM 8700-INSERT-MNT-TRANS-DET   THRU  8700-EXIT.         
                                                                        
       2375-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2380-WRITE-YP-MNT-TRNHST-DET.                                  *        
      *      WRITE CSS_ACCT_ATTRIBUTE TRANSACTION DETAILS.             *        
      ******************************************************************        
       2380-WRITE-YP-MNT-TRNHST-DET.                                    
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
           MOVE +1                          TO MI-TRAN-APPL-NO.         
           MOVE 'ATTRIBUTE_DESC'            TO MI-COLUMN-DESC.          
           MOVE '**NEW**'                   TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                            TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE YP-ATTRIBUTE-DESC           TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE 'YP'                        TO MI-TABLE-ID.             
           PERFORM 8700-INSERT-MNT-TRANS-DET   THRU  8700-EXIT.         
                                                                        
           ADD  +1                          TO MI-TRAN-APPL-NO.         
           MOVE 'ATTRIBUTE_VALUE'           TO MI-COLUMN-DESC.          
           MOVE '**NEW**'                   TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                            TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE YP-ATTRIBUTE-VALUE-CD       TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE 'YP'                        TO MI-TABLE-ID.             
           PERFORM 8700-INSERT-MNT-TRANS-DET   THRU  8700-EXIT.         
                                                                        
       2380-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  2400-BUILD-RESULT-SET.                                        *        
      ******************************************************************        
       2400-BUILD-RESULT-SET.                                           
                                                                        
           MOVE 0                           TO S-RETURN-CODE            
                                               S-APPL-STATUS-CODE.      
           PERFORM 8100-SEND-RESULT            THRU  8100-EXIT.         
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6000-XFER-VAR-RATE.                                            *        
      *   1. GET VARIABLE (DROP) OPTION.                               *        
      *   2. SET TRANSFER TO ACCOUNT ON VARIABLE RATE.                 *        
      ******************************************************************        
       6000-XFER-VAR-RATE.                                              
                                                                        
      **** GET RENEWAL OPTIONS FOR THE CURRENT RATE.                            
           MOVE PROGRAM-NAME                TO WS-CPD00328-CALLING-PGM. 
           MOVE WS-XFR-FROM-ACCT-NUM        TO WS-IN-ACCOUNT-NO.        
           MOVE DF-OPTION-CD                TO WS-IN-OPTION-CD.         
           MOVE UT-CODE-UTIL-TYPE           TO WS-IN-CODE-UTIL-TYPE.    
           MOVE UT-IC-NO                    TO WS-IN-IC-NO.             
                                                                        
           MOVE SPACES                      TO ABEND-FUNCTION.          
           INITIALIZE WS-RESULT-TABLE.                                  
                                                                        
           CALL MCSCB328  USING   CWS00328-FIELDS,                      
                                  WS-RESULT-TABLE,                      
                                  ABEND-FILE,                           
                                  RETURN-CODE-328.                      
                                                                        
           MOVE RETURN-CODE-328             TO  WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-SUB-CTR = 0 OR ABEND-FUNCTION > SPACES                 
              INITIALIZE WS-RESULT-TABLE                                
              PERFORM 9000-SEND-ERROR-RESULT   THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
           IF WS-SUB-CTR > 0                                            
      **** SET TRANSFER TO ACCOUNT ON VARIABLE RATE.                            
              PERFORM 6500-CALL-MCSCB326       THRU  6500-EXIT          
           END-IF.                                                      
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6500-CALL-MCSCB326.                                            *        
      *      CREATE NEW IC AND SET RATE.                               *        
      ******************************************************************        
       6500-CALL-MCSCB326.                                              
                                                                        
           INITIALIZE WS-MCSCB326-ONLINE-DATA.                          
                                                                        
           MOVE PARM-XFR-TO-ACCT-NO         TO WS-ACCOUNT-NO-O.         
           MOVE UT-CODE-UTIL-TYPE           TO WS-CODE-UTIL-TYPE-O.     
           MOVE UT-IC-NO                    TO WS-IC-NO-O.              
           MOVE UT-CODE-REVENUE-CLASS       TO WS-CODE-REV-CLASS-O.     
                                                                        
           MOVE WS-DROP-OPTION              TO WS-OPTION-CD-O.          
           MOVE WS-DROP-OFFER-CD            TO WS-OFFER-CD-O.           
                                                                        
           MOVE ZEROS                       TO WS-TRANS-SEQ-ID-O.       
           MOVE SPACES                      TO WS-PROMO-CD-O.           
           MOVE 'W'                         TO WS-COMM-CHANNEL-O.       
           MOVE PARM-USER-ID                TO WS-CREATED-USER-ID-O.    
           MOVE 'I'                         TO WS-PROCESS-CD-O.         
                                                                        
           PERFORM 7050-GET-CURRENT-TIMESTAMP  THRU  7050-EXIT.         
           MOVE WS-CURRENT-TIMESTAMP(1:10)  TO WS-OPT-AGRMT-EFF-DT-O.   
           MOVE WS-CURRENT-TIMESTAMP(12:8)  TO WS-OPT-AGRMT-EFF-TM-O.   
                                                                        
           MOVE 'N'                         TO WS-EXIT-FEE-FLAG-O.      
           MOVE ZEROS                       TO WS-EXIT-FEE-AMT-O.       
                                                                        
           MOVE SPACES                      TO WS-PREV-OPT-CODE-O       
           MOVE WS-DROP-RATE-PLAN-NO        TO WS-RATE-PLAN-NO-O.       
           MOVE WS-DROP-OPTION-THERM-PRICE  TO WS-THERM-PRICE.          
           MOVE WS-THERM-PRICE-A            TO WS-CUST-AGRD-THERM-O.    
                                                                        
           MOVE WS-XFR-FROM-ACCT-NUM        TO DD-ACCOUNT-NO.           
           PERFORM 7175-GET-ACCT-MKT-TIER      THRU  7175-EXIT.         
           MOVE DD-TIER-ACCT-TYPE-CD        TO WS-TIER-ACCT-TYPE-CD-O.  
           MOVE DD-TIER-CUST-STAT-CD        TO WS-TIER-CUST-STAT-CD-O.  
           MOVE DD-MKT-TIER-RANKING         TO WS-MKT-TIER-RANKING-O.   
           MOVE DD-MKT-TIER-START-DT        TO WS-MKT-TIER-START-DT-O.  
                                                                        
      *****INDICATE 326 ROUTINE, CALL FROM WEB PROCESS.                         
           MOVE 'WEB'                       TO WS-APPL-PGMID.           
           MOVE 'N'                         TO WS-AUTO-REN-OPT-IN-FL-O. 
           MOVE ZEROS                       TO WS-RT-PKG-OPT-SEQ-NO-O.  
                                                                        
           CALL MCSCB326 USING  ABEND-FILE                              
                               ,WS-WARNING-DATA-ELEMENTS                
                               ,LS-MCSCB326-CALL-TYPE                   
                               ,LS-MCSCB326-ONLINE-CALL                 
                               ,LS-MCSCB326-RET-FIELDS.                 
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE.           
                                                                        
           IF ABEND-FUNCTION > SPACES OR S-RETURN-CODE > 0              
              PERFORM 9000-SEND-ERROR-RESULT   THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       6500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-GET-BILL-WINDOW.                                          *        
      *      GET MIN REVENUE MONTH FOR DATE EXTRACT.                   *        
      ******************************************************************        
       7000-GET-BILL-WINDOW.                                            
                                                                        
           EXEC SQL                                                     
              SELECT  MIN(BN.REVENUE_MONTH)                             
                INTO :BN-REVENUE-MONTH :WS-NULL-IND-01                   
                FROM  CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                  
               WHERE  BN.DATE_EXTRACT >= IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  MIN(BN.REVENUE_MONTH)                                     
MFA-TR*         INTO :BN-REVENUE-MONTH:WS-NULL-IND-01                           
MFA-TR*         FROM  CSS_BILL_WINDOW BN                                        
MFA-TR*        WHERE  BN.DATE_EXTRACT >= :BN-DATE-EXTRACT                       
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND-01 EQUAL WS-YES-NULL                       
                 MOVE ZEROS                 TO BN-REVENUE-MONTH         
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_BILL_WINDOW'        TO TABLE-1                  
              MOVE 'DATE_EXTRACT'           TO TABLE-ELEMENT-1          
              MOVE BN-DATE-EXTRACT          TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7025-SELECT-JOB-PARM.                                          *        
      *      GET DETAILS FROM CSS_JOB_PARM.                            *        
      ******************************************************************        
       7025-SELECT-JOB-PARM.                                            
                                                                        
           EXEC SQL                                                     
              SELECT  G6.PARM_DATA                                      
                INTO :G6-PARM-DATA                                      
                FROM  CSS_JOB_PARM    G6 WITH(READUNCOMMITTED)                  
               WHERE  G6.PROGRAM_NAME  =  :G6-PROGRAM-NAME              
                 AND  G6.CMND_CODE     =  :G6-CMND-CODE                 
                 AND  G6.COMPANY_NO    =  :G6-COMPANY-NO                
                 AND  G6.SEQ_NO        =  :G6-SEQ-NO                    
                 AND  G6.STATUS        = 'A'                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  G6.PARM_DATA                                              
MFA-TR*         INTO :G6-PARM-DATA                                              
MFA-TR*         FROM  CSS_JOB_PARM    G6                                        
MFA-TR*        WHERE  G6.PROGRAM_NAME  =  :G6-PROGRAM-NAME                      
MFA-TR*          AND  G6.CMND_CODE     =  :G6-CMND-CODE                         
MFA-TR*          AND  G6.COMPANY_NO    =  :G6-COMPANY-NO                        
MFA-TR*          AND  G6.SEQ_NO        =  :G6-SEQ-NO                            
MFA-TR*          AND  G6.STATUS        = 'A'                                    
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7025                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7025'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_JOB_PARM'           TO TABLE-1                  
              MOVE 'PROGRAM_NAME'           TO TABLE-ELEMENT-1          
              MOVE 'COMMON'                 TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7050-GET-CURRENT-TIMESTAMP.                                    *        
      *      GET THE CURRENT SYSTEM TIMESTAMP.                         *        
      ******************************************************************        
       7050-GET-CURRENT-TIMESTAMP.                                      
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7050'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_MODEL_SQL'          TO TABLE-1                  
              MOVE 'CURRENT_TIMESTAMP'      TO TABLE-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT   THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7075-GET-CURRENT-DATE.                                         *        
      *      GET THE CURRENT SYSTEM DATE.                              *        
      ******************************************************************        
       7075-GET-CURRENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                               
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7075'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_MODEL_SQL'          TO TABLE-1                  
              MOVE 'CURRENT_DATE'           TO TABLE-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT   THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       7075-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-SELECT-ACCT-DETAILS.                                      *        
      *      GET ACCOUNT DETAILS FROM CSS_ACCOUNT & CSS_UTIL_ENVRNMT   *        
      ******************************************************************        
       7100-SELECT-ACCT-DETAILS.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) AT.REV_MTH_LST_NRML,
              AT.CUSTOMER_NO,
              AT.BILL_CYCLE,
              UT.CODE_UTIL_TYPE,
              UT.IC_NO,
              UT.CODE_REVENUE_CLASS,
              UT.RATE_PLAN_NO,
              DF.OPTION_CD                                      
                INTO :AT-REV-MTH-LST-NRML                               
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-BILL-CYCLE                                     
                    ,:UT-CODE-UTIL-TYPE                                 
                    ,:UT-IC-NO                                          
                    ,:UT-CODE-REVENUE-CLASS                             
                    ,:UT-RATE-PLAN-NO                                   
                    ,:DF-OPTION-CD                                      
                FROM  CSS_ACCOUNT        AT WITH(READUNCOMMITTED)               
                     ,CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)               
                     ,CSS_ACCT_RTPK_AGR  DF WITH(READUNCOMMITTED)               
               WHERE  AT.ACCOUNT_NO        = :AT-ACCOUNT-NO             
                 AND  UT.ACCOUNT_NO        =  AT.ACCOUNT_NO             
                 AND  DF.ACCOUNT_NO        =  UT.ACCOUNT_NO             
                 AND  DF.IC_NO             =  UT.IC_NO                  
                 AND  DF.CODE_UTIL_TYPE    =  UT.CODE_UTIL_TYPE         
                 AND  DF.RT_PKG_OPT_SEQ_NO =  UT.RT_PKG_OPT_SEQ_NO      
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  AT.REV_MTH_LST_NRML                                       
MFA-TR*              ,AT.CUSTOMER_NO                                            
MFA-TR*              ,AT.BILL_CYCLE                                             
MFA-TR*              ,UT.CODE_UTIL_TYPE                                         
MFA-TR*              ,UT.IC_NO                                                  
MFA-TR*              ,UT.CODE_REVENUE_CLASS                                     
MFA-TR*              ,UT.RATE_PLAN_NO                                           
MFA-TR*              ,DF.OPTION_CD                                              
MFA-TR*         INTO :AT-REV-MTH-LST-NRML                                       
MFA-TR*             ,:AT-CUSTOMER-NO                                            
MFA-TR*             ,:AT-BILL-CYCLE                                             
MFA-TR*             ,:UT-CODE-UTIL-TYPE                                         
MFA-TR*             ,:UT-IC-NO                                                  
MFA-TR*             ,:UT-CODE-REVENUE-CLASS                                     
MFA-TR*             ,:UT-RATE-PLAN-NO                                           
MFA-TR*             ,:DF-OPTION-CD                                              
MFA-TR*         FROM  CSS_ACCOUNT        AT                                     
MFA-TR*              ,CSS_UTIL_ENVRNMT   UT                                     
MFA-TR*              ,CSS_ACCT_RTPK_AGR  DF                                     
MFA-TR*        WHERE  AT.ACCOUNT_NO        = :AT-ACCOUNT-NO                     
MFA-TR*          AND  UT.ACCOUNT_NO        =  AT.ACCOUNT_NO                     
MFA-TR*          AND  DF.ACCOUNT_NO        =  UT.ACCOUNT_NO                     
MFA-TR*          AND  DF.IC_NO             =  UT.IC_NO                          
MFA-TR*          AND  DF.CODE_UTIL_TYPE    =  UT.CODE_UTIL_TYPE                 
MFA-TR*          AND  DF.RT_PKG_OPT_SEQ_NO =  UT.RT_PKG_OPT_SEQ_NO              
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7125-GET-ACCOUNT-DETAILS.                                      *        
      *      GET ACCOUNT DETAILS FROM CSS_ACCOUNT                      *        
      ******************************************************************        
       7125-GET-ACCOUNT-DETAILS.                                        
                                                                        
           EXEC SQL                                                     
              SELECT  AT.REV_MTH_LST_NRML                               
                     ,AT.PREMISE_NO                                     
                     ,AT.CUSTOMER_NO                                    
                     ,AT.COMPANY_NO                                     
                     ,AT.BILL_CYCLE                                     
                INTO :AT-REV-MTH-LST-NRML                               
                    ,:AT-PREMISE-NO                                     
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-COMPANY-NO                                     
                    ,:AT-BILL-CYCLE                                     
                FROM  CSS_ACCOUNT   AT WITH(READUNCOMMITTED)                    
               WHERE  AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  AT.REV_MTH_LST_NRML                                       
MFA-TR*              ,AT.PREMISE_NO                                             
MFA-TR*              ,AT.CUSTOMER_NO                                            
MFA-TR*              ,AT.COMPANY_NO                                             
MFA-TR*              ,AT.BILL_CYCLE                                             
MFA-TR*         INTO :AT-REV-MTH-LST-NRML                                       
MFA-TR*             ,:AT-PREMISE-NO                                             
MFA-TR*             ,:AT-CUSTOMER-NO                                            
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*             ,:AT-BILL-CYCLE                                             
MFA-TR*         FROM  CSS_ACCOUNT   AT                                          
MFA-TR*        WHERE  AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7125                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7125'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       7125-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7150-GET-MONTHS-REMAINING.                                     *        
      ******************************************************************        
       7150-GET-MONTHS-REMAINING.                                       
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) FF.DURATION_REMAIN_NO                             
                INTO :FF-DURATION-REMAIN-NO :WS-NULL-IND-05              
                FROM  CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)               
                     ,CSS_FIXED_FCTR     FF WITH(READUNCOMMITTED)               
               WHERE  FF.ACCOUNT_NO         = :DF-ACCOUNT-NO            
                 AND  FF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE        
                 AND  FF.IC_NO              = :DF-IC-NO                 
                 AND  FF.RT_PKG_OPT_SEQ_NO  = :WS-OLD-RTPKG-SEQ-NO      
                 AND  HQ.OPTION_CD          = :DF-OPTION-CD             
                 AND  HQ.FACTOR_ID          = FF.FACTOR_ID              
                 AND  HQ.PRIMRY_OPT_ATTR_FL = 'Y'                       
                 AND  HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'             
                 AND  HQ.ATTR_INCTV_STRT_DT <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)             
                 AND  HQ.ATTR_INCTV_END_DT  >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)             
                 AND  HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()        
                 AND  HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()        
                 AND  HQ.PROC_STATUS_CD     = 'AC'                      
               ORDER BY HQ.OPT_ATTR_VSTART_TS DESC                      
                       ,FF.EFF_DATE_FROM DESC                           
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  FF.DURATION_REMAIN_NO                                     
MFA-TR*         INTO :FF-DURATION-REMAIN-NO:WS-NULL-IND-05                      
MFA-TR*         FROM  CRM_OPT_ATTR_INCTV HQ                                     
MFA-TR*              ,CSS_FIXED_FCTR     FF                                     
MFA-TR*        WHERE  FF.ACCOUNT_NO         = :DF-ACCOUNT-NO                    
MFA-TR*          AND  FF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE                
MFA-TR*          AND  FF.IC_NO              = :DF-IC-NO                         
MFA-TR*          AND  FF.RT_PKG_OPT_SEQ_NO  = :WS-OLD-RTPKG-SEQ-NO              
MFA-TR*          AND  HQ.OPTION_CD          = :DF-OPTION-CD                     
MFA-TR*          AND  HQ.FACTOR_ID          = FF.FACTOR_ID                      
MFA-TR*          AND  HQ.PRIMRY_OPT_ATTR_FL = 'Y'                               
MFA-TR*          AND  HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'                     
MFA-TR*          AND  HQ.ATTR_INCTV_STRT_DT <= CURRENT DATE                     
MFA-TR*          AND  HQ.ATTR_INCTV_END_DT  >= CURRENT DATE                     
MFA-TR*          AND  HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP                
MFA-TR*          AND  HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP                
MFA-TR*          AND  HQ.PROC_STATUS_CD     = 'AC'                              
MFA-TR*        ORDER BY HQ.OPT_ATTR_VSTART_TS DESC                              
MFA-TR*                ,FF.EFF_DATE_FROM DESC                                   
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7150                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR                   
                 WS-NULL-IND-05 EQUAL WS-YES-NULL                       
                 MOVE ZEROES                TO FF-DURATION-REMAIN-NO    
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7150'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_FIXED_FCTR'         TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE DF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'OPTION_CD'              TO TABLE-ELEMENT-2          
              MOVE DF-OPTION-CD             TO HOSTVAR-ELEMENT-2        
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE DF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              MOVE 'RT_PKG_OPT_SEQ_NO'      TO TABLE-ELEMENT-4          
              MOVE WS-OLD-RTPKG-SEQ-NO      TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT   THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7175-GET-ACCT-MKT-TIER.                                        *        
      *      GET DETAILS FROM CSS_ACCT_MKT_TIER.                       *        
      ******************************************************************        
       7175-GET-ACCT-MKT-TIER.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DD.TIER_CUST_STAT_CD,
              DD.TIER_ACCT_TYPE_CD,
              DD.MKT_TIER_RANKING,
              DD.MKT_TIER_START_DT,
              DD.COMPANY_NO,
              REPLACE(REPLACE(CONVERT(CHAR(26), DD.CREATED_TS, 121), 
           ' ', '-'), ':', '.') CREATED_TS,
              DD.LAST_UPDATE_USERID,
              DD.EFF_START_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), DD.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,
              DD.LAST_EVALUATED_DT,
              DD.TIER_SOURCE_CD,
              DD.ADJ_TIER_SEQ_NO,
              IG.MKT_TIER_DESC,
              TT.TIER_ACCT_DESC                                 
                INTO :DD-TIER-CUST-STAT-CD                              
                    ,:DD-TIER-ACCT-TYPE-CD                              
                    ,:DD-MKT-TIER-RANKING                               
                    ,:DD-MKT-TIER-START-DT                              
                    ,:DD-COMPANY-NO                                     
                    ,:DD-CREATED-TS                                     
                    ,:DD-LAST-UPDATE-USERID                             
                    ,:DD-EFF-START-DT                                   
                    ,:DD-LAST-UPDATE-TS                                 
                    ,:DD-LAST-EVALUATED-DT                              
                    ,:DD-TIER-SOURCE-CD                                 
                    ,:DD-ADJ-TIER-SEQ-NO                                
                    ,:IG-MKT-TIER-DESC                                  
                    ,:TT-TIER-ACCT-DESC                                 
                FROM  CSS_ACCT_MKT_TIER   DD WITH(READUNCOMMITTED)              
                     ,CRM_MKT_TIER        IG WITH(READUNCOMMITTED)              
                     ,CRM_TIER_ACCT_TYPE  TT WITH(READUNCOMMITTED)              
               WHERE  DD.ACCOUNT_NO        = :DD-ACCOUNT-NO             
                 AND  DD.EFF_START_DT      =                            
                     (SELECT MAX(D1.EFF_START_DT)                       
                        FROM CSS_ACCT_MKT_TIER D1 WITH(READUNCOMMITTED)         
                       WHERE D1.ACCOUNT_NO = DD.ACCOUNT_NO)             
                 AND  IG.COMPANY_NO        = DD.COMPANY_NO              
                 AND  IG.TIER_CUST_STAT_CD = DD.TIER_CUST_STAT_CD       
                 AND  IG.TIER_ACCT_TYPE_CD = DD.TIER_ACCT_TYPE_CD       
                 AND  IG.MKT_TIER_RANKING  = DD.MKT_TIER_RANKING        
                 AND  IG.MKT_TIER_START_DT = DD.MKT_TIER_START_DT       
                 AND  TT.COMPANY_NO        = DD.COMPANY_NO              
                 AND  TT.TIER_ACCT_TYPE_CD = DD.TIER_ACCT_TYPE_CD       
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DD.TIER_CUST_STAT_CD                                      
MFA-TR*              ,DD.TIER_ACCT_TYPE_CD                                      
MFA-TR*              ,DD.MKT_TIER_RANKING                                       
MFA-TR*              ,DD.MKT_TIER_START_DT                                      
MFA-TR*              ,DD.COMPANY_NO                                             
MFA-TR*              ,DD.CREATED_TS                                             
MFA-TR*              ,DD.LAST_UPDATE_USERID                                     
MFA-TR*              ,DD.EFF_START_DT                                           
MFA-TR*              ,DD.LAST_UPDATE_TS                                         
MFA-TR*              ,DD.LAST_EVALUATED_DT                                      
MFA-TR*              ,DD.TIER_SOURCE_CD                                         
MFA-TR*              ,DD.ADJ_TIER_SEQ_NO                                        
MFA-TR*              ,IG.MKT_TIER_DESC                                          
MFA-TR*              ,TT.TIER_ACCT_DESC                                         
MFA-TR*         INTO :DD-TIER-CUST-STAT-CD                                      
MFA-TR*             ,:DD-TIER-ACCT-TYPE-CD                                      
MFA-TR*             ,:DD-MKT-TIER-RANKING                                       
MFA-TR*             ,:DD-MKT-TIER-START-DT                                      
MFA-TR*             ,:DD-COMPANY-NO                                             
MFA-TR*             ,:DD-CREATED-TS                                             
MFA-TR*             ,:DD-LAST-UPDATE-USERID                                     
MFA-TR*             ,:DD-EFF-START-DT                                           
MFA-TR*             ,:DD-LAST-UPDATE-TS                                         
MFA-TR*             ,:DD-LAST-EVALUATED-DT                                      
MFA-TR*             ,:DD-TIER-SOURCE-CD                                         
MFA-TR*             ,:DD-ADJ-TIER-SEQ-NO                                        
MFA-TR*             ,:IG-MKT-TIER-DESC                                          
MFA-TR*             ,:TT-TIER-ACCT-DESC                                         
MFA-TR*         FROM  CSS_ACCT_MKT_TIER   DD                                    
MFA-TR*              ,CRM_MKT_TIER        IG                                    
MFA-TR*              ,CRM_TIER_ACCT_TYPE  TT                                    
MFA-TR*        WHERE  DD.ACCOUNT_NO        = :DD-ACCOUNT-NO                     
MFA-TR*          AND  DD.EFF_START_DT      =                                    
MFA-TR*              (SELECT MAX(D1.EFF_START_DT)                               
MFA-TR*                 FROM CSS_ACCT_MKT_TIER D1                               
MFA-TR*                WHERE D1.ACCOUNT_NO = DD.ACCOUNT_NO)                     
MFA-TR*          AND  IG.COMPANY_NO        = DD.COMPANY_NO                      
MFA-TR*          AND  IG.TIER_CUST_STAT_CD = DD.TIER_CUST_STAT_CD               
MFA-TR*          AND  IG.TIER_ACCT_TYPE_CD = DD.TIER_ACCT_TYPE_CD               
MFA-TR*          AND  IG.MKT_TIER_RANKING  = DD.MKT_TIER_RANKING                
MFA-TR*          AND  IG.MKT_TIER_START_DT = DD.MKT_TIER_START_DT               
MFA-TR*          AND  TT.COMPANY_NO        = DD.COMPANY_NO                      
MFA-TR*          AND  TT.TIER_ACCT_TYPE_CD = DD.TIER_ACCT_TYPE_CD               
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7175                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7175'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCT_MKT_TIER'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE DD-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       7175-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7400-OPEN-RTPKG-AGRMNTS.                                       *        
      *      OPEN RTPKG_AGRMNTS CURSOR.                                *        
      ******************************************************************        
       7400-OPEN-RTPKG-AGRMNTS.                                         
                                                                        
           EXEC SQL                                                     
              OPEN RTPKG_AGRMNTS                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7400'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-1                  
              MOVE 'CSS_ACCT_RTPK_AGR'      TO TABLE-2                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7425-FETCH-RTPKG-AGRMNTS.                                      *        
      *      FETCH RTPKG_AGRMNTS CURSOR.                               *        
      ******************************************************************        
       7425-FETCH-RTPKG-AGRMNTS.                                        
                                                                        
           EXEC SQL                                                     
              FETCH  RTPKG_AGRMNTS                                      
               INTO :DF-ACCOUNT-NO                                      
                   ,:DF-CODE-UTIL-TYPE                                  
                   ,:DF-IC-NO                                           
                   ,:WS-OLD-RTPKG-SEQ-NO                                
                   ,:DF-TRANS-SEQ-ID                                    
                   ,:DF-OFFER-CD                                        
                   ,:DF-OPTION-CD                                       
                   ,:DF-PROMO-CD                                        
                   ,:DF-STATUS-CD                                       
                   ,:DF-COMM-CHANNEL                                    
                   ,:DF-CREATED-USERID                                  
                   ,:DF-LAST-UPDATE-USERID                              
                   ,:DF-OPT-AGRMT-EFF-DT                                
                   ,:DF-OPT-AGRMT-EFF-TM                                
                   ,:DF-CREATED-TS                                      
                   ,:DF-LAST-UPDATE-TS                                  
                   ,:DF-COMPANY-NO                                      
                   ,:DF-STATUS-EFF-REV-MTH                              
                   ,:DF-AGREEMNT-SOURCE-CD                              
                   ,:DF-ADJ-TIER-SEQ-NO                                 
                   ,:DF-OFFER-OPT-START-DT                              
                   ,:DF-OFF-OPT-VRSN-NO                                 
                   ,:DF-STAT-ADJUSTABLE-CD                              
                   ,:DF-PRCE-NEGOTIATED-CD                              
                   ,:DF-STATUS-CHANGE-DT :WS-NULL-IND-01                 
                   ,:DF-AUTO-REN-OPT-IN-FL                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF WS-NULL-IND-01 EQUAL WS-YES-NULL                    
                    MOVE SPACES             TO DF-STATUS-CHANGE-DT      
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7425'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-1                  
              MOVE 'CSS_ACCT_RTPK_AGR'      TO TABLE-2                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       7425-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7450-CLOSE-RTPKG-AGRMNTS.                                      *        
      *      CLOSE RTPKG_AGRMNTS CURSOR.                               *        
      ******************************************************************        
       7450-CLOSE-RTPKG-AGRMNTS.                                        
                                                                        
           EXEC SQL                                                     
              CLOSE RTPKG_AGRMNTS                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7450'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-1                  
              MOVE 'CSS_ACCT_RTPK_AGR'      TO TABLE-2                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7500-OPEN-OPTN-FCTRS.                                          *        
      *      OPEN OPTN_FCTRS CURSOR.                                   *        
      ******************************************************************        
       7500-OPEN-OPTN-FCTRS.                                            
                                                                        
           EXEC SQL                                                     
              OPEN OPTN_FCTRS                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7500'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_FIXED_FCTR'         TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE FF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE FF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE FF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              MOVE 'RT_PKG_OPT_SEQ_NO'      TO TABLE-ELEMENT-4          
              MOVE WS-OLD-RTPKG-SEQ-NO      TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT   THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7525-FETCH-OPTN-FCTRS.                                         *        
      *      FETCH OPTN_FCTRS CURSOR.                                  *        
      ******************************************************************        
       7525-FETCH-OPTN-FCTRS.                                           
                                                                        
           EXEC SQL                                                     
              FETCH  OPTN_FCTRS                                         
               INTO  :FF-FACTOR-ID                                      
                    ,:FF-EFF-DATE-FROM                                  
                    ,:FF-CMPNT-ID-CD                                    
                    ,:FF-CODE-SEASON                                    
                    ,:FF-INSTR-USE-TYPE-CD                              
                    ,:FF-CODE-TIME-PERIOD                               
                    ,:FF-EFF-DATE-TO :WS-NULL-IND-01                     
                    ,:FF-FIXED-FCTR-TYP-CD                              
                    ,:FF-FACTOR                                         
                    ,:FF-FAC-CHRG-BASE-AM                               
                    ,:FF-DURATION-REMAIN-NO :WS-NULL-IND-02              
                    ,:FF-BLOCK-NO                                       
                    ,:SF-FACTOR-TEXT                                    
                    ,:SF-RT-ATTR-INCTV-TYPE                             
                    ,:SF-DURATION-TYPE-CD                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF WS-NULL-IND-01 EQUAL WS-YES-NULL                    
                    MOVE SPACES             TO FF-EFF-DATE-TO           
                 END-IF                                                 
                 IF WS-NULL-IND-02 EQUAL WS-YES-NULL                    
                    MOVE ZEROS              TO FF-DURATION-REMAIN-NO    
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7525'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'CSS_FIXED_FCTR'         TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE FF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE FF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE FF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              MOVE 'RT_PKG_OPT_SEQ_NO'      TO TABLE-ELEMENT-4          
              MOVE WS-OLD-RTPKG-SEQ-NO      TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT   THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       7525-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7550-CLOSE-OPTN-FCTRS.                                         *        
      *      CLOSE OPTN_FCTRS CURSOR.                                  *        
      ******************************************************************        
       7550-CLOSE-OPTN-FCTRS.                                           
                                                                        
           EXEC SQL                                                     
              CLOSE OPTN_FCTRS                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7550'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_FIXED_FCTR'         TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE FF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE FF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE FF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              MOVE 'RT_PKG_OPT_SEQ_NO'      TO TABLE-ELEMENT-4          
              MOVE WS-OLD-RTPKG-SEQ-NO      TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT   THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7600-OPEN-OTHER-FCTRS.                                         *        
      *      OPEN OTHER_FCTRS CURSOR.                                  *        
      ******************************************************************        
       7600-OPEN-OTHER-FCTRS.                                           
                                                                        
           EXEC SQL                                                     
              OPEN OTHER_FCTRS                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7600'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_FIXED_FCTR'         TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE FF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE FF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE FF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9000-SEND-ERROR-RESULT   THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7625-FETCH-OTHER-FCTRS.                                        *        
      *      FETCH OTHER_FCTRS CURSOR.                                 *        
      ******************************************************************        
       7625-FETCH-OTHER-FCTRS.                                          
                                                                        
           EXEC SQL                                                     
              FETCH  OTHER_FCTRS                                        
               INTO  :FF-FACTOR-ID                                      
                    ,:FF-EFF-DATE-FROM                                  
                    ,:FF-CMPNT-ID-CD                                    
                    ,:FF-CODE-SEASON                                    
                    ,:FF-INSTR-USE-TYPE-CD                              
                    ,:FF-CODE-TIME-PERIOD                               
                    ,:FF-EFF-DATE-TO :WS-NULL-IND-01                     
                    ,:FF-FIXED-FCTR-TYP-CD                              
                    ,:FF-FACTOR                                         
                    ,:FF-FAC-CHRG-BASE-AM                               
                    ,:FF-DURATION-REMAIN-NO :WS-NULL-IND-02              
                    ,:FF-BLOCK-NO                                       
                    ,:SF-FACTOR-TEXT                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF WS-NULL-IND-01 EQUAL WS-YES-NULL                    
                    MOVE SPACES             TO FF-EFF-DATE-TO           
                 END-IF                                                 
                 IF WS-NULL-IND-02 EQUAL WS-YES-NULL                    
                    MOVE ZEROS              TO FF-DURATION-REMAIN-NO    
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7625'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'CSS_FIXED_FCTR'         TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE FF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE FF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE FF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9000-SEND-ERROR-RESULT   THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       7625-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7650-CLOSE-OTHER-FCTRS.                                        *        
      *      CLOSE OTHER_FCTRS CURSOR.                                 *        
      ******************************************************************        
       7650-CLOSE-OTHER-FCTRS.                                          
                                                                        
           EXEC SQL                                                     
              CLOSE OTHER_FCTRS                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7650'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_FIXED_FCTR'         TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE FF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE FF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE FF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9000-SEND-ERROR-RESULT   THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       7650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7675-SEL-CODE-VALUE-DESC.                                      *        
      *      GET CODE VALUE DESCRIPTION.                               *        
      ******************************************************************        
       7675-SEL-CODE-VALUE-DESC.                                        
                                                                        
           EXEC SQL                                                     
              SELECT  UV.CODE_SHORT_DESC                                
                INTO :UV-CODE-SHORT-DESC                                
                FROM  CSS_CODE_VALUE    UV WITH(READUNCOMMITTED)                
               WHERE  UV.CODE_VALUE  = :UV-CODE-VALUE                   
                 AND  UV.COLUMN_NA   = :UV-COLUMN-NA                    
                 AND  UV.COMPANY_NO  = :UV-COMPANY-NO                   
                 AND  UV.PROGRAM_ID  = :UV-PROGRAM-ID                   
                 AND  UV.TABLE_NA    = :UV-TABLE-NA                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  UV.CODE_SHORT_DESC                                        
MFA-TR*         INTO :UV-CODE-SHORT-DESC                                        
MFA-TR*         FROM  CSS_CODE_VALUE    UV                                      
MFA-TR*        WHERE  UV.CODE_VALUE  = :UV-CODE-VALUE                           
MFA-TR*          AND  UV.COLUMN_NA   = :UV-COLUMN-NA                            
MFA-TR*          AND  UV.COMPANY_NO  = :UV-COMPANY-NO                           
MFA-TR*          AND  UV.PROGRAM_ID  = :UV-PROGRAM-ID                           
MFA-TR*          AND  UV.TABLE_NA    = :UV-TABLE-NA                             
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7675'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_CODE_VALUE'         TO TABLE-1                  
              MOVE 'COLUMN_NA'              TO TABLE-ELEMENT-1          
              MOVE UV-COLUMN-NA             TO HOSTVAR-ELEMENT-1        
              MOVE 'TABLE_NA'               TO TABLE-ELEMENT-2          
              MOVE UV-TABLE-NA              TO HOSTVAR-ELEMENT-2        
              MOVE 'CODE_VALUE'             TO TABLE-ELEMENT-3          
              MOVE UV-CODE-VALUE            TO HOSTVAR-ELEMENT-3        
              PERFORM 9000-SEND-ERROR-RESULT   THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       7675-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7700-OPEN-ACCT-ATTRS.                                          *        
      *      OPEN ACCT_ATTRS CURSOR.                                   *        
      ******************************************************************        
       7700-OPEN-ACCT-ATTRS.                                            
                                                                        
           EXEC SQL                                                     
              OPEN ACCT_ATTRS                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7700'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_ACCT_ATTRIBUTE'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE YP-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7725-FETCH-ACCT-ATTRS.                                         *        
      *      FETCH ACCT_ATTRS CURSOR.                                  *        
      ******************************************************************        
       7725-FETCH-ACCT-ATTRS.                                           
                                                                        
           EXEC SQL                                                     
              FETCH  ACCT_ATTRS                                         
               INTO  :YP-ACCOUNT-NO                                     
                    ,:YP-ATTRIBUTE-DESC                                 
                    ,:YP-ATTRIBUTE-VALUE-CD                             
                    ,:YP-ATTRIBUTE-VALUE-DT :WS-NULL-IND-06              
                    ,:YP-ATTRIBUTE-VALUE-TX :WS-NULL-IND-07              
                    ,:YP-CREATED-TS                                     
                    ,:YP-STATUS-CD                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7725'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'CSS_ACCT_ATTRIBUTE'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE YP-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       7725-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7750-CLOSE-ACCT-ATTRS.                                         *        
      *      CLOSE ACCT_ATTRS CURSOR.                                  *        
      ******************************************************************        
       7750-CLOSE-ACCT-ATTRS.                                           
                                                                        
           EXEC SQL                                                     
              CLOSE ACCT_ATTRS                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7750'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_ACCT_ATTRIBUTE'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE YP-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       7750-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000A-DEL-GTT-ROWS.                                            *        
      ******************************************************************        
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
              DELETE FROM #CSR04901_R1                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM SESSION.CSR04901_R1                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                  CONTINUE                                              
               WHEN NOT-FOUND                                           
                  MOVE ZEROES               TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '8000A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DELETE'             TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04901_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04901_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_STATUS_CODE                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE                                       
                  ,:S-APPL-STATUS-CODE                                  
                 )                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04901_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_STATUS_CODE                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE                                               
MFA-TR*           ,:S-APPL-STATUS-CODE                                          
MFA-TR*          )                                                              
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO CTR-ROWS                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8100'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04901_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8200-INSERT-UT.                                                *        
      ******************************************************************        
       8200-INSERT-UT.                                                  
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_UTIL_ENVRNMT                              
                   (                                                    
                      PREMISE_NO                                        
                     ,CODE_UTIL_TYPE                                    
                     ,IC_NO                                             
                     ,RT_PKG_OPT_SEQ_NO                                 
                     ,CODE_ESTIMATE_OK                                  
                     ,CODE_CURTAIL_PRTY                                 
                     ,CODE_REVENUE_CLASS                                
                     ,CODE_SERVICE_TYPE                                 
                     ,DATE_LST_NRML_BILL                                
                     ,RATE_PLAN_NO                                      
                     ,END_USER_PER_RATE                                 
                     ,DATE_INSTALL                                      
                     ,READ_CYCLE                                        
                     ,READ_ROUTE                                        
                     ,ACCOUNT_NO                                        
                     ,CODE_MTR_READ_FREQ                                
                     ,CODE_SIC_NO                                       
                     ,NAICS_CD                                          
                     ,ENERGY_SOURCE                                     
                     ,SPLY_SENSITIVE_IND                                
                     ,SEASONAL_USE_CODE                                 
                     ,COMPANY_NO                                        
                     ,PRV_RATE_PLAN_NO                                  
                     ,CODE_STAT_TAX_XMT                                 
                     ,CODE_CITY_TAX_XMT                                 
                     ,CODE_OTHR_TAX_XMT                                 
                     ,CODE_XCIS_TAX_XMT                                 
                     ,STATE_TAX_EXMPT_NO                                
                     ,TOU_RATE_IND                                      
                     ,GAS_BASE_LAST_UPDT                                
                     ,GAS_PREV_BASE_USE                                 
                     ,GAS_BASE_USE                                      
                     ,LAST_UPDATE_TS                                    
                     ,ZERO_USE_INVEST_DT                                
                     ,ONERATE_ORIG_MO                                   
                     ,ONERATE_ANNIV_MO                                  
                     ,ALTERNATE_FUEL_CD                                 
                     ,AUTO_RATE_SW_FL                                   
                   )                                                    
              VALUES                                                    
                   (                                                    
                      :UT-PREMISE-NO                                    
                     ,:UT-CODE-UTIL-TYPE                                
                     ,:UT-IC-NO                                         
                     ,:UT-RT-PKG-OPT-SEQ-NO                             
                     ,:UT-CODE-ESTIMATE-OK                              
                     ,:UT-CODE-CURTAIL-PRTY                             
                     ,:UT-CODE-REVENUE-CLASS                            
                     ,:UT-CODE-SERVICE-TYPE                             
                     ,IIF(TRY_CONVERT(DATE, :UT-DATE-LST-NRML-BILL 
                                            :WS-NULL-IND-01
              ) IS NULL OR (PATINDEX('%.%', :UT-DATE-LST-NRML-BILL 
                                                        :WS-NULL-IND-01
              ) <> 0) OR (LEN(:UT-DATE-LST-NRML-BILL :WS-NULL-IND-01
              ) <> 10), CIS.CHAR2DATE(:UT-DATE-LST-NRML-BILL 
                                                        :WS-NULL-IND-01
              ), CONVERT(DATE, :UT-DATE-LST-NRML-BILL :WS-NULL-IND-01
              ) )             
                     ,:UT-RATE-PLAN-NO                                  
                     ,:UT-END-USER-PER-RATE                             
                     ,IIF(TRY_CONVERT(DATE, :UT-DATE-INSTALL 
                                            :WS-NULL-IND-02
              ) IS NULL OR (PATINDEX('%.%', :UT-DATE-INSTALL 
                                                        :WS-NULL-IND-02
              ) <> 0) OR (LEN(:UT-DATE-INSTALL :WS-NULL-IND-02
              ) <> 10), CIS.CHAR2DATE(:UT-DATE-INSTALL :WS-NULL-IND-02
              ), CONVERT(DATE, :UT-DATE-INSTALL :WS-NULL-IND-02) )             
                     ,:UT-READ-CYCLE                                    
                     ,:UT-READ-ROUTE                                    
                     ,:UT-ACCOUNT-NO                                    
                     ,:UT-CODE-MTR-READ-FREQ                            
                     ,:UT-CODE-SIC-NO                                   
                     ,:UT-NAICS-CD                                      
                     ,:UT-ENERGY-SOURCE                                 
                     ,:UT-SPLY-SENSITIVE-IND                            
                     ,:UT-SEASONAL-USE-CODE                             
                     ,:UT-COMPANY-NO                                    
                     ,:UT-PRV-RATE-PLAN-NO                              
                     ,:UT-CODE-STAT-TAX-XMT                             
                     ,:UT-CODE-CITY-TAX-XMT                             
                     ,:UT-CODE-OTHR-TAX-XMT                             
                     ,:UT-CODE-XCIS-TAX-XMT                             
                     ,:UT-STATE-TAX-EXMPT-NO                            
                     ,:UT-TOU-RATE-IND                                  
                     ,IIF(TRY_CONVERT(DATE, :UT-GAS-BASE-LAST-UPDT 
                                            :WS-NULL-IND-03
              ) IS NULL OR (PATINDEX('%.%', :UT-GAS-BASE-LAST-UPDT 
                                                        :WS-NULL-IND-03
              ) <> 0) OR (LEN(:UT-GAS-BASE-LAST-UPDT :WS-NULL-IND-03
              ) <> 10), CIS.CHAR2DATE(:UT-GAS-BASE-LAST-UPDT 
                                                        :WS-NULL-IND-03
              ), CONVERT(DATE, :UT-GAS-BASE-LAST-UPDT :WS-NULL-IND-03
              ) )             
                     ,:UT-GAS-PREV-BASE-USE                             
                     ,:UT-GAS-BASE-USE                                  
                     ,CIS.CHAR2TIMESTAMP(:UT-LAST-UPDATE-TS)                    
                     ,IIF(TRY_CONVERT(DATE, :UT-ZERO-USE-INVEST-DT 
                                            :WS-NULL-IND-04
              ) IS NULL OR (PATINDEX('%.%', :UT-ZERO-USE-INVEST-DT 
                                                        :WS-NULL-IND-04
              ) <> 0) OR (LEN(:UT-ZERO-USE-INVEST-DT :WS-NULL-IND-04
              ) <> 10), CIS.CHAR2DATE(:UT-ZERO-USE-INVEST-DT 
                                                        :WS-NULL-IND-04
              ), CONVERT(DATE, :UT-ZERO-USE-INVEST-DT :WS-NULL-IND-04
              ) )             
                     ,:UT-ONERATE-ORIG-MO                               
                     ,:UT-ONERATE-ANNIV-MO                              
                     ,:UT-ALTERNATE-FUEL-CD                             
                     ,:UT-AUTO-RATE-SW-FL                               
                   )                                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_UTIL_ENVRNMT                                      
MFA-TR*            (                                                            
MFA-TR*               PREMISE_NO                                                
MFA-TR*              ,CODE_UTIL_TYPE                                            
MFA-TR*              ,IC_NO                                                     
MFA-TR*              ,RT_PKG_OPT_SEQ_NO                                         
MFA-TR*              ,CODE_ESTIMATE_OK                                          
MFA-TR*              ,CODE_CURTAIL_PRTY                                         
MFA-TR*              ,CODE_REVENUE_CLASS                                        
MFA-TR*              ,CODE_SERVICE_TYPE                                         
MFA-TR*              ,DATE_LST_NRML_BILL                                        
MFA-TR*              ,RATE_PLAN_NO                                              
MFA-TR*              ,END_USER_PER_RATE                                         
MFA-TR*              ,DATE_INSTALL                                              
MFA-TR*              ,READ_CYCLE                                                
MFA-TR*              ,READ_ROUTE                                                
MFA-TR*              ,ACCOUNT_NO                                                
MFA-TR*              ,CODE_MTR_READ_FREQ                                        
MFA-TR*              ,CODE_SIC_NO                                               
MFA-TR*              ,NAICS_CD                                                  
MFA-TR*              ,ENERGY_SOURCE                                             
MFA-TR*              ,SPLY_SENSITIVE_IND                                        
MFA-TR*              ,SEASONAL_USE_CODE                                         
MFA-TR*              ,COMPANY_NO                                                
MFA-TR*              ,PRV_RATE_PLAN_NO                                          
MFA-TR*              ,CODE_STAT_TAX_XMT                                         
MFA-TR*              ,CODE_CITY_TAX_XMT                                         
MFA-TR*              ,CODE_OTHR_TAX_XMT                                         
MFA-TR*              ,CODE_XCIS_TAX_XMT                                         
MFA-TR*              ,STATE_TAX_EXMPT_NO                                        
MFA-TR*              ,TOU_RATE_IND                                              
MFA-TR*              ,GAS_BASE_LAST_UPDT                                        
MFA-TR*              ,GAS_PREV_BASE_USE                                         
MFA-TR*              ,GAS_BASE_USE                                              
MFA-TR*              ,LAST_UPDATE_TS                                            
MFA-TR*              ,ZERO_USE_INVEST_DT                                        
MFA-TR*              ,ONERATE_ORIG_MO                                           
MFA-TR*              ,ONERATE_ANNIV_MO                                          
MFA-TR*              ,ALTERNATE_FUEL_CD                                         
MFA-TR*              ,AUTO_RATE_SW_FL                                           
MFA-TR*            )                                                            
MFA-TR*       VALUES                                                            
MFA-TR*            (                                                            
MFA-TR*               :UT-PREMISE-NO                                            
MFA-TR*              ,:UT-CODE-UTIL-TYPE                                        
MFA-TR*              ,:UT-IC-NO                                                 
MFA-TR*              ,:UT-RT-PKG-OPT-SEQ-NO                                     
MFA-TR*              ,:UT-CODE-ESTIMATE-OK                                      
MFA-TR*              ,:UT-CODE-CURTAIL-PRTY                                     
MFA-TR*              ,:UT-CODE-REVENUE-CLASS                                    
MFA-TR*              ,:UT-CODE-SERVICE-TYPE                                     
MFA-TR*              ,:UT-DATE-LST-NRML-BILL:WS-NULL-IND-01                     
MFA-TR*              ,:UT-RATE-PLAN-NO                                          
MFA-TR*              ,:UT-END-USER-PER-RATE                                     
MFA-TR*              ,:UT-DATE-INSTALL:WS-NULL-IND-02                           
MFA-TR*              ,:UT-READ-CYCLE                                            
MFA-TR*              ,:UT-READ-ROUTE                                            
MFA-TR*              ,:UT-ACCOUNT-NO                                            
MFA-TR*              ,:UT-CODE-MTR-READ-FREQ                                    
MFA-TR*              ,:UT-CODE-SIC-NO                                           
MFA-TR*              ,:UT-NAICS-CD                                              
MFA-TR*              ,:UT-ENERGY-SOURCE                                         
MFA-TR*              ,:UT-SPLY-SENSITIVE-IND                                    
MFA-TR*              ,:UT-SEASONAL-USE-CODE                                     
MFA-TR*              ,:UT-COMPANY-NO                                            
MFA-TR*              ,:UT-PRV-RATE-PLAN-NO                                      
MFA-TR*              ,:UT-CODE-STAT-TAX-XMT                                     
MFA-TR*              ,:UT-CODE-CITY-TAX-XMT                                     
MFA-TR*              ,:UT-CODE-OTHR-TAX-XMT                                     
MFA-TR*              ,:UT-CODE-XCIS-TAX-XMT                                     
MFA-TR*              ,:UT-STATE-TAX-EXMPT-NO                                    
MFA-TR*              ,:UT-TOU-RATE-IND                                          
MFA-TR*              ,:UT-GAS-BASE-LAST-UPDT:WS-NULL-IND-03                     
MFA-TR*              ,:UT-GAS-PREV-BASE-USE                                     
MFA-TR*              ,:UT-GAS-BASE-USE                                          
MFA-TR*              ,:UT-LAST-UPDATE-TS                                        
MFA-TR*              ,:UT-ZERO-USE-INVEST-DT:WS-NULL-IND-04                     
MFA-TR*              ,:UT-ONERATE-ORIG-MO                                       
MFA-TR*              ,:UT-ONERATE-ANNIV-MO                                      
MFA-TR*              ,:UT-ALTERNATE-FUEL-CD                                     
MFA-TR*              ,:UT-AUTO-RATE-SW-FL                                       
MFA-TR*            )                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE UT-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE UT-IC-NO                 TO HOSTVAR-ELEMENT-3        
              MOVE 'RT_PKG_OPT_SEQ_NO'      TO TABLE-ELEMENT-4          
              MOVE UT-RT-PKG-OPT-SEQ-NO     TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT   THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8300-INSERT-DF.                                                *        
      ******************************************************************        
       8300-INSERT-DF.                                                  
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ACCT_RTPK_AGR                             
                   (                                                    
                      ACCOUNT_NO                                        
                     ,CODE_UTIL_TYPE                                    
                     ,IC_NO                                             
                     ,RT_PKG_OPT_SEQ_NO                                 
                     ,TRANS_SEQ_ID                                      
                     ,OFFER_CD                                          
                     ,OPTION_CD                                         
                     ,PROMO_CD                                          
                     ,STATUS_CD                                         
                     ,COMM_CHANNEL                                      
                     ,CREATED_USERID                                    
                     ,LAST_UPDATE_USERID                                
                     ,OPT_AGRMT_EFF_DT                                  
                     ,OPT_AGRMT_EFF_TM                                  
                     ,CREATED_TS                                        
                     ,LAST_UPDATE_TS                                    
                     ,COMPANY_NO                                        
                     ,STATUS_EFF_REV_MTH                                
                     ,AGREEMNT_SOURCE_CD                                
                     ,ADJ_TIER_SEQ_NO                                   
                     ,OFFER_OPT_START_DT                                
                     ,OFF_OPT_VRSN_NO                                   
                     ,STAT_ADJUSTABLE_CD                                
                     ,PRCE_NEGOTIATED_CD                                
                     ,STATUS_CHANGE_DT                                  
                     ,AUTO_REN_OPT_IN_FL                                
                   )                                                    
              VALUES                                                    
                   (                                                    
                      :DF-ACCOUNT-NO                                    
                     ,:DF-CODE-UTIL-TYPE                                
                     ,:DF-IC-NO                                         
                     ,:DF-RT-PKG-OPT-SEQ-NO                             
                     ,:DF-TRANS-SEQ-ID                                  
                     ,:DF-OFFER-CD                                      
                     ,:DF-OPTION-CD                                     
                     ,:DF-PROMO-CD                                      
                     ,:DF-STATUS-CD                                     
                     ,:DF-COMM-CHANNEL                                  
                     ,:DF-CREATED-USERID                                
                     ,:DF-LAST-UPDATE-USERID                            
                     ,IIF(TRY_CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) )                         
                     ,CIS.CHAR2TIME(:DF-OPT-AGRMT-EFF-TM)                       
                     ,CIS.CHAR2TIMESTAMP(:DF-CREATED-TS)                        
                     ,CIS.CHAR2TIMESTAMP(:DF-LAST-UPDATE-TS)                    
                     ,:DF-COMPANY-NO                                    
                     ,:DF-STATUS-EFF-REV-MTH                            
                     ,:DF-AGREEMNT-SOURCE-CD                            
                     ,:DF-ADJ-TIER-SEQ-NO                               
                     ,IIF(TRY_CONVERT(DATE, :DF-OFFER-OPT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OFFER-OPT-START-DT
              ) <> 0) OR (LEN(:DF-OFFER-OPT-START-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OFFER-OPT-START-DT
              ), CONVERT(DATE, :DF-OFFER-OPT-START-DT) )                       
                     ,:DF-OFF-OPT-VRSN-NO                               
                     ,:DF-STAT-ADJUSTABLE-CD                            
                     ,:DF-PRCE-NEGOTIATED-CD                            
                     ,IIF(TRY_CONVERT(DATE, :DF-STATUS-CHANGE-DT 
                                            :WS-NULL-IND-01
              ) IS NULL OR (PATINDEX('%.%', :DF-STATUS-CHANGE-DT 
                                                        :WS-NULL-IND-01
              ) <> 0) OR (LEN(:DF-STATUS-CHANGE-DT :WS-NULL-IND-01
              ) <> 10), CIS.CHAR2DATE(:DF-STATUS-CHANGE-DT 
                                                        :WS-NULL-IND-01
              ), CONVERT(DATE, :DF-STATUS-CHANGE-DT :WS-NULL-IND-01) )         
                     ,:DF-AUTO-REN-OPT-IN-FL                            
                   )                                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_ACCT_RTPK_AGR                                     
MFA-TR*            (                                                            
MFA-TR*               ACCOUNT_NO                                                
MFA-TR*              ,CODE_UTIL_TYPE                                            
MFA-TR*              ,IC_NO                                                     
MFA-TR*              ,RT_PKG_OPT_SEQ_NO                                         
MFA-TR*              ,TRANS_SEQ_ID                                              
MFA-TR*              ,OFFER_CD                                                  
MFA-TR*              ,OPTION_CD                                                 
MFA-TR*              ,PROMO_CD                                                  
MFA-TR*              ,STATUS_CD                                                 
MFA-TR*              ,COMM_CHANNEL                                              
MFA-TR*              ,CREATED_USERID                                            
MFA-TR*              ,LAST_UPDATE_USERID                                        
MFA-TR*              ,OPT_AGRMT_EFF_DT                                          
MFA-TR*              ,OPT_AGRMT_EFF_TM                                          
MFA-TR*              ,CREATED_TS                                                
MFA-TR*              ,LAST_UPDATE_TS                                            
MFA-TR*              ,COMPANY_NO                                                
MFA-TR*              ,STATUS_EFF_REV_MTH                                        
MFA-TR*              ,AGREEMNT_SOURCE_CD                                        
MFA-TR*              ,ADJ_TIER_SEQ_NO                                           
MFA-TR*              ,OFFER_OPT_START_DT                                        
MFA-TR*              ,OFF_OPT_VRSN_NO                                           
MFA-TR*              ,STAT_ADJUSTABLE_CD                                        
MFA-TR*              ,PRCE_NEGOTIATED_CD                                        
MFA-TR*              ,STATUS_CHANGE_DT                                          
MFA-TR*              ,AUTO_REN_OPT_IN_FL                                        
MFA-TR*            )                                                            
MFA-TR*       VALUES                                                            
MFA-TR*            (                                                            
MFA-TR*               :DF-ACCOUNT-NO                                            
MFA-TR*              ,:DF-CODE-UTIL-TYPE                                        
MFA-TR*              ,:DF-IC-NO                                                 
MFA-TR*              ,:DF-RT-PKG-OPT-SEQ-NO                                     
MFA-TR*              ,:DF-TRANS-SEQ-ID                                          
MFA-TR*              ,:DF-OFFER-CD                                              
MFA-TR*              ,:DF-OPTION-CD                                             
MFA-TR*              ,:DF-PROMO-CD                                              
MFA-TR*              ,:DF-STATUS-CD                                             
MFA-TR*              ,:DF-COMM-CHANNEL                                          
MFA-TR*              ,:DF-CREATED-USERID                                        
MFA-TR*              ,:DF-LAST-UPDATE-USERID                                    
MFA-TR*              ,:DF-OPT-AGRMT-EFF-DT                                      
MFA-TR*              ,:DF-OPT-AGRMT-EFF-TM                                      
MFA-TR*              ,:DF-CREATED-TS                                            
MFA-TR*              ,:DF-LAST-UPDATE-TS                                        
MFA-TR*              ,:DF-COMPANY-NO                                            
MFA-TR*              ,:DF-STATUS-EFF-REV-MTH                                    
MFA-TR*              ,:DF-AGREEMNT-SOURCE-CD                                    
MFA-TR*              ,:DF-ADJ-TIER-SEQ-NO                                       
MFA-TR*              ,:DF-OFFER-OPT-START-DT                                    
MFA-TR*              ,:DF-OFF-OPT-VRSN-NO                                       
MFA-TR*              ,:DF-STAT-ADJUSTABLE-CD                                    
MFA-TR*              ,:DF-PRCE-NEGOTIATED-CD                                    
MFA-TR*              ,:DF-STATUS-CHANGE-DT:WS-NULL-IND-01                       
MFA-TR*              ,:DF-AUTO-REN-OPT-IN-FL                                    
MFA-TR*            )                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCT_RTPK_AGR'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE DF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'RT_PKG_OPT_SEQ_NO'      TO TABLE-ELEMENT-2          
              MOVE DF-RT-PKG-OPT-SEQ-NO     TO HOSTVAR-ELEMENT-2        
              MOVE 'OPTION_CD'              TO TABLE-ELEMENT-3          
              MOVE DF-OPTION-CD             TO HOSTVAR-ELEMENT-3        
              MOVE 'OFFER_CD'               TO TABLE-ELEMENT-4          
              MOVE DF-OFFER-CD              TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT   THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8400-INSERT-FF.                                                *        
      ******************************************************************        
       8400-INSERT-FF.                                                  
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_FIXED_FCTR                                
                   (                                                    
                      ACCOUNT_NO                                        
                     ,CODE_UTIL_TYPE                                    
                     ,IC_NO                                             
                     ,FIXED_FCTR_SEQ_NO                                 
                     ,FACTOR_ID                                         
                     ,EFF_DATE_FROM                                     
                     ,CMPNT_ID_CD                                       
                     ,CODE_SEASON                                       
                     ,INSTR_USE_TYPE_CD                                 
                     ,CODE_TIME_PERIOD                                  
                     ,EFF_DATE_TO                                       
                     ,FIXED_FCTR_TYP_CD                                 
                     ,FACTOR                                            
                     ,FAC_CHRG_BASE_AM                                  
                     ,LAST_UPDATE_TS                                    
                     ,DURATION_REMAIN_NO                                
                     ,RT_PKG_OPT_SEQ_NO                                 
                     ,BLOCK_NO                                          
                   )                                                    
              VALUES                                                    
                   (                                                    
                      :FF-ACCOUNT-NO                                    
                     ,:FF-CODE-UTIL-TYPE                                
                     ,:FF-IC-NO                                         
                     ,:FF-FIXED-FCTR-SEQ-NO                             
                     ,:FF-FACTOR-ID                                     
                     ,IIF(TRY_CONVERT(DATE, :FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FF-EFF-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM) )                            
                     ,:FF-CMPNT-ID-CD                                   
                     ,:FF-CODE-SEASON                                   
                     ,:FF-INSTR-USE-TYPE-CD                             
                     ,:FF-CODE-TIME-PERIOD                              
                     ,IIF(TRY_CONVERT(DATE, :FF-EFF-DATE-TO 
                                            :WS-NULL-IND-01
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO 
                                                        :WS-NULL-IND-01
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO :WS-NULL-IND-01
              ) <> 10), CIS.CHAR2DATE(:FF-EFF-DATE-TO :WS-NULL-IND-01
              ), CONVERT(DATE, :FF-EFF-DATE-TO :WS-NULL-IND-01) )              
                     ,:FF-FIXED-FCTR-TYP-CD                             
                     ,:FF-FACTOR                                        
                     ,:FF-FAC-CHRG-BASE-AM                              
                     ,CIS.CHAR2TIMESTAMP(:FF-LAST-UPDATE-TS)                    
                     ,:FF-DURATION-REMAIN-NO :WS-NULL-IND-02             
                     ,:FF-RT-PKG-OPT-SEQ-NO                             
                     ,:FF-BLOCK-NO                                      
                   )                                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_FIXED_FCTR                                        
MFA-TR*            (                                                            
MFA-TR*               ACCOUNT_NO                                                
MFA-TR*              ,CODE_UTIL_TYPE                                            
MFA-TR*              ,IC_NO                                                     
MFA-TR*              ,FIXED_FCTR_SEQ_NO                                         
MFA-TR*              ,FACTOR_ID                                                 
MFA-TR*              ,EFF_DATE_FROM                                             
MFA-TR*              ,CMPNT_ID_CD                                               
MFA-TR*              ,CODE_SEASON                                               
MFA-TR*              ,INSTR_USE_TYPE_CD                                         
MFA-TR*              ,CODE_TIME_PERIOD                                          
MFA-TR*              ,EFF_DATE_TO                                               
MFA-TR*              ,FIXED_FCTR_TYP_CD                                         
MFA-TR*              ,FACTOR                                                    
MFA-TR*              ,FAC_CHRG_BASE_AM                                          
MFA-TR*              ,LAST_UPDATE_TS                                            
MFA-TR*              ,DURATION_REMAIN_NO                                        
MFA-TR*              ,RT_PKG_OPT_SEQ_NO                                         
MFA-TR*              ,BLOCK_NO                                                  
MFA-TR*            )                                                            
MFA-TR*       VALUES                                                            
MFA-TR*            (                                                            
MFA-TR*               :FF-ACCOUNT-NO                                            
MFA-TR*              ,:FF-CODE-UTIL-TYPE                                        
MFA-TR*              ,:FF-IC-NO                                                 
MFA-TR*              ,:FF-FIXED-FCTR-SEQ-NO                                     
MFA-TR*              ,:FF-FACTOR-ID                                             
MFA-TR*              ,:FF-EFF-DATE-FROM                                         
MFA-TR*              ,:FF-CMPNT-ID-CD                                           
MFA-TR*              ,:FF-CODE-SEASON                                           
MFA-TR*              ,:FF-INSTR-USE-TYPE-CD                                     
MFA-TR*              ,:FF-CODE-TIME-PERIOD                                      
MFA-TR*              ,:FF-EFF-DATE-TO:WS-NULL-IND-01                            
MFA-TR*              ,:FF-FIXED-FCTR-TYP-CD                                     
MFA-TR*              ,:FF-FACTOR                                                
MFA-TR*              ,:FF-FAC-CHRG-BASE-AM                                      
MFA-TR*              ,:FF-LAST-UPDATE-TS                                        
MFA-TR*              ,:FF-DURATION-REMAIN-NO:WS-NULL-IND-02                     
MFA-TR*              ,:FF-RT-PKG-OPT-SEQ-NO                                     
MFA-TR*              ,:FF-BLOCK-NO                                              
MFA-TR*            )                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8400'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_FIXED_FCTR'         TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE FF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'FACTOR_ID'              TO TABLE-ELEMENT-2          
              MOVE FF-FACTOR-ID             TO HOSTVAR-ELEMENT-2        
              MOVE 'EFF_DATE_FROM'          TO TABLE-ELEMENT-3          
              MOVE FF-EFF-DATE-FROM         TO HOSTVAR-ELEMENT-3        
              MOVE 'RT_PKG_OPT_SEQ_NO'      TO TABLE-ELEMENT-4          
              MOVE FF-RT-PKG-OPT-SEQ-NO     TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT   THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8500-INSERT-DD.                                                *        
      ******************************************************************        
       8500-INSERT-DD.                                                  
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ACCT_MKT_TIER                             
                   (                                                    
                      ACCOUNT_NO                                        
                     ,TIER_CUST_STAT_CD                                 
                     ,TIER_ACCT_TYPE_CD                                 
                     ,MKT_TIER_RANKING                                  
                     ,MKT_TIER_START_DT                                 
                     ,COMPANY_NO                                        
                     ,CREATED_TS                                        
                     ,LAST_UPDATE_USERID                                
                     ,EFF_START_DT                                      
                     ,LAST_UPDATE_TS                                    
                     ,LAST_EVALUATED_DT                                 
                     ,TIER_SOURCE_CD                                    
                     ,ADJ_TIER_SEQ_NO                                   
                   )                                                    
              VALUES                                                    
                   (                                                    
                      :DD-ACCOUNT-NO                                    
                     ,:DD-TIER-CUST-STAT-CD                             
                     ,:DD-TIER-ACCT-TYPE-CD                             
                     ,:DD-MKT-TIER-RANKING                              
                     ,IIF(TRY_CONVERT(DATE, :DD-MKT-TIER-START-DT
              ) IS NULL OR (PATINDEX('%.%', :DD-MKT-TIER-START-DT
              ) <> 0) OR (LEN(:DD-MKT-TIER-START-DT
              ) <> 10), CIS.CHAR2DATE(:DD-MKT-TIER-START-DT
              ), CONVERT(DATE, :DD-MKT-TIER-START-DT) )                        
                     ,:DD-COMPANY-NO                                    
                     ,CIS.CHAR2TIMESTAMP(:DD-CREATED-TS)                        
                     ,:DD-LAST-UPDATE-USERID                            
                     ,IIF(TRY_CONVERT(DATE, :DD-EFF-START-DT
              ) IS NULL OR (PATINDEX('%.%', :DD-EFF-START-DT
              ) <> 0) OR (LEN(:DD-EFF-START-DT) <> 10), CIS.CHAR2DATE(
                                                       :DD-EFF-START-DT
              ), CONVERT(DATE, :DD-EFF-START-DT) )                             
                     ,CIS.CHAR2TIMESTAMP(:DD-LAST-UPDATE-TS)                    
                     ,IIF(TRY_CONVERT(DATE, :DD-LAST-EVALUATED-DT
              ) IS NULL OR (PATINDEX('%.%', :DD-LAST-EVALUATED-DT
              ) <> 0) OR (LEN(:DD-LAST-EVALUATED-DT
              ) <> 10), CIS.CHAR2DATE(:DD-LAST-EVALUATED-DT
              ), CONVERT(DATE, :DD-LAST-EVALUATED-DT) )                        
                     ,:DD-TIER-SOURCE-CD                                
                     ,:DD-ADJ-TIER-SEQ-NO                               
                   )                                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_ACCT_MKT_TIER                                     
MFA-TR*            (                                                            
MFA-TR*               ACCOUNT_NO                                                
MFA-TR*              ,TIER_CUST_STAT_CD                                         
MFA-TR*              ,TIER_ACCT_TYPE_CD                                         
MFA-TR*              ,MKT_TIER_RANKING                                          
MFA-TR*              ,MKT_TIER_START_DT                                         
MFA-TR*              ,COMPANY_NO                                                
MFA-TR*              ,CREATED_TS                                                
MFA-TR*              ,LAST_UPDATE_USERID                                        
MFA-TR*              ,EFF_START_DT                                              
MFA-TR*              ,LAST_UPDATE_TS                                            
MFA-TR*              ,LAST_EVALUATED_DT                                         
MFA-TR*              ,TIER_SOURCE_CD                                            
MFA-TR*              ,ADJ_TIER_SEQ_NO                                           
MFA-TR*            )                                                            
MFA-TR*       VALUES                                                            
MFA-TR*            (                                                            
MFA-TR*               :DD-ACCOUNT-NO                                            
MFA-TR*              ,:DD-TIER-CUST-STAT-CD                                     
MFA-TR*              ,:DD-TIER-ACCT-TYPE-CD                                     
MFA-TR*              ,:DD-MKT-TIER-RANKING                                      
MFA-TR*              ,:DD-MKT-TIER-START-DT                                     
MFA-TR*              ,:DD-COMPANY-NO                                            
MFA-TR*              ,:DD-CREATED-TS                                            
MFA-TR*              ,:DD-LAST-UPDATE-USERID                                    
MFA-TR*              ,:DD-EFF-START-DT                                          
MFA-TR*              ,:DD-LAST-UPDATE-TS                                        
MFA-TR*              ,:DD-LAST-EVALUATED-DT                                     
MFA-TR*              ,:DD-TIER-SOURCE-CD                                        
MFA-TR*              ,:DD-ADJ-TIER-SEQ-NO                                       
MFA-TR*            )                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8500'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCT_MKT_TIER'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE DD-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'TIER_CUST_STAT_CD'      TO TABLE-ELEMENT-2          
              MOVE DD-TIER-CUST-STAT-CD     TO HOSTVAR-ELEMENT-2        
              MOVE 'TIER_ACCT_TYPE_CD'      TO TABLE-ELEMENT-3          
              MOVE DD-TIER-ACCT-TYPE-CD     TO HOSTVAR-ELEMENT-3        
              MOVE 'MKT_TIER_RANKING'       TO TABLE-ELEMENT-4          
              MOVE DD-MKT-TIER-RANKING      TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT   THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8600-INSERT-MNT-TRANS-HDR.                                     *        
      ******************************************************************        
       8600-INSERT-MNT-TRANS-HDR.                                       
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_MNT_TRANS_HIST                            
                (                                                       
                  TRANS_HIST_SEQ_NO,      DATE_TRANS,                   
                  CODE_TRAN_TYPE,         RESP_AREA_ID,                 
                  ACCOUNT_NO,                                           
                  CUSTOMER_NO,            PREMISE_NO,                   
                  USER_ID,                APPL_PROGRAM_ID,              
                  TRAN_COMMENT                                          
                )                                                       
              VALUES                                                    
                (                                                       
                  CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO), 
              IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) ),                
                  :MH-CODE-TRAN-TYPE,    :MH-RESP-AREA-ID,              
                  :MH-ACCOUNT-NO,                                       
                  :MH-CUSTOMER-NO,       :MH-PREMISE-NO,                
                  :MH-USER-ID,           :MH-APPL-PROGRAM-ID,           
                  :MH-TRAN-COMMENT                                      
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_MNT_TRANS_HIST                                    
MFA-TR*         (                                                               
MFA-TR*           TRANS_HIST_SEQ_NO,      DATE_TRANS,                           
MFA-TR*           CODE_TRAN_TYPE,         RESP_AREA_ID,                         
MFA-TR*           ACCOUNT_NO,                                                   
MFA-TR*           CUSTOMER_NO,            PREMISE_NO,                           
MFA-TR*           USER_ID,                APPL_PROGRAM_ID,                      
MFA-TR*           TRAN_COMMENT                                                  
MFA-TR*         )                                                               
MFA-TR*       VALUES                                                            
MFA-TR*         (                                                               
MFA-TR*           :MH-TRANS-HIST-SEQ-NO, :MH-DATE-TRANS,                        
MFA-TR*           :MH-CODE-TRAN-TYPE,    :MH-RESP-AREA-ID,                      
MFA-TR*           :MH-ACCOUNT-NO,                                               
MFA-TR*           :MH-CUSTOMER-NO,       :MH-PREMISE-NO,                        
MFA-TR*           :MH-USER-ID,           :MH-APPL-PROGRAM-ID,                   
MFA-TR*           :MH-TRAN-COMMENT                                              
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8600'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_MNT_TRANS_HIST'     TO TABLE-1                  
              MOVE 'ACCOUNT-NO'             TO TABLE-ELEMENT-1          
              MOVE MH-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'CUSTOMER-NO'            TO TABLE-ELEMENT-2          
              MOVE MH-CUSTOMER-NO           TO HOSTVAR-ELEMENT-2        
              MOVE 'PREMISE-NO'             TO TABLE-ELEMENT-3          
              MOVE MH-PREMISE-NO            TO HOSTVAR-ELEMENT-3        
              MOVE 'DATE-TRANS'             TO TABLE-ELEMENT-4          
              MOVE MH-DATE-TRANS            TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT   THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8700-INSERT-MNT-TRANS-DET.                                     *        
      ******************************************************************        
       8700-INSERT-MNT-TRANS-DET.                                       
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_MT_TRN_HST_DET                            
                   (                                                    
                     TRANS_HIST_SEQ_NO,     TRAN_APPL_NO,               
                     COLUMN_DESC,           PRV_COLUMN_VALUE,           
                     CHG_COLUMN_VALUE,                                  
                     TABLE_ID                                           
                   )                                                    
              VALUES                                                    
                   (                                                    
                    CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO), 
                                                      :MI-TRAN-APPL-NO,        
                    :MI-COLUMN-DESC,       :MI-PRV-COLUMN-VALUE,        
                    :MI-CHG-COLUMN-VALUE,                               
                    :MI-TABLE-ID                                        
                   )                                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_MT_TRN_HST_DET                                    
MFA-TR*            (                                                            
MFA-TR*              TRANS_HIST_SEQ_NO,     TRAN_APPL_NO,                       
MFA-TR*              COLUMN_DESC,           PRV_COLUMN_VALUE,                   
MFA-TR*              CHG_COLUMN_VALUE,                                          
MFA-TR*              TABLE_ID                                                   
MFA-TR*            )                                                            
MFA-TR*       VALUES                                                            
MFA-TR*            (                                                            
MFA-TR*             :MI-TRANS-HIST-SEQ-NO, :MI-TRAN-APPL-NO,                    
MFA-TR*             :MI-COLUMN-DESC,       :MI-PRV-COLUMN-VALUE,                
MFA-TR*             :MI-CHG-COLUMN-VALUE,                                       
MFA-TR*             :MI-TABLE-ID                                                
MFA-TR*            )                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8700'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_MT_TRN_HST_DET'     TO TABLE-1                  
              MOVE 'TRANS-HIST-SEQ-NO'      TO TABLE-ELEMENT-1          
              MOVE MI-TRANS-HIST-SEQ-NO     TO HOSTVAR-ELEMENT-1        
              MOVE 'TRAN-APPL-NO'           TO TABLE-ELEMENT-2          
              MOVE MI-TRAN-APPL-NO          TO HOSTVAR-ELEMENT-2        
              MOVE 'COLUMN-DESC'            TO TABLE-ELEMENT-3          
              MOVE MI-COLUMN-DESC           TO HOSTVAR-ELEMENT-3        
              MOVE 'ACCOUNT-NO'             TO TABLE-ELEMENT-4          
              MOVE MH-ACCOUNT-NO            TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT   THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       8700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8800-INSERT-YP.                                                *        
      ******************************************************************        
       8800-INSERT-YP.                                                  
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ACCT_ATTRIBUTE                            
                   (                                                    
                      ACCOUNT_NO                                        
                     ,ATTRIBUTE_DESC                                    
                     ,ATTRIBUTE_VALUE_CD                                
                     ,ATTRIBUTE_VALUE_DT                                
                     ,ATTRIBUTE_VALUE_TX                                
                     ,CREATED_TS                                        
                     ,STATUS_CD                                         
                   )                                                    
              VALUES                                                    
                   (                                                    
                      :YP-ACCOUNT-NO                                    
                     ,:YP-ATTRIBUTE-DESC                                
                     ,:YP-ATTRIBUTE-VALUE-CD                            
                     ,IIF(TRY_CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT 
                                            :WS-NULL-IND-06
              ) IS NULL OR (PATINDEX('%.%', :YP-ATTRIBUTE-VALUE-DT 
                                                        :WS-NULL-IND-06
              ) <> 0) OR (LEN(:YP-ATTRIBUTE-VALUE-DT :WS-NULL-IND-06
              ) <> 10), CIS.CHAR2DATE(:YP-ATTRIBUTE-VALUE-DT 
                                                        :WS-NULL-IND-06
              ), CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT :WS-NULL-IND-06
              ) )             
                     ,:YP-ATTRIBUTE-VALUE-TX :WS-NULL-IND-07             
                     ,CIS.CHAR2TIMESTAMP(:YP-CREATED-TS)                        
                     ,:YP-STATUS-CD                                     
                   )                                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_ACCT_ATTRIBUTE                                    
MFA-TR*            (                                                            
MFA-TR*               ACCOUNT_NO                                                
MFA-TR*              ,ATTRIBUTE_DESC                                            
MFA-TR*              ,ATTRIBUTE_VALUE_CD                                        
MFA-TR*              ,ATTRIBUTE_VALUE_DT                                        
MFA-TR*              ,ATTRIBUTE_VALUE_TX                                        
MFA-TR*              ,CREATED_TS                                                
MFA-TR*              ,STATUS_CD                                                 
MFA-TR*            )                                                            
MFA-TR*       VALUES                                                            
MFA-TR*            (                                                            
MFA-TR*               :YP-ACCOUNT-NO                                            
MFA-TR*              ,:YP-ATTRIBUTE-DESC                                        
MFA-TR*              ,:YP-ATTRIBUTE-VALUE-CD                                    
MFA-TR*              ,:YP-ATTRIBUTE-VALUE-DT:WS-NULL-IND-06                     
MFA-TR*              ,:YP-ATTRIBUTE-VALUE-TX:WS-NULL-IND-07                     
MFA-TR*              ,:YP-CREATED-TS                                            
MFA-TR*              ,:YP-STATUS-CD                                             
MFA-TR*            )                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8800'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCT_ATTRIBUTE'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE YP-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'ATTRIBUTE_DESC'         TO TABLE-ELEMENT-2          
              MOVE YP-ATTRIBUTE-DESC        TO HOSTVAR-ELEMENT-2        
              MOVE 'ATTRIBUTE_VALUE_CD'     TO TABLE-ELEMENT-3          
              MOVE YP-ATTRIBUTE-VALUE-CD    TO HOSTVAR-ELEMENT-3        
              MOVE 'STATUS_CD'              TO TABLE-ELEMENT-4          
              MOVE YP-STATUS-CD             TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT   THRU  9000-EXIT          
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           EXEC SQL                                                     
              OPEN C1                                                   
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT.                                        *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           EXEC SQL                                                     
              ROLLBACK                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE.           
           MOVE 0                           TO S-APPL-STATUS-CODE.      
           PERFORM 0100A-DECLARE-GTT           THRU  0100A-EXIT.        
           PERFORM 8100-SEND-RESULT            THRU  8100-EXIT.         
           PERFORM 9900-SQL-ERROR-ROUTINE      THRU  9900-EXIT.         
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
       9999-END-PROGRAM.                                                
                                                                        
           PERFORM 8900-SEND-DONE              THRU  8900-EXIT.         
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
