       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04900.                                         
       AUTHOR.        AARON ABRAHAM                                     
COB303 DATE-WRITTEN.  FEB 22, 2016.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *  THE PURPOSE OF THIS PROGRAM IS TO HAVE A SINGLE PROGRAM WHICH *        
      *  CONTAIN ALL LOGIC NECESSARY TO MAINTAIN RETURNED PAYMERNT     *        
      *  HISTORY.                                                      *        
      *                                                                *        
      *  #  INVOKED FROM PAYMENT SOLUTION/RETURNED PAYMENT PROJECT     *        
      *                                                                *        
      *  #  BUSOP NAME: REQUUPDACCTRETURNEDPYMTHISTBUSINESSOP          *        
      *                                                                *        
      ******************************************************************        
      *                     PROGRAM MODIFICATION LOG                   *        
      ******************************************************************        
      * ---------- -------- ------------------------------------------ *        
      *    DATE    INITIALS COMMENTS                                   *        
      * ---------- -------- ------------------------------------------ *        
P00935* 02/22/2016 AA97148  INITIAL IMPLEMENTATION.                    *        
      ******************************************************************        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      ******************************************************************        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04900'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04900 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCOUNT           - AT                                  *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CREDIT_PROFILE    - CZ                                  *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCRPROF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CRED_COLL         - CL                                  *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCRCOLL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MT_TRN_HST_DET    - MI                                  *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MNT_TRANS_HIST    - MH                                  *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_NSF_HIST          - NH                                  *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNSFHST                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WS VARIABLE FOR CPD00056                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00056                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    ERROR HANDLING                                              *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WORK-FIELDS.                                                 
           05  PROGRAM-NAME              PIC X(08) VALUE 'CSR04900'.    
           05  WS-ACCOUNT-NO-CHAR        PIC X(13).                     
           05  WS-ACCOUNT-NUM REDEFINES WS-ACCOUNT-NO-CHAR PIC 9(13).   
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.      
           05  WS-RETURN-CHECK-AMT-CHAR  PIC X(09).                     
           05  WS-RETURN-CHECK-AMT-NUM REDEFINES                        
               WS-RETURN-CHECK-AMT-CHAR  PIC 9(07)V99.                  
           05  WS-RETURN-CHECK-AMT       PIC S9(07)V99 COMP-3 VALUE 0.  
           05  WS-NH-RETURN-CHECK-AMT    PIC ZZZZZZ9.99.                
           05  WS-NH-RETURN-CHECK-AMT-X REDEFINES                       
                           WS-NH-RETURN-CHECK-AMT  PIC X(10).           
           05  WS-NSC-REMOVE-FL          PIC X(01) VALUE SPACES.        
           05  WS-NSF-STATUS-CD          PIC X(01) VALUE SPACES.        
           05  WS-NSF-REASON-CD          PIC X(03) VALUE SPACES.        
           05  WS-ACTION-TYPE            PIC X(01) VALUE SPACES.        
           05  WS-CASH-ONLY-FL           PIC X(01) VALUE SPACES.        
           05  WS-PREV-WAIVE-NOTICE-FL   PIC X(01) VALUE SPACES.        
           05  WS-WAIVE-NOTICE-FL        PIC X(01) VALUE SPACES.        
           05  WS-CASH-ONLY-COM-TEXT     PIC X(72) VALUE SPACES.        
           05  WS-CASH-ONLY-COM-LEN      PIC S9(09) COMP VALUE +0.      
           05  WS-CSH-ONLY-EFFECT-DT     PIC X(10) VALUE SPACES.        
           05  WS-CSH-ONLY-EFF-DT-NULL   PIC S9(4) COMP VALUE +0.       
           05  WS-DATE-NOTICE-MAIL-NULL  PIC S9(4) COMP VALUE +0.       
           05  WS-USER-ID                PIC X(07) VALUE SPACES.        
           05  WS-NSF-TIMESTMP           PIC X(26) VALUE SPACES.        
           05  WS-CURRENT-TIMESTAMP      PIC X(26) VALUE SPACES.        
           05  WS-CURRENT-DATE           PIC X(10) VALUE SPACES.        
           05  WS-DATE-NOTICE-MAIL       PIC X(10) VALUE SPACES.        
           05  WS-DATE-TRAN              PIC X(10) VALUE SPACES.        
           05  WS-RESP-AREA-ID           PIC X(03) VALUE SPACES.        
           05  WS-SEND-NOTICE-CD         PIC X(01) VALUE SPACES.        
           05  WS-PARM-TYPE              PIC X(01) VALUE SPACES.        
           05  WS-PREV-NSC-REMOVE-FL     PIC X(01) VALUE SPACES.        
           05  WS-PREV-NSF-STATUS-CD     PIC X(01) VALUE SPACES.        
           05  WS-PREV-NSF-TYPE-CD       PIC X(01) VALUE SPACES.        
           05  WS-PREV-CASH-ONLY-FL      PIC X(01) VALUE SPACES.        
           05  WS-PREV-SEND-NOTICE-CD    PIC X(01) VALUE SPACES.        
           05  WS-PREV-NSF-REASON-CD     PIC X(03) VALUE SPACES.        
           05  WS-PREV-CSH-ONLY-EFFECT-DT                               
                                         PIC X(10) VALUE SPACES.        
           05  WS-PREV-RETURN-CHECK-AMT  PIC S9(7)V9(2) COMP-3 VALUE 0. 
           05  WS-NSF-COMMENTS-TEXT.                                    
               10  WS-NSF-COMMENTS-114         PIC X(114) VALUE SPACES. 
               10  WS-NSF-COMMENTS-BANK-ID     PIC X(06)  VALUE SPACES. 
           05  WS-PREV-NSF-COMM-TEXT.                                   
               10  WS-PREV-NSF-COMM-114        PIC X(114) VALUE SPACES. 
               10  WS-PREV-NSF-COMM-BANK-ID    PIC X(06)  VALUE SPACES. 
           05  WS-TRANS-COMMENT.                                        
               49  WS-TRANS-COMMENT-LEN        PIC  S9(4) COMP VALUE +0.
               49  WS-TRANS-COMMENT-TEXT       PIC  X(210) VALUE SPACES.
           05  WS-PREV-CASH-ONLY-COMMENTS.                              
               49  WS-PREV-CASH-ONLY-COMM-LEN  PIC S9(4) COMP VALUE +0. 
               49  WS-PREV-CASH-ONLY-COMM-TEXT PIC X(72) VALUE SPACES.  
           05  WS-PREV-NSF-COMMENTS .                                   
               49  WS-PREV-NSF-COMMENTS-LEN    PIC S9(4) COMP VALUE +0. 
               49  WS-PREV-NSF-COMMENTS-TEXT   PIC X(120) VALUE SPACES. 
                                                                        
       01 SWITCHES.                                                     
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-FUTURE-H-EXIST         PIC X(01) VALUE 'N'.           
           05  WS-FUTURE-N-EXIST         PIC X(01) VALUE 'N'.           
           05  WS-FUTURE-C-F-EXIST       PIC X(01) VALUE 'N'.           
           05  WS-FUTURE-D-G-EXIST       PIC X(01) VALUE 'N'.           
           05  WS-CASH-ONLY-TRAN-FL      PIC X(01) VALUE 'N'.           
           05  WS-WAIVER-TRAN-FL         PIC X(01) VALUE 'N'.           
           05  WS-MAINT-TRAN-FL          PIC X(01) VALUE 'N'.           
                                                                        
       01  WS-LITERAL.                                                  
           05  WS-YES                    PIC X(01) VALUE 'Y'.           
           05  WS-ACTIVE                 PIC X(01) VALUE 'A'.           
           05  WS-C                      PIC X(01) VALUE 'C'.           
           05  WS-F                      PIC X(01) VALUE 'F'.           
           05  WS-G                      PIC X(01) VALUE 'G'.           
           05  WS-D                      PIC X(01) VALUE 'D'.           
           05  WS-H                      PIC X(01) VALUE 'H'.           
           05  WS-N                      PIC X(01) VALUE 'N'.           
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                  PIC S9(9) COMP VALUE 0.        
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05 S-RETURN-CODE              PIC S9(9) COMP VALUE 0.        
           05 S-FORECASTED-DNP           PIC X(01) VALUE SPACES.        
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO               PIC X(13)  VALUE SPACES.       
       01  PARM-TYPE                     PIC X(01)  VALUE SPACES.       
       01  PARM-DATE-TRAN                PIC X(10)  VALUE SPACES.       
       01  PARM-NSF-TIMESTMP             PIC X(26)  VALUE SPACES.       
       01  PARM-NSF-STATUS-CD            PIC X(01)  VALUE SPACES.       
       01  PARM-NSF-REASON-CD            PIC X(03)  VALUE SPACES.       
       01  PARM-NSC-REMOVE-FL            PIC X(01)  VALUE SPACES.       
       01  PARM-WAIVE-NOTICE-FL          PIC X(01)  VALUE SPACES.       
       01  PARM-RETURN-CHECK-AMT         PIC X(09)  VALUE SPACES.       
       01  PARM-ACTION-TYPE              PIC X(01)  VALUE SPACES.       
       01  PARM-RESP-AREA-ID             PIC X(03)  VALUE SPACES.       
       01  PARM-USER-ID                  PIC X(07)  VALUE SPACES.       
       01  PARM-NSF-COMMENTS-LEN         PIC S9(04) COMP VALUE 0.       
       01  PARM-NSF-COMMENTS-TEXT        PIC X(114) VALUE SPACES.       
       01  PARM-CASH-ONLY-FL             PIC X(01)  VALUE SPACES.       
       01  PARM-CASH-ONLY-COM-TEXT       PIC X(72)  VALUE SPACES.       
       01  PARM-CASH-ONLY-COM-LEN        PIC S9(09) COMP VALUE +0.      
       01  PARM-CSH-ONLY-EFFECT-DT       PIC X(10)  VALUE SPACES.       
                                                                        
       PROCEDURE DIVISION USING   PARM-ACCOUNT-NO                       
                                  PARM-TYPE                             
                                  PARM-DATE-TRAN                        
                                  PARM-NSF-TIMESTMP                     
                                  PARM-NSF-STATUS-CD                    
                                  PARM-NSF-REASON-CD                    
                                  PARM-NSC-REMOVE-FL                    
                                  PARM-WAIVE-NOTICE-FL                  
                                  PARM-RETURN-CHECK-AMT                 
                                  PARM-ACTION-TYPE                      
                                  PARM-RESP-AREA-ID                     
                                  PARM-USER-ID                          
                                  PARM-NSF-COMMENTS-LEN                 
                                  PARM-NSF-COMMENTS-TEXT                
                                  PARM-CASH-ONLY-FL                     
                                  PARM-CASH-ONLY-COM-TEXT               
                                  PARM-CASH-ONLY-COM-LEN                
                                  PARM-CSH-ONLY-EFFECT-DT.              
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE                     THRU 0100-EXIT.  
           PERFORM 1000-PROCESS-INPUT                  THRU 1000-EXIT.  
           PERFORM 2000-PROCESS-OUTPUT                 THRU 2000-EXIT.  
           PERFORM 9999-END-PROGRAM                    THRU 9999-EXIT.  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                   :S-RETURN-CODE     AS RETURN_CODE                    
                  ,:S-FORECASTED-DNP  AS FORECASTED_DNP                 
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            :S-RETURN-CODE     AS RETURN_CODE                            
MFA-TR*           ,:S-FORECASTED-DNP  AS FORECASTED_DNP                         
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO          TO WS-ACCOUNT-NO-CHAR          
           MOVE WS-ACCOUNT-NUM           TO WS-ACCOUNT-NO               
           MOVE WS-ACCOUNT-NO            TO AT-ACCOUNT-NO               
                                            CL-ACCOUNT-NO               
                                            CZ-ACCOUNT-NO               
                                            MH-ACCOUNT-NO               
                                            NH-ACCOUNT-NO.              
           MOVE PARM-TYPE                TO WS-PARM-TYPE.               
           MOVE PARM-DATE-TRAN           TO WS-DATE-TRAN                
                                            NH-DATE-TRAN.               
           MOVE PARM-NSF-TIMESTMP        TO WS-NSF-TIMESTMP             
                                            NH-NSF-TIMESTMP.            
           MOVE PARM-NSF-STATUS-CD       TO WS-NSF-STATUS-CD.           
           MOVE PARM-NSF-REASON-CD       TO WS-NSF-REASON-CD.           
           MOVE PARM-NSC-REMOVE-FL       TO WS-NSC-REMOVE-FL.           
           MOVE PARM-RETURN-CHECK-AMT    TO WS-RETURN-CHECK-AMT-CHAR.   
           MOVE WS-RETURN-CHECK-AMT-NUM  TO WS-RETURN-CHECK-AMT.        
           MOVE PARM-ACTION-TYPE         TO WS-ACTION-TYPE.             
           MOVE PARM-RESP-AREA-ID        TO WS-RESP-AREA-ID.            
           MOVE PARM-USER-ID             TO WS-USER-ID.                 
           MOVE PARM-NSF-COMMENTS-TEXT   TO WS-NSF-COMMENTS-114         
                                            WS-TRANS-COMMENT-TEXT.      
           MOVE PARM-NSF-COMMENTS-LEN    TO WS-TRANS-COMMENT-LEN.       
           MOVE PARM-CASH-ONLY-FL        TO WS-CASH-ONLY-FL.            
           MOVE PARM-CASH-ONLY-COM-TEXT  TO WS-CASH-ONLY-COM-TEXT.      
           MOVE PARM-CASH-ONLY-COM-LEN   TO WS-CASH-ONLY-COM-LEN.       
           MOVE PARM-CSH-ONLY-EFFECT-DT  TO WS-CSH-ONLY-EFFECT-DT.      
           MOVE PARM-WAIVE-NOTICE-FL     TO WS-WAIVE-NOTICE-FL.         
                                                                        
      *    As table reads SEND NOTICE CD, we translate it from waiver           
      *    flag                                                                 
           IF WS-WAIVE-NOTICE-FL = 'Y'                                  
              MOVE 'N'                   TO WS-SEND-NOTICE-CD           
           ELSE                                                         
              MOVE 'Y'                   TO WS-SEND-NOTICE-CD           
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7010-SELECT-ACCOUNT                THRU 7010-EXIT.   
           MOVE AT-CODES-DATA-PRESENT        TO WS-CODES-DATA-PRESENT.  
           PERFORM 7070-GET-CURRENT-DATE-TS           THRU 7070-EXIT.   
                                                                        
           IF WS-NSF-TIMESTMP > SPACES                                  
              PERFORM 7060-SELECT-PREV-NSF-HIST       THRU 7060-EXIT    
              MOVE WS-PREV-NSF-COMMENTS-TEXT(1:114)                     
                                         TO WS-PREV-NSF-COMM-114        
              MOVE WS-PREV-NSF-COMMENTS-TEXT(115:6)                     
                                         TO WS-PREV-NSF-COMM-BANK-ID    
                                            WS-NSF-COMMENTS-BANK-ID     
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF WS-PREV-SEND-NOTICE-CD = 'Y'                        
                    MOVE 'N'             TO WS-PREV-WAIVE-NOTICE-FL     
                 ELSE                                                   
                    MOVE 'Y'             TO WS-PREV-WAIVE-NOTICE-FL     
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
           MOVE WS-NSF-COMMENTS-TEXT     TO NH-COMMENTS-TEXT            
           MOVE 120                      TO NH-COMMENTS-LEN             
                                                                        
           PERFORM 5000-UPDATE                        THRU 5000-EXIT.   
                                                                        
           PERFORM 5100-MNT-TRAN-HEAD                 THRU 5100-EXIT.   
           PERFORM 5110-MNT-TRAN-DTLS                 THRU 5110-EXIT.   
           ADD +1                            TO CTR-ROWS.               
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-CHECK-CRED-COLL.                                          *        
      *                                                                *        
      *  THIS PARAGRAPH CHECKS TO SEE IF THERE IS ANY FUTURE CRED COLL *        
      *  FOR THIS ACCOUNT BECAUSE OF THE RETURNED CHECK CREDIT ACTION  *        
      *  EXISTS FOR THE FOLLOWING CONDITION:                           *        
      *     IF PENDING DNP EXISTS, SET THE FLAG TO Y                   *        
      *     IF FUTURE DNP (H) FOR THE DEPOSIT EXISTS,SET THE FLAG TO YES        
      *     IF RET CHECK NOTICE EXISTS WITH A MESSAGE NUMBER 90107 THEN*        
      *        IT MEANS MERGING OF CREDIT ACTION EXIST.                *        
      *     IF NORMAL NOTICE EXISTS WITH NOTICE MAIL DATE(C) EQUAL TO  *        
      *        RET CHECK NOTICE MAIL DATE(N) CHECK THE NORMAL DNP(D),  *        
      *        IF DATE CREDIT ACTION IS IN THE FUTURE, SET THE FL TO YES        
      *     IF SPECIAL NOTICE EXISTS WITH NOTICE MAIL DATE(F)EQUAL TO  *        
      *        RET CHECK NOTICE MAIL DATE(N) CHECK THE SPECIAL DNP(G), *        
      *        IF DATE CREDIT ACTION IS IN THE FUTURE, SET THE FL TO YES        
      ***************************************************************           
                                                                        
       2100-CHECK-CRED-COLL.                                            
                                                                        
           IF WS-CODE-PENDING-DNP EQUAL WS-ACTIVE                       
               MOVE WS-YES                    TO S-FORECASTED-DNP       
           ELSE                                                         
               PERFORM 7020-CHECK-FUTURE-H              THRU 7020-EXIT  
               IF WS-FUTURE-H-EXIST EQUAL WS-YES                        
                  MOVE WS-YES                 TO S-FORECASTED-DNP       
               ELSE                                                     
                  PERFORM 7030-CHECK-FUTURE-N           THRU 7030-EXIT  
                  IF WS-FUTURE-N-EXIST EQUAL WS-YES                     
                      MOVE WS-C               TO CL-CODE-NOTICE-TYPE    
                      PERFORM 7040-CHECK-FUTURE-C-F     THRU 7040-EXIT  
                      IF WS-FUTURE-C-F-EXIST EQUAL WS-YES               
                          MOVE WS-D           TO CL-CODE-NOTICE-TYPE    
                          PERFORM 7050-CHECK-FUTURE-D-G THRU 7050-EXIT  
                          IF WS-FUTURE-D-G-EXIST EQUAL WS-YES           
                             MOVE WS-YES      TO S-FORECASTED-DNP       
                          END-IF                                        
                      ELSE                                              
                          MOVE WS-F           TO CL-CODE-NOTICE-TYPE    
                          PERFORM 7040-CHECK-FUTURE-C-F THRU 7040-EXIT  
                          IF WS-FUTURE-C-F-EXIST EQUAL WS-YES           
                             MOVE WS-G        TO CL-CODE-NOTICE-TYPE    
                             PERFORM 7050-CHECK-FUTURE-D-G              
                                                        THRU 7050-EXIT  
                             IF WS-FUTURE-D-G-EXIST EQUAL WS-YES        
                                MOVE WS-YES   TO S-FORECASTED-DNP       
                             END-IF                                     
                          END-IF                                        
                       END-IF                                           
                    END-IF                                              
               END-IF                                                   
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 5000-UPDATE                                                 *           
      ***************************************************************           
                                                                        
       5000-UPDATE.                                                     
                                                                        
           EVALUATE WS-PARM-TYPE                                        
            WHEN 'C'                                                    
                 PERFORM 5010-CASH-ONLY-PROCESS       THRU 5010-EXIT    
            WHEN 'U'                                                    
                 PERFORM 5020-MAINT-CURR-DETLS        THRU 5020-EXIT    
            WHEN 'W'                                                    
                 PERFORM 5030-PENDING-CHRG-WAIVER     THRU 5030-EXIT    
           END-EVALUATE.                                                
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5010-CASH-ONLY-PROCESS                                         *        
      ******************************************************************        
                                                                        
       5010-CASH-ONLY-PROCESS.                                          
                                                                        
           EVALUATE WS-PREV-NSF-TYPE-CD                                 
              WHEN 'D'                                                  
                 MOVE 'PANEL182D'         TO MH-APPL-PROGRAM-ID         
              WHEN 'M'                                                  
                 MOVE 'PANEL182O'         TO MH-APPL-PROGRAM-ID         
              WHEN OTHER                                                
                 MOVE 'PANEL182C'         TO MH-APPL-PROGRAM-ID         
           END-EVALUATE.                                                
                                                                        
           PERFORM 7080-SELECT-CRED-PROFILE   THRU 7080-EXIT.           
                                                                        
      * Get previous value from table to write trans hist dtls                  
           MOVE CZ-CASH-ONLY-FL           TO WS-PREV-CASH-ONLY-FL.      
           MOVE CZ-CSH-ONLY-EFFECT-DT     TO WS-PREV-CSH-ONLY-EFFECT-DT.
           MOVE CZ-CASH-ONLY-COMMENTS-LEN TO WS-PREV-CASH-ONLY-COMM-LEN.
           MOVE CZ-CASH-ONLY-COMMENTS-TEXT                              
                                          TO WS-PREV-CASH-ONLY-COMM-TEXT
                                                                        
      * Move input Parm value to the host variables                             
           MOVE WS-CSH-ONLY-EFFECT-DT     TO CZ-CSH-ONLY-EFFECT-DT.     
           MOVE WS-CASH-ONLY-COM-LEN      TO CZ-CASH-ONLY-COMMENTS-LEN. 
           MOVE WS-CASH-ONLY-COM-TEXT     TO CZ-CASH-ONLY-COMMENTS-TEXT.
           MOVE WS-CASH-ONLY-FL           TO CZ-CASH-ONLY-FL.           
                                                                        
           PERFORM 8010-UPDATE-CZ             THRU 8010-EXIT.           
           MOVE 'Y'                       TO WS-CASH-ONLY-TRAN-FL.      
                                                                        
       5010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5020-MAINT-CURR-DETLS                                          *        
      ******************************************************************        
                                                                        
       5020-MAINT-CURR-DETLS.                                           
                                                                        
           EVALUATE WS-PREV-NSF-TYPE-CD                                 
              WHEN 'C'                                                  
                   MOVE 'PANEL255A'           TO MH-APPL-PROGRAM-ID     
              WHEN 'M'                                                  
                   MOVE 'PANEL255M'           TO MH-APPL-PROGRAM-ID     
              WHEN OTHER                                                
                   MOVE 'PANEL255B'           TO MH-APPL-PROGRAM-ID     
           END-EVALUATE.                                                
                                                                        
           PERFORM 8030-UPD-NSF-STATUS-REASON    THRU 8030-EXIT         
           PERFORM 2100-CHECK-CRED-COLL          THRU 2100-EXIT         
                                                                        
           MOVE 'Y'                           TO WS-MAINT-TRAN-FL.      
                                                                        
       5020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5030-PENDING-CHRG-WAIVER                                       *        
      ******************************************************************        
                                                                        
       5030-PENDING-CHRG-WAIVER.                                        
                                                                        
           MOVE 'PANEL256'                  TO MH-APPL-PROGRAM-ID.      
           MOVE 'P'                         TO NH-NSF-STATUS-CD.        
                                                                        
           EVALUATE WS-ACTION-TYPE                                      
            WHEN 'I'                                                    
                 MOVE 0                     TO NH-BANK-ID               
                                               NH-CHECK-NONUTIL-AMT     
                                               NH-CHECK-UTIL-AMT        
                                               NH-DRAWN-BY-NM-LEN       
                                               NH-NSF-CHARGE-AMT        
                 MOVE SPACES                TO NH-DRAWN-BY-NM-TEXT      
                                               NH-NSF-REASON-CD         
                                               NH-NSF-TYPE-CD           
                                               NH-WAIVER-REASON-CD      
                 MOVE WS-CURRENT-TIMESTAMP  TO NH-TRANS-HIST-SEQ-NO     
                                               NH-NSF-TIMESTMP          
                 MOVE WS-CURRENT-DATE       TO NH-NSF-ORIG-DT           
                                               NH-DATE-TRAN             
                 MOVE WS-NSC-REMOVE-FL      TO NH-NSC-REMOVE-FL         
                 MOVE WS-SEND-NOTICE-CD     TO NH-SEND-NOTICE-CD        
                 MOVE WS-RETURN-CHECK-AMT   TO NH-RETURN-CHECK-AMT      
                 PERFORM 8500-INSERT-NH        THRU  8500-EXIT          
            WHEN 'U'                                                    
                 MOVE WS-RETURN-CHECK-AMT   TO NH-RETURN-CHECK-AMT      
                 MOVE WS-SEND-NOTICE-CD     TO NH-SEND-NOTICE-CD        
                 MOVE WS-NSC-REMOVE-FL      TO NH-NSC-REMOVE-FL         
                 PERFORM 8050-UPDATE-NH        THRU  8050-EXIT          
            WHEN 'D'                                                    
                 PERFORM 8800-DELETE-NH        THRU  8800-EXIT          
           END-EVALUATE.                                                
                                                                        
           MOVE 'Y'                         TO WS-WAIVER-TRAN-FL.       
                                                                        
       5030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04325000
      * 5100-MNT-TRAN-HEAD.                                            *04330000
      ******************************************************************04340000
                                                                        
       5100-MNT-TRAN-HEAD.                                              
                                                                        
           MOVE 'F'                           TO MH-CODE-TRAN-TYPE.     
           MOVE WS-RESP-AREA-ID               TO MH-RESP-AREA-ID.       
           MOVE ZEROS                         TO MH-PREMISE-NO          
                                                 MH-CUSTOMER-NO.        
           MOVE WS-USER-ID                    TO MH-USER-ID.            
           MOVE WS-CURRENT-DATE               TO MH-DATE-TRANS.         
           MOVE WS-CURRENT-TIMESTAMP          TO MH-TRANS-HIST-SEQ-NO   
                                                 MI-TRANS-HIST-SEQ-NO   
           MOVE WS-TRANS-COMMENT-TEXT         TO MH-TRAN-COMMENT-TEXT.  
           MOVE WS-TRANS-COMMENT-LEN          TO MH-TRAN-COMMENT-LEN.   
           MOVE +1                            TO MI-TRAN-APPL-NO.       
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5110-MNT-TRAN-DTLS                                             *        
      ******************************************************************        
       5110-MNT-TRAN-DTLS.                                              
                                                                        
           IF WS-CASH-ONLY-TRAN-FL = 'Y'                                
              PERFORM 5200-MNT-CASH-ONLY          THRU 5200-EXIT        
           END-IF.                                                      
                                                                        
           IF WS-MAINT-TRAN-FL = 'Y'                                    
              PERFORM 5210-MNT-NSF-HIST           THRU 5210-EXIT        
           END-IF                                                       
                                                                        
           IF WS-WAIVER-TRAN-FL = 'Y'                                   
              PERFORM 5220-MNT-PENDING-WAIVER     THRU 5220-EXIT        
           END-IF.                                                      
                                                                        
       5110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5200-MNT-CASH-ONLY                                             *        
      ******************************************************************        
                                                                        
       5200-MNT-CASH-ONLY.                                              
                                                                        
           IF WS-CASH-ONLY-FL NOT = WS-PREV-CASH-ONLY-FL                
              MOVE 'CASH ONLY FL'            TO MI-COLUMN-DESC          
              MOVE +1                        TO MI-PRV-COLUMN-VALUE-LEN 
              MOVE WS-PREV-CASH-ONLY-FL      TO MI-PRV-COLUMN-VALUE-TEXT
              MOVE +1                        TO MI-CHG-COLUMN-VALUE-LEN 
              MOVE WS-CASH-ONLY-FL           TO MI-CHG-COLUMN-VALUE-TEXT
              MOVE SPACES                    TO MI-TABLE-ID             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                          TO MI-TRAN-APPL-NO         
           END-IF.                                                      
                                                                        
           IF WS-CASH-ONLY-COM-TEXT NOT = WS-PREV-CASH-ONLY-COMM-TEXT   
              MOVE 'CASH ONLY COM'           TO MI-COLUMN-DESC          
              MOVE +72                       TO MI-PRV-COLUMN-VALUE-LEN 
              MOVE WS-PREV-CASH-ONLY-COMM-TEXT                          
                                             TO MI-PRV-COLUMN-VALUE-TEXT
              MOVE +72                       TO MI-CHG-COLUMN-VALUE-LEN 
              MOVE WS-CASH-ONLY-COM-TEXT     TO MI-CHG-COLUMN-VALUE-TEXT
              MOVE SPACES                    TO MI-TABLE-ID             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                          TO MI-TRAN-APPL-NO         
           END-IF.                                                      
                                                                        
           IF WS-CSH-ONLY-EFFECT-DT NOT = WS-PREV-CSH-ONLY-EFFECT-DT    
              MOVE 'CASH ONLY EFFECT DT'     TO MI-COLUMN-DESC          
              MOVE +10                       TO MI-PRV-COLUMN-VALUE-LEN 
              MOVE WS-PREV-CSH-ONLY-EFFECT-DT                           
                                             TO MI-PRV-COLUMN-VALUE-TEXT
              MOVE +10                       TO MI-CHG-COLUMN-VALUE-LEN 
              MOVE WS-CSH-ONLY-EFFECT-DT     TO MI-CHG-COLUMN-VALUE-TEXT
              MOVE SPACES                    TO MI-TABLE-ID             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           END-IF.                                                      
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5210-MNT-NSF-HIST                                              *        
      ******************************************************************        
                                                                        
       5210-MNT-NSF-HIST.                                               
                                                                        
           IF WS-NSF-STATUS-CD NOT = WS-PREV-NSF-STATUS-CD              
              MOVE 'NSF_STATUS_CD'           TO MI-COLUMN-DESC          
              MOVE +1                        TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
              MOVE WS-NSF-STATUS-CD          TO MI-CHG-COLUMN-VALUE-TEXT
              MOVE WS-PREV-NSF-STATUS-CD     TO MI-PRV-COLUMN-VALUE-TEXT
              MOVE '53'                      TO MI-TABLE-ID             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                          TO MI-TRAN-APPL-NO         
           END-IF.                                                      
                                                                        
           IF WS-NSF-REASON-CD NOT = WS-PREV-NSF-REASON-CD              
              MOVE 'NSF_REASON_CD'           TO MI-COLUMN-DESC          
              MOVE +3                        TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
              MOVE WS-NSF-REASON-CD          TO MI-CHG-COLUMN-VALUE-TEXT
              MOVE WS-PREV-NSF-REASON-CD     TO MI-PRV-COLUMN-VALUE-TEXT
              MOVE '52'                      TO MI-TABLE-ID             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                          TO MI-TRAN-APPL-NO         
           END-IF.                                                      
                                                                        
           IF WS-NSF-COMMENTS-114 NOT = WS-PREV-NSF-COMM-114            
              MOVE 'COMMENTS'                TO MI-COLUMN-DESC          
              MOVE +75                       TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
              MOVE WS-NSF-COMMENTS-114       TO MI-CHG-COLUMN-VALUE-TEXT
              MOVE WS-PREV-NSF-COMM-114      TO MI-PRV-COLUMN-VALUE-TEXT
              MOVE SPACES                    TO MI-TABLE-ID             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           END-IF.                                                      
                                                                        
       5210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5220-MNT-PENDING-WAIVER.                                       *        
      ******************************************************************        
                                                                        
       5220-MNT-PENDING-WAIVER.                                         
                                                                        
           IF WS-ACTION-TYPE = 'I' OR 'D'                               
      * CHECK AMOUNT                                                            
              IF WS-ACTION-TYPE = 'I'                                   
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE +10                    TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE WS-RETURN-CHECK-AMT    TO WS-NH-RETURN-CHECK-AMT  
                 MOVE WS-NH-RETURN-CHECK-AMT-X                          
                                             TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +10                    TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE +8                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-RETURN-CHECK-AMT TO WS-NH-RETURN-CHECK-AMT
                 MOVE WS-NH-RETURN-CHECK-AMT-X                          
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE '*DELETE*'             TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'CHECK AMOUNT'            TO MI-COLUMN-DESC          
              MOVE SPACES                    TO MI-TABLE-ID             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                          TO MI-TRAN-APPL-NO         
                                                                        
      * WAIVE NOTICE                                                            
              IF WS-ACTION-TYPE = 'I'                                   
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE WS-WAIVE-NOTICE-FL     TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE +8                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETE*'             TO MI-CHG-COLUMN-VALUE-TEXT
                 MOVE WS-PREV-WAIVE-NOTICE-FL                           
                                             TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'WAIVE NOTICE'            TO MI-COLUMN-DESC          
              MOVE SPACES                    TO MI-TABLE-ID             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                          TO MI-TRAN-APPL-NO         
                                                                        
      * WAIVE CHARGE                                                            
              IF WS-ACTION-TYPE = 'I'                                   
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE WS-NSC-REMOVE-FL       TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE +8                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETE*'             TO MI-CHG-COLUMN-VALUE-TEXT
                 MOVE WS-PREV-NSC-REMOVE-FL  TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'WAIVE CHARGE'            TO MI-COLUMN-DESC          
              MOVE SPACES                    TO MI-TABLE-ID             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                          TO MI-TRAN-APPL-NO         
                                                                        
      * COMMENTS                                                                
              IF WS-ACTION-TYPE = 'I'                                   
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE +75                    TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE WS-NSF-COMMENTS-114    TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +75                    TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE +8                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-NSF-COMM-114   TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE '*DELETE*'             TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'COMMENTS'                TO MI-COLUMN-DESC          
              MOVE SPACES                    TO MI-TABLE-ID             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
           END-IF.                                                      
                                                                        
           IF WS-ACTION-TYPE = 'U'                                      
              IF WS-PREV-RETURN-CHECK-AMT NOT = WS-RETURN-CHECK-AMT     
                 MOVE +10                    TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-RETURN-CHECK-AMT                          
                                             TO WS-NH-RETURN-CHECK-AMT  
                 MOVE WS-NH-RETURN-CHECK-AMT-X                          
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE WS-RETURN-CHECK-AMT    TO WS-NH-RETURN-CHECK-AMT  
                 MOVE WS-NH-RETURN-CHECK-AMT-X                          
                                             TO MI-CHG-COLUMN-VALUE-TEXT
                 MOVE 'CHECK AMOUNT'         TO MI-COLUMN-DESC          
                 MOVE SPACES                 TO MI-TABLE-ID             
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                       TO MI-TRAN-APPL-NO         
              END-IF                                                    
                                                                        
              IF WS-PREV-WAIVE-NOTICE-FL NOT = WS-WAIVE-NOTICE-FL       
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-WAIVE-NOTICE-FL                           
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE WS-WAIVE-NOTICE-FL     TO MI-CHG-COLUMN-VALUE-TEXT
                 MOVE 'WAIVE NOTICE'         TO MI-COLUMN-DESC          
                 MOVE SPACES                 TO MI-TABLE-ID             
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                       TO MI-TRAN-APPL-NO         
              END-IF                                                    
                                                                        
              IF WS-PREV-NSC-REMOVE-FL NOT = WS-NSC-REMOVE-FL           
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-NSC-REMOVE-FL  TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE WS-NSC-REMOVE-FL       TO MI-CHG-COLUMN-VALUE-TEXT
                 MOVE 'WAIVE CHARGE'         TO MI-COLUMN-DESC          
                 MOVE SPACES                 TO MI-TABLE-ID             
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                       TO MI-TRAN-APPL-NO         
              END-IF                                                    
                                                                        
              IF WS-PREV-NSF-COMM-114 NOT = WS-NSF-COMMENTS-114         
                 MOVE +75                    TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-PREV-NSF-COMM-114   TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE WS-NSF-COMMENTS-114    TO MI-CHG-COLUMN-VALUE-TEXT
                 MOVE 'COMMENTS'             TO MI-COLUMN-DESC          
                 MOVE SPACES                 TO MI-TABLE-ID             
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6530-LOAD-MNT-TRANS-HIST                                       *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 7010-SELECT-ACCOUNT                                            *        
      ******************************************************************        
                                                                        
       7010-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT CODES_DATA_PRESENT                                 
                INTO :AT-CODES-DATA-PRESENT                             
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODES_DATA_PRESENT                                         
MFA-TR*         INTO :AT-CODES-DATA-PRESENT                                     
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO S-RETURN-CODE               
                                            WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7010'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7020-CHECK-FUTURE-H                                            *        
      ******************************************************************        
                                                                        
       7020-CHECK-FUTURE-H.                                             
                                                                        
           MOVE WS-ACCOUNT-NUM           TO CL-ACCOUNT-NO.              
           MOVE WS-H                     TO CL-CODE-NOTICE-TYPE         
                                                                        
           EXEC SQL                                                     
               SELECT 'Y'                                               
                INTO  :WS-FUTURE-H-EXIST                                
                FROM  CSS_CRED_COLL WITH(READUNCOMMITTED)                       
                WHERE ACCOUNT_NO       = :CL-ACCOUNT-NO                 
                  AND CODE_NOTICE_TYPE = :CL-CODE-NOTICE-TYPE           
                  AND DATE_CREDIT_ACTION > CAST(SYSDATETIMEOFFSET() 
           AS DATE)                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*         INTO  :WS-FUTURE-H-EXIST                                        
MFA-TR*         FROM  CSS_CRED_COLL                                             
MFA-TR*         WHERE ACCOUNT_NO       = :CL-ACCOUNT-NO                         
MFA-TR*           AND CODE_NOTICE_TYPE = :CL-CODE-NOTICE-TYPE                   
MFA-TR*           AND DATE_CREDIT_ACTION > CURRENT DATE                         
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7020                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO S-RETURN-CODE               
                                            WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
              MOVE ZEROS                 TO S-RETURN-CODE               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7020'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CRED_COLL'       TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'CODE_NOTICE_TYPE'    TO TABLE-ELEMENT-2             
              MOVE CL-CODE-NOTICE-TYPE   TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7030-CHECK-FUTURE-N                                         *         
      *****************************************************************         
                                                                        
       7030-CHECK-FUTURE-N.                                             
                                                                        
           MOVE WS-ACCOUNT-NUM           TO CL-ACCOUNT-NO.              
           MOVE WS-N                     TO CL-CODE-NOTICE-TYPE         
           MOVE 90107                    TO CL-CODE-MESSAGE-TYPE        
                                                                        
           EXEC SQL                                                     
               SELECT DATE_NOTICE_MAIL                                  
                INTO  :CL-DATE-NOTICE-MAIL :WS-DATE-NOTICE-MAIL-NULL     
                FROM  CSS_CRED_COLL WITH(READUNCOMMITTED)                       
                WHERE ACCOUNT_NO       = :CL-ACCOUNT-NO                 
                  AND CODE_NOTICE_TYPE = :CL-CODE-NOTICE-TYPE           
                  AND CODE_MESSAGE_TYPE= :CL-CODE-MESSAGE-TYPE          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DATE_NOTICE_MAIL                                          
MFA-TR*         INTO  :CL-DATE-NOTICE-MAIL:WS-DATE-NOTICE-MAIL-NULL             
MFA-TR*         FROM  CSS_CRED_COLL                                             
MFA-TR*         WHERE ACCOUNT_NO       = :CL-ACCOUNT-NO                         
MFA-TR*           AND CODE_NOTICE_TYPE = :CL-CODE-NOTICE-TYPE                   
MFA-TR*           AND CODE_MESSAGE_TYPE= :CL-CODE-MESSAGE-TYPE                  
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7030                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO S-RETURN-CODE               
                                            WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              MOVE WS-YES                TO WS-FUTURE-N-EXIST           
              IF WS-DATE-NOTICE-MAIL-NULL EQUAL -1                      
                 MOVE SPACES             TO WS-DATE-NOTICE-MAIL         
              ELSE                                                      
                 MOVE CL-DATE-NOTICE-MAIL   TO WS-DATE-NOTICE-MAIL      
              END-IF                                                    
           ELSE                                                         
              IF SQLCODE EQUAL NOT-FOUND                                
                 MOVE ZEROS              TO S-RETURN-CODE               
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '7030'             TO ACTIVE-PARAGRAPH            
                 MOVE 'SELECT'           TO ABEND-FUNCTION              
                 MOVE 'CSS_CRED_COLL'    TO TABLE-1                     
                 MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1             
                 MOVE WS-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1           
                 MOVE 'CODE_NOTICE_TYPE' TO TABLE-ELEMENT-2             
                 MOVE CL-CODE-NOTICE-TYPE   TO HOSTVAR-ELEMENT-2        
                 MOVE 'CODE_MESSAGE_TYPE'   TO TABLE-ELEMENT-3          
                 MOVE CL-CODE-MESSAGE-TYPE  TO HOSTVAR-ELEMENT-3        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7040-CHECK-FUTURE-C-F.                                      *         
      *****************************************************************         
                                                                        
       7040-CHECK-FUTURE-C-F.                                           
                                                                        
           MOVE WS-ACCOUNT-NUM           TO CL-ACCOUNT-NO.              
                                                                        
           EXEC SQL                                                     
               SELECT 'Y'                                               
                INTO  :WS-FUTURE-C-F-EXIST                              
                FROM  CSS_CRED_COLL WITH(READUNCOMMITTED)                       
                WHERE ACCOUNT_NO       = :CL-ACCOUNT-NO                 
                  AND CODE_NOTICE_TYPE = :CL-CODE-NOTICE-TYPE           
                  AND DATE_NOTICE_MAIL = IIF(TRY_CONVERT(DATE, 
                                                   :WS-DATE-NOTICE-MAIL
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-NOTICE-MAIL
              ) <> 0) OR (LEN(:WS-DATE-NOTICE-MAIL
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-NOTICE-MAIL
              ), CONVERT(DATE, :WS-DATE-NOTICE-MAIL) )           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*         INTO  :WS-FUTURE-C-F-EXIST                                      
MFA-TR*         FROM  CSS_CRED_COLL                                             
MFA-TR*         WHERE ACCOUNT_NO       = :CL-ACCOUNT-NO                         
MFA-TR*           AND CODE_NOTICE_TYPE = :CL-CODE-NOTICE-TYPE                   
MFA-TR*           AND DATE_NOTICE_MAIL = :WS-DATE-NOTICE-MAIL                   
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7040                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO S-RETURN-CODE               
                                            WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
              MOVE ZEROS                 TO S-RETURN-CODE               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7040'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CRED_COLL'       TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'CODE-NOTICE-TYPE'    TO TABLE-ELEMENT-2             
              MOVE CL-CODE-NOTICE-TYPE   TO HOSTVAR-ELEMENT-2           
              MOVE 'DATE_NOTICE_MAIL'    TO TABLE-ELEMENT-3             
              MOVE WS-DATE-NOTICE-MAIL   TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7050-CHECK-FUTURE-D-G                                       *         
      *****************************************************************         
                                                                        
       7050-CHECK-FUTURE-D-G.                                           
                                                                        
           MOVE WS-ACCOUNT-NUM           TO CL-ACCOUNT-NO.              
                                                                        
           EXEC SQL                                                     
               SELECT 'Y'                                               
                INTO  :WS-FUTURE-D-G-EXIST                              
                FROM  CSS_CRED_COLL WITH(READUNCOMMITTED)                       
                WHERE ACCOUNT_NO       = :CL-ACCOUNT-NO                 
                  AND CODE_NOTICE_TYPE = :CL-CODE-NOTICE-TYPE           
                  AND DATE_CREDIT_ACTION > CAST(SYSDATETIMEOFFSET() 
           AS DATE)                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*         INTO  :WS-FUTURE-D-G-EXIST                                      
MFA-TR*         FROM  CSS_CRED_COLL                                             
MFA-TR*         WHERE ACCOUNT_NO       = :CL-ACCOUNT-NO                         
MFA-TR*           AND CODE_NOTICE_TYPE = :CL-CODE-NOTICE-TYPE                   
MFA-TR*           AND DATE_CREDIT_ACTION > CURRENT DATE                         
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO S-RETURN-CODE               
                                            WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
              MOVE ZEROS                 TO S-RETURN-CODE               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7050'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CRED_COLL'       TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'CODE-NOTICE-TYPE'    TO TABLE-ELEMENT-2             
              MOVE CL-CODE-NOTICE-TYPE   TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05341000
      * 7060-SELECT-PREV-NSF-HIST                                      *05342000
      ******************************************************************05343000
                                                                        
       7060-SELECT-PREV-NSF-HIST.                                       
                                                                        
           EXEC SQL                                                     
              SELECT NSC_REMOVE_FL                                      
                    ,NSF_STATUS_CD                                      
                    ,NSF_REASON_CD                                      
                    ,NSF_TYPE_CD                                        
                    ,RETURN_CHECK_AMT                                   
                    ,SEND_NOTICE_CD                                     
                    ,COMMENTS                                           
                INTO :WS-PREV-NSC-REMOVE-FL                             
                    ,:WS-PREV-NSF-STATUS-CD                             
                    ,:WS-PREV-NSF-REASON-CD                             
                    ,:WS-PREV-NSF-TYPE-CD                               
                    ,:WS-PREV-RETURN-CHECK-AMT                          
                    ,:WS-PREV-SEND-NOTICE-CD                            
                    ,:WS-PREV-NSF-COMMENTS                              
                FROM CSS_NSF_HIST WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO   = :NH-ACCOUNT-NO                      
                 AND NSF_TIMESTMP = CIS.CHAR2TIMESTAMP(:NH-NSF-TIMESTMP)        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     05345000
MFA-TR*       SELECT NSC_REMOVE_FL                                      05346000
MFA-TR*             ,NSF_STATUS_CD                                              
MFA-TR*             ,NSF_REASON_CD                                              
MFA-TR*             ,NSF_TYPE_CD                                                
MFA-TR*             ,RETURN_CHECK_AMT                                           
MFA-TR*             ,SEND_NOTICE_CD                                             
MFA-TR*             ,COMMENTS                                                   
MFA-TR*         INTO :WS-PREV-NSC-REMOVE-FL                             05349200
MFA-TR*             ,:WS-PREV-NSF-STATUS-CD                                     
MFA-TR*             ,:WS-PREV-NSF-REASON-CD                                     
MFA-TR*             ,:WS-PREV-NSF-TYPE-CD                                       
MFA-TR*             ,:WS-PREV-RETURN-CHECK-AMT                                  
MFA-TR*             ,:WS-PREV-SEND-NOTICE-CD                                    
MFA-TR*             ,:WS-PREV-NSF-COMMENTS                                      
MFA-TR*         FROM CSS_NSF_HIST                                       05349400
MFA-TR*        WHERE ACCOUNT_NO   = :NH-ACCOUNT-NO                      05349500
MFA-TR*          AND NSF_TIMESTMP = :NH-NSF-TIMESTMP                    05349700
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7060                                                       
MFA-TR*    END-EXEC.                                                    05349800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE '7060'                TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_NSF_HIST'        TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'NSF_TIMESTMP'        TO TABLE-ELEMENT-2             
              MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              MOVE NH-NSF-TIMESTMP       TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7070-GET-CURRENT-DATE-TS                                       *        
      ******************************************************************        
                                                                        
       7070-GET-CURRENT-DATE-TS.                                        
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                    
MFA-TR*           ,:WS-CURRENT-DATE      = CURRENT DATE                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE.        
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
                    MOVE '7070'                TO ACTIVE-PARAGRAPH      
                    MOVE 'SET'                 TO ABEND-FUNCTION        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  04690000
      * 7080-SELECT-CRED-PROFILE                                     *  04700000
      ****************************************************************  04710000
                                                                        
       7080-SELECT-CRED-PROFILE.                                        
                                                                        
           EXEC SQL                                                     
             SELECT CASH_ONLY_FL                                        
                   ,CASH_ONLY_COMMENTS                                  
                   ,CIS.CHAR2$DATE(CSH_ONLY_EFFECT_DT,'USA')                    
               INTO :CZ-CASH-ONLY-FL                                    
                   ,:CZ-CASH-ONLY-COMMENTS                              
                   ,:CZ-CSH-ONLY-EFFECT-DT :WS-CSH-ONLY-EFF-DT-NULL      
              FROM CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                     
             WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     04730000
MFA-TR*      SELECT CASH_ONLY_FL                                        04750000
MFA-TR*            ,CASH_ONLY_COMMENTS                                  04760000
MFA-TR*            ,CHAR(CSH_ONLY_EFFECT_DT,USA)                        04771000
MFA-TR*        INTO :CZ-CASH-ONLY-FL                                    04780000
MFA-TR*            ,:CZ-CASH-ONLY-COMMENTS                              04790000
MFA-TR*            ,:CZ-CSH-ONLY-EFFECT-DT:WS-CSH-ONLY-EFF-DT-NULL      04800000
MFA-TR*       FROM CSS_CREDIT_PROFILE                                   04810000
MFA-TR*      WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                          04820000
MFA-TR*       WITH UR                                                           
MFA-TR*     QUERYNO 7080                                                        
MFA-TR*    END-EXEC.                                                    04830000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-CSH-ONLY-EFF-DT-NULL = -1                           
                 MOVE SPACES          TO CZ-CSH-ONLY-EFFECT-DT          
                 MOVE ZEROES          TO WS-CSH-ONLY-EFF-DT-NULL        
              END-IF                                                    
              IF CZ-CASH-ONLY-COMMENTS = LOW-VALUES                     
                 MOVE SPACES          TO CZ-CASH-ONLY-COMMENTS-TEXT     
              END-IF                                                    
              IF CZ-CASH-ONLY-FL = SPACES                               
                 MOVE 'N'             TO CZ-CASH-ONLY-FL                
              END-IF                                                    
           ELSE                                                         
              MOVE '7080'             TO ACTIVE-PARAGRAPH               
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE 'SELECT'           TO ABEND-FUNCTION                 
              MOVE SPACES             TO ABEND-SQL-PREDICATES           
                                         ABEND-TABLES                   
              MOVE 'CSS_CREDIT_PROFILE'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1                
              MOVE CZ-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1              
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  05040000
      * 8010-UPDATE-CZ.                                             *   05050000
      ****************************************************************  05060000
                                                                        
       8010-UPDATE-CZ.                                                  
                                                                        
           IF CZ-CSH-ONLY-EFFECT-DT = SPACES                            
              MOVE -1                    TO WS-CSH-ONLY-EFF-DT-NULL     
           ELSE                                                         
              MOVE 0                     TO WS-CSH-ONLY-EFF-DT-NULL     
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_CREDIT_PROFILE                                  
                SET CASH_ONLY_FL       = :CZ-CASH-ONLY-FL,              
                    CASH_ONLY_COMMENTS = :CZ-CASH-ONLY-COMMENTS,        
                    CSH_ONLY_EFFECT_DT = IIF(TRY_CONVERT(DATE, 
                                                :CZ-CSH-ONLY-EFFECT-DT 
                                               :WS-CSH-ONLY-EFF-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :CZ-CSH-ONLY-EFFECT-DT 
                                               :WS-CSH-ONLY-EFF-DT-NULL
              ) <> 0) OR (LEN(:CZ-CSH-ONLY-EFFECT-DT 
                                               :WS-CSH-ONLY-EFF-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:CZ-CSH-ONLY-EFFECT-DT 
                                               :WS-CSH-ONLY-EFF-DT-NULL
              ), CONVERT(DATE, :CZ-CSH-ONLY-EFFECT-DT 
                                               :WS-CSH-ONLY-EFF-DT-NULL
              ) )       
              WHERE ACCOUNT_NO         = :CZ-ACCOUNT-NO                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     05100000
MFA-TR*      UPDATE CSS_CREDIT_PROFILE                                  05110000
MFA-TR*         SET CASH_ONLY_FL       = :CZ-CASH-ONLY-FL,              05120000
MFA-TR*             CASH_ONLY_COMMENTS = :CZ-CASH-ONLY-COMMENTS,        05130000
MFA-TR*             CSH_ONLY_EFFECT_DT = :CZ-CSH-ONLY-EFFECT-DT         05140000
MFA-TR*                                  :WS-CSH-ONLY-EFF-DT-NULL       05150000
MFA-TR*       WHERE ACCOUNT_NO         = :CZ-ACCOUNT-NO                 05160000
MFA-TR*    END-EXEC.                                                    05170000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE '8010'                TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CREDIT_PROFILE'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE CZ-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  05351700
      * 8020-UPDATE-NSC-REMOVE-NH                                   *   05351800
      ****************************************************************  05351900
                                                                        
       8020-UPDATE-NSC-REMOVE-NH.                                       
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_NSF_HIST                                        
                SET NSC_REMOVE_FL = :NH-NSC-REMOVE-FL                   
              WHERE ACCOUNT_NO    = :NH-ACCOUNT-NO                      
                AND NSF_TIMESTMP  = CIS.CHAR2TIMESTAMP(:NH-NSF-TIMESTMP)        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     05352300
MFA-TR*      UPDATE CSS_NSF_HIST                                        05352400
MFA-TR*         SET NSC_REMOVE_FL = :NH-NSC-REMOVE-FL                   05352500
MFA-TR*       WHERE ACCOUNT_NO    = :NH-ACCOUNT-NO                      05352900
MFA-TR*         AND NSF_TIMESTMP  = :NH-NSF-TIMESTMP                    05353100
MFA-TR*    END-EXEC.                                                    05353200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '8020'                TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_NSF_HIST'        TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'NSF_TIMESTMP'        TO TABLE-ELEMENT-2             
              MOVE NH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE NH-NSF-TIMESTMP       TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 8030-UPD-NSF-STATUS-REASON                                  *           
      ***************************************************************           
                                                                        
       8030-UPD-NSF-STATUS-REASON.                                      
                                                                        
           EXEC SQL                                                     
              UPDATE  CSS_NSF_HIST                                      
                 SET NSF_STATUS_CD = :WS-NSF-STATUS-CD                  
                    ,NSF_REASON_CD = :WS-NSF-REASON-CD                  
                    ,COMMENTS      = :NH-COMMENTS                       
               WHERE ACCOUNT_NO    = :NH-ACCOUNT-NO                     
                 AND NSF_TIMESTMP  = CIS.CHAR2TIMESTAMP(:NH-NSF-TIMESTMP
              )                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     04131095
MFA-TR*       UPDATE  CSS_NSF_HIST                                      15690002
MFA-TR*          SET NSF_STATUS_CD = :WS-NSF-STATUS-CD                          
MFA-TR*             ,NSF_REASON_CD = :WS-NSF-REASON-CD                          
MFA-TR*             ,COMMENTS      = :NH-COMMENTS                       05352500
MFA-TR*        WHERE ACCOUNT_NO    = :NH-ACCOUNT-NO                     15740002
MFA-TR*          AND NSF_TIMESTMP  = :NH-NSF-TIMESTMP                   15750003
MFA-TR*    END-EXEC.                                                    04131595

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                           S-RETURN-CODE.                               
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE '8030'               TO ACTIVE-PARAGRAPH            
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE 'UPDATE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSS_NSF_HIST'       TO TABLE-1                     
               MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
               MOVE 'NSF_TIMESTMP'       TO TABLE-ELEMENT-2             
               MOVE NH-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
               MOVE NH-NSF-TIMESTMP      TO HOSTVAR-ELEMENT-2           
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8050-UPDATE-NH                                                 *        
      ******************************************************************        
                                                                        
       8050-UPDATE-NH.                                                  
                                                                        
            EXEC SQL                                                    
                 UPDATE CSS_NSF_HIST                                    
                    SET  COMMENTS         =  :NH-COMMENTS,              
                         RETURN_CHECK_AMT =  :NH-RETURN-CHECK-AMT,      
                         SEND_NOTICE_CD   =  :NH-SEND-NOTICE-CD,        
                         NSC_REMOVE_FL    =  :NH-NSC-REMOVE-FL          
                  WHERE  ACCOUNT_NO       =  :NH-ACCOUNT-NO             
                   AND   NSF_TIMESTMP     =  CIS.CHAR2TIMESTAMP(
                                                       :NH-NSF-TIMESTMP
              )           
                   AND   NSF_STATUS_CD    =  :NH-NSF-STATUS-CD          
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*          UPDATE CSS_NSF_HIST                                            
MFA-TR*             SET  COMMENTS         =  :NH-COMMENTS,                      
MFA-TR*                  RETURN_CHECK_AMT =  :NH-RETURN-CHECK-AMT,              
MFA-TR*                  SEND_NOTICE_CD   =  :NH-SEND-NOTICE-CD,                
MFA-TR*                  NSC_REMOVE_FL    =  :NH-NSC-REMOVE-FL                  
MFA-TR*           WHERE  ACCOUNT_NO       =  :NH-ACCOUNT-NO                     
MFA-TR*            AND   NSF_TIMESTMP     =  :NH-NSF-TIMESTMP                   
MFA-TR*            AND   NSF_STATUS_CD    =  :NH-NSF-STATUS-CD                  
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8050'               TO ACTIVE-PARAGRAPH            
               MOVE 'UPDATE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSS_NSF_HIST'       TO TABLE-1                     
               MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
               MOVE 'NSF_TIMESTMP'       TO TABLE-ELEMENT-2             
               MOVE NH-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
               MOVE NH-NSF-TIMESTMP      TO HOSTVAR-ELEMENT-2           
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
            END-IF.                                                     
                                                                        
       8050-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8500-INSERT-NH                                                 *        
      ******************************************************************        
                                                                        
       8500-INSERT-NH.                                                  
                                                                        
            EXEC SQL                                                    
                 INSERT INTO CSS_NSF_HIST                               
                        (ACCOUNT_NO,                                    
                         BANK_ID,                                       
                         CHECK_NONUTIL_AMT,                             
                         CHECK_UTIL_AMT,                                
                         COMMENTS,                                      
                         DATE_TRAN,                                     
                         DRAWN_BY_NM,                                   
                         NSC_REMOVE_FL,                                 
                         NSF_CHARGE_AMT,                                
                         NSF_ORIG_DT,                                   
                         NSF_REASON_CD,                                 
                         NSF_STATUS_CD,                                 
                         NSF_TIMESTMP,                                  
                         NSF_TYPE_CD,                                   
                         RETURN_CHECK_AMT,                              
                         SEND_NOTICE_CD,                                
                         TRANS_HIST_SEQ_NO,                             
                         WAIVER_REASON_CD)                              
                  VALUES                                                
                       (:NH-ACCOUNT-NO,                                 
                        :NH-BANK-ID,                                    
                        :NH-CHECK-NONUTIL-AMT,                          
                        :NH-CHECK-UTIL-AMT,                             
                        :NH-COMMENTS,                                   
                        IIF(TRY_CONVERT(DATE, :NH-DATE-TRAN
              ) IS NULL OR (PATINDEX('%.%', :NH-DATE-TRAN
              ) <> 0) OR (LEN(:NH-DATE-TRAN) <> 10), CIS.CHAR2DATE(
                                                          :NH-DATE-TRAN
              ), CONVERT(DATE, :NH-DATE-TRAN) ),                               
                        :NH-DRAWN-BY-NM,                                
                        :NH-NSC-REMOVE-FL,                              
                        :NH-NSF-CHARGE-AMT,                             
                        IIF(TRY_CONVERT(DATE, :NH-NSF-ORIG-DT
              ) IS NULL OR (PATINDEX('%.%', :NH-NSF-ORIG-DT
              ) <> 0) OR (LEN(:NH-NSF-ORIG-DT) <> 10), CIS.CHAR2DATE(
                                                        :NH-NSF-ORIG-DT
              ), CONVERT(DATE, :NH-NSF-ORIG-DT) ),                             
                        :NH-NSF-REASON-CD,                              
                        :NH-NSF-STATUS-CD,                              
                        CIS.CHAR2TIMESTAMP(:NH-NSF-TIMESTMP),                   
                        :NH-NSF-TYPE-CD,                                
                        :NH-RETURN-CHECK-AMT,                           
                        :NH-SEND-NOTICE-CD,                             
                        CIS.CHAR2TIMESTAMP(:NH-TRANS-HIST-SEQ-NO),              
                        :NH-WAIVER-REASON-CD)                           
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO CSS_NSF_HIST                                       
MFA-TR*                 (ACCOUNT_NO,                                            
MFA-TR*                  BANK_ID,                                               
MFA-TR*                  CHECK_NONUTIL_AMT,                                     
MFA-TR*                  CHECK_UTIL_AMT,                                        
MFA-TR*                  COMMENTS,                                              
MFA-TR*                  DATE_TRAN,                                             
MFA-TR*                  DRAWN_BY_NM,                                           
MFA-TR*                  NSC_REMOVE_FL,                                         
MFA-TR*                  NSF_CHARGE_AMT,                                        
MFA-TR*                  NSF_ORIG_DT,                                           
MFA-TR*                  NSF_REASON_CD,                                         
MFA-TR*                  NSF_STATUS_CD,                                         
MFA-TR*                  NSF_TIMESTMP,                                          
MFA-TR*                  NSF_TYPE_CD,                                           
MFA-TR*                  RETURN_CHECK_AMT,                                      
MFA-TR*                  SEND_NOTICE_CD,                                        
MFA-TR*                  TRANS_HIST_SEQ_NO,                                     
MFA-TR*                  WAIVER_REASON_CD)                                      
MFA-TR*           VALUES                                                        
MFA-TR*                (:NH-ACCOUNT-NO,                                         
MFA-TR*                 :NH-BANK-ID,                                            
MFA-TR*                 :NH-CHECK-NONUTIL-AMT,                                  
MFA-TR*                 :NH-CHECK-UTIL-AMT,                                     
MFA-TR*                 :NH-COMMENTS,                                           
MFA-TR*                 :NH-DATE-TRAN,                                          
MFA-TR*                 :NH-DRAWN-BY-NM,                                        
MFA-TR*                 :NH-NSC-REMOVE-FL,                                      
MFA-TR*                 :NH-NSF-CHARGE-AMT,                                     
MFA-TR*                 :NH-NSF-ORIG-DT,                                        
MFA-TR*                 :NH-NSF-REASON-CD,                                      
MFA-TR*                 :NH-NSF-STATUS-CD,                                      
MFA-TR*                 :NH-NSF-TIMESTMP,                                       
MFA-TR*                 :NH-NSF-TYPE-CD,                                        
MFA-TR*                 :NH-RETURN-CHECK-AMT,                                   
MFA-TR*                 :NH-SEND-NOTICE-CD,                                     
MFA-TR*                 :NH-TRANS-HIST-SEQ-NO,                                  
MFA-TR*                 :NH-WAIVER-REASON-CD)                                   
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME         TO   ABEND-PROGRAM             
               MOVE '8500'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSS_NSF_HIST'       TO TABLE-1                     
               MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
               MOVE 'DATE_TRAN'          TO TABLE-ELEMENT-2             
               MOVE 'NSC_REMOVE_FL'      TO TABLE-ELEMENT-3             
               MOVE NH-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
               MOVE NH-DATE-TRAN         TO HOSTVAR-ELEMENT-2           
               MOVE NH-NSC-REMOVE-FL     TO HOSTVAR-ELEMENT-3           
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
            END-IF.                                                     
                                                                        
       8500-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8800-DELETE-NH                                                 *        
      ******************************************************************        
                                                                        
       8800-DELETE-NH.                                                  
                                                                        
            EXEC SQL                                                    
                 DELETE FROM CSS_NSF_HIST                               
                  WHERE ACCOUNT_NO       =  :NH-ACCOUNT-NO              
                    AND NSF_TIMESTMP     =  CIS.CHAR2TIMESTAMP(
                                                       :NH-NSF-TIMESTMP
              )            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*          DELETE FROM CSS_NSF_HIST                                       
MFA-TR*           WHERE ACCOUNT_NO       =  :NH-ACCOUNT-NO                      
MFA-TR*             AND NSF_TIMESTMP     =  :NH-NSF-TIMESTMP                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE         
                                          S-RETURN-CODE.                
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE '8800'             TO ACTIVE-PARAGRAPH              
               MOVE 'DELETE'           TO ABEND-FUNCTION                
               MOVE SPACES             TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
               MOVE 'CSS_NSF_HIST'     TO TABLE-1                       
               MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1               
               MOVE 'NSF_TIMESTMP'     TO TABLE-ELEMENT-2               
               MOVE NH-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1             
               MOVE NH-NSF-TIMESTMP    TO HOSTVAR-ELEMENT-2             
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
            END-IF.                                                     
                                                                        
       8800-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8900-SEND-DONE                                                 *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00331                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT.            
           PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT.            
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900 - JOURNALING / ERROR HANDLING INCLUDE                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
