       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04898.                                         
COB303 DATE-WRITTEN.     SEP 18, 2013.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00070000
      ******************************************************************00150000
      *                 P R O G R A M  S U M M A R Y                   *00160000
      *                                                                *00170000
      *                                                                *        
      *                                                                *        
      ******************************************************************00220000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE       INITIALS   COMMENTS                              *00260000
      *  ------------------------------------------------------------  *00270000
A05459*  02/19/16    SV95326  INITIAL VERSION.(ACT001)                 *00280000
      ******************************************************************00300000
      ******************************************************************00310000
      *                                                                *00320000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00330000
      *                                                                *00340000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00350000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00360000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00370000
      *  3000 - 4999  NOT USED                                         *00380000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00390000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00400000
      *  7000 - 7999  INPUT MODULES                                    *00410000
      *  8000 - 8999  OUTPUT MODULES                                   *00420000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00430000
      *                                                                *00440000
      ******************************************************************00450000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04898'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04898 STARTS HERE'.                  
                                                                        
      ******************************************************************00540000
      *    DB2 INCLUDES                                                *00550000
      ******************************************************************00560000
                                                                        
           EXEC SQL                                                     00580000
              INCLUDE SQLCA                                             00590000
           END-EXEC.                                                    00600000
                                                                        
      *-------< INCLUDE CSS_BILLING_DET BG  >                           00620000
                                                                        
           EXEC SQL                                                     00630000
              INCLUDE TBBLLDET                                          00640000
           END-EXEC.                                                    00650000
                                                                        
      *-------< INCLUDE CSS_BILLING_HDR BI >                            00620000
                                                                        
           EXEC SQL                                                     00630000
              INCLUDE TBBLLHDR                                          00640000
           END-EXEC.                                                    00650000
                                                                        
      ******************************************************************00720000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00730000
      ******************************************************************00740000
                                                                        
           EXEC SQL                                                     00760000
              INCLUDE CWS00013                                          00770000
           END-EXEC.                                                    00780000
                                                                        
      ******************************************************************00800000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00810000
      ******************************************************************00820000
                                                                        
           COPY CCA00001.                                               00860000
           COPY CWS00027.                                               00880000
           COPY CWS00303.                                               00890000
                                                                        
      ******************************************************************00950000
      *    WORK AREAS                                                  *00960000
      ******************************************************************00970000
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
                                                                        
       01  GENERAL-WORKING-STORAGE.                                     
           05 PROGRAM-NAME               PIC X(08) VALUE 'CSR04898'.    
           05 WS-ACCOUNT-NO              PIC X(13) VALUE SPACES.        
           05 WS-ACCOUNT-NUM REDEFINES WS-ACCOUNT-NO                    
                                         PIC S9(13).                    
           05 WS-BTU-FACTOR.                                            
              10 WS-BTU-FACTOR-INT       PIC 9(02).                     
              10 WS-BTU-FACTOR-DEC       PIC 9(03).                     
           05 WS-DECIMAL-2V3-NUM         PIC S9(5).                     
           05 WS-DECIMAL-2V3             REDEFINES WS-DECIMAL-2V3-NUM   
                                         PIC S9(2)V9(3).                
                                                                        
       01 SWITCHES.                                                     
          05  SEND-DONE-SW               PIC X(01) VALUE 'Y'.           
              88 SEND-DONE-ERROR                   VALUE 'N'.           
              88 SEND-DONE-OK                      VALUE 'Y'.           
                                                                        
      *                                                                         
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       01  PARM-ACCOUNT-NO               PIC X(13).                     
       01  PARM-BTU-FACTOR               PIC X(06).                     
                                                                        
       PROCEDURE DIVISION USING  PARM-ACCOUNT-NO                        
                                ,PARM-BTU-FACTOR.                       
                                                                        
      ******************************************************************02030000
      * 0000-MAINLINE                                                  *02040000
      *     CALLS 0100-INITIALIZE                                      *02050000
      *           1000-PROCESS-INPUT                                   *02060000
      *           2000-PROCESS-OUTPUT                                  *02070000
      *           9999-END-PROGRAM                                     *02080000
      *                                                                *02090000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02100000
      ******************************************************************02110000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           MOVE '0000'                 TO ACTIVE-PARAGRAPH.             
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02230000
      * 0100-INITIALIZE                                                *02240000
      *     CALLS 9000-SEND-ERROR-RESULT                               *02250000
      *           9900-SQL-ERROR-ROUTINE                               *02260000
      *                                                                *02270000
      *     CALLED FROM 0000-MAINLINE                                  *02280000
      *                                                                *02290000
      ******************************************************************02350000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                  TO ACTIVE-PARAGRAPH.            
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
                DECLARE C1 CURSOR  FOR                       
                SELECT                                                  
                     :S-RETURN-CODE         AS RETURN_CODE              
                FROM                                                    
                     CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*              :S-RETURN-CODE         AS RETURN_CODE                      
MFA-TR*         FROM                                                            
MFA-TR*              SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************02640000
      * 1000-PROCESS-INPUT                                             *02650000
      *     CALLS 1100-RECEIVE-PARMS                                   *02660000
      *                                                                *02670000
      *     CALLED FROM 0000-MAINLINE                                  *02680000
      *                                                                *02690000
      *     RECEIVE PARMS                                              *02700000
      ******************************************************************02710000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                  TO ACTIVE-PARAGRAPH.            
                                                                        
           MOVE PARM-ACCOUNT-NO         TO WS-ACCOUNT-NO.               
           MOVE WS-ACCOUNT-NUM          TO BI-ACCOUNT-NO.               
           MOVE PARM-BTU-FACTOR(1:2)    TO WS-BTU-FACTOR-INT.           
           MOVE PARM-BTU-FACTOR(4:3)    TO WS-BTU-FACTOR-DEC.           
           MOVE WS-BTU-FACTOR           TO WS-DECIMAL-2V3-NUM.          
           MOVE WS-DECIMAL-2V3          TO BG-BTU-FACTOR.               
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03210000
      * 2000-PROCESS-OUTPUT.                                           *03220000
      *     CALLS 2100-DESCRIBE-RESULT                                 *03230000
      *           2300-BUILD-RESULT                                    *03240000
      *           2800-TRANSFER-HISTORY                                *        
      *                                                                *03250000
      *     CALLED FROM 0000-MAINLINE                                  *03260000
      *                                                                *03270000
      *     SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS,    *03280000
      *      AND SENDS THEM BACK                                       *03290000
      ******************************************************************03300000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                       TO ACTIVE-PARAGRAPH.       
           PERFORM 7100-GET-BG-DETAILS       THRU 7100-EXIT.            
           PERFORM 8000-UPDATE-BTU-FACTOR-BG THRU 8100-EXIT.            
           PERFORM 8100-SEND-RESULT      THRU 8100-EXIT.                
           PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT.               
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  2000A-MOVE-RESULT.                                            *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE RS-RETURN-CODE        TO S-RETURN-CODE.                 
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-GET-BG-DETAILS.                                           *        
      ******************************************************************        
                                                                        
       7100-GET-BG-DETAILS.                                             
                                                                        
           EXEC SQL                                                     
            SELECT BG.ACCOUNT_NO                                        
                  ,BG.BILL_NO                                           
                  ,BG.CODE_UTIL_TYPE                                    
                  ,BG.IC_NO                                             
                  ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BG.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                                
             INTO :BG-ACCOUNT-NO                                        
                 ,:BG-BILL-NO                                           
                 ,:BG-CODE-UTIL-TYPE                                    
                 ,:BG-IC-NO                                             
                 ,:BG-BILL-ITEM-TIMESTMP                                
             FROM CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                      
                 ,CSS_BILLING_DET BG WITH(READUNCOMMITTED)                      
            WHERE BI.DATE_BILLED IS NULL                                
              AND BI.ACCOUNT_NO     = :BI-ACCOUNT-NO                    
              AND BI.ACCOUNT_NO     = BG.ACCOUNT_NO                     
              AND BI.BILL_NO        = BG.BILL_NO                        
              AND BG.CODE_UTIL_TYPE =  'G'                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT BG.ACCOUNT_NO                                                
MFA-TR*           ,BG.BILL_NO                                                   
MFA-TR*           ,BG.CODE_UTIL_TYPE                                            
MFA-TR*           ,BG.IC_NO                                                     
MFA-TR*           ,BG.BILL_ITEM_TIMESTMP                                        
MFA-TR*      INTO :BG-ACCOUNT-NO                                                
MFA-TR*          ,:BG-BILL-NO                                                   
MFA-TR*          ,:BG-CODE-UTIL-TYPE                                            
MFA-TR*          ,:BG-IC-NO                                                     
MFA-TR*          ,:BG-BILL-ITEM-TIMESTMP                                        
MFA-TR*      FROM CSS_BILLING_HDR BI                                            
MFA-TR*          ,CSS_BILLING_DET BG                                            
MFA-TR*     WHERE BI.DATE_BILLED IS NULL                                        
MFA-TR*       AND BI.ACCOUNT_NO     = :BI-ACCOUNT-NO                            
MFA-TR*       AND BI.ACCOUNT_NO     = BG.ACCOUNT_NO                             
MFA-TR*       AND BI.BILL_NO        = BG.BILL_NO                                
MFA-TR*       AND BG.CODE_UTIL_TYPE =  'G'                                      
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE            
                                       RS-RETURN-CODE.                  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7100'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_BILLING_HDR'         TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE BI-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000-UPDATE-BTU-FACTOR-BG.                                     *        
      ******************************************************************        
                                                                        
       8000-UPDATE-BTU-FACTOR-BG.                                       
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_BILLING_DET                                   
                  SET BTU_FACTOR         = :BG-BTU-FACTOR               
                WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO               
                  AND BILL_NO            = :BG-BILL-NO                  
                  AND CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE           
                  AND IC_NO              = :BG-IC-NO                    
                  AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )       
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_BILLING_DET                                           
MFA-TR*           SET BTU_FACTOR         = :BG-BTU-FACTOR                       
MFA-TR*         WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO                       
MFA-TR*           AND BILL_NO            = :BG-BILL-NO                          
MFA-TR*           AND CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                   
MFA-TR*           AND IC_NO              = :BG-IC-NO                            
MFA-TR*           AND BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP               
MFA-TR*      QUERYNO 8000                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            RS-RETURN-CODE.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '8000'                    TO ACTIVE-PARAGRAPH       
               MOVE 'UPDATE'                  TO ABEND-FUNCTION         
               MOVE 'CSS_BILLING_DET'         TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE 'BILL_NO'                 TO TABLE-ELEMENT-2        
               MOVE 'IC_NO'                   TO TABLE-ELEMENT-3        
               MOVE 'BILL_ITEM_TIMESTMP'      TO TABLE-ELEMENT-4        
               MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               MOVE BG-BILL-NO                TO HOSTVAR-ELEMENT-2      
               MOVE BG-IC-NO                  TO HOSTVAR-ELEMENT-3      
               MOVE BG-BILL-ITEM-TIMESTMP     TO HOSTVAR-ELEMENT-4      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05410000
      * 8100-SEND-RESULT.                                              *05420000
      ******************************************************************05430000
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
                                                                        
      ******************************************************************07969900
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     07970000
      ******************************************************************07970100
           EXEC SQL                                                     07970200
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                    07980000
                                                                        
      ******************************************************************08000000
      * END PROGRAM COPYLIB                                            *08010000
      ******************************************************************08020000
           EXEC SQL                                                             
               INCLUDE CPD00321                                                 
           END-EXEC.                                                            
      *                                                                *63030000
