       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04895.                                      
       AUTHOR.           MR7E794.                                       
COB303 DATE-WRITTEN.     AUG 30,2015.                                   
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                    SOUTH CAROLINA ELECTRIC & GAS               *        
      ******************************************************************        
      *                     STORED PROCEDURE:  CSR04895                *        
      ******************************************************************        
      *                           S U M M A R Y                        *        
      *    CSR04895 :                                                  *        
      *                                                                *        
      *    #  INSERT/DELETE A ROW IN CSS_WQ_U_CATEGORY TABLE           *        
      *    #  INSERT/DELETE A ROW IN CSS_WQ_AREA_CAT   TABLE           *        
      *                                                                *        
      ******************************************************************        
      *    PARAMETERS DETAIL                                           *        
      *                                                                *        
      *        INPUT                                                   *        
      *              I_COMPANY_NO              CHAR(2)                 *        
      *              I_CATEGORY_ID             CHAR(100)               *        
      *              I_USER_ID                 CHAR(7)                 *        
      *              I_RESP_AREA_ID            CHAR(3)                 *        
      *                                                                *        
      *    RESULT SET                                                  *        
      *              RETURN_CODE               INTEGER                 *        
      *                                                                *        
      ******************************************************************        
      *                    MODIFICATION LOG                            *        
      *                                                                *        
      *    DATE          INITIALS    COMMENTS                          *        
      *    -----------   --------    ----------------------------------*        
      *    08-27-2016    MR7E794     INITIAL VERSION                   *        
      *                                                                *        
      ******************************************************************        
      *               ---- BASIC SEQUENCE STRUCTURE ----               *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04895'.
MSQ017     COPY MFASQLM.
                                                                        
       01 WS-START                      PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04895 STARTS HERE'.                  
                                                                        
       01 WS-WORKING-STORAGE.                                           
           05 WS-SQLSTATE                PIC X(05) VALUE SPACES.        
           05 WS-LAST-UPDT-USER-ID       PIC X(07) VALUE SPACES.        
           05 WS-CURRENT-DATE            PIC X(10) VALUE SPACES.        
           05 WS-CURRENT-TS              PIC X(26) VALUE SPACES.        
                                                                        
       01 WS-INPUT.                                                     
           05 WS-COMPANY-NO              PIC X(02) VALUE SPACES.        
           05 WS-CATEGORY-IDS            PIC X(03) VALUE ZEROS.         
           05 WS-USER-ID                 PIC X(07) VALUE SPACES.        
           05 WS-RESP-AREA-ID            PIC X(03) VALUE SPACES.        
                                                                        
       01 WS-CATEGORY-ARRAY.                                            
           05 WS-CATEGORY-ARRAY-DET OCCURS 25 TIMES INDEXED BY WS-SUB.  
              10 WS-ACTION-TYPE          PIC X(01).                     
              10 WS-CATEGORY-ID          PIC X(03).                     
                                                                        
       01 COUNTER-FIELDS.                                               
           05 CTR-ROWS                   PIC S9(9) COMP VALUE 0.        
                                                                        
       01 WS-SWITCHES.                                                  
           05 SEND-DONE-SW               PIC X(01) VALUE 'Y'.           
              88 SEND-DONE-ERROR             VALUE 'N'.                 
              88 SEND-DONE-OK                VALUE 'Y'.                 
                                                                        
       01 WS-LITERALS.                                                  
           05 GTT-NAME                   PIC X(26) VALUE                
                                              'SESSION.CSR04895_R1'.    
           05 PROGRAM-NAME               PIC X(08) VALUE 'CSR04895'.    
                                                                        
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE             PIC S9(09) COMP VALUE 0.       
                                                                        
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       01  PARM-COMPANY-NO                PIC X(02)  VALUE SPACES.      
       01  PARM-CATEGORY-ID               PIC X(100) VALUE SPACES.      
       01  PARM-USER-ID                   PIC X(07)  VALUE SPACES.      
       01  PARM-RESP-AREA-ID              PIC X(03)  VALUE SPACES.      
                                                                        
       PROCEDURE DIVISION  USING PARM-COMPANY-NO                        
                                 PARM-CATEGORY-ID                       
                                 PARM-USER-ID                           
                                 PARM-RESP-AREA-ID.                     
                                                                        
      *****************************************************************         
      * 0000-MAINLINE.                                                *         
      *****************************************************************         
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 0100-INITIALIZE.                                              *         
      *****************************************************************         
       0100-INITIALIZE.                                                 
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT           THRU 0100A-EXIT.         
           PERFORM 7000-GET-CURRENT-DATE       THRU 7000-EXIT.          
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 0100A-DECLARE-GTT.                                            *         
      *****************************************************************         
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04895_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04895_R1
              (                                                       
                    RETURN_CODE             INT                     
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS       THRU 8000A-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100'                TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE GTT-NAME              TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                FROM #CSR04895_R1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*         FROM SESSION.CSR04895_R1                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 1000-PROCESS-INPUT                                            *         
      *****************************************************************         
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-COMPANY-NO        TO WS-COMPANY-NO.                
           MOVE PARM-USER-ID           TO WS-USER-ID.                   
           MOVE PARM-RESP-AREA-ID      TO WS-RESP-AREA-ID.              
                                                                        
           INITIALIZE WS-CATEGORY-ARRAY.                                
           MOVE PARM-CATEGORY-ID   TO WS-CATEGORY-ARRAY.                
                                                                        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *****************************************************************         
      * 2000-PROCESS-OUTPUT.                                          *         
      *****************************************************************         
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM VARYING WS-SUB FROM 1 BY 1                           
SCA006       UNTIL  WS-SUB >  25 OR 
                    WS-ACTION-TYPE(WS-SUB) <= SPACE                             
                                                                        
              IF WS-USER-ID > SPACES                                    
                 IF WS-ACTION-TYPE(WS-SUB) = 'D'                        
                    MOVE WS-CATEGORY-ID(WS-SUB) TO WS-CATEGORY-IDS      
                    PERFORM 8200-DELETE-WQ-U-CATEGORY THRU 8200-EXIT    
                 ELSE                                                   
                     IF WS-ACTION-TYPE(WS-SUB) = 'I'                    
                      MOVE WS-CATEGORY-ID(WS-SUB) TO WS-CATEGORY-IDS    
                       PERFORM 8300-INSRT-WQ-U-CATEGORY THRU 8300-EXIT  
                     END-IF                                             
                 END-IF                                                 
                                                                        
              ELSE                                                      
                  IF WS-ACTION-TYPE(WS-SUB) = 'D'                       
                   MOVE WS-CATEGORY-ID(WS-SUB) TO WS-CATEGORY-IDS       
                     PERFORM 8400-DELETE-WQ-AREA-CAT  THRU 8400-EXIT    
                  ELSE                                                  
                   IF WS-ACTION-TYPE(WS-SUB) = 'I'                      
                   MOVE WS-CATEGORY-ID(WS-SUB) TO WS-CATEGORY-IDS       
                   PERFORM 8500-INSRT-WQ-AREA-CAT THRU 8500-EXIT        
                   END-IF                                               
                  END-IF                                                
                                                                        
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2000A-MOVE-RESULT.                                            *         
      *****************************************************************         
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE.           
           PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.          
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 7000-GET-CURRENT-DATE.                                       *          
      ****************************************************************          
       7000-GET-CURRENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TS,
              :WS-CURRENT-DATE                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TS        = CURRENT TIMESTAMP                     
MFA-TR*          ,:WS-CURRENT-DATE      = CURRENT DATE                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'CURRENT DATE'           TO TABLE-ELEMENT-1          
              MOVE WS-CURRENT-DATE          TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 8000A-DEL-GTT-ROWS.                                          *          
      ****************************************************************          
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04895_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04895_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME                                   
                                            TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04895_R1'                                  
                                            TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8100-SEND-RESULT.                                             *         
      *****************************************************************         
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04895_R1                           
                 (                                                      
                   RETURN_CODE                                          
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE                                       
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04895_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE                                               
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO CTR-ROWS                 
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8100'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04895_R1'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 8200-DELETE-WQ-U-CATEGORY.                                   *          
      ****************************************************************          
       8200-DELETE-WQ-U-CATEGORY.                                       
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_WQ_U_CATEGORY                            
               WHERE                                                    
                   CATEGORY_ID = :WS-CATEGORY-IDS AND                   
                   USER_ID = :WS-USER-ID                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME                                        
                                       TO ABEND-PROGRAM                 
               MOVE SQLCODE            TO ABEND-SQLCODE                 
               MOVE SQLSTATE           TO ABEND-SQLSTATE                
               MOVE '8200'             TO ACTIVE-PARAGRAPH              
               MOVE 'DELETE'           TO ABEND-FUNCTION                
               MOVE SPACES             TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
               MOVE 'CSS_WQ_U_CATEGORY' TO TABLE-1                      
               MOVE 'CATEGORY_ID'      TO TABLE-ELEMENT-1               
               MOVE 'USER_ID'          TO TABLE-ELEMENT-2               
               MOVE WS-CATEGORY-IDS    TO HOSTVAR-ELEMENT-1             
               MOVE WS-USER-ID         TO HOSTVAR-ELEMENT-2             
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 8300-INSRT-WQ-U-CATEGORY.                                    *          
      ****************************************************************          
       8300-INSRT-WQ-U-CATEGORY.                                        
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_WQ_U_CATEGORY                              
                        (CATEGORY_ID                                    
                        ,USER_ID                                        
                        ,LAST_UPDATE_USERID                             
                        ,LAST_UPDATE_TS)                                
                  VALUES                                                
                        (:WS-CATEGORY-IDS                               
                        ,:WS-USER-ID                                    
                        ,:WS-LAST-UPDT-USER-ID                          
                        ,CIS.CHAR2TIMESTAMP(:WS-CURRENT-TS))                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_WQ_U_CATEGORY                                      
MFA-TR*                 (CATEGORY_ID                                            
MFA-TR*                 ,USER_ID                                                
MFA-TR*                 ,LAST_UPDATE_USERID                                     
MFA-TR*                 ,LAST_UPDATE_TS)                                        
MFA-TR*           VALUES                                                        
MFA-TR*                 (:WS-CATEGORY-IDS                                       
MFA-TR*                 ,:WS-USER-ID                                            
MFA-TR*                 ,:WS-LAST-UPDT-USER-ID                                  
MFA-TR*                 ,:WS-CURRENT-TS)                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR -803           
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '8300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_WQ_U_CATEGORY'      TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'CATEGORY_ID'            TO TABLE-ELEMENT-1          
              MOVE 'USER_ID'                TO TABLE-ELEMENT-2          
              MOVE WS-CATEGORY-IDS          TO HOSTVAR-ELEMENT-1        
              MOVE WS-USER-ID               TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 8400-DELETE-WQ-AREA-CAT                                      *          
      ****************************************************************          
       8400-DELETE-WQ-AREA-CAT.                                         
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_WQ_AREA_CAT                              
               WHERE                                                    
                   COMPANY_NO  = :WS-COMPANY-NO   AND                   
                   CATEGORY_ID = :WS-CATEGORY-IDS AND                   
                   RESP_AREA_ID = :WS-RESP-AREA-ID                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME                                        
                                       TO ABEND-PROGRAM                 
               MOVE SQLCODE            TO ABEND-SQLCODE                 
               MOVE SQLSTATE           TO ABEND-SQLSTATE                
               MOVE '8400'             TO ACTIVE-PARAGRAPH              
               MOVE 'DELETE'           TO ABEND-FUNCTION                
               MOVE 'CSS_WQ_AREA_CAT'  TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
                                          TABLE-1                       
               MOVE 'COMPANY_NO'       TO TABLE-ELEMENT-1               
               MOVE 'CATEGORY_ID'      TO TABLE-ELEMENT-2               
               MOVE 'USER_ID'          TO TABLE-ELEMENT-3               
               MOVE WS-COMPANY-NO      TO HOSTVAR-ELEMENT-1             
               MOVE WS-CATEGORY-IDS    TO HOSTVAR-ELEMENT-2             
               MOVE WS-RESP-AREA-ID    TO HOSTVAR-ELEMENT-3             
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 8500-INSRT-WQ-AREA-CAT                                       *          
      ****************************************************************          
       8500-INSRT-WQ-AREA-CAT.                                          
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_WQ_AREA_CAT                                
                        (COMPANY_NO                                     
                        ,CATEGORY_ID                                    
                        ,RESP_AREA_ID                                   
                        ,LAST_UPDATE_USERID                             
                        ,LAST_UPDATE_TS)                                
                  VALUES                                                
                        (:WS-COMPANY-NO                                 
                        ,:WS-CATEGORY-IDS                               
                        ,:WS-RESP-AREA-ID                               
                        ,:WS-LAST-UPDT-USER-ID                          
                        ,CIS.CHAR2TIMESTAMP(:WS-CURRENT-TS))                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_WQ_AREA_CAT                                        
MFA-TR*                 (COMPANY_NO                                             
MFA-TR*                 ,CATEGORY_ID                                            
MFA-TR*                 ,RESP_AREA_ID                                           
MFA-TR*                 ,LAST_UPDATE_USERID                                     
MFA-TR*                 ,LAST_UPDATE_TS)                                        
MFA-TR*           VALUES                                                        
MFA-TR*                 (:WS-COMPANY-NO                                         
MFA-TR*                 ,:WS-CATEGORY-IDS                                       
MFA-TR*                 ,:WS-RESP-AREA-ID                                       
MFA-TR*                 ,:WS-LAST-UPDT-USER-ID                                  
MFA-TR*                 ,:WS-CURRENT-TS)                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR -803           
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '8500'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_WQ_AREA_CAT'        TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CATEGORY_ID'            TO TABLE-ELEMENT-2          
              MOVE 'USER_ID'                TO TABLE-ELEMENT-3          
              MOVE WS-COMPANY-NO            TO HOSTVAR-ELEMENT-1        
              MOVE WS-CATEGORY-IDS          TO HOSTVAR-ELEMENT-2        
              MOVE WS-RESP-AREA-ID          TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 9700-PROCESS-ABEND.                                           *         
      *****************************************************************         
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT.          
           PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT.          
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                    *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *****************************************************************         
      * END PROGRAM COPYLIB                                           *         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE CPD00320                                                   
           END-EXEC.                                                            
