       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04894.                                         
       AUTHOR.        CARLA BROWN.                                      
COB303 DATE-WRITTEN.  MARCH 22, 2016                                    
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROCEDURE IS TO PROCESS ADVANCE PAY CORRECTIONS IN MOD   *        
      *  IT POSTS PAYMENT, WRITE JOUNALS AND TRANSACTION HISTORY       *00200016
      *     CLONED FROM CSR02351.                                      *00210016
      *                                                                *00210016
      *  BUSOP NAME: REQUUPDACCTADVPAYCORRECTIONBUSINESSOP             *00001600
      *                                                                *00001200
      ******************************************************************00220000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE    INITIALS   COMMENTS                                 *00260000
      *  --------  --------   ---------------------------------------  *00270000
P00586*  03/22/16  CB18344    PROCEDURE ORIGINALLY CODED.              *00280016
      *                                                                *00290000
A04860*  06/05/16  MS7M727    WORK QUEUE CHANGE TO REPLACE THE         *        
A04860*            ACT114     CSS_WQ_ITEMS_MF WITH CSS_WQ_ITEMS        *        
P00948*  06/16/16  AA97148    LEAST AMOUNT TO PAY CHANGES.             *        
P0586F*  09/21/16  AP40911   CHANGE MADE TO FIX OUT OF BALANCE IN      *        
      *                      JOURNALING,OVERAGE WAS NOT CREATED WHEN   *        
      *                      THERE IS A DIFFERENCE IN PAYMENT AMOUNT.  *        
ACT285*  10/21/16  AA97148    REPLACE CPD03413 WITH NEW COPYBOOK       *        
ACT285*                       CPD03414. Ref:APPL00005460               *        
P00948*  01/01/17  VENKAT.P   SEND DNP CANCEL NOTIFICATION E-MAIL FOR  *        
P00948*                       CUSTOMERS WITH E-MAIL ADDRESS.           *        
      ******************************************************************00300000
      ******************************************************************00310000
      *                                                                *00320000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00330000
      *                                                                *00340000
      ******************************************************************00310000
      *                                                                *00340000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00350000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00360000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00370000
      *  3000 - 4999  NOT USED                                         *00380000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00390000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00400000
      *  7000 - 7999  INPUT MODULES                                    *00410000
      *  8000 - 8999  OUTPUT MODULES                                   *00420000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00430000
      *                                                                *00440000
      ******************************************************************00450000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04894'.
MSQ017     COPY MFASQLM.
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04894 STARTS HERE'.                  
                                                                        
      ******************************************************************00540000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00550000
      ******************************************************************00560000
                                                                        
      *-- COPYBOOK TO DECLARE DISPLAY DATE VARIABLES                            
           COPY CWS00004.                                               00610013
                                                                        
      *-- HOLIDAY CHECK                                                         
           EXEC SQL                                                             
               INCLUDE CWS10016                                                 
           END-EXEC.                                                            
                                                                        
      *-- DECLARE REBATE AMOUNT VARIABLES                                       
           EXEC SQL                                                     PCS00670
              INCLUDE CWS00008                                          PCS00670
           END-EXEC.                                                    PCS00670
                                                                        
      *-- DECLARE ERROR HANDLING VARIABLES                                      
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      *-- COPYBOOK TO DECLARE CODES_DATA_PRESENT                                
           COPY CWS00056.                                               00640014
                                                                        
      *-- SUPPORTS DB2 AND SQL ERROR CHECKING                                   
           COPY CWS00303.                                               00650013
                                                                        
      *-- COPYBOOK TO DECLARE 101 JOURNAL VARIABLES                             
           COPY CJF00101.                                               PCS00760
                                                                        
      *-- COPYBOOK TO DECLARE 105 JOURNAL VARIABLES                             
           COPY CJF00105.                                               PCS00760
                                                                        
      *-- COPYBOOK TO DECLARE 102 JOURNAL VARIABLES                             
           COPY CJF00102.                                               PCS00760
                                                                        
      *-- COPYBOOK TO DECLARE SCSCA225 VARIABLES                                
           COPY CWSCA225.                                                       
                                                                        
      *-- COPYBOOK TO DECLARE SCSCA224 VARIABLES                                
           COPY CWSCA224.                                                       
                                                                        
      *-- COPYBOOK FOR CSS_WQ_ITEMS                                             
ACT114     COPY CWS00077.                                                       
ACT285*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
ACT285*    WS VARIABLE FOR COPY BOOK CPD03414                         *         
ACT285*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
ACT285                                                                  
ACT285     EXEC SQL                                                             
ACT285      INCLUDE CWS03414                                                    
ACT285     END-EXEC.                                                            
ACT285                                                                  
      ******************************************************************00670000
      *    WORK AREAS                                                  *00680000
      ******************************************************************00690000
                                                                        
       01  WS-MISC.                                                     
ACT114     05  WS-WQ-CALL-PGM           PIC X(08)  VALUE 'MCSCB077'.    
ACT114     05  MCSCB077                 PIC X(08)  VALUE 'MCSCB077'.    
ACT114     05  SCSCB077                 PIC X(08)  VALUE 'SCSCB077'.    
ACT114     05  WS-CPD0010S-CALL-TYPE    PIC X(01)  VALUE 'O'.           
ACT114         88 WS-CPD0010S-ONLINE-CALL          VALUE 'O'.           
ACT114         88 WS-CPD0010S-BATCH-CALL           VALUE 'B'.           
P00948     05  WS-LEAST-AMT-DUE-CD      PIC X(13)  VALUE                
P00948                                       'LEAST-AMT-DUE'.           
P00948     05  WS-LEAST-AMOUNT-DUE      PIC S9(4)V9(5) USAGE COMP-3     
P00948                                             VALUE 0.             
ACT285     05  WS-PYMT-AMOUNT           PIC S9(09)V99 COMP-3 VALUE +0.  
ACT285     05  WS-PROGRAM-NAME          PIC X(08) VALUE SPACES.         
ACT285     05  WS-UPDATE-ACTION-FL      PIC X(01) VALUE SPACES.         
           05  WS-TOTAL-ARREARS         PIC S9(9)V99 COMP-3 VALUE 0.    
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  WS-LAST-UPDATE-TS        PIC X(26) VALUE SPACES.         
           05  WS-DATE-ORIG-PYMT-IND    PIC S9(04) COMP VALUE +0.       
           05  WS-AMT-TOT-SUB           PIC S9(04) COMP VALUE +0.       
           05  WS-ACCT-SUB              PIC S9(04) COMP VALUE +0.       
           05  WS-ACCT-SUB-PLUS1        PIC S9(04) COMP VALUE +0.       
           05  WS-LOAD-SUB              PIC S9(04) COMP VALUE +0.       
           05  WS-MAX-NO-ROWS           PIC S9(04) COMP VALUE +0.       
           05  WS-DNP-RET-CODE          PIC S9(4) VALUE 0 COMP.         
           05  WS-CANCELDNP-FLAG        PIC X(01) VALUE SPACES.         
           05  WS-FIRST-PAYMENT         PIC X(01) VALUE 'Y'.            
               88 FIRST-PAYMENT                   VALUE 'Y'.            
           05  WS-FIRST-TIME-JRNL       PIC X(01) VALUE 'Y'.            
               88 FIRST-JRNL                      VALUE 'Y'.            
           05  WS-OV-SH-TRAN-ID         PIC X(04) VALUE SPACES.         
               88 OVERAGE-TRAN-ID                 VALUE 'O412'.         
               88 SHORTAGE-TRAN-ID                VALUE 'S412'.         
           05  WS-SQLSTATE              PIC X(05).                      
           05  MULTIPLE-ROWS-SELECTED   PIC S9(09) VALUE -811 COMP.     
           05  WS-OVERSHORT-TYPE        PIC X(01) VALUE SPACES.         
           05  WS-DISP-GL-ACCT          PIC 9(3).9(4).                  
           05  WS-UTIL-ACCOUNT          PIC X.                          
               88  UTIL-EXISTS                    VALUE 'Y'.            
               88  NO-UTIL-EXISTS                 VALUE 'N'.            
           05  WS-VALID-RATE-FL         PIC X.                          
               88  VALID-RATE                     VALUE 'Y'.            
               88  NOT-VALID-RATE                 VALUE 'N'.            
           05  WS-DIR-PAY-TABLE.                                        
               10  WS-DIR-PAY-TAB OCCURS 20 TIMES.                      
                   15  WS-DIR-PAY-ACCOUNT          PIC X(13).           
                   15  WS-DIR-PAY-ACCOUNT-NO-NUM                        
                             REDEFINES WS-DIR-PAY-ACCOUNT PIC 9(13).    
                   15  WS-DIR-PAY-PYMT-PRTY-LVL    PIC S9(04) COMP.     
                   15  WS-DIR-PAY-ITEM-ID          PIC S9(09) COMP.     
COB305             15 WS-DIR-PAY-AMT        PIC S9(09)V99 COMP-3 
COB305               VALUE 0.
                   15  WS-DIR-PAY-CURRENCY         PIC  X(01).          
                   15  WS-DIR-PAY-UPDATE-TYPE      PIC  X(01).          
                   15  WS-DIR-PAY-AMT-CHECK        PIC  X(11).          
                   15  WS-DIR-PAY-AMT-MONEY-ORDER  PIC  X(11).          
                   15  WS-DIR-PAY-AMT-CHRG-CARD    PIC  X(11).          
                   15  WS-DIR-PAY-AMT-CASH         PIC  X(11).          
                   15  WS-DIR-PAY-CHRG-OFF         PIC  X(01).          
                   15  WS-DIR-PAY-LAST-UPDATE-TS   PIC  X(26).          
           05  WS-ACCOUNT-NO            PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                
                                        PIC 9(13).                      
           05  WS-ACCOUNT-NO-COMP3      PIC S9(13) COMP-3 VALUE 0.      
           05  WS-PREV-ACCOUNT-NO-COMP3 PIC S9(13) COMP-3 VALUE 0.      
           05  WS-AMOUNT-CHECK          PIC X(11).                      
           05  WS-AMOUNT-CHECK-NUM REDEFINES WS-AMOUNT-CHECK            
                                        PIC 9(09)V99.                   
           05  WS-AMOUNT-CHECK-COMP3    PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-AMOUNT-MORDER         PIC X(11).                      
           05  WS-AMOUNT-MORDER-NUM REDEFINES WS-AMOUNT-MORDER          
                                        PIC  9(09)V99.                  
           05  WS-AMOUNT-MORDER-COMP3   PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-AMOUNT-CASH           PIC X(11).                      
           05  WS-AMOUNT-CASH-NUM REDEFINES WS-AMOUNT-CASH              
                                        PIC 9(09)V99.                   
           05  WS-AMOUNT-CASH-COMP3     PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-AMT-CHRG-CARD         PIC X(11).                      
           05  WS-AMT-CHRG-CARD-NUM REDEFINES WS-AMT-CHRG-CARD          
                                        PIC 9(09)V99.                   
           05  WS-AMT-CHRG-CARD-COMP3   PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-TOTAL-ORIG-AMT        PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-DIR-BREAKDOWN.                                        
               10  WS-DIR-ACCOUNT-NO    PIC X(13).                      
               10  WS-DIR-ACCOUNT-NO-NUM REDEFINES WS-DIR-ACCOUNT-NO    
                                        PIC 9(13).                      
               10  WS-DIR-UPDATE-TYPE   PIC X(01).                      
               10  WS-DIR-PYMT-PRTY-LVL PIC X(04).                      
               10  WS-DIR-PYMT-PRTY-LVL-NUM REDEFINES                   
                                            WS-DIR-PYMT-PRTY-LVL        
                                        PIC 9(04).                      
               10  WS-DIR-ITEM-ID       PIC X(09).                      
               10  WS-DIR-ITEM-ID-NUM REDEFINES WS-DIR-ITEM-ID          
                                        PIC 9(09).                      
               10  WS-DIR-AMT-PYMT      PIC X(11).                      
               10  WS-DIR-AMT-PYMT-NUM REDEFINES WS-DIR-AMT-PYMT        
                                        PIC 9(09)V99.                   
               10  WS-DIR-CURRENCY      PIC X(01).                      
               10  WS-DIR-AMT-CHECK     PIC X(11).                      
               10  WS-DIR-AMT-MO        PIC X(11).                      
               10  WS-DIR-AMT-CHRG-CARD PIC X(11).                      
               10  WS-DIR-AMT-CASH      PIC X(11).                      
               10  WS-DIR-CHRG-OFF      PIC X(01).                      
               10  WS-DIR-LAST-UPD-TS   PIC X(26).                      
           05  WS-REV-TYPE-NUM-COMP     PIC S9(04) COMP VALUE 0.        
           05  WS-AMT-DIFF-NUM          PIC S9(09)V99.                  
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-MNT-TRH-DATE          PIC X(10) VALUE SPACES.         
           05  WS-MNT-TRH-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-PREV-TRANS-HIST-SEQ-NO PIC X(26) VALUE SPACES.        
           05  WS-DATE                  PIC X(10) VALUE SPACES.         
           05  WS-TIME                  PIC X(08) VALUE SPACES.         
           05  WS-ADJ-TRANS-HIST-SEQ-NO PIC X(26) VALUE SPACES.         
           05  WS-TRANS-HIST-SEQ-NO     PIC X(26) VALUE SPACES.         
           05  WS-RECORD-ONLY           PIC X(01) VALUE SPACES.         
           05  WS-USER-ID               PIC X(07) VALUE SPACES.         
           05  WS-NULL-IND1             PIC S9(04) COMP VALUE 0.        
           05  WS-NULL-IND2             PIC S9(04) COMP VALUE 0.        
           05  WS-NULL-IND3             PIC S9(04) COMP VALUE 0.        
           05  WS-NULL-INDICATOR-1      PIC S9(04) COMP VALUE 0.        
           05  WS-NULL-INDICATOR-2      PIC S9(04) COMP VALUE 0.        
           05  WS-NULL-INDICATOR-3      PIC S9(04) COMP VALUE 0.        
           05  WS-NULL-INDICATOR-4      PIC S9(04) COMP VALUE 0.        
           05  WS-NULL-BAL-TS           PIC S9(4)  COMP VALUE 0.        
           05  WS-NSC                   PIC S9(04) COMP VALUE 19.       
           05  WS-FROM-CMMNT-LEN        PIC 9(04)  VALUE 0.             
           05  WS-FROM-CMMNT-LEN-NUM    PIC S9(04) COMP VALUE 0.        
           05  WS-FROM-CMMNT-TEXT       PIC X(210) VALUE SPACES.        
           05  WS-USER-CMMNT-LEN        PIC 9(04)  VALUE 0.             
           05  WS-USER-CMMNT-LEN-NUM    PIC S9(04) COMP VALUE 0.        
           05  WS-USER-CMMNT-TEXT       PIC X(210) VALUE SPACES.        
           05 WS-TEMP-GEN-LEDG-DB       PIC S9(3)V9(4) COMP-3 VALUE +0. 
           05 WS-TEMP-GEN-LEDG-CR       PIC S9(3)V9(4) COMP-3 VALUE +0. 
           05 WS-TEMP-CURR              PIC X(01)  VALUE SPACES.        
           05 WS-JRNL-FLAG              PIC X(01)  VALUE 'Y'.           
              88 WS-JRNL-TRUE                      VALUE 'Y'.           
           05 WS-AR-CASH-COMPANY-NO     PIC X(2) VALUE SPACES.          
           05 WS-AR-CASH-LOCAL-OFFICE   PIC X(3) VALUE SPACES.          
           05 WS-AR-DATE-CASH-REPORT    PIC X(10) VALUE SPACES.         
           05 WS-AR-CASH-DRAWER-ID      PIC 9(04) VALUE 0.              
                                                                        
                                                                        
       01  WS-LITERAL.                                                  
           05  WS-A                     PIC X(01)  VALUE 'A'.           
           05  WS-C                     PIC X(01)  VALUE 'C'.           
           05  WS-D                     PIC X(01)  VALUE 'D'.           
           05  WS-U                     PIC X(01)  VALUE 'U'.           
           05  WS-N                     PIC X(01)  VALUE 'N'.           
           05  WS-Y                     PIC X(01)  VALUE 'Y'.           
           05  WS-01                    PIC X(02)  VALUE '01'.          
           05  WS-998                   PIC X(03)  VALUE '998'.         
           05  WS-5272-CHECK            PIC X(03)  VALUE 'Y'.           
           05  WS-LOCAL-OFFICE          PIC X(3)   VALUE '002'.         
           05  WS-FOUND-MULT-BILLS      PIC S9(04) COMP VALUE -811.     
           05  MCSCB225                 PIC X(8)   VALUE 'MCSCB225'.    
           05  MCSCA182                 PIC X(8)   VALUE 'MCSCA182'.    
ACT285     05  MCS03414                 PIC X(08)  VALUE 'MCS03414'.    
           05  WS-COG-TRAN-TYPE-CD-73   PIC X(1)   VALUE 'P'.           
           05  MCSCB224                 PIC X(8)   VALUE 'MCSCB224'.    
           05  WS-CHRG-OFF-IND          PIC X(01)  VALUE 'N'.           
           05  WS-DPP-ACCT-IND          PIC X(01)  VALUE 'N'.           
           05  WS-JRNL-CNTL             PIC X(01)  VALUE 'N'.           
           05  WS-NO                    PIC  X(01) VALUE 'N'.           
           05  WS-YES                   PIC  X(01) VALUE 'Y'.           
           05  PROGRAM-NAME             PIC X(08)  VALUE 'CSR04894'.    
           05  EIBTRNID                 PIC X(04)  VALUE 'S351'.        
           05  MCSCO061                 PIC X(08)  VALUE 'MCSCO061'.    
           05  WS-NEG-DIFF-FLAG         PIC X(01)  VALUE 'N'.           
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05  GTT-NAME                 PIC X(26)                       
                                            VALUE 'SESSION.CSR04894_R1'.
           05  GTT-ROW.                                                 
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
           05  GTT-SQLCODE              PIC S9(9) COMP.                 
                                                                        
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                 PIC S9(9) COMP.                 
           05  SNA-CONNECTION-NAME      PIC X(8)  VALUE SPACES.         
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN               PIC S9(9) COMP VALUE 1.         
           05  CTR-ROWS                 PIC S9(9) COMP VALUE 0.         
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM          PIC S9(9) COMP.                 
           05  WRKLEN1                  PIC S9(9) COMP.                 
           05  WRKLEN2                  PIC S9(9) COMP.                 
           05  WRK-DONE-STATUS          PIC S9(9) COMP.                 
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(09) COMP   VALUE +0.     
           05  RS-ACCOUNT-NO            PIC X(13).                      
           05  RS-ERROR-MESSAGE1        PIC X(05) VALUE SPACES.         
           05  RS-ERROR-MESSAGE2        PIC X(05) VALUE SPACES.         
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(09) COMP VALUE +0.       
           05  S-ACCOUNT-NO             PIC X(13).                      
           05  S-ERROR-MESSAGE1         PIC X(05) VALUE SPACES.         
           05  S-ERROR-MESSAGE2         PIC X(05) VALUE SPACES.         
                                                                        
       01  CSRERLOG-P.                                                  
           05  S-SP-NAME                PIC X(18) VALUE SPACES.         
           05  S-SQLCODE                PIC S9(9) COMP VALUE 0.         
           05  S-SQLSTATE               PIC X(5)  VALUE ' '.            
           05  S-TABLE-NAME             PIC X(18) VALUE SPACES.         
           05  S-HOST-VARIABLES.                                        
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
           05  S-SQL-STATEMENT.                                         
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
           05  S-SQL-DESCRIPTION.                                       
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
      *-- COPYBOOK TO DECLARE SCSCA182 VARIABLES                                
       COPY CWS00182.                                                           
                                                                        
      *-- SQL COMMUNICATION AREA                                                
           EXEC SQL                                                     02450012
              INCLUDE SQLCA                                             02460012
           END-EXEC.                                                    02470012
                                                                        
      *-- AC CSS_AR_CNTL                                                        
           EXEC SQL                                                     02690016
              INCLUDE TBARCNTL                                          02700016
           END-EXEC.                                                    02710016
                                                                        
      *-- AL CSS_AR_LOCKOUT                                                     
           EXEC SQL                                                             
              INCLUDE TBARLOCK                                                  
           END-EXEC.                                                            
                                                                        
      *-- AR CSS_AR_TRANS_HIST                                                  
           EXEC SQL                                                     02490012
              INCLUDE TBARHIST                                          02500016
           END-EXEC.                                                    02510012
                                                                        
      *-- AT CSS_ACCOUNT                                                        
           EXEC SQL                                                     02530016
              INCLUDE TBACCT                                            02540016
           END-EXEC.                                                    02550016
                                                                        
      *-- AU CSS_AR_TRN_HST_DET                                                 
           EXEC SQL                                                     00010000
              INCLUDE TBARHDT                                           00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- BC CSS_BCH_JRNL_CNTL                                                  
           EXEC SQL                                                     00010000
              INCLUDE TBBJCNTL                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- BH CSS_BUDGET_HIST                                                    
           EXEC SQL                                                     02490012
              INCLUDE TBBGTHST                                          02500016
           END-EXEC.                                                    02510012
                                                                        
      *-- BJ CSS_BATCH_JRNL                                                     
           EXEC SQL                                                     00010000
              INCLUDE TBBTJRNL                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- BU CSS_BUDGET_PLAN                                                    
           EXEC SQL                                                     02490012
              INCLUDE TBBGTPLN                                          02500016
           END-EXEC.                                                    02510012
                                                                        
      *-- B1 CSS_LOCAL_OFFICE                                                   
           EXEC SQL                                                             
              INCLUDE TBLOCOFC                                                  
           END-EXEC.                                                            
                                                                        
      *-- CC CSS_CONNECT_CHRG                                                   
           EXEC SQL                                                             
              INCLUDE TBCCCHRG                                                  
           END-EXEC.                                                            
                                                                        
      *-- CJ CSS_CSH_DRWR_JRNL                                                  
           EXEC SQL                                                     00010000
              INCLUDE TBCDJRNL                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- CL CSS_CRED_COLL                                                      
           EXEC SQL                                                     02730016
              INCLUDE TBCRCOLL                                          02740016
           END-EXEC.                                                    02750016
                                                                        
      *-- CO CSS_CHRG_OFF                                                       
           EXEC SQL                                                             
              INCLUDE TBCHGOFF                                                  
           END-EXEC.                                                            
                                                                        
      *-- CS CSS_CSH_DRWR_CNTL                                                  
           EXEC SQL                                                     00010000
              INCLUDE TBCDCNTL                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- CT CSS_CONTRACT                                                       
           EXEC SQL                                                     00010000
              INCLUDE TBCNTRCT                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- CU CSS_CUSTOMER                                              *        
           EXEC SQL                                                     02570016
              INCLUDE TBCUST                                            02580016
           END-EXEC.                                                    02590016
                                                                        
      *-- CZ CSS_CREDIT_PROFILE                                                 
           EXEC SQL                                                             
              INCLUDE TBCRPROF                                                  
           END-EXEC.                                                            
                                                                        
      *-- C8 CSS_DELINQUENCY                                                    
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      *-- C9 CSS_AR_PMT_PRTY                                                    
           EXEC SQL                                                     00010000
              INCLUDE TBARPMT                                           00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- DA CSS_DFA_ACCT                                                       
           EXEC SQL                                                     00010000
              INCLUDE TBDFAACT                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- DL CSS_RECONNECT                                                      
           EXEC SQL                                                             
              INCLUDE TBRECNCT                                                  
           END-EXEC.                                                            
                                                                        
      *-- DO CSS_DEP_ON_HAND                                                    
           EXEC SQL                                                     00010000
              INCLUDE TBDEPHND                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- DP CSS_DEP_PAY_HST                                                    
           EXEC SQL                                                     00010000
              INCLUDE TBDEPHST                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- DR CSS_DEP_REQ                                                        
           EXEC SQL                                                     00010000
              INCLUDE TBDEPREQ                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- DV CSS_DFA_RECVBLE                                                    
           EXEC SQL                                                     00010000
              INCLUDE TBDFARCV                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- EA CSS_CNT_DETAIL                                                     
           EXEC SQL                                                     02490012
              INCLUDE TBCNTDET                                          02500016
           END-EXEC.                                                    02510012
                                                                        
      *-- FW CSS_FINAL_WO                                               07009300
           EXEC SQL                                                     07009600
               INCLUDE TBFINLWO                                         07009700
           END-EXEC.                                                    07009800
                                                                        
      *-- GO CSS_GL_ACCT_NO                                                     
           EXEC SQL                                                     00010000
              INCLUDE TBGLATNO                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- G6 CSS_JOB_PARM                                                       
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
                                                                        
      *-- J8 CSS_HOLIDAY                                                        
           EXEC SQL                                                             
               INCLUDE TBHLDAY                                                  
           END-EXEC.                                                            
                                                                        
      *-- LI CSS_LIEAP                                                          
           EXEC SQL                                                             
              INCLUDE TBLIEAP                                                   
           END-EXEC.                                                            
                                                                        
      *-- MH CSS_MNT_TRANS_HIST                                                 
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      *-- MI CSS_MT_TRN_HST_DET                                                 
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      *-- MJ CSS_MISC_JRNL                                                      
           EXEC SQL                                                     00010000
              INCLUDE TBMSJRNL                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- NH CSS_NSF_HIST                                                       
           EXEC SQL                                                             
              INCLUDE TBNSFHST                                                  
           END-EXEC.                                                            
                                                                        
      *-- OD CSS_OVERSHORT_DET                                                  
           EXEC SQL                                                             
              INCLUDE TBOVSHDT                                                  
           END-EXEC.                                                            
                                                                        
      *-- OH CSS_OVERSHORT_HDR                                                  
           EXEC SQL                                                             
              INCLUDE TBOVSHHD                                                  
           END-EXEC.                                                            
                                                                        
      *-- OT CSS_OVERSHORT_TYPE                                                 
           EXEC SQL                                                             
             INCLUDE TBOVSHTY                                                   
           END-EXEC.                                                            
                                                                        
      *-- PF CSS_USER_PROFILE                                                   
           EXEC SQL                                                     00010000
              INCLUDE TBUSRPRF                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- PJ CSS_PROJ_SHARE                                                     
           EXEC SQL                                                     00010000
              INCLUDE TBPRJSHR                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- PR CSS_PREMISE                                                        
           EXEC SQL                                                     02610016
              INCLUDE TBPREM                                            02620016
           END-EXEC.                                                    02630016
                                                                        
      *-- UT CSS_UTIL_ENVRNMT                                                   
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
                                                                        
      *-- U7 CSS_RECONNECT_CHRG                                                 
           EXEC SQL                                                             
              INCLUDE TBRCNCHR                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
      *-- WG CSS_WO_ARRANGEMENT                                                 
           EXEC SQL                                                     07009600
               INCLUDE TBWOARGM                                         07009700
           END-EXEC.                                                    07009800
                                                                        
                                                                        
      *-- YR CSS_CSH_REPORT_HDR                                        *        
           EXEC SQL                                                             
              INCLUDE TBCSRPHD                                                  
           END-EXEC.                                                            
                                                                        
      *-- Y2 CSS_CASHIER_OFFICE                                                 
           EXEC SQL                                                             
              INCLUDE TBCSHOFF                                                  
           END-EXEC.                                                            
                                                                        
      *-- COPYBOOK TO DECLARE JOURNAL VARIABLES AND CWS-13 VARIABLES            
           EXEC SQL                                                             
              INCLUDE CWS0013B                                                  
           END-EXEC.                                                            
                                                                        
      *-- COPYBOOK TO DECLARE WS VARIABLES FOR PAYMENT ROUTINE                  
           EXEC SQL                                                     PCS00710
              INCLUDE CWS00017                                          PCS00710
           END-EXEC.                                                    PCS00710
                                                                        
      *-- COPYBOOK TO DECLARE WS VARIABLES FOR GENERAL LEDGERS                  
           EXEC SQL                                                             
              INCLUDE CWS00061                                                  
           END-EXEC.                                                            
                                                                        
      *-- COPYBOOK FOR LINKAGE SECTION VARIABLES FOR SCSCO061                   
           COPY CWS0061L.                                                       
                                                                        
      *-- COPYBOOK TO DECLARE CHARGE OFF RECEIVABLES                            
           EXEC SQL                                                     02930012
              INCLUDE CWS00073                                          02940012
           END-EXEC.                                                    02950012
                                                                        
      *-- COPYBOOK TO DECLARE WS VARIABLES FOR REFUND CPD CPD00116              
           EXEC SQL                                                     02930012
              INCLUDE CWS0116A                                          02940012
           END-EXEC.                                                    02950012
      *                                                                         
       LINKAGE SECTION.                                                 
       01  PARM-USER-ID                  PIC X(07).                     
       01  PARM-FROM-ACCOUNT-NO          PIC X(13).                     
COB305 01 PARM-CORRECTION-AMT-DIFF        PIC S9(09)V99 COMP-3 VALUE 0.         
       01  PARM-TRANS-HIST-SEQ-NO        PIC X(26).                     
       01  PARM-FROM-ACCT-CMMNT-LEN      PIC X(04).                     
       01  PARM-FROM-ACCT-CMMNT-TEXT     PIC X(210).                    
       01  PARM-NO-OF-PAYCORRECTION-ROWS PIC S9(04) COMP.               
       01  PARM-PAY-CORR-ROW-1           PIC X(110).                    
       01  PARM-PAY-CORR-ROW-2           PIC X(110).                    
       01  PARM-PAY-CORR-ROW-3           PIC X(110).                    
       01  PARM-PAY-CORR-ROW-4           PIC X(110).                    
       01  PARM-PAY-CORR-ROW-5           PIC X(110).                    
       01  PARM-PAY-CORR-ROW-6           PIC X(110).                    
       01  PARM-PAY-CORR-ROW-7           PIC X(110).                    
       01  PARM-PAY-CORR-ROW-8           PIC X(110).                    
       01  PARM-PAY-CORR-ROW-9           PIC X(110).                    
       01  PARM-PAY-CORR-ROW-10          PIC X(110).                    
       01  PARM-PAY-CORR-ROW-11          PIC X(110).                    
       01  PARM-PAY-CORR-ROW-12          PIC X(110).                    
       01  PARM-PAY-CORR-ROW-13          PIC X(110).                    
       01  PARM-PAY-CORR-ROW-14          PIC X(110).                    
       01  PARM-PAY-CORR-ROW-15          PIC X(110).                    
       01  PARM-PAY-CORR-ROW-16          PIC X(110).                    
       01  PARM-PAY-CORR-ROW-17          PIC X(110).                    
       01  PARM-PAY-CORR-ROW-18          PIC X(110).                    
       01  PARM-PAY-CORR-ROW-19          PIC X(110).                    
       01  PARM-PAY-CORR-ROW-20          PIC X(110).                    
       01  PARM-USER-CMMNT-LEN           PIC X(04).                     
       01  PARM-USER-CMMNT-TEXT          PIC X(210).                    
                                                                        
       PROCEDURE DIVISION USING     PARM-USER-ID                        
                                    PARM-FROM-ACCOUNT-NO                
                                    PARM-CORRECTION-AMT-DIFF            
                                    PARM-TRANS-HIST-SEQ-NO              
                                    PARM-FROM-ACCT-CMMNT-LEN            
                                    PARM-FROM-ACCT-CMMNT-TEXT           
                                    PARM-NO-OF-PAYCORRECTION-ROWS       
                                    PARM-PAY-CORR-ROW-1                 
                                    PARM-PAY-CORR-ROW-2                 
                                    PARM-PAY-CORR-ROW-3                 
                                    PARM-PAY-CORR-ROW-4                 
                                    PARM-PAY-CORR-ROW-5                 
                                    PARM-PAY-CORR-ROW-6                 
                                    PARM-PAY-CORR-ROW-7                 
                                    PARM-PAY-CORR-ROW-8                 
                                    PARM-PAY-CORR-ROW-9                 
                                    PARM-PAY-CORR-ROW-10                
                                    PARM-PAY-CORR-ROW-11                
                                    PARM-PAY-CORR-ROW-12                
                                    PARM-PAY-CORR-ROW-13                
                                    PARM-PAY-CORR-ROW-14                
                                    PARM-PAY-CORR-ROW-15                
                                    PARM-PAY-CORR-ROW-16                
                                    PARM-PAY-CORR-ROW-17                
                                    PARM-PAY-CORR-ROW-18                
                                    PARM-PAY-CORR-ROW-19                
                                    PARM-PAY-CORR-ROW-20                
                                    PARM-USER-CMMNT-LEN                 
                                    PARM-USER-CMMNT-TEXT.               

SCA006        SET WS-GL-SUB TO 1.
      *                                                                 03020000
      ******************************************************************03030000
      * 0000-MAINLINE.                                                 *03040000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *03050000
      ******************************************************************03060000
      *                                                                 03020000
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03020000
      ******************************************************************03160000
      * 0100-INITIALIZE.                                               *03170000
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *03190000
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *03200000
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*03210000
      ******************************************************************03230000
      *                                                                 03020000
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE '0100' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           PERFORM 0100A-DECLARE-GTT    THRU 0100A-EXIT.                
      *                                                                         
           EXEC SQL                                                     
                DECLARE C1 CURSOR   FOR             
                SELECT                                                  
                      RETURN_CODE                                       
                     ,LTRIM(RTRIM(ACCOUNT_NO))         AS ACCOUNT_NO           
                     ,LTRIM(RTRIM(ERROR_MESSAGE1))     AS ERROR_MESSAGE1       
                     ,LTRIM(RTRIM(ERROR_MESSAGE2))     AS ERROR_MESSAGE2       
                FROM #CSR04894_R1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ034
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH HOLD WITH RETURN FOR                     
MFA-TR*         SELECT                                                          
MFA-TR*               RETURN_CODE                                               
MFA-TR*              ,STRIP(ACCOUNT_NO)         AS ACCOUNT_NO                   
MFA-TR*              ,STRIP(ERROR_MESSAGE1)     AS ERROR_MESSAGE1               
MFA-TR*              ,STRIP(ERROR_MESSAGE2)     AS ERROR_MESSAGE2               
MFA-TR*         FROM SESSION.CSR04894_R1                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS.                                
           INITIALIZE WS-PAR-MESSAGE-NO.                                
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************02530000
      * 0100A-DECLARE-GTT.                                             *02540000
      *      DECLARE TEMPORARY TABLE                                   *02540000
      ******************************************************************02890000
      *                                                                         
       0100A-DECLARE-GTT.                                               
      *                                                                         
           MOVE '0100A' TO ACTIVE-PARAGRAPH.                            
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04894_R1'            
                                       TO S-SQL-STATEMENT-V.            
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04894_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04894_R1
              (                                                       
                   RETURN_CODE              INT                     
                  ,ACCOUNT_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,ERROR_MESSAGE1 CHAR(05)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,ERROR_MESSAGE2 CHAR(05)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS  THRU 8000A-EXIT            
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE SQLCODE              TO ABEND-SQLCODE             
                 MOVE SQLSTATE             TO ABEND-SQLSTATE            
                 MOVE 'DECLARE GTT'        TO ABEND-FUNCTION            
                 MOVE SPACES               TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                 MOVE 'CSR04894_R1'        TO TABLE-1                   
                 MOVE SPACES               TO TABLE-ELEMENT-1           
                 MOVE SPACES               TO HOSTVAR-ELEMENT-1         
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
         0100A-EXIT.                                                    
              EXIT.                                                     
      *                                                                         
      ******************************************************************03800002
      * 2000-PROCESS-OUTPUT.                                           *03810002
      *     1. DESCRIBE RESULT SET                                     *03830002
      *     2. UPDATE DB2 DATA                                         *03840002
      *     3. BUILD RESULT SET                                        *03850002
      *     4. SEND RESULT SET                                         *03860002
      ******************************************************************03880002
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 7999-SELECT-AL THRU 7999-SELECT-AL-EXIT.             
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
              MOVE +0                   TO RS-RETURN-CODE               
              MOVE '5000'               TO RS-ERROR-MESSAGE1            
              PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT  THRU 8100-EXIT                  
              PERFORM 9999-END-PROGRAM  THRU 9999-EXIT                  
           END-IF.                                                      
      *                                                                 03960002
           MOVE PARM-NO-OF-PAYCORRECTION-ROWS TO WS-MAX-NO-ROWS.        
           IF PARM-USER-CMMNT-LEN > 0210                                
              MOVE 0210                  TO WS-USER-CMMNT-LEN           
           ELSE                                                         
              MOVE PARM-USER-CMMNT-LEN   TO WS-USER-CMMNT-LEN           
           END-IF.                                                      
      *                                                                         
           MOVE PARM-USER-CMMNT-TEXT      TO WS-USER-CMMNT-TEXT.        
           MOVE WS-USER-CMMNT-LEN         TO WS-USER-CMMNT-LEN-NUM.     
           MOVE PARM-FROM-ACCT-CMMNT-TEXT TO WS-FROM-CMMNT-TEXT.        
           MOVE PARM-FROM-ACCT-CMMNT-LEN  TO WS-FROM-CMMNT-LEN.         
           MOVE WS-FROM-CMMNT-LEN         TO WS-FROM-CMMNT-LEN-NUM      
                                             AR-TRAN-COMMENT-LEN.       
           MOVE WS-FROM-CMMNT-LEN-NUM     TO WS-PAR-AR-TRAN-COMMENT-LEN 
                                             WS-JRNL-TRAN-COMMENT-LEN.  
           MOVE WS-FROM-CMMNT-TEXT        TO AR-TRAN-COMMENT-TEXT       
                                             WS-PAR-AR-TRAN-COMMENT-TEXT
                                             WS-JRNL-TRAN-COMMENT-TEXT. 
           MOVE WS-998                    TO Y2-CASH-LOCAL-OFFICE.      
           MOVE WS-01                     TO Y2-CASH-COMPANY-NO.        
      *                                                                         
           PERFORM 7320-SELECT-CASHIER    THRU 7320-EXIT.               
           MOVE Y2-LOCAL-OFFICE           TO WS-LOCAL-OFFICE.           
      *                                                                         
           PERFORM 2200-PROCESS-ALL-ROWS  THRU 2200-EXIT.               
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************00085300
      * 2000A-MOVE-RESULT.                                             *03810002
      *     MOVE THE RETURN VALUES                                     *00085400
      ******************************************************************00085500
      *                                                                         
       2000A-MOVE-RESULT.                                               
      *                                                                 00085700
            MOVE  RS-RETURN-CODE    TO S-RETURN-CODE.                   
            MOVE  RS-ACCOUNT-NO     TO S-ACCOUNT-NO.                    
            MOVE  RS-ERROR-MESSAGE1 TO S-ERROR-MESSAGE1.                
            MOVE  RS-ERROR-MESSAGE2 TO S-ERROR-MESSAGE2.                
      *                                                                 00085700
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-PROCESS-ALL-ROWS.                                         *        
      *     RECEIVE INPUT PARMS AND PROCESS THE ACCOUNTS               *00106200
      ******************************************************************        
      *                                                                         
       2200-PROCESS-ALL-ROWS.                                           
      *                                                                         
           INITIALIZE WS-ACCOUNT-NO-COMP3.                              
      *                                                                         
           PERFORM 2205-LOAD-GL-NUMBERS THRU 2205-EXIT.                 
      *                                                                         
           PERFORM 2220-LOAD-DIR-PYMT-TABLE THRU 2220-EXIT.             
      *                                                                         
P0586F     IF PARM-CORRECTION-AMT-DIFF < 0                              
P0586F        COMPUTE WS-AMT-DIFF-NUM = PARM-CORRECTION-AMT-DIFF * -1   
P0586F        MOVE 'Y' TO WS-NEG-DIFF-FLAG                              
P0586F     ELSE                                                         
P0586F        MOVE PARM-CORRECTION-AMT-DIFF TO WS-AMT-DIFF-NUM          
P0586F        MOVE 'N' TO WS-NEG-DIFF-FLAG                              
P0586F     END-IF.                                                      
      *                                                                         
           PERFORM 2201-PROCESS-EACH-ROW  THRU 2201-EXIT                
              VARYING WS-ACCT-SUB FROM 1  BY   1                        
                UNTIL WS-ACCT-SUB GREATER THAN WS-MAX-NO-ROWS.          
      *                                                                         
           IF WS-AMT-DIFF-NUM GREATER THAN 0                            
              PERFORM 5750-JOURNAL-FORMAT-101   THRU 5750-EXIT          
              PERFORM 7775-CHECK-MATCHING-ENTRY THRU 7775-EXIT          
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2201-PROCESS-EACH-ROW.                                         *        
      *     PROCESS EACH ACCOUNT ROW                                   *        
      ******************************************************************        
      *                                                                         
       2201-PROCESS-EACH-ROW.                                           
      *                                                                         
           INITIALIZE TDS-RETURN-FIELDS.                                
           MOVE WS-ACCOUNT-NO-COMP3 TO WS-PREV-ACCOUNT-NO-COMP3.        
           MOVE WS-DIR-PAY-ACCOUNT (WS-ACCT-SUB) TO WS-ACCOUNT-NO.      
           MOVE WS-ACCOUNT-NO-NUM TO WS-ACCOUNT-NO-COMP3.               
           MOVE WS-ACCOUNT-NO-COMP3 TO AT-ACCOUNT-NO.                   
           MOVE 'N' TO WS-PAR-VALIDATE-JRNL.                            
           IF WS-PREV-ACCOUNT-NO-COMP3 NOT = WS-ACCOUNT-NO-COMP3        
              INITIALIZE WS-PAR-TRAN-APPL-NO                            
              INITIALIZE WS-PAR-TRAN-APPL-NO-WO1                        
              INITIALIZE WS-PAR-TRAN-APPL-NO-WO2                        
              MOVE 'Y' TO WS-PAR-VALIDATE-JRNL                          
           END-IF.                                                      
      *                                                                         
           IF WS-ACCT-SUB = 1                                           
              MOVE 'Y' TO WS-PAR-VALIDATE-JRNL                          
           END-IF.                                                      
      *                                                                         
           PERFORM 7000-SELECT-AT-PR-CU THRU 7000-EXIT.                 
           MOVE WS-DIR-CHRG-OFF TO WS-CHRG-OFF-IND.                     
           MOVE WS-ACCOUNT-NO TO RS-ACCOUNT-NO                          
                                 S-ACCOUNT-NO.                          
           MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT.         
           IF WS-CODE-DPP-ACCT = 'A'                                    
              MOVE 'Y' TO WS-DPP-ACCT-IND                               
           END-IF.                                                      
      *                                                                         
           MOVE WS-CLR-CASH-GL-NO (WS-GL-SUB) TO WS-PAR-GEN-LEDG-DB.    
      *                                                                         
           MOVE AT-ACCOUNT-NO TO DL-ACCOUNT-NO.                         
      *                                                                         
           PERFORM 7170-SELECT-RECONNECT THRU 7170-EXIT.                
      *                                                                         
           MOVE WS-DIR-PAY-AMT-CHECK(WS-ACCT-SUB) TO WS-AMOUNT-CHECK.   
           MOVE WS-AMOUNT-CHECK-NUM TO WS-AMOUNT-CHECK-COMP3.           
           MOVE WS-AMOUNT-CHECK-COMP3 TO WS-AMT-CHECK.                  
      *                                                                         
           MOVE WS-DIR-PAY-AMT-MONEY-ORDER (WS-ACCT-SUB)                
                                           TO WS-AMOUNT-MORDER.         
           MOVE WS-AMOUNT-MORDER-NUM       TO WS-AMOUNT-MORDER-COMP3.   
           MOVE WS-AMOUNT-MORDER-COMP3     TO WS-AMT-MONEY-ORDER.       
      *                                                                         
           MOVE WS-DIR-PAY-AMT-CASH (WS-ACCT-SUB)                       
                                           TO WS-AMOUNT-CASH.           
           MOVE WS-AMOUNT-CASH-NUM TO WS-AMOUNT-CASH-COMP3.             
           MOVE WS-AMOUNT-CASH-COMP3 TO WS-AMT-CASH.                    
      *                                                                         
           MOVE WS-DIR-PAY-AMT-CHRG-CARD (WS-ACCT-SUB)                  
                                           TO WS-AMT-CHRG-CARD.         
           MOVE WS-AMT-CHRG-CARD-NUM TO WS-AMT-CHRG-CARD-COMP3.         
           MOVE WS-AMT-CHRG-CARD-COMP3 TO WS-AMT-CREDIT-CARD.           
           ADD WS-AMOUNT-CHECK-COMP3                                    
               WS-AMOUNT-MORDER-COMP3                                   
               WS-AMOUNT-CASH-COMP3                                     
               WS-AMT-CHRG-CARD-COMP3 GIVING WS-PAYMENT-AMOUNT.         
      *                                                                 PCS05720
           MOVE ZERO TO WS-PAYMENT-AMOUNT-TOTAL.                        
           PERFORM VARYING WS-AMT-TOT-SUB FROM 1  BY   1                
                UNTIL WS-AMT-TOT-SUB GREATER THAN WS-MAX-NO-ROWS        
              IF (WS-DIR-PAY-ACCOUNT(WS-AMT-TOT-SUB) = WS-ACCOUNT-NO )  
                 ADD WS-DIR-PAY-AMT(WS-AMT-TOT-SUB) TO                  
                                            WS-PAYMENT-AMOUNT-TOTAL     
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                 PCS05720
           MOVE WS-DIR-PAY-UPDATE-TYPE  (WS-ACCT-SUB) TO                
                                WS-DIR-UPDATE-TYPE                      
           MOVE WS-CLR-CASH-GL-NO(WS-GL-SUB) TO WS-PAR-GEN-LEDG-DB.     
           MOVE 'Y' TO WS-CSH-DRWR-CLOSED.                              
           MOVE SPACES TO WS-OV-SH-TRAN-ID.                             
           IF WS-NEG-DIFF-FLAG = 'Y'                                    
              MOVE WS-CLR-CASH-GL-NO(WS-GL-SUB) TO WS-TEMP-GEN-LEDG-DB  
              MOVE WS-CSH-OV-SH-GL-NO(WS-GL-SUB) TO WS-TEMP-GEN-LEDG-CR 
              SET OVERAGE-TRAN-ID TO TRUE                               
           ELSE                                                         
              MOVE WS-CSH-OV-SH-GL-NO(WS-GL-SUB) TO WS-TEMP-GEN-LEDG-DB 
              MOVE WS-CLR-CASH-GL-NO(WS-GL-SUB) TO WS-TEMP-GEN-LEDG-CR  
              SET SHORTAGE-TRAN-ID TO TRUE                              
           END-IF.                                                      
      *                                                                         
           MOVE WS-DIR-UPDATE-TYPE TO WS-PAR-UPDATE-TYPE.               
           IF WS-DIR-UPDATE-TYPE EQUAL WS-D                             
              MOVE WS-YES TO WS-IS-THIS-DIRECTED-PYMT                   
           ELSE                                                         
              MOVE WS-NO TO WS-IS-THIS-DIRECTED-PYMT                    
              PERFORM 2210-LOAD-PYMT-PRIORITY THRU 2210-EXIT            
      *                                                                         
           END-IF.                                                      
      *                                                                 10680005
           IF WS-PREV-ACCOUNT-NO-COMP3 NOT = WS-ACCOUNT-NO-COMP3        
              PERFORM 7610-GET-CURRENT-TIMESTAMP THRU 7610-EXIT         
           END-IF.                                                      
      *                                                                 10680005
           IF  WS-ACCT-SUB = 1                                          
               MOVE WS-CURRENT-DATE TO WS-CD-REPORT-DATE                
               MOVE 9999 TO WS-CASH-DRAWER-ID                           
               PERFORM 2230-CREATE-AR-FOR-REVERSAL THRU 2230-EXIT       
      *                                                                         
               MOVE 'C' TO AR-CODE-TRAN-TYPE                            
               MOVE ZEROS TO WS-NULL-IND1                               
                             WS-NULL-IND2                               
               MOVE AR-DATE-TRANS TO AR-DATE-ORIG-PYMT                  
                                     WS-PREV-DATE-TRANS                 
               MOVE WS-CURRENT-DATE TO AR-DATE-TRANS                    
               MOVE WS-FROM-CMMNT-TEXT TO AR-TRAN-COMMENT-TEXT          
               MOVE WS-FROM-CMMNT-LEN-NUM TO AR-TRAN-COMMENT-LEN        
               MOVE WS-01 TO AR-CASH-COMPANY-NO                         
               MOVE WS-CURRENT-DATE TO AR-DATE-CASH-REPORT              
               MOVE 9999 TO AR-CASH-DRAWER-ID                           
               MOVE WS-RECORD-ONLY TO AR-RECORD-ONLY-FL                 
               MOVE PF-RESP-AREA-ID TO AR-RESP-AREA-ID                  
               PERFORM 6510A-INSERT-AR-TRANS-HIST THRU 6510A-EXIT       
      *                                                                         
               MOVE SPACE TO AR-RECORD-ONLY-FL                          
               MOVE AR-AMT-ORIG-ENTERED TO WS-AMOUNT-REFUNDED           
               MOVE 'F' TO WS-PART-CASH-PROCESS-FLG                     
               MOVE 'RVR' TO WS-CHECK-CASH-IND                          
               MOVE PARM-USER-ID TO WS-USER-ID                          
               MOVE EIBTRNID TO WS-CSH-DRWR-TRAN-ID                     
               MOVE AR-ACCOUNT-NO TO AU-ACCOUNT-NO                      
                                     AT-ACCOUNT-NO                      
                                     WS-ACCOUNT-NO-COMP3                
              PERFORM 6904-INSERT-AR-DETAILS THRU 6904-EXIT             
      *                                                                         
              PERFORM 7000-SELECT-AT-PR-CU THRU 7000-EXIT               
      *                                                                         
              MOVE WS-ACCOUNT-NO TO AR-ACCOUNT-NO                       
                                    AT-ACCOUNT-NO                       
                                    AC-ACCOUNT-NO                       
                                    AU-ACCOUNT-NO                       
                                    WS-ACCOUNT-NO-COMP3                 
              PERFORM 7000-SELECT-AT-PR-CU THRU 7000-EXIT               
      *                                                                         
              MOVE WS-USER-CMMNT-TEXT TO AR-TRAN-COMMENT-TEXT           
                                         WS-PAR-AR-TRAN-COMMENT-TEXT    
              MOVE WS-USER-CMMNT-LEN-NUM TO AR-TRAN-COMMENT-LEN         
                                            WS-PAR-AR-TRAN-COMMENT-LEN  
           END-IF.                                                      
      *                                                                         
           IF WS-PAYMENT-AMOUNT = 0                                     
              MOVE ZERO TO S-RETURN-CODE                                
              PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
              GO TO 2201-EXIT                                           
           END-IF.                                                      
      *                                                                 10680005
           MOVE WS-USER-CMMNT-LEN-NUM TO WS-JRNL-TRAN-COMMENT-LEN.      
           MOVE WS-USER-CMMNT-TEXT TO WS-JRNL-TRAN-COMMENT-TEXT.        
           PERFORM 5000-UPDATE THRU 5000-EXIT.                          
      *                                                                 10680005
           MOVE WS-PAR-MESSAGE-NO TO RS-ERROR-MESSAGE1.                 
      *                                                                         
ACT285     PERFORM 2950-PROCESS-DNP-RECONNECT     THRU 2950-EXIT        
ACT285     MOVE WS-CNCL-DNP-ACTN-FL TO WS-CANCELDNP-FLAG                
      *                                                                         
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE.                 
           PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT.                   
           PERFORM 8100-SEND-RESULT   THRU 8100-EXIT.                   
           IF WS-ACTIVE-RETURN-CODE = -204                              
              PERFORM 0100-INITIALIZE THRU 0100-EXIT                    
              PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                 
           END-IF.                                                      
      *                                                                         
       2201-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11980016
      ******************************************************************        
      * 2205-LOAD-GL-NUMBERS.                                          *        
      *     LOAD ALL G/L NUMBER, INCLUDING CHARGED OFF.                *        
      ******************************************************************        
      *                                                                 11980016
       2205-LOAD-GL-NUMBERS.                                            
      *                                                                 11980016
           PERFORM 9350-LINK-SCSCO061 THRU 9350-EXIT.                   
      *                                                                 11980016
           PERFORM VARYING WS-VALID-CO-SUB FROM 1 BY 1                  
              UNTIL WS-VALID-CO-SUB > 5                                 
                 OR WS-VALID-CO-NO (WS-VALID-CO-SUB) = '01'             
                    OR WS-VALID-CO-NO (WS-VALID-CO-SUB) = WS-GL-99      
             IF WS-VALID-CO-NO (WS-VALID-CO-SUB) = '01'                 
                MOVE WS-Y TO WS-COMPANY-IN-TABLE                        
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                         
       2205-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2210-LOAD-PYMT-PRIORITY.                                       *        
      *     LOAD THE PAYMENT PRIORITY TABLE                            *        
      *     USE PARM-UPDATE-TYPE TO DECIDE WHICH SET TO LOAD:          *        
      *      B FOR BILLED, A FOR ARREARS, AND U FOR UNDIRECTED.        *        
      *     SCHEDULE 1 IS FOR BILLED AND UNDIRECTED DUE TO THE ORDER   *        
      *     PAYMENT IS POSTED.  SCHEDULE 2 IS FOR ARREARS WHICH PAYS   *        
      *     OFF ALL 90 DAY FIRST, THEN 60 DAYS, ETC.                   *        
      ******************************************************************        
      *                                                                         
       2210-LOAD-PYMT-PRIORITY.                                         
      *                                                                         
           IF WS-DIR-UPDATE-TYPE EQUAL WS-A                             
              MOVE 2 TO C9-PMT-PRTY-SCHEDULE                            
           ELSE                                                         
              MOVE 1 TO C9-PMT-PRTY-SCHEDULE                            
           END-IF.                                                      
      *                                                                         
           PERFORM 6722B-OPEN-AR-PMT-PRTY THRU 6722B-EXIT.              
      *                                                                         
           PERFORM 6722C-FETCH-AR-PMT-PRTY THRU 6722C-EXIT.             
      *                                                                         
           PERFORM 6722D-LOAD-AR-PMT-PRTY THRU 6722D-EXIT               
              VARYING WS-PAR-SUB FROM 1 BY 1                            
                 UNTIL WS-PAR-SUB GREATER THAN 52                       
                    OR WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.           
      *                                                                         
           PERFORM 6722E-CLOSE-AR-PMT-PRTY THRU 6722E-EXIT.             
      *                                                                         
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2220-LOAD-DIR-PYMT-TABLE.                                      *        
      *     RECEIVE THE DIRECTED PAYMENT VALUES FROM THE INPUT PARMS   *00106200
      *     FOR PROCESSING                                             *00106200
      ******************************************************************        
      *                                                                         
       2220-LOAD-DIR-PYMT-TABLE.                                        
      *                                                                         
           PERFORM VARYING WS-LOAD-SUB FROM 1 BY 1                      
                   UNTIL WS-LOAD-SUB GREATER THAN WS-MAX-NO-ROWS        
                                                                        
             EVALUATE WS-LOAD-SUB                                       
                WHEN 1                                                  
                    IF PARM-PAY-CORR-ROW-1 EQUAL SPACES                 
                       INITIALIZE WS-DIR-BREAKDOWN                      
                    ELSE                                                
                       MOVE PARM-PAY-CORR-ROW-1 TO WS-DIR-BREAKDOWN     
                    END-IF                                              
                WHEN 2                                                  
                    IF PARM-PAY-CORR-ROW-2 EQUAL SPACES                 
                       INITIALIZE WS-DIR-BREAKDOWN                      
                    ELSE                                                
                       MOVE PARM-PAY-CORR-ROW-2 TO WS-DIR-BREAKDOWN     
                    END-IF                                              
                WHEN 3                                                  
                    IF PARM-PAY-CORR-ROW-3 EQUAL SPACES                 
                       INITIALIZE WS-DIR-BREAKDOWN                      
                    ELSE                                                
                       MOVE PARM-PAY-CORR-ROW-3 TO WS-DIR-BREAKDOWN     
                    END-IF                                              
                WHEN 4                                                  
                    IF PARM-PAY-CORR-ROW-4 EQUAL SPACES                 
                       INITIALIZE WS-DIR-BREAKDOWN                      
                    ELSE                                                
                       MOVE PARM-PAY-CORR-ROW-4 TO WS-DIR-BREAKDOWN     
                    END-IF                                              
                WHEN 5                                                  
                    IF PARM-PAY-CORR-ROW-5 EQUAL SPACES                 
                       INITIALIZE WS-DIR-BREAKDOWN                      
                    ELSE                                                
                       MOVE PARM-PAY-CORR-ROW-5 TO WS-DIR-BREAKDOWN     
                    END-IF                                              
                WHEN 6                                                  
                    IF PARM-PAY-CORR-ROW-6 EQUAL SPACES                 
                       INITIALIZE WS-DIR-BREAKDOWN                      
                    ELSE                                                
                       MOVE PARM-PAY-CORR-ROW-6 TO WS-DIR-BREAKDOWN     
                    END-IF                                              
                WHEN 7                                                  
                    IF PARM-PAY-CORR-ROW-7 EQUAL SPACES                 
                       INITIALIZE WS-DIR-BREAKDOWN                      
                    ELSE                                                
                       MOVE PARM-PAY-CORR-ROW-7 TO WS-DIR-BREAKDOWN     
                    END-IF                                              
                WHEN 8                                                  
                    IF PARM-PAY-CORR-ROW-8 EQUAL SPACES                 
                       INITIALIZE WS-DIR-BREAKDOWN                      
                    ELSE                                                
                       MOVE PARM-PAY-CORR-ROW-8 TO WS-DIR-BREAKDOWN     
                    END-IF                                              
                WHEN 9                                                  
                    IF PARM-PAY-CORR-ROW-9 EQUAL SPACES                 
                       INITIALIZE WS-DIR-BREAKDOWN                      
                    ELSE                                                
                       MOVE PARM-PAY-CORR-ROW-9 TO WS-DIR-BREAKDOWN     
                    END-IF                                              
                WHEN 10                                                 
                    IF PARM-PAY-CORR-ROW-10 EQUAL SPACES                
                       INITIALIZE WS-DIR-BREAKDOWN                      
                    ELSE                                                
                       MOVE PARM-PAY-CORR-ROW-10 TO WS-DIR-BREAKDOWN    
                    END-IF                                              
                WHEN 11                                                 
                    IF PARM-PAY-CORR-ROW-11 EQUAL SPACES                
                       INITIALIZE WS-DIR-BREAKDOWN                      
                    ELSE                                                
                       MOVE PARM-PAY-CORR-ROW-11 TO WS-DIR-BREAKDOWN    
                    END-IF                                              
                WHEN 12                                                 
                    IF PARM-PAY-CORR-ROW-12 EQUAL SPACES                
                       INITIALIZE WS-DIR-BREAKDOWN                      
                    ELSE                                                
                       MOVE PARM-PAY-CORR-ROW-12 TO WS-DIR-BREAKDOWN    
                    END-IF                                              
                WHEN 13                                                 
                    IF PARM-PAY-CORR-ROW-13 EQUAL SPACES                
                       INITIALIZE WS-DIR-BREAKDOWN                      
                    ELSE                                                
                       MOVE PARM-PAY-CORR-ROW-13 TO WS-DIR-BREAKDOWN    
                    END-IF                                              
                WHEN 14                                                 
                    IF PARM-PAY-CORR-ROW-14 EQUAL SPACES                
                       INITIALIZE WS-DIR-BREAKDOWN                      
                    ELSE                                                
                       MOVE PARM-PAY-CORR-ROW-14 TO WS-DIR-BREAKDOWN    
                    END-IF                                              
                WHEN 15                                                 
                    IF PARM-PAY-CORR-ROW-15 EQUAL SPACES                
                       INITIALIZE WS-DIR-BREAKDOWN                      
                    ELSE                                                
                       MOVE PARM-PAY-CORR-ROW-15 TO WS-DIR-BREAKDOWN    
                    END-IF                                              
                WHEN 16                                                 
                    IF PARM-PAY-CORR-ROW-16 EQUAL SPACES                
                       INITIALIZE WS-DIR-BREAKDOWN                      
                    ELSE                                                
                       MOVE PARM-PAY-CORR-ROW-16 TO WS-DIR-BREAKDOWN    
                    END-IF                                              
                WHEN 17                                                 
                    IF PARM-PAY-CORR-ROW-17 EQUAL SPACES                
                       INITIALIZE WS-DIR-BREAKDOWN                      
                    ELSE                                                
                       MOVE PARM-PAY-CORR-ROW-17 TO WS-DIR-BREAKDOWN    
                    END-IF                                              
                WHEN 18                                                 
                    IF PARM-PAY-CORR-ROW-18 EQUAL SPACES                
                       INITIALIZE WS-DIR-BREAKDOWN                      
                    ELSE                                                
                       MOVE PARM-PAY-CORR-ROW-18 TO WS-DIR-BREAKDOWN    
                    END-IF                                              
                WHEN 19                                                 
                    IF PARM-PAY-CORR-ROW-19 EQUAL SPACES                
                       INITIALIZE WS-DIR-BREAKDOWN                      
                    ELSE                                                
                       MOVE PARM-PAY-CORR-ROW-19 TO WS-DIR-BREAKDOWN    
                    END-IF                                              
                WHEN 20                                                 
                    IF PARM-PAY-CORR-ROW-20 EQUAL SPACES                
                       INITIALIZE WS-DIR-BREAKDOWN                      
                    ELSE                                                
                       MOVE PARM-PAY-CORR-ROW-20 TO WS-DIR-BREAKDOWN    
                    END-IF                                              
                WHEN OTHER                                              
                    INITIALIZE WS-DIR-BREAKDOWN                         
             END-EVALUATE                                               
      *                                                                         
             MOVE WS-DIR-ACCOUNT-NO TO WS-DIR-PAY-ACCOUNT (WS-LOAD-SUB) 
             MOVE WS-DIR-PYMT-PRTY-LVL TO                               
                           WS-DIR-PAY-PYMT-PRTY-LVL (WS-LOAD-SUB)       
             MOVE WS-DIR-ITEM-ID-NUM TO WS-DIR-PAY-ITEM-ID (WS-LOAD-SUB)
             MOVE WS-DIR-AMT-PYMT-NUM TO WS-DIR-PAY-AMT (WS-LOAD-SUB)   
             MOVE WS-DIR-CURRENCY TO WS-DIR-PAY-CURRENCY (WS-LOAD-SUB)  
             MOVE WS-DIR-UPDATE-TYPE TO                                 
                           WS-DIR-PAY-UPDATE-TYPE (WS-LOAD-SUB)         
             MOVE WS-DIR-AMT-CHECK TO WS-DIR-PAY-AMT-CHECK (WS-LOAD-SUB)
             MOVE WS-DIR-AMT-MO TO                                      
                           WS-DIR-PAY-AMT-MONEY-ORDER (WS-LOAD-SUB)     
             MOVE WS-DIR-AMT-CHRG-CARD TO                               
                           WS-DIR-PAY-AMT-CHRG-CARD (WS-LOAD-SUB)       
             MOVE WS-DIR-AMT-CASH TO WS-DIR-PAY-AMT-CASH (WS-LOAD-SUB)  
             MOVE WS-CHRG-OFF-IND TO WS-DIR-PAY-CHRG-OFF (WS-LOAD-SUB)  
             MOVE WS-DIR-LAST-UPD-TS TO                                 
                           WS-DIR-PAY-LAST-UPDATE-TS (WS-LOAD-SUB)      
             IF FIRST-JRNL                                              
                MOVE WS-DIR-CURRENCY TO WS-TEMP-CURR                    
                MOVE 'N' TO WS-FIRST-TIME-JRNL                          
             END-IF                                                     
      *                                                                         
             IF WS-DIR-CURRENCY NOT EQUAL WS-TEMP-CURR                  
                MOVE 'N' TO WS-JRNL-FLAG                                
             END-IF                                                     
      *                                                                         
             IF WS-5272-CHECK = 'Y'                                     
                INITIALIZE SCSCA182-LINK-RECORD                         
                MOVE WS-DIR-PAY-ACCOUNT (WS-LOAD-SUB) TO                
                                             SCSCA182-ACCOUNT-NO        
      *                                                                         
                PERFORM 9200-LINK-SCSCA182 THRU 9200-EXIT               
                IF SCSCA182-RETURN-CODE NOT EQUAL TO ZERO               
                   MOVE PROGRAM-NAME TO ABEND-PROGRAM                   
                   MOVE SCSCA182-RETURN-CODE TO WS-ACTIVE-RETURN-CODE   
                                                RS-RETURN-CODE          
                                                SQLCODE                 
                   PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT            
                   PERFORM 8100-SEND-RESULT THRU 8100-EXIT              
                   PERFORM 9999-END-PROGRAM THRU 9999-EXIT              
                ELSE                                                    
                   MOVE SCSCA182-LAST-UPDATE-TS TO WS-LAST-UPDATE-TS    
                   IF WS-DIR-PAY-LAST-UPDATE-TS (WS-LOAD-SUB)           
                                         = WS-LAST-UPDATE-TS            
                   OR WS-DIR-PAY-LAST-UPDATE-TS (WS-LOAD-SUB)           
                                         = 'STRESS'                     
                      CONTINUE                                          
                   ELSE                                                 
                      MOVE SCSCA182-RETURN-CODE TO WS-ACTIVE-RETURN-CODE
                                                   SQLCODE              
                      MOVE '5272' TO RS-ERROR-MESSAGE1                  
                      PERFORM 9000A-SEND-ERROR-RESULT THRU 9000A-EXIT   
                   END-IF                                               
                END-IF                                                  
                IF WS-LOAD-SUB = WS-MAX-NO-ROWS                         
                   MOVE 'N' TO WS-5272-CHECK                            
                END-IF                                                  
             END-IF                                                     
      *                                                                         
           END-PERFORM.                                                 
      *                                                                         
       2220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2230-CREATE-AR-FOR-REVERSAL.                                   *        
      *     CREATES CLOSED DRAWER USED FOR REVERSAL OF PAYMENT TO BE   *07430000
      *     CORRECTED                                                  *07430000
      ******************************************************************        
      *                                                                         
       2230-CREATE-AR-FOR-REVERSAL.                                     
      *                                                                         
           MOVE PARM-TRANS-HIST-SEQ-NO TO AR-TRANS-HIST-SEQ-NO          
                                          WS-INPUT-TRANS-HIST-SEQ-NO    
                                          WS-PREV-TRANS-HIST-SEQ-NO.    
           MOVE PARM-FROM-ACCOUNT-NO TO AR-ACCOUNT-NO.                  
           PERFORM 7600-SELECT-AR-TRANS-HIST THRU 7600-EXIT.            
      *                                                                         
           MOVE AR-CASH-COMPANY-NO TO WS-AR-CASH-COMPANY-NO             
                                      OH-CASH-COMPANY-NO                
                                      WS-CD-COMPANY-NO.                 
           MOVE AR-CASH-LOCAL-OFFICE TO WS-AR-CASH-LOCAL-OFFICE         
                                        OH-CASH-LOCAL-OFFICE            
                                        WS-CD-LOCAL-OFFICE              
                                        WS-CD-REPORT-NO.                
           MOVE AR-DATE-CASH-REPORT TO WS-AR-DATE-CASH-REPORT           
                                       OH-DATE-CASH-REPORT.             
           MOVE AR-CASH-DRAWER-ID TO WS-AR-CASH-DRAWER-ID               
                                     OH-CASH-DRAWER-ID.                 
           MOVE AR-ACCOUNT-NO TO OH-ACCOUNT-NO.                         
           PERFORM 2240-CREATE-REPORT-DRWR THRU 2240-EXIT.              
      *                                                                         
           IF CS-CASH-LOCAL-OFFICE = '998'                              
              MOVE CS-CODE-CSH-DRWR-STAT TO WS-JRNL-OPER-ACTIVE         
           ELSE                                                         
              MOVE WS-C TO WS-JRNL-OPER-ACTIVE                          
           END-IF.                                                      
      *                                                                         
           IF AR-DATE-ORIG-PYMT EQUAL SPACES                            
              MOVE -1 TO WS-NULL-IND1                                   
                         WS-DATE-ORIG-PYMT-IND                          
           END-IF.                                                      
      *                                                                         
           IF AR-DATE-TRANS EQUAL SPACES                                
              MOVE -1 TO WS-NULL-IND2                                   
           END-IF.                                                      
      *                                                                         
           IF AR-DATE-CASH-REPORT EQUAL SPACES                          
              MOVE -1 TO WS-NULL-IND3                                   
           END-IF.                                                      
      *                                                                 02504831
           MOVE 'Y' TO AR-PYMT-REFUNDED-IND.                            
           MOVE PARM-USER-ID TO AR-USER-ID.                             
           MOVE 'PANEL373C' TO AR-APPL-PROGRAM-ID.                      
           PERFORM 7950-PROCESS-RECORD-ONLY THRU 7950-EXIT.             
      *                                                                 02504831
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE 'Y' TO WS-RECORD-ONLY                                
           END-IF.                                                      
      *                                                                 02504831
           MOVE WS-RECORD-ONLY TO AR-RECORD-ONLY-FL.                    
           MOVE PARM-USER-ID TO WS-JRNL-OL-TEMP-ID.                     
           PERFORM 6415-SELECT-TERMOP THRU 6415-EXIT.                   
      *                                                                 02504831
           MOVE PF-RESP-AREA-ID TO AR-RESP-AREA-ID.                     
           PERFORM 7605-UPDATE-AR-TRANS-HIST THRU 7605-EXIT.            
      *                                                                 02504831
           MOVE AR-TRANS-HIST-SEQ-NO(1:10) TO WS-DATE.                  
           MOVE AR-TRANS-HIST-SEQ-NO(12:8) TO WS-TIME.                  
           PERFORM 7951-GET-ADJ-ROW THRU 7951-EXIT.                     
      *                                                                 02504831
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR WS-FOUND-MULT-BILLS                                       
              MOVE WS-ADJ-TRANS-HIST-SEQ-NO TO AR-TRANS-HIST-SEQ-NO     
              MOVE 'PANEL113H' TO AR-APPL-PROGRAM-ID                    
              PERFORM 7605-UPDATE-AR-TRANS-HIST THRU 7605-EXIT          
           END-IF.                                                      
      *                                                                         
           MOVE SPACE TO AR-RECORD-ONLY-FL.                             
           IF WS-PREV-ACCOUNT-NO-COMP3 NOT = WS-ACCOUNT-NO-COMP3        
              PERFORM 7610-GET-CURRENT-TIMESTAMP THRU 7610-EXIT         
           END-IF.                                                      
      *                                                                         
           MOVE 'PANEL373' TO AR-APPL-PROGRAM-ID.                       
      *                                                                         
       2230-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2240-CREATE-REPORT-DRWR                                        *        
      *     CHECKS FOR VALID CASH DRAWER AND CASH REPORT FOR GIVEN CASH*        
      *     LOCAL OFFICE AND CASH REPORT DATE.  IF NOT AVAILABLE IT    *        
      *     CREATES NEW BATCH AND REPORT.                              *        
      ******************************************************************        
      *                                                                         
       2240-CREATE-REPORT-DRWR.                                         
      *                                                                         
           MOVE WS-CURRENT-DATE TO CS-DATE-CASH-REPORT                  
                                   YR-DATE-CASH-REPORT.                 
           MOVE AR-CASH-LOCAL-OFFICE TO CS-CASH-LOCAL-OFFICE            
                                        CS-CASH-REPORT-NO               
                                        YR-CASH-LOCAL-OFFICE            
                                        Y2-CASH-LOCAL-OFFICE.           
           MOVE WS-01 TO CS-CASH-COMPANY-NO                             
                         YR-CASH-COMPANY-NO                             
                         Y2-CASH-COMPANY-NO.                            
           PERFORM 7320-SELECT-CASHIER THRU 7320-EXIT.                  
      *                                                                         
           PERFORM 7020-SELECT-CASH-DRWR THRU 7020-EXIT.                
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              PERFORM 7325-SELECT-CASH-REPORT THRU 7325-EXIT            
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE Y2-USER-ID TO YR-USER-ID                          
                 MOVE WS-A TO YR-STATUS                                 
                 PERFORM 8325-CREATE-CASH-REPORT THRU 8325-EXIT         
              END-IF                                                    
      *                                                                         
              INITIALIZE DCLCSS-CSH-DRWR-CNTL                           
              MOVE WS-01 TO CS-CASH-COMPANY-NO                          
              MOVE WS-CURRENT-DATE TO CS-DATE-CASH-REPORT               
                                      CS-DATE-LAST-ACTIVITY             
              MOVE AR-CASH-LOCAL-OFFICE TO CS-CASH-LOCAL-OFFICE         
                                           CS-CASH-REPORT-NO            
              MOVE 9999 TO CS-CASH-DRAWER-ID                            
              MOVE WS-C TO CS-CODE-CSH-DRWR-STAT                        
              MOVE Y2-USER-ID TO CS-USER-ID                             
              MOVE SPACES TO CS-CASHIER-CODE                            
              MOVE WS-NO TO CS-CODE-FCS-EXTRACTED                       
              MOVE SPACES TO CS-BALANCED-BY                             
              MOVE AR-PYMT-FACILITY-CD TO CS-CODE-PYMT-FACILITY         
              MOVE -1 TO WS-NULL-BAL-TS                                 
              PERFORM 8010-CREATE-NEW-BATCH THRU 8010-EXIT              
           END-IF.                                                      
      *                                                                         
       2240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2950-PROCESS-DNP-RECONNECT.                                    *        
ACT285*     CALLS SUB PROGRAM MCS03414 TO HANDLE DNP/RECONNECT REAL-   *        
      *     TIME                                                       *        
      ******************************************************************        
      *                                                                         
       2950-PROCESS-DNP-RECONNECT.                                      
      *                                                                         
ACT285* Populate WS variable to call CPD03414                                   
           MOVE 0 TO WS-DNP-RET-CODE.                                   
           MOVE AT-ACCOUNT-NO TO WS-ACCOUNT-NO-NUM.                     
           MOVE 'P'                         TO WS-UPDATE-ACTION-FL.     
ACT285     MOVE 'O'                         TO WS-CALL-TYPE.            
ACT285     MOVE 'Y'                         TO WS-CPD68-REQUIRED.       
ACT285     MOVE PROGRAM-NAME                TO WS-PROGRAM-NAME.         
ACT285     MOVE SPACES                      TO ws-APPL-PROGRAM-ID.      
P00948     MOVE 'N'                         TO WS-CNCL-DNP-EMAIL-REQ-FL 
                                                                        
ACT285     PERFORM 9800-CALL-MCS03414 THRU 9800-EXIT.                   
      *                                                                         
           IF WS-DNP-RET-CODE > 0                                       
              MOVE WS-DNP-RET-CODE TO RS-ERROR-MESSAGE2                 
           END-IF.                                                      
      *                                                                         
       2950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5000-UPDATE.                                                   *        
      *     CALLS THE PARAGRAPHS THAT PERFORM THE JOURNALLING          *        
      ******************************************************************        
      *                                                                         
       5000-UPDATE.                                                     
      *                                                                         
           MOVE '5000' TO ACTIVE-PARAGRAPH.                             
           MOVE WS-01 TO YR-CASH-COMPANY-NO                             
                         Y2-CASH-COMPANY-NO.                            
           MOVE AR-CASH-LOCAL-OFFICE TO YR-CASH-LOCAL-OFFICE            
                                        Y2-CASH-LOCAL-OFFICE.           
           PERFORM 7320-SELECT-CASHIER THRU 7320-EXIT.                  
      *                                                                         
           MOVE Y2-USER-ID TO YR-USER-ID.                               
           MOVE WS-CURRENT-DATE TO YR-DATE-CASH-REPORT.                 
           MOVE WS-C TO YR-STATUS.                                      
           PERFORM 7325-SELECT-CASH-REPORT THRU 7325-EXIT.              
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 8325-CREATE-CASH-REPORT THRU 8325-EXIT            
           END-IF.                                                      
      *                                                                         
           MOVE AT-COMPANY-NO TO WS-100-COMPANY-NO.                     
           MOVE EIBTRNID TO WS-PAR-EIBTRNID.                            
           MOVE 9 TO WS-TRAN-OPER-LEVEL.                                
           MOVE 1 TO WS-TRAN-OCAP-FIELD.                                
           MOVE 1 TO WS-TRAN-OCAP-VALUE.                                
           MOVE WS-C TO WS-TRAN-JRNL-TYPE.                              
           MOVE WS-N TO WS-TRAN-HOLD-EXEMPT-FLAG.                       
           MOVE PARM-USER-ID TO WS-JRNL-OL-TEMP-ID.                     
           MOVE WS-JRNL-CK-OPER-ID TO WS-JRNL-OPERATION-RQST.           
           IF WS-PAR-VALIDATE-JRNL  = 'Y'                               
              PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT           
           END-IF.                                                      
      *                                                                         
           MOVE WS-JRNL-OL-OPR-LOC TO WS-TERM-LOC.                      
           MOVE WS-01 TO WS-JRNL-OL-COMPANY.                            
           MOVE AR-CASH-LOCAL-OFFICE TO WS-JRNL-OL-LOC-OFF.             
           MOVE AR-CASH-LOCAL-OFFICE TO WS-JRNL-OL-REPORT-NO.           
           MOVE WS-CURRENT-DATE TO WS-JRNL-OL-REPORT-DT.                
           MOVE 9999 TO WS-JRNL-OL-CASH-DRWR.                           
           MOVE WS-TERM-LOC TO WS-JRNL-OL-TERM-LOC                      
                               WS-JRNL-OL-CASH-LOC                      
                               WS-JRNL-OL-OPR-LOC.                      
           MOVE WS-JRNL-VALIDATE-OPER TO WS-JRNL-OPERATION-RQST.        
           MOVE WS-C TO WS-JRNL-SOURCE-CODE.                            
           IF CASH-TRANSACTION                                          
              MOVE WS-JRNL-CASH-UPDATE TO WS-JRNL-OL-AUTH-TYPE          
           ELSE                                                         
              MOVE WS-JRNL-NON-CASH-UPDATE TO WS-JRNL-OL-AUTH-TYPE      
           END-IF.                                                      
      *                                                                         
           IF WS-PAR-VALIDATE-JRNL = 'Y'                                
              PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT           
           END-IF.                                                      
      *                                                                         
           MOVE WS-A TO WS-100-JRNL-SORT-ID.                            
           MOVE AT-ACCOUNT-NO TO WS-100-ACCT-NO.                        
           MOVE AT-CUSTOMER-NO TO WS-100-CUSTOMER-NO.                   
           MOVE AT-PREMISE-NO TO WS-100-PREMISE-NO.                     
           MOVE EIBTRNID TO WS-100-CODE-TERMINAL-TRAN.                  
           ADD 1 TO WS-100-JRNL-TRAN-APPL-NO.                           
           MOVE WS-CURRENT-DATE TO WS-100-DATE-LAST-ACTION              
                                   AT-DATE-LAST-ACTION.                 
           MOVE WS-C TO WS-100-CODE-ENTRY-SOURCE.                       
           MOVE AT-LOCAL-OFFICE TO WS-100-LOCAL-OFFICE-CD.              
      *                                                                         
           MOVE WS-JRNL-OL-COMPANY TO WS-PAR-COMPANY-NO.                
           MOVE WS-JRNL-OL-LOC-OFF TO WS-PAR-LOCAL-OFFICE.              
           MOVE WS-JRNL-OL-REPORT-NO TO WS-PAR-REPORT-NO.               
           MOVE WS-JRNL-OL-REPORT-DT TO WS-PAR-REPORT-DATE.             
           MOVE WS-JRNL-OL-CASH-DRWR TO WS-PAR-CASH-DRAWER.             
           MOVE WS-TERM-LOC TO WS-PAR-ACCESS-LOC.                       
           MOVE PARM-USER-ID TO WS-PAR-OPERATOR-ID.                     
           MOVE PF-RESP-AREA-ID TO WS-PAR-RESP-AREA.                    
           MOVE 'PANEL373' TO WS-PAR-APPL-PROG-ID.                      
           MOVE AR-PYMT-FACILITY-CD TO WS-PAR-PYMT-FACILITY-CD.         
           MOVE WS-PAR-P TO WS-PAR-CODE-TRAN-TYPE.                      
      *                                                                         
           COMPUTE                                                      
                WS-ACCT-SUB-PLUS1 = WS-ACCT-SUB + 1                     
           END-COMPUTE.                                                 
      *                                                                         
           MOVE 'N' TO WS-JRNL-CNTL.                                    
           IF WS-ACCT-SUB = WS-MAX-NO-ROWS                              
              MOVE 'Y' TO WS-JRNL-CNTL                                  
           ELSE                                                         
              IF WS-DIR-PAY-ACCOUNT (WS-ACCT-SUB) NOT =                 
                WS-DIR-PAY-ACCOUNT (WS-ACCT-SUB-PLUS1)                  
                 MOVE 'Y'  TO WS-JRNL-CNTL                              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF DIRECTED-PYMT                                             
              PERFORM 5010-PAYMENT-LOOP THRU 5010-EXIT                  
           ELSE                                                         
              PERFORM 6700-APPLY-PAYMENT THRU 6700-EXIT                 
              MOVE WS-PAR-MESSAGE-NO TO RS-ERROR-MESSAGE1               
              PERFORM 5001-CHECK-PAYMENT-RETURN THRU 5001-EXIT          
              IF WS-JRNL-CNTL = 'Y'                                     
                 MOVE WS-JRNL-CNTRL-ONLY TO WS-JRNL-OPERATION-RQST      
                 PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT        
                 IF WS-JRNL-RTRN-CODE EQUAL SPACES                      
                    NEXT SENTENCE                                       
                 ELSE                                                   
                    MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
                    MOVE 'USERABEN'            TO ABEND-FUNCTION        
                    MOVE WS-YES                TO WS-USER-FORCE-ABEND   
                    MOVE SPACES                TO DSNTIAR-MESSAGE-1     
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5001-CHECK-PAYMENT-RETURN.                                     *        
      *     CHECKS THE PAYMENT POSTING RETURN CODE                     *        
      ******************************************************************        
      *                                                                         
       5001-CHECK-PAYMENT-RETURN.                                       
      *                                                                         
           MOVE '5001' TO ACTIVE-PARAGRAPH.                             
           IF PYMT-WAS-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-PAR-MESSAGE-NO          TO RS-ERROR-MESSAGE1      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'USERABEN'                 TO ABEND-FUNCTION         
              MOVE WS-YES                     TO WS-USER-FORCE-ABEND    
              MOVE 'PAYMENT ABEND'            TO DSNTIAR-MESSAGE-1      
              PERFORM 9000A-SEND-ERROR-RESULT THRU 9000A-EXIT           
           END-IF.                                                      
      *                                                                         
       5001-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5010-PAYMENT-LOOP.                                             *        
      *     THE PAYMENT POSTING ROUTINE                                *        
      ******************************************************************        
      *                                                                         
       5010-PAYMENT-LOOP.                                               
      *                                                                         
           MOVE '5010' TO ACTIVE-PARAGRAPH.                             
           IF WS-DIR-PAY-PYMT-PRTY-LVL (WS-ACCT-SUB) = 70               
              MOVE 1 TO AC-ITEM-ID                                      
              PERFORM 7630-SELECT-CIA-IN-AR-CNTL THRU 7630-EXIT         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 PERFORM 8000-INSERT-CIA-IN-AR-CNTL THRU 8000-EXIT      
                 MOVE ZEROES TO AC-ITEM-ID                              
                 PERFORM 7630-SELECT-CIA-IN-AR-CNTL THRU 7630-EXIT      
                 IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND               
                    PERFORM 8000-INSERT-CIA-IN-AR-CNTL THRU 8000-EXIT   
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
           MOVE WS-DIR-PAY-AMT (WS-ACCT-SUB)   TO WS-PAYMENT-AMOUNT.    
           MOVE WS-DIR-PAY-PYMT-PRTY-LVL(WS-ACCT-SUB) TO WS-PAR-TYPE.   
           MOVE WS-DIR-PAY-ITEM-ID (WS-ACCT-SUB) TO WS-PAR-TYPE-NO.     
           MOVE WS-DIR-PAY-CHRG-OFF (WS-ACCT-SUB) TO                    
                                            WS-PAR-PAY-CHRG-OFF.        
           PERFORM 6700-APPLY-PAYMENT THRU 6700-EXIT.                   
      *                                                                         
           MOVE WS-PAR-MESSAGE-NO TO RS-ERROR-MESSAGE1.                 
           IF FIRST-PAYMENT                                             
              MOVE WS-NO TO WS-FIRST-PAYMENT                            
              PERFORM 5001-CHECK-PAYMENT-RETURN THRU 5001-EXIT          
           ELSE                                                         
              IF PYMT-WAS-SUCCESSFUL                                    
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE WS-PAR-MESSAGE-NO          TO RS-ERROR-MESSAGE1   
                 MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
                 MOVE 'USERABEN'              TO ABEND-FUNCTION         
                 MOVE WS-YES                  TO WS-USER-FORCE-ABEND    
                 MOVE 'PAYMENT ABEND'         TO DSNTIAR-MESSAGE-1      
                 PERFORM 9000A-SEND-ERROR-RESULT THRU 9000A-EXIT        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF WS-JRNL-CNTL = 'Y'                                        
             MOVE WS-JRNL-CNTRL-ONLY TO WS-JRNL-OPERATION-RQST          
             PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT            
             IF WS-JRNL-RTRN-CODE EQUAL SPACES                          
                NEXT SENTENCE                                           
             ELSE                                                       
                MOVE PROGRAM-NAME            TO ABEND-PROGRAM           
                MOVE 'USERABEN'              TO ABEND-FUNCTION          
                MOVE WS-YES                  TO WS-USER-FORCE-ABEND     
                MOVE SPACES                  TO DSNTIAR-MESSAGE-1       
                PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT             
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
           MOVE ZERO TO WS-PAR-TYPE-NO.                                 
      *                                                                         
       5010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5020-PAYMENT-NSC.                                              *        
      ******************************************************************        
      *                                                                         
       5020-PAYMENT-NSC.                                                
      *                                                                         
           MOVE '5020' TO ACTIVE-PARAGRAPH.                             
           MOVE ZERO TO WS-AMT-CHECK                                    
                        WS-AMT-MONEY-ORDER                              
                        WS-AMT-CASH                                     
                        WS-AMT-CREDIT-CARD.                             
           MOVE WS-D TO WS-DIR-UPDATE-TYPE.                             
           MOVE WS-YES TO WS-IS-THIS-DIRECTED-PYMT.                     
           MOVE NH-NSF-CHARGE-AMT TO WS-PAYMENT-AMOUNT                  
                                     WS-PAYMENT-AMOUNT-TOTAL            
                                     WS-AMT-CASH.                       
           MOVE 'N' TO WS-PAR-APPLYING-CREDIT-SW.                       
           MOVE WS-A TO WS-PAR-CODE-TRAN-TYPE.                          
           MOVE WS-NSC TO WS-PAR-TYPE.                                  
           MOVE ZERO TO WS-PAR-TYPE-NO.                                 
           MOVE SPACES TO WS-PAR-PAY-CHRG-OFF.                          
           PERFORM 6700-APPLY-PAYMENT THRU 6700-EXIT.                   
      *                                                                         
           MOVE WS-PAR-MESSAGE-NO TO RS-ERROR-MESSAGE1.                 
           IF FIRST-PAYMENT                                             
              MOVE WS-NO TO WS-FIRST-PAYMENT                            
              PERFORM 5001-CHECK-PAYMENT-RETURN THRU 5001-EXIT          
           ELSE                                                         
              IF PYMT-WAS-SUCCESSFUL                                    
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
                 MOVE 'USERABEN'              TO ABEND-FUNCTION         
                 MOVE WS-YES                  TO WS-USER-FORCE-ABEND    
                 MOVE 'PAYMENT ABEND'         TO DSNTIAR-MESSAGE-1      
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT            
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE WS-JRNL-CNTRL-ONLY TO WS-JRNL-OPERATION-RQST.           
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
      *                                                                         
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE 'USERABEN'              TO ABEND-FUNCTION            
              MOVE WS-YES                  TO WS-USER-FORCE-ABEND       
              MOVE SPACES                  TO DSNTIAR-MESSAGE-1         
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
      *                                                                         
       5020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5030-PAYMENT-REMAINING-NSC.                                    *        
      ******************************************************************        
      *                                                                         
       5030-PAYMENT-REMAINING-NSC.                                      
      *                                                                         
           MOVE '5030' TO ACTIVE-PARAGRAPH.                             
           MOVE ZERO TO WS-AMT-CHECK                                    
                        WS-AMT-MONEY-ORDER                              
                        WS-AMT-CASH                                     
                        WS-AMT-CREDIT-CARD.                             
           MOVE WS-U TO WS-DIR-UPDATE-TYPE.                             
           MOVE WS-NO TO WS-IS-THIS-DIRECTED-PYMT.                      
           MOVE WS-REMAINING-PYMT-AMT TO WS-PAYMENT-AMOUNT              
                                         WS-PAYMENT-AMOUNT-TOTAL        
                                         WS-AMT-CHECK.                  
           MOVE WS-PAR-NO TO WS-PAR-APPLYING-CREDIT-SW.                 
           MOVE WS-A TO WS-PAR-CODE-TRAN-TYPE.                          
           MOVE ZERO TO WS-PAR-TYPE                                     
                        WS-PAR-TYPE-NO.                                 
           MOVE SPACES TO WS-PAR-PAY-CHRG-OFF.                          
           PERFORM 6700-APPLY-PAYMENT THRU 6700-EXIT.                   
      *                                                                         
           MOVE WS-PAR-MESSAGE-NO TO RS-ERROR-MESSAGE1.                 
           IF FIRST-PAYMENT                                             
              MOVE WS-NO TO WS-FIRST-PAYMENT                            
              PERFORM 5001-CHECK-PAYMENT-RETURN THRU 5001-EXIT          
           ELSE                                                         
              IF PYMT-WAS-SUCCESSFUL                                    
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
                 MOVE 'USERABEN'              TO ABEND-FUNCTION         
                 MOVE WS-YES                  TO WS-USER-FORCE-ABEND    
                 MOVE 'PAYMENT ABEND'         TO DSNTIAR-MESSAGE-1      
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT            
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE WS-JRNL-CNTRL-ONLY TO WS-JRNL-OPERATION-RQST.           
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
      *                                                                         
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE 'USERABEN'              TO ABEND-FUNCTION            
              MOVE WS-YES                  TO WS-USER-FORCE-ABEND       
              MOVE SPACES                  TO DSNTIAR-MESSAGE-1         
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
      *                                                                         
       5030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************14930000
      * 5500-CHECK-NON-UTIL.                                           *14930000
      *     COPYBOOK TO CHECK IF A NON-UTIL ACCOUNT CAN FINAL.         *14930000
      ******************************************************************14950000
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00312                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 5750-JOURNAL-FORMAT-101.                                       *        
      *     THIS MODULE WRITES A FORMAT 101 JOURNAL                    *        
      ******************************************************************        
      *                                                                         
       5750-JOURNAL-FORMAT-101.                                         
      *                                                                         
           MOVE WS-JRNL-CK-OPER-ID TO WS-JRNL-OPERATION-RQST.           
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
      *                                                                         
           MOVE WS-CURRENT-DATE TO WS-JRNL-OL-REPORT-DT.                
           MOVE WS-JRNL-VALIDATE-OPER TO WS-JRNL-OPERATION-RQST.        
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
      *                                                                         
           MOVE 'A'                     TO WS-100-JRNL-SORT-ID.         
           MOVE '01'                    TO WS-100-COMPANY-NO.           
           MOVE WS-LOCAL-OFFICE         TO WS-100-LOCAL-OFFICE-CD.      
           MOVE 0                       TO WS-100-ACCT-NO               
                                           WS-100-CUSTOMER-NO           
                                           WS-100-PREMISE-NO.           
           MOVE AU-TRAN-APPL-NO         TO WS-100-JRNL-TRAN-APPL-NO.    
           ADD  1                       TO WS-100-JRNL-TRAN-APPL-NO.    
           MOVE WS-CURRENT-DATE         TO WS-100-DATE-LAST-ACTION.     
           MOVE 'C'                     TO WS-100-CODE-ENTRY-SOURCE.    
           MOVE SPACES                  TO WS-100-TRANS-ERRORS.         
           MOVE 101                     TO WS-101-JRNL-FORMAT-NO.       
           MOVE SPACES                  TO WS-101-CASH-DRAWER-USED.     
      *                                                                         
P0586F     MOVE WS-AMT-DIFF-NUM         TO WS-101-AMT-POSTED            
                                           WS-101-AMOUNT-ENTERED.       
           MOVE SPACES                  TO WS-101-AR-AGE.               
           MOVE WS-CURRENT-DATE         TO WS-101-DATE-AR-BILLED.       
           MOVE 0                       TO WS-101-ITEM-ID-NO            
                                           WS-101-DETAIL-END-BAL        
                                           WS-101-DETAIL-END-AR-BAL     
                                           WS-101-ACCT-END-AR-BAL.      
           MOVE SPACES                  TO WS-101-FUNCTION-CODE         
                                           WS-101-CODE-REVENUE-DISTRICT 
                                           WS-101-CODE-EMPL-ACCT        
                                           WS-101-CODE-COMPANY-ACCT     
                                           WS-101-CODE-ACCOUNT-STATUS   
                                           WS-101-CODE-PREMISE-STATUS.  
           MOVE WS-TEMP-GEN-LEDG-DB     TO WS-101-ACCT-GEN-LED-DR.      
           MOVE WS-TEMP-GEN-LEDG-CR     TO WS-101-ACCT-GEN-LED-CR.      
           IF Y2-DEP-CASH-GL-OFFSET > 0                                 
              IF  Y2-CASH-LOCAL-OFFICE = '025'                          
              AND WS-PAR-PYMT-FACILITY-CD = 'G'                         
                  CONTINUE                                              
              ELSE                                                      
                  IF OVERAGE-TRAN-ID                                    
                     MOVE Y2-DEP-CASH-GL-OFFSET TO                      
                                                 WS-101-ACCT-GEN-LED-CR 
                  ELSE                                                  
                     IF SHORTAGE-TRAN-ID                                
                        MOVE Y2-DEP-CASH-GL-OFFSET TO                   
                                                 WS-101-ACCT-GEN-LED-DR 
                     END-IF                                             
                  END-IF                                                
              END-IF                                                    
           END-IF.                                                      
           MOVE WS-OV-SH-TRAN-ID TO WS-100-CODE-TERMINAL-TRAN           
      *                                                                         
      *******************************************************                   
      * POPULATE CWS00013 VARIABLES.                        *                   
      *******************************************************                   
      *                                                                         
           MOVE SPACES TO WS-JRNL-CURRENCY-TYPE.                        
           IF WS-JRNL-TRUE                                              
              IF WS-JRNL-AU-CURRENCY-TYPE =  WS-DIR-CURRENCY            
                 MOVE WS-DIR-CURRENCY TO WS-JRNL-CURRENCY-TYPE          
              ELSE                                                      
                 IF SHORTAGE-TRAN-ID                                    
                    MOVE WS-DIR-CURRENCY TO WS-JRNL-CURRENCY-TYPE       
                 ELSE                                                   
                    MOVE WS-JRNL-AU-CURRENCY-TYPE                       
                                         TO WS-JRNL-CURRENCY-TYPE       
                END-IF                                                  
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE SPACES TO WS-JRNL-CODE-PYMT-FACILITY.                   
           MOVE CJF00101 TO WS-100-USER-DEFINED-AREA.                   
           MOVE WS-JRNL-ONLY TO WS-JRNL-OPERATION-RQST.                 
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
      *                                                                         
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
           MOVE WS-JRNL-CNTRL-ONLY TO WS-JRNL-OPERATION-RQST.           
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
      *                                                                         
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       5750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CPD00003                                                       *        
      *     6100-COMPUTE-REBATE-AMOUNT                                 *        
      *     6102-SELECT-ACCOUNT-DAYS                                   *        
      *     6103-SELECT-CONTRACT-DAYS                                  *        
      *     6104-SELECT-CNT-AR-ROW                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     12160012
             INCLUDE CPD00003                                           PCS09350
           END-EXEC.                                                    PCS09350
      *                                                                         
      ******************************************************************        
      * CPD0006A                                                       *        
      *     6400-ONLINE-JRNL-ROUTINE                                   *        
      *     6415-SELECT-TERMOP.                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD0006A                                           PCS09360
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CPD00008                                                       *        
      *     6500-ONLINE-LOAD-AR-TRAN-HIST                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00008                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6510A-INSERT-AR-TRANS-HIST.                                    *        
      *     INSERTS A ROW INTO THE CSS_AR_TRANS_HIST TABLE             *        
      ******************************************************************        
      *                                                                         
       6510A-INSERT-AR-TRANS-HIST.                                      
      *                                                                         
           MOVE '6510A' TO ACTIVE-PARAGRAPH.                            
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_AR_TRANS_HIST                            
                   ( ACCOUNT_NO                                         
                    ,TRANS_HIST_SEQ_NO                                  
                    ,DATE_TRANS                                         
                    ,CODE_TRAN_TYPE                                     
                    ,AMT_ORIG_ENTERED                                   
                    ,AMT_BILLED_UNPAID                                  
                    ,RESP_AREA_ID                                       
                    ,APPL_PROGRAM_ID                                    
                    ,PYMT_FACILITY_CD                                   
                    ,USER_ID                                            
                    ,COMPANY_NO                                         
                    ,RECORD_ONLY_FL                                     
                    ,DATE_ORIG_PYMT                                     
                    ,PYMT_REFUNDED_IND                                  
                    ,CASH_COMPANY_NO                                    
                    ,CASH_LOCAL_OFFICE                                  
                    ,CASH_REPORT_NO                                     
                    ,DATE_CASH_REPORT                                   
                    ,CASH_DRAWER_ID                                     
                    ,TRAN_COMMENT )                                     
               VALUES                                                   
                   ( :AR-ACCOUNT-NO                                     
                    ,CIS.CHAR2TIMESTAMP(:AR-TRANS-HIST-SEQ-NO)                  
                    ,IIF(TRY_CONVERT(DATE, :AR-DATE-TRANS :WS-NULL-IND2
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS 
                                                          :WS-NULL-IND2
              ) <> 0) OR (LEN(:AR-DATE-TRANS :WS-NULL-IND2
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-TRANS :WS-NULL-IND2
              ), CONVERT(DATE, :AR-DATE-TRANS :WS-NULL-IND2) )                 
                    ,:AR-CODE-TRAN-TYPE                                 
                    ,:AR-AMT-ORIG-ENTERED                               
                    ,:AR-AMT-BILLED-UNPAID                              
                    ,:AR-RESP-AREA-ID                                   
                    ,:AR-APPL-PROGRAM-ID                                
                    ,:AR-PYMT-FACILITY-CD                               
                    ,:AR-USER-ID                                        
                    ,:AR-COMPANY-NO                                     
                    ,:AR-RECORD-ONLY-FL                                 
                    ,IIF(TRY_CONVERT(DATE, :AR-DATE-ORIG-PYMT 
                                           :WS-NULL-IND1
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-ORIG-PYMT 
                                                          :WS-NULL-IND1
              ) <> 0) OR (LEN(:AR-DATE-ORIG-PYMT :WS-NULL-IND1
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-ORIG-PYMT :WS-NULL-IND1
              ), CONVERT(DATE, :AR-DATE-ORIG-PYMT :WS-NULL-IND1) )             
                    ,:AR-PYMT-REFUNDED-IND                              
                    ,:AR-CASH-COMPANY-NO                                
                    ,:AR-CASH-LOCAL-OFFICE                              
                    ,:AR-CASH-REPORT-NO                                 
                    ,IIF(TRY_CONVERT(DATE, :AR-DATE-CASH-REPORT 
                                           :WS-NULL-IND3
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-CASH-REPORT 
                                                          :WS-NULL-IND3
              ) <> 0) OR (LEN(:AR-DATE-CASH-REPORT :WS-NULL-IND3
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-CASH-REPORT 
                                                          :WS-NULL-IND3
              ), CONVERT(DATE, :AR-DATE-CASH-REPORT :WS-NULL-IND3) )           
                    ,:AR-CASH-DRAWER-ID                                 
                    ,:AR-TRAN-COMMENT )                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00210000
MFA-TR*        INSERT INTO CSS_AR_TRANS_HIST                            00220000
MFA-TR*            ( ACCOUNT_NO                                         00230000
MFA-TR*             ,TRANS_HIST_SEQ_NO                                  00231004
MFA-TR*             ,DATE_TRANS                                         00240000
MFA-TR*             ,CODE_TRAN_TYPE                                     00260000
MFA-TR*             ,AMT_ORIG_ENTERED                                   00270000
MFA-TR*             ,AMT_BILLED_UNPAID                                  00271004
MFA-TR*             ,RESP_AREA_ID                                       00272004
MFA-TR*             ,APPL_PROGRAM_ID                                    00273004
MFA-TR*             ,PYMT_FACILITY_CD                                   00274004
MFA-TR*             ,USER_ID                                            00275004
MFA-TR*             ,COMPANY_NO                                         00276004
MFA-TR*             ,RECORD_ONLY_FL                                     00277004
MFA-TR*             ,DATE_ORIG_PYMT                                     00278004
MFA-TR*             ,PYMT_REFUNDED_IND                                  00279004
MFA-TR*             ,CASH_COMPANY_NO                                    00280004
MFA-TR*             ,CASH_LOCAL_OFFICE                                  00290004
MFA-TR*             ,CASH_REPORT_NO                                     00310004
MFA-TR*             ,DATE_CASH_REPORT                                   00320004
MFA-TR*             ,CASH_DRAWER_ID                                     00320004
MFA-TR*             ,TRAN_COMMENT )                                             
MFA-TR*        VALUES                                                   00350000
MFA-TR*            ( :AR-ACCOUNT-NO                                     00360000
MFA-TR*             ,:AR-TRANS-HIST-SEQ-NO                              00362004
MFA-TR*             ,:AR-DATE-TRANS:WS-NULL-IND2                        00370000
MFA-TR*             ,:AR-CODE-TRAN-TYPE                                 00390000
MFA-TR*             ,:AR-AMT-ORIG-ENTERED                               00400000
MFA-TR*             ,:AR-AMT-BILLED-UNPAID                              00401004
MFA-TR*             ,:AR-RESP-AREA-ID                                   00402004
MFA-TR*             ,:AR-APPL-PROGRAM-ID                                00403004
MFA-TR*             ,:AR-PYMT-FACILITY-CD                               00404004
MFA-TR*             ,:AR-USER-ID                                        00405004
MFA-TR*             ,:AR-COMPANY-NO                                     00406004
MFA-TR*             ,:AR-RECORD-ONLY-FL                                 00407004
MFA-TR*             ,:AR-DATE-ORIG-PYMT:WS-NULL-IND1                    00408004
MFA-TR*             ,:AR-PYMT-REFUNDED-IND                              00409004
MFA-TR*             ,:AR-CASH-COMPANY-NO                                00409104
MFA-TR*             ,:AR-CASH-LOCAL-OFFICE                              00409204
MFA-TR*             ,:AR-CASH-REPORT-NO                                 00409304
MFA-TR*             ,:AR-DATE-CASH-REPORT:WS-NULL-IND3                  00320004
MFA-TR*             ,:AR-CASH-DRAWER-ID                                 00409404
MFA-TR*             ,:AR-TRAN-COMMENT )                                         
MFA-TR*    END-EXEC.                                                    00480000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'TRANS_HIST_SEQ_NO'       TO TABLE-ELEMENT-2         
              MOVE 'DATE_TRANS'              TO TABLE-ELEMENT-3         
              MOVE 'CODE_TRAN_TYPE'          TO TABLE-ELEMENT-4         
              MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AR-TRANS-HIST-SEQ-NO      TO HOSTVAR-ELEMENT-2       
              MOVE AR-DATE-TRANS             TO HOSTVAR-ELEMENT-3       
              MOVE AR-CODE-TRAN-TYPE         TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       6510A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************00210600
      * 6530-LOAD-MNT-TRANS-HIST                                       *        
      *     THIS COPYBOOK LOADS MAINTENANCE TRANSACTION HISTORY        *        
      ******************************************************************00210800
      *                                                                         
           EXEC SQL                                                     00206700
              INCLUDE CPD00067                                          00206800
           END-EXEC.                                                    00206900
      *                                                                         
      ******************************************************************00210600
      * CPD00010                                                       *        
      *     6700-APPLY-PAYMENT                                         *00210700
      *     6722D-LOAD-AR-PMT-PRTY                                     *00210700
      *     THIS COPYBOOK CONTAINS THE NON-SQL PROCEDURE DIVISION      *        
      *     STATEMENTS NECESSARY TO EXECUTE THE PAYMENT APPLICATION    *        
      *     ROUTINE.                                                   *        
      ******************************************************************00210800
      *                                                                         
           COPY CPD00010.                                               12160012
      *                                                                         
      ******************************************************************        
      * CPD0010S                                                       *        
      * 6701-SELECT-ACCOUNT.                                           *        
      * 6722B-OPEN-AR-PMT-PRTY.                                        *        
      * 6722C-FETCH-AR-PMT-PRTY.                                       *        
      * 6722E-CLOSE-AR-PMT-PRTY.                                       *        
      *     THIS COPYBOOK CONTAINS THE SQL STATEMENTS NECESSARY TO     *        
      *     EXECUTE THE PAYMENT APPLICATION ROUTINE (CPD00010).        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD0010S                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CPD00073                                                       *        
      *     6800-APPLY-PYMT-CO                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00073                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CPD00116                                                       *        
      *     6904-INSERT-AR-DETAILS                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00116                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************00210600
      * 7000-SELECT-AT-PR-CU.                                          *        
      *     SELECTS THE CSS-ACCOUNT ROW                                *00210700
      ******************************************************************00210800
      *                                                                         
       7000-SELECT-AT-PR-CU.                                            
      *                                                                         
           MOVE '7000' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              SELECT AT.CUSTOMER_NO                                     
                    ,AT.CODE_ACCT_STAT                                  
                    ,AT.TOTAL_AR_BALANCE                                
                    ,AT.DATE_LAST_ACTION                                
                    ,AT.LOCAL_OFFICE                                    
                    ,AT.PREMISE_NO                                      
                    ,AT.CODES_DATA_PRESENT                              
                    ,AT.COMPANY_NO                                      
                    ,AT.AR_XFER_IND                                     
                    ,AT.ACCT_XFER_TO                                    
                    ,AT.BANKRUPTCY_IND                                  
                    ,AT.CREDIT_GROUP                                    
                    ,AT.DATE_BILL_DAY_00                                
                    ,AT.DATE_BILL_DAY_30                                
                    ,AT.DATE_BILL_DAY_60                                
                    ,AT.DATE_BILL_DAY_90                                
                    ,AT.CODE_DISC_OK                                    
                    ,AT.NOTICE_EXEMPT_CD                                
                    ,AT.IVR_EXEMPT_CD                                   
                    ,PR.CODE_PREMISE_STAT                               
                    ,PR.REV_DISTRICT_CD                                 
                    ,CU.CODE_EMPL_ACCT                                  
                    ,CU.CODE_CUST_STATUS                                
                    ,CAST(SYSDATETIMEOFFSET() AS DATE)                          
             INTO    :AT-CUSTOMER-NO                                    
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-TOTAL-AR-BALANCE                               
                    ,:AT-DATE-LAST-ACTION                               
                    ,:AT-LOCAL-OFFICE                                   
                    ,:AT-PREMISE-NO                                     
                    ,:AT-CODES-DATA-PRESENT                             
                    ,:AT-COMPANY-NO                                     
                    ,:AT-AR-XFER-IND                                    
                    ,:AT-ACCT-XFER-TO                                   
                    ,:AT-BANKRUPTCY-IND                                 
                    ,:AT-CREDIT-GROUP                                   
                    ,:AT-DATE-BILL-DAY-00 :WS-NULL-INDICATOR-1           
                    ,:AT-DATE-BILL-DAY-30 :WS-NULL-INDICATOR-2           
                    ,:AT-DATE-BILL-DAY-60 :WS-NULL-INDICATOR-3           
                    ,:AT-DATE-BILL-DAY-90 :WS-NULL-INDICATOR-4           
                    ,:AT-CODE-DISC-OK                                   
                    ,:AT-NOTICE-EXEMPT-CD                               
                    ,:AT-IVR-EXEMPT-CD                                  
                    ,:PR-CODE-PREMISE-STAT                              
                    ,:PR-REV-DISTRICT-CD                                
                    ,:CU-CODE-EMPL-ACCT                                 
                    ,:CU-CODE-CUST-STATUS                               
                    ,:WS-CURRENT-DATE                                   
            FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                           
                ,CSS_PREMISE PR WITH(READUNCOMMITTED)                           
                ,CSS_CUSTOMER CU WITH(READUNCOMMITTED)                          
            WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                       
              AND AT.PREMISE_NO  = PR.PREMISE_NO                        
              AND AT.CUSTOMER_NO = CU.CUSTOMER_NO                       
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     12270014
MFA-TR*       SELECT AT.CUSTOMER_NO                                     PCS15140
MFA-TR*             ,AT.CODE_ACCT_STAT                                  PCS15150
MFA-TR*             ,AT.TOTAL_AR_BALANCE                                PCS15160
MFA-TR*             ,AT.DATE_LAST_ACTION                                PCS15170
MFA-TR*             ,AT.LOCAL_OFFICE                                    12330016
MFA-TR*             ,AT.PREMISE_NO                                      PCS15180
MFA-TR*             ,AT.CODES_DATA_PRESENT                              PCS15180
MFA-TR*             ,AT.COMPANY_NO                                      12350016
MFA-TR*             ,AT.AR_XFER_IND                                             
MFA-TR*             ,AT.ACCT_XFER_TO                                            
MFA-TR*             ,AT.BANKRUPTCY_IND                                  12360016
MFA-TR*             ,AT.CREDIT_GROUP                                            
MFA-TR*             ,AT.DATE_BILL_DAY_00                                        
MFA-TR*             ,AT.DATE_BILL_DAY_30                                        
MFA-TR*             ,AT.DATE_BILL_DAY_60                                        
MFA-TR*             ,AT.DATE_BILL_DAY_90                                        
MFA-TR*             ,AT.CODE_DISC_OK                                            
MFA-TR*             ,AT.NOTICE_EXEMPT_CD                                        
MFA-TR*             ,AT.IVR_EXEMPT_CD                                           
MFA-TR*             ,PR.CODE_PREMISE_STAT                               PCS15210
MFA-TR*             ,PR.REV_DISTRICT_CD                                         
MFA-TR*             ,CU.CODE_EMPL_ACCT                                  PCS15220
MFA-TR*             ,CU.CODE_CUST_STATUS                                PCS15220
MFA-TR*             ,CURRENT DATE                                               
MFA-TR*      INTO    :AT-CUSTOMER-NO                                    PCS15230
MFA-TR*             ,:AT-CODE-ACCT-STAT                                 PCS15150
MFA-TR*             ,:AT-TOTAL-AR-BALANCE                               PCS15160
MFA-TR*             ,:AT-DATE-LAST-ACTION                               PCS15170
MFA-TR*             ,:AT-LOCAL-OFFICE                                   12330016
MFA-TR*             ,:AT-PREMISE-NO                                     PCS15180
MFA-TR*             ,:AT-CODES-DATA-PRESENT                             PCS15180
MFA-TR*             ,:AT-COMPANY-NO                                     12350016
MFA-TR*             ,:AT-AR-XFER-IND                                            
MFA-TR*             ,:AT-ACCT-XFER-TO                                           
MFA-TR*             ,:AT-BANKRUPTCY-IND                                 12360016
MFA-TR*             ,:AT-CREDIT-GROUP                                           
MFA-TR*             ,:AT-DATE-BILL-DAY-00:WS-NULL-INDICATOR-1                   
MFA-TR*             ,:AT-DATE-BILL-DAY-30:WS-NULL-INDICATOR-2                   
MFA-TR*             ,:AT-DATE-BILL-DAY-60:WS-NULL-INDICATOR-3                   
MFA-TR*             ,:AT-DATE-BILL-DAY-90:WS-NULL-INDICATOR-4                   
MFA-TR*             ,:AT-CODE-DISC-OK                                           
MFA-TR*             ,:AT-NOTICE-EXEMPT-CD                                       
MFA-TR*             ,:AT-IVR-EXEMPT-CD                                          
MFA-TR*             ,:PR-CODE-PREMISE-STAT                              PCS15210
MFA-TR*             ,:PR-REV-DISTRICT-CD                                        
MFA-TR*             ,:CU-CODE-EMPL-ACCT                                 PCS15220
MFA-TR*             ,:CU-CODE-CUST-STATUS                               PCS15220
MFA-TR*             ,:WS-CURRENT-DATE                                           
MFA-TR*     FROM CSS_ACCOUNT AT                                         PCS15240
MFA-TR*         ,CSS_PREMISE PR                                         PCS15240
MFA-TR*         ,CSS_CUSTOMER CU                                        PCS15240
MFA-TR*     WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                       PCS15240
MFA-TR*       AND AT.PREMISE_NO  = PR.PREMISE_NO                        PCS15240
MFA-TR*       AND AT.CUSTOMER_NO = CU.CUSTOMER_NO                       PCS15240
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*       WITH UR                                                   PCS15140
MFA-TR*    END-EXEC.                                                    12490016

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12500016
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-NULL-INDICATOR-1 < ZERO                             
                 MOVE LOW-VALUES TO AT-DATE-BILL-DAY-00                 
              END-IF                                                    
              IF WS-NULL-INDICATOR-2 < ZERO                             
                 MOVE LOW-VALUES TO AT-DATE-BILL-DAY-30                 
              END-IF                                                    
              IF WS-NULL-INDICATOR-3 < ZERO                             
                 MOVE LOW-VALUES TO AT-DATE-BILL-DAY-60                 
              END-IF                                                    
              IF WS-NULL-INDICATOR-4 < ZERO                             
                 MOVE LOW-VALUES TO AT-DATE-BILL-DAY-90                 
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE               
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'CSS_PREMISE'         TO TABLE-2                     
              MOVE 'CSS_CUSTOMER'        TO TABLE-3                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7020-SELECT-CASH-DRWR.                                         *        
      *     SELECTS CASH DRAWER ID FOR GIVEN CASH LOCAL OFFICE AND     *        
      *     DATE CASH REPORT.                                          *        
      ******************************************************************        
      *                                                                         
       7020-SELECT-CASH-DRWR.                                           
      *                                                                         
           MOVE '7020' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
             SELECT CASH_DRAWER_ID                                      
                   ,CODE_CSH_DRWR_STAT                                  
               INTO :CS-CASH-DRAWER-ID                                  
                   ,:CS-CODE-CSH-DRWR-STAT                              
               FROM CSS_CSH_DRWR_CNTL WITH(READUNCOMMITTED)                     
              WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO            
                AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE          
                AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )           
                AND CASH_DRAWER_ID     = 9999                           
                                                            
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CASH_DRAWER_ID                                              
MFA-TR*            ,CODE_CSH_DRWR_STAT                                          
MFA-TR*        INTO :CS-CASH-DRAWER-ID                                          
MFA-TR*            ,:CS-CODE-CSH-DRWR-STAT                                      
MFA-TR*        FROM CSS_CSH_DRWR_CNTL                                           
MFA-TR*       WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO                    
MFA-TR*         AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE                  
MFA-TR*         AND DATE_CASH_REPORT   = :CS-DATE-CASH-REPORT                   
MFA-TR*         AND CASH_DRAWER_ID     = 9999                                   
MFA-TR*     QUERYNO 7020                                                        
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           OR NOT-FOUND                                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CSH_DRWR_CNTL'       TO TABLE-1                 
              MOVE 'CASH_LOCAL_OFFICE'       TO TABLE-ELEMENT-1         
              MOVE CS-CASH-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-1       
              MOVE 'DATE_CASH_REPORT'        TO TABLE-ELEMENT-2         
              MOVE CS-DATE-CASH-REPORT       TO HOSTVAR-ELEMENT-2       
              MOVE 'CODE_CSH_DRWR_STAT'      TO TABLE-ELEMENT-3         
              MOVE CS-CODE-CSH-DRWR-STAT     TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7170-SELECT-RECONNECT.                                         *        
      *     SELECTS ROWS FROM THE CSS_RECONNECT TABLE                  *        
      ******************************************************************        
      *                                                                         
       7170-SELECT-RECONNECT.                                           
      *                                                                         
           MOVE '7170' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
               SELECT RECNCT_COLLECT_AMT                                
                     ,AMT_TOT_RECONNECT                                 
                 INTO :DL-RECNCT-COLLECT-AMT                            
                     ,:DL-AMT-TOT-RECONNECT                             
              FROM CSS_RECONNECT WITH(READUNCOMMITTED)                          
              WHERE ACCOUNT_NO = :DL-ACCOUNT-NO                         
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02499031
MFA-TR*        SELECT RECNCT_COLLECT_AMT                                        
MFA-TR*              ,AMT_TOT_RECONNECT                                         
MFA-TR*          INTO :DL-RECNCT-COLLECT-AMT                                    
MFA-TR*              ,:DL-AMT-TOT-RECONNECT                                     
MFA-TR*       FROM CSS_RECONNECT                                        02504032
MFA-TR*       WHERE ACCOUNT_NO = :DL-ACCOUNT-NO                         02504531
MFA-TR*        QUERYNO 7170                                                     
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    02504731

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 02504831
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR NOT-FOUND                                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE               
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_RECONNECT'       TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE DL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7170-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7320-SELECT-CASHIER.                                           *        
      *     SELECT CASHIER INFORMATION FROM CSS_CASHIER_OFFICE TABLE   *        
      ******************************************************************        
      *                                                                         
       7320-SELECT-CASHIER.                                             
      *                                                                         
           MOVE '7320' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
             SELECT USER_ID                                             
                   ,DEP_CASH_GL_OFFSET                                  
                   ,LOCAL_OFFICE                                        
               INTO :Y2-USER-ID                                         
                   ,:Y2-DEP-CASH-GL-OFFSET                              
                   ,:Y2-LOCAL-OFFICE                                    
               FROM CSS_CASHIER_OFFICE WITH(READUNCOMMITTED)                    
              WHERE CASH_COMPANY_NO    = :Y2-CASH-COMPANY-NO            
                AND CASH_LOCAL_OFFICE  = :Y2-CASH-LOCAL-OFFICE          
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT USER_ID                                                     
MFA-TR*            ,DEP_CASH_GL_OFFSET                                          
MFA-TR*            ,LOCAL_OFFICE                                                
MFA-TR*        INTO :Y2-USER-ID                                                 
MFA-TR*            ,:Y2-DEP-CASH-GL-OFFSET                                      
MFA-TR*            ,:Y2-LOCAL-OFFICE                                            
MFA-TR*        FROM CSS_CASHIER_OFFICE                                          
MFA-TR*       WHERE CASH_COMPANY_NO    = :Y2-CASH-COMPANY-NO                    
MFA-TR*         AND CASH_LOCAL_OFFICE  = :Y2-CASH-LOCAL-OFFICE                  
MFA-TR*     QUERYNO 7320                                                        
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CASHIER_OFFICE'  TO TABLE-1                     
              MOVE 'CASH COMPANY NO'     TO TABLE-ELEMENT-1             
              MOVE 'CASH LOCAL OFFICE'   TO TABLE-ELEMENT-2             
              MOVE Y2-CASH-COMPANY-NO    TO HOSTVAR-ELEMENT-1           
              MOVE Y2-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7325-SELECT-CASH-REPORT                                        *        
      *     SELECTS USER ID FROM CSS_CSH_REPORT_HDR TABLE              *        
      ******************************************************************        
      *                                                                         
       7325-SELECT-CASH-REPORT.                                         
      *                                                                         
           MOVE '7325' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
             SELECT USER_ID                                             
               INTO :YR-USER-ID                                         
               FROM CSS_CSH_REPORT_HDR WITH(READUNCOMMITTED)                    
              WHERE CASH_COMPANY_NO    = :YR-CASH-COMPANY-NO            
                AND CASH_LOCAL_OFFICE  = :YR-CASH-LOCAL-OFFICE          
                AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :YR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YR-DATE-CASH-REPORT
              ), CONVERT(DATE, :YR-DATE-CASH-REPORT) )           
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT USER_ID                                                     
MFA-TR*        INTO :YR-USER-ID                                                 
MFA-TR*        FROM CSS_CSH_REPORT_HDR                                          
MFA-TR*       WHERE CASH_COMPANY_NO    = :YR-CASH-COMPANY-NO                    
MFA-TR*         AND CASH_LOCAL_OFFICE  = :YR-CASH-LOCAL-OFFICE                  
MFA-TR*         AND DATE_CASH_REPORT   = :YR-DATE-CASH-REPORT                   
MFA-TR*     QUERYNO 7325                                                        
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR NOT-FOUND                                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CSH_REPORT_HDR'  TO TABLE-1                     
              MOVE 'CASH COMPANY NO'     TO TABLE-ELEMENT-1             
              MOVE 'CASH LOCAL OFFICE'   TO TABLE-ELEMENT-2             
              MOVE 'DATE CASH REPORT'    TO TABLE-ELEMENT-3             
              MOVE YR-CASH-COMPANY-NO    TO HOSTVAR-ELEMENT-1           
              MOVE YR-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-2           
              MOVE YR-DATE-CASH-REPORT   TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7325-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7600-SELECT-AR-TRANS-HIST.                                     *        
      *     SELECTS ROW FROM THE CSS_AR_TRANS_HIST TABLE.              *        
      ******************************************************************        
      *                                                                         
       7600-SELECT-AR-TRANS-HIST.                                       
      *                                                                         
           MOVE '7600' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
               SELECT DATE_TRANS                                        
                     ,CODE_TRAN_TYPE                                    
                     ,AMT_ORIG_ENTERED                                  
                     ,AMT_BILLED_UNPAID                                 
                     ,RESP_AREA_ID                                      
                     ,APPL_PROGRAM_ID                                   
                     ,PYMT_FACILITY_CD                                  
                     ,USER_ID                                           
                     ,COMPANY_NO                                        
                     ,RECORD_ONLY_FL                                    
                     ,DATE_ORIG_PYMT                                    
                     ,PYMT_REFUNDED_IND                                 
                     ,CASH_COMPANY_NO                                   
                     ,CASH_LOCAL_OFFICE                                 
                     ,CASH_REPORT_NO                                    
                     ,DATE_CASH_REPORT                                  
                     ,CASH_DRAWER_ID                                    
                     ,TRAN_COMMENT                                      
                 INTO  :AR-DATE-TRANS :WS-NULL-IND2                      
                      ,:AR-CODE-TRAN-TYPE                               
                      ,:AR-AMT-ORIG-ENTERED                             
                      ,:AR-AMT-BILLED-UNPAID                            
                      ,:AR-RESP-AREA-ID                                 
                      ,:AR-APPL-PROGRAM-ID                              
                      ,:AR-PYMT-FACILITY-CD                             
                      ,:AR-USER-ID                                      
                      ,:AR-COMPANY-NO                                   
                      ,:AR-RECORD-ONLY-FL                               
                      ,:AR-DATE-ORIG-PYMT :WS-NULL-IND1                  
                      ,:AR-PYMT-REFUNDED-IND                            
                      ,:AR-CASH-COMPANY-NO                              
                      ,:AR-CASH-LOCAL-OFFICE                            
                      ,:AR-CASH-REPORT-NO                               
                      ,:AR-DATE-CASH-REPORT :WS-NULL-IND3                
                      ,:AR-CASH-DRAWER-ID                               
                      ,:AR-TRAN-COMMENT                                 
              FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                      
              WHERE ACCOUNT_NO = :AR-ACCOUNT-NO                         
              AND   TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )           
              AND   RECORD_ONLY_FL <> 'Y'                               
              AND   APPL_PROGRAM_ID <> 'PANEL373C'                      
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     02499031
MFA-TR*        SELECT DATE_TRANS                                                
MFA-TR*              ,CODE_TRAN_TYPE                                            
MFA-TR*              ,AMT_ORIG_ENTERED                                          
MFA-TR*              ,AMT_BILLED_UNPAID                                         
MFA-TR*              ,RESP_AREA_ID                                              
MFA-TR*              ,APPL_PROGRAM_ID                                           
MFA-TR*              ,PYMT_FACILITY_CD                                          
MFA-TR*              ,USER_ID                                                   
MFA-TR*              ,COMPANY_NO                                                
MFA-TR*              ,RECORD_ONLY_FL                                            
MFA-TR*              ,DATE_ORIG_PYMT                                            
MFA-TR*              ,PYMT_REFUNDED_IND                                         
MFA-TR*              ,CASH_COMPANY_NO                                           
MFA-TR*              ,CASH_LOCAL_OFFICE                                         
MFA-TR*              ,CASH_REPORT_NO                                            
MFA-TR*              ,DATE_CASH_REPORT                                          
MFA-TR*              ,CASH_DRAWER_ID                                            
MFA-TR*              ,TRAN_COMMENT                                              
MFA-TR*          INTO  :AR-DATE-TRANS:WS-NULL-IND2                              
MFA-TR*               ,:AR-CODE-TRAN-TYPE                                       
MFA-TR*               ,:AR-AMT-ORIG-ENTERED                                     
MFA-TR*               ,:AR-AMT-BILLED-UNPAID                                    
MFA-TR*               ,:AR-RESP-AREA-ID                                         
MFA-TR*               ,:AR-APPL-PROGRAM-ID                                      
MFA-TR*               ,:AR-PYMT-FACILITY-CD                                     
MFA-TR*               ,:AR-USER-ID                                              
MFA-TR*               ,:AR-COMPANY-NO                                           
MFA-TR*               ,:AR-RECORD-ONLY-FL                                       
MFA-TR*               ,:AR-DATE-ORIG-PYMT:WS-NULL-IND1                          
MFA-TR*               ,:AR-PYMT-REFUNDED-IND                                    
MFA-TR*               ,:AR-CASH-COMPANY-NO                                      
MFA-TR*               ,:AR-CASH-LOCAL-OFFICE                                    
MFA-TR*               ,:AR-CASH-REPORT-NO                                       
MFA-TR*               ,:AR-DATE-CASH-REPORT:WS-NULL-IND3                        
MFA-TR*               ,:AR-CASH-DRAWER-ID                                       
MFA-TR*               ,:AR-TRAN-COMMENT                                         
MFA-TR*       FROM CSS_AR_TRANS_HIST                                    02504032
MFA-TR*       WHERE ACCOUNT_NO = :AR-ACCOUNT-NO                         02504531
MFA-TR*       AND   TRANS_HIST_SEQ_NO = :AR-TRANS-HIST-SEQ-NO                   
MFA-TR*       AND   RECORD_ONLY_FL <> 'Y'                                       
MFA-TR*       AND   APPL_PROGRAM_ID <> 'PANEL373C'                              
MFA-TR*       QUERYNO 7600                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    02504731

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF WS-NULL-IND1 < 0                                          
              MOVE SPACES TO AR-DATE-ORIG-PYMT                          
           END-IF.                                                      
      *                                                                         
           IF WS-NULL-IND2 < 0                                          
              MOVE SPACES TO AR-DATE-TRANS                              
           END-IF.                                                      
      *                                                                         
           IF WS-NULL-IND3 < 0                                          
              MOVE SPACES TO AR-DATE-CASH-REPORT                        
           END-IF.                                                      
      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
      ******************************************************************        
      * DO NOT REVERSE A REVERSED PAYMENT.                             *        
      * ABEND IF PAYMENT TO BE REVERSED IS NOT FOUND OR IS MARKED      *        
      * RECORDS ONLY.                                                  *        
      ******************************************************************        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_TRANS_HIST'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'TRANS_HIST_SEQ_NO'   TO TABLE-ELEMENT-2             
              MOVE AR-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE AR-TRANS-HIST-SEQ-NO  TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7605-UPDATE-AR-TRANS-HIST.                                     *        
      *     UPDATES ROW ON THE CSS_AR-TRANS_HIST TABLE.                *        
      ******************************************************************        
      *                                                                         
       7605-UPDATE-AR-TRANS-HIST.                                       
      *                                                                         
           MOVE '7605' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_AR_TRANS_HIST                                 
                  SET APPL_PROGRAM_ID   = :AR-APPL-PROGRAM-ID           
                     ,PYMT_REFUNDED_IND = :AR-PYMT-REFUNDED-IND         
                     ,RECORD_ONLY_FL    = :AR-RECORD-ONLY-FL            
                WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                
                  AND TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00210000
MFA-TR*        UPDATE CSS_AR_TRANS_HIST                                 00220000
MFA-TR*           SET APPL_PROGRAM_ID   = :AR-APPL-PROGRAM-ID           00271004
MFA-TR*              ,PYMT_REFUNDED_IND = :AR-PYMT-REFUNDED-IND         00271004
MFA-TR*              ,RECORD_ONLY_FL    = :AR-RECORD-ONLY-FL            00271004
MFA-TR*         WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                        
MFA-TR*           AND TRANS_HIST_SEQ_NO = :AR-TRANS-HIST-SEQ-NO                 
MFA-TR*       QUERYNO 7605                                                      
MFA-TR*    END-EXEC.                                                    00480000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'TRANS_HIST_SEQ_NO'       TO TABLE-ELEMENT-2         
              MOVE 'USER_ID'                 TO TABLE-ELEMENT-3         
              MOVE 'APPL_PROGRAM_ID'         TO TABLE-ELEMENT-4         
              MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AR-TRANS-HIST-SEQ-NO      TO HOSTVAR-ELEMENT-2       
              MOVE AR-USER-ID                TO HOSTVAR-ELEMENT-3       
              MOVE AR-APPL-PROGRAM-ID        TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7605-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************07990000
      * 7610-GET-CURRENT-TIMESTAMP                                     *08000000
      *     SETS THE CURRENT TIMESTAMP AND THE CURRENT DATE.           *08000000
      ******************************************************************08010000
      *                                                                 07980000
       7610-GET-CURRENT-TIMESTAMP.                                      
      *                                                                 07980000
           MOVE '7610' TO ACTIVE-PARAGRAPH.                             
      *                                                                 07980000
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07980000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR NOT-FOUND                                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE PARM-FROM-ACCOUNT-NO  TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE WS-CURRENT-TIMESTAMP  TO AR-TRANS-HIST-SEQ-NO.          
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR NOT-FOUND                                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE PARM-FROM-ACCOUNT-NO  TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7610-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************07990000
      * 7620-MNT_TRANHIS-TIMESTAMP.                                    *08000000
      *     SETS THE CURRENT TIMESTAMP FOR THE CSS_MNT_TRANS_HIST      *08000000
      *     TABLE.                                                     *08000000
      ******************************************************************08010000
      *                                                                 07980000
       7620-MNT-TRANHIS-TIMESTAMP.                                      
      *                                                                 07980000
           MOVE '7620' TO ACTIVE-PARAGRAPH.                             
      *                                                                 07980000
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-MNT-TRH-TIMESTAMP           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-MNT-TRH-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07980000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR NOT-FOUND                                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE PARM-FROM-ACCOUNT-NO  TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-MNT-TRH-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-MNT-TRH-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR NOT-FOUND                                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE PARM-FROM-ACCOUNT-NO  TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7620-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************07990000
      * 7630-SELECT-CIA-IN-AR-CNTL.                                    *08000000
      *     CHECK FOR CIA RECEIVABLE                                   *08000000
      ******************************************************************08010000
      *                                                                 07980000
       7630-SELECT-CIA-IN-AR-CNTL.                                      
      *                                                                 07980000
           MOVE '7630' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
             SELECT ACCOUNT_NO                                          
               INTO :AC-ACCOUNT-NO                                      
               FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                           
              WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                  
                AND PYMT_PRIORITY_LVL = 070                             
                AND ITEM_ID           = :AC-ITEM-ID                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00243400
MFA-TR*      SELECT ACCOUNT_NO                                          00243500
MFA-TR*        INTO :AC-ACCOUNT-NO                                      00243600
MFA-TR*        FROM CSS_AR_CNTL                                         00243700
MFA-TR*       WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                  00243800
MFA-TR*         AND PYMT_PRIORITY_LVL = 070                             00243900
MFA-TR*         AND ITEM_ID           = :AC-ITEM-ID                     00244000
MFA-TR*        WITH UR                                                  00244100
MFA-TR*     QUERYNO 7630                                                00244200
MFA-TR*    END-EXEC.                                                    00244300

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07980000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7630-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * 7700-GET-GL-NO                                              *           
      *     SELECTS THE GL ACCOUNT INFORMATION.                     *           
      ***************************************************************           
      *                                                                         
       7700-GET-GL-NO.                                                  
      *                                                                         
           MOVE '7700' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              SELECT GL_ACCT_NO                                         
                INTO :GO-GL-ACCT-NO                                     
                FROM CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                       
               WHERE COMPANY_NO   = '01'                                
                 AND GL_ACCT_NAME = :GO-GL-ACCT-NAME                    
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT GL_ACCT_NO                                                 
MFA-TR*         INTO :GO-GL-ACCT-NO                                             
MFA-TR*         FROM CSS_GL_ACCT_NO                                             
MFA-TR*        WHERE COMPANY_NO   = '01'                                        
MFA-TR*          AND GL_ACCT_NAME = :GO-GL-ACCT-NAME                            
MFA-TR*      QUERYNO 7700                                                       
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_GL_ACCT_NO'      TO TABLE-1                     
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1             
              MOVE 'GL_ACCT_NAME'        TO TABLE-ELEMENT-2             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3             
              MOVE '01'                  TO HOSTVAR-ELEMENT-1           
              MOVE GO-GL-ACCT-NAME       TO HOSTVAR-ELEMENT-2           
              MOVE PARM-FROM-ACCOUNT-NO  TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7775-CHECK-MATCHING-ENTRY.                                     *        
      *     CHECK TO SEE IF THERE ALREADY EXISTS AN ENTRY IN THE TABLE *        
      *     FOR THE BATCH OF THE ORIGINAL PAYMENT                      *        
      ******************************************************************        
      *                                                                         
       7775-CHECK-MATCHING-ENTRY.                                       
      *                                                                         
            MOVE '7775' TO ACTIVE-PARAGRAPH.                            
            MOVE PARM-FROM-ACCOUNT-NO TO AR-ACCOUNT-NO.                 
            MOVE PARM-TRANS-HIST-SEQ-NO TO AR-TRANS-HIST-SEQ-NO.        
P0586F      MOVE WS-AMT-DIFF-NUM   TO OH-OVERSHORT-AMT                  
P0586F      IF WS-NEG-DIFF-FLAG = 'Y'                                   
               MOVE 'C' TO OH-OVERSHORT-DR-CR                           
            ELSE                                                        
               MOVE 'D' TO OH-OVERSHORT-DR-CR                           
            END-IF.                                                     
      *                                                                         
            MOVE '01' TO OH-CASH-COMPANY-NO.                            
      *                                                                         
            EXEC SQL                                                    
               SELECT  CASH_COMPANY_NO                                  
                      ,DATE_CASH_REPORT                                 
                      ,OVERSHORT_ID                                     
                      ,OVERSHORT_AMT                                    
                      ,OFST_OVERSHORT_AMT                               
                      ,OFST_DR_CR                                       
                      ,OVERSHORT_DR_CR                                  
                 INTO :OH-CASH-COMPANY-NO                               
                     ,:OH-DATE-CASH-REPORT                              
                     ,:OH-OVERSHORT-ID                                  
                     ,:OH-OVERSHORT-AMT                                 
                     ,:OH-OFST-OVERSHORT-AMT                            
                     ,:OH-OFST-DR-CR                                    
                     ,:OH-OVERSHORT-DR-CR                               
                 FROM CSS_OVERSHORT_HDR WITH(READUNCOMMITTED)                   
                WHERE OVERSHORT_SOLTN_FL = 'P'                          
                  AND CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO           
                  AND CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE         
                  AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )          
                  AND CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID            
                  AND OVERSHORT_DR_CR  <> :OH-OVERSHORT-DR-CR           
                  AND OVERSHORT_AMT     = :OH-OVERSHORT-AMT             
                                                            
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT  CASH_COMPANY_NO                                          
MFA-TR*               ,DATE_CASH_REPORT                                         
MFA-TR*               ,OVERSHORT_ID                                             
MFA-TR*               ,OVERSHORT_AMT                                            
MFA-TR*               ,OFST_OVERSHORT_AMT                                       
MFA-TR*               ,OFST_DR_CR                                               
MFA-TR*               ,OVERSHORT_DR_CR                                          
MFA-TR*          INTO :OH-CASH-COMPANY-NO                                       
MFA-TR*              ,:OH-DATE-CASH-REPORT                                      
MFA-TR*              ,:OH-OVERSHORT-ID                                          
MFA-TR*              ,:OH-OVERSHORT-AMT                                         
MFA-TR*              ,:OH-OFST-OVERSHORT-AMT                                    
MFA-TR*              ,:OH-OFST-DR-CR                                            
MFA-TR*              ,:OH-OVERSHORT-DR-CR                                       
MFA-TR*          FROM CSS_OVERSHORT_HDR                                         
MFA-TR*         WHERE OVERSHORT_SOLTN_FL = 'P'                                  
MFA-TR*           AND CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO                   
MFA-TR*           AND CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE                 
MFA-TR*           AND DATE_CASH_REPORT  = :OH-DATE-CASH-REPORT                  
MFA-TR*           AND CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID                    
MFA-TR*           AND OVERSHORT_DR_CR  <> :OH-OVERSHORT-DR-CR                   
MFA-TR*           AND OVERSHORT_AMT     = :OH-OVERSHORT-AMT                     
MFA-TR*        QUERYNO 7775                                                     
MFA-TR*        WITH UR                                                          
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
      ******************************************************************        
      * IF A MATCH IS FOUND                                            *        
      *    UPDATE THE PROBELM OV-SH                                    *        
      *    INSERT THE ROW FOR THE NEW SOLUTION OV-SH IN OVERSHORT-HDR  *        
      *    INSERT A ROW IN OVERSHORT-DET                               *        
      * ELSE                                                           *        
      *    INSERT A ROW IN OVERSHORT-HDR                               *        
      ******************************************************************        
                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               MOVE 'S' TO WS-OVERSHORT-TYPE                            
               IF OH-OVERSHORT-DR-CR = 'C'                              
                  MOVE 'D' TO OH-OFST-DR-CR                             
               ELSE                                                     
                  MOVE 'C' TO OH-OFST-DR-CR                             
               END-IF                                                   
               PERFORM 7777-UPDATE-OVERSHORT-HDR THRU 7777-EXIT         
               PERFORM 7778-INSERT-OVERSHORT-HDR THRU 7778-EXIT         
               PERFORM 7779-INSERT-OVERSHORT-DET THRU 7779-EXIT         
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
               OR MULTIPLE-ROWS-SELECTED                                
                  MOVE 'P' TO WS-OVERSHORT-TYPE                         
                  PERFORM 7778-INSERT-OVERSHORT-HDR THRU 7778-EXIT      
               ELSE                                                     
                  MOVE SPACES                TO ABEND-TABLES            
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                  MOVE 'S351'                TO ABEND-PROGRAM           
                  MOVE 'SELECT'              TO ABEND-FUNCTION          
                  MOVE 'CSS_OVERSHORT_HDR'   TO TABLE-1                 
                  MOVE 'CASH_LOCAL_OFFICE'   TO TABLE-ELEMENT-1         
                  MOVE 'DATE_CASH_REPORT'    TO TABLE-ELEMENT-2         
                  MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3         
                  MOVE AR-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-1       
                  MOVE AR-TRANS-HIST-SEQ-NO  TO HOSTVAR-ELEMENT-2       
                  MOVE AR-ACCOUNT-NO         TO HOSTVAR-ELEMENT-4       
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT             
               END-IF                                                   
            END-IF.                                                     
      *                                                                         
       7775-EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7776-GET-LAST-OVERSHORT-ID.                                    *        
      *     OBTAIN LAST OVERSHORT-ID FOR CASH DRAWER IN THE            *        
      *     CSS-OVERSHORT TABLE.  IF NO ENTRIES, START OVERSHORT-ID AT *        
      *     1.                                                         *        
      ******************************************************************        
      *                                                                         
       7776-GET-LAST-OVERSHORT-ID.                                      
      *                                                                         
            MOVE '7776' TO ACTIVE-PARAGRAPH.                            
      *                                                                         
            EXEC SQL                                                    
               SELECT MAX(OVERSHORT_ID)                                 
                 INTO :OH-OVERSHORT-ID :WS-NULL-IND1                    
                 FROM CSS_OVERSHORT_HDR WITH(READUNCOMMITTED)                   
                WHERE CASH_COMPANY_NO   = '01'                          
                  AND CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE         
                  AND DATE_CASH_REPORT  = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                  
                  AND CASH_DRAWER_ID    = 9999                          
                                                            
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT MAX(OVERSHORT_ID)                                         
MFA-TR*          INTO :OH-OVERSHORT-ID :WS-NULL-IND1                            
MFA-TR*          FROM CSS_OVERSHORT_HDR                                         
MFA-TR*         WHERE CASH_COMPANY_NO   = '01'                                  
MFA-TR*           AND CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE                 
MFA-TR*           AND DATE_CASH_REPORT  = CURRENT DATE                          
MFA-TR*           AND CASH_DRAWER_ID    = 9999                                  
MFA-TR*       QUERYNO 7776                                                      
MFA-TR*          WITH UR                                                        
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
            IF WS-NULL-IND1 < 0                                         
               MOVE 1                TO OH-OVERSHORT-ID                 
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                  ADD 1 TO OH-OVERSHORT-ID                              
               ELSE                                                     
                  MOVE SPACES                TO ABEND-TABLES            
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                  MOVE 'S351'                TO ABEND-PROGRAM           
                  MOVE 'SELECT'              TO ABEND-FUNCTION          
                  MOVE 'CSS_OVERSHORT_HDR'   TO TABLE-1                 
                  MOVE 'CASH_COMPANY_NO'     TO TABLE-ELEMENT-1         
                  MOVE 'CASH_LOCAL_OFFICE'   TO TABLE-ELEMENT-2         
                  MOVE 'DATE_CASH_REPORT'    TO TABLE-ELEMENT-3         
                  MOVE 'CASH_DRAWER_ID'      TO TABLE-ELEMENT-4         
                  MOVE OH-CASH-COMPANY-NO    TO HOSTVAR-ELEMENT-1       
                  MOVE OH-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-2       
                  MOVE OH-DATE-CASH-REPORT   TO HOSTVAR-ELEMENT-3       
                  MOVE OH-CASH-DRAWER-ID     TO HOSTVAR-ELEMENT-4       
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT             
               END-IF                                                   
            END-IF.                                                     
      *                                                                         
       7776-EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7777-UPDATE-OVERSHORT-HDR.                                     *        
      *     SINCE MATCHING ENTRY WAS FOUND, UPDATE THE OFFSET AMT AND  *        
      *     IF EQUAL TO OVERSHORT AMT, UPDATE SOLTN-FL TO 'Y'          *        
      ******************************************************************        
      *                                                                         
       7777-UPDATE-OVERSHORT-HDR.                                       
      *                                                                         
           MOVE '7777' TO ACTIVE-PARAGRAPH.                             
           MOVE OH-CASH-COMPANY-NO     TO OD-OFST-COMPANY-NO.           
           MOVE OH-CASH-LOCAL-OFFICE   TO OD-OFST-LOC-OFCE.             
           MOVE OH-DATE-CASH-REPORT    TO OD-OFST-CASH-REPT-DT.         
           MOVE OH-CASH-DRAWER-ID      TO OD-OFST-CASH-DRWR-ID.         
           MOVE OH-OVERSHORT-ID        TO OD-OFST-OVERSHORT-ID.         
           MOVE OH-OVERSHORT-AMT       TO OD-OFST-OVERSHORT-AMT.        
P0586F     MOVE WS-AMT-DIFF-NUM        TO OH-OFST-OVERSHORT-AMT.        
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_OVERSHORT_HDR                                 
                  SET OFST_OVERSHORT_AMT = :OH-OFST-OVERSHORT-AMT,      
                      OFST_DR_CR         = :OH-OFST-DR-CR               
                WHERE CASH_COMPANY_NO    = :OH-CASH-COMPANY-NO          
                  AND CASH_LOCAL_OFFICE  = :OH-CASH-LOCAL-OFFICE        
                  AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )         
                  AND CASH_DRAWER_ID     = :OH-CASH-DRAWER-ID           
                  AND OVERSHORT_ID       = :OH-OVERSHORT-ID             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00210000
MFA-TR*        UPDATE CSS_OVERSHORT_HDR                                 00220000
MFA-TR*           SET OFST_OVERSHORT_AMT = :OH-OFST-OVERSHORT-AMT,      00271004
MFA-TR*               OFST_DR_CR         = :OH-OFST-DR-CR                       
MFA-TR*         WHERE CASH_COMPANY_NO    = :OH-CASH-COMPANY-NO                  
MFA-TR*           AND CASH_LOCAL_OFFICE  = :OH-CASH-LOCAL-OFFICE                
MFA-TR*           AND DATE_CASH_REPORT   = :OH-DATE-CASH-REPORT                 
MFA-TR*           AND CASH_DRAWER_ID     = :OH-CASH-DRAWER-ID                   
MFA-TR*           AND OVERSHORT_ID       = :OH-OVERSHORT-ID                     
MFA-TR*       QUERYNO 7777                                                      
MFA-TR*    END-EXEC.                                                    00480000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_OVERSHORT_HDR'       TO TABLE-1                 
              MOVE 'CASH_COMPANY_NO'         TO TABLE-ELEMENT-1         
              MOVE 'CASH_LOCAL_OFFICE'       TO TABLE-ELEMENT-2         
              MOVE 'DATE_CASH_REPORT'        TO TABLE-ELEMENT-3         
              MOVE 'CASH_DRAWER_ID'          TO TABLE-ELEMENT-4         
              MOVE OH-CASH-COMPANY-NO        TO HOSTVAR-ELEMENT-1       
              MOVE OH-CASH-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-2       
              MOVE OH-DATE-CASH-REPORT       TO HOSTVAR-ELEMENT-3       
              MOVE OH-CASH-DRAWER-ID         TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7777-EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7778-INSERT-OVERSHORT-HDR.                                     *        
      *     INSERT ENTRY INTO CSS_OVERSHORT_HDR IF OV/SH               *        
      ******************************************************************        
      *                                                                         
       7778-INSERT-OVERSHORT-HDR.                                       
      *                                                                         
           MOVE '7778' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           PERFORM 7776-GET-LAST-OVERSHORT-ID   THRU 7776-EXIT.         
      *                                                                         
           IF WS-NEG-DIFF-FLAG = 'Y'                                    
              MOVE 'C'                     TO OH-OVERSHORT-DR-CR        
           ELSE                                                         
               MOVE 'D'                     TO OH-OVERSHORT-DR-CR       
           END-IF.                                                      
     *                                                                  
           MOVE WS-CURRENT-DATE         TO OH-DATE-CASH-REPORT.         
           MOVE AR-CASH-LOCAL-OFFICE    TO OH-CASH-LOCAL-OFFICE.        
           MOVE 9999                    TO OH-CASH-DRAWER-ID.           
           MOVE PARM-USER-ID            TO OH-USER-ID.                  
           MOVE PARM-FROM-ACCOUNT-NO    TO OH-ACCOUNT-NO.               
P0586F     MOVE WS-AMT-DIFF-NUM         TO OH-OVERSHORT-AMT.            
           MOVE 'CSH-OV-SH'             TO GO-GL-ACCT-NAME.             
           PERFORM 7700-GET-GL-NO       THRU 7700-EXIT.                 
     *                                                                  
           MOVE GO-GL-ACCT-NO           TO OH-GL-ACCT-NO.               
           IF Y2-DEP-CASH-GL-OFFSET > 0                                 
              IF Y2-CASH-LOCAL-OFFICE = '025' AND                       
                 WS-PAR-PYMT-FACILITY-CD = 'G'                          
                 CONTINUE                                               
              ELSE                                                      
                 MOVE Y2-DEP-CASH-GL-OFFSET TO OH-GL-ACCT-NO            
              END-IF                                                    
           END-IF.                                                      
     *                                                                  
           MOVE OH-GL-ACCT-NO TO OT-GL-ACCT-NO.                         
           PERFORM 7960-GET-OVSH-TYPE THRU 7960-EXIT.                   
     *                                                                  
           MOVE OT-OVERSHORT-TYPE-CD TO OH-OVERSHORT-TYPE-CD.           
           PERFORM 7620-MNT-TRANHIS-TIMESTAMP THRU 7620-EXIT.           
     *                                                                  
           MOVE WS-MNT-TRH-TIMESTAMP TO OH-TRAN-TS                      
                                        OH-LAST-UPDATE-TS.              
           IF WS-OVERSHORT-TYPE = 'P'                                   
               MOVE 'P'                 TO OH-OVERSHORT-SOLTN-FL        
               MOVE ' '                 TO OH-OFST-DR-CR                
               MOVE 0                   TO OH-OFST-OVERSHORT-AMT        
           ELSE                                                         
               MOVE 'S'                 TO OH-OVERSHORT-SOLTN-FL        
               MOVE OH-OVERSHORT-AMT    TO OH-OFST-OVERSHORT-AMT        
               IF OH-OVERSHORT-DR-CR = 'C'                              
                 MOVE 'D'               TO OH-OFST-DR-CR                
               ELSE                                                     
                 MOVE 'C'               TO OH-OFST-DR-CR                
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           MOVE PARM-FROM-ACCT-CMMNT-LEN TO OH-TRAN-COMMENT-LEN.        
           MOVE PARM-FROM-ACCT-CMMNT-TEXT TO OH-TRAN-COMMENT-TEXT.      
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_OVERSHORT_HDR                             
                         ( CASH_COMPANY_NO                              
                          ,CASH_LOCAL_OFFICE                            
                          ,DATE_CASH_REPORT                             
                          ,CASH_DRAWER_ID                               
                          ,OVERSHORT_ID                                 
                          ,USER_ID                                      
                          ,ACCOUNT_NO                                   
                          ,OVERSHORT_AMT                                
                          ,OVERSHORT_DR_CR                              
                          ,OFST_OVERSHORT_AMT                           
                          ,OFST_DR_CR                                   
                          ,GL_ACCT_NO                                   
                          ,TRAN_TS                                      
                          ,LAST_UPDATE_TS                               
                          ,OVERSHORT_TYPE_CD                            
                          ,OVERSHORT_SOLTN_FL                           
                          ,TRAN_COMMENT)                                
                  VALUES( :OH-CASH-COMPANY-NO                           
                         ,:OH-CASH-LOCAL-OFFICE                         
                         ,IIF(TRY_CONVERT(DATE, :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )                         
                         ,:OH-CASH-DRAWER-ID                            
                         ,:OH-OVERSHORT-ID                              
                         ,:OH-USER-ID                                   
                         ,:OH-ACCOUNT-NO                                
                         ,:OH-OVERSHORT-AMT                             
                         ,:OH-OVERSHORT-DR-CR                           
                         ,:OH-OFST-OVERSHORT-AMT                        
                         ,:OH-OFST-DR-CR                                
                         ,:OH-GL-ACCT-NO                                
                         ,CIS.CHAR2TIMESTAMP(:OH-TRAN-TS)                       
                         ,CIS.CHAR2TIMESTAMP(:OH-LAST-UPDATE-TS)                
                         ,:OH-OVERSHORT-TYPE-CD                         
                         ,:OH-OVERSHORT-SOLTN-FL                        
                         ,:OH-TRAN-COMMENT)                             
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_OVERSHORT_HDR                                     
MFA-TR*                  ( CASH_COMPANY_NO                                      
MFA-TR*                   ,CASH_LOCAL_OFFICE                                    
MFA-TR*                   ,DATE_CASH_REPORT                                     
MFA-TR*                   ,CASH_DRAWER_ID                                       
MFA-TR*                   ,OVERSHORT_ID                                         
MFA-TR*                   ,USER_ID                                              
MFA-TR*                   ,ACCOUNT_NO                                           
MFA-TR*                   ,OVERSHORT_AMT                                        
MFA-TR*                   ,OVERSHORT_DR_CR                                      
MFA-TR*                   ,OFST_OVERSHORT_AMT                                   
MFA-TR*                   ,OFST_DR_CR                                           
MFA-TR*                   ,GL_ACCT_NO                                           
MFA-TR*                   ,TRAN_TS                                              
MFA-TR*                   ,LAST_UPDATE_TS                                       
MFA-TR*                   ,OVERSHORT_TYPE_CD                                    
MFA-TR*                   ,OVERSHORT_SOLTN_FL                                   
MFA-TR*                   ,TRAN_COMMENT)                                        
MFA-TR*           VALUES( :OH-CASH-COMPANY-NO                                   
MFA-TR*                  ,:OH-CASH-LOCAL-OFFICE                                 
MFA-TR*                  ,:OH-DATE-CASH-REPORT                                  
MFA-TR*                  ,:OH-CASH-DRAWER-ID                                    
MFA-TR*                  ,:OH-OVERSHORT-ID                                      
MFA-TR*                  ,:OH-USER-ID                                           
MFA-TR*                  ,:OH-ACCOUNT-NO                                        
MFA-TR*                  ,:OH-OVERSHORT-AMT                                     
MFA-TR*                  ,:OH-OVERSHORT-DR-CR                                   
MFA-TR*                  ,:OH-OFST-OVERSHORT-AMT                                
MFA-TR*                  ,:OH-OFST-DR-CR                                        
MFA-TR*                  ,:OH-GL-ACCT-NO                                        
MFA-TR*                  ,:OH-TRAN-TS                                           
MFA-TR*                  ,:OH-LAST-UPDATE-TS                                    
MFA-TR*                  ,:OH-OVERSHORT-TYPE-CD                                 
MFA-TR*                  ,:OH-OVERSHORT-SOLTN-FL                                
MFA-TR*                  ,:OH-TRAN-COMMENT)                                     
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE SPACES                TO ABEND-TABLES               
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
               MOVE 'S351'                TO ABEND-PROGRAM              
               MOVE 'INSERT'              TO ABEND-FUNCTION             
               MOVE 'CSS_OVERSHORT_HDR'   TO TABLE-1                    
               MOVE 'CASH_COMPANY_NO'     TO TABLE-ELEMENT-1            
               MOVE 'CASH_LOCAL_OFFICE'   TO TABLE-ELEMENT-2            
               MOVE 'DATE_CASH_REPORT'    TO TABLE-ELEMENT-3            
               MOVE 'CASH_DRAWER_ID'      TO TABLE-ELEMENT-4            
               MOVE OH-CASH-COMPANY-NO    TO HOSTVAR-ELEMENT-1          
               MOVE OH-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-2          
               MOVE OH-DATE-CASH-REPORT   TO HOSTVAR-ELEMENT-3          
               MOVE OH-CASH-DRAWER-ID     TO HOSTVAR-ELEMENT-4          
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
            END-IF.                                                     
      *                                                                         
       7778-EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7779-INSERT-OVERSHORT-DET.                                     *        
      *     INSERT ROW FOR TABLE MATCHING OFFSET WITH OVERSHORT        *        
      ******************************************************************        
      *                                                                         
       7779-INSERT-OVERSHORT-DET.                                       
      *                                                                         
            MOVE '7779' TO ACTIVE-PARAGRAPH.                            
            MOVE '01'                    TO OD-CASH-COMPANY-NO.         
            MOVE AR-CASH-LOCAL-OFFICE    TO OD-CASH-LOCAL-OFFICE.       
            MOVE WS-CURRENT-DATE         TO OD-DATE-CASH-REPORT.        
            MOVE 9999                    TO OD-CASH-DRAWER-ID.          
            MOVE OH-OVERSHORT-ID         TO OD-OVERSHORT-ID.            
            MOVE OH-OVERSHORT-DR-CR      TO OD-OFST-DR-CR.              
      *                                                                         
               EXEC SQL                                                 
                  SELECT MAX(OD.OVERSHORT_SEQ_NO)                       
                    INTO :OD-OVERSHORT-SEQ-NO :WS-NULL-IND1              
                    FROM CSS_OVERSHORT_DET OD WITH(READUNCOMMITTED)             
                   WHERE OD.CASH_COMPANY_NO   = :OD-CASH-COMPANY-NO     
                     AND OD.CASH_LOCAL_OFFICE = :OD-CASH-LOCAL-OFFICE   
                     AND OD.DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :OD-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OD-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OD-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OD-DATE-CASH-REPORT
              ), CONVERT(DATE, :OD-DATE-CASH-REPORT) )    
                     AND OD.CASH_DRAWER_ID    = :OD-CASH-DRAWER-ID      
                     AND OD.OVERSHORT_ID      = :OD-OVERSHORT-ID        
                                                            
                                                                 
               END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*        EXEC SQL                                                         
MFA-TR*           SELECT MAX(OD.OVERSHORT_SEQ_NO)                               
MFA-TR*             INTO :OD-OVERSHORT-SEQ-NO:WS-NULL-IND1                      
MFA-TR*             FROM CSS_OVERSHORT_DET OD                                   
MFA-TR*            WHERE OD.CASH_COMPANY_NO   = :OD-CASH-COMPANY-NO             
MFA-TR*              AND OD.CASH_LOCAL_OFFICE = :OD-CASH-LOCAL-OFFICE           
MFA-TR*              AND OD.DATE_CASH_REPORT  = :OD-DATE-CASH-REPORT            
MFA-TR*              AND OD.CASH_DRAWER_ID    = :OD-CASH-DRAWER-ID              
MFA-TR*              AND OD.OVERSHORT_ID      = :OD-OVERSHORT-ID                
MFA-TR*          QUERYNO 7779                                                   
MFA-TR*             WITH UR                                                     
MFA-TR*        END-EXEC.                                                        

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
             IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
                ADD 1 TO OD-OVERSHORT-SEQ-NO                            
             ELSE                                                       
                IF WS-NULL-IND1 < 0                                     
                   MOVE 1 TO OD-OVERSHORT-SEQ-NO                        
                ELSE                                                    
                   MOVE SPACES                TO ABEND-TABLES           
                   MOVE SPACES                TO ABEND-SQL-PREDICATES   
                   MOVE 'S351'                TO ABEND-PROGRAM          
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_OVERSHORT_DET'   TO TABLE-1                
                   MOVE 'CASH_COMPANY_NO'     TO TABLE-ELEMENT-1        
                   MOVE 'CASH_LOCAL_OFFICE'   TO TABLE-ELEMENT-2        
                   MOVE 'DATE_CASH_REPORT'    TO TABLE-ELEMENT-3        
                   MOVE 'CASH_DRAWER_ID'      TO TABLE-ELEMENT-4        
                   MOVE OD-CASH-COMPANY-NO    TO HOSTVAR-ELEMENT-1      
                   MOVE OD-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-2      
                   MOVE OD-DATE-CASH-REPORT   TO HOSTVAR-ELEMENT-3      
                   MOVE OD-CASH-DRAWER-ID     TO HOSTVAR-ELEMENT-4      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
                END-IF
             END-IF.                                                 
      *                                                                         
            EXEC SQL                                                    
                INSERT INTO CSS_OVERSHORT_DET                           
                     (CASH_COMPANY_NO                                   
                     ,CASH_LOCAL_OFFICE                                 
                     ,DATE_CASH_REPORT                                  
                     ,CASH_DRAWER_ID                                    
                     ,OVERSHORT_ID                                      
                     ,OVERSHORT_SEQ_NO                                  
                     ,OFST_OVERSHORT_AMT                                
                     ,OFST_DR_CR                                        
                     ,OFST_COMPANY_NO                                   
                     ,OFST_LOC_OFCE                                     
                     ,OFST_CASH_REPT_DT                                 
                     ,OFST_CASH_DRWR_ID                                 
                     ,OFST_OVERSHORT_ID )                               
                VALUES                                                  
                     (:OD-CASH-COMPANY-NO                               
                     ,:OD-CASH-LOCAL-OFFICE                             
                     ,IIF(TRY_CONVERT(DATE, :OD-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OD-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OD-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OD-DATE-CASH-REPORT
              ), CONVERT(DATE, :OD-DATE-CASH-REPORT) )                         
                     ,:OD-CASH-DRAWER-ID                                
                     ,:OD-OVERSHORT-ID                                  
                     ,:OD-OVERSHORT-SEQ-NO                              
                     ,:OD-OFST-OVERSHORT-AMT                            
                     ,:OD-OFST-DR-CR                                    
                     ,:OD-OFST-COMPANY-NO                               
                     ,:OD-OFST-LOC-OFCE                                 
                     ,IIF(TRY_CONVERT(DATE, :OD-OFST-CASH-REPT-DT
              ) IS NULL OR (PATINDEX('%.%', :OD-OFST-CASH-REPT-DT
              ) <> 0) OR (LEN(:OD-OFST-CASH-REPT-DT
              ) <> 10), CIS.CHAR2DATE(:OD-OFST-CASH-REPT-DT
              ), CONVERT(DATE, :OD-OFST-CASH-REPT-DT) )                        
                     ,:OD-OFST-CASH-DRWR-ID                             
                     ,:OD-OFST-OVERSHORT-ID)                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*         INSERT INTO CSS_OVERSHORT_DET                                   
MFA-TR*              (CASH_COMPANY_NO                                           
MFA-TR*              ,CASH_LOCAL_OFFICE                                         
MFA-TR*              ,DATE_CASH_REPORT                                          
MFA-TR*              ,CASH_DRAWER_ID                                            
MFA-TR*              ,OVERSHORT_ID                                              
MFA-TR*              ,OVERSHORT_SEQ_NO                                          
MFA-TR*              ,OFST_OVERSHORT_AMT                                        
MFA-TR*              ,OFST_DR_CR                                                
MFA-TR*              ,OFST_COMPANY_NO                                           
MFA-TR*              ,OFST_LOC_OFCE                                             
MFA-TR*              ,OFST_CASH_REPT_DT                                         
MFA-TR*              ,OFST_CASH_DRWR_ID                                         
MFA-TR*              ,OFST_OVERSHORT_ID )                                       
MFA-TR*         VALUES                                                          
MFA-TR*              (:OD-CASH-COMPANY-NO                                       
MFA-TR*              ,:OD-CASH-LOCAL-OFFICE                                     
MFA-TR*              ,:OD-DATE-CASH-REPORT                                      
MFA-TR*              ,:OD-CASH-DRAWER-ID                                        
MFA-TR*              ,:OD-OVERSHORT-ID                                          
MFA-TR*              ,:OD-OVERSHORT-SEQ-NO                                      
MFA-TR*              ,:OD-OFST-OVERSHORT-AMT                                    
MFA-TR*              ,:OD-OFST-DR-CR                                            
MFA-TR*              ,:OD-OFST-COMPANY-NO                                       
MFA-TR*              ,:OD-OFST-LOC-OFCE                                         
MFA-TR*              ,:OD-OFST-CASH-REPT-DT                                     
MFA-TR*              ,:OD-OFST-CASH-DRWR-ID                                     
MFA-TR*              ,:OD-OFST-OVERSHORT-ID)                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               ADD 1 TO OD-OVERSHORT-SEQ-NO                             
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                  MOVE 1 TO OD-OVERSHORT-SEQ-NO                         
               ELSE                                                     
                  MOVE SPACES                TO ABEND-TABLES            
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                  MOVE 'S351'                TO ABEND-PROGRAM           
                  MOVE 'INSERT'              TO ABEND-FUNCTION          
                  MOVE 'CSS_OVERSHORT_DET'   TO TABLE-1                 
                  MOVE 'CASH_COMPANY_NO'     TO TABLE-ELEMENT-1         
                  MOVE 'CASH_LOCAL_OFFICE'   TO TABLE-ELEMENT-2         
                  MOVE 'DATE_CASH_REPORT'    TO TABLE-ELEMENT-3         
                  MOVE 'CASH_DRAWER_ID'      TO TABLE-ELEMENT-4         
                  MOVE OD-CASH-COMPANY-NO    TO HOSTVAR-ELEMENT-1       
                  MOVE OD-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-2       
                  MOVE OD-DATE-CASH-REPORT   TO HOSTVAR-ELEMENT-3       
                  MOVE OD-CASH-DRAWER-ID     TO HOSTVAR-ELEMENT-4       
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT             
               END-IF                                                   
            END-IF.                                                     
      *                                                                         
       7779-EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7950-PROCESS-RECORD-ONLY.                                      *        
      *     THE SELECT DETERMINES IF A BILLING OCCURRED AFTER THE      *        
      *     PAYMENT WAS MADE. IF NOT THIS MEANS THE JOURNALING IS FOR  *        
      *     RECORDS ONLY. NOTE THIS SELECT MAY BRING BACK MORE THAN    *        
      *     ONE ROW IF SO MULTIPLE BILLINGS HAVE OCCURRED.             *        
      ******************************************************************        
      *                                                                         
       7950-PROCESS-RECORD-ONLY.                                        
      *                                                                         
           MOVE '7950' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), TRANS_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') TRANS_HIST_SEQ_NO                      
               INTO :WS-TRANS-HIST-SEQ-NO                               
               FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                     
              WHERE ACCOUNT_NO = :AR-ACCOUNT-NO                         
                AND TRANS_HIST_SEQ_NO > CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )           
                AND CODE_TRAN_TYPE = 'B'                                
                AND CIS.SUBSTR3(
           APPL_PROGRAM_ID,1,5) IN ('PCSCA','SCSCA')    
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT TRANS_HIST_SEQ_NO                                          
MFA-TR*        INTO :WS-TRANS-HIST-SEQ-NO                                       
MFA-TR*        FROM CSS_AR_TRANS_HIST                                           
MFA-TR*       WHERE ACCOUNT_NO = :AR-ACCOUNT-NO                                 
MFA-TR*         AND TRANS_HIST_SEQ_NO > :AR-TRANS-HIST-SEQ-NO                   
MFA-TR*         AND CODE_TRAN_TYPE = 'B'                                        
MFA-TR*         AND SUBSTR(APPL_PROGRAM_ID,1,5) IN ('PCSCA','SCSCA')            
MFA-TR*       QUERYNO 7950                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR NOT-FOUND                                                 
           OR WS-FOUND-MULT-BILLS                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'TRANS_HIST_SEQ_NO'       TO TABLE-ELEMENT-2         
              MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AR-TRANS-HIST-SEQ-NO      TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7951-GET-ADJ-ROW.                                              *        
      *     THE SELECT GETS THE ADJ ROW FOR THE PAYMENT TO BE          *        
      *     CORRECTED.  WHEN THE PAYMENT ROW IS CORRECTED THE RECORD   *        
      *     ONLY FLAG FOR THE ADJ ROW SHOULD ALSO BE SET.              *        
      ******************************************************************        
      *                                                                         
       7951-GET-ADJ-ROW.                                                
      *                                                                         
           MOVE '7951' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), TRANS_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') TRANS_HIST_SEQ_NO                      
                INTO :WS-ADJ-TRANS-HIST-SEQ-NO                          
                FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                    
               WHERE ACCOUNT_NO = :AR-ACCOUNT-NO                        
                 AND TRANS_HIST_SEQ_NO <= CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )         
                 AND DATE_TRANS = IIF(TRY_CONVERT(DATE, :AR-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS
              ) <> 0) OR (LEN(:AR-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :AR-DATE-TRANS
              ), CONVERT(DATE, :AR-DATE-TRANS) )                        
                 AND CODE_TRAN_TYPE = 'A'                               
                 AND APPL_PROGRAM_ID = 'PANEL113H'                      
                 AND CAST(TRANS_HIST_SEQ_NO AS DATE) = 
              IIF(TRY_CONVERT(DATE, :WS-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE) <> 0) OR (LEN(
                                                               :WS-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-DATE), CONVERT(DATE, :WS-DATE
              ) )                 
                 AND DATEADD(NANOSECOND, -DATEPART(NANOSECOND, CAST(
           TRANS_HIST_SEQ_NO AS TIME)), CAST(TRANS_HIST_SEQ_NO
            AS TIME)) = CIS.CHAR2TIME(:WS-TIME)                 
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT TRANS_HIST_SEQ_NO                                          
MFA-TR*         INTO :WS-ADJ-TRANS-HIST-SEQ-NO                                  
MFA-TR*         FROM CSS_AR_TRANS_HIST                                          
MFA-TR*        WHERE ACCOUNT_NO = :AR-ACCOUNT-NO                                
MFA-TR*          AND TRANS_HIST_SEQ_NO <= :AR-TRANS-HIST-SEQ-NO                 
MFA-TR*          AND DATE_TRANS = :AR-DATE-TRANS                                
MFA-TR*          AND CODE_TRAN_TYPE = 'A'                                       
MFA-TR*          AND APPL_PROGRAM_ID = 'PANEL113H'                              
MFA-TR*          AND DATE(TRANS_HIST_SEQ_NO) = :WS-DATE                         
MFA-TR*          AND TIME(TRANS_HIST_SEQ_NO) = :WS-TIME                         
MFA-TR*       QUERYNO 7951                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR NOT-FOUND                                                 
           OR WS-FOUND-MULT-BILLS                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'TRANS_HIST_SEQ_NO'       TO TABLE-ELEMENT-2         
              MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AR-TRANS-HIST-SEQ-NO      TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7951-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7960-GET-OVSH-TYPE.                                            *        
      *     SELECTS THE OVERSHORT INFORMATION                          *        
      ******************************************************************        
      *                                                                         
       7960-GET-OVSH-TYPE.                                              
      *                                                                         
           MOVE '7960' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) OVERSHORT_TYPE_CD                                   
               INTO :OT-OVERSHORT-TYPE-CD                               
               FROM CSS_OVERSHORT_TYPE WITH(READUNCOMMITTED)                    
              WHERE GL_ACCT_NO = :OT-GL-ACCT-NO                         
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT OVERSHORT_TYPE_CD                                           
MFA-TR*        INTO :OT-OVERSHORT-TYPE-CD                                       
MFA-TR*        FROM CSS_OVERSHORT_TYPE                                          
MFA-TR*       WHERE GL_ACCT_NO = :OT-GL-ACCT-NO                                 
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7960                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_OVERSHORT_TYPE'      TO TABLE-1                 
              MOVE 'GL_ACCT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2         
              MOVE OT-GL-ACCT-NO             TO WS-DISP-GL-ACCT         
              MOVE WS-DISP-GL-ACCT           TO HOSTVAR-ELEMENT-1       
              MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7960-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7999-SELECT-AL.                                                *        
      *     CHECKS FOR AR-LOCKOUT.                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     14890000
              INCLUDE CPD00075                                          14900000
           END-EXEC.                                                    14910000
      *                                                                         
      ******************************************************************00268000
      * 8000-INSERT-CIA-IN-AR-CNTL.                                    *00268000
      *   INSERT A ROW IN AR CONTROL TABLE                             *00268100
      ******************************************************************00268000
      *                                                                 00268200
       8000-INSERT-CIA-IN-AR-CNTL.                                      
      *                                                                 00268200
           EXEC SQL                                                     
               INSERT INTO CSS_AR_CNTL                                  
                   (                                                    
                    ACCOUNT_NO                                          
                   ,PYMT_PRIORITY_LVL                                   
                   ,ITEM_ID                                             
                   ,AMT_AR_DAY_00                                       
                   ,AMT_AR_DAY_30                                       
                   ,AMT_AR_DAY_60                                       
                   ,AMT_AR_DAY_90                                       
                   ,AMT_UNUSED_CR                                       
                   ,TOT_SUMM_UNBILLED                                   
                   ,AMT_TRAN_BALANCE                                    
                   ,LAST_UPDATE_TS                                      
                   )                                                    
                VALUES                                                  
                   (                                                    
                    :AC-ACCOUNT-NO                                      
                   ,70                                                  
                   ,:AC-ITEM-ID                                         
                   ,0                                                   
                   ,0                                                   
                   ,0                                                   
                   ,0                                                   
                   ,0                                                   
                   ,0                                                   
                   ,0                                                   
                   ,CIS.CURRENT$TIMESTAMP()                                   
                   )                                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     00268400
MFA-TR*        INSERT INTO CSS_AR_CNTL                                  00268500
MFA-TR*            (                                                    00268600
MFA-TR*             ACCOUNT_NO                                          00268600
MFA-TR*            ,PYMT_PRIORITY_LVL                                   00268700
MFA-TR*            ,ITEM_ID                                             00268800
MFA-TR*            ,AMT_AR_DAY_00                                       00268900
MFA-TR*            ,AMT_AR_DAY_30                                       00269000
MFA-TR*            ,AMT_AR_DAY_60                                       00269100
MFA-TR*            ,AMT_AR_DAY_90                                       00269200
MFA-TR*            ,AMT_UNUSED_CR                                       00269300
MFA-TR*            ,TOT_SUMM_UNBILLED                                   00269400
MFA-TR*            ,AMT_TRAN_BALANCE                                    00269500
MFA-TR*            ,LAST_UPDATE_TS                                      00269600
MFA-TR*            )                                                    00269600
MFA-TR*         VALUES                                                  00269700
MFA-TR*            (                                                    00269800
MFA-TR*             :AC-ACCOUNT-NO                                      00269800
MFA-TR*            ,70                                                  00269900
MFA-TR*            ,:AC-ITEM-ID                                         00270000
MFA-TR*            ,0                                                   00270100
MFA-TR*            ,0                                                   00270200
MFA-TR*            ,0                                                   00270300
MFA-TR*            ,0                                                   00270400
MFA-TR*            ,0                                                   00270500
MFA-TR*            ,0                                                   00270600
MFA-TR*            ,0                                                   00270700
MFA-TR*            ,CURRENT TIMESTAMP                                   00270800
MFA-TR*            )                                                    00270800
MFA-TR*    END-EXEC.                                                    00270900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00271000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_AR_CNTL'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'PYMT_PRIORITY_LVL'       TO TABLE-ELEMENT-2         
              MOVE 'ITEM_ID'                 TO TABLE-ELEMENT-3         
              MOVE AC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE '70'                      TO HOSTVAR-ELEMENT-2       
              MOVE AC-ITEM-ID                TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                 00272900
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8010-CREATE-NEW-BATCH.                                         *        
      *     CREATES A NEW BATCH.                                       *        
      ******************************************************************        
      *                                                                         
       8010-CREATE-NEW-BATCH.                                           
      *                                                                         
           MOVE '8010' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO CSS_CSH_DRWR_CNTL                              
                  (                                                     
                   CASH_COMPANY_NO                                      
                  ,CASH_LOCAL_OFFICE                                    
                  ,CASH_REPORT_NO                                       
                  ,DATE_CASH_REPORT                                     
                  ,CASH_DRAWER_ID                                       
                  ,AMT_CASH_DEBIT                                       
                  ,AMT_CASH_CREDIT                                      
                  ,AMT_AR_DEBIT                                         
                  ,AMT_AR_CREDIT                                        
                  ,AMT_CK_ISS_DEBIT                                     
                  ,AMT_CK_ISS_CREDIT                                    
                  ,AMT_GL_DEBIT                                         
                  ,AMT_GL_CREDIT                                        
                  ,AMT_CASH_BEGIN_BAL                                   
                  ,AMT_BASIC_WORK                                       
                  ,USER_ID                                              
                  ,CASHIER_CODE                                         
                  ,CODE_PYMT_FACILITY                                   
                  ,CODE_FCS_EXTRACTED                                   
                  ,CODE_CSH_DRWR_STAT                                   
                  ,DATE_LAST_ACTIVITY                                   
                  ,BALANCED_BY                                          
                  ,BALANCED_TS                                          
                  ,NO_ITEMS_ENTERED                                     
                  )                                                     
           VALUES (                                                     
                   :CS-CASH-COMPANY-NO                                  
                  ,:CS-CASH-LOCAL-OFFICE                                
                  ,:CS-CASH-REPORT-NO                                   
                  ,IIF(TRY_CONVERT(DATE, :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )                         
                  ,:CS-CASH-DRAWER-ID                                   
                  ,:CS-AMT-CASH-DEBIT                                   
                  ,:CS-AMT-CASH-CREDIT                                  
                  ,:CS-AMT-AR-DEBIT                                     
                  ,:CS-AMT-AR-CREDIT                                    
                  ,:CS-AMT-CK-ISS-DEBIT                                 
                  ,:CS-AMT-CK-ISS-CREDIT                                
                  ,:CS-AMT-GL-DEBIT                                     
                  ,:CS-AMT-GL-CREDIT                                    
                  ,:CS-AMT-CASH-BEGIN-BAL                               
                  ,:CS-AMT-BASIC-WORK                                   
                  ,:CS-USER-ID                                          
                  ,:CS-CASHIER-CODE                                     
                  ,:CS-CODE-PYMT-FACILITY                               
                  ,:CS-CODE-FCS-EXTRACTED                               
                  ,:CS-CODE-CSH-DRWR-STAT                               
                  ,IIF(TRY_CONVERT(DATE, :CS-DATE-LAST-ACTIVITY
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-LAST-ACTIVITY
              ) <> 0) OR (LEN(:CS-DATE-LAST-ACTIVITY
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-LAST-ACTIVITY
              ), CONVERT(DATE, :CS-DATE-LAST-ACTIVITY) )                       
                  ,:CS-BALANCED-BY                                      
                  ,CIS.CHAR2TIMESTAMP(:CS-BALANCED-TS :WS-NULL-BAL-TS)          
                  ,:CS-NO-ITEMS-ENTERED                                 
                  )                                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_CSH_DRWR_CNTL                                      
MFA-TR*           (                                                             
MFA-TR*            CASH_COMPANY_NO                                              
MFA-TR*           ,CASH_LOCAL_OFFICE                                            
MFA-TR*           ,CASH_REPORT_NO                                               
MFA-TR*           ,DATE_CASH_REPORT                                             
MFA-TR*           ,CASH_DRAWER_ID                                               
MFA-TR*           ,AMT_CASH_DEBIT                                               
MFA-TR*           ,AMT_CASH_CREDIT                                              
MFA-TR*           ,AMT_AR_DEBIT                                                 
MFA-TR*           ,AMT_AR_CREDIT                                                
MFA-TR*           ,AMT_CK_ISS_DEBIT                                             
MFA-TR*           ,AMT_CK_ISS_CREDIT                                            
MFA-TR*           ,AMT_GL_DEBIT                                                 
MFA-TR*           ,AMT_GL_CREDIT                                                
MFA-TR*           ,AMT_CASH_BEGIN_BAL                                           
MFA-TR*           ,AMT_BASIC_WORK                                               
MFA-TR*           ,USER_ID                                                      
MFA-TR*           ,CASHIER_CODE                                                 
MFA-TR*           ,CODE_PYMT_FACILITY                                           
MFA-TR*           ,CODE_FCS_EXTRACTED                                           
MFA-TR*           ,CODE_CSH_DRWR_STAT                                           
MFA-TR*           ,DATE_LAST_ACTIVITY                                           
MFA-TR*           ,BALANCED_BY                                                  
MFA-TR*           ,BALANCED_TS                                                  
MFA-TR*           ,NO_ITEMS_ENTERED                                             
MFA-TR*           )                                                             
MFA-TR*    VALUES (                                                             
MFA-TR*            :CS-CASH-COMPANY-NO                                          
MFA-TR*           ,:CS-CASH-LOCAL-OFFICE                                        
MFA-TR*           ,:CS-CASH-REPORT-NO                                           
MFA-TR*           ,:CS-DATE-CASH-REPORT                                         
MFA-TR*           ,:CS-CASH-DRAWER-ID                                           
MFA-TR*           ,:CS-AMT-CASH-DEBIT                                           
MFA-TR*           ,:CS-AMT-CASH-CREDIT                                          
MFA-TR*           ,:CS-AMT-AR-DEBIT                                             
MFA-TR*           ,:CS-AMT-AR-CREDIT                                            
MFA-TR*           ,:CS-AMT-CK-ISS-DEBIT                                         
MFA-TR*           ,:CS-AMT-CK-ISS-CREDIT                                        
MFA-TR*           ,:CS-AMT-GL-DEBIT                                             
MFA-TR*           ,:CS-AMT-GL-CREDIT                                            
MFA-TR*           ,:CS-AMT-CASH-BEGIN-BAL                                       
MFA-TR*           ,:CS-AMT-BASIC-WORK                                           
MFA-TR*           ,:CS-USER-ID                                                  
MFA-TR*           ,:CS-CASHIER-CODE                                             
MFA-TR*           ,:CS-CODE-PYMT-FACILITY                                       
MFA-TR*           ,:CS-CODE-FCS-EXTRACTED                                       
MFA-TR*           ,:CS-CODE-CSH-DRWR-STAT                                       
MFA-TR*           ,:CS-DATE-LAST-ACTIVITY                                       
MFA-TR*           ,:CS-BALANCED-BY                                              
MFA-TR*           ,:CS-BALANCED-TS   :WS-NULL-BAL-TS                            
MFA-TR*           ,:CS-NO-ITEMS-ENTERED                                         
MFA-TR*           )                                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           OR NOT-FOUND                                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CSH_DRWR_CNTL'       TO TABLE-1                 
              MOVE 'CASH_LOCAL_OFFICE'       TO TABLE-ELEMENT-1         
              MOVE 'DATE_CASH_REPORT'        TO TABLE-ELEMENT-2         
              MOVE 'CASH_DRAWER_ID'          TO TABLE-ELEMENT-3         
              MOVE 'CODE_CSH_DRWR_STAT'      TO TABLE-ELEMENT-4         
              MOVE CS-CASH-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-1       
              MOVE CS-DATE-CASH-REPORT       TO HOSTVAR-ELEMENT-2       
              MOVE CS-CASH-DRAWER-ID         TO HOSTVAR-ELEMENT-3       
              MOVE CS-CODE-CSH-DRWR-STAT     TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       8010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  12310000
      * 8000A-DELETE-GTT-ROWS.                                       *  12320000
      *      DELETES THE GTT ROWS.                                   *  12320000
      ****************************************************************  12330000
      *                                                                         
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
           MOVE '8000A' TO ACTIVE-PARAGRAPH.                            
           MOVE 'DELETE ROWS' TO S-SQL-STATEMENT-V.                     
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM #CSR04894_R1                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM SESSION.CSR04894_R1                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           OR NOT-FOUND                                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE SQLCODE               TO ABEND-SQLCODE              
               MOVE 'DELETE'              TO ABEND-FUNCTION             
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSR04894_R1'         TO TABLE-1                    
               MOVE SPACES                TO TABLE-ELEMENT-1            
               MOVE SPACES                TO HOSTVAR-ELEMENT-1          
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ****************************************************************  12310000
      * 8100-SEND-RESULT.                                            *  12320000
      *     INSERTS INTO THE TEMPORARY TABLE.                        *  12320000
      ****************************************************************  12330000
       8100-SEND-RESULT.                                                
      *                                                                         
           MOVE '8100' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO #CSR04894_R1                         
                (                                                       
                      RETURN_CODE                                       
                     ,ACCOUNT_NO                                        
                     ,ERROR_MESSAGE1                                    
                     ,ERROR_MESSAGE2                                    
                )                                                       
                VALUES                                                  
                (                                                       
                      :S-RETURN-CODE                                    
                     ,:S-ACCOUNT-NO                                     
                     ,:S-ERROR-MESSAGE1                                 
                     ,:S-ERROR-MESSAGE2                                 
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04894_R1                                 
MFA-TR*         (                                                               
MFA-TR*               RETURN_CODE                                               
MFA-TR*              ,ACCOUNT_NO                                                
MFA-TR*              ,ERROR_MESSAGE1                                            
MFA-TR*              ,ERROR_MESSAGE2                                            
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*               :S-RETURN-CODE                                            
MFA-TR*              ,:S-ACCOUNT-NO                                             
MFA-TR*              ,:S-ERROR-MESSAGE1                                         
MFA-TR*              ,:S-ERROR-MESSAGE2                                         
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR -204           
              ADD +1 TO CTR-ROWS                                        
           ELSE                                                         
                MOVE PROGRAM-NAME              TO ABEND-PROGRAM         
                MOVE SQLCODE                   TO ABEND-SQLCODE         
                MOVE 'INSERT'                  TO ABEND-FUNCTION        
                MOVE SPACES                    TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
                MOVE 'CSR04894_R1'             TO TABLE-1               
                MOVE SPACES                    TO TABLE-ELEMENT-1       
                MOVE SPACES                    TO HOSTVAR-ELEMENT-1     
                PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8325-CREATE-CASH-REPORT.                                       *        
      *     CREATES A NEW CSS-CSH_REPORT_HDR ROW.                      *        
      ******************************************************************        
      *                                                                         
       8325-CREATE-CASH-REPORT.                                         
      *                                                                         
           MOVE '8325' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO CSS_CSH_REPORT_HDR                             
                    (                                                   
                     CASH_COMPANY_NO                                    
                    ,CASH_LOCAL_OFFICE                                  
                    ,DATE_CASH_REPORT                                   
                    ,USER_ID                                            
                    ,STATUS                                             
                    ,CLOSED_TS                                          
                    )                                                   
             VALUES (                                                   
                     :YR-CASH-COMPANY-NO                                
                     ,:YR-CASH-LOCAL-OFFICE                             
                     ,IIF(TRY_CONVERT(DATE, :YR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YR-DATE-CASH-REPORT
              ), CONVERT(DATE, :YR-DATE-CASH-REPORT) )                         
                     ,:YR-USER-ID                                       
                     ,:YR-STATUS                                        
                     ,CIS.CURRENT$TIMESTAMP()                                 
                     )                                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_CSH_REPORT_HDR                                     
MFA-TR*             (                                                           
MFA-TR*              CASH_COMPANY_NO                                            
MFA-TR*             ,CASH_LOCAL_OFFICE                                          
MFA-TR*             ,DATE_CASH_REPORT                                           
MFA-TR*             ,USER_ID                                                    
MFA-TR*             ,STATUS                                                     
MFA-TR*             ,CLOSED_TS                                                  
MFA-TR*             )                                                           
MFA-TR*      VALUES (                                                           
MFA-TR*              :YR-CASH-COMPANY-NO                                        
MFA-TR*              ,:YR-CASH-LOCAL-OFFICE                                     
MFA-TR*              ,:YR-DATE-CASH-REPORT                                      
MFA-TR*              ,:YR-USER-ID                                               
MFA-TR*              ,:YR-STATUS                                                
MFA-TR*              ,CURRENT TIMESTAMP                                         
MFA-TR*              )                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CSH_REPORT_HDR'  TO TABLE-1                     
              MOVE 'CASH COMPANY NO'     TO TABLE-ELEMENT-1             
              MOVE 'CASH LOCAL OFFICE'   TO TABLE-ELEMENT-2             
              MOVE 'DATE CASH REPORT'    TO TABLE-ELEMENT-3             
              MOVE YR-CASH-COMPANY-NO    TO HOSTVAR-ELEMENT-1           
              MOVE YR-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-2           
              MOVE YR-DATE-CASH-REPORT   TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       8325-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************00273300
      * 8999-ISSUE-COMMIT                                              *        
      *     COMMIT STATEMENT FOR DB2/SQL CHECK POINTS.                 *        
      ******************************************************************        
      *                                                                         
       8999-ISSUE-COMMIT.                                               
      *                                                                         
           EXEC SQL                                                     14890000
              INCLUDE CPD00047                                          14900000
           END-EXEC.                                                    14910000
                                                    
      *                                                                         
       8999-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14910000
      ******************************************************************14920000
      * 9000A-SEND-ERROR-RESULT                                        *        
      *      PERFORMS ROLLBACK FOR ACCOUNTS PROCESSED BEFORE ABEND     *        
      ******************************************************************        
      *                                                                 14910000
       9000A-SEND-ERROR-RESULT.                                         
      *                                                                 14910000
           MOVE 'N' TO SEND-DONE-SW.                                    
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE.                
      *                                                                 14910000
           EXEC SQL                                                     
                ROLLBACK                                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14910000
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK' TO ABEND-FUNCTION                         
           END-IF.                                                      
      *                                                                 14910000
           PERFORM 0100A-DECLARE-GTT      THRU 0100A-EXIT.              
           PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT.              
           PERFORM 8100-SEND-RESULT       THRU 8100-EXIT.               
           PERFORM 9999-END-PROGRAM       THRU 9999-EXIT.               
      *                                                                 14910000
       9000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 14910000
      ******************************************************************        
      * 9200-LINK-SCACA182.                                            *        
      *     RETRIEVES LAST UPDATE TIMESTAMP FOR AN ACCOUNT             *00322600
      ******************************************************************        
      *                                                                 00322800
       9200-LINK-SCSCA182.                                              
      *                                                                 00322800
           MOVE '9200' TO ACTIVE-PARAGRAPH.                             
      *                                                                 00322800
           CALL MCSCA182  USING  SCSCA182-ACCOUNT-NO                    
                                ,SCSCA182-RETURN-CODE                   
                                ,SCSCA182-LAST-UPDATE-TS                
                                ,ABEND-FILE.                            
      *                                                                 00322800
           MOVE SCSCA182-ACCOUNT-NO TO RS-ACCOUNT-NO.                   
      *                                                                 00322800
       9200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9350-LINK-SCSCO061.                                            *        
      *     CALLS THE SUBPROGRAM SCSCO061.                             *        
      ******************************************************************        
      *                                                                         
       9350-LINK-SCSCO061.                                              
      *                                                                         
           MOVE SPACES TO ABEND-FUNCTION.                               
           PERFORM 9400-CALL-CPD00061 THRU 9400-EXIT.                   
      *                                                                         
           MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE                 
                                  SQLCODE.                              
           IF ABEND-FUNCTION > SPACES                                   
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       9350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9400-CALL-CPD00061                                             *        
      *     CALLS THE COPYBOOK CPD00061                                *        
      ******************************************************************        
      *                                                                         
       9400-CALL-CPD00061.                                              
      *                                                                         
           CALL MCSCO061  USING  WS-GL-ACCT-NAME                        
                                 WS-GL-ACCT-MAJOR-FIELDS                
                                 WS-VALID-COMPANY-NOS                   
                                 WS-GL-NAME-INFO                        
                                 WS-GL-ACCT-NO-TABLE                    
                                 ABEND-FILE                             
                                 RS-RETURN-CODE.                        
      *                                                                         
           MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE.                
           IF ABEND-FUNCTION > SPACES                                   
              IF ABEND-FUNCTION EQUAL 'BADDATA'                         
                 MOVE -1 TO RS-RETURN-CODE                              
                            WS-ACTIVE-RETURN-CODE                       
              END-IF                                                    
              PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       9400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************00327100
      * 9700-PROCESS-ABEND.                                            *14870000
      ******************************************************************14880000
      *                                                                 14920000
           EXEC SQL                                                     14890000
              INCLUDE CPD0023C                                          14900000
           END-EXEC.                                                    14910000
      *                                                                 14920000
      ******************************************************************14880000
      * 9800-CALL-MCS03413.                                            *00329700
      *     CANCEL DNP OR DNPFB                                        *00329800
      ******************************************************************14880000
      *                                                                 14920000
ACT285 9800-CALL-MCS03414.                                              
      *                                                                 14920000
ACT285     CALL MCS03414 USING   WS-ACCOUNT-NO-NUM                      
ACT285                          ,WS-UPDATE-ACTION-FL                    
                                ,WS-D                                   
                                ,WS-DNP-RET-CODE                        
ACT285                          ,WS-PYMT-AMOUNT                         
ACT285                          ,WS-PAYMENT-AMOUNT-TOTAL                
ACT285                          ,WS-CALL-TYPE                           
ACT285                          ,WS-CPD68-REQUIRED                      
ACT285                          ,WS-PROGRAM-NAME                        
ACT285                          ,WS-CPD68-ACTN-FL                       
ACT285                          ,WS-CNCL-DNP-ACTN-FL                    
P00948                          ,WS-CNCL-DNP-EMAIL-REQ-FL               
ACT285                          ,WS-SO-UPDT-ACTN-FL                     
ACT285                          ,WS-CRED-ARNG-ACTN-FL                   
ACT285                          ,ws-APPL-PROGRAM-ID                     
                                ,ABEND-FILE.                            
      *                                                                         
       9800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************14860000
      * 9900-SQL-ERROR-ROUTINE.                                        *14870000
      * 9975-ABEND-CONTROL-TRANSFER.                                   *14870000
      ******************************************************************14880000
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************14930000
      * 8900-SEND-DONE.                                                *14930000
      * 9000-SEND-ERROR-RESULT.                                        *14930000
      * 9999-END-PROGRAM.                                              *14930000
      ******************************************************************14950000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00320                                                 
           END-EXEC.                                                            
                                                                        
