       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04893.                                     
COB303 DATE-WRITTEN.      FEB 14, 2013.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00170014
      *                 P R O G R A M  S U M M A R Y                   *00180014
      ******************************************************************00180015
      *                                                                *00190014
      *  THIS PROGRAM                                                  *00200014
      *       - BOOKS OVERAGES/SHORTAGES                               *00200014
      *       - OFFSETS EXISTING OVERAGES/SHORTAGES                    *00200014
      *       - OFFSET REVERSAL                                        *00200014
      *                                                                *00200015
      *  BUSS OP: UPDOVERAGESHORTAGEOFFSET (CASH MANAGEMENT)          * 00200015
      *                                                                *00200015
      *  CALL-TYPE: 'O' - OFFSET                                       *00200015
      *             'R' - OFFSET REVERSAL                              *00200015
      *                                                                *00260014
      ******************************************************************00260014
      *                                                                *00270014
      *                     PROGRAM MODIFICATION LOG                   *00280014
      *                                                                *00280015
      ******************************************************************00280016
      *                                                                *00290014
      *    DATE    INITIALS   COMMENTS                                 *00300014
      *  --------  --------   ---------------------------------------  *00310014
P00586*  04/01/16  VP43661    PROCEDURE ORIGINALLY CODED.              *00311014
P00586*  10/14/16  VP43661    OFFSET REVERSAL CHANGES.                 *00311014
      *                                                                *00312014
      ******************************************************************00630014
      *                                                                *00640014
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00650014
      *                                                                *00660014
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00670014
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00680014
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00690014
      *  3000 - 4999  NOT USED                                         *00700014
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00710014
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00720014
      *  7000 - 7999  INPUT MODULES                                    *00730014
      *  8000 - 8999  OUTPUT MODULES                                   *00740014
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00750014
      *                                                                *00760014
      ******************************************************************00770014
      *                                                                 00780014
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04893'.
MSQ017     COPY MFASQLM.
      *                                                                 00820014
       01  WS-START                     PIC X(40)  VALUE                
           'WORKING STORAGE FOR CSR04893 STARTS HERE'.                  
      *                                                                 01520014
      ******************************************************************01530014
      * Work Areas                                                     *01540014
      ******************************************************************01550014
      *                                                                 01560014
       01  GTT-RETURN-FIELDS.                                           
           05  S-APPL-RETURN-CODE       PIC X(10)  VALUE SPACES.        
           05  S-RETURN-CODE            PIC S9(9)  COMP  VALUE 0.       
      *                                                                 01560014
       01 WS-MISC.                                                      
          05 PROGRAM-NAME               PIC X(08)  VALUE 'CSR04893'.    
          05 CSR02412                   PIC X(08)  VALUE 'CSR02412'.    
          05 WS-SQLSTATE                PIC X(05)  VALUE SPACES.        
          05 WS-OVSH-COUNT              PIC S9(04) COMP  VALUE +0.      
          05 WS-SUB                     PIC S9(04) COMP  VALUE +0.      
          05 WS-OVSH-SOLTN-FL           PIC X(01)  VALUE SPACES.        
          05 WS-OVSH-TRAN-TYPE          PIC X(01)  VALUE SPACES.        
          05 WS-OVSH-TYPE-CD            PIC X(02)  VALUE SPACES.        
          05 WS-OVSH-GL-ACCT-NO         PIC X(07)  VALUE SPACES.        
          05 WS-OVSH-CURR-TYPE          PIC X(01)  VALUE SPACES.        
COB305    05 WS-OVSH-AMOUNT        PIC S9(09)V99 COMP-3 VALUE 0.           
          05 WS-COMMENTS                PIC X(210) VALUE SPACES.        
          05 WS-INPUT-PARMS.                                            
             10 WS-APPL-ID              PIC X(10).                      
             10 WS-USER-ID              PIC X(07).                      
             10 WS-CASH-COMPANY-NO      PIC X(02).                      
             10 WS-CASH-LOCAL-OFFICE    PIC X(03).                      
             10 WS-DATE-CASH-REPORT     PIC X(10).                      
             10 WS-CASH-DRAWER-ID       PIC S9(04) COMP  VALUE +0.      
             10 WS-CSR-PC-ID            PIC X(04).                      
             10 WS-TRAN-COMMENT-LEN     PIC S9(04) COMP  VALUE +0.      
             10 WS-TRAN-COMMENT-TXT     PIC X(210).                     
             10 WS-OVRSHRT-1            PIC X(23).                      
             10 WS-OVRSHRT-2            PIC X(23).                      
             10 WS-OVRSHRT-3            PIC X(23).                      
             10 WS-OVRSHRT-4            PIC X(23).                      
             10 WS-OVRSHRT-5            PIC X(23).                      
             10 WS-OVSH-OFFSETS.                                        
                15 WS-OVSH-OFFSET-01    PIC X(50).                      
                15 WS-OVSH-OFFSET-02    PIC X(50).                      
                15 WS-OVSH-OFFSET-03    PIC X(50).                      
                15 WS-OVSH-OFFSET-04    PIC X(50).                      
                15 WS-OVSH-OFFSET-05    PIC X(50).                      
                15 WS-OVSH-OFFSET-06    PIC X(50).                      
                15 WS-OVSH-OFFSET-07    PIC X(50).                      
                15 WS-OVSH-OFFSET-08    PIC X(50).                      
                15 WS-OVSH-OFFSET-09    PIC X(50).                      
                15 WS-OVSH-OFFSET-10    PIC X(50).                      
                15 WS-OVSH-OFFSET-11    PIC X(50).                      
                15 WS-OVSH-OFFSET-12    PIC X(50).                      
                15 WS-OVSH-OFFSET-13    PIC X(50).                      
                15 WS-OVSH-OFFSET-14    PIC X(50).                      
                15 WS-OVSH-OFFSET-15    PIC X(50).                      
                15 WS-OVSH-OFFSET-16    PIC X(50).                      
                15 WS-OVSH-OFFSET-17    PIC X(50).                      
                15 WS-OVSH-OFFSET-18    PIC X(50).                      
                15 WS-OVSH-OFFSET-19    PIC X(50).                      
                15 WS-OVSH-OFFSET-20    PIC X(50).                      
                15 WS-OVSH-OFFSET-21    PIC X(50).                      
                15 WS-OVSH-OFFSET-22    PIC X(50).                      
                15 WS-OVSH-OFFSET-23    PIC X(50).                      
                15 WS-OVSH-OFFSET-24    PIC X(50).                      
                15 WS-OVSH-OFFSET-25    PIC X(50).                      
            10  WS-OVSH-OFFSET-ARRAY REDEFINES WS-OVSH-OFFSETS.         
                15 WS-OVSH-OFFSET-DTLS  OCCURS 25 TIMES.                
                   20 WS-OFFSET-COMPANY PIC X(02).                      
                   20 WS-OFFSET-LOC-OFF PIC X(03).                      
                   20 WS-OFFSET-RPT-DT  PIC X(10).                      
                   20 WS-OFFSET-DRWR    PIC X(04).                      
                   20 WS-OFFSET-DRWR-ID REDEFINES WS-OFFSET-DRWR        
                                        PIC S9(04).                     
                   20 WS-OFFSET-OVSH    PIC X(04).                      
                   20 WS-OFFSET-OVSH-ID REDEFINES WS-OFFSET-OVSH        
                                        PIC S9(04).                     
                   20 FILLER            PIC X(27).                      
      *                                                                         
          05 WS-OVSH.                                                   
             10 WS-OVSH-DETAIL OCCURS 5 TIMES.                          
                15 WS-SOLTN-FL          PIC X(01).                      
                15 WS-TRAN-TYPE         PIC X(01).                      
                15 WS-TYPE-CD           PIC X(02).                      
                15 WS-GL-ACCT-NO        PIC X(07).                      
                15 WS-AMOUNT            PIC X(11).                      
                15 WS-AMOUNT-NUM REDEFINES WS-AMOUNT                    
                                        PIC S9(9)V99.                   
                15 WS-CURR-TYPE         PIC X(01).                      
      *                                                                         
          05 WS-REV-COMMENTS.                                           
             10 FILLER                  PIC X(10)  VALUE 'ORIG OFST:'.  
             10 WS-REV-COMPANY          PIC X(02)  VALUE SPACES.        
             10 FILLER                  PIC X(01)  VALUE ''.           
             10 WS-REV-LOC-OFF          PIC X(03)  VALUE SPACES.        
             10 FILLER                  PIC X(01)  VALUE ''.           
             10 WS-REV-RPT-DT           PIC X(10)  VALUE SPACES.        
             10 FILLER                  PIC X(01)  VALUE ''.           
             10 WS-REV-DRWR-ID          PIC X(04)  VALUE SPACES.        
             10 FILLER                  PIC X(01)  VALUE ''.           
             10 WS-REV-OVSH-ID          PIC X(04)  VALUE SPACES.        
             10 FILLER                  PIC X(01)  VALUE ''.           
      *                                                                 01830006
       01 SWITCHES.                                                     
          05 SEND-DONE-SW               PIC X(01)  VALUE 'Y'.           
             88 SEND-DONE-ERROR                    VALUE 'N'.           
             88 SEND-DONE-OK                       VALUE 'Y'.           
          05 WS-MORE-ROWS               PIC X(01)  VALUE 'Y'.           
             88 NO-MORE-ROWS                       VALUE 'N'.           
             88 MORE-ROWS                          VALUE 'Y'.           
      *                                                                 02130000
      ******************************************************************02130100
      * Declare Result set Locators for all sub-programs               *02979209
      ******************************************************************02979210
      *                                                                 02979220
      *01 LOC2412 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *                                                                 03050807
      ******************************************************************03050809
      * DB2 Includes                                                   *03050810
      ******************************************************************03050811
      *                                                                 03050812
      * SQLCA                                                           03050814
      *                                                                 03050815
           EXEC SQL                                                     03050816
                INCLUDE SQLCA                                           03050817
           END-EXEC.                                                    03050818
      *                                                                 00782400
      * CSS_OVERSHORT_DET - OD                                                  
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOVSHDT                                                  
           END-EXEC.                                                            
      *                                                                 03050815
      * CSS_OVERSHORT_HDR - OH                                                  
      *                                                                 03050815
           EXEC SQL                                                             
              INCLUDE TBOVSHHD                                                  
           END-EXEC.                                                            
      *                                                                 00782400
      ******************************************************************        
      * ABEND-FILE                                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
      *                                                                 03050829
      ******************************************************************03050830
      * WS-WARNING-DATA-ELEMENTS                                       *03050831
      ******************************************************************03050832
      *                                                                 03050833
           COPY CWS00303.                                               03050836
      *                                                                 03050835
      ******************************************************************03050842
      * Declare Result set Cursors                                     *03050843
      ******************************************************************03050844
      *                                                                 03050850
           EXEC SQL                                                     
                DECLARE C1 CURSOR  FOR                       
                SELECT                                                  
                     :S-APPL-RETURN-CODE    AS APPL_RETURN_CODE         
                    ,:S-RETURN-CODE         AS RETURN_CODE              
                FROM                                                    
                     CIS.SYSDUMMY1                                   
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*              :S-APPL-RETURN-CODE    AS APPL_RETURN_CODE                 
MFA-TR*             ,:S-RETURN-CODE         AS RETURN_CODE                      
MFA-TR*         FROM                                                            
MFA-TR*              SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2412 CURSOR
MSQ001          FOR CALL CSR02412( :WS-OVSH-TRAN-TYPE
                  , :WS-OVSH-GL-ACCT-NO
                  , :WS-OVSH-AMOUNT
                  , :WS-OVSH-CURR-TYPE
                  , :WS-TRAN-COMMENT-LEN
                  , :WS-TRAN-COMMENT-TXT
                  , :WS-USER-ID
                  , 'PANEL175'
                  , :WS-DATE-CASH-REPORT
                  , :WS-CASH-COMPANY-NO
                  , :WS-CASH-LOCAL-OFFICE
                  , :WS-CASH-DRAWER-ID
                  , :WS-CSR-PC-ID
                  , :WS-OVSH-TYPE-CD
                  , :WS-OVSH-SOLTN-FL
                  , :WS-OVSH-OFFSET-01
                  , :WS-OVSH-OFFSET-02
                  , :WS-OVSH-OFFSET-03
                  , :WS-OVSH-OFFSET-04
                  , :WS-OVSH-OFFSET-05
                  , :WS-OVSH-OFFSET-06
                  , :WS-OVSH-OFFSET-07
                  , :WS-OVSH-OFFSET-08
                  , :WS-OVSH-OFFSET-09
                  , :WS-OVSH-OFFSET-10
                  , :WS-OVSH-OFFSET-11
                  , :WS-OVSH-OFFSET-12
                  , :WS-OVSH-OFFSET-13
                  , :WS-OVSH-OFFSET-14
                  , :WS-OVSH-OFFSET-15
                  , :WS-OVSH-OFFSET-16
                  , :WS-OVSH-OFFSET-17
                  , :WS-OVSH-OFFSET-18
                  , :WS-OVSH-OFFSET-19
                  , :WS-OVSH-OFFSET-20
                  , :WS-OVSH-OFFSET-21
                  , :WS-OVSH-OFFSET-22
                  , :WS-OVSH-OFFSET-23
                  , :WS-OVSH-OFFSET-24
                  , :WS-OVSH-OFFSET-25
                  )
MSQ001        END-EXEC.
                                                    
      *                                                                 03062000
      ******************************************************************03068508
      * Linkage Section                                                *03068509
      ******************************************************************03068510
      *                                                                 03068520
       LINKAGE SECTION.                                                 
       01  PARM-APPL-ID                 PIC X(10).                      
       01  PARM-CALL-TYPE               PIC X(01).                      
       01  PARM-USER-ID                 PIC X(07).                      
       01  PARM-CASH-COMPANY-NO         PIC X(02).                      
       01  PARM-CASH-LOCAL-OFFICE       PIC X(03).                      
       01  PARM-DATE-CASH-REPORT        PIC X(10).                      
       01  PARM-CASH-DRAWER-ID          PIC S9(04)   COMP.              
       01  PARM-CSR-PC-ID               PIC X(04).                      
       01  PARM-TRAN-COMMENT-LEN        PIC S9(04)   COMP.              
       01  PARM-TRAN-COMMENT-TXT        PIC X(210).                     
       01  PARM-OVRSHRT-1               PIC X(23).                      
       01  PARM-OVRSHRT-2               PIC X(23).                      
       01  PARM-OVRSHRT-3               PIC X(23).                      
       01  PARM-OVRSHRT-4               PIC X(23).                      
       01  PARM-OVRSHRT-5               PIC X(23).                      
       01  PARM-OVSH-OFFSET-01          PIC X(50).                      
       01  PARM-OVSH-OFFSET-02          PIC X(50).                      
       01  PARM-OVSH-OFFSET-03          PIC X(50).                      
       01  PARM-OVSH-OFFSET-04          PIC X(50).                      
       01  PARM-OVSH-OFFSET-05          PIC X(50).                      
       01  PARM-OVSH-OFFSET-06          PIC X(50).                      
       01  PARM-OVSH-OFFSET-07          PIC X(50).                      
       01  PARM-OVSH-OFFSET-08          PIC X(50).                      
       01  PARM-OVSH-OFFSET-09          PIC X(50).                      
       01  PARM-OVSH-OFFSET-10          PIC X(50).                      
       01  PARM-OVSH-OFFSET-11          PIC X(50).                      
       01  PARM-OVSH-OFFSET-12          PIC X(50).                      
       01  PARM-OVSH-OFFSET-13          PIC X(50).                      
       01  PARM-OVSH-OFFSET-14          PIC X(50).                      
       01  PARM-OVSH-OFFSET-15          PIC X(50).                      
       01  PARM-OVSH-OFFSET-16          PIC X(50).                      
       01  PARM-OVSH-OFFSET-17          PIC X(50).                      
       01  PARM-OVSH-OFFSET-18          PIC X(50).                      
       01  PARM-OVSH-OFFSET-19          PIC X(50).                      
       01  PARM-OVSH-OFFSET-20          PIC X(50).                      
       01  PARM-OVSH-OFFSET-21          PIC X(50).                      
       01  PARM-OVSH-OFFSET-22          PIC X(50).                      
       01  PARM-OVSH-OFFSET-23          PIC X(50).                      
       01  PARM-OVSH-OFFSET-24          PIC X(50).                      
       01  PARM-OVSH-OFFSET-25          PIC X(50).                      
      *                                                                 03069008
      ******************************************************************03069009
      * Procedure Division                                             *03069010
      ******************************************************************03069020
      *                                                                 03069030
       PROCEDURE DIVISION USING PARM-APPL-ID                            
                                PARM-CALL-TYPE                          
                                PARM-USER-ID                            
                                PARM-CASH-COMPANY-NO                    
                                PARM-CASH-LOCAL-OFFICE                  
                                PARM-DATE-CASH-REPORT                   
                                PARM-CASH-DRAWER-ID                     
                                PARM-CSR-PC-ID                          
                                PARM-TRAN-COMMENT-LEN                   
                                PARM-TRAN-COMMENT-TXT                   
                                PARM-OVRSHRT-1                          
                                PARM-OVRSHRT-2                          
                                PARM-OVRSHRT-3                          
                                PARM-OVRSHRT-4                          
                                PARM-OVRSHRT-5                          
                                PARM-OVSH-OFFSET-01                     
                                PARM-OVSH-OFFSET-02                     
                                PARM-OVSH-OFFSET-03                     
                                PARM-OVSH-OFFSET-04                     
                                PARM-OVSH-OFFSET-05                     
                                PARM-OVSH-OFFSET-06                     
                                PARM-OVSH-OFFSET-07                     
                                PARM-OVSH-OFFSET-08                     
                                PARM-OVSH-OFFSET-09                     
                                PARM-OVSH-OFFSET-10                     
                                PARM-OVSH-OFFSET-11                     
                                PARM-OVSH-OFFSET-12                     
                                PARM-OVSH-OFFSET-13                     
                                PARM-OVSH-OFFSET-14                     
                                PARM-OVSH-OFFSET-15                     
                                PARM-OVSH-OFFSET-16                     
                                PARM-OVSH-OFFSET-17                     
                                PARM-OVSH-OFFSET-18                     
                                PARM-OVSH-OFFSET-19                     
                                PARM-OVSH-OFFSET-20                     
                                PARM-OVSH-OFFSET-21                     
                                PARM-OVSH-OFFSET-22                     
                                PARM-OVSH-OFFSET-23                     
                                PARM-OVSH-OFFSET-24                     
                                PARM-OVSH-OFFSET-25.                    
      *                                                                 03071007
       0000-MAINLINE.                                                   
      *                                                                 03150100
           MOVE '0000'                 TO ACTIVE-PARAGRAPH              
      *                                                                 13991024
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
      *                                                                 03190100
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
      *                                                                 03210000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03240000
      ******************************************************************03250000
      * 0100-INITIALIZE                                                *03260000
      ******************************************************************03330000
      *                                                                 03340008
       0100-INITIALIZE.                                                 
      *                                                                 03360008
           MOVE '0100'                 TO ACTIVE-PARAGRAPH              
      *                                                                 13991024
           INITIALIZE S-RETURN-CODE                                     
                      S-APPL-RETURN-CODE.                               
      *                                                                 03578037
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03646559
      ******************************************************************03646659
      * 1000-PROCESS-INPUT                                             *03646759
      ******************************************************************03660000
      *                                                                 03670000
       1000-PROCESS-INPUT.                                              
      *                                                                 03690000
           MOVE '1000'                 TO ACTIVE-PARAGRAPH              
      *                                                                 13991024
           MOVE PARM-APPL-ID           TO WS-APPL-ID                    
           MOVE PARM-USER-ID           TO WS-USER-ID                    
           MOVE PARM-CASH-COMPANY-NO   TO WS-CASH-COMPANY-NO            
           MOVE PARM-CASH-LOCAL-OFFICE TO WS-CASH-LOCAL-OFFICE          
           MOVE PARM-DATE-CASH-REPORT  TO WS-DATE-CASH-REPORT           
           MOVE PARM-CASH-DRAWER-ID    TO WS-CASH-DRAWER-ID             
           MOVE PARM-CSR-PC-ID         TO WS-CSR-PC-ID                  
           MOVE PARM-TRAN-COMMENT-LEN  TO WS-TRAN-COMMENT-LEN           
           MOVE PARM-TRAN-COMMENT-TXT  TO WS-TRAN-COMMENT-TXT           
           MOVE PARM-OVRSHRT-1         TO WS-OVRSHRT-1                  
           MOVE PARM-OVRSHRT-2         TO WS-OVRSHRT-2                  
           MOVE PARM-OVRSHRT-3         TO WS-OVRSHRT-3                  
           MOVE PARM-OVRSHRT-4         TO WS-OVRSHRT-4                  
           MOVE PARM-OVRSHRT-5         TO WS-OVRSHRT-5                  
           MOVE PARM-OVSH-OFFSET-01    TO WS-OVSH-OFFSET-01             
           MOVE PARM-OVSH-OFFSET-02    TO WS-OVSH-OFFSET-02             
           MOVE PARM-OVSH-OFFSET-03    TO WS-OVSH-OFFSET-03             
           MOVE PARM-OVSH-OFFSET-04    TO WS-OVSH-OFFSET-04             
           MOVE PARM-OVSH-OFFSET-05    TO WS-OVSH-OFFSET-05             
           MOVE PARM-OVSH-OFFSET-06    TO WS-OVSH-OFFSET-06             
           MOVE PARM-OVSH-OFFSET-07    TO WS-OVSH-OFFSET-07             
           MOVE PARM-OVSH-OFFSET-08    TO WS-OVSH-OFFSET-08             
           MOVE PARM-OVSH-OFFSET-09    TO WS-OVSH-OFFSET-09             
           MOVE PARM-OVSH-OFFSET-10    TO WS-OVSH-OFFSET-10             
           MOVE PARM-OVSH-OFFSET-11    TO WS-OVSH-OFFSET-11             
           MOVE PARM-OVSH-OFFSET-12    TO WS-OVSH-OFFSET-12             
           MOVE PARM-OVSH-OFFSET-13    TO WS-OVSH-OFFSET-13             
           MOVE PARM-OVSH-OFFSET-14    TO WS-OVSH-OFFSET-14             
           MOVE PARM-OVSH-OFFSET-15    TO WS-OVSH-OFFSET-15             
           MOVE PARM-OVSH-OFFSET-16    TO WS-OVSH-OFFSET-16             
           MOVE PARM-OVSH-OFFSET-17    TO WS-OVSH-OFFSET-17             
           MOVE PARM-OVSH-OFFSET-18    TO WS-OVSH-OFFSET-18             
           MOVE PARM-OVSH-OFFSET-19    TO WS-OVSH-OFFSET-19             
           MOVE PARM-OVSH-OFFSET-20    TO WS-OVSH-OFFSET-20             
           MOVE PARM-OVSH-OFFSET-21    TO WS-OVSH-OFFSET-21             
           MOVE PARM-OVSH-OFFSET-22    TO WS-OVSH-OFFSET-22             
           MOVE PARM-OVSH-OFFSET-23    TO WS-OVSH-OFFSET-23             
           MOVE PARM-OVSH-OFFSET-24    TO WS-OVSH-OFFSET-24             
           MOVE PARM-OVSH-OFFSET-25    TO WS-OVSH-OFFSET-25             
      *                                                                 03690000
           IF WS-OVRSHRT-1 NOT EQUAL SPACES                             
              MOVE WS-OVRSHRT-1        TO WS-OVSH-DETAIL(1)             
              ADD  1                   TO WS-OVSH-COUNT                 
           END-IF                                                       
      *                                                                 03690000
           IF WS-OVRSHRT-2 NOT EQUAL SPACES                             
              MOVE WS-OVRSHRT-2        TO WS-OVSH-DETAIL(2)             
              ADD  1                   TO WS-OVSH-COUNT                 
           END-IF                                                       
      *                                                                 03690000
           IF WS-OVRSHRT-3 NOT EQUAL SPACES                             
              MOVE WS-OVRSHRT-3        TO WS-OVSH-DETAIL(3)             
              ADD  1                   TO WS-OVSH-COUNT                 
           END-IF                                                       
      *                                                                 03690000
           IF WS-OVRSHRT-4 NOT EQUAL SPACES                             
              MOVE PARM-OVRSHRT-4      TO WS-OVSH-DETAIL(4)             
              ADD  1                   TO WS-OVSH-COUNT                 
           END-IF                                                       
      *                                                                 03690000
           IF WS-OVRSHRT-5 NOT EQUAL SPACES                             
              MOVE WS-OVRSHRT-5        TO WS-OVSH-DETAIL(5)             
              ADD  1                   TO WS-OVSH-COUNT                 
           END-IF.                                                      
      *                                                                 03720000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04180000
      ******************************************************************04190000
      * 2000-PROCESS-OUTPUT.                                           *04200000
      ******************************************************************04310000
      *                                                                 04320000
       2000-PROCESS-OUTPUT.                                             
      *                                                                 04340000
           MOVE '2000'                           TO ACTIVE-PARAGRAPH    
      *                                                                 13991024
           INITIALIZE S-RETURN-CODE                                     
                      S-APPL-RETURN-CODE.                               
      *                                                                 07732011
           EVALUATE PARM-CALL-TYPE                                      
               WHEN 'O'                                                 
                    PERFORM 2100-OVSH-OFFSET     THRU 2100-EXIT         
               WHEN 'R'                                                 
                    PERFORM 2200-OFFSET-REVERSAL THRU 2200-EXIT         
                    MOVE WS-REV-COMMENTS         TO WS-COMMENTS(1:38)   
                    MOVE WS-TRAN-COMMENT-TXT     TO WS-COMMENTS(39:172) 
                    ADD 38                       TO WS-TRAN-COMMENT-LEN 
                    MOVE WS-COMMENTS             TO WS-TRAN-COMMENT-TXT 
                    PERFORM 2100-OVSH-OFFSET     THRU 2100-EXIT         
           END-EVALUATE.                                                
      *                                                                 07732011
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07660003
      ******************************************************************04190000
      * 2100-OVSH-OFFSET.                                              *04200000
      ******************************************************************04310000
      *                                                                 04320000
       2100-OVSH-OFFSET.                                                
      *                                                                 04340000
           MOVE '2100'                    TO ACTIVE-PARAGRAPH           
      *                                                                 13991024
           PERFORM VARYING WS-SUB FROM 1 BY 1                           
             UNTIL WS-SUB > WS-OVSH-COUNT OR S-APPL-RETURN-CODE > SPACES
              MOVE WS-SOLTN-FL(WS-SUB)    TO WS-OVSH-SOLTN-FL           
              MOVE WS-TRAN-TYPE(WS-SUB)   TO WS-OVSH-TRAN-TYPE          
              MOVE WS-TYPE-CD(WS-SUB)     TO WS-OVSH-TYPE-CD            
              MOVE WS-GL-ACCT-NO(WS-SUB)  TO WS-OVSH-GL-ACCT-NO         
              MOVE WS-AMOUNT-NUM(WS-SUB)  TO WS-OVSH-AMOUNT             
              MOVE WS-CURR-TYPE(WS-SUB)   TO WS-OVSH-CURR-TYPE          
              IF WS-SUB > 1                                             
                 MOVE SPACES              TO WS-OVSH-OFFSETS            
              END-IF                                                    
              PERFORM 5000-CALL-CSR02412  THRU 5000-EXIT                
           END-PERFORM.                                                 
      *                                                                 04476003
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07660003
      ******************************************************************04190000
      * 2200-OFFSET-REVERSAL.                                          *04200000
      ******************************************************************04310000
      *                                                                 04320000
       2200-OFFSET-REVERSAL.                                            
      *                                                                 04340000
           MOVE '2200'                      TO ACTIVE-PARAGRAPH         
      *                                                                 13991024
           PERFORM VARYING WS-SUB FROM 1 BY 1                           
             UNTIL WS-SUB > 25 OR WS-OFFSET-COMPANY(WS-SUB) = SPACES    
      * GET OFFSET OVR/SHRT                                                     
             MOVE WS-OFFSET-COMPANY(WS-SUB) TO OD-OFST-COMPANY-NO       
             MOVE WS-OFFSET-LOC-OFF(WS-SUB) TO OD-OFST-LOC-OFCE         
             MOVE WS-OFFSET-RPT-DT(WS-SUB)  TO OD-OFST-CASH-REPT-DT     
             MOVE WS-OFFSET-DRWR-ID(WS-SUB) TO OD-OFST-CASH-DRWR-ID     
             MOVE WS-OFFSET-OVSH-ID(WS-SUB) TO OD-OFST-OVERSHORT-ID     
             PERFORM 7000-GET-OVERSHORT-DET THRU 7000-EXIT              
      * DELETE OFFSET OVR/SHRT                                                  
             PERFORM 8100-DEL-OVERSHORT-DET THRU 8100-EXIT              
             MOVE OD-CASH-COMPANY-NO        TO OH-CASH-COMPANY-NO       
             MOVE OD-CASH-LOCAL-OFFICE      TO OH-CASH-LOCAL-OFFICE     
             MOVE OD-DATE-CASH-REPORT       TO OH-DATE-CASH-REPORT      
             MOVE OD-CASH-DRAWER-ID         TO OH-CASH-DRAWER-ID        
             MOVE OD-OVERSHORT-ID           TO OH-OVERSHORT-ID          
             PERFORM 8200-DEL-OVERSHORT-HDR THRU 8200-EXIT              
      * UPD/DEL OFFSET DTLS ON ORIGINAL OVR/SHRT                                
             MOVE WS-OFFSET-COMPANY(WS-SUB) TO OH-CASH-COMPANY-NO       
                                               WS-REV-COMPANY           
             MOVE WS-OFFSET-LOC-OFF(WS-SUB) TO OH-CASH-LOCAL-OFFICE     
                                               WS-REV-LOC-OFF           
             MOVE WS-OFFSET-RPT-DT(WS-SUB)  TO OH-DATE-CASH-REPORT      
                                               WS-REV-RPT-DT            
             MOVE WS-OFFSET-DRWR-ID(WS-SUB) TO OH-CASH-DRAWER-ID        
                                               WS-REV-DRWR-ID           
             MOVE WS-OFFSET-OVSH-ID(WS-SUB) TO OH-OVERSHORT-ID          
                                               WS-REV-OVSH-ID           
             MOVE ZEROS                     TO OH-OFST-OVERSHORT-AMT    
             MOVE SPACES                    TO OH-OFST-DR-CR            
             PERFORM 8000-UPD-OVERSHORT-HDR THRU 8000-EXIT              
           END-PERFORM.                                                 
      *                                                                 07732011
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07660003
      ***************************************************************** 07670003
      * 5000-CALL-CSR02412                                            * 07680011
      ***************************************************************** 07690003
      *                                                                 07691006
       5000-CALL-CSR02412.                                              
      *                                                                 07710003
           MOVE '5000'                    TO ACTIVE-PARAGRAPH           
      *                                                                 13991024
      *    EXEC SQL                                                     
      *       CALL CSR02412( :WS-OVSH-TRAN-TYPE                         
      *                     ,:WS-OVSH-GL-ACCT-NO                        
      *                     ,:WS-OVSH-AMOUNT                            
      *                     ,:WS-OVSH-CURR-TYPE                         
      *                     ,:WS-TRAN-COMMENT-LEN                       
      *                     ,:WS-TRAN-COMMENT-TXT                       
      *                     ,:WS-USER-ID                                
      *                     ,'PANEL175'                                 
      *                     ,:WS-DATE-CASH-REPORT                       
      *                     ,:WS-CASH-COMPANY-NO                        
      *                     ,:WS-CASH-LOCAL-OFFICE                      
      *                     ,:WS-CASH-DRAWER-ID                         
      *                     ,:WS-CSR-PC-ID                              
      *                     ,:WS-OVSH-TYPE-CD                           
      *                     ,:WS-OVSH-SOLTN-FL                          
      *                     ,:WS-OVSH-OFFSET-01                         
      *                     ,:WS-OVSH-OFFSET-02                         
      *                     ,:WS-OVSH-OFFSET-03                         
      *                     ,:WS-OVSH-OFFSET-04                         
      *                     ,:WS-OVSH-OFFSET-05                         
      *                     ,:WS-OVSH-OFFSET-06                         
      *                     ,:WS-OVSH-OFFSET-07                         
      *                     ,:WS-OVSH-OFFSET-08                         
      *                     ,:WS-OVSH-OFFSET-09                         
      *                     ,:WS-OVSH-OFFSET-10                         
      *                     ,:WS-OVSH-OFFSET-11                         
      *                     ,:WS-OVSH-OFFSET-12                         
      *                     ,:WS-OVSH-OFFSET-13                         
      *                     ,:WS-OVSH-OFFSET-14                         
      *                     ,:WS-OVSH-OFFSET-15                         
      *                     ,:WS-OVSH-OFFSET-16                         
      *                     ,:WS-OVSH-OFFSET-17                         
      *                     ,:WS-OVSH-OFFSET-18                         
      *                     ,:WS-OVSH-OFFSET-19                         
      *                     ,:WS-OVSH-OFFSET-20                         
      *                     ,:WS-OVSH-OFFSET-21                         
      *                     ,:WS-OVSH-OFFSET-22                         
      *                     ,:WS-OVSH-OFFSET-23                         
      *                     ,:WS-OVSH-OFFSET-24                         
      *                     ,:WS-OVSH-OFFSET-25                         
      *                    )                                            
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2412
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2412
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2412 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
      *                                                                 07754003
           IF SQLCODE = +466 THEN                                       
      *       EXEC SQL ASSOCIATE LOCATORS(:LOC2412) WITH PROCEDURE      
      *         CSR02412                                                
      *       END-EXEC                                                  
      *                                                                 07758106
      *       EXEC SQL                                                  
      *          ALLOCATE RESULT_SET_CSR_2412 CURSOR FOR RESULT SET     
      *          :LOC2412                                               
      *       END-EXEC                                                  
      *                                                                 07759406
              EXEC SQL                                                  
                 FETCH RESULT_SET_CSR_2412 INTO                         
                        :S-RETURN-CODE                                  
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07761806
              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
      *                                                                 07762059
              EVALUATE WS-ACTIVE-RETURN-CODE                            
                  WHEN SUCCESSFUL-CALL                                  
                       EVALUATE S-RETURN-CODE                           
                           WHEN 0                                       
                                CONTINUE                                
                           WHEN 5000                                    
                                MOVE '5000' TO S-APPL-RETURN-CODE       
                                MOVE +0     TO S-RETURN-CODE            
                           WHEN 1000                                    
                                MOVE '1000' TO S-APPL-RETURN-CODE       
                                MOVE +0     TO S-RETURN-CODE            
                           WHEN OTHER                                   
                                MOVE S-RETURN-CODE TO                   
                                                   WS-ACTIVE-RETURN-CODE
                                MOVE PROGRAM-NAME  TO ABEND-PROGRAM     
                                MOVE 'FETCH'       TO ABEND-FUNCTION    
                                MOVE 'CSR02412'    TO TABLE-1           
                                PERFORM 9700-PROCESS-ABEND              
                                                   THRU 9700-EXIT       
                       END-EVALUATE                                     
                  WHEN NOT-FOUND                                        
                       MOVE 0             TO WS-ACTIVE-RETURN-CODE      
                  WHEN OTHER                                            
                       MOVE PROGRAM-NAME  TO ABEND-PROGRAM              
                       MOVE 'FETCH'       TO ABEND-FUNCTION             
                       MOVE 'CSR02412'    TO TABLE-1                    
                       PERFORM 9700-PROCESS-ABEND                       
                                          THRU  9700-EXIT               
              END-EVALUATE                                              
           ELSE                                                         
              MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE      
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE 'CALL'                 TO ABEND-FUNCTION             
              MOVE 'CSR02412'             TO TABLE-1                    
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                 07766803
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07766803
      ******************************************************************13990524
      * 7000-GET-OVERSHORT-HDR.                                        *13990624
      ******************************************************************13990724
      *                                                                 13990824
       7000-GET-OVERSHORT-DET.                                          
      *                                                                 13991024
           MOVE '7000'                    TO ACTIVE-PARAGRAPH           
      *                                                                 13991024
           EXEC SQL                                                     
             SELECT TOP(1) OD.CASH_COMPANY_NO,
              OD.CASH_LOCAL_OFFICE,
              OD.DATE_CASH_REPORT,
              OD.CASH_DRAWER_ID,
              OD.OVERSHORT_ID                                    
               INTO  :OD-CASH-COMPANY-NO                                
                    ,:OD-CASH-LOCAL-OFFICE                              
                    ,:OD-DATE-CASH-REPORT                               
                    ,:OD-CASH-DRAWER-ID                                 
                    ,:OD-OVERSHORT-ID                                   
               FROM CSS_OVERSHORT_DET OD WITH(READUNCOMMITTED)                  
              WHERE OD.OFST_COMPANY_NO   = :OD-OFST-COMPANY-NO          
                AND OD.OFST_LOC_OFCE     = :OD-OFST-LOC-OFCE            
                AND OD.OFST_CASH_REPT_DT = IIF(TRY_CONVERT(DATE, 
                                                  :OD-OFST-CASH-REPT-DT
              ) IS NULL OR (PATINDEX('%.%', :OD-OFST-CASH-REPT-DT
              ) <> 0) OR (LEN(:OD-OFST-CASH-REPT-DT
              ) <> 10), CIS.CHAR2DATE(:OD-OFST-CASH-REPT-DT
              ), CONVERT(DATE, :OD-OFST-CASH-REPT-DT) )        
                AND OD.OFST_CASH_DRWR_ID = :OD-OFST-CASH-DRWR-ID        
                AND OD.OFST_OVERSHORT_ID = :OD-OFST-OVERSHORT-ID        
                                                                 
                                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  OD.CASH_COMPANY_NO                                         
MFA-TR*             ,OD.CASH_LOCAL_OFFICE                                       
MFA-TR*             ,OD.DATE_CASH_REPORT                                        
MFA-TR*             ,OD.CASH_DRAWER_ID                                          
MFA-TR*             ,OD.OVERSHORT_ID                                            
MFA-TR*        INTO  :OD-CASH-COMPANY-NO                                        
MFA-TR*             ,:OD-CASH-LOCAL-OFFICE                                      
MFA-TR*             ,:OD-DATE-CASH-REPORT                                       
MFA-TR*             ,:OD-CASH-DRAWER-ID                                         
MFA-TR*             ,:OD-OVERSHORT-ID                                           
MFA-TR*        FROM CSS_OVERSHORT_DET OD                                        
MFA-TR*       WHERE OD.OFST_COMPANY_NO   = :OD-OFST-COMPANY-NO                  
MFA-TR*         AND OD.OFST_LOC_OFCE     = :OD-OFST-LOC-OFCE                    
MFA-TR*         AND OD.OFST_CASH_REPT_DT = :OD-OFST-CASH-REPT-DT                
MFA-TR*         AND OD.OFST_CASH_DRWR_ID = :OD-OFST-CASH-DRWR-ID                
MFA-TR*         AND OD.OFST_OVERSHORT_ID = :OD-OFST-OVERSHORT-ID                
MFA-TR*        WITH UR                                                          
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*     QUERYNO 7000                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_OVERSHORT_DET'   TO TABLE-1                    
               MOVE 'CASH_LOCAL_OFFICE'   TO TABLE-ELEMENT-1            
               MOVE 'DATE_CASH-REPORT'    TO TABLE-ELEMENT-2            
               MOVE 'CASH_DRAWER_ID'      TO TABLE-ELEMENT-3            
               MOVE 'OVERSHORT_ID'        TO TABLE-ELEMENT-4            
               MOVE OD-OFST-LOC-OFCE      TO HOSTVAR-ELEMENT-1          
               MOVE OD-OFST-CASH-REPT-DT  TO HOSTVAR-ELEMENT-2          
               MOVE OD-OFST-CASH-DRWR-ID  TO HOSTVAR-ELEMENT-3          
               MOVE OD-OFST-OVERSHORT-ID  TO HOSTVAR-ELEMENT-4          
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                 13991624
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07942004
      ******************************************************************13990524
      * 7100-GET-OVERSHORT-HDR.                                        *13990624
      ******************************************************************13990724
      *                                                                 13990824
       7100-GET-OVERSHORT-HDR.                                          
      *                                                                 13991024
           MOVE '7100'                    TO ACTIVE-PARAGRAPH           
      *                                                                 13991024
           EXEC SQL                                                     
             SELECT  OH.TRAN_COMMENT                                    
                    ,OH.OVERSHORT_AMT                                   
                    ,OH.OVERSHORT_DR_CR                                 
               INTO  :OH-TRAN-COMMENT                                   
                    ,:OH-OVERSHORT-AMT                                  
                    ,:OH-OVERSHORT-DR-CR                                
               FROM CSS_OVERSHORT_HDR OH WITH(READUNCOMMITTED)                  
              WHERE OH.CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO          
                AND OH.CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE        
                AND OH.DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )         
                AND OH.CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID           
                AND OH.OVERSHORT_ID      = :OH-OVERSHORT-ID             
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  OH.TRAN_COMMENT                                            
MFA-TR*             ,OH.OVERSHORT_AMT                                           
MFA-TR*             ,OH.OVERSHORT_DR_CR                                         
MFA-TR*        INTO  :OH-TRAN-COMMENT                                           
MFA-TR*             ,:OH-OVERSHORT-AMT                                          
MFA-TR*             ,:OH-OVERSHORT-DR-CR                                        
MFA-TR*        FROM CSS_OVERSHORT_HDR OH                                        
MFA-TR*       WHERE OH.CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO                  
MFA-TR*         AND OH.CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE                
MFA-TR*         AND OH.DATE_CASH_REPORT  = :OH-DATE-CASH-REPORT                 
MFA-TR*         AND OH.CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID                   
MFA-TR*         AND OH.OVERSHORT_ID      = :OH-OVERSHORT-ID                     
MFA-TR*     QUERYNO 7100                                                        
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_OVERSHORT_HDR'   TO TABLE-1                    
               MOVE 'CASH_LOCAL_OFFICE'   TO TABLE-ELEMENT-1            
               MOVE 'DATE_CASH-REPORT'    TO TABLE-ELEMENT-2            
               MOVE 'CASH_DRAWER_ID'      TO TABLE-ELEMENT-3            
               MOVE 'OVERSHORT_ID'        TO TABLE-ELEMENT-4            
               MOVE OH-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-1          
               MOVE OH-DATE-CASH-REPORT   TO HOSTVAR-ELEMENT-2          
               MOVE OH-CASH-DRAWER-ID     TO HOSTVAR-ELEMENT-3          
               MOVE OH-OVERSHORT-ID       TO HOSTVAR-ELEMENT-4          
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                 13991624
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07942004
      ******************************************************************13990524
      * 8000-UPD-OVERSHORT-HDR.                                        *13990624
      ******************************************************************13990724
      *                                                                 13990824
       8000-UPD-OVERSHORT-HDR.                                          
      *                                                                 13991024
           MOVE '8000'                    TO ACTIVE-PARAGRAPH           
      *                                                                 13991024
           EXEC SQL                                                     
                UPDATE OH                              
                SET  OH.OFST_OVERSHORT_AMT = :OH-OFST-OVERSHORT-AMT     
                    ,OH.OFST_DR_CR         = :OH-OFST-DR-CR             
                FROM CSS_OVERSHORT_HDR OH
               WHERE OH.CASH_COMPANY_NO    = :OH-CASH-COMPANY-NO        
                 AND OH.CASH_LOCAL_OFFICE  = :OH-CASH-LOCAL-OFFICE      
                 AND OH.DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )       
                 AND OH.CASH_DRAWER_ID     = :OH-CASH-DRAWER-ID         
                 AND OH.OVERSHORT_ID       = :OH-OVERSHORT-ID           
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_OVERSHORT_HDR OH                                     
MFA-TR*         SET  OH.OFST_OVERSHORT_AMT = :OH-OFST-OVERSHORT-AMT             
MFA-TR*             ,OH.OFST_DR_CR         = :OH-OFST-DR-CR                     
MFA-TR*        WHERE OH.CASH_COMPANY_NO    = :OH-CASH-COMPANY-NO                
MFA-TR*          AND OH.CASH_LOCAL_OFFICE  = :OH-CASH-LOCAL-OFFICE              
MFA-TR*          AND OH.DATE_CASH_REPORT   = :OH-DATE-CASH-REPORT               
MFA-TR*          AND OH.CASH_DRAWER_ID     = :OH-CASH-DRAWER-ID                 
MFA-TR*          AND OH.OVERSHORT_ID       = :OH-OVERSHORT-ID                   
MFA-TR*      QUERYNO 8000                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE              
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE 'CSS_OVERSHORT_HDR'   TO TABLE-1                    
               MOVE 'CASH_LOCAL_OFFICE'   TO TABLE-ELEMENT-1            
               MOVE 'DATE_CASH-REPORT'    TO TABLE-ELEMENT-2            
               MOVE 'CASH_DRAWER_ID'      TO TABLE-ELEMENT-3            
               MOVE 'OVERSHORT_ID'        TO TABLE-ELEMENT-4            
               MOVE OH-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-1          
               MOVE OH-DATE-CASH-REPORT   TO HOSTVAR-ELEMENT-2          
               MOVE OH-CASH-DRAWER-ID     TO HOSTVAR-ELEMENT-3          
               MOVE OH-OVERSHORT-ID       TO HOSTVAR-ELEMENT-4          
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                 13991624
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07942004
      ******************************************************************13990524
      * 8100-DEL-OVERSHORT-DET.                                        *13990624
      ******************************************************************13990724
      *                                                                 13990824
       8100-DEL-OVERSHORT-DET.                                          
      *                                                                 13991024
           MOVE '8100'                    TO ACTIVE-PARAGRAPH           
      *                                                                 13991024
           EXEC SQL                                                     
             DELETE OD                                 
             FROM CSS_OVERSHORT_DET OD
              WHERE OD.CASH_COMPANY_NO   = :OD-CASH-COMPANY-NO          
                AND OD.CASH_LOCAL_OFFICE = :OD-CASH-LOCAL-OFFICE        
                AND OD.DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :OD-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OD-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OD-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OD-DATE-CASH-REPORT
              ), CONVERT(DATE, :OD-DATE-CASH-REPORT) )         
                AND OD.CASH_DRAWER_ID    = :OD-CASH-DRAWER-ID           
                AND OD.OVERSHORT_ID      = :OD-OVERSHORT-ID             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DELETE CSS_OVERSHORT_DET OD                                        
MFA-TR*       WHERE OD.CASH_COMPANY_NO   = :OD-CASH-COMPANY-NO                  
MFA-TR*         AND OD.CASH_LOCAL_OFFICE = :OD-CASH-LOCAL-OFFICE                
MFA-TR*         AND OD.DATE_CASH_REPORT  = :OD-DATE-CASH-REPORT                 
MFA-TR*         AND OD.CASH_DRAWER_ID    = :OD-CASH-DRAWER-ID                   
MFA-TR*         AND OD.OVERSHORT_ID      = :OD-OVERSHORT-ID                     
MFA-TR*     QUERYNO 8100                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE              
               MOVE 'DELETE'              TO ABEND-FUNCTION             
               MOVE 'CSS_OVERSHORT_DET'   TO TABLE-1                    
               MOVE 'CASH_LOCAL_OFFICE'   TO TABLE-ELEMENT-1            
               MOVE 'DATE_CASH-REPORT'    TO TABLE-ELEMENT-2            
               MOVE 'CASH_DRAWER_ID'      TO TABLE-ELEMENT-3            
               MOVE 'OVERSHORT_ID'        TO TABLE-ELEMENT-4            
               MOVE OD-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-1          
               MOVE OD-DATE-CASH-REPORT   TO HOSTVAR-ELEMENT-2          
               MOVE OD-CASH-DRAWER-ID     TO HOSTVAR-ELEMENT-3          
               MOVE OD-OVERSHORT-ID       TO HOSTVAR-ELEMENT-4          
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                 13991624
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07942004
      ******************************************************************13990524
      * 8200-DEL-OVERSHORT-HDR.                                        *13990624
      ******************************************************************13990724
      *                                                                 13990824
       8200-DEL-OVERSHORT-HDR.                                          
      *                                                                 13991024
           MOVE '8200'                    TO ACTIVE-PARAGRAPH           
      *                                                                 13991024
           EXEC SQL                                                     
             DELETE OH                                 
             FROM CSS_OVERSHORT_HDR OH
              WHERE OH.CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO          
                AND OH.CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE        
                AND OH.DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )         
                AND OH.CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID           
                AND OH.OVERSHORT_ID      = :OH-OVERSHORT-ID             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DELETE CSS_OVERSHORT_HDR OH                                        
MFA-TR*       WHERE OH.CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO                  
MFA-TR*         AND OH.CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE                
MFA-TR*         AND OH.DATE_CASH_REPORT  = :OH-DATE-CASH-REPORT                 
MFA-TR*         AND OH.CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID                   
MFA-TR*         AND OH.OVERSHORT_ID      = :OH-OVERSHORT-ID                     
MFA-TR*     QUERYNO 8200                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE              
               MOVE 'DELETE'              TO ABEND-FUNCTION             
               MOVE 'CSS_OVERSHORT_DET'   TO TABLE-1                    
               MOVE 'CASH_LOCAL_OFFICE'   TO TABLE-ELEMENT-1            
               MOVE 'DATE_CASH-REPORT'    TO TABLE-ELEMENT-2            
               MOVE 'CASH_DRAWER_ID'      TO TABLE-ELEMENT-3            
               MOVE 'OVERSHORT_ID'        TO TABLE-ELEMENT-4            
               MOVE OH-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-1          
               MOVE OH-DATE-CASH-REPORT   TO HOSTVAR-ELEMENT-2          
               MOVE OH-CASH-DRAWER-ID     TO HOSTVAR-ELEMENT-3          
               MOVE OH-OVERSHORT-ID       TO HOSTVAR-ELEMENT-4          
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                 13991624
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14009227
      ******************************************************************13990524
      * 8900-SEND-DONE.                                                *13990624
      ******************************************************************13990724
      *                                                                 13990824
       8900-SEND-DONE.                                                  
      *                                                                 13991024
           EXEC SQL                                                     
                OPEN C1                                                 
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                 13991624
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14009227
      ******************************************************************14009327
      * 9000-SEND-ERROR-RESULT                                         *14009427
      ******************************************************************14009527
      *                                                                 14009528
       9000-SEND-ERROR-RESULT.                                          
      *                                                                 14009727
           MOVE 'N'                   TO SEND-DONE-SW.                  
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
      *                                                                 14010932
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
      *                                                                 14011337
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14012232
      ******************************************************************14012747
      * 9700-PROCESS-ABEND                                             *14012847
      ******************************************************************14013447
      *                                                                 14013547
       9700-PROCESS-ABEND.                                              
      *                                                                 14013747
           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT.               
           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.               
      *                                                                 14014047
       9700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************14100025
      * 9999-END-PROGRAM.                                      *        14110025
      ******************************************************************14120025
      *                                                                 14130025
       9999-END-PROGRAM.                                                
      *                                                                 14150025
           PERFORM 8900-SEND-DONE THRU 8900-EXIT                        
           
MSQ016        GOBACK.                                                    
      *                                                                 14300025
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                *14330025
