       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04892.                                      
COB303 DATE-WRITTEN.     OCT 30, 2015.                                  
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04892              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04892:                                                 --         
      *--                                                            --         
      *--  WEB MOD:RETRIEVE CIG CUSTOMER USAGE HISTORY SUMMARY DATA  --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *-- PARAMETERS                                                 --         
      *--                                                            --         
      *--  INPUT                                                     --         
      *--    APPL_PROGRAM_ID     CHAR(03)                            --         
      *--    ACCOUNT_NO          CHAR(13)                            --         
      *--                                                            --         
      *--  OUTPUT                                                    --         
      *--    RESULT SET: CIG CUSTOMER USAGE HISTORY SUMMARY DATA     --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
P00836*--  10/30/2015    GD43988     INITIAL VERSION.                --         
P836F1*--  04/25/2016    SS45239     FIX BIND ERROR.                 --         
WEBFIX*--  03/09/2017    GD43988     A05745:FIX WEB SORT ORDER ISSUE.--         
      *--                                                            --         
      *----------------------------------------------------------------         
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04892'.
MSQ017     COPY MFASQLM.
      *                                                                         
      **********************************                                        
      **   DB2 INCLUDES               **                                        
      **********************************                                        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      **** CSS_ACCOUNT, AT                                                      
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      **** CSS_UTIL_ENVRNMT, UT                                                 
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_RATE_PLAN_DESC, RD                                               
           EXEC SQL                                                             
               INCLUDE TBRTDESC                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_PRTY_SVC_CAT, Z4                                                 
           EXEC SQL                                                             
               INCLUDE TBSVCCAT                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_BILLING_HDR, BI                                                  
           EXEC SQL                                                             
               INCLUDE TBBLLHDR                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_BILLING_DET, BG                                                  
           EXEC SQL                                                             
               INCLUDE TBBLLDET                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_VOL_DAILY, ND                                                    
           EXEC SQL                                                             
              INCLUDE TBVOLDLY                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_WQ_ITEMS, WQ                                                     
           EXEC SQL                                                             
               INCLUDE TBWQITS                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_WQ_CATEGORY, C3                                                  
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBWQCAT                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_BILL_CRED_DET, 1H                                                
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBCRBLDL                                                   
           END-EXEC.                                                            
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG              PIC X(08) VALUE 'CSRERLOG'.    
           05  PROGRAM-NAME              PIC X(08) VALUE 'CSR04892'.    
           05  WS-811                    PIC S9(9) VALUE -811 COMP.     
           05  WS-12                     PIC S9(4) VALUE  12.           
           05  WS-YES-NULL               PIC S9(4) VALUE -1.            
      *                                                                         
       01  WS-MISC.                                                     
           05 WS-REVENUE-MONTH           PIC 9(06) VALUE 0.             
           05 WS-REVENUE-MONTH-RED REDEFINES WS-REVENUE-MONTH.          
               10 WS-REVENUE-MONTH-YY    PIC 9(04).                     
               10 WS-REVENUE-MONTH-MM    PIC 9(02).                     
           05 WS-SHOW-LATEST-BILL-FL     PIC X(01) VALUE 'Y'.           
           05 WS-WEB-REV-MTH-LATEST      PIC S9(6)V COMP-3 VALUE 0.     
      *                                                                         
       01  PARM-FIELDS.                                                 
           05  PARM-L                    PIC S9(9) COMP.                
           05  PARM-APPL-PROGRAM-ID      PIC X(03).                     
           05  PARM-ACCOUNT-NO           PIC X(13).                     
           05  PARM-ACCOUNT-NO-NUM   REDEFINES                          
               PARM-ACCOUNT-NO           PIC 9(13).                     
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-SUMMARY          PIC S9(9) COMP VALUE 0.        
           05  CTR-ROWS-WORK             PIC S9(9) COMP VALUE 0.        
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
      *                                                                         
      **** GTT TABLE LAYOUT FOR CIG USAGE HISOTRY SUMMARY                       
      *                                                                         
           05 GTT-RETURN-FIELDS-SUMMARY.                                
              10 S-RETURN-CODE         PIC S9(9) COMP VALUE 0.          
              10 S-APPL-RETURN-CODE    PIC S9(9) COMP VALUE 0.          
              10 S-CODE-UTIL-TYPE      PIC X(01) VALUE SPACES.          
              10 S-IC-NO               PIC S9(4) COMP VALUE 0.          
              10 S-PRTY-SVC-CAT-CD     PIC X(02) VALUE SPACES.          
              10 S-RATE-PLAN-NO        PIC X(03) VALUE SPACES.          
              10 S-RATE-DESC           PIC X(50) VALUE SPACES.          
              10 S-DATE-BILLED         PIC X(10) VALUE SPACES.          
              10 S-REVENUE-MONTH       PIC S9(6)V   COMP-3 VALUE 0.     
              10 S-MT-MCF              PIC S9(9)V9  COMP-3 VALUE 0.     
              10 S-MT-MCF-PEAK         PIC S9(9)V9  COMP-3 VALUE 0.     
              10 S-MT-DEKATHERMS       PIC S9(9)V9  COMP-3 VALUE 0.     
              10 S-MT-DEKATHERMS-PEAK  PIC S9(9)V9  COMP-3 VALUE 0.     
              10 S-VB-MCF              PIC S9(9)V9  COMP-3 VALUE 0.     
              10 S-VB-MCF-PEAK         PIC S9(9)V9  COMP-3 VALUE 0.     
              10 S-VB-DEKATHERMS       PIC S9(9)V9  COMP-3 VALUE 0.     
              10 S-VB-DEKATHERMS-PEAK  PIC S9(9)V9  COMP-3 VALUE 0.     
              10 S-OTHER-UNITS         PIC S9(9)V9  COMP-3 VALUE 0.     
              10 S-OTHER-UNITS-PEAK    PIC S9(9)V9  COMP-3 VALUE 0.     
              10 S-AMT-BILL-ITEM       PIC S9(9)V99 COMP-3 VALUE 0.     
      *                                                                         
      **** GTT TABLE LAYOUT FOR CIG USAGE HISOTRY WORKING TABLE                 
      *                                                                         
           05 GTT-RETURN-FIELDS-WORK.                                   
              10 S-W-RETURN-CODE         PIC S9(9) COMP VALUE 0.        
              10 S-W-APPL-RETURN-CODE    PIC S9(9) COMP VALUE 0.        
              10 S-W-CODE-UTIL-TYPE      PIC X(01) VALUE SPACES.        
              10 S-W-IC-NO               PIC S9(4) COMP VALUE 0.        
              10 S-W-BILL-NO             PIC S9(9) COMP VALUE 0.        
              10 S-W-BILL-ITEM-TIMESTMP  PIC X(26) VALUE SPACES.        
              10 S-W-DATE-BILLED         PIC X(10) VALUE SPACES.        
              10 S-W-CODE-BILL-TYPE      PIC X(01) VALUE SPACES.        
              10 S-W-REVENUE-MONTH       PIC S9(6)V   COMP-3 VALUE 0.   
              10 S-W-AMT-BILL-ITEM       PIC S9(9)V99 COMP-3 VALUE 0.   
              10 S-W-PRTY-SVC-CAT-CD     PIC X(02) VALUE SPACES.        
              10 S-W-RATE-PLAN-NO        PIC X(03) VALUE SPACES.        
              10 S-W-RATE-DESC           PIC X(50) VALUE SPACES.        
              10 S-W-MT-MCF              PIC S9(9)V9  COMP-3 VALUE 0.   
              10 S-W-MT-MCF-PEAK         PIC S9(9)V9  COMP-3 VALUE 0.   
              10 S-W-MT-DEKATHERMS       PIC S9(9)V9  COMP-3 VALUE 0.   
              10 S-W-MT-DEKATHERMS-PEAK  PIC S9(9)V9  COMP-3 VALUE 0.   
              10 S-W-VB-MCF              PIC S9(9)V9  COMP-3 VALUE 0.   
              10 S-W-VB-MCF-PEAK         PIC S9(9)V9  COMP-3 VALUE 0.   
              10 S-W-VB-DEKATHERMS       PIC S9(9)V9  COMP-3 VALUE 0.   
              10 S-W-VB-DEKATHERMS-PEAK  PIC S9(9)V9  COMP-3 VALUE 0.   
              10 S-W-OTHER-UNITS         PIC S9(9)V9  COMP-3 VALUE 0.   
              10 S-W-OTHER-UNITS-PEAK    PIC S9(9)V9  COMP-3 VALUE 0.   
      *                                                                         
      ****************************************************************          
      **   ERROR PROCESSING VARIABLES                               **          
      ****************************************************************          
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                    PIC X(18) VALUE SPACES.     
           10  S-SQLCODE                    PIC S9(9) COMP VALUE 0.     
           10  S-SQLSTATE                   PIC X(5)  VALUE ' '.        
           10  S-TABLE-NAME                 PIC X(18) VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L       PIC S9(4) USAGE COMP.       
               49  S-HOST-VARIABLES-V       PIC X(255).                 
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L        PIC S9(4) USAGE COMP.       
               49  S-SQL-STATEMENT-V        PIC X(255).                 
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L      PIC S9(4) USAGE COMP.       
               49  S-SQL-DESCRIPTION-V      PIC X(255).                 
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L      PIC S9(4) USAGE COMP.       
               49  WS-ABEND-SQLERRMC-V      PIC X(255).                 
           10  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
      *                                                                         
      **** ERROR HANDLING (ABEND VARIABLES)                                     
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      **** DB2 AND SQL ERROR CHECKING                                           
           COPY CWS00303.                                                       
      *                                                                         
      **** ABEND ROUTINE (USED WITH CPD09900 INCLUDE MEMBER)                    
           COPY CWS09900.                                                       
      *                                                                         
      ******************************************************************        
      ** ACCOUNT RATE AND BILLING DETAILS CURSOR                      **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               DECLARE ACCT_BILL_DET_CUR CURSOR FOR                     
                SELECT  BG.CODE_UTIL_TYPE                               
                       ,BG.IC_NO                                        
                       ,BG.BILL_NO                                      
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BG.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                           
                       ,COALESCE(BI.DATE_BILLED,IIF(TRY_CONVERT(DATE, 
              '2999-12-31') IS NULL OR (PATINDEX('%.%', '2999-12-31'
              ) <> 0) OR (LEN('2999-12-31') <> 10), CIS.CHAR2DATE(
              '2999-12-31'), CONVERT(DATE, '2999-12-31') ))             
                       ,COALESCE(BG.DATE_ORIG_BILL,
              IIF(TRY_CONVERT(DATE, '1900-01-01'
              ) IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') ))          
                       ,BG.REVENUE_MONTH                                
                       ,BG.REV_MTH_ORIG_BILL                            
P836F1                 ,BG.CODE_DR_CR_CNSMPTN                           
P836F1                 ,BG.AMT_BILL_ITEM                                
                       ,BG.CODE_BILL_CALC                               
                       ,BG.CODE_BILL_ITM_IND                            
                       ,BG.CODE_BILL_ITM_TYPE                           
                       ,Z4.PRTY_SVC_CAT_CD                              
                       ,RD.RATE_PLAN_NO                                 
                       ,RD.BILL_LITERAL_TX                              
                       ,BI.CODE_BILL_TYPE                               
                                                                        
                  FROM  CSS_BILLING_HDR     BI WITH(READUNCOMMITTED)            
                       ,CSS_BILLING_DET     BG WITH(READUNCOMMITTED)            
                       ,CSS_UTIL_ENVRNMT    UT WITH(READUNCOMMITTED)            
                       ,CSS_PRTY_SVC_CAT    Z4 WITH(READUNCOMMITTED)            
                       ,CSS_RATE_PLAN_DESC  RD WITH(READUNCOMMITTED)            
                                                                        
                 WHERE  BI.ACCOUNT_NO        = :BI-ACCOUNT-NO           
                   AND  BI.ACCOUNT_NO        =  BG.ACCOUNT_NO           
                   AND  BI.ACCOUNT_NO        =  UT.ACCOUNT_NO           
                   AND  BI.COMPANY_NO        =  BG.COMPANY_NO           
                   AND  BI.COMPANY_NO        =  UT.COMPANY_NO           
                   AND  BI.COMPANY_NO        =  Z4.COMPANY_NO           
                   AND  BI.BILL_NO           =  BG.BILL_NO              
                   AND  BG.IC_NO             =  UT.IC_NO                
                   AND  BG.CODE_UTIL_TYPE    =  UT.CODE_UTIL_TYPE       
                   AND  BG.CODE_UTIL_TYPE    =  RD.CODE_UTIL_TYPE       
                   AND  BG.RATE_PLAN_NO      =  RD.RATE_PLAN_NO         
                   AND  UT.CODE_CURTAIL_PRTY =  Z4.CODE_CURTAIL_PRTY    
                FOR READ ONLY                                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE ACCT_BILL_DET_CUR CURSOR FOR                             
MFA-TR*         SELECT  BG.CODE_UTIL_TYPE                                       
MFA-TR*                ,BG.IC_NO                                                
MFA-TR*                ,BG.BILL_NO                                              
MFA-TR*                ,BG.BILL_ITEM_TIMESTMP                                   
MFA-TR*                ,IFNULL(BI.DATE_BILLED,'2999-12-31')                     
MFA-TR*                ,IFNULL(BG.DATE_ORIG_BILL,'1900-01-01')                  
MFA-TR*                ,BG.REVENUE_MONTH                                        
MFA-TR*                ,BG.REV_MTH_ORIG_BILL                                    
MFA-TR*                ,BG.CODE_DR_CR_CNSMPTN                                   
MFA-TR*                ,BG.AMT_BILL_ITEM                                        
MFA-TR*                ,BG.CODE_BILL_CALC                                       
MFA-TR*                ,BG.CODE_BILL_ITM_IND                                    
MFA-TR*                ,BG.CODE_BILL_ITM_TYPE                                   
MFA-TR*                ,Z4.PRTY_SVC_CAT_CD                                      
MFA-TR*                ,RD.RATE_PLAN_NO                                         
MFA-TR*                ,RD.BILL_LITERAL_TX                                      
MFA-TR*                ,BI.CODE_BILL_TYPE                                       
MFA-TR*                                                                         
MFA-TR*           FROM  CSS_BILLING_HDR     BI                                  
MFA-TR*                ,CSS_BILLING_DET     BG                                  
MFA-TR*                ,CSS_UTIL_ENVRNMT    UT                                  
MFA-TR*                ,CSS_PRTY_SVC_CAT    Z4                                  
MFA-TR*                ,CSS_RATE_PLAN_DESC  RD                                  
MFA-TR*                                                                         
MFA-TR*          WHERE  BI.ACCOUNT_NO        = :BI-ACCOUNT-NO                   
MFA-TR*            AND  BI.ACCOUNT_NO        =  BG.ACCOUNT_NO                   
MFA-TR*            AND  BI.ACCOUNT_NO        =  UT.ACCOUNT_NO                   
MFA-TR*            AND  BI.COMPANY_NO        =  BG.COMPANY_NO                   
MFA-TR*            AND  BI.COMPANY_NO        =  UT.COMPANY_NO                   
MFA-TR*            AND  BI.COMPANY_NO        =  Z4.COMPANY_NO                   
MFA-TR*            AND  BI.BILL_NO           =  BG.BILL_NO                      
MFA-TR*            AND  BG.IC_NO             =  UT.IC_NO                        
MFA-TR*            AND  BG.CODE_UTIL_TYPE    =  UT.CODE_UTIL_TYPE               
MFA-TR*            AND  BG.CODE_UTIL_TYPE    =  RD.CODE_UTIL_TYPE               
MFA-TR*            AND  BG.RATE_PLAN_NO      =  RD.RATE_PLAN_NO                 
MFA-TR*            AND  UT.CODE_CURTAIL_PRTY =  Z4.CODE_CURTAIL_PRTY            
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01 LINK-APPL-PROGRAM-ID  PIC X(03).                              
       01 LINK-ACCOUNT-NO       PIC X(13).                              
      *                                                                         
       PROCEDURE DIVISION USING LINK-APPL-PROGRAM-ID                    
                               ,LINK-ACCOUNT-NO.                        
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE         THRU  0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT      THRU  1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT     THRU  2000-EXIT.             
           PERFORM 2900-VLDT-NOTFOUND-RES  THRU  2900-EXIT.             
           PERFORM 9999-END-PROGRAM        THRU  9999-EXIT.             
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE '0100'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS.         
      *                                                                         
           PERFORM 0100A-DECLARE-GTT-SUMMARY  THRU  0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-WORK     THRU  0100B-EXIT.         
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DECLARE GLOBAL TEMPORARY TABLE - RESULT TABLE                **        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT-SUMMARY.                                       
      *                                                                         
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04892_SUMMARY'            
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04892_SUMMARY')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04892_SUMMARY
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,IC_NO                   SMALLINT                    
                   ,PRTY_SVC_CAT_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RATE_DESC CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,DATE_BILLED CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,REVENUE_MONTH           DECIMAL(6,0)                
                   ,MT_MCF                  DECIMAL(10,1)               
                   ,MT_MCF_PEAK             DECIMAL(10,1)               
                   ,MT_DEKATHERMS           DECIMAL(10,1)               
                   ,MT_DEKATHERMS_PEAK      DECIMAL(10,1)               
                   ,VB_MCF                  DECIMAL(10,1)               
                   ,VB_MCF_PEAK             DECIMAL(10,1)               
                   ,VB_DEKATHERMS           DECIMAL(10,1)               
                   ,VB_DEKATHERMS_PEAK      DECIMAL(10,1)               
                   ,OTHER_UNITS             DECIMAL(10,1)               
                   ,OTHER_UNITS_PEAK        DECIMAL(10,1)               
                   ,AMT_BILL_ITEM           DECIMAL(11,2)               
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS-SUMMARY  THRU  8000A-EXIT      
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE '0100A'                TO ACTIVE-PARAGRAPH        
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSR04892_SUMMARY'    TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,CODE_UTIL_TYPE                                   
                      ,IC_NO                                            
                      ,PRTY_SVC_CAT_CD                                  
                      ,RATE_PLAN_NO                                     
                      ,RATE_DESC                                        
                      ,DATE_BILLED                                      
                      ,REVENUE_MONTH                                    
                      ,MT_MCF                                           
                      ,MT_MCF_PEAK                                      
                      ,MT_DEKATHERMS                                    
                      ,MT_DEKATHERMS_PEAK                               
                      ,VB_MCF                                           
                      ,VB_MCF_PEAK                                      
                      ,VB_DEKATHERMS                                    
                      ,VB_DEKATHERMS_PEAK                               
                      ,OTHER_UNITS                                      
                      ,OTHER_UNITS_PEAK                                 
                      ,AMT_BILL_ITEM                                    
                  FROM #CSR04892_SUMMARY                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,IC_NO                                                    
MFA-TR*               ,PRTY_SVC_CAT_CD                                          
MFA-TR*               ,RATE_PLAN_NO                                             
MFA-TR*               ,RATE_DESC                                                
MFA-TR*               ,DATE_BILLED                                              
MFA-TR*               ,REVENUE_MONTH                                            
MFA-TR*               ,MT_MCF                                                   
MFA-TR*               ,MT_MCF_PEAK                                              
MFA-TR*               ,MT_DEKATHERMS                                            
MFA-TR*               ,MT_DEKATHERMS_PEAK                                       
MFA-TR*               ,VB_MCF                                                   
MFA-TR*               ,VB_MCF_PEAK                                              
MFA-TR*               ,VB_DEKATHERMS                                            
MFA-TR*               ,VB_DEKATHERMS_PEAK                                       
MFA-TR*               ,OTHER_UNITS                                              
MFA-TR*               ,OTHER_UNITS_PEAK                                         
MFA-TR*               ,AMT_BILL_ITEM                                            
MFA-TR*           FROM SESSION.CSR04892_SUMMARY                                 
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** DECLARE GLOBAL TEMPORARY TABLE - WORKING TABLE               **        
      ******************************************************************        
      *                                                                         
       0100B-DECLARE-GTT-WORK.                                          
      *                                                                         
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04892_WORK'               
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04892_WORK')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04892_WORK
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,IC_NO                   SMALLINT                    
                   ,BILL_NO                 INT                     
                   ,BILL_ITEM_TIMESTMP CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DATE_BILLED CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_BILL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,REVENUE_MONTH           DECIMAL(6,0)               
                   ,AMT_BILL_ITEM           DECIMAL(11,2)              
                   ,PRTY_SVC_CAT_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RATE_DESC CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,MT_MCF                  DECIMAL(10,1)               
                   ,MT_MCF_PEAK             DECIMAL(10,1)               
                   ,MT_DEKATHERMS           DECIMAL(10,1)               
                   ,MT_DEKATHERMS_PEAK      DECIMAL(10,1)               
                   ,VB_MCF                  DECIMAL(10,1)               
                   ,VB_MCF_PEAK             DECIMAL(10,1)               
                   ,VB_DEKATHERMS           DECIMAL(10,1)               
                   ,VB_DEKATHERMS_PEAK      DECIMAL(10,1)               
                   ,OTHER_UNITS             DECIMAL(10,1)               
                   ,OTHER_UNITS_PEAK        DECIMAL(10,1)               
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS-WORK  THRU  8000B-EXIT         
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE '0100B'                TO ACTIVE-PARAGRAPH        
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSR04892_WORK'       TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,CODE_UTIL_TYPE                                   
                      ,IC_NO                                            
                      ,BILL_NO                                          
                      ,BILL_ITEM_TIMESTMP                               
                      ,DATE_BILLED                                      
                      ,CODE_BILL_TYPE                                   
                      ,REVENUE_MONTH                                    
                      ,AMT_BILL_ITEM                                    
                      ,PRTY_SVC_CAT_CD                                  
                      ,RATE_PLAN_NO                                     
                      ,RATE_DESC                                        
                      ,MT_MCF                                           
                      ,MT_MCF_PEAK                                      
                      ,MT_DEKATHERMS                                    
                      ,MT_DEKATHERMS_PEAK                               
                      ,VB_MCF                                           
                      ,VB_MCF_PEAK                                      
                      ,VB_DEKATHERMS                                    
                      ,VB_DEKATHERMS_PEAK                               
                      ,OTHER_UNITS                                      
                      ,OTHER_UNITS_PEAK                                 
                  FROM #CSR04892_WORK                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,IC_NO                                                    
MFA-TR*               ,BILL_NO                                                  
MFA-TR*               ,BILL_ITEM_TIMESTMP                                       
MFA-TR*               ,DATE_BILLED                                              
MFA-TR*               ,CODE_BILL_TYPE                                           
MFA-TR*               ,REVENUE_MONTH                                            
MFA-TR*               ,AMT_BILL_ITEM                                            
MFA-TR*               ,PRTY_SVC_CAT_CD                                          
MFA-TR*               ,RATE_PLAN_NO                                             
MFA-TR*               ,RATE_DESC                                                
MFA-TR*               ,MT_MCF                                                   
MFA-TR*               ,MT_MCF_PEAK                                              
MFA-TR*               ,MT_DEKATHERMS                                            
MFA-TR*               ,MT_DEKATHERMS_PEAK                                       
MFA-TR*               ,VB_MCF                                                   
MFA-TR*               ,VB_MCF_PEAK                                              
MFA-TR*               ,VB_DEKATHERMS                                            
MFA-TR*               ,VB_DEKATHERMS_PEAK                                       
MFA-TR*               ,OTHER_UNITS                                              
MFA-TR*               ,OTHER_UNITS_PEAK                                         
MFA-TR*           FROM SESSION.CSR04892_WORK                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100B-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** RECEIVE INPUT PARMS                                          **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE '1000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           IF LINK-APPL-PROGRAM-ID GREATER THAN SPACES                  
              MOVE LINK-APPL-PROGRAM-ID   TO PARM-APPL-PROGRAM-ID       
           END-IF.                                                      
      *                                                                         
           IF LINK-ACCOUNT-NO GREATER THAN SPACES                       
              MOVE LINK-ACCOUNT-NO        TO PARM-ACCOUNT-NO            
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** PROCESS OUTPUT                                               **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        BI-ACCOUNT-NO              
                                             BI-DATE-BILLED             
                                             BI-CODE-BILL-TYPE          
                                             DCLCSS-BILLING-DET         
                                             Z4-PRTY-SVC-CAT-CD         
                                             RD-RATE-PLAN-NO            
                                             RD-BILL-LITERAL-TX.        
      *                                                                         
           MOVE PARM-ACCOUNT-NO-NUM       TO AT-ACCOUNT-NO              
                                             BI-ACCOUNT-NO              
                                             WQ-ACCOUNT-NO.             
      *                                                                         
      *** GET REVENUE MONTH FOR UNBILLED ROW                                    
           PERFORM 7000-SELECT-ACCT-DATA  THRU  7000-EXIT.              
           MOVE AT-REV-MTH-LST-NRML       TO WS-REVENUE-MONTH.          
           IF WS-REVENUE-MONTH > 0                                      
              ADD  1                      TO WS-REVENUE-MONTH-MM        
              IF WS-REVENUE-MONTH-MM > 12                               
                 MOVE 1                   TO WS-REVENUE-MONTH-MM        
                 ADD  1                   TO WS-REVENUE-MONTH-YY        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
      *** CHECK EBILL NO DISPLAY IND FOR ANY ACTIVE/INPROGRESS WQ               
           PERFORM 7050-CHECK-EBILL-NO-DISP-IND    THRU  7050-EXIT.     
      *                                                                         
           PERFORM 7100-OPEN-ACCT-BILL-DET-CUR     THRU  7100-EXIT.     
           PERFORM 7125-FETCH-ACCT-BILL-DET-CUR    THRU  7125-EXIT.     
           PERFORM 2100-PROCESS-ACCT-BILL-DETAILS  THRU  2100-EXIT      
             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
           PERFORM 7150-CLOSE-ACCT-BILL-DET-CUR    THRU  7150-EXIT.     
      *                                                                         
      **** POPULATE SUMMARY RESULT USING WORK TABLE                             
           IF CTR-ROWS-WORK > 0                                         
              PERFORM 8200-INSERT-RESULT-SUMMARY   THRU  8200-EXIT      
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** PROCESS ACCOUNT RATE AND BILLING DETAILS                     **        
      ******************************************************************        
      *                                                                         
       2100-PROCESS-ACCT-BILL-DETAILS.                                  
      *                                                                         
           MOVE '2100'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS-WORK     
                                             DCLCSS-VOL-DAILY.          
      *                                                                         
      **** GET VOL DAILY DATA(EXCLUDING BACKOUT ROW & CANCEL ROW)               
           IF BG-CODE-BILL-ITM-TYPE NOT = 'B'  AND                      
              BG-CODE-BILL-ITM-IND  NOT = 'K'                           
              MOVE PARM-ACCOUNT-NO-NUM    TO ND-ACCOUNT-NO              
              MOVE BG-BILL-NO             TO ND-BILL-NO                 
              MOVE BG-CODE-UTIL-TYPE      TO ND-CODE-UTIL-TYPE          
              MOVE BG-IC-NO               TO ND-IC-NO                   
              MOVE BG-BILL-ITEM-TIMESTMP  TO ND-BILL-ITEM-TIMESTMP      
              PERFORM 7200-GET-VOL-DAILY-DATA  THRU  7200-EXIT          
           END-IF.                                                      
      *                                                                         
           PERFORM 2500-MOVE-RESULT-WORK  THRU  2500-EXIT.              
      *                                                                         
           INITIALIZE                        BI-DATE-BILLED             
                                             DCLCSS-BILLING-DET         
                                             Z4-PRTY-SVC-CAT-CD         
                                             RD-RATE-PLAN-NO            
                                             RD-BILL-LITERAL-TX.        
      *                                                                         
           PERFORM 7125-FETCH-ACCT-BILL-DET-CUR  THRU  7125-EXIT.       
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE CIG USAGE HISTORY SUMMARY WORKING TABLE                 **        
      ******************************************************************        
      *                                                                         
       2500-MOVE-RESULT-WORK.                                           
      *                                                                         
           MOVE '2500'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           IF WS-SHOW-LATEST-BILL-FL = 'Y' AND                          
              CTR-ROWS-WORK          =  0  AND                          
              BG-BILL-NO             >  0  AND                          
              BG-REVENUE-MONTH       >  0                               
              MOVE BG-REVENUE-MONTH       TO WS-WEB-REV-MTH-LATEST      
              PERFORM 7950-CHECK-BILL-CRED-DATA THRU 7950-EXIT          
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'N'                 TO WS-SHOW-LATEST-BILL-FL     
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE BG-CODE-UTIL-TYPE         TO S-W-CODE-UTIL-TYPE.        
           MOVE BG-IC-NO                  TO S-W-IC-NO.                 
           MOVE BG-BILL-NO                TO S-W-BILL-NO.               
           MOVE BG-BILL-ITEM-TIMESTMP     TO S-W-BILL-ITEM-TIMESTMP.    
           MOVE BI-CODE-BILL-TYPE         TO S-W-CODE-BILL-TYPE.        
      *                                                                         
      **** WE CAN USE BG-DATE-ORIG-BILL, IF NEEDED                              
           EVALUATE TRUE                                                
      **** WE DON'T WANT TO CONSIDER BILL DATE OF NON-CALC                      
               WHEN BG-CODE-BILL-CALC = 'S'                             
                    MOVE '1900-01-01'     TO S-W-DATE-BILLED            
      **** UNBILLED ROW                                                         
               WHEN BI-DATE-BILLED = '2999-12-31'                       
                    MOVE SPACES           TO S-W-DATE-BILLED            
               WHEN OTHER                                               
                    MOVE BI-DATE-BILLED   TO S-W-DATE-BILLED            
           END-EVALUATE.                                                
      *                                                                         
      **** CANCEL-REBILL: USE ORIGINAL BILL REVENUE MONTH                       
      **** UNBILLED ROW : REVENUE MONTH LAST NORMAL + 1                         
           IF BG-REV-MTH-ORIG-BILL > 0                                  
              MOVE BG-REV-MTH-ORIG-BILL   TO S-W-REVENUE-MONTH          
           ELSE                                                         
              IF BG-REVENUE-MONTH  = 0                                  
                 MOVE WS-REVENUE-MONTH    TO S-W-REVENUE-MONTH          
              ELSE                                                      
                 MOVE BG-REVENUE-MONTH    TO S-W-REVENUE-MONTH          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE BG-AMT-BILL-ITEM          TO S-W-AMT-BILL-ITEM.         
           MOVE Z4-PRTY-SVC-CAT-CD        TO S-W-PRTY-SVC-CAT-CD.       
           MOVE RD-RATE-PLAN-NO           TO S-W-RATE-PLAN-NO.          
           MOVE RD-BILL-LITERAL-TX-TEXT(7:44)                           
                                          TO S-W-RATE-DESC.             
      *                                                                         
           IF (WS-SHOW-LATEST-BILL-FL  = 'N' AND                        
               WS-WEB-REV-MTH-LATEST   =  S-W-REVENUE-MONTH)            
      ***                            OR                                         
      *** FURTURE BILLHOOK WITH NO CONSUMPTION                                  
      ***     (S-W-DATE-BILLED         = ' ' AND                                
      ***      S-W-MT-MCF              =  0  AND                                
      ***      S-W-MT-MCF-PEAK         =  0  AND                                
      ***      S-W-MT-DEKATHERMS       =  0  AND                                
      ***      S-W-MT-DEKATHERMS-PEAK  =  0  AND                                
      ***      S-W-VB-MCF              =  0  AND                                
      ***      S-W-VB-MCF-PEAK         =  0  AND                                
      ***      S-W-VB-DEKATHERMS       =  0  AND                                
      ***      S-W-VB-DEKATHERMS-PEAK  =  0  AND                                
      ***      S-W-OTHER-UNITS         =  0  AND                                
      ***      S-W-OTHER-UNITS-PEAK    =  0  )                                  
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 8100B-SEND-RESULT-WORK  THRU  8100B-EXIT          
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** IF ROW COUNT = 0 IN A RESULT SET, SEND DUMMY RESULT SET      **        
      ******************************************************************        
      *                                                                         
       2900-VLDT-NOTFOUND-RES.                                          
      *                                                                         
           MOVE '2900'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           IF CTR-ROWS-SUMMARY = 0                                      
              INITIALIZE                     GTT-RETURN-FIELDS-SUMMARY  
              MOVE 100                    TO S-RETURN-CODE              
                                             S-APPL-RETURN-CODE         
              PERFORM 8100A-SEND-RESULT-SUMMARY  THRU  8100A-EXIT       
           END-IF.                                                      
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CHECK ACTIVE/IN PROGRESS WQ WITH EBILL NO DISPLAY IND SET    **        
      ******************************************************************        
      *                                                                         
       7000-SELECT-ACCT-DATA.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT  AT.REV_MTH_LST_NRML                             
                  INTO :AT-REV-MTH-LST-NRML                             
                  FROM CSS_ACCOUNT     AT WITH(READUNCOMMITTED)                 
                 WHERE AT.ACCOUNT_NO  =  :AT-ACCOUNT-NO                 
                   AND AT.COMPANY_NO  =  '01'                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  AT.REV_MTH_LST_NRML                                     
MFA-TR*           INTO :AT-REV-MTH-LST-NRML                                     
MFA-TR*           FROM CSS_ACCOUNT     AT                                       
MFA-TR*          WHERE AT.ACCOUNT_NO  =  :AT-ACCOUNT-NO                         
MFA-TR*            AND AT.COMPANY_NO  =  '01'                                   
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CHECK ACTIVE/IN PROGRESS WQ WITH EBILL NO DISPLAY IND SET    **        
      ******************************************************************        
      *                                                                         
       7050-CHECK-EBILL-NO-DISP-IND.                                    
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'N'                                              
                  INTO :WS-SHOW-LATEST-BILL-FL                          
                  FROM CSS_WQ_CATEGORY C3 WITH(READUNCOMMITTED)                 
                      ,CSS_WQ_ITEMS    WQ WITH(READUNCOMMITTED)                 
                 WHERE WQ.ACCOUNT_NO        =  :WQ-ACCOUNT-NO           
                   AND WQ.CATEGORY_ID       =   C3.CATEGORY_ID          
                   AND C3.EBILL_NO_DISP_IND =  'Y'                      
                   AND WQ.STATUS           IN ('A','I')                 
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'N'                                                      
MFA-TR*           INTO :WS-SHOW-LATEST-BILL-FL                                  
MFA-TR*           FROM CSS_WQ_CATEGORY C3                                       
MFA-TR*               ,CSS_WQ_ITEMS    WQ                                       
MFA-TR*          WHERE WQ.ACCOUNT_NO        =  :WQ-ACCOUNT-NO                   
MFA-TR*            AND WQ.CATEGORY_ID       =   C3.CATEGORY_ID                  
MFA-TR*            AND C3.EBILL_NO_DISP_IND =  'Y'                              
MFA-TR*            AND WQ.STATUS           IN ('A','I')                         
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*         QUERYNO 7050                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7050'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_WQ_ITEMS'        TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WQ-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** OPEN ACCOUNT RATE AND BILLING DETAILS CURSOR                 **        
      ******************************************************************        
      *                                                                         
       7100-OPEN-ACCT-BILL-DET-CUR.                                     
      *                                                                         
           EXEC SQL                                                     
                OPEN ACCT_BILL_DET_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_BILLING_HDR'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE BI-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** FETCH ACCOUNT RATE AND BILLING DETAILS CURSOR                **        
      ******************************************************************        
      *                                                                         
       7125-FETCH-ACCT-BILL-DET-CUR.                                    
      *                                                                         
           EXEC SQL                                                     
               FETCH ACCT_BILL_DET_CUR                                  
                INTO :BG-CODE-UTIL-TYPE                                 
                    ,:BG-IC-NO                                          
                    ,:BG-BILL-NO                                        
                    ,:BG-BILL-ITEM-TIMESTMP                             
                    ,:BI-DATE-BILLED                                    
                    ,:BG-DATE-ORIG-BILL                                 
                    ,:BG-REVENUE-MONTH                                  
                    ,:BG-REV-MTH-ORIG-BILL                              
P836F1              ,:BG-CODE-DR-CR-CNSMPTN                             
                    ,:BG-AMT-BILL-ITEM                                  
                    ,:BG-CODE-BILL-CALC                                 
                    ,:BG-CODE-BILL-ITM-IND                              
                    ,:BG-CODE-BILL-ITM-TYPE                             
                    ,:Z4-PRTY-SVC-CAT-CD                                
                    ,:RD-RATE-PLAN-NO                                   
                    ,:RD-BILL-LITERAL-TX                                
                    ,:BI-CODE-BILL-TYPE                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
P836F1     EVALUATE WS-ACTIVE-RETURN-CODE                               
P836F1        WHEN SUCCESSFUL-CALL                                      
P836F1           IF BG-CODE-DR-CR-CNSMPTN EQUAL 'C'                     
P836F1              COMPUTE BG-AMT-BILL-ITEM                            
P836F1                EQUAL BG-AMT-BILL-ITEM * -1                       
P836F1           END-IF                                                 
P836F1        WHEN NOT-FOUND                                            
P836F1           CONTINUE                                               
P836F1        WHEN OTHER                                                
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '7125'             TO ACTIVE-PARAGRAPH            
                 MOVE 'OPEN'             TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE 'CSS_BILLING_HDR'  TO TABLE-1                     
                 MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1             
                 MOVE BI-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1           
                 PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT        
P836F1     END-EVALUATE.                                                
      *                                                                         
       7125-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CLOSE ACCOUNT RATE AND BILLING DETAILS CURSOR                **        
      ******************************************************************        
      *                                                                         
       7150-CLOSE-ACCT-BILL-DET-CUR.                                    
                                                                        
           EXEC SQL                                                     
                CLOSE ACCT_BILL_DET_CUR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7150'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_BILLING_HDR'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE BI-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET VOLUME DAILY DATA FOR EACH BG ROW                        **        
      ******************************************************************        
      *                                                                         
       7200-GET-VOL-DAILY-DATA.                                         
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                  COALESCE(SUM(CASE                                       
                             WHEN (ND.VOL_TYPE_CD    = 'MT'             
                              AND  ND.ENERGY_UNIT_CD = 'M')             
                             THEN  ND.NO_UNITS ELSE 0 END),0)           
                 ,COALESCE(MAX(CASE                                       
                             WHEN (ND.VOL_TYPE_CD    = 'MT'             
                              AND  ND.ENERGY_UNIT_CD = 'M')             
                             THEN  ND.NO_UNITS ELSE 0 END),0)           
                 ,COALESCE(SUM(CASE                                       
                             WHEN (ND.VOL_TYPE_CD    = 'MT'             
                              AND  ND.ENERGY_UNIT_CD = 'D')             
                             THEN  ND.NO_UNITS ELSE 0 END),0)           
                 ,COALESCE(MAX(CASE                                       
                             WHEN (ND.VOL_TYPE_CD    = 'MT'             
                              AND  ND.ENERGY_UNIT_CD = 'D')             
                             THEN  ND.NO_UNITS ELSE 0 END),0)           
                 ,COALESCE(SUM(CASE                                       
                             WHEN (ND.VOL_TYPE_CD    = 'VB'             
                              AND  ND.ENERGY_UNIT_CD = 'M')             
                             THEN  ND.NO_UNITS ELSE 0 END),0)           
                 ,COALESCE(MAX(CASE                                       
                             WHEN (ND.VOL_TYPE_CD    = 'VB'             
                              AND  ND.ENERGY_UNIT_CD = 'M')             
                             THEN  ND.NO_UNITS ELSE 0 END),0)           
                 ,COALESCE(SUM(CASE                                       
                             WHEN (ND.VOL_TYPE_CD    = 'VB'             
                              AND  ND.ENERGY_UNIT_CD = 'D')             
                             THEN  ND.NO_UNITS ELSE 0 END),0)           
                 ,COALESCE(MAX(CASE                                       
                             WHEN (ND.VOL_TYPE_CD    = 'VB'             
                              AND  ND.ENERGY_UNIT_CD = 'D')             
                             THEN  ND.NO_UNITS ELSE 0 END),0)           
                 ,COALESCE(SUM(CASE                                       
                             WHEN (ND.ENERGY_UNIT_CD IN ('D','M'))      
                             THEN  0 ELSE ND.NO_UNITS END),0)           
                 ,COALESCE(MAX(CASE                                       
                             WHEN (ND.ENERGY_UNIT_CD IN ('D','M'))      
                             THEN  0 ELSE ND.NO_UNITS END),0)           
                  INTO :S-W-MT-MCF                                      
                      ,:S-W-MT-MCF-PEAK                                 
                      ,:S-W-MT-DEKATHERMS                               
                      ,:S-W-MT-DEKATHERMS-PEAK                          
                      ,:S-W-VB-MCF                                      
                      ,:S-W-VB-MCF-PEAK                                 
                      ,:S-W-VB-DEKATHERMS                               
                      ,:S-W-VB-DEKATHERMS-PEAK                          
                      ,:S-W-OTHER-UNITS                                 
                      ,:S-W-OTHER-UNITS-PEAK                            
                  FROM  CSS_VOL_DAILY  ND WITH(READUNCOMMITTED)                 
                 WHERE  ND.ACCOUNT_NO         = :ND-ACCOUNT-NO          
                   AND  ND.BILL_NO            = :ND-BILL-NO             
                   AND  ND.CODE_UTIL_TYPE     = :ND-CODE-UTIL-TYPE      
                   AND  ND.IC_NO              = :ND-IC-NO               
                   AND  ND.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :ND-BILL-ITEM-TIMESTMP
              )  
                   AND  ND.VOL_TYPE_CD       IN ('MT','VB')             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*           IFNULL(SUM(CASE                                               
MFA-TR*                      WHEN (ND.VOL_TYPE_CD    = 'MT'                     
MFA-TR*                       AND  ND.ENERGY_UNIT_CD = 'M')                     
MFA-TR*                      THEN  ND.NO_UNITS ELSE 0 END),0)                   
MFA-TR*          ,IFNULL(MAX(CASE                                               
MFA-TR*                      WHEN (ND.VOL_TYPE_CD    = 'MT'                     
MFA-TR*                       AND  ND.ENERGY_UNIT_CD = 'M')                     
MFA-TR*                      THEN  ND.NO_UNITS ELSE 0 END),0)                   
MFA-TR*          ,IFNULL(SUM(CASE                                               
MFA-TR*                      WHEN (ND.VOL_TYPE_CD    = 'MT'                     
MFA-TR*                       AND  ND.ENERGY_UNIT_CD = 'D')                     
MFA-TR*                      THEN  ND.NO_UNITS ELSE 0 END),0)                   
MFA-TR*          ,IFNULL(MAX(CASE                                               
MFA-TR*                      WHEN (ND.VOL_TYPE_CD    = 'MT'                     
MFA-TR*                       AND  ND.ENERGY_UNIT_CD = 'D')                     
MFA-TR*                      THEN  ND.NO_UNITS ELSE 0 END),0)                   
MFA-TR*          ,IFNULL(SUM(CASE                                               
MFA-TR*                      WHEN (ND.VOL_TYPE_CD    = 'VB'                     
MFA-TR*                       AND  ND.ENERGY_UNIT_CD = 'M')                     
MFA-TR*                      THEN  ND.NO_UNITS ELSE 0 END),0)                   
MFA-TR*          ,IFNULL(MAX(CASE                                               
MFA-TR*                      WHEN (ND.VOL_TYPE_CD    = 'VB'                     
MFA-TR*                       AND  ND.ENERGY_UNIT_CD = 'M')                     
MFA-TR*                      THEN  ND.NO_UNITS ELSE 0 END),0)                   
MFA-TR*          ,IFNULL(SUM(CASE                                               
MFA-TR*                      WHEN (ND.VOL_TYPE_CD    = 'VB'                     
MFA-TR*                       AND  ND.ENERGY_UNIT_CD = 'D')                     
MFA-TR*                      THEN  ND.NO_UNITS ELSE 0 END),0)                   
MFA-TR*          ,IFNULL(MAX(CASE                                               
MFA-TR*                      WHEN (ND.VOL_TYPE_CD    = 'VB'                     
MFA-TR*                       AND  ND.ENERGY_UNIT_CD = 'D')                     
MFA-TR*                      THEN  ND.NO_UNITS ELSE 0 END),0)                   
MFA-TR*          ,IFNULL(SUM(CASE                                               
MFA-TR*                      WHEN (ND.ENERGY_UNIT_CD IN ('D','M'))              
MFA-TR*                      THEN  0 ELSE ND.NO_UNITS END),0)                   
MFA-TR*          ,IFNULL(MAX(CASE                                               
MFA-TR*                      WHEN (ND.ENERGY_UNIT_CD IN ('D','M'))              
MFA-TR*                      THEN  0 ELSE ND.NO_UNITS END),0)                   
MFA-TR*           INTO :S-W-MT-MCF                                              
MFA-TR*               ,:S-W-MT-MCF-PEAK                                         
MFA-TR*               ,:S-W-MT-DEKATHERMS                                       
MFA-TR*               ,:S-W-MT-DEKATHERMS-PEAK                                  
MFA-TR*               ,:S-W-VB-MCF                                              
MFA-TR*               ,:S-W-VB-MCF-PEAK                                         
MFA-TR*               ,:S-W-VB-DEKATHERMS                                       
MFA-TR*               ,:S-W-VB-DEKATHERMS-PEAK                                  
MFA-TR*               ,:S-W-OTHER-UNITS                                         
MFA-TR*               ,:S-W-OTHER-UNITS-PEAK                                    
MFA-TR*           FROM  CSS_VOL_DAILY  ND                                       
MFA-TR*          WHERE  ND.ACCOUNT_NO         = :ND-ACCOUNT-NO                  
MFA-TR*            AND  ND.BILL_NO            = :ND-BILL-NO                     
MFA-TR*            AND  ND.CODE_UTIL_TYPE     = :ND-CODE-UTIL-TYPE              
MFA-TR*            AND  ND.IC_NO              = :ND-IC-NO                       
MFA-TR*            AND  ND.BILL_ITEM_TIMESTMP = :ND-BILL-ITEM-TIMESTMP          
MFA-TR*            AND  ND.VOL_TYPE_CD       IN ('MT','VB')                     
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7200'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_VOL_DAILY'       TO TABLE-1                     
              MOVE 'BILL_NO'             TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE 'BILL_ITEM_TIMESTMP'  TO TABLE-ELEMENT-4             
              MOVE BG-BILL-NO            TO HOSTVAR-ELEMENT-1           
              MOVE BG-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE BG-IC-NO              TO HOSTVAR-ELEMENT-3           
              MOVE BG-BILL-ITEM-TIMESTMP TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CHECK DATA EXISTS FOR LATEST BILL IN BILL CRED TABLE         **        
      ******************************************************************        
      *                                                                         
       7950-CHECK-BILL-CRED-DATA.                                       
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) [1H].ACCOUNT_NO                                   
                  INTO :1H-ACCOUNT-NO                                   
                  FROM  CSS_BILL_CRED_DET [1H] WITH(READUNCOMMITTED)            
                 WHERE  [1H].ACCOUNT_NO = :BI-ACCOUNT-NO                  
                   AND  [1H].BILL_NO    = :BG-BILL-NO                     
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  1H.ACCOUNT_NO                                           
MFA-TR*           INTO :1H-ACCOUNT-NO                                           
MFA-TR*           FROM  CSS_BILL_CRED_DET 1H                                    
MFA-TR*          WHERE  1H.ACCOUNT_NO = :BI-ACCOUNT-NO                          
MFA-TR*            AND  1H.BILL_NO    = :BG-BILL-NO                             
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*         QUERYNO 7950                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7950'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_BILL_CRED_DET'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE BI-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'BILL_NO'             TO TABLE-ELEMENT-2             
              MOVE BG-BILL-NO            TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** DELETE SESSION TABLE - SUMMARY                              **         
      *****************************************************************         
      *                                                                         
       8000A-DEL-GTT-ROWS-SUMMARY.                                      
      *                                                                         
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04892_SUMMARY'             
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04892_SUMMARY                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04892_SUMMARY                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000A'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04892_SUMMARY'       TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      ** DELETE SESSION TABLE - WORKING TABLE                        **         
      *****************************************************************         
      *                                                                         
       8000B-DEL-GTT-ROWS-WORK.                                         
      *                                                                         
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04892_WORK'                
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04892_WORK                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04892_WORK                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000B'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04892_WORK'          TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8000B-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** INSERT RESULT SET - SUMMARY                                  **        
      ******************************************************************        
      *                                                                         
       8100A-SEND-RESULT-SUMMARY.                                       
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO #CSR04892_SUMMARY                      
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,CODE_UTIL_TYPE                                       
                  ,IC_NO                                                
                  ,PRTY_SVC_CAT_CD                                      
                  ,RATE_PLAN_NO                                         
                  ,RATE_DESC                                            
                  ,DATE_BILLED                                          
                  ,REVENUE_MONTH                                        
                  ,MT_MCF                                               
                  ,MT_MCF_PEAK                                          
                  ,MT_DEKATHERMS                                        
                  ,MT_DEKATHERMS_PEAK                                   
                  ,VB_MCF                                               
                  ,VB_MCF_PEAK                                          
                  ,VB_DEKATHERMS                                        
                  ,VB_DEKATHERMS_PEAK                                   
                  ,OTHER_UNITS                                          
                  ,OTHER_UNITS_PEAK                                     
                  ,AMT_BILL_ITEM                                        
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE                                       
                  ,:S-APPL-RETURN-CODE                                  
                  ,:S-CODE-UTIL-TYPE                                    
                  ,:S-IC-NO                                             
                  ,:S-PRTY-SVC-CAT-CD                                   
                  ,:S-RATE-PLAN-NO                                      
                  ,:S-RATE-DESC                                         
                  ,:S-DATE-BILLED                                       
                  ,:S-REVENUE-MONTH                                     
                  ,:S-MT-MCF                                            
                  ,:S-MT-MCF-PEAK                                       
                  ,:S-MT-DEKATHERMS                                     
                  ,:S-MT-DEKATHERMS-PEAK                                
                  ,:S-VB-MCF                                            
                  ,:S-VB-MCF-PEAK                                       
                  ,:S-VB-DEKATHERMS                                     
                  ,:S-VB-DEKATHERMS-PEAK                                
                  ,:S-OTHER-UNITS                                       
                  ,:S-OTHER-UNITS-PEAK                                  
                  ,:S-AMT-BILL-ITEM                                     
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04892_SUMMARY                              
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,IC_NO                                                        
MFA-TR*           ,PRTY_SVC_CAT_CD                                              
MFA-TR*           ,RATE_PLAN_NO                                                 
MFA-TR*           ,RATE_DESC                                                    
MFA-TR*           ,DATE_BILLED                                                  
MFA-TR*           ,REVENUE_MONTH                                                
MFA-TR*           ,MT_MCF                                                       
MFA-TR*           ,MT_MCF_PEAK                                                  
MFA-TR*           ,MT_DEKATHERMS                                                
MFA-TR*           ,MT_DEKATHERMS_PEAK                                           
MFA-TR*           ,VB_MCF                                                       
MFA-TR*           ,VB_MCF_PEAK                                                  
MFA-TR*           ,VB_DEKATHERMS                                                
MFA-TR*           ,VB_DEKATHERMS_PEAK                                           
MFA-TR*           ,OTHER_UNITS                                                  
MFA-TR*           ,OTHER_UNITS_PEAK                                             
MFA-TR*           ,AMT_BILL_ITEM                                                
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE                                               
MFA-TR*           ,:S-APPL-RETURN-CODE                                          
MFA-TR*           ,:S-CODE-UTIL-TYPE                                            
MFA-TR*           ,:S-IC-NO                                                     
MFA-TR*           ,:S-PRTY-SVC-CAT-CD                                           
MFA-TR*           ,:S-RATE-PLAN-NO                                              
MFA-TR*           ,:S-RATE-DESC                                                 
MFA-TR*           ,:S-DATE-BILLED                                               
MFA-TR*           ,:S-REVENUE-MONTH                                             
MFA-TR*           ,:S-MT-MCF                                                    
MFA-TR*           ,:S-MT-MCF-PEAK                                               
MFA-TR*           ,:S-MT-DEKATHERMS                                             
MFA-TR*           ,:S-MT-DEKATHERMS-PEAK                                        
MFA-TR*           ,:S-VB-MCF                                                    
MFA-TR*           ,:S-VB-MCF-PEAK                                               
MFA-TR*           ,:S-VB-DEKATHERMS                                             
MFA-TR*           ,:S-VB-DEKATHERMS-PEAK                                        
MFA-TR*           ,:S-OTHER-UNITS                                               
MFA-TR*           ,:S-OTHER-UNITS-PEAK                                          
MFA-TR*           ,:S-AMT-BILL-ITEM                                             
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1                          TO CTR-ROWS-SUMMARY        
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8100A'                   TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04892_SUMMARY'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE LINK-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
           END-IF.                                                      
      *                                                                         
        8100A-EXIT.                                                     
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** INSERT RESULT SET - WORKING TABLE                            **        
      ******************************************************************        
      *                                                                         
       8100B-SEND-RESULT-WORK.                                          
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO #CSR04892_WORK                         
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,CODE_UTIL_TYPE                                       
                  ,IC_NO                                                
                  ,BILL_NO                                              
                  ,BILL_ITEM_TIMESTMP                                   
                  ,DATE_BILLED                                          
                  ,CODE_BILL_TYPE                                       
                  ,REVENUE_MONTH                                        
                  ,AMT_BILL_ITEM                                        
                  ,PRTY_SVC_CAT_CD                                      
                  ,RATE_PLAN_NO                                         
                  ,RATE_DESC                                            
                  ,MT_MCF                                               
                  ,MT_MCF_PEAK                                          
                  ,MT_DEKATHERMS                                        
                  ,MT_DEKATHERMS_PEAK                                   
                  ,VB_MCF                                               
                  ,VB_MCF_PEAK                                          
                  ,VB_DEKATHERMS                                        
                  ,VB_DEKATHERMS_PEAK                                   
                  ,OTHER_UNITS                                          
                  ,OTHER_UNITS_PEAK                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-W-RETURN-CODE                                     
                  ,:S-W-APPL-RETURN-CODE                                
                  ,:S-W-CODE-UTIL-TYPE                                  
                  ,:S-W-IC-NO                                           
                  ,:S-W-BILL-NO                                         
                  ,:S-W-BILL-ITEM-TIMESTMP                              
                  ,:S-W-DATE-BILLED                                     
                  ,:S-W-CODE-BILL-TYPE                                  
                  ,:S-W-REVENUE-MONTH                                   
                  ,:S-W-AMT-BILL-ITEM                                   
                  ,:S-W-PRTY-SVC-CAT-CD                                 
                  ,:S-W-RATE-PLAN-NO                                    
                  ,:S-W-RATE-DESC                                       
                  ,:S-W-MT-MCF                                          
                  ,:S-W-MT-MCF-PEAK                                     
                  ,:S-W-MT-DEKATHERMS                                   
                  ,:S-W-MT-DEKATHERMS-PEAK                              
                  ,:S-W-VB-MCF                                          
                  ,:S-W-VB-MCF-PEAK                                     
                  ,:S-W-VB-DEKATHERMS                                   
                  ,:S-W-VB-DEKATHERMS-PEAK                              
                  ,:S-W-OTHER-UNITS                                     
                  ,:S-W-OTHER-UNITS-PEAK                                
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04892_WORK                                 
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,IC_NO                                                        
MFA-TR*           ,BILL_NO                                                      
MFA-TR*           ,BILL_ITEM_TIMESTMP                                           
MFA-TR*           ,DATE_BILLED                                                  
MFA-TR*           ,CODE_BILL_TYPE                                               
MFA-TR*           ,REVENUE_MONTH                                                
MFA-TR*           ,AMT_BILL_ITEM                                                
MFA-TR*           ,PRTY_SVC_CAT_CD                                              
MFA-TR*           ,RATE_PLAN_NO                                                 
MFA-TR*           ,RATE_DESC                                                    
MFA-TR*           ,MT_MCF                                                       
MFA-TR*           ,MT_MCF_PEAK                                                  
MFA-TR*           ,MT_DEKATHERMS                                                
MFA-TR*           ,MT_DEKATHERMS_PEAK                                           
MFA-TR*           ,VB_MCF                                                       
MFA-TR*           ,VB_MCF_PEAK                                                  
MFA-TR*           ,VB_DEKATHERMS                                                
MFA-TR*           ,VB_DEKATHERMS_PEAK                                           
MFA-TR*           ,OTHER_UNITS                                                  
MFA-TR*           ,OTHER_UNITS_PEAK                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-W-RETURN-CODE                                             
MFA-TR*           ,:S-W-APPL-RETURN-CODE                                        
MFA-TR*           ,:S-W-CODE-UTIL-TYPE                                          
MFA-TR*           ,:S-W-IC-NO                                                   
MFA-TR*           ,:S-W-BILL-NO                                                 
MFA-TR*           ,:S-W-BILL-ITEM-TIMESTMP                                      
MFA-TR*           ,:S-W-DATE-BILLED                                             
MFA-TR*           ,:S-W-CODE-BILL-TYPE                                          
MFA-TR*           ,:S-W-REVENUE-MONTH                                           
MFA-TR*           ,:S-W-AMT-BILL-ITEM                                           
MFA-TR*           ,:S-W-PRTY-SVC-CAT-CD                                         
MFA-TR*           ,:S-W-RATE-PLAN-NO                                            
MFA-TR*           ,:S-W-RATE-DESC                                               
MFA-TR*           ,:S-W-MT-MCF                                                  
MFA-TR*           ,:S-W-MT-MCF-PEAK                                             
MFA-TR*           ,:S-W-MT-DEKATHERMS                                           
MFA-TR*           ,:S-W-MT-DEKATHERMS-PEAK                                      
MFA-TR*           ,:S-W-VB-MCF                                                  
MFA-TR*           ,:S-W-VB-MCF-PEAK                                             
MFA-TR*           ,:S-W-VB-DEKATHERMS                                           
MFA-TR*           ,:S-W-VB-DEKATHERMS-PEAK                                      
MFA-TR*           ,:S-W-OTHER-UNITS                                             
MFA-TR*           ,:S-W-OTHER-UNITS-PEAK                                        
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1                          TO CTR-ROWS-WORK           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8100B'                   TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04892_WORK'           TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE LINK-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
           END-IF.                                                      
      *                                                                         
        8100B-EXIT.                                                     
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** INSERT SUMMARY RESULT SET USING WORK TABLE                   **        
      ******************************************************************        
      *                                                                         
       8200-INSERT-RESULT-SUMMARY.                                      
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO #CSR04892_SUMMARY                      
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,CODE_UTIL_TYPE                                       
                  ,IC_NO                                                
                  ,PRTY_SVC_CAT_CD                                      
                  ,RATE_PLAN_NO                                         
                  ,RATE_DESC                                            
                  ,DATE_BILLED                                          
                  ,REVENUE_MONTH                                        
                  ,MT_MCF                                               
                  ,MT_MCF_PEAK                                          
                  ,MT_DEKATHERMS                                        
                  ,MT_DEKATHERMS_PEAK                                   
                  ,VB_MCF                                               
                  ,VB_MCF_PEAK                                          
                  ,VB_DEKATHERMS                                        
                  ,VB_DEKATHERMS_PEAK                                   
                  ,OTHER_UNITS                                          
                  ,OTHER_UNITS_PEAK                                     
                  ,AMT_BILL_ITEM                                        
                 )                                                      
                 SELECT TOP(100) RETURN_CODE,
              APPL_RETURN_CODE,
              CODE_UTIL_TYPE,
              IC_NO,
              PRTY_SVC_CAT_CD,
              RATE_PLAN_NO,
              RATE_DESC,
              MAX(DATE_BILLED),
              REVENUE_MONTH,
              SUM(MT_MCF),
              MAX(MT_MCF_PEAK),
              SUM(MT_DEKATHERMS),
              MAX(MT_DEKATHERMS_PEAK),
              SUM(VB_MCF),
              MAX(VB_MCF_PEAK),
              SUM(VB_DEKATHERMS),
              MAX(VB_DEKATHERMS_PEAK),
              SUM(OTHER_UNITS),
              MAX(OTHER_UNITS_PEAK),
              SUM(AMT_BILL_ITEM)                             
                   FROM  #CSR04892_WORK                          
                 GROUP BY RETURN_CODE, APPL_RETURN_CODE,                
                          CODE_UTIL_TYPE, IC_NO, PRTY_SVC_CAT_CD,       
                          RATE_PLAN_NO, RATE_DESC, REVENUE_MONTH,       
                          CODE_BILL_TYPE                                
                 ORDER BY CODE_UTIL_TYPE, IC_NO, REVENUE_MONTH DESC,    
                          CODE_BILL_TYPE DESC                           
WEBFIX                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04892_SUMMARY                              
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,IC_NO                                                        
MFA-TR*           ,PRTY_SVC_CAT_CD                                              
MFA-TR*           ,RATE_PLAN_NO                                                 
MFA-TR*           ,RATE_DESC                                                    
MFA-TR*           ,DATE_BILLED                                                  
MFA-TR*           ,REVENUE_MONTH                                                
MFA-TR*           ,MT_MCF                                                       
MFA-TR*           ,MT_MCF_PEAK                                                  
MFA-TR*           ,MT_DEKATHERMS                                                
MFA-TR*           ,MT_DEKATHERMS_PEAK                                           
MFA-TR*           ,VB_MCF                                                       
MFA-TR*           ,VB_MCF_PEAK                                                  
MFA-TR*           ,VB_DEKATHERMS                                                
MFA-TR*           ,VB_DEKATHERMS_PEAK                                           
MFA-TR*           ,OTHER_UNITS                                                  
MFA-TR*           ,OTHER_UNITS_PEAK                                             
MFA-TR*           ,AMT_BILL_ITEM                                                
MFA-TR*          )                                                              
MFA-TR*          SELECT  RETURN_CODE                                            
MFA-TR*                 ,APPL_RETURN_CODE                                       
MFA-TR*                 ,CODE_UTIL_TYPE                                         
MFA-TR*                 ,IC_NO                                                  
MFA-TR*                 ,PRTY_SVC_CAT_CD                                        
MFA-TR*                 ,RATE_PLAN_NO                                           
MFA-TR*                 ,RATE_DESC                                              
MFA-TR*                 ,MAX(DATE_BILLED)                                       
MFA-TR*                 ,REVENUE_MONTH                                          
MFA-TR*                 ,SUM(MT_MCF)                                            
MFA-TR*                 ,MAX(MT_MCF_PEAK)                                       
MFA-TR*                 ,SUM(MT_DEKATHERMS)                                     
MFA-TR*                 ,MAX(MT_DEKATHERMS_PEAK)                                
MFA-TR*                 ,SUM(VB_MCF)                                            
MFA-TR*                 ,MAX(VB_MCF_PEAK)                                       
MFA-TR*                 ,SUM(VB_DEKATHERMS)                                     
MFA-TR*                 ,MAX(VB_DEKATHERMS_PEAK)                                
MFA-TR*                 ,SUM(OTHER_UNITS)                                       
MFA-TR*                 ,MAX(OTHER_UNITS_PEAK)                                  
MFA-TR*                 ,SUM(AMT_BILL_ITEM)                                     
MFA-TR*            FROM  SESSION.CSR04892_WORK                                  
MFA-TR*          GROUP BY RETURN_CODE, APPL_RETURN_CODE,                        
MFA-TR*                   CODE_UTIL_TYPE, IC_NO, PRTY_SVC_CAT_CD,               
MFA-TR*                   RATE_PLAN_NO, RATE_DESC, REVENUE_MONTH,               
MFA-TR*                   CODE_BILL_TYPE                                        
MFA-TR*          ORDER BY CODE_UTIL_TYPE, IC_NO, REVENUE_MONTH DESC,            
MFA-TR*                   CODE_BILL_TYPE DESC                                   
MFA-TR*          FETCH FIRST 100 ROWS ONLY                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE CTR-ROWS-WORK             TO CTR-ROWS-SUMMARY        
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04892_SUMMARY'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE LINK-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
           END-IF.                                                      
      *                                                                         
        8200-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** 8900-SEND-DONE                                               **        
      ******************************************************************        
      *                                                                         
       8900-SEND-DONE.                                                  
      *                                                                         
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 9000-SEND-ERROR-RESULT                                       **        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'          TO ABEND-FUNCTION                
           END-IF.                                                      
      *                                                                         
           INITIALIZE                     GTT-RETURN-FIELDS.            
      *                                                                         
           MOVE WS-ACTIVE-RETURN-CODE  TO S-RETURN-CODE.                
      *                                                                         
           PERFORM 0100A-DECLARE-GTT-SUMMARY  THRU  0100A-EXIT.         
      *                                                                         
           PERFORM 8100A-SEND-RESULT-SUMMARY  THRU  8100A-EXIT.         
      *                                                                         
           PERFORM 9900-SQL-ERROR-ROUTINE     THRU  9900-EXIT.          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 9900-SQL-ERROR-ROUTINE                                       **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      ** 9999-END-PROGRAM                                             **        
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
      *                                                                         
           PERFORM 8900-SEND-DONE  THRU  8900-EXIT.                     
      *                                                                         
           
MSQ016        GOBACK.                                                    
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
