       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04890.                                         
       AUTHOR.        AARON ABRAHAM.                                    
COB303 DATE-WRITTEN.  JAN 08, 2016.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      ******************************************************************        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE UPDATES REFUND AND ADDRESS INFORMATIONS FOR    *        
      *  MAINTENANCE VIEW.                                             *        
      *                                                                *        
      *  BusOp : RequUpdAcctRefund (Accounts Receivable Solution)      *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00870*  01/08/16  AA97148    INITIAL IMPLEMENTATION.                  *        
P00870*  02/11/16  AA97148    CHANGE CSR02294 INTO DYNAMIC CALL        *        
P00870*  03/11/16  AA97148    STOP UPDATE COMMENTS TO CSS_REFUND TABLE *        
P0087A*  01/17/17  WR19680    ADDING CALL TO CSR02171 TO PROCESS A     *        
P0087A*                       DEPOSIT REFUND GOING FROM 'R' TO 'A'     *        
P0087A*  02/01/17  WR19680    FIXING ISSUE WITH ADDRESS IN U.I. CITY   *        
P0087A*                       AND STATE NOT POPULATING CORRECTLY FOR   *        
P0087A*                       FREEFORM ADDRESS                         *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04890'.
MSQ017     COPY MFASQLM.
                                                                        
       01 WS-START                                   PIC X(40) VALUE    
          'WORKING STORAGE FOR CSR04890 STARTS HERE'.                   
                                                                        
       01 WS-MISC.                                                      
          05  PROGRAM-NAME                PIC X(08)  VALUE 'CSR04890'.  
          05  WS-PGRMNAME                 PIC X(08)  VALUE 'CSR04890'.  
P00870    05  CSR02294                    PIC X(08)  VALUE 'CSR02294'.  
P0087A    05  CSR02171                    PIC X(08)  VALUE 'CSR02171'.  
          05  WS-CURRENT-DATE             PIC X(10)  VALUE SPACES.      
          05  WS-CURRENT-TIMESTAMP        PIC X(26)  VALUE SPACES.      
          05  WS-RESP-AREA-ID             PIC X(03)  VALUE SPACES.      
          05  WS-REFUND-EXISTS            PIC S9(04) COMP  VALUE 0.     
          05  RS-RETURN-CODE              PIC S9(09) COMP  VALUE 0.     
          05  WS-AMT-REFUNDED             PIC 9(09)V9(2)   VALUE 0.     
          05  WS-AMT-REFUNDED-N  REDEFINES                              
              WS-AMT-REFUNDED             PIC 9(11).                    
          05  WS-CHECK-CURR-STATUS-CD     PIC X(02)  VALUE SPACES.      
          05  WS-CHECK-PREV-STATUS-CD     PIC X(02)  VALUE SPACES.      
          05  WS-REQ-EXISTS               PIC X(01)  VALUE 'N'.         
          05  WS-REFUND-ITEM-ID           PIC S9(9)  USAGE COMP.        
          05  WS-MANUAL-INDICATOR         PIC X(01)  VALUE SPACES.      
          05  WS-PREV-TRANS-HIST-SEQ-NO   PIC X(26)  VALUE SPACES.      
          05  MCSCB225                    PIC X(8)   VALUE 'MCSCB225'.  
          05  MCSCB224                    PIC X(8)   VALUE 'MCSCB224'.  
          05  MCSCB077                    PIC X(08)  VALUE 'MCSCB077'.  
          05  WS-ZIP-CODE-PLUS-FOUR       PIC X(04)  VALUE SPACES.      
                                                                        
       01 WS-REFUND-DTLS.                                               
          05  WS-ACTION-CODE              PIC X(01)  VALUE SPACES.      
          05  WS-ACCOUNT-NO               PIC S9(13)V COMP-3 VALUE 0.   
          05  WS-ITEM-ID                  PIC S9(09) COMP VALUE 0.      
          05  WS-USER-ID                  PIC X(07)  VALUE SPACES.      
          05  WS-DATE-REQUESTED           PIC X(10)  VALUE SPACES.      
          05  WS-RETURN-REASON            PIC X(01)  VALUE SPACES.      
          05  WS-COMMENTS-TEXT            PIC X(72)  VALUE SPACES.      
          05  WS-COMMENTS-LEN             PIC S9(04) COMP VALUE 0.      
          05  WS-CHECK-ISS-REAS-CODE      PIC X(02)  VALUE SPACES.      
          05  WS-CHECK-STATUS-CD          PIC X(01)  VALUE SPACES.      
          05  WS-DATE-ESCH-VERIFIED       PIC X(10)  VALUE SPACES.      
          05  WS-DATE-RETURNED            PIC X(10)  VALUE SPACES.      
          05  WS-ADDRESS-CHANGED-FL       PIC X(01)  VALUE SPACES.      
          05  WS-TRANS-COMMENTS-TEXT      PIC X(210) VALUE SPACES.      
          05  WS-TRANS-COMMENTS-LEN       PIC S9(04) COMP VALUE 0.      
          05  WS-TRANS-HIST-SEQ-NO        PIC X(26)  VALUE SPACES.      
          05  WS-ESCHEATMENT-CD           PIC X(01)  VALUE SPACES.      
          05  WS-DATE-CLEARED             PIC X(10)  VALUE SPACES.      
          05  WS-REFUND-CHECK-NO          PIC X(09)  VALUE SPACES.      
          05  WS-AT-LAST-UPD-TS           PIC X(26)  VALUE SPACES.      
          05  WS-ACCOUNT-NO-COMP3         PIC S9(13)V COMP-3 VALUE 0.   
          05  WS-TOTAL-ORIG-AMT           PIC S9(9)V99  COMP-3 VALUE 0. 
          05  WS-REFUND-DTLS-FLAG         PIC X(01)  VALUE SPACES.      
          05  WS-CIA-ITEM-ID              PIC X(09).                    
          05  WS-CIA-ITEM-ID-NUM  REDEFINES WS-CIA-ITEM-ID              
                                          PIC 9(09).                    
       01 WS-CRED-BAL-JRNL.                                             
           05 WS-RFND-CHECK-AMT          PIC S9(09)V99 COMP-3 VALUE 0.  
           05 WS-RFND-CASH-AMT           PIC S9(09)V99 COMP-3 VALUE 0.  
           05 WS-REFUND-AMT              PIC S9(9)V99  COMP-3 VALUE 0.  
           05 WS-RECVBL-RFND-AMT         PIC S9(09)V99 COMP-3 VALUE 0.  
           05 WS-RFND-AMT-NUM            PIC S9(09)V99 COMP-3 VALUE 0.  
           05 WS-AMOUNT-DIFF             PIC S9(9)V99  COMP-3 VALUE 0.  
           05 WS-SUMM-BAL-NEGV           PIC X(01)     VALUE 'F'.       
           05 WS-SUMM-FLAG               PIC X(03)     VALUE SPACES.    
           05 WS-AC-SUMM-UNUSED-CR       PIC S9(9)V99  COMP-3 VALUE 0.  
           05 WS-AC-SUMM-ITEM-ID         PIC S9(9) USAGE COMP VALUE 0.  
           05 WS-END-OF-PROCESS          PIC X(1)       VALUE 'F'.      
           05 WS-CREDIT-BAL-LESS-RET-CODE PIC S9(9)    COMP VALUE  -051.
           05 WS-ADD-STR.                                               
              10 F                       PIC X(03) VALUE 'AR-'.         
              10 WS-ADD-RECVBL           PIC X(03).                     
                                                                        
       01 COUNTER-FIELDS.                                               
          05  CTR-ROWS                    PIC S9(9)  COMP VALUE 0.      
                                                                        
       01 FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.       
                                                                        
       01 SWITCHES.                                                     
          05  SEND-DONE-SW                PIC X(01)  VALUE 'Y'.         
              88 SEND-DONE-ERROR                     VALUE 'N'.         
              88 SEND-DONE-OK                        VALUE 'Y'.         
          05  WS-VALID-RATE-FL            PIC X(01).                    
              88 VALID-RATE                          VALUE 'Y'.         
              88 NOT-VALID-RATE                      VALUE 'N'.         
          05  WS-UTIL-ACCOUNT             PIC X(01).                    
              88 UTIL-EXISTS                         VALUE 'Y'.         
              88 NO-UTIL-EXISTS                      VALUE 'N'.         
          05  WS-DATABASE-COG             PIC 9(01)  VALUE ZERO.        
              88 CSR-DATABASE-COG                    VALUE 1.           
              88 SEB-DATABASE-COG                    VALUE 2.           
       01 GTT-RETURN-FIELDS.                                            
          05  S-RETURN-CODE               PIC S9(09) COMP VALUE 0.      
          05  S-APPL-RETURN-CODE          PIC X(10)  VALUE SPACES.      
                                                                        
       01 WS-NULL-INDICATORS.                                           
          05 WS-NULL-DATE-REFUND          PIC S9(04) COMP VALUE 0.      
          05 WS-NULL-DATE-REQUEST         PIC S9(04) COMP VALUE 0.      
          05 WS-NULL-DATE-CANCELLED       PIC S9(04) COMP VALUE 0.      
          05 WS-NULL-DATE-CHECK-VOID      PIC S9(04) COMP VALUE 0.      
          05 WS-NULL-DATE-STOP-REQ        PIC S9(04) COMP VALUE 0.      
          05 WS-NULL-DATE-STOP-CONF       PIC S9(04) COMP VALUE 0.      
          05 WS-NULL-DATE-CHK-REMAIL      PIC S9(04) COMP VALUE 0.      
          05 WS-NULL-DATE-REISSUED        PIC S9(04) COMP VALUE 0.      
          05 WS-NULL-DATE-RETURNED        PIC S9(04) COMP VALUE 0.      
          05 WS-NULL-DATE-APPROP          PIC S9(04) COMP VALUE 0.      
          05 WS-NULL-DATE-ESCHEATED       PIC S9(04) COMP VALUE 0.      
          05 WS-NULL-DATE-ESCH-VERIFIED   PIC S9(04) COMP VALUE 0.      
          05 WS-NULL-DATE-ESCH-RETURNED   PIC S9(04) COMP VALUE 0.      
          05 WS-NULL-DATE-CLEARED         PIC S9(04) COMP VALUE 0.      
          05 WS-DATE-REFUNDED-NULL        PIC S9(04) COMP VALUE 0.      
          05 WS-REQUEST-DT-NULL           PIC S9(04) COMP VALUE 0.      
          05 WS-REFUND-STATUS-DT-NULL     PIC S9(04) COMP VALUE 0.      
          05 WS-AR-NULL-IND-1             PIC S9(04) COMP VALUE 0.      
          05 WS-AR-NULL-IND-2             PIC S9(04) COMP VALUE 0.      
          05 WS-AR-NULL-IND-3             PIC S9(04) COMP VALUE 0.      
                                                                        
      * CSR02294 INPUT AREA                                                     
       01 WS-CSR02294-INPUT-AREA.                                       
          05 WS-2294-ACCOUNT-NO           PIC X(13) VALUE SPACE.        
          05 WS-2294-ITEM-ID              PIC S9(09) COMP  VALUE 0.     
          05 WS-2294-RECV-TYPE            PIC X(03) VALUE SPACE.        
          05 WS-2294-PYMT-PRIORITY-LVL    PIC S9(4) COMP VALUE 0.       
          05 WS-2294-GL-ACCT-NO           PIC X(07) VALUE SPACE.        
          05 WS-2294-CR-AMT-DAY-00        PIC X(11) VALUE SPACES.       
          05 WS-2294-CR-AMT-DAY-30        PIC X(11) VALUE SPACES.       
          05 WS-2294-CR-AMT-DAY-60        PIC X(11) VALUE SPACES.       
          05 WS-2294-CR-AMT-DAY-90        PIC X(11) VALUE SPACES.       
          05 WS-2294-CR-AMT-TOTAL         PIC X(11) VALUE SPACES.       
          05 WS-2294-DIST-AR-TYPE-SHORT   PIC X(03) VALUE SPACE.        
          05 WS-2294-DIST-PYMT-PRI-LVL    PIC S9(4) COMP VALUE 0.       
          05 WS-2294-DIST-ITEM-ID         PIC S9(9) COMP VALUE 0.       
          05 WS-2294-RESP-AREA-ID         PIC X(03) VALUE SPACE.        
          05 WS-2294-USER-ID              PIC X(07) VALUE SPACE.        
          05 WS-2294-AT-LAST-UPDATE-TS    PIC X(26) VALUE SPACE.        
          05 WS-2294-AC-LAST-UPDATE-TS    PIC X(26) VALUE SPACE.        
          05 WS-2294-TRANS-LEN            PIC S9(4) COMP SYNC VALUE +0. 
          05 WS-2294-TRANS-COMMENTS       PIC X(210)    VALUE SPACES.   
          05 WS-2294-PRINCIPAL            PIC X(11) VALUE SPACES.       
          05 WS-2294-STATE-TAX            PIC X(11) VALUE SPACES.       
          05 WS-2294-CITY-TAX             PIC X(11) VALUE SPACES.       
          05 WS-2294-OTHER-TAX            PIC X(11) VALUE SPACES.       
          05 WS-2294-DEF-INT              PIC X(11) VALUE SPACES.       
          05 WS-2294-EARNED-INT           PIC X(11) VALUE SPACES.       
          05 WS-2294-CNT-NAME-CD          PIC S9(04) COMP VALUE 0.      
          05 WS-2294-REVENUE-MONTH        PIC X(06)     VALUE SPACE.    
      * CSR02294 RETURN AREA                                                    
       01 WS-CSR02294-RET-AREA.                                         
          05 WS-2294-RETURN-CODE          PIC S9(09) COMP VALUE +0.     
          05 WS-2294-CANCELDNP-FLAG       PIC X(01) VALUE SPACES.       
          05 WS-2294-AR-LOCKOUT-IND       PIC X(01) VALUE SPACES.       
          05 WS-2294-AT-ACCT-XFER-TO      PIC X(13) VALUE SPACES.       
          05 WS-2294-CANCELNOT-FLAG       PIC X(01) VALUE SPACES.       
      * RESULT SET LOCATOR                                                      
      *01 LOC1 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.            
                                                                        
P0087A* CSR02171 INPUT AREA                                                     
P0087A 01 WS-CSR02171-INPUT-AREA.                                       
P0087A    05 WS-2171-ACTION-CODE        PIC X(01).                      
P0087A    05 WS-2171-ACCOUNT-NO         PIC X(13).                      
P0087A    05 WS-2171-PREMISE-NO         PIC X(10).                      
P0087A    05 WS-2171-SERVICE-TYPE-CD    PIC X(01).                      
P0087A    05 WS-2171-DEPOSIT-CERT-NO    PIC X(09).                      
P0087A    05 WS-2171-CODE-REFUND-REASON PIC X(01).                      
P0087A    05 WS-2171-CHECK-ISS-REAS-CD  PIC X(02).                      
P0087A    05 WS-2171-CMNTS-LEN          PIC S9(04) COMP.                
P0087A    05 WS-2171-CMNTS-TEXT         PIC X(72).                      
P0087A    05 WS-2171-BALANCE-AMT        PIC X(11).                      
P0087A    05 WS-2171-THIS-CR-AMT        PIC X(11).                      
P0087A    05 WS-2171-THIS-AR-TYPE       PIC X(04).                      
P0087A    05 WS-2171-THIS-ITEM-ID       PIC X(09).                      
P0087A    05 WS-2171-SPEC-ACCOUNT-NO    PIC X(13).                      
P0087A    05 WS-2171-SPEC-CR-AMT        PIC X(11).                      
P0087A    05 WS-2171-SPEC-AR-TYPE       PIC X(04).                      
P0087A    05 WS-2171-SPEC-ITEM-ID       PIC X(09).                      
P0087A    05 WS-2171-AMT-CHK            PIC X(11).                      
P0087A    05 WS-2171-AMT-CASH           PIC X(11).                      
P0087A    05 WS-2171-CASHIER-CODE       PIC X(02).                      
P0087A    05 WS-2171-ADDRESS-CHANGED    PIC X(01).                      
P0087A    05 WS-2171-ADDR-STREET        PIC X(55).                      
P0087A    05 WS-2171-ADDR-CITY-STATE    PIC X(30).                      
P0087A    05 WS-2171-ADDR-ZIP-CODE      PIC X(09).                      
P0087A    05 WS-2171-ADDR-COUNTRY       PIC X(35).                      
P0087A    05 WS-2171-ADDRESS-OVERFLOW   PIC X(35).                      
P0087A    05 WS-2171-SUPERVISOR-ID      PIC X(09).                      
P0087A    05 WS-2171-APPROVE-IND        PIC X(01).                      
P0087A    05 WS-2171-CD-COMPANY-NO      PIC X(02).                      
P0087A    05 WS-2171-CD-LOCAL-OFFICE    PIC X(03).                      
P0087A    05 WS-2171-CD-REPORT-DATE     PIC X(10).                      
P0087A    05 WS-2171-CD-REPORT-NO       PIC X(03).                      
P0087A    05 WS-2171-CASH-DRAWER-ID     PIC X(04).                      
P0087A    05 WS-2171-USER-ID            PIC X(09).                      
P0087A    05 WS-2171-RESP-AREA-ID       PIC X(03).                      
P0087A    05 WS-2171-TRAN-CMNT-LEN      PIC S9(04) COMP.                
P0087A    05 WS-2171-TRAN-CMNT-TEXT     PIC X(210).                     
P0087A    05 WS-2171-CSR-PC-ID          PIC X(04).                      
P0087A    05 WS-2171-REFUND-TYPE        PIC X(01).                      
P0087A    05 WS-2171-INTEREST-AMOUNT    PIC X(11).                      
P0087A    05 WS-2171-SUPERUSER-CD       PIC X(01).                      
P0087A    05 WS-2171-APPROVE-CHK-IND    PIC X(01).                      
P0087A    05 WS-2171-LAST-UPDATE-TS     PIC X(26).                      
P0087A    05 WS-2171-REQUEST-DATE       PIC X(10).                      
P0087A* CSR02171 RETURN AREA                                                    
P0087A 01 WS-CSR02171-RET-AREA.                                         
P0087A    05  WS-2171-RETURN-CODE       PIC S9(9) COMP VALUE 0.         
P0087A    05  WS-2171-ERROR-MESSAGE-NO  PIC X(05) VALUE SPACES.         
P0087A    05  WS-2171-CANCELDNP-FLAG    PIC X(01) VALUE SPACES.         
P0087A    05  WS-2171-CANCELDNP-TO-FLAG PIC X(01) VALUE SPACES.         
P0087A    05  WS-2171-CANCELNOT-FLAG    PIC X(01) VALUE SPACES.         
P0087A    05  WS-2171-CANCELNOT-TO-FLAG PIC X(01) VALUE SPACES.         
      *                                                                         
      ******************************************************************00880000
      *    DB2 INCLUDES                                                *00890000
      ******************************************************************00900000
                                                                        
           EXEC SQL                                                     00920000
              INCLUDE SQLCA                                             00930000
           END-EXEC.                                                    00940000
                                                                        
      ******************************************************************        
      * CSS_ACCOUNT        - AT                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_AR_CNTL           - AC                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01640000
              INCLUDE TBARCNTL                                          01650000
           END-EXEC.                                                    01660000
                                                                        
      ******************************************************************        
      * CSS_AR_LOCKOUT     - AL                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBARLOCK                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_AR_TRN_HST_DET    - AU                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01080000
              INCLUDE TBARHDT                                           01090000
           END-EXEC.                                                    01100000
                                                                        
      ******************************************************************        
      * CSS_AR_TRANS_HIST     - AR                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01040000
              INCLUDE TBARHIST                                          01050000
           END-EXEC.                                                    01060000
                                                                        
      ******************************************************************        
      * CSS_ADDR_FORMATTED - DY                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_ADDR_FREEFORM  - DZ                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_BATCH_JRNL     - BJ                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBTJRNL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_BUDGET_HIST    - BH                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBGTHST                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_BUDGET_PLAN    - BU                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBGTPLN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CSH_DRWR_JRNL  - CJ                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCDJRNL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CRED_COLL      - CL                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCRCOLL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CSH_DRWR_CNTL  - CS                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCDCNTL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_MISC_JRNL      - MJ                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMSJRNL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CUSTOMER       - CU                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CHRG_OFF       - CO                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCHGOFF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CSH_DRWR_CNTL  - CS                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBJCNTL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CONNECT_CHRG   - CC                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCCCHRG                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CONTRACT       - CT                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCNTRCT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CNT_DETAIL     - EA                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCNTDET                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_GL_ACCT_NO        - GO                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01440000
               INCLUDE TBGLATNO                                         01450000
           END-EXEC.                                                    01460000
                                                                        
      ******************************************************************        
      * CSS_DEP_ON_HAND       - DO                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01720000
              INCLUDE TBDEPHND                                          01730000
           END-EXEC.                                                    01740000
                                                                        
      ******************************************************************        
      * CSS_DELINQUENCY       - DQ                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01720000
              INCLUDE TBDELQ                                            01730000
           END-EXEC.                                                    01740000
                                                                        
      ******************************************************************        
      * CSS_DEP_PAY_HST       - DP                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01720000
              INCLUDE TBDEPHST                                          01730000
           END-EXEC.                                                    01740000
                                                                        
      ******************************************************************        
      * CSS_DEP_REQ           - DR                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01720000
              INCLUDE TBDEPREQ                                          01730000
           END-EXEC.                                                    01740000
                                                                        
      ******************************************************************        
      * CSS_DFA_ACCT          - DA                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01720000
              INCLUDE TBDFAACT                                          01730000
           END-EXEC.                                                    01740000
                                                                        
      ******************************************************************        
      * CSS_DFA_RECVBLE       - DV                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01720000
              INCLUDE TBDFARCV                                          01730000
           END-EXEC.                                                    01740000
                                                                        
      ******************************************************************        
      * CSS_FINAL_WO          - FW                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01720000
              INCLUDE TBFINLWO                                          01730000
           END-EXEC.                                                    01740000
                                                                        
      ******************************************************************        
      * CSS_JOB_PARM       - G6                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_LOCAL_OFFICE   - B1                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBLOCOFC                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_PREMISE           - PR                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01720000
              INCLUDE TBPREM                                            01730000
           END-EXEC.                                                    01740000
                                                                        
      ******************************************************************        
      * CSS_PROJ_SHARE        - PJ                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01720000
              INCLUDE TBPRJSHR                                          01730000
           END-EXEC.                                                    01740000
                                                                        
      ******************************************************************        
      * CSS_REFUND            - RN                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBREFUND                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_ADDR_ID_CNTL   - I8                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01230000
              INCLUDE TBADDRID                                          01240000
           END-EXEC.                                                    01250000
                                                                        
      ******************************************************************        
      * CSS_MT_TRN_HST_DET - MI                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01290000
              INCLUDE TBMNHDT                                           01300000
           END-EXEC.                                                    01310000
                                                                        
      ******************************************************************        
      * CSS_MNT_TRANS_HIST - MH                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_USER_PROFILE   - PF                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_UTIL_ENVRNMT   - UT                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_ZIP_CODE       - A4                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 00289904
      * ERROR HANDLING.                                               *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                            *01480000
      ******************************************************************        
                                                                        
           COPY CWS00303.                                               01490000
                                                                        
      *****************************************************************         
      *    WORKING STORAGE FOR CPD00071                                         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     01670000
              INCLUDE CWS00071                                          01680000
           END-EXEC.                                                    01690000
                                                                        
      *****************************************************************         
      *    WORKING STORAGE FOR CPD00116                                         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     01670000
              INCLUDE CWS0116A                                          01680000
           END-EXEC.                                                    01690000
                                                                        
      *****************************************************************         
      *    WORKING STORAGE FOR CPDKR363                                         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     01670000
              INCLUDE CWSKR363                                          01680000
           END-EXEC.                                                    01690000
                                                                        
      *****************************************************************         
      *    CASH JOURNAL OF FORMAT 101                                           
      *****************************************************************         
                                                                        
           EXEC SQL                                                     01670000
              INCLUDE CJF00101                                          01680000
           END-EXEC.                                                    01690000
                                                                        
      *****************************************************************         
      *    WORKING STORAGE LAYOUT FOR DATA PRESENT CODES                        
      *****************************************************************         
                                                                        
           EXEC SQL                                                     01670000
              INCLUDE CWS00056                                          01680000
           END-EXEC.                                                    01690000
                                                                        
      *****************************************************************         
      *    WORKING STORAGE VARIABLES FOR GENERAL LEDGER                         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     01670000
              INCLUDE CWS00061                                          01680000
           END-EXEC.                                                    01690000
                                                                        
      *****************************************************************         
      *    WORKING STORAGE VARIABLES FOR PAYMENT APPLICATION ROUTINE            
      *****************************************************************         
                                                                        
           EXEC SQL                                                     01670000
              INCLUDE CWS00017                                          01680000
           END-EXEC.                                                    01690000
                                                                        
      *****************************************************************         
      *    WORKING STORAGE FOR CPD00077                                         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     01710000
              INCLUDE CWS00077                                          01720000
           END-EXEC.                                                    01730000
                                                                        
      *****************************************************************         
      *    WORKING STORAGE FOR CPDCA225                                         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     01710000
              INCLUDE CWSCA225                                          01720000
           END-EXEC.                                                    01730000
                                                                        
      *****************************************************************         
      *    WORKING STORAGE FOR CPDCA224                                         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     01710000
              INCLUDE CWSCA224                                          01720000
           END-EXEC.                                                    01730000
                                                                        
      *****************************************************************         
      *    WORKING STORAGE FOR CPD0013B                                         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     01710000
              INCLUDE CWS0013B                                          01720000
           END-EXEC.                                                    01730000
                                                                        
      *****************************************************************         
      *    WORKING STORAGE FOR CPD0090A                                         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     01710000
              INCLUDE CWS0090A                                          01720000
           END-EXEC.                                                    01730000
MSQ001        EXEC SQL
MSQ001          DECLARE REFUND CURSOR
MSQ001          FOR CALL CSR02294                                       
                       ( :WS-2294-ACCOUNT-NO
                  , :WS-2294-ITEM-ID
                  , :WS-2294-RECV-TYPE
                  , :WS-2294-PYMT-PRIORITY-LVL
                  , :WS-2294-GL-ACCT-NO
                  , :WS-2294-CR-AMT-DAY-00
                  , :WS-2294-CR-AMT-DAY-30
                  , :WS-2294-CR-AMT-DAY-60
                  , :WS-2294-CR-AMT-DAY-90
                  , :WS-2294-CR-AMT-TOTAL
                  , :WS-2294-DIST-AR-TYPE-SHORT
                  , :WS-2294-DIST-PYMT-PRI-LVL
                  , :WS-2294-DIST-ITEM-ID
                  , :WS-2294-RESP-AREA-ID
                  , :WS-2294-USER-ID
                  , :WS-2294-AT-LAST-UPDATE-TS
                  , :WS-2294-AC-LAST-UPDATE-TS
                  , :WS-2294-TRANS-LEN
                  , :WS-2294-TRANS-COMMENTS
                  , :WS-2294-PRINCIPAL
                  , :WS-2294-STATE-TAX
                  , :WS-2294-CITY-TAX
                  , :WS-2294-OTHER-TAX
                  , :WS-2294-DEF-INT
                  , :WS-2294-EARNED-INT
                  , :WS-2294-CNT-NAME-CD
                  , :WS-2294-REVENUE-MONTH
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE DEPOSIT CURSOR
MSQ001          FOR CALL CSR02171                                       
P0087A                 ( :WS-2171-ACTION-CODE
                  , :WS-2171-ACCOUNT-NO
                  , :WS-2171-PREMISE-NO
                  , :WS-2171-SERVICE-TYPE-CD
                  , :WS-2171-DEPOSIT-CERT-NO
                  , :WS-2171-CODE-REFUND-REASON
                  , :WS-2171-CHECK-ISS-REAS-CD
                  , :WS-2171-CMNTS-LEN
                  , :WS-2171-CMNTS-TEXT
                  , :WS-2171-BALANCE-AMT
                  , :WS-2171-THIS-CR-AMT
                  , :WS-2171-THIS-AR-TYPE
                  , :WS-2171-THIS-ITEM-ID
                  , :WS-2171-SPEC-ACCOUNT-NO
                  , :WS-2171-SPEC-CR-AMT
                  , :WS-2171-SPEC-AR-TYPE
                  , :WS-2171-SPEC-ITEM-ID
                  , :WS-2171-AMT-CHK
                  , :WS-2171-AMT-CASH
                  , :WS-2171-CASHIER-CODE
                  , :WS-2171-ADDRESS-CHANGED
                  , :WS-2171-ADDR-STREET
                  , :WS-2171-ADDR-CITY-STATE
                  , :WS-2171-ADDR-ZIP-CODE
                  , :WS-2171-ADDR-COUNTRY
                  , :WS-2171-ADDRESS-OVERFLOW
                  , :WS-2171-SUPERVISOR-ID
                  , :WS-2171-APPROVE-IND
                  , :WS-2171-CD-COMPANY-NO
                  , :WS-2171-CD-LOCAL-OFFICE
                  , :WS-2171-CD-REPORT-DATE
                  , :WS-2171-CD-REPORT-NO
                  , :WS-2171-CASH-DRAWER-ID
                  , :WS-2171-USER-ID
                  , :WS-2171-RESP-AREA-ID
                  , :WS-2171-TRAN-CMNT-LEN
                  , :WS-2171-TRAN-CMNT-TEXT
                  , :WS-2171-CSR-PC-ID
                  , :WS-2171-REFUND-TYPE
                  , :WS-2171-INTEREST-AMOUNT
                  , :WS-2171-SUPERUSER-CD
                  , :WS-2171-APPROVE-CHK-IND
                  , :WS-2171-LAST-UPDATE-TS
                  , :WS-2171-REQUEST-DATE
                  )
MSQ001        END-EXEC.
                    
                                                                        
       LINKAGE SECTION.                                                 
       01 PARM-ACTION-CODE                   PIC X(01) VALUE SPACES.    
       01 PARM-ACCOUNT-NO                    PIC S9(13)V COMP-3 VALUE 0.
       01 PARM-ITEM-ID                       PIC S9(09) COMP VALUE 0.   
       01 PARM-USER-ID                       PIC X(07) VALUE SPACES.    
       01 PARM-DATE-REQUESTED                PIC X(10) VALUE SPACES.    
       01 PARM-RETURN-REASON                 PIC X(01) VALUE SPACES.    
       01 PARM-COMMENTS-TEXT                 PIC X(72) VALUE SPACES.    
       01 PARM-COMMENTS-LEN                  PIC S9(04) COMP VALUE 0.   
       01 PARM-CHECK-ISS-REAS-CODE           PIC X(02) VALUE SPACES.    
       01 PARM-CHECK-STATUS-CD               PIC X(01) VALUE SPACES.    
       01 PARM-DATE-ESCH-VERIFIED            PIC X(10) VALUE SPACES.    
       01 PARM-DATE-RETURNED                 PIC X(10) VALUE SPACES.    
       01 PARM-ADDRESS-CHANGED-FL            PIC X(01) VALUE SPACES.    
       01 PARM-TRANS-COMMENTS-TEXT           PIC X(210) VALUE SPACES.   
       01 PARM-TRANS-COMMENTS-LEN            PIC S9(04) COMP VALUE 0.   
       01 PARM-TRANS-HIST-SEQ-NO             PIC X(26) VALUE SPACES.    
       01 PARM-ESCHEATMENT-CD                PIC X(01) VALUE SPACES.    
       01 PARM-DATE-CLEARED                  PIC X(10) VALUE SPACES.    
       01 PARM-REFUND-CHECK-NO               PIC X(09) VALUE SPACES.    
       01 PARM-AT-LAST-UPD-TS                PIC X(26) VALUE SPACES.    
       01 PARM-ADDRESS-FORMAT                PIC X(01) VALUE SPACES.    
       01 PARM-ADDRESS-ID                    PIC S9(13)V COMP-3 VALUE 0.
       01 PARM-FMT-HOUSE-NO                  PIC X(15) VALUE SPACES.    
       01 PARM-FMT-ADDR-PREFIX-1             PIC X(03) VALUE SPACES.    
       01 PARM-FMT-ADDR-PREFIX-2             PIC X(02) VALUE SPACES.    
       01 PARM-FMT-STREET-NAME               PIC X(30) VALUE SPACES.    
       01 PARM-FMT-STREET-SUFFIX             PIC X(04) VALUE SPACES.    
       01 PARM-FMT-ADDR-SUFFIX               PIC X(02) VALUE SPACES.    
       01 PARM-FMT-STREET-LOCATION-1         PIC X(04) VALUE SPACES.    
       01 PARM-FMT-STREET-LOCATION-2         PIC X(11) VALUE SPACES.    
       01 PARM-FF-ADDR-STREET                PIC X(55) VALUE SPACES.    
       01 PARM-FF-ADDRESS-OVERFLOW           PIC X(35) VALUE SPACES.    
       01 PARM-FF-ADDRESS-CITY-STATE         PIC X(30) VALUE SPACES.    
       01 PARM-CITY                          PIC X(26) VALUE SPACES.    
       01 PARM-STATE                         PIC X(02) VALUE SPACES.    
       01 PARM-ZIP-CODE                      PIC X(05) VALUE SPACES.    
       01 PARM-ZIP-CODE-PLUS-FOUR            PIC X(04) VALUE SPACES.    
WLR    01 PARM-COUNTRY                       PIC X(35) VALUE SPACES.    
                                                                        
       PROCEDURE DIVISION USING PARM-ACTION-CODE                        
                                PARM-ACCOUNT-NO                         
                                PARM-ITEM-ID                            
                                PARM-USER-ID                            
                                PARM-DATE-REQUESTED                     
                                PARM-RETURN-REASON                      
                                PARM-COMMENTS-TEXT                      
                                PARM-COMMENTS-LEN                       
                                PARM-CHECK-ISS-REAS-CODE                
                                PARM-CHECK-STATUS-CD                    
                                PARM-DATE-ESCH-VERIFIED                 
                                PARM-DATE-RETURNED                      
                                PARM-ADDRESS-CHANGED-FL                 
                                PARM-TRANS-COMMENTS-TEXT                
                                PARM-TRANS-COMMENTS-LEN                 
                                PARM-TRANS-HIST-SEQ-NO                  
                                PARM-ESCHEATMENT-CD                     
                                PARM-DATE-CLEARED                       
                                PARM-REFUND-CHECK-NO                    
                                PARM-AT-LAST-UPD-TS                     
                                PARM-ADDRESS-FORMAT                     
                                PARM-ADDRESS-ID                         
                                PARM-FMT-HOUSE-NO                       
                                PARM-FMT-ADDR-PREFIX-1                  
                                PARM-FMT-ADDR-PREFIX-2                  
                                PARM-FMT-STREET-NAME                    
                                PARM-FMT-STREET-SUFFIX                  
                                PARM-FMT-ADDR-SUFFIX                    
                                PARM-FMT-STREET-LOCATION-1              
                                PARM-FMT-STREET-LOCATION-2              
                                PARM-FF-ADDR-STREET                     
                                PARM-FF-ADDRESS-OVERFLOW                
                                PARM-FF-ADDRESS-CITY-STATE              
                                PARM-CITY                               
                                PARM-STATE                              
                                PARM-ZIP-CODE                           
                                PARM-ZIP-CODE-PLUS-FOUR                 
WLR                             PARM-COUNTRY.                           

SCA006        SET WS-GL-SUB TO 1.
                                                                        
      ******************************************************************03050000
      * 0000-MAINLINE                                                  *03060000
      ******************************************************************03130000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03250000
      * 0100-INITIALIZE                                                *03260000
      ******************************************************************03370000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                  TO ACTIVE-PARAGRAPH.            
                                                                        
           INITIALIZE WS-REFUND-DTLS                                    
                      GTT-RETURN-FIELDS.                                
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR   FOR              
               SELECT                                                   
                   :S-RETURN-CODE             AS  RETURN_CODE           
                  ,LTRIM(RTRIM(:S-APPL-RETURN-CODE)) AS  
           APPL_RETURN_CODE      
               FROM                                                     
                   CIS.SYSDUMMY1                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR* MSQ034
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH HOLD WITH RETURN FOR                      
MFA-TR*        SELECT                                                           
MFA-TR*            :S-RETURN-CODE             AS  RETURN_CODE                   
MFA-TR*           ,STRIP(:S-APPL-RETURN-CODE) AS  APPL_RETURN_CODE              
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03660000
      * 1000-PROCESS-INPUT                                             *03670000
      ******************************************************************03730000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACTION-CODE            TO WS-ACTION-CODE.          
           MOVE PARM-ACCOUNT-NO             TO WS-ACCOUNT-NO            
                                               WS-ACCOUNT-NO-COMP3.     
           MOVE PARM-ITEM-ID                TO WS-ITEM-ID.              
           MOVE PARM-USER-ID                TO WS-USER-ID.              
           MOVE PARM-DATE-REQUESTED         TO WS-DATE-REQUESTED.       
           MOVE PARM-RETURN-REASON          TO WS-RETURN-REASON.        
           MOVE PARM-CHECK-ISS-REAS-CODE    TO WS-CHECK-ISS-REAS-CODE.  
           MOVE PARM-CHECK-STATUS-CD        TO WS-CHECK-STATUS-CD.      
           MOVE PARM-DATE-ESCH-VERIFIED     TO WS-DATE-ESCH-VERIFIED.   
           MOVE PARM-DATE-RETURNED          TO WS-DATE-RETURNED.        
           MOVE PARM-ADDRESS-CHANGED-FL     TO WS-ADDRESS-CHANGED-FL.   
           MOVE PARM-TRANS-COMMENTS-TEXT    TO WS-TRANS-COMMENTS-TEXT   
                                               WS-COMMENTS-TEXT.        
           MOVE PARM-TRANS-COMMENTS-LEN     TO WS-TRANS-COMMENTS-LEN    
                                               WS-COMMENTS-LEN.         
           MOVE PARM-TRANS-HIST-SEQ-NO      TO WS-TRANS-HIST-SEQ-NO     
                WS-PREV-TRANS-HIST-SEQ-NO.                              
           MOVE PARM-ESCHEATMENT-CD         TO WS-ESCHEATMENT-CD.       
           MOVE PARM-DATE-CLEARED           TO WS-DATE-CLEARED.         
           MOVE PARM-REFUND-CHECK-NO        TO WS-REFUND-CHECK-NO.      
           MOVE PARM-AT-LAST-UPD-TS         TO WS-AT-LAST-UPD-TS.       
           MOVE PARM-ADDRESS-FORMAT         TO WS-KR363-ADDRESS-FORMAT. 
           MOVE PARM-ADDRESS-ID             TO WS-KR363-ADDRESS-ID.     
           MOVE PARM-FMT-HOUSE-NO           TO WS-KR363-FMT-HOUSE-NO.   
           MOVE PARM-FMT-ADDR-PREFIX-1   TO WS-KR363-FMT-ADDR-PREFIX-1. 
           MOVE PARM-FMT-ADDR-PREFIX-2   TO WS-KR363-FMT-ADDR-PREFIX-2. 
           MOVE PARM-FMT-STREET-NAME        TO WS-KR363-FMT-STREET-NAME.
           MOVE PARM-FMT-STREET-SUFFIX   TO WS-KR363-FMT-STREET-SUFFIX. 
           MOVE PARM-FMT-ADDR-SUFFIX     TO WS-KR363-FMT-ADDR-SUFFIX.   
           MOVE PARM-FMT-STREET-LOCATION-1  TO                          
                                            WS-KR363-FMT-STREET-LOC-1.  
           MOVE PARM-FMT-STREET-LOCATION-2  TO                          
                                            WS-KR363-FMT-STREET-LOC-2.  
           MOVE PARM-FF-ADDR-STREET         TO WS-KR363-FF-ADDR-STREET. 
           MOVE PARM-FF-ADDRESS-OVERFLOW TO WS-KR363-FF-ADDR-OVERFLOW.  
           MOVE PARM-FF-ADDRESS-CITY-STATE  To                          
                                            WS-KR363-FF-ADDR-CITY-STATE.
           MOVE PARM-CITY                   TO WS-KR363-CITY.           
           MOVE PARM-STATE                  TO WS-KR363-STATE.          
           MOVE PARM-ZIP-CODE               TO WS-KR363-ZIP-CODE.       
P0087A     MOVE PARM-ZIP-CODE-PLUS-FOUR  TO WS-KR363-ZIP-CODE-PLUS-FOUR.
WLR        MOVE PARM-COUNTRY             TO WS-KR363-FF-ADDR-COUNTRY.   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08230000
      * 2000-PROCESS-OUTPUT.                                           *08240000
      ******************************************************************08340000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE WS-ACCOUNT-NO            TO AT-ACCOUNT-NO               
                                            AR-ACCOUNT-NO               
                                            AU-ACCOUNT-NO               
                                            RN-ACCOUNT-NO.              
           MOVE WS-ITEM-ID               TO RN-REFUND-ITEM-ID.          
           MOVE WS-CHECK-STATUS-CD       TO WS-CHECK-CURR-STATUS-CD.    
           MOVE WS-ACTION-CODE           TO WS-KR363-ACTION-FLAG.       
                                                                        
           PERFORM 2100-PROCESS-REFUND                 THRU 2100-EXIT.  
                                                                        
           PERFORM 2500-APPLY-MISC-CREDIT              THRU 2500-EXIT.  
                                                                        
           IF WS-CHECK-PREV-STATUS-CD NOT = WS-CHECK-CURR-STATUS-CD AND 
              WS-CHECK-CURR-STATUS-CD = 'A'                             
              PERFORM 2600-APPLY-PAYMENT-JRNL          THRU 2600-EXIT   
           END-IF                                                       
                                                                        
           ADD +1                       TO CTR-ROWS.                    
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-PROCESS-REFUND                                            *        
      ******************************************************************        
                                                                        
       2100-PROCESS-REFUND.                                             
                                                                        
                                                                        
           PERFORM 7999-SELECT-AL THRU        7999-SELECT-AL-EXIT.      
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
              MOVE 0                          TO S-RETURN-CODE          
              MOVE '5000'                     TO S-APPL-RETURN-CODE     
              ADD +1                          TO  CTR-ROWS              
              PERFORM 9999-END-PROGRAM                  THRU 9999-EXIT  
           END-IF.                                                      
                                                                        
           PERFORM 7800-GET-ACCOUNT-INFO      THRU 7800-KR364-EXIT.     
           MOVE AT-CODES-DATA-PRESENT         TO WS-CODES-DATA-PRESENT. 
           IF AT-LAST-UPDATE-TS NOT = WS-AT-LAST-UPD-TS                 
              MOVE 0                          TO S-RETURN-CODE          
              MOVE '5272'                     TO S-APPL-RETURN-CODE     
              ADD +1                          TO CTR-ROWS               
              PERFORM 9999-END-PROGRAM                  THRU 9999-EXIT  
           END-IF.                                                      
                                                                        
           PERFORM 7020-ACCEPT-TIMESTAMP               THRU 7020-EXIT.  
           PERFORM 7030-GET-RESP-AREA-ID               THRU 7030-EXIT.  
           PERFORM 7040-GET-REFUND-DETAILS             THRU 7040-EXIT.  
           MOVE RN-CHECK-STATUS-CD          TO WS-CHECK-PREV-STATUS-CD. 
           MOVE RN-AMT-REFUNDED             TO WS-AMT-REFUNDED          
                                               WS-TOTAL-ORIG-AMT.       
           IF RN-PANEL-NO = 'P111'                                      
              MOVE RN-COMMENTS-TEXT(1:10)   TO WS-PREV-DATE-TRANS       
           ELSE                                                         
              IF RN-PANEL-NO = 'P275'                                   
                 MOVE RN-COMMENTS-TEXT(1:9) TO WS-CIA-ITEM-ID           
              END-IF                                                    
           END-IF.                                                      
           MOVE SPACES                      TO RN-COMMENTS-TEXT.        
           MOVE 0                           TO RN-COMMENTS-LEN.         
           MOVE PARM-TRANS-COMMENTS-TEXT    TO RN-COMMENTS-TEXT.        
           MOVE PARM-TRANS-COMMENTS-LEN     TO RN-COMMENTS-LEN.         
                                                                        
           PERFORM 5010-MNT-TRAN-HEAD                  THRU 5010-EXIT.  
                                                                        
           IF WS-ACTION-CODE = 'U'                                      
              PERFORM 2300-UPDATE-REFUND-PROCESS       THRU 2300-EXIT   
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2300-UPDATE-REFUND-PROCESS                                     *        
      ******************************************************************        
                                                                        
       2300-UPDATE-REFUND-PROCESS.                                      
                                                                        
           MOVE 'N'                         TO WS-REFUND-DTLS-FLAG.     
      * Request Date                                                            
           IF WS-DATE-REQUESTED NOT = RN-REQUEST-DT AND                 
              WS-DATE-REQUESTED NOT = '0001-01-01'                      
              ADD +1                        TO MI-TRAN-APPL-NO          
              MOVE 'REQUEST_DATE'           TO MI-COLUMN-DESC           
              MOVE RN-REQUEST-DT            TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 10                       TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-DATE-REQUESTED        TO MI-CHG-COLUMN-VALUE-TEXT 
                                               RN-REQUEST-DT            
              MOVE 'Y'                      TO WS-REFUND-DTLS-FLAG      
              PERFORM 6530-LOAD-MNT-TRANS-HIST          THRU 6530-EXIT  
           END-IF.                                                      
                                                                        
      * Check Status Code                                                       
           IF WS-CHECK-STATUS-CD NOT = RN-CHECK-STATUS-CD               
              PERFORM 2310-RESET-DATES    THRU 2310-EXIT                
              ADD +1                        TO MI-TRAN-APPL-NO          
              MOVE 'CHECK_STATUS_CD'        TO MI-COLUMN-DESC           
              MOVE RN-CHECK-STATUS-CD       TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 1                        TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CHECK-STATUS-CD       TO MI-CHG-COLUMN-VALUE-TEXT 
                                               RN-CHECK-STATUS-CD       
              MOVE 'Y'                      TO WS-REFUND-DTLS-FLAG      
              PERFORM 6530-LOAD-MNT-TRANS-HIST          THRU 6530-EXIT  
           END-IF.                                                      
                                                                        
      * Returned Reason                                                         
           IF WS-RETURN-REASON      NOT = RN-RETURNED-REASON            
              ADD +1                        TO MI-TRAN-APPL-NO          
              MOVE 'RETURNED_REASON'        TO MI-COLUMN-DESC           
              MOVE RN-RETURNED-REASON       TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 1                        TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-RETURN-REASON         TO MI-CHG-COLUMN-VALUE-TEXT 
                                               RN-RETURNED-REASON       
              MOVE 'Y'                      TO WS-REFUND-DTLS-FLAG      
              PERFORM 6530-LOAD-MNT-TRANS-HIST          THRU 6530-EXIT  
           END-IF.                                                      
                                                                        
      * Comments                                                                
           IF WS-COMMENTS-TEXT NOT = RN-COMMENTS-TEXT                   
              ADD +1                        TO MI-TRAN-APPL-NO          
              MOVE 'COMMENTS'               TO MI-COLUMN-DESC           
              MOVE RN-COMMENTS-TEXT         TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE RN-COMMENTS-LEN          TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE WS-COMMENTS-LEN          TO MI-CHG-COLUMN-VALUE-LEN  
                                               RN-COMMENTS-LEN          
              MOVE WS-COMMENTS-TEXT         TO MI-CHG-COLUMN-VALUE-TEXT 
                                               RN-COMMENTS-TEXT         
              MOVE 'Y'                      TO WS-REFUND-DTLS-FLAG      
              PERFORM 6530-LOAD-MNT-TRANS-HIST          THRU 6530-EXIT  
           END-IF.                                                      
                                                                        
      * Check ISS Reason Code                                                   
           IF WS-CHECK-ISS-REAS-CODE NOT = RN-CHECK-ISS-REAS-CD         
              ADD +1                        TO MI-TRAN-APPL-NO          
              MOVE 'CHECK-ISS-REAS-CD'      TO MI-COLUMN-DESC           
              MOVE RN-CHECK-ISS-REAS-CD     TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 2                        TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CHECK-ISS-REAS-CODE   TO MI-CHG-COLUMN-VALUE-TEXT 
                                               RN-CHECK-ISS-REAS-CD     
              MOVE 'Y'                      TO WS-REFUND-DTLS-FLAG      
              PERFORM 6530-LOAD-MNT-TRANS-HIST          THRU 6530-EXIT  
           END-IF.                                                      
                                                                        
      * Escheat Verify Date                                                     
           IF WS-DATE-ESCH-VERIFIED NOT = RN-ESCHEAT-VERIFY-DT AND      
              WS-DATE-ESCH-VERIFIED NOT = '0001-01-01'                  
              ADD +1                        TO MI-TRAN-APPL-NO          
              MOVE 'ESCHEAT_VERIFY_DT'      TO MI-COLUMN-DESC           
              MOVE RN-ESCHEAT-VERIFY-DT     TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 10                       TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-DATE-ESCH-VERIFIED    TO MI-CHG-COLUMN-VALUE-TEXT 
                                               RN-ESCHEAT-VERIFY-DT     
              MOVE 'Y'                      TO WS-REFUND-DTLS-FLAG      
              PERFORM 6530-LOAD-MNT-TRANS-HIST          THRU 6530-EXIT  
           END-IF.                                                      
                                                                        
      * Escheat Return Date                                                     
           IF WS-DATE-RETURNED NOT = RN-ESCHEAT-RETURN-DT AND           
              WS-DATE-RETURNED NOT = '0001-01-01'                       
              ADD +1                        TO MI-TRAN-APPL-NO          
              MOVE 'ESCHEAT_RETURN_DT'      TO MI-COLUMN-DESC           
              MOVE RN-ESCHEAT-RETURN-DT     TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 10                       TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-DATE-RETURNED         TO MI-CHG-COLUMN-VALUE-TEXT 
                                               RN-ESCHEAT-RETURN-DT     
              MOVE 'Y'                      TO WS-REFUND-DTLS-FLAG      
              PERFORM 6530-LOAD-MNT-TRANS-HIST          THRU 6530-EXIT  
           END-IF.                                                      
                                                                        
      * Escheatment Code                                                        
           IF WS-ESCHEATMENT-CD   NOT = RN-ESCHEATMENT-CD               
              ADD +1                      TO MI-TRAN-APPL-NO            
              MOVE 'ESCHEATMENT_CD'       TO MI-COLUMN-DESC             
              MOVE RN-ESCHEATMENT-CD      TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 1                      TO MI-PRV-COLUMN-VALUE-LEN    
                                             MI-CHG-COLUMN-VALUE-LEN    
              MOVE WS-ESCHEATMENT-CD      TO MI-CHG-COLUMN-VALUE-TEXT   
                                             RN-ESCHEATMENT-CD          
              MOVE 'Y'                      TO WS-REFUND-DTLS-FLAG      
              PERFORM 6530-LOAD-MNT-TRANS-HIST          THRU 6530-EXIT  
           END-IF                                                       
                                                                        
      * Date Cleared                                                            
           IF WS-DATE-CLEARED NOT = RN-CLEARED-DT AND                   
              WS-DATE-CLEARED NOT = '0001-01-01'                        
              ADD +1                      TO MI-TRAN-APPL-NO            
              MOVE 'DATE_CLEARED'         TO MI-COLUMN-DESC             
              MOVE RN-CLEARED-DT          TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 10                     TO MI-PRV-COLUMN-VALUE-LEN    
                                             MI-CHG-COLUMN-VALUE-LEN    
              MOVE WS-DATE-CLEARED        TO MI-CHG-COLUMN-VALUE-TEXT   
                                             RN-CLEARED-DT              
              MOVE 'Y'                      TO WS-REFUND-DTLS-FLAG      
              PERFORM 6530-LOAD-MNT-TRANS-HIST          THRU 6530-EXIT  
           END-IF                                                       
                                                                        
      * Refund Check Number                                                     
           IF WS-REFUND-CHECK-NO  NOT = RN-REFUND-CHECK-NO              
              ADD +1                      TO MI-TRAN-APPL-NO            
              MOVE 'REFUND_CHECK_NO'      TO MI-COLUMN-DESC             
              MOVE RN-REFUND-CHECK-NO     TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 9                      TO MI-PRV-COLUMN-VALUE-LEN    
                                             MI-CHG-COLUMN-VALUE-LEN    
              MOVE WS-REFUND-CHECK-NO     TO MI-CHG-COLUMN-VALUE-TEXT   
                                             RN-REFUND-CHECK-NO         
              MOVE 'Y'                      TO WS-REFUND-DTLS-FLAG      
              PERFORM 6530-LOAD-MNT-TRANS-HIST          THRU 6530-EXIT  
           END-IF                                                       
                                                                        
           IF WS-ADDRESS-CHANGED-FL = 'T'                               
              MOVE 'I'                      TO WS-KR363-ACTION-FLAG     
              PERFORM 5100-ADDRESS-PROCESS     THRU 5100-KR363-EXIT     
              MOVE WS-90-NEW-ADDRESS-ID     TO RN-ADDRESS-ID            
              MOVE 'Y'                      TO WS-REFUND-DTLS-FLAG      
           END-IF.                                                      
                                                                        
           IF WS-REFUND-DTLS-FLAG = 'Y'                                 
              MOVE WS-CURRENT-TIMESTAMP     TO RN-TRANS-HIST-SEQ-NO     
              PERFORM 8310-UPDATE-REFUND       THRU 8310-EXIT           
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2310-RESET-DATES                                               *        
      ******************************************************************        
                                                                        
       2310-RESET-DATES.                                                
                                                                        
           IF WS-CURRENT-DATE NOT = RN-REFUND-STATUS-DT                 
              ADD +1                        TO MI-TRAN-APPL-NO          
              MOVE 'REFUND_STATUS_DATE'     TO MI-COLUMN-DESC           
              MOVE RN-REFUND-STATUS-DT      TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 10                       TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CURRENT-DATE          TO MI-CHG-COLUMN-VALUE-TEXT 
                                               RN-REFUND-STATUS-DT      
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           END-IF.                                                      
                                                                        
           MOVE SPACES                      TO MI-COLUMN-DESC.          
           EVALUATE WS-CHECK-STATUS-CD                                  
            WHEN 'C'                                                    
                 IF WS-CURRENT-DATE NOT = RN-DATE-CANCELLED             
                    MOVE 'DATE_CANCELLED'   TO MI-COLUMN-DESC           
                    MOVE RN-DATE-CANCELLED  TO MI-PRV-COLUMN-VALUE-TEXT 
                    MOVE WS-CURRENT-DATE    TO RN-DATE-CANCELLED        
                 END-IF                                                 
            WHEN 'S'                                                    
                 IF WS-CURRENT-DATE NOT = RN-STOP-REQUEST-DT            
                    MOVE 'STOP_REQUEST_DT'  TO MI-COLUMN-DESC           
                    MOVE RN-STOP-REQUEST-DT TO MI-PRV-COLUMN-VALUE-TEXT 
                    MOVE WS-CURRENT-DATE    TO RN-STOP-REQUEST-DT       
                 END-IF                                                 
            WHEN 'U'                                                    
                 IF WS-CURRENT-DATE NOT = RN-RETURNED-DATE              
                    MOVE 'RETURNED_DATE'    TO MI-COLUMN-DESC           
                    MOVE RN-RETURNED-DATE   TO MI-PRV-COLUMN-VALUE-TEXT 
                    MOVE WS-CURRENT-DATE    TO RN-RETURNED-DATE         
                 END-IF                                                 
            WHEN 'M'                                                    
                 IF WS-CURRENT-DATE NOT = RN-CHECK-REMAIL-DT            
                    MOVE 'CHECK_REMAIL_DT'  TO MI-COLUMN-DESC           
                    MOVE RN-CHECK-REMAIL-DT TO MI-PRV-COLUMN-VALUE-TEXT 
                    MOVE WS-CURRENT-DATE    TO RN-CHECK-REMAIL-DT       
                 END-IF                                                 
            WHEN 'T'                                                    
                 IF WS-CURRENT-DATE NOT = RN-DATE-ESCHEATED             
                    MOVE 'DATE_ESCHEATED'   TO MI-COLUMN-DESC           
                    MOVE RN-DATE-ESCHEATED  TO MI-PRV-COLUMN-VALUE-TEXT 
                    MOVE WS-CURRENT-DATE    TO RN-DATE-ESCHEATED        
                 END-IF                                                 
            WHEN 'X'                                                    
                 IF WS-CURRENT-DATE NOT = RN-DATE-CHECK-VOIDED          
                    MOVE 'DATE_CHECK_VOIDED'    TO MI-COLUMN-DESC       
                    MOVE RN-DATE-CHECK-VOIDED   TO                      
                                             MI-PRV-COLUMN-VALUE-TEXT   
                    MOVE WS-CURRENT-DATE        TO RN-DATE-CHECK-VOIDED 
                 END-IF                                                 
            WHEN 'L'                                                    
                 IF WS-CURRENT-DATE NOT = RN-CLEARED-DT                 
                    MOVE 'DATE_CLEARED'     TO MI-COLUMN-DESC           
                    MOVE RN-CLEARED-DT      TO MI-PRV-COLUMN-VALUE-TEXT 
                    MOVE WS-CURRENT-DATE    TO RN-CLEARED-DT            
                 END-IF                                                 
           END-EVALUATE.                                                
                                                                        
           IF MI-COLUMN-DESC NOT = SPACES                               
              MOVE 10                       TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
              ADD +1                        TO MI-TRAN-APPL-NO          
              MOVE WS-CURRENT-DATE          TO MI-CHG-COLUMN-VALUE-TEXT 
              PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT         
           END-IF.                                                      
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2500-APPLY-MISC-CREDIT.                                       *         
      *****************************************************************         
                                                                        
       2500-APPLY-MISC-CREDIT.                                          
                                                                        
           INITIALIZE WS-CSR02294-INPUT-AREA.                           
                                                                        
           MOVE WS-ACCOUNT-NO                TO WS-2294-ACCOUNT-NO.     
           MOVE 0                            TO WS-2294-CNT-NAME-CD     
                                             WS-2294-PYMT-PRIORITY-LVL. 
                                                                        
           MOVE 'CIA'                        TO                         
                                             WS-2294-DIST-AR-TYPE-SHORT.
           MOVE 70                           TO                         
                                             WS-2294-DIST-PYMT-PRI-LVL. 
           MOVE '00000000000'                TO WS-2294-EARNED-INT      
                                                WS-2294-DEF-INT         
                                                WS-2294-OTHER-TAX       
                                                WS-2294-STATE-TAX       
                                                WS-2294-CITY-TAX        
                                                WS-2294-PRINCIPAL       
                                                WS-2294-CR-AMT-DAY-00   
                                                WS-2294-CR-AMT-DAY-30   
                                                WS-2294-CR-AMT-DAY-60   
                                                WS-2294-CR-AMT-DAY-90.  
           MOVE PARM-AT-LAST-UPD-TS          TO                         
                                             WS-2294-AT-LAST-UPDATE-TS  
                                             WS-2294-AC-LAST-UPDATE-TS. 
           MOVE 1                            TO WS-2294-DIST-ITEM-ID.   
           MOVE WS-RESP-AREA-ID              TO WS-2294-RESP-AREA-ID.   
           MOVE WS-USER-ID                   TO WS-2294-USER-ID.        
           MOVE '000000'                     TO WS-2294-REVENUE-MONTH.  
           MOVE WS-AMT-REFUNDED-N            TO WS-2294-CR-AMT-TOTAL.   
                                                                        
           IF S-RETURN-CODE = 0 AND NOT ( WS-CHECK-ISS-REAS-CODE = 'ER' 
              AND (WS-CHECK-CURR-STATUS-CD  = 'C' AND                   
              WS-CHECK-PREV-STATUS-CD = 'A'))                           
              IF WS-CHECK-CURR-STATUS-CD  = 'S' OR 'X' OR               
                 (WS-CHECK-CURR-STATUS-CD = 'C' AND                     
                  WS-CHECK-PREV-STATUS-CD = 'A')                        
                 EVALUATE WS-CHECK-PREV-STATUS-CD                       
                  WHEN 'I'                                              
                  WHEN 'M'                                              
                  WHEN 'U'                                              
                       IF AT-COMPANY-NO = '01'                          
                          MOVE '2538900'     TO WS-2294-GL-ACCT-NO      
                       ELSE                                             
                          MOVE '2538926'     TO WS-2294-GL-ACCT-NO      
                       END-IF                                           
                  WHEN 'E'                                              
                  WHEN 'T'                                              
                       IF AT-COMPANY-NO = '01'                          
                          MOVE '2530603'     TO WS-2294-GL-ACCT-NO      
                       ELSE                                             
                          MOVE '2530626'     TO WS-2294-GL-ACCT-NO      
                       END-IF                                           
                  WHEN 'A'                                              
                          MOVE '1842300'     TO WS-2294-GL-ACCT-NO      
                 END-EVALUATE                                           
                 PERFORM 2510-CALL-CSR02294  THRU 2510-EXIT             
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2510-CALL-CSR02294                                             *        
      ******************************************************************        
                                                                        
       2510-CALL-CSR02294.                                              
                                                                        
           EVALUATE WS-CHECK-CURR-STATUS-CD                             
            WHEN 'S'                                                    
                 MOVE 'STOP PAYMENT APPLIED' TO WS-2294-TRANS-COMMENTS  
                 MOVE +20                    TO WS-2294-TRANS-LEN       
            WHEN 'X'                                                    
                 MOVE 'CHECK VOIDED'         TO WS-2294-TRANS-COMMENTS  
                 MOVE +12                    TO WS-2294-TRANS-LEN       
            WHEN 'C'                                                    
                 MOVE 'REFUND CANCELLED'     TO WS-2294-TRANS-COMMENTS  
                 MOVE +16                    TO WS-2294-TRANS-LEN       
           END-EVALUATE.                                                
                                                                        
           IF WS-CHECK-ISS-REAS-CODE = 'ER'                             
              MOVE 'DSM'                     TO WS-2294-RECV-TYPE       
              MOVE WS-ITEM-ID                TO WS-2294-ITEM-ID         
           ELSE                                                         
              MOVE 'MIS'                     TO WS-2294-RECV-TYPE       
              MOVE WS-ITEM-ID                TO WS-2294-ITEM-ID         
           END-IF.                                                      
                                                                        
           MOVE 100                          TO WS-2294-RETURN-CODE.    
                                                                        
           PERFORM 7500-OPEN-CSR02294        THRU 7500-EXIT.            
                                                                        
      *    EXEC SQL                                                     
      *        ASSOCIATE LOCATORS                                       
      *        (:LOC1)                                                  
      *        WITH PROCEDURE CSR02294                                  
      *    END-EXEC                                                     
                                                                        
      *    EXEC SQL                                                     
      *        ALLOCATE REFUND CURSOR FOR RESULT SET                    
      *        :LOC1                                                    
      *    END-EXEC                                                     
                                                                        
           PERFORM 7510-FETCH-CSR02294       THRU 7510-EXIT.            
                                                                        
           EVALUATE WS-2294-RETURN-CODE                                 
            WHEN 0                                                      
                 MOVE 0                     TO S-RETURN-CODE            
            WHEN 5000                                                   
                 IF WS-2294-AT-ACCT-XFER-TO > 0                         
                    MOVE 0                  TO S-RETURN-CODE            
                    MOVE '5001'             TO S-APPL-RETURN-CODE       
                    ADD +1                  TO CTR-ROWS                 
                    PERFORM 9999-END-PROGRAM   THRU 9999-EXIT           
                 ELSE                                                   
                    MOVE 0                  TO S-RETURN-CODE            
                    MOVE '5000'             TO S-APPL-RETURN-CODE       
                    ADD +1                  TO CTR-ROWS                 
                    PERFORM 9999-END-PROGRAM   THRU 9999-EXIT           
                 END-IF                                                 
            WHEN 5272                                                   
                 MOVE 0                     TO S-RETURN-CODE            
                 MOVE '5272'                TO S-APPL-RETURN-CODE       
                 ADD +1                     TO CTR-ROWS                 
                 PERFORM 9999-END-PROGRAM   THRU 9999-EXIT              
            WHEN OTHER                                                  
                 MOVE WS-2294-RETURN-CODE   TO WS-ACTIVE-RETURN-CODE    
                 MOVE 'CALL'                TO ABEND-FUNCTION           
                 MOVE 'CREDIT_CSR02294'     TO TABLE-1                  
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 7520-CLOSE-CSR02294      THRU 7520-EXIT.             
                                                                        
       2510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2600-APPLY-PAYMENT-JRNL                                        *        
      ******************************************************************        
                                                                        
       2600-APPLY-PAYMENT-JRNL.                                         
                                                                        
P0087A     IF RN-PANEL-NO = 'P259'                                      
P0087A        PERFORM 5300-DEP-JRNL-PROCESS        THRU 5300-EXIT       
P0087A     ELSE                                                         
              PERFORM 5020-UPDATE-REFUND-DTLS       THRU 5020-EXIT      
                                                                        
              IF RN-PANEL-NO = 'P111'                                   
                 PERFORM 5100-PRE-PYMT-JRNL-PROCESS THRU 5100-EXIT      
              ELSE                                                      
                 MOVE RN-AMT-REFUNDED    TO WS-RFND-CHECK-AMT           
                 MOVE 0                  TO WS-RFND-CASH-AMT            
                 MOVE WS-RESP-AREA-ID    TO PF-RESP-AREA-ID             
                 PERFORM 5200-CRED-BAL-JRNL-PROCESS THRU 5200-KR364-EXIT
              END-IF                                                    
P0087A     END-IF.                                                      
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5010-MNT-TRAN-HEAD                                             *        
      ******************************************************************        
                                                                        
       5010-MNT-TRAN-HEAD.                                              
                                                                        
           INITIALIZE DCLCSS-MNT-TRANS-HIST                             
                      DCLCSS-MT-TRN-HST-DET                             
                                                                        
           MOVE WS-CURRENT-TIMESTAMP        TO MH-TRANS-HIST-SEQ-NO     
                                               MI-TRANS-HIST-SEQ-NO.    
           MOVE WS-CURRENT-DATE             TO MH-DATE-TRANS.           
           MOVE 'F'                         TO MH-CODE-TRAN-TYPE.       
           MOVE WS-RESP-AREA-ID             TO MH-RESP-AREA-ID.         
           MOVE WS-ACCOUNT-NO               TO MH-ACCOUNT-NO.           
           MOVE 0                           TO MH-CUSTOMER-NO.          
           MOVE 0                           TO MH-PREMISE-NO.           
           MOVE WS-USER-ID                  TO MH-USER-ID.              
           MOVE 'PANEL270'                  TO MH-APPL-PROGRAM-ID.      
                                                                        
           IF WS-TRANS-COMMENTS-LEN > 0                                 
              MOVE WS-TRANS-COMMENTS-TEXT   TO MH-TRAN-COMMENT-TEXT     
              MOVE WS-TRANS-COMMENTS-LEN    TO MH-TRAN-COMMENT-LEN      
           ELSE                                                         
              MOVE SPACES                   TO MH-TRAN-COMMENT-TEXT     
              MOVE 0                        TO MH-TRAN-COMMENT-LEN      
           END-IF.                                                      
                                                                        
       5010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5020-UPDATE-REFUND-DTLS                                        *        
      ******************************************************************        
                                                                        
       5020-UPDATE-REFUND-DTLS.                                         
                                                                        
           MOVE WS-CURRENT-TIMESTAMP        TO RN-TRANS-HIST-SEQ-NO.    
           MOVE WS-CHECK-STATUS-CD          TO RN-CHECK-STATUS-CD.      
           MOVE WS-USER-ID                  TO RN-USER-ID-APPRVD-BY.    
           MOVE WS-COMMENTS-TEXT            TO RN-COMMENTS-TEXT         
                                                                        
           IF PARM-DATE-REQUESTED > SPACES                              
              MOVE PARM-DATE-REQUESTED TO RN-REQUEST-DT                 
              MOVE +0                  TO WS-NULL-DATE-REQUEST          
           ELSE                                                         
              MOVE -1                  TO WS-NULL-DATE-REQUEST          
           END-IF.                                                      
                                                                        
           PERFORM 8320-UPDATE-REFUND-DTLS         THRU 8320-EXIT.      
                                                                        
       5020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5100-ADDRESS-PROCESS                                           *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDKR363                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 5100-PRE-PYMT-JRNL-PROCESS                                     *        
      ******************************************************************        
                                                                        
       5100-PRE-PYMT-JRNL-PROCESS.                                      
                                                                        
           MOVE WS-CURRENT-TIMESTAMP        TO AR-TRANS-HIST-SEQ-NO     
                                               AU-TRANS-HIST-SEQ-NO.    
           MOVE WS-CURRENT-DATE             TO AR-DATE-TRANS.           
           MOVE 'R'                         TO AR-CODE-TRAN-TYPE.       
           MOVE RN-AMT-REFUNDED             TO AR-AMT-ORIG-ENTERED.     
           MOVE WS-RESP-AREA-ID             TO AR-RESP-AREA-ID.         
           MOVE WS-USER-ID                  TO AR-USER-ID.              
                                                                        
           IF PARM-CHECK-ISS-REAS-CODE = 'P'                            
              MOVE 'PANEL111A'              TO AR-APPL-PROGRAM-ID       
           ELSE                                                         
              MOVE 'PANEL111'               TO AR-APPL-PROGRAM-ID       
           END-IF.                                                      
                                                                        
           MOVE WS-PREV-DATE-TRANS          TO AR-DATE-ORIG-PYMT.       
           MOVE 'Y'                      TO AR-PYMT-REFUNDED-IND        
           MOVE WS-TRANS-COMMENTS-TEXT   TO AR-TRAN-COMMENT-TEXT.       
           MOVE WS-TRANS-COMMENTS-LEN    TO AR-TRAN-COMMENT-LEN.        
           IF RN-MANUAL-INDICATOR = 'C'                                 
              STRING 'PAYMENT LOCAL OFFICE:',WS-CD-LOCAL-OFFICE,        
                '; REPORT DATE:',WS-CD-REPORT-DATE,                     
                '; BATCH NO:',WS-CD-REPORT-NO,';',WS-TRANS-COMMENTS-TEXT
                 DELIMITED BY SIZE INTO AR-TRAN-COMMENT-TEXT            
              ADD +63                       TO  AR-TRAN-COMMENT-LEN     
           END-IF.                                                      
           MOVE AT-TOTAL-AR-BALANCE         TO AR-AMT-BILLED-UNPAID.    
           ADD  RN-AMT-REFUNDED             TO AR-AMT-BILLED-UNPAID.    
           MOVE SPACES                      TO AR-RECORD-ONLY-FL        
                                               AR-PYMT-FACILITY-CD.     
           MOVE AT-COMPANY-NO               TO AR-COMPANY-NO.           
                                                                        
           IF RN-MANUAL-INDICATOR = 'M'                                 
              MOVE 'CHK'                    TO WS-CHECK-CASH-IND        
                                                                        
              MOVE '01'                     TO AR-CASH-COMPANY-NO       
                                               WS-CD-COMPANY-NO         
              MOVE '998'                    TO AR-CASH-LOCAL-OFFICE     
                                               WS-CD-LOCAL-OFFICE       
              MOVE '998'                    TO AR-CASH-REPORT-NO        
                                               WS-CD-REPORT-NO          
              MOVE WS-CURRENT-DATE          TO AR-DATE-CASH-REPORT      
                                               WS-CD-REPORT-DATE        
              MOVE 9999                     TO AR-CASH-DRAWER-ID        
                                               WS-CASH-DRAWER-ID        
           ELSE                                                         
              IF RN-MANUAL-INDICATOR = 'C'                              
                 MOVE 'CSH'                 TO WS-CHECK-CASH-IND        
                 MOVE WS-CD-COMPANY-NO      TO AR-CASH-COMPANY-NO       
                 MOVE WS-CD-LOCAL-OFFICE    TO AR-CASH-LOCAL-OFFICE     
                 MOVE WS-CD-REPORT-NO       TO AR-CASH-REPORT-NO        
                 MOVE WS-CD-REPORT-DATE     TO AR-DATE-CASH-REPORT      
                 MOVE WS-CASH-DRAWER-ID     TO AR-CASH-DRAWER-ID        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE 'F'                         TO WS-PART-CASH-PROCESS-FLG.
           PERFORM 8020-INSERT-AR-TRANS-HIST      THRU 8020-EXIT        
           MOVE RN-AMT-REFUNDED             TO WS-AMOUNT-REFUNDED.      
           MOVE 'S135'                      TO WS-CSH-DRWR-TRAN-ID      
                                                                        
           PERFORM 6904-INSERT-AR-DETAILS         THRU 6904-EXIT.       
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5200-CRED-BAL-JRNL-PROCESS.                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDKR364                                                  
           END-EXEC.                                                            
                                                                        
P0087A******************************************************************        
P0087A* 5300-DEP-JRNL-PROCESS                                          *        
P0087A******************************************************************        
P0087A                                                                  
P0087A 5300-DEP-JRNL-PROCESS.                                           
P0087A                                                                  
P0087A     INITIALIZE WS-CSR02171-INPUT-AREA.                           
P0087A                                                                  
P0087A     MOVE 'U'                   TO WS-2171-ACTION-CODE.           
P0087A     MOVE PARM-ACCOUNT-NO       TO WS-2171-ACCOUNT-NO.            
P0087A     MOVE AT-PREMISE-NO         TO WS-2171-PREMISE-NO.            
P0087A     MOVE 'U'                   TO WS-2171-SERVICE-TYPE-CD.       
P0087A     MOVE RN-DEPOSIT-CERT-NO    TO WS-2171-DEPOSIT-CERT-NO.       
P0087A     MOVE PARM-RETURN-REASON    TO WS-2171-CODE-REFUND-REASON.    
P0087A     MOVE PARM-CHECK-ISS-REAS-CODE TO WS-2171-CHECK-ISS-REAS-CD.  
P0087A     MOVE PARM-COMMENTS-LEN     TO WS-2171-CMNTS-LEN.             
P0087A     MOVE PARM-COMMENTS-TEXT    TO WS-2171-CMNTS-TEXT.            
P0087A     MOVE '00000000000'         TO WS-2171-BALANCE-AMT            
P0087A                                   WS-2171-THIS-CR-AMT.           
P0087A     MOVE SPACES                TO WS-2171-THIS-AR-TYPE.          
P0087A     MOVE '000000000'           TO WS-2171-THIS-ITEM-ID.          
P0087A     MOVE SPACES                TO WS-2171-SPEC-ACCOUNT-NO        
P0087A                                   WS-2171-SPEC-CR-AMT            
P0087A                                   WS-2171-SPEC-AR-TYPE           
P0087A                                   WS-2171-SPEC-ITEM-ID.          
P0087A     MOVE WS-AMT-REFUNDED-N     TO WS-2171-AMT-CHK.               
P0087A     MOVE '00000000000'         TO WS-2171-AMT-CASH.              
P0087A     MOVE SPACES                TO WS-2171-CASHIER-CODE           
P0087A                                   WS-2171-ADDRESS-CHANGED        
P0087A                                   WS-2171-ADDR-STREET            
P0087A                                   WS-2171-ADDR-CITY-STATE        
P0087A                                   WS-2171-ADDR-ZIP-CODE          
P0087A                                   WS-2171-ADDR-COUNTRY           
P0087A                                   WS-2171-ADDRESS-OVERFLOW.      
P0087A     MOVE WS-USER-ID            TO WS-2171-SUPERVISOR-ID.         
P0087A     MOVE 'A'                   TO WS-2171-APPROVE-IND.           
P0087A     MOVE '01'                  TO WS-2171-CD-COMPANY-NO.         
P0087A     MOVE '998'                 TO WS-2171-CD-LOCAL-OFFICE        
P0087A                                   WS-2171-CD-REPORT-NO.          
P0087A     MOVE WS-CURRENT-DATE       TO WS-2171-CD-REPORT-DATE.        
P0087A     MOVE 9999                  TO WS-2171-CASH-DRAWER-ID.        
P0087A     MOVE RN-USER-ID-RQSTED-BY  TO WS-2171-USER-ID.               
P0087A     MOVE WS-RESP-AREA-ID       TO WS-2171-RESP-AREA-ID.          
P0087A     MOVE PARM-TRANS-COMMENTS-LEN                                 
P0087A                                TO WS-2171-TRAN-CMNT-LEN.         
P0087A     MOVE PARM-TRANS-COMMENTS-TEXT                                
P0087A                                TO WS-2171-TRAN-CMNT-TEXT.        
P0087A     MOVE SPACES                TO WS-2171-CSR-PC-ID.             
P0087A     MOVE 'A'                   TO WS-2171-REFUND-TYPE.           
P0087A     MOVE ZEROS                 TO WS-2171-INTEREST-AMOUNT.       
P0087A     MOVE SPACES                TO WS-2171-SUPERUSER-CD.          
P0087A     MOVE SPACES                TO WS-2171-APPROVE-CHK-IND.       
P0087A     MOVE PARM-AT-LAST-UPD-TS   TO WS-2171-LAST-UPDATE-TS.        
P0087A     MOVE PARM-DATE-REQUESTED   TO WS-2171-REQUEST-DATE.          
P0087A                                                                  
P0087A     MOVE 100                          TO WS-2171-RETURN-CODE.    
P0087A                                                                  
P0087A     PERFORM 7550-OPEN-CSR02171        THRU 7550-EXIT.            
P0087A                                                                  
P0087A*    EXEC SQL                                                     
P0087A*        ASSOCIATE LOCATORS                                       
P0087A*        (:LOC1)                                                  
P0087A*        WITH PROCEDURE CSR02171                                  
P0087A*    END-EXEC                                                     
P0087A                                                                  
P0087A*    EXEC SQL                                                     
P0087A*        ALLOCATE DEPOSIT CURSOR FOR RESULT SET                   
P0087A*        :LOC1                                                    
P0087A*    END-EXEC                                                     
P0087A                                                                  
P0087A     PERFORM 7560-FETCH-CSR02171       THRU 7560-EXIT.            
P0087A                                                                  
P0087A     EVALUATE WS-2171-RETURN-CODE                                 
P0087A      WHEN 0                                                      
P0087A           MOVE 0                     TO S-RETURN-CODE            
P0087A      WHEN 5000                                                   
P0087A           MOVE 0                  TO S-RETURN-CODE               
P0087A           MOVE '5000'             TO S-APPL-RETURN-CODE          
P0087A           ADD +1                  TO CTR-ROWS                    
P0087A           PERFORM 9999-END-PROGRAM   THRU 9999-EXIT              
P0087A      WHEN 5272                                                   
P0087A           MOVE 0                     TO S-RETURN-CODE            
P0087A           MOVE '5272'                TO S-APPL-RETURN-CODE       
P0087A           ADD +1                     TO CTR-ROWS                 
P0087A           PERFORM 9999-END-PROGRAM   THRU 9999-EXIT              
P0087A      WHEN OTHER                                                  
P0087A           MOVE WS-2171-RETURN-CODE    TO WS-ACTIVE-RETURN-CODE   
P0087A           MOVE 'CALL'                 TO ABEND-FUNCTION          
P0087A           MOVE 'DEPOSIT_CSR02171'     TO TABLE-1                 
P0087A           PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT             
P0087A     END-EVALUATE.                                                
P0087A                                                                  
P0087A     PERFORM 7570-CLOSE-CSR02171      THRU 7570-EXIT.             
P0087A                                                                  
P0087A 5300-EXIT.                                                       
P0087A     EXIT.                                                        
      ******************************************************************        
      * 6202-GET-NEW-ADDRESS-ID                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00090                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 6210-CALCULATE-CHECK-DIGIT                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00071                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 6530-LOAD-MNT-TRANS-HIST                                       *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 6400-ONLINE-JRNL-ROUTINE                                       *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD0006A                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 6904-INSERT-AR-DETAILS                                         *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00116                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 7020-ACCEPT-TIMESTAMP                                          *        
      ******************************************************************        
                                                                        
       7020-ACCEPT-TIMESTAMP.                                           
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                    
MFA-TR*           ,:WS-CURRENT-DATE      = CURRENT DATE                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE         
                    MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
                    MOVE '7020'                TO ACTIVE-PARAGRAPH      
                    MOVE 'SET'                 TO ABEND-FUNCTION        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7030-GET-RESP-AREA-ID                                          *        
      ******************************************************************        
                                                                        
       7030-GET-RESP-AREA-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :WS-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :WS-USER-ID                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :WS-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :WS-USER-ID                                      
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7030                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7030'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_USER_PROFILE  '     TO TABLE-1                  
              MOVE 'USER_ID'                TO TABLE-ELEMENT-1          
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2          
              MOVE WS-USER-ID               TO HOSTVAR-ELEMENT-1        
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND               THRU 9700-EXIT   
           END-IF.                                                      
                                                                        
        7030-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7040-GET-REFUND-DETAILS                                        *        
      ******************************************************************        
                                                                        
       7040-GET-REFUND-DETAILS.                                         
                                                                        
           EXEC SQL                                                     
              SELECT REFUND_CHECK_NO                                    
                    ,DEPOSIT_CERT_NO                                    
                    ,LOCAL_OFFICE                                       
                    ,AMT_REFUNDED                                       
                    ,DATE_REFUNDED                                      
                    ,REQUEST_DT                                         
                    ,CLEARED_DT                                         
                    ,DATE_CANCELLED                                     
                    ,DATE_CHECK_VOIDED                                  
                    ,STOP_REQUEST_DT                                    
                    ,STOP_CONFIRM_DT                                    
                    ,CHECK_REMAIL_DT                                    
                    ,CHECK_STATUS_CD                                    
                    ,CHECK_ISS_REAS_CD                                  
                    ,REISSUED_DATE                                      
                    ,ORIGINAL_CHECK_NO                                  
                    ,RETURNED_REASON                                    
                    ,MANUAL_INDICATOR                                   
                    ,USER_ID_APPRVD_BY                                  
                    ,REFUND_STATUS_DT                                   
                    ,USER_ID_RQSTED_BY                                  
                    ,RETURNED_DATE                                      
                    ,DATE_APPROPRIATED                                  
                    ,DATE_ESCHEATED                                     
                    ,PANEL_NO                                           
                    ,ADDRESS_ID                                         
                    ,ESCHEAT_RETURN_DT                                  
                    ,ESCHEAT_VERIFY_DT                                  
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), TRANS_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') TRANS_HIST_SEQ_NO                      
                    ,ESCHEATMENT_CD                                     
                    ,COMMENTS                                           
                INTO :RN-REFUND-CHECK-NO                                
                    ,:RN-DEPOSIT-CERT-NO                                
                    ,:RN-LOCAL-OFFICE                                   
                    ,:RN-AMT-REFUNDED                                   
                    ,:RN-DATE-REFUNDED :WS-NULL-DATE-REFUND          
                    ,:RN-REQUEST-DT :WS-NULL-DATE-REQUEST         
                    ,:RN-CLEARED-DT :WS-NULL-DATE-CLEARED         
                    ,:RN-DATE-CANCELLED :WS-NULL-DATE-CANCELLED       
                    ,:RN-DATE-CHECK-VOIDED :WS-NULL-DATE-CHECK-VOID      
                    ,:RN-STOP-REQUEST-DT :WS-NULL-DATE-STOP-REQ        
                    ,:RN-STOP-CONFIRM-DT :WS-NULL-DATE-STOP-CONF       
                    ,:RN-CHECK-REMAIL-DT :WS-NULL-DATE-CHK-REMAIL      
                    ,:RN-CHECK-STATUS-CD                                
                    ,:RN-CHECK-ISS-REAS-CD                              
                    ,:RN-REISSUED-DATE :WS-NULL-DATE-REISSUED        
                    ,:RN-ORIGINAL-CHECK-NO                              
                    ,:RN-RETURNED-REASON                                
                    ,:RN-MANUAL-INDICATOR                               
                    ,:RN-USER-ID-APPRVD-BY                              
                    ,:RN-REFUND-STATUS-DT                               
                    ,:RN-USER-ID-RQSTED-BY                              
                    ,:RN-RETURNED-DATE :WS-NULL-DATE-RETURNED        
                    ,:RN-DATE-APPROPRIATED :WS-NULL-DATE-APPROP          
                    ,:RN-DATE-ESCHEATED :WS-NULL-DATE-ESCHEATED       
                    ,:RN-PANEL-NO                                       
                    ,:RN-ADDRESS-ID                                     
                    ,:RN-ESCHEAT-RETURN-DT :WS-NULL-DATE-ESCH-RETURNED   
                    ,:RN-ESCHEAT-VERIFY-DT :WS-NULL-DATE-ESCH-VERIFIED   
                    ,:RN-TRANS-HIST-SEQ-NO                              
                    ,:RN-ESCHEATMENT-CD                                 
                    ,:RN-COMMENTS                                       
                FROM CSS_REFUND WITH(READUNCOMMITTED)                           
               WHERE ACCOUNT_NO     = :RN-ACCOUNT-NO                    
                 AND REFUND_ITEM_ID = :RN-REFUND-ITEM-ID                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT REFUND_CHECK_NO                                            
MFA-TR*             ,DEPOSIT_CERT_NO                                            
MFA-TR*             ,LOCAL_OFFICE                                               
MFA-TR*             ,AMT_REFUNDED                                               
MFA-TR*             ,DATE_REFUNDED                                              
MFA-TR*             ,REQUEST_DT                                                 
MFA-TR*             ,CLEARED_DT                                                 
MFA-TR*             ,DATE_CANCELLED                                             
MFA-TR*             ,DATE_CHECK_VOIDED                                          
MFA-TR*             ,STOP_REQUEST_DT                                            
MFA-TR*             ,STOP_CONFIRM_DT                                            
MFA-TR*             ,CHECK_REMAIL_DT                                            
MFA-TR*             ,CHECK_STATUS_CD                                            
MFA-TR*             ,CHECK_ISS_REAS_CD                                          
MFA-TR*             ,REISSUED_DATE                                              
MFA-TR*             ,ORIGINAL_CHECK_NO                                          
MFA-TR*             ,RETURNED_REASON                                            
MFA-TR*             ,MANUAL_INDICATOR                                           
MFA-TR*             ,USER_ID_APPRVD_BY                                          
MFA-TR*             ,REFUND_STATUS_DT                                           
MFA-TR*             ,USER_ID_RQSTED_BY                                          
MFA-TR*             ,RETURNED_DATE                                              
MFA-TR*             ,DATE_APPROPRIATED                                          
MFA-TR*             ,DATE_ESCHEATED                                             
MFA-TR*             ,PANEL_NO                                                   
MFA-TR*             ,ADDRESS_ID                                                 
MFA-TR*             ,ESCHEAT_RETURN_DT                                          
MFA-TR*             ,ESCHEAT_VERIFY_DT                                          
MFA-TR*             ,TRANS_HIST_SEQ_NO                                          
MFA-TR*             ,ESCHEATMENT_CD                                             
MFA-TR*             ,COMMENTS                                                   
MFA-TR*         INTO :RN-REFUND-CHECK-NO                                        
MFA-TR*             ,:RN-DEPOSIT-CERT-NO                                        
MFA-TR*             ,:RN-LOCAL-OFFICE                                           
MFA-TR*             ,:RN-AMT-REFUNDED                                           
MFA-TR*             ,:RN-DATE-REFUNDED    :WS-NULL-DATE-REFUND                  
MFA-TR*             ,:RN-REQUEST-DT       :WS-NULL-DATE-REQUEST                 
MFA-TR*             ,:RN-CLEARED-DT       :WS-NULL-DATE-CLEARED                 
MFA-TR*             ,:RN-DATE-CANCELLED   :WS-NULL-DATE-CANCELLED               
MFA-TR*             ,:RN-DATE-CHECK-VOIDED:WS-NULL-DATE-CHECK-VOID              
MFA-TR*             ,:RN-STOP-REQUEST-DT  :WS-NULL-DATE-STOP-REQ                
MFA-TR*             ,:RN-STOP-CONFIRM-DT  :WS-NULL-DATE-STOP-CONF               
MFA-TR*             ,:RN-CHECK-REMAIL-DT  :WS-NULL-DATE-CHK-REMAIL              
MFA-TR*             ,:RN-CHECK-STATUS-CD                                        
MFA-TR*             ,:RN-CHECK-ISS-REAS-CD                                      
MFA-TR*             ,:RN-REISSUED-DATE    :WS-NULL-DATE-REISSUED                
MFA-TR*             ,:RN-ORIGINAL-CHECK-NO                                      
MFA-TR*             ,:RN-RETURNED-REASON                                        
MFA-TR*             ,:RN-MANUAL-INDICATOR                                       
MFA-TR*             ,:RN-USER-ID-APPRVD-BY                                      
MFA-TR*             ,:RN-REFUND-STATUS-DT                                       
MFA-TR*             ,:RN-USER-ID-RQSTED-BY                                      
MFA-TR*             ,:RN-RETURNED-DATE    :WS-NULL-DATE-RETURNED                
MFA-TR*             ,:RN-DATE-APPROPRIATED:WS-NULL-DATE-APPROP                  
MFA-TR*             ,:RN-DATE-ESCHEATED   :WS-NULL-DATE-ESCHEATED               
MFA-TR*             ,:RN-PANEL-NO                                               
MFA-TR*             ,:RN-ADDRESS-ID                                             
MFA-TR*             ,:RN-ESCHEAT-RETURN-DT:WS-NULL-DATE-ESCH-RETURNED           
MFA-TR*             ,:RN-ESCHEAT-VERIFY-DT:WS-NULL-DATE-ESCH-VERIFIED           
MFA-TR*             ,:RN-TRANS-HIST-SEQ-NO                                      
MFA-TR*             ,:RN-ESCHEATMENT-CD                                         
MFA-TR*             ,:RN-COMMENTS                                               
MFA-TR*         FROM CSS_REFUND                                                 
MFA-TR*        WHERE ACCOUNT_NO     = :RN-ACCOUNT-NO                            
MFA-TR*          AND REFUND_ITEM_ID = :RN-REFUND-ITEM-ID                        
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7040                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-NULL-DATE-REFUND < 0                                
                 MOVE SPACES               TO RN-DATE-REFUNDED          
                 MOVE ZEROES               TO WS-NULL-DATE-REFUND       
              END-IF                                                    
              IF WS-NULL-DATE-REQUEST < 0                               
                 MOVE SPACES               TO RN-REQUEST-DT             
                 MOVE ZEROES               TO WS-NULL-DATE-REQUEST      
              END-IF                                                    
              IF WS-NULL-DATE-CLEARED < 0                               
                 MOVE SPACES               TO RN-CLEARED-DT             
                 MOVE ZEROES               TO WS-NULL-DATE-CLEARED      
              END-IF                                                    
              IF WS-NULL-DATE-CANCELLED < 0                             
                 MOVE SPACES               TO RN-DATE-CANCELLED         
                 MOVE ZEROES               TO WS-NULL-DATE-CANCELLED    
              END-IF                                                    
              IF WS-NULL-DATE-CHECK-VOID < 0                            
                 MOVE SPACES               TO RN-DATE-CHECK-VOIDED      
                 MOVE ZEROES               TO WS-NULL-DATE-CHECK-VOID   
              END-IF                                                    
              IF WS-NULL-DATE-STOP-REQ < 0                              
                 MOVE SPACES               TO RN-STOP-REQUEST-DT        
                 MOVE ZEROES               TO WS-NULL-DATE-STOP-REQ     
              END-IF                                                    
              IF WS-NULL-DATE-STOP-CONF < 0                             
                 MOVE SPACES               TO RN-STOP-CONFIRM-DT        
                 MOVE ZEROES               TO WS-NULL-DATE-STOP-CONF    
              END-IF                                                    
              IF WS-NULL-DATE-CHK-REMAIL < 0                            
                 MOVE SPACES               TO RN-CHECK-REMAIL-DT        
                 MOVE ZEROES               TO WS-NULL-DATE-CHK-REMAIL   
              END-IF                                                    
              IF WS-NULL-DATE-REISSUED < 0                              
                 MOVE SPACES               TO RN-REISSUED-DATE          
                 MOVE ZEROES               TO WS-NULL-DATE-REISSUED     
              END-IF                                                    
              IF WS-NULL-DATE-RETURNED < 0                              
                 MOVE SPACES               TO RN-RETURNED-DATE          
                 MOVE ZEROES               TO WS-NULL-DATE-RETURNED     
              END-IF                                                    
              IF WS-NULL-DATE-APPROP < 0                                
                 MOVE SPACES               TO RN-DATE-APPROPRIATED      
                 MOVE ZEROES               TO WS-NULL-DATE-APPROP       
              END-IF                                                    
              IF WS-NULL-DATE-ESCHEATED < 0                             
                 MOVE SPACES               TO RN-DATE-ESCHEATED         
                 MOVE ZEROES               TO WS-NULL-DATE-ESCHEATED    
              END-IF                                                    
              IF WS-NULL-DATE-ESCH-RETURNED < 0                         
                 MOVE SPACES               TO RN-ESCHEAT-RETURN-DT      
                 MOVE ZEROES               TO WS-NULL-DATE-ESCH-RETURNED
              END-IF                                                    
              IF WS-NULL-DATE-ESCH-VERIFIED < 0                         
                 MOVE SPACES               TO RN-ESCHEAT-VERIFY-DT      
                 MOVE ZEROES               TO WS-NULL-DATE-ESCH-VERIFIED
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7040'                  TO ACTIVE-PARAGRAPH          
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE SQLCODE                 TO ABEND-SQLCODE             
                                              S-RETURN-CODE             
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE 'CSS_REFUND'            TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE 'REFUND_ITEM_ID'        TO TABLE-ELEMENT-2           
              MOVE RN-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
              MOVE RN-REFUND-ITEM-ID       TO HOSTVAR-ELEMENT-2         
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7500-OPEN-CSR02294                                             *        
      ******************************************************************        
                                                                        
       7500-OPEN-CSR02294.                                              
                                                                        
           INITIALIZE WS-CSR02294-RET-AREA.                             
                                                                        
      *    EXEC SQL CALL CSR02294                                       
      *                ( :WS-2294-ACCOUNT-NO                            
      *                 ,:WS-2294-ITEM-ID                               
      *                 ,:WS-2294-RECV-TYPE                             
      *                 ,:WS-2294-PYMT-PRIORITY-LVL                     
      *                 ,:WS-2294-GL-ACCT-NO                            
      *                 ,:WS-2294-CR-AMT-DAY-00                         
      *                 ,:WS-2294-CR-AMT-DAY-30                         
      *                 ,:WS-2294-CR-AMT-DAY-60                         
      *                 ,:WS-2294-CR-AMT-DAY-90                         
      *                 ,:WS-2294-CR-AMT-TOTAL                          
      *                 ,:WS-2294-DIST-AR-TYPE-SHORT                    
      *                 ,:WS-2294-DIST-PYMT-PRI-LVL                     
      *                 ,:WS-2294-DIST-ITEM-ID                          
      *                 ,:WS-2294-RESP-AREA-ID                          
      *                 ,:WS-2294-USER-ID                               
      *                 ,:WS-2294-AT-LAST-UPDATE-TS                     
      *                 ,:WS-2294-AC-LAST-UPDATE-TS                     
      *                 ,:WS-2294-TRANS-LEN                             
      *                 ,:WS-2294-TRANS-COMMENTS                        
      *                 ,:WS-2294-PRINCIPAL                             
      *                 ,:WS-2294-STATE-TAX                             
      *                 ,:WS-2294-CITY-TAX                              
      *                 ,:WS-2294-OTHER-TAX                             
      *                 ,:WS-2294-DEF-INT                               
      *                 ,:WS-2294-EARNED-INT                            
      *                 ,:WS-2294-CNT-NAME-CD                           
      *                 ,:WS-2294-REVENUE-MONTH                         
      *                )                                                
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE REFUND
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN REFUND
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR REFUND INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF SQLCODE = +466 THEN                                       
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7500'                     TO ACTIVE-PARAGRAPH       
              MOVE 'DB2SP'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSR02294'                 TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE RN-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND                THRU 9700-EXIT  
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7510-FETCH-CSR02294                                            *        
      ******************************************************************        
                                                                        
       7510-FETCH-CSR02294.                                             
                                                                        
           EXEC SQL                                                     
              FETCH REFUND                                              
               INTO :WS-2294-RETURN-CODE                                
                   ,:WS-2294-CANCELDNP-FLAG                             
                   ,:WS-2294-AR-LOCKOUT-IND                             
                   ,:WS-2294-AT-ACCT-XFER-TO                            
                   ,:WS-2294-CANCELNOT-FLAG                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7510'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSR02294'                 TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE RN-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND                THRU 9700-EXIT  
           END-IF.                                                      
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7520-CLOSE-CSR02294                                            *        
      ******************************************************************        
       7520-CLOSE-CSR02294.                                             
                                                                        
           EXEC SQL                                                     
              CLOSE REFUND                                              
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7520'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSR02294'                 TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE RN-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND                THRU 9700-EXIT  
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
P0087A******************************************************************        
P0087A* 7550-OPEN-CSR02171                                             *        
P0087A******************************************************************        
P0087A                                                                  
P0087A 7550-OPEN-CSR02171.                                              
P0087A                                                                  
P0087A     INITIALIZE WS-CSR02171-RET-AREA.                             
P0087A                                                                  
P0087A*    EXEC SQL CALL CSR02171                                       
P0087A*                ( :WS-2171-ACTION-CODE                           
P0087A*                 ,:WS-2171-ACCOUNT-NO                            
P0087A*                 ,:WS-2171-PREMISE-NO                            
P0087A*                 ,:WS-2171-SERVICE-TYPE-CD                       
P0087A*                 ,:WS-2171-DEPOSIT-CERT-NO                       
P0087A*                 ,:WS-2171-CODE-REFUND-REASON                    
P0087A*                 ,:WS-2171-CHECK-ISS-REAS-CD                     
P0087A*                 ,:WS-2171-CMNTS-LEN                             
P0087A*                 ,:WS-2171-CMNTS-TEXT                            
P0087A*                 ,:WS-2171-BALANCE-AMT                           
P0087A*                 ,:WS-2171-THIS-CR-AMT                           
P0087A*                 ,:WS-2171-THIS-AR-TYPE                          
P0087A*                 ,:WS-2171-THIS-ITEM-ID                          
P0087A*                 ,:WS-2171-SPEC-ACCOUNT-NO                       
P0087A*                 ,:WS-2171-SPEC-CR-AMT                           
P0087A*                 ,:WS-2171-SPEC-AR-TYPE                          
P0087A*                 ,:WS-2171-SPEC-ITEM-ID                          
P0087A*                 ,:WS-2171-AMT-CHK                               
P0087A*                 ,:WS-2171-AMT-CASH                              
P0087A*                 ,:WS-2171-CASHIER-CODE                          
P0087A*                 ,:WS-2171-ADDRESS-CHANGED                       
P0087A*                 ,:WS-2171-ADDR-STREET                           
P0087A*                 ,:WS-2171-ADDR-CITY-STATE                       
P0087A*                 ,:WS-2171-ADDR-ZIP-CODE                         
P0087A*                 ,:WS-2171-ADDR-COUNTRY                          
P0087A*                 ,:WS-2171-ADDRESS-OVERFLOW                      
P0087A*                 ,:WS-2171-SUPERVISOR-ID                         
P0087A*                 ,:WS-2171-APPROVE-IND                           
P0087A*                 ,:WS-2171-CD-COMPANY-NO                         
P0087A*                 ,:WS-2171-CD-LOCAL-OFFICE                       
P0087A*                 ,:WS-2171-CD-REPORT-DATE                        
P0087A*                 ,:WS-2171-CD-REPORT-NO                          
P0087A*                 ,:WS-2171-CASH-DRAWER-ID                        
P0087A*                 ,:WS-2171-USER-ID                               
P0087A*                 ,:WS-2171-RESP-AREA-ID                          
P0087A*                 ,:WS-2171-TRAN-CMNT-LEN                         
P0087A*                 ,:WS-2171-TRAN-CMNT-TEXT                        
P0087A*                 ,:WS-2171-CSR-PC-ID                             
P0087A*                 ,:WS-2171-REFUND-TYPE                           
P0087A*                 ,:WS-2171-INTEREST-AMOUNT                       
P0087A*                 ,:WS-2171-SUPERUSER-CD                          
P0087A*                 ,:WS-2171-APPROVE-CHK-IND                       
P0087A*                 ,:WS-2171-LAST-UPDATE-TS                        
P0087A*                 ,:WS-2171-REQUEST-DATE                          
P0087A*                )                                                
P0087A*    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE DEPOSIT
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN DEPOSIT
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR DEPOSIT INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
P0087A                                                                  
P0087A     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P0087A                                                                  
P0087A     IF SQLCODE = +466 THEN                                       
P0087A        CONTINUE                                                  
P0087A     ELSE                                                         
P0087A        MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
P0087A        MOVE SQLCODE                    TO ABEND-SQLCODE          
P0087A        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P0087A        MOVE '7550'                     TO ACTIVE-PARAGRAPH       
P0087A        MOVE 'DB2SP'                    TO ABEND-FUNCTION         
P0087A        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
P0087A                                           ABEND-TABLES           
P0087A        MOVE 'CSR02171'                 TO TABLE-1                
P0087A        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
P0087A        MOVE RN-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
P0087A        PERFORM 9700-PROCESS-ABEND                THRU 9700-EXIT  
P0087A     END-IF.                                                      
P0087A                                                                  
P0087A 7550-EXIT.                                                       
P0087A     EXIT.                                                        
P0087A                                                                  
P0087A******************************************************************        
P0087A* 7560-FETCH-CSR02171                                            *        
P0087A******************************************************************        
P0087A                                                                  
P0087A 7560-FETCH-CSR02171.                                             
P0087A                                                                  
P0087A     EXEC SQL                                                     
P0087A        FETCH DEPOSIT                                             
P0087A         INTO :WS-2171-RETURN-CODE                                
P0087A             ,:WS-2171-ERROR-MESSAGE-NO                           
P0087A             ,:WS-2171-CANCELDNP-FLAG                             
P0087A             ,:WS-2171-CANCELDNP-TO-FLAG                          
P0087A             ,:WS-2171-CANCELNOT-FLAG                             
P0087A             ,:WS-2171-CANCELNOT-TO-FLAG                          
P0087A     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0087A                                                                  
P0087A     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P0087A                                                                  
P0087A     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P0087A        CONTINUE                                                  
P0087A     ELSE                                                         
P0087A        MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
P0087A        MOVE SQLCODE                    TO ABEND-SQLCODE          
P0087A        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P0087A        MOVE '7560'                     TO ACTIVE-PARAGRAPH       
P0087A        MOVE 'FETCH'                    TO ABEND-FUNCTION         
P0087A        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
P0087A                                           ABEND-TABLES           
P0087A        MOVE 'CSR02171'                 TO TABLE-1                
P0087A        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
P0087A        MOVE RN-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
P0087A        PERFORM 9700-PROCESS-ABEND                THRU 9700-EXIT  
P0087A     END-IF.                                                      
P0087A                                                                  
P0087A 7560-EXIT.                                                       
P0087A     EXIT.                                                        
P0087A                                                                  
P0087A******************************************************************        
P0087A* 7570-CLOSE-CSR02171                                            *        
P0087A******************************************************************        
P0087A 7570-CLOSE-CSR02171.                                             
P0087A                                                                  
P0087A     EXEC SQL                                                     
P0087A        CLOSE DEPOSIT                                             
P0087A     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0087A                                                                  
P0087A     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
P0087A                                                                  
P0087A     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P0087A        CONTINUE                                                  
P0087A     ELSE                                                         
P0087A        MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
P0087A        MOVE SQLCODE                    TO ABEND-SQLCODE          
P0087A        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P0087A        MOVE '7570'                     TO ACTIVE-PARAGRAPH       
P0087A        MOVE 'CLOSE'                    TO ABEND-FUNCTION         
P0087A        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
P0087A                                           ABEND-TABLES           
P0087A        MOVE 'CSR02171'                 TO TABLE-1                
P0087A        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
P0087A        MOVE RN-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
P0087A        PERFORM 9700-PROCESS-ABEND                THRU 9700-EXIT  
P0087A     END-IF.                                                      
P0087A                                                                  
P0087A 7570-EXIT.                                                       
P0087A     EXIT.                                                        
P0087A                                                                  
      ******************************************************************        
      * 7999-SELECT-AL                                                 *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00075                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 8020-INSERT-AR-TRANS-HIST                                      *        
      ******************************************************************        
                                                                        
       8020-INSERT-AR-TRANS-HIST.                                       
                                                                        
           IF AR-DATE-TRANS <= SPACES                                   
              MOVE -1                  TO WS-AR-NULL-IND-1              
           ELSE                                                         
              MOVE 0                   TO WS-AR-NULL-IND-1              
           END-IF                                                       
                                                                        
           IF AR-DATE-ORIG-PYMT <= SPACES                               
              MOVE -1                  TO WS-AR-NULL-IND-2              
           ELSE                                                         
              MOVE 0                   TO WS-AR-NULL-IND-2              
           END-IF                                                       
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_AR_TRANS_HIST                           
                       (ACCOUNT_NO,                                     
                        TRANS_HIST_SEQ_NO,                              
                        DATE_TRANS,                                     
                        CODE_TRAN_TYPE,                                 
                        AMT_ORIG_ENTERED,                               
                        AMT_BILLED_UNPAID,                              
                        RESP_AREA_ID,                                   
                        APPL_PROGRAM_ID,                                
                        PYMT_FACILITY_CD,                               
                        USER_ID,                                        
                        COMPANY_NO,                                     
                        RECORD_ONLY_FL,                                 
                        DATE_ORIG_PYMT,                                 
                        PYMT_REFUNDED_IND,                              
                        CASH_COMPANY_NO,                                
                        CASH_LOCAL_OFFICE,                              
                        CASH_REPORT_NO,                                 
                        DATE_CASH_REPORT,                               
                        CASH_DRAWER_ID,                                 
                        TRAN_COMMENT)                                   
                VALUES                                                  
                      (:AR-ACCOUNT-NO,                                  
                       CIS.CHAR2TIMESTAMP(:AR-TRANS-HIST-SEQ-NO),               
                       IIF(TRY_CONVERT(DATE, :AR-DATE-TRANS 
                                             :WS-AR-NULL-IND-1
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS 
                                                      :WS-AR-NULL-IND-1
              ) <> 0) OR (LEN(:AR-DATE-TRANS :WS-AR-NULL-IND-1
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-TRANS :WS-AR-NULL-IND-1
              ), CONVERT(DATE, :AR-DATE-TRANS :WS-AR-NULL-IND-1) ),            
                       :AR-CODE-TRAN-TYPE,                              
                       :AR-AMT-ORIG-ENTERED,                            
                       :AR-AMT-BILLED-UNPAID,                           
                       :AR-RESP-AREA-ID,                                
                       :AR-APPL-PROGRAM-ID,                             
                       :AR-PYMT-FACILITY-CD,                            
                       :AR-USER-ID,                                     
                       :AR-COMPANY-NO,                                  
                       :AR-RECORD-ONLY-FL,                              
                       IIF(TRY_CONVERT(DATE, :AR-DATE-ORIG-PYMT 
                                             :WS-AR-NULL-IND-2
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-ORIG-PYMT 
                                                      :WS-AR-NULL-IND-2
              ) <> 0) OR (LEN(:AR-DATE-ORIG-PYMT :WS-AR-NULL-IND-2
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-ORIG-PYMT 
                                                      :WS-AR-NULL-IND-2
              ), CONVERT(DATE, :AR-DATE-ORIG-PYMT :WS-AR-NULL-IND-2) ),        
                       :AR-PYMT-REFUNDED-IND,                           
                       :AR-CASH-COMPANY-NO,                             
                       :AR-CASH-LOCAL-OFFICE,                           
                       :AR-CASH-REPORT-NO,                              
                       IIF(TRY_CONVERT(DATE, :AR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:AR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-CASH-REPORT
              ), CONVERT(DATE, :AR-DATE-CASH-REPORT) ),                        
                       :AR-CASH-DRAWER-ID,                              
                       :AR-TRAN-COMMENT)                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_AR_TRANS_HIST                                   
MFA-TR*                (ACCOUNT_NO,                                             
MFA-TR*                 TRANS_HIST_SEQ_NO,                                      
MFA-TR*                 DATE_TRANS,                                             
MFA-TR*                 CODE_TRAN_TYPE,                                         
MFA-TR*                 AMT_ORIG_ENTERED,                                       
MFA-TR*                 AMT_BILLED_UNPAID,                                      
MFA-TR*                 RESP_AREA_ID,                                           
MFA-TR*                 APPL_PROGRAM_ID,                                        
MFA-TR*                 PYMT_FACILITY_CD,                                       
MFA-TR*                 USER_ID,                                                
MFA-TR*                 COMPANY_NO,                                             
MFA-TR*                 RECORD_ONLY_FL,                                         
MFA-TR*                 DATE_ORIG_PYMT,                                         
MFA-TR*                 PYMT_REFUNDED_IND,                                      
MFA-TR*                 CASH_COMPANY_NO,                                        
MFA-TR*                 CASH_LOCAL_OFFICE,                                      
MFA-TR*                 CASH_REPORT_NO,                                         
MFA-TR*                 DATE_CASH_REPORT,                                       
MFA-TR*                 CASH_DRAWER_ID,                                         
MFA-TR*                 TRAN_COMMENT)                                           
MFA-TR*         VALUES                                                          
MFA-TR*               (:AR-ACCOUNT-NO,                                          
MFA-TR*                :AR-TRANS-HIST-SEQ-NO,                                   
MFA-TR*                :AR-DATE-TRANS:WS-AR-NULL-IND-1,                         
MFA-TR*                :AR-CODE-TRAN-TYPE,                                      
MFA-TR*                :AR-AMT-ORIG-ENTERED,                                    
MFA-TR*                :AR-AMT-BILLED-UNPAID,                                   
MFA-TR*                :AR-RESP-AREA-ID,                                        
MFA-TR*                :AR-APPL-PROGRAM-ID,                                     
MFA-TR*                :AR-PYMT-FACILITY-CD,                                    
MFA-TR*                :AR-USER-ID,                                             
MFA-TR*                :AR-COMPANY-NO,                                          
MFA-TR*                :AR-RECORD-ONLY-FL,                                      
MFA-TR*                :AR-DATE-ORIG-PYMT:WS-AR-NULL-IND-2,                     
MFA-TR*                :AR-PYMT-REFUNDED-IND,                                   
MFA-TR*                :AR-CASH-COMPANY-NO,                                     
MFA-TR*                :AR-CASH-LOCAL-OFFICE,                                   
MFA-TR*                :AR-CASH-REPORT-NO,                                      
MFA-TR*                :AR-DATE-CASH-REPORT,                                    
MFA-TR*                :AR-CASH-DRAWER-ID,                                      
MFA-TR*                :AR-TRAN-COMMENT)                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8020'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT '                TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'CSS_AR_TRANS_HIST'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'TRANS_HIST_SEQ_NO'      TO TABLE-ELEMENT-2          
              MOVE 'DATE_TRANS'             TO TABLE-ELEMENT-3          
              MOVE 'CODE_TRAN_TYPE'         TO TABLE-ELEMENT-4          
              MOVE AR-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE AR-TRANS-HIST-SEQ-NO     TO HOSTVAR-ELEMENT-2        
              MOVE AR-DATE-TRANS            TO HOSTVAR-ELEMENT-3        
              MOVE AR-CODE-TRAN-TYPE        TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8310-UPDATE-REFUND.                                            *        
      ******************************************************************        
                                                                        
       8310-UPDATE-REFUND.                                              
                                                                        
           IF RN-DATE-REFUNDED <= SPACES                                
              MOVE -1                  TO WS-NULL-DATE-REFUND           
           ELSE                                                         
              MOVE 0                   TO WS-NULL-DATE-REFUND           
           END-IF                                                       
                                                                        
           IF RN-REQUEST-DT <= SPACES                                   
              MOVE -1                  TO WS-NULL-DATE-REQUEST          
           ELSE                                                         
              MOVE 0                   TO WS-NULL-DATE-REQUEST          
           END-IF                                                       
                                                                        
           IF RN-CLEARED-DT <= SPACES                                   
              MOVE -1                  TO WS-NULL-DATE-CLEARED          
           ELSE                                                         
              MOVE 0                   TO WS-NULL-DATE-CLEARED          
           END-IF                                                       
                                                                        
           IF RN-DATE-CANCELLED <= SPACES                               
              MOVE -1                  TO WS-NULL-DATE-CANCELLED        
           ELSE                                                         
              MOVE 0                   TO WS-NULL-DATE-CANCELLED        
           END-IF                                                       
                                                                        
           IF RN-DATE-CHECK-VOIDED <= SPACES                            
              MOVE -1                  TO WS-NULL-DATE-CHECK-VOID       
           ELSE                                                         
              MOVE 0                   TO WS-NULL-DATE-CHECK-VOID       
           END-IF                                                       
                                                                        
           IF RN-STOP-REQUEST-DT <= SPACES                              
              MOVE -1                  TO WS-NULL-DATE-STOP-REQ         
           ELSE                                                         
              MOVE 0                   TO WS-NULL-DATE-STOP-REQ         
           END-IF                                                       
                                                                        
           IF RN-STOP-CONFIRM-DT <= SPACES                              
              MOVE -1                  TO WS-NULL-DATE-STOP-CONF        
           ELSE                                                         
              MOVE 0                   TO WS-NULL-DATE-STOP-CONF        
           END-IF                                                       
                                                                        
           IF RN-CHECK-REMAIL-DT <= SPACES                              
              MOVE -1                  TO WS-NULL-DATE-CHK-REMAIL       
           ELSE                                                         
              MOVE 0                   TO WS-NULL-DATE-CHK-REMAIL       
           END-IF                                                       
                                                                        
           IF RN-REISSUED-DATE <= SPACES                                
              MOVE -1                  TO WS-NULL-DATE-REISSUED         
           ELSE                                                         
              MOVE 0                   TO WS-NULL-DATE-REISSUED         
           END-IF                                                       
                                                                        
           IF RN-RETURNED-DATE <= SPACES                                
              MOVE -1                  TO WS-NULL-DATE-RETURNED         
           ELSE                                                         
              MOVE 0                   TO WS-NULL-DATE-RETURNED         
           END-IF                                                       
                                                                        
           IF RN-DATE-APPROPRIATED <= SPACES                            
              MOVE -1                  TO WS-NULL-DATE-APPROP           
           ELSE                                                         
              MOVE 0                   TO WS-NULL-DATE-APPROP           
           END-IF                                                       
                                                                        
           IF RN-DATE-ESCHEATED <= SPACES                               
              MOVE -1                  TO WS-NULL-DATE-ESCHEATED        
           ELSE                                                         
              MOVE 0                   TO WS-NULL-DATE-ESCHEATED        
           END-IF                                                       
                                                                        
           IF RN-ESCHEAT-RETURN-DT <= SPACES                            
              MOVE -1                  TO WS-NULL-DATE-ESCH-RETURNED    
           ELSE                                                         
              MOVE 0                   TO WS-NULL-DATE-ESCH-RETURNED    
           END-IF                                                       
                                                                        
           IF RN-ESCHEAT-VERIFY-DT <= SPACES                            
              MOVE -1                  TO WS-NULL-DATE-ESCH-VERIFIED    
           ELSE                                                         
              MOVE 0                   TO WS-NULL-DATE-ESCH-VERIFIED    
           END-IF                                                       
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_REFUND                                         
                 SET DATE_REFUNDED        = IIF(TRY_CONVERT(DATE, 
                                                     :RN-DATE-REFUNDED 
                                                   :WS-NULL-DATE-REFUND
              ) IS NULL OR (PATINDEX('%.%', :RN-DATE-REFUNDED 
                                                   :WS-NULL-DATE-REFUND
              ) <> 0) OR (LEN(:RN-DATE-REFUNDED :WS-NULL-DATE-REFUND
              ) <> 10), CIS.CHAR2DATE(:RN-DATE-REFUNDED 
                                                   :WS-NULL-DATE-REFUND
              ), CONVERT(DATE, :RN-DATE-REFUNDED :WS-NULL-DATE-REFUND
              ) )        
                    ,REQUEST_DT           = IIF(TRY_CONVERT(DATE, 
                                                        :RN-REQUEST-DT 
                                                  :WS-NULL-DATE-REQUEST
              ) IS NULL OR (PATINDEX('%.%', :RN-REQUEST-DT 
                                                  :WS-NULL-DATE-REQUEST
              ) <> 0) OR (LEN(:RN-REQUEST-DT :WS-NULL-DATE-REQUEST
              ) <> 10), CIS.CHAR2DATE(:RN-REQUEST-DT 
                                                  :WS-NULL-DATE-REQUEST
              ), CONVERT(DATE, :RN-REQUEST-DT :WS-NULL-DATE-REQUEST) )       
                    ,CLEARED_DT           = IIF(TRY_CONVERT(DATE, 
                                                        :RN-CLEARED-DT 
                                                  :WS-NULL-DATE-CLEARED
              ) IS NULL OR (PATINDEX('%.%', :RN-CLEARED-DT 
                                                  :WS-NULL-DATE-CLEARED
              ) <> 0) OR (LEN(:RN-CLEARED-DT :WS-NULL-DATE-CLEARED
              ) <> 10), CIS.CHAR2DATE(:RN-CLEARED-DT 
                                                  :WS-NULL-DATE-CLEARED
              ), CONVERT(DATE, :RN-CLEARED-DT :WS-NULL-DATE-CLEARED) )       
                    ,DATE_CANCELLED       = IIF(TRY_CONVERT(DATE, 
                                                    :RN-DATE-CANCELLED 
                                                :WS-NULL-DATE-CANCELLED
              ) IS NULL OR (PATINDEX('%.%', :RN-DATE-CANCELLED 
                                                :WS-NULL-DATE-CANCELLED
              ) <> 0) OR (LEN(:RN-DATE-CANCELLED 
                                                :WS-NULL-DATE-CANCELLED
              ) <> 10), CIS.CHAR2DATE(:RN-DATE-CANCELLED 
                                                :WS-NULL-DATE-CANCELLED
              ), CONVERT(DATE, :RN-DATE-CANCELLED 
                                                :WS-NULL-DATE-CANCELLED
              ) )     
                    ,DATE_CHECK_VOIDED    = IIF(TRY_CONVERT(DATE, 
                                                 :RN-DATE-CHECK-VOIDED 
                                               :WS-NULL-DATE-CHECK-VOID
              ) IS NULL OR (PATINDEX('%.%', :RN-DATE-CHECK-VOIDED 
                                               :WS-NULL-DATE-CHECK-VOID
              ) <> 0) OR (LEN(:RN-DATE-CHECK-VOIDED 
                                               :WS-NULL-DATE-CHECK-VOID
              ) <> 10), CIS.CHAR2DATE(:RN-DATE-CHECK-VOIDED 
                                               :WS-NULL-DATE-CHECK-VOID
              ), CONVERT(DATE, :RN-DATE-CHECK-VOIDED 
                                               :WS-NULL-DATE-CHECK-VOID
              ) )    
                    ,STOP_REQUEST_DT      = IIF(TRY_CONVERT(DATE, 
                                                   :RN-STOP-REQUEST-DT 
                                                 :WS-NULL-DATE-STOP-REQ
              ) IS NULL OR (PATINDEX('%.%', :RN-STOP-REQUEST-DT 
                                                 :WS-NULL-DATE-STOP-REQ
              ) <> 0) OR (LEN(:RN-STOP-REQUEST-DT 
                                                 :WS-NULL-DATE-STOP-REQ
              ) <> 10), CIS.CHAR2DATE(:RN-STOP-REQUEST-DT 
                                                 :WS-NULL-DATE-STOP-REQ
              ), CONVERT(DATE, :RN-STOP-REQUEST-DT 
                                                 :WS-NULL-DATE-STOP-REQ
              ) )      
                    ,STOP_CONFIRM_DT      = IIF(TRY_CONVERT(DATE, 
                                                   :RN-STOP-CONFIRM-DT 
                                                :WS-NULL-DATE-STOP-CONF
              ) IS NULL OR (PATINDEX('%.%', :RN-STOP-CONFIRM-DT 
                                                :WS-NULL-DATE-STOP-CONF
              ) <> 0) OR (LEN(:RN-STOP-CONFIRM-DT 
                                                :WS-NULL-DATE-STOP-CONF
              ) <> 10), CIS.CHAR2DATE(:RN-STOP-CONFIRM-DT 
                                                :WS-NULL-DATE-STOP-CONF
              ), CONVERT(DATE, :RN-STOP-CONFIRM-DT 
                                                :WS-NULL-DATE-STOP-CONF
              ) )     
                    ,CHECK_REMAIL_DT      = IIF(TRY_CONVERT(DATE, 
                                                   :RN-CHECK-REMAIL-DT 
                                               :WS-NULL-DATE-CHK-REMAIL
              ) IS NULL OR (PATINDEX('%.%', :RN-CHECK-REMAIL-DT 
                                               :WS-NULL-DATE-CHK-REMAIL
              ) <> 0) OR (LEN(:RN-CHECK-REMAIL-DT 
                                               :WS-NULL-DATE-CHK-REMAIL
              ) <> 10), CIS.CHAR2DATE(:RN-CHECK-REMAIL-DT 
                                               :WS-NULL-DATE-CHK-REMAIL
              ), CONVERT(DATE, :RN-CHECK-REMAIL-DT 
                                               :WS-NULL-DATE-CHK-REMAIL
              ) )    
                    ,CHECK_STATUS_CD      = :RN-CHECK-STATUS-CD         
                    ,CHECK_ISS_REAS_CD    = :RN-CHECK-ISS-REAS-CD       
                    ,REISSUED_DATE        = IIF(TRY_CONVERT(DATE, 
                                                     :RN-REISSUED-DATE 
                                                 :WS-NULL-DATE-REISSUED
              ) IS NULL OR (PATINDEX('%.%', :RN-REISSUED-DATE 
                                                 :WS-NULL-DATE-REISSUED
              ) <> 0) OR (LEN(:RN-REISSUED-DATE :WS-NULL-DATE-REISSUED
              ) <> 10), CIS.CHAR2DATE(:RN-REISSUED-DATE 
                                                 :WS-NULL-DATE-REISSUED
              ), CONVERT(DATE, :RN-REISSUED-DATE :WS-NULL-DATE-REISSUED
              ) )      
                    ,RETURNED_REASON      = :RN-RETURNED-REASON         
                    ,MANUAL_INDICATOR     = :RN-MANUAL-INDICATOR        
                    ,REFUND_STATUS_DT     = IIF(TRY_CONVERT(DATE, 
                                                   :RN-REFUND-STATUS-DT
              ) IS NULL OR (PATINDEX('%.%', :RN-REFUND-STATUS-DT
              ) <> 0) OR (LEN(:RN-REFUND-STATUS-DT
              ) <> 10), CIS.CHAR2DATE(:RN-REFUND-STATUS-DT
              ), CONVERT(DATE, :RN-REFUND-STATUS-DT) )        
                    ,USER_ID_RQSTED_BY    = :RN-USER-ID-RQSTED-BY       
                    ,RETURNED_DATE        = IIF(TRY_CONVERT(DATE, 
                                                     :RN-RETURNED-DATE 
                                                 :WS-NULL-DATE-RETURNED
              ) IS NULL OR (PATINDEX('%.%', :RN-RETURNED-DATE 
                                                 :WS-NULL-DATE-RETURNED
              ) <> 0) OR (LEN(:RN-RETURNED-DATE :WS-NULL-DATE-RETURNED
              ) <> 10), CIS.CHAR2DATE(:RN-RETURNED-DATE 
                                                 :WS-NULL-DATE-RETURNED
              ), CONVERT(DATE, :RN-RETURNED-DATE :WS-NULL-DATE-RETURNED
              ) )      
                    ,DATE_APPROPRIATED    = IIF(TRY_CONVERT(DATE, 
                                                 :RN-DATE-APPROPRIATED 
                                                   :WS-NULL-DATE-APPROP
              ) IS NULL OR (PATINDEX('%.%', :RN-DATE-APPROPRIATED 
                                                   :WS-NULL-DATE-APPROP
              ) <> 0) OR (LEN(:RN-DATE-APPROPRIATED 
                                                   :WS-NULL-DATE-APPROP
              ) <> 10), CIS.CHAR2DATE(:RN-DATE-APPROPRIATED 
                                                   :WS-NULL-DATE-APPROP
              ), CONVERT(DATE, :RN-DATE-APPROPRIATED 
                                                   :WS-NULL-DATE-APPROP
              ) )        
                    ,DATE_ESCHEATED       = IIF(TRY_CONVERT(DATE, 
                                                    :RN-DATE-ESCHEATED 
                                                :WS-NULL-DATE-ESCHEATED
              ) IS NULL OR (PATINDEX('%.%', :RN-DATE-ESCHEATED 
                                                :WS-NULL-DATE-ESCHEATED
              ) <> 0) OR (LEN(:RN-DATE-ESCHEATED 
                                                :WS-NULL-DATE-ESCHEATED
              ) <> 10), CIS.CHAR2DATE(:RN-DATE-ESCHEATED 
                                                :WS-NULL-DATE-ESCHEATED
              ), CONVERT(DATE, :RN-DATE-ESCHEATED 
                                                :WS-NULL-DATE-ESCHEATED
              ) )     
                    ,ADDRESS_ID           = :RN-ADDRESS-ID              
                    ,ESCHEAT_RETURN_DT    = IIF(TRY_CONVERT(DATE, 
                                                 :RN-ESCHEAT-RETURN-DT 
                                            :WS-NULL-DATE-ESCH-RETURNED
              ) IS NULL OR (PATINDEX('%.%', :RN-ESCHEAT-RETURN-DT 
                                            :WS-NULL-DATE-ESCH-RETURNED
              ) <> 0) OR (LEN(:RN-ESCHEAT-RETURN-DT 
                                            :WS-NULL-DATE-ESCH-RETURNED
              ) <> 10), CIS.CHAR2DATE(:RN-ESCHEAT-RETURN-DT 
                                            :WS-NULL-DATE-ESCH-RETURNED
              ), CONVERT(DATE, :RN-ESCHEAT-RETURN-DT 
                                            :WS-NULL-DATE-ESCH-RETURNED
              ) ) 
                    ,ESCHEAT_VERIFY_DT    = IIF(TRY_CONVERT(DATE, 
                                                 :RN-ESCHEAT-VERIFY-DT 
                                            :WS-NULL-DATE-ESCH-VERIFIED
              ) IS NULL OR (PATINDEX('%.%', :RN-ESCHEAT-VERIFY-DT 
                                            :WS-NULL-DATE-ESCH-VERIFIED
              ) <> 0) OR (LEN(:RN-ESCHEAT-VERIFY-DT 
                                            :WS-NULL-DATE-ESCH-VERIFIED
              ) <> 10), CIS.CHAR2DATE(:RN-ESCHEAT-VERIFY-DT 
                                            :WS-NULL-DATE-ESCH-VERIFIED
              ), CONVERT(DATE, :RN-ESCHEAT-VERIFY-DT 
                                            :WS-NULL-DATE-ESCH-VERIFIED
              ) ) 
                    ,TRANS_HIST_SEQ_NO    = CIS.CHAR2TIMESTAMP(
                                                  :RN-TRANS-HIST-SEQ-NO
              )       
                    ,ESCHEATMENT_CD       = :RN-ESCHEATMENT-CD          
                    ,REFUND_CHECK_NO      = :RN-REFUND-CHECK-NO         
               WHERE ACCOUNT_NO             = :RN-ACCOUNT-NO            
                 AND REFUND_ITEM_ID         = :RN-REFUND-ITEM-ID        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_REFUND                                                 
MFA-TR*          SET DATE_REFUNDED        = :RN-DATE-REFUNDED                   
MFA-TR*                                     :WS-NULL-DATE-REFUND                
MFA-TR*             ,REQUEST_DT           = :RN-REQUEST-DT                      
MFA-TR*                                     :WS-NULL-DATE-REQUEST               
MFA-TR*             ,CLEARED_DT           = :RN-CLEARED-DT                      
MFA-TR*                                     :WS-NULL-DATE-CLEARED               
MFA-TR*             ,DATE_CANCELLED       = :RN-DATE-CANCELLED                  
MFA-TR*                                     :WS-NULL-DATE-CANCELLED             
MFA-TR*             ,DATE_CHECK_VOIDED    = :RN-DATE-CHECK-VOIDED               
MFA-TR*                                     :WS-NULL-DATE-CHECK-VOID            
MFA-TR*             ,STOP_REQUEST_DT      = :RN-STOP-REQUEST-DT                 
MFA-TR*                                     :WS-NULL-DATE-STOP-REQ              
MFA-TR*             ,STOP_CONFIRM_DT      = :RN-STOP-CONFIRM-DT                 
MFA-TR*                                     :WS-NULL-DATE-STOP-CONF             
MFA-TR*             ,CHECK_REMAIL_DT      = :RN-CHECK-REMAIL-DT                 
MFA-TR*                                     :WS-NULL-DATE-CHK-REMAIL            
MFA-TR*             ,CHECK_STATUS_CD      = :RN-CHECK-STATUS-CD                 
MFA-TR*             ,CHECK_ISS_REAS_CD    = :RN-CHECK-ISS-REAS-CD               
MFA-TR*             ,REISSUED_DATE        = :RN-REISSUED-DATE                   
MFA-TR*                                     :WS-NULL-DATE-REISSUED              
MFA-TR*             ,RETURNED_REASON      = :RN-RETURNED-REASON                 
MFA-TR*             ,MANUAL_INDICATOR     = :RN-MANUAL-INDICATOR                
MFA-TR*             ,REFUND_STATUS_DT     = :RN-REFUND-STATUS-DT                
MFA-TR*             ,USER_ID_RQSTED_BY    = :RN-USER-ID-RQSTED-BY               
MFA-TR*             ,RETURNED_DATE        = :RN-RETURNED-DATE                   
MFA-TR*                                     :WS-NULL-DATE-RETURNED              
MFA-TR*             ,DATE_APPROPRIATED    = :RN-DATE-APPROPRIATED               
MFA-TR*                                     :WS-NULL-DATE-APPROP                
MFA-TR*             ,DATE_ESCHEATED       = :RN-DATE-ESCHEATED                  
MFA-TR*                                     :WS-NULL-DATE-ESCHEATED             
MFA-TR*             ,ADDRESS_ID           = :RN-ADDRESS-ID                      
MFA-TR*             ,ESCHEAT_RETURN_DT    = :RN-ESCHEAT-RETURN-DT               
MFA-TR*                                     :WS-NULL-DATE-ESCH-RETURNED         
MFA-TR*             ,ESCHEAT_VERIFY_DT    = :RN-ESCHEAT-VERIFY-DT               
MFA-TR*                                     :WS-NULL-DATE-ESCH-VERIFIED         
MFA-TR*             ,TRANS_HIST_SEQ_NO    = :RN-TRANS-HIST-SEQ-NO               
MFA-TR*             ,ESCHEATMENT_CD       = :RN-ESCHEATMENT-CD                  
MFA-TR*             ,REFUND_CHECK_NO      = :RN-REFUND-CHECK-NO                 
MFA-TR*        WHERE ACCOUNT_NO             = :RN-ACCOUNT-NO                    
MFA-TR*          AND REFUND_ITEM_ID         = :RN-REFUND-ITEM-ID                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8310'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'CSS_REFUND'             TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE WS-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'REFUND_ITEM_ID'         TO TABLE-ELEMENT-2          
              MOVE RN-REFUND-ITEM-ID        TO HOSTVAR-ELEMENT-2        
              MOVE 'TRANS_HIST_SEQ_NO'      TO TABLE-ELEMENT-3          
              MOVE WS-TRANS-HIST-SEQ-NO     TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8320-UPDATE-REFUND-DTLS                                                 
      ******************************************************************        
                                                                        
       8320-UPDATE-REFUND-DTLS.                                         
                                                                        
           IF RN-REQUEST-DT <= SPACES                                   
              MOVE -1                  TO WS-NULL-DATE-REQUEST          
           ELSE                                                         
              MOVE 0                   TO WS-NULL-DATE-REQUEST          
           END-IF                                                       
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_REFUND                                         
                 SET REQUEST_DT        = IIF(TRY_CONVERT(DATE, 
                                                        :RN-REQUEST-DT 
                                                  :WS-NULL-DATE-REQUEST
              ) IS NULL OR (PATINDEX('%.%', :RN-REQUEST-DT 
                                                  :WS-NULL-DATE-REQUEST
              ) <> 0) OR (LEN(:RN-REQUEST-DT :WS-NULL-DATE-REQUEST
              ) <> 10), CIS.CHAR2DATE(:RN-REQUEST-DT 
                                                  :WS-NULL-DATE-REQUEST
              ), CONVERT(DATE, :RN-REQUEST-DT :WS-NULL-DATE-REQUEST) ),        
                     CHECK_STATUS_CD   = :RN-CHECK-STATUS-CD,           
                     USER_ID_APPRVD_BY = :RN-USER-ID-APPRVD-BY          
               WHERE ACCOUNT_NO        = :RN-ACCOUNT-NO                 
                 AND REFUND_ITEM_ID    = :RN-REFUND-ITEM-ID             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_REFUND                                                 
MFA-TR*          SET REQUEST_DT        = :RN-REQUEST-DT                         
MFA-TR*                                  :WS-NULL-DATE-REQUEST,                 
MFA-TR*              CHECK_STATUS_CD   = :RN-CHECK-STATUS-CD,                   
MFA-TR*              USER_ID_APPRVD_BY = :RN-USER-ID-APPRVD-BY                  
MFA-TR*        WHERE ACCOUNT_NO        = :RN-ACCOUNT-NO                         
MFA-TR*          AND REFUND_ITEM_ID    = :RN-REFUND-ITEM-ID                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8320'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'CSS_REFUND'             TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'REFUND_ITEM_ID'         TO TABLE-ELEMENT-2          
              MOVE 'MANUAL_INDICATOR'       TO TABLE-ELEMENT-3          
              MOVE 'TRANS_HIST_SEQ_NO'      TO TABLE-ELEMENT-4          
              MOVE RN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE RN-REFUND-ITEM-ID        TO HOSTVAR-ELEMENT-2        
              MOVE RN-MANUAL-INDICATOR      TO HOSTVAR-ELEMENT-3        
              MOVE RN-TRANS-HIST-SEQ-NO     TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8900-SEND-DONE                                                 *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
