       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04889.                                         
       AUTHOR.        AARON ABRAHAM                                     
COB303 DATE-WRITTEN.  APR 04, 2016.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *  THIS PROCEDURE RETRIEVES REFUND DATA FOR REGULAR & ARCHIVED   *        
      *  ACCOUNTS.                                                     *        
      *                                                                *        
      *  #  INVOKED FROM ACCOUNT RECEIVABLE SOLUTION/REFUND PROJECT    *        
      *                                                                *        
      *  #  BUSOP NAME: REQUGETACCTREFUNDSBUSINESSOP                   *        
      *                                                                *        
      *  #  PARAMETERS                                                 *        
      *     IN                                                         *        
      *       ACCOUNT_NO               DECIMAL(13, 0)                  *        
      ******************************************************************        
      *                     PROGRAM MODIFICATION LOG                   *        
      ******************************************************************        
      * ---------- -------- ------------------------------------------ *        
      *    DATE    INITIALS COMMENTS                                   *        
      * ---------- -------- ------------------------------------------ *        
P00870* 04/04/2016 AA97148  INITIAL IMPLEMENTATION.                    *        
      *                                                                *        
      ******************************************************************        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      ******************************************************************        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04889'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04889 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCOUNT           - AT                                  *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ADDR_FORMATTED    - DY                                  *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_NAME_ACCT_XREF    - HT                                  *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ADDR_FREEFORM     - DZ                                  *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_NAME              - DQ                                  *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_PREMISE           - PR                                  *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    HST_ACCOUNT           - HA                                  *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBHACCT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    HST_REFUND            - HU                                  *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBHREFUN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_REFUND            - RN                                  *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBREFUND                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ZIP_CODE          - A4                                  *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    ERROR HANDLING                                              *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WORK-FIELDS.                                                 
           05  PROGRAM-NAME             PIC X(08)      VALUE 'CSR04889'.
           05  WS-AT-ADDRESS-ID         PIC S9(13)V COMP-3              
                                                       VALUE 0.         
           05  WS-ADDRESS-ID            PIC S9(13)V COMP-3              
                                                       VALUE 0.         
           05  WS-PREMISE-NO            PIC S9(10)V COMP-3              
                                                       VALUE 0.         
           05  WS-AT-ADDRESS-FORMAT     PIC X(01)      VALUE SPACES.    
           05  WS-ADDRESS-FORMAT        PIC X(01)      VALUE SPACES.    
           05  WS-ACCT-TBL-FND          PIC X(01)      VALUE SPACES.    
           05  WS-PREM-TBL-FND          PIC X(01)      VALUE SPACES.    
           05  WS-ARCHIVED-FL           PIC X(01)      VALUE SPACES.    
           05  WS-SUB1                  PIC S9(4) COMP VALUE 0.         
           05  WS-SUB2                  PIC S9(4) COMP VALUE 0.         
           05  SEND-DONE-SW             PIC X(01)      VALUE 'Y'.       
               88 SEND-DONE-ERROR                      VALUE 'N'.       
               88 SEND-DONE-OK                         VALUE 'Y'.       
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                 PIC S9(9) COMP VALUE 0.         
           05  WS-TBL-COUNT             PIC S9(9) COMP VALUE 0.         
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  GTT-RETURN-FIELDS-1.                                     
               10 S-RETURN-CODE         PIC S9(4) COMP VALUE 0.         
               10 S-REFUND-ITEM-ID      PIC S9(9) COMP VALUE +0.        
               10 S-REFUND-CHECK-NO     PIC X(9)       VALUE SPACES.    
               10 S-DEPOSIT-CERT-NO     PIC S9(9) COMP VALUE +0.        
               10 S-LOCAL-OFFICE        PIC X(3)       VALUE SPACES.    
               10 S-REQUEST-DT          PIC X(10)      VALUE SPACES.    
               10 S-CLEARED-DT          PIC X(10)      VALUE SPACES.    
               10 S-DATE-CANCELLED      PIC X(10)      VALUE SPACES.    
               10 S-DATE-CHECK-VOIDED   PIC X(10)      VALUE SPACES.    
               10 S-STOP-REQUEST-DT     PIC X(10)      VALUE SPACES.    
               10 S-STOP-CONFIRM-DT     PIC X(10)      VALUE SPACES.    
               10 S-CHECK-REMAIL-DT     PIC X(10)      VALUE SPACES.    
               10 S-REISSUED-DATE       PIC X(10)      VALUE SPACES.    
               10 S-ORIGINAL-CHECK-NO   PIC X(9)       VALUE SPACES.    
               10 S-RETURNED-REASON     PIC X(1)       VALUE SPACES.    
               10 S-USER-ID-APPRVD-BY   PIC X(7)       VALUE SPACES.    
               10 S-USER-ID-RQSTED-BY   PIC X(7)       VALUE SPACES.    
               10 S-RETURNED-DATE       PIC X(10)      VALUE SPACES.    
               10 S-DATE-APPROPRIATED   PIC X(10)      VALUE SPACES.    
               10 S-DATE-ESCHEATED      PIC X(10)      VALUE SPACES.    
               10 S-COMMENTS            PIC X(72)      VALUE SPACES.    
               10 S-AMT-REFUNDED        PIC S999999999V99 COMP-3        
                                                       VALUE 0.         
               10 S-MANUAL-INDICATOR    PIC X(1)       VALUE SPACES.    
               10 S-DATE-REFUNDED       PIC X(10)      VALUE SPACES.    
               10 S-CHECK-ISS-REAS-CD   PIC X(2)       VALUE SPACES.    
               10 S-CHECK-STATUS-CD     PIC X(1)       VALUE SPACES.    
               10 S-REFUND-STATUS-DT    PIC X(10)      VALUE SPACES.    
               10 S-DATE-ESCH-VERIFIED  PIC X(10)      VALUE SPACES.    
               10 S-DATE-ESCH-RETURNED  PIC X(10)      VALUE SPACES.    
               10 S-PANEL-NO            PIC X(04)      VALUE SPACES.    
               10 S-TRANS-HIST-SEQ-NO   PIC X(26)      VALUE SPACES.    
               10 S-NAME-FORMAT         PIC X(01)      VALUE SPACES.    
               10 S-TITLE-PREFIX        PIC X(09)      VALUE SPACES.    
               10 S-FIRST-NAME          PIC X(15)      VALUE SPACES.    
               10 S-MIDDLE-NAME         PIC X(15)      VALUE SPACES.    
               10 S-LAST-NAME           PIC X(20)      VALUE SPACES.    
               10 S-FULL-NAME           PIC X(50)      VALUE SPACES.    
               10 S-TITLE-SUFFIX-1      PIC X(03)      VALUE SPACES.    
               10 S-TITLE-SUFFIX-2      PIC X(03)      VALUE SPACES.    
               10 S-ADDRESS-FORMAT      PIC X(01)      VALUE SPACES.    
               10 S-HOUSE-NO            PIC X(05)      VALUE SPACES.    
               10 S-ADDR-PREFIX-1       PIC X(03)      VALUE SPACES.    
               10 S-ADDR-PREFIX-2       PIC X(02)      VALUE SPACES.    
               10 S-ADDR-SUFFIX         PIC X(02)      VALUE SPACES.    
               10 S-STREET-NAME         PIC X(35)      VALUE SPACES.    
               10 S-STREET-SUFFIX       PIC X(04)      VALUE SPACES.    
               10 S-ADDRESS-OVERFLOW    PIC X(35)      VALUE SPACES.    
               10 S-CITY                PIC X(26)      VALUE SPACES.    
               10 S-STATE               PIC X(02)      VALUE SPACES.    
               10 S-COUNTRY             PIC X(35)      VALUE SPACES.    
               10 S-ZIP-CODE            PIC X(05)      VALUE SPACES.    
               10 S-ZIP-CODE-PLUS-FOUR  PIC X(04)      VALUE SPACES.    
               10 S-STREET-LOCATION-1   PIC X(4)       VALUE SPACES.    
               10 S-STREET-LOCATION-2   PIC X(6)       VALUE SPACES.    
               10 S-ESCHEATMENT-CD      PIC X(1)       VALUE SPACES.    
               10 S-LAST-UPDATE-TS      PIC X(26)      VALUE SPACES.    
               10 S-ADDRESS-ID          PIC S9(13)V COMP-3 VALUE 0.     
                                                                        
       01  CSRERLOG-P.                                                  
           05  S-SP-NAME                PIC X(18)  VALUE SPACES.        
           05  S-SQLCODE                PIC S9(9)  COMP  VALUE 0.       
           05  S-SQLSTATE               PIC X(5)   VALUE ' '.           
           05  S-TABLE-NAME             PIC X(18)  VALUE SPACES.        
           05  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L   PIC S9(4)  USAGE COMP.          
               49  S-HOST-VARIABLES-V   PIC X(255).                     
           05  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L    PIC S9(4)  USAGE COMP.          
               49  S-SQL-STATEMENT-V    PIC X(255).                     
           05  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L  PIC S9(4)  USAGE COMP.          
               49  S-SQL-DESCRIPTION-V  PIC X(255).                     
           05  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L  PIC S9(4)  USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V  PIC X(255).                     
           05  WS-SQLSTATE              PIC X(05)  VALUE SPACES.        
           05  WS-GTT-NAME              PIC X(19)  VALUE SPACES.        
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05 WS-NULL-DATE-REFUND       PIC S9(04)   COMP VALUE +0.     
           05 WS-NULL-DATE-REQUEST      PIC S9(04)   COMP VALUE +0.     
           05 WS-NULL-DATE-CLEARED      PIC S9(04)   COMP VALUE +0.     
           05 WS-NULL-DATE-CANCELLED    PIC S9(04)   COMP VALUE +0.     
           05 WS-NULL-DATE-CHECK-VOID   PIC S9(04)   COMP VALUE +0.     
           05 WS-NULL-DATE-STOP-REQ     PIC S9(04)   COMP VALUE +0.     
           05 WS-NULL-DATE-STOP-CONF    PIC S9(04)   COMP VALUE +0.     
           05 WS-NULL-DATE-CHK-REMAIL   PIC S9(04)   COMP VALUE +0.     
           05 WS-NULL-DATE-REISSUED     PIC S9(04)   COMP VALUE +0.     
           05 WS-NULL-REFUND-STAT-DT    PIC S9(04)   COMP VALUE +0.     
           05 WS-NULL-DATE-RETURNED     PIC S9(04)   COMP VALUE +0.     
           05 WS-NULL-DATE-APPROP       PIC S9(04)   COMP VALUE +0.     
           05 WS-NULL-DATE-ESCHEATED    PIC S9(04)   COMP VALUE +0.     
           05 WS-NULL-DATE-VERIFIED     PIC S9(04)   COMP VALUE +0.     
           05 WS-NULL-DATE-ESC-RET      PIC S9(04)   COMP VALUE +0.     
                                                                        
      ******************************************************************        
      * DECLARE CURSOR TO GET ARCHIVED REFUND DATA                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE ARCH_REFUND CURSOR FOR                            
              SELECT REFUND_ITEM_ID                                     
                    ,REFUND_CHECK_NO                                    
                    ,DEPOSIT_CERT_NO                                    
                    ,AMT_REFUNDED                                       
                    ,DATE_REFUNDED                                      
                    ,REQUEST_DT                                         
                    ,CLEARED_DT                                         
                    ,DATE_CHECK_VOIDED                                  
                    ,STOP_REQUEST_DT                                    
                    ,CHECK_REMAIL_DT                                    
                    ,CHECK_STATUS_CD                                    
                    ,CHECK_ISS_REAS_CD                                  
                    ,REISSUED_DATE                                      
                    ,ORIGINAL_CHECK_NO                                  
                    ,RETURNED_REASON                                    
                    ,MANUAL_INDICATOR                                   
                    ,USER_ID_APPRVD_BY                                  
                    ,REFUND_STATUS_DT                                   
                    ,USER_ID_RQSTED_BY                                  
                    ,RETURNED_DATE                                      
                    ,DATE_ESCHEATED                                     
                    ,ADDRESS_ID                                         
                    ,ESCHEAT_RETURN_DT                                  
                    ,ESCHEAT_VERIFY_DT                                  
                    ,COMMENTS                                           
                    ,ESCHEATMENT_CD                                     
                FROM HST_REFUND WITH(READUNCOMMITTED)                           
               WHERE ACCOUNT_NO       =  :HU-ACCOUNT-NO                 
                 AND MANUAL_INDICATOR IN ('C','M','S')                  
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ARCH_REFUND CURSOR FOR                                    
MFA-TR*       SELECT REFUND_ITEM_ID                                             
MFA-TR*             ,REFUND_CHECK_NO                                            
MFA-TR*             ,DEPOSIT_CERT_NO                                            
MFA-TR*             ,AMT_REFUNDED                                               
MFA-TR*             ,DATE_REFUNDED                                              
MFA-TR*             ,REQUEST_DT                                                 
MFA-TR*             ,CLEARED_DT                                                 
MFA-TR*             ,DATE_CHECK_VOIDED                                          
MFA-TR*             ,STOP_REQUEST_DT                                            
MFA-TR*             ,CHECK_REMAIL_DT                                            
MFA-TR*             ,CHECK_STATUS_CD                                            
MFA-TR*             ,CHECK_ISS_REAS_CD                                          
MFA-TR*             ,REISSUED_DATE                                              
MFA-TR*             ,ORIGINAL_CHECK_NO                                          
MFA-TR*             ,RETURNED_REASON                                            
MFA-TR*             ,MANUAL_INDICATOR                                           
MFA-TR*             ,USER_ID_APPRVD_BY                                          
MFA-TR*             ,REFUND_STATUS_DT                                           
MFA-TR*             ,USER_ID_RQSTED_BY                                          
MFA-TR*             ,RETURNED_DATE                                              
MFA-TR*             ,DATE_ESCHEATED                                             
MFA-TR*             ,ADDRESS_ID                                                 
MFA-TR*             ,ESCHEAT_RETURN_DT                                          
MFA-TR*             ,ESCHEAT_VERIFY_DT                                          
MFA-TR*             ,COMMENTS                                                   
MFA-TR*             ,ESCHEATMENT_CD                                             
MFA-TR*         FROM HST_REFUND                                                 
MFA-TR*        WHERE ACCOUNT_NO       =  :HU-ACCOUNT-NO                         
MFA-TR*          AND MANUAL_INDICATOR IN ('C','M','S')                          
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * DECLARE CURSOR TO GET REFUND DATA                              *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE REFUND_CUR CURSOR FOR                             
              SELECT REFUND_ITEM_ID                                     
                    ,REFUND_CHECK_NO                                    
                    ,DEPOSIT_CERT_NO                                    
                    ,LOCAL_OFFICE                                       
                    ,AMT_REFUNDED                                       
                    ,DATE_REFUNDED                                      
                    ,REQUEST_DT                                         
                    ,CLEARED_DT                                         
                    ,DATE_CANCELLED                                     
                    ,DATE_CHECK_VOIDED                                  
                    ,STOP_REQUEST_DT                                    
                    ,STOP_CONFIRM_DT                                    
                    ,CHECK_REMAIL_DT                                    
                    ,CHECK_STATUS_CD                                    
                    ,CHECK_ISS_REAS_CD                                  
                    ,REISSUED_DATE                                      
                    ,ORIGINAL_CHECK_NO                                  
                    ,RETURNED_REASON                                    
                    ,MANUAL_INDICATOR                                   
                    ,USER_ID_APPRVD_BY                                  
                    ,REFUND_STATUS_DT                                   
                    ,USER_ID_RQSTED_BY                                  
                    ,RETURNED_DATE                                      
                    ,DATE_APPROPRIATED                                  
                    ,DATE_ESCHEATED                                     
                    ,PANEL_NO                                           
                    ,ADDRESS_ID                                         
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), TRANS_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') TRANS_HIST_SEQ_NO                      
                    ,ESCHEAT_RETURN_DT                                  
                    ,ESCHEAT_VERIFY_DT                                  
                    ,COMMENTS                                           
                    ,ESCHEATMENT_CD                                     
                FROM CSS_REFUND WITH(READUNCOMMITTED)                           
               WHERE ACCOUNT_NO       =  :RN-ACCOUNT-NO                 
                 AND MANUAL_INDICATOR IN ('C','M','S')                  
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE REFUND_CUR CURSOR FOR                                     
MFA-TR*       SELECT REFUND_ITEM_ID                                             
MFA-TR*             ,REFUND_CHECK_NO                                            
MFA-TR*             ,DEPOSIT_CERT_NO                                            
MFA-TR*             ,LOCAL_OFFICE                                               
MFA-TR*             ,AMT_REFUNDED                                               
MFA-TR*             ,DATE_REFUNDED                                              
MFA-TR*             ,REQUEST_DT                                                 
MFA-TR*             ,CLEARED_DT                                                 
MFA-TR*             ,DATE_CANCELLED                                             
MFA-TR*             ,DATE_CHECK_VOIDED                                          
MFA-TR*             ,STOP_REQUEST_DT                                            
MFA-TR*             ,STOP_CONFIRM_DT                                            
MFA-TR*             ,CHECK_REMAIL_DT                                            
MFA-TR*             ,CHECK_STATUS_CD                                            
MFA-TR*             ,CHECK_ISS_REAS_CD                                          
MFA-TR*             ,REISSUED_DATE                                              
MFA-TR*             ,ORIGINAL_CHECK_NO                                          
MFA-TR*             ,RETURNED_REASON                                            
MFA-TR*             ,MANUAL_INDICATOR                                           
MFA-TR*             ,USER_ID_APPRVD_BY                                          
MFA-TR*             ,REFUND_STATUS_DT                                           
MFA-TR*             ,USER_ID_RQSTED_BY                                          
MFA-TR*             ,RETURNED_DATE                                              
MFA-TR*             ,DATE_APPROPRIATED                                          
MFA-TR*             ,DATE_ESCHEATED                                             
MFA-TR*             ,PANEL_NO                                                   
MFA-TR*             ,ADDRESS_ID                                                 
MFA-TR*             ,TRANS_HIST_SEQ_NO                                          
MFA-TR*             ,ESCHEAT_RETURN_DT                                          
MFA-TR*             ,ESCHEAT_VERIFY_DT                                          
MFA-TR*             ,COMMENTS                                                   
MFA-TR*             ,ESCHEATMENT_CD                                             
MFA-TR*         FROM CSS_REFUND                                                 
MFA-TR*        WHERE ACCOUNT_NO       =  :RN-ACCOUNT-NO                         
MFA-TR*          AND MANUAL_INDICATOR IN ('C','M','S')                          
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*      QUERYNO 7040                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
COB305 01 PARM-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.              
                                                                        
       PROCEDURE DIVISION USING   PARM-ACCOUNT-NO.                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE                     THRU 0100-EXIT.  
           PERFORM 1000-PROCESS-INPUT                  THRU 1000-EXIT.  
           PERFORM 2000-PROCESS-OUTPUT                 THRU 2000-EXIT.  
           PERFORM 9999-END-PROGRAM                    THRU 9999-EXIT.  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           INITIALIZE GTT-RETURN-FIELDS                                 
                      DCLHST-REFUND                                     
                      DCLHST-ACCOUNT                                    
                      DCLCSS-ACCOUNT                                    
                      DCLCSS-REFUND.                                    
           MOVE 'N'                          TO WS-ARCHIVED-FL          
                                                WS-ACCT-TBL-FND         
                                                WS-PREM-TBL-FND.        
           MOVE 0                            TO WS-TBL-COUNT.           
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT                   THRU 0100A-EXIT. 
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02530000
      * 0100A-DECLARE-GTT.                                             *02540000
      ******************************************************************02890000
                                                                        
       0100A-DECLARE-GTT.                                               
                                                                        
           MOVE 'SESSION.CSR04889'           TO WS-GTT-NAME.            
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04889')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04889
              (                                                         
                   RETURN_CODE              INT                     
                  ,REFUND_ITEM_ID           INT                     
                  ,REFUND_CHECK CHAR(9)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,DEPOSIT_CERT_NO          INT                     
                  ,LOCAL_OFFICE CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,REQUEST_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,CLEARED_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,DATE_CANCELLED CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,DATE_CHECK_VOIDED CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,STOP_REQUEST_DT CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,STOP_CONFIRM_DT CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,CHECK_REMAIL_DT CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,REISSUED_DATE CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,ORIGINAL_CHECK_NO CHAR(9)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,RETURNED_REASON CHAR(1)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,USER_ID_APPRVD_BY CHAR(7)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,USER_ID_RQSTED_BY CHAR(7)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,RETURNED_DATE CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,DATE_APPROPRIATED CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,DATE_ESCHEATED CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,COMMENTS CHAR(72)  COLLATE LATIN1_GENERAL_100_BIN2           
                  ,AMT_REFUNDED             DECIMAL(11,2)               
                  ,MANUAL_INDICATOR CHAR(1)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,DATE_REFUNDED CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,CHECK_ISS_REAS_CD CHAR(2)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,CHECK_STATUS_CD CHAR(1)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,REFUND_STATUS_DT CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,DATE_ESCH_RETURNED CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,DATE_VERIFIED CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,PANEL_NO CHAR(04)  COLLATE LATIN1_GENERAL_100_BIN2           
                  ,TRANS_HIST_SEQ_NO CHAR(26)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,NAME_FORMAT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,TITLE_PREFIX CHAR(09)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,FIRST_NAME CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,MIDDLE_NAME CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,LAST_NAME CHAR(20)  COLLATE LATIN1_GENERAL_100_BIN2          
                  ,FULL_NAME CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2          
                  ,TITLE_SUFFIX_1 CHAR(03)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,TITLE_SUFFIX_2 CHAR(03)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,ADDRESS_FORMAT CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,HOUSE_NO CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2           
                  ,ADDR_PREFIX_1 CHAR(03)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,ADDR_PREFIX_2 CHAR(02)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,ADDR_SUFFIX CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,STREET_NAME CHAR(35)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,STREET_SUFFIX CHAR(04)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,ADDRESS_OVERFLOW CHAR(35)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,CITY CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2               
                  ,STATE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2              
                  ,COUNTRY CHAR(35)  COLLATE LATIN1_GENERAL_100_BIN2            
                  ,ZIP_CODE CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2           
                  ,ZIP_CODE_PLUS_FOUR CHAR(04)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,STREET_LOCATION_1 CHAR(4)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,STREET_LOCATION_2 CHAR(6)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,ESCHEATMENT_CD CHAR(1)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,ADDRESS_ID               DECIMAL(13,0)              
              )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS            THRU 8000A-EXIT  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE '0100A'                TO ACTIVE-PARAGRAPH        
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSR04889'             TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9900-SQL-ERROR-ROUTINE        THRU  9900-EXIT  
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT *                                                 
               FROM #CSR04889                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT *                                                         
MFA-TR*        FROM SESSION.CSR04889                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO              TO AT-ACCOUNT-NO           
                                                HT-ACCOUNT-NO           
                                                RN-ACCOUNT-NO           
                                                HA-ACCOUNT-NO           
                                                HU-ACCOUNT-NO.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
      * Set Archived flag if account not found in css_account table             
           PERFORM 7200-SELECT-ACCOUNT                 THRU 7200-EXIT.  
           IF WS-AT-ADDRESS-ID > 0                                      
              MOVE 'Y'                       TO WS-ACCT-TBL-FND         
           END-IF.                                                      
                                                                        
           PERFORM 7240-SELECT-PREMISE                 THRU 7240-EXIT.  
           IF PR-ADDRESS-ID > 0                                         
              MOVE 'Y'                       TO WS-PREM-TBL-FND         
           END-IF.                                                      
           PERFORM 7210-SELECT-NAME                    THRU 7210-EXIT.  
                                                                        
      *    If Archived Account,then get refund data from hst_refund else        
      *    get it from css_refund table                                         
           IF WS-ARCHIVED-FL = 'Y'                                      
              PERFORM 7000-OPEN-ARCH-REFUND-CUR        THRU 7000-EXIT   
              PERFORM 7010-FETCH-ARCH-REFUND-CUR       THRU 7010-EXIT   
              PERFORM 2100-PROCESS-ARCH-REFUNDS        THRU 2100-EXIT   
                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
              PERFORM 7020-CLOSE-ARCH-REFUND-CUR       THRU 7020-EXIT   
           ELSE                                                         
              PERFORM 7030-OPEN-REFUND-CURSOR          THRU 7030-EXIT   
              PERFORM 7040-FETCH-REFUND-CURSOR         THRU 7040-EXIT   
              PERFORM 2400-PROCESS-REFUNDS             THRU 2400-EXIT   
                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
              PERFORM 7050-CLOSE-REFUND-CURSOR         THRU 7050-EXIT   
           END-IF.                                                      
                                                                        
      * When no pending request is found then send RC as 100.                   
           IF WS-TBL-COUNT = 0                                          
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE 100                       TO S-RETURN-CODE           
              PERFORM 8100-SEND-RESULT                 THRU 8100-EXIT   
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-PROCESS-ARCH-REFUNDS                                      *        
      ******************************************************************        
                                                                        
       2100-PROCESS-ARCH-REFUNDS.                                       
                                                                        
      * If ADDRESS-ID (HST_REFUND) is greater than zero then get the            
      * address info from CSS_ADDR_FREEFORM/CSS_ADDR_FORMATTED                  
           IF HU-ADDRESS-ID > 0                                         
              MOVE HU-ADDRESS-ID             TO WS-ADDRESS-ID           
              PERFORM 2200-BUILD-ADDRESS               THRU 2200-EXIT   
           ELSE                                                         
              PERFORM 5100-FIND-ADDRESS                THRU 5100-EXIT   
           END-IF.                                                      
                                                                        
           PERFORM 2230-MOVE-NAME-VAR                  THRU 2230-EXIT.  
           PERFORM 2300-BUILD-RESULT-SET               THRU 2300-EXIT.  
           ADD +1                            TO WS-TBL-COUNT.           
           PERFORM 8100-SEND-RESULT                    THRU 8100-EXIT.  
                                                                        
           PERFORM 7010-FETCH-ARCH-REFUND-CUR          THRU 7010-EXIT.  
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-ADDRESS                                             *        
      ******************************************************************        
                                                                        
       2200-BUILD-ADDRESS.                                              
                                                                        
           MOVE WS-ADDRESS-ID                TO DY-ADDRESS-ID           
                                                DZ-ADDRESS-ID           
                                                S-ADDRESS-ID            
                                                                        
           PERFORM 7220-FREEFORM-ADDRESS               THRU 7220-EXIT   
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              PERFORM 7230-FORMATTED-ADDRESS           THRU 7230-EXIT   
              MOVE 'A'                       TO S-ADDRESS-FORMAT        
              PERFORM 2210-MOVE-FORMATTED-VAR          THRU 2210-EXIT   
           ELSE                                                         
              MOVE 'B'                       TO S-ADDRESS-FORMAT        
              PERFORM 2220-MOVE-FREEFORM-VAR        THRU 2220-EXIT      
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2210-MOVE-FORMATTED-VAR                                        *        
      ******************************************************************        
                                                                        
       2210-MOVE-FORMATTED-VAR.                                         
                                                                        
           MOVE DY-ADDR-PREFIX-1             TO S-ADDR-PREFIX-1.        
           MOVE DY-ADDR-PREFIX-2             TO S-ADDR-PREFIX-2.        
           MOVE DY-ADDR-SUFFIX               TO S-ADDR-SUFFIX.          
           MOVE DY-ADDRESS-OVERFLOW          TO S-ADDRESS-OVERFLOW.     
           MOVE DY-HOUSE-NO                  TO S-HOUSE-NO.             
           MOVE DY-STREET-LOCATION-1         TO S-STREET-LOCATION-1.    
           MOVE DY-STREET-LOCATION-2         TO S-STREET-LOCATION-2.    
           MOVE DY-STREET-NAME               TO S-STREET-NAME.          
           MOVE DY-STREET-SUFFIX             TO S-STREET-SUFFIX.        
           MOVE DY-ZIP-CODE                  TO S-ZIP-CODE.             
           MOVE DY-ZIP-CODE-PLUS-FOUR        TO S-ZIP-CODE-PLUS-FOUR.   
           MOVE A4-TOWN                      TO S-CITY.                 
           MOVE A4-STATE                     TO S-STATE.                
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2220-MOVE-FREEFORM-VAR                                         *        
      ******************************************************************        
                                                                        
       2220-MOVE-FREEFORM-VAR.                                          
                                                                        
           MOVE 'B'                          TO S-ADDRESS-FORMAT.       
           MOVE DZ-ADDRESS-OVERFLOW          TO S-ADDRESS-OVERFLOW.     
           MOVE DZ-ADDR-STREET               TO S-STREET-NAME.          
           MOVE DZ-ADDR-CITY-STATE           TO S-CITY.                 
           MOVE DZ-ADDR-COUNTRY              TO S-COUNTRY.              
           MOVE DZ-ADDR-ZIP-CODE(1:5)        TO S-ZIP-CODE.             
           MOVE DZ-ADDR-ZIP-CODE(5:4)        TO S-ZIP-CODE-PLUS-FOUR.   
                                                                        
      * Extract City & State                                                    
           MOVE +30 TO WS-SUB1.                                         
           MOVE 0 TO WS-SUB2.                                           
           PERFORM UNTIL DZ-ADDR-CITY-STATE(WS-SUB1:1) > ' '            
               SUBTRACT +1 FROM WS-SUB1                                 
           END-PERFORM.                                                 
           IF DZ-ADDR-CITY-STATE(WS-SUB1 - 2:1) = ' '                   
               MOVE DZ-ADDR-CITY-STATE(WS-SUB1 - 1:2) TO S-STATE        
               MOVE DZ-ADDR-CITY-STATE(1:WS-SUB1 - 3) TO S-CITY         
           END-IF.                                                      
                                                                        
       2220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2230-MOVE-NAME-VAR                                             *        
      *************2****************************************************        
                                                                        
       2230-MOVE-NAME-VAR.                                              
                                                                        
           MOVE DQ-NAME-FORMAT               TO S-NAME-FORMAT.          
           MOVE DQ-TITLE-PREFIX              TO S-TITLE-PREFIX.         
           MOVE DQ-FIRST-NAME                TO S-FIRST-NAME.           
           MOVE DQ-MIDDLE-NAME               TO S-MIDDLE-NAME.          
           MOVE DQ-LAST-NAME                 TO S-LAST-NAME.            
           MOVE DQ-TITLE-SUFFIX-1            TO S-TITLE-SUFFIX-1.       
           MOVE DQ-TITLE-SUFFIX-2            TO S-TITLE-SUFFIX-2.       
           MOVE DQ-FULL-NAME                 TO S-FULL-NAME.            
                                                                        
       2230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2300-BUILD-RESULT-SET                                          *        
      ******************************************************************        
                                                                        
       2300-BUILD-RESULT-SET.                                           
                                                                        
                                                                        
           IF WS-ARCHIVED-FL = 'Y'                                      
              MOVE HU-REFUND-ITEM-ID         TO S-REFUND-ITEM-ID        
              MOVE HU-REFUND-CHECK-NO        TO S-REFUND-CHECK-NO       
              MOVE HU-DEPOSIT-CERT-NO        TO S-DEPOSIT-CERT-NO       
              MOVE HU-AMT-REFUNDED           TO S-AMT-REFUNDED          
              MOVE HU-DATE-REFUNDED          TO S-DATE-REFUNDED         
              MOVE HU-REQUEST-DT             TO S-REQUEST-DT            
              MOVE HU-CLEARED-DT             TO S-CLEARED-DT            
              MOVE HU-DATE-CHECK-VOIDED      TO S-DATE-CHECK-VOIDED     
              MOVE HU-STOP-REQUEST-DT        TO S-STOP-REQUEST-DT       
              MOVE HU-CHECK-REMAIL-DT        TO S-CHECK-REMAIL-DT       
              MOVE HU-CHECK-STATUS-CD        TO S-CHECK-STATUS-CD       
              MOVE HU-CHECK-ISS-REAS-CD      TO S-CHECK-ISS-REAS-CD     
              MOVE HU-REISSUED-DATE          TO S-REISSUED-DATE         
              MOVE HU-ORIGINAL-CHECK-NO      TO S-ORIGINAL-CHECK-NO     
              MOVE HU-RETURNED-REASON        TO S-RETURNED-REASON       
              MOVE HU-MANUAL-INDICATOR       TO S-MANUAL-INDICATOR      
              MOVE HU-USER-ID-APPRVD-BY      TO S-USER-ID-APPRVD-BY     
              MOVE HU-REFUND-STATUS-DT       TO S-REFUND-STATUS-DT      
              MOVE HU-USER-ID-RQSTED-BY      TO S-USER-ID-RQSTED-BY     
              MOVE HU-RETURNED-DATE          TO S-RETURNED-DATE         
              MOVE HU-DATE-ESCHEATED         TO S-DATE-ESCHEATED        
              MOVE HU-ESCHEAT-VERIFY-DT      TO S-DATE-ESCH-VERIFIED    
              MOVE HU-ESCHEAT-RETURN-DT      TO S-DATE-ESCH-RETURNED    
              MOVE HU-COMMENTS               TO S-COMMENTS              
              MOVE HU-ESCHEATMENT-CD         TO S-ESCHEATMENT-CD        
              MOVE HA-LAST-UPDATE-TS         TO S-LAST-UPDATE-TS        
      * As below fields are not available on archived refund table, move        
      * Spaces                                                                  
              MOVE SPACES                    TO S-LOCAL-OFFICE          
                                                S-TRANS-HIST-SEQ-NO     
                                                S-PANEL-NO              
                                                S-DATE-APPROPRIATED     
                                                S-STOP-CONFIRM-DT       
                                                S-DATE-CANCELLED        
           ELSE                                                         
              MOVE RN-REFUND-ITEM-ID         TO S-REFUND-ITEM-ID        
              MOVE RN-REFUND-CHECK-NO        TO S-REFUND-CHECK-NO       
              MOVE RN-DEPOSIT-CERT-NO        TO S-DEPOSIT-CERT-NO       
              MOVE RN-LOCAL-OFFICE           TO S-LOCAL-OFFICE          
              MOVE RN-AMT-REFUNDED           TO S-AMT-REFUNDED          
              MOVE RN-DATE-REFUNDED          TO S-DATE-REFUNDED         
              MOVE RN-REQUEST-DT             TO S-REQUEST-DT            
              MOVE RN-CLEARED-DT             TO S-CLEARED-DT            
              MOVE RN-DATE-CANCELLED         TO S-DATE-CANCELLED        
              MOVE RN-DATE-CHECK-VOIDED      TO S-DATE-CHECK-VOIDED     
              MOVE RN-STOP-REQUEST-DT        TO S-STOP-REQUEST-DT       
              MOVE RN-STOP-CONFIRM-DT        TO S-STOP-CONFIRM-DT       
              MOVE RN-CHECK-REMAIL-DT        TO S-CHECK-REMAIL-DT       
              MOVE RN-CHECK-STATUS-CD        TO S-CHECK-STATUS-CD       
              MOVE RN-CHECK-ISS-REAS-CD      TO S-CHECK-ISS-REAS-CD     
              MOVE RN-REISSUED-DATE          TO S-REISSUED-DATE         
              MOVE RN-ORIGINAL-CHECK-NO      TO S-ORIGINAL-CHECK-NO     
              MOVE RN-RETURNED-REASON        TO S-RETURNED-REASON       
              MOVE RN-MANUAL-INDICATOR       TO S-MANUAL-INDICATOR      
              MOVE RN-USER-ID-APPRVD-BY      TO S-USER-ID-APPRVD-BY     
              MOVE RN-REFUND-STATUS-DT       TO S-REFUND-STATUS-DT      
              MOVE RN-USER-ID-RQSTED-BY      TO S-USER-ID-RQSTED-BY     
              MOVE RN-RETURNED-DATE          TO S-RETURNED-DATE         
              MOVE RN-DATE-APPROPRIATED      TO S-DATE-APPROPRIATED     
              MOVE RN-DATE-ESCHEATED         TO S-DATE-ESCHEATED        
              MOVE RN-PANEL-NO               TO S-PANEL-NO              
              MOVE RN-TRANS-HIST-SEQ-NO      TO S-TRANS-HIST-SEQ-NO     
              MOVE RN-ESCHEAT-VERIFY-DT      TO S-DATE-ESCH-VERIFIED    
              MOVE RN-ESCHEAT-RETURN-DT      TO S-DATE-ESCH-RETURNED    
              MOVE RN-COMMENTS-TEXT          TO S-COMMENTS              
              MOVE RN-ESCHEATMENT-CD         TO S-ESCHEATMENT-CD        
              MOVE AT-LAST-UPDATE-TS         TO S-LAST-UPDATE-TS        
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2400-PROCESS-REFUNDS                                           *        
      ******************************************************************        
                                                                        
       2400-PROCESS-REFUNDS.                                            
                                                                        
      * If ADDRESS-ID (CSS_REFUND) is greater than zero then get the            
      * address info from CSS_ADDR_FREEFORM/CSS_ADDR_FORMATTED                  
           IF RN-ADDRESS-ID > 0                                         
              MOVE RN-ADDRESS-ID             TO WS-ADDRESS-ID           
              PERFORM 2200-BUILD-ADDRESS               THRU 2200-EXIT   
           ELSE                                                         
              PERFORM 5100-FIND-ADDRESS                THRU 5100-EXIT   
           END-IF.                                                      
                                                                        
           PERFORM 2230-MOVE-NAME-VAR                  THRU 2230-EXIT.  
           PERFORM 2300-BUILD-RESULT-SET               THRU 2300-EXIT.  
           ADD +1                            TO WS-TBL-COUNT.           
           PERFORM 8100-SEND-RESULT                    THRU 8100-EXIT.  
                                                                        
           PERFORM 7040-FETCH-REFUND-CURSOR            THRU 7040-EXIT.  
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5100- FIND ADDRESS.                                            *        
      ******************************************************************        
                                                                        
       5100-FIND-ADDRESS.                                               
                                                                        
      * If Billing Address (AT) not found then use Service Address              
           IF WS-ACCT-TBL-FND = 'Y'                                     
              MOVE WS-AT-ADDRESS-ID          TO WS-ADDRESS-ID           
              MOVE WS-AT-ADDRESS-FORMAT      TO WS-ADDRESS-FORMAT       
           ELSE                                                         
              IF WS-PREM-TBL-FND = 'Y'                                  
                 MOVE PR-ADDRESS-ID          TO WS-ADDRESS-ID           
                 MOVE PR-ADDRESS-FORMAT      TO WS-ADDRESS-FORMAT       
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE WS-ADDRESS-ID                TO DY-ADDRESS-ID           
                                                DZ-ADDRESS-ID           
                                                S-ADDRESS-ID.           
           MOVE WS-ADDRESS-FORMAT            TO S-ADDRESS-FORMAT.       
                                                                        
           IF WS-ADDRESS-FORMAT = 'A'                                   
              PERFORM 7230-FORMATTED-ADDRESS           THRU 7230-EXIT   
              PERFORM 2210-MOVE-FORMATTED-VAR          THRU 2210-EXIT   
           ELSE                                                         
              PERFORM 7220-FREEFORM-ADDRESS            THRU 7220-EXIT   
              PERFORM 2220-MOVE-FREEFORM-VAR           THRU 2220-EXIT   
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-OPEN-ARCH-REFUND-CUR                                      *        
      ******************************************************************        
                                                                        
       7000-OPEN-ARCH-REFUND-CUR.                                       
                                                                        
           EXEC SQL                                                     
              OPEN ARCH_REFUND                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'HST_REFUND'              TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE HU-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND               THRU 9700-EXIT   
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7010-FETCH-ARCH-REFUND-CUR                                     *        
      ******************************************************************        
                                                                        
       7010-FETCH-ARCH-REFUND-CUR.                                      
                                                                        
           EXEC SQL                                                     
              FETCH ARCH_REFUND                                         
               INTO :HU-REFUND-ITEM-ID                                  
                   ,:HU-REFUND-CHECK-NO                                 
                   ,:HU-DEPOSIT-CERT-NO                                 
                   ,:HU-AMT-REFUNDED                                    
                   ,:HU-DATE-REFUNDED :WS-NULL-DATE-REFUND          
                   ,:HU-REQUEST-DT :WS-NULL-DATE-REQUEST         
                   ,:HU-CLEARED-DT :WS-NULL-DATE-CLEARED         
                   ,:HU-DATE-CHECK-VOIDED :WS-NULL-DATE-CHECK-VOID      
                   ,:HU-STOP-REQUEST-DT :WS-NULL-DATE-STOP-REQ        
                   ,:HU-CHECK-REMAIL-DT :WS-NULL-DATE-CHK-REMAIL      
                   ,:HU-CHECK-STATUS-CD                                 
                   ,:HU-CHECK-ISS-REAS-CD                               
                   ,:HU-REISSUED-DATE :WS-NULL-DATE-REISSUED        
                   ,:HU-ORIGINAL-CHECK-NO                               
                   ,:HU-RETURNED-REASON                                 
                   ,:HU-MANUAL-INDICATOR                                
                   ,:HU-USER-ID-APPRVD-BY                               
                   ,:HU-REFUND-STATUS-DT :WS-NULL-REFUND-STAT-DT       
                   ,:HU-USER-ID-RQSTED-BY                               
                   ,:HU-RETURNED-DATE :WS-NULL-DATE-RETURNED        
                   ,:HU-DATE-ESCHEATED :WS-NULL-DATE-ESCHEATED       
                   ,:HU-ADDRESS-ID                                      
                   ,:HU-ESCHEAT-VERIFY-DT :WS-NULL-DATE-VERIFIED        
                   ,:HU-ESCHEAT-RETURN-DT :WS-NULL-DATE-ESC-RET         
                   ,:HU-COMMENTS                                        
                   ,:HU-ESCHEATMENT-CD                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
            WHEN SUCCESSFUL-CALL                                        
                 IF WS-NULL-DATE-REFUND      < 0                        
                    MOVE SPACES              TO HU-DATE-REFUNDED        
                    MOVE ZEROES              TO WS-NULL-DATE-REFUND     
                 END-IF                                                 
                 IF WS-NULL-DATE-REQUEST     < 0                        
                    MOVE SPACES              TO HU-REQUEST-DT           
                    MOVE ZEROES              TO WS-NULL-DATE-REQUEST    
                 END-IF                                                 
                 IF WS-NULL-DATE-CLEARED     < 0                        
                    MOVE SPACES              TO HU-CLEARED-DT           
                    MOVE ZEROES              TO WS-NULL-DATE-CLEARED    
                 END-IF                                                 
                 IF WS-NULL-DATE-CHECK-VOID  < 0                        
                    MOVE SPACES              TO HU-DATE-CHECK-VOIDED    
                    MOVE ZEROES              TO WS-NULL-DATE-CHECK-VOID 
                 END-IF                                                 
                 IF WS-NULL-DATE-STOP-REQ    < 0                        
                    MOVE SPACES              TO HU-STOP-REQUEST-DT      
                    MOVE ZEROES              TO WS-NULL-DATE-STOP-REQ   
                 END-IF                                                 
                 IF WS-NULL-DATE-CHK-REMAIL  < 0                        
                    MOVE SPACES              TO HU-CHECK-REMAIL-DT      
                    MOVE ZEROES              TO WS-NULL-DATE-CHK-REMAIL 
                 END-IF                                                 
                 IF WS-NULL-DATE-REISSUED    < 0                        
                    MOVE SPACES              TO HU-REISSUED-DATE        
                    MOVE ZEROES              TO WS-NULL-DATE-REISSUED   
                 END-IF                                                 
                 IF WS-NULL-REFUND-STAT-DT   < 0                        
                    MOVE SPACES              TO HU-REFUND-STATUS-DT     
                    MOVE ZEROES              TO WS-NULL-REFUND-STAT-DT  
                 END-IF                                                 
                 IF WS-NULL-DATE-RETURNED    < 0                        
                    MOVE SPACES              TO HU-RETURNED-DATE        
                    MOVE ZEROES              TO WS-NULL-DATE-RETURNED   
                 END-IF                                                 
                 IF WS-NULL-DATE-ESCHEATED   < 0                        
                    MOVE SPACES              TO HU-DATE-ESCHEATED       
                    MOVE ZEROES              TO WS-NULL-DATE-ESCHEATED  
                 END-IF                                                 
                 IF WS-NULL-DATE-VERIFIED    < 0                        
                    MOVE SPACES              TO HU-ESCHEAT-VERIFY-DT    
                    MOVE ZEROES              TO WS-NULL-DATE-VERIFIED   
                 END-IF                                                 
                 IF WS-NULL-DATE-ESC-RET     < 0                        
                    MOVE SPACES              TO HU-ESCHEAT-RETURN-DT    
                    MOVE ZEROES              TO WS-NULL-DATE-ESC-RET    
                 END-IF                                                 
            WHEN NOT-FOUND                                              
                 CONTINUE                                               
            WHEN OTHER                                                  
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '7010'                 TO ACTIVE-PARAGRAPH        
                 MOVE 'FETCH'                TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'HST_REFUND'           TO TABLE-1                 
                 MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1         
                 MOVE HU-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND            THRU 9700-EXIT   
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7020-CLOSE-ARCH-REFUND-CUR                                     *        
      ******************************************************************        
                                                                        
       7020-CLOSE-ARCH-REFUND-CUR.                                      
                                                                        
           EXEC SQL                                                     
              CLOSE ARCH_REFUND                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7020'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'HSR_REFUND'              TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE HU-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND               THRU 9700-EXIT   
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7030-OPEN-REFUND-CURSOR                                        *        
      ******************************************************************        
                                                                        
       7030-OPEN-REFUND-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
              OPEN REFUND_CUR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7030'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_REFUND'              TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE RN-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND               THRU 9700-EXIT   
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7040-FETCH-REFUND-CURSOR                                       *        
      ******************************************************************        
                                                                        
       7040-FETCH-REFUND-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
              FETCH REFUND_CUR                                          
               INTO :RN-REFUND-ITEM-ID                                  
                   ,:RN-REFUND-CHECK-NO                                 
                   ,:RN-DEPOSIT-CERT-NO                                 
                   ,:RN-LOCAL-OFFICE                                    
                   ,:RN-AMT-REFUNDED                                    
                   ,:RN-DATE-REFUNDED :WS-NULL-DATE-REFUND          
                   ,:RN-REQUEST-DT :WS-NULL-DATE-REQUEST         
                   ,:RN-CLEARED-DT :WS-NULL-DATE-CLEARED         
                   ,:RN-DATE-CANCELLED :WS-NULL-DATE-CANCELLED       
                   ,:RN-DATE-CHECK-VOIDED :WS-NULL-DATE-CHECK-VOID      
                   ,:RN-STOP-REQUEST-DT :WS-NULL-DATE-STOP-REQ        
                   ,:RN-STOP-CONFIRM-DT :WS-NULL-DATE-STOP-CONF       
                   ,:RN-CHECK-REMAIL-DT :WS-NULL-DATE-CHK-REMAIL      
                   ,:RN-CHECK-STATUS-CD                                 
                   ,:RN-CHECK-ISS-REAS-CD                               
                   ,:RN-REISSUED-DATE :WS-NULL-DATE-REISSUED        
                   ,:RN-ORIGINAL-CHECK-NO                               
                   ,:RN-RETURNED-REASON                                 
                   ,:RN-MANUAL-INDICATOR                                
                   ,:RN-USER-ID-APPRVD-BY                               
                   ,:RN-REFUND-STATUS-DT                                
                   ,:RN-USER-ID-RQSTED-BY                               
                   ,:RN-RETURNED-DATE :WS-NULL-DATE-RETURNED        
                   ,:RN-DATE-APPROPRIATED :WS-NULL-DATE-APPROP          
                   ,:RN-DATE-ESCHEATED :WS-NULL-DATE-ESCHEATED       
                   ,:RN-PANEL-NO                                        
                   ,:RN-ADDRESS-ID                                      
                   ,:RN-TRANS-HIST-SEQ-NO                               
                   ,:RN-ESCHEAT-VERIFY-DT :WS-NULL-DATE-VERIFIED        
                   ,:RN-ESCHEAT-RETURN-DT :WS-NULL-DATE-ESC-RET         
                   ,:RN-COMMENTS                                        
                   ,:RN-ESCHEATMENT-CD                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
            WHEN SUCCESSFUL-CALL                                        
                 IF WS-NULL-DATE-REFUND      < 0                        
                    MOVE SPACES              TO RN-DATE-REFUNDED        
                    MOVE ZEROES              TO WS-NULL-DATE-REFUND     
                 END-IF                                                 
                 IF WS-NULL-DATE-REQUEST     < 0                        
                    MOVE SPACES              TO RN-REQUEST-DT           
                    MOVE ZEROES              TO WS-NULL-DATE-REQUEST    
                 END-IF                                                 
                 IF WS-NULL-DATE-CLEARED     < 0                        
                    MOVE SPACES              TO RN-CLEARED-DT           
                    MOVE ZEROES              TO WS-NULL-DATE-CLEARED    
                 END-IF                                                 
                 IF WS-NULL-DATE-CANCELLED   < 0                        
                    MOVE SPACES              TO RN-DATE-CANCELLED       
                    MOVE ZEROES              TO WS-NULL-DATE-CANCELLED  
                 END-IF                                                 
                 IF WS-NULL-DATE-CHECK-VOID  < 0                        
                    MOVE SPACES              TO RN-DATE-CHECK-VOIDED    
                    MOVE ZEROES              TO WS-NULL-DATE-CHECK-VOID 
                 END-IF                                                 
                 IF WS-NULL-DATE-STOP-REQ    < 0                        
                    MOVE SPACES              TO RN-STOP-REQUEST-DT      
                    MOVE ZEROES              TO WS-NULL-DATE-STOP-REQ   
                 END-IF                                                 
                 IF WS-NULL-DATE-STOP-CONF   < 0                        
                    MOVE SPACES              TO RN-STOP-CONFIRM-DT      
                    MOVE ZEROES              TO WS-NULL-DATE-STOP-CONF  
                 END-IF                                                 
                 IF WS-NULL-DATE-CHK-REMAIL  < 0                        
                    MOVE SPACES              TO RN-CHECK-REMAIL-DT      
                    MOVE ZEROES              TO WS-NULL-DATE-CHK-REMAIL 
                 END-IF                                                 
                 IF WS-NULL-DATE-REISSUED    < 0                        
                    MOVE SPACES              TO RN-REISSUED-DATE        
                    MOVE ZEROES              TO WS-NULL-DATE-REISSUED   
                 END-IF                                                 
                 IF WS-NULL-DATE-RETURNED    < 0                        
                    MOVE SPACES              TO RN-RETURNED-DATE        
                    MOVE ZEROES              TO WS-NULL-DATE-RETURNED   
                 END-IF                                                 
                 IF WS-NULL-DATE-APPROP      < 0                        
                    MOVE SPACES              TO RN-DATE-APPROPRIATED    
                    MOVE ZEROES              TO WS-NULL-DATE-APPROP     
                 END-IF                                                 
                 IF WS-NULL-DATE-ESCHEATED   < 0                        
                    MOVE SPACES              TO RN-DATE-ESCHEATED       
                    MOVE ZEROES              TO WS-NULL-DATE-ESCHEATED  
                 END-IF                                                 
                 IF WS-NULL-DATE-VERIFIED    < 0                        
                    MOVE SPACES              TO RN-ESCHEAT-VERIFY-DT    
                    MOVE ZEROES              TO WS-NULL-DATE-VERIFIED   
                 END-IF                                                 
                 IF WS-NULL-DATE-ESC-RET     < 0                        
                    MOVE SPACES              TO RN-ESCHEAT-RETURN-DT    
                    MOVE ZEROES              TO WS-NULL-DATE-ESC-RET    
                 END-IF                                                 
            WHEN NOT-FOUND                                              
                 CONTINUE                                               
            WHEN OTHER                                                  
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '7040'                 TO ACTIVE-PARAGRAPH        
                 MOVE 'FETCH'                TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSS_REFUND'           TO TABLE-1                 
                 MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1         
                 MOVE RN-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND            THRU 9700-EXIT   
           END-EVALUATE.                                                
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7050-CLOSE-REFUND-CURSOR                                       *        
      ******************************************************************        
                                                                        
       7050-CLOSE-REFUND-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
              CLOSE REFUND_CUR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7050'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_REFUND'              TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE RN-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND               THRU 9700-EXIT   
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-SELECT-ACCOUNT                                            *        
      ******************************************************************        
                                                                        
       7200-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT AT.ADDRESS_ID                                      
                    ,AT.ADDRESS_FORMAT                                  
                    ,AT.PREMISE_NO                                      
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), AT.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                INTO :WS-AT-ADDRESS-ID                                  
                    ,:WS-AT-ADDRESS-FORMAT                              
                    ,:WS-PREMISE-NO                                     
                    ,:AT-LAST-UPDATE-TS                                 
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.ADDRESS_ID                                              
MFA-TR*             ,AT.ADDRESS_FORMAT                                          
MFA-TR*             ,AT.PREMISE_NO                                              
MFA-TR*             ,AT.LAST_UPDATE_TS                                          
MFA-TR*         INTO :WS-AT-ADDRESS-ID                                          
MFA-TR*             ,:WS-AT-ADDRESS-FORMAT                                      
MFA-TR*             ,:WS-PREMISE-NO                                             
MFA-TR*             ,:AT-LAST-UPDATE-TS                                         
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
            WHEN 0                                                      
                 CONTINUE                                               
            WHEN 100                                                    
                 PERFORM 7250-SELECT-ARCHIVED-ACCOUNT  THRU 7250-EXIT   
            WHEN OTHER                                                  
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '7200'                 TO ACTIVE-PARAGRAPH        
                 MOVE 'SELECT'               TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSS_ACCOUNT'          TO TABLE-1                 
                 MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1         
                 MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND            THRU 9700-EXIT   
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7210-SELECT-NAME                                               *        
      ******************************************************************        
                                                                        
       7210-SELECT-NAME.                                                
                                                                        
           EXEC SQL                                                     
              SELECT DQ.NAME_FORMAT                                     
                    ,DQ.TITLE_PREFIX                                    
                    ,DQ.FIRST_NAME                                      
                    ,DQ.MIDDLE_NAME                                     
                    ,DQ.LAST_NAME                                       
                    ,DQ.TITLE_SUFFIX_1                                  
                    ,DQ.TITLE_SUFFIX_2                                  
                    ,DQ.FULL_NAME                                       
                INTO :DQ-NAME-FORMAT                                    
                    ,:DQ-TITLE-PREFIX                                   
                    ,:DQ-FIRST-NAME                                     
                    ,:DQ-MIDDLE-NAME                                    
                    ,:DQ-LAST-NAME                                      
                    ,:DQ-TITLE-SUFFIX-1                                 
                    ,:DQ-TITLE-SUFFIX-2                                 
                    ,:DQ-FULL-NAME                                      
                FROM CSS_NAME           DQ WITH(READUNCOMMITTED)                
                    ,CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)                
               WHERE HT.ACCOUNT_NO       = :HT-ACCOUNT-NO               
                 AND HT.NAME_ID          = DQ.NAME_ID                   
                 AND DQ.NAME_TYPE        = 'CN'                         
                 AND HT.CUSTOMER_ROLE_CD = ' '                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DQ.NAME_FORMAT                                             
MFA-TR*             ,DQ.TITLE_PREFIX                                            
MFA-TR*             ,DQ.FIRST_NAME                                              
MFA-TR*             ,DQ.MIDDLE_NAME                                             
MFA-TR*             ,DQ.LAST_NAME                                               
MFA-TR*             ,DQ.TITLE_SUFFIX_1                                          
MFA-TR*             ,DQ.TITLE_SUFFIX_2                                          
MFA-TR*             ,DQ.FULL_NAME                                               
MFA-TR*         INTO :DQ-NAME-FORMAT                                            
MFA-TR*             ,:DQ-TITLE-PREFIX                                           
MFA-TR*             ,:DQ-FIRST-NAME                                             
MFA-TR*             ,:DQ-MIDDLE-NAME                                            
MFA-TR*             ,:DQ-LAST-NAME                                              
MFA-TR*             ,:DQ-TITLE-SUFFIX-1                                         
MFA-TR*             ,:DQ-TITLE-SUFFIX-2                                         
MFA-TR*             ,:DQ-FULL-NAME                                              
MFA-TR*         FROM CSS_NAME           DQ                                      
MFA-TR*             ,CSS_NAME_ACCT_XREF HT                                      
MFA-TR*        WHERE HT.ACCOUNT_NO       = :HT-ACCOUNT-NO                       
MFA-TR*          AND HT.NAME_ID          = DQ.NAME_ID                           
MFA-TR*          AND DQ.NAME_TYPE        = 'CN'                                 
MFA-TR*          AND HT.CUSTOMER_ROLE_CD = ' '                                  
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7210                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7210'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT            '      TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_NAME          '      TO TABLE-1                 
              MOVE 'CSS_NAME_ACCT_XREF'      TO TABLE-2                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE HT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND               THRU 9700-EXIT   
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7220-FREEFORM-ADDRESS                                          *        
      ******************************************************************        
                                                                        
       7220-FREEFORM-ADDRESS.                                           
                                                                        
           EXEC SQL                                                     
              SELECT ADDR_CITY_STATE                                    
                    ,ADDR_STREET                                        
                    ,ADDRESS_OVERFLOW                                   
                    ,ADDR_COUNTRY                                       
                    ,ADDR_ZIP_CODE                                      
                INTO :DZ-ADDR-CITY-STATE                                
                    ,:DZ-ADDR-STREET                                    
                    ,:DZ-ADDRESS-OVERFLOW                               
                    ,:DZ-ADDR-COUNTRY                                   
                    ,:DZ-ADDR-ZIP-CODE                                  
                FROM CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)                    
               WHERE ADDRESS_ID = :DZ-ADDRESS-ID                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ADDR_CITY_STATE                                            
MFA-TR*             ,ADDR_STREET                                                
MFA-TR*             ,ADDRESS_OVERFLOW                                           
MFA-TR*             ,ADDR_COUNTRY                                               
MFA-TR*             ,ADDR_ZIP_CODE                                              
MFA-TR*         INTO :DZ-ADDR-CITY-STATE                                        
MFA-TR*             ,:DZ-ADDR-STREET                                            
MFA-TR*             ,:DZ-ADDRESS-OVERFLOW                                       
MFA-TR*             ,:DZ-ADDR-COUNTRY                                           
MFA-TR*             ,:DZ-ADDR-ZIP-CODE                                          
MFA-TR*         FROM CSS_ADDR_FREEFORM                                          
MFA-TR*        WHERE ADDRESS_ID = :DZ-ADDRESS-ID                                
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7220                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '7220'                   TO ACTIVE-PARAGRAPH        
               MOVE 'SELECT'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSS_ADDR_FREEFORM'      TO TABLE-1                 
               MOVE 'ADDRESS_ID'             TO TABLE-ELEMENT-1         
               MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2         
               MOVE DZ-ADDRESS-ID            TO HOSTVAR-ELEMENT-1       
               MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND               THRU 9700-EXIT   
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7230 FORMATTED-ADDRESS                                         *        
      ******************************************************************        
                                                                        
       7230-FORMATTED-ADDRESS.                                          
                                                                        
           EXEC SQL                                                     
              SELECT DY.ADDR_PREFIX_1                                   
                    ,DY.STREET_SUFFIX                                   
                    ,DY.ADDR_PREFIX_2                                   
                    ,DY.HOUSE_NO                                        
                    ,DY.STREET_NAME                                     
                    ,DY.ADDR_SUFFIX                                     
                    ,DY.ADDRESS_OVERFLOW                                
                    ,DY.ZIP_CODE                                        
                    ,DY.ZIP_CODE_PLUS_FOUR                              
                    ,DY.STREET_LOCATION_1                               
                    ,DY.STREET_LOCATION_2                               
                    ,A4.TOWN                                            
                    ,A4.STATE                                           
                INTO :DY-ADDR-PREFIX-1                                  
                    ,:DY-STREET-SUFFIX                                  
                    ,:DY-ADDR-PREFIX-2                                  
                    ,:DY-HOUSE-NO                                       
                    ,:DY-STREET-NAME                                    
                    ,:DY-ADDR-SUFFIX                                    
                    ,:DY-ADDRESS-OVERFLOW                               
                    ,:DY-ZIP-CODE                                       
                    ,:DY-ZIP-CODE-PLUS-FOUR                             
                    ,:DY-STREET-LOCATION-1                              
                    ,:DY-STREET-LOCATION-2                              
                    ,:A4-TOWN                                           
                    ,:A4-STATE                                          
                FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),               
                     CSS_ZIP_CODE       A4 WITH(READUNCOMMITTED)                
               WHERE DY.ADDRESS_ID     = :DY-ADDRESS-ID                 
                 AND A4.ZIP_CODE       = DY.ZIP_CODE                    
                 AND A4.ZIP_CODE_TOKEN = DY.ZIP_CODE_TOKEN              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DY.ADDR_PREFIX_1                                           
MFA-TR*             ,DY.STREET_SUFFIX                                           
MFA-TR*             ,DY.ADDR_PREFIX_2                                           
MFA-TR*             ,DY.HOUSE_NO                                                
MFA-TR*             ,DY.STREET_NAME                                             
MFA-TR*             ,DY.ADDR_SUFFIX                                             
MFA-TR*             ,DY.ADDRESS_OVERFLOW                                        
MFA-TR*             ,DY.ZIP_CODE                                                
MFA-TR*             ,DY.ZIP_CODE_PLUS_FOUR                                      
MFA-TR*             ,DY.STREET_LOCATION_1                                       
MFA-TR*             ,DY.STREET_LOCATION_2                                       
MFA-TR*             ,A4.TOWN                                                    
MFA-TR*             ,A4.STATE                                                   
MFA-TR*         INTO :DY-ADDR-PREFIX-1                                          
MFA-TR*             ,:DY-STREET-SUFFIX                                          
MFA-TR*             ,:DY-ADDR-PREFIX-2                                          
MFA-TR*             ,:DY-HOUSE-NO                                               
MFA-TR*             ,:DY-STREET-NAME                                            
MFA-TR*             ,:DY-ADDR-SUFFIX                                            
MFA-TR*             ,:DY-ADDRESS-OVERFLOW                                       
MFA-TR*             ,:DY-ZIP-CODE                                               
MFA-TR*             ,:DY-ZIP-CODE-PLUS-FOUR                                     
MFA-TR*             ,:DY-STREET-LOCATION-1                                      
MFA-TR*             ,:DY-STREET-LOCATION-2                                      
MFA-TR*             ,:A4-TOWN                                                   
MFA-TR*             ,:A4-STATE                                                  
MFA-TR*         FROM CSS_ADDR_FORMATTED DY,                                     
MFA-TR*              CSS_ZIP_CODE       A4                                      
MFA-TR*        WHERE DY.ADDRESS_ID     = :DY-ADDRESS-ID                         
MFA-TR*          AND A4.ZIP_CODE       = DY.ZIP_CODE                            
MFA-TR*          AND A4.ZIP_CODE_TOKEN = DY.ZIP_CODE_TOKEN                      
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7230                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7230'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT            '      TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ADDR_FORMATTED'      TO TABLE-1                 
              MOVE 'CSS_ZIP_CODE'            TO TABLE-2                 
              MOVE 'ADDRESS-ID'              TO TABLE-ELEMENT-1         
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2         
              MOVE DY-ADDRESS-ID             TO HOSTVAR-ELEMENT-1       
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND               THRU 9700-EXIT   
           END-IF.                                                      
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7240-SELECT-PREMISE                                            *        
      ******************************************************************        
                                                                        
       7240-SELECT-PREMISE.                                             
                                                                        
           EXEC SQL                                                     
              SELECT ADDRESS_ID                                         
                    ,ADDRESS_FORMAT                                     
                INTO :PR-ADDRESS-ID                                     
                    ,:PR-ADDRESS-FORMAT                                 
                FROM CSS_PREMISE WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :WS-PREMISE-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ADDRESS_ID                                                 
MFA-TR*             ,ADDRESS_FORMAT                                             
MFA-TR*         INTO :PR-ADDRESS-ID                                             
MFA-TR*             ,:PR-ADDRESS-FORMAT                                         
MFA-TR*         FROM CSS_PREMISE                                                
MFA-TR*        WHERE PREMISE_NO = :WS-PREMISE-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7240                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7240'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_PREMISE'             TO TABLE-1                 
              MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-PREMISE-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND               THRU 9700-EXIT   
           END-IF.                                                      
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7250-SELECT-ARCHIVED-ACCOUNT                                   *        
      ******************************************************************        
                                                                        
       7250-SELECT-ARCHIVED-ACCOUNT.                                    
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                    ,HA.ADDRESS_ID                                      
                    ,HA.ADDRESS_FORMAT                                  
                    ,HA.PREMISE_NO                                      
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), HA.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                INTO :WS-ARCHIVED-FL                                    
                    ,:WS-AT-ADDRESS-ID                                  
                    ,:WS-AT-ADDRESS-FORMAT                              
                    ,:WS-PREMISE-NO                                     
                    ,:HA-LAST-UPDATE-TS                                 
                FROM HST_ACCOUNT HA WITH(READUNCOMMITTED)                       
               WHERE HA.ACCOUNT_NO = :HA-ACCOUNT-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*             ,HA.ADDRESS_ID                                              
MFA-TR*             ,HA.ADDRESS_FORMAT                                          
MFA-TR*             ,HA.PREMISE_NO                                              
MFA-TR*             ,HA.LAST_UPDATE_TS                                          
MFA-TR*         INTO :WS-ARCHIVED-FL                                            
MFA-TR*             ,:WS-AT-ADDRESS-ID                                          
MFA-TR*             ,:WS-AT-ADDRESS-FORMAT                                      
MFA-TR*             ,:WS-PREMISE-NO                                             
MFA-TR*             ,:HA-LAST-UPDATE-TS                                         
MFA-TR*         FROM HST_ACCOUNT HA                                             
MFA-TR*        WHERE HA.ACCOUNT_NO = :HA-ACCOUNT-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7250                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7250'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'HST_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE HA-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND               THRU 9700-EXIT   
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  12310000
      * 8000A-DELETE-GTT-ROWS.                                       *  12320000
      ****************************************************************  12330000
                                                                        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           EXEC SQL                                                     
                DELETE FROM #CSR04889                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM SESSION.CSR04889                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE '8000A'                   TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04889'                TO TABLE-1                 
              MOVE SPACES                    TO TABLE-ELEMENT-1         
              MOVE SPACES                    TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT    
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ****************************************************************  12310000
      * 8100-SEND-RESULT                                             *  12320000
      ****************************************************************  12330000
                                                                        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
                INSERT INTO #CSR04889                            
                (                                                       
                      RETURN_CODE                                       
                     ,REFUND_ITEM_ID                                    
                     ,REFUND_CHECK                                      
                     ,DEPOSIT_CERT_NO                                   
                     ,LOCAL_OFFICE                                      
                     ,REQUEST_DT                                        
                     ,CLEARED_DT                                        
                     ,DATE_CANCELLED                                    
                     ,DATE_CHECK_VOIDED                                 
                     ,STOP_REQUEST_DT                                   
                     ,STOP_CONFIRM_DT                                   
                     ,CHECK_REMAIL_DT                                   
                     ,REISSUED_DATE                                     
                     ,ORIGINAL_CHECK_NO                                 
                     ,RETURNED_REASON                                   
                     ,USER_ID_APPRVD_BY                                 
                     ,USER_ID_RQSTED_BY                                 
                     ,RETURNED_DATE                                     
                     ,DATE_APPROPRIATED                                 
                     ,DATE_ESCHEATED                                    
                     ,COMMENTS                                          
                     ,AMT_REFUNDED                                      
                     ,MANUAL_INDICATOR                                  
                     ,DATE_REFUNDED                                     
                     ,CHECK_ISS_REAS_CD                                 
                     ,CHECK_STATUS_CD                                   
                     ,REFUND_STATUS_DT                                  
                     ,DATE_ESCH_RETURNED                                
                     ,DATE_VERIFIED                                     
                     ,PANEL_NO                                          
                     ,TRANS_HIST_SEQ_NO                                 
                     ,NAME_FORMAT                                       
                     ,TITLE_PREFIX                                      
                     ,FIRST_NAME                                        
                     ,MIDDLE_NAME                                       
                     ,LAST_NAME                                         
                     ,FULL_NAME                                         
                     ,TITLE_SUFFIX_1                                    
                     ,TITLE_SUFFIX_2                                    
                     ,ADDRESS_FORMAT                                    
                     ,HOUSE_NO                                          
                     ,ADDR_PREFIX_1                                     
                     ,ADDR_PREFIX_2                                     
                     ,ADDR_SUFFIX                                       
                     ,STREET_NAME                                       
                     ,STREET_SUFFIX                                     
                     ,ADDRESS_OVERFLOW                                  
                     ,CITY                                              
                     ,STATE                                             
                     ,COUNTRY                                           
                     ,ZIP_CODE                                          
                     ,ZIP_CODE_PLUS_FOUR                                
                     ,STREET_LOCATION_1                                 
                     ,STREET_LOCATION_2                                 
                     ,ESCHEATMENT_CD                                    
                     ,LAST_UPDATE_TS                                    
                     ,ADDRESS_ID                                        
                )                                                       
                VALUES                                                  
                (                                                       
                      :S-RETURN-CODE                                    
                     ,:S-REFUND-ITEM-ID                                 
                     ,:S-REFUND-CHECK-NO                                
                     ,:S-DEPOSIT-CERT-NO                                
                     ,:S-LOCAL-OFFICE                                   
                     ,:S-REQUEST-DT                                     
                     ,:S-CLEARED-DT                                     
                     ,:S-DATE-CANCELLED                                 
                     ,:S-DATE-CHECK-VOIDED                              
                     ,:S-STOP-REQUEST-DT                                
                     ,:S-STOP-CONFIRM-DT                                
                     ,:S-CHECK-REMAIL-DT                                
                     ,:S-REISSUED-DATE                                  
                     ,:S-ORIGINAL-CHECK-NO                              
                     ,:S-RETURNED-REASON                                
                     ,:S-USER-ID-APPRVD-BY                              
                     ,:S-USER-ID-RQSTED-BY                              
                     ,:S-RETURNED-DATE                                  
                     ,:S-DATE-APPROPRIATED                              
                     ,:S-DATE-ESCHEATED                                 
                     ,:S-COMMENTS                                       
                     ,:S-AMT-REFUNDED                                   
                     ,:S-MANUAL-INDICATOR                               
                     ,:S-DATE-REFUNDED                                  
                     ,:S-CHECK-ISS-REAS-CD                              
                     ,:S-CHECK-STATUS-CD                                
                     ,:S-REFUND-STATUS-DT                               
                     ,:S-DATE-ESCH-RETURNED                             
                     ,:S-DATE-ESCH-VERIFIED                             
                     ,:S-PANEL-NO                                       
                     ,:S-TRANS-HIST-SEQ-NO                              
                     ,:S-NAME-FORMAT                                    
                     ,:S-TITLE-PREFIX                                   
                     ,:S-FIRST-NAME                                     
                     ,:S-MIDDLE-NAME                                    
                     ,:S-LAST-NAME                                      
                     ,:S-FULL-NAME                                      
                     ,:S-TITLE-SUFFIX-1                                 
                     ,:S-TITLE-SUFFIX-2                                 
                     ,:S-ADDRESS-FORMAT                                 
                     ,:S-HOUSE-NO                                       
                     ,:S-ADDR-PREFIX-1                                  
                     ,:S-ADDR-PREFIX-2                                  
                     ,:S-ADDR-SUFFIX                                    
                     ,:S-STREET-NAME                                    
                     ,:S-STREET-SUFFIX                                  
                     ,:S-ADDRESS-OVERFLOW                               
                     ,:S-CITY                                           
                     ,:S-STATE                                          
                     ,:S-COUNTRY                                        
                     ,:S-ZIP-CODE                                       
                     ,:S-ZIP-CODE-PLUS-FOUR                             
                     ,:S-STREET-LOCATION-1                              
                     ,:S-STREET-LOCATION-2                              
                     ,:S-ESCHEATMENT-CD                                 
                     ,:S-LAST-UPDATE-TS                                 
                     ,:S-ADDRESS-ID                                     
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04889                                    
MFA-TR*         (                                                               
MFA-TR*               RETURN_CODE                                               
MFA-TR*              ,REFUND_ITEM_ID                                    01670000
MFA-TR*              ,REFUND_CHECK                                              
MFA-TR*              ,DEPOSIT_CERT_NO                                           
MFA-TR*              ,LOCAL_OFFICE                                              
MFA-TR*              ,REQUEST_DT                                                
MFA-TR*              ,CLEARED_DT                                                
MFA-TR*              ,DATE_CANCELLED                                            
MFA-TR*              ,DATE_CHECK_VOIDED                                         
MFA-TR*              ,STOP_REQUEST_DT                                           
MFA-TR*              ,STOP_CONFIRM_DT                                           
MFA-TR*              ,CHECK_REMAIL_DT                                           
MFA-TR*              ,REISSUED_DATE                                             
MFA-TR*              ,ORIGINAL_CHECK_NO                                         
MFA-TR*              ,RETURNED_REASON                                           
MFA-TR*              ,USER_ID_APPRVD_BY                                         
MFA-TR*              ,USER_ID_RQSTED_BY                                         
MFA-TR*              ,RETURNED_DATE                                             
MFA-TR*              ,DATE_APPROPRIATED                                         
MFA-TR*              ,DATE_ESCHEATED                                            
MFA-TR*              ,COMMENTS                                                  
MFA-TR*              ,AMT_REFUNDED                                              
MFA-TR*              ,MANUAL_INDICATOR                                          
MFA-TR*              ,DATE_REFUNDED                                             
MFA-TR*              ,CHECK_ISS_REAS_CD                                         
MFA-TR*              ,CHECK_STATUS_CD                                           
MFA-TR*              ,REFUND_STATUS_DT                                          
MFA-TR*              ,DATE_ESCH_RETURNED                                        
MFA-TR*              ,DATE_VERIFIED                                             
MFA-TR*              ,PANEL_NO                                                  
MFA-TR*              ,TRANS_HIST_SEQ_NO                                         
MFA-TR*              ,NAME_FORMAT                                               
MFA-TR*              ,TITLE_PREFIX                                              
MFA-TR*              ,FIRST_NAME                                                
MFA-TR*              ,MIDDLE_NAME                                               
MFA-TR*              ,LAST_NAME                                                 
MFA-TR*              ,FULL_NAME                                                 
MFA-TR*              ,TITLE_SUFFIX_1                                            
MFA-TR*              ,TITLE_SUFFIX_2                                            
MFA-TR*              ,ADDRESS_FORMAT                                            
MFA-TR*              ,HOUSE_NO                                                  
MFA-TR*              ,ADDR_PREFIX_1                                             
MFA-TR*              ,ADDR_PREFIX_2                                             
MFA-TR*              ,ADDR_SUFFIX                                               
MFA-TR*              ,STREET_NAME                                               
MFA-TR*              ,STREET_SUFFIX                                             
MFA-TR*              ,ADDRESS_OVERFLOW                                          
MFA-TR*              ,CITY                                                      
MFA-TR*              ,STATE                                                     
MFA-TR*              ,COUNTRY                                                   
MFA-TR*              ,ZIP_CODE                                                  
MFA-TR*              ,ZIP_CODE_PLUS_FOUR                                        
MFA-TR*              ,STREET_LOCATION_1                                         
MFA-TR*              ,STREET_LOCATION_2                                         
MFA-TR*              ,ESCHEATMENT_CD                                            
MFA-TR*              ,LAST_UPDATE_TS                                            
MFA-TR*              ,ADDRESS_ID                                                
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*               :S-RETURN-CODE                                    01670000
MFA-TR*              ,:S-REFUND-ITEM-ID                                 01670000
MFA-TR*              ,:S-REFUND-CHECK-NO                                        
MFA-TR*              ,:S-DEPOSIT-CERT-NO                                        
MFA-TR*              ,:S-LOCAL-OFFICE                                           
MFA-TR*              ,:S-REQUEST-DT                                             
MFA-TR*              ,:S-CLEARED-DT                                             
MFA-TR*              ,:S-DATE-CANCELLED                                         
MFA-TR*              ,:S-DATE-CHECK-VOIDED                                      
MFA-TR*              ,:S-STOP-REQUEST-DT                                        
MFA-TR*              ,:S-STOP-CONFIRM-DT                                        
MFA-TR*              ,:S-CHECK-REMAIL-DT                                        
MFA-TR*              ,:S-REISSUED-DATE                                          
MFA-TR*              ,:S-ORIGINAL-CHECK-NO                                      
MFA-TR*              ,:S-RETURNED-REASON                                        
MFA-TR*              ,:S-USER-ID-APPRVD-BY                                      
MFA-TR*              ,:S-USER-ID-RQSTED-BY                                      
MFA-TR*              ,:S-RETURNED-DATE                                          
MFA-TR*              ,:S-DATE-APPROPRIATED                                      
MFA-TR*              ,:S-DATE-ESCHEATED                                         
MFA-TR*              ,:S-COMMENTS                                               
MFA-TR*              ,:S-AMT-REFUNDED                                           
MFA-TR*              ,:S-MANUAL-INDICATOR                                       
MFA-TR*              ,:S-DATE-REFUNDED                                          
MFA-TR*              ,:S-CHECK-ISS-REAS-CD                                      
MFA-TR*              ,:S-CHECK-STATUS-CD                                        
MFA-TR*              ,:S-REFUND-STATUS-DT                                       
MFA-TR*              ,:S-DATE-ESCH-RETURNED                                     
MFA-TR*              ,:S-DATE-ESCH-VERIFIED                                     
MFA-TR*              ,:S-PANEL-NO                                               
MFA-TR*              ,:S-TRANS-HIST-SEQ-NO                                      
MFA-TR*              ,:S-NAME-FORMAT                                            
MFA-TR*              ,:S-TITLE-PREFIX                                           
MFA-TR*              ,:S-FIRST-NAME                                             
MFA-TR*              ,:S-MIDDLE-NAME                                            
MFA-TR*              ,:S-LAST-NAME                                              
MFA-TR*              ,:S-FULL-NAME                                              
MFA-TR*              ,:S-TITLE-SUFFIX-1                                         
MFA-TR*              ,:S-TITLE-SUFFIX-2                                         
MFA-TR*              ,:S-ADDRESS-FORMAT                                         
MFA-TR*              ,:S-HOUSE-NO                                               
MFA-TR*              ,:S-ADDR-PREFIX-1                                          
MFA-TR*              ,:S-ADDR-PREFIX-2                                          
MFA-TR*              ,:S-ADDR-SUFFIX                                            
MFA-TR*              ,:S-STREET-NAME                                            
MFA-TR*              ,:S-STREET-SUFFIX                                          
MFA-TR*              ,:S-ADDRESS-OVERFLOW                                       
MFA-TR*              ,:S-CITY                                                   
MFA-TR*              ,:S-STATE                                                  
MFA-TR*              ,:S-COUNTRY                                                
MFA-TR*              ,:S-ZIP-CODE                                               
MFA-TR*              ,:S-ZIP-CODE-PLUS-FOUR                                     
MFA-TR*              ,:S-STREET-LOCATION-1                                      
MFA-TR*              ,:S-STREET-LOCATION-2                                      
MFA-TR*              ,:S-ESCHEATMENT-CD                                         
MFA-TR*              ,:S-LAST-UPDATE-TS                                         
MFA-TR*              ,:S-ADDRESS-ID                                             
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                ADD +1                       TO CTR-ROWS                
           ELSE                                                         
                MOVE PROGRAM-NAME            TO ABEND-PROGRAM           
                MOVE SQLCODE                 TO ABEND-SQLCODE           
                MOVE '8010'                  TO ACTIVE-PARAGRAPH        
                MOVE 'INSERT'                TO ABEND-FUNCTION          
                MOVE SPACES                  TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                MOVE 'CSR04889'              TO TABLE-1                 
                PERFORM 9700-PROCESS-ABEND             THRU 9700-EXIT   
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT.  
           PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT.  
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900 - JOURNALING / ERROR HANDLING INCLUDE                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999 - END PROGRAM COPYLIB                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00320                                                  
           END-EXEC.                                                            
                                                                        
