       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04888.                                         
       AUTHOR.        AARON ABRAHAM                                     
COB303 DATE-WRITTEN.  FEB 04, 2016.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *  This procedure is used to refund Credit Balance & Previous    *        
      *  Payment.                                                      *        
      *                                                                *        
      *  # Invoked from Account Receivable Solution/Refunds Project    *        
      *  # BusOp Name: RequUpdIssueRefund                              *00001600
      *  # CSR04910 - This procedure Refunds Previous Payment          *        
      *  # CSR04911 - This procedure Refunds Credit Balance            *        
      *                                                                *        
      *  PARM-TYPE                                                     *        
      *    'PYMT'   - Previous Payment                                 *        
      *    'CRDBAL' - Credit Balance                                   *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      * ---------- -------- ------------------------------------------ *        
      *    DATE    INITIALS COMMENTS                                   *        
      * ---------- -------- ------------------------------------------ *        
P00870* 02/04/2015 AA97148  INITIAL IMPLEMENTATION.                    *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************00650000
      *                                                                *00660000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00670000
      *                                                                *00680000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00690000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00700000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00710000
      *  3000 - 4999  NOT USED                                         *00720000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00730000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00740000
      *  7000 - 7999  INPUT MODULES                                    *00750000
      *  8000 - 8999  OUTPUT MODULES                                   *00760000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00770000
      *                                                                *00780000
      ******************************************************************00790000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04888'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04888 STARTS HERE'.                  
                                                                        
      ******************************************************************02120000
      *    COBOL WORKING STORAGE COPY BOOKS                            *02130000
      ******************************************************************02140000
                                                                        
      ******************************************************************        
      *   SQL COMMUNICATION AREA                                       *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * ERROR HANDLING                                                 *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00000010
              INCLUDE CWSX0010                                          00000020
           END-EXEC.                                                    00000030
                                                                        
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                               02320000
                                                                        
       01 WS-MISC.                                                      
          05 PROGRAM-NAME               PIC X(08) VALUE 'CSR04888'.     
          05 WS-PARM-TYPE               PIC X(05) VALUE SPACES.         
                                                                        
       01 WS-COUNTERS.                                                  
          05 CTR-ROWS                   PIC S9(09) COMP VALUE 0.        
                                                                        
       01 SWITCHES.                                                     
          05 SEND-DONE-SW               PIC X(01) VALUE 'Y'.            
             88 SEND-DONE-ERROR                   VALUE 'N'.            
             88 SEND-DONE-OK                      VALUE 'Y'.            
                                                                        
       01  CSRERLOG-P.                                                  
           05  S-SP-NAME                  PIC X(18)  VALUE SPACES.      
           05  S-SQLCODE                  PIC S9(9)  COMP  VALUE 0.     
           05  S-SQLSTATE                 PIC X(5)   VALUE ' '.         
           05  S-TABLE-NAME               PIC X(18)  VALUE SPACES.      
           05  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L     PIC S9(4)  USAGE COMP.        
               49  S-HOST-VARIABLES-V     PIC X(255).                   
           05  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L      PIC S9(4)  USAGE COMP.        
               49  S-SQL-STATEMENT-V      PIC X(255).                   
           05  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L    PIC S9(4)  USAGE COMP.        
               49  S-SQL-DESCRIPTION-V    PIC X(255).                   
           05  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L    PIC S9(4)  USAGE COMP.        
               49  WS-ABEND-SQLERRMC-V    PIC X(255).                   
           05  WS-SQLSTATE                PIC X(05)  VALUE SPACES.      
           05  WS-GTT-NAME                PIC X(19)  VALUE SPACES.      
                                                                        
      * CSR04910 RETURN AREA                                                    
       01 WS-CSR04910-RET-AREA.                                         
          05 WS-4910-RETURN-CODE        PIC S9(9) COMP VALUE 0.         
          05 WS-4910-APPL-RETURN-CODE   PIC X(10) VALUE SPACES.         
          05 WS-4910-AT-LAST-UPD-TS     PIC X(26) VALUE SPACES.         
                                                                        
      * CSR04911 RETURN AREA                                                    
       01 WS-CSR04911-RET-AREA.                                         
          05 WS-4911-RETURN-CODE        PIC S9(9) COMP VALUE 0.         
          05 WS-4911-APPL-RETURN-CODE   PIC X(10) VALUE SPACES.         
          05 WS-4911-AT-LAST-UPD-TS     PIC X(26) VALUE SPACES.         
                                                                        
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE              PIC S9(9) COMP VALUE 0.         
          05 S-APPL-RETURN-CODE         PIC X(10) VALUE SPACES.         
          05 S-AT-LAST-UPD-TS           PIC X(26) VALUE SPACES.         
                                                                        
      * RESULT SET LOCATOR                                                      
      *01 LOC1 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.            
      *01 LOC2 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.            
MSQ001        EXEC SQL
MSQ001          DECLARE PYMT_CUR CURSOR
MSQ001          FOR CALL CSR04910                                       
                       ( :PARM-ACCOUNT-NO
                  , :PARM-ACTION-CODE
                  , :PARM-TRANS-HIST-SEQ-NO
                  , :PARM-PREV-DATE-TRANS
                  , :PARM-AMT-REFUNDED
                  , :PARM-TOTAL-ORIG-AMT
                  , :PARM-CHECK-ISS-REAS-CD
                  , :PARM-CHECK-STATUS-CD
                  , :PARM-COMMENTS
                  , :PARM-COMMENTS-LEN
                  , :PARM-MANUAL-INDICATOR
                  , :PARM-REQUEST-DT
                  , :PARM-GS-USER-ID
                  , :PARM-TRANS-COMMENTS
                  , :PARM-TRANS-COMMENTS-LEN
                  , :PARM-CASH-COMPANY-NO
                  , :PARM-CASH-LOCAL-OFFICE
                  , :PARM-CASH-REPORT-NO
                  , :PARM-DATE-CASH-REPORT
                  , :PARM-CASH-DRAWER-ID
                  , :PARM-ADDRESS-CHANGED-FL
                  , :PARM-ADDRESS-FORMAT
                  , :PARM-FMT-HOUSE-NO
                  , :PARM-FMT-ADDR-PREFIX-1
                  , :PARM-FMT-ADDR-PREFIX-2
                  , :PARM-FMT-STREET-NAME
                  , :PARM-FMT-STREET-SUFFIX
                  , :PARM-FMT-ADDR-SUFFIX
                  , :PARM-FMT-STREET-LOCATION-1
                  , :PARM-FMT-STREET-LOCATION-2
                  , :PARM-FF-ADDR-STREET
                  , :PARM-FF-ADDRESS-OVERFLOW
                  , :PARM-FF-ADDR-COUNTRY
                  , :PARM-FF-ADDRESS-CITY-STATE
                  , :PARM-CITY
                  , :PARM-STATE
                  , :PARM-ZIP-CODE
                  , :PARM-ZIP-CODE-PLUS-FOUR
                  , :PARM-LAST-UPDATE-TS
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE CRED_BAL CURSOR
MSQ001          FOR CALL CSR04911                                       
                       ( :PARM-ACCOUNT-NO
                  , :PARM-ACTION-CODE
                  , :PARM-TRANS-HIST-SEQ-NO
                  , :PARM-RFND-CHECK-AMT
                  , :PARM-RFND-CASH-AMT
                  , :PARM-CHECK-ISS-REAS-CD
                  , :PARM-CHECK-STATUS-CD
                  , :PARM-ITEM-ID
                  , :PARM-COMMENTS
                  , :PARM-COMMENTS-LEN
                  , :PARM-REQST-DT-CHANGED
                  , :PARM-REQUEST-DT
                  , :PARM-PANEL-NO
                  , :PARM-GS-USER-ID
                  , :PARM-TRANS-COMMENTS
                  , :PARM-TRANS-COMMENTS-LEN
                  , :PARM-CASH-COMPANY-NO
                  , :PARM-CASH-LOCAL-OFFICE
                  , :PARM-CASH-REPORT-NO
                  , :PARM-DATE-CASH-REPORT
                  , :PARM-CASH-DRAWER-ID
                  , :PARM-CSR-PC-ID
                  , :PARM-LAST-UPDATE-TS
                  , :PARM-ADDRESS-CHANGED-FL
                  , :PARM-ADDRESS-FORMAT
                  , :PARM-FMT-HOUSE-NO
                  , :PARM-FMT-ADDR-PREFIX-1
                  , :PARM-FMT-ADDR-PREFIX-2
                  , :PARM-FMT-STREET-NAME
                  , :PARM-FMT-STREET-SUFFIX
                  , :PARM-FMT-ADDR-SUFFIX
                  , :PARM-FMT-STREET-LOCATION-1
                  , :PARM-FMT-STREET-LOCATION-2
                  , :PARM-FF-ADDR-STREET
                  , :PARM-FF-ADDRESS-OVERFLOW
                  , :PARM-FF-ADDR-COUNTRY
                  , :PARM-FF-ADDRESS-CITY-STATE
                  , :PARM-CITY
                  , :PARM-STATE
                  , :PARM-ZIP-CODE
                  , :PARM-ZIP-CODE-PLUS-FOUR
                  )
MSQ001        END-EXEC.
            
                                                                        
      ******************************************************************        
      **   LINKAGE SECTION.                                           **        
      ******************************************************************        
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO              PIC X(13) VALUE SPACES.         
       01  PARM-ACTION-CODE             PIC X(01) VALUE SPACES.         
       01  PARM-TYPE                    PIC X(05) VALUE SPACES.         
       01  PARM-TRANS-HIST-SEQ-NO       PIC X(26) VALUE SPACES.         
       01  PARM-CHECK-ISS-REAS-CD       PIC X(02) VALUE SPACES.         
       01  PARM-CHECK-STATUS-CD         PIC X(01) VALUE SPACES.         
       01  PARM-GS-USER-ID              PIC X(07) VALUE SPACES.         
       01  PARM-REQUEST-DT              PIC X(10) VALUE SPACES.         
       01  PARM-CASH-COMPANY-NO         PIC X(02) VALUE SPACES.         
       01  PARM-CASH-LOCAL-OFFICE       PIC X(03) VALUE SPACES.         
       01  PARM-CASH-REPORT-NO          PIC X(03) VALUE SPACES.         
       01  PARM-DATE-CASH-REPORT        PIC X(10) VALUE SPACES.         
       01  PARM-CASH-DRAWER-ID          PIC X(04) VALUE SPACES.         
       01  PARM-COMMENTS                PIC X(72) VALUE SPACES.         
       01  PARM-COMMENTS-LEN            PIC X(04) VALUE SPACES.         
       01  PARM-TRANS-COMMENTS          PIC X(210) VALUE SPACES.        
       01  PARM-TRANS-COMMENTS-LEN      PIC X(04) VALUE SPACES.         
       01  PARM-ADDRESS-CHANGED-FL      PIC X(01) VALUE SPACES.         
       01  PARM-ADDRESS-FORMAT          PIC X(01) VALUE SPACES.         
       01  PARM-FMT-HOUSE-NO            PIC X(15) VALUE SPACES.         
       01  PARM-FMT-ADDR-PREFIX-1       PIC X(03) VALUE SPACES.         
       01  PARM-FMT-ADDR-PREFIX-2       PIC X(02) VALUE SPACES.         
       01  PARM-FMT-STREET-NAME         PIC X(30) VALUE SPACES.         
       01  PARM-FMT-STREET-SUFFIX       PIC X(04) VALUE SPACES.         
       01  PARM-FMT-ADDR-SUFFIX         PIC X(02) VALUE SPACES.         
       01  PARM-FMT-STREET-LOCATION-1   PIC X(04) VALUE SPACES.         
       01  PARM-FMT-STREET-LOCATION-2   PIC X(11) VALUE SPACES.         
       01  PARM-FF-ADDR-STREET          PIC X(55) VALUE SPACES.         
       01  PARM-FF-ADDRESS-OVERFLOW     PIC X(35) VALUE SPACES.         
       01  PARM-FF-ADDR-COUNTRY         PIC X(35) VALUE SPACES.         
       01  PARM-FF-ADDRESS-CITY-STATE   PIC X(30) VALUE SPACES.         
       01  PARM-CITY                    PIC X(26) VALUE SPACES.         
       01  PARM-STATE                   PIC X(02) VALUE SPACES.         
       01  PARM-ZIP-CODE                PIC X(05) VALUE SPACES.         
       01  PARM-ZIP-CODE-PLUS-FOUR      PIC X(04) VALUE SPACES.         
       01  PARM-PREV-DATE-TRANS         PIC X(10) VALUE SPACES.         
       01  PARM-AMT-REFUNDED            PIC X(11) VALUE SPACES.         
       01  PARM-TOTAL-ORIG-AMT          PIC X(11) VALUE SPACES.         
       01  PARM-MANUAL-INDICATOR        PIC X(01) VALUE SPACES.         
       01  PARM-RFND-CHECK-AMT          PIC X(11) VALUE SPACES.         
       01  PARM-RFND-CASH-AMT           PIC X(11) VALUE SPACES.         
       01  PARM-ITEM-ID                 PIC X(09) VALUE SPACES.         
       01  PARM-REQST-DT-CHANGED        PIC X(01) VALUE SPACES.         
       01  PARM-PANEL-NO                PIC X(04) VALUE SPACES.         
       01  PARM-CSR-PC-ID               PIC X(04) VALUE SPACES.         
       01  PARM-LAST-UPDATE-TS          PIC X(26) VALUE SPACES.         
                                                                        
       PROCEDURE DIVISION USING                                         
                PARM-ACCOUNT-NO                                         
               ,PARM-ACTION-CODE                                        
               ,PARM-TYPE                                               
               ,PARM-TRANS-HIST-SEQ-NO                                  
               ,PARM-CHECK-ISS-REAS-CD                                  
               ,PARM-CHECK-STATUS-CD                                    
               ,PARM-GS-USER-ID                                         
               ,PARM-REQUEST-DT                                         
               ,PARM-CASH-COMPANY-NO                                    
               ,PARM-CASH-LOCAL-OFFICE                                  
               ,PARM-CASH-REPORT-NO                                     
               ,PARM-DATE-CASH-REPORT                                   
               ,PARM-CASH-DRAWER-ID                                     
               ,PARM-COMMENTS                                           
               ,PARM-COMMENTS-LEN                                       
               ,PARM-TRANS-COMMENTS                                     
               ,PARM-TRANS-COMMENTS-LEN                                 
               ,PARM-ADDRESS-CHANGED-FL                                 
               ,PARM-ADDRESS-FORMAT                                     
               ,PARM-FMT-HOUSE-NO                                       
               ,PARM-FMT-ADDR-PREFIX-1                                  
               ,PARM-FMT-ADDR-PREFIX-2                                  
               ,PARM-FMT-STREET-NAME                                    
               ,PARM-FMT-STREET-SUFFIX                                  
               ,PARM-FMT-ADDR-SUFFIX                                    
               ,PARM-FMT-STREET-LOCATION-1                              
               ,PARM-FMT-STREET-LOCATION-2                              
               ,PARM-FF-ADDR-STREET                                     
               ,PARM-FF-ADDRESS-OVERFLOW                                
               ,PARM-FF-ADDR-COUNTRY                                    
               ,PARM-FF-ADDRESS-CITY-STATE                              
               ,PARM-CITY                                               
               ,PARM-STATE                                              
               ,PARM-ZIP-CODE                                           
               ,PARM-ZIP-CODE-PLUS-FOUR                                 
               ,PARM-PREV-DATE-TRANS                                    
               ,PARM-AMT-REFUNDED                                       
               ,PARM-TOTAL-ORIG-AMT                                     
               ,PARM-MANUAL-INDICATOR                                   
               ,PARM-RFND-CHECK-AMT                                     
               ,PARM-RFND-CASH-AMT                                      
               ,PARM-ITEM-ID                                            
               ,PARM-REQST-DT-CHANGED                                   
               ,PARM-PANEL-NO                                           
               ,PARM-CSR-PC-ID                                          
               ,PARM-LAST-UPDATE-TS.                                    
                                                                        
      ******************************************************************05170000
      * 0000-MAINLINE                                                  *05180000
      ******************************************************************05250000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05360000
      * 0100-INITIALIZE                                                *05370000
      ******************************************************************05480000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR   FOR                
                SELECT                                                  
                   :S-RETURN-CODE              AS RETURN_CODE           
                   ,LTRIM(RTRIM(:S-APPL-RETURN-CODE)) AS 
           APPL_RETURN_CODE      
                   ,LTRIM(RTRIM(:S-AT-LAST-UPD-TS))   AS AT_LAST_UPD_TS        
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR* MSQ034
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH HOLD WITH RETURN FOR                        
MFA-TR*         SELECT                                                          
MFA-TR*            :S-RETURN-CODE              AS RETURN_CODE                   
MFA-TR*            ,STRIP(:S-APPL-RETURN-CODE) AS APPL_RETURN_CODE              
MFA-TR*            ,STRIP(:S-AT-LAST-UPD-TS)   AS AT_LAST_UPD_TS                
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05770000
      * 1000-PROCESS-INPUT                                             *05780000
      ******************************************************************05840000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-TYPE                      TO WS-PARM-TYPE.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09480000
      * 2000-PROCESS-OUTPUT.                                           *09490000
      ******************************************************************09560000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           EVALUATE WS-PARM-TYPE                                        
              WHEN 'PYMT'                                               
                   PERFORM 2100-PROCESS-REFUND-PAYMENT  THRU 2100-EXIT  
              WHEN 'CRBAL'                                              
                   PERFORM 2200-PROCESS-REFUND-CR-BAL   THRU 2200-EXIT  
           END-EVALUATE.                                                
                                                                        
           ADD +1                           TO   CTR-ROWS.              
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************10650000
      * 2100-PROCESS-REFUND-PAYMENT                                    *10660000
      ******************************************************************10670000
                                                                        
       2100-PROCESS-REFUND-PAYMENT.                                     
                                                                        
           MOVE '2100'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 2110-CALL-CSR04910                   THRU 2110-EXIT. 
                                                                        
      *    EXEC SQL                                                     
      *        ASSOCIATE LOCATORS                                       
      *        (:LOC1)                                                  
      *        WITH PROCEDURE CSR04910                                  
      *    END-EXEC                                                     
                                                                        
      *    EXEC SQL                                                     
      *        ALLOCATE PYMT_CUR CURSOR FOR RESULT SET                  
      *        :LOC1                                                    
      *    END-EXEC                                                     
                                                                        
           PERFORM 2120-FETCH-CSR04910                  THRU 2120-EXIT. 
                                                                        
           MOVE WS-4910-RETURN-CODE TO WS-ACTIVE-RETURN-CODE            
                                                                        
           EVALUATE WS-4910-RETURN-CODE                                 
              WHEN 0                                                    
                   MOVE WS-4910-RETURN-CODE      TO S-RETURN-CODE       
                   MOVE WS-4910-APPL-RETURN-CODE TO S-APPL-RETURN-CODE  
                   MOVE WS-4910-AT-LAST-UPD-TS   TO S-AT-LAST-UPD-TS    
              WHEN OTHER                                                
                   MOVE WS-4910-RETURN-CODE      TO S-RETURN-CODE       
                   MOVE 'CALL'                   TO ABEND-FUNCTION      
                   MOVE 'CSR04910'               TO TABLE-1             
                   PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT  
           END-EVALUATE                                                 
                                                                        
           PERFORM 2130-CLOSE-CSR04910                  THRU 2130-EXIT. 
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2110-CALL-CSR04910.                                            *        
      ******************************************************************        
                                                                        
       2110-CALL-CSR04910.                                              
                                                                        
           INITIALIZE WS-CSR04910-RET-AREA.                             
                                                                        
      *    EXEC SQL CALL CSR04910                                       
      *                ( :PARM-ACCOUNT-NO                               
      *                 ,:PARM-ACTION-CODE                              
      *                 ,:PARM-TRANS-HIST-SEQ-NO                        
      *                 ,:PARM-PREV-DATE-TRANS                          
      *                 ,:PARM-AMT-REFUNDED                             
      *                 ,:PARM-TOTAL-ORIG-AMT                           
      *                 ,:PARM-CHECK-ISS-REAS-CD                        
      *                 ,:PARM-CHECK-STATUS-CD                          
      *                 ,:PARM-COMMENTS                                 
      *                 ,:PARM-COMMENTS-LEN                             
      *                 ,:PARM-MANUAL-INDICATOR                         
      *                 ,:PARM-REQUEST-DT                               
      *                 ,:PARM-GS-USER-ID                               
      *                 ,:PARM-TRANS-COMMENTS                           
      *                 ,:PARM-TRANS-COMMENTS-LEN                       
      *                 ,:PARM-CASH-COMPANY-NO                          
      *                 ,:PARM-CASH-LOCAL-OFFICE                        
      *                 ,:PARM-CASH-REPORT-NO                           
      *                 ,:PARM-DATE-CASH-REPORT                         
      *                 ,:PARM-CASH-DRAWER-ID                           
      *                 ,:PARM-ADDRESS-CHANGED-FL                       
      *                 ,:PARM-ADDRESS-FORMAT                           
      *                 ,:PARM-FMT-HOUSE-NO                             
      *                 ,:PARM-FMT-ADDR-PREFIX-1                        
      *                 ,:PARM-FMT-ADDR-PREFIX-2                        
      *                 ,:PARM-FMT-STREET-NAME                          
      *                 ,:PARM-FMT-STREET-SUFFIX                        
      *                 ,:PARM-FMT-ADDR-SUFFIX                          
      *                 ,:PARM-FMT-STREET-LOCATION-1                    
      *                 ,:PARM-FMT-STREET-LOCATION-2                    
      *                 ,:PARM-FF-ADDR-STREET                           
      *                 ,:PARM-FF-ADDRESS-OVERFLOW                      
      *                 ,:PARM-FF-ADDR-COUNTRY                          
      *                 ,:PARM-FF-ADDRESS-CITY-STATE                    
      *                 ,:PARM-CITY                                     
      *                 ,:PARM-STATE                                    
      *                 ,:PARM-ZIP-CODE                                 
      *                 ,:PARM-ZIP-CODE-PLUS-FOUR                       
      *                 ,:PARM-LAST-UPDATE-TS                           
      *                )                                                
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE PYMT_CUR
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN PYMT_CUR
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR PYMT_CUR INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                   S-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = +466                              
              CONTINUE                                                  
           ELSE                                                         
               MOVE '2110'                     TO ACTIVE-PARAGRAPH      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE 'DB2SP CALL'               TO ABEND-FUNCTION        
               MOVE 'CSR04910'                 TO TABLE-1               
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
               MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1     
               MOVE 'SQLCODE'                  TO TABLE-ELEMENT-2       
               MOVE SQLCODE                    TO HOSTVAR-ELEMENT-2     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2120-FETCH-CSR04910.                                           *        
      ******************************************************************        
                                                                        
       2120-FETCH-CSR04910.                                             
                                                                        
           EXEC SQL                                                     
           FETCH PYMT_CUR INTO                                          
                    :WS-4910-RETURN-CODE                                
                   ,:WS-4910-APPL-RETURN-CODE                           
                   ,:WS-4910-AT-LAST-UPD-TS                             
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '2120'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSR04910'                 TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
              MOVE 'SQLCODE '                 TO TABLE-ELEMENT-2        
              MOVE WS-ACTIVE-RETURN-CODE      TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       2120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2130-CLOSE-CSR04910.                                           *        
      ******************************************************************        
                                                                        
       2130-CLOSE-CSR04910.                                             
                                                                        
           EXEC SQL                                                     
              CLOSE PYMT_CUR                                            
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '2130'                  TO ACTIVE-PARAGRAPH          
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE 'CLOSE'                 TO ABEND-FUNCTION            
              MOVE 'CSR04910'              TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1         
              MOVE 'SQLCODE '              TO TABLE-ELEMENT-1           
              MOVE WS-ACTIVE-RETURN-CODE   TO HOSTVAR-ELEMENT-1         
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       2130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************12170000
      * 2200-PROCESS-REFUND-CR-BAL                                     *12180000
      ******************************************************************12230000
                                                                        
       2200-PROCESS-REFUND-CR-BAL.                                      
                                                                        
           MOVE '2200'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 2210-CALL-CSR04911                   THRU 2210-EXIT. 
                                                                        
      *    EXEC SQL                                                     
      *        ASSOCIATE LOCATORS                                       
      *        (:LOC2)                                                  
      *        WITH PROCEDURE CSR04911                                  
      *    END-EXEC                                                     
                                                                        
      *    EXEC SQL                                                     
      *        ALLOCATE CRED_BAL    CURSOR FOR RESULT SET               
      *        :LOC2                                                    
      *    END-EXEC                                                     
                                                                        
           PERFORM 2220-FETCH-CSR04911                  THRU 2220-EXIT. 
                                                                        
           MOVE WS-4911-RETURN-CODE TO WS-ACTIVE-RETURN-CODE            
                                                                        
           EVALUATE WS-4911-RETURN-CODE                                 
              WHEN 0                                                    
                   MOVE WS-4911-RETURN-CODE      TO S-RETURN-CODE       
                   MOVE WS-4911-APPL-RETURN-CODE TO S-APPL-RETURN-CODE  
                   MOVE WS-4911-AT-LAST-UPD-TS   TO S-AT-LAST-UPD-TS    
              WHEN OTHER                                                
                   MOVE WS-4911-RETURN-CODE      TO S-RETURN-CODE       
                   MOVE 'CALL'                   TO ABEND-FUNCTION      
                   MOVE 'CSR04911'               TO TABLE-1             
                   PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT  
           END-EVALUATE                                                 
                                                                        
           PERFORM 2230-CLOSE-CSR04911                  THRU 2230-EXIT. 
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2210-CALL-CSR04911.                                            *        
      ******************************************************************        
                                                                        
       2210-CALL-CSR04911.                                              
                                                                        
           INITIALIZE WS-CSR04911-RET-AREA.                             
                                                                        
      *    EXEC SQL CALL CSR04911                                       
      *                ( :PARM-ACCOUNT-NO                               
      *                 ,:PARM-ACTION-CODE                              
      *                 ,:PARM-TRANS-HIST-SEQ-NO                        
      *                 ,:PARM-RFND-CHECK-AMT                           
      *                 ,:PARM-RFND-CASH-AMT                            
      *                 ,:PARM-CHECK-ISS-REAS-CD                        
      *                 ,:PARM-CHECK-STATUS-CD                          
      *                 ,:PARM-ITEM-ID                                  
      *                 ,:PARM-COMMENTS                                 
      *                 ,:PARM-COMMENTS-LEN                             
      *                 ,:PARM-REQST-DT-CHANGED                         
      *                 ,:PARM-REQUEST-DT                               
      *                 ,:PARM-PANEL-NO                                 
      *                 ,:PARM-GS-USER-ID                               
      *                 ,:PARM-TRANS-COMMENTS                           
      *                 ,:PARM-TRANS-COMMENTS-LEN                       
      *                 ,:PARM-CASH-COMPANY-NO                          
      *                 ,:PARM-CASH-LOCAL-OFFICE                        
      *                 ,:PARM-CASH-REPORT-NO                           
      *                 ,:PARM-DATE-CASH-REPORT                         
      *                 ,:PARM-CASH-DRAWER-ID                           
      *                 ,:PARM-CSR-PC-ID                                
      *                 ,:PARM-LAST-UPDATE-TS                           
      *                 ,:PARM-ADDRESS-CHANGED-FL                       
      *                 ,:PARM-ADDRESS-FORMAT                           
      *                 ,:PARM-FMT-HOUSE-NO                             
      *                 ,:PARM-FMT-ADDR-PREFIX-1                        
      *                 ,:PARM-FMT-ADDR-PREFIX-2                        
      *                 ,:PARM-FMT-STREET-NAME                          
      *                 ,:PARM-FMT-STREET-SUFFIX                        
      *                 ,:PARM-FMT-ADDR-SUFFIX                          
      *                 ,:PARM-FMT-STREET-LOCATION-1                    
      *                 ,:PARM-FMT-STREET-LOCATION-2                    
      *                 ,:PARM-FF-ADDR-STREET                           
      *                 ,:PARM-FF-ADDRESS-OVERFLOW                      
      *                 ,:PARM-FF-ADDR-COUNTRY                          
      *                 ,:PARM-FF-ADDRESS-CITY-STATE                    
      *                 ,:PARM-CITY                                     
      *                 ,:PARM-STATE                                    
      *                 ,:PARM-ZIP-CODE                                 
      *                 ,:PARM-ZIP-CODE-PLUS-FOUR                       
      *                )                                                
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE CRED_BAL
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN CRED_BAL
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR CRED_BAL INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                   S-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = +466                              
              CONTINUE                                                  
           ELSE                                                         
               MOVE '2210'                     TO ACTIVE-PARAGRAPH      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE 'DB2SP CALL'               TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-TABLES          
                                                  ABEND-SQL-PREDICATES  
               MOVE 'CSR04911'                 TO TABLE-1               
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
               MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1     
               MOVE 'SQLCODE'                  TO TABLE-ELEMENT-2       
               MOVE SQLCODE                    TO HOSTVAR-ELEMENT-2     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2220-FETCH-CSR04911.                                           *        
      ******************************************************************        
                                                                        
       2220-FETCH-CSR04911.                                             
                                                                        
           EXEC SQL                                                     
           FETCH CRED_BAL INTO                                          
                    :WS-4911-RETURN-CODE                                
                   ,:WS-4911-APPL-RETURN-CODE                           
                   ,:WS-4911-AT-LAST-UPD-TS                             
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '2220'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSR04911'                 TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
              MOVE 'SQLCODE '                 TO TABLE-ELEMENT-2        
              MOVE WS-ACTIVE-RETURN-CODE      TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       2220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2230-CLOSE-CSR04911.                                           *        
      ******************************************************************        
                                                                        
       2230-CLOSE-CSR04911.                                             
                                                                        
           EXEC SQL                                                     
             CLOSE CRED_BAL                                             
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '2230'                  TO ACTIVE-PARAGRAPH          
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE 'CLOSE'                 TO ABEND-FUNCTION            
              MOVE 'CSR04911'              TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1         
              MOVE 'SQLCODE '              TO TABLE-ELEMENT-1           
              MOVE WS-ACTIVE-RETURN-CODE   TO HOSTVAR-ELEMENT-1         
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       2230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************34580000
      * 9900-SQL-ERROR-ROUTINE                                         *34590000
      ******************************************************************34600000
                                                                        
           EXEC SQL                                                     34610000
              INCLUDE CPDSP300                                          34620000
           END-EXEC.                                                    34630000
                                                                        
      ******************************************************************        
      * 9700-PROCESS-ABEND                                             *        
      ******************************************************************        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8900-SEND-DONE                                                 *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00000100
               INCLUDE CPD00321                                         00000200
           END-EXEC.                                                    00000300
                                                                        
