       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04887.                                         
       AUTHOR.        AARON ABRAHAM                                     
COB303 DATE-WRITTEN.  OCT 13, 2015.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      * THIS PROCEDURE RETRIEVES REFUND INFORMATION FOR CREDIT BALANCE *        
      * AND PREVIOUS PAYMENTS.                                         *        
      *                                                                *        
      *     PARM-REFUND-TYPE                                           *        
      *     - 'C' - Credit In Advance                                  *        
      *     - 'P' - Previous Payments(Cash/Check)                      *        
      *                                                                *        
      *  #  INVOKED FROM ACCOUNT RECEIVABLE SOLUTION/REFUND PROJECT    *        
      *                                                                *        
      *  #  BUSOP NAME: GETACCTCRORPYMNTREFUNDDTLS                     *        
      *                                                                *        
      *  #  PARAMETERS                                                 *        
      *     IN                                                         *        
      *         ACCOUNT_NO               DECIMAL(13, 0)                *        
      *         REFUND_TYPE              CHAR(01)                      *        
      *                                                                *        
      ******************************************************************        
      *                     PROGRAM MODIFICATION LOG                   *        
      ******************************************************************        
      * --------   -------- ------------------------------------------ *        
      *   DATE     INITIALS COMMENTS                                   *        
      * ---------- -------- ------------------------------------------ *        
P00870* 10/13/2015 AA97148  INITIAL IMPLEMENTATION.                    *        
P0087A* 12/14/2016 WR19680  ADDING NEW FLAG FOR ORDER STATE            *        
      *                                                                *        
      ******************************************************************        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      ******************************************************************        
      * 0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION              *        
      * 1000 - 1999  INPUT PROCESSING CONTROL PATH                     *        
      * 2000 - 2999  OUTPUT PROCESSING CONTROL PATH                    *        
      * 3000 - 4999  NOT USED                                          *        
      * 5000 - 5999  COMMON PROGRAM MODULES                            *        
      * 6000 - 6999  COMMON SYSTEM MODULES                             *        
      * 7000 - 7999  INPUT MODULES                                     *        
      * 8000 - 8999  OUTPUT MODULES                                    *        
      * 9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES              *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04887'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40) VALUE                  
           'WORKING STORAGE FOR CSR04887 STARTS HERE'.                  
                                                                        
       01 WS-MISC.                                                      
          05 PROGRAM-NAME              PIC X(08)       VALUE 'CSR04887'.
          05 WS-PGRMNAME               PIC X(08)       VALUE 'CSR04887'.
          05 WS-AMT-UNUSED-CR          PIC S9(9)V99 COMP-3              
                                                       VALUE 0.         
          05 WS-CHECK-AMT              PIC S9(9)V99 COMP-3              
                                                       VALUE ZEROES.    
          05 WS-CASH-AMT               PIC S9(9)V99 COMP-3              
                                                       VALUE ZEROES.    
          05 WS-OTHER-AMT              PIC S9(9)V99 COMP-3              
                                                       VALUE ZEROES.    
          05 WS-ADDRESS-FORMAT         PIC X(01)       VALUE SPACES.    
          05 WS-ADDRESS-ID             PIC S9(13)V  COMP-3              
                                                       VALUE 0.         
          05 WS-ACCT-TBL-FND           PIC X(01)       VALUE SPACES.    
          05 WS-PREM-TBL-FND           PIC X(01)       VALUE SPACES.    
          05 WS-NSF-HIST-FL            PIC X(01)       VALUE SPACES.    
          05 WS-FIRST-TIME-FL          PIC X(01)       VALUE SPACES.    
          05 WS-LAST-REC-FL            PIC X(01)       VALUE SPACES.    
          05 WS-DEPOSIT-ELIGIBLE-FL    PIC X(01)       VALUE SPACES.    
          05 WS-CURRENT-DATE           PIC X(10)       VALUE SPACES.    
          05 WS-PAST-15-DATE           PIC X(10)       VALUE SPACES.    
          05 WS-DEL-WORK-DATE          PIC X(10)       VALUE SPACES.    
          05 WS-RELEASE-DATE           PIC X(10)       VALUE SPACES.    
          05 WS-CURRENT-TIMESTMP       PIC X(26)       VALUE SPACES.    
          05 WS-TRANS-HIST-SEQ-NO      PIC X(26)       VALUE SPACES.    
          05 WS-DEL-DAYS               PIC S9(3) COMP-3                 
                                                       VALUE 0.         
          05 WS-DEL-CAL-DAYS           PIC S9(3) COMP-3                 
                                                       VALUE 0.         
          05 WS-DATE-TRANS-NULL        PIC S9(4) COMP  VALUE 0.         
          05 RS-RETURN-CODE            PIC S9(4) COMP  VALUE 0.         
          05 WS-SUMM-UNBILLED-NULL     PIC S9(4) COMP  VALUE 0.         
          05 WS-REQUEST-DT-NULL        PIC S9(4) COMP  VALUE 0.         
          05  WS-SUB1                  PIC S9(4) COMP  VALUE 0.         
          05  WS-SUB2                  PIC S9(4) COMP  VALUE 0.         
                                                                        
       01 WS-COUNTERS.                                                  
          05 CTR-ROWS-R1               PIC S9(9) COMP  VALUE 0.         
          05 CTR-ROWS-R2               PIC S9(9) COMP  VALUE 0.         
          05 CTR-ROWS-R3               PIC S9(9) COMP  VALUE 0.         
          05 CTR-ROWS-R4               PIC S9(9) COMP  VALUE 0.         
                                                                        
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW              PIC X(01)       VALUE 'Y'.       
             88 SEND-DONE-ERROR                        VALUE 'N'.       
             88 SEND-DONE-OK                           VALUE 'Y'.       
          05 ALL-DONE-SW               PIC X(01)       VALUE 'N'.       
             88 NOT-ALL-DONE                           VALUE 'N'.       
             88 ALL-DONE                               VALUE 'Y'.       
                                                                        
       01 GTT-RETURN-FIELDS.                                            
      * CIA result set                                                          
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-R1-RETURN-CODE       PIC S9(9) COMP  VALUE 0.         
             10 S-R1-PPL-NAME          PIC X(03)       VALUE SPACES.    
             10 S-R1-ITEM-ID           PIC S9(9) COMP  VALUE ZEROES.    
             10 S-R1-AMT-UNUSED-CR     PIC S9(9)V99 COMP-3              
                                                       VALUE 0.         
             10 S-R1-AC-LAST-UPD-TS    PIC X(26)       VALUE SPACES.    
             10 S-R1-NSC-NSA-IND       PIC X(01)       VALUE SPACE.     
             10 S-R1-SUMM-UNBILLED     PIC S9(11)V99 COMP-3             
                                                       VALUE 0.         
             10 S-R1-AT-LAST-UPD-TS    PIC X(26)       VALUE SPACES.    
             10 S-R1-RELEASE-DT        PIC X(10)       VALUE SPACES.    
             10 S-R1-RN-TRANS-HIST-SEQ PIC X(26)       VALUE SPACES.    
      * Pre Payment result set                                                  
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-R2-RETURN-CODE       PIC S9(9) COMP  VALUE 0.         
             10 S-R2-DATE-TRANS        PIC X(10)       VALUE SPACES.    
             10 S-R2-CODE-TRAN-TYPE    PIC X(01)       VALUE SPACES.    
             10 S-R2-REFUND-IND        PIC X(01)       VALUE SPACES.    
             10 S-R2-AMT-ORIG-ENTERED  PIC S9(9)V99 COMP-3              
                                                       VALUE 0.         
             10 S-R2-CHECK-AMT         PIC S9(9)V99 COMP-3              
                                                       VALUE ZEROES.    
             10 S-R2-CASH-AMT          PIC S9(9)V99 COMP-3              
                                                       VALUE ZEROES.    
             10 S-R2-OTHER-AMT         PIC S9(9)V99 COMP-3              
                                                       VALUE ZEROES.    
             10 S-R2-FIRST-NAME-PF     PIC X(12)       VALUE SPACES.    
             10 S-R2-MIDDLE-NAME-PF    PIC X(10)       VALUE SPACES.    
             10 S-R2-LAST-NAME-PF      PIC X(15)       VALUE SPACES.    
             10 S-R2-TRANS-SEQ-NO      PIC X(26)       VALUE SPACES.    
             10 S-R2-PYMT-RCPT-PRNTD-CD                                 
                                       PIC X(01)       VALUE SPACES.    
             10 S-R2-RELEASE-DT        PIC X(10)       VALUE SPACES.    
             10 S-R2-AT-LAST-UPD-TS    PIC X(26)       VALUE SPACES.    
      * Credit bal check pay result set                                         
          05 GTT-RETURN-FIELDS-3.                                       
             10 S-R3-RETURN-CODE       PIC S9(9) COMP  VALUE 0.         
             10 S-R3-CHECK-PYMT-FL     PIC X(01)       VALUE SPACES.    
             10 S-R3-REFUND-DEPOSIT-FL PIC X(01)       VALUE SPACES.    
P0087A       10 S-R3-ORDER-TYPE-FL     PIC X(01)       VALUE SPACES.    
      * Refunds Result Set                                                      
          05 GTT-RETURN-FIELDS-4.                                       
             10 S-R4-RETURN-CODE       PIC S9(9) COMP  VALUE 0.         
             10 S-R4-ADDRESS-FORMAT    PIC X(01)       VALUE SPACES.    
             10 S-R4-HOUSE-NO          PIC X(05)       VALUE SPACES.    
             10 S-R4-ADDR-PREFIX-1     PIC X(03)       VALUE SPACES.    
             10 S-R4-ADDR-PREFIX-2     PIC X(02)       VALUE SPACES.    
             10 S-R4-ADDR-SUFFIX       PIC X(02)       VALUE SPACES.    
             10 S-R4-STREET-NAME       PIC X(35)       VALUE SPACES.    
             10 S-R4-STREET-SUFFIX     PIC X(04)       VALUE SPACES.    
             10 S-R4-ADDRESS-OVERFLOW  PIC X(35)       VALUE SPACES.    
             10 S-R4-STREET-LOCATION-1 PIC X(04)       VALUE SPACES.    
             10 S-R4-STREET-LOCATION-2 PIC X(06)       VALUE SPACES.    
             10 S-R4-CITY              PIC X(26)       VALUE SPACES.    
             10 S-R4-STATE             PIC X(02)       VALUE SPACES.    
             10 S-R4-COUNTRY           PIC X(35)       VALUE SPACES.    
             10 S-R4-ZIP-CODE          PIC X(05)       VALUE SPACES.    
             10 S-R4-ZIP-CODE-PLUS-FOUR                                 
                                       PIC X(04)       VALUE SPACES.    
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_ACCOUNT           - AT                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBACCT                                            00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * CSS_AR_CNTL           - AC                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBARCNTL                                          00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * CSS_AR_TYPE           - L5                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBARTYPE                                          00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * CSS_AR_TRANS_HIST     - AR                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBARHIST                                          00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * CSS_AR_TRN_HST_DET    - AU                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBARHDT                                           00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * CSS_ADDR_FORMATTED    - DY                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBADRFMT                                          00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * CSS_ADDR_FREEFORM     - DZ                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBADRFRE                                          00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * CSS_DELINQUENCY       - DQ                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBDELQ                                            00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * CSS_DEP_ON_HAND       - DO                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBDEPHND                                          00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * CSS_GL_ACCT_NO        - GO                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBGLATNO                                          00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * CSS_PREMISE           - PR                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBPREM                                            00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * CSS_REFUND            - RN                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBZIPCD                                           00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * CSS_NSF_HIST          - NH                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBNSFHST                                          00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * CSS_USER_PROFILE      - PF                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBUSRPRF                                          00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * CSS_ZIP_CODE          - A4                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBREFUND                                          00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * CSS_SO_DATA           - VO                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00780200
              INCLUDE TBSODAT                                           00782200
           END-EXEC.                                                    00782300
                                                                        
      ******************************************************************        
      * ERROR HANDLING                                                 *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      * WORKING STORAGE COPYBOOKS FOR CPD00322                         *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE CWS00322                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * DECLARE CURSOR TO GET ALL CREDIT IN ADVANCE DETAILS.           *        
      * PYMT_PRIORITY_LVL : 70 - CREDIT IN ADVANCE                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE CIA_CURSOR CURSOR FOR                             
               SELECT AC.AMT_UNUSED_CR                                  
                     ,AC.ITEM_ID                                        
                     ,AC.PYMT_PRIORITY_LVL                              
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           AC.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                     ,L5.AR_TYPE_SHORT_DESC                             
                 FROM CSS_AR_CNTL AC WITH(READUNCOMMITTED)                      
                     ,CSS_AR_TYPE L5 WITH(READUNCOMMITTED)                      
                WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO             
                  AND AC.PYMT_PRIORITY_LVL = 70                         
                  AND AC.PYMT_PRIORITY_LVL = L5.PYMT_PRIORITY_LVL       
                  AND AC.AMT_UNUSED_CR     < 0                          
                  AND AC.ITEM_ID           IN (1,2)                     
             ORDER BY AC.PYMT_PRIORITY_LVL ASC                          
                     ,AC.ITEM_ID DESC                                   
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CIA_CURSOR CURSOR FOR                                     
MFA-TR*        SELECT AC.AMT_UNUSED_CR                                          
MFA-TR*              ,AC.ITEM_ID                                                
MFA-TR*              ,AC.PYMT_PRIORITY_LVL                                      
MFA-TR*              ,AC.LAST_UPDATE_TS                                         
MFA-TR*              ,L5.AR_TYPE_SHORT_DESC                                     
MFA-TR*          FROM CSS_AR_CNTL AC                                            
MFA-TR*              ,CSS_AR_TYPE L5                                            
MFA-TR*         WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO                     
MFA-TR*           AND AC.PYMT_PRIORITY_LVL = 70                                 
MFA-TR*           AND AC.PYMT_PRIORITY_LVL = L5.PYMT_PRIORITY_LVL               
MFA-TR*           AND AC.AMT_UNUSED_CR     < 0                                  
MFA-TR*           AND AC.ITEM_ID           IN (1,2)                             
MFA-TR*      ORDER BY AC.PYMT_PRIORITY_LVL ASC                                  
MFA-TR*              ,AC.ITEM_ID DESC                                           
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7570                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * DECLARE CURSOR TO GET ALL PREVIOUS PAYMENTS WHICH INCLUDES     *        
      * CREDIT & PAYMENT TRANSACTION TYPE.                             *        
      * CODE-TRAN-TYPE: P - PAYMENT                                    *        
      * CODE-TRAN-TYPE: I - CREDIT                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE PRE_PAYMENT_CUR CURSOR FOR                        
               SELECT CIS.CHAR2$DATE(AR.DATE_TRANS,'USA')                       
                     ,AR.AMT_ORIG_ENTERED                               
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           AR.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO                              
                     ,AR.USER_ID                                        
                     ,AR.PYMT_REFUNDED_IND                              
                     ,AR.CODE_TRAN_TYPE                                 
                     ,AU.CURRENCY_TYPE                                  
                     ,AU.CURRENCY_AMT                                   
                     ,AU.TRAN_APPL_NO                                   
                     ,AR.PYMT_RCPT_PRNTD_CD                             
                 FROM CSS_AR_TRANS_HIST  AR WITH(READUNCOMMITTED)               
                     ,CSS_AR_TRN_HST_DET AU WITH(READUNCOMMITTED)               
                WHERE AR.ACCOUNT_NO        = :AR-ACCOUNT-NO             
                  AND (AR.CODE_TRAN_TYPE   = 'P' OR                     
                      (AR.CODE_TRAN_TYPE   = 'I' AND                    
                      AR.APPL_PROGRAM_ID IN   ('PANEL310A',             
                       'PANEL310B','PANEL310C','PANEL310D',             
                       'PANEL310E','PANEL310F','PANEL310G',             
                       'PANEL310H','PANEL310I','PANEL3101',             
                       'PANEL3102','PANEL3103','PANEL3104',             
                       'PANEL3105','PANEL3106')))                       
                  AND AU.ACCOUNT_NO        = AR.ACCOUNT_NO              
                  AND AU.TRANS_HIST_SEQ_NO = AR.TRANS_HIST_SEQ_NO       
                  AND AR.AMT_ORIG_ENTERED  > 0                          
                  AND AU.CURRENCY_AMT      > 0                          
             ORDER BY TRANS_HIST_SEQ_NO DESC                         
                     ,AU.TRAN_APPL_NO ASC                               
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE PRE_PAYMENT_CUR CURSOR FOR                                
MFA-TR*        SELECT CHAR(AR.DATE_TRANS,USA)                                   
MFA-TR*              ,AR.AMT_ORIG_ENTERED                                       
MFA-TR*              ,AR.TRANS_HIST_SEQ_NO                                      
MFA-TR*              ,AR.USER_ID                                                
MFA-TR*              ,AR.PYMT_REFUNDED_IND                                      
MFA-TR*              ,AR.CODE_TRAN_TYPE                                         
MFA-TR*              ,AU.CURRENCY_TYPE                                          
MFA-TR*              ,AU.CURRENCY_AMT                                           
MFA-TR*              ,AU.TRAN_APPL_NO                                           
MFA-TR*              ,AR.PYMT_RCPT_PRNTD_CD                                     
MFA-TR*          FROM CSS_AR_TRANS_HIST  AR                                     
MFA-TR*              ,CSS_AR_TRN_HST_DET AU                                     
MFA-TR*         WHERE AR.ACCOUNT_NO        = :AR-ACCOUNT-NO                     
MFA-TR*           AND (AR.CODE_TRAN_TYPE   = 'P' OR                             
MFA-TR*               (AR.CODE_TRAN_TYPE   = 'I' AND                            
MFA-TR*               AR.APPL_PROGRAM_ID IN   ('PANEL310A',                     
MFA-TR*                'PANEL310B','PANEL310C','PANEL310D',                     
MFA-TR*                'PANEL310E','PANEL310F','PANEL310G',                     
MFA-TR*                'PANEL310H','PANEL310I','PANEL3101',                     
MFA-TR*                'PANEL3102','PANEL3103','PANEL3104',                     
MFA-TR*                'PANEL3105','PANEL3106')))                               
MFA-TR*           AND AU.ACCOUNT_NO        = AR.ACCOUNT_NO                      
MFA-TR*           AND AU.TRANS_HIST_SEQ_NO = AR.TRANS_HIST_SEQ_NO               
MFA-TR*           AND AR.AMT_ORIG_ENTERED  > 0                                  
MFA-TR*           AND AU.CURRENCY_AMT      > 0                                  
MFA-TR*      ORDER BY AR.TRANS_HIST_SEQ_NO DESC                                 
MFA-TR*              ,AU.TRAN_APPL_NO ASC                                       
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7540                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * PAST CHECK PAYMENT DATAILS                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
             DECLARE C3 CURSOR  FOR                          
              SELECT :S-R3-RETURN-CODE       AS RETURN_CODE             
                    ,:S-R3-CHECK-PYMT-FL     AS CHECK_PYMT_FL           
                    ,:S-R3-REFUND-DEPOSIT-FL AS REFUND_DEPOSIT_FL       
P0087A              ,:S-R3-ORDER-TYPE-FL     AS ORDER_TYPE_FL           
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C3 CURSOR WITH RETURN FOR                                  
MFA-TR*       SELECT :S-R3-RETURN-CODE       AS RETURN_CODE                     
MFA-TR*             ,:S-R3-CHECK-PYMT-FL     AS CHECK_PYMT_FL                   
MFA-TR*             ,:S-R3-REFUND-DEPOSIT-FL AS REFUND_DEPOSIT_FL               
MFA-TR*             ,:S-R3-ORDER-TYPE-FL     AS ORDER_TYPE_FL                   
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * REFUND DETAILS                                                          
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
             DECLARE C4 CURSOR  FOR                          
              SELECT :S-R4-RETURN-CODE        AS RETURN_CODE            
                    ,:S-R4-ADDRESS-FORMAT     AS ADDRESS_FORMAT         
                    ,:S-R4-HOUSE-NO           AS HOUSE_NO               
                    ,:S-R4-ADDR-PREFIX-1      AS ADDR_PREFIX_1          
                    ,:S-R4-ADDR-PREFIX-2      AS ADDR_PREFIX_2          
                    ,:S-R4-ADDR-SUFFIX        AS ADDR_SUFFIX            
                    ,:S-R4-STREET-NAME        AS STREET_NAME            
                    ,:S-R4-STREET-SUFFIX      AS STREET_SUFFIX          
                    ,:S-R4-ADDRESS-OVERFLOW   AS ADDRESS_OVERFLOW       
                    ,:S-R4-STREET-LOCATION-1  AS STREET_LOCATION_1      
                    ,:S-R4-STREET-LOCATION-2  AS STREET_LOCATION_2      
                    ,:S-R4-CITY               AS CITY                   
                    ,:S-R4-STATE              AS STATE                  
                    ,:S-R4-COUNTRY            AS COUNTRY                
                    ,:S-R4-ZIP-CODE           AS ZIP_CODE               
                    ,:S-R4-ZIP-CODE-PLUS-FOUR AS ZIP_CODE_PLUS_FOUR     
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C4 CURSOR WITH RETURN FOR                                  
MFA-TR*       SELECT :S-R4-RETURN-CODE        AS RETURN_CODE                    
MFA-TR*             ,:S-R4-ADDRESS-FORMAT     AS ADDRESS_FORMAT                 
MFA-TR*             ,:S-R4-HOUSE-NO           AS HOUSE_NO                       
MFA-TR*             ,:S-R4-ADDR-PREFIX-1      AS ADDR_PREFIX_1                  
MFA-TR*             ,:S-R4-ADDR-PREFIX-2      AS ADDR_PREFIX_2                  
MFA-TR*             ,:S-R4-ADDR-SUFFIX        AS ADDR_SUFFIX                    
MFA-TR*             ,:S-R4-STREET-NAME        AS STREET_NAME                    
MFA-TR*             ,:S-R4-STREET-SUFFIX      AS STREET_SUFFIX                  
MFA-TR*             ,:S-R4-ADDRESS-OVERFLOW   AS ADDRESS_OVERFLOW               
MFA-TR*             ,:S-R4-STREET-LOCATION-1  AS STREET_LOCATION_1              
MFA-TR*             ,:S-R4-STREET-LOCATION-2  AS STREET_LOCATION_2              
MFA-TR*             ,:S-R4-CITY               AS CITY                           
MFA-TR*             ,:S-R4-STATE              AS STATE                          
MFA-TR*             ,:S-R4-COUNTRY            AS COUNTRY                        
MFA-TR*             ,:S-R4-ZIP-CODE           AS ZIP_CODE                       
MFA-TR*             ,:S-R4-ZIP-CODE-PLUS-FOUR AS ZIP_CODE_PLUS_FOUR             
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
COB305 01 PARM-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.              
       01  PARM-REFUND-TYPE            PIC X(01).                       
                                                                        
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
                               ,PARM-REFUND-TYPE.                       
                                                                        
      ******************************************************************        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE 'N'                          TO WS-ACCT-TBL-FND         
                                                WS-PREM-TBL-FND.        
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           PERFORM 0101-DECLARE-GTT-R1                 THRU 0101-EXIT.  
           PERFORM 0102-DECLARE-GTT-R2                 THRU 0102-EXIT.  
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0101-DECLARE-GTT-R1                                            *        
      ******************************************************************        
                                                                        
       0101-DECLARE-GTT-R1.                                             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04887_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04887_R1
              (                                                          
               RETURN_CODE              INT                         
              ,PPL_NAME CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2               
              ,ITEM_ID                  INT                         
              ,AMT_UNUSED_CR            DECIMAL(11,2)                   
              ,AC_LAST_UPD_TS CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,NSC_NSA_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,SUMM_UNBILLED            DECIMAL(13,2)                   
              ,AT_LAST_UPD_TS CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,RELEASE_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2             
              ,RN_TRANS_HIST_SEQ CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF SQLSTATE = '42710'                                        
              PERFORM 8001A-DEL-GTT-R1      THRU 8001A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL              
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '0101'                TO ACTIVE-PARAGRAPH         
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE 'CSR04887_R1'         TO TABLE-1                  
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT *                                                 
                 FROM #CSR04887_R1                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT *                                                         
MFA-TR*          FROM SESSION.CSR04887_R1                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       0101-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0102-DECLARE-GTT-R2                                            *        
      ******************************************************************        
                                                                        
       0102-DECLARE-GTT-R2.                                             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04887_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04887_R2
              (                                                          
               RETURN_CODE              INT                         
              ,DATE_TRANS CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2             
              ,CODE_TRAN_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,REFUND_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2             
              ,AMT_ORIG_ENTERED         DECIMAL(11,2)                   
              ,CHECK_AMT                DECIMAL(11,2)                   
              ,CASH_AMT                 DECIMAL(11,2)                   
              ,OTHER_AMT                DECIMAL(11,2)                   
              ,FIRST_NAME_PF CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2          
              ,MIDDLE_NAME_PF CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,LAST_NAME_PF CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,TRANS_HIST_SEQ_NO_AR CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,PYMT_RCPT_PRNTD_CD CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,RELEASE_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2             
              ,AT_LAST_UPD_TS CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2         
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF SQLSTATE = '42710'                                        
              PERFORM 8002A-DEL-GTT-R2      THRU 8002A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL              
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '0102'                TO ACTIVE-PARAGRAPH         
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE 'CSR04887_R2'         TO TABLE-1                  
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR  FOR                        
               SELECT *                                                 
                 FROM #CSR04887_R2                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT *                                                         
MFA-TR*          FROM SESSION.CSR04887_R2                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       0102-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO                 TO AT-ACCOUNT-NO        
                                                   AR-ACCOUNT-NO        
                                                   RN-ACCOUNT-NO        
                                                   DO-ACCOUNT-NO        
                                                   AC-ACCOUNT-NO.       
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-SELECT-ACCOUNT                 THRU 7000-EXIT.  
                                                                        
           MOVE 'DAY-REFUND-CHECK-CAL'       TO C8-DELINQ-CD.           
           PERFORM 7020-SELECT-DELINQUENCY             THRU 7020-EXIT.  
           MOVE C8-DELINQ-VALUE              TO WS-DEL-CAL-DAYS.        
                                                                        
           MOVE 'DAY-REFUND-CHECK'           TO C8-DELINQ-CD.           
           PERFORM 7020-SELECT-DELINQUENCY             THRU 7020-EXIT.  
           MOVE C8-DELINQ-VALUE              TO WS-DEL-DAYS.            
           PERFORM 7010-GET-CURRENT-DATE-TS            THRU 7010-EXIT.  
                                                                        
           IF AT-ADDRESS-ID > 0                                         
              MOVE 'Y'                       TO WS-ACCT-TBL-FND         
           END-IF.                                                      
                                                                        
           PERFORM 2400-RQSTD-REFUNDS-PROCESS          THRU 2400-EXIT.  
           PERFORM 2500-CALC-RELEASE-DATE              THRU 2500-EXIT.  
                                                                        
      * C - Credit In Advance                                                   
      * P - Previous Payments(Cash/Check)                                       
           EVALUATE PARM-REFUND-TYPE                                    
            WHEN 'C'                                                    
                 PERFORM 2100-CIA-PROCESS              THRU 2100-EXIT   
                 PERFORM 2200-CHECK-PAYMENT-PROCESS    THRU 2200-EXIT   
            WHEN 'P'                                                    
                 PERFORM 2300-PRE-PAYMENT-PROCESS      THRU 2300-EXIT   
           END-EVALUATE.                                                
                                                                        
A0087A     IF AT-CODE-ACCT-STAT = 'B' OR 'S'                            
P0087A        CONTINUE                                                  
P0087A     ELSE                                                         
P0087A        PERFORM 2210-CHECK-EXISTING-SO THRU 2210-EXIT             
P0087A     END-IF.                                                      
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-CIA-PROCESS                                               *        
      ******************************************************************        
                                                                        
       2100-CIA-PROCESS.                                                
                                                                        
           SET NOT-ALL-DONE                  TO TRUE.                   
           PERFORM 7030-GET-SUMM-UNBILLED              THRU 7030-EXIT.  
           PERFORM 7500-OPEN-CIA-CURSOR                THRU 7500-EXIT.  
           PERFORM 7510-FETCH-CIA-CURSOR               THRU 7510-EXIT.  
                                                                        
           PERFORM UNTIL ALL-DONE                                       
              IF AC-AMT-UNUSED-CR < 0                                   
                 COMPUTE WS-AMT-UNUSED-CR = -1 * AC-AMT-UNUSED-CR       
                 MOVE WS-AMT-UNUSED-CR       TO S-R1-AMT-UNUSED-CR      
              ELSE                                                      
                 MOVE AC-AMT-UNUSED-CR       TO S-R1-AMT-UNUSED-CR      
              END-IF                                                    
              MOVE 'N'                       TO S-R1-NSC-NSA-IND        
              MOVE AC-ITEM-ID                TO S-R1-ITEM-ID            
              MOVE L5-AR-TYPE-SHORT-DESC     TO S-R1-PPL-NAME           
              MOVE AC-LAST-UPDATE-TS         TO S-R1-AC-LAST-UPD-TS     
              MOVE AT-LAST-UPDATE-TS         TO S-R1-AT-LAST-UPD-TS     
              MOVE WS-RELEASE-DATE           TO S-R1-RELEASE-DT         
              PERFORM 8001-INSERT-GTT-R1               THRU 8001-EXIT   
              INITIALIZE GTT-RETURN-FIELDS-1                            
              PERFORM 7510-FETCH-CIA-CURSOR            THRU 7510-EXIT   
           END-PERFORM.                                                 
                                                                        
           PERFORM 7520-CLOSE-CIA-CURSOR               THRU 7520-EXIT.  
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-CHECK-PAYMENT-PROCESS                                     *        
      ******************************************************************        
                                                                        
       2200-CHECK-PAYMENT-PROCESS.                                      
                                                                        
           MOVE SPACES                       TO S-R3-ORDER-TYPE-FL.     
           PERFORM 7060-GET-PAST-CHECK-PYMT-DT         THRU 7060-EXIT.  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 'Y'                       TO S-R3-CHECK-PYMT-FL      
              PERFORM 7070-GET-DEPOSIT-ELIGIBLE-FL      THRU 7070-EXIT  
              MOVE WS-DEPOSIT-ELIGIBLE-FL    TO S-R3-REFUND-DEPOSIT-FL  
              ADD +1                         TO CTR-ROWS-R3             
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
P0087A******************************************************************        
P0087A* 2210-CHECK-EXISTING-SO                                         *        
P0087A******************************************************************        
P0087A                                                                  
P0087A 2210-CHECK-EXISTING-SO.                                          
P0087A                                                                  
P0087A     PERFORM 7075-CHECK-FOR-SERVICE-ORDER        THRU 7075-EXIT.  
P0087A     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P0087A        EVALUATE VO-ORDER-TYPE-CD                                 
P0087A          WHEN 'CC001'                                            
P0087A          WHEN 'CC002'                                            
P0087A          WHEN 'CC003'                                            
P0087A            MOVE 'C'                     TO S-R3-ORDER-TYPE-FL    
P0087A          WHEN 'OFF01'                                            
P0087A          WHEN 'OFF02'                                            
P0087A          WHEN 'OFF03'                                            
P0087A            MOVE 'O'                     TO S-R3-ORDER-TYPE-FL    
P0087A          WHEN OTHER                                              
P0087A            MOVE SPACES                  TO S-R3-ORDER-TYPE-FL    
P0087A        END-EVALUATE                                              
P0087A        ADD +1                           TO CTR-ROWS-R3           
P0087A     END-IF.                                                      
P0087A                                                                  
P0087A 2210-EXIT.                                                       
P0087A     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2300-PRE-PAYMENT-PROCESS                                       *        
      ******************************************************************        
                                                                        
       2300-PRE-PAYMENT-PROCESS.                                        
                                                                        
           MOVE 'Y'                          TO WS-FIRST-TIME-FL.       
           MOVE 'N'                          TO WS-LAST-REC-FL.         
           MOVE 0                            TO WS-DATE-TRANS-NULL      
           SET NOT-ALL-DONE                  TO TRUE.                   
           PERFORM 7530-OPEN-PRE-PAYMENT-CURSOR        THRU 7530-EXIT.  
           PERFORM 7540-FETCH-PRE-PAYMENT-CURSOR       THRU 7540-EXIT.  
                                                                        
           PERFORM UNTIL WS-LAST-REC-FL = 'Y'                           
              IF AR-TRANS-HIST-SEQ-NO NOT = WS-TRANS-HIST-SEQ-NO        
                 MOVE 'N'                    TO WS-NSF-HIST-FL          
                 IF AR-TRANS-HIST-SEQ-NO > 0                            
                    MOVE AR-TRANS-HIST-SEQ-NO  TO NH-TRANS-HIST-SEQ-NO  
                    MOVE AR-DATE-TRANS         TO NH-DATE-TRAN          
                    PERFORM 7040-SELECT-NSF-HIST          THRU 7040-EXIT
                 END-IF                                                 
                                                                        
                 IF WS-NSF-HIST-FL = 'N' AND WS-FIRST-TIME-FL = 'N'     
                    PERFORM 2310-MOVE-AMOUNT           THRU 2310-EXIT   
                    PERFORM 8002-INSERT-GTT-R2         THRU 8002-EXIT   
                    MOVE 0                   TO WS-CHECK-AMT            
                                                WS-CASH-AMT             
                                                WS-OTHER-AMT            
                    MOVE SPACES              TO S-R2-PYMT-RCPT-PRNTD-CD 
                    INITIALIZE GTT-RETURN-FIELDS-2                      
                 END-IF                                                 
                 MOVE 'N'                    TO WS-FIRST-TIME-FL        
                                                                        
                 IF ALL-DONE                                            
                    MOVE 'Y'                 TO WS-LAST-REC-FL          
                 ELSE                                                   
                    MOVE AR-TRANS-HIST-SEQ-NO   TO WS-TRANS-HIST-SEQ-NO 
                    PERFORM 2320-BUILD-PRE-PYMT-RSLT   THRU 2320-EXIT   
                    PERFORM 2330-COMPUTE-AMOUNTS       THRU 2330-EXIT   
                 END-IF                                                 
              ELSE                                                      
                 IF ALL-DONE                                            
                    MOVE 'Y'                 TO WS-LAST-REC-FL          
                 ELSE                                                   
                    IF AR-TRANS-HIST-SEQ-NO = WS-TRANS-HIST-SEQ-NO      
                       PERFORM 2330-COMPUTE-AMOUNTS    THRU 2330-EXIT   
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
              PERFORM 7540-FETCH-PRE-PAYMENT-CURSOR    THRU 7540-EXIT   
           END-PERFORM.                                                 
                                                                        
           PERFORM 7550-CLOSE-PRE-PAYMENT-CURSOR       THRU 7550-EXIT.  
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  2310-MOVE-AMOUNT                                              *        
      ******************************************************************        
                                                                        
       2310-MOVE-AMOUNT.                                                
                                                                        
           MOVE WS-RELEASE-DATE              TO S-R2-RELEASE-DT         
           IF WS-CHECK-AMT > ZEROES                                     
              MOVE WS-CHECK-AMT              TO S-R2-CHECK-AMT          
           END-IF.                                                      
           IF WS-CASH-AMT  > ZEROES                                     
              MOVE WS-CASH-AMT               TO S-R2-CASH-AMT           
           END-IF.                                                      
           IF WS-OTHER-AMT > ZEROES                                     
              MOVE WS-OTHER-AMT              TO S-R2-OTHER-AMT          
           END-IF.                                                      
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2320-BUILD-PRE-PYMT-RSLT                                       *        
      ******************************************************************        
                                                                        
       2320-BUILD-PRE-PYMT-RSLT.                                        
                                                                        
           MOVE AR-CODE-TRAN-TYPE            TO S-R2-CODE-TRAN-TYPE.    
           MOVE AR-PYMT-REFUNDED-IND         TO S-R2-REFUND-IND.        
           MOVE AR-AMT-ORIG-ENTERED          TO S-R2-AMT-ORIG-ENTERED.  
           MOVE AR-TRANS-HIST-SEQ-NO         TO S-R2-TRANS-SEQ-NO.      
           MOVE AR-PYMT-RCPT-PRNTD-CD        TO S-R2-PYMT-RCPT-PRNTD-CD.
           MOVE AR-USER-ID                   TO PF-USER-ID.             
           MOVE AT-LAST-UPDATE-TS            TO S-R2-AT-LAST-UPD-TS.    
                                                                        
           PERFORM  7050-GET-EMPLOYEE-NAME             THRU 7050-EXIT.  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE PF-FIRST-NAME             TO S-R2-FIRST-NAME-PF      
              MOVE PF-MIDDLE-NAME            TO S-R2-MIDDLE-NAME-PF     
              MOVE PF-LAST-NAME              TO S-R2-LAST-NAME-PF       
           END-IF.                                                      
                                                                        
           MOVE AR-DATE-TRANS                TO WS-NEW-BUSINESS-DAY     
                                                S-R2-DATE-TRANS.        
                                                                        
       2320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 2330-COMPUTE-AMOUNTS                                                    
      ****************************************************************          
                                                                        
       2330-COMPUTE-AMOUNTS.                                            
                                                                        
           IF AU-CURRENCY-AMT > 0                                       
              EVALUATE AU-CURRENCY-TYPE                                 
               WHEN 'C'                                                 
               WHEN 'D'                                                 
                    ADD AU-CURRENCY-AMT      TO WS-CHECK-AMT            
               WHEN 'A'                                                 
                    ADD AU-CURRENCY-AMT      TO WS-CASH-AMT             
               WHEN OTHER                                               
                    ADD AU-CURRENCY-AMT      TO WS-OTHER-AMT            
              END-EVALUATE                                              
           END-IF.                                                      
                                                                        
       2330-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2400-RQSTD-REFUNDS-PROCESS                                     *        
      ******************************************************************        
                                                                        
       2400-RQSTD-REFUNDS-PROCESS.                                      
                                                                        
           PERFORM 7120-SELECT-PENDING-REFUNDS      THRU 7120-EXIT.     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE RN-TRANS-HIST-SEQ-NO   TO S-R1-RN-TRANS-HIST-SEQ     
              IF RN-ADDRESS-ID > 0                                      
                 MOVE RN-ADDRESS-ID       TO DY-ADDRESS-ID              
                                             DZ-ADDRESS-ID              
                 PERFORM 7090-FREEFORM-ADDRESS      THRU 7090-EXIT      
                 IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                    PERFORM 7080-FORMATTED-ADDRESS  THRU 7080-EXIT      
                    MOVE 'A'              TO S-R4-ADDRESS-FORMAT        
                    PERFORM 2410-MOVE-FORMATTED-VAR THRU 2410-EXIT      
                 ELSE                                                   
                    MOVE 'B'              TO S-R4-ADDRESS-FORMAT        
                    PERFORM 2420-MOVE-FREEFORM-VAR  THRU 2420-EXIT      
                 END-IF                                                 
              ELSE                                                      
                 PERFORM 5000-FIND-ADDRESS          THRU 5000-EXIT      
              END-IF                                                    
           ELSE                                                         
              PERFORM 5000-FIND-ADDRESS             THRU 5000-EXIT      
           END-IF.                                                      
                                                                        
           ADD +1                            TO  CTR-ROWS-R4.           
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2410-MOVE-FORMATTED-VAR                                        *        
      ******************************************************************        
                                                                        
       2410-MOVE-FORMATTED-VAR.                                         
                                                                        
           MOVE DY-ADDR-PREFIX-1             TO S-R4-ADDR-PREFIX-1.     
           MOVE DY-ADDR-PREFIX-2             TO S-R4-ADDR-PREFIX-2.     
           MOVE DY-ADDR-SUFFIX               TO S-R4-ADDR-SUFFIX.       
           MOVE DY-ADDRESS-OVERFLOW          TO S-R4-ADDRESS-OVERFLOW.  
           MOVE DY-STREET-LOCATION-1         TO S-R4-STREET-LOCATION-1. 
           MOVE DY-STREET-LOCATION-2         TO S-R4-STREET-LOCATION-2. 
           MOVE DY-HOUSE-NO                  TO S-R4-HOUSE-NO.          
           MOVE DY-STREET-NAME               TO S-R4-STREET-NAME.       
           MOVE DY-STREET-SUFFIX             TO S-R4-STREET-SUFFIX.     
           MOVE DY-ZIP-CODE                  TO S-R4-ZIP-CODE.          
           MOVE DY-ZIP-CODE-PLUS-FOUR        TO S-R4-ZIP-CODE-PLUS-FOUR.
           MOVE A4-TOWN                      TO S-R4-CITY.              
           MOVE A4-STATE                     TO S-R4-STATE.             
                                                                        
       2410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2420-MOVE-FREEFORM-VAR                                         *        
      ******************************************************************        
                                                                        
       2420-MOVE-FREEFORM-VAR.                                          
                                                                        
           MOVE 'B'                          TO S-R4-ADDRESS-FORMAT.    
           MOVE DZ-ADDRESS-OVERFLOW          TO S-R4-ADDRESS-OVERFLOW.  
           MOVE DZ-ADDR-STREET               TO S-R4-STREET-NAME.       
           MOVE DZ-ADDR-COUNTRY              TO S-R4-COUNTRY.           
           MOVE DZ-ADDR-ZIP-CODE(1:5)        TO S-R4-ZIP-CODE.          
           MOVE DZ-ADDR-ZIP-CODE(5:4)        TO S-R4-ZIP-CODE-PLUS-FOUR.
                                                                        
      * Extract City & State                                                    
           MOVE +30 TO WS-SUB1.                                         
           MOVE 0 TO WS-SUB2.                                           
           PERFORM UNTIL DZ-ADDR-CITY-STATE(WS-SUB1:1) > ' '            
               SUBTRACT +1 FROM WS-SUB1                                 
           END-PERFORM.                                                 
           IF DZ-ADDR-CITY-STATE(WS-SUB1 - 2:1) = ' '                   
               MOVE DZ-ADDR-CITY-STATE(WS-SUB1 - 1:2) TO S-R4-STATE     
               MOVE DZ-ADDR-CITY-STATE(1:WS-SUB1 - 3) TO S-R4-CITY      
           END-IF.                                                      
                                                                        
       2420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2500-CALC-RELEASE-DATE                                         *        
      ******************************************************************        
                                                                        
       2500-CALC-RELEASE-DATE.                                          
                                                                        
           MOVE 0                         TO WS-DATE-TRANS-NULL         
           PERFORM 7110-SEL-AR-PYMT-DT-TYPE        THRU 7110-EXIT.      
                                                                        
           IF AU-CURRENCY-TYPE = 'H'                                    
              MOVE 'DAY-REFUND-CARD'      TO C8-DELINQ-CD               
           ELSE                                                         
              MOVE 'DAY-REFUND-CHECK'     TO C8-DELINQ-CD               
           END-IF.                                                      
           PERFORM 7020-SELECT-DELINQUENCY         THRU 7020-EXIT.      
           MOVE C8-DELINQ-VALUE           TO WS-DEL-DAYS.               
                                                                        
      *    CURRENT DATE - DELINQUENCY DAYS = WS-DEL-WORK-DATE                   
           MOVE WS-DEL-DAYS               TO WS-NO-OF-DAY.              
           MOVE WS-CURRENT-DATE           TO WS-NEW-BUSINESS-DAY.       
           PERFORM 6525-PREV-BUSINESS-DAY                               
                                     THRU 6525-PREV-BUSINESS-DAY-EXIT.  
           MOVE WS-NEW-BUSINESS-DAY       TO WS-DEL-WORK-DATE.          
                                                                        
           IF AR-DATE-CASH-REPORT > SPACES AND                          
              AR-DATE-CASH-REPORT > WS-DEL-WORK-DATE                    
              MOVE WS-DEL-DAYS            TO WS-NO-OF-DAY               
              MOVE AR-DATE-CASH-REPORT    TO WS-NEW-BUSINESS-DAY        
              PERFORM 6500-GET-NEXT-BUSINESS-DAY                        
                                     THRU 6500-NEXT-BUSINESS-DAY-EXIT   
              MOVE WS-NEW-BUSINESS-DAY    TO WS-RELEASE-DATE            
           ELSE                                                         
              MOVE WS-CURRENT-DATE        TO WS-NEW-BUSINESS-DAY        
              PERFORM 6530-CURRENT-BUSINESS-DAY                         
                                     THRU 6530-CURRENT-BUSINESS-DAY-EXIT
              MOVE WS-NEW-BUSINESS-DAY    TO WS-RELEASE-DATE            
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5000-FIND-ADDRESS                                              *        
      ******************************************************************        
                                                                        
       5000-FIND-ADDRESS.                                               
                                                                        
           IF WS-ACCT-TBL-FND = 'Y'                                     
              MOVE AT-ADDRESS-ID             TO WS-ADDRESS-ID           
              MOVE AT-ADDRESS-FORMAT         TO WS-ADDRESS-FORMAT       
           ELSE                                                         
              PERFORM 7100-SELECT-PREMISE              THRU 7100-EXIT   
              IF PR-ADDRESS-ID > 0                                      
                  MOVE 'Y'                   TO WS-PREM-TBL-FND         
              END-IF                                                    
              IF WS-PREM-TBL-FND = 'Y'                                  
                 MOVE PR-ADDRESS-ID          TO WS-ADDRESS-ID           
                 MOVE PR-ADDRESS-FORMAT      TO WS-ADDRESS-FORMAT       
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE WS-ADDRESS-ID                TO DY-ADDRESS-ID           
                                                DZ-ADDRESS-ID.          
           MOVE WS-ADDRESS-FORMAT            TO S-R4-ADDRESS-FORMAT.    
                                                                        
           IF WS-ADDRESS-FORMAT = 'A'                                   
              PERFORM 7080-FORMATTED-ADDRESS           THRU 7080-EXIT   
              PERFORM 2410-MOVE-FORMATTED-VAR          THRU 2410-EXIT   
           ELSE                                                         
              PERFORM 7090-FREEFORM-ADDRESS            THRU 7090-EXIT   
              PERFORM 2420-MOVE-FREEFORM-VAR           THRU 2420-EXIT   
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      ******************************************************************        
      * 6500-GET-NEXT-BUSINESS-DAY                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00322                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 7000-SELECT-ACCOUNT                                            *        
      ******************************************************************        
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT AT.COMPANY_NO                                      
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), AT.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                    ,AT.ADDRESS_ID                                      
                    ,AT.ADDRESS_FORMAT                                  
                    ,AT.PREMISE_NO                                      
P0087A              ,AT.CODE_ACCT_STAT                                  
                INTO :AT-COMPANY-NO                                     
                    ,:AT-LAST-UPDATE-TS                                 
                    ,:AT-ADDRESS-ID                                     
                    ,:AT-ADDRESS-FORMAT                                 
                    ,:AT-PREMISE-NO                                     
P0087A              ,:AT-CODE-ACCT-STAT                                 
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.ACCOUNT_NO   = :AT-ACCOUNT-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     10130000
MFA-TR*       SELECT AT.COMPANY_NO                                              
MFA-TR*             ,AT.LAST_UPDATE_TS                                          
MFA-TR*             ,AT.ADDRESS_ID                                              
MFA-TR*             ,AT.ADDRESS_FORMAT                                          
MFA-TR*             ,AT.PREMISE_NO                                              
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*         INTO :AT-COMPANY-NO                                             
MFA-TR*             ,:AT-LAST-UPDATE-TS                                         
MFA-TR*             ,:AT-ADDRESS-ID                                             
MFA-TR*             ,:AT-ADDRESS-FORMAT                                         
MFA-TR*             ,:AT-PREMISE-NO                                             
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*         FROM CSS_ACCOUNT AT                                     10180000
MFA-TR*        WHERE AT.ACCOUNT_NO   = :AT-ACCOUNT-NO                   10190000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                    10200000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND               THRU 9700-EXIT   
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7010-GET-CURRENT-DATE-TS                                                
      ******************************************************************        
                                                                        
       7010-GET-CURRENT-DATE-TS.                                        
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              DATEADD( DAY, -:WS-DEL-CAL-DAYS, CAST(SYSDATETIMEOFFSET() 
           AS DATE) )
            INTO
              :WS-CURRENT-DATE,
              :WS-CURRENT-TIMESTMP,
              :WS-PAST-15-DATE          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE     = CURRENT DATE                           
MFA-TR*          ,:WS-CURRENT-TIMESTMP = CURRENT TIMESTAMP                      
MFA-TR*          ,:WS-PAST-15-DATE     = CURRENT DATE -                         
MFA-TR*                                  :WS-DEL-CAL-DAYS DAYS                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7010'                    TO ACTIVE-PARAGRAPH        
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'SET'                     TO ABEND-FUNCTION          
              PERFORM 9700-PROCESS-ABEND               THRU 9700-EXIT   
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7020-SELECT-DELINQUENCY                                        *        
      ******************************************************************        
                                                                        
       7020-SELECT-DELINQUENCY.                                         
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = :C8-DELINQ-CD                          
                 AND COMPANY_NO = :AT-COMPANY-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*          AND COMPANY_NO = :AT-COMPANY-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7020                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7020'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_DELINQUENCY'         TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'DELINQ_CD'               TO TABLE-ELEMENT-2         
              MOVE AT-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE C8-DELINQ-CD              TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND               THRU 9700-EXIT   
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7030-GET-SUMM-UNBILLED                                         *        
      ******************************************************************        
                                                                        
       7030-GET-SUMM-UNBILLED.                                          
                                                                        
           EXEC SQL                                                     
              SELECT SUM (TOT_SUMM_UNBILLED)                            
                INTO :AC-TOT-SUMM-UNBILLED :WS-SUMM-UNBILLED-NULL       
                FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO   = :AC-ACCOUNT-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM (TOT_SUMM_UNBILLED)                                    
MFA-TR*         INTO :AC-TOT-SUMM-UNBILLED :WS-SUMM-UNBILLED-NULL               
MFA-TR*         FROM CSS_AR_CNTL                                                
MFA-TR*        WHERE ACCOUNT_NO   = :AC-ACCOUNT-NO                              
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7030                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
            WHEN SUCCESSFUL-CALL                                        
                 IF WS-SUMM-UNBILLED-NULL < 0                           
                    MOVE 0                   TO AC-TOT-SUMM-UNBILLED    
                    MOVE ZEROES              TO WS-SUMM-UNBILLED-NULL   
                 END-IF                                                 
            WHEN NOT-FOUND                                              
                 CONTINUE                                               
            WHEN OTHER                                                  
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE 'FETCH'                TO ABEND-FUNCTION          
                 MOVE '7030'                 TO ACTIVE-PARAGRAPH        
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSS_AR_CNTL'          TO TABLE-1                 
                 MOVE 'ACCOUNT_NO    '       TO TABLE-ELEMENT-1         
                 MOVE AC-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND            THRU 9700-EXIT   
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7040-SELECT-NSF-HIST.                                                   
      ******************************************************************        
                                                                        
       7040-SELECT-NSF-HIST.                                            
                                                                        
           EXEC SQL                                                     
             SELECT 'Y'                                                 
               INTO :WS-NSF-HIST-FL                                     
               FROM CSS_NSF_HIST WITH(READUNCOMMITTED)                          
              WHERE ACCOUNT_NO = :AR-ACCOUNT-NO                         
                AND TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :NH-TRANS-HIST-SEQ-NO
              )           
                AND DATE_TRAN         = IIF(TRY_CONVERT(DATE, 
                                                          :NH-DATE-TRAN
              ) IS NULL OR (PATINDEX('%.%', :NH-DATE-TRAN
              ) <> 0) OR (LEN(:NH-DATE-TRAN) <> 10), CIS.CHAR2DATE(
                                                          :NH-DATE-TRAN
              ), CONVERT(DATE, :NH-DATE-TRAN) )                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 'Y'                                                         
MFA-TR*        INTO :WS-NSF-HIST-FL                                             
MFA-TR*        FROM CSS_NSF_HIST                                                
MFA-TR*       WHERE ACCOUNT_NO = :AR-ACCOUNT-NO                                 
MFA-TR*         AND TRANS_HIST_SEQ_NO = :NH-TRANS-HIST-SEQ-NO                   
MFA-TR*         AND DATE_TRAN         = :NH-DATE-TRAN                           
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7040                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7090'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_NSF_HIST'            TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'TRANS_HIST_SEQ_NO'       TO TABLE-ELEMENT-2         
              MOVE 'DATE_TRAN'               TO TABLE-ELEMENT-3         
              MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE NH-TRANS-HIST-SEQ-NO      TO HOSTVAR-ELEMENT-2       
              MOVE NH-DATE-TRAN              TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND               THRU 9700-EXIT   
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7050-GET-EMPLOYEE-NAME                                         *        
      ******************************************************************        
                                                                        
       7050-GET-EMPLOYEE-NAME.                                          
                                                                        
           EXEC SQL                                                     
              SELECT PF.FIRST_NAME                                      
                    ,PF.MIDDLE_NAME                                     
                    ,PF.LAST_NAME                                       
                INTO :PF-FIRST-NAME                                     
                    ,:PF-MIDDLE-NAME                                    
                    ,:PF-LAST-NAME                                      
                FROM CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                  
               WHERE PF.USER_ID  = :PF-USER-ID                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PF.FIRST_NAME                                              
MFA-TR*             ,PF.MIDDLE_NAME                                             
MFA-TR*             ,PF.LAST_NAME                                               
MFA-TR*         INTO :PF-FIRST-NAME                                             
MFA-TR*             ,:PF-MIDDLE-NAME                                            
MFA-TR*             ,:PF-LAST-NAME                                              
MFA-TR*         FROM CSS_USER_PROFILE PF                                        
MFA-TR*        WHERE PF.USER_ID  = :PF-USER-ID                                  
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7050                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7050'                    TO ACTIVE-PARAGRAPH        
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_USER_PROFILE '       TO TABLE-1                 
              MOVE 'USER_ID     '            TO TABLE-ELEMENT-1         
              MOVE PF-USER-ID                TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND               THRU 9700-EXIT   
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7060-GET-PAST-CHECK-PYMT-DT                                    *        
      ******************************************************************        
                                                                        
       7060-GET-PAST-CHECK-PYMT-DT.                                     
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) AR.DATE_TRANS                                      
                INTO :AR-DATE-TRANS                                     
                FROM CSS_AR_TRANS_HIST  AR WITH(READUNCOMMITTED)                
                    ,CSS_AR_TRN_HST_DET AU WITH(READUNCOMMITTED)                
               WHERE AR.ACCOUNT_NO        = :AR-ACCOUNT-NO              
                 AND AR.CODE_TRAN_TYPE    = 'P'                         
                 AND AU.CURRENCY_TYPE     = 'C'                         
                 AND AR.DATE_TRANS       <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )            
                 AND AR.DATE_TRANS        > IIF(TRY_CONVERT(DATE, 
                                                       :WS-PAST-15-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PAST-15-DATE
              ) <> 0) OR (LEN(:WS-PAST-15-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-PAST-15-DATE
              ), CONVERT(DATE, :WS-PAST-15-DATE) )            
                 AND AR.PYMT_REFUNDED_IND <> 'Y'                        
                 AND AU.ACCOUNT_NO        = AR.ACCOUNT_NO               
                 AND AU.TRANS_HIST_SEQ_NO = AR.TRANS_HIST_SEQ_NO        
               ORDER BY AU.TRANS_HIST_SEQ_NO DESC                       
                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AR.DATE_TRANS                                              
MFA-TR*         INTO :AR-DATE-TRANS                                             
MFA-TR*         FROM CSS_AR_TRANS_HIST  AR                                      
MFA-TR*             ,CSS_AR_TRN_HST_DET AU                                      
MFA-TR*        WHERE AR.ACCOUNT_NO        = :AR-ACCOUNT-NO                      
MFA-TR*          AND AR.CODE_TRAN_TYPE    = 'P'                                 
MFA-TR*          AND AU.CURRENCY_TYPE     = 'C'                                 
MFA-TR*          AND AR.DATE_TRANS       <= :WS-CURRENT-DATE                    
MFA-TR*          AND AR.DATE_TRANS        > :WS-PAST-15-DATE                    
MFA-TR*          AND AR.PYMT_REFUNDED_IND <> 'Y'                                
MFA-TR*          AND AU.ACCOUNT_NO        = AR.ACCOUNT_NO                       
MFA-TR*          AND AU.TRANS_HIST_SEQ_NO = AR.TRANS_HIST_SEQ_NO                
MFA-TR*        ORDER BY AU.TRANS_HIST_SEQ_NO DESC                               
MFA-TR*        FETCH FIRST 1 ROW ONLY WITH UR                                   
MFA-TR*      QUERYNO 7060                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE '7060'                    TO ACTIVE-PARAGRAPH        
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
              MOVE 'CSS_AR_TRN_HST_DET'      TO TABLE-2                 
              MOVE 'ACCOUNT_NO    '          TO TABLE-ELEMENT-1         
              MOVE 'DATE_TRANS'              TO TABLE-ELEMENT-2         
              MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE WS-CURRENT-DATE           TO HOSTVAR-ELEMENT-2       
              MOVE WS-PAST-15-DATE           TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND               THRU 9700-EXIT   
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7070-GET-DEPOSIT-ELIGIBLE-FL                                   *        
      ******************************************************************        
                                                                        
       7070-GET-DEPOSIT-ELIGIBLE-FL.                                    
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-DEPOSIT-ELIGIBLE-FL                            
                FROM CSS_DEP_ON_HAND DO WITH(READUNCOMMITTED)                   
               WHERE DO.ACCOUNT_NO        = :DO-ACCOUNT-NO              
                 AND DO.CODE_REFUND_ELIG  <> 'A'                        
                 AND DO.DEPOSIT_STATUS_CD IN ('A','P')                  
                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-DEPOSIT-ELIGIBLE-FL                                    
MFA-TR*         FROM CSS_DEP_ON_HAND DO                                         
MFA-TR*        WHERE DO.ACCOUNT_NO        = :DO-ACCOUNT-NO                      
MFA-TR*          AND DO.CODE_REFUND_ELIG  <> 'A'                                
MFA-TR*          AND DO.DEPOSIT_STATUS_CD IN ('A','P')                          
MFA-TR*        FETCH FIRST 1 ROW ONLY WITH UR                                   
MFA-TR*      QUERYNO 7070                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
            WHEN SUCCESSFUL-CALL                                        
                 CONTINUE                                               
            WHEN NOT-FOUND                                              
                 MOVE 'N'                    TO WS-DEPOSIT-ELIGIBLE-FL  
            WHEN OTHER                                                  
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE 'SELECT'               TO ABEND-FUNCTION          
                 MOVE '7070'                 TO ACTIVE-PARAGRAPH        
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSS_DEP_ON_HAND'      TO TABLE-1                 
                 MOVE 'ACCOUNT_NO    '       TO TABLE-ELEMENT-1         
                 MOVE DO-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT    
           END-EVALUATE.                                                
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
P0087A******************************************************************        
P0087A* 7075-CHECK-FOR-SERVICE-ORDER                                   *        
P0087A******************************************************************        
P0087A                                                                  
P0087A 7075-CHECK-FOR-SERVICE-ORDER.                                    
P0087A                                                                  
P0087A     EXEC SQL                                                     
P0087A        SELECT TOP(1) VO.ORDER_TYPE_CD                                   
P0087A          INTO :VO-ORDER-TYPE-CD                                  
P0087A          FROM CSS_SO_DATA VO WITH(READUNCOMMITTED)                       
P0087A         WHERE VO.ACCOUNT_NO        = :AT-ACCOUNT-NO              
P0087A           AND VO.ORDER_TYPE_CD IN ('CC001','CC002','CC003',      
P0087A                                    'OFF01','0FF03','0FF03')      
P0087A           AND VO.ORDER_STATE_CD NOT IN ('C','Z')                 
P0087A                                     
P0087A                                                      
P0087A     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT VO.ORDER_TYPE_CD                                           
MFA-TR*         INTO :VO-ORDER-TYPE-CD                                          
MFA-TR*         FROM CSS_SO_DATA VO                                             
MFA-TR*        WHERE VO.ACCOUNT_NO        = :AT-ACCOUNT-NO                      
MFA-TR*          AND VO.ORDER_TYPE_CD IN ('CC001','CC002','CC003',              
MFA-TR*                                   'OFF01','0FF03','0FF03')              
MFA-TR*          AND VO.ORDER_STATE_CD NOT IN ('C','Z')                         
MFA-TR*        FETCH FIRST 1 ROW ONLY WITH UR                                   
MFA-TR*      QUERYNO 7075                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0087A                                                                  
P0087A     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P0087A                                                                  
P0087A     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P0087A        CONTINUE                                                  
P0087A     ELSE                                                         
P0087A        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P0087A        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P0087A        MOVE '7075'                    TO ACTIVE-PARAGRAPH        
P0087A        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
P0087A                                          ABEND-TABLES            
P0087A        MOVE 'CSS_SO_DATA'             TO TABLE-1                 
P0087A        MOVE 'ACCOUNT_NO    '          TO TABLE-ELEMENT-1         
P0087A        MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
P0087A        PERFORM 9700-PROCESS-ABEND               THRU 9700-EXIT   
P0087A     END-IF.                                                      
P0087A                                                                  
P0087A 7075-EXIT.                                                       
P0087A     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7080 FORMATTED-ADDRESS                                         *        
      ******************************************************************        
                                                                        
       7080-FORMATTED-ADDRESS.                                          
                                                                        
           EXEC SQL                                                     
              SELECT DY.ADDR_PREFIX_1                                   
                    ,DY.STREET_SUFFIX                                   
                    ,DY.ADDR_PREFIX_2                                   
                    ,DY.HOUSE_NO                                        
                    ,DY.STREET_NAME                                     
                    ,DY.ADDR_SUFFIX                                     
                    ,DY.ADDRESS_OVERFLOW                                
                    ,DY.STREET_LOCATION_1                               
                    ,DY.STREET_LOCATION_2                               
                    ,DY.ZIP_CODE                                        
                    ,DY.ZIP_CODE_PLUS_FOUR                              
                    ,A4.TOWN                                            
                    ,A4.STATE                                           
                INTO :DY-ADDR-PREFIX-1                                  
                    ,:DY-STREET-SUFFIX                                  
                    ,:DY-ADDR-PREFIX-2                                  
                    ,:DY-HOUSE-NO                                       
                    ,:DY-STREET-NAME                                    
                    ,:DY-ADDR-SUFFIX                                    
                    ,:DY-ADDRESS-OVERFLOW                               
                    ,:DY-STREET-LOCATION-1                              
                    ,:DY-STREET-LOCATION-2                              
                    ,:DY-ZIP-CODE                                       
                    ,:DY-ZIP-CODE-PLUS-FOUR                             
                    ,:A4-TOWN                                           
                    ,:A4-STATE                                          
                FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),               
                     CSS_ZIP_CODE       A4 WITH(READUNCOMMITTED)                
               WHERE DY.ADDRESS_ID     = :DY-ADDRESS-ID                 
                 AND A4.ZIP_CODE       = DY.ZIP_CODE                    
                 AND A4.ZIP_CODE_TOKEN = DY.ZIP_CODE_TOKEN              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DY.ADDR_PREFIX_1                                           
MFA-TR*             ,DY.STREET_SUFFIX                                           
MFA-TR*             ,DY.ADDR_PREFIX_2                                           
MFA-TR*             ,DY.HOUSE_NO                                                
MFA-TR*             ,DY.STREET_NAME                                             
MFA-TR*             ,DY.ADDR_SUFFIX                                             
MFA-TR*             ,DY.ADDRESS_OVERFLOW                                        
MFA-TR*             ,DY.STREET_LOCATION_1                                       
MFA-TR*             ,DY.STREET_LOCATION_2                                       
MFA-TR*             ,DY.ZIP_CODE                                                
MFA-TR*             ,DY.ZIP_CODE_PLUS_FOUR                                      
MFA-TR*             ,A4.TOWN                                                    
MFA-TR*             ,A4.STATE                                                   
MFA-TR*         INTO :DY-ADDR-PREFIX-1                                          
MFA-TR*             ,:DY-STREET-SUFFIX                                          
MFA-TR*             ,:DY-ADDR-PREFIX-2                                          
MFA-TR*             ,:DY-HOUSE-NO                                               
MFA-TR*             ,:DY-STREET-NAME                                            
MFA-TR*             ,:DY-ADDR-SUFFIX                                            
MFA-TR*             ,:DY-ADDRESS-OVERFLOW                                       
MFA-TR*             ,:DY-STREET-LOCATION-1                                      
MFA-TR*             ,:DY-STREET-LOCATION-2                                      
MFA-TR*             ,:DY-ZIP-CODE                                               
MFA-TR*             ,:DY-ZIP-CODE-PLUS-FOUR                                     
MFA-TR*             ,:A4-TOWN                                                   
MFA-TR*             ,:A4-STATE                                                  
MFA-TR*         FROM CSS_ADDR_FORMATTED DY,                                     
MFA-TR*              CSS_ZIP_CODE       A4                                      
MFA-TR*        WHERE DY.ADDRESS_ID     = :DY-ADDRESS-ID                         
MFA-TR*          AND A4.ZIP_CODE       = DY.ZIP_CODE                            
MFA-TR*          AND A4.ZIP_CODE_TOKEN = DY.ZIP_CODE_TOKEN                      
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7080                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7080'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT            '      TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ADDR_FORMATTED'      TO TABLE-1                 
              MOVE 'CSS_ZIP_CODE'            TO TABLE-2                 
              MOVE 'ADDRESS-ID'              TO TABLE-ELEMENT-1         
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2         
              MOVE WS-ADDRESS-ID             TO HOSTVAR-ELEMENT-1       
              MOVE PARM-ACCOUNT-NO           TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND               THRU 9700-EXIT   
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7090-FREEFORM-ADDRESS                                          *        
      ******************************************************************        
                                                                        
       7090-FREEFORM-ADDRESS.                                           
                                                                        
           EXEC SQL                                                     
              SELECT ADDR_CITY_STATE                                    
                    ,ADDR_STREET                                        
                    ,ADDRESS_OVERFLOW                                   
                    ,ADDR_COUNTRY                                       
                    ,ADDR_ZIP_CODE                                      
                INTO :DZ-ADDR-CITY-STATE                                
                    ,:DZ-ADDR-STREET                                    
                    ,:DZ-ADDRESS-OVERFLOW                               
                    ,:DZ-ADDR-COUNTRY                                   
                    ,:DZ-ADDR-ZIP-CODE                                  
                FROM CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)                    
               WHERE ADDRESS_ID = :DZ-ADDRESS-ID                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ADDR_CITY_STATE                                            
MFA-TR*             ,ADDR_STREET                                                
MFA-TR*             ,ADDRESS_OVERFLOW                                           
MFA-TR*             ,ADDR_COUNTRY                                               
MFA-TR*             ,ADDR_ZIP_CODE                                              
MFA-TR*         INTO :DZ-ADDR-CITY-STATE                                        
MFA-TR*             ,:DZ-ADDR-STREET                                            
MFA-TR*             ,:DZ-ADDRESS-OVERFLOW                                       
MFA-TR*             ,:DZ-ADDR-COUNTRY                                           
MFA-TR*             ,:DZ-ADDR-ZIP-CODE                                          
MFA-TR*         FROM CSS_ADDR_FREEFORM                                          
MFA-TR*        WHERE ADDRESS_ID = :DZ-ADDRESS-ID                                
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7090                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7090'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT            '      TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ADDR_FREEFORM'       TO TABLE-1                 
              MOVE 'ADDRESS_ID'              TO TABLE-ELEMENT-1         
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2         
              MOVE WS-ADDRESS-ID             TO HOSTVAR-ELEMENT-1       
              MOVE PARM-ACCOUNT-NO           TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND               THRU 9700-EXIT   
           END-IF.                                                      
                                                                        
       7090-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-SELECT-PREMISE                                            *        
      ******************************************************************        
                                                                        
       7100-SELECT-PREMISE.                                             
                                                                        
           EXEC SQL                                                     
              SELECT ADDRESS_ID                                         
                    ,ADDRESS_FORMAT                                     
                INTO :PR-ADDRESS-ID                                     
                    ,:PR-ADDRESS-FORMAT                                 
                FROM CSS_PREMISE WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :AT-PREMISE-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ADDRESS_ID                                                 
MFA-TR*             ,ADDRESS_FORMAT                                             
MFA-TR*         INTO :PR-ADDRESS-ID                                             
MFA-TR*             ,:PR-ADDRESS-FORMAT                                         
MFA-TR*         FROM CSS_PREMISE                                                
MFA-TR*        WHERE PREMISE_NO = :AT-PREMISE-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_PREMISE'             TO TABLE-1                 
              MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-PREMISE-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND               THRU 9700-EXIT   
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11850000
      * 7110-SEL-AR-PYMT-DT-TYPE                                       *11860000
      * DETERMINE THE LAST PAYMENT DATE AND TYPE OF PAYMENT.           *11880000
      ******************************************************************11910000
                                                                        
       7110-SEL-AR-PYMT-DT-TYPE.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) AR.DATE_TRANS,
              AU.CURRENCY_TYPE,
              AR.DATE_CASH_REPORT                                
                INTO :AR-DATE-TRANS :WS-DATE-TRANS-NULL                  
                    ,:AU-CURRENCY-TYPE                                  
                    ,:AR-DATE-CASH-REPORT                               
                FROM CSS_AR_TRANS_HIST AR,                              
                     CSS_AR_TRN_HST_DET AU                              
               WHERE AR.ACCOUNT_NO        = :AT-ACCOUNT-NO              
                 AND AR.ACCOUNT_NO        = AU.ACCOUNT_NO               
                 AND AR.CODE_TRAN_TYPE    = 'P'                         
                 AND AR.TRANS_HIST_SEQ_NO = AU.TRANS_HIST_SEQ_NO        
                 AND AU.CURRENCY_TYPE NOT IN ('A','L')                  
               ORDER BY AR.DATE_TRANS    DESC                           
                       ,AU.CURRENCY_TYPE DESC                           
                                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                     11930000
MFA-TR*       SELECT AR.DATE_TRANS                                      11931000
MFA-TR*             ,AU.CURRENCY_TYPE                                   11931000
MFA-TR*             ,AR.DATE_CASH_REPORT                                        
MFA-TR*         INTO :AR-DATE-TRANS:WS-DATE-TRANS-NULL                  11931100
MFA-TR*             ,:AU-CURRENCY-TYPE                                  11931000
MFA-TR*             ,:AR-DATE-CASH-REPORT                                       
MFA-TR*         FROM CSS_AR_TRANS_HIST AR,                              11932000
MFA-TR*              CSS_AR_TRN_HST_DET AU                              11933000
MFA-TR*        WHERE AR.ACCOUNT_NO        = :AT-ACCOUNT-NO              11934000
MFA-TR*          AND AR.ACCOUNT_NO        = AU.ACCOUNT_NO                       
MFA-TR*          AND AR.CODE_TRAN_TYPE    = 'P'                         11935000
MFA-TR*          AND AR.TRANS_HIST_SEQ_NO = AU.TRANS_HIST_SEQ_NO        11936000
MFA-TR*          AND AU.CURRENCY_TYPE NOT IN ('A','L')                  11938000
MFA-TR*        ORDER BY AR.DATE_TRANS    DESC                           11938000
MFA-TR*                ,AU.CURRENCY_TYPE DESC                           11938000
MFA-TR*        FETCH FIRST ROW ONLY                                     11938000
MFA-TR*    END-EXEC.                                                    12070000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE SQLCODE                                             
            WHEN SUCCESSFUL-CALL                                        
                 IF WS-DATE-TRANS-NULL < 0                              
                    MOVE LOW-VALUES TO AR-DATE-TRANS                    
                    MOVE 0          TO WS-DATE-TRANS-NULL               
                 END-IF                                                 
            WHEN NOT-FOUND                                              
                 MOVE LOW-VALUES      TO AR-DATE-TRANS                  
                 MOVE SPACES          TO AR-DATE-CASH-REPORT            
                                         AU-CURRENCY-TYPE               
            WHEN OTHER                                                  
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE 'FETCH'                TO ABEND-FUNCTION          
                 MOVE '7110'                 TO ACTIVE-PARAGRAPH        
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSS_AR_TRANS_HIST'    TO TABLE-1                 
                 MOVE 'CSS_AR_TRN_HST_DET'   TO TABLE-2                 
                 MOVE 'ACCOUNT_NO    '       TO TABLE-ELEMENT-1         
                 MOVE AR-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND            THRU 9700-EXIT   
           END-EVALUATE.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11850000
      * 7120-SELECT-PENDING-REFUNDS                                    *11860000
      * CHECK-STATUS-CODE : R - REQUESTED                                       
      ******************************************************************        
                                                                        
       7120-SELECT-PENDING-REFUNDS.                                     
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RN.AMT_REFUNDED,
              RN.CHECK_ISS_REAS_CD,
              RN.COMMENTS,
              CIS.CHAR2$DATE(RN.REQUEST_DT,'USA'),
              RN.MANUAL_INDICATOR,
              RN.USER_ID_APPRVD_BY,
              RN.USER_ID_RQSTED_BY,
              RN.ADDRESS_ID,
              REPLACE(REPLACE(CONVERT(CHAR(26), RN.TRANS_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') TRANS_HIST_SEQ_NO,
              RN.PANEL_NO                                        
                INTO :RN-AMT-REFUNDED                                   
                    ,:RN-CHECK-ISS-REAS-CD                              
                    ,:RN-COMMENTS                                       
                    ,:RN-REQUEST-DT :WS-REQUEST-DT-NULL                 
                    ,:RN-MANUAL-INDICATOR                               
                    ,:RN-USER-ID-APPRVD-BY                              
                    ,:RN-USER-ID-RQSTED-BY                              
                    ,:RN-ADDRESS-ID                                     
                    ,:RN-TRANS-HIST-SEQ-NO                              
                    ,:RN-PANEL-NO                                       
                FROM CSS_REFUND RN WITH(READUNCOMMITTED)                        
               WHERE RN.ACCOUNT_NO      = :RN-ACCOUNT-NO                
                 AND RN.CHECK_STATUS_CD = 'R'                           
               ORDER BY REFUND_ITEM_ID DESC                             
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RN.AMT_REFUNDED                                            
MFA-TR*             ,RN.CHECK_ISS_REAS_CD                                       
MFA-TR*             ,RN.COMMENTS                                                
MFA-TR*             ,CHAR(RN.REQUEST_DT,USA)                                    
MFA-TR*             ,RN.MANUAL_INDICATOR                                        
MFA-TR*             ,RN.USER_ID_APPRVD_BY                                       
MFA-TR*             ,RN.USER_ID_RQSTED_BY                                       
MFA-TR*             ,RN.ADDRESS_ID                                              
MFA-TR*             ,RN.TRANS_HIST_SEQ_NO                                       
MFA-TR*             ,RN.PANEL_NO                                                
MFA-TR*         INTO :RN-AMT-REFUNDED                                           
MFA-TR*             ,:RN-CHECK-ISS-REAS-CD                                      
MFA-TR*             ,:RN-COMMENTS                                               
MFA-TR*             ,:RN-REQUEST-DT :WS-REQUEST-DT-NULL                         
MFA-TR*             ,:RN-MANUAL-INDICATOR                                       
MFA-TR*             ,:RN-USER-ID-APPRVD-BY                                      
MFA-TR*             ,:RN-USER-ID-RQSTED-BY                                      
MFA-TR*             ,:RN-ADDRESS-ID                                             
MFA-TR*             ,:RN-TRANS-HIST-SEQ-NO                                      
MFA-TR*             ,:RN-PANEL-NO                                               
MFA-TR*         FROM CSS_REFUND RN                                              
MFA-TR*        WHERE RN.ACCOUNT_NO      = :RN-ACCOUNT-NO                        
MFA-TR*          AND RN.CHECK_STATUS_CD = 'R'                                   
MFA-TR*        ORDER BY REFUND_ITEM_ID DESC                                     
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7120                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7120'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_REFUND'              TO TABLE-1                 
              MOVE 'ACCOINT_NO'              TO TABLE-ELEMENT-1         
              MOVE RN-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND               THRU 9700-EXIT   
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7500-OPEN-CIA-CURSOR                                           *        
      ******************************************************************        
                                                                        
       7500-OPEN-CIA-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
              OPEN CIA_CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7500'                    TO ACTIVE-PARAGRAPH        
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_AR_CNTL'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND               THRU 9700-EXIT   
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7510-FETCH-CIA-CURSOR                                          *        
      ******************************************************************        
                                                                        
       7510-FETCH-CIA-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
              FETCH CIA_CURSOR                                          
               INTO :AC-AMT-UNUSED-CR                                   
                   ,:AC-ITEM-ID                                         
                   ,:AC-PYMT-PRIORITY-LVL                               
                   ,:AC-LAST-UPDATE-TS                                  
                   ,:L5-AR-TYPE-SHORT-DESC                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
            WHEN SUCCESSFUL-CALL                                        
                 CONTINUE                                               
            WHEN NOT-FOUND                                              
                 SET ALL-DONE                TO TRUE                    
            WHEN OTHER                                                  
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '7510'                 TO ACTIVE-PARAGRAPH        
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'FETCH'                TO ABEND-FUNCTION          
                 MOVE 'CSS_AR_CNTL'          TO TABLE-1                 
                 MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1         
                 MOVE AC-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND            THRU 9700-EXIT   
           END-EVALUATE.                                                
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************33760000
      * 7520-CLOSE-CIA-CURSOR                                          *33770000
      ******************************************************************33780000
                                                                        
       7520-CLOSE-CIA-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
              CLOSE CIA_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7520'                    TO ACTIVE-PARAGRAPH        
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_AR_CNTL'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND               THRU 9700-EXIT   
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7530-OPEN-PRE-PAYMENT-CURSOR                                   *        
      ******************************************************************        
                                                                        
       7530-OPEN-PRE-PAYMENT-CURSOR.                                    
                                                                        
           EXEC SQL                                                     
              OPEN PRE_PAYMENT_CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7530'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
              MOVE 'CSS_AR_TRN_HST_DET'      TO TABLE-2                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND               THRU 9700-EXIT   
           END-IF.                                                      
                                                                        
       7530-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7540-FETCH-PRE-PAYMENT-CURSOR                                  *        
      ******************************************************************        
                                                                        
       7540-FETCH-PRE-PAYMENT-CURSOR.                                   
                                                                        
           EXEC SQL                                                     
              FETCH PRE_PAYMENT_CUR                                     
               INTO :AR-DATE-TRANS :WS-DATE-TRANS-NULL               
                   ,:AR-AMT-ORIG-ENTERED                                
                   ,:AR-TRANS-HIST-SEQ-NO                               
                   ,:AR-USER-ID                                         
                   ,:AR-PYMT-REFUNDED-IND                               
                   ,:AR-CODE-TRAN-TYPE                                  
                   ,:AU-CURRENCY-TYPE                                   
                   ,:AU-CURRENCY-AMT                                    
                   ,:AU-TRAN-APPL-NO                                    
                   ,:AR-PYMT-RCPT-PRNTD-CD                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
            WHEN SUCCESSFUL-CALL                                        
                 IF WS-DATE-TRANS-NULL < 0                              
                    MOVE SPACES              TO AR-DATE-TRANS           
                    MOVE ZEROES              TO WS-DATE-TRANS-NULL      
                 END-IF                                                 
            WHEN NOT-FOUND                                              
                 SET ALL-DONE                TO TRUE                    
                 INITIALIZE DCLCSS-AR-TRANS-HIST                        
                            DCLCSS-AR-TRN-HST-DET                       
            WHEN OTHER                                                  
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE 'FETCH'                TO ABEND-FUNCTION          
                 MOVE '7540'                 TO ACTIVE-PARAGRAPH        
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSS_AR_TRANS_HIST'    TO TABLE-1                 
                 MOVE 'CSS_AR_TRN_HST_DET'   TO TABLE-2                 
                 MOVE 'ACCOUNT_NO    '       TO TABLE-ELEMENT-1         
                 MOVE AR-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND            THRU 9700-EXIT   
           END-EVALUATE.                                                
                                                                        
       7540-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************33760000
      * 7550-CLOSE-PRE-PAYMENT-CURSOR                                  *33770000
      ******************************************************************33780000
                                                                        
       7550-CLOSE-PRE-PAYMENT-CURSOR.                                   
                                                                        
           EXEC SQL                                                     
              CLOSE PRE_PAYMENT_CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7550'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
              MOVE 'CSS_AR_TRN_HST_DET'      TO TABLE-2                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND               THRU 9700-EXIT   
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8001-INSERT-GTT-R1.                                            *        
      ******************************************************************        
                                                                        
       8001-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04887_R1                            
             (                                                          
               RETURN_CODE                                              
              ,PPL_NAME                                                 
              ,ITEM_ID                                                  
              ,AMT_UNUSED_CR                                            
              ,AC_LAST_UPD_TS                                           
              ,NSC_NSA_IND                                              
              ,SUMM_UNBILLED                                            
              ,AT_LAST_UPD_TS                                           
              ,RELEASE_DT                                               
              ,RN_TRANS_HIST_SEQ                                        
             )                                                          
             VALUES                                                     
             (                                                          
              :S-R1-RETURN-CODE                                         
             ,:S-R1-PPL-NAME                                            
             ,:S-R1-ITEM-ID                                             
             ,:S-R1-AMT-UNUSED-CR                                       
             ,:S-R1-AC-LAST-UPD-TS                                      
             ,:S-R1-NSC-NSA-IND                                         
             ,:S-R1-SUMM-UNBILLED                                       
             ,:S-R1-AT-LAST-UPD-TS                                      
             ,:S-R1-RELEASE-DT                                          
             ,:S-R1-RN-TRANS-HIST-SEQ                                   
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04887_R1                                    
MFA-TR*      (                                                                  
MFA-TR*        RETURN_CODE                                                      
MFA-TR*       ,PPL_NAME                                                         
MFA-TR*       ,ITEM_ID                                                          
MFA-TR*       ,AMT_UNUSED_CR                                                    
MFA-TR*       ,AC_LAST_UPD_TS                                                   
MFA-TR*       ,NSC_NSA_IND                                                      
MFA-TR*       ,SUMM_UNBILLED                                                    
MFA-TR*       ,AT_LAST_UPD_TS                                                   
MFA-TR*       ,RELEASE_DT                                                       
MFA-TR*       ,RN_TRANS_HIST_SEQ                                                
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-R1-RETURN-CODE                                                 
MFA-TR*      ,:S-R1-PPL-NAME                                                    
MFA-TR*      ,:S-R1-ITEM-ID                                                     
MFA-TR*      ,:S-R1-AMT-UNUSED-CR                                               
MFA-TR*      ,:S-R1-AC-LAST-UPD-TS                                              
MFA-TR*      ,:S-R1-NSC-NSA-IND                                                 
MFA-TR*      ,:S-R1-SUMM-UNBILLED                                               
MFA-TR*      ,:S-R1-AT-LAST-UPD-TS                                              
MFA-TR*      ,:S-R1-RELEASE-DT                                                  
MFA-TR*      ,:S-R1-RN-TRANS-HIST-SEQ                                           
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              ADD +1                        TO  CTR-ROWS-R1             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '8001'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSR04887_R1'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8001-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8001A-DEL-GTT-R1.                                              *        
      ******************************************************************        
                                                                        
       8001A-DEL-GTT-R1.                                                
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04887_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04887_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE ZEROES                   TO WS-ACTIVE-RETURN-CODE    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE WS-ACTIVE-RETURN-CODE    TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '8001A'                  TO ACTIVE-PARAGRAPH         
              MOVE 'DELETE'                 TO ABEND-FUNCTION           
              MOVE 'CSR04887_R1'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8001A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8002-INSERT-GTT-R2.                                            *        
      ******************************************************************        
                                                                        
       8002-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04887_R2                            
             (                                                          
               RETURN_CODE                                              
              ,DATE_TRANS                                               
              ,CODE_TRAN_TYPE                                           
              ,REFUND_IND                                               
              ,AMT_ORIG_ENTERED                                         
              ,CHECK_AMT                                                
              ,CASH_AMT                                                 
              ,OTHER_AMT                                                
              ,FIRST_NAME_PF                                            
              ,MIDDLE_NAME_PF                                           
              ,LAST_NAME_PF                                             
              ,TRANS_HIST_SEQ_NO_AR                                     
              ,PYMT_RCPT_PRNTD_CD                                       
              ,RELEASE_DT                                               
              ,AT_LAST_UPD_TS                                           
             )                                                          
             VALUES                                                     
             (                                                          
              :S-R2-RETURN-CODE                                         
             ,:S-R2-DATE-TRANS                                          
             ,:S-R2-CODE-TRAN-TYPE                                      
             ,:S-R2-REFUND-IND                                          
             ,:S-R2-AMT-ORIG-ENTERED                                    
             ,:S-R2-CHECK-AMT                                           
             ,:S-R2-CASH-AMT                                            
             ,:S-R2-OTHER-AMT                                           
             ,:S-R2-FIRST-NAME-PF                                       
             ,:S-R2-MIDDLE-NAME-PF                                      
             ,:S-R2-LAST-NAME-PF                                        
             ,:S-R2-TRANS-SEQ-NO                                        
             ,:S-R2-PYMT-RCPT-PRNTD-CD                                  
             ,:S-R2-RELEASE-DT                                          
             ,:S-R2-AT-LAST-UPD-TS                                      
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04887_R2                                    
MFA-TR*      (                                                                  
MFA-TR*        RETURN_CODE                                                      
MFA-TR*       ,DATE_TRANS                                                       
MFA-TR*       ,CODE_TRAN_TYPE                                                   
MFA-TR*       ,REFUND_IND                                                       
MFA-TR*       ,AMT_ORIG_ENTERED                                                 
MFA-TR*       ,CHECK_AMT                                                        
MFA-TR*       ,CASH_AMT                                                         
MFA-TR*       ,OTHER_AMT                                                        
MFA-TR*       ,FIRST_NAME_PF                                                    
MFA-TR*       ,MIDDLE_NAME_PF                                                   
MFA-TR*       ,LAST_NAME_PF                                                     
MFA-TR*       ,TRANS_HIST_SEQ_NO_AR                                             
MFA-TR*       ,PYMT_RCPT_PRNTD_CD                                               
MFA-TR*       ,RELEASE_DT                                                       
MFA-TR*       ,AT_LAST_UPD_TS                                                   
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-R2-RETURN-CODE                                                 
MFA-TR*      ,:S-R2-DATE-TRANS                                                  
MFA-TR*      ,:S-R2-CODE-TRAN-TYPE                                              
MFA-TR*      ,:S-R2-REFUND-IND                                                  
MFA-TR*      ,:S-R2-AMT-ORIG-ENTERED                                            
MFA-TR*      ,:S-R2-CHECK-AMT                                                   
MFA-TR*      ,:S-R2-CASH-AMT                                                    
MFA-TR*      ,:S-R2-OTHER-AMT                                                   
MFA-TR*      ,:S-R2-FIRST-NAME-PF                                               
MFA-TR*      ,:S-R2-MIDDLE-NAME-PF                                              
MFA-TR*      ,:S-R2-LAST-NAME-PF                                                
MFA-TR*      ,:S-R2-TRANS-SEQ-NO                                                
MFA-TR*      ,:S-R2-PYMT-RCPT-PRNTD-CD                                          
MFA-TR*      ,:S-R2-RELEASE-DT                                                  
MFA-TR*      ,:S-R2-AT-LAST-UPD-TS                                              
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              ADD +1                        TO  CTR-ROWS-R2             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '8002'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSR04887_R2'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8002-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8002A-DEL-GTT-R2.                                              *        
      ******************************************************************        
                                                                        
       8002A-DEL-GTT-R2.                                                
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04887_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04887_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE ZEROES                   TO WS-ACTIVE-RETURN-CODE    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE WS-ACTIVE-RETURN-CODE    TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '8002A'                  TO ACTIVE-PARAGRAPH         
              MOVE 'DELETE'                 TO ABEND-FUNCTION           
              MOVE 'CSR04887_R2'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8002A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************34120000
      * 8800-CHECK-RESULTS.                                            *34130000
      ******************************************************************34140000
                                                                        
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-R1  = 0                                          
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE 100                       TO S-R1-RETURN-CODE        
              PERFORM 8001-INSERT-GTT-R1     THRU 8001-EXIT             
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-R2  = 0                                          
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE 100                       TO S-R2-RETURN-CODE        
              PERFORM 8002-INSERT-GTT-R2     THRU 8002-EXIT             
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-R3  = 0                                          
              INITIALIZE GTT-RETURN-FIELDS-3                            
              MOVE 100                       TO S-R3-RETURN-CODE        
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-R4  = 0                                          
              INITIALIZE GTT-RETURN-FIELDS-4                            
              MOVE 100                       TO S-R4-RETURN-CODE        
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
                                                                        
           EXEC SQL                                                     
               OPEN C4                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-R1-RETURN-CODE         
                                               S-R2-RETURN-CODE         
                                               S-R3-RETURN-CODE         
                                               S-R4-RETURN-CODE.        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           PERFORM 8001A-DEL-GTT-R1         THRU 8001A-EXIT             
           PERFORM 8001-INSERT-GTT-R1       THRU 8001-EXIT.             
                                                                        
           PERFORM 8002A-DEL-GTT-R2         THRU 8002A-EXIT             
           PERFORM 8002-INSERT-GTT-R2       THRU 8002-EXIT.             
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           PERFORM 8800-CHECK-RESULTS    THRU 8800-EXIT.                
                                                                        
           IF CTR-ROWS-R1 < 1 AND CTR-ROWS-R2 < 1 AND CTR-ROWS-R3 < 1   
              AND CTR-ROWS-R4 < 1                                       
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '9999-END-PROGRAM'    TO ABEND-FUNCTION              
              MOVE 'PROGRAMMER LOGIC'    TO TABLE-1                     
              MOVE 'FAILED TO SEND'      TO TABLE-ELEMENT-1             
              MOVE 'RESULT SET'          TO HOSTVAR-ELEMENT-1           
              MOVE -1                    TO WS-ACTIVE-RETURN-CODE       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           ELSE                                                         
              PERFORM 8900-SEND-DONE     THRU 8900-EXIT                 
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
