       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04886.                                      
       AUTHOR.       MITHUN KUMAR SEKARAN.                              
COB303 DATE-WRITTEN.     OCT 09,  2015.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      ***              P R O G R A M  S U M M A R Y                  ***        
      ***                                                            ***        
      *** CSR04886:                                                  ***        
      ***                                                            ***        
      *** THIS PROCEDURE USED TO VALIDATE NAVIGATION FOR COMPLETION  ***        
      *** WIZARD.                                                    ***        
      ***                                                            ***        
      *** DB2 TABLES USED.                                           ***        
      ***    1.CSS_SO_DATA.                                          ***        
      ***    2.CSS_WORK_AREA_MATL.                                   ***        
      ***                                                            ***        
      ***------------------------------------------------------------***        
      *** PARAMETERS                                                 ***        
      ***                                                            ***        
      ***    INPUT                                                   ***        
      ***                                                            ***        
      ***           SERV_ORDER_NO      DECIMAL(13,0)                 ***        
      ***           SOURCE_SYSTEM_CD   CHAR(3)                       ***        
      ***                                                            ***        
      ***    OUT                                                     ***        
      ***                                                            ***        
      ***          NONE                                              ***        
      ***                                                            ***        
      ***    INOUT                                                   ***        
      ***                                                            ***        
      ***          NONE                                              ***        
      ***                                                            ***        
      *** RESULT SET                                                 ***        
      ***                                                            ***        
      *** CSR04886_R1 - WORK AREA ID DETAILS                         ***        
      ***                                                            ***        
      ***          RETURN_CODE         INTEGER                       ***        
      ***         ,APPL_RETURN_CODE    INTEGER                       ***        
      ***         ,WORK_AREA_EXIST     CHAR(05)                      ***        
      ***         ,ADD_CHARGES         CHAR(01)                      ***        
      ***                                                            ***        
      ***------------------------------------------------------------***        
      ******************************************************************        
      ***                    MODIFICATION LOG                        ***        
      ***------------------------------------------------------------***        
      ***                                                            ***        
      ***  DATE          INITIALS    COMMENTS                        ***        
      ***  -----------   --------    --------------------------------***        
      ***  10/09/2015    MS7M727     NEW                             ***        
      ***  12/28/2015    MSR         ADD VALIDATION FOR SERVICE CHGS ***        
      ***  02/24/2016    MSR         ADD RATES VALIDATION            ***        
      ***  03/24/2016    MSR         ADD ACCOUNT NO PRIOR            ***        
      ***  11/03/2016    MLF18988    IF FALSE FROM 7000, CALL 7010   ***        
      ***                            TO GO JOIN WITH HST_SO_DATA.    ***        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     ACCOUNT PROCESSING CONTROL PATH       **        
      **        2000 - 2999     COMMON PROGRAM MODULES                **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     NOT USED                              **        
      **        7000 - 7999     OUTPUT MODULES                        **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04886'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-LITERALS.                                                  
          05 WS-PROGRAM-NAME                PIC X(08) VALUE 'CSR04886'. 
      *                                                                         
       01 WS-WORK-AREA.                                                 
          05 WS-APPL-RETURN-CODE            PIC S9(04) COMP VALUE 0.    
          05 WS-SQLSTATE                    PIC X(05) VALUE SPACES.     
      *                                                                         
       01 COUNTER-FIELDS.                                               
          05  CTR-ROWS-RS1                  PIC S9(9) COMP VALUE 0.     
      *                                                                         
       01 GTT-MISC-FIELDS.                                              
          05  WS-GTT-NAME                   PIC X(26) VALUE SPACES.     
          05  GTT-ROW.                                                  
              49 GTT-ROW-LEN                PIC S9(04) COMP.            
              49 GTT-ROW-CHAR               PIC X(1024).                
          05  GTT-SQLCODE                   PIC S9(9) COMP.             
      *                                                                         
       01 WS-ERR-FLAGS.                                                 
          05  WS-ERR-INSRT-R1               PIC X(01) VALUE 'N'.        
          05  WS-YES                        PIC X(01) VALUE 'Y'.        
          05  WS-RATE-REQUIRED              PIC X(01) VALUE 'N'.        
          05  WS-MTR-ROW-FND                PIC X(01) VALUE 'N'.        
COB305    05 WS-SERV-ORDER-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.   
      *                                                                         
      *****************************************************************         
      *   GTT TABLE LAYOUT FOR WORK AREA ID DETAILS                  **         
      *****************************************************************         
      *                                                                         
        01 GTT-RETURN-FIELDS.                                           
           05 GTT-RETURN-FIELDS-1.                                      
              10 S-RETURN-CODE-1            PIC S9(04) COMP VALUE 0.    
              10 S-APPL-RETURN-CODE-1       PIC S9(04) COMP VALUE 0.    
              10 S-WORK-AREA-EXIST          PIC X(05)  VALUE SPACES.    
              10 S-ADD-CHARGES              PIC X(01)  VALUE SPACES.    
              10 S-RATES-REQUIRED           PIC X(01)  VALUE SPACES.    
              10 S-BUSINESS-RULE-ID         PIC X(10)  VALUE SPACES.    
              10 S-WANTED-BY-DATETIME       PIC X(26)  VALUE SPACES.    
              10 S-ACCOUNT-NO-PRIOR         PIC X(13)  VALUE SPACES.    
      *                                                                         
      *****************************************************************         
      *    CSS_WORK_AREA_MATL AG                                     **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBWKMATL                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_SO_DATA  VO                                           **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_SO_UTILITY VT                                         **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSOUTL                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_SO_UTL_CHG VE                                         **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSOUTG                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_SO_ORDER_INST VI                                      **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSOODR                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_ORDER_TYPE C2                                         **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBORTYP                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_SO_MTR_CHG VC                                        **          
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSOMCG                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    DB2 INCLUDES                                              **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **   ABEND TABLE                                               **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    COMMON SQL AND DB2 ABEND CODES                                       
      *****************************************************************         
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
COB305 01 PARM-SERV-ORDER-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.   
       01 PARM-SOURCE-SYSTEM                PIC X(03).                  
      *                                                                         
       PROCEDURE DIVISION USING PARM-SERV-ORDER-NO                      
                               ,PARM-SOURCE-SYSTEM.                     
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE              THRU 0100-EXIT.         
           PERFORM 1000-PROCESS-INPUT           THRU 1000-EXIT.         
           PERFORM 9999-END-PROGRAM             THRU 9999-EXIT.         
           
MSQ016        GOBACK.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           PERFORM 0100A-DECLARE-GTT-R1         THRU 0100A-EXIT.        
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************00062500
      * 0100A-DECLARE-GTT-R1                                           *00062600
      ******************************************************************00062800
      *                                                                         
       0100A-DECLARE-GTT-R1.                                            
      *                                                                 00063000
           MOVE 'SESSION.CSR04886_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04886_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04886_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,WORK_AREA_EXIST CHAR(05)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ADD_CHARGES CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RATES_REQUIRED CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUSINESS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,WANTED_BY_DATETIME CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ACCOUNT_NO_PRIOR CHAR(13)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS        THRU 8000A-EXIT         
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE WS-PROGRAM-NAME       TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(WORK_AREA_EXIST)) AS WORK_AREA_EXIST        
                      ,LTRIM(RTRIM(ADD_CHARGES)) AS ADD_CHARGES                
                      ,LTRIM(RTRIM(RATES_REQUIRED)) AS RATES_REQUIRED          
                      ,LTRIM(RTRIM(BUSINESS_RULE_ID)) AS 
           BUSINESS_RULE_ID      
                      ,LTRIM(RTRIM(WANTED_BY_DATETIME)) AS 
           WANTED_BY_DATETIME  
                      ,LTRIM(RTRIM(ACCOUNT_NO_PRIOR)) AS 
           ACCOUNT_NO_PRIOR      
                  FROM #CSR04886_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00066700
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                            00066800
MFA-TR*                          WITH ROWSET POSITIONING FOR            00066900
MFA-TR*         SELECT RETURN_CODE                                      00067000
MFA-TR*               ,APPL_RETURN_CODE                                 00067100
MFA-TR*               ,STRIP(WORK_AREA_EXIST) AS WORK_AREA_EXIST        00067200
MFA-TR*               ,STRIP(ADD_CHARGES) AS ADD_CHARGES                        
MFA-TR*               ,STRIP(RATES_REQUIRED) AS RATES_REQUIRED                  
MFA-TR*               ,STRIP(BUSINESS_RULE_ID) AS BUSINESS_RULE_ID              
MFA-TR*               ,STRIP(WANTED_BY_DATETIME) AS WANTED_BY_DATETIME          
MFA-TR*               ,STRIP(ACCOUNT_NO_PRIOR) AS ACCOUNT_NO_PRIOR              
MFA-TR*           FROM SESSION.CSR04886_R1                              00067500
MFA-TR*    END-EXEC.                                                    00067600
      *                                                                 00067700
       0100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 00068000
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           PERFORM 7000-SELECT-WORK-ORDER       THRU 7000-EXIT.         
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
               PERFORM 7010-SELECT-WORK-ORDER-HST THRU 7010-EXIT        
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                   MOVE 'FALSE'             TO  S-WORK-AREA-EXIST       
               END-IF                                                   
           END-IF.                                                      
           PERFORM 2100-GET-SERV-CHGS-DATA  THRU 2100-EXIT.             
           PERFORM 2200-CHECK-RATES         THRU 2200-EXIT.             
           PERFORM 2300-VALIDATE-ORDER      THRU 2300-EXIT.             
           PERFORM 8010-INSERT-GTT-R1   THRU 8010-EXIT.                 
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-GET-SERV-CHGS-DATA                                        *        
      ******************************************************************        
      *                                                                         
       2100-GET-SERV-CHGS-DATA.                                         
      *                                                                         
           PERFORM 7100-SELECT-SO-DATA        THRU 7100-EXIT.           
           MOVE VO-WANTED-BY-DATETIME         TO S-WANTED-BY-DATETIME.  
           MOVE VO-ACCOUNT-NO-PRIOR           TO S-ACCOUNT-NO-PRIOR.    
           IF VO-ORDER-TYPE-CD(1:2) EQUAL 'EM' OR                       
               (VO-ORDER-TYPE-CD(1:2) EQUAL 'FW' AND                    
                VO-ORDER-TYPE-CD NOT EQUAL 'FW026') OR                  
                C2-ORDER-GROUP-CD = 'F' OR C2-ORDER-GROUP-CD = 'G'      
              MOVE 'N'                      TO S-ADD-CHARGES            
           ELSE                                                         
              MOVE 'Y'                      TO S-ADD-CHARGES            
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-CHECK-RATES                                               *        
      ******************************************************************        
      *                                                                         
       2200-CHECK-RATES.                                                
      *                                                                         
           PERFORM 7200-SELECT-SO-UTILITY        THRU 7200-EXIT.        
           MOVE WS-RATE-REQUIRED                 TO S-RATES-REQUIRED.   
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2300-VALIDATE-ORDER                                            *        
      ******************************************************************        
      *                                                                         
       2300-VALIDATE-ORDER.                                             
      *                                                                         
           IF VO-ORDER-TYPE-CD(1:2) EQUAL 'CC' OR                       
              VO-ORDER-TYPE-CD(1:2) EQUAL 'OF'                          
              PERFORM 7400-CHECK-METERS          THRU 7400-EXIT         
              IF WS-MTR-ROW-FND EQUAL 'N'                               
                  PERFORM 7300-CHECK-PENDING-SETS    THRU 7300-EXIT     
                  IF WS-SERV-ORDER-NO > 0                               
                     MOVE 'ORDR000416'             TO S-BUSINESS-RULE-ID
                  ELSE                                                  
                     MOVE 'ORDR000417'             TO S-BUSINESS-RULE-ID
                  END-IF                                                
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7000-SELECT-WORK-ORDER                                         *        
      ******************************************************************        
      *                                                                         
       7000-SELECT-WORK-ORDER.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT 'TRUE'                                             
                INTO :S-WORK-AREA-EXIST                                 
                FROM CSS_WORK_AREA_MATL  AG                             
                JOIN CSS_SO_DATA VO                                     
                  ON VO.SERV_ORDER_NO = :PARM-SERV-ORDER-NO             
                 AND VO.WORK_AREA_ID  = AG.WORK_AREA_ID                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-PROGRAM-NAME          TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_SO_DATA'            TO TABLE-1                  
              MOVE 'SERV_ORDER_NO'          TO TABLE-ELEMENT-1          
              MOVE VO-SERV-ORDER-NO         TO HOSTVAR-ELEMENT-1        
              MOVE 'CSS_WORK_AREA_MATL'     TO TABLE-2                  
              MOVE 'WORK_AREA_ID'           TO TABLE-ELEMENT-2          
              MOVE AG-WORK-AREA-ID          TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7010-SELECT-WORK-ORDER-HST                                     *        
      ******************************************************************        
      *                                                                         
       7010-SELECT-WORK-ORDER-HST.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT 'TRUE'                                             
                INTO :S-WORK-AREA-EXIST                                 
                FROM CSS_WORK_AREA_MATL  AG                             
                JOIN HST_SO_DATA VH                                     
                  ON VH.SERV_ORDER_NO = :PARM-SERV-ORDER-NO             
                 AND VH.WORK_AREA_ID  = AG.WORK_AREA_ID                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-PROGRAM-NAME          TO ABEND-PROGRAM            
              MOVE '7010'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'HST_SO_DATA'            TO TABLE-1                  
              MOVE 'SERV_ORDER_NO'          TO TABLE-ELEMENT-1          
              MOVE VO-SERV-ORDER-NO         TO HOSTVAR-ELEMENT-1        
              MOVE 'CSS_WORK_AREA_MATL'     TO TABLE-2                  
              MOVE 'WORK_AREA_ID'           TO TABLE-ELEMENT-2          
              MOVE AG-WORK-AREA-ID          TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-SELECT-SO0-DATA                                           *        
      ******************************************************************        
      *                                                                         
       7100-SELECT-SO-DATA.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT VO.ORDER_TYPE_CD                                   
                    ,ORDER_STATE_CD                                     
                    ,ORDER_GROUP_CD                                     
                    ,PREMISE_NO                                         
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           WANTED_BY_DATETIME, 121), ' ', '-'), ':', '.') 
           WANTED_BY_DATETIME                                 
                    ,ACCOUNT_NO_PRIOR                                   
                INTO :VO-ORDER-TYPE-CD                                  
                    ,:VO-ORDER-STATE-CD                                 
                    ,:C2-ORDER-GROUP-CD                                 
                    ,:VO-PREMISE-NO                                     
                    ,:VO-WANTED-BY-DATETIME                             
                    ,:VO-ACCOUNT-NO-PRIOR                               
                FROM CSS_SO_DATA VO WITH(READUNCOMMITTED)                       
                    ,CSS_ORDER_TYPE C2 WITH(READUNCOMMITTED)                    
               WHERE VO.SERV_ORDER_NO = :PARM-SERV-ORDER-NO             
                 AND VO.ORDER_TYPE_CD = C2.ORDER_TYPE_CD                
                 AND VO.COMPANY_NO = C2.COMPANY_NO                      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT VO.ORDER_TYPE_CD                                           
MFA-TR*             ,ORDER_STATE_CD                                             
MFA-TR*             ,ORDER_GROUP_CD                                             
MFA-TR*             ,PREMISE_NO                                                 
MFA-TR*             ,WANTED_BY_DATETIME                                         
MFA-TR*             ,ACCOUNT_NO_PRIOR                                           
MFA-TR*         INTO :VO-ORDER-TYPE-CD                                          
MFA-TR*             ,:VO-ORDER-STATE-CD                                         
MFA-TR*             ,:C2-ORDER-GROUP-CD                                         
MFA-TR*             ,:VO-PREMISE-NO                                             
MFA-TR*             ,:VO-WANTED-BY-DATETIME                                     
MFA-TR*             ,:VO-ACCOUNT-NO-PRIOR                                       
MFA-TR*         FROM CSS_SO_DATA VO                                             
MFA-TR*             ,CSS_ORDER_TYPE C2                                          
MFA-TR*        WHERE VO.SERV_ORDER_NO = :PARM-SERV-ORDER-NO                     
MFA-TR*          AND VO.ORDER_TYPE_CD = C2.ORDER_TYPE_CD                        
MFA-TR*          AND VO.COMPANY_NO = C2.COMPANY_NO                              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-PROGRAM-NAME          TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_SO_DATA'            TO TABLE-1                  
              MOVE 'SERV_ORDER_NO'          TO TABLE-ELEMENT-1          
              MOVE VO-SERV-ORDER-NO         TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-SELECT-SO-UTILITY                                         *        
      ******************************************************************        
      *                                                                         
       7200-SELECT-SO-UTILITY.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-RATE-REQUIRED                                  
                FROM CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED)                 
               WHERE VI.SERV_ORDER_NO = :PARM-SERV-ORDER-NO             
                 AND VI.WORK_TYPE_CD IN ('SET','ST2','ST3','TMP')       
                 AND NOT EXISTS                                         
                     (SELECT 1                                          
                        FROM CSS_SO_UTILITY VT WITH(READUNCOMMITTED)            
                       WHERE VT.SERV_ORDER_NO = VI.SERV_ORDER_NO        
                         AND VT.SERV_ORDER_NO = :PARM-SERV-ORDER-NO     
                         AND VT.CODE_UTIL_TYPE = VI.CODE_UTIL_TYPE      
                         AND VT.IC_NO = VI.IC_NO)                       
                 AND NOT EXISTS                                         
                     (SELECT 1                                          
                        FROM CSS_SO_UTL_CHG VE WITH(READUNCOMMITTED)            
                       WHERE VE.SERV_ORDER_NO = VI.SERV_ORDER_NO        
                         AND VE.SERV_ORDER_NO = :PARM-SERV-ORDER-NO     
                         AND VE.CODE_UTIL_TYPE = VI.CODE_UTIL_TYPE      
                         AND VE.IC_NO = VI.IC_NO)                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-RATE-REQUIRED                                          
MFA-TR*         FROM CSS_SO_ORDER_INST VI                                       
MFA-TR*        WHERE VI.SERV_ORDER_NO = :PARM-SERV-ORDER-NO                     
MFA-TR*          AND VI.WORK_TYPE_CD IN ('SET','ST2','ST3','TMP')               
MFA-TR*          AND NOT EXISTS                                                 
MFA-TR*              (SELECT 1                                                  
MFA-TR*                 FROM CSS_SO_UTILITY VT                                  
MFA-TR*                WHERE VT.SERV_ORDER_NO = VI.SERV_ORDER_NO                
MFA-TR*                  AND VT.SERV_ORDER_NO = :PARM-SERV-ORDER-NO             
MFA-TR*                  AND VT.CODE_UTIL_TYPE = VI.CODE_UTIL_TYPE              
MFA-TR*                  AND VT.IC_NO = VI.IC_NO)                               
MFA-TR*          AND NOT EXISTS                                                 
MFA-TR*              (SELECT 1                                                  
MFA-TR*                 FROM CSS_SO_UTL_CHG VE                                  
MFA-TR*                WHERE VE.SERV_ORDER_NO = VI.SERV_ORDER_NO                
MFA-TR*                  AND VE.SERV_ORDER_NO = :PARM-SERV-ORDER-NO             
MFA-TR*                  AND VE.CODE_UTIL_TYPE = VI.CODE_UTIL_TYPE              
MFA-TR*                  AND VE.IC_NO = VI.IC_NO)                               
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-PROGRAM-NAME          TO ABEND-PROGRAM            
              MOVE '7200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_SO_ORDER_INST'      TO TABLE-1                  
              MOVE 'SERV_ORDER_NO'          TO TABLE-ELEMENT-1          
              MOVE PARM-SERV-ORDER-NO       TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-CHECK-PENDING-SETS                                        *        
      ******************************************************************        
      *                                                                         
       7300-CHECK-PENDING-SETS.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) SERV_ORDER_NO                                      
                INTO :WS-SERV-ORDER-NO                                  
                FROM CSS_SO_DATA WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :VO-PREMISE-NO                        
                 AND ORDER_TYPE_CD = 'FM002'                            
                 AND ORDER_STATE_CD NOT IN ('C','Z')                    
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SERV_ORDER_NO                                              
MFA-TR*         INTO :WS-SERV-ORDER-NO                                          
MFA-TR*         FROM CSS_SO_DATA                                                
MFA-TR*        WHERE PREMISE_NO = :VO-PREMISE-NO                                
MFA-TR*          AND ORDER_TYPE_CD = 'FM002'                                    
MFA-TR*          AND ORDER_STATE_CD NOT IN ('C','Z')                            
MFA-TR*    FETCH FIRST 1 ROWS ONLY                                              
MFA-TR*    WITH UR                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE ZEROS                 TO WS-SERV-ORDER-NO         
              END-IF                                                    
           ELSE                                                         
              MOVE WS-PROGRAM-NAME          TO ABEND-PROGRAM            
              MOVE '7300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_SO_DATA'            TO TABLE-1                  
              MOVE 'SERV_ORDER_NO'          TO TABLE-ELEMENT-1          
              MOVE PARM-SERV-ORDER-NO       TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7400-CHECK-METERS                                              *        
      ******************************************************************        
      *                                                                         
       7400-CHECK-METERS.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-MTR-ROW-FND                                    
                FROM CSS_SO_MTR_CHG WITH(READUNCOMMITTED)                       
               WHERE SERV_ORDER_NO = :PARM-SERV-ORDER-NO                
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-MTR-ROW-FND                                            
MFA-TR*         FROM CSS_SO_MTR_CHG                                             
MFA-TR*        WHERE SERV_ORDER_NO = :PARM-SERV-ORDER-NO                        
MFA-TR*    FETCH FIRST 1 ROWS ONLY                                              
MFA-TR*    WITH UR                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE ZEROS                 TO WS-SERV-ORDER-NO         
              END-IF                                                    
           ELSE                                                         
              MOVE WS-PROGRAM-NAME          TO ABEND-PROGRAM            
              MOVE '7400'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_SO_MTR_CHG'         TO TABLE-1                  
              MOVE 'SERV_ORDER_NO'          TO TABLE-ELEMENT-1          
              MOVE PARM-SERV-ORDER-NO       TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 00205000
      *8000A-DEL-GTT-ROWS.                                            * 00205100
      ***************************************************************** 00205300
      *                                                                         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04886_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00205600
MFA-TR*        DELETE FROM SESSION.CSR04886_R1                          00205700
MFA-TR*    END-EXEC.                                                    00205800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
               WHEN OTHER                                               
                    MOVE WS-PROGRAM-NAME    TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04886_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                 00208200
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 00208500
      ******************************************************************900     
      * 8010-INSERT-GTT-R1.                                            *00218100
      ******************************************************************200     
      *                                                                         
       8010-INSERT-GTT-R1.                                              
      *                                                                 00218400
           EXEC SQL                                                     
              INSERT INTO #CSR04886_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,WORK_AREA_EXIST                                      
                  ,ADD_CHARGES                                          
                  ,RATES_REQUIRED                                       
                  ,BUSINESS_RULE_ID                                     
                  ,WANTED_BY_DATETIME                                   
                  ,ACCOUNT_NO_PRIOR                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-1                                     
                  ,:S-APPL-RETURN-CODE-1                                
                  ,:S-WORK-AREA-EXIST                                   
                  ,:S-ADD-CHARGES                                       
                  ,:S-RATES-REQUIRED                                    
                  ,:S-BUSINESS-RULE-ID                                  
                  ,:S-WANTED-BY-DATETIME                                
                  ,:S-ACCOUNT-NO-PRIOR                                  
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00218500
MFA-TR*       INSERT INTO SESSION.CSR04886_R1                           00218600
MFA-TR*          (                                                      00218700
MFA-TR*            RETURN_CODE                                          00218800
MFA-TR*           ,APPL_RETURN_CODE                                     00218900
MFA-TR*           ,WORK_AREA_EXIST                                      00219000
MFA-TR*           ,ADD_CHARGES                                                  
MFA-TR*           ,RATES_REQUIRED                                               
MFA-TR*           ,BUSINESS_RULE_ID                                             
MFA-TR*           ,WANTED_BY_DATETIME                                           
MFA-TR*           ,ACCOUNT_NO_PRIOR                                             
MFA-TR*          )                                                      00219300
MFA-TR*       VALUES                                                    00219400
MFA-TR*          (                                                      00219500
MFA-TR*            :S-RETURN-CODE-1                                     00219600
MFA-TR*           ,:S-APPL-RETURN-CODE-1                                00219700
MFA-TR*           ,:S-WORK-AREA-EXIST                                   00219800
MFA-TR*           ,:S-ADD-CHARGES                                               
MFA-TR*           ,:S-RATES-REQUIRED                                            
MFA-TR*           ,:S-BUSINESS-RULE-ID                                          
MFA-TR*           ,:S-WANTED-BY-DATETIME                                        
MFA-TR*           ,:S-ACCOUNT-NO-PRIOR                                          
MFA-TR*          )                                                      00220100
MFA-TR*    END-EXEC.                                                    00220200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = WS-YES          
              ADD +1                        TO  CTR-ROWS-RS1            
           ELSE                                                         
              MOVE WS-PROGRAM-NAME          TO  ABEND-PROGRAM           
              MOVE '8010'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE WS-YES                   TO  WS-ERR-INSRT-R1         
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04886_R1'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
        8010-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                                         
      * 8800-CHECK-RESULTS.                                                     
      ************************************************************              
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE 100                      TO S-RETURN-CODE-1          
              MOVE   0                      TO S-APPL-RETURN-CODE-1     
              PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT          
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      * 8900-SEND-DONE.                                                         
      ************************************************************              
       8900-SEND-DONE.                                                  
                                                                        
           MOVE WS-PROGRAM-NAME             TO ABEND-PROGRAM            
           MOVE '8900'                      TO ACTIVE-PARAGRAPH         
           MOVE 'OPEN'                      TO ABEND-FUNCTION           
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04886_R1'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 00229400
      * 9000-SEND-ERROR-RESULT                                        * 00229600
      ***************************************************************** 00229700
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
      *                                                                 00229900
            INITIALIZE GTT-RETURN-FIELDS.                               
            MOVE WS-ACTIVE-RETURN-CODE      TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1.         
            MOVE WS-APPL-RETURN-CODE        TO S-APPL-RETURN-CODE-1.    
            MOVE SQLERRMC                   TO ABEND-SQLERRMC.          
                                                                        
            EXEC SQL                                                    
                ROLLBACK                                                
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            IF SQLCODE = 0                                              
                CONTINUE                                                
            ELSE                                                        
                MOVE 'ROLLBACK'             TO ABEND-FUNCTION           
            END-IF.                                                     
                                                                        
            PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.        
            PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.         
      *                                                                 00232600
       9000-EXIT.                                                       
            EXIT.                                                       
      *                                                                 00232900
      ***************************************************************** 00233000
      * 9700-ABEND-PROCESSING.                                        * 00233100
      ***************************************************************** 00      
      *                                                                         
       9700-PROCESS-ABEND.                                              
      *                                                                 00233400
            PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT.         
            PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT.         
      *                                                                 00233700
       9700-EXIT.                                                       
            EXIT.                                                       
      *                                                                 00234000
      ******************************************************************00234100
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *00234200
      ******************************************************************00234300
      *                                                                         
           EXEC SQL                                                     00234400
              INCLUDE CPDSP300                                          00234500
           END-EXEC.                                                    00234600
HPCCDM*    EJECT                                                        00234700
      *                                                                         
      ******************************************************************00234800
      * 9999-END-PROGRAM.                                              *00234900
      ******************************************************************00235000
      *                                                                 00235100
       9999-END-PROGRAM.                                                
      *                                                                 00235300
            PERFORM 8800-CHECK-RESULTS          THRU 8800-EXIT.         
            PERFORM 8900-SEND-DONE              THRU 8900-EXIT.         
                                                                        
           
MSQ016        GOBACK.                                                    
      *                                                                 00235800
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00235800
