       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04885.                                     
COB303 DATE-WRITTEN.      DECEMBER 07, 2015.                            
       DATE-COMPILED.                                                   
                                                                        
      *****************************************************************         
      *                                                               *         
      *                SOUTH CAROLINA ELECTRIC & GAS                  *         
      *                                                               *         
      *****************************************************************         
      *                 P R O G R A M  S U M M A R Y                  *         
      *                                                               *         
      *  CIS MOD COLLECTION UPDATE PROCESS FOR THE BELOW TABLES.      *         
      *                                                               *         
      *  CSS_COLLECT_HIST                                             *         
      *  CSS_COLL_ACCT_INFO                                           *         
      *  CSS_COLL_HIST_DET                                            *         
      *                                                               *         
      *  PARM-ROW 1 - WILL CONTAIN ALL BRAND NEW PTP DTLS WITH ACTV.  *         
      *  PARM-ROW 2 - CONTAIN EXISTING PTP WITH ACTV OR PEDNING STAT. *         
      *  PARM-ROW 3 - CONTAIN EXISTING PTP WITH PENDING STATUS.       *         
      *  PARM-ROW 4 -  CONTAIN EXISTING PTP WITH PENDING STATUS.      *         
      *                                                               *         
      *                                                                         
      *  PARAMETERS                                                             
      *  INPUT                                                                  
      *         ACCOUNT_NO         CHAR(13)                                     
      *         QUEUE_ID           CHAR(04)                                     
      *         WORK_DATE          CHAR(10)                                     
      *         DO_NOT_CALL_FL     CHAR(01)                                     
      *         PERM_COMMENT_LEN   SMALLINT                                     
      *         PERM_COMMENT_TXT   CHAR(255)                                    
      *         PTP_COMMENT_LEN    SMALLINT                                     
      *         PTP_COMMENT_TEXT   CHAR(255)                                    
      *         USERID             CHAR(07)                                     
      *         NEW COLL ROW 1     CHAR(42)                                     
      *         PTP ROW 2          CHAR(42)                                     
      *         PTP ROW 3          CHAR(42)                                     
      *         PTP ROW 4          CHAR(42)                                     
      * CLONED FROM: CSR02514 AND CSR04399                                      
      *****************************************************************         
      *                                                                         
      *                     PROGRAM MODIFICATION LOG                            
      *                                                                         
      *    DATE    INITIALS   COMMENTS                                          
      *  --------  --------   ---------------------------------------           
P00885*  12/07/15   MR7E794   ORIGINAL CODE                                     
      *****************************************************************         
      *                                                                         
      *                ---- BASIC SEQUENCE STRUCTURE ----                       
      *                                                                         
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION                      
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                             
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                            
      *  3000 - 4999  NOT USED                                                  
      *  5000 - 5999  COMMON PROGRAM MODULES                                    
      *  6000 - 6999  COMMON SYSTEM MODULES                                     
      *  7000 - 7999  INPUT MODULES                                             
      *  8000 - 8999  OUTPUT MODULES                                            
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES                      
      *                                                                         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04885'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04885 STARTS HERE'.                  
                                                                        
      *****************************************************************         
      *    COBOL WORKING STORAGE COPY BOOKS                                     
      *****************************************************************         
      * COMMON SYSTEM AREA                                                      
           COPY CCA00001.                                                       
      * ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS                          
           COPY CWS00027.                                                       
      * SUPPORTS DB2 AND SQL ERROR CHECKING                                     
           COPY CWS00303.                                                       
      *                                                                         
      ****************************************************************          
      *    DB2 ERRROR PROCESSING COPYBOOK                            *          
      ****************************************************************          
           COPY CWSSP001.                                                       
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK                                    *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      ****** CWS00315 CONTAINS WS FOR FINDING NEXT BUSINESS DAY ****            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00315                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE FIOJC01                                                  
           END-EXEC.                                                            
                                                                        
      *       CWS00038 IS JC01 WORK DATA   *                                    
                                                                        
           EXEC SQL                                                             
               INCLUDE CWS00038                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00068                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00056                                                  
           END-EXEC.                                                            
      *****************************************************************         
      *    WORK AREAS                                                           
      *****************************************************************         
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04885'.     
           05  WS-PGRMNAME              PIC X(08) VALUE 'CSR04885'.     
           05  MCSCB068                 PIC  X(08) VALUE 'MCSCB068'.    
           05  WS-ACCOUNT-NO            PIC S9(13)V COMP-3 VALUE 0.     
           05  WS-PTP-AMT               PIC S9(09)V99 COMP-3 VALUE 0.   
           05  WS-RESULT-CD             PIC X(04) VALUE SPACES.         
           05  WS-COLL-HIST-DET         PIC X(01) VALUE 'N'.            
               88 COLL-HIST-DET-EXIST             VALUE 'Y'.            
               88 NO-COLL-HIST-DET                VALUE 'N'.            
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  WS-CURRENT-DATE-MMDDYY.                                  
               10  WS-CURR-DT-MM        PIC X(02) VALUE SPACES.         
               10  WS-CURR-DT-DD        PIC X(02) VALUE SPACES.         
               10  WS-CURR-DT-YY        PIC X(02) VALUE SPACES.         
           05  WS-TRAN-DATE             PIC X(10) VALUE SPACES.         
           05  WS-CURRENT-TIME          PIC X(08) VALUE SPACES.         
           05  WS-CURRENT-TIME-HHCMM.                                   
               10  WS-CURR-TIME-HH      PIC X(02) VALUE SPACES.         
               10  WS-CURR-TIME-CLN     PIC X(01) VALUE ':'.            
               10  WS-CURR-TIME-MM      PIC X(02) VALUE SPACES.         
      *    05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.                 
      *    05  WS-CURRENT-TIMESTAMP-R REDEFINES WS-CURRENT-TIMESTAMP.           
      *        10  FILLER                   PIC X(11).                          
      *        10  WS-CURR-TIME.                                                
      *            15  WS-CURR-HH           PIC X(02).                          
      *            15  WS-CURR-COLON        PIC X(01).                          
      *            15  WS-CURR-MM           PIC X(02).                          
      *        10  FILLER                   PIC X(10).                          
           05  WS-FUTURE-NO             PIC S9(9) USAGE COMP VALUE 0.   
           05  WS-FUTURE-WORK-DATE      PIC X(10) VALUE SPACES.         
           05  WS-PTP-DATE              PIC X(10) VALUE SPACES.         
           05  WS-PTP-AMT-C             PIC X(11) VALUE SPACES.         
           05  WS-PTP-AMT-N             REDEFINES WS-PTP-AMT-C          
                                        PIC 9(09)V99.                   
           05  WS-ARREARS-AMT           PIC S9(09)V99 COMP-3 VALUE 0.   
           05  WS-ARREARS-AMT-C         PIC X(11) VALUE SPACES.         
           05  WS-ARREARS-AMT-N         REDEFINES WS-ARREARS-AMT-C      
                                        PIC 9(09)V99.                   
           05  WS-PTP-EXISTS            PIC X(01) VALUE SPACES.         
           05 WS-TAB-PERM-COMM.                                         
              15 WS-PERM-COMM           PIC X(01)  OCCURS 512 TIMES.    
           05 WS-TAB-PTP-COMM.                                          
              15 WS-PTP-COMM            PIC X(01)  OCCURS 512 TIMES.    
           05 WS-MAX-LEN                PIC S9(04) COMP VALUE 512.      
           05 WS-PERM-TX-SUB            PIC S9(04) COMP VALUE 0.        
           05 WS-PTP-TX-SUB             PIC S9(04) COMP VALUE 0.        
           05 WS-DATE-MM-DD-YYYY.                                       
              10  WS-DATE-MM            PIC X(02) VALUE SPACES.         
              10  FILLER                PIC X(01) VALUE '/'.            
              10  WS-DATE-DD            PIC X(02) VALUE SPACES.         
              10  FILLER                PIC X(01) VALUE '/'.            
              10  WS-DATE-CCYY          PIC X(04) VALUE SPACES.         
                                                                        
       01  WS-PERM-PTP-COMM-LEN         PIC S9(04) COMP VALUE +512.     
       01  WS-PERM-PTP-COMM-TEXT.                                       
           05  WS-PERM-COMM-AREA-1      PIC X(255) VALUE SPACES.        
           05  WS-PTP-COMM-AREA-2       PIC X(255) VALUE SPACES.        
           05  FILLER                   PIC X(02)  VALUE SPACES.        
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-PROMISE-TO-PAY        PIC X(03) VALUE 'PP'.           
           05  WS-PROMISE-TO-MAIL       PIC X(03) VALUE 'PM'.           
           05  WS-PROMISE-TO-WIRE       PIC X(03) VALUE 'PW'.           
           05  WS-SPECIAL-PAYMENT       PIC X(02) VALUE 'SP'.           
           05  WS-ARRANGEMENTS          PIC X(02) VALUE 'AR'.           
           05  WS-BANKRUPTCY            PIC X(02) VALUE 'BK'.           
           05  WS-REFUSES-TO-PAY        PIC X(02) VALUE 'RP'.           
           05  WS-DISPUTE               PIC X(02) VALUE 'DS'.           
           05  WS-LEFT-MESSAGE          PIC X(02) VALUE 'LM'.           
           05  WS-NO-ANSWER             PIC X(02) VALUE 'NA'.           
           05  WS-BUSY                  PIC X(02) VALUE 'BZ'.           
           05  WS-DISCONNECTED-PHONE    PIC X(02) VALUE 'DP'.           
           05  WS-NOT-EMPLOYED          PIC X(02) VALUE 'NE'.           
           05  WS-WRONGNO-FOR-CUSTOMER  PIC X(02) VALUE 'WP'.           
           05  WS-DECEASED-CUSTOMER     PIC X(02) VALUE 'DC'.           
           05  WS-OTHER-RESULT          PIC X(02) VALUE 'OR'.           
           05  WS-YES                   PIC X(01) VALUE 'Y'.            
           05  WS-NO                    PIC X(01) VALUE 'N'.            
           05  WS-DASH                  PIC X(01) VALUE '-'.            
           05  WS-SLASH                 PIC X(01) VALUE '/'.            
           05  WS-SPACE                 PIC X(01) VALUE ' '.            
           05  WS-Z                     PIC X(01) VALUE 'Z'.            
           05  WS-PP                    PIC X(02) VALUE 'PP'.           
           05  WS-PM                    PIC X(02) VALUE 'PM'.           
           05  WS-PW                    PIC X(02) VALUE 'PW'.           
           05  WS-SP                    PIC X(02) VALUE 'SP'.           
           05  WS-AR                    PIC X(02) VALUE 'AR'.           
           05  WS-OR                    PIC X(02) VALUE 'OR'.           
           05  WS-PENDING               PIC X(01) VALUE 'P'.            
           05  WS-CANCELLED             PIC X(01) VALUE 'C'.            
           05  WS-BADDATA               PIC X(07) VALUE 'BADDATA'.      
           05  WS-ZERO                  PIC 9(04) VALUE 0.              
           05  WS-PTP-CMNT-MAX-LEN      PIC 9(04) VALUE 512.            
      *                                                                         
       01  WS-COLL-EXEMPT-CD.                                           
           05  WS-COLL-BANKRUPTCY       PIC X(01) VALUE SPACES.         
           05  WS-COLL-JUDGEMENT        PIC X(01) VALUE SPACES.         
           05  WS-COLL-CRED-BUREAU      PIC X(01) VALUE SPACES.         
           05  WS-COLL-DNP-EXEMPT       PIC X(01) VALUE SPACES.         
           05  WS-COLL-MED-CERT         PIC X(01) VALUE SPACES.         
           05  WS-COLL-DO-NOT-CALL      PIC X(01) VALUE SPACES.         
           05  WS-COLL-NOTICE-EXEMPT    PIC X(01) VALUE SPACES.         
           05  WS-COLL-WO-CRED-BUREAU   PIC X(01) VALUE SPACES.         
           05  WS-COLL-DECEASED         PIC X(01) VALUE SPACES.         
           05  WS-COLL-COND             PIC X(01) VALUE SPACES.         
           05  FILLER                   PIC X(10) VALUE SPACES.         
      *                                                                         
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  WS-PARM-FIELDS.                                              
           05  WS-PARM-TRANS-ID          PIC S9(13)V USAGE COMP-3       
                                                           VALUE 0.     
       01  SWITCHES.                                                    
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05  WS-HOLD-PTP-DATE          PIC X(10) VALUE SPACES.        
           05  WS-TEMP-DATE-R.                                          
               10  WS-TEMP-CCYY.                                        
                   15 WS-TEMP-CC         PIC X(02) VALUE SPACES.        
                   15 WS-TEMP-YY         PIC X(02) VALUE SPACES.        
               10  WS-SLASH-DASH1        PIC X(01) VALUE '-'.           
               10  WS-TEMP-MM            PIC X(02) VALUE SPACES.        
               10  WS-SLASH-DASH2        PIC X(01) VALUE '-'.           
               10  WS-TEMP-DD            PIC X(02) VALUE SPACES.        
           05  WS-MOVE-DATE.                                            
               10  WS-MOVE-MM            PIC X(02) VALUE SPACES.        
               10  WS-MOVE-DD            PIC X(02) VALUE SPACES.        
               10  WS-MOVE-CCYY.                                        
                   15 WS-MOVE-CC         PIC X(02) VALUE SPACES.        
                   15 WS-MOVE-YY         PIC X(02) VALUE SPACES.        
           05  WS-CANCELLED-ALL          PIC X(01) VALUE 'N'.           
      *01  WS-COMMENTS-TEXT              PIC X(512) VALUE SPACES.               
       01  WS-COMMENTS-AREA1-LEN         PIC 9(02)  VALUE 21.           
       01  WS-COMMENTS-AREA1-TEXT.                                      
           05  WS-COMM-DATE.                                            
               10 WS-COMM-DATE-MM        PIC X(02) VALUE SPACES.        
               10 WS-COMM-DATE-DD        PIC X(02) VALUE SPACES.        
               10 WS-COMM-DATE-YY        PIC X(02) VALUE SPACES.        
           05  FILLER                    PIC X(01) VALUE SPACES.        
           05  WS-COMM-TIME              PIC X(05) VALUE SPACES.        
           05  FILLER                    PIC X(01) VALUE SPACES.        
           05  WS-COMM-USERID            PIC X(07) VALUE SPACES.        
           05  FILLER                    PIC X(01) VALUE SPACES.        
       01  WS-COMMENTS-AREA2-TEXT.                                      
           05  WS-COMM-ACTION-CD         PIC X(02) VALUE SPACES.        
           05  FILLER                    PIC X(01) VALUE SPACES.        
           05  WS-COMM-RESULT-CD         PIC X(02) VALUE SPACES.        
           05  FILLER                    PIC X(01) VALUE SPACES.        
           05  WS-COMM-PTP-AMT           PIC 9(09)V99 VALUE ZEROS.      
           05  FILLER                    PIC X(01) VALUE SPACES.        
           05  WS-COMM-PTP-DT.                                          
               10  WS-COMM-PTP-MM        PIC X(02) VALUE SPACES.        
               10  WS-COMM-SLASH1        PIC X(01) VALUE SPACES.        
               10  WS-COMM-PTP-DD        PIC X(02) VALUE SPACES.        
               10  WS-COMM-SLASH2        PIC X(01) VALUE SPACES.        
               10  WS-COMM-PTP-CCYY      PIC X(04) VALUE SPACES.        
                                                                        
       01  WS-INSERT-COMMENTS-LEN        PIC S9(04) COMP VALUE +49.     
       01  WS-INSERT-COMMENTS-TEXT.                                     
           05  WS-I-COMM-AREA-1          PIC X(21) VALUE SPACES.        
           05  WS-I-COMM-AREA-2          PIC X(28) VALUE SPACES.        
       01  WS-CANCEL-COMMENTS-LEN        PIC S9(04) COMP VALUE +56.     
       01  WS-CANCEL-COMMENTS-TEXT.                                     
           05  WS-C-COMM-AREA-1          PIC X(21) VALUE SPACES.        
           05  FILLER                    PIC X(07)  VALUE 'CANCEL '.    
           05  WS-C-COMM-AREA-2          PIC X(28) VALUE SPACES.        
                                                                        
       01  WS-PARM-ROW-BREAKUP.                                         
           05  WS-IN-TRANS-ID            PIC X(13) VALUE SPACES.        
           05  WS-IN-COLL-ACTION-CD      PIC X(04) VALUE SPACES.        
           05  WS-IN-COLL-RESULT-CD      PIC X(04) VALUE SPACES.        
           05  WS-IN-PTP-DT              PIC X(08) VALUE SPACES.        
           05  WS-IN-PTP-AMT             PIC X(11) VALUE SPACES.        
           05  WS-IN-PTP-STATUS-CD       PIC X(01) VALUE SPACES.        
           05  WS-IN-COLL-CONDITION-CD   PIC X(01) VALUE SPACES.        
                                                                        
       01  WS-NULL-IND-VARS.                                            
           05  WS-NULL-IND1             PIC S9(04) COMP VALUE 0.        
           05  WS-NULL-IND2             PIC S9(04) COMP VALUE 0.        
           05  WS-NULL-IND3             PIC S9(04) COMP VALUE 0.        
           05  WS-NULL-IND4             PIC S9(04) COMP VALUE 0.        
           05  WS-NULL-INDICATOR-1      PIC S9(04) COMP VALUE 0.        
           05  WS-NULL-INDICATOR-2      PIC S9(04) COMP VALUE 0.        
           05  WS-NULL-INDICATOR-3      PIC S9(04) COMP VALUE 0.        
           05  WS-NULL-INDICATOR-4      PIC S9(04) COMP VALUE 0.        
           05  WS-COLL-EX-NULL-IND2     PIC S9(04) COMP VALUE 0.        
           05  WS-FINAL-NULL-IND        PIC S9(04) COMP VALUE +0.       
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
      *****************************************************************         
      * DATABASE DEFINITION                                                     
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_COLL_ACCT_INFO                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCINF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_COLL_HIST_DET                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCOLDET                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_COLLECT_HIST                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCOLHST                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_ACCOUNT                                                  *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_HOLIDAY                                                  *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBHLDAY                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_DELINQUENCY                                              *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_JOB_PARM                                                 *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
      *                                                                 02500000
      ******************************************************************02340000
      ***  CURSOR TO FETCH THE COLLECTIONS HISTORY FOR THE ACCT        *02350000
      ******************************************************************02360000
                                                                        
           EXEC SQL                                                     
             DECLARE COLLECT-DET CURSOR   FOR                           
             SELECT  LH.COLL_ACTION_CD,                                 
                     LH.COLL_RESULT_CD,                                 
                     LH.PTP_DT,                                         
                     LH.PTP_AMT,                                        
                     LH.PTP_ARREARS_AM,                                 
                     LH.PTP_OVERPYMT_AMT                                
             FROM CSS_COLL_HIST_DET LH WITH(READUNCOMMITTED)                    
             WHERE LH.ACCOUNT_NO       = :LH-ACCOUNT-NO                 
               AND LH.COLL_HIST_SEQ_TS = CIS.CHAR2TIMESTAMP(
                                                   :LH-COLL-HIST-SEQ-TS
              )           
               AND LH.PTP_STATUS_CD IN ('A','P')                        
               AND LH.PTP_DT           > IIF(TRY_CONVERT(DATE, 
                                                      :WS-HOLD-PTP-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-PTP-DATE
              ) <> 0) OR (LEN(:WS-HOLD-PTP-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-HOLD-PTP-DATE
              ), CONVERT(DATE, :WS-HOLD-PTP-DATE) )              
             FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     02380000
MFA-TR*      DECLARE COLLECT-DET CURSOR   FOR                           02390000
MFA-TR*      SELECT  LH.COLL_ACTION_CD,                                 02400000
MFA-TR*              LH.COLL_RESULT_CD,                                 02400000
MFA-TR*              LH.PTP_DT,                                         02410000
MFA-TR*              LH.PTP_AMT,                                        02420000
MFA-TR*              LH.PTP_ARREARS_AM,                                         
MFA-TR*              LH.PTP_OVERPYMT_AMT                                        
MFA-TR*      FROM CSS_COLL_HIST_DET LH                                  02460000
MFA-TR*      WHERE LH.ACCOUNT_NO       = :LH-ACCOUNT-NO                 02470000
MFA-TR*        AND LH.COLL_HIST_SEQ_TS = :LH-COLL-HIST-SEQ-TS                   
MFA-TR*        AND LH.PTP_STATUS_CD IN ('A','P')                                
MFA-TR*        AND LH.PTP_DT           > :WS-HOLD-PTP-DATE                      
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                    02490000
                                                                        
      ******************************************************************        
HPCCDM*EJECT                                                                    
                                                                        
       LINKAGE SECTION.                                                 
COB305 01 PARM-ACCOUNT-NUM        PIC S9(13)V COMP-3 VALUE 0.                  
       01 PARM-QUEUE-ID            PIC X(04).                           
       01 PARM-WORK-DATE           PIC X(10).                           
       01 PARM-DO-NOT-CALL-FL      PIC X(01).                           
       01 PARM-PERM-COMMENT-LEN    PIC S9(04) COMP.                     
       01 PARM-PERM-COMMENT-TXT    PIC X(254).                          
       01 PARM-PTP-COMMENT-LEN     PIC S9(04) COMP.                     
       01 PARM-PTP-COMMENT.                                             
          49 PARM-PTP-CMNT-LEN     PIC S9(04) USAGE COMP.               
          49 PARM-PTP-CMNT-TXT     PIC X(512).                          
       01 PARM-USERID              PIC X(07).                           
       01 PARM-NEW-COLL-ROW1       PIC X(42).                           
       01 PARM-PTP-ROW2            PIC X(42).                           
       01 PARM-PTP-ROW3            PIC X(42).                           
       01 PARM-PTP-ROW4            PIC X(42).                           
                                                                        
       PROCEDURE DIVISION USING PARM-ACCOUNT-NUM                        
                                PARM-QUEUE-ID                           
                                PARM-WORK-DATE                          
                                PARM-DO-NOT-CALL-FL                     
                                PARM-PERM-COMMENT-LEN                   
                                PARM-PERM-COMMENT-TXT                   
                                PARM-PTP-COMMENT-LEN                    
                                PARM-PTP-COMMENT                        
                                PARM-USERID                             
                                PARM-NEW-COLL-ROW1                      
                                PARM-PTP-ROW2                           
                                PARM-PTP-ROW3                           
                                PARM-PTP-ROW4.                          
                                                                        
      *****************************************************************         
      * 0000-MAINLINE                                                 *         
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                     *         
      *****************************************************************         
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 0100-INITIALIZE                                               *         
      *****************************************************************         
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR CONTINUE END-EXEC.                
           EXEC SQL WHENEVER NOT FOUND CONTINUE END-EXEC.               
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                   :S-RETURN-CODE          AS  RETURN_CODE              
               FROM                                                     
                   CIS.SYSDUMMY1                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            :S-RETURN-CODE          AS  RETURN_CODE                      
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 1000-PROCESS-INPUT.                                           *         
      *****************************************************************         
       1000-PROCESS-INPUT.                                              
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
           MOVE PARM-ACCOUNT-NUM              TO WS-ACCOUNT-NO          
                                                 AT-ACCOUNT-NO          
                                                 LH-ACCOUNT-NO          
                                                 IF-ACCOUNT-NO          
                                                 HC-ACCOUNT-NO          
                                                                        
           PERFORM 7000-GET-CURRENT-DATE         THRU 7000-EXIT.        
           MOVE WS-CURRENT-DATE             TO WS-TEMP-DATE-R.          
           MOVE WS-TEMP-MM                  TO WS-CURR-DT-MM.           
           MOVE WS-TEMP-DD                  TO WS-CURR-DT-DD.           
           MOVE WS-TEMP-YY                  TO WS-CURR-DT-YY.           
           MOVE WS-CURRENT-TIME(1:2)        TO WS-CURR-TIME-HH.         
           MOVE WS-CURRENT-TIME(4:2)        TO WS-CURR-TIME-MM.         
                                                                        
           PERFORM 7005-SELECT-ACCOUNT           THRU 7005-EXIT.        
                                                                        
      *    CALLING CPD00068 TO GET ARREARS, AND PAST DUE AMOUNT         23790000
                                                                        
           MOVE AT-CODES-DATA-PRESENT         TO WS-CODES-DATA-PRESENT. 
           MOVE WS-CURRENT-DATE               TO WS-HOLD-DATE.          
           MOVE WS-YES                        TO CALC-ARREARS-SW        
                                                 CALC-PAST-DUE-SW       
                                                 CALC-BALANCE-SW.       
                                                                        
           MOVE PROGRAM-NAME                 TO WS-CPD00068-CALLING-PGM.
           MOVE SPACES                        TO ABEND-FUNCTION.        
           PERFORM 6000-CALL-CPD00068            THRU 6000-EXIT.        
           MOVE S-RETURN-CODE                 TO WS-ACTIVE-RETURN-CODE, 
                                                 SQLCODE.               
           IF ABEND-FUNCTION  > SPACES                                  
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
           MOVE WS-AMT-PAST-DUE                  TO WS-ARREARS-AMT.     
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 2000-PROCESS-OUTPUT.                                          *         
      *****************************************************************         
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2020-INSERT-NEW-COLLECTION    THRU 2020-EXIT.        
           PERFORM 2030-UPDATE-PTP-DETAILS       THRU 2030-EXIT.        
                                                                        
           ADD +1                             TO CTR-ROWS.              
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *  2020-INSERT-NEW-COLLECTION.                                   *        
      ******************************************************************        
       2020-INSERT-NEW-COLLECTION.                                      
                                                                        
           INITIALIZE WS-PARM-ROW-BREAKUP.                              
           MOVE PARM-NEW-COLL-ROW1            TO WS-PARM-ROW-BREAKUP    
                                                                        
           MOVE WS-IN-PTP-AMT                 TO WS-PTP-AMT-C           
           IF  WS-PTP-AMT-N IS NUMERIC                                  
               MOVE WS-PTP-AMT-N              TO WS-PTP-AMT             
           ELSE                                                         
               MOVE WS-ZERO                   TO WS-PTP-AMT             
           END-IF.                                                      
                                                                        
           IF WS-IN-TRANS-ID IS NUMERIC                                 
               MOVE WS-IN-TRANS-ID            TO WS-PARM-TRANS-ID       
           END-IF.                                                      
                                                                        
           MOVE PARM-QUEUE-ID                 TO HC-CALL-QUEUE-ID       
           PERFORM 7100-GET-COLL-HIST-SEQ        THRU 7100-EXIT         
                                                                        
           PERFORM 7110-GET-MAX-TRANS-ID         THRU 7110-EXIT         
           IF ((WS-PARM-TRANS-ID = LH-TRANS-ID) OR                      
               (WS-PARM-TRANS-ID = 0))                                  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 500                        TO S-RETURN-CODE          
              ADD +1                          TO CTR-ROWS               
              PERFORM 9999-END-PROGRAM           THRU 9999-EXIT         
           END-IF.                                                      
                                                                        
           MOVE WS-CURRENT-DATE               TO WS-TRAN-DATE.          
           PERFORM 5100-UPDATE-COLL-ACCT-INFO    THRU 5100-EXIT.        
                                                                        
                                                                        
           MOVE WS-IN-COLL-RESULT-CD          TO WS-RESULT-CD           
                                                                        
           IF (PARM-PTP-CMNT-TXT GREATER THAN SPACES AND                
               PARM-NEW-COLL-ROW1 EQUAL SPACES AND                      
               PARM-PTP-ROW2      EQUAL SPACES AND                      
               PARM-PTP-ROW3      EQUAL SPACES AND                      
               PARM-PTP-ROW4      EQUAL SPACES ) OR                     
               PARM-NEW-COLL-ROW1 GREATER THAN SPACES                   
                                                                        
              IF WS-RESULT-CD GREATER THAN SPACES                       
                 PERFORM 5200-COLL-HIST-UPDT     THRU 5200-EXIT         
              ELSE                                                      
                 MOVE WS-ZERO                 TO LH-PTP-AMT             
              END-IF                                                    
                                                                        
              PERFORM 5300-PROCESS-COLL-HIST-DETL THRU 5300-EXIT        
           END-IF.                                                      
                                                                        
           IF WS-RESULT-CD EQUAL SPACES AND                             
              PARM-WORK-DATE GREATER THAN SPACES                        
              PERFORM 8500-UPDATE-WORK-DATE       THRU 8500-EXIT        
           END-IF.                                                      
                                                                        
       2020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2030-UPDATE-PTP-DETAILS.                                       *        
      ******************************************************************        
       2030-UPDATE-PTP-DETAILS.                                         
                                                                        
           MOVE HC-COLL-HIST-SEQ-TS      TO LH-COLL-HIST-SEQ-TS.        
                                                                        
           MOVE PARM-USERID              TO LH-LAST-UPDATE-USERID-TEXT  
                                            HC-LAST-UPDATE-USERID-TEXT  
                                            LH-COLL-AGENT-ID-TEXT.      
                                                                        
           MOVE +7                       TO LH-LAST-UPDATE-USERID-LEN   
                                            HC-LAST-UPDATE-USERID-LEN   
                                            LH-COLL-AGENT-ID-LEN.       
                                                                        
      *    PROCESS OF PTP ROW 2                                                 
           INITIALIZE WS-PARM-ROW-BREAKUP.                              
                                                                        
           IF PARM-PTP-ROW2 GREATER THAN SPACES                         
              MOVE PARM-PTP-ROW2              TO WS-PARM-ROW-BREAKUP    
              PERFORM 2100-LOAD-PTP-INFO         THRU 2100-EXIT         
           END-IF.                                                      
                                                                        
      *    PROCESS OF PTP ROW 3                                                 
           INITIALIZE WS-PARM-ROW-BREAKUP.                              
                                                                        
           IF PARM-PTP-ROW3 > SPACES AND WS-CANCELLED-ALL EQUAL WS-NO   
              MOVE PARM-PTP-ROW3              TO WS-PARM-ROW-BREAKUP    
              PERFORM 2100-LOAD-PTP-INFO         THRU 2100-EXIT         
           END-IF.                                                      
                                                                        
      *    PROCESS OF PTP ROW 4                                                 
           INITIALIZE WS-PARM-ROW-BREAKUP.                              
                                                                        
           IF PARM-PTP-ROW4 > SPACES AND WS-CANCELLED-ALL EQUAL WS-NO   
              MOVE PARM-PTP-ROW4              TO WS-PARM-ROW-BREAKUP    
              PERFORM 2100-LOAD-PTP-INFO         THRU 2100-EXIT         
           END-IF.                                                      
                                                                        
       2030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 08310000
      * 2100-LOAD-PTP-INFO                                            * 08320000
      *                                                               * 08330000
      ***************************************************************** 08340000
       2100-LOAD-PTP-INFO.                                              
                                                                        
           MOVE WS-ACCOUNT-NO                 TO LH-ACCOUNT-NO          
                                                 HC-ACCOUNT-NO.         
           IF WS-IN-TRANS-ID IS NUMERIC                                 
              MOVE WS-IN-TRANS-ID             TO WS-PARM-TRANS-ID       
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '2100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'RECEIVE INPUT'            TO ABEND-FUNCTION         
              MOVE 'TRANS_ID'                 TO TABLE-ELEMENT-1        
              MOVE WS-IN-TRANS-ID             TO HOSTVAR-ELEMENT-1      
              MOVE +1000                      TO WS-ACTIVE-RETURN-CODE  
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
           MOVE WS-IN-PTP-AMT                 TO WS-PTP-AMT-C           
                                                                        
           IF  WS-PTP-AMT-N IS NUMERIC                                  
               MOVE WS-PTP-AMT-N              TO WS-PTP-AMT             
           ELSE                                                         
                MOVE PROGRAM-NAME             TO ABEND-PROGRAM          
                MOVE '2100'                   TO ACTIVE-PARAGRAPH       
                MOVE 'RECEIVE INPUT'          TO ABEND-FUNCTION         
                MOVE 'PTP-AMT'                TO TABLE-ELEMENT-1        
                MOVE WS-IN-TRANS-ID           TO HOSTVAR-ELEMENT-1      
                MOVE +1000                    TO WS-ACTIVE-RETURN-CODE  
                PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
           ADD +1                        TO LH-TRANS-ID.                
           MOVE WS-IN-COLL-RESULT-CD     TO LH-COLL-RESULT-CD.          
           MOVE WS-IN-COLL-ACTION-CD     TO LH-COLL-ACTION-CD.          
           MOVE ZEROS                    TO LH-PTP-ARREARS-AM           
                                            LH-PTP-OVERPYMT-AMT.        
                                                                        
           MOVE WS-CURRENT-DATE          TO LH-RECORD-CREATION-DT       
                                            LH-LAST-UPDATE-DT           
                                            HC-LAST-UPDATE-DT.          
                                                                        
           MOVE WS-IN-PTP-STATUS-CD      TO LH-PTP-STATUS-CD.           
                                                                        
           MOVE WS-IN-PTP-DT             TO WS-MOVE-DATE.               
           MOVE WS-MOVE-MM               TO WS-TEMP-MM.                 
           MOVE WS-MOVE-DD               TO WS-TEMP-DD.                 
           MOVE WS-MOVE-CCYY             TO WS-TEMP-CCYY.               
           MOVE WS-TEMP-DATE-R           TO LH-PTP-DT                   
                                            WS-HOLD-PTP-DATE.           
                                                                        
           MOVE WS-PTP-AMT               TO LH-PTP-AMT.                 
                                                                        
           INITIALIZE WS-COMMENTS-AREA1-TEXT                            
                      WS-COMMENTS-AREA2-TEXT                            
                      WS-INSERT-COMMENTS-TEXT                           
                      WS-CANCEL-COMMENTS-TEXT.                          
      *                                                                         
           PERFORM 2110-BUILD-COMMENTS   THRU 2110-EXIT.                
           IF WS-IN-PTP-STATUS-CD EQUAL WS-PENDING                      
              MOVE WS-COMMENTS-AREA1-TEXT   TO WS-I-COMM-AREA-1         
              MOVE WS-COMMENTS-AREA2-TEXT   TO WS-I-COMM-AREA-2         
              MOVE WS-INSERT-COMMENTS-TEXT  TO LH-COMMENTS-TX-TEXT      
              IF PARM-PTP-COMMENT-LEN > (WS-PTP-CMNT-MAX-LEN -          
                                         WS-INSERT-COMMENTS-LEN)        
                 MOVE WS-PTP-CMNT-MAX-LEN   TO LH-COMMENTS-TX-LEN       
                 MOVE PARM-PTP-CMNT-TXT     TO LH-COMMENTS-TX-TEXT      
                     (50:(WS-PTP-CMNT-MAX-LEN - WS-INSERT-COMMENTS-LEN))
              ELSE                                                      
                 COMPUTE LH-COMMENTS-TX-LEN = PARM-PTP-COMMENT-LEN +    
                                              WS-INSERT-COMMENTS-LEN    
                 MOVE PARM-PTP-CMNT-TXT     TO LH-COMMENTS-TX-TEXT      
                                               (50:PARM-PTP-COMMENT-LEN)
              END-IF                                                    
              PERFORM 8300-INSERT-COLL-HIST-DET                         
                                            THRU 8300-EXIT              
           ELSE                                                         
              MOVE WS-COMMENTS-AREA1-TEXT   TO WS-C-COMM-AREA-1         
              MOVE WS-COMMENTS-AREA2-TEXT   TO WS-C-COMM-AREA-2         
              MOVE WS-CANCEL-COMMENTS-TEXT  TO LH-COMMENTS-TX-TEXT      
              IF PARM-PTP-COMMENT-LEN > (WS-PTP-CMNT-MAX-LEN -          
                                         WS-CANCEL-COMMENTS-LEN)        
                 MOVE WS-PTP-CMNT-MAX-LEN   TO LH-COMMENTS-TX-LEN       
                 MOVE PARM-PTP-CMNT-TXT     TO LH-COMMENTS-TX-TEXT      
                    (57:(WS-PTP-CMNT-MAX-LEN - WS-CANCEL-COMMENTS-LEN)) 
              ELSE                                                      
                 COMPUTE LH-COMMENTS-TX-LEN = PARM-PTP-COMMENT-LEN +    
                                              WS-CANCEL-COMMENTS-LEN    
                 MOVE PARM-PTP-CMNT-TXT     TO LH-COMMENTS-TX-TEXT      
                                               (57:PARM-PTP-COMMENT-LEN)
              END-IF                                                    
              PERFORM 8300-INSERT-COLL-HIST-DET                         
                                            THRU 8300-EXIT              
              PERFORM 7300-OPEN-COLL-CSR    THRU 7300-EXIT              
              PERFORM 7400-FETCH-COLL-CSR   THRU 7400-EXIT              
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
                 ADD +1                        TO LH-TRANS-ID           
                 MOVE WS-CANCELLED             TO LH-PTP-STATUS-CD      
                 PERFORM 2110-BUILD-COMMENTS   THRU 2110-EXIT           
                 MOVE WS-COMMENTS-AREA1-TEXT   TO WS-C-COMM-AREA-1      
                 MOVE WS-COMMENTS-AREA2-TEXT   TO WS-C-COMM-AREA-2      
                 MOVE WS-CANCEL-COMMENTS-TEXT  TO LH-COMMENTS-TX-TEXT   
                 IF PARM-PTP-COMMENT-LEN > (WS-PTP-CMNT-MAX-LEN -       
                                            WS-CANCEL-COMMENTS-LEN)     
                    MOVE WS-PTP-CMNT-MAX-LEN   TO LH-COMMENTS-TX-LEN    
                    MOVE PARM-PTP-CMNT-TXT     TO LH-COMMENTS-TX-TEXT   
                     (57:(WS-PTP-CMNT-MAX-LEN - WS-CANCEL-COMMENTS-LEN))
                 ELSE                                                   
                    COMPUTE LH-COMMENTS-TX-LEN = PARM-PTP-COMMENT-LEN + 
                                                 WS-CANCEL-COMMENTS-LEN 
                    MOVE PARM-PTP-CMNT-TXT     TO LH-COMMENTS-TX-TEXT   
                                               (57:PARM-PTP-COMMENT-LEN)
                 END-IF                                                 
                 PERFORM 8300-INSERT-COLL-HIST-DET                      
                                               THRU 8300-EXIT           
                 PERFORM 7400-FETCH-COLL-CSR   THRU 7400-EXIT           
              END-PERFORM                                               
              PERFORM 7500-CLOSE-COLL-CSR      THRU 7500-EXIT           
              PERFORM 8350-CAN-EXISTING-ROW    THRU 8350-EXIT           
              PERFORM 7450-CHECK-ACTIVE-PTP    THRU 7450-EXIT           
              IF WS-PTP-EXISTS = WS-YES                                 
                 CONTINUE                                               
              ELSE                                                      
                 MOVE WS-CURRENT-DATE          TO WS-NEW-BUSINESS-DAY   
                 PERFORM 7250-GET-PREV-BUSINESS-DAY THRU 7250-EXIT      
                 PERFORM 6500-GET-NEXT-BUSINESS-DAY                     
                    THRU 6500-NEXT-BUSINESS-DAY-EXIT                    
                   UNTIL NEXT-BUSINESS-DAY-FOUND                        
                 MOVE WS-NEW-BUSINESS-DAY      TO HC-FUTURE-WORK-DT     
                 PERFORM 8400-UPDATE-COLLECT-HIST  THRU 8400-EXIT       
                 MOVE WS-YES                   TO WS-CANCELLED-ALL      
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE WS-DASH                      TO WS-SLASH-DASH1          
                                                WS-SLASH-DASH2.         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08560000
      ******************************************************************08570000
      * 2110-BUILD-COMMENTS                                            *08580000
      ******************************************************************08610000
       2110-BUILD-COMMENTS.                                             
                                                                        
           MOVE WS-CURRENT-DATE-MMDDYY      TO WS-COMM-DATE.            
           MOVE WS-CURRENT-TIME-HHCMM       TO WS-COMM-TIME.            
           MOVE PARM-USERID                 TO WS-COMM-USERID.          
           MOVE LH-COLL-ACTION-CD           TO WS-COMM-ACTION-CD.       
           MOVE LH-COLL-RESULT-CD           TO WS-COMM-RESULT-CD.       
           MOVE LH-PTP-AMT                  TO WS-COMM-PTP-AMT.         
           IF LH-PTP-DT > SPACES                                        
              MOVE LH-PTP-DT                TO WS-TEMP-DATE-R           
           ELSE                                                         
              MOVE '0000-00-00'             TO WS-TEMP-DATE-R           
           END-IF                                                       
           MOVE WS-TEMP-MM                  TO WS-COMM-PTP-MM.          
           MOVE WS-TEMP-DD                  TO WS-COMM-PTP-DD.          
           MOVE WS-TEMP-YY                  TO WS-COMM-PTP-CCYY.        
           MOVE WS-SLASH                    TO WS-SLASH-DASH1           
                                               WS-SLASH-DASH2           
                                               WS-COMM-SLASH1           
                                               WS-COMM-SLASH2.          
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2120-TRIM-COMM-TEXT.                                           *        
      ******************************************************************        
      *                                                                         
      *2120-TRIM-COMM-TEXT.                                                     
      *                                                                         
      *    MOVE SPACES                       TO WS-TAB-PERM-COMM.               
      *                                                                         
      *    MOVE PARM-PERM-COMMENT-TXT        TO WS-TAB-PERM-COMM.               
      *    MOVE WS-MAX-LEN                   TO WS-PERM-TX-SUB.                 
      *                                                                         
      *    PERFORM UNTIL WS-PERM-COMM(WS-PERM-TX-SUB) > SPACES                  
      *                               OR WS-PERM-TX-SUB  = 0                    
      *            COMPUTE WS-PERM-TX-SUB = WS-PERM-TX-SUB - 1                  
      *    END-PERFORM.                                                         
      *                                                                         
      *    MOVE SPACES                       TO WS-TAB-PTP-COMM.                
      *                                                                         
      *    MOVE PARM-PTP-CMNT-TXT            TO WS-TAB-PTP-COMM.                
      *    MOVE WS-MAX-LEN                   TO WS-PTP-TX-SUB.                  
      *                                                                         
      *    PERFORM UNTIL WS-PTP-COMM(WS-PTP-TX-SUB) > SPACES                    
      *                               OR WS-PTP-TX-SUB  = 0                     
      *            COMPUTE WS-PTP-TX-SUB = WS-PTP-TX-SUB - 1                    
      *    END-PERFORM.                                                         
      *                                                                         
      *                                                                         
      *2120-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 5100-UPDATE-COLL-ACCT-INFO.                                    *        
      ******************************************************************        
       5100-UPDATE-COLL-ACCT-INFO.                                      
                                                                        
      *    THIS PROCESS DETERMINE THE COLL_EXEMPTION_CD BASED ON                
      *    PASSED INPUT DO NOT CALL FLAG AND COLLECTION CONDITION CODE.         
      *    AND UPDATE THE PERM COMMENTS INTO COLL INFO TABLE.                   
                                                                        
           PERFORM 7200-GET-COLL-EXEMPT-CD    THRU 7200-EXIT            
           MOVE IF-COLL-EXEMPTION-CD       TO WS-COLL-EXEMPT-CD         
           IF PARM-DO-NOT-CALL-FL = WS-ZERO                             
              MOVE SPACES                  TO WS-COLL-DO-NOT-CALL       
           ELSE                                                         
              MOVE PARM-DO-NOT-CALL-FL     TO WS-COLL-DO-NOT-CALL       
           END-IF                                                       
                                                                        
           IF WS-IN-COLL-CONDITION-CD > SPACES                          
              IF WS-IN-COLL-CONDITION-CD EQUAL WS-Z                     
                 MOVE SPACES               TO WS-COLL-COND              
              ELSE                                                      
                 MOVE WS-IN-COLL-CONDITION-CD                           
                                           TO WS-COLL-COND              
              END-IF                                                    
           END-IF                                                       
                                                                        
           MOVE WS-COLL-EXEMPT-CD          TO IF-COLL-EXEMPTION-CD      
           MOVE WS-CURRENT-DATE            TO IF-LAST-UPDATE-DT         
           MOVE PARM-USERID                TO IF-LAST-UPDATE-USERID-TEXT
           MOVE +7                         TO IF-LAST-UPDATE-USERID-LEN 
           PERFORM 8020-UPDT-EXEMPT-CD        THRU 8020-EXIT            
                                                                        
           IF  PARM-PERM-COMMENT-TXT > SPACES                           
               MOVE PARM-PERM-COMMENT-LEN  TO IF-COLL-COMMENT-TX-LEN    
               MOVE PARM-PERM-COMMENT-TXT  TO IF-COLL-COMMENT-TX-TEXT   
               MOVE WS-CURRENT-DATE        TO IF-LAST-UPDATE-DT         
               MOVE PARM-USERID            TO IF-LAST-UPDATE-USERID-TEXT
               MOVE +7                     TO IF-LAST-UPDATE-USERID-LEN 
               PERFORM 8030-UPDATE-PERM-COMMENTS                        
                                              THRU 8030-EXIT            
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 5200-UPDATE-COLL-HIST-UPDT.                                    *        
      ******************************************************************        
       5200-COLL-HIST-UPDT.                                             
                                                                        
           MOVE PARM-QUEUE-ID                 TO HC-CALL-QUEUE-ID       
           MOVE WS-ACCOUNT-NO                 TO HC-ACCOUNT-NO          
           MOVE WS-IN-COLL-RESULT-CD          TO HC-QUEUE-STATUS-CD     
           MOVE WS-TRAN-DATE                  TO HC-QUEUE-STATUS-DT     
                                                 HC-LAST-UPDATE-DT      
           MOVE PARM-USERID                   TO                        
                                              HC-LAST-UPDATE-USERID-TEXT
           MOVE +7                            TO                        
                                              HC-LAST-UPDATE-USERID-LEN 
                                                                        
           EVALUATE WS-RESULT-CD                                        
               WHEN WS-PROMISE-TO-PAY                                   
                   MOVE 'CQ-DAY-PP-FOLLOW-UP' TO C8-DELINQ-CD           
                   PERFORM 5210-UPDT-FUTURE-WORK-DT THRU 5210-EXIT      
               WHEN WS-PROMISE-TO-MAIL                                  
                   MOVE 'CQ-DAY-PM-FOLLOW-UP' TO C8-DELINQ-CD           
                   PERFORM 5210-UPDT-FUTURE-WORK-DT THRU 5210-EXIT      
               WHEN WS-PROMISE-TO-WIRE                                  
                   MOVE 'CQ-DAY-PW-FOLLOW-UP' TO C8-DELINQ-CD           
                   PERFORM 5210-UPDT-FUTURE-WORK-DT THRU 5210-EXIT      
               WHEN WS-SPECIAL-PAYMENT                                  
                   MOVE 'CQ-DAY-SP-FOLLOW-UP' TO C8-DELINQ-CD           
                   PERFORM 5210-UPDT-FUTURE-WORK-DT THRU 5210-EXIT      
               WHEN WS-ARRANGEMENTS                                     
                   MOVE 'CQ-DAY-AR-FOLLOW-UP' TO C8-DELINQ-CD           
                   PERFORM 5210-UPDT-FUTURE-WORK-DT THRU 5210-EXIT      
               WHEN WS-BANKRUPTCY                                       
                   MOVE 'CQ-DAY-BK-FOLLOW-UP' TO C8-DELINQ-CD           
                   PERFORM 5210-UPDT-FUTURE-WORK-DT THRU 5210-EXIT      
               WHEN WS-REFUSES-TO-PAY                                   
                   MOVE 'CQ-DAY-RP-FOLLOW-UP' TO C8-DELINQ-CD           
                   PERFORM 5210-UPDT-FUTURE-WORK-DT THRU 5210-EXIT      
               WHEN WS-DISPUTE                                          
                   MOVE 'CQ-DAY-DS-FOLLOW-UP' TO C8-DELINQ-CD           
                   PERFORM 5210-UPDT-FUTURE-WORK-DT THRU 5210-EXIT      
               WHEN WS-LEFT-MESSAGE                                     
                   MOVE 'CQ-DAY-LM-FOLLOW-UP' TO C8-DELINQ-CD           
                   PERFORM 5210-UPDT-FUTURE-WORK-DT THRU 5210-EXIT      
                   MOVE LOW-VALUES      TO LH-PTP-DT                    
                   MOVE ZEROS           TO LH-PTP-AMT                   
               WHEN WS-NO-ANSWER                                        
                   MOVE 'CQ-DAY-NA-FOLLOW-UP' TO C8-DELINQ-CD           
                   PERFORM 5210-UPDT-FUTURE-WORK-DT THRU 5210-EXIT      
                   MOVE LOW-VALUES      TO LH-PTP-DT                    
                   MOVE ZEROS           TO LH-PTP-AMT                   
               WHEN WS-BUSY                                             
                   MOVE 'CQ-DAY-BZ-FOLLOW-UP' TO C8-DELINQ-CD           
                   PERFORM 5210-UPDT-FUTURE-WORK-DT THRU 5210-EXIT      
                   MOVE LOW-VALUES      TO LH-PTP-DT                    
                   MOVE ZEROS           TO LH-PTP-AMT                   
               WHEN WS-DISCONNECTED-PHONE                               
                   MOVE 'CQ-DAY-DP-FOLLOW-UP' TO C8-DELINQ-CD           
                   PERFORM 5210-UPDT-FUTURE-WORK-DT THRU 5210-EXIT      
                   MOVE LOW-VALUES      TO LH-PTP-DT                    
                   MOVE ZEROS           TO LH-PTP-AMT                   
               WHEN WS-NOT-EMPLOYED                                     
                   MOVE 'CQ-DAY-NE-FOLLOW-UP' TO C8-DELINQ-CD           
                   PERFORM 5210-UPDT-FUTURE-WORK-DT THRU 5210-EXIT      
                   MOVE LOW-VALUES      TO LH-PTP-DT                    
                   MOVE ZEROS           TO LH-PTP-AMT                   
               WHEN WS-WRONGNO-FOR-CUSTOMER                             
                   MOVE 'CQ-DAY-WP-FOLLOW-UP' TO C8-DELINQ-CD           
                   PERFORM 5210-UPDT-FUTURE-WORK-DT THRU 5210-EXIT      
                   MOVE LOW-VALUES      TO LH-PTP-DT                    
                   MOVE ZEROS           TO LH-PTP-AMT                   
               WHEN WS-DECEASED-CUSTOMER                                
                   MOVE 'CQ-DAY-DC-FOLLOW-UP' TO C8-DELINQ-CD           
                   PERFORM 5210-UPDT-FUTURE-WORK-DT THRU 5210-EXIT      
                   MOVE LOW-VALUES      TO LH-PTP-DT                    
                   MOVE ZEROS           TO LH-PTP-AMT                   
               WHEN WS-OTHER-RESULT                                     
                   MOVE 'CQ-DAY-OR-FOLLOW-UP' TO C8-DELINQ-CD           
                   PERFORM 5210-UPDT-FUTURE-WORK-DT THRU 5210-EXIT      
               WHEN '0'                                                 
               WHEN ' '                                                 
                   MOVE LOW-VALUES      TO LH-PTP-DT                    
                   MOVE ZEROS           TO LH-PTP-AMT                   
               WHEN OTHER                                               
                   MOVE WS-RESULT-CD    TO HC-QUEUE-STATUS-CD           
                   MOVE LOW-VALUES      TO LH-PTP-DT                    
                   MOVE ZEROS           TO LH-PTP-AMT                   
                   PERFORM  8210-UPDATE-QUEUE-STATUS                    
                                        THRU 8210-EXIT                  
           END-EVALUATE.                                                
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5210-UPDT-FUTURE-WORK-DT                                       *        
      *     -- THIS MODULE SETS THE THE FUTURE WORK DT FOR COLLECT HIST*        
      *        BASED ON THE NO OF FOLLOW UP DAYS FROM DELINQUENCY TABLE*        
      ******************************************************************        
       5210-UPDT-FUTURE-WORK-DT.                                        
      *                                                                         
           MOVE AT-COMPANY-NO             TO C8-COMPANY-NO.             
           IF PARM-WORK-DATE EQUAL SPACE                                
              PERFORM 7020-GET-DELINQUENCY-VALUE THRU 7020-EXIT         
              MOVE C8-DELINQ-VALUE           TO WS-FUTURE-NO            
              IF  WS-IN-PTP-DT > SPACES                                 
                  MOVE WS-IN-PTP-DT(1:2)  TO WS-DATE-MM                 
                  MOVE WS-IN-PTP-DT(3:2)  TO WS-DATE-DD                 
                  MOVE WS-IN-PTP-DT(5:4)  TO WS-DATE-CCYY               
                  MOVE WS-DATE-MM-DD-YYYY TO WS-PTP-DATE                
              ELSE                                                      
                 IF  WS-RESULT-CD = WS-AR OR WS-OR                      
                     MOVE WS-RESULT-CD      TO HC-QUEUE-STATUS-CD       
                     PERFORM 8210-UPDATE-QUEUE-STATUS                   
                                            THRU 8210-EXIT              
                     IF  WS-IN-PTP-DT  > SPACES                         
                         MOVE WS-IN-PTP-DT         TO WS-MOVE-DATE      
                         MOVE WS-MOVE-MM           TO WS-TEMP-MM        
                         MOVE WS-MOVE-DD           TO WS-TEMP-DD        
                         MOVE WS-MOVE-CCYY         TO WS-TEMP-CCYY      
                         MOVE WS-TEMP-DATE-R       TO LH-PTP-DT         
                     ELSE                                               
                         MOVE LOW-VALUES    TO LH-PTP-DT                
                     END-IF                                             
                     IF  WS-PTP-AMT > ZEROS                             
                         MOVE WS-PTP-AMT    TO LH-PTP-AMT               
                     ELSE                                               
                         MOVE ZEROS         TO LH-PTP-AMT               
                     END-IF                                             
                     GO TO 5210-EXIT                                    
                 ELSE                                                   
                     MOVE WS-TRAN-DATE      TO WS-PTP-DATE              
                 END-IF                                                 
              END-IF                                                    
      * 1 DAY IS SUBTRACTED FROM THE FUTURE FOLLOW UP DAYS AS COPYBOOK          
      * CPD0315B RETURNS NEXT BUSINESS DAY                                      
              SUBTRACT 1                   FROM WS-FUTURE-NO            
              PERFORM 7030-GET-FUTURE-WORK-DATE                         
                                           THRU 7030-EXIT               
              MOVE WS-FUTURE-WORK-DATE     TO WS-NEW-BUSINESS-DAY       
              PERFORM 6500-GET-NEXT-BUSINESS-DAY                        
                 THRU 6500-NEXT-BUSINESS-DAY-EXIT                       
                 UNTIL NEXT-BUSINESS-DAY-FOUND                          
           ELSE                                                         
              MOVE PARM-WORK-DATE    TO  WS-NEW-BUSINESS-DAY            
           END-IF                                                       
                                                                        
           PERFORM 7450-CHECK-ACTIVE-PTP THRU 7450-EXIT.                
           IF WS-PTP-EXISTS = WS-YES                                    
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-NEW-BUSINESS-DAY     TO HC-FUTURE-WORK-DT        
               PERFORM 8200-UPDATE-COLLECT-HIST                         
                                            THRU 8200-EXIT              
           END-IF.                                                      
           IF  WS-IN-PTP-DT  > SPACES                                   
               MOVE WS-IN-PTP-DT        TO WS-MOVE-DATE                 
               MOVE WS-MOVE-MM          TO WS-TEMP-MM                   
               MOVE WS-MOVE-DD          TO WS-TEMP-DD                   
               MOVE WS-MOVE-CCYY        TO WS-TEMP-CCYY                 
               MOVE WS-TEMP-DATE-R      TO LH-PTP-DT                    
           ELSE                                                         
               MOVE WS-TRAN-DATE        TO LH-PTP-DT                    
           END-IF.                                                      
           IF  WS-PTP-AMT > ZEROS                                       
               MOVE WS-PTP-AMT          TO LH-PTP-AMT                   
           ELSE                                                         
               MOVE ZEROS               TO LH-PTP-AMT                   
           END-IF.                                                      
                                                                        
       5210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5300-PROCESS-COLL-HIST-DETL                                    *        
      ******************************************************************        
       5300-PROCESS-COLL-HIST-DETL.                                     
                                                                        
           INITIALIZE WS-COMMENTS-AREA1-TEXT                            
                      WS-COMMENTS-AREA2-TEXT                            
                                                                        
           MOVE PARM-QUEUE-ID                 TO HC-CALL-QUEUE-ID       
           PERFORM 7100-GET-COLL-HIST-SEQ        THRU 7100-EXIT         
                                                                        
           MOVE WS-ACCOUNT-NO                 TO LH-ACCOUNT-NO          
           PERFORM 7110-GET-MAX-TRANS-ID         THRU 7110-EXIT         
           IF  COLL-HIST-DET-EXIST                                      
               ADD 1                          TO LH-TRANS-ID            
           ELSE                                                         
               MOVE 1                         TO LH-TRANS-ID            
           END-IF                                                       
                                                                        
           MOVE HC-COLL-HIST-SEQ-TS           TO LH-COLL-HIST-SEQ-TS    
           MOVE WS-IN-COLL-RESULT-CD          TO LH-COLL-RESULT-CD      
           IF  LH-COLL-RESULT-CD = WS-SPACE OR WS-ZERO                  
               MOVE SPACES                    TO LH-COLL-RESULT-CD      
           END-IF                                                       
                                                                        
           MOVE WS-IN-COLL-ACTION-CD          TO LH-COLL-ACTION-CD      
           MOVE WS-TRAN-DATE                  TO LH-RECORD-CREATION-DT  
                                                 LH-LAST-UPDATE-DT      
           MOVE PARM-USERID                   TO LH-COLL-AGENT-ID-TEXT  
                                              LH-LAST-UPDATE-USERID-TEXT
           MOVE +7                            TO  LH-COLL-AGENT-ID-LEN  
                                              LH-LAST-UPDATE-USERID-LEN 
                                                                        
           IF LH-COLL-RESULT-CD = (WS-PP OR WS-PM OR WS-PW OR WS-SP)    
              MOVE WS-ARREARS-AMT             TO LH-PTP-ARREARS-AM      
              MOVE 'A'                        TO LH-PTP-STATUS-CD       
           ELSE                                                         
              MOVE ZEROS                      TO LH-PTP-ARREARS-AM      
              MOVE SPACES                     TO LH-PTP-STATUS-CD       
           END-IF                                                       
                                                                        
           MOVE WS-ZERO                       TO LH-PTP-OVERPYMT-AMT    
                                                                        
           PERFORM 2110-BUILD-COMMENTS           THRU 2110-EXIT         
           MOVE WS-COMMENTS-AREA1-TEXT        TO WS-I-COMM-AREA-1       
           MOVE WS-COMMENTS-AREA2-TEXT        TO WS-I-COMM-AREA-2       
           MOVE WS-INSERT-COMMENTS-TEXT       TO LH-COMMENTS-TX-TEXT    
           IF PARM-PTP-COMMENT-LEN > (WS-PTP-CMNT-MAX-LEN -             
                                         WS-INSERT-COMMENTS-LEN)        
              MOVE WS-PTP-CMNT-MAX-LEN        TO LH-COMMENTS-TX-LEN     
              MOVE PARM-PTP-CMNT-TXT          TO LH-COMMENTS-TX-TEXT    
                     (50:(WS-PTP-CMNT-MAX-LEN - WS-INSERT-COMMENTS-LEN))
           ELSE                                                         
              COMPUTE LH-COMMENTS-TX-LEN = PARM-PTP-COMMENT-LEN +       
                                              WS-INSERT-COMMENTS-LEN    
              MOVE PARM-PTP-CMNT-TXT          TO LH-COMMENTS-TX-TEXT    
                                               (50:PARM-PTP-COMMENT-LEN)
           END-IF                                                       
                                                                        
           PERFORM 8300-INSERT-COLL-HIST-DET     THRU 8300-EXIT.        
                                                                        
           MOVE WS-ZERO                       TO WS-NULL-IND1.          
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *6000-CALL-CPD00068                                              *        
      ******************************************************************        
       6000-CALL-CPD00068.                                              
                                                                        
           CALL MCSCB068  USING  CWS00068-FIELDS                        
                                 WS-CODES-DATA-PRESENT                  
                                 DCLCSS-ACCOUNT                         
                                 ABEND-FILE                             
                                 S-RETURN-CODE.                         
           MOVE S-RETURN-CODE      TO WS-ACTIVE-RETURN-CODE.            
                                                                        
           IF ABEND-FUNCTION  > SPACES                                  
               IF ABEND-FUNCTION EQUAL WS-BADDATA                       
                  MOVE -1           TO S-RETURN-CODE,                   
                                       WS-ACTIVE-RETURN-CODE            
               END-IF                                                   
               PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *    6500-GET-NEXT-BUSINESS-DAY                                 *         
      *                                                               *         
      *    COPYBOOK CPD0315B CONTAINS THE LOGIC FOR FINDING           *         
      *    THE NEXT BUSINESS DAY.                                     *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD0315B                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   7000-GET-CURRENT-DATE.                                       *        
      *                                                                *        
      *   THIS PARAGRAPH IS USED TO GET THE CUURENT DATE FROM THE      *        
      *   CSS_MODEL_SQL.                                               *        
      ******************************************************************        
       7000-GET-CURRENT-DATE.                                           
                                                                        
           MOVE '7000'         TO ACTIVE-PARAGRAPH.                     
                                                                        
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(CONVERT(CHAR(8), CIS.CURRENT$TIME(), 108), ':', 
           '.')
            INTO
              :WS-CURRENT-DATE,
              :WS-CURRENT-TIME                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-DATE = CURRENT DATE                              
MFA-TR*           ,:WS-CURRENT-TIMESTAMP = CURRENT_TIMESTAMP                    
MFA-TR*           ,:WS-CURRENT-TIME      = CURRENT TIME                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SET'                 TO ABEND-FUNCTION             
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7020-GET-DELINQUENCY-VALUE.                                   *         
      ******************************************************************        
       7020-GET-DELINQUENCY-VALUE.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                  DELINQ_VALUE                                          
              INTO                                                      
                  :C8-DELINQ-VALUE                                      
              FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                        
              WHERE DELINQ_CD  = :C8-DELINQ-CD                          
                AND COMPANY_NO = :C8-COMPANY-NO                         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*           DELINQ_VALUE                                                  
MFA-TR*       INTO                                                              
MFA-TR*           :C8-DELINQ-VALUE                                              
MFA-TR*       FROM CSS_DELINQUENCY                                              
MFA-TR*       WHERE DELINQ_CD  = :C8-DELINQ-CD                                  
MFA-TR*         AND COMPANY_NO = :C8-COMPANY-NO                                 
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7020'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
              MOVE 'DELINQ_CD'                TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE C8-DELINQ-CD               TO HOSTVAR-ELEMENT-1      
              MOVE C8-COMPANY-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   7030-GET-FUTURE-WORK-DATE.                                   *        
      *                                                                *        
      *   THIS PARAGRAPH IS USED TO GET THE FUTURE WORK DATE FROM      *        
      *   CSS_MODEL_SQL.                                               *        
      ******************************************************************        
       7030-GET-FUTURE-WORK-DATE.                                       
                                                                        
           MOVE '7030'         TO ACTIVE-PARAGRAPH.                     
                                                                        
           EXEC SQL                                                     
               SELECT
              DATEADD( DAY, :WS-FUTURE-NO, IIF(TRY_CONVERT(DATE, 
                                                           :WS-PTP-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PTP-DATE
              ) <> 0) OR (LEN(:WS-PTP-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-PTP-DATE
              ), CONVERT(DATE, :WS-PTP-DATE) ) )
            INTO
              :WS-FUTURE-WORK-DATE
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-FUTURE-WORK-DATE =                                       
MFA-TR*                          DATE(:WS-PTP-DATE) + :WS-FUTURE-NO DAYS        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SET'                 TO ABEND-FUNCTION             
               MOVE 'PTP_DATE'            TO TABLE-ELEMENT-1            
               MOVE WS-PTP-DATE           TO HOSTVAR-ELEMENT-1          
               MOVE 'NO_DAYS'             TO TABLE-ELEMENT-2            
               MOVE WS-FUTURE-NO          TO HOSTVAR-ELEMENT-2          
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
      *                                                                         
           END-IF.                                                      
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-GET-COLL-HIST-SEQ.                                        *        
      *     THIS MODULE GETS THE COLL_HIST_SEQ_NO FOR THE ACTIVE QUEUE *        
      *     TO CREATE DETL ROWS FOR THE CURRENT ACTION                 *        
      ******************************************************************        
       7100-GET-COLL-HIST-SEQ.                                          
      *                                                                         
           MOVE '7100'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           HC.COLL_HIST_SEQ_TS, 121), ' ', '-'), ':', '.') 
           COLL_HIST_SEQ_TS,                               
                     HC.DATE_FORECAST_DNP                               
             INTO    :HC-COLL-HIST-SEQ-TS                               
            FROM CSS_COLLECT_HIST HC WITH(READUNCOMMITTED)                      
            WHERE HC.ACCOUNT_NO    = :HC-ACCOUNT-NO                     
              AND HC.FUTURE_WORK_DT IS NOT NULL                         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT HC.COLL_HIST_SEQ_TS,                                       
MFA-TR*              HC.DATE_FORECAST_DNP                                       
MFA-TR*      INTO    :HC-COLL-HIST-SEQ-TS                                       
MFA-TR*     FROM CSS_COLLECT_HIST HC                                            
MFA-TR*     WHERE HC.ACCOUNT_NO    = :HC-ACCOUNT-NO                             
MFA-TR*       AND HC.FUTURE_WORK_DT IS NOT NULL                                 
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE               
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_COLLECT_HIST'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE HC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7005-SELECT-ACCOUNT                                            *        
      *                                                                *        
      ******************************************************************        
       7005-SELECT-ACCOUNT.                                             
           EXEC SQL                                                     
               SELECT ACCOUNT_NO,                                       
                      CUSTOMER_NO,                                      
                      DATE_BILL_DAY_00,                                 
                      DATE_BILL_DAY_30,                                 
                      DATE_BILL_DAY_60,                                 
                      DATE_BILL_DAY_90,                                 
                      BILL_CYCLE,                                       
                      CODE_ACCT_STAT,                                   
                      TOTAL_AR_BALANCE,                                 
                      LOCAL_OFFICE,                                     
                      PREMISE_NO,                                       
                      ACCT_XFER_TO,                                     
                      BANKRUPTCY_IND,                                   
                      CODES_DATA_PRESENT,                               
                      COMPANY_NO,                                       
                      CREDIT_GROUP,                                     
                      CANREB_CODE_00_DAY,                               
                      CANREB_CODE_30_DAY,                               
                      CANREB_CODE_60_DAY,                               
                      CANREB_CODE_90_DAY,                               
                      REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,                        
                      CODE_DISC_OK,                                     
                      NOTICE_EXEMPT_CD,                                 
                      CODE_BILL_FREQ,                                   
                      REV_MTH_LST_NRML,                                 
                      REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_FINALED_DT
           , 121), ' ', '-'), ':', '.') ACCT_FINALED_DT,                       
                      IVR_EXEMPT_CD                                     
               INTO   :AT-ACCOUNT-NO,                                   
                      :AT-CUSTOMER-NO,                                  
                      :AT-DATE-BILL-DAY-00 :WS-NULL-INDICATOR-1,        
                      :AT-DATE-BILL-DAY-30 :WS-NULL-INDICATOR-2,        
                      :AT-DATE-BILL-DAY-60 :WS-NULL-INDICATOR-3,        
                      :AT-DATE-BILL-DAY-90 :WS-NULL-INDICATOR-4,        
                      :AT-BILL-CYCLE,                                   
                      :AT-CODE-ACCT-STAT,                               
                      :AT-TOTAL-AR-BALANCE,                             
                      :AT-LOCAL-OFFICE,                                 
                      :AT-PREMISE-NO,                                   
                      :AT-ACCT-XFER-TO,                                 
                      :AT-BANKRUPTCY-IND,                               
                      :AT-CODES-DATA-PRESENT,                           
                      :AT-COMPANY-NO,                                   
                      :AT-CREDIT-GROUP,                                 
                      :AT-CANREB-CODE-00-DAY,                           
                      :AT-CANREB-CODE-30-DAY,                           
                      :AT-CANREB-CODE-60-DAY,                           
                      :AT-CANREB-CODE-90-DAY,                           
                      :AT-LAST-UPDATE-TS,                               
                      :AT-CODE-DISC-OK,                                 
                      :AT-NOTICE-EXEMPT-CD,                             
                      :AT-CODE-BILL-FREQ,                               
                      :AT-REV-MTH-LST-NRML,                             
                      :AT-ACCT-FINALED-DT :WS-FINAL-NULL-IND,            
                      :AT-IVR-EXEMPT-CD                                 
              FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                            
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     31860000
MFA-TR*        SELECT ACCOUNT_NO,                                       31870000
MFA-TR*               CUSTOMER_NO,                                      31880000
MFA-TR*               DATE_BILL_DAY_00,                                 31890000
MFA-TR*               DATE_BILL_DAY_30,                                 31900000
MFA-TR*               DATE_BILL_DAY_60,                                 31910000
MFA-TR*               DATE_BILL_DAY_90,                                 31920000
MFA-TR*               BILL_CYCLE,                                       31930000
MFA-TR*               CODE_ACCT_STAT,                                   31940000
MFA-TR*               TOTAL_AR_BALANCE,                                 31950000
MFA-TR*               LOCAL_OFFICE,                                     31960000
MFA-TR*               PREMISE_NO,                                       31970000
MFA-TR*               ACCT_XFER_TO,                                     31980000
MFA-TR*               BANKRUPTCY_IND,                                   31990000
MFA-TR*               CODES_DATA_PRESENT,                               32000000
MFA-TR*               COMPANY_NO,                                       32010000
MFA-TR*               CREDIT_GROUP,                                     32020000
MFA-TR*               CANREB_CODE_00_DAY,                               32030000
MFA-TR*               CANREB_CODE_30_DAY,                               32040000
MFA-TR*               CANREB_CODE_60_DAY,                               32050000
MFA-TR*               CANREB_CODE_90_DAY,                               32060000
MFA-TR*               LAST_UPDATE_TS,                                   32070000
MFA-TR*               CODE_DISC_OK,                                     32080000
MFA-TR*               NOTICE_EXEMPT_CD,                                 32090000
MFA-TR*               CODE_BILL_FREQ,                                   32100000
MFA-TR*               REV_MTH_LST_NRML,                                 32110000
MFA-TR*               ACCT_FINALED_DT,                                  32120000
MFA-TR*               IVR_EXEMPT_CD                                             
MFA-TR*        INTO   :AT-ACCOUNT-NO,                                   32130000
MFA-TR*               :AT-CUSTOMER-NO,                                  32140000
MFA-TR*               :AT-DATE-BILL-DAY-00 :WS-NULL-INDICATOR-1,        32150000
MFA-TR*               :AT-DATE-BILL-DAY-30 :WS-NULL-INDICATOR-2,        32160000
MFA-TR*               :AT-DATE-BILL-DAY-60 :WS-NULL-INDICATOR-3,        32170000
MFA-TR*               :AT-DATE-BILL-DAY-90 :WS-NULL-INDICATOR-4,        32180000
MFA-TR*               :AT-BILL-CYCLE,                                   32190000
MFA-TR*               :AT-CODE-ACCT-STAT,                               32200000
MFA-TR*               :AT-TOTAL-AR-BALANCE,                             32210000
MFA-TR*               :AT-LOCAL-OFFICE,                                 32220000
MFA-TR*               :AT-PREMISE-NO,                                   32230000
MFA-TR*               :AT-ACCT-XFER-TO,                                 32240000
MFA-TR*               :AT-BANKRUPTCY-IND,                               32250000
MFA-TR*               :AT-CODES-DATA-PRESENT,                           32260000
MFA-TR*               :AT-COMPANY-NO,                                   32270000
MFA-TR*               :AT-CREDIT-GROUP,                                 32280000
MFA-TR*               :AT-CANREB-CODE-00-DAY,                           32290000
MFA-TR*               :AT-CANREB-CODE-30-DAY,                           32300000
MFA-TR*               :AT-CANREB-CODE-60-DAY,                           32310000
MFA-TR*               :AT-CANREB-CODE-90-DAY,                           32320000
MFA-TR*               :AT-LAST-UPDATE-TS,                               32330000
MFA-TR*               :AT-CODE-DISC-OK,                                 32340000
MFA-TR*               :AT-NOTICE-EXEMPT-CD,                             32350000
MFA-TR*               :AT-CODE-BILL-FREQ,                               32360000
MFA-TR*               :AT-REV-MTH-LST-NRML,                             32370000
MFA-TR*               :AT-ACCT-FINALED-DT:WS-FINAL-NULL-IND,            32380000
MFA-TR*               :AT-IVR-EXEMPT-CD                                         
MFA-TR*       FROM CSS_ACCOUNT                                          32390000
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         32400000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    32410000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-NULL-INDICATOR-1 < ZERO                             
                  MOVE ZEROS             TO AT-DATE-BILL-DAY-00         
              END-IF                                                    
              IF WS-NULL-INDICATOR-2 < ZERO                             
                  MOVE ZEROS             TO AT-DATE-BILL-DAY-30         
              END-IF                                                    
              IF WS-NULL-INDICATOR-3 < ZERO                             
                  MOVE ZEROS             TO AT-DATE-BILL-DAY-60         
              END-IF                                                    
              IF WS-NULL-INDICATOR-4 < ZERO                             
                  MOVE ZEROS             TO AT-DATE-BILL-DAY-90         
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE               
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7105'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7110-GET-MAX-TRANS-ID.                                         *        
      * THIS MODULE GETS THE MAX TRANS ID FOR THE ACCOUNT WITH THE     *        
      * SAME COLL_HIST_SEQ TO CREATE DETL ROWS FOR THE CURRENT ACTION  *        
      ******************************************************************        
       7110-GET-MAX-TRANS-ID.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT MAX(TRANS_ID)                                      
                INTO :LH-TRANS-ID :WS-NULL-IND2                          
            FROM CSS_COLL_HIST_DET LH WITH(READUNCOMMITTED)                     
            WHERE LH.ACCOUNT_NO       = :HC-ACCOUNT-NO                  
              AND LH.COLL_HIST_SEQ_TS = CIS.CHAR2TIMESTAMP(
                                                   :HC-COLL-HIST-SEQ-TS
              )            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(TRANS_ID)                                              
MFA-TR*         INTO :LH-TRANS-ID:WS-NULL-IND2                                  
MFA-TR*     FROM CSS_COLL_HIST_DET LH                                           
MFA-TR*     WHERE LH.ACCOUNT_NO       = :HC-ACCOUNT-NO                          
MFA-TR*       AND LH.COLL_HIST_SEQ_TS = :HC-COLL-HIST-SEQ-TS                    
MFA-TR*     WITH UR                                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
           OR  NOT-FOUND                                                
               IF  WS-NULL-IND2 < ZEROS                                 
                   MOVE ZEROS         TO LH-TRANS-ID                    
                   SET NO-COLL-HIST-DET    TO TRUE                      
               ELSE                                                     
                   SET COLL-HIST-DET-EXIST TO TRUE                      
               END-IF                                                   
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE              
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7110'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                             ABEND-TABLES               
               MOVE 'CSS_COLL_HIST_DET'  TO TABLE-1                     
               MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
               MOVE 'COLL_HIST_SEQ_NO'   TO TABLE-ELEMENT-2             
               MOVE HC-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
               MOVE HC-COLL-HIST-SEQ-TS  TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7200-GET-COLL-EXEMPT-CD                                       *         
      * THIS GETS THE EXISTING COLL-EXEMPT-CD                         *         
      *****************************************************************         
      *                                                                         
       7200-GET-COLL-EXEMPT-CD.                                         
                                                                        
           EXEC SQL                                                     
              SELECT [IF].COLL_EXEMPTION_CD                               
                INTO :IF-COLL-EXEMPTION-CD :WS-COLL-EX-NULL-IND2        
                FROM CSS_COLL_ACCT_INFO AS [IF] WITH(READUNCOMMITTED)           
               WHERE [IF].ACCOUNT_NO = :IF-ACCOUNT-NO                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT IF.COLL_EXEMPTION_CD                                       
MFA-TR*         INTO :IF-COLL-EXEMPTION-CD :WS-COLL-EX-NULL-IND2                
MFA-TR*         FROM CSS_COLL_ACCT_INFO AS IF                                   
MFA-TR*        WHERE IF.ACCOUNT_NO = :IF-ACCOUNT-NO                             
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-COLL-EX-NULL-IND2 < 0                               
                 MOVE SPACES        TO IF-COLL-EXEMPTION-CD             
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE               
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7200'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_COLL_ACCT_INFO'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE IF-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7250-GET-PREV-BUSINESS-DAY                                   *        
      *                                                                *        
      *   THIS PARAGRAPH IS USED TO GET THE PREVIOUS BUSINESS DAY.     *        
      *                                                                *        
      ******************************************************************        
       7250-GET-PREV-BUSINESS-DAY.                                      
      *                                                                         
           EXEC SQL                                                     
             SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                   :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) ) )
            INTO
              :WS-NEW-BUSINESS-DAY      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-NEW-BUSINESS-DAY =                                         
MFA-TR*                        DATE(:WS-NEW-BUSINESS-DAY) - 1 DAYS              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7250'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SET'                     TO ABEND-FUNCTION          
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************   10380000
      * 7300-OPEN-COLL-CSR                                          *           
      * OPEN A CURSOR FOR COLLECTION HIST DET AND COLLECT ACCT INFO *   10390000
      ***************************************************************   10400000
      *                                                                 10410000
       7300-OPEN-COLL-CSR.                                              
           EXEC SQL                                                     
               OPEN COLLECT-DET                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7300'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-TABLES            
                                                ABEND-SQL-PREDICATES    
              MOVE 'CSS_COLL_HIST_DET'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE LH-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************   10380000
      * 7400-FETCH-COLL-CSR                                         *           
      * FETCH A CURSOR FOR COLLECTION HIST DET AND COLLECT ACCT INFO*   10390000
      ***************************************************************   10400000
      *                                                                         
       7400-FETCH-COLL-CSR.                                             
           EXEC SQL                                                     
              FETCH COLLECT-DET                                         
              INTO  :LH-COLL-ACTION-CD,                                 
                    :LH-COLL-RESULT-CD,                                 
                    :LH-PTP-DT,                                         
                    :LH-PTP-AMT,                                        
                    :LH-PTP-ARREARS-AM,                                 
                    :LH-PTP-OVERPYMT-AMT                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '7400'                 TO ACTIVE-PARAGRAPH        
                 MOVE 'FETCH'                TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-TABLES            
                                                ABEND-SQL-PREDICATES    
                 MOVE 'CSS_COLL_HIST_DET'    TO TABLE-1                 
                 MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1         
                 MOVE LH-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT             
           END-IF.                                                      
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 11320000
      * 7450-CHECK-ACTIVE-PTP                                         * 11330000
      *      CHECK TO SEE IF ACTIVE PTP EXISTS ON THE ACCOUNT         * 11340000
      ***************************************************************** 11350000
      *                                                                         
       7450-CHECK-ACTIVE-PTP.                                           
                                                                        
           EXEC SQL                                                     
             SELECT 'Y'                                                 
             INTO    :WS-PTP-EXISTS                                     
            FROM CSS_COLL_HIST_DET LH WITH(READUNCOMMITTED)                     
            WHERE LH.ACCOUNT_NO  = :LH-ACCOUNT-NO                       
              AND LH.PTP_STATUS_CD = 'A'                                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11400000
MFA-TR*      SELECT 'Y'                                                 11410000
MFA-TR*      INTO    :WS-PTP-EXISTS                                     11430000
MFA-TR*     FROM CSS_COLL_HIST_DET LH                                   11450000
MFA-TR*     WHERE LH.ACCOUNT_NO  = :LH-ACCOUNT-NO                       11460000
MFA-TR*       AND LH.PTP_STATUS_CD = 'A'                                11470000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7450                                                      
MFA-TR*    END-EXEC.                                                    11480000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7450'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-TABLES               
                                             ABEND-SQL-PREDICATES       
              MOVE 'CSS_COLL_HIST_DET'    TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE LH-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
       7450-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11060000
      ***************************************************************** 11320000
      * 7500-CLOSE-COLL-CSR                                           * 11330000
      * CLOSE A CURSOR FOR COLLECTION HIST DET AND COLLECT ACCT INFO  * 11340000
      ***************************************************************** 11350000
      *                                                                         
       7500-CLOSE-COLL-CSR.                                             
           EXEC SQL                                                     
              CLOSE COLLECT-DET                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7500'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-TABLES            
                                                ABEND-SQL-PREDICATES    
              MOVE 'CSS_COLL_HIST_DET'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE LH-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *8020-UPDT-EXEMPT-CD.                                            *        
      *    UPDATES COLL_EXEMPT_CD ON CSS_COLL_ACCT_INFO.               *        
      ******************************************************************        
       8020-UPDT-EXEMPT-CD.                                             
      *                                                                         
           MOVE '8020' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_COLL_ACCT_INFO                                
                  SET COLL_EXEMPTION_CD  = :IF-COLL-EXEMPTION-CD        
                     ,LAST_UPDATE_DT     = IIF(TRY_CONVERT(DATE, 
                                                     :IF-LAST-UPDATE-DT
              ) IS NULL OR (PATINDEX('%.%', :IF-LAST-UPDATE-DT
              ) <> 0) OR (LEN(:IF-LAST-UPDATE-DT
              ) <> 10), CIS.CHAR2DATE(:IF-LAST-UPDATE-DT
              ), CONVERT(DATE, :IF-LAST-UPDATE-DT) )           
                     ,LAST_UPDATE_USERID = :IF-LAST-UPDATE-USERID       
                WHERE ACCOUNT_NO  = :IF-ACCOUNT-NO                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_COLL_ACCT_INFO                                        
MFA-TR*           SET COLL_EXEMPTION_CD  = :IF-COLL-EXEMPTION-CD                
MFA-TR*              ,LAST_UPDATE_DT     = :IF-LAST-UPDATE-DT                   
MFA-TR*              ,LAST_UPDATE_USERID = :IF-LAST-UPDATE-USERID               
MFA-TR*         WHERE ACCOUNT_NO  = :IF-ACCOUNT-NO                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_COLL_ACCT_INFO'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE IF-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *8030-UPDATE-PERM-COMMENTS.                                      *        
      *    UPDATES PERM_COMMENTS  ON CSS_COLL_ACCT_INFO.               *        
      ******************************************************************        
       8030-UPDATE-PERM-COMMENTS.                                       
      *                                                                         
           MOVE '8030' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_COLL_ACCT_INFO                                
                  SET COLL_COMMENT_TX    = :IF-COLL-COMMENT-TX          
                     ,LAST_UPDATE_DT     = IIF(TRY_CONVERT(DATE, 
                                                     :IF-LAST-UPDATE-DT
              ) IS NULL OR (PATINDEX('%.%', :IF-LAST-UPDATE-DT
              ) <> 0) OR (LEN(:IF-LAST-UPDATE-DT
              ) <> 10), CIS.CHAR2DATE(:IF-LAST-UPDATE-DT
              ), CONVERT(DATE, :IF-LAST-UPDATE-DT) )           
                     ,LAST_UPDATE_USERID = :IF-LAST-UPDATE-USERID       
                WHERE ACCOUNT_NO  = :IF-ACCOUNT-NO                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_COLL_ACCT_INFO                                        
MFA-TR*           SET COLL_COMMENT_TX    = :IF-COLL-COMMENT-TX                  
MFA-TR*              ,LAST_UPDATE_DT     = :IF-LAST-UPDATE-DT                   
MFA-TR*              ,LAST_UPDATE_USERID = :IF-LAST-UPDATE-USERID               
MFA-TR*         WHERE ACCOUNT_NO  = :IF-ACCOUNT-NO                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE 'UPDATE'                  TO ABEND-FUNCTION         
               MOVE 'CSS_COLL_ACCT_INFO'      TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE 'COLL_COMMENT_TX'         TO TABLE-ELEMENT-2        
               MOVE IF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               MOVE IF-COLL-COMMENT-TX-TEXT   TO HOSTVAR-ELEMENT-2      
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      *8200-UPDATE-COLLECT-HIST.                                       *        
      *    UPDATES QUEUE-STATUS-CD AND FUTURE-WORK-DATE ON COLLECT_HIST*        
      ******************************************************************        
       8200-UPDATE-COLLECT-HIST.                                        
      *                                                                         
           MOVE '8200' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_COLLECT_HIST                                  
                  SET QUEUE_STATUS_CD    = :HC-QUEUE-STATUS-CD          
                     ,QUEUE_STATUS_DT    = IIF(TRY_CONVERT(DATE, 
                                                    :HC-QUEUE-STATUS-DT
              ) IS NULL OR (PATINDEX('%.%', :HC-QUEUE-STATUS-DT
              ) <> 0) OR (LEN(:HC-QUEUE-STATUS-DT
              ) <> 10), CIS.CHAR2DATE(:HC-QUEUE-STATUS-DT
              ), CONVERT(DATE, :HC-QUEUE-STATUS-DT) )          
                     ,FUTURE_WORK_DT     = IIF(TRY_CONVERT(DATE, 
                                                     :HC-FUTURE-WORK-DT
              ) IS NULL OR (PATINDEX('%.%', :HC-FUTURE-WORK-DT
              ) <> 0) OR (LEN(:HC-FUTURE-WORK-DT
              ) <> 10), CIS.CHAR2DATE(:HC-FUTURE-WORK-DT
              ), CONVERT(DATE, :HC-FUTURE-WORK-DT) )           
                     ,LAST_UPDATE_DT     = IIF(TRY_CONVERT(DATE, 
                                                     :HC-LAST-UPDATE-DT
              ) IS NULL OR (PATINDEX('%.%', :HC-LAST-UPDATE-DT
              ) <> 0) OR (LEN(:HC-LAST-UPDATE-DT
              ) <> 10), CIS.CHAR2DATE(:HC-LAST-UPDATE-DT
              ), CONVERT(DATE, :HC-LAST-UPDATE-DT) )           
                     ,LAST_UPDATE_USERID = :HC-LAST-UPDATE-USERID       
                WHERE ACCOUNT_NO  = :HC-ACCOUNT-NO                      
                  AND FUTURE_WORK_DT IS NOT NULL                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_COLLECT_HIST                                          
MFA-TR*           SET QUEUE_STATUS_CD    = :HC-QUEUE-STATUS-CD                  
MFA-TR*              ,QUEUE_STATUS_DT    = :HC-QUEUE-STATUS-DT                  
MFA-TR*              ,FUTURE_WORK_DT     = :HC-FUTURE-WORK-DT                   
MFA-TR*              ,LAST_UPDATE_DT     = :HC-LAST-UPDATE-DT                   
MFA-TR*              ,LAST_UPDATE_USERID = :HC-LAST-UPDATE-USERID               
MFA-TR*         WHERE ACCOUNT_NO  = :HC-ACCOUNT-NO                              
MFA-TR*           AND FUTURE_WORK_DT IS NOT NULL                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_COLLECT_HIST'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE HC-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'FUTURE_WORK_DT'           TO TABLE-ELEMENT-2        
              MOVE HC-FUTURE-WORK-DT          TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *8210-UPDATE-QUEUE-STATUS.                                       *        
      *    UPDATES QUEUE-STATUS-CD AND QUEUE-STATUS-DT  ON COLLECT_HIST*        
      ******************************************************************        
       8210-UPDATE-QUEUE-STATUS.                                        
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_COLLECT_HIST                                  
                  SET QUEUE_STATUS_CD    = :HC-QUEUE-STATUS-CD          
                     ,QUEUE_STATUS_DT    = IIF(TRY_CONVERT(DATE, 
                                                    :HC-QUEUE-STATUS-DT
              ) IS NULL OR (PATINDEX('%.%', :HC-QUEUE-STATUS-DT
              ) <> 0) OR (LEN(:HC-QUEUE-STATUS-DT
              ) <> 10), CIS.CHAR2DATE(:HC-QUEUE-STATUS-DT
              ), CONVERT(DATE, :HC-QUEUE-STATUS-DT) )          
                     ,LAST_UPDATE_DT     = IIF(TRY_CONVERT(DATE, 
                                                     :HC-LAST-UPDATE-DT
              ) IS NULL OR (PATINDEX('%.%', :HC-LAST-UPDATE-DT
              ) <> 0) OR (LEN(:HC-LAST-UPDATE-DT
              ) <> 10), CIS.CHAR2DATE(:HC-LAST-UPDATE-DT
              ), CONVERT(DATE, :HC-LAST-UPDATE-DT) )           
                     ,LAST_UPDATE_USERID = :HC-LAST-UPDATE-USERID       
                WHERE ACCOUNT_NO  = :HC-ACCOUNT-NO                      
                  AND FUTURE_WORK_DT IS NOT NULL                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_COLLECT_HIST                                          
MFA-TR*           SET QUEUE_STATUS_CD    = :HC-QUEUE-STATUS-CD                  
MFA-TR*              ,QUEUE_STATUS_DT    = :HC-QUEUE-STATUS-DT                  
MFA-TR*              ,LAST_UPDATE_DT     = :HC-LAST-UPDATE-DT                   
MFA-TR*              ,LAST_UPDATE_USERID = :HC-LAST-UPDATE-USERID               
MFA-TR*         WHERE ACCOUNT_NO  = :HC-ACCOUNT-NO                              
MFA-TR*           AND FUTURE_WORK_DT IS NOT NULL                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8210'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_COLLECT_HIST'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE HC-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *8300-INSERT-COLL-HIST-DET.                                      *        
      *    INSERTS NEW ROW IN CSS_COLL_HIST_DET FOR THE CURRENT ACTION *        
      *    ON A QUEUE.                                                 *        
      ******************************************************************        
       8300-INSERT-COLL-HIST-DET.                                       
      *                                                                         
           MOVE '8300' TO ACTIVE-PARAGRAPH.                             
           IF  LH-PTP-DT = LOW-VALUES                                   
               MOVE -1                   TO WS-NULL-IND1                
           END-IF                                                       
           EXEC SQL                                                     
              INSERT INTO CSS_COLL_HIST_DET                             
                         (ACCOUNT_NO                                    
                         ,COLL_HIST_SEQ_TS                              
                         ,TRANS_ID                                      
                         ,PTP_DT                                        
                         ,PTP_AMT                                       
                         ,COLL_RESULT_CD                                
                         ,COLL_ACTION_CD                                
                         ,RECORD_CREATION_DT                            
                         ,LAST_UPDATE_DT                                
                         ,LAST_UPDATE_USERID                            
                         ,COLL_AGENT_ID                                 
                         ,COMMENTS_TX                                   
                         ,PTP_ARREARS_AM                                
                         ,PTP_STATUS_CD                                 
                         ,PTP_OVERPYMT_AMT)                             
              VALUES     ( :LH-ACCOUNT-NO                               
                          ,CIS.CHAR2TIMESTAMP(:LH-COLL-HIST-SEQ-TS)             
                          ,:LH-TRANS-ID                                 
                          ,IIF(TRY_CONVERT(DATE, :LH-PTP-DT 
                                                 :WS-NULL-IND1
              ) IS NULL OR (PATINDEX('%.%', :LH-PTP-DT :WS-NULL-IND1
              ) <> 0) OR (LEN(:LH-PTP-DT :WS-NULL-IND1
              ) <> 10), CIS.CHAR2DATE(:LH-PTP-DT :WS-NULL-IND1
              ), CONVERT(DATE, :LH-PTP-DT :WS-NULL-IND1) )                     
                          ,:LH-PTP-AMT                                  
                          ,:LH-COLL-RESULT-CD                           
                          ,:LH-COLL-ACTION-CD                           
                          ,IIF(TRY_CONVERT(DATE, :LH-RECORD-CREATION-DT
              ) IS NULL OR (PATINDEX('%.%', :LH-RECORD-CREATION-DT
              ) <> 0) OR (LEN(:LH-RECORD-CREATION-DT
              ) <> 10), CIS.CHAR2DATE(:LH-RECORD-CREATION-DT
              ), CONVERT(DATE, :LH-RECORD-CREATION-DT) )                       
                          ,IIF(TRY_CONVERT(DATE, :LH-LAST-UPDATE-DT
              ) IS NULL OR (PATINDEX('%.%', :LH-LAST-UPDATE-DT
              ) <> 0) OR (LEN(:LH-LAST-UPDATE-DT
              ) <> 10), CIS.CHAR2DATE(:LH-LAST-UPDATE-DT
              ), CONVERT(DATE, :LH-LAST-UPDATE-DT) )                           
                          ,:LH-LAST-UPDATE-USERID                       
                          ,:LH-COLL-AGENT-ID                            
                          ,:LH-COMMENTS-TX                              
                          ,:LH-PTP-ARREARS-AM                           
                          ,:LH-PTP-STATUS-CD                            
                          ,:LH-PTP-OVERPYMT-AMT)                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_COLL_HIST_DET                                     
MFA-TR*                  (ACCOUNT_NO                                            
MFA-TR*                  ,COLL_HIST_SEQ_TS                                      
MFA-TR*                  ,TRANS_ID                                              
MFA-TR*                  ,PTP_DT                                                
MFA-TR*                  ,PTP_AMT                                               
MFA-TR*                  ,COLL_RESULT_CD                                        
MFA-TR*                  ,COLL_ACTION_CD                                        
MFA-TR*                  ,RECORD_CREATION_DT                                    
MFA-TR*                  ,LAST_UPDATE_DT                                        
MFA-TR*                  ,LAST_UPDATE_USERID                                    
MFA-TR*                  ,COLL_AGENT_ID                                         
MFA-TR*                  ,COMMENTS_TX                                           
MFA-TR*                  ,PTP_ARREARS_AM                                        
MFA-TR*                  ,PTP_STATUS_CD                                         
MFA-TR*                  ,PTP_OVERPYMT_AMT)                                     
MFA-TR*       VALUES     ( :LH-ACCOUNT-NO                                       
MFA-TR*                   ,:LH-COLL-HIST-SEQ-TS                                 
MFA-TR*                   ,:LH-TRANS-ID                                         
MFA-TR*                   ,:LH-PTP-DT:WS-NULL-IND1                              
MFA-TR*                   ,:LH-PTP-AMT                                          
MFA-TR*                   ,:LH-COLL-RESULT-CD                                   
MFA-TR*                   ,:LH-COLL-ACTION-CD                                   
MFA-TR*                   ,:LH-RECORD-CREATION-DT                               
MFA-TR*                   ,:LH-LAST-UPDATE-DT                                   
MFA-TR*                   ,:LH-LAST-UPDATE-USERID                               
MFA-TR*                   ,:LH-COLL-AGENT-ID                                    
MFA-TR*                   ,:LH-COMMENTS-TX                                      
MFA-TR*                   ,:LH-PTP-ARREARS-AM                                   
MFA-TR*                   ,:LH-PTP-STATUS-CD                                    
MFA-TR*                   ,:LH-PTP-OVERPYMT-AMT)                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_COLL_HIST_DET'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE LH-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'COLL_HIST_SEQ_NO'         TO TABLE-ELEMENT-2        
              MOVE LH-COLL-HIST-SEQ-TS        TO HOSTVAR-ELEMENT-2      
              MOVE 'TRANS_ID'                 TO TABLE-ELEMENT-3        
              MOVE LH-TRANS-ID                TO HOSTVAR-ELEMENT-3      
              MOVE 'PTP_DT '                  TO TABLE-ELEMENT-4        
              MOVE LH-PTP-DT                  TO HOSTVAR-ELEMENT-4      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *8350-CAN-EXISTING-ROW                                           *        
      *    UPDATE STATUS CODE ON EXISTING ROW TO 'C' FOR CANCEL        *        
      ******************************************************************        
       8350-CAN-EXISTING-ROW.                                           
      *                                                                         
           MOVE '8350' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_COLL_HIST_DET                                 
                  SET PTP_STATUS_CD = 'M'                               
                     ,LAST_UPDATE_DT     = IIF(TRY_CONVERT(DATE, 
                                                     :LH-LAST-UPDATE-DT
              ) IS NULL OR (PATINDEX('%.%', :LH-LAST-UPDATE-DT
              ) <> 0) OR (LEN(:LH-LAST-UPDATE-DT
              ) <> 10), CIS.CHAR2DATE(:LH-LAST-UPDATE-DT
              ), CONVERT(DATE, :LH-LAST-UPDATE-DT) )           
                     ,LAST_UPDATE_USERID = :LH-LAST-UPDATE-USERID       
                WHERE ACCOUNT_NO         = :LH-ACCOUNT-NO               
                  AND COLL_HIST_SEQ_TS   = CIS.CHAR2TIMESTAMP(
                                                   :LH-COLL-HIST-SEQ-TS
              )         
      *           AND TRANS_ID           >= :WS-PARM-TRANS-ID                   
                  AND PTP_DT             >= IIF(TRY_CONVERT(DATE, 
                                                      :WS-HOLD-PTP-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-PTP-DATE
              ) <> 0) OR (LEN(:WS-HOLD-PTP-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-HOLD-PTP-DATE
              ), CONVERT(DATE, :WS-HOLD-PTP-DATE) )           
                  AND PTP_STATUS_CD      IN ('A','P')                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_COLL_HIST_DET                                         
MFA-TR*           SET PTP_STATUS_CD = 'M'                                       
MFA-TR*              ,LAST_UPDATE_DT     = :LH-LAST-UPDATE-DT                   
MFA-TR*              ,LAST_UPDATE_USERID = :LH-LAST-UPDATE-USERID               
MFA-TR*         WHERE ACCOUNT_NO         = :LH-ACCOUNT-NO                       
MFA-TR*           AND COLL_HIST_SEQ_TS   = :LH-COLL-HIST-SEQ-TS                 
MFA-TR*           AND TRANS_ID           >= :WS-PARM-TRANS-ID                   
MFA-TR*           AND PTP_DT             >= :WS-HOLD-PTP-DATE                   
MFA-TR*           AND PTP_STATUS_CD      IN ('A','P')                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_COLL_HIST_DET'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE LH-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'COLL_HIST_SEQ_NO'         TO TABLE-ELEMENT-2        
              MOVE LH-COLL-HIST-SEQ-TS        TO HOSTVAR-ELEMENT-2      
              MOVE 'TRANS_ID'                 TO TABLE-ELEMENT-3        
              MOVE LH-TRANS-ID                TO HOSTVAR-ELEMENT-3      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
       8350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *8400-UPDATE-COLLECT-HIST                                        *        
      *    UPDATE QUE STATUS CODE TO SPACES ON COLLECT HIST            *        
      ******************************************************************        
       8400-UPDATE-COLLECT-HIST.                                        
      *                                                                         
           MOVE '8400' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_COLLECT_HIST                                  
                  SET QUEUE_STATUS_CD    = '  '                         
                     ,FUTURE_WORK_DT     = IIF(TRY_CONVERT(DATE, 
                                                     :HC-FUTURE-WORK-DT
              ) IS NULL OR (PATINDEX('%.%', :HC-FUTURE-WORK-DT
              ) <> 0) OR (LEN(:HC-FUTURE-WORK-DT
              ) <> 10), CIS.CHAR2DATE(:HC-FUTURE-WORK-DT
              ), CONVERT(DATE, :HC-FUTURE-WORK-DT) )           
                     ,LAST_UPDATE_DT     = IIF(TRY_CONVERT(DATE, 
                                                     :HC-LAST-UPDATE-DT
              ) IS NULL OR (PATINDEX('%.%', :HC-LAST-UPDATE-DT
              ) <> 0) OR (LEN(:HC-LAST-UPDATE-DT
              ) <> 10), CIS.CHAR2DATE(:HC-LAST-UPDATE-DT
              ), CONVERT(DATE, :HC-LAST-UPDATE-DT) )           
                     ,LAST_UPDATE_USERID = :HC-LAST-UPDATE-USERID       
                WHERE ACCOUNT_NO         = :HC-ACCOUNT-NO               
                  AND COLL_HIST_SEQ_TS   = CIS.CHAR2TIMESTAMP(
                                                   :HC-COLL-HIST-SEQ-TS
              )         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_COLLECT_HIST                                          
MFA-TR*           SET QUEUE_STATUS_CD    = '  '                                 
MFA-TR*              ,FUTURE_WORK_DT     = :HC-FUTURE-WORK-DT                   
MFA-TR*              ,LAST_UPDATE_DT     = :HC-LAST-UPDATE-DT                   
MFA-TR*              ,LAST_UPDATE_USERID = :HC-LAST-UPDATE-USERID               
MFA-TR*         WHERE ACCOUNT_NO         = :HC-ACCOUNT-NO                       
MFA-TR*           AND COLL_HIST_SEQ_TS   = :HC-COLL-HIST-SEQ-TS                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_COLLECT_HIST'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE HC-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'COLL_HIST_SEQ_NO'         TO TABLE-ELEMENT-2        
              MOVE HC-COLL-HIST-SEQ-TS        TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *8500-UPDATE-WORK-DATE.                                          *        
      *    UPDATES WORK DATE.                                          *        
      ******************************************************************        
       8500-UPDATE-WORK-DATE.                                           
      *                                                                         
           MOVE '8500' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_COLLECT_HIST                                  
                  SET FUTURE_WORK_DT     = IIF(TRY_CONVERT(DATE, 
                                                        :PARM-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :PARM-WORK-DATE
              ) <> 0) OR (LEN(:PARM-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                        :PARM-WORK-DATE
              ), CONVERT(DATE, :PARM-WORK-DATE) )              
                WHERE ACCOUNT_NO  = :HC-ACCOUNT-NO                      
                  AND FUTURE_WORK_DT IS NOT NULL                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_COLLECT_HIST                                          
MFA-TR*           SET FUTURE_WORK_DT     = :PARM-WORK-DATE                      
MFA-TR*         WHERE ACCOUNT_NO  = :HC-ACCOUNT-NO                              
MFA-TR*           AND FUTURE_WORK_DT IS NOT NULL                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_COLLECT_HIST'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE HC-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'FUTURE_WORK_DT'           TO TABLE-ELEMENT-2        
              MOVE HC-FUTURE-WORK-DT          TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      * 9700- PROCESS-ABEND ERROR HANDLING INCLUDE                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                              
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *****************************************************************         
      *       END PROGRAM COPYLIB                                               
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
