       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04884.                                         
COB303 DATE-WRITTEN.  NOV 12,2015.                                      
       DATE-COMPILED.                                                   
      *                                                                 00051000
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *                                                                *00100000
      ******************************************************************00110000
      *                 P R O G R A M  S U M M A R Y                   *00120000
      *                                                                *00130000
      *  THIS PROGRAM RETRIEVES COLLECTION INFORMATION FOR A CUSTOMER  *00140000
      *  FROM CSS_COLLECT_HIST FOR THE CREDIT/CUSTOMER SUMMARY SCREEN. *00150000
      *                                                                *00220300
      *  IF THE ACCOUNT NOT FOUND IN CSS_ACCOUNT/CSS_COLL_ACCT_INFO/   *00220400
      *  CSS_COLLECTION_HIST PROGRAM WILL END NORMALLY BY INSERTING    *00220500
      *  BUS RULES (R5).                                               *00220600
      *                                                                *00220700
      *  FEW LOGICS TAKEN FROM CSR02511.                               *00221000
      *                                                                *00222000
      *---------------------------------------------------------------- 00223000
      *--                                                            -- 00224000
      *--  PARAMETERS:                                               -- 00225000
      *--                                                            -- 00226000
      *--  INPUT PARAMETERS.                                         -- 00227000
      *--                                                            -- 00228000
      *--           I_ACCOUNT_NO               CHAR(13)              -- 00229000
      *--                                                            -- 00229400
      *--  RESULT SET 1.                                             -- 00229500
      *--                                                            -- 00229600
      *--           RETURN_CODE                INTEGER               -- 00229700
      *--           COLL_HIST_SEQ_TS           CHAR(26)              -- 00229800
      *--           COLL_Q                     CHAR(5)               -- 00229900
      *--           COLL_EXEMPTION_CD          CHAR(20)              -- 00230000
      *--           WRITE_OFF_DATE             CHAR(10)              -- 00230100
      *--           FUTURE_WORK_DATE           CHAR(10)              -- 00230200
      *--           BILL_ADDR_FLAG             CHAR(01)              -- 00230300
      *--           MULTI_ACCTS_FLAG           CHAR(01)              -- 00230400
      *--           PERM_COMMENT_TEXT          CHAR(254)             -- 00230500
      *--           TRANS_ID                   DECIMAL(13,0)         -- 00230600
      *--           DNP_FLAG                   CHAR(01)              -- 00230700
      *--                                                            -- 00232200
      *--  RESULT SET 2.                                             -- 00232300
      *--                                                            -- 00232400
      *--           RETURN_CODE                INTEGER               -- 00232500
      *--           TRANS_ID                   DECIMAL(13,0)         -- 00232600
      *--           PROMISE_TO_PAY_STATUS      CHAR(01)              -- 00232700
      *--           PROMISE_TO_PAY_ACTION      CHAR(04)              -- 00232800
      *--           PROMISE_TO_PAY_RESULT      CHAR(04)              -- 00232900
      *--           PROMISE_TO_PAY_DATE        CHAR(10)              -- 00233000
      *--           PROMISE_TO_PAY_AMT         DECIMAL(11,2)         -- 00233100
      *--                                                            -- 00233900
      *--  RESULT SET 3.                                             -- 00234000
      *--                                                            -- 00234100
      *--           RETURN_CODE                INTEGER               -- 00234200
      *--           NO_OF_CONTRACTS            INTEGER               -- 00234300
      *--           PROMISE_KEPT_NO            INTEGER               -- 00234400
      *--           PROMISE_BROKEN_NO          INTEGER               -- 00234500
      *--           COLL_EXEMPTION_CD_3        CHAR(20)              -- 00234600
      *--           COLL_COMMENT_DATETIME      CHAR(16)              -- 00234700
      *--           COLL_COMMENT_USER_ID       CHAR(37)              -- 00234800
      *--           COMMENT_TEXT               CHAR(254)             -- 00234900
      *--                                                            -- 00235000
      *--  RESULT SET 4.                                             -- 00235200
      *--                                                            -- 00235300
      *--           RETURN_CODE                INTEGER               -- 00235400
      *--           AR_DATE_TRANSTS            CHAR(10)              -- 00235500
      *--           AR_AMT_ORIG_ENTERED        DECIMAL(11, 2)        -- 00235600
      *--                                                            -- 00236000
      *--  RESULT SET 5.                                             -- 00236100
      *--                                                            -- 00236200
      *--           RETURN_CODE                INTEGER               -- 00236300
      *--           BUS_RULE_ID                CHAR(10)              -- 00236400
      *--           BUS_RESULT_CD              CHAR(08)              -- 00236500
      *--           BUS_RULE_XREF_ID           CHAR(26)              -- 00236600
      *--                                                            -- 00236700
      ******************************************************************00237000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *  11/12/15  SS7F226    PROCEDURE ORIGINALLY CODED.              *00290000
P00845*  04/28/16  HA7A338    CHANGES MADE TO SEND COMMMENTS, CONTRACT *00291000
P00845*                       COUNTS & MULTI ACCOUNT FLAG DETAILS FOR  *00292000
P00845*                       ACCOUNTS NOT IN COLLECTION.              *00293000
A05460*  04/28/16  SM93554    INCLUDE ARCHIVE ACCOUNT COUNT AS PART OF *00294000
      *            Act-157    MULTI ACCOUNT LOGIC.                     *00295000
A05460*  01/04/17  SM93554    ADDED TO STRIP TO REMOVE ADDITIONAL SPACE*00295100
      *            Act-396    ON THE COMMENT TEXT FIELD.               *00295200
      ******************************************************************00300000
      ******************************************************************00310000
      *                                                                *00320000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00330000
      *                                                                *00340000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00350000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00360000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00370000
      *  3000 - 4999  NOT USED                                         *00380000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00390000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00400000
      *  7000 - 7999  INPUT MODULES                                    *00410000
      *  8000 - 8999  OUTPUT MODULES                                   *00420000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00430000
      *                                                                *00440000
      ******************************************************************00450000
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04884'.
MSQ017     COPY MFASQLM.
                                                                        
       01 WS-START                      PIC X(40) VALUE                 
            'WORKING STORAGE FOR CSR04884 STARTS HERE'.                 
                                                                        
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME               PIC X(08) VALUE 'CSR04884'.     
          05 WS-YES-NULL                PIC S9(4) VALUE -1.             
          05 WS-USER-ID                 PIC X(07) VALUE 'GENESYS'.      
          05 WS-REFUSE-CD               PIC X(02) VALUE 'RE'.           
          05 WS-PAYMENT                 PIC X(01) VALUE 'P'.            
          05 WS-FAILED                  PIC X(01) VALUE 'F'.            
          05 WS-YES                     PIC X(01) VALUE 'Y'.            
          05 WS-NO                      PIC X(01) VALUE 'N'.            
          05 WS-ACTIVE-CNT              PIC X(01) VALUE 'B'.            
          05 WS-ACTIVE-PTP              PIC X(01) VALUE 'A'.            
          05 WS-PENDING-PTP             PIC X(01) VALUE 'P'.            
          05 WS-DOT                     PIC X(01) VALUE '.'.            
          05 WS-ZERO                    PIC S9(4) VALUE 0.              
A00157    05 WS-ONE                     PIC S9(4) VALUE 1.              
      *                                                                 00580000
       01 WS-MISC.                                                      
          05 WS-GTT-NAME                PIC X(19) VALUE SPACES.         
          05 WS-SQLSTATE                PIC X(05) VALUE SPACES.         
          05 WS-DATABASE                PIC 9(01) VALUE ZERO.           
              88  CSR-DATABASE                    VALUE 1.              
              88  SEB-DATABASE                    VALUE 2.              
          05 WS-MULT-ACCTS              PIC X(01) VALUE SPACES.         
          05 WS-ACCOUNT-NO              PIC X(13) VALUE SPACES.         
          05 WS-ACCOUNT-NUM REDEFINES WS-ACCOUNT-NO                     
                                        PIC S9(13).                     
          05 WS-NO-OF-CONTRACTS-3       PIC S9(4)  COMP VALUE 0.        
A00157    05 WS-CURR-ACCT-CNT           PIC S9(4)  COMP VALUE 0.        
A00157    05 WS-ARCHV-ACCT-CNT          PIC S9(4)  COMP VALUE 0.        
          05 WS-RULE-ID-5               PIC X(10)  VALUE SPACES.        
          05 WS-RULE-RESULT-CD-5        PIC X(08)  VALUE SPACES.        
          05 WS-BUS-RULE-XREF-ID-5      PIC X(26)  VALUE SPACES.        
          05 WS-FIRST-NAME-PNTER        PIC 9(03)  VALUE 0.             
          05 WS-LAST-NAME-PNTER         PIC 9(03)  VALUE 0.             
          05 WS-MIDDLE-NAME-PNTER       PIC 9(03)  VALUE 0.             
          05 WS-COMMON-TXT-POINTER      PIC 9(03)  VALUE 0.             
          05 WS-COMMON-TXT              PIC X(254).                     
          05 WS-COMMON-TXT-REVERSED     PIC X(254) VALUE SPACES.        
          05 WS-COMMON-TXT-CHARS        PIC 9(3)   VALUE 0.             
          05 WS-COMMENT-TX.                                             
             49 WS-COMMENT-TX-LEN-3     PIC S9(4)  USAGE COMP.          
             49 WS-COMMENT-TX-TEXT-3    PIC X(512) VALUE SPACES.        
          05 WS-TAB-COMMENTS.                                           
             15 WS-TAB-COMM             PIC X(01)  OCCURS 512 TIMES.    
          05 WS-MAX-LENGTH              PIC S9(04) COMP VALUE 512.      
          05 WS-TX-SUB                  PIC S9(04) COMP VALUE 0.        
          05 WS-COLL-EXEMPTION-CD       PIC X(20)  VALUE SPACES.        
          05 WS-COLL-COMMENT-USER-ID-3  PIC X(07)  VALUE SPACES.        
          05 WS-EMPLOYEE-NAME           PIC X(40)  VALUE SPACE.         
          05 WS-DATE-CCYY-MM-DD.                                        
             10  WS-DATE-CCYY           PIC X(04) VALUE SPACES.         
             10  FILLER                 PIC X(01) VALUE SPACES.         
             10  WS-DATE-MM             PIC X(02) VALUE SPACES.         
             10  FILLER                 PIC X(01) VALUE SPACES.         
             10  WS-DATE-DD             PIC X(02) VALUE SPACES.         
          05 WS-DATE-MM-DD-YYYY.                                        
             10  WS-DATE2-MM            PIC X(02) VALUE SPACES.         
             10  FILLER                 PIC X(01) VALUE '/'.            
             10  WS-DATE2-DD            PIC X(02) VALUE SPACES.         
             10  FILLER                 PIC X(01) VALUE '/'.            
             10  WS-DATE2-CCYY          PIC X(04) VALUE SPACES.         
          05 WS-CREATION-DATE.                                          
             10  WS-DATE3-MM            PIC X(02) VALUE SPACES.         
             10  FILLER                 PIC X(01) VALUE '/'.            
             10  WS-DATE3-DD            PIC X(02) VALUE SPACES.         
             10  FILLER                 PIC X(01) VALUE '/'.            
             10  WS-DATE3-CCYY          PIC X(04) VALUE SPACES.         
          05 WS-CREATION-TIME.                                          
             10  WS-SPACE               PIC X(01) VALUE SPACES.         
             10  WS-MINUTE              PIC X(02) VALUE SPACES.         
             10  WS-COLON               PIC X(01) VALUE ':'.            
             10  WS-SECOND              PIC X(02) VALUE SPACES.         
          05 WS-CREATION-DATE-TIME.                                     
             10 WS-OUTPUT-DATE          PIC X(10) VALUE SPACES.         
             10 WS-OUTPUT-TIME          PIC X(06) VALUE SPACES.         
      *                                                                 00921000
       01 WS-COUNTERS.                                                  
          05 CTR-ROWS-1                 PIC S9(9) COMP VALUE 0.         
          05 CTR-ROWS-2                 PIC S9(9) COMP VALUE 0.         
          05 CTR-ROWS-3                 PIC S9(9) COMP VALUE 0.         
          05 CTR-ROWS-4                 PIC S9(9) COMP VALUE 0.         
          05 CTR-ROWS-5                 PIC S9(9) COMP VALUE 0.         
          05 WS-HIST-COUNT              PIC S9(9) COMP VALUE 0.         
          05 WS-PYMT-COUNT              PIC S9(9) COMP VALUE 0.         
      *                                                                 00924400
       01 WS-NULL-FLDS.                                                 
          05 WS-NULL-WRITE-OFF-DT       PIC S9(04) COMP.                
          05 WS-NULL-COLL-EXEMPTION-CD  PIC S9(04) COMP.                
          05 WS-NULL-COLL-COMMENT-TX    PIC S9(04) COMP.                
          05 WS-NULL-PTP-DT             PIC S9(04) COMP.                
          05 WS-NULL-TRANS-ID           PIC S9(04) COMP.                
          05 WS-NULL-COMMENTS-TX        PIC S9(04) COMP.                
          05 WS-NULL-DATE-TRANS         PIC S9(04) COMP.                
      *                                                                 00925400
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW               PIC X(01) VALUE 'Y'.            
             88 SEND-DONE-ERROR                   VALUE 'N'.            
             88 SEND-DONE-OK                      VALUE 'Y'.            
          05 WS-NO-MORE-ROWS-C1         PIC X(01) VALUE 'N'.            
             88 NO-MORE-ROWS-C1                   VALUE 'Y'.            
          05 WS-NO-MORE-ROWS-C2         PIC X(01) VALUE 'N'.            
             88 NO-MORE-ROWS-C2                   VALUE 'Y'.            
P00845    05 WS-ACCT-IN-COLL            PIC X(01) VALUE 'Y'.            
P00845       88 ACCT-NOT-IN-COLL                  VALUE 'N'.            
P00845       88 ACCT-IN-COLL                      VALUE 'Y'.            
      *                                                                 01310000
       01 GTT-RETURN-FIELDS-1.                                          
             10 S-RETURN-CODE-1         PIC S9(4)    COMP VALUE 0.      
             10 S-COLL-HIST-SEQ-TS-1    PIC X(26)    VALUE SPACES.      
             10 S-COLL-Q-1              PIC X(05)    VALUE SPACES.      
             10 S-COLL-EXEMPTION-CD-1   PIC X(01)    VALUE SPACES.      
             10 S-WRITE-OFF-DATE-1      PIC X(10)    VALUE SPACES.      
             10 S-FUTURE-WORK-DATE-1    PIC X(10)    VALUE SPACES.      
             10 S-BILL-ADDR-FLAG-1      PIC X(01)    VALUE SPACES.      
             10 S-MULTI-ACCTS-FLAG-1    PIC X(01)    VALUE SPACES.      
             10 S-PERM-COMMENT-TEXT-1   PIC X(254)   VALUE SPACES.      
COB305       10 S-TRANS-ID-1        PIC S9(13)V USAGE COMP-3 VALUE 0.       
             10 S-DNP-FLAG-1            PIC X(01)    VALUE SPACES.      
      *                                                                 01390000
       01 GTT-RETURN-FIELDS-2.                                          
             10 S-RETURN-CODE-2         PIC S9(4)    COMP VALUE 0.      
COB305       10 S-TRANS-ID-2        PIC S9(13)V USAGE COMP-3 VALUE 0.       
             10 S-PROMISE-TO-PAY-STATUS-2 PIC X(01)  VALUE SPACES.      
             10 S-PROMISE-TO-PAY-ACTION-2 PIC X(04)  VALUE SPACES.      
             10 S-PROMISE-TO-PAY-RESULT-2 PIC X(04)  VALUE SPACES.      
             10 S-PROMISE-TO-PAY-DATE-2 PIC X(10)    VALUE SPACES.      
COB305       10 S-PROMISE-TO-PAY-AMT-2        PIC S9(9)V9(2) 
COB305       USAGE COMP-3 VALUE 0.    
      *                                                                 01460000
       01 GTT-RETURN-FIELDS-3.                                          
             10 S-RETURN-CODE-3         PIC S9(4)    COMP VALUE 0.      
             10 S-NO-OF-CONTRACTS-3     PIC S9(4)    COMP VALUE 0.      
             10 S-PROMISE-KEPT-NO-3     PIC S9(9) USAGE COMP.           
             10 S-PROMISE-BROKEN-NO-3   PIC S9(9) USAGE COMP.           
             10 S-COLL-EXEMPTION-CD-3   PIC X(20)    VALUE SPACES.      
             10 S-COLL-COMMENT-DATETIME-3 PIC X(16)  VALUE SPACES.      
             10 S-COLL-COMMENT-USER-ID-3  PIC X(40)  VALUE SPACES.      
             10 S-COMMENT-TEXT-3        PIC X(512)   VALUE SPACES.      
      *                                                                 01540000
       01 GTT-RETURN-FIELDS-4.                                          
             10 S-RETURN-CODE-4         PIC S9(4)    COMP VALUE 0.      
             10 S-AR-DATE-TRANS-4       PIC X(10)    VALUE SPACES.      
COB305       10 S-AR-AMT-ORIG-ENTERED-4        PIC S9(9)V9(2) 
COB305       USAGE COMP-3 VALUE 0.    
      *                                                                 01580000
       01 GTT-RETURN-FIELDS-5.                                          
             10 S-RETURN-CODE-5         PIC S9(4)    COMP VALUE 0.      
             10 S-RULE-ID-5             PIC X(10)    VALUE SPACES.      
             10 S-RULE-RESULT-CD-5      PIC X(08)    VALUE SPACES.      
             10 S-BUS-RULE-XREF-ID-5    PIC X(26)    VALUE SPACES.      
                                                                        
                                                                        
       01  WS-END                    PIC X(40)                          
           VALUE 'WORKING STORAGE FOR CSR04884 ENDS HERE  '.            
                                                                        
      ******************************************************************03191000
      *               COBOL WORKING STORAGE COPY BOOKS                 *03192000
      ******************************************************************03193000
           COPY CWS00056.                                               03194206
                                                                        
      ***************************************************************** 03195100
      *    WORKING STORAGE FOR CPD00004(6010-REDUCE-EMBEDDED-SPACES)  * 03195200
      ***************************************************************** 03195300
           COPY CWS0011A.                                               03195606
                                                                        
      ***************************************************************** 03195800
      *    COPY BOOKS USED FOR CPD00068.                                03196000
      ******************************************************************03197000
      *                                                                 03198000
           EXEC SQL                                                     03199000
              INCLUDE CWS00068                                          03199100
           END-EXEC.                                                    03199200
      *                                                                 03199300
      ***************************************************************** 03199400
      *    ERROR HANDLING                                               03199500
      ******************************************************************03199600
      *                                                                 03199700
           EXEC SQL                                                     03199800
              INCLUDE CWSX0010                                          03199900
           END-EXEC.                                                    03200000
      *                                                                 03200100
      ******************************************************************03200200
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *03200300
      ******************************************************************03200400
      *                                                                 03200500
           COPY CWS00303.                                               03200600
      *                                                                 03200700
      ******************************************************************03200800
      *    COPYBOOK FOR CWS00309                                       *03200900
      ******************************************************************03201000
      *                                                                 03201100
           EXEC SQL                                                     03201200
              INCLUDE CWS00309                                          03201300
           END-EXEC.                                                    03201400
      *                                                                 03201500
      *                                                                 03201600
      ******************************************************************03201700
      *    COPYBOOK FOR CPD04353                                       *03201800
      ******************************************************************03201900
      *                                                                 03202000
           EXEC SQL                                                     03202100
              INCLUDE CWS04353                                          03202200
           END-EXEC.                                                    03202300
      *                                                                 03202400
      ******************************************************************03202500
      *   SQL COMMUNICATION AREA                                       *03202600
      ******************************************************************03202700
      *                                                                 03202800
           EXEC SQL                                                     03202900
               INCLUDE SQLCA                                            03203000
           END-EXEC.                                                    03203100
      *                                                                 03203200
      ******************************************************************03203300
      *    CSS_AR_TRANS_HIST  - AR                                     *03203400
      ******************************************************************03203500
      *                                                                 03203600
           EXEC SQL                                                     03203700
               INCLUDE TBARHIST                                         03203800
           END-EXEC.                                                    03203900
      *                                                                 03204000
      ******************************************************************03204100
      *    CSS_ACCOUNT  - AT                                           *03204200
      ******************************************************************03204300
      *                                                                 03204400
           EXEC SQL                                                     03204500
                INCLUDE TBACCT                                          03204600
           END-EXEC.                                                    03204700
      *                                                                 03204800
      ******************************************************************03204900
      *    CSS_CONTRACT - CT                                           *03205000
      ******************************************************************03205100
      *                                                                 03205200
           EXEC SQL                                                     03205300
                INCLUDE TBCNTRCT                                        03205400
           END-EXEC.                                                    03205500
      *                                                                 03205600
      ******************************************************************03205700
      *    CSS_DELINQUENCY  -  C8                                      *03205800
      ******************************************************************03205900
      *                                                                 03206000
           EXEC SQL                                                     03206100
                INCLUDE TBDELQ                                          03206200
           END-EXEC.                                                    03206300
      *                                                                 03206400
      ******************************************************************03206500
      *    CSS_COLLECT_HIST  - HC                                    *  03206600
      ******************************************************************03206700
      *                                                                 03206800
           EXEC SQL                                                     03206900
               INCLUDE TBCOLHST                                         03207000
           END-EXEC.                                                    03207100
      *                                                                 03207200
      ******************************************************************03207300
      *    CSS_COLL_ACCT_INFO  - IF                                    *03207400
      ******************************************************************03207500
      *                                                                 03207600
           EXEC SQL                                                     03207700
               INCLUDE TBACCINF                                         03207800
           END-EXEC.                                                    03207900
      *                                                                 03208000
      ******************************************************************03208100
      *    CSS_COLL_HIST_DET  - LH                                     *03208200
      ******************************************************************03208300
      *                                                                 03208400
           EXEC SQL                                                     03208500
                INCLUDE TBCOLDET                                        03208600
           END-EXEC.                                                    03209000
      *                                                                 03212800
      ******************************************************************03212900
      *    CSS_USER_PROFILE   - PF                                     *03213000
      ******************************************************************03214000
      *                                                                 03215000
           EXEC SQL                                                     03216000
                INCLUDE TBUSRPRF                                        03217000
           END-EXEC.                                                    03218000
      *                                                                 03219000
                                                                        
                                                                        
      ***************************************************************   03224100
      ***  TO FETCH THE COLLECTIONS HISTORY DETAILS FOR THE ACCOUNT     03224200
      *                                                                 03224300
           EXEC SQL                                                     
             DECLARE COLLECT_DET CURSOR FOR                             
              SELECT TOP(100) LH.RECORD_CREATION_DT,
              LH.PTP_STATUS_CD,
              LH.COLL_ACTION_CD,
              LH.COLL_RESULT_CD,
              LH.PTP_DT,
              LH.PTP_AMT,
              LH.COMMENTS_TX,
              LH.COLL_AGENT_ID,
              LH.TRANS_ID                                        
               FROM CSS_COLL_HIST_DET LH WITH(READUNCOMMITTED)                  
              WHERE LH.ACCOUNT_NO     = :LH-ACCOUNT-NO                  
                AND LH.LAST_UPDATE_USERID <> :WS-USER-ID                
                AND LH.COLL_RESULT_CD     <> :WS-REFUSE-CD              
              ORDER BY LH.RECORD_CREATION_DT DESC                       
                      ,LH.TRANS_ID DESC                                 
                                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     03224500
MFA-TR*      DECLARE COLLECT_DET CURSOR FOR                             03224600
MFA-TR*       SELECT LH.RECORD_CREATION_DT                              03224700
MFA-TR*             ,LH.PTP_STATUS_CD                                   03224800
MFA-TR*             ,LH.COLL_ACTION_CD                                  03224900
MFA-TR*             ,LH.COLL_RESULT_CD                                  03225000
MFA-TR*             ,LH.PTP_DT                                          03225100
MFA-TR*             ,LH.PTP_AMT                                         03225200
MFA-TR*             ,LH.COMMENTS_TX                                     03225300
MFA-TR*             ,LH.COLL_AGENT_ID                                   03225400
MFA-TR*             ,LH.TRANS_ID                                        03225600
MFA-TR*        FROM CSS_COLL_HIST_DET LH                                03225700
MFA-TR*       WHERE LH.ACCOUNT_NO     = :LH-ACCOUNT-NO                  03225800
MFA-TR*         AND LH.LAST_UPDATE_USERID <> :WS-USER-ID                03225900
MFA-TR*         AND LH.COLL_RESULT_CD     <> :WS-REFUSE-CD              03226000
MFA-TR*       ORDER BY LH.RECORD_CREATION_DT DESC                       03226100
MFA-TR*               ,LH.TRANS_ID DESC                                 03226200
MFA-TR*      FETCH FIRST 100 ROWS ONLY WITH UR                          03226300
MFA-TR*      QUERYNO 7100                                               03226500
MFA-TR*    END-EXEC.                                                    03226600
      *                                                                 03226700
      ***************************************************************   03226800
      ***  TO FETCH THE PAYMENT DETAILS FOR RESULT SET(4)               03226900
      *                                                                 03227000
           EXEC SQL                                                     
             DECLARE PAYMENTS_CURSOR CURSOR FOR                         
              SELECT TOP(15) AR.AMT_ORIG_ENTERED,
              AR.DATE_TRANS                                      
               FROM CSS_AR_TRANS_HIST AR WITH(READUNCOMMITTED)                  
              WHERE AR.ACCOUNT_NO     = :AR-ACCOUNT-NO                  
                AND AR.CODE_TRAN_TYPE = :WS-PAYMENT                     
                AND AR.RECORD_ONLY_FL <> :WS-YES                        
                ORDER BY DATE_TRANS DESC                                
                                         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     03227100
MFA-TR*      DECLARE PAYMENTS_CURSOR CURSOR FOR                         03227200
MFA-TR*       SELECT AR.AMT_ORIG_ENTERED                                03227300
MFA-TR*             ,AR.DATE_TRANS                                      03227400
MFA-TR*        FROM CSS_AR_TRANS_HIST AR                                03227500
MFA-TR*       WHERE AR.ACCOUNT_NO     = :AR-ACCOUNT-NO                  03227600
MFA-TR*         AND AR.CODE_TRAN_TYPE = :WS-PAYMENT                     03227700
MFA-TR*         AND AR.RECORD_ONLY_FL <> :WS-YES                        03227800
MFA-TR*         ORDER BY DATE_TRANS DESC                                03227900
MFA-TR*      FETCH FIRST 15 ROWS ONLY WITH UR                           03228000
MFA-TR*      QUERYNO 7200                                               03228100
MFA-TR*    END-EXEC.                                                    03228200
      *                                                                 03228300
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO           PIC  X(13).                        
      *                                                                 03229000
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
      *                                                                 03240000
      ******************************************************************03250000
      * 0000-MAINLINE                                                  *03260000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *03270000
      ******************************************************************03280000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
           
MSQ016        GOBACK.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03400000
      ******************************************************************03410000
      * 0100-INITIALIZE                                                *03420000
      ******************************************************************03430000
      *                                                                 03440000
       0100-INITIALIZE.                                                 
                                                                        
           PERFORM 0100A-DECLARE-GTT          THRU 0100A-EXIT.          
           PERFORM 0100B-DECLARE-GTT          THRU 0100B-EXIT.          
           PERFORM 0100C-DECLARE-GTT          THRU 0100C-EXIT.          
           PERFORM 0100D-DECLARE-GTT          THRU 0100D-EXIT.          
           PERFORM 0100E-DECLARE-GTT          THRU 0100E-EXIT.          
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03610000
      ******************************************************************03620000
      * 0100A-DECLARE-GTT  - COLLECTION ACCOUNT DETAILS.               *03630000
      ******************************************************************03640000
      *                                                                 03650000
       0100A-DECLARE-GTT.                                               
      *                                                                 03670000
           MOVE 'SESSION.CSR04884_R1'        TO WS-GTT-NAME.            
      *                                                                 03690000
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04884_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04884_R1
              (                                                       
                    RETURN_CODE                 INT                 
                   ,COLL_HIST_SEQ_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,COLL_Q CHAR(5)  COLLATE LATIN1_GENERAL_100_BIN2             
                   ,COLL_EXEMPTION_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,WRITE_OFF_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,FUTURE_WORK_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,BILL_ADDR_FLAG CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,MULTI_ACCTS_FLAG CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,PERM_COMMENT_TEXT CHAR(254)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2               
                   ,TRANS_ID                    DECIMAL(13,0)           
                   ,DNP_FLAG CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 03810000
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                 03850000
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS      THRU 8000A-EXIT           
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '0100A'                TO ACTIVE-PARAGRAPH        
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE WS-GTT-NAME            TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
      *                                                                 04050000
           EXEC SQL                                                     
              DECLARE C1 CURSOR                              
                                WITH ROWSET POSITIONING FOR             
               SELECT RETURN_CODE                                       
                     ,LTRIM(RTRIM(COLL_HIST_SEQ_TS))  AS 
           COLL_HIST_SEQ_TS      
                     ,LTRIM(RTRIM(COLL_Q))            AS COLL_Q                
                     ,LTRIM(RTRIM(COLL_EXEMPTION_CD)) AS 
           COLL_EXEMPTION_CD     
                     ,LTRIM(RTRIM(WRITE_OFF_DATE))    AS WRITE_OFF_DATE        
                     ,LTRIM(RTRIM(FUTURE_WORK_DATE))  AS 
           FUTURE_WORK_DATE      
                     ,LTRIM(RTRIM(BILL_ADDR_FLAG))    AS BILL_ADDR_FLAG        
                     ,LTRIM(RTRIM(MULTI_ACCTS_FLAG))  AS 
           MULTI_ACCTS_FLAG      
                     ,LTRIM(RTRIM(PERM_COMMENT_TEXT)) AS 
           PERM_COMMENT_TEXT     
                     ,TRANS_ID                 AS TRANS_ID              
                     ,LTRIM(RTRIM(DNP_FLAG))          AS DNP_FLAG              
                FROM #CSR04884_R1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     04051000
MFA-TR*       DECLARE C1 CURSOR WITH RETURN                             04052000
MFA-TR*                         WITH ROWSET POSITIONING FOR             04052100
MFA-TR*        SELECT RETURN_CODE                                       04053000
MFA-TR*              ,STRIP(COLL_HIST_SEQ_TS)  AS COLL_HIST_SEQ_TS      04054000
MFA-TR*              ,STRIP(COLL_Q)            AS COLL_Q                04055000
MFA-TR*              ,STRIP(COLL_EXEMPTION_CD) AS COLL_EXEMPTION_CD     04056000
MFA-TR*              ,STRIP(WRITE_OFF_DATE)    AS WRITE_OFF_DATE        04056100
MFA-TR*              ,STRIP(FUTURE_WORK_DATE)  AS FUTURE_WORK_DATE      04056200
MFA-TR*              ,STRIP(BILL_ADDR_FLAG)    AS BILL_ADDR_FLAG        04056300
MFA-TR*              ,STRIP(MULTI_ACCTS_FLAG)  AS MULTI_ACCTS_FLAG      04056400
MFA-TR*              ,STRIP(PERM_COMMENT_TEXT) AS PERM_COMMENT_TEXT     04056500
MFA-TR*              ,TRANS_ID                 AS TRANS_ID              04056600
MFA-TR*              ,STRIP(DNP_FLAG)          AS DNP_FLAG              04056700
MFA-TR*         FROM SESSION.CSR04884_R1                                04057000
MFA-TR*    END-EXEC.                                                    04058000
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                 04080000
      ******************************************************************04090000
      * 0100B-DECLARE-GTT   - PROMISE TO PAY DETAILS.                  *04091000
      ******************************************************************04092000
      *                                                                 04093000
       0100B-DECLARE-GTT.                                               
      *                                                                 04093200
           MOVE 'SESSION.CSR04884_R2'        TO WS-GTT-NAME.            
      *                                                                 04093400
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04884_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04884_R2
              (                                                       
                    RETURN_CODE                 INT                 
                   ,TRANS_ID                    DECIMAL(13,0)           
                   ,PROMISE_TO_PAY_STATUS CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,PROMISE_TO_PAY_ACTION CHAR(04)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,PROMISE_TO_PAY_RESULT CHAR(04)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,PROMISE_TO_PAY_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,PROMISE_TO_PAY_AMT          DECIMAL(11,2)           
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 04094900
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                 04095200
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS      THRU 8000B-EXIT           
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '0100B'                TO ACTIVE-PARAGRAPH        
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE WS-GTT-NAME            TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
      *                                                                 04097200
           EXEC SQL                                                     
              DECLARE C2 CURSOR                              
                                WITH ROWSET POSITIONING FOR             
               SELECT RETURN_CODE                                       
                     ,TRANS_ID              AS TRANS_ID                 
                     ,LTRIM(RTRIM(PROMISE_TO_PAY_STATUS))                      
                                            AS PROMISE_TO_PAY_STATUS    
                     ,LTRIM(RTRIM(PROMISE_TO_PAY_ACTION))                      
                                            AS PROMISE_TO_PAY_ACTION    
                     ,LTRIM(RTRIM(PROMISE_TO_PAY_RESULT))                      
                                            AS PROMISE_TO_PAY_RESULT    
                     ,LTRIM(RTRIM(PROMISE_TO_PAY_DATE))  AS 
           PROMISE_TO_PAY_DATE
                     ,PROMISE_TO_PAY_AMT    AS PROMISE_TO_PAY_AMT       
                FROM #CSR04884_R2                                
                ORDER BY PROMISE_TO_PAY_STATUS                          
                        ,PROMISE_TO_PAY_DATE                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     04097300
MFA-TR*       DECLARE C2 CURSOR WITH RETURN                             04097400
MFA-TR*                         WITH ROWSET POSITIONING FOR             04097500
MFA-TR*        SELECT RETURN_CODE                                       04097600
MFA-TR*              ,TRANS_ID              AS TRANS_ID                 04097700
MFA-TR*              ,STRIP(PROMISE_TO_PAY_STATUS)                      04097900
MFA-TR*                                     AS PROMISE_TO_PAY_STATUS    04098000
MFA-TR*              ,STRIP(PROMISE_TO_PAY_ACTION)                      04098100
MFA-TR*                                     AS PROMISE_TO_PAY_ACTION    04098200
MFA-TR*              ,STRIP(PROMISE_TO_PAY_RESULT)                      04098500
MFA-TR*                                     AS PROMISE_TO_PAY_RESULT    04098600
MFA-TR*              ,STRIP(PROMISE_TO_PAY_DATE)  AS PROMISE_TO_PAY_DATE04098700
MFA-TR*              ,PROMISE_TO_PAY_AMT    AS PROMISE_TO_PAY_AMT       04098800
MFA-TR*         FROM SESSION.CSR04884_R2                                04098900
MFA-TR*         ORDER BY PROMISE_TO_PAY_STATUS                          04099000
MFA-TR*                 ,PROMISE_TO_PAY_DATE                            04099100
MFA-TR*    END-EXEC.                                                    04099200
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
      *                                                                 04099600
      ******************************************************************04099700
      * 0100C-DECLARE-GTT   -  PROMISE KEPT/BROKEN DETAILS.            *04099800
      ******************************************************************04099900
      *                                                                 04100000
       0100C-DECLARE-GTT.                                               
      *                                                                 04100200
           MOVE 'SESSION.CSR04884_R3'        TO WS-GTT-NAME.            
      *                                                                 04100400
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04884_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04884_R3
              (                                                       
                    RETURN_CODE                 INT                 
                   ,NO_OF_CONTRACTS             INT                 
                   ,PROMISE_KEPT_NO             INT                 
                   ,PROMISE_BROKEN_NO           INT                 
                   ,COLL_EXEMPTION_CD_3 CHAR(20)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,COLL_COMMENT_DATETIME CHAR(16)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,COLL_COMMENT_USER_ID CHAR(40)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,COMMENT_TEXT VARCHAR(512)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2            
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 04101900
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                 04102200
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000C-DEL-GTT-ROWS      THRU 8000C-EXIT           
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '0100C'                TO ACTIVE-PARAGRAPH        
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE WS-GTT-NAME            TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
      *                                                                 04104200
           EXEC SQL                                                     
              DECLARE C3 CURSOR                              
                                WITH ROWSET POSITIONING FOR             
               SELECT RETURN_CODE                                       
                     ,NO_OF_CONTRACTS      AS NO_OF_CONTRACTS           
                     ,PROMISE_KEPT_NO      AS PROMISE_KEPT_NO           
                     ,PROMISE_BROKEN_NO    AS PROMISE_BROKEN_NO         
                     ,LTRIM(RTRIM(COLL_EXEMPTION_CD_3)) AS 
           COLL_EXEMPTION_CD   
                     ,LTRIM(RTRIM(COLL_COMMENT_DATETIME))                      
                                           AS COLL_COMMENT_DATETIME     
                     ,LTRIM(RTRIM(COLL_COMMENT_USER_ID))                       
                                           AS COLL_COMMENT_USER_ID      
                     ,LTRIM(RTRIM(COMMENT_TEXT))  AS COMMENT_TEXT              
                FROM #CSR04884_R3                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     04104300
MFA-TR*       DECLARE C3 CURSOR WITH RETURN                             04104400
MFA-TR*                         WITH ROWSET POSITIONING FOR             04104500
MFA-TR*        SELECT RETURN_CODE                                       04104600
MFA-TR*              ,NO_OF_CONTRACTS      AS NO_OF_CONTRACTS           04104700
MFA-TR*              ,PROMISE_KEPT_NO      AS PROMISE_KEPT_NO           04104800
MFA-TR*              ,PROMISE_BROKEN_NO    AS PROMISE_BROKEN_NO         04104900
MFA-TR*              ,STRIP(COLL_EXEMPTION_CD_3) AS COLL_EXEMPTION_CD   04105000
MFA-TR*              ,STRIP(COLL_COMMENT_DATETIME)                      04105100
MFA-TR*                                    AS COLL_COMMENT_DATETIME     04105200
MFA-TR*              ,STRIP(COLL_COMMENT_USER_ID)                       04105300
MFA-TR*                                    AS COLL_COMMENT_USER_ID      04105400
MFA-TR*              ,STRIP(COMMENT_TEXT)  AS COMMENT_TEXT              04105500
MFA-TR*         FROM SESSION.CSR04884_R3                                04105600
MFA-TR*    END-EXEC.                                                    04105700
                                                                        
       0100C-EXIT.                                                      
            EXIT.                                                       
      *                                                                 04106100
      ******************************************************************04106200
      * 0100D-DECLARE-GTT   -  PAYMENT HIST DETAILS.                   *04106300
      ******************************************************************04106400
      *                                                                 04106500
       0100D-DECLARE-GTT.                                               
      *                                                                 04106700
           MOVE 'SESSION.CSR04884_R4'        TO WS-GTT-NAME.            
      *                                                                 04106900
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04884_R4')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04884_R4
              (                                                       
                    RETURN_CODE                 INT                 
                   ,AR_DATE_TRANS CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,AR_AMT_ORIG_ENTERED         DECIMAL(11,2)          
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 04107900
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                 04108200
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000D-DEL-GTT-ROWS      THRU 8000D-EXIT           
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '0100D'                TO ACTIVE-PARAGRAPH        
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE WS-GTT-NAME            TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
      *                                                                 04110200
           EXEC SQL                                                     
              DECLARE C4 CURSOR                              
                                WITH ROWSET POSITIONING FOR             
               SELECT RETURN_CODE                                       
                     ,LTRIM(RTRIM(AR_DATE_TRANS)) AS AR_DATE_TRANS             
                     ,AR_AMT_ORIG_ENTERED  AS AR_AMT_ORIG_ENTERED       
                FROM #CSR04884_R4                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     04110300
MFA-TR*       DECLARE C4 CURSOR WITH RETURN                             04110400
MFA-TR*                         WITH ROWSET POSITIONING FOR             04110500
MFA-TR*        SELECT RETURN_CODE                                       04110600
MFA-TR*              ,STRIP(AR_DATE_TRANS) AS AR_DATE_TRANS             04110700
MFA-TR*              ,AR_AMT_ORIG_ENTERED  AS AR_AMT_ORIG_ENTERED       04110800
MFA-TR*         FROM SESSION.CSR04884_R4                                04110900
MFA-TR*    END-EXEC.                                                    04111000
                                                                        
       0100D-EXIT.                                                      
            EXIT.                                                       
      *                                                                 04111400
      *                                                                 04111500
      ******************************************************************04111600
      * 0100E-DECLARE-GTT  -   COMMON BUSINESS RULE DETAILS.           *04111700
      ******************************************************************04111800
      *                                                                 04111900
       0100E-DECLARE-GTT.                                               
      *                                                                 04112100
           MOVE 'SESSION.CSR04884_R5'        TO WS-GTT-NAME.            
      *                                                                 04112300
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04884_R5')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04884_R5
              (                                                       
                    RETURN_CODE                 INT                 
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,BUS_RESULT_CD CHAR(08)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 04113400
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                 04113700
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000E-DEL-GTT-ROWS      THRU 8000E-EXIT           
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '0100E'                TO ACTIVE-PARAGRAPH        
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE WS-GTT-NAME            TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
      *                                                                 04115700
           EXEC SQL                                                     
              DECLARE C5 CURSOR                              
                                WITH ROWSET POSITIONING FOR             
               SELECT RETURN_CODE                                       
                     ,LTRIM(RTRIM(BUS_RULE_ID))        AS BUS_RULE_ID          
                     ,LTRIM(RTRIM(BUS_RESULT_CD))      AS BUS_RESULT_CD        
                     ,LTRIM(RTRIM(BUS_RULE_XREF_ID))   AS 
           BUS_RULE_XREF_ID     
                FROM #CSR04884_R5                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     04115800
MFA-TR*       DECLARE C5 CURSOR WITH RETURN                             04115900
MFA-TR*                         WITH ROWSET POSITIONING FOR             04116000
MFA-TR*        SELECT RETURN_CODE                                       04116100
MFA-TR*              ,STRIP(BUS_RULE_ID)        AS BUS_RULE_ID          04116200
MFA-TR*              ,STRIP(BUS_RESULT_CD)      AS BUS_RESULT_CD        04116300
MFA-TR*              ,STRIP(BUS_RULE_XREF_ID)   AS BUS_RULE_XREF_ID     04116400
MFA-TR*         FROM SESSION.CSR04884_R5                                04116500
MFA-TR*    END-EXEC.                                                    04116600
                                                                        
       0100E-EXIT.                                                      
            EXIT.                                                       
      *                                                                 04117000
      ******************************************************************04117100
      * 1000-PROCESS-INPUT.                                            *04117200
      ******************************************************************04118000
      *                                                                 04120000
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO              TO WS-ACCOUNT-NO.          
           MOVE WS-ACCOUNT-NUM               TO LH-ACCOUNT-NO           
                                                HC-ACCOUNT-NO           
                                                IF-ACCOUNT-NO           
                                                AR-ACCOUNT-NO           
                                                CT-ACCOUNT-NO           
                                                AT-ACCOUNT-NO.          
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04430000
      * 2000-PROCESS-OUTPUT                                            *04440000
      ******************************************************************04450000
       2000-PROCESS-OUTPUT.                                             
                                                                        
           INITIALIZE                           GTT-RETURN-FIELDS-1     
                                                GTT-RETURN-FIELDS-5.    
P00845     SET ACCT-IN-COLL                  TO TRUE.                   
                                                                        
           PERFORM 2250-GET-PAYMENT-HIST      THRU 2250-EXIT.           
           PERFORM 2100-COLL-MAIN-PROCESS     THRU 2100-EXIT.           
           PERFORM 2200-GET-COLL-HIST-DET     THRU 2200-EXIT.           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04686700
      *                                                                *04686900
      * 2100-COLL-MAIN-PROCESS.                                        *04687000
      ******************************************************************04687100
       2100-COLL-MAIN-PROCESS.                                          
                                                                        
      *    GET ACCOUNT INFORMATION                                      04687400
           PERFORM 2110-PROCESS-ACCOUNT-DATA  THRU 2110-EXIT.           
                                                                        
      *    GET NUMBER OF CONTRACTS FOR R3                               04687700
           PERFORM 7200-GET-NO-OF-CONTRACTS     THRU 7200-EXIT.         
           MOVE WS-NO-OF-CONTRACTS-3         TO S-NO-OF-CONTRACTS-3.    
                                                                        
      *    GET COLLECTION ACCOUNT INFORMATION                           04691600
           PERFORM 2120-COLL-ACCOUNT-PROCESS  THRU 2120-EXIT.           
                                                                        
      *    GET COLLECTION HIST INFORMATION                              04692000
P00845     IF ACCT-IN-COLL                                              
              PERFORM 2140-COLLECT-HIST-PROCESS                         
                                              THRU 2140-EXIT            
P00845     END-IF.                                                      
                                                                        
      *    GET DNP-FLAG FROM DELINQUENCY FOR R1                         04692600
           MOVE 'CQ-DNP'                     TO C8-DELINQ-CD.           
           MOVE AT-COMPANY-NO                TO C8-COMPANY-NO.          
           PERFORM 7250-GET-DELINQUENCY-VALUE                           
                                              THRU 7250-EXIT.           
           IF C8-DELINQ-VALUE > 0                                       
              MOVE WS-YES                    TO S-DNP-FLAG-1            
           ELSE                                                         
              MOVE WS-NO                     TO S-DNP-FLAG-1            
           END-IF.                                                      
                                                                        
           PERFORM 8010-INSERT-GTT-R1         THRU 8010-EXIT.           
                                                                        
        2100-EXIT.                                                      
             EXIT.                                                      
      *                                                                 04699500
      ******************************************************************04699600
      *                                                                *04699700
      * 2110-PROCESS-ACCOUNT-DATA.                                     *04699800
      * GET DETAILS FROM ACCOUNT TABLE IF ACCOUNT NOT PRESENT IN THE   *04699900
      * TABLE END THE PROGRAM NORMALLY BY INSERTING BUS RULE(R5).      *04700000
      ******************************************************************04700100
       2110-PROCESS-ACCOUNT-DATA.                                       
                                                                        
           PERFORM 7000-GET-ACCT-DATA           THRU 7000-EXIT.         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF AT-ADDRESS-ID > 0                                      
                 MOVE WS-YES                 TO S-BILL-ADDR-FLAG-1      
              ELSE                                                      
                 MOVE WS-NO                  TO S-BILL-ADDR-FLAG-1      
              END-IF                                                    
           ELSE                                                         
              MOVE 'CRDCOLL020'              TO S-RULE-ID-5             
              MOVE WS-FAILED                 TO S-RULE-RESULT-CD-5      
              IF S-RULE-ID-5 GREATER THAN SPACES                        
                 PERFORM 7650-GET-RULE-XREF-ID  THRU 7650-EXIT          
              END-IF                                                    
              PERFORM 8050-INSERT-GTT-R5        THRU 8050-EXIT          
              PERFORM 9999-END-PROGRAM          THRU 9999-EXIT          
           END-IF.                                                      
                                                                        
A00157     PERFORM 7150-GET-CURR-ACCT-CNT       THRU 7150-EXIT.         
A00157                                                                  
A00157     IF WS-CURR-ACCT-CNT <= WS-ONE                                
A00157        PERFORM 7160-GET-ARCHV-ACCT-CNT   THRU 7160-EXIT          
A00157     END-IF                                                       
A00157                                                                  
A00157     IF (WS-CURR-ACCT-CNT + WS-ARCHV-ACCT-CNT) > WS-ONE           
A00157         MOVE WS-YES                   TO S-MULTI-ACCTS-FLAG-1    
A00157     ELSE                                                         
A00157         MOVE WS-NO                    TO S-MULTI-ACCTS-FLAG-1    
A00157     END-IF.                                                      
                                                                        
        2110-EXIT.                                                      
             EXIT.                                                      
      *                                                                 04704200
      ******************************************************************04704300
      * 2120-COLL-ACCOUNT-PROCESS.                                     *04704400
      * GET COLLECTION ACCOUNT DETAILS FROM COLL_ACCT_INFO TABLE       *04704500
      * IF ACCOUNT NOT PRESENT END THE PROGRAM NORMALLY AND INSERT     *04704600
      * BUS RULE (R5).                                                 *04704700
      ******************************************************************04704800
      *                                                                 04705000
       2120-COLL-ACCOUNT-PROCESS.                                       
      *                                                                 04720000
           PERFORM 7210-GET-COLL-ACCT-INFO    THRU 7210-EXIT.           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-NULL-COLL-EXEMPTION-CD = WS-YES-NULL                
                 MOVE SPACES                 TO IF-COLL-EXEMPTION-CD    
              ELSE                                                      
                 MOVE IF-COLL-EXEMPTION-CD(6:1)                         
                                             TO S-COLL-EXEMPTION-CD-1   
                 MOVE IF-COLL-EXEMPTION-CD   TO WS-COLL-EXEMPTION-CD    
                 PERFORM 2160-REDUCE-EMBEDDED-SPACES                    
                                              THRU 2160-EXIT            
              END-IF                                                    
                                                                        
              IF WS-NULL-COLL-COMMENT-TX = WS-YES-NULL                  
                 MOVE SPACES                 TO S-PERM-COMMENT-TEXT-1   
                                                IF-COLL-COMMENT-TX      
              ELSE                                                      
                 MOVE IF-COLL-COMMENT-TX-TEXT                           
                                             TO WS-COMMENT-TX-TEXT-3    
                 PERFORM 2227-REMOVE-JUNK-DATA                          
                                              THRU 2227-EXIT            
                 MOVE WS-TAB-COMMENTS(1:WS-TX-SUB)                      
                                             TO S-PERM-COMMENT-TEXT-1   
              END-IF                                                    
                                                                        
              MOVE IF-PROMISE-KEPT-NO        TO S-PROMISE-KEPT-NO-3     
              MOVE IF-PROMISE-BROKEN-NO      TO S-PROMISE-BROKEN-NO-3   
           ELSE                                                         
              MOVE 'CRDCOLL001'              TO S-RULE-ID-5             
              MOVE WS-FAILED                 TO S-RULE-RESULT-CD-5      
              IF S-RULE-ID-5 GREATER THAN SPACES                        
                 PERFORM 7650-GET-RULE-XREF-ID                          
                                              THRU 7650-EXIT            
              END-IF                                                    
              PERFORM 8050-INSERT-GTT-R5      THRU 8050-EXIT            
P00845        SET ACCT-NOT-IN-COLL           TO TRUE                    
           END-IF.                                                      
      *                                                                 05009000
       2120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05021000
      ******************************************************************05021200
      * 2140-COLLECT-HIST-PROCESS.                                     *05021300
      * GET COLLECTION HISTORY DETAILS FROM COLLECTION_HIST TABLE      *05021400
      * IF ACCOUNT NOT PRESENT END THE PROGRAM NORMALLY BY INSERTING   *05021500
      * BUS RULE (R5).                                                 *05021600
      ******************************************************************05021700
      *                                                                 05021800
       2140-COLLECT-HIST-PROCESS.                                       
      *                                                                 05022000
           PERFORM 7230-GET-COLL-HIST-DATA    THRU 7230-EXIT.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE     = SUCCESSFUL-CALL               
              IF WS-NULL-WRITE-OFF-DT   = WS-YES-NULL                   
                 MOVE SPACES                 TO S-WRITE-OFF-DATE-1      
                                                HC-WRITE-OFF-DT         
              ELSE                                                      
                 MOVE HC-WRITE-OFF-DT        TO WS-DATE-CCYY-MM-DD      
                 MOVE WS-DATE-CCYY           TO WS-DATE2-CCYY           
                 MOVE WS-DATE-MM             TO WS-DATE2-MM             
                 MOVE WS-DATE-DD             TO WS-DATE2-DD             
                 MOVE WS-DATE-MM-DD-YYYY     TO S-WRITE-OFF-DATE-1      
              END-IF                                                    
                                                                        
              MOVE HC-FUTURE-WORK-DT         TO WS-DATE-CCYY-MM-DD      
              MOVE WS-DATE-CCYY              TO WS-DATE2-CCYY           
              MOVE WS-DATE-MM                TO WS-DATE2-MM             
              MOVE WS-DATE-DD                TO WS-DATE2-DD             
              MOVE WS-DATE-MM-DD-YYYY        TO S-FUTURE-WORK-DATE-1    
                                                                        
              MOVE HC-COLL-HIST-SEQ-TS       TO S-COLL-HIST-SEQ-TS-1    
                                                LH-COLL-HIST-SEQ-TS     
              MOVE HC-CALL-QUEUE-ID          TO S-COLL-Q-1              
           ELSE                                                         
              MOVE SPACES                    TO S-WRITE-OFF-DATE-1      
                                                S-FUTURE-WORK-DATE-1    
                                                S-COLL-HIST-SEQ-TS-1    
                                                LH-COLL-HIST-SEQ-TS     
                                                S-COLL-Q-1              
                                                                        
              MOVE 'CRDCOLL001'              TO S-RULE-ID-5             
              MOVE WS-FAILED                 TO S-RULE-RESULT-CD-5      
              IF S-RULE-ID-5 GREATER THAN SPACES                        
                 PERFORM 7650-GET-RULE-XREF-ID  THRU 7650-EXIT          
              END-IF                                                    
              MOVE WS-ZERO                   TO S-RETURN-CODE-5         
              PERFORM 8050-INSERT-GTT-R5      THRU 8050-EXIT            
P00845        SET ACCT-NOT-IN-COLL           TO TRUE                    
           END-IF.                                                      
                                                                        
           IF LH-COLL-HIST-SEQ-TS > SPACES                              
P00845        AND ACCT-IN-COLL                                          
              PERFORM 7235-GET-MAX-TRANS-ID   THRU 7235-EXIT            
              IF WS-ACTIVE-RETURN-CODE     = SUCCESSFUL-CALL            
                 IF WS-NULL-TRANS-ID       = WS-YES-NULL                
                    MOVE ZEROS               TO S-TRANS-ID-1            
                                                LH-TRANS-ID             
                 ELSE                                                   
                    MOVE LH-TRANS-ID         TO S-TRANS-ID-1            
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              MOVE ZEROS                     TO S-TRANS-ID-1            
           END-IF.                                                      
      *                                                                 05027900
       2140-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05028200
      ******************************************************************05028300
      * 2160-REDUCE-EMBEDDED-SPACES.                                   *05028400
      * TO ELIMINATE SPACES IN EXEMPTION CODE. (FOR R3)                *05028500
      ******************************************************************05028600
      *                                                                 05028700
       2160-REDUCE-EMBEDDED-SPACES.                                     
      *                                                                 05028900
           INITIALIZE    WS-EMB-INPUT                                   
                         WS-CMP-TABLE.                                  
                                                                        
           MOVE WS-COLL-EXEMPTION-CD         TO WS-EMB-INPUT.           
           MOVE +20                          TO WS-EMB-LENG.            
           MOVE LENGTH OF WS-EMB-INPUT       TO WS-EMB-TBL-LENG.        
           SET WS-EMB-INDX TO 1.                                        
           SET WS-CMP-INDX TO 1.                                        
                                                                        
           MOVE SPACE                        TO WS-EMB-LAST-CHAR.       
           IF WS-EMB-LENG NUMERIC AND                                   
             WS-EMB-LENG GREATER THAN ZERO AND LESS THAN WS-EMB-TBL-LENG
              CONTINUE                                                  
           ELSE                                                         
               MOVE WS-EMB-TBL-LENG          TO WS-EMB-LENG             
           END-IF.                                                      
                                                                        
           PERFORM 2170-COMPRESSION-ROUTINE   THRU 2170-EXIT            
               VARYING WS-EMB-INDX FROM WS-EMB-INDX BY 1                
               UNTIL WS-EMB-INDX GREATER THAN WS-EMB-LENG.              
                                                                        
           MOVE ZERO                         TO WS-EMB-LENG.            
           MOVE WS-CMP-TABLE                 TO S-COLL-EXEMPTION-CD-3.  
      *                                                                 05031400
       2160-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05034000
      ******************************************************************05034100
      * 2170-COMPRESSION-ROUTINE.                                      *05034200
      * TO ELIMINATE SPACES IN EXEMPTION CODE. (FOR R3)                *05034300
      ******************************************************************05034400
      *                                                                 05034500
       2170-COMPRESSION-ROUTINE.                                        
      *                                                                 05035100
           IF WS-EMB-CHAR (WS-EMB-INDX) EQUAL SPACE                     
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-EMB-CHAR (WS-EMB-INDX) TO                         
                                             WS-CMP-CHAR (WS-CMP-INDX)  
              SET WS-CMP-INDX UP BY 1                                   
           END-IF.                                                      
      *                                                                 05039600
       2170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05043000
      * 2200-GET-COLL-HIST-DET.                                        *05050000
      * PROCESS TO GET DATA FOR R2 & R3 FROM COLL_HIST_DET.            *05051000
      ******************************************************************05060000
      *                                                                 05070000
       2200-GET-COLL-HIST-DET.                                          
      *                                                                 05090000
           PERFORM 7300-OPEN-COLLECT-DET      THRU 7300-EXIT.           
                                                                        
           PERFORM 7350-FETCH-COLLECT-DET     THRU 7350-EXIT.           
           IF WS-ACTIVE-RETURN-CODE  =  NOT-FOUND                       
              PERFORM 8030-INSERT-GTT-R3      THRU 8030-EXIT            
           ELSE                                                         
              PERFORM 2220-MOVE-COLL-HIST     THRU 2220-EXIT            
                                              UNTIL NO-MORE-ROWS-C1     
           END-IF.                                                      
                                                                        
           PERFORM 7400-CLOSE-COLLECT-DET     THRU 7400-EXIT.           
      *                                                                 05110000
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05140000
      ******************************************************************05150000
      * 2220-MOVE-COLL-HIST.                                           *05160000
      *1. THIS MODULE BUILDS THE RESULT SET FOR THE COLL_HIST_DET ROWS *05161000
      * PREVIOUSLY RETRIEVED AND SENDS THEM FOR 100 ROWS.              *05162000
      *2. SEND THE RESULT SET2 2 & 3.                                  *05163000
      ******************************************************************05170000
      *                                                                 05180000
       2220-MOVE-COLL-HIST.                                             
      *                                                                 05200000
           IF WS-NULL-COMMENTS-TX = WS-YES-NULL                         
              MOVE SPACES                    TO LH-COMMENTS-TX-TEXT     
           END-IF                                                       
           IF LH-COMMENTS-TX-TEXT EQUAL LOW-VALUES OR HIGH-VALUES       
              MOVE SPACES                    TO LH-COMMENTS-TX-TEXT     
           END-IF                                                       
           IF WS-NULL-PTP-DT      = WS-YES-NULL                         
              MOVE SPACES                    TO LH-PTP-DT               
           END-IF                                                       
                                                                        
           MOVE LH-TRANS-ID                  TO S-TRANS-ID-2.           
           MOVE LH-PTP-STATUS-CD             TO                         
                                             S-PROMISE-TO-PAY-STATUS-2. 
           MOVE LH-COLL-ACTION-CD            TO                         
                                             S-PROMISE-TO-PAY-ACTION-2. 
           MOVE LH-COLL-RESULT-CD            TO                         
                                             S-PROMISE-TO-PAY-RESULT-2. 
           MOVE LH-PTP-DT                    TO S-PROMISE-TO-PAY-DATE-2.
           MOVE LH-PTP-AMT                   TO S-PROMISE-TO-PAY-AMT-2. 
                                                                        
           PERFORM 2230-GET-DATE-TIME-VAL     THRU 2230-EXIT.           
      *                                                                 05260000
      *    MOVE LH-COLL-AGENT-ID-TEXT        TO                         05260100
      *                                     WS-COLL-COMMENT-USER-ID-3.  05260200
           IF WS-COLL-COMMENT-USER-ID-3 > SPACES                        
              PERFORM 2225-GET-USER-NAME-DET  THRU 2225-EXIT            
           ELSE                                                         
              MOVE WS-COLL-COMMENT-USER-ID-3 TO S-COLL-COMMENT-USER-ID-3
           END-IF.                                                      
                                                                        
           IF (LH-PTP-STATUS-CD = WS-ACTIVE-PTP OR WS-PENDING-PTP)      
              PERFORM 8020-INSERT-GTT-R2      THRU 8020-EXIT            
           END-IF.                                                      
      *                                                                 05262000
           PERFORM 8030-INSERT-GTT-R3         THRU 8030-EXIT.           
      *                                                                 05262200
           INITIALIZE LH-TRANS-ID                                       
                      LH-PTP-STATUS-CD                                  
                      LH-COLL-ACTION-CD                                 
                      LH-COLL-RESULT-CD                                 
                      LH-PTP-DT                                         
                      LH-PTP-AMT                                        
                      LH-COLL-AGENT-ID-TEXT                             
                      LH-COMMENTS-TX-TEXT                               
                      LH-RECORD-CREATION-DT                             
                      WS-CREATION-DATE-TIME                             
                      S-COMMENT-TEXT-3                                  
                      S-COLL-COMMENT-USER-ID-3                          
                      S-COLL-COMMENT-DATETIME-3.                        
                                                                        
           PERFORM 7350-FETCH-COLLECT-DET     THRU 7350-EXIT.           
                                                                        
       2220-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05281000
      ******************************************************************05282000
      * 2225-GET-USER-NAME-DET.                                        *05283000
      *                                                                *05284000
      ******************************************************************05285000
      *                                                                 05286000
       2225-GET-USER-NAME-DET.                                          
      *                                                                 05288000
           MOVE WS-COLL-COMMENT-USER-ID-3    TO PF-USER-ID.             
           PERFORM 7240-GET-FULL-NAME         THRU 7240-EXIT.           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE SPACES                    TO WS-COMMON-TXT           
              MOVE PF-FIRST-NAME             TO WS-COMMON-TXT           
              PERFORM 2226-LOOKUP-EXTRA-SPACES                          
                                              THRU 2226-EXIT            
              MOVE WS-COMMON-TXT-POINTER     TO WS-FIRST-NAME-PNTER     
                                                                        
              MOVE SPACES                    TO WS-COMMON-TXT           
              MOVE PF-LAST-NAME              TO WS-COMMON-TXT           
              PERFORM 2226-LOOKUP-EXTRA-SPACES                          
                                              THRU 2226-EXIT            
              MOVE WS-COMMON-TXT-POINTER     TO WS-LAST-NAME-PNTER      
                                                                        
              MOVE SPACES                    TO WS-COMMON-TXT           
              MOVE PF-MIDDLE-NAME            TO WS-COMMON-TXT           
              PERFORM 2226-LOOKUP-EXTRA-SPACES                          
                                              THRU 2226-EXIT            
              MOVE WS-COMMON-TXT-POINTER     TO WS-MIDDLE-NAME-PNTER    
                                                                        
              MOVE SPACES                    TO WS-EMPLOYEE-NAME        
              STRING PF-LAST-NAME(1:WS-LAST-NAME-PNTER)                 
                                     DELIMITED SIZE                     
                     ', '            DELIMITED SIZE                     
                     PF-FIRST-NAME(1:WS-FIRST-NAME-PNTER)               
                                    DELIMITED SIZE                      
                     ' '            DELIMITED SIZE                      
                     PF-MIDDLE-NAME(1:WS-MIDDLE-NAME-PNTER)             
                                    DELIMITED SIZE                      
                   INTO WS-EMPLOYEE-NAME                                
              END-STRING                                                
              MOVE WS-EMPLOYEE-NAME          TO S-COLL-COMMENT-USER-ID-3
           ELSE                                                         
              MOVE WS-COLL-COMMENT-USER-ID-3 TO S-COLL-COMMENT-USER-ID-3
           END-IF.                                                      
      *                                                                 05292600
                                                                        
       2225-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05293000
      ******************************************************************05293100
      * 2226-LOOKUP-EXTRA-SPACES.                                      *05293200
      *                                                                *05293300
      ******************************************************************05293400
      *                                                                 05293500
       2226-LOOKUP-EXTRA-SPACES.                                        
      *                                                                 05293700
           MOVE SPACES                    TO WS-COMMON-TXT-REVERSED     
           MOVE ZEROES                    TO WS-COMMON-TXT-CHARS        
                                                                        
           MOVE FUNCTION REVERSE (WS-COMMON-TXT) TO                     
                                         WS-COMMON-TXT-REVERSED         
                                                                        
           INSPECT WS-COMMON-TXT-REVERSED                               
           TALLYING WS-COMMON-TXT-CHARS FOR LEADING SPACES.             
                                                                        
           COMPUTE WS-COMMON-TXT-POINTER =                              
           FUNCTION                                                     
           LENGTH(WS-COMMON-TXT-REVERSED) - WS-COMMON-TXT-CHARS.        
      *                                                                 05295000
       2226-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05295300
      ******************************************************************05295400
      * 2227-REMOVE-JUNK-DATA.                                         *05295500
      *                                                                *05295600
      ******************************************************************05295700
      *                                                                 05295800
       2227-REMOVE-JUNK-DATA.                                           
      *                                                                 05296000
           MOVE SPACES                       TO WS-TAB-COMMENTS.        
                                                                        
           MOVE WS-COMMENT-TX-TEXT-3         TO WS-TAB-COMMENTS.        
           MOVE WS-MAX-LENGTH                TO WS-TX-SUB.              
                                                                        
           PERFORM UNTIL WS-TAB-COMM(WS-TX-SUB) > SPACES                
                                      OR WS-TX-SUB  = 0                 
                   COMPUTE WS-TX-SUB = WS-TX-SUB - 1                    
           END-PERFORM.                                                 
      *                                                                 05298100
       2227-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05298400
      ******************************************************************05298500
      * 2230-GET-DATE-TIME-VAL.                                        *05298600
      *                                                                *05298700
      ******************************************************************05298800
      *                                                                 05298900
       2230-GET-DATE-TIME-VAL.                                          
      *                                                                 05299100
           IF LH-RECORD-CREATION-DT NOT = SPACES                        
              MOVE LH-RECORD-CREATION-DT(6:2)                           
                                             TO WS-DATE3-MM             
              MOVE LH-RECORD-CREATION-DT(9:2)                           
                                             TO WS-DATE3-DD             
              MOVE LH-RECORD-CREATION-DT(1:4)                           
                                             TO WS-DATE3-CCYY           
              MOVE WS-CREATION-DATE          TO WS-OUTPUT-DATE          
           ELSE                                                         
              MOVE SPACES                    TO WS-OUTPUT-DATE          
           END-IF.                                                      
                                                                        
           IF LH-COMMENTS-TX-TEXT(1:6) IS NUMERIC                       
              IF LH-COMMENTS-TX-TEXT(8:4) IS NUMERIC                    
                 MOVE LH-COMMENTS-TX-TEXT(8:2)                          
                                             TO WS-MINUTE               
                 MOVE LH-COMMENTS-TX-TEXT(10:2)                         
                                             TO WS-SECOND               
                 MOVE WS-CREATION-TIME       TO WS-OUTPUT-TIME          
                 MOVE LH-COMMENTS-TX-TEXT(13:7) TO                      
                                             WS-COLL-COMMENT-USER-ID-3  
                 MOVE LH-COMMENTS-TX-TEXT(21:491)                       
                                             TO WS-COMMENT-TX-TEXT-3    
                 PERFORM 2227-REMOVE-JUNK-DATA                          
                                              THRU 2227-EXIT            
                 MOVE WS-TAB-COMMENTS(1:WS-TX-SUB)                      
                                             TO S-COMMENT-TEXT-3        
              ELSE                                                      
                 IF (LH-COMMENTS-TX-TEXT(8:2) IS NUMERIC                
                    AND LH-COMMENTS-TX-TEXT(10:1) = WS-COLON            
                    AND LH-COMMENTS-TX-TEXT(11:2) IS NUMERIC)           
                                                                        
                    MOVE LH-COMMENTS-TX-TEXT(8:2)                       
                                             TO WS-MINUTE               
                    MOVE LH-COMMENTS-TX-TEXT(11:2)                      
                                             TO WS-SECOND               
                    MOVE WS-CREATION-TIME    TO WS-OUTPUT-TIME          
                    MOVE LH-COMMENTS-TX-TEXT(14:7) TO                   
                                             WS-COLL-COMMENT-USER-ID-3  
                    MOVE LH-COMMENTS-TX-TEXT(22:490)                    
                                             TO WS-COMMENT-TX-TEXT-3    
                    PERFORM 2227-REMOVE-JUNK-DATA                       
                                              THRU 2227-EXIT            
                    MOVE WS-TAB-COMMENTS(1:WS-TX-SUB)                   
                                             TO S-COMMENT-TEXT-3        
                 ELSE                                                   
                   IF (LH-COMMENTS-TX-TEXT(8:2) IS NUMERIC              
                      AND LH-COMMENTS-TX-TEXT(10:1) = WS-DOT            
                      AND LH-COMMENTS-TX-TEXT(11:2) IS NUMERIC)         
                                                                        
                      MOVE LH-COMMENTS-TX-TEXT(8:2)                     
                                             TO WS-MINUTE               
                      MOVE LH-COMMENTS-TX-TEXT(11:2)                    
                                             TO WS-SECOND               
                      MOVE WS-CREATION-TIME  TO WS-OUTPUT-TIME          
                      MOVE LH-COMMENTS-TX-TEXT(14:7) TO                 
                                             WS-COLL-COMMENT-USER-ID-3  
                      MOVE LH-COMMENTS-TX-TEXT(22:490)                  
                                             TO WS-COMMENT-TX-TEXT-3    
                      PERFORM 2227-REMOVE-JUNK-DATA                     
                                              THRU 2227-EXIT            
                      MOVE WS-TAB-COMMENTS(1:WS-TX-SUB)                 
                                             TO S-COMMENT-TEXT-3        
                   ELSE                                                 
                      MOVE SPACES            TO WS-OUTPUT-TIME          
                                             WS-COLL-COMMENT-USER-ID-3  
                      MOVE LH-COMMENTS-TX-TEXT(16:496)                  
                                             TO WS-COMMENT-TX-TEXT-3    
                      PERFORM 2227-REMOVE-JUNK-DATA                     
                                              THRU 2227-EXIT            
                      MOVE WS-TAB-COMMENTS(1:WS-TX-SUB)                 
                                             TO S-COMMENT-TEXT-3        
                   END-IF                                               
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              PERFORM 2240-CHCK-DT-FOR-COMMNT-TXT                       
                                              THRU 2240-EXIT            
           END-IF.                                                      
                                                                        
           MOVE WS-CREATION-DATE-TIME        TO                         
                                             S-COLL-COMMENT-DATETIME-3. 
      *                                                                 05307800
       2230-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05308100
      ******************************************************************05308200
      * 2240-CHCK-DT-FOR-COMMNT-TXT.                                   *05308300
      *                                                                *05308400
      ******************************************************************05308500
      *                                                                 05308600
       2240-CHCK-DT-FOR-COMMNT-TXT.                                     
      *                                                                 05308800
           IF (LH-COMMENTS-TX-TEXT(1:2) IS NUMERIC                      
             AND LH-COMMENTS-TX-TEXT(3:1) = '/'                         
             AND LH-COMMENTS-TX-TEXT(4:2) IS NUMERIC                    
             AND LH-COMMENTS-TX-TEXT(6:1) = '/'                         
             AND LH-COMMENTS-TX-TEXT(7:4) IS NUMERIC)                   
                                                                        
              IF (LH-COMMENTS-TX-TEXT(12:2) IS NUMERIC                  
                AND LH-COMMENTS-TX-TEXT(14:1) = WS-DOT                  
                AND LH-COMMENTS-TX-TEXT(15:2) IS NUMERIC)               
                                                                        
                 MOVE LH-COMMENTS-TX-TEXT(12:2)                         
                                             TO WS-MINUTE               
                 MOVE LH-COMMENTS-TX-TEXT(15:2)                         
                                             TO WS-SECOND               
                 MOVE WS-CREATION-TIME       TO WS-OUTPUT-TIME          
                 MOVE LH-COMMENTS-TX-TEXT(18:7) TO                      
                                             WS-COLL-COMMENT-USER-ID-3  
                 MOVE LH-COMMENTS-TX-TEXT(26:486)                       
                                             TO WS-COMMENT-TX-TEXT-3    
                 PERFORM 2227-REMOVE-JUNK-DATA                          
                                              THRU 2227-EXIT            
                 MOVE WS-TAB-COMMENTS(1:WS-TX-SUB)                      
                                             TO S-COMMENT-TEXT-3        
                                                                        
              ELSE                                                      
                 MOVE SPACES                 TO WS-OUTPUT-TIME          
                                             WS-COLL-COMMENT-USER-ID-3  
                 MOVE LH-COMMENTS-TX-TEXT(20:492)                       
                                             TO WS-COMMENT-TX-TEXT-3    
                 PERFORM 2227-REMOVE-JUNK-DATA                          
                                              THRU 2227-EXIT            
                 MOVE WS-TAB-COMMENTS(1:WS-TX-SUB)                      
                                             TO S-COMMENT-TEXT-3        
              END-IF                                                    
           ELSE                                                         
              MOVE SPACES                    TO WS-OUTPUT-TIME          
                                             WS-COLL-COMMENT-USER-ID-3  
              MOVE LH-COMMENTS-TX-TEXT       TO WS-COMMENT-TX-TEXT-3    
              PERFORM 2227-REMOVE-JUNK-DATA   THRU 2227-EXIT            
              MOVE WS-TAB-COMMENTS(1:WS-TX-SUB)                         
                                             TO S-COMMENT-TEXT-3        
           END-IF.                                                      
                                                                        
       2240-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05313700
      ******************************************************************05313800
      * 2250-GET-PAYMENT-HIST.                                         *05313900
      * THIS MODULE GETS THE PAYMENT HISTORY FOR THE ACCOUNT           *05314000
      * FROM CSS_AR_TRANS_HIST FOR FIRST 15 ROWS.                      *05314100
      ******************************************************************05314200
      *                                                                 05314300
       2250-GET-PAYMENT-HIST.                                           
      *                                                                 05314500
           PERFORM 7500-OPEN-PAYMENT-CSR      THRU 7500-EXIT.           
           PERFORM 7550-FETCH-PAYMENT-CSR     THRU 7550-EXIT.           
           PERFORM 2260-MOVE-PAYMNT-DATA      THRU 2260-EXIT            
                                              UNTIL NO-MORE-ROWS-C2.    
           PERFORM 7600-CLOSE-PAYMENT-CSR     THRU 7600-EXIT.           
      *                                                                 05315100
       2250-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05315400
      ******************************************************************05315500
      * 2260-MOVE-PAYMNT-DATA.                                         *05315600
      * THIS MODULE SENDS THE PAYMENT HISTORY RETRIEVED                *05315700
      * FROM CSS_AR_TRANS_HIST.                                        *05315800
      ******************************************************************05315900
      *                                                                 05316000
       2260-MOVE-PAYMNT-DATA.                                           
      *                                                                 05316200
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-NULL-DATE-TRANS = WS-YES-NULL                       
                 MOVE SPACES                 TO S-AR-DATE-TRANS-4       
                                                AR-DATE-TRANS           
              ELSE                                                      
                 MOVE AR-DATE-TRANS          TO S-AR-DATE-TRANS-4       
              END-IF                                                    
              MOVE AR-AMT-ORIG-ENTERED       TO S-AR-AMT-ORIG-ENTERED-4 
           ELSE                                                         
              MOVE SPACES                    TO S-AR-DATE-TRANS-4       
              MOVE ZEROS                     TO S-AR-AMT-ORIG-ENTERED-4 
           END-IF.                                                      
      *                                                                 05317500
           PERFORM 8040-INSERT-GTT-R4         THRU 8040-EXIT.           
      *                                                                 05317700
           PERFORM 7550-FETCH-PAYMENT-CSR     THRU 7550-EXIT.           
      *                                                                 05317900
       2260-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05318200
      ******************************************************************05318300
      * 7000-GET-ACCT-DATA.                                            *05318400
      ******************************************************************05318500
      *                                                                 05318600
       7000-GET-ACCT-DATA.                                              
      *                                                                 05318800
           EXEC SQL                                                     
              SELECT AT.ADDRESS_ID                                      
                    ,AT.CUSTOMER_NO                                     
                    ,AT.COMPANY_NO                                      
                INTO :AT-ADDRESS-ID                                     
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-COMPANY-NO                                     
                FROM CSS_ACCOUNT  AT WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05318900
MFA-TR*       SELECT AT.ADDRESS_ID                                      05319000
MFA-TR*             ,AT.CUSTOMER_NO                                     05319100
MFA-TR*             ,AT.COMPANY_NO                                      05319200
MFA-TR*         INTO :AT-ADDRESS-ID                                     05319300
MFA-TR*             ,:AT-CUSTOMER-NO                                    05319400
MFA-TR*             ,:AT-COMPANY-NO                                     05319500
MFA-TR*         FROM CSS_ACCOUNT  AT                                    05319600
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        05319700
MFA-TR*         WITH UR                                                 05319800
MFA-TR*      QUERYNO 7000                                               05319900
MFA-TR*    END-EXEC.                                                    05320000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1         
                                                S-RETURN-CODE-2         
                                                S-RETURN-CODE-3         
                                                S-RETURN-CODE-4.        
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE WS-ZERO              TO S-RETURN-CODE-5         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7100'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_ACCOUNT'        TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
A00157******************************************************************09762000
A00157*                                                                *09763000
A00157* 7150-GET-CURR-ACCT-CNT.                                        *09763100
A00157******************************************************************09764000
A00157 7150-GET-CURR-ACCT-CNT.                                          
A00157                                                                  
A00157     EXEC SQL                                                     
A00157        SELECT COUNT(*)                                           
A00157          INTO :WS-CURR-ACCT-CNT                                  
A00157          FROM CSS_ACCOUNT AT                                     
A00157         WHERE AT.CUSTOMER_NO = :AT-CUSTOMER-NO                   
A00157                                                      
A00157     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     09768000
MFA-TR*       SELECT COUNT(*)                                           09769000
MFA-TR*         INTO :WS-CURR-ACCT-CNT                                  09769300
MFA-TR*         FROM CSS_ACCOUNT AT                                     09769600
MFA-TR*        WHERE AT.CUSTOMER_NO = :AT-CUSTOMER-NO                   09769700
MFA-TR*      QUERYNO 7150                                               09770000
MFA-TR*    END-EXEC.                                                    09770100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00157                                                                  
A00157     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7150'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-1         
              MOVE AT-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
A00157******************************************************************09772600
A00157*                                                                *09772700
A00157* 7160-GET-ARCHV-ACCT-CNT                                        *09772800
A00157******************************************************************09772900
A00157 7160-GET-ARCHV-ACCT-CNT.                                         
A00157                                                                  
A00157     EXEC SQL                                                     
A00157        SELECT COUNT(*)                                           
A00157          INTO :WS-ARCHV-ACCT-CNT                                 
A00157          FROM HST_ACCOUNT AT                                     
A00157         WHERE AT.CUSTOMER_NO = :AT-CUSTOMER-NO                   
A00157                                                      
A00157     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     09776000
MFA-TR*       SELECT COUNT(*)                                           09777000
MFA-TR*         INTO :WS-ARCHV-ACCT-CNT                                 09778000
MFA-TR*         FROM HST_ACCOUNT AT                                     09779000
MFA-TR*        WHERE AT.CUSTOMER_NO = :AT-CUSTOMER-NO                   09780000
MFA-TR*      QUERYNO 7160                                               09790000
MFA-TR*    END-EXEC.                                                    09800000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00157                                                                  
A00157     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
A00157                                                                  
A00157     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A00157        CONTINUE                                                  
A00157     ELSE                                                         
A00157        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
A00157        MOVE '7160'                    TO ACTIVE-PARAGRAPH        
A00157        MOVE 'SELECT'                  TO ABEND-FUNCTION          
A00157        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
A00157                                          ABEND-TABLES            
A00157        MOVE 'HST_ACCOUNT'             TO TABLE-1                 
A00157        MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-1         
A00157        MOVE AT-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1       
A00157        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
A00157     END-IF.                                                      
A00157                                                                  
A00157 7160-EXIT.                                                       
A00157     EXIT.                                                        
                                                                        
      ******************************************************************10124000
      * 7200-GET-NO-OF-CONTRACTS.                                      *10124100
      ******************************************************************10124200
      *                                                                 10124300
       7200-GET-NO-OF-CONTRACTS.                                        
      *                                                                 10124500
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
                INTO :WS-NO-OF-CONTRACTS-3                              
                FROM CSS_CONTRACT CT WITH(READUNCOMMITTED)                      
               WHERE CT.ACCOUNT_NO       = :CT-ACCOUNT-NO               
                 AND CT.CNT_STATUS_CD    = :WS-ACTIVE-CNT               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     10124600
MFA-TR*       SELECT COUNT(*)                                           10124700
MFA-TR*         INTO :WS-NO-OF-CONTRACTS-3                              10124800
MFA-TR*         FROM CSS_CONTRACT CT                                    10124900
MFA-TR*        WHERE CT.ACCOUNT_NO       = :CT-ACCOUNT-NO               10125000
MFA-TR*          AND CT.CNT_STATUS_CD    = :WS-ACTIVE-CNT               10125100
MFA-TR*         WITH UR                                                 10125200
MFA-TR*      QUERYNO 7200                                               10125300
MFA-TR*    END-EXEC.                                                    10125400

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE '7200'                    TO ACTIVE-PARAGRAPH        
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_CONTRACT'            TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE CT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10127600
      ******************************************************************10127700
      * 7210-GET-COLL-ACCT-INFO.                                       *10127800
      ******************************************************************10127900
      *                                                                 10128000
       7210-GET-COLL-ACCT-INFO.                                         
      *                                                                 10128200
           EXEC SQL                                                     
              SELECT [IF].COLL_EXEMPTION_CD                               
                    ,[IF].COLL_COMMENT_TX                                 
                    ,[IF].PROMISE_KEPT_NO                                 
                    ,[IF].PROMISE_BROKEN_NO                               
                INTO :IF-COLL-EXEMPTION-CD :WS-NULL-COLL-EXEMPTION-CD   
                    ,:IF-COLL-COMMENT-TX :WS-NULL-COLL-COMMENT-TX     
                    ,:IF-PROMISE-KEPT-NO                                
                    ,:IF-PROMISE-BROKEN-NO                              
                FROM CSS_COLL_ACCT_INFO  [IF] WITH(READUNCOMMITTED)             
               WHERE [IF].ACCOUNT_NO = :IF-ACCOUNT-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                     10128300
MFA-TR*       SELECT IF.COLL_EXEMPTION_CD                               10128400
MFA-TR*             ,IF.COLL_COMMENT_TX                                 10128500
MFA-TR*             ,IF.PROMISE_KEPT_NO                                 10128600
MFA-TR*             ,IF.PROMISE_BROKEN_NO                               10128700
MFA-TR*         INTO :IF-COLL-EXEMPTION-CD :WS-NULL-COLL-EXEMPTION-CD   10128800
MFA-TR*             ,:IF-COLL-COMMENT-TX   :WS-NULL-COLL-COMMENT-TX     10128900
MFA-TR*             ,:IF-PROMISE-KEPT-NO                                10129000
MFA-TR*             ,:IF-PROMISE-BROKEN-NO                              10129100
MFA-TR*         FROM CSS_COLL_ACCT_INFO  IF                             10129200
MFA-TR*        WHERE IF.ACCOUNT_NO = :IF-ACCOUNT-NO                     10129300
MFA-TR*         WITH UR                                                 10129400
MFA-TR*      QUERYNO 7210                                               10129500
MFA-TR*    END-EXEC.                                                    10129600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                         S-RETURN-CODE-1         10129900
      *                                         S-RETURN-CODE-2         10130000
      *                                         S-RETURN-CODE-3         10130100
      *                                         S-RETURN-CODE-4.        10130200
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE WS-ZERO              TO S-RETURN-CODE-5         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7210'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_COLL_ACCT_INFO' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE IF-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10132300
      ******************************************************************10132400
      * 4230-GET-COLL-HIST-DATA.                                       *10132500
      ******************************************************************10132600
      *                                                                 10132700
       7230-GET-COLL-HIST-DATA.                                         
      *                                                                 10132900
           EXEC SQL                                                     
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           HC.COLL_HIST_SEQ_TS, 121), ' ', '-'), ':', '.') 
           COLL_HIST_SEQ_TS                               
                     ,HC.CALL_QUEUE_ID                                  
                     ,HC.WRITE_OFF_DT                                   
                     ,HC.FUTURE_WORK_DT                                 
                 INTO :HC-COLL-HIST-SEQ-TS                              
                     ,:HC-CALL-QUEUE-ID                                 
                     ,:HC-WRITE-OFF-DT :WS-NULL-WRITE-OFF-DT          
                     ,:HC-FUTURE-WORK-DT                                
                 FROM CSS_COLLECT_HIST HC WITH(READUNCOMMITTED)                 
                WHERE HC.ACCOUNT_NO     = :HC-ACCOUNT-NO                
                  AND HC.FUTURE_WORK_DT IS NOT NULL                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     10133000
MFA-TR*        SELECT HC.COLL_HIST_SEQ_TS                               10133100
MFA-TR*              ,HC.CALL_QUEUE_ID                                  10133200
MFA-TR*              ,HC.WRITE_OFF_DT                                   10133300
MFA-TR*              ,HC.FUTURE_WORK_DT                                 10133400
MFA-TR*          INTO :HC-COLL-HIST-SEQ-TS                              10133500
MFA-TR*              ,:HC-CALL-QUEUE-ID                                 10133600
MFA-TR*              ,:HC-WRITE-OFF-DT   :WS-NULL-WRITE-OFF-DT          10133700
MFA-TR*              ,:HC-FUTURE-WORK-DT                                10133800
MFA-TR*          FROM CSS_COLLECT_HIST HC                               10133900
MFA-TR*         WHERE HC.ACCOUNT_NO     = :HC-ACCOUNT-NO                10134000
MFA-TR*           AND HC.FUTURE_WORK_DT IS NOT NULL                     10134100
MFA-TR*          WITH UR                                                10134200
MFA-TR*       QUERYNO 7230                                              10134300
MFA-TR*    END-EXEC.                                                    10134400

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                         S-RETURN-CODE-1         10134700
      *                                         S-RETURN-CODE-2         10134800
      *                                         S-RETURN-CODE-3         10134900
      *                                         S-RETURN-CODE-4.        10135000
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7230'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_COLLECT_HIST'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE HC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 10136300
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10136600
      ******************************************************************10136700
      * 7235-GET-MAX-TRANS-ID.                                         *10136800
      ******************************************************************10136900
      *                                                                 10137000
       7235-GET-MAX-TRANS-ID.                                           
      *                                                                 10137200
           EXEC SQL                                                     
               SELECT MAX(LH.TRANS_ID)                                  
                 INTO :LH-TRANS-ID :WS-NULL-TRANS-ID                    
                 FROM CSS_COLL_HIST_DET LH WITH(READUNCOMMITTED)                
                WHERE LH.ACCOUNT_NO       = :LH-ACCOUNT-NO              
                  AND LH.COLL_HIST_SEQ_TS = CIS.CHAR2TIMESTAMP(
                                                   :LH-COLL-HIST-SEQ-TS
              )        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     10137300
MFA-TR*        SELECT MAX(LH.TRANS_ID)                                  10137400
MFA-TR*          INTO :LH-TRANS-ID :WS-NULL-TRANS-ID                    10137500
MFA-TR*          FROM CSS_COLL_HIST_DET LH                              10137600
MFA-TR*         WHERE LH.ACCOUNT_NO       = :LH-ACCOUNT-NO              10137700
MFA-TR*           AND LH.COLL_HIST_SEQ_TS = :LH-COLL-HIST-SEQ-TS        10137800
MFA-TR*          WITH UR                                                10137900
MFA-TR*       QUERYNO 7235                                              10138000
MFA-TR*    END-EXEC.                                                    10138100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7235'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_COLL_HIST_DET'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'COLL_HIST_SEQ_TS'        TO TABLE-ELEMENT-2         
              MOVE LH-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE LH-COLL-HIST-SEQ-TS       TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 10139800
       7235-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10140100
      ******************************************************************10140200
      * 7240-GET-FULL-NAME.                                            *10140300
      ******************************************************************10140400
      *                                                                 10140500
       7240-GET-FULL-NAME.                                              
      *                                                                 10140700
           EXEC SQL                                                     
               SELECT PF.LAST_NAME                                      
                     ,PF.FIRST_NAME                                     
                     ,PF.MIDDLE_NAME                                    
                 INTO :PF-LAST-NAME                                     
                     ,:PF-FIRST-NAME                                    
                     ,:PF-MIDDLE-NAME                                   
                 FROM CSS_USER_PROFILE  PF WITH(READUNCOMMITTED)                
                WHERE PF.USER_ID    = :PF-USER-ID                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     10140800
MFA-TR*        SELECT PF.LAST_NAME                                      10140900
MFA-TR*              ,PF.FIRST_NAME                                     10141000
MFA-TR*              ,PF.MIDDLE_NAME                                    10141100
MFA-TR*          INTO :PF-LAST-NAME                                     10141200
MFA-TR*              ,:PF-FIRST-NAME                                    10141300
MFA-TR*              ,:PF-MIDDLE-NAME                                   10141400
MFA-TR*          FROM CSS_USER_PROFILE  PF                              10141500
MFA-TR*         WHERE PF.USER_ID    = :PF-USER-ID                       10141600
MFA-TR*          WITH UR                                                10141700
MFA-TR*       QUERYNO 7240                                              10141800
MFA-TR*    END-EXEC.                                                    10141900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7240'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_USER_PROFILE'        TO TABLE-1                 
              MOVE 'USER_ID'                 TO TABLE-ELEMENT-1         
              MOVE PF-USER-ID                TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 10143400
       7240-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10143700
      ******************************************************************10143800
      * 7250-GET-DELINQUENCY-VALUE.                                    *10143900
      ******************************************************************10144000
      *                                                                 10144100
       7250-GET-DELINQUENCY-VALUE.                                      
      *                                                                 10144300
           EXEC SQL                                                     
               SELECT C8.DELINQ_VALUE                                   
                 INTO :C8-DELINQ-VALUE                                  
                 FROM CSS_DELINQUENCY  C8 WITH(READUNCOMMITTED)                 
                WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                     
                  AND C8.COMPANY_NO = :C8-COMPANY-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     10144400
MFA-TR*        SELECT C8.DELINQ_VALUE                                   10144500
MFA-TR*          INTO :C8-DELINQ-VALUE                                  10144600
MFA-TR*          FROM CSS_DELINQUENCY  C8                               10144700
MFA-TR*         WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                     10144800
MFA-TR*           AND C8.COMPANY_NO = :C8-COMPANY-NO                    10144900
MFA-TR*          WITH UR                                                10145000
MFA-TR*       QUERYNO 7250                                              10145100
MFA-TR*    END-EXEC.                                                    10145200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7250'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_DELINQUENCY'         TO TABLE-1                 
              MOVE 'DELINQ_CD'               TO TABLE-ELEMENT-1         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE C8-DELINQ-CD              TO HOSTVAR-ELEMENT-1       
              MOVE C8-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 10146900
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10147200
      ******************************************************************10147300
      * 7300-OPEN-COLLECT-DET.                                         *10147400
      ******************************************************************10147500
      *                                                                 10147600
       7300-OPEN-COLLECT-DET.                                           
      *                                                                 10147800
           EXEC SQL                                                     
               OPEN COLLECT_DET                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '7300'                    TO ACTIVE-PARAGRAPH        
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_COLL_HIST_DET'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE LH-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10150300
      ***************************************************************** 10150400
      * 7350-FETCH-COLLECT-DET.                                       * 10150500
      *                                                               * 10150600
      ***************************************************************** 10150700
       7350-FETCH-COLLECT-DET.                                          
      *                                                                 10150900
           EXEC SQL                                                     
              FETCH COLLECT_DET                                         
               INTO                                                     
                    :LH-RECORD-CREATION-DT                              
                   ,:LH-PTP-STATUS-CD                                   
                   ,:LH-COLL-ACTION-CD                                  
                   ,:LH-COLL-RESULT-CD                                  
                   ,:LH-PTP-DT :WS-NULL-PTP-DT                          
                   ,:LH-PTP-AMT                                         
                   ,:LH-COMMENTS-TX :WS-NULL-COMMENTS-TX                
                   ,:LH-COLL-AGENT-ID                                   
                   ,:LH-TRANS-ID                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    ADD +1                   TO WS-HIST-COUNT           
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                 TO WS-NO-MORE-ROWS-C1      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7350'               TO ACTIVE-PARAGRAPH        
                   MOVE 'FETCH'              TO ABEND-FUNCTION          
                   MOVE 'CSS_COLL_HIST_DET'  TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE LH-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10154700
      ***************************************************************** 10154800
      * 7400-CLOSE-COLLECT-DET.                                       * 10154900
      *                                                               * 10155000
      ***************************************************************** 10155100
       7400-CLOSE-COLLECT-DET.                                          
      *                                                                 10155300
           EXEC SQL                                                     
              CLOSE COLLECT_DET                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '7400'                    TO ACTIVE-PARAGRAPH        
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_COLL_HIST_DET'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE LH-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10690000
      ******************************************************************10700000
      * 7500-OPEN-PAYMENT-CSR.                                         *10710000
      ******************************************************************10720000
      *                                                                 10730000
       7500-OPEN-PAYMENT-CSR.                                           
      *                                                                 10750000
           EXEC SQL                                                     
               OPEN PAYMENTS_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '7500'                    TO ACTIVE-PARAGRAPH        
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10970000
      ***************************************************************** 10980000
      * 7550-FETCH-PAYMENT-CSR.                                       * 10990000
      *                                                               * 11000000
      ***************************************************************** 11010000
       7550-FETCH-PAYMENT-CSR.                                          
      *                                                                 11030000
           EXEC SQL                                                     
              FETCH PAYMENTS_CURSOR                                     
               INTO :AR-AMT-ORIG-ENTERED                                
                   ,:AR-DATE-TRANS :WS-NULL-DATE-TRANS                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    ADD +1                   TO WS-PYMT-COUNT           
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                 TO WS-NO-MORE-ROWS-C2      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7550'               TO ACTIVE-PARAGRAPH        
                   MOVE 'FETCH'              TO ABEND-FUNCTION          
                   MOVE 'CSS_AR_TRANS_HIST'  TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE AR-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11350000
      ***************************************************************** 11360000
      * 7600-CLOSE-PAYMENT-CSR.                                       * 11370000
      *                                                               * 11380000
      ***************************************************************** 11390000
       7600-CLOSE-PAYMENT-CSR.                                          
      *                                                                 11410000
           EXEC SQL                                                     
              CLOSE PAYMENTS_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '7600'                    TO ACTIVE-PARAGRAPH        
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11640000
      ******************************************************************11660000
      * 7650-GET-RULE-XREF-ID.                                         *11670000
      ******************************************************************11680000
      *                                                                 11690000
       7650-GET-RULE-XREF-ID.                                           
      *                                                                 11710000
           EXEC SQL                                                     
               SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           [1T].BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                               
                 INTO :S-BUS-RULE-XREF-ID-5                             
                 FROM CSS_BUS_RULE      [1R] WITH(READUNCOMMITTED)              
                     ,CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)              
                WHERE [1R].BUS_RULE_ID = :S-RULE-ID-5                     
                  AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                   
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     11720000
MFA-TR*        SELECT 1T.BUS_RULE_XREF_ID                               11730000
MFA-TR*          INTO :S-BUS-RULE-XREF-ID-5                             11760000
MFA-TR*          FROM CSS_BUS_RULE      1R                              11790000
MFA-TR*              ,CSS_BUS_RULE_XREF 1T                              11791000
MFA-TR*         WHERE 1R.BUS_RULE_ID = :S-RULE-ID-5                     11800000
MFA-TR*           AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                   11801000
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                           11810000
MFA-TR*       QUERYNO 7650                                              11820000
MFA-TR*    END-EXEC.                                                    11830000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ACTIVE-PARAGRAPH        
              MOVE 'CSS_BUS_RULE'            TO ABEND-FUNCTION          
              MOVE 'BUS_RULE_ID'             TO TABLE-1                 
              MOVE 'S-BUS-RULE-ID-5'         TO TABLE-ELEMENT-1         
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 11980000
       7650-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12010000
      ******************************************************************14920000
      * 8000A-DEL-GTT-ROWS.                                            *14930000
      ******************************************************************14940000
      *                                                                 14950000
       8000A-DEL-GTT-ROWS.                                              
      *                                                                 14970000
           EXEC SQL                                                     
               DELETE FROM #CSR04884_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     14980000
MFA-TR*        DELETE FROM SESSION.CSR04884_R1                          14990000
MFA-TR*    END-EXEC.                                                    15000000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15010000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1.        
      *                                                                 15040000
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1         
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE SQLCODE             TO ABEND-SQLCODE           
                    MOVE SQLSTATE            TO ABEND-SQLSTATE          
                    MOVE '8000A'             TO ACTIVE-PARAGRAPH        
                    MOVE 'DELETE'            TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CSR04884_R1'       TO TABLE-1                 
                    MOVE SPACES              TO TABLE-ELEMENT-1         
                    MOVE SPACES              TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                 15240000
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                 15270000
      ******************************************************************15280000
      * 8000B-DEL-GTT-ROWS.                                            *15281000
      ******************************************************************15281100
      *                                                                 15281200
       8000B-DEL-GTT-ROWS.                                              
      *                                                                 15281400
           EXEC SQL                                                     
               DELETE FROM #CSR04884_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     15281500
MFA-TR*        DELETE FROM SESSION.CSR04884_R2                          15281600
MFA-TR*    END-EXEC.                                                    15281700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15281800
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-2.        
      *                                                                 15282100
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-2         
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE SQLCODE             TO ABEND-SQLCODE           
                    MOVE SQLSTATE            TO ABEND-SQLSTATE          
                    MOVE '8000B'             TO ACTIVE-PARAGRAPH        
                    MOVE 'DELETE'            TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CSR04884_R2'       TO TABLE-1                 
                    MOVE SPACES              TO TABLE-ELEMENT-1         
                    MOVE SPACES              TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                 15284100
       8000B-EXIT.                                                      
            EXIT.                                                       
      *                                                                 15284400
      ******************************************************************15284500
      * 8000C-DEL-GTT-ROWS.                                            *15284600
      ******************************************************************15284700
      *                                                                 15284800
       8000C-DEL-GTT-ROWS.                                              
      *                                                                 15285000
           EXEC SQL                                                     
               DELETE FROM #CSR04884_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     15285100
MFA-TR*        DELETE FROM SESSION.CSR04884_R3                          15285200
MFA-TR*    END-EXEC.                                                    15285300

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15285400
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-3.        
      *                                                                 15285700
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-3         
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE SQLCODE             TO ABEND-SQLCODE           
                    MOVE SQLSTATE            TO ABEND-SQLSTATE          
                    MOVE '8000C'             TO ACTIVE-PARAGRAPH        
                    MOVE 'DELETE'            TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CSR04884_R3'       TO TABLE-1                 
                    MOVE SPACES              TO TABLE-ELEMENT-1         
                    MOVE SPACES              TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                 15287700
       8000C-EXIT.                                                      
            EXIT.                                                       
      *                                                                 15288000
      ******************************************************************15288100
      * 8000D-DEL-GTT-ROWS.                                            *15288200
      ******************************************************************15288300
      *                                                                 15288400
       8000D-DEL-GTT-ROWS.                                              
      *                                                                 15288600
           EXEC SQL                                                     
               DELETE FROM #CSR04884_R4                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     15288700
MFA-TR*        DELETE FROM SESSION.CSR04884_R4                          15288800
MFA-TR*    END-EXEC.                                                    15288900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15289000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-4.        
      *                                                                 15289300
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-4         
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE SQLCODE             TO ABEND-SQLCODE           
                    MOVE SQLSTATE            TO ABEND-SQLSTATE          
                    MOVE '8000D'             TO ACTIVE-PARAGRAPH        
                    MOVE 'DELETE'            TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CSR04884_R4'       TO TABLE-1                 
                    MOVE SPACES              TO TABLE-ELEMENT-1         
                    MOVE SPACES              TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                 15291300
       8000D-EXIT.                                                      
            EXIT.                                                       
      *                                                                 15291600
      ******************************************************************15291800
      * 8000E-DEL-GTT-ROWS.                                            *15291900
      ******************************************************************15292000
      *                                                                 15292100
       8000E-DEL-GTT-ROWS.                                              
      *                                                                 15292300
           EXEC SQL                                                     
               DELETE FROM #CSR04884_R5                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     15292400
MFA-TR*        DELETE FROM SESSION.CSR04884_R5                          15292500
MFA-TR*    END-EXEC.                                                    15292600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15292700
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-5.        
      *                                                                 15293000
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-5         
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE SQLCODE             TO ABEND-SQLCODE           
                    MOVE SQLSTATE            TO ABEND-SQLSTATE          
                    MOVE '8000E'             TO ACTIVE-PARAGRAPH        
                    MOVE 'DELETE'            TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CSR04884_R5'       TO TABLE-1                 
                    MOVE SPACES              TO TABLE-ELEMENT-1         
                    MOVE SPACES              TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                 15295000
       8000E-EXIT.                                                      
            EXIT.                                                       
      *                                                                 15295300
      ******************************************************************15295400
      * 8010-INSERT-GTT-R1.                                            *15296000
      ******************************************************************15300000
      *                                                                 15310000
       8010-INSERT-GTT-R1.                                              
      *                                                                 15330000
            EXEC SQL                                                    
               INSERT INTO #CSR04884_R1                          
                  (                                                     
                    RETURN_CODE                                         
                   ,COLL_HIST_SEQ_TS                                    
                   ,COLL_Q                                              
                   ,COLL_EXEMPTION_CD                                   
                   ,WRITE_OFF_DATE                                      
                   ,FUTURE_WORK_DATE                                    
                   ,BILL_ADDR_FLAG                                      
                   ,MULTI_ACCTS_FLAG                                    
                   ,PERM_COMMENT_TEXT                                   
                   ,TRANS_ID                                            
                   ,DNP_FLAG                                            
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE-1                                    
                   ,:S-COLL-HIST-SEQ-TS-1                               
                   ,:S-COLL-Q-1                                         
                   ,:S-COLL-EXEMPTION-CD-1                              
                   ,:S-WRITE-OFF-DATE-1                                 
                   ,:S-FUTURE-WORK-DATE-1                               
                   ,:S-BILL-ADDR-FLAG-1                                 
                   ,:S-MULTI-ACCTS-FLAG-1                               
                   ,:S-PERM-COMMENT-TEXT-1                              
                   ,:S-TRANS-ID-1                                       
                   ,:S-DNP-FLAG-1                                       
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    15340000
MFA-TR*        INSERT INTO SESSION.CSR04884_R1                          15350000
MFA-TR*           (                                                     15360000
MFA-TR*             RETURN_CODE                                         15370000
MFA-TR*            ,COLL_HIST_SEQ_TS                                    15380000
MFA-TR*            ,COLL_Q                                              15390000
MFA-TR*            ,COLL_EXEMPTION_CD                                   15400000
MFA-TR*            ,WRITE_OFF_DATE                                      15410000
MFA-TR*            ,FUTURE_WORK_DATE                                    15411000
MFA-TR*            ,BILL_ADDR_FLAG                                      15412000
MFA-TR*            ,MULTI_ACCTS_FLAG                                    15413000
MFA-TR*            ,PERM_COMMENT_TEXT                                   15414000
MFA-TR*            ,TRANS_ID                                            15415000
MFA-TR*            ,DNP_FLAG                                            15416000
MFA-TR*           )                                                     15420000
MFA-TR*        VALUES                                                   15430000
MFA-TR*           (                                                     15440000
MFA-TR*             :S-RETURN-CODE-1                                    15450000
MFA-TR*            ,:S-COLL-HIST-SEQ-TS-1                               15460000
MFA-TR*            ,:S-COLL-Q-1                                         15470000
MFA-TR*            ,:S-COLL-EXEMPTION-CD-1                              15480000
MFA-TR*            ,:S-WRITE-OFF-DATE-1                                 15490000
MFA-TR*            ,:S-FUTURE-WORK-DATE-1                               15491000
MFA-TR*            ,:S-BILL-ADDR-FLAG-1                                 15492000
MFA-TR*            ,:S-MULTI-ACCTS-FLAG-1                               15493000
MFA-TR*            ,:S-PERM-COMMENT-TEXT-1                              15494000
MFA-TR*            ,:S-TRANS-ID-1                                       15495000
MFA-TR*            ,:S-DNP-FLAG-1                                       15496000
MFA-TR*           )                                                     15500000
MFA-TR*     END-EXEC                                                    15510000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15520000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1.        
      *                                                                 15550000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                         TO  CTR-ROWS-1             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO  ABEND-PROGRAM          
              MOVE '8010'                    TO  ACTIVE-PARAGRAPH       
              MOVE SQLCODE                   TO  ABEND-SQLCODE          
              MOVE 'INSERT'                  TO  ABEND-FUNCTION         
              MOVE SPACES                    TO  ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSR04884_R1'             TO  TABLE-1                
              MOVE SPACES                    TO  TABLE-ELEMENT-1        
              MOVE SPACES                    TO  HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 15700000
        8010-EXIT.                                                      
            EXIT.                                                       
      *                                                                 15730000
      ******************************************************************15740000
      * 8020-INSERT-GTT-R2.                                            *15741000
      ******************************************************************15742000
      *                                                                 15742100
       8020-INSERT-GTT-R2.                                              
      *                                                                 15742300
            EXEC SQL                                                    
               INSERT INTO #CSR04884_R2                          
                  (                                                     
                    RETURN_CODE                                         
                   ,TRANS_ID                                            
                   ,PROMISE_TO_PAY_STATUS                               
                   ,PROMISE_TO_PAY_ACTION                               
                   ,PROMISE_TO_PAY_RESULT                               
                   ,PROMISE_TO_PAY_DATE                                 
                   ,PROMISE_TO_PAY_AMT                                  
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE-2                                    
                   ,:S-TRANS-ID-2                                       
                   ,:S-PROMISE-TO-PAY-STATUS-2                          
                   ,:S-PROMISE-TO-PAY-ACTION-2                          
                   ,:S-PROMISE-TO-PAY-RESULT-2                          
                   ,:S-PROMISE-TO-PAY-DATE-2                            
                   ,:S-PROMISE-TO-PAY-AMT-2                             
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    15742400
MFA-TR*        INSERT INTO SESSION.CSR04884_R2                          15742500
MFA-TR*           (                                                     15742600
MFA-TR*             RETURN_CODE                                         15742700
MFA-TR*            ,TRANS_ID                                            15742800
MFA-TR*            ,PROMISE_TO_PAY_STATUS                               15743000
MFA-TR*            ,PROMISE_TO_PAY_ACTION                               15743100
MFA-TR*            ,PROMISE_TO_PAY_RESULT                               15743200
MFA-TR*            ,PROMISE_TO_PAY_DATE                                 15743300
MFA-TR*            ,PROMISE_TO_PAY_AMT                                  15743400
MFA-TR*           )                                                     15743500
MFA-TR*        VALUES                                                   15743600
MFA-TR*           (                                                     15743700
MFA-TR*             :S-RETURN-CODE-2                                    15743800
MFA-TR*            ,:S-TRANS-ID-2                                       15743900
MFA-TR*            ,:S-PROMISE-TO-PAY-STATUS-2                          15744100
MFA-TR*            ,:S-PROMISE-TO-PAY-ACTION-2                          15744200
MFA-TR*            ,:S-PROMISE-TO-PAY-RESULT-2                          15744300
MFA-TR*            ,:S-PROMISE-TO-PAY-DATE-2                            15744400
MFA-TR*            ,:S-PROMISE-TO-PAY-AMT-2                             15744500
MFA-TR*           )                                                     15744600
MFA-TR*     END-EXEC                                                    15744700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15744800
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-2.        
      *                                                                 15745300
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                         TO  CTR-ROWS-2             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO  ABEND-PROGRAM          
              MOVE '8020'                    TO  ACTIVE-PARAGRAPH       
              MOVE SQLCODE                   TO  ABEND-SQLCODE          
              MOVE 'INSERT'                  TO  ABEND-FUNCTION         
              MOVE SPACES                    TO  ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSR04884_R2'             TO  TABLE-1                
              MOVE SPACES                    TO  TABLE-ELEMENT-1        
              MOVE SPACES                    TO  HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 15746800
        8020-EXIT.                                                      
            EXIT.                                                       
      *                                                                 15747100
      ******************************************************************15747200
      * 8030-INSERT-GTT-R3.                                            *15747300
      ******************************************************************15747400
      *                                                                 15747500
       8030-INSERT-GTT-R3.                                              
      *                                                                 15747700
            EXEC SQL                                                    
               INSERT INTO #CSR04884_R3                          
                  (                                                     
                    RETURN_CODE                                         
                   ,NO_OF_CONTRACTS                                     
                   ,PROMISE_KEPT_NO                                     
                   ,PROMISE_BROKEN_NO                                   
                   ,COLL_EXEMPTION_CD_3                                 
                   ,COLL_COMMENT_DATETIME                               
                   ,COLL_COMMENT_USER_ID                                
                   ,COMMENT_TEXT                                        
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE-3                                    
                   ,:S-NO-OF-CONTRACTS-3                                
                   ,:S-PROMISE-KEPT-NO-3                                
                   ,:S-PROMISE-BROKEN-NO-3                              
                   ,:S-COLL-EXEMPTION-CD-3                              
                   ,:S-COLL-COMMENT-DATETIME-3                          
                   ,:S-COLL-COMMENT-USER-ID-3                           
                   ,:S-COMMENT-TEXT-3                                   
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    15747800
MFA-TR*        INSERT INTO SESSION.CSR04884_R3                          15747900
MFA-TR*           (                                                     15748000
MFA-TR*             RETURN_CODE                                         15748100
MFA-TR*            ,NO_OF_CONTRACTS                                     15748200
MFA-TR*            ,PROMISE_KEPT_NO                                     15748300
MFA-TR*            ,PROMISE_BROKEN_NO                                   15748400
MFA-TR*            ,COLL_EXEMPTION_CD_3                                 15748500
MFA-TR*            ,COLL_COMMENT_DATETIME                               15748600
MFA-TR*            ,COLL_COMMENT_USER_ID                                15748700
MFA-TR*            ,COMMENT_TEXT                                        15748800
MFA-TR*           )                                                     15751000
MFA-TR*        VALUES                                                   15751100
MFA-TR*           (                                                     15751200
MFA-TR*             :S-RETURN-CODE-3                                    15751300
MFA-TR*            ,:S-NO-OF-CONTRACTS-3                                15751400
MFA-TR*            ,:S-PROMISE-KEPT-NO-3                                15751500
MFA-TR*            ,:S-PROMISE-BROKEN-NO-3                              15751600
MFA-TR*            ,:S-COLL-EXEMPTION-CD-3                              15751700
MFA-TR*            ,:S-COLL-COMMENT-DATETIME-3                          15751800
MFA-TR*            ,:S-COLL-COMMENT-USER-ID-3                           15751900
MFA-TR*            ,:S-COMMENT-TEXT-3                                   15752000
MFA-TR*           )                                                     15752100
MFA-TR*     END-EXEC                                                    15752200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15752300
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-3.        
      *                                                                 15752600
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                         TO  CTR-ROWS-3             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO  ABEND-PROGRAM          
              MOVE '8030'                    TO  ACTIVE-PARAGRAPH       
              MOVE SQLCODE                   TO  ABEND-SQLCODE          
              MOVE 'INSERT'                  TO  ABEND-FUNCTION         
              MOVE SPACES                    TO  ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSR04884_R3'             TO  TABLE-1                
              MOVE SPACES                    TO  TABLE-ELEMENT-1        
              MOVE SPACES                    TO  HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 15754100
        8030-EXIT.                                                      
            EXIT.                                                       
      *                                                                 15754400
      ******************************************************************15754500
      * 8040-INSERT-GTT-R4.                                            *15754600
      ******************************************************************15754700
      *                                                                 15754800
       8040-INSERT-GTT-R4.                                              
      *                                                                 15755000
            EXEC SQL                                                    
               INSERT INTO #CSR04884_R4                          
                  (                                                     
                    RETURN_CODE                                         
                   ,AR_DATE_TRANS                                       
                   ,AR_AMT_ORIG_ENTERED                                 
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE-4                                    
                   ,:S-AR-DATE-TRANS-4                                  
                   ,:S-AR-AMT-ORIG-ENTERED-4                            
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    15755100
MFA-TR*        INSERT INTO SESSION.CSR04884_R4                          15755200
MFA-TR*           (                                                     15755300
MFA-TR*             RETURN_CODE                                         15755400
MFA-TR*            ,AR_DATE_TRANS                                       15755500
MFA-TR*            ,AR_AMT_ORIG_ENTERED                                 15755600
MFA-TR*           )                                                     15755700
MFA-TR*        VALUES                                                   15755800
MFA-TR*           (                                                     15755900
MFA-TR*             :S-RETURN-CODE-4                                    15756000
MFA-TR*            ,:S-AR-DATE-TRANS-4                                  15756100
MFA-TR*            ,:S-AR-AMT-ORIG-ENTERED-4                            15756200
MFA-TR*           )                                                     15756300
MFA-TR*     END-EXEC                                                    15756400

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15756500
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-4.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                         TO  CTR-ROWS-4             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO  ABEND-PROGRAM          
              MOVE '8040'                    TO  ACTIVE-PARAGRAPH       
              MOVE SQLCODE                   TO  ABEND-SQLCODE          
              MOVE 'INSERT'                  TO  ABEND-FUNCTION         
              MOVE SPACES                    TO  ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSR04884_R4'             TO  TABLE-1                
              MOVE SPACES                    TO  TABLE-ELEMENT-1        
              MOVE SPACES                    TO  HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 15758300
        8040-EXIT.                                                      
            EXIT.                                                       
      *                                                                 15758600
      ******************************************************************15758700
      * 8050-INSERT-GTT-R5.                                            *15758800
      ******************************************************************15758900
      *                                                                 15759000
       8050-INSERT-GTT-R5.                                              
      *                                                                 15759200
            EXEC SQL                                                    
               INSERT INTO #CSR04884_R5                          
                  (                                                     
                    RETURN_CODE                                         
                   ,BUS_RULE_ID                                         
                   ,BUS_RESULT_CD                                       
                   ,BUS_RULE_XREF_ID                                    
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE-5                                    
                   ,:S-RULE-ID-5                                        
                   ,:S-RULE-RESULT-CD-5                                 
                   ,:S-BUS-RULE-XREF-ID-5                               
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    15759300
MFA-TR*        INSERT INTO SESSION.CSR04884_R5                          15759400
MFA-TR*           (                                                     15759500
MFA-TR*             RETURN_CODE                                         15759600
MFA-TR*            ,BUS_RULE_ID                                         15759700
MFA-TR*            ,BUS_RESULT_CD                                       15759800
MFA-TR*            ,BUS_RULE_XREF_ID                                    15759900
MFA-TR*           )                                                     15760000
MFA-TR*        VALUES                                                   15760100
MFA-TR*           (                                                     15760200
MFA-TR*             :S-RETURN-CODE-5                                    15760300
MFA-TR*            ,:S-RULE-ID-5                                        15760400
MFA-TR*            ,:S-RULE-RESULT-CD-5                                 15760500
MFA-TR*            ,:S-BUS-RULE-XREF-ID-5                               15760600
MFA-TR*           )                                                     15760700
MFA-TR*     END-EXEC                                                    15760800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15760900
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-5.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE  =  SUCCESSFUL-CALL                 
              ADD +1                         TO  CTR-ROWS-5             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO  ABEND-PROGRAM          
              MOVE '8050'                    TO  ACTIVE-PARAGRAPH       
              MOVE SQLCODE                   TO  ABEND-SQLCODE          
              MOVE 'INSERT'                  TO  ABEND-FUNCTION         
              MOVE SPACES                    TO  ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSR04884_R5'             TO  TABLE-1                
              MOVE SPACES                    TO  TABLE-ELEMENT-1        
              MOVE SPACES                    TO  HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 15762800
        8050-EXIT.                                                      
            EXIT.                                                       
      *                                                                 15763100
      ******************************************************************15763200
      * 8800-CHECK-RESULTS.                                            *15763300
      ******************************************************************15764000
      *                                                                 15770000
       8800-CHECK-RESULTS.                                              
      *                                                                 15790000
           IF CTR-ROWS-1    <= 0                                        
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE 100                       TO S-RETURN-CODE-1         
              PERFORM 8010-INSERT-GTT-R1      THRU 8010-EXIT            
           END-IF.                                                      
      *                                                                 15840100
           IF CTR-ROWS-2    <= 0                                        
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE 100                       TO S-RETURN-CODE-2         
              PERFORM 8020-INSERT-GTT-R2      THRU 8020-EXIT            
           END-IF.                                                      
      *                                                                 15856000
           IF CTR-ROWS-3    <= 0                                        
              INITIALIZE GTT-RETURN-FIELDS-3                            
              MOVE 100                       TO S-RETURN-CODE-3         
              PERFORM 8030-INSERT-GTT-R3      THRU 8030-EXIT            
           END-IF.                                                      
      *                                                                 15859300
           IF CTR-ROWS-4    <= 0                                        
              INITIALIZE GTT-RETURN-FIELDS-4                            
              MOVE 100                       TO S-RETURN-CODE-4         
              PERFORM 8040-INSERT-GTT-R4      THRU 8040-EXIT            
           END-IF.                                                      
      *                                                                 15859900
           IF CTR-ROWS-5    <= 0                                        
              INITIALIZE GTT-RETURN-FIELDS-5                            
              MOVE 100                       TO S-RETURN-CODE-5         
              PERFORM 8050-INSERT-GTT-R5      THRU 8050-EXIT            
           END-IF.                                                      
      *                                                                 15860500
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15880000
      ******************************************************************15890000
      * 8900-SEND-DONE.                                                *15900000
      ******************************************************************15910000
      *                                                                 15920000
       8900-SEND-DONE.                                                  
      *                                                                 15940000
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 16000000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1.        
      *                                                                 16030000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '8900'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSR04884_R1'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 16140100
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 16140500
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-2.        
      *                                                                 16140800
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '8900'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSR04884_R2'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 16142000
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 16142400
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-3.        
      *                                                                 16142700
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '8900'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSR04884_R3'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 16144000
           EXEC SQL                                                     
               OPEN C4                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 16149000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-4.        
      *                                                                 16161000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '8900'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSR04884_R4'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 16169400
           EXEC SQL                                                     
               OPEN C5                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 16169800
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-5.        
      *                                                                 16170100
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '8900'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSR04884_R5'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 16171300
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16190000
      ******************************************************************16210000
      * 9000-SEND-ERROR-RESULT.                                        *16220000
      ******************************************************************16230000
      *                                                                 16240000
       9000-SEND-ERROR-RESULT.                                          
      *                                                                 16260000
           MOVE WS-NO                        TO SEND-DONE-SW.           
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1                               
                      GTT-RETURN-FIELDS-2                               
                      GTT-RETURN-FIELDS-3                               
                      GTT-RETURN-FIELDS-4                               
                      GTT-RETURN-FIELDS-5.                              
                                                                        
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE        TO ABEND-SQLCODE           
                                                S-RETURN-CODE-1         
                                                S-RETURN-CODE-2         
                                                S-RETURN-CODE-3         
                                                S-RETURN-CODE-4         
                                                S-RETURN-CODE-5.        
           MOVE SQLERRMC                     TO ABEND-SQLERRMC.         
      *                                                                 16350000
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 16390000
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'                TO ABEND-FUNCTION          
           END-IF.                                                      
      *                                                                 16450000
           PERFORM 0100A-DECLARE-GTT          THRU 0100A-EXIT.          
           PERFORM 0100B-DECLARE-GTT          THRU 0100B-EXIT.          
           PERFORM 0100C-DECLARE-GTT          THRU 0100C-EXIT.          
           PERFORM 0100D-DECLARE-GTT          THRU 0100D-EXIT.          
           PERFORM 0100E-DECLARE-GTT          THRU 0100E-EXIT.          
      *                                                                 16470000
           PERFORM 8010-INSERT-GTT-R1         THRU 8010-EXIT.           
           PERFORM 8020-INSERT-GTT-R2         THRU 8020-EXIT.           
           PERFORM 8030-INSERT-GTT-R3         THRU 8030-EXIT.           
           PERFORM 8040-INSERT-GTT-R4         THRU 8040-EXIT.           
           PERFORM 8050-INSERT-GTT-R5         THRU 8050-EXIT.           
      *                                                                 16520000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16550000
      ******************************************************************16560000
      * INCLUDE CPD0023C FOR 9700- ERROR HANDLING                      *16570000
      ******************************************************************16580000
      *                                                                 16590000
           EXEC SQL                                                     16591000
              INCLUDE CPD0023C                                          16592000
           END-EXEC.                                                    16593000
      *                                                                 16640000
      ******************************************************************16680000
      * 9900-SQL-ERROR-ROUTINE.                                        *16690000
      ******************************************************************16700000
      *                                                                 16710000
           EXEC SQL                                                     16720000
              INCLUDE CPDSP300                                          16730000
           END-EXEC.                                                    16740000
      *                                                                 16750000
      ******************************************************************16760000
      * 9999-END-PROGRAM.                                      *        16770000
      ******************************************************************16780000
      *                                                                 16790000
       9999-END-PROGRAM.                                                
      *                                                                 16810000
           PERFORM 8800-CHECK-RESULTS         THRU 8800-EXIT            
           PERFORM 8900-SEND-DONE             THRU 8900-EXIT            
                                                                        
           
MSQ016        GOBACK.                                                    
      *                                                                 16940000
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                *16970000
      **********************End Of Program *****************************16980000
      *                                                                *16990000
