       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04881.                                          
COB303 DATE-WRITTEN. AUGUST 28, 2015.                                   
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM GETS THE WEB PAYMENT WIDGET DATA.                *        
      *  USES COPYBOOK CPD00375, CPD00376                              *        
      *                                                                *        
      *  BUSOP - GETACCTPYMTWIDGETDATA                                 *        
      *  WEB USES CHANNEL-CD 'WEB'                                     *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE      INITIALS   COMMENTS                               *        
      *  --------    --------   -------------------------------------  *        
      *  08/28/2015  LG41184    NEW PROGRAM.                           *        
      *  06/06/2016  LG41184    FIX FOR SQLCODE -305 IN 7450- PARA.    *        
P00836*  11/01/2016  LG41184    RESULT VARS ADDED FOR DNP MESSAGING.   *        
ACT040*  02/23/2017  BD09555    REMOVE STA TABLE                       *        
ACT040*  02/23/2017  A05744-ACT040                                     *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04881'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04881 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *** CSS_ACCOUNT - AT                                                      
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      *** CSS_MSTSUB_ACCT - MU                                                  
           EXEC SQL                                                             
              INCLUDE TBMSTSUB                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_BILLING_HDR - BI                                                  
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_BILLING_DET - BG                                                  
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_DEP_REQ - DR                                                      
           EXEC SQL                                                             
              INCLUDE TBDEPREQ                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_AR_CNTL  - AC                                                     
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_DFA_ACCT   - DA                                                   
           EXEC SQL                                                             
              INCLUDE TBDFAACT                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_CONTRACT  - CT                                                    
           EXEC SQL                                                             
              INCLUDE TBCNTRCT                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_CREDIT_PROFILE - CZ                                               
           EXEC SQL                                                             
               INCLUDE TBCRPROF                                                 
           END-EXEC.                                                            
                                                                        
      *** CSS_SO_DATA - VO                                                      
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
      *** CSS_BUDGET_HIST - BH                                                  
           EXEC SQL                                                             
              INCLUDE TBBGTHST                                                  
           END-EXEC.                                                            
                                                                        
      ***  CSS_BUDGET_PLAN - BU                                                 
           EXEC SQL                                                             
               INCLUDE TBBGTPLN                                                 
           END-EXEC.                                                            
                                                                        
                                                                        
      *** CSS_CRED_ARNGMENT - X1                                                
           EXEC SQL                                                             
              INCLUDE TBCRARNG                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_CRED_ARNG_HIST - WY                                               
           EXEC SQL                                                             
              INCLUDE TBCRARHS                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_CRED_ARNG_SCHD - WX                                               
           EXEC SQL                                                             
              INCLUDE TBCRARSC                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_WQ_CATEGORY - C3                                                  
           EXEC SQL                                                             
              INCLUDE TBWQCAT                                                   
           END-EXEC.                                                            
                                                                        
      *** CSS_WQ_ITEMS - WQ                                                     
           EXEC SQL                                                             
              INCLUDE TBWQITS                                                   
           END-EXEC.                                                            
                                                                        
      ***  CSS_NSF_HIST     - NH                                                
           EXEC SQL                                                             
               INCLUDE TBNSFHST                                                 
           END-EXEC.                                                            
                                                                        
      ***  CSS_BILL_WINDOW     - BN                                             
           EXEC SQL                                                             
              INCLUDE TBBILWDW                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_BILL_CRED_DET - 1H                                                
           EXEC SQL                                                             
              INCLUDE TBCRBLDL                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_JOB_PARM - G6                                                     
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_DELINQUENCY - C8                                                  
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
           COPY CWS00056.                                                       
           COPY CWS00303.                                                       
           COPY CCA00001.                                                       
           COPY CWS0068L.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE CWS00068                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE CWS00375                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE CWS00376                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE CWS00322                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE CWS00309                                                
           END-EXEC.                                                            
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01 GTT-RETURN-FIELDS.                                            
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1      PIC S9(09)  COMP   VALUE 0.        
             10 S-ACCOUNT-NO         PIC S9(13)V COMP-3 VALUE 0.        
             10 S-STATUS-CODE        PIC S9(09)  COMP   VALUE 0.        
             10 S-CUSTOMER-NO        PIC S9(10)V COMP-3 VALUE 0.        
             10 S-CODE-ACCT-STAT     PIC X(01)          VALUE SPACES.   
             10 S-BILL-CYCLE         PIC X(02)          VALUE SPACES.   
             10 S-LAST-PYMT-DT       PIC X(10)          VALUE SPACES.   
             10 S-LAST-PYMT-AMT      PIC S9(09)V99 COMP-3 VALUE 0.      
             10 S-LAST-BILL-DATE     PIC X(10)          VALUE SPACES.   
             10 S-TOTAL-AR-BALANCE   PIC S9(11)V9(02) COMP-3 VALUE 0.   
             10 S-DISPLAY-DUE-DT     PIC X(10)          VALUE SPACES.   
             10 S-CURRENT-DUE-DT     PIC X(10)          VALUE SPACES.   
             10 S-CURRENT-CHARGES    PIC S9(11)V9(02) COMP-3 VALUE 0.   
             10 S-ARREARS-AMT        PIC S9(11)V9(02) COMP-3 VALUE 0.   
             10 S-ARREARS-DUE-DT     PIC X(10) VALUE SPACES.            
             10 S-MST-SUB-ACCT-IND   PIC X(01) VALUE SPACES.            
             10 S-ACCOUNT-TYPE-CODE  PIC X(01) VALUE SPACES.            
             10 S-COMPANY-NO         PIC X(02) VALUE SPACES.            
             10 S-REG-GROUP-CD       PIC X(03) VALUE SPACES.            
             10 S-MST-ACCT-NO        PIC S9(13)V COMP-3 VALUE 0.        
             10 S-CIAC-CNT-STATUS-CD PIC X(01) VALUE SPACES.            
             10 S-BILL-EXCPN-WQ-FL   PIC X(01) VALUE SPACES.            
             10 S-DNP-FL             PIC X(01) VALUE SPACES.            
             10 S-STA-EXISTS-FL      PIC X(01) VALUE SPACES.            
             10 S-NEED-MORE-TIME-FL  PIC X(01) VALUE SPACES.            
             10 S-CREDIT-GROUP       PIC X(01) VALUE SPACES.            
             10 S-ACCT-CREATE-DT     PIC X(10) VALUE SPACES.            
             10 S-REV-MTH-LST-NRML   PIC S9(6)V COMP-3 VALUE 0.         
             10 S-BBP-FL             PIC X(01) VALUE SPACE.             
             10 S-CASH-ONLY          PIC X(01) VALUE SPACE.             
             10 S-BILL-IMMED-DEP-FL  PIC X(01) VALUE SPACE.             
             10 S-RETURN-CHECK-FL    PIC X(01) VALUE SPACE.             
             10 S-BBP-OFFER-FL       PIC X(01) VALUE SPACE.             
             10 S-BBP-OFFER-AMT      PIC S9(09)V99 COMP-3 VALUE 0.      
             10 S-BBP-ANNIVERSARY-FL PIC X(01) VALUE SPACE.             
             10 S-ANNIV-START-DATE   PIC X(10) VALUE SPACE.             
             10 S-ANNIV-END-DATE     PIC X(10) VALUE SPACE.             
             10 S-CURRENT-BBP-AMOUNT PIC S9(9)V99 COMP-3 VALUE +0.      
             10 S-NEW-BBP-AMOUNT     PIC S9(9)V99 COMP-3 VALUE +0.      
             10 S-BBP-FULL-BALANCE   PIC S9(9)V99 COMP-3 VALUE +0.      
             10 S-CURR-ACCT-BALANCE  PIC S9(9)V99 COMP-3 VALUE +0.      
             10 S-DEPOSIT-AMT        PIC S9(9)V99 COMP-3 VALUE 0.       
             10 S-DPP-SETUP-DT       PIC X(10) VALUE SPACES.            
             10 S-ARNG-TYPE          PIC X(10) VALUE SPACES.            
             10 S-ARNG-SCHD-DUE-DT   PIC X(10) VALUE SPACES.            
             10 S-ARNG-REM-AMT       PIC S9(11)V9(02) COMP-3 VALUE 0.   
             10 S-ARNG-CONFIRM-NO    PIC X(20) VALUE SPACES.            
             10 S-BALANCE-TAG        PIC X(50) VALUE                    
                                                 'CURRENT BALANCE'.     
P00836       10 S-ACTIVE-DNP-FL      PIC X(01) VALUE SPACE.             
P00836       10 S-DNP-DATE           PIC X(10) VALUE SPACES.            
                                                                        
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2      PIC S9(09) COMP VALUE 0.           
             10 S-PYMT-PRIORITY-LVL  PIC S9(04) COMP VALUE +0.          
             10 S-AR-TYPE            PIC X(03)       VALUE SPACES.      
             10 S-ITEM-ID            PIC S9(09) COMP VALUE +0.          
             10 S-AMOUNT-00-DAY      PIC S9(09)V99 COMP-3 VALUE +0.     
             10 S-DUE-DATE           PIC X(10)       VALUE SPACES.      
                                                                        
       01  SWITCHES.                                                    
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-ACCOUNT-NO-CHAR       PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO-CHAR    
                                        PIC 9(13).                      
           05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04881'.     
           05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
           05  WS-NULL-1                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-2                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-3                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-4                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-5                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-6                PIC S9(4) COMP VALUE +0.        
           05  RS-RETURN-CODE           PIC S9(09) COMP VALUE 0.        
           05  WS-NULL-IND-CPD          PIC S9(04) COMP.                
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
           05  WS-SCEG-FL               PIC X(01) VALUE 'N'.            
           05  WS-PSNC-FL               PIC X(01) VALUE 'N'.            
           05  WS-BBP-ONLY-FL           PIC X(01) VALUE SPACES.         
           05  WS-INSTALMNT-CNT-FL      PIC X(01) VALUE SPACES.         
           05  WS-GTT02-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-701                   PIC S9(04) COMP VALUE +701.     
           05  SW-FETCH                 PIC X(01) VALUE 'Y'.            
               88 NO-MORE-ROWS                    VALUE 'N'.            
               88 MORE-ROWS                       VALUE 'Y'.            
           05  WS-RETURN-CHECK-EXISTS   PIC X(01) VALUE SPACE.          
           05  WS-NSF-HIST-EXISTS       PIC X(01) VALUE SPACE.          
           05  WS-BILLING-DET-EXISTS    PIC X(01) VALUE SPACE.          
           05  WS-DATE-YEAR-AGO.                                        
               10 WS-YEAR-AGO-YYYY      PIC 9(04).                      
               10 FILLER                PIC X(01) VALUE '-'.            
               10 WS-YEAR-AGO-MM        PIC 9(02).                      
               10 FILLER                PIC X(01) VALUE '-'.            
               10 WS-YEAR-AGO-DD        PIC 9(02).                      
           05  WS-YEAR-AGO-DATE REDEFINES WS-DATE-YEAR-AGO PIC X(10).   
           05  WS-BBP-ANNIV-DATE        PIC X(10) VALUE SPACES.         
                                                                        
       01  DYNAMIC-CALLS.                                               
           05  WS-MCSCB068             PIC X(08) VALUE 'MCSCB068'.      
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(09) COMP VALUE 0.        
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
                                                                        
           EXEC SQL                                                     
              DECLARE AR-CNTL-CURSOR CURSOR FOR                         
               SELECT PYMT_PRIORITY_LVL,                                
                      ITEM_ID,                                          
                      AMT_AR_DAY_00,                                    
                      AMT_AR_DAY_30,                                    
                      AMT_AR_DAY_60,                                    
                      AMT_AR_DAY_90,                                    
                      AMT_UNUSED_CR                                     
                 FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                       
                  AND PYMT_PRIORITY_LVL IN (90, 100)                    
                  AND ITEM_ID > 0                                       
                  AND AMT_AR_DAY_00 > 0                                 
                FOR READ ONLY                                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE AR-CNTL-CURSOR CURSOR FOR                                 
MFA-TR*        SELECT PYMT_PRIORITY_LVL,                                        
MFA-TR*               ITEM_ID,                                                  
MFA-TR*               AMT_AR_DAY_00,                                            
MFA-TR*               AMT_AR_DAY_30,                                            
MFA-TR*               AMT_AR_DAY_60,                                            
MFA-TR*               AMT_AR_DAY_90,                                            
MFA-TR*               AMT_UNUSED_CR                                             
MFA-TR*          FROM CSS_AR_CNTL                                               
MFA-TR*         WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                               
MFA-TR*           AND PYMT_PRIORITY_LVL IN (90, 100)                            
MFA-TR*           AND ITEM_ID > 0                                               
MFA-TR*           AND AMT_AR_DAY_00 > 0                                         
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7550                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-1     AS RETURN_CODE,              
                      :S-ACCOUNT-NO        AS ACCOUNT_NO,               
                      :S-CUSTOMER-NO       AS CUSTOMER_NO,              
                      :S-CODE-ACCT-STAT    AS CODE_ACCT_STAT,           
                      :S-ACCOUNT-TYPE-CODE AS ACCOUNT_TYPE_CODE,        
                      :S-BILL-CYCLE        AS BILL_CYCLE,               
                      :S-BILL-EXCPN-WQ-FL  AS BILL_EXCPN_WQ_FL,         
                      :S-DNP-FL            AS DNP_FL,                   
                      :S-STA-EXISTS-FL     AS STA_EXISTS_FL,            
                      :S-NEED-MORE-TIME-FL AS NEED_MORE_TIME_FL,        
                      :S-TOTAL-AR-BALANCE  AS TOTAL_AR_BALANCE,         
                      :S-DISPLAY-DUE-DT    AS DISPLAY_DUE_DT,           
                      :S-CURRENT-CHARGES   AS CURRENT_CHARGES,          
                      :S-CURRENT-DUE-DT    AS CURRENT_DUE_DT,           
                      :S-ARREARS-AMT       AS ARREARS_AMT,              
                      :S-ARREARS-DUE-DT    AS ARREARS_DUE_DT,           
                      :S-LAST-BILL-DATE    AS LAST_BILL_DATE,           
                      :S-REV-MTH-LST-NRML  AS REV_MTH_LST_NRML,         
                      :S-COMPANY-NO        AS COMPANY_NO,               
                      :S-MST-SUB-ACCT-IND  AS MST_SUB_ACCT_IND,         
                      :S-MST-ACCT-NO       AS MST_ACCT_NO,              
                      :S-CREDIT-GROUP      AS CREDIT_GROUP,             
                      :S-ACCT-CREATE-DT    AS ACCT_CREATE_DT,           
                      :S-CIAC-CNT-STATUS-CD AS CIAC_CNT_STATUS_CD,      
                      :S-BBP-FL             AS BBP_FL,                  
                      :S-CASH-ONLY          AS CASH_ONLY,               
                      :S-BILL-IMMED-DEP-FL  AS BILL_IMMED_DEP_FL,       
                      :S-RETURN-CHECK-FL    AS RETURN_CHECK_FL,         
                      :S-BBP-OFFER-FL       AS BBP_OFFER_FL,            
                      :S-BBP-OFFER-AMT      AS BBP_OFFER_AMT,           
                      :S-BBP-ANNIVERSARY-FL AS BBP_ANNIVERSARY_FL,      
                      :S-ANNIV-START-DATE   AS ANNIV_START_DATE,        
                      :S-ANNIV-END-DATE     AS ANNIV_END_DATE,          
                      :S-CURRENT-BBP-AMOUNT AS CURRENT_BBP_AMOUNT,      
                      :S-NEW-BBP-AMOUNT     AS NEW_BBP_AMOUNT,          
                      :S-BBP-FULL-BALANCE   AS BBP_FULL_BALANCE,        
                      :S-CURR-ACCT-BALANCE  AS CURR_ACCT_BALANCE,       
                      :S-DEPOSIT-AMT        AS DEPOSIT_AMT,             
                      :S-DPP-SETUP-DT       AS DPP_SETUP_DT,            
                      :S-ARNG-TYPE         AS ARNG_TYPE,                
                      :S-ARNG-SCHD-DUE-DT  AS ARNG_SCHD_DUE_DT,         
                      :S-ARNG-REM-AMT      AS ARNG_REM_AMT,             
                      :S-ARNG-CONFIRM-NO   AS ARNG_CONFIRM_NO,          
                      :S-BALANCE-TAG       AS BALANCE_TAG,              
P00836                :S-ACTIVE-DNP-FL     AS ACTIVE_DNP_FL,            
P00836                :S-DNP-DATE          AS DNP_DATE                  
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-1     AS RETURN_CODE,                      
MFA-TR*               :S-ACCOUNT-NO        AS ACCOUNT_NO,                       
MFA-TR*               :S-CUSTOMER-NO       AS CUSTOMER_NO,                      
MFA-TR*               :S-CODE-ACCT-STAT    AS CODE_ACCT_STAT,                   
MFA-TR*               :S-ACCOUNT-TYPE-CODE AS ACCOUNT_TYPE_CODE,                
MFA-TR*               :S-BILL-CYCLE        AS BILL_CYCLE,                       
MFA-TR*               :S-BILL-EXCPN-WQ-FL  AS BILL_EXCPN_WQ_FL,                 
MFA-TR*               :S-DNP-FL            AS DNP_FL,                           
MFA-TR*               :S-STA-EXISTS-FL     AS STA_EXISTS_FL,                    
MFA-TR*               :S-NEED-MORE-TIME-FL AS NEED_MORE_TIME_FL,                
MFA-TR*               :S-TOTAL-AR-BALANCE  AS TOTAL_AR_BALANCE,                 
MFA-TR*               :S-DISPLAY-DUE-DT    AS DISPLAY_DUE_DT,                   
MFA-TR*               :S-CURRENT-CHARGES   AS CURRENT_CHARGES,                  
MFA-TR*               :S-CURRENT-DUE-DT    AS CURRENT_DUE_DT,                   
MFA-TR*               :S-ARREARS-AMT       AS ARREARS_AMT,                      
MFA-TR*               :S-ARREARS-DUE-DT    AS ARREARS_DUE_DT,                   
MFA-TR*               :S-LAST-BILL-DATE    AS LAST_BILL_DATE,                   
MFA-TR*               :S-REV-MTH-LST-NRML  AS REV_MTH_LST_NRML,                 
MFA-TR*               :S-COMPANY-NO        AS COMPANY_NO,                       
MFA-TR*               :S-MST-SUB-ACCT-IND  AS MST_SUB_ACCT_IND,                 
MFA-TR*               :S-MST-ACCT-NO       AS MST_ACCT_NO,                      
MFA-TR*               :S-CREDIT-GROUP      AS CREDIT_GROUP,                     
MFA-TR*               :S-ACCT-CREATE-DT    AS ACCT_CREATE_DT,                   
MFA-TR*               :S-CIAC-CNT-STATUS-CD AS CIAC_CNT_STATUS_CD,              
MFA-TR*               :S-BBP-FL             AS BBP_FL,                          
MFA-TR*               :S-CASH-ONLY          AS CASH_ONLY,                       
MFA-TR*               :S-BILL-IMMED-DEP-FL  AS BILL_IMMED_DEP_FL,               
MFA-TR*               :S-RETURN-CHECK-FL    AS RETURN_CHECK_FL,                 
MFA-TR*               :S-BBP-OFFER-FL       AS BBP_OFFER_FL,                    
MFA-TR*               :S-BBP-OFFER-AMT      AS BBP_OFFER_AMT,                   
MFA-TR*               :S-BBP-ANNIVERSARY-FL AS BBP_ANNIVERSARY_FL,              
MFA-TR*               :S-ANNIV-START-DATE   AS ANNIV_START_DATE,                
MFA-TR*               :S-ANNIV-END-DATE     AS ANNIV_END_DATE,                  
MFA-TR*               :S-CURRENT-BBP-AMOUNT AS CURRENT_BBP_AMOUNT,              
MFA-TR*               :S-NEW-BBP-AMOUNT     AS NEW_BBP_AMOUNT,                  
MFA-TR*               :S-BBP-FULL-BALANCE   AS BBP_FULL_BALANCE,                
MFA-TR*               :S-CURR-ACCT-BALANCE  AS CURR_ACCT_BALANCE,               
MFA-TR*               :S-DEPOSIT-AMT        AS DEPOSIT_AMT,                     
MFA-TR*               :S-DPP-SETUP-DT       AS DPP_SETUP_DT,                    
MFA-TR*               :S-ARNG-TYPE         AS ARNG_TYPE,                        
MFA-TR*               :S-ARNG-SCHD-DUE-DT  AS ARNG_SCHD_DUE_DT,                 
MFA-TR*               :S-ARNG-REM-AMT      AS ARNG_REM_AMT,                     
MFA-TR*               :S-ARNG-CONFIRM-NO   AS ARNG_CONFIRM_NO,                  
MFA-TR*               :S-BALANCE-TAG       AS BALANCE_TAG,                      
MFA-TR*               :S-ACTIVE-DNP-FL     AS ACTIVE_DNP_FL,                    
MFA-TR*               :S-DNP-DATE          AS DNP_DATE                          
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C2 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE        AS RETURN_CODE,                
                      PYMT_PRIORITY_LVL  AS PYMT_PRIORITY_LVL,          
                      AR_TYPE            AS AR_TYPE,                    
                      ITEM_ID            AS ITEM_ID,                    
                      AMOUNT_00_DAY      AS AMOUNT_00_DAY,              
                      DUE_DATE           AS DUE_DATE                    
                FROM #CSR04881_R2                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE        AS RETURN_CODE,                        
MFA-TR*               PYMT_PRIORITY_LVL  AS PYMT_PRIORITY_LVL,                  
MFA-TR*               AR_TYPE            AS AR_TYPE,                            
MFA-TR*               ITEM_ID            AS ITEM_ID,                            
MFA-TR*               AMOUNT_00_DAY      AS AMOUNT_00_DAY,                      
MFA-TR*               DUE_DATE           AS DUE_DATE                            
MFA-TR*         FROM SESSION.CSR04881_R2                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N2 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-2      AS RETURN_CODE,             
                      :S-PYMT-PRIORITY-LVL  AS PYMT_PRIORITY_LVL,       
                      :S-AR-TYPE            AS AR_TYPE,                 
                      :S-ITEM-ID            AS ITEM_ID,                 
                      :S-AMOUNT-00-DAY      AS AMOUNT_00_DAY,           
                      :S-DUE-DATE           AS DUE_DATE                 
      *               :S-PAST-DUE-FL        AS PAST_DUE_FL                      
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N2 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-2      AS RETURN_CODE,                     
MFA-TR*               :S-PYMT-PRIORITY-LVL  AS PYMT_PRIORITY_LVL,               
MFA-TR*               :S-AR-TYPE            AS AR_TYPE,                         
MFA-TR*               :S-ITEM-ID            AS ITEM_ID,                         
MFA-TR*               :S-AMOUNT-00-DAY      AS AMOUNT_00_DAY,                   
MFA-TR*               :S-DUE-DATE           AS DUE_DATE                         
MFA-TR*               :S-PAST-DUE-FL        AS PAST_DUE_FL                      
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO                PIC X(13).                    
       01  LINK-CHANNEL-CD                PIC X(08).                    
                                                                        
                                                                        
       PROCEDURE DIVISION USING LINK-ACCOUNT-NO,                        
                                LINK-CHANNEL-CD.                        
                                                                        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0102-DECLARE-GTT02.                                              
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04881_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04881_R2
              (                                                          
               RETURN_CODE          INT,                            
               PYMT_PRIORITY_LVL    SMALLINT,                           
               AR_TYPE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,               
               ITEM_ID              INT,                            
               AMOUNT_00_DAY        DECIMAL(11,2),                      
               DUE_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2               
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8002-DELETE-GTT2-ROWS THRU 8002-EXIT              
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE SQLCODE              TO ABEND-SQLCODE             
                 MOVE SQLSTATE             TO ABEND-SQLSTATE            
                 MOVE '0102'               TO ACTIVE-PARAGRAPH          
                 MOVE 'DECLARE GTT'        TO ABEND-FUNCTION            
                 MOVE SPACES               TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                 MOVE 'CSR04881_R2'        TO TABLE-1                   
                 MOVE SPACES               TO TABLE-ELEMENT-1           
                 MOVE SPACES               TO HOSTVAR-ELEMENT-1         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
              END-IF
           END-IF.        
                                                                        
           MOVE 'Y' TO WS-GTT02-DECLARED.                               
       0102-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-ACCOUNT-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.                          
           MOVE LINK-ACCOUNT-NO TO WS-ACCOUNT-NO-CHAR.                  
           MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO.                     
                                                                        
           IF LINK-ACCOUNT-NO = ZEROES                                  
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE +100 TO S-RETURN-CODE-1                             
               MOVE 'NO DATA'   TO S-LAST-PYMT-DT                       
               PERFORM 9999-END-PROGRAM THRU 9999-EXIT                  
           END-IF.                                                      
           ADD 1 TO CTR-ROWS.                                           
                                                                        
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           MOVE '01' TO C8-COMPANY-NO.                                  
           PERFORM 7060-GET-DELINQUENCY-VALUES THRU 7060-EXIT.          
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
            PERFORM 2200-BUILD-RESULT       THRU 2200-EXIT.             
            PERFORM 2900-SET-RESULT-FLAGS   THRU 2900-EXIT.             
            PERFORM 2400-BUILD-RESULT-2     THRU 2400-EXIT.             
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2200-BUILD-RESULT.                                               
                                                                        
           PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT.                  
           MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT.         
           IF AT-MST-SUB-ACCT-IND = 'S'                                 
               PERFORM 7250-MST-SUB THRU 7250-EXIT
           END-IF.                     
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE AT-ACCOUNT-NO TO S-ACCOUNT-NO.                          
           MOVE AT-CUSTOMER-NO TO S-CUSTOMER-NO.                        
           MOVE AT-LAST-PYMT-DATE TO S-LAST-PYMT-DT.                    
           MOVE AT-LAST-PYMT-AMOUNT TO S-LAST-PYMT-AMT.                 
           MOVE AT-BILL-CYCLE       TO S-BILL-CYCLE.                    
           MOVE AT-CODE-ACCT-STAT   TO S-CODE-ACCT-STAT.                
           MOVE AT-ACCOUNT-TYPE-CODE TO S-ACCOUNT-TYPE-CODE.            
           MOVE AT-DATE-BILL-DAY-00  TO S-LAST-BILL-DATE.               
           MOVE AT-TOTAL-AR-BALANCE  TO S-TOTAL-AR-BALANCE.             
           MOVE AT-COMPANY-NO        TO S-COMPANY-NO.                   
           IF WS-CODE-EPP-OFFER = 'A'                                   
              MOVE 'Y'               TO S-BBP-OFFER-FL                  
           END-IF.                                                      
           MOVE AT-EPP-OFFER-AMOUNT  TO S-BBP-OFFER-AMT.                
           MOVE AT-REV-MTH-LST-NRML  TO S-REV-MTH-LST-NRML.             
           MOVE AT-CREDIT-GROUP      TO S-CREDIT-GROUP.                 
           MOVE AT-ACCT-CREATE-DT(1:10) TO S-ACCT-CREATE-DT.            
           MOVE AT-MST-SUB-ACCT-IND  TO S-MST-SUB-ACCT-IND.             
           IF AT-MST-SUB-ACCT-IND = 'S'                                 
               MOVE MU-MST-ACCT-NO TO S-MST-ACCT-NO
           END-IF.                    
                                                                        
           MOVE 'CSR04881' TO WS-CPD00068-CALLING-PGM.                  
           MOVE SPACES                      TO ABEND-FUNCTION           
           PERFORM 6000-GET-ACCT-DATA         THRU                      
                                 6000-GET-ACCT-DATA-EXIT.               
           MOVE WS-BILLED-BALANCE     TO S-TOTAL-AR-BALANCE.            
           MOVE WS-375-DNP-FL         TO S-DNP-FL.                      
P00836     MOVE WS-375-ACTIVE-DNP-FL  TO S-ACTIVE-DNP-FL.               
P00836     MOVE WS-375-DNP-DT         TO S-DNP-DATE.                    
           MOVE WS-BILL-EXCPN-WQ-FL   TO S-BILL-EXCPN-WQ-FL.            
      *    IF WS-BILL-EXCPN-WQ-FL = 'Y' OR WS-BILLED-BALANCE <= 0               
           IF WS-BILL-EXCPN-WQ-FL = 'Y'                                 
              GO TO 2200-EXIT
           END-IF.                                          
                                                                        
           MOVE WS-AMT-ARREARS        TO S-ARREARS-AMT.                 
           MOVE WS-CURR-CHARGES       TO S-CURRENT-CHARGES.             
                                                                        
           MOVE WS-DISPLAY-DUE-DATE   TO S-DISPLAY-DUE-DT.              
           MOVE WS-CURRENT-DUE-DATE   TO S-CURRENT-DUE-DT.              
           MOVE WS-ARREARS-DUE-DATE   TO S-ARREARS-DUE-DT.              
           MOVE WS-STA-EXISTS-FL      TO S-STA-EXISTS-FL.               
                                                                        
           IF AT-MST-SUB-ACCT-IND NOT = 'M'                             
              PERFORM 2480-CHK-TO-SHOW-BILL      THRU 2480-EXIT         
           END-IF.                                                      
                                                                        
           IF WS-BILL-IMMED-DEP-FL NOT = 'Y'                            
              PERFORM 7450-GET-DEPOSIT-AMT    THRU 7450-EXIT
           END-IF.           
           MOVE WS-BILL-IMMED-DEP-FL  TO S-BILL-IMMED-DEP-FL.           
           MOVE WS-DEPOSIT-AMT        TO S-DEPOSIT-AMT.                 
                                                                        
           IF WS-CODE-BUDGET = 'A'                                      
              PERFORM 7400-CHK-BBP-ONLY           THRU 7400-EXIT        
           END-IF.                                                      
           PERFORM 6001-CALC-CURR-ACCT-BALANCE    THRU 6001-EXIT.       
           MOVE WS-CURR-ACCT-BALANCE   TO S-CURR-ACCT-BALANCE.          
                                                                        
           PERFORM 7630-SELECT-CONTRACT-STATUS THRU 7630-EXIT.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE CT-CNT-STATUS-CD TO S-CIAC-CNT-STATUS-CD
           END-IF.            
                                                                        
           PERFORM 7675-ARCNTL-RET-CHECK       THRU 7675-EXIT.          
           IF WS-RETURN-CHECK-EXISTS = 'Y'                              
              PERFORM 7680-SELECT-NSF-HIST     THRU 7680-EXIT           
              IF WS-NSF-HIST-EXISTS = 'Y'                               
                 MOVE 'Y'           TO S-RETURN-CHECK-FL                
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-CODE-BUDGET = 'A'                                      
              PERFORM 7700-SELECT-BUDGET-HIST  THRU 7700-EXIT           
              PERFORM 7720-SELECT-BUDGET-PLAN  THRU 7720-EXIT           
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE BU-AMT-MO-PYMT      TO S-CURRENT-BBP-AMOUNT       
                 MOVE BU-DATE-PYMT-STRT   TO S-ANNIV-START-DATE         
                 MOVE BU-ANNIVERSARY-DATE TO S-ANNIV-END-DATE           
              END-IF                                                    
              IF AT-DATE-BILL-DAY-00 = WS-BBP-ANNIV-DATE AND            
                    AT-LAST-PYMT-DATE <= AT-DATE-BILL-DAY-00            
                 MOVE 'Y'     TO S-BBP-ANNIVERSARY-FL                   
                 MOVE BU-AMT-MO-PYMT-NEW  TO S-NEW-BBP-AMOUNT           
                 MOVE AT-EPP-OFFER-AMOUNT TO S-BBP-FULL-BALANCE         
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-CODE-DPP-ACCT = 'A'                                    
              PERFORM 7650-GET-DPP-SETUP-DT    THRU 7650-EXIT           
           END-IF.                                                      
                                                                        
           IF (WS-CODE-STA-ACCT = 'A' OR WS-CODE-CRED-ARNG = 'A'        
               OR WS-CODE-DPP-ACCT = 'A') AND WS-ARNG-TYPE > SPACES     
              MOVE WS-ARNG-TYPE         TO S-ARNG-TYPE                  
              MOVE WS-ARNG-SCHD-DUE-DT  TO S-ARNG-SCHD-DUE-DT           
              MOVE WS-ARNG-REM-AMT      TO S-ARNG-REM-AMT               
              MOVE WS-ARNG-CONFIRM-NO   TO S-ARNG-CONFIRM-NO            
           END-IF.                                                      
                                                                        
           IF CTR-ROWS = 0                                              
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE +100 TO S-RETURN-CODE-1                             
               MOVE 'NO DATA' TO S-LAST-PYMT-DT                         
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2400-BUILD-RESULT-2.                                             
           MOVE AT-ACCOUNT-NO      TO AC-ACCOUNT-NO.                    
           PERFORM 7550-OPEN-ARCNTL-CURSOR   THRU 7550-EXIT.            
           PERFORM 7555-FETCH-ARCNTL-CURSOR  THRU 7555-EXIT.            
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 2405-PROCESS-ROWS      THRU 2405-EXIT             
                          UNTIL NO-MORE-ROWS                            
           END-IF.                                                      
           PERFORM 7560-CLOSE-ARCNTL-CURSOR  THRU 7560-EXIT.            
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2405-PROCESS-ROWS.                                               
           IF AC-PYMT-PRIORITY-LVL = 100                                
              PERFORM 7610-GET-CONTRACT         THRU 7610-EXIT          
              IF WS-INSTALMNT-CNT-FL = 'Y'                              
                 PERFORM 2410-SET-RESULT-VALUES THRU 2410-EXIT          
              END-IF                                                    
           ELSE                                                         
      *       IF AC-ITEM-ID > 30000000                                          
                 PERFORM 2410-SET-RESULT-VALUES THRU 2410-EXIT          
      *       END-IF                                                            
           END-IF                                                       
           PERFORM 7555-FETCH-ARCNTL-CURSOR     THRU 7555-EXIT.         
                                                                        
       2405-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2410-SET-RESULT-VALUES.                                          
           INITIALIZE GTT-RETURN-FIELDS-2.                              
           IF WS-GTT02-DECLARED = 'N'                                   
              PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT                 
           END-IF.                                                      
           MOVE WS-ACTIVE-RETURN-CODE   TO S-RETURN-CODE-2.             
           MOVE AC-PYMT-PRIORITY-LVL    TO S-PYMT-PRIORITY-LVL.         
           EVALUATE AC-PYMT-PRIORITY-LVL                                
              WHEN 100                                                  
                 MOVE 'CNT'             TO S-AR-TYPE                    
              WHEN 90                                                   
                 IF AC-ITEM-ID > 40000000                               
                    MOVE 'DFA'          TO S-AR-TYPE                    
                 ELSE                                                   
                    MOVE 'DPP'          TO S-AR-TYPE                    
                 END-IF                                                 
              WHEN OTHER                                                
                 MOVE SPACES            TO S-AR-TYPE                    
           END-EVALUATE.                                                
           MOVE AC-ITEM-ID              TO S-ITEM-ID.                   
           MOVE AC-AMT-AR-DAY-00        TO S-AMOUNT-00-DAY.             
           IF AC-PYMT-PRIORITY-LVL = 90 AND AC-ITEM-ID < 30000000       
              MOVE WS-ARNG-SCHD-DUE-DT  TO S-DUE-DATE                   
           ELSE                                                         
              MOVE WS-CURRENT-DUE-DATE  TO S-DUE-DATE                   
           END-IF.                                                      
           PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT.                   
                                                                        
       2410-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2480-CHK-TO-SHOW-BILL.                                           
           PERFORM 6580-SELECT-BILL-HDR      THRU 6580-EXIT.            
           PERFORM 7740-SELECT-BILLING-DET   THRU 7740-EXIT.            
           IF WS-BILLING-DET-EXISTS = 'N'                               
              IF BI-TOT-OTHER-CHARGES = 0 AND BI-TOTAL-ARREARS = 0      
                 MOVE SPACES          TO S-LAST-BILL-DATE               
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2480-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2900-SET-RESULT-FLAGS.                                           
                                                                        
           IF AT-CREDIT-GROUP NOT = 'N' OR S-TOTAL-AR-BALANCE <= 0      
              OR AT-CODE-ACCT-STAT NOT = 'A' OR WS-CODE-DPP-ACCT = 'A'  
              OR WS-CODE-DFA-ACCT = 'A' OR S-BILL-IMMED-DEP-FL = 'Y'    
              MOVE 'N'                TO S-NEED-MORE-TIME-FL            
           ELSE                                                         
              MOVE 'Y'                TO S-NEED-MORE-TIME-FL
           END-IF.           
                                                                        
           IF WS-CODE-BUDGET = 'A'                                      
              MOVE 'Y'                TO S-BBP-FL                       
           ELSE                                                         
              MOVE 'N'                TO S-BBP-FL
           END-IF.                      
                                                                        
           PERFORM 7420-GET-CREDIT-PROFILE   THRU 7420-EXIT.            
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND               
                                      CZ-CASH-ONLY-FL = 'Y'             
              MOVE 'Y'        TO S-CASH-ONLY                            
           ELSE                                                         
              MOVE 'N'        TO S-CASH-ONLY
           END-IF.                           
                                                                        
           IF S-BILL-EXCPN-WQ-FL = 'Y'                                  
              MOVE 'CHECK BACK LATER' TO S-BALANCE-TAG                  
              GO TO 2900-EXIT
           END-IF.                                          
                                                                        
           IF WS-BILL-IMMED-DEP-FL = 'Y'                                
              MOVE 'DEPOSIT'          TO S-BALANCE-TAG                  
              GO TO 2900-EXIT
           END-IF.                                          
                                                                        
           IF WS-BILLED-BALANCE < 0                                     
              MOVE 'CREDIT BALANCE'   TO S-BALANCE-TAG                  
              GO TO 2900-EXIT                                           
           END-IF.                                                      
                                                                        
           IF S-ARREARS-AMT > 0                                         
              IF S-CURRENT-CHARGES > 0                                  
                 MOVE 'PAST & CURRENT CHARGES' TO S-BALANCE-TAG         
              ELSE                                                      
                 MOVE 'PAST DUE BALANCE'       TO S-BALANCE-TAG         
              END-IF                                                    
           ELSE                                                         
              IF WS-BBP-ONLY-FL = 'Y' AND WS-BILLED-BALANCE > 0         
                    AND WS-BILLED-BALANCE = BU-AMT-MO-PYMT              
                 MOVE 'BUDGET BILLING AMOUNT' TO S-BALANCE-TAG          
              ELSE                                                      
                 MOVE 'CURRENT BALANCE'       TO S-BALANCE-TAG          
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      * 5900-NEXT-BILL-DATE.                                                    
      ************************************************************              
           EXEC SQL                                                             
              INCLUDE CPD0309A                                                  
           END-EXEC.                                                            
                                                                        
      ************************************************************              
      * 6000-GET-ACCT-DATA.                                                     
      ************************************************************              
           EXEC SQL                                                             
              INCLUDE CPD00375                                                  
           END-EXEC.                                                            
                                                                        
      ************************************************************              
      * 6001-CALC-CURR-ACCT-BALANCE.                                            
      ************************************************************              
           EXEC SQL                                                             
              INCLUDE CPD00376                                                  
           END-EXEC.                                                            
                                                                        
      ************************************************************              
      * 6525-PREV-BUSINESS-DAY.                                                 
      ************************************************************              
           EXEC SQL                                                             
              INCLUDE CPD00322                                                  
           END-EXEC.                                                            
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
               SELECT CUSTOMER_NO,                                      
                      BILL_CYCLE,                                       
                      CODE_ACCT_STAT,                                   
                      ACCOUNT_TYPE_CODE,                                
                      DATE_BILL_DAY_00,                                 
                      DATE_BILL_DAY_30,                                 
                      DATE_BILL_DAY_60,                                 
                      DATE_BILL_DAY_90,                                 
                      TOTAL_AR_BALANCE,                                 
                      CODE_BILL_FREQ,                                   
                      BANKRUPTCY_IND,                                   
                      JUDGEMENT_IND,                                    
                      PREMISE_NO,                                       
                      COMPANY_NO,                                       
                      CODES_DATA_PRESENT,                               
                      LAST_PYMT_DATE,                                   
                      LAST_PYMT_AMOUNT,                                 
                      NO_BILL_COPIES,                                   
                      EPP_OFFER_AMOUNT,                                 
                      REV_MTH_LST_NRML,                                 
                      CREDIT_GROUP,                                     
                      LOCAL_OFFICE,                                     
                      REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_CREATE_DT
           , 121), ' ', '-'), ':', '.') ACCT_CREATE_DT,                        
                      NOTICE_EXEMPT_CD,                                 
                      CODE_DISC_OK,                                     
                      IVR_EXEMPT_CD,                                    
                      MST_SUB_ACCT_IND                                  
                 INTO :AT-CUSTOMER-NO,                                  
                      :AT-BILL-CYCLE,                                   
                      :AT-CODE-ACCT-STAT,                               
                      :AT-ACCOUNT-TYPE-CODE,                            
                      :AT-DATE-BILL-DAY-00,                             
                      :AT-DATE-BILL-DAY-30,                             
                      :AT-DATE-BILL-DAY-60,                             
                      :AT-DATE-BILL-DAY-90,                             
                      :AT-TOTAL-AR-BALANCE,                             
                      :AT-CODE-BILL-FREQ,                               
                      :AT-BANKRUPTCY-IND,                               
                      :AT-JUDGEMENT-IND,                                
                      :AT-PREMISE-NO,                                   
                      :AT-COMPANY-NO,                                   
                      :AT-CODES-DATA-PRESENT,                           
                      :AT-LAST-PYMT-DATE :WS-NULL-1,                     
                      :AT-LAST-PYMT-AMOUNT,                             
                      :AT-NO-BILL-COPIES,                               
                      :AT-EPP-OFFER-AMOUNT,                             
                      :AT-REV-MTH-LST-NRML,                             
                      :AT-CREDIT-GROUP,                                 
                      :AT-LOCAL-OFFICE,                                 
                      :AT-ACCT-CREATE-DT,                               
                      :AT-NOTICE-EXEMPT-CD,                             
                      :AT-CODE-DISC-OK,                                 
                      :AT-IVR-EXEMPT-CD,                                
                      :AT-MST-SUB-ACCT-IND                              
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CUSTOMER_NO,                                              
MFA-TR*               BILL_CYCLE,                                               
MFA-TR*               CODE_ACCT_STAT,                                           
MFA-TR*               ACCOUNT_TYPE_CODE,                                        
MFA-TR*               DATE_BILL_DAY_00,                                         
MFA-TR*               DATE_BILL_DAY_30,                                         
MFA-TR*               DATE_BILL_DAY_60,                                         
MFA-TR*               DATE_BILL_DAY_90,                                         
MFA-TR*               TOTAL_AR_BALANCE,                                         
MFA-TR*               CODE_BILL_FREQ,                                           
MFA-TR*               BANKRUPTCY_IND,                                           
MFA-TR*               JUDGEMENT_IND,                                            
MFA-TR*               PREMISE_NO,                                               
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               CODES_DATA_PRESENT,                                       
MFA-TR*               LAST_PYMT_DATE,                                           
MFA-TR*               LAST_PYMT_AMOUNT,                                         
MFA-TR*               NO_BILL_COPIES,                                           
MFA-TR*               EPP_OFFER_AMOUNT,                                         
MFA-TR*               REV_MTH_LST_NRML,                                         
MFA-TR*               CREDIT_GROUP,                                             
MFA-TR*               LOCAL_OFFICE,                                             
MFA-TR*               ACCT_CREATE_DT,                                           
MFA-TR*               NOTICE_EXEMPT_CD,                                         
MFA-TR*               CODE_DISC_OK,                                             
MFA-TR*               IVR_EXEMPT_CD,                                            
MFA-TR*               MST_SUB_ACCT_IND                                          
MFA-TR*          INTO :AT-CUSTOMER-NO,                                          
MFA-TR*               :AT-BILL-CYCLE,                                           
MFA-TR*               :AT-CODE-ACCT-STAT,                                       
MFA-TR*               :AT-ACCOUNT-TYPE-CODE,                                    
MFA-TR*               :AT-DATE-BILL-DAY-00,                                     
MFA-TR*               :AT-DATE-BILL-DAY-30,                                     
MFA-TR*               :AT-DATE-BILL-DAY-60,                                     
MFA-TR*               :AT-DATE-BILL-DAY-90,                                     
MFA-TR*               :AT-TOTAL-AR-BALANCE,                                     
MFA-TR*               :AT-CODE-BILL-FREQ,                                       
MFA-TR*               :AT-BANKRUPTCY-IND,                                       
MFA-TR*               :AT-JUDGEMENT-IND,                                        
MFA-TR*               :AT-PREMISE-NO,                                           
MFA-TR*               :AT-COMPANY-NO,                                           
MFA-TR*               :AT-CODES-DATA-PRESENT,                                   
MFA-TR*               :AT-LAST-PYMT-DATE:WS-NULL-1,                             
MFA-TR*               :AT-LAST-PYMT-AMOUNT,                                     
MFA-TR*               :AT-NO-BILL-COPIES,                                       
MFA-TR*               :AT-EPP-OFFER-AMOUNT,                                     
MFA-TR*               :AT-REV-MTH-LST-NRML,                                     
MFA-TR*               :AT-CREDIT-GROUP,                                         
MFA-TR*               :AT-LOCAL-OFFICE,                                         
MFA-TR*               :AT-ACCT-CREATE-DT,                                       
MFA-TR*               :AT-NOTICE-EXEMPT-CD,                                     
MFA-TR*               :AT-CODE-DISC-OK,                                         
MFA-TR*               :AT-IVR-EXEMPT-CD,                                        
MFA-TR*               :AT-MST-SUB-ACCT-IND                                      
MFA-TR*          FROM CSS_ACCOUNT AT                                            
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-1 < 0                                     
                       MOVE SPACES TO AT-LAST-PYMT-DATE                 
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7000'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7060-GET-DELINQUENCY-VALUES.                                     
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
              WHERE DELINQ_CD = :C8-DELINQ-CD                           
                AND COMPANY_NO = :C8-COMPANY-NO                         
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*       WHERE DELINQ_CD = :C8-DELINQ-CD                                   
MFA-TR*         AND COMPANY_NO = :C8-COMPANY-NO                                 
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7060                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 1 TO C8-DELINQ-VALUE                            
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7060'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DELINQ_CD'      TO TABLE-ELEMENT-1             
                   MOVE C8-DELINQ-CD     TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7250-MST-SUB.                                                    
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MST_ACCT_NO                                       
                 INTO :MU-MST-ACCT-NO                                   
                 FROM CSS_MSTSUB_ACCT WITH(READUNCOMMITTED)                     
                WHERE SUB_ACCT_NO = :AT-ACCOUNT-NO                      
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MST_ACCT_NO                                               
MFA-TR*          INTO :MU-MST-ACCT-NO                                           
MFA-TR*          FROM CSS_MSTSUB_ACCT                                           
MFA-TR*         WHERE SUB_ACCT_NO = :AT-ACCOUNT-NO                              
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7250                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  MU-MST-ACCT-NO                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7250'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_MSTSUB_ACCT'    TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-CHK-BBP-ONLY.                                               
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :WS-BBP-ONLY-FL                                   
                 FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                
                  AND PYMT_PRIORITY_LVL = 50                            
                  AND ITEM_ID = 0                                       
                  AND NOT EXISTS                                        
                          (SELECT '1'                                   
                             FROM CSS_AR_CNTL WITH(READUNCOMMITTED)             
                            WHERE ACCOUNT_NO = :AT-ACCOUNT-NO           
                              AND PYMT_PRIORITY_LVL <> 50)              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-BBP-ONLY-FL                                           
MFA-TR*          FROM CSS_AR_CNTL                                               
MFA-TR*         WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                        
MFA-TR*           AND PYMT_PRIORITY_LVL = 50                                    
MFA-TR*           AND ITEM_ID = 0                                               
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*                   (SELECT '1'                                           
MFA-TR*                      FROM CSS_AR_CNTL                                   
MFA-TR*                     WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                   
MFA-TR*                       AND PYMT_PRIORITY_LVL <> 50)                      
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7400'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_AR_CNTL'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7420-GET-CREDIT-PROFILE.                                                
      *****************************************************************         
       7420-GET-CREDIT-PROFILE.                                         
           EXEC SQL                                                     
               SELECT CASH_ONLY_FL                                      
                 INTO :CZ-CASH-ONLY-FL                                  
                 FROM CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                  
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CASH_ONLY_FL                                              
MFA-TR*          INTO :CZ-CASH-ONLY-FL                                          
MFA-TR*          FROM CSS_CREDIT_PROFILE                                        
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7420                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7420'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CREDIT_PROFILE' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7450-GET-DEPOSIT-AMT.                                            
           EXEC SQL                                                     
               SELECT SUM(AMT_AR_DAY_00 + AMT_AR_DAY_30 +               
                       AMT_AR_DAY_60 + AMT_AR_DAY_90 +                  
                       AMT_UNUSED_CR)                                   
                 INTO :WS-DEPOSIT-AMT :WS-NULL-6                         
                 FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND PYMT_PRIORITY_LVL = 80                            
                  AND ITEM_ID > 0                                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_AR_DAY_00 + AMT_AR_DAY_30 +                       
MFA-TR*                AMT_AR_DAY_60 + AMT_AR_DAY_90 +                          
MFA-TR*                AMT_UNUSED_CR)                                           
MFA-TR*          INTO :WS-DEPOSIT-AMT:WS-NULL-6                                 
MFA-TR*          FROM CSS_AR_CNTL                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND PYMT_PRIORITY_LVL = 80                                    
MFA-TR*           AND ITEM_ID > 0                                               
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7450                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 IF WS-NULL-6 < 0                                       
                    MOVE ZERO         TO WS-DEPOSIT-AMT                 
                 END-IF                                                 
              WHEN NOT-FOUND                                            
                 CONTINUE                                               
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '7450'             TO ACTIVE-PARAGRAPH            
                 MOVE 'SELECT'           TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE 'CSS_AR_CNTL'      TO TABLE-1                     
                 MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1             
                 MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1           
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
           END-EVALUATE.                                                
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7550-OPEN-ARCNTL-CURSOR.                                         
           EXEC SQL                                                     
               OPEN AR-CNTL-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME     TO ABEND-PROGRAM                    
              MOVE '7550'           TO ACTIVE-PARAGRAPH                 
              MOVE 'OPEN'           TO ABEND-FUNCTION                   
              MOVE SPACES           TO ABEND-SQL-PREDICATES             
                                       ABEND-TABLES                     
              MOVE 'CSS_AR_CNTL'    TO TABLE-1                          
              MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1                  
              MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1                
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7555-FETCH-ARCNTL-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
               FETCH AR-CNTL-CURSOR                                     
                INTO :AC-PYMT-PRIORITY-LVL,                             
                     :AC-ITEM-ID,                                       
                     :AC-AMT-AR-DAY-00,                                 
                     :AC-AMT-AR-DAY-30,                                 
                     :AC-AMT-AR-DAY-60,                                 
                     :AC-AMT-AR-DAY-90,                                 
                     :AC-AMT-UNUSED-CR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 SET NO-MORE-ROWS TO TRUE                               
              ELSE                                                      
                 MOVE PROGRAM-NAME     TO ABEND-PROGRAM                 
                 MOVE '7555'           TO ACTIVE-PARAGRAPH              
                 MOVE 'FETCH'          TO ABEND-FUNCTION                
                 MOVE SPACES           TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
                 MOVE 'CSS_AR_CNTL'    TO TABLE-1                       
                 MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1               
                 MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1             
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7555-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7560-CLOSE-ARCNTL-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
               CLOSE AR-CNTL-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME     TO ABEND-PROGRAM                    
              MOVE '7560'           TO ACTIVE-PARAGRAPH                 
              MOVE 'OPEN'           TO ABEND-FUNCTION                   
              MOVE SPACES           TO ABEND-SQL-PREDICATES             
                                       ABEND-TABLES                     
              MOVE 'CSS_AR_CNTL'    TO TABLE-1                          
              MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1                  
              MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1                
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7560-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7610-GET-CONTRACT.                                               
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-INSTALMNT-CNT-FL                               
                FROM CSS_CONTRACT WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          
                 AND CNT_ITEM_ID       = :AC-ITEM-ID                    
                 AND CODE_BILL_TYPE    = 'C'                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-INSTALMNT-CNT-FL                                       
MFA-TR*         FROM CSS_CONTRACT                                               
MFA-TR*        WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                         
MFA-TR*          AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL                  
MFA-TR*          AND CNT_ITEM_ID       = :AC-ITEM-ID                            
MFA-TR*          AND CODE_BILL_TYPE    = 'C'                                    
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7610                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                  CONTINUE                                              
               WHEN NOT-FOUND                                           
                  MOVE 'N'                   TO WS-INSTALMNT-CNT-FL     
               WHEN OTHER                                               
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE '7610'                TO ACTIVE-PARAGRAPH        
                  MOVE 'OPEN'                TO ABEND-FUNCTION          
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                  MOVE 'CSS_AR_CNTL'         TO TABLE-1                 
                  MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1         
                  MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2         
                  MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3         
                  MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1       
                  MOVE AC-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2       
                  MOVE AC-ITEM-ID            TO HOSTVAR-ELEMENT-3       
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT             
           END-EVALUATE.                                                
                                                                        
       7610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7630-SELECT-CONTRACT-STATUS                                             
      * SELECT CONTRACT STATUS                                                  
      *****************************************************************         
       7630-SELECT-CONTRACT-STATUS.                                     
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CNT_STATUS_CD                                      
                INTO :CT-CNT-STATUS-CD                                  
                FROM CSS_CONTRACT CT WITH(READUNCOMMITTED)                      
               WHERE CT.ACCOUNT_NO        = :AT-ACCOUNT-NO              
                 AND CT.CNT_NAME_CD       = :WS-701                     
               ORDER BY  DATE_CONTRACT DESC                             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CNT_STATUS_CD                                              
MFA-TR*         INTO :CT-CNT-STATUS-CD                                          
MFA-TR*         FROM CSS_CONTRACT CT                                            
MFA-TR*        WHERE CT.ACCOUNT_NO        = :AT-ACCOUNT-NO                      
MFA-TR*          AND CT.CNT_NAME_CD       = :WS-701                             
MFA-TR*        ORDER BY  DATE_CONTRACT DESC                                     
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7630                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7630'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CONTRACT'       TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7630-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7650-GET-DPP-SETUP-DT.                                           
           EXEC SQL                                                     
              SELECT TOP(1) DATE_OF_AGREE                                      
                INTO :DA-DATE-OF-AGREE :WS-NULL-2                        
                FROM CSS_DFA_ACCT DA WITH(READUNCOMMITTED)                      
               WHERE DA.ACCOUNT_NO        = :AT-ACCOUNT-NO              
                 AND DA.PYMT_PRIORITY_LVL = 90                          
                 AND DA.CODE_DFA_TYPE     = 'B'                         
                 AND DA.CODE_DFA_STATUS   = 'A'                         
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE_OF_AGREE                                              
MFA-TR*         INTO :DA-DATE-OF-AGREE:WS-NULL-2                                
MFA-TR*         FROM CSS_DFA_ACCT DA                                            
MFA-TR*        WHERE DA.ACCOUNT_NO        = :AT-ACCOUNT-NO                      
MFA-TR*          AND DA.PYMT_PRIORITY_LVL = 90                                  
MFA-TR*          AND DA.CODE_DFA_TYPE     = 'B'                                 
MFA-TR*          AND DA.CODE_DFA_STATUS   = 'A'                                 
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7650                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-NULL-2 < 0                                          
                  MOVE SPACES           TO S-DPP-SETUP-DT,              
                                           DA-DATE-OF-AGREE             
              ELSE                                                      
                  MOVE DA-DATE-OF-AGREE TO S-DPP-SETUP-DT               
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE '7650'               TO ACTIVE-PARAGRAPH          
                 MOVE 'SELECT'             TO ABEND-FUNCTION            
                 MOVE 'CSS_DFA_ACCT'       TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
                 MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7650-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7675-ARCNTL-RET-CHECK.                                           
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-RETURN-CHECK-EXISTS                            
                FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                   
                 AND PYMT_PRIORITY_LVL IN (020, 029)                    
                 AND (AMT_AR_DAY_00 > 0 OR                              
                      AMT_AR_DAY_30 > 0 OR                              
                      AMT_AR_DAY_60 > 0 OR                              
                      AMT_AR_DAY_90 > 0)                                
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-RETURN-CHECK-EXISTS                                    
MFA-TR*         FROM CSS_AR_CNTL                                                
MFA-TR*        WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                           
MFA-TR*          AND PYMT_PRIORITY_LVL IN (020, 029)                            
MFA-TR*          AND (AMT_AR_DAY_00 > 0 OR                                      
MFA-TR*               AMT_AR_DAY_30 > 0 OR                                      
MFA-TR*               AMT_AR_DAY_60 > 0 OR                                      
MFA-TR*               AMT_AR_DAY_90 > 0)                                        
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7675                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 MOVE 'N'           TO WS-RETURN-CHECK-EXISTS           
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE '7675'               TO ACTIVE-PARAGRAPH          
                 MOVE 'SELECT'             TO ABEND-FUNCTION            
                 MOVE 'CSS_AR_CNTL'        TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
                 MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
           END-EVALUATE.                                                
                                                                        
       7675-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7680-SELECT-NSF-HIST.                                            
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( YEAR, -1, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-YEAR-AGO-DATE                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES (DATE(:WS-CURRENT-DATE) - 1 YEAR)                          
MFA-TR*         INTO :WS-YEAR-AGO-DATE                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                         
                INTO :NH-ACCOUNT-NO                                     
                FROM CSS_NSF_HIST WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                 AND DATE_TRAN  > IIF(TRY_CONVERT(DATE, 
                                                      :WS-YEAR-AGO-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-YEAR-AGO-DATE
              ) <> 0) OR (LEN(:WS-YEAR-AGO-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-YEAR-AGO-DATE
              ), CONVERT(DATE, :WS-YEAR-AGO-DATE) )                     
                 AND NSF_STATUS_CD IN ('C','F')                         
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*         INTO :NH-ACCOUNT-NO                                             
MFA-TR*         FROM CSS_NSF_HIST                                               
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*          AND DATE_TRAN  > :WS-YEAR-AGO-DATE                             
MFA-TR*          AND NSF_STATUS_CD IN ('C','F')                                 
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7680                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 MOVE 'Y'           TO WS-NSF-HIST-EXISTS               
              WHEN NOT-FOUND                                            
                 MOVE 'N'           TO WS-NSF-HIST-EXISTS               
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE '7680'               TO ACTIVE-PARAGRAPH          
                 MOVE 'SELECT'             TO ABEND-FUNCTION            
                 MOVE 'CSS_NSF_HIST'       TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
                 MOVE 'DATE_TRAN'          TO TABLE-ELEMENT-2           
                 MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
                 MOVE WS-YEAR-AGO-DATE     TO HOSTVAR-ELEMENT-2         
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
           END-EVALUATE.                                                
                                                                        
       7680-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7700-SELECT-BUDGET-HIST.                                         
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), MAX(
           BUD_HIST_SEQ_NO), 121), ' ', '-'), ':', '.')                        
                INTO :BH-BUD-HIST-SEQ-NO :WS-NULL-3                      
                FROM CSS_BUDGET_HIST WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                 AND PYMT_PRIORITY_LVL = 50                             
                 AND CHANGE_REASON = 'A'                                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(BUD_HIST_SEQ_NO)                                       
MFA-TR*         INTO :BH-BUD-HIST-SEQ-NO:WS-NULL-3                              
MFA-TR*         FROM CSS_BUDGET_HIST                                            
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*          AND PYMT_PRIORITY_LVL = 50                                     
MFA-TR*          AND CHANGE_REASON = 'A'                                        
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7700                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 IF WS-NULL-3 < 0                                       
                    MOVE SPACES     TO WS-BBP-ANNIV-DATE                
                 ELSE                                                   
                    MOVE BH-BUD-HIST-SEQ-NO(1:10) TO WS-BBP-ANNIV-DATE  
                 END-IF                                                 
              WHEN NOT-FOUND                                            
                 CONTINUE                                               
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE '7700'               TO ACTIVE-PARAGRAPH          
                 MOVE 'SELECT'             TO ABEND-FUNCTION            
                 MOVE 'CSS_BUDGET_HIST'    TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
                 MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
           END-EVALUATE.                                                
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7720-SELECT-BUDGET-PLAN.                                         
           EXEC SQL                                                     
              SELECT AMT_MO_PYMT,                                       
                     AMT_MO_PYMT_NEW,                                   
                     DATE_PYMT_STRT,                                    
                     ANNIVERSARY_DATE                                   
                INTO :BU-AMT-MO-PYMT,                                   
                     :BU-AMT-MO-PYMT-NEW,                               
                     :BU-DATE-PYMT-STRT :WS-NULL-4,                      
                     :BU-ANNIVERSARY-DATE :WS-NULL-5                     
                FROM CSS_BUDGET_PLAN WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                 AND PYMT_PRIORITY_LVL = 50                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AMT_MO_PYMT,                                               
MFA-TR*              AMT_MO_PYMT_NEW,                                           
MFA-TR*              DATE_PYMT_STRT,                                            
MFA-TR*              ANNIVERSARY_DATE                                           
MFA-TR*         INTO :BU-AMT-MO-PYMT,                                           
MFA-TR*              :BU-AMT-MO-PYMT-NEW,                                       
MFA-TR*              :BU-DATE-PYMT-STRT:WS-NULL-4,                              
MFA-TR*              :BU-ANNIVERSARY-DATE:WS-NULL-5                             
MFA-TR*         FROM CSS_BUDGET_PLAN                                            
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*          AND PYMT_PRIORITY_LVL = 50                                     
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7720                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 IF WS-NULL-4 < 0                                       
                    MOVE SPACES     TO BU-DATE-PYMT-STRT                
                 END-IF                                                 
                 IF WS-NULL-5 < 0                                       
                    MOVE SPACES     TO BU-ANNIVERSARY-DATE              
                 END-IF                                                 
              WHEN NOT-FOUND                                            
                 CONTINUE                                               
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE '7720'               TO ACTIVE-PARAGRAPH          
                 MOVE 'SELECT'             TO ABEND-FUNCTION            
                 MOVE 'CSS_BUDGET_PLAN'    TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
                 MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
           END-EVALUATE.                                                
       7720-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7740-SELECT-BILLING-DET.                                         
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-BILLING-DET-EXISTS                            
                 FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND BILL_NO = :BI-BILL-NO                             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-BILLING-DET-EXISTS                                    
MFA-TR*          FROM CSS_BILLING_DET                                           
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND BILL_NO = :BI-BILL-NO                                     
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7740                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 MOVE 'N'           TO WS-BILLING-DET-EXISTS            
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE '7740'               TO ACTIVE-PARAGRAPH          
                 MOVE 'SELECT'             TO ABEND-FUNCTION            
                 MOVE 'CSS_BILLING_DET'    TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
                 MOVE 'BILL_NO'            TO TABLE-ELEMENT-2           
                 MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
                 MOVE BI-BILL-NO           TO HOSTVAR-ELEMENT-2         
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
           END-EVALUATE.                                                
       7740-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8002-DELETE-GTT2-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04881_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04881_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8002'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04881_R2'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8002-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-SEND-RESULT-2.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04881_R2                           
              (                                                         
                 RETURN_CODE,                                           
                 PYMT_PRIORITY_LVL,                                     
                 AR_TYPE,                                               
                 ITEM_ID,                                               
                 AMOUNT_00_DAY,                                         
                 DUE_DATE                                               
              )                                                         
              VALUES                                                    
              (                                                         
                :S-RETURN-CODE-2,                                       
                :S-PYMT-PRIORITY-LVL,                                   
                :S-AR-TYPE,                                             
                :S-ITEM-ID,                                             
                :S-AMOUNT-00-DAY,                                       
                :S-DUE-DATE                                             
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04881_R2                                   
MFA-TR*       (                                                                 
MFA-TR*          RETURN_CODE,                                                   
MFA-TR*          PYMT_PRIORITY_LVL,                                             
MFA-TR*          AR_TYPE,                                                       
MFA-TR*          ITEM_ID,                                                       
MFA-TR*          AMOUNT_00_DAY,                                                 
MFA-TR*          DUE_DATE                                                       
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*         :S-RETURN-CODE-2,                                               
MFA-TR*         :S-PYMT-PRIORITY-LVL,                                           
MFA-TR*         :S-AR-TYPE,                                                     
MFA-TR*         :S-ITEM-ID,                                                     
MFA-TR*         :S-AMOUNT-00-DAY,                                               
MFA-TR*         :S-DUE-DATE                                                     
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04881_R2'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           IF WS-GTT02-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-2                             
               EXEC SQL                                                 
                   OPEN N2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1                
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 9700-PROCESS-ABEND.                                        *            
      **************************************************************            
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
                                                                        
      ************************************************************              
      * 9900-  ERROR HANDLING INCLUDE *                                         
      ************************************************************              
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
       9999-END-PROGRAM.                                                
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '9999-END-PROGRAM'  TO ABEND-FUNCTION                
              MOVE 'PROGRAMMER LOGIC'  TO TABLE-1                       
              MOVE 'FAILED TO SEND'    TO TABLE-ELEMENT-1               
              MOVE 'RESULT SET'        TO HOSTVAR-ELEMENT-1             
              MOVE -1                  TO WS-ACTIVE-RETURN-CODE         
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT
           END-IF.                 
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
                                                                        
