       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04880.                                         
COB303 DATE-WRITTEN.  NOVEMBER 2015.                                    
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00000600
      *                                                                *00000700
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00000800
      *                                                                *00000900
      ******************************************************************00001000
      *                                                                *00001200
      *                P R O G R A M  S U M M A R Y                    *00001100
      *                                                                *00001200
      ******************************************************************00001000
      *                                                                *00001200
      *  THIS PROCEDURE IS TO PROCESS SIMPLE PAY CORRECTIONS IN MOD    *        
      *  IT POSTS PAYMENTS, AND WRITES JOURNAL AND TRANSACTION         *00001300
      *  HISTORY.                                                      *00001300
      *                                                                *00001500
      *  BUSOP NAME: REQUUPDACCTPAYCORRECTION BUSINESSOP               *00001600
      *                                                                *00001200
      ******************************************************************00001700
      *                                                                *00001800
      *                     PROGRAM MODIFICATION LOG                   *00001900
      *                                                                *00001800
      ******************************************************************00001700
      *                                                                *00002000
      *    DATE    INITIALS   COMMENTS                                 *00002100
      *  --------  --------   ---------------------------------------  *00002200
P00586*  11/17/15  CB18344    INITIAL VERSION OF PAYMENT POSTING FOR   *00002400
      *                       PAYMENT CORRECTION PROCESS.              *        
A04860*  04/28/16  MS7M727   REPLACE CSS_WQ_ITEMS_MF TABLE WITH        *01790100
A04860*            ACT113    CSS_WQ_ITEMS TABLE                        *01790200
P00586*  06/28/16  AP40911   CHANGE MADE TO WRITE TRANSACTION COMMENTS *        
      *                      WHEN CORRECTION MADE FOR ZERO AMOUNT AND  *00002000
      *                      FROM ACCOUNT AND TO ACCOUNT ARE SAME.     *        
P0586F*  09/15/16  AP40911   CHANGE MADE TO FIX OUT OF BALANCE IN      *        
      *                      JOURNALING,SHORTAGE WAS NOT CREATED WHEN  *        
      *                      THERE IS A DIFFERENCE IN PAYMENT AMOUNT.  *        
      ******************************************************************00003400
      ******************************************************************00003500
      *                                                                *00003600
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00003700
      *                                                                *00003800
      ******************************************************************00003500
      *                                                                *00004800
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00003900
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00004000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00004100
      *  3000 - 4999  NOT USED                                         *00004200
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00004300
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00004400
      *  7000 - 7999  INPUT MODULES                                    *00004500
      *  8000 - 8999  OUTPUT MODULES                                   *00004600
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00004700
      *                                                                *00004800
      ******************************************************************00004900
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04880'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04880 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
      *-- AC CSS_AR_CNTL                                                        
           EXEC SQL                                                     02690016
              INCLUDE TBARCNTL                                          02700016
           END-EXEC.                                                    02710016
                                                                        
      *-- AL CSS_AR_LOCKOUT                                                     
           EXEC SQL                                                             
              INCLUDE TBARLOCK                                                  
           END-EXEC.                                                            
                                                                        
      *-- AR CSS_AR_TRANS_HIST                                                  
           EXEC SQL                                                     02490012
              INCLUDE TBARHIST                                          02500016
           END-EXEC.                                                    02510012
                                                                        
      *-- AT CSS_ACCOUNT                                                        
           EXEC SQL                                                     02530016
              INCLUDE TBACCT                                            02540016
           END-EXEC.                                                    02550016
                                                                        
      *-- AU CSS_AR_TRN_HST_DET                                                 
           EXEC SQL                                                     00010000
              INCLUDE TBARHDT                                           00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- BC CSS_BCH_JRNL_CNTL                                                  
           EXEC SQL                                                     00010000
              INCLUDE TBBJCNTL                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- BH CSS_BUDGET_HIST                                                    
           EXEC SQL                                                     02490012
              INCLUDE TBBGTHST                                          02500016
           END-EXEC.                                                    02510012
                                                                        
      *-- BJ CSS_BATCH_JRNL                                                     
           EXEC SQL                                                     00010000
              INCLUDE TBBTJRNL                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- BU CSS_BUDGET_PLAN                                                    
           EXEC SQL                                                     02490012
              INCLUDE TBBGTPLN                                          02500016
           END-EXEC.                                                    02510012
                                                                        
      *-- B1 CSS_LOCAL_OFFICE                                                   
           EXEC SQL                                                             
              INCLUDE TBLOCOFC                                                  
           END-EXEC.                                                            
                                                                        
      *-- CC CSS_CONNECT_CHRG                                                   
           EXEC SQL                                                             
              INCLUDE TBCCCHRG                                                  
           END-EXEC.                                                            
                                                                        
      *-- CJ CSS_CSH_DRWR_JRNL                                                  
           EXEC SQL                                                     00010000
              INCLUDE TBCDJRNL                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- CL CSS_CRED_COLL                                                      
           EXEC SQL                                                     02730016
              INCLUDE TBCRCOLL                                          02740016
           END-EXEC.                                                    02750016
                                                                        
      *-- CO CSS_CHRG_OFF                                                       
           EXEC SQL                                                             
              INCLUDE TBCHGOFF                                                  
           END-EXEC.                                                            
                                                                        
      *-- CS CSS_CSH_DRWR_CNTL                                                  
           EXEC SQL                                                     00010000
              INCLUDE TBCDCNTL                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- CT CSS_CONTRACT                                                       
           EXEC SQL                                                             
              INCLUDE TBCNTRCT                                                  
           END-EXEC.                                                            
                                                                        
      *-- CU CSS_CUSTOMER                                              *        
           EXEC SQL                                                     02570016
              INCLUDE TBCUST                                            02580016
           END-EXEC.                                                    02590016
                                                                        
      *-- CZ CSS_CREDIT_PROFILE                                                 
           EXEC SQL                                                             
              INCLUDE TBCRPROF                                                  
           END-EXEC.                                                            
                                                                        
      *-- C8 CSS_DELINQUENCY                                                    
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      *-- C9 CSS_AR_PMT_PRTY                                                    
           EXEC SQL                                                     00010000
              INCLUDE TBARPMT                                           00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- DA CSS_DFA_ACCT                                                       
           EXEC SQL                                                     00010000
              INCLUDE TBDFAACT                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- DL CSS_RECONNECT                                                      
           EXEC SQL                                                             
              INCLUDE TBRECNCT                                                  
           END-EXEC.                                                            
                                                                        
      *-- DO CSS_DEP_ON_HAND                                                    
           EXEC SQL                                                     00010000
              INCLUDE TBDEPHND                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- DP CSS_DEP_PAY_HST                                                    
           EXEC SQL                                                     00010000
              INCLUDE TBDEPHST                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- DR CSS_DEP_REQ                                                        
           EXEC SQL                                                     00010000
              INCLUDE TBDEPREQ                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- DV CSS_DFA_RECVBLE                                                    
           EXEC SQL                                                     00010000
              INCLUDE TBDFARCV                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- EA CSS_CNT_DETAIL                                                     
           EXEC SQL                                                     02490012
              INCLUDE TBCNTDET                                          02500016
           END-EXEC.                                                    02510012
                                                                        
      *-- FW CSS_FINAL_WO                                               07009300
           EXEC SQL                                                     07009600
               INCLUDE TBFINLWO                                         07009700
           END-EXEC.                                                    07009800
                                                                        
      *-- GO CSS_GL_ACCT_NO                                                     
           EXEC SQL                                                     00010000
              INCLUDE TBGLATNO                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- G6 CSS_JOB_PARM                                                       
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
                                                                        
      *-- J8 CSS_HOLIDAY                                                        
           EXEC SQL                                                             
               INCLUDE TBHLDAY                                                  
           END-EXEC.                                                            
                                                                        
      *-- LI CSS_LIEAP                                                          
           EXEC SQL                                                             
              INCLUDE TBLIEAP                                                   
           END-EXEC.                                                            
                                                                        
      *-- MH CSS_MNT_TRANS_HIST                                                 
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      *-- MI CSS_MT_TRN_HST_DET                                                 
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      *-- MJ CSS_MISC_JRNL                                                      
           EXEC SQL                                                     00010000
              INCLUDE TBMSJRNL                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- NH CSS_NSF_HIST                                                       
           EXEC SQL                                                             
              INCLUDE TBNSFHST                                                  
           END-EXEC.                                                            
                                                                        
      *-- OD CSS_OVERSHORT_DET                                                  
           EXEC SQL                                                             
              INCLUDE TBOVSHDT                                                  
           END-EXEC.                                                            
                                                                        
      *-- OH CSS_OVERSHORT_HDR                                                  
           EXEC SQL                                                             
              INCLUDE TBOVSHHD                                                  
           END-EXEC.                                                            
                                                                        
      *-- OT CSS_OVERSHORT_TYPE                                                 
           EXEC SQL                                                             
              INCLUDE TBOVSHTY                                                  
           END-EXEC.                                                            
                                                                        
      *-- PF CSS_USER_PROFILE                                                   
           EXEC SQL                                                     00010000
              INCLUDE TBUSRPRF                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- PJ CSS_PROJ_SHARE                                                     
           EXEC SQL                                                     00010000
              INCLUDE TBPRJSHR                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      *-- PR CSS_PREMISE                                                        
           EXEC SQL                                                     02610016
              INCLUDE TBPREM                                            02620016
           END-EXEC.                                                    02630016
                                                                        
      *-- RD CSS_RATE_PLAN_DESC                                                 
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                    02510012
                                                                        
      *-- UT CSS_UTIL_ENVRNMT                                                   
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
                                                                        
      *-- U7 CSS_RECONNECT_CHRG                                                 
           EXEC SQL                                                             
              INCLUDE TBRCNCHR                                                  
           END-EXEC.                                                            
                                                                        
      *-- WG CSS_WO_ARRANGEMENT                                                 
           EXEC SQL                                                     07009600
               INCLUDE TBWOARGM                                         07009700
           END-EXEC.                                                    07009800
                                                                        
                                                                        
      *-- XK CSS_SO_DNP_CANCEL                                                  
           EXEC SQL                                                             
              INCLUDE TBSODNPC                                                  
           END-EXEC.                                                            
                                                                        
      *-- YR CSS_CSH_REPORT_HDR                                        *        
           EXEC SQL                                                     02570016
              INCLUDE TBCSRPHD                                          02580016
           END-EXEC.                                                    02590016
                                                                        
      *-- Y2 CSS_CASHIER_OFFICE                                                 
           EXEC SQL                                                     01532000
              INCLUDE TBCSHOFF                                          01533000
           END-EXEC.                                                    01534000
                                                                        
      *-- SQL COMMUNICATION AREA                                                
           EXEC SQL                                                     02450012
              INCLUDE SQLCA                                             02460012
           END-EXEC.                                                    02470012
                                                                        
      *-- COPYBOOK TO DECLARE DISPLAY DATE VARIABLES                            
           COPY CWS00004.                                                       
                                                                        
      *-- HOLIDAY CHECK                                                         
           EXEC SQL                                                             
               INCLUDE CWS10016                                                 
           END-EXEC.                                                            
                                                                        
      *-- COPYBOOK TO DECLARE CODES_DATA_PRESENT                                
            COPY CWS00056.                                                      
                                                                        
      *-- SUPPORTS DB2 AND SQL ERROR CHECKING                                   
            COPY CWS00303.                                                      
                                                                        
      *-- COPYBOOK TO DECLARE 101 JOURNAL VARIABLES                             
            COPY CJF00101.                                                      
                                                                        
      *-- COPYBOOK TO DECLARE 105 JOURNAL VARIABLES                             
            COPY CJF00105.                                                      
                                                                        
      *-- COPYBOOK TO DECLARE 102 JOURNAL VARIABLES                             
            COPY CJF00102.                                                      
                                                                        
      *-- COPYBOOK TO DECLARE SCSCA225 VARIABLES                                
            COPY CWSCA225.                                                      
                                                                        
      *-- COPYBOOK TO DECLARE SCSCA224 VARIABLES                                
            COPY CWSCA224.                                                      
                                                                        
      *-- COPYBOOK TO DECLARE WQ VARIABLES                                      
ACT113     COPY CWS00077.                                                       
                                                                        
      *-- DECLARE REBATE AMOUNT VARIABLES                                       
           EXEC SQL                                                     00052700
              INCLUDE CWS00008                                          00052800
           END-EXEC.                                                    00052900
                                                                        
           EXEC SQL                                                     00007000
               INCLUDE CWSX0010                                         00007100
           END-EXEC.                                                    00007200
                                                                        
      *01  LOC1                  USAGE IS SQL TYPE IS                   
      *                          RESULT-SET-LOCATOR VARYING.            
       01  WS-MISC.                                                     
           05  WS-LAST-UPDATE-TS          PIC  X(26) VALUE SPACES.      
ACT113     05  WS-WQ-CALL-PGM           PIC X(08)  VALUE 'MCSCB077'.    
ACT113     05  MCSCB077                 PIC X(08)  VALUE 'MCSCB077'.    
ACT113     05  SCSCB077                 PIC X(08)  VALUE 'SCSCB077'.    
ACT113     05  WS-CPD0010S-CALL-TYPE    PIC X(01)  VALUE 'O'.           
ACT113         88 WS-CPD0010S-ONLINE-CALL          VALUE 'O'.           
ACT113         88 WS-CPD0010S-BATCH-CALL           VALUE 'B'.           
           05  WS-PREV-TRANS-HIST-SEQ-NO  PIC X(26)  VALUE SPACES.      
           05  WS-DISP-GL-ACCT            PIC 9(3).9(4).                
           05  MULTIPLE-ROWS-SELECTED     PIC S9(09) VALUE -811 COMP.   
           05  WS-OVERSHORT-TYPE          PIC X(01)  VALUE SPACES.      
           05  WS-RECORD-ONLY             PIC X(01)  VALUE SPACES.      
           05  WS-USER-ID                 PIC X(07)  VALUE SPACES.      
           05  WS-TEMP-GEN-LEDG-DB        PIC S9(3)V9(4) COMP-3         
                                                     VALUE +0.          
           05  WS-TEMP-GEN-LEDG-CR        PIC S9(3)V9(4) COMP-3         
                                                     VALUE +0.          
           05  WS-UTIL-ACCOUNT            PIC X.                        
               88  UTIL-EXISTS                       VALUE 'Y'.         
               88  NO-UTIL-EXISTS                    VALUE 'N'.         
           05  WS-TOTAL-ORIG-AMT          PIC S9(09)V99 COMP-3          
                                                     VALUE +0.          
           05  WS-OV-SH-TRAN-ID           PIC X(04)  VALUE SPACES.      
               88  OVERAGE-TRAN-ID                   VALUE 'O412'.      
               88  SHORTAGE-TRAN-ID                  VALUE 'S412'.      
           05  WS-JRNL-FLAG               PIC X(01)  VALUE 'Y'.         
               88 WS-JRNL-TRUE                       VALUE 'Y'.         
           05  SEND-DONE-SW               PIC X(01)  VALUE 'Y'.         
               88 SEND-DONE-ERROR                    VALUE 'N'.         
               88 SEND-DONE-OK                       VALUE 'Y'.         
           05  WS-SAME-ACCOUNT-NO-FLAG    PIC X(01) VALUE 'N'.          
P0586F*    05  WS-AMT-DIFF-NUM            PIC S9(09)V99.                        
COB305     05 WS-HOLD-PARM-DIFF        PIC S9(09)V99 COMP-3 VALUE 0.         
           05  WS-ACCOUNT-NO              PIC X(13).                    
           05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                
                                          PIC 9(13).                    
           05  WS-ACCOUNT-NO-COMP3        PIC S9(13) COMP-3 VALUE 0.    
COB305     05 WS-HOLD-TO-ACCT-NO        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.     
           05  WS-USER-CMMNT-LEN          PIC 9(04) VALUE 0.            
           05  WS-USER-CMMNT-LEN-NUM      PIC S9(04) COMP VALUE 0.      
           05  WS-USER-CMMNT-TEXT         PIC X(210) VALUE SPACES.      
           05  WS-FROM-ACCT-CMMNT-TEXT    PIC X(210) VALUE SPACES.      
           05  WS-FROM-ACCT-CMMNT-LEN     PIC 9(04) VALUE 0.            
           05  WS-FROM-ACCT-CMMNT-LEN-NUM PIC S9(04) COMP               
                                                    VALUE 0.            
           05  WS-CURRENT-DATE            PIC X(10) VALUE SPACES.       
           05  WS-CURRENT-TIMESTAMP       PIC X(26) VALUE SPACES.       
           05  WS-TRANS-HIST-SEQ-NO       PIC X(26) VALUE SPACES.       
           05  WS-DATE                    PIC X(10) VALUE SPACES.       
           05  WS-TIME                    PIC X(08) VALUE SPACES.       
           05  WS-ADJ-TRANS-HIST-SEQ-NO   PIC X(26) VALUE SPACES.       
           05  WS-SQLSTATE                PIC X(05).                    
           05  WS-VALID-RATE-FL           PIC X.                        
               88  VALID-RATE                       VALUE 'Y'.          
               88  NOT-VALID-RATE                   VALUE 'N'.          
           05  WS-CSR02341-INPUT-FIELDS.                                
               10  WS-CSR02341-BYPASS-WARNING    PIC X(01) VALUE SPACE. 
               10  WS-CSR02341-UPDATE-TYPE       PIC X(01) VALUE SPACE. 
               10  WS-CSR02341-ACCT-NO           PIC X(13) VALUE SPACE. 
               10  WS-CSR02341-FACILITY-CODE     PIC X(01) VALUE SPACE. 
               10  WS-CSR02341-PAYMENT-TYPE      PIC X(01) VALUE SPACE. 
               10  WS-CSR02341-AMT-CHECK         PIC X(11) VALUE SPACE. 
               10  WS-CSR02341-AMT-MONEY-ORDER   PIC X(11) VALUE SPACE. 
               10  WS-CSR02341-AMT-LIHEAP        PIC X(11) VALUE SPACE. 
               10  WS-CSR02341-CHRG-CARD-TYPE    PIC X(01) VALUE SPACE. 
               10  WS-CSR02341-AMT-CHRG-CARD     PIC X(11) VALUE SPACE. 
               10  WS-CSR02341-AMT-CASH          PIC X(11) VALUE SPACE. 
               10  WS-CSR02341-NO-ROWS           PIC S9(04) COMP        
                                                           VALUE 0.     
               10  WS-CSR02341-DIR-PAY-1         PIC X(27) VALUE SPACE. 
               10  WS-CSR02341-DIR-PAY-2         PIC X(27) VALUE SPACE. 
               10  WS-CSR02341-DIR-PAY-3         PIC X(27) VALUE SPACE. 
               10  WS-CSR02341-DIR-PAY-4         PIC X(27) VALUE SPACE. 
               10  WS-CSR02341-DIR-PAY-5         PIC X(27) VALUE SPACE. 
               10  WS-CSR02341-DIR-PAY-6         PIC X(27) VALUE SPACE. 
               10  WS-CSR02341-DIR-PAY-7         PIC X(27) VALUE SPACE. 
               10  WS-CSR02341-DIR-PAY-8         PIC X(27) VALUE SPACE. 
               10  WS-CSR02341-DIR-PAY-9         PIC X(27) VALUE SPACE. 
               10  WS-CSR02341-DIR-PAY-10        PIC X(27) VALUE SPACE. 
               10  WS-CSR02341-DIR-PAY-11        PIC X(27) VALUE SPACE. 
               10  WS-CSR02341-DIR-PAY-12        PIC X(27) VALUE SPACE. 
               10  WS-CSR02341-DIR-PAY-13        PIC X(27) VALUE SPACE. 
               10  WS-CSR02341-DIR-PAY-14        PIC X(27) VALUE SPACE. 
               10  WS-CSR02341-DIR-PAY-15        PIC X(27) VALUE SPACE. 
               10  WS-CSR02341-DIR-PAY-16        PIC X(27) VALUE SPACE. 
               10  WS-CSR02341-DIR-PAY-17        PIC X(27) VALUE SPACE. 
               10  WS-CSR02341-DIR-PAY-18        PIC X(27) VALUE SPACE. 
               10  WS-CSR02341-DIR-PAY-19        PIC X(27) VALUE SPACE. 
               10  WS-CSR02341-DIR-PAY-20        PIC X(27) VALUE SPACE. 
               10  WS-CSR02341-USER-ID           PIC X(07) VALUE SPACE. 
               10  WS-CSR02341-PANEL-NO          PIC X(09) VALUE SPACE. 
               10  WS-CSR02341-DATE-CASH-REPORT  PIC X(10) VALUE SPACE. 
               10  WS-CSR02341-CASH-COMPANY-NO   PIC X(02) VALUE SPACE. 
               10  WS-CSR02341-CASH-LOCAL-OFFICE PIC X(03) VALUE SPACE. 
               10  WS-CSR02341-CASH-DRAWER-ID    PIC S9(04) COMP        
                                                           VALUE 0.     
               10  WS-CSR02341-CASH-REPORT-NO    PIC X(03) VALUE SPACE. 
               10  WS-CSR02341-CONTRACT-TYPE     PIC X(01) VALUE SPACE. 
               10  WS-CSR02341-CONTRACT-NAME     PIC X(04) VALUE SPACE. 
               10  WS-CSR02341-CNT-CMMNT-LEN     PIC S9(4) COMP SYNC    
                                                           VALUE 0.     
               10  WS-CSR02341-CNT-CMMNT-TXT     PIC X(210) VALUE SPACE.
               10  WS-CSR02341-PYMT-RCPT-PRNTD-CD                       
                                                 PIC X(01) VALUE SPACE. 
               10  WS-CSR02341-LAST-UPDATE-TS    PIC X(26) VALUE SPACE. 
           05  WS-CSR02341-OUTPUT-FIELDS.                               
               10  WS-CSR02341-RETURN-CODE       PIC S9(09) COMP        
                                                           VALUE 0.     
               10  WS-CSR02341-ACCOUNT-NO        PIC X(13) VALUE SPACE. 
               10  WS-CSR02341-AMT-THIS-MONTH    PIC S9(11)V99 COMP-3   
                                                           VALUE +0.    
               10  WS-CSR02341-ADV-COLL-TSTAMP   PIC X(26) VALUE SPACES.
               10  WS-CSR02341-ERR-MSG1          PIC X(05) VALUE SPACES.
               10  WS-CSR02341-ERR-MSG2          PIC X(05) VALUE SPACES.
                                                                        
       01  WS-LITERAL.                                                  
           05  WS-A                       PIC X(01)  VALUE 'A'.         
           05  WS-C                       PIC X(01)  VALUE 'C'.         
           05  WS-Y                       PIC X(01)  VALUE 'Y'.         
           05  WS-NO                      PIC X(01)  VALUE 'N'.         
           05  WS-01                      PIC X(02)  VALUE '01'.        
           05  WS-998                     PIC X(03)  VALUE '998'.       
           05  PROGRAM-NAME               PIC X(08)  VALUE 'CSR04880'.  
           05  WS-NO-ERROR                PIC X(05)  VALUE 'NOERR'.     
           05  MCSCA182                   PIC X(8)   VALUE 'MCSCA182'.  
           05  MCSCO061                   PIC X(08)  VALUE 'MCSCO061'.  
           05  WS-NEG-DIFF-FLAG           PIC X(01)  VALUE 'N'.         
           05  MCSCB224                   PIC X(8)   VALUE 'MCSCB224'.  
           05  MCSCB225                   PIC X(8)   VALUE 'MCSCB225'.  
           05  WS-COG-TRAN-TYPE-CD-73     PIC X(1)   VALUE 'P'.         
           05  WS-FOUND-MULT-BILLS        PIC S9(04) COMP VALUE -811.   
           05  EIBTRNID                   PIC X(04)  VALUE 'S351'.      
           05  WS-LOCAL-OFFICE            PIC X(3)   VALUE SPACES.      
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                 PIC S9(9) COMP VALUE 1.       
           05  CTR-ROWS                   PIC S9(9) COMP VALUE 0.       
                                                                        
       01  WS-OVER-SHORT-WQ.                                            
           10 FILLER                      PIC X(60) VALUE               
            'ORIGINAL PAYMENT AMOUNT DIFFERENT FROM RE APPLY AMOUNT.'.  
           10 FILLER                      PIC X(12) VALUE               
                                                    'DIFF AMOUNT:'.     
           10 WS-LEFT-PAREN               PIC X(01).                    
           10 WS-AMT-DIFF-WQ              PIC Z(9).99.                  
           10 WS-RIGHT-PAREN              PIC X(01).                    
           10 FILLER                      PIC X(12) VALUE 'COMPANY NO:'.
           10 WS-AR-CASH-COMPANY-NO       PIC X(2).                     
           10 FILLER                      PIC X(14) VALUE               
                                                    ' CASH LOC OFF:'.   
           10 WS-AR-CASH-LOCAL-OFFICE     PIC X(3).                     
           10 FILLER                      PIC X(13) VALUE               
                                                    ' REPORT DATE:'.    
           10 WS-AR-DATE-CASH-REPORT      PIC X(10).                    
           10 FILLER                      PIC X(11) VALUE               
                                                    ' DRAWER ID:'.      
           10 WS-AR-CASH-DRAWER-ID        PIC 9(04).                    
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE             PIC S9(09) COMP VALUE +0.     
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE              PIC S9(09) COMP VALUE +0.     
           05  S-FROM-ACCOUNT-NO          PIC X(13) VALUE SPACE.        
           05  S-TO-ACCOUNT-NO            PIC X(13) VALUE SPACE.        
           05  S-ERROR-MSG1               PIC X(05) VALUE SPACES.       
           05  S-ERROR-MSG2               PIC X(05) VALUE SPACES.       
                                                                        
       01  WS-NULL-DATE.                                                
           05  WS-NULL-IND1               PIC S9(04) COMP VALUE +0.     
           05  WS-NULL-IND2               PIC S9(04) COMP VALUE +0.     
           05  WS-NULL-IND3               PIC S9(04) COMP VALUE +0.     
           05  WS-NULL-BAL-TS             PIC S9(04) COMP VALUE +0.     
           05  WS-DATE-ORIG-PYMT-IND      PIC S9(04) COMP VALUE +0.     
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                  PIC X(18) VALUE SPACES.       
           10  S-SQLCODE                  PIC S9(9) COMP VALUE 0.       
           10  S-SQLSTATE                 PIC X(05) VALUE ' '.          
           10  S-TABLE-NAME               PIC X(18) VALUE SPACES.       
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L     PIC S9(4) USAGE COMP.         
               49  S-HOST-VARIABLES-V     PIC X(255).                   
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L      PIC S9(4) USAGE COMP.         
               49  S-SQL-STATEMENT-V      PIC X(255).                   
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L    PIC S9(4) USAGE COMP.         
               49  S-SQL-DESCRIPTION-V    PIC X(255).                   
      *                                                                         
      *-- COPYBOOK TO DECLARE SCSCA182 VARIABLES                                
       COPY CWS00182.                                                           
      *                                                                         
      *-- COPYBOOK TO DECLARE JOURNAL VARIABLES AND CWS-13 VARIABLES            
           EXEC SQL                                                             
              INCLUDE CWS0013B                                                  
           END-EXEC.                                                            
                                                                        
      *-- COPYBOOK TO DECLARE WS VARIABLES FOR PAYMENT ROUTINE                  
           EXEC SQL                                                     PCS00710
              INCLUDE CWS00017                                          PCS00710
           END-EXEC.                                                    PCS00710
                                                                        
      *-- COPYBOOK TO DECLARE WS VARIABLES FOR GENERAL LEDGERS                  
           EXEC SQL                                                             
              INCLUDE CWS00061                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
      *-- COPYBOOK TO DECLARE CHARGE OFF RECEIVABLES                            
           EXEC SQL                                                     02930012
              INCLUDE CWS00073                                          02940012
           END-EXEC.                                                    02950012
                                                                        
      *-- COPYBOOK TO DECLARE WS VARIABLES FOR REFUND CPD CPD00116              
           EXEC SQL                                                     02930012
              INCLUDE CWS0116A                                          02940012
           END-EXEC.                                                    02950012
MSQ001        EXEC SQL
MSQ001          DECLARE PAYMENT_POSTING CURSOR
MSQ001          FOR CALL CSR02341                                           
                ( :WS-CSR02341-BYPASS-WARNING
                  , :WS-CSR02341-UPDATE-TYPE
                  , :WS-CSR02341-ACCT-NO
                  , :WS-CSR02341-FACILITY-CODE
                  , :WS-CSR02341-PAYMENT-TYPE
                  , :WS-CSR02341-AMT-CHECK
                  , :WS-CSR02341-AMT-MONEY-ORDER
                  , :WS-CSR02341-AMT-LIHEAP
                  , :WS-CSR02341-CHRG-CARD-TYPE
                  , :WS-CSR02341-AMT-CHRG-CARD
                  , :WS-CSR02341-AMT-CASH
                  , :WS-CSR02341-NO-ROWS
                  , :WS-CSR02341-DIR-PAY-1
                  , :WS-CSR02341-DIR-PAY-2
                  , :WS-CSR02341-DIR-PAY-3
                  , :WS-CSR02341-DIR-PAY-4
                  , :WS-CSR02341-DIR-PAY-5
                  , :WS-CSR02341-DIR-PAY-6
                  , :WS-CSR02341-DIR-PAY-7
                  , :WS-CSR02341-DIR-PAY-8
                  , :WS-CSR02341-DIR-PAY-9
                  , :WS-CSR02341-DIR-PAY-10
                  , :WS-CSR02341-DIR-PAY-11
                  , :WS-CSR02341-DIR-PAY-12
                  , :WS-CSR02341-DIR-PAY-13
                  , :WS-CSR02341-DIR-PAY-14
                  , :WS-CSR02341-DIR-PAY-15
                  , :WS-CSR02341-DIR-PAY-16
                  , :WS-CSR02341-DIR-PAY-17
                  , :WS-CSR02341-DIR-PAY-18
                  , :WS-CSR02341-DIR-PAY-19
                  , :WS-CSR02341-DIR-PAY-20
                  , :WS-CSR02341-USER-ID
                  , :WS-CSR02341-PANEL-NO
                  , :WS-CSR02341-DATE-CASH-REPORT
                  , :WS-CSR02341-CASH-COMPANY-NO
                  , :WS-CSR02341-CASH-LOCAL-OFFICE
                  , :WS-CSR02341-CASH-DRAWER-ID
                  , :WS-CSR02341-CASH-REPORT-NO
                  , :WS-CSR02341-CONTRACT-TYPE
                  , :WS-CSR02341-CONTRACT-NAME
                  , :WS-CSR02341-CNT-CMMNT-LEN
                  , :WS-CSR02341-CNT-CMMNT-TXT
                  , :WS-CSR02341-PYMT-RCPT-PRNTD-CD
                  , :WS-CSR02341-LAST-UPDATE-TS
                  )
MSQ001        END-EXEC.
    
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-USER-ID                   PIC X(07).                    
       01  PARM-FROM-ACCOUNT-NO           PIC X(13).                    
       01  PARM-UPDATE-TYPE               PIC X(01).                    
COB305 01 PARM-CORRECTION-AMT-DIFF        PIC S9(09)V99 COMP-3 VALUE 0.        
       01  PARM-TRANS-HIST-SEQ-NO         PIC X(26).                    
       01  PARM-FROM-ACCT-CMMNT-LEN       PIC X(04).                    
       01  PARM-FROM-ACCT-CMMNT-TEXT      PIC X(210).                   
       01  PARM-TO-ACCOUNT-NO             PIC X(13).                    
       01  PARM-CURRENCY-TYPE             PIC X(01).                    
       01  PARM-CHECK-AMOUNT              PIC X(11).                    
       01  PARM-MONEY-ORDER-AMOUNT        PIC X(11).                    
       01  PARM-CHRG-CARD-AMOUNT          PIC X(11).                    
       01  PARM-CASH-AMOUNT               PIC X(11).                    
       01  PARM-NO-OF-DIRECTED-ROWS       PIC S9(04) COMP.              
       01  PARM-PAY-CORR-DIR-ROW-1        PIC X(27).                    
       01  PARM-PAY-CORR-DIR-ROW-2        PIC X(27).                    
       01  PARM-PAY-CORR-DIR-ROW-3        PIC X(27).                    
       01  PARM-PAY-CORR-DIR-ROW-4        PIC X(27).                    
       01  PARM-PAY-CORR-DIR-ROW-5        PIC X(27).                    
       01  PARM-PAY-CORR-DIR-ROW-6        PIC X(27).                    
       01  PARM-PAY-CORR-DIR-ROW-7        PIC X(27).                    
       01  PARM-PAY-CORR-DIR-ROW-8        PIC X(27).                    
       01  PARM-PAY-CORR-DIR-ROW-9        PIC X(27).                    
       01  PARM-PAY-CORR-DIR-ROW-10       PIC X(27).                    
       01  PARM-PAY-CORR-DIR-ROW-11       PIC X(27).                    
       01  PARM-PAY-CORR-DIR-ROW-12       PIC X(27).                    
       01  PARM-PAY-CORR-DIR-ROW-13       PIC X(27).                    
       01  PARM-PAY-CORR-DIR-ROW-14       PIC X(27).                    
       01  PARM-PAY-CORR-DIR-ROW-15       PIC X(27).                    
       01  PARM-PAY-CORR-DIR-ROW-16       PIC X(27).                    
       01  PARM-PAY-CORR-DIR-ROW-17       PIC X(27).                    
       01  PARM-PAY-CORR-DIR-ROW-18       PIC X(27).                    
       01  PARM-PAY-CORR-DIR-ROW-19       PIC X(27).                    
       01  PARM-PAY-CORR-DIR-ROW-20       PIC X(27).                    
       01  PARM-USER-CMMNT-LEN            PIC X(04).                    
       01  PARM-USER-CMMNT-TEXT           PIC X(210).                   
       01  PARM-TO-ACCT-LAST-UPDATE-TS    PIC X(26).                    
                                                                        
       PROCEDURE DIVISION USING     PARM-USER-ID                        
                                    PARM-FROM-ACCOUNT-NO                
                                    PARM-UPDATE-TYPE                    
                                    PARM-CORRECTION-AMT-DIFF            
                                    PARM-TRANS-HIST-SEQ-NO              
                                    PARM-FROM-ACCT-CMMNT-LEN            
                                    PARM-FROM-ACCT-CMMNT-TEXT           
                                    PARM-TO-ACCOUNT-NO                  
                                    PARM-CURRENCY-TYPE                  
                                    PARM-CHECK-AMOUNT                   
                                    PARM-MONEY-ORDER-AMOUNT             
                                    PARM-CHRG-CARD-AMOUNT               
                                    PARM-CASH-AMOUNT                    
                                    PARM-NO-OF-DIRECTED-ROWS            
                                    PARM-PAY-CORR-DIR-ROW-1             
                                    PARM-PAY-CORR-DIR-ROW-2             
                                    PARM-PAY-CORR-DIR-ROW-3             
                                    PARM-PAY-CORR-DIR-ROW-4             
                                    PARM-PAY-CORR-DIR-ROW-5             
                                    PARM-PAY-CORR-DIR-ROW-6             
                                    PARM-PAY-CORR-DIR-ROW-7             
                                    PARM-PAY-CORR-DIR-ROW-8             
                                    PARM-PAY-CORR-DIR-ROW-9             
                                    PARM-PAY-CORR-DIR-ROW-10            
                                    PARM-PAY-CORR-DIR-ROW-11            
                                    PARM-PAY-CORR-DIR-ROW-12            
                                    PARM-PAY-CORR-DIR-ROW-13            
                                    PARM-PAY-CORR-DIR-ROW-14            
                                    PARM-PAY-CORR-DIR-ROW-15            
                                    PARM-PAY-CORR-DIR-ROW-16            
                                    PARM-PAY-CORR-DIR-ROW-17            
                                    PARM-PAY-CORR-DIR-ROW-18            
                                    PARM-PAY-CORR-DIR-ROW-19            
                                    PARM-PAY-CORR-DIR-ROW-20            
                                    PARM-USER-CMMNT-LEN                 
                                    PARM-USER-CMMNT-TEXT                
                                    PARM-TO-ACCT-LAST-UPDATE-TS.        

SCA006        SET WS-GL-SUB TO 1.
      *                                                                         
      ******************************************************************03030000
      *                                                                *03030000
      * 0000-MAINLINE                                                  *03040000
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *03050000
      *                                                                *03030000
      ******************************************************************03060000
      *                                                                         
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************00074400
      *                                                                *03030000
      * 0100-INITIALIZE                                                *03170000
      * INITIALIZE AND DECLARE OUTPUT CURSOR                           *00074500
      *                                                                *03030000
      ******************************************************************00074600
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE '0100' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           PERFORM 0100A-DECLARE-GTT    THRU 0100A-EXIT.                
      *                                                                 00075800
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT RETURN_CODE                                       
                     ,FROM_ACCOUNT_NO                                   
                     ,TO_ACCOUNT_NO                                     
                     ,ERROR_MSG1                                        
                     ,ERROR_MSG2                                        
                FROM #CSR04880_R1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00076100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        00076200
MFA-TR*        SELECT RETURN_CODE                                       00076300
MFA-TR*              ,FROM_ACCOUNT_NO                                   00076400
MFA-TR*              ,TO_ACCOUNT_NO                                     00076400
MFA-TR*              ,ERROR_MSG1                                        00076700
MFA-TR*              ,ERROR_MSG2                                        00076700
MFA-TR*         FROM SESSION.CSR04880_R1                                        
MFA-TR*    END-EXEC.                                                    00077000
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS.                                
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************02530000
      *                                                                *03030000
      * 0100A-DECLARE-GTT                                              *03170000
      * DECLARE TEMPORARY TABLE                                        *00074500
      *                                                                *03030000
      ******************************************************************02890000
      *                                                                         
       0100A-DECLARE-GTT.                                               
      *                                                                         
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04880_R1'            
                                       TO S-SQL-STATEMENT-V.            
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04880_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04880_R1
              (                                                       
                   RETURN_CODE              INT                     
                  ,FROM_ACCOUNT_NO CHAR(13)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,TO_ACCOUNT_NO CHAR(13)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,ERROR_MSG1 CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,ERROR_MSG2 CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2         
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE 'CSR04880_R1'         TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
         0100A-EXIT.                                                    
              EXIT.                                                     
      *                                                                         
      ******************************************************************03800002
      *                                                                *03870002
      * 2000-PROCESS-OUTPUT                                            *03810002
      * 1. DESCRIBE RESULT SET                                         *03830002
      * 2. UPDATE DB2 SATA                                             *03840002
      * 3. BUILD RESULT SET                                            *03850002
      * 4. SEND RESULT SET                                             *03860002
      *                                                                *03870002
      ******************************************************************03880002
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           PERFORM 7999-SELECT-AL       THRU 7999-SELECT-AL-EXIT.       
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
              MOVE +0                   TO S-RETURN-CODE                
              MOVE +5000                TO S-ERROR-MSG1                 
              PERFORM 8100-SEND-RESULT  THRU 8100-EXIT                  
              PERFORM 9999-END-PROGRAM  THRU 9999-EXIT                  
           END-IF.                                                      
      *                                                                         
           INITIALIZE SCSCA182-LINK-RECORD.                             
           MOVE PARM-FROM-ACCOUNT-NO        TO S-FROM-ACCOUNT-NO.       
           MOVE PARM-TO-ACCOUNT-NO          TO S-TO-ACCOUNT-NO          
                                               WS-ACCOUNT-NO.           
           MOVE WS-ACCOUNT-NO-NUM           TO WS-HOLD-TO-ACCT-NO.      
           MOVE WS-HOLD-TO-ACCT-NO          TO SCSCA182-ACCOUNT-NO.     
           PERFORM 9200-LINK-SCSCA182 THRU 9200-EXIT.                   
           IF SCSCA182-RETURN-CODE NOT EQUAL TO ZERO                    
              MOVE PROGRAM-NAME TO ABEND-PROGRAM                        
              MOVE SCSCA182-RETURN-CODE TO WS-ACTIVE-RETURN-CODE        
                                           S-RETURN-CODE                
                                           SQLCODE                      
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
              PERFORM 9999-END-PROGRAM THRU 9999-EXIT                   
           ELSE                                                         
              MOVE SCSCA182-LAST-UPDATE-TS TO WS-LAST-UPDATE-TS         
              IF PARM-TO-ACCT-LAST-UPDATE-TS = WS-LAST-UPDATE-TS        
              OR PARM-TO-ACCT-LAST-UPDATE-TS = 'STRESS'                 
                 CONTINUE                                               
              ELSE                                                      
                 MOVE '5272' TO S-ERROR-MSG1                            
                 PERFORM 8100-SEND-RESULT  THRU 8100-EXIT               
                 PERFORM 9999-END-PROGRAM  THRU 9999-EXIT               
              END-IF                                                    
           END-IF.                                                      
           IF PARM-FROM-ACCT-CMMNT-LEN > 0210                           
              MOVE 0210                     TO WS-FROM-ACCT-CMMNT-LEN   
           ELSE                                                         
              MOVE PARM-FROM-ACCT-CMMNT-LEN TO WS-FROM-ACCT-CMMNT-LEN   
           END-IF.                                                      
      *                                                                         
           IF PARM-FROM-ACCOUNT-NO = PARM-TO-ACCOUNT-NO                 
P00586        AND (PARM-CHECK-AMOUNT > ZERO                             
P00586        OR PARM-MONEY-ORDER-AMOUNT > ZERO                         
P00586        OR PARM-CHRG-CARD-AMOUNT > ZERO                           
P00586        OR PARM-CASH-AMOUNT > ZERO)                               
              MOVE 'Y' TO WS-SAME-ACCOUNT-NO-FLAG                       
           END-IF.                                                      
      *                                                                         
           MOVE PARM-FROM-ACCT-CMMNT-TEXT TO WS-FROM-ACCT-CMMNT-TEXT.   
           MOVE WS-FROM-ACCT-CMMNT-LEN    TO WS-FROM-ACCT-CMMNT-LEN-NUM.
           MOVE PARM-USER-CMMNT-TEXT      TO WS-USER-CMMNT-TEXT.        
           MOVE PARM-USER-CMMNT-LEN       TO WS-USER-CMMNT-LEN.         
           MOVE WS-USER-CMMNT-LEN         TO WS-USER-CMMNT-LEN-NUM.     
                                                                        
           MOVE WS-FROM-ACCT-CMMNT-TEXT   TO AR-TRAN-COMMENT-TEXT.      
           MOVE WS-FROM-ACCT-CMMNT-LEN    TO AR-TRAN-COMMENT-LEN.       
                                                                        
           MOVE WS-FROM-ACCT-CMMNT-TEXT  TO WS-PAR-AR-TRAN-COMMENT-TEXT 
                                            WS-JRNL-TRAN-COMMENT-TEXT.  
           MOVE WS-FROM-ACCT-CMMNT-LEN   TO                             
                                            WS-PAR-AR-TRAN-COMMENT-LEN  
                                            WS-JRNL-TRAN-COMMENT-LEN.   
           MOVE WS-NO-ERROR              TO WS-PAR-MESSAGE-NO.          
           MOVE WS-998                   TO Y2-CASH-LOCAL-OFFICE        
           MOVE WS-01                    TO Y2-CASH-COMPANY-NO          
      *                                                                         
P0586F     IF PARM-CORRECTION-AMT-DIFF < 0                              
P0586F        COMPUTE WS-HOLD-PARM-DIFF = PARM-CORRECTION-AMT-DIFF * -1 
P0586F        MOVE 'Y' TO WS-NEG-DIFF-FLAG                              
P0586F     ELSE                                                         
P0586F        MOVE PARM-CORRECTION-AMT-DIFF TO WS-HOLD-PARM-DIFF        
P0586F        MOVE 'N' TO WS-NEG-DIFF-FLAG                              
P0586F     END-IF.                                                      
                                                                        
           PERFORM 7320-SELECT-CASHIER   THRU 7320-EXIT.                
           MOVE Y2-LOCAL-OFFICE          TO WS-LOCAL-OFFICE.            
           PERFORM 2200-PROCESS          THRU 2200-EXIT.                
      *                                                                         
           IF WS-HOLD-PARM-DIFF > 0                                     
              PERFORM 5750-JOURNAL-FORMAT-101   THRU 5750-EXIT          
              PERFORM 7775-CHECK-MATCHING-ENTRY THRU 7775-EXIT          
           END-IF.                                                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = 0                                 
              PERFORM 2210-LOAD-CSR02341-PARMS THRU 2210-EXIT           
              PERFORM 7500-CALL-CSR02341 THRU 7500-EXIT                 
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS = 0                                              
              MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE               
              PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                 
              IF WS-ACTIVE-RETURN-CODE = -204                           
                 PERFORM 0100-INITIALIZE THRU 0100-EXIT                 
                 MOVE WS-CSR02341-RETURN-CODE TO S-RETURN-CODE          
                 MOVE WS-CSR02341-ACCOUNT-NO TO S-TO-ACCOUNT-NO         
                 MOVE WS-CSR02341-ERR-MSG1 TO S-ERROR-MSG1              
                 MOVE WS-CSR02341-ERR-MSG2 TO S-ERROR-MSG2              
                 PERFORM 8100-SEND-RESULT   THRU 8100-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************06650000
      *                                                                *06650000
      * 2200-PROCESS                                                   *06660000
      * RECEIVE INPUT PARMS AND PROCESS THE ACCOUNT                    *00106200
      *                                                                *06650000
      ******************************************************************00106400
      *                                                                 08130000
       2200-PROCESS.                                                    
      *                                                                         
           INITIALIZE                   WS-PAR-TRAN-APPL-NO.            
           INITIALIZE                   WS-PAR-TRAN-APPL-NO-WO1.        
           INITIALIZE                   WS-PAR-TRAN-APPL-NO-WO2.        
           MOVE 'Y'                     TO WS-PAR-VALIDATE-JRNL.        
      *                                                                 08130000
           PERFORM 2205-LOAD-GL-NUMBERS THRU 2205-EXIT.                 
           MOVE WS-CLR-CASH-GL-NO (WS-GL-SUB) TO WS-PAR-GEN-LEDG-DB.    
      *                                                                 08130000
           PERFORM 2300-CREATE-AR-FOR-REVERSAL THRU 2300-EXIT.          
           MOVE 'C'                     TO AR-CODE-TRAN-TYPE.           
           MOVE ZEROS                   TO WS-NULL-IND1                 
                                           WS-NULL-IND2.                
           MOVE AR-DATE-TRANS           TO AR-DATE-ORIG-PYMT            
                                           WS-PREV-DATE-TRANS.          
           MOVE WS-CURRENT-DATE         TO AR-DATE-TRANS.               
           IF WS-SAME-ACCOUNT-NO-FLAG = 'Y'                             
              MOVE 0 TO AR-TRAN-COMMENT-LEN                             
                        WS-JRNL-TRAN-COMMENT-LEN                        
              MOVE SPACES TO AR-TRAN-COMMENT-TEXT                       
                             WS-JRNL-TRAN-COMMENT-TEXT                  
           ELSE                                                         
              MOVE WS-FROM-ACCT-CMMNT-TEXT TO AR-TRAN-COMMENT-TEXT      
              MOVE WS-FROM-ACCT-CMMNT-LEN-NUM  TO AR-TRAN-COMMENT-LEN   
           END-IF.                                                      
      *                                                                 08130000
           MOVE WS-01                   TO AR-CASH-COMPANY-NO.          
           MOVE WS-CURRENT-DATE         TO AR-DATE-CASH-REPORT.         
           MOVE 9999                    TO AR-CASH-DRAWER-ID.           
           MOVE WS-RECORD-ONLY          TO AR-RECORD-ONLY-FL.           
           MOVE PF-RESP-AREA-ID         TO AR-RESP-AREA-ID.             
      *                                                                 08130000
           PERFORM 8040-INSERT-AR-TRANS-HIST THRU 8040-EXIT.            
           MOVE WS-FROM-ACCT-CMMNT-TEXT TO AR-TRAN-COMMENT-TEXT.        
           MOVE WS-FROM-ACCT-CMMNT-LEN-NUM  TO AR-TRAN-COMMENT-LEN.     
           MOVE SPACE                   TO AR-RECORD-ONLY-FL.           
           MOVE AR-AMT-ORIG-ENTERED     TO WS-AMOUNT-REFUNDED.          
           MOVE 'F'                     TO WS-PART-CASH-PROCESS-FLG.    
           MOVE 'RVR'                   TO WS-CHECK-CASH-IND.           
           MOVE PARM-USER-ID            TO WS-USER-ID.                  
           MOVE EIBTRNID                TO WS-CSH-DRWR-TRAN-ID.         
           MOVE AR-ACCOUNT-NO           TO AU-ACCOUNT-NO                
                                           AT-ACCOUNT-NO                
                                           S-FROM-ACCOUNT-NO            
                                           WS-ACCOUNT-NO-COMP3.         
      *                                                                 07380000
           PERFORM 6904-INSERT-AR-DETAILS THRU 6904-EXIT.               
      *                                                                 07380000
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07380000
      ******************************************************************        
      *                                                                *07380000
      * 2205-LOAD-GL-NUMBERS                                           *07380000
      * LOAD ALL G/L NUMBERS, INCLUDING CHARGE OFF.                    *        
      *                                                                *07380000
      ******************************************************************        
      *                                                                         
       2205-LOAD-GL-NUMBERS.                                            
      *                                                                         
           PERFORM 9350-LINK-SCSCO061     THRU 9350-EXIT.               
      *                                                                         
           PERFORM VARYING WS-VALID-CO-SUB FROM 1 BY 1                  
              UNTIL WS-VALID-CO-SUB > 5                                 
                 OR WS-VALID-CO-NO (WS-VALID-CO-SUB) = '01'             
                 OR WS-VALID-CO-NO (WS-VALID-CO-SUB) = WS-GL-99         
      *                                                                         
                    IF WS-VALID-CO-NO (WS-VALID-CO-SUB) = '01'          
                       MOVE WS-Y TO WS-COMPANY-IN-TABLE                 
                    END-IF                                              
           END-PERFORM.                                                 
      *                                                                         
       2205-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 2210-LOAD-CSR02341-PARMS                                       *        
      * LOADS INPUT PARMS FOR CSR02341                                 *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       2210-LOAD-CSR02341-PARMS.                                        
      *                                                                         
           INITIALIZE WS-CSR02341-INPUT-FIELDS.                         
      *                                                                         
           IF WS-JRNL-OPER-ACTIVE = 'C'                                 
              MOVE WS-C TO WS-CSR02341-BYPASS-WARNING                   
           ELSE                                                         
              MOVE SPACE TO WS-CSR02341-BYPASS-WARNING                  
           END-IF.                                                      
           MOVE PARM-UPDATE-TYPE TO WS-CSR02341-UPDATE-TYPE.            
           MOVE PARM-TO-ACCOUNT-NO TO WS-CSR02341-ACCT-NO.              
           MOVE AR-PYMT-FACILITY-CD TO WS-CSR02341-FACILITY-CODE.       
           MOVE PARM-CURRENCY-TYPE TO WS-CSR02341-PAYMENT-TYPE.         
           MOVE PARM-CHECK-AMOUNT TO WS-CSR02341-AMT-CHECK.             
           MOVE PARM-MONEY-ORDER-AMOUNT TO WS-CSR02341-AMT-MONEY-ORDER. 
           MOVE '00000000000' TO WS-CSR02341-AMT-LIHEAP.                
           MOVE SPACE TO WS-CSR02341-CHRG-CARD-TYPE.                    
           MOVE PARM-CHRG-CARD-AMOUNT TO WS-CSR02341-AMT-CHRG-CARD.     
           MOVE PARM-CASH-AMOUNT TO WS-CSR02341-AMT-CASH.               
           MOVE PARM-NO-OF-DIRECTED-ROWS TO WS-CSR02341-NO-ROWS.        
           MOVE PARM-PAY-CORR-DIR-ROW-1 TO WS-CSR02341-DIR-PAY-1.       
           MOVE PARM-PAY-CORR-DIR-ROW-2 TO WS-CSR02341-DIR-PAY-2.       
           MOVE PARM-PAY-CORR-DIR-ROW-3 TO WS-CSR02341-DIR-PAY-3.       
           MOVE PARM-PAY-CORR-DIR-ROW-4 TO WS-CSR02341-DIR-PAY-4.       
           MOVE PARM-PAY-CORR-DIR-ROW-5 TO WS-CSR02341-DIR-PAY-5.       
           MOVE PARM-PAY-CORR-DIR-ROW-6 TO WS-CSR02341-DIR-PAY-6.       
           MOVE PARM-PAY-CORR-DIR-ROW-7 TO WS-CSR02341-DIR-PAY-7.       
           MOVE PARM-PAY-CORR-DIR-ROW-8 TO WS-CSR02341-DIR-PAY-8.       
           MOVE PARM-PAY-CORR-DIR-ROW-9 TO WS-CSR02341-DIR-PAY-9.       
           MOVE PARM-PAY-CORR-DIR-ROW-10 TO WS-CSR02341-DIR-PAY-10.     
           MOVE PARM-PAY-CORR-DIR-ROW-11 TO WS-CSR02341-DIR-PAY-11.     
           MOVE PARM-PAY-CORR-DIR-ROW-12 TO WS-CSR02341-DIR-PAY-12.     
           MOVE PARM-PAY-CORR-DIR-ROW-13 TO WS-CSR02341-DIR-PAY-13.     
           MOVE PARM-PAY-CORR-DIR-ROW-14 TO WS-CSR02341-DIR-PAY-14.     
           MOVE PARM-PAY-CORR-DIR-ROW-15 TO WS-CSR02341-DIR-PAY-15.     
           MOVE PARM-PAY-CORR-DIR-ROW-16 TO WS-CSR02341-DIR-PAY-16.     
           MOVE PARM-PAY-CORR-DIR-ROW-17 TO WS-CSR02341-DIR-PAY-17.     
           MOVE PARM-PAY-CORR-DIR-ROW-18 TO WS-CSR02341-DIR-PAY-18.     
           MOVE PARM-PAY-CORR-DIR-ROW-19 TO WS-CSR02341-DIR-PAY-19.     
           MOVE PARM-PAY-CORR-DIR-ROW-20 TO WS-CSR02341-DIR-PAY-20.     
           MOVE PARM-USER-ID TO WS-CSR02341-USER-ID.                    
           MOVE AR-APPL-PROGRAM-ID TO WS-CSR02341-PANEL-NO.             
           MOVE WS-CURRENT-DATE TO WS-CSR02341-DATE-CASH-REPORT.        
           MOVE AR-CASH-COMPANY-NO TO WS-CSR02341-CASH-COMPANY-NO.      
           MOVE CS-CASH-LOCAL-OFFICE TO WS-CSR02341-CASH-LOCAL-OFFICE.  
           MOVE CS-CASH-DRAWER-ID TO WS-CSR02341-CASH-DRAWER-ID.        
           MOVE CS-CASH-REPORT-NO TO WS-CSR02341-CASH-REPORT-NO.        
           MOVE SPACE TO WS-CSR02341-CONTRACT-TYPE.                     
           MOVE SPACE TO WS-CSR02341-CONTRACT-NAME.                     
           IF WS-SAME-ACCOUNT-NO-FLAG = 'Y'                             
              MOVE PARM-FROM-ACCT-CMMNT-LEN  TO                         
                                             WS-CSR02341-CNT-CMMNT-LEN  
              MOVE PARM-FROM-ACCT-CMMNT-TEXT TO                         
                                             WS-CSR02341-CNT-CMMNT-TXT  
           ELSE                                                         
              MOVE PARM-USER-CMMNT-LEN       TO                         
                                             WS-CSR02341-CNT-CMMNT-LEN  
              MOVE PARM-USER-CMMNT-TEXT      TO                         
                                             WS-CSR02341-CNT-CMMNT-TXT  
           END-IF.                                                      
           MOVE WS-NO TO WS-CSR02341-PYMT-RCPT-PRNTD-CD.                
           MOVE PARM-TO-ACCT-LAST-UPDATE-TS TO                          
                                         WS-CSR02341-LAST-UPDATE-TS.    
      *                                                                         
       2210-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 2240-CREATE-REPORT-DRWR                                        *        
      * CHECKS FOR VALID CASH DRAWER AND CASH REPORT FOR GIVEN CASH    *        
      * LOCAL OFFICE AND CASH REPORT DATE. IF NOT AVAILABLE IT CREATES *        
      * A NEW BATCH AND REPORT.                                        *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       2240-CREATE-REPORT-DRWR.                                         
      *                                                                         
           MOVE WS-CURRENT-DATE              TO CS-DATE-CASH-REPORT     
                                                YR-DATE-CASH-REPORT.    
           MOVE AR-CASH-LOCAL-OFFICE         TO CS-CASH-LOCAL-OFFICE    
                                                CS-CASH-REPORT-NO       
                                                YR-CASH-LOCAL-OFFICE    
                                                Y2-CASH-LOCAL-OFFICE.   
           MOVE WS-01                        TO CS-CASH-COMPANY-NO      
                                                YR-CASH-COMPANY-NO      
                                                Y2-CASH-COMPANY-NO.     
      *                                                                         
           PERFORM 7320-SELECT-CASHIER  THRU 7320-EXIT.                 
      *                                                                         
           PERFORM 7020-SELECT-CASH-DRWR   THRU 7020-EXIT.              
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              PERFORM 7325-SELECT-CASH-REPORT THRU 7325-EXIT            
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE Y2-USER-ID         TO YR-USER-ID                  
                 MOVE WS-A               TO YR-STATUS                   
                 PERFORM 8325-CREATE-CASH-REPORT THRU 8325-EXIT         
              END-IF                                                    
              INITIALIZE DCLCSS-CSH-DRWR-CNTL                           
              MOVE WS-01                     TO  CS-CASH-COMPANY-NO     
              MOVE WS-CURRENT-DATE           TO  CS-DATE-CASH-REPORT    
                                                 CS-DATE-LAST-ACTIVITY  
              MOVE AR-CASH-LOCAL-OFFICE      TO  CS-CASH-LOCAL-OFFICE   
                                                 CS-CASH-REPORT-NO      
              MOVE 9999                      TO  CS-CASH-DRAWER-ID      
              MOVE WS-C                      TO  CS-CODE-CSH-DRWR-STAT  
              MOVE Y2-USER-ID                TO  CS-USER-ID             
              MOVE SPACES                    TO  CS-CASHIER-CODE        
              MOVE WS-NO                     TO  CS-CODE-FCS-EXTRACTED  
              MOVE SPACES                    TO  CS-BALANCED-BY         
              MOVE AR-PYMT-FACILITY-CD       TO  CS-CODE-PYMT-FACILITY  
              MOVE -1                        TO  WS-NULL-BAL-TS         
              PERFORM 8330-CREATE-NEW-BATCH  THRU 8330-EXIT             
           END-IF.                                                      
      *                                                                         
       2240-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07380000
      ******************************************************************07420000
      *                                                                *        
      * 2300-CREATE-AR-FOR-REVERSAL                                    *07430000
      * CREATES CLOSED DRAWER USED FOR REVERSAL OF PAYMENT TO BE       *07430000
      * CORRECTED                                                      *07430000
      *                                                                *        
      ******************************************************************07440000
      *                                                                 07380000
       2300-CREATE-AR-FOR-REVERSAL.                                     
      *                                                                         
           MOVE PARM-TRANS-HIST-SEQ-NO TO AR-TRANS-HIST-SEQ-NO          
                                          WS-INPUT-TRANS-HIST-SEQ-NO    
                                          WS-PREV-TRANS-HIST-SEQ-NO.    
           MOVE PARM-FROM-ACCOUNT-NO    TO AR-ACCOUNT-NO.               
      *                                                                 07380000
           PERFORM 7100-SELECT-AR-TRANS-HIST THRU 7100-EXIT.            
P0586F*    MOVE PARM-CORRECTION-AMT-DIFF TO WS-HOLD-PARM-DIFF.                  
           MOVE SPACES TO WS-OV-SH-TRAN-ID.                             
           MOVE WS-CLR-CASH-GL-NO(WS-GL-SUB)  TO WS-PAR-GEN-LEDG-DB.    
      *                                                                 07380000
P0586F*    IF WS-HOLD-PARM-DIFF < 0                                             
P0586F*       MOVE 'Y' TO WS-NEG-DIFF-FLAG                                      
P0586F     IF WS-NEG-DIFF-FLAG = 'Y'                                    
              MOVE 'C' TO OH-OVERSHORT-DR-CR                            
              MOVE WS-CLR-CASH-GL-NO (WS-GL-SUB)  TO                    
                                               WS-TEMP-GEN-LEDG-DB      
              MOVE WS-CSH-OV-SH-GL-NO (WS-GL-SUB) TO                    
                                               WS-TEMP-GEN-LEDG-CR      
              SET OVERAGE-TRAN-ID TO TRUE                               
           ELSE                                                         
P0586F*       MOVE 'N' TO WS-NEG-DIFF-FLAG                                      
              MOVE 'D' TO OH-OVERSHORT-DR-CR                            
              MOVE WS-CSH-OV-SH-GL-NO (WS-GL-SUB) TO                    
                                               WS-TEMP-GEN-LEDG-DB      
              MOVE WS-CLR-CASH-GL-NO (WS-GL-SUB)  TO                    
                                               WS-TEMP-GEN-LEDG-CR      
              SET SHORTAGE-TRAN-ID TO TRUE                              
           END-IF.                                                      
P0586F*    ADD WS-HOLD-PARM-DIFF TO AR-AMT-ORIG-ENTERED                         
P0586F*                                 GIVING WS-AMT-DIFF-NUM.                 
P0586F*    COMPUTE WS-HOLD-PARM-DIFF = WS-HOLD-PARM-DIFF * -1.                  
           MOVE WS-CURRENT-DATE TO WS-CD-REPORT-DATE.                   
           MOVE 9999 TO WS-CASH-DRAWER-ID.                              
           MOVE AR-CASH-COMPANY-NO   TO WS-AR-CASH-COMPANY-NO           
                                        OH-CASH-COMPANY-NO              
                                        WS-CD-COMPANY-NO.               
           MOVE AR-CASH-LOCAL-OFFICE TO WS-AR-CASH-LOCAL-OFFICE         
                                        OH-CASH-LOCAL-OFFICE            
                                        WS-CD-LOCAL-OFFICE              
                                        WS-CD-REPORT-NO.                
           MOVE AR-DATE-CASH-REPORT  TO WS-AR-DATE-CASH-REPORT          
                                        OH-DATE-CASH-REPORT.            
           MOVE AR-CASH-DRAWER-ID    TO WS-AR-CASH-DRAWER-ID            
                                        OH-CASH-DRAWER-ID.              
           MOVE AR-ACCOUNT-NO        TO OH-ACCOUNT-NO.                  
      *                                                                         
           PERFORM 2240-CREATE-REPORT-DRWR THRU 2240-EXIT.              
      *                                                                         
           IF CS-CASH-LOCAL-OFFICE = '998'                              
              MOVE CS-CODE-CSH-DRWR-STAT TO WS-JRNL-OPER-ACTIVE         
           ELSE                                                         
              MOVE WS-C TO WS-JRNL-OPER-ACTIVE                          
           END-IF.                                                      
      *                                                                         
           IF AR-DATE-TRANS EQUAL SPACES                                
              MOVE -1 TO WS-NULL-IND1                                   
           END-IF.                                                      
      *                                                                         
           IF AR-DATE-ORIG-PYMT  EQUAL SPACES                           
              MOVE -1 TO WS-NULL-IND2                                   
                         WS-DATE-ORIG-PYMT-IND                          
           END-IF.                                                      
      *                                                                         
           IF AR-DATE-CASH-REPORT EQUAL SPACES                          
              MOVE -1 TO WS-NULL-IND3                                   
           END-IF.                                                      
           MOVE 'Y'          TO AR-PYMT-REFUNDED-IND.                   
           MOVE PARM-USER-ID TO AR-USER-ID.                             
           MOVE 'PANEL373C'  TO AR-APPL-PROGRAM-ID.                     
                                                                        
      * CHECK TO SEE IF BILLING OCCURRED AFTER PAYMENT.                         
      * IF NOT, MARK JOURNAL ENTRIES FOR RECORD ONLY.                           
      *                                                                         
           PERFORM 7250-PROCESS-RECORD-ONLY THRU 7250-EXIT.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE 'Y' TO WS-RECORD-ONLY                                
           END-IF.                                                      
           MOVE WS-RECORD-ONLY TO AR-RECORD-ONLY-FL.                    
           MOVE PARM-USER-ID TO WS-JRNL-OL-TEMP-ID.                     
      *                                                                         
           PERFORM 6415-SELECT-TERMOP THRU 6415-EXIT.                   
           MOVE PF-RESP-AREA-ID TO AR-RESP-AREA-ID.                     
      *                                                                         
           PERFORM 8020-UPDATE-AR-TRANS-HIST THRU 8020-EXIT.            
           MOVE AR-TRANS-HIST-SEQ-NO(1:10) TO WS-DATE.                  
           MOVE AR-TRANS-HIST-SEQ-NO(12:8) TO WS-TIME.                  
      *                                                                         
           PERFORM 7251-GET-ADJ-ROW           THRU 7251-EXIT.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                       OR WS-FOUND-MULT-BILLS           
              MOVE WS-ADJ-TRANS-HIST-SEQ-NO  TO AR-TRANS-HIST-SEQ-NO    
              MOVE 'PANEL113H'               TO AR-APPL-PROGRAM-ID      
              PERFORM 8020-UPDATE-AR-TRANS-HIST THRU 8020-EXIT          
           END-IF.                                                      
           MOVE SPACE          TO AR-RECORD-ONLY-FL.                    
      *                                                                         
           PERFORM 7000-GET-CURRENT-TIMESTAMP THRU 7000-EXIT.           
           MOVE 'PANEL373'    TO AR-APPL-PROGRAM-ID.                    
      *                                                                         
       2300-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 5750-JOURNAL-FORMAT-101                                        *        
      * THIS MODULE WRITES A FORMAT 101 JOURNAL                        *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       5750-JOURNAL-FORMAT-101.                                         
      *                                                                         
           MOVE WS-JRNL-CK-OPER-ID TO WS-JRNL-OPERATION-RQST.           
      *                                                                         
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
           MOVE WS-CURRENT-DATE         TO WS-JRNL-OL-REPORT-DT.        
           MOVE WS-JRNL-VALIDATE-OPER TO WS-JRNL-OPERATION-RQST.        
      *                                                                         
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
           MOVE 'A'                     TO WS-100-JRNL-SORT-ID.         
           MOVE '01'                    TO WS-100-COMPANY-NO.           
           MOVE WS-LOCAL-OFFICE         TO WS-100-LOCAL-OFFICE-CD.      
           MOVE 0                       TO WS-100-ACCT-NO               
                                           WS-100-CUSTOMER-NO           
                                           WS-100-PREMISE-NO.           
           MOVE AU-TRAN-APPL-NO         TO WS-100-JRNL-TRAN-APPL-NO.    
           ADD  1                       TO WS-100-JRNL-TRAN-APPL-NO.    
           MOVE WS-CURRENT-DATE         TO WS-100-DATE-LAST-ACTION.     
           MOVE 'C'                     TO WS-100-CODE-ENTRY-SOURCE.    
           MOVE SPACES                  TO WS-100-TRANS-ERRORS.         
           MOVE 101                     TO WS-101-JRNL-FORMAT-NO.       
           MOVE SPACES                  TO WS-101-CASH-DRAWER-USED.     
           MOVE WS-HOLD-PARM-DIFF       TO WS-101-AMT-POSTED            
           MOVE SPACES                  TO WS-101-AR-AGE.               
           MOVE WS-CURRENT-DATE         TO WS-101-DATE-AR-BILLED.       
           MOVE 0                       TO WS-101-ITEM-ID-NO            
                                           WS-101-DETAIL-END-BAL        
                                           WS-101-DETAIL-END-AR-BAL     
                                           WS-101-ACCT-END-AR-BAL.      
           MOVE SPACES                  TO WS-101-FUNCTION-CODE         
                                           WS-101-CODE-REVENUE-DISTRICT 
                                           WS-101-CODE-EMPL-ACCT        
                                           WS-101-CODE-COMPANY-ACCT     
                                           WS-101-CODE-ACCOUNT-STATUS   
                                           WS-101-CODE-PREMISE-STATUS.  
           MOVE WS-TEMP-GEN-LEDG-DB     TO WS-101-ACCT-GEN-LED-DR.      
           MOVE WS-TEMP-GEN-LEDG-CR     TO WS-101-ACCT-GEN-LED-CR.      
      *                                                                         
           IF Y2-DEP-CASH-GL-OFFSET > 0                                 
              IF Y2-CASH-LOCAL-OFFICE = '025' AND                       
                 WS-PAR-PYMT-FACILITY-CD = 'G'                          
                 CONTINUE                                               
              ELSE                                                      
                 IF OVERAGE-TRAN-ID                                     
                    MOVE Y2-DEP-CASH-GL-OFFSET TO WS-101-ACCT-GEN-LED-CR
                 ELSE                                                   
                    IF SHORTAGE-TRAN-ID                                 
                       MOVE Y2-DEP-CASH-GL-OFFSET                       
                              TO WS-101-ACCT-GEN-LED-DR                 
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
           MOVE WS-OV-SH-TRAN-ID        TO WS-100-CODE-TERMINAL-TRAN.   
           MOVE SPACES                  TO WS-JRNL-CURRENCY-TYPE.       
      *                                                                         
           IF WS-JRNL-TRUE                                              
              IF WS-JRNL-AU-CURRENCY-TYPE =  AU-CURRENCY-TYPE           
                 MOVE AU-CURRENCY-TYPE  TO WS-JRNL-CURRENCY-TYPE        
              ELSE                                                      
                 IF SHORTAGE-TRAN-ID                                    
                    MOVE AU-CURRENCY-TYPE TO WS-JRNL-CURRENCY-TYPE      
                 ELSE                                                   
                    MOVE WS-JRNL-AU-CURRENCY-TYPE                       
                                        TO WS-JRNL-CURRENCY-TYPE        
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
           MOVE SPACES                  TO WS-JRNL-CODE-PYMT-FACILITY.  
           MOVE CJF00101                TO WS-100-USER-DEFINED-AREA.    
           MOVE WS-JRNL-ONLY            TO WS-JRNL-OPERATION-RQST.      
      *                                                                         
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
      *                                                                         
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
           MOVE WS-JRNL-CNTRL-ONLY     TO WS-JRNL-OPERATION-RQST.       
      *                                                                         
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
      *                                                                         
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * CPD00003                                                       *        
      * 6100-COMPUTE-REBATE-AMOUNT                                     *        
      * 6102-SELECT-ACCOUNT-DAYS                                       *        
      * 6103-SELECT-CONTRACT-DAYS                                      *        
      * 6104-SELECT-CNT-AR-ROW                                         *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     12160012
             INCLUDE CPD00003                                           PCS09350
           END-EXEC.                                                    PCS09350
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * CPD0006A                                                       *        
      * 6400-ONLINE-JRNL-ROUTINE                                       *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD0006A                                           PCS09360
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * CPD00008                                                       *        
      * 6500-ONLINE-LOAD-AR-TRAN-HIST                                  *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00008                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************00210600
      *                                                                *03030000
      * CPD00010                                                       *        
      * 6700-APPLY-PAYMENT                                             *00210700
      * THIS COPYBOOK CONTAINS THE NON-SQL PROCEDURE DIVISION          *        
      * STATEMENTS NECESSARY TO EXECUTE THE PAYMENT APPLICATION        *        
      * ROUTINE.                                                       *        
      *                                                                *03030000
      ******************************************************************00210800
      *                                                                         
           COPY CPD00010.                                               12160012
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * CPD0010S                                                       *        
      * THIS COPYBOOK CONTAINS THE SQL STATEMENTS NECESSARY TO EXECUTE *        
      * THE PAYMENT APPLICATION ROUTINE (CPD00010).                    *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD0010S                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * CPD00073                                                       *        
      * 6800-APPLY-PYMT-CO                                             *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00073                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * CPD00116                                                       *        
      * 6904-INSERT-AR-DETAILS                                         *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00116                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************07990000
      *                                                                *        
      * 7000-GET-CURRENT-TIMESTAMP                                     *08000000
      * SETS THE CURRENT TIMESTAMP                                     *08000000
      *                                                                *        
      ******************************************************************08010000
      *                                                                 07980000
       7000-GET-CURRENT-TIMESTAMP.                                      
      *                                                                 07980000
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     08040000
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP           08050000
MFA-TR*    END-EXEC.                                                    08060000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE WS-CURRENT-TIMESTAMP  TO AR-TRANS-HIST-SEQ-NO.          
      *                                                                 08130000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08130000
      ******************************************************************        
      *                                                                *        
      * 7020-SELECT-CASH-DRWR                                          *        
      * SELECTS CASH DRAWER ID FOR GIVEN CASH LOCAL OFFICE AND DATE    *        
      * CASH REPORT                                                    *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7020-SELECT-CASH-DRWR.                                           
      *                                                                 07980000
           EXEC SQL                                                     
             SELECT CASH_DRAWER_ID                                      
                   ,CODE_CSH_DRWR_STAT                                  
               INTO :CS-CASH-DRAWER-ID                                  
                   ,:CS-CODE-CSH-DRWR-STAT                              
               FROM CSS_CSH_DRWR_CNTL WITH(READUNCOMMITTED)                     
              WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO            
                AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE          
                AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )           
                AND CASH_DRAWER_ID     = 9999                           
                                                            
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CASH_DRAWER_ID                                              
MFA-TR*            ,CODE_CSH_DRWR_STAT                                          
MFA-TR*        INTO :CS-CASH-DRAWER-ID                                          
MFA-TR*            ,:CS-CODE-CSH-DRWR-STAT                                      
MFA-TR*        FROM CSS_CSH_DRWR_CNTL                                           
MFA-TR*       WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO                    
MFA-TR*         AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE                  
MFA-TR*         AND DATE_CASH_REPORT   = :CS-DATE-CASH-REPORT                   
MFA-TR*         AND CASH_DRAWER_ID     = 9999                                   
MFA-TR*     QUERYNO 7020                                                        
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7020'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CSH_DRWR_CNTL'   TO TABLE-1                     
              MOVE 'CASH_LOCAL_OFFICE'   TO TABLE-ELEMENT-1             
              MOVE CS-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-1           
              MOVE 'DATE_CASH_REPORT'    TO TABLE-ELEMENT-2             
              MOVE CS-DATE-CASH-REPORT   TO HOSTVAR-ELEMENT-2           
              MOVE 'CODE_CSH_DRWR_STAT'  TO TABLE-ELEMENT-3             
              MOVE CS-CODE-CSH-DRWR-STAT TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************08160000
      *                                                                *08160000
      * 7100-SELECT-AR-TRANS-HIST                                      *08170000
      * SELECTS FROM THE CSS_AR_TRANS_HIST TABLE                       *08170000
      *                                                                *08160000
      ***************************************************************** 08180000
      *                                                                 08130000
       7100-SELECT-AR-TRANS-HIST.                                       
      *                                                                 03770000
           EXEC SQL                                                     
               SELECT DATE_TRANS                                        
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO                                 
                     ,CODE_TRAN_TYPE                                    
                     ,AMT_ORIG_ENTERED                                  
                     ,AMT_BILLED_UNPAID                                 
                     ,RESP_AREA_ID                                      
                     ,APPL_PROGRAM_ID                                   
                     ,PYMT_FACILITY_CD                                  
                     ,USER_ID                                           
                     ,COMPANY_NO                                        
                     ,RECORD_ONLY_FL                                    
                     ,DATE_ORIG_PYMT                                    
                     ,CASH_COMPANY_NO                                   
                     ,CASH_LOCAL_OFFICE                                 
                     ,CASH_REPORT_NO                                    
                     ,DATE_CASH_REPORT                                  
                     ,CASH_DRAWER_ID                                    
                     ,TRAN_COMMENT                                      
                     ,CAST(SYSDATETIMEOFFSET() AS DATE)                         
                 INTO :AR-DATE-TRANS :WS-NULL-IND1                       
                     ,:AR-TRANS-HIST-SEQ-NO                             
                     ,:AR-CODE-TRAN-TYPE                                
                     ,:AR-AMT-ORIG-ENTERED                              
                     ,:AR-AMT-BILLED-UNPAID                             
                     ,:AR-RESP-AREA-ID                                  
                     ,:AR-APPL-PROGRAM-ID                               
                     ,:AR-PYMT-FACILITY-CD                              
                     ,:AR-USER-ID                                       
                     ,:AR-COMPANY-NO                                    
                     ,:AR-RECORD-ONLY-FL                                
                     ,:AR-DATE-ORIG-PYMT :WS-NULL-IND2                   
                     ,:AR-CASH-COMPANY-NO                               
                     ,:AR-CASH-LOCAL-OFFICE                             
                     ,:AR-CASH-REPORT-NO                                
                     ,:AR-DATE-CASH-REPORT :WS-NULL-IND3                 
                     ,:AR-CASH-DRAWER-ID                                
                     ,:AR-TRAN-COMMENT                                  
                     ,:WS-CURRENT-DATE                                  
                 FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                
                  AND TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )         
                  AND CODE_TRAN_TYPE    = 'P'                           
                  AND RECORD_ONLY_FL    IN ('N', ' ')                   
                  AND PYMT_REFUNDED_IND IN ('N', ' ')                   
                  AND APPL_PROGRAM_ID <> 'PANEL373C'                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     08210000
MFA-TR*        SELECT DATE_TRANS                                        08220000
MFA-TR*              ,TRANS_HIST_SEQ_NO                                 08220000
MFA-TR*              ,CODE_TRAN_TYPE                                    08230000
MFA-TR*              ,AMT_ORIG_ENTERED                                  08240000
MFA-TR*              ,AMT_BILLED_UNPAID                                 08250000
MFA-TR*              ,RESP_AREA_ID                                      08260000
MFA-TR*              ,APPL_PROGRAM_ID                                   08270000
MFA-TR*              ,PYMT_FACILITY_CD                                  08280000
MFA-TR*              ,USER_ID                                           08290000
MFA-TR*              ,COMPANY_NO                                        08300000
MFA-TR*              ,RECORD_ONLY_FL                                    08310000
MFA-TR*              ,DATE_ORIG_PYMT                                    08320000
MFA-TR*              ,CASH_COMPANY_NO                                   08330000
MFA-TR*              ,CASH_LOCAL_OFFICE                                 08340000
MFA-TR*              ,CASH_REPORT_NO                                    08350000
MFA-TR*              ,DATE_CASH_REPORT                                  08360000
MFA-TR*              ,CASH_DRAWER_ID                                    08370000
MFA-TR*              ,TRAN_COMMENT                                      08380000
MFA-TR*              ,CURRENT DATE                                      08380000
MFA-TR*          INTO :AR-DATE-TRANS:WS-NULL-IND1                       08390000
MFA-TR*              ,:AR-TRANS-HIST-SEQ-NO                             08390000
MFA-TR*              ,:AR-CODE-TRAN-TYPE                                08400000
MFA-TR*              ,:AR-AMT-ORIG-ENTERED                              08410000
MFA-TR*              ,:AR-AMT-BILLED-UNPAID                             08420000
MFA-TR*              ,:AR-RESP-AREA-ID                                  08430000
MFA-TR*              ,:AR-APPL-PROGRAM-ID                               08440000
MFA-TR*              ,:AR-PYMT-FACILITY-CD                              08450000
MFA-TR*              ,:AR-USER-ID                                       08460000
MFA-TR*              ,:AR-COMPANY-NO                                    08470000
MFA-TR*              ,:AR-RECORD-ONLY-FL                                08480000
MFA-TR*              ,:AR-DATE-ORIG-PYMT:WS-NULL-IND2                   08490000
MFA-TR*              ,:AR-CASH-COMPANY-NO                               08500000
MFA-TR*              ,:AR-CASH-LOCAL-OFFICE                             08510000
MFA-TR*              ,:AR-CASH-REPORT-NO                                08520000
MFA-TR*              ,:AR-DATE-CASH-REPORT:WS-NULL-IND3                 08530000
MFA-TR*              ,:AR-CASH-DRAWER-ID                                08540000
MFA-TR*              ,:AR-TRAN-COMMENT                                  08550000
MFA-TR*              ,:WS-CURRENT-DATE                                  08550000
MFA-TR*          FROM CSS_AR_TRANS_HIST                                 08560000
MFA-TR*         WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                08570000
MFA-TR*           AND TRANS_HIST_SEQ_NO = :AR-TRANS-HIST-SEQ-NO                 
MFA-TR*           AND CODE_TRAN_TYPE    = 'P'                                   
MFA-TR*           AND RECORD_ONLY_FL    IN ('N', ' ')                           
MFA-TR*           AND PYMT_REFUNDED_IND IN ('N', ' ')                           
MFA-TR*           AND APPL_PROGRAM_ID <> 'PANEL373C'                            
MFA-TR*       WITH UR                                                           
MFA-TR*    QUERYNO 7100                                                         
MFA-TR*    END-EXEC.                                                    08590000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF WS-NULL-IND1 < 0                                          
              MOVE SPACES TO AR-DATE-TRANS                              
           END-IF.                                                      
      *                                                                         
           IF WS-NULL-IND2 < 0                                          
              MOVE SPACES TO AR-DATE-ORIG-PYMT                          
           END-IF.                                                      
      *                                                                         
           IF WS-NULL-IND3 < 0                                          
              MOVE SPACES TO AR-DATE-CASH-REPORT                        
           END-IF.                                                      
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      * DO NOT REVERSE A REVERSED PAYMENT. ABEND IF PAYMENT TO BE               
      * REVERSED IS NOT FOUND OR IS MARKED RECORDS ONLY.                        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
             MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                
             MOVE PROGRAM-NAME          TO ABEND-PROGRAM                
             MOVE '7100'                TO ACTIVE-PARAGRAPH             
             MOVE 'SELECT'              TO ABEND-FUNCTION               
             MOVE 'CSS_AR_TRANS_HIST'   TO TABLE-1                      
             MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1              
             MOVE 'TRAN_HIST_SEQ_NO'    TO TABLE-ELEMENT-2              
             MOVE AR-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1            
             MOVE AR-TRANS-HIST-SEQ-NO  TO HOSTVAR-ELEMENT-2            
             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                  
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7250-PROCESS-RECORD-ONLY                                       *        
      * THE SELECT DETERMINES IF A BILLING OCCURRED AFTER THE          *        
      * PAYMENT WAS MADE. IF NOT THIS MEANS THE JOURNALING IS FOR      *        
      * RECORDS ONLY. NOTE THIS SELECT MAY BRING BACK MORE THAN ONE    *        
      * ROW IF SO MULTIPLE BILLINGS HAVE OCCURED.                      *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7250-PROCESS-RECORD-ONLY.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), TRANS_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') TRANS_HIST_SEQ_NO                      
                INTO :WS-TRANS-HIST-SEQ-NO                              
                FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                    
               WHERE ACCOUNT_NO = :AR-ACCOUNT-NO                        
                 AND TRANS_HIST_SEQ_NO > CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )          
                 AND CODE_TRAN_TYPE = 'B'                               
                 AND CIS.SUBSTR3(
           APPL_PROGRAM_ID,1,5) IN ('PCSCA','SCSCA')   
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT TRANS_HIST_SEQ_NO                                          
MFA-TR*         INTO :WS-TRANS-HIST-SEQ-NO                                      
MFA-TR*         FROM CSS_AR_TRANS_HIST                                          
MFA-TR*        WHERE ACCOUNT_NO = :AR-ACCOUNT-NO                                
MFA-TR*          AND TRANS_HIST_SEQ_NO > :AR-TRANS-HIST-SEQ-NO                  
MFA-TR*          AND CODE_TRAN_TYPE = 'B'                                       
MFA-TR*          AND SUBSTR(APPL_PROGRAM_ID,1,5) IN ('PCSCA','SCSCA')           
MFA-TR*       QUERYNO 7250                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR NOT-FOUND                                                 
           OR WS-FOUND-MULT-BILLS                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE               
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7250'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_AR_TRANS_HIST'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'TRAN_HIST_SEQ_NO'    TO TABLE-ELEMENT-2             
              MOVE AR-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE AR-TRANS-HIST-SEQ-NO  TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************09780000
      *                                                                *09780000
      * 7251-GET-ADJ-ROW                                               *09790000
      * SELECT GETS THE ADJ ROW FOR THE PAYMENT TO BE CORRECTED        *        
      *                                                                *09780000
      ******************************************************************09840000
      *                                                                         
       7251-GET-ADJ-ROW.                                                
      *                                                                         
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), TRANS_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') TRANS_HIST_SEQ_NO                      
                INTO :WS-ADJ-TRANS-HIST-SEQ-NO                          
                FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                    
               WHERE ACCOUNT_NO = :AR-ACCOUNT-NO                        
                 AND TRANS_HIST_SEQ_NO <= CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )         
                 AND DATE_TRANS = IIF(TRY_CONVERT(DATE, :AR-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS
              ) <> 0) OR (LEN(:AR-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :AR-DATE-TRANS
              ), CONVERT(DATE, :AR-DATE-TRANS) )                        
                 AND CODE_TRAN_TYPE = 'A'                               
                 AND APPL_PROGRAM_ID = 'PANEL113H'                      
                 AND CAST(TRANS_HIST_SEQ_NO AS DATE) = 
              IIF(TRY_CONVERT(DATE, :WS-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE) <> 0) OR (LEN(
                                                               :WS-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-DATE), CONVERT(DATE, :WS-DATE
              ) )                 
                 AND DATEADD(NANOSECOND, -DATEPART(NANOSECOND, CAST(
           TRANS_HIST_SEQ_NO AS TIME)), CAST(TRANS_HIST_SEQ_NO
            AS TIME)) = CIS.CHAR2TIME(:WS-TIME)                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     09860000
MFA-TR*       SELECT TRANS_HIST_SEQ_NO                                  09870000
MFA-TR*         INTO :WS-ADJ-TRANS-HIST-SEQ-NO                          09880000
MFA-TR*         FROM CSS_AR_TRANS_HIST                                  09890000
MFA-TR*        WHERE ACCOUNT_NO = :AR-ACCOUNT-NO                        09900000
MFA-TR*          AND TRANS_HIST_SEQ_NO <= :AR-TRANS-HIST-SEQ-NO         09910000
MFA-TR*          AND DATE_TRANS = :AR-DATE-TRANS                                
MFA-TR*          AND CODE_TRAN_TYPE = 'A'                               09920000
MFA-TR*          AND APPL_PROGRAM_ID = 'PANEL113H'                              
MFA-TR*          AND DATE(TRANS_HIST_SEQ_NO) = :WS-DATE                 09930000
MFA-TR*          AND TIME(TRANS_HIST_SEQ_NO) = :WS-TIME                 09930000
MFA-TR*       WITH UR                                                           
MFA-TR*    QUERYNO 7251                                                 09940000
MFA-TR*    END-EXEC.                                                    09940000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR NOT-FOUND                                                 
           OR WS-FOUND-MULT-BILLS                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE               
              MOVE '7251'                TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_AR_TRANS_HIST'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'TRAN_HIST_SEQ_NO'    TO TABLE-ELEMENT-2             
              MOVE AR-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE AR-TRANS-HIST-SEQ-NO  TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7251-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7320-SELECT-CASHIER                                            *        
      * SELECTS CASHIER INFORMATION FROM CSS_CASHIER_OFFICE TABLE      *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7320-SELECT-CASHIER.                                             
      *                                                                         
           EXEC SQL                                                     
             SELECT USER_ID                                             
                   ,DEP_CASH_GL_OFFSET                                  
                   ,LOCAL_OFFICE                                        
               INTO :Y2-USER-ID                                         
                   ,:Y2-DEP-CASH-GL-OFFSET                              
                   ,:Y2-LOCAL-OFFICE                                    
               FROM CSS_CASHIER_OFFICE WITH(READUNCOMMITTED)                    
              WHERE CASH_COMPANY_NO    = :Y2-CASH-COMPANY-NO            
                AND CASH_LOCAL_OFFICE  = :Y2-CASH-LOCAL-OFFICE          
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT USER_ID                                                     
MFA-TR*            ,DEP_CASH_GL_OFFSET                                          
MFA-TR*            ,LOCAL_OFFICE                                                
MFA-TR*        INTO :Y2-USER-ID                                                 
MFA-TR*            ,:Y2-DEP-CASH-GL-OFFSET                                      
MFA-TR*            ,:Y2-LOCAL-OFFICE                                            
MFA-TR*        FROM CSS_CASHIER_OFFICE                                          
MFA-TR*       WHERE CASH_COMPANY_NO    = :Y2-CASH-COMPANY-NO                    
MFA-TR*         AND CASH_LOCAL_OFFICE  = :Y2-CASH-LOCAL-OFFICE                  
MFA-TR*     QUERYNO 7320                                                        
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7320'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CASHIER_OFFICE'  TO TABLE-1                     
              MOVE 'CASH COMPANY NO'     TO TABLE-ELEMENT-1             
              MOVE 'CASH LOCAL OFFICE'   TO TABLE-ELEMENT-2             
              MOVE Y2-CASH-COMPANY-NO    TO HOSTVAR-ELEMENT-1           
              MOVE Y2-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7325-SELECT-CASH-REPORT                                        *        
      * SELECTS USER ID FROM CSS_CSH_REPORT_HDR TABLE                  *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7325-SELECT-CASH-REPORT.                                         
      *                                                                         
           EXEC SQL                                                     
             SELECT USER_ID                                             
               INTO :YR-USER-ID                                         
               FROM CSS_CSH_REPORT_HDR WITH(READUNCOMMITTED)                    
              WHERE CASH_COMPANY_NO    = :YR-CASH-COMPANY-NO            
                AND CASH_LOCAL_OFFICE  = :YR-CASH-LOCAL-OFFICE          
                AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :YR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YR-DATE-CASH-REPORT
              ), CONVERT(DATE, :YR-DATE-CASH-REPORT) )           
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT USER_ID                                                     
MFA-TR*        INTO :YR-USER-ID                                                 
MFA-TR*        FROM CSS_CSH_REPORT_HDR                                          
MFA-TR*       WHERE CASH_COMPANY_NO    = :YR-CASH-COMPANY-NO                    
MFA-TR*         AND CASH_LOCAL_OFFICE  = :YR-CASH-LOCAL-OFFICE                  
MFA-TR*         AND DATE_CASH_REPORT   = :YR-DATE-CASH-REPORT                   
MFA-TR*     QUERYNO 7325                                                        
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR NOT-FOUND                                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7325'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CSH_REPORT_HDR'  TO TABLE-1                     
              MOVE 'CASH COMPANY NO'     TO TABLE-ELEMENT-1             
              MOVE 'CASH LOCAL OFFICE'   TO TABLE-ELEMENT-2             
              MOVE 'DATE CASH REPORT'    TO TABLE-ELEMENT-3             
              MOVE YR-CASH-COMPANY-NO    TO HOSTVAR-ELEMENT-1           
              MOVE YR-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-2           
              MOVE YR-DATE-CASH-REPORT   TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7325-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7500-CALL-CSR02341                                             *        
      * CALLS CSR02341                                                 *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7500-CALL-CSR02341.                                              
      *                                                                         
           INITIALIZE WS-CSR02341-OUTPUT-FIELDS.                        
      *                                                                         
      *    EXEC SQL                                                     
      *         CALL CSR02341                                           
      *         (   :WS-CSR02341-BYPASS-WARNING                         
      *            ,:WS-CSR02341-UPDATE-TYPE                            
      *            ,:WS-CSR02341-ACCT-NO                                
      *            ,:WS-CSR02341-FACILITY-CODE                          
      *            ,:WS-CSR02341-PAYMENT-TYPE                           
      *            ,:WS-CSR02341-AMT-CHECK                              
      *            ,:WS-CSR02341-AMT-MONEY-ORDER                        
      *            ,:WS-CSR02341-AMT-LIHEAP                             
      *            ,:WS-CSR02341-CHRG-CARD-TYPE                         
      *            ,:WS-CSR02341-AMT-CHRG-CARD                          
      *            ,:WS-CSR02341-AMT-CASH                               
      *            ,:WS-CSR02341-NO-ROWS                                
      *            ,:WS-CSR02341-DIR-PAY-1                              
      *            ,:WS-CSR02341-DIR-PAY-2                              
      *            ,:WS-CSR02341-DIR-PAY-3                              
      *            ,:WS-CSR02341-DIR-PAY-4                              
      *            ,:WS-CSR02341-DIR-PAY-5                              
      *            ,:WS-CSR02341-DIR-PAY-6                              
      *            ,:WS-CSR02341-DIR-PAY-7                              
      *            ,:WS-CSR02341-DIR-PAY-8                              
      *            ,:WS-CSR02341-DIR-PAY-9                              
      *            ,:WS-CSR02341-DIR-PAY-10                             
      *            ,:WS-CSR02341-DIR-PAY-11                             
      *            ,:WS-CSR02341-DIR-PAY-12                             
      *            ,:WS-CSR02341-DIR-PAY-13                             
      *            ,:WS-CSR02341-DIR-PAY-14                             
      *            ,:WS-CSR02341-DIR-PAY-15                             
      *            ,:WS-CSR02341-DIR-PAY-16                             
      *            ,:WS-CSR02341-DIR-PAY-17                             
      *            ,:WS-CSR02341-DIR-PAY-18                             
      *            ,:WS-CSR02341-DIR-PAY-19                             
      *            ,:WS-CSR02341-DIR-PAY-20                             
      *            ,:WS-CSR02341-USER-ID                                
      *            ,:WS-CSR02341-PANEL-NO                               
      *            ,:WS-CSR02341-DATE-CASH-REPORT                       
      *            ,:WS-CSR02341-CASH-COMPANY-NO                        
      *            ,:WS-CSR02341-CASH-LOCAL-OFFICE                      
      *            ,:WS-CSR02341-CASH-DRAWER-ID                         
      *            ,:WS-CSR02341-CASH-REPORT-NO                         
      *            ,:WS-CSR02341-CONTRACT-TYPE                          
      *            ,:WS-CSR02341-CONTRACT-NAME                          
      *            ,:WS-CSR02341-CNT-CMMNT-LEN                          
      *            ,:WS-CSR02341-CNT-CMMNT-TXT                          
      *            ,:WS-CSR02341-PYMT-RCPT-PRNTD-CD                     
      *            ,:WS-CSR02341-LAST-UPDATE-TS)                        
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE PAYMENT_POSTING
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN PAYMENT_POSTING
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR PAYMENT_POSTING INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = +466                              
      *       EXEC SQL                                                  
      *            ASSOCIATE LOCATORS (:LOC1)                           
      *            WITH PROCEDURE CSR02341                              
      *       END-EXEC                                                  
      *                                                                         
      *       EXEC SQL                                                  
      *            ALLOCATE PAYMENT_POSTING CURSOR                      
      *            FOR RESULT SET :LOC1                                 
      *       END-EXEC                                                  
      *                                                                         
              EXEC SQL                                                  
                   FETCH PAYMENT_POSTING                                
                   INTO         :WS-CSR02341-RETURN-CODE                
                               ,:WS-CSR02341-ACCOUNT-NO                 
                               ,:WS-CSR02341-AMT-THIS-MONTH             
                               ,:WS-CSR02341-ADV-COLL-TSTAMP            
                               ,:WS-CSR02341-ERR-MSG1                   
                               ,:WS-CSR02341-ERR-MSG2                   
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
              MOVE WS-CSR02341-RETURN-CODE TO S-RETURN-CODE             
              MOVE WS-CSR02341-ACCOUNT-NO TO S-TO-ACCOUNT-NO            
              MOVE WS-CSR02341-ERR-MSG1 TO S-ERROR-MSG1                 
              MOVE WS-CSR02341-ERR-MSG2 TO S-ERROR-MSG2                 
              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
      *                                                                         
              IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL        
              OR WS-CSR02341-ERR-MSG1 = 5000                            
              OR WS-CSR02341-ERR-MSG1 = 5272                            
                 MOVE '7500'                  TO ACTIVE-PARAGRAPH       
                 MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
                 MOVE 'CALL'                  TO ABEND-FUNCTION         
                 MOVE 'CSR02341'              TO TABLE-1                
                 MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1        
                 MOVE 'SQLCODE '              TO TABLE-ELEMENT-2        
                 MOVE 'ERROR MSG1'            TO TABLE-ELEMENT-3        
                 MOVE WS-CSR02341-ACCOUNT-NO  TO HOSTVAR-ELEMENT-1      
                 MOVE WS-ACTIVE-RETURN-CODE   TO HOSTVAR-ELEMENT-2      
                 MOVE S-ERROR-MSG1            TO HOSTVAR-ELEMENT-3      
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT            
              END-IF                                                    
      *                                                                         
              EXEC SQL                                                  
                CLOSE PAYMENT_POSTING                                   
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
      *                                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE '7500'                 TO ACTIVE-PARAGRAPH        
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE 'CLOSE'                TO ABEND-FUNCTION          
                 MOVE 'CSR02341'             TO TABLE-1                 
                 MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1         
                 MOVE WS-CSR02341-ACCOUNT-NO TO HOSTVAR-ELEMENT-1       
                 MOVE 'SQLCODE '             TO TABLE-ELEMENT-2         
                 MOVE WS-ACTIVE-RETURN-CODE  TO HOSTVAR-ELEMENT-2       
                 PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT             
              END-IF                                                    
           ELSE                                                         
              MOVE -1                        TO WS-ACTIVE-RETURN-CODE   
              MOVE '7500'                    TO ACTIVE-PARAGRAPH        
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'DB2SP CALL'              TO ABEND-FUNCTION          
              MOVE 'CSR02341'                TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-CSR02341-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1       
              MOVE 'SQLCODE'                 TO TABLE-ELEMENT-2         
              MOVE SQLCODE                   TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7700-GET-GL-NO                                                 *        
      * SELECTS GL ACCOUNT NO FROM THE CSS_GL_ACCT_NO TABLE            *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7700-GET-GL-NO.                                                  
      *                                                                         
           EXEC SQL                                                     
              SELECT GL_ACCT_NO                                         
                INTO :GO-GL-ACCT-NO                                     
                FROM CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                       
               WHERE COMPANY_NO   = '01'                                
                 AND GL_ACCT_NAME = :GO-GL-ACCT-NAME                    
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT GL_ACCT_NO                                                 
MFA-TR*         INTO :GO-GL-ACCT-NO                                             
MFA-TR*         FROM CSS_GL_ACCT_NO                                             
MFA-TR*        WHERE COMPANY_NO   = '01'                                        
MFA-TR*          AND GL_ACCT_NAME = :GO-GL-ACCT-NAME                            
MFA-TR*      QUERYNO 7700                                                       
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7700'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_GL_ACCT_NO'      TO TABLE-1                     
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1             
              MOVE 'GL_ACCT_NAME'        TO TABLE-ELEMENT-2             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3             
              MOVE '01'                  TO HOSTVAR-ELEMENT-1           
              MOVE GO-GL-ACCT-NAME       TO HOSTVAR-ELEMENT-2           
              MOVE PARM-FROM-ACCOUNT-NO  TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************14930000
      *                                                                *        
      * CPD00312                                                       *14940000
      * 5500-CHECK-NON-UTIL                                            *14940000
      * COPYBOOK TO CHECK IF A NON-UTIL ACCOUNT CAN FINAL.             *        
      *                                                                *        
      ******************************************************************14950000
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00312                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7775-CHECK-MATCHING-ENTRY                                      *        
      * CHECK TO SEE IF THERE ALREADY EXISTS AN ENTRY IN THE TABLE FOR *        
      * THE BATCH OF THE ORIGINAL PAYMENT                              *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7775-CHECK-MATCHING-ENTRY.                                       
      *                                                                         
           MOVE PARM-FROM-ACCOUNT-NO   TO AR-ACCOUNT-NO.                
           MOVE PARM-TRANS-HIST-SEQ-NO TO AR-TRANS-HIST-SEQ-NO.         
           MOVE WS-HOLD-PARM-DIFF      TO OH-OVERSHORT-AMT.             
           MOVE '01'                   TO OH-CASH-COMPANY-NO.           
      *                                                                         
            EXEC SQL                                                    
               SELECT  CASH_COMPANY_NO                                  
                      ,DATE_CASH_REPORT                                 
                      ,OVERSHORT_ID                                     
                      ,OVERSHORT_AMT                                    
                      ,OFST_OVERSHORT_AMT                               
                      ,OFST_DR_CR                                       
                      ,OVERSHORT_DR_CR                                  
                 INTO  :OH-CASH-COMPANY-NO                              
                      ,:OH-DATE-CASH-REPORT                             
                      ,:OH-OVERSHORT-ID                                 
                      ,:OH-OVERSHORT-AMT                                
                      ,:OH-OFST-OVERSHORT-AMT                           
                      ,:OH-OFST-DR-CR                                   
                      ,:OH-OVERSHORT-DR-CR                              
                 FROM CSS_OVERSHORT_HDR WITH(READUNCOMMITTED)                   
                WHERE OVERSHORT_SOLTN_FL = 'P'                          
                  AND CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO           
                  AND CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE         
                  AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )          
                  AND CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID            
                  AND OVERSHORT_DR_CR  <> :OH-OVERSHORT-DR-CR           
                  AND OVERSHORT_AMT     = :OH-OVERSHORT-AMT             
                                                            
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT  CASH_COMPANY_NO                                          
MFA-TR*               ,DATE_CASH_REPORT                                         
MFA-TR*               ,OVERSHORT_ID                                             
MFA-TR*               ,OVERSHORT_AMT                                            
MFA-TR*               ,OFST_OVERSHORT_AMT                                       
MFA-TR*               ,OFST_DR_CR                                               
MFA-TR*               ,OVERSHORT_DR_CR                                          
MFA-TR*          INTO  :OH-CASH-COMPANY-NO                                      
MFA-TR*               ,:OH-DATE-CASH-REPORT                                     
MFA-TR*               ,:OH-OVERSHORT-ID                                         
MFA-TR*               ,:OH-OVERSHORT-AMT                                        
MFA-TR*               ,:OH-OFST-OVERSHORT-AMT                                   
MFA-TR*               ,:OH-OFST-DR-CR                                           
MFA-TR*               ,:OH-OVERSHORT-DR-CR                                      
MFA-TR*          FROM CSS_OVERSHORT_HDR                                         
MFA-TR*         WHERE OVERSHORT_SOLTN_FL = 'P'                                  
MFA-TR*           AND CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO                   
MFA-TR*           AND CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE                 
MFA-TR*           AND DATE_CASH_REPORT  = :OH-DATE-CASH-REPORT                  
MFA-TR*           AND CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID                    
MFA-TR*           AND OVERSHORT_DR_CR  <> :OH-OVERSHORT-DR-CR                   
MFA-TR*           AND OVERSHORT_AMT     = :OH-OVERSHORT-AMT                     
MFA-TR*        QUERYNO 7775                                                     
MFA-TR*        WITH UR                                                          
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
      *     IF A MATCH IS FOUND                                                 
      *        UPDATE THE PROBLEM OV-SH                                         
      *        INSERT THE ROW FOR THE NEW OV-SH IN OVERSHORT-HDR                
      *        INSERT A ROW IN OVERSHORT-DET TO MAP IT                          
      *     ELSE                                                                
      *        INSERT A ROW INTO OVERSHORT-HDR                                  
                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               MOVE 'S' TO WS-OVERSHORT-TYPE                            
               IF OH-OVERSHORT-DR-CR = 'C'                              
                  MOVE 'D' TO OH-OFST-DR-CR                             
               ELSE                                                     
                  MOVE 'C' TO OH-OFST-DR-CR                             
               END-IF                                                   
               PERFORM 7777-UPDATE-OVERSHORT-HDR THRU 7777-EXIT         
               PERFORM 7778-INSERT-OVERSHORT-HDR THRU 7778-EXIT         
               PERFORM 7779-INSERT-OVERSHORT-DET THRU 7779-EXIT         
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND OR              
                                              MULTIPLE-ROWS-SELECTED    
               MOVE 'P' TO WS-OVERSHORT-TYPE                            
                  PERFORM 7778-INSERT-OVERSHORT-HDR THRU 7778-EXIT      
               ELSE                                                     
                  MOVE SPACES               TO ABEND-TABLES             
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE 'SELECT'             TO ABEND-FUNCTION           
                  MOVE 'CSS_OVERSHORT_HDR'  TO TABLE-1                  
                  MOVE 'CASH_LOCAL_OFFICE'  TO TABLE-ELEMENT-1          
                  MOVE 'DATE_CASH_REPORT'   TO TABLE-ELEMENT-2          
                  MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-3          
                  MOVE AR-CASH-LOCAL-OFFICE TO HOSTVAR-ELEMENT-1        
                  MOVE AR-TRANS-HIST-SEQ-NO TO HOSTVAR-ELEMENT-2        
                  MOVE AR-ACCOUNT-NO        TO HOSTVAR-ELEMENT-4        
                  PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT        
               END-IF                                                   
            END-IF.                                                     
      *                                                                         
       7775-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7776-GET-LAST-OVERSHORT-ID                                     *        
      * OBTAIN LAST OVERSHORT-ID FOR CASH DRAWER IN TABLE              *        
      * CSS-OVERSHORT. IF NO ENTRIES, START OVERSHORT-ID AT 1          *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7776-GET-LAST-OVERSHORT-ID.                                      
      *                                                                         
            EXEC SQL                                                    
               SELECT MAX(OVERSHORT_ID)                                 
                 INTO :OH-OVERSHORT-ID :WS-NULL-IND1                    
                 FROM CSS_OVERSHORT_HDR WITH(READUNCOMMITTED)                   
                WHERE CASH_COMPANY_NO   = '01'                          
                  AND CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE         
                  AND DATE_CASH_REPORT  = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                  
                  AND CASH_DRAWER_ID    = 9999                          
                                                            
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT MAX(OVERSHORT_ID)                                         
MFA-TR*          INTO :OH-OVERSHORT-ID :WS-NULL-IND1                            
MFA-TR*          FROM CSS_OVERSHORT_HDR                                         
MFA-TR*         WHERE CASH_COMPANY_NO   = '01'                                  
MFA-TR*           AND CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE                 
MFA-TR*           AND DATE_CASH_REPORT  = CURRENT DATE                          
MFA-TR*           AND CASH_DRAWER_ID    = 9999                                  
MFA-TR*       QUERYNO 7776                                                      
MFA-TR*          WITH UR                                                        
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
            IF WS-NULL-IND1 < 0                                         
               MOVE 1                TO OH-OVERSHORT-ID                 
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                  ADD 1 TO OH-OVERSHORT-ID                              
               ELSE                                                     
                  MOVE SPACES               TO ABEND-TABLES             
                  MOVE '7776'               TO ACTIVE-PARAGRAPH         
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                  MOVE 'S351'               TO ABEND-PROGRAM            
                  MOVE 'SELECT'             TO ABEND-FUNCTION           
                  MOVE 'CSS_OVERSHORT_HDR'  TO TABLE-1                  
                  MOVE 'CASH_COMPANY_NO'    TO TABLE-ELEMENT-1          
                  MOVE 'CASH_LOCAL_OFFICE'  TO TABLE-ELEMENT-2          
                  MOVE 'DATE_CASH_REPORT'   TO TABLE-ELEMENT-3          
                  MOVE 'CASH_DRAWER_ID'     TO TABLE-ELEMENT-4          
                  MOVE OH-CASH-COMPANY-NO   TO HOSTVAR-ELEMENT-1        
                  MOVE OH-CASH-LOCAL-OFFICE TO HOSTVAR-ELEMENT-2        
                  MOVE OH-DATE-CASH-REPORT  TO HOSTVAR-ELEMENT-3        
                  MOVE OH-CASH-DRAWER-ID    TO HOSTVAR-ELEMENT-4        
                  PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT        
               END-IF                                                   
            END-IF.                                                     
      *                                                                         
       7776-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7777-UPDATE-OVERSHORT-HDR.                                     *        
      * SINCE A MATCHING ENTRY WAS FOUND, UPDATE THE OFFSET AMT AND IF *        
      * EQUAL TO OVERSHORT AMT, UPDATE SOLTN-FL TO 'Y'                 *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7777-UPDATE-OVERSHORT-HDR.                                       
      *                                                                         
      * SAVE VALUES FOR INSERT INTO CSS_OVERSHORT_DET                           
           MOVE OH-CASH-COMPANY-NO     TO OD-OFST-COMPANY-NO.           
           MOVE OH-CASH-LOCAL-OFFICE   TO OD-OFST-LOC-OFCE.             
           MOVE OH-DATE-CASH-REPORT    TO OD-OFST-CASH-REPT-DT.         
           MOVE OH-CASH-DRAWER-ID      TO OD-OFST-CASH-DRWR-ID.         
           MOVE OH-OVERSHORT-ID        TO OD-OFST-OVERSHORT-ID.         
           MOVE OH-OVERSHORT-AMT       TO OD-OFST-OVERSHORT-AMT.        
           MOVE WS-HOLD-PARM-DIFF      TO OH-OFST-OVERSHORT-AMT.        
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_OVERSHORT_HDR                                 
                  SET OFST_OVERSHORT_AMT = :OH-OFST-OVERSHORT-AMT       
                     ,OFST_DR_CR         = :OH-OFST-DR-CR               
                WHERE CASH_COMPANY_NO    = :OH-CASH-COMPANY-NO          
                  AND CASH_LOCAL_OFFICE  = :OH-CASH-LOCAL-OFFICE        
                  AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )         
                  AND CASH_DRAWER_ID     = :OH-CASH-DRAWER-ID           
                  AND OVERSHORT_ID       = :OH-OVERSHORT-ID             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00210000
MFA-TR*        UPDATE CSS_OVERSHORT_HDR                                 00220000
MFA-TR*           SET OFST_OVERSHORT_AMT = :OH-OFST-OVERSHORT-AMT       00271004
MFA-TR*              ,OFST_DR_CR         = :OH-OFST-DR-CR                       
MFA-TR*         WHERE CASH_COMPANY_NO    = :OH-CASH-COMPANY-NO                  
MFA-TR*           AND CASH_LOCAL_OFFICE  = :OH-CASH-LOCAL-OFFICE                
MFA-TR*           AND DATE_CASH_REPORT   = :OH-DATE-CASH-REPORT                 
MFA-TR*           AND CASH_DRAWER_ID     = :OH-CASH-DRAWER-ID                   
MFA-TR*           AND OVERSHORT_ID       = :OH-OVERSHORT-ID                     
MFA-TR*       QUERYNO 7777                                                      
MFA-TR*    END-EXEC.                                                    00480000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7777'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_OVERSHORT_HDR'       TO TABLE-1                 
              MOVE 'CASH_COMPANY_NO'         TO TABLE-ELEMENT-1         
              MOVE 'CASH_LOCAL_OFFICE'       TO TABLE-ELEMENT-2         
              MOVE 'DATE_CASH_REPORT'        TO TABLE-ELEMENT-3         
              MOVE 'CASH_DRAWER_ID'          TO TABLE-ELEMENT-4         
              MOVE OH-CASH-COMPANY-NO        TO HOSTVAR-ELEMENT-1       
              MOVE OH-CASH-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-2       
              MOVE OH-DATE-CASH-REPORT       TO HOSTVAR-ELEMENT-3       
              MOVE OH-CASH-DRAWER-ID         TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7777-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7778-INSERT-OVERSHORT-HDR                                      *        
      * INSERT ENTRY INTO CSS_OVERSHORT_HDR IF OV/SH                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7778-INSERT-OVERSHORT-HDR.                                       
      *                                                                         
           PERFORM 7776-GET-LAST-OVERSHORT-ID   THRU 7776-EXIT.         
      *                                                                         
           IF WS-NEG-DIFF-FLAG = 'Y'                                    
              MOVE 'C'                     TO OH-OVERSHORT-DR-CR        
           ELSE                                                         
              MOVE 'D'                     TO OH-OVERSHORT-DR-CR        
           END-IF.                                                      
                                                                        
           MOVE WS-CURRENT-DATE         TO OH-DATE-CASH-REPORT.         
           MOVE AR-CASH-LOCAL-OFFICE    TO OH-CASH-LOCAL-OFFICE.        
           MOVE 9999                    TO OH-CASH-DRAWER-ID.           
           MOVE PARM-USER-ID            TO OH-USER-ID.                  
           MOVE PARM-FROM-ACCOUNT-NO    TO OH-ACCOUNT-NO.               
           MOVE WS-HOLD-PARM-DIFF       TO OH-OVERSHORT-AMT.            
           MOVE 'CSH-OV-SH'             TO GO-GL-ACCT-NAME.             
      *                                                                         
           PERFORM 7700-GET-GL-NO       THRU 7700-EXIT.                 
           MOVE GO-GL-ACCT-NO           TO OH-GL-ACCT-NO.               
      *                                                                         
           IF Y2-DEP-CASH-GL-OFFSET > 0                                 
              IF  Y2-CASH-LOCAL-OFFICE = '025'                          
              AND WS-PAR-PYMT-FACILITY-CD = 'G'                         
                  CONTINUE                                              
              ELSE                                                      
                 MOVE Y2-DEP-CASH-GL-OFFSET TO OH-GL-ACCT-NO            
              END-IF                                                    
           END-IF.                                                      
           MOVE OH-GL-ACCT-NO           TO OT-GL-ACCT-NO.               
      *                                                                         
           PERFORM 7960-GET-OVSH-TYPE THRU 7960-EXIT.                   
           MOVE OT-OVERSHORT-TYPE-CD    TO OH-OVERSHORT-TYPE-CD.        
           MOVE WS-CURRENT-TIMESTAMP    TO OH-TRAN-TS                   
                                           OH-LAST-UPDATE-TS.           
      *                                                                         
           IF WS-OVERSHORT-TYPE = 'P'                                   
              MOVE 'P'                 TO OH-OVERSHORT-SOLTN-FL         
              MOVE ' '                 TO OH-OFST-DR-CR                 
              MOVE 0                   TO OH-OFST-OVERSHORT-AMT         
           ELSE                                                         
              MOVE 'S'                 TO OH-OVERSHORT-SOLTN-FL         
              MOVE OH-OVERSHORT-AMT    TO OH-OFST-OVERSHORT-AMT         
              IF OH-OVERSHORT-DR-CR = 'C'                               
                 MOVE 'D'               TO OH-OFST-DR-CR                
              ELSE                                                      
                 MOVE 'C'               TO OH-OFST-DR-CR                
              END-IF                                                    
            END-IF.                                                     
            MOVE PARM-FROM-ACCT-CMMNT-LEN  TO OH-TRAN-COMMENT-LEN.      
            MOVE PARM-FROM-ACCT-CMMNT-TEXT TO OH-TRAN-COMMENT-TEXT.     
      *                                                                         
            EXEC SQL                                                    
               INSERT INTO CSS_OVERSHORT_HDR                            
                         ( CASH_COMPANY_NO                              
                          ,CASH_LOCAL_OFFICE                            
                          ,DATE_CASH_REPORT                             
                          ,CASH_DRAWER_ID                               
                          ,OVERSHORT_ID                                 
                          ,USER_ID                                      
                          ,ACCOUNT_NO                                   
                          ,OVERSHORT_AMT                                
                          ,OVERSHORT_DR_CR                              
                          ,OFST_OVERSHORT_AMT                           
                          ,OFST_DR_CR                                   
                          ,GL_ACCT_NO                                   
                          ,TRAN_TS                                      
                          ,LAST_UPDATE_TS                               
                          ,OVERSHORT_TYPE_CD                            
                          ,OVERSHORT_SOLTN_FL                           
                          ,TRAN_COMMENT)                                
                  VALUES(  :OH-CASH-COMPANY-NO                          
                          ,:OH-CASH-LOCAL-OFFICE                        
                          ,IIF(TRY_CONVERT(DATE, :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )                         
                          ,:OH-CASH-DRAWER-ID                           
                          ,:OH-OVERSHORT-ID                             
                          ,:OH-USER-ID                                  
                          ,:OH-ACCOUNT-NO                               
                          ,:OH-OVERSHORT-AMT                            
                          ,:OH-OVERSHORT-DR-CR                          
                          ,:OH-OFST-OVERSHORT-AMT                       
                          ,:OH-OFST-DR-CR                               
                          ,:OH-GL-ACCT-NO                               
                          ,CIS.CHAR2TIMESTAMP(:OH-TRAN-TS)                      
                          ,CIS.CHAR2TIMESTAMP(:OH-LAST-UPDATE-TS)               
                          ,:OH-OVERSHORT-TYPE-CD                        
                          ,:OH-OVERSHORT-SOLTN-FL                       
                          ,:OH-TRAN-COMMENT)                            
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*        INSERT INTO CSS_OVERSHORT_HDR                                    
MFA-TR*                  ( CASH_COMPANY_NO                                      
MFA-TR*                   ,CASH_LOCAL_OFFICE                                    
MFA-TR*                   ,DATE_CASH_REPORT                                     
MFA-TR*                   ,CASH_DRAWER_ID                                       
MFA-TR*                   ,OVERSHORT_ID                                         
MFA-TR*                   ,USER_ID                                              
MFA-TR*                   ,ACCOUNT_NO                                           
MFA-TR*                   ,OVERSHORT_AMT                                        
MFA-TR*                   ,OVERSHORT_DR_CR                                      
MFA-TR*                   ,OFST_OVERSHORT_AMT                                   
MFA-TR*                   ,OFST_DR_CR                                           
MFA-TR*                   ,GL_ACCT_NO                                           
MFA-TR*                   ,TRAN_TS                                              
MFA-TR*                   ,LAST_UPDATE_TS                                       
MFA-TR*                   ,OVERSHORT_TYPE_CD                                    
MFA-TR*                   ,OVERSHORT_SOLTN_FL                                   
MFA-TR*                   ,TRAN_COMMENT)                                        
MFA-TR*           VALUES(  :OH-CASH-COMPANY-NO                                  
MFA-TR*                   ,:OH-CASH-LOCAL-OFFICE                                
MFA-TR*                   ,:OH-DATE-CASH-REPORT                                 
MFA-TR*                   ,:OH-CASH-DRAWER-ID                                   
MFA-TR*                   ,:OH-OVERSHORT-ID                                     
MFA-TR*                   ,:OH-USER-ID                                          
MFA-TR*                   ,:OH-ACCOUNT-NO                                       
MFA-TR*                   ,:OH-OVERSHORT-AMT                                    
MFA-TR*                   ,:OH-OVERSHORT-DR-CR                                  
MFA-TR*                   ,:OH-OFST-OVERSHORT-AMT                               
MFA-TR*                   ,:OH-OFST-DR-CR                                       
MFA-TR*                   ,:OH-GL-ACCT-NO                                       
MFA-TR*                   ,:OH-TRAN-TS                                          
MFA-TR*                   ,:OH-LAST-UPDATE-TS                                   
MFA-TR*                   ,:OH-OVERSHORT-TYPE-CD                                
MFA-TR*                   ,:OH-OVERSHORT-SOLTN-FL                               
MFA-TR*                   ,:OH-TRAN-COMMENT)                                    
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
      *                                                                         
             IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
                NEXT SENTENCE                                           
             ELSE                                                       
                MOVE SPACES               TO ABEND-TABLES               
                MOVE '7778'               TO ACTIVE-PARAGRAPH           
                MOVE SPACES               TO ABEND-SQL-PREDICATES       
                MOVE PROGRAM-NAME         TO ABEND-PROGRAM              
                MOVE 'INSERT'             TO ABEND-FUNCTION             
                MOVE 'CSS_OVERSHORT_HDR'  TO TABLE-1                    
                MOVE 'CASH_COMPANY_NO'    TO TABLE-ELEMENT-1            
                MOVE 'CASH_LOCAL_OFFICE'  TO TABLE-ELEMENT-2            
                MOVE 'DATE_CASH_REPORT'   TO TABLE-ELEMENT-3            
                MOVE 'CASH_DRAWER_ID'     TO TABLE-ELEMENT-4            
                MOVE OH-CASH-COMPANY-NO   TO HOSTVAR-ELEMENT-1          
                MOVE OH-CASH-LOCAL-OFFICE TO HOSTVAR-ELEMENT-2          
                MOVE OH-DATE-CASH-REPORT  TO HOSTVAR-ELEMENT-3          
                MOVE OH-CASH-DRAWER-ID    TO HOSTVAR-ELEMENT-4          
                PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT          
             END-IF.                                                    
      *                                                                         
       7778-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7779-INSERT-OVERSHORT-DET                                      *        
      * INSERT ROW FOR TABLE MATCHING OFFSET WITH OVERSHORT            *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7779-INSERT-OVERSHORT-DET.                                       
      *                                                                         
            MOVE '01'                    TO OD-CASH-COMPANY-NO.         
            MOVE AR-CASH-LOCAL-OFFICE    TO OD-CASH-LOCAL-OFFICE.       
            MOVE WS-CURRENT-DATE         TO OD-DATE-CASH-REPORT.        
            MOVE 9999                    TO OD-CASH-DRAWER-ID.          
            MOVE OH-OVERSHORT-ID         TO OD-OVERSHORT-ID.            
            MOVE OH-OVERSHORT-DR-CR      TO OD-OFST-DR-CR.              
      *                                                                         
               EXEC SQL                                                 
                  SELECT MAX(OD.OVERSHORT_SEQ_NO)                       
                    INTO :OD-OVERSHORT-SEQ-NO :WS-NULL-IND1              
                    FROM CSS_OVERSHORT_DET OD WITH(READUNCOMMITTED)             
                   WHERE OD.CASH_COMPANY_NO   = :OD-CASH-COMPANY-NO     
                     AND OD.CASH_LOCAL_OFFICE = :OD-CASH-LOCAL-OFFICE   
                     AND OD.DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :OD-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OD-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OD-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OD-DATE-CASH-REPORT
              ), CONVERT(DATE, :OD-DATE-CASH-REPORT) )    
                     AND OD.CASH_DRAWER_ID    = :OD-CASH-DRAWER-ID      
                     AND OD.OVERSHORT_ID      = :OD-OVERSHORT-ID        
                                                            
                                                                 
               END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*        EXEC SQL                                                         
MFA-TR*           SELECT MAX(OD.OVERSHORT_SEQ_NO)                               
MFA-TR*             INTO :OD-OVERSHORT-SEQ-NO:WS-NULL-IND1                      
MFA-TR*             FROM CSS_OVERSHORT_DET OD                                   
MFA-TR*            WHERE OD.CASH_COMPANY_NO   = :OD-CASH-COMPANY-NO             
MFA-TR*              AND OD.CASH_LOCAL_OFFICE = :OD-CASH-LOCAL-OFFICE           
MFA-TR*              AND OD.DATE_CASH_REPORT  = :OD-DATE-CASH-REPORT            
MFA-TR*              AND OD.CASH_DRAWER_ID    = :OD-CASH-DRAWER-ID              
MFA-TR*              AND OD.OVERSHORT_ID      = :OD-OVERSHORT-ID                
MFA-TR*          QUERYNO 7779                                                   
MFA-TR*             WITH UR                                                     
MFA-TR*        END-EXEC.                                                        

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
      *                                                                         
             IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
                ADD 1 TO OD-OVERSHORT-SEQ-NO                            
             ELSE                                                       
                IF WS-NULL-IND1 < 0                                     
                   MOVE 1 TO OD-OVERSHORT-SEQ-NO                        
                ELSE                                                    
                   MOVE SPACES               TO ABEND-TABLES            
                   MOVE '7779'               TO ACTIVE-PARAGRAPH        
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_OVERSHORT_DET'  TO TABLE-1                 
                   MOVE 'CASH_COMPANY_NO'    TO TABLE-ELEMENT-1         
                   MOVE 'CASH_LOCAL_OFFICE'  TO TABLE-ELEMENT-2         
                   MOVE 'DATE_CASH_REPORT'   TO TABLE-ELEMENT-3         
                   MOVE 'CASH_DRAWER_ID'     TO TABLE-ELEMENT-4         
                   MOVE OD-CASH-COMPANY-NO   TO HOSTVAR-ELEMENT-1       
                   MOVE OD-CASH-LOCAL-OFFICE TO HOSTVAR-ELEMENT-2       
                   MOVE OD-DATE-CASH-REPORT  TO HOSTVAR-ELEMENT-3       
                   MOVE OD-CASH-DRAWER-ID    TO HOSTVAR-ELEMENT-4       
                   PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT       
                END-IF
             END-IF.                                                 
      *                                                                         
            EXEC SQL                                                    
                INSERT INTO CSS_OVERSHORT_DET                           
                     (CASH_COMPANY_NO                                   
                     ,CASH_LOCAL_OFFICE                                 
                     ,DATE_CASH_REPORT                                  
                     ,CASH_DRAWER_ID                                    
                     ,OVERSHORT_ID                                      
                     ,OVERSHORT_SEQ_NO                                  
                     ,OFST_OVERSHORT_AMT                                
                     ,OFST_DR_CR                                        
                     ,OFST_COMPANY_NO                                   
                     ,OFST_LOC_OFCE                                     
                     ,OFST_CASH_REPT_DT                                 
                     ,OFST_CASH_DRWR_ID                                 
                     ,OFST_OVERSHORT_ID )                               
                VALUES                                                  
                     (:OD-CASH-COMPANY-NO                               
                     ,:OD-CASH-LOCAL-OFFICE                             
                     ,IIF(TRY_CONVERT(DATE, :OD-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OD-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OD-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OD-DATE-CASH-REPORT
              ), CONVERT(DATE, :OD-DATE-CASH-REPORT) )                         
                     ,:OD-CASH-DRAWER-ID                                
                     ,:OD-OVERSHORT-ID                                  
                     ,:OD-OVERSHORT-SEQ-NO                              
                     ,:OD-OFST-OVERSHORT-AMT                            
                     ,:OD-OFST-DR-CR                                    
                     ,:OD-OFST-COMPANY-NO                               
                     ,:OD-OFST-LOC-OFCE                                 
                     ,IIF(TRY_CONVERT(DATE, :OD-OFST-CASH-REPT-DT
              ) IS NULL OR (PATINDEX('%.%', :OD-OFST-CASH-REPT-DT
              ) <> 0) OR (LEN(:OD-OFST-CASH-REPT-DT
              ) <> 10), CIS.CHAR2DATE(:OD-OFST-CASH-REPT-DT
              ), CONVERT(DATE, :OD-OFST-CASH-REPT-DT) )                        
                     ,:OD-OFST-CASH-DRWR-ID                             
                     ,:OD-OFST-OVERSHORT-ID)                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*         INSERT INTO CSS_OVERSHORT_DET                                   
MFA-TR*              (CASH_COMPANY_NO                                           
MFA-TR*              ,CASH_LOCAL_OFFICE                                         
MFA-TR*              ,DATE_CASH_REPORT                                          
MFA-TR*              ,CASH_DRAWER_ID                                            
MFA-TR*              ,OVERSHORT_ID                                              
MFA-TR*              ,OVERSHORT_SEQ_NO                                          
MFA-TR*              ,OFST_OVERSHORT_AMT                                        
MFA-TR*              ,OFST_DR_CR                                                
MFA-TR*              ,OFST_COMPANY_NO                                           
MFA-TR*              ,OFST_LOC_OFCE                                             
MFA-TR*              ,OFST_CASH_REPT_DT                                         
MFA-TR*              ,OFST_CASH_DRWR_ID                                         
MFA-TR*              ,OFST_OVERSHORT_ID )                                       
MFA-TR*         VALUES                                                          
MFA-TR*              (:OD-CASH-COMPANY-NO                                       
MFA-TR*              ,:OD-CASH-LOCAL-OFFICE                                     
MFA-TR*              ,:OD-DATE-CASH-REPORT                                      
MFA-TR*              ,:OD-CASH-DRAWER-ID                                        
MFA-TR*              ,:OD-OVERSHORT-ID                                          
MFA-TR*              ,:OD-OVERSHORT-SEQ-NO                                      
MFA-TR*              ,:OD-OFST-OVERSHORT-AMT                                    
MFA-TR*              ,:OD-OFST-DR-CR                                            
MFA-TR*              ,:OD-OFST-COMPANY-NO                                       
MFA-TR*              ,:OD-OFST-LOC-OFCE                                         
MFA-TR*              ,:OD-OFST-CASH-REPT-DT                                     
MFA-TR*              ,:OD-OFST-CASH-DRWR-ID                                     
MFA-TR*              ,:OD-OFST-OVERSHORT-ID)                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               ADD 1 TO OD-OVERSHORT-SEQ-NO                             
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                  MOVE 1 TO OD-OVERSHORT-SEQ-NO                         
               ELSE                                                     
                  MOVE SPACES               TO ABEND-TABLES             
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE '7779'               TO ACTIVE-PARAGRAPH         
                  MOVE 'INSERT'             TO ABEND-FUNCTION           
                  MOVE 'CSS_OVERSHORT_DET'  TO TABLE-1                  
                  MOVE 'CASH_COMPANY_NO'    TO TABLE-ELEMENT-1          
                  MOVE 'CASH_LOCAL_OFFICE'  TO TABLE-ELEMENT-2          
                  MOVE 'DATE_CASH_REPORT'   TO TABLE-ELEMENT-3          
                  MOVE 'CASH_DRAWER_ID'     TO TABLE-ELEMENT-4          
                  MOVE OD-CASH-COMPANY-NO   TO HOSTVAR-ELEMENT-1        
                  MOVE OD-CASH-LOCAL-OFFICE TO HOSTVAR-ELEMENT-2        
                  MOVE OD-DATE-CASH-REPORT  TO HOSTVAR-ELEMENT-3        
                  MOVE OD-CASH-DRAWER-ID    TO HOSTVAR-ELEMENT-4        
                  PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT        
               END-IF                                                   
            END-IF.                                                     
      *                                                                         
       7779-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7960-GET-OVSH-TYPE                                             *        
      * SELECTS THE OVERSHORT TYPE CD FROM THE CSS_OVERSHORT_TYPE TABLE*        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7960-GET-OVSH-TYPE.                                              
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) OVERSHORT_TYPE_CD                                   
               INTO :OT-OVERSHORT-TYPE-CD                               
               FROM CSS_OVERSHORT_TYPE WITH(READUNCOMMITTED)                    
              WHERE GL_ACCT_NO = :OT-GL-ACCT-NO                         
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT OVERSHORT_TYPE_CD                                           
MFA-TR*        INTO :OT-OVERSHORT-TYPE-CD                                       
MFA-TR*        FROM CSS_OVERSHORT_TYPE                                          
MFA-TR*       WHERE GL_ACCT_NO = :OT-GL-ACCT-NO                                 
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7960                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7960'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_OVERSHORT_TYPE'      TO TABLE-1                 
              MOVE 'GL_ACCT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2         
              MOVE OT-GL-ACCT-NO             TO WS-DISP-GL-ACCT         
              MOVE WS-DISP-GL-ACCT           TO HOSTVAR-ELEMENT-1       
              MOVE PARM-FROM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7960-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************12310000
      *                                                                *        
      * CPD00075                                                       *12320000
      * 7999-SELECT-AL                                                 *12320000
      *                                                                *        
      ******************************************************************12310000
      *                                                                 42860000
           EXEC SQL                                                     14890000
              INCLUDE CPD00075                                          14900000
           END-EXEC.                                                    14910000
      *                                                                         
      ******************************************************************12310000
      *                                                                *12310000
      * 8000A-DELETE-GTT-ROWS                                          *12320000
      * DELETE GTT ROWS                                                *12320000
      *                                                                *12310000
      ******************************************************************12330000
      *                                                                         
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
           MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM #CSR04880_R1                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM SESSION.CSR04880_R1                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           OR NOT-FOUND                                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE '8000A'               TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                               ABEND-TABLES             
              MOVE 'CSR04880_R1'         TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************09490000
      *                                                                *09490000
      * 8020-UPDATE-AR-TRANS-HIST                                      *09500000
      * UPDATES THE AR TRANS HIST ROW                                  *        
      *                                                                *09490000
      ******************************************************************09510000
      *                                                                         
       8020-UPDATE-AR-TRANS-HIST.                                       
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_AR_TRANS_HIST                                 
                  SET APPL_PROGRAM_ID   = :AR-APPL-PROGRAM-ID           
                     ,PYMT_REFUNDED_IND = :AR-PYMT-REFUNDED-IND         
                     ,RECORD_ONLY_FL    = :AR-RECORD-ONLY-FL            
                WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                
                  AND TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00210000
MFA-TR*        UPDATE CSS_AR_TRANS_HIST                                 00220000
MFA-TR*           SET APPL_PROGRAM_ID   = :AR-APPL-PROGRAM-ID           00271004
MFA-TR*              ,PYMT_REFUNDED_IND = :AR-PYMT-REFUNDED-IND         00271004
MFA-TR*              ,RECORD_ONLY_FL    = :AR-RECORD-ONLY-FL            00271004
MFA-TR*         WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                        
MFA-TR*           AND TRANS_HIST_SEQ_NO = :AR-TRANS-HIST-SEQ-NO                 
MFA-TR*       QUERYNO 8020                                                      
MFA-TR*    END-EXEC.                                                    00480000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
              MOVE '8020'                    TO ACTIVE-PARAGRAPH        
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'PYMT_REFUNDED_IND'       TO TABLE-ELEMENT-2         
              MOVE 'USER_ID'                 TO TABLE-ELEMENT-3         
              MOVE 'APPL_PROGRAM_ID'         TO TABLE-ELEMENT-4         
              MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AR-PYMT-REFUNDED-IND      TO HOSTVAR-ELEMENT-2       
              MOVE AR-USER-ID                TO HOSTVAR-ELEMENT-3       
              MOVE AR-APPL-PROGRAM-ID        TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       8020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************08850000
      *                                                                *08850000
      * 8040-INSERT-AR-TRANS-HIST                                      *08860000
      * INSERTS A ROW INTO THE CSS_AR_TRANS_HIST TABLE                 *08860000
      *                                                                *08850000
      ******************************************************************08870000
      *                                                                         
       8040-INSERT-AR-TRANS-HIST.                                       
      *                                                                 03770000
           EXEC SQL                                                     
               INSERT INTO CSS_AR_TRANS_HIST                            
                   ( ACCOUNT_NO                                         
                    ,TRANS_HIST_SEQ_NO                                  
                    ,DATE_TRANS                                         
                    ,CODE_TRAN_TYPE                                     
                    ,AMT_ORIG_ENTERED                                   
                    ,AMT_BILLED_UNPAID                                  
                    ,RESP_AREA_ID                                       
                    ,APPL_PROGRAM_ID                                    
                    ,PYMT_FACILITY_CD                                   
                    ,USER_ID                                            
                    ,COMPANY_NO                                         
                    ,RECORD_ONLY_FL                                     
                    ,DATE_ORIG_PYMT                                     
                    ,PYMT_REFUNDED_IND                                  
                    ,CASH_COMPANY_NO                                    
                    ,CASH_LOCAL_OFFICE                                  
                    ,CASH_REPORT_NO                                     
                    ,DATE_CASH_REPORT                                   
                    ,CASH_DRAWER_ID                                     
                    ,TRAN_COMMENT)                                      
              VALUES                                                    
                  ( :AR-ACCOUNT-NO                                      
                   ,CIS.CHAR2TIMESTAMP(:AR-TRANS-HIST-SEQ-NO)                   
                   ,IIF(TRY_CONVERT(DATE, :AR-DATE-TRANS :WS-NULL-IND1
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS 
                                                          :WS-NULL-IND1
              ) <> 0) OR (LEN(:AR-DATE-TRANS :WS-NULL-IND1
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-TRANS :WS-NULL-IND1
              ), CONVERT(DATE, :AR-DATE-TRANS :WS-NULL-IND1) )                 
                   ,:AR-CODE-TRAN-TYPE                                  
                   ,:AR-AMT-ORIG-ENTERED                                
                   ,:AR-AMT-BILLED-UNPAID                               
                   ,:AR-RESP-AREA-ID                                    
                   ,:AR-APPL-PROGRAM-ID                                 
                   ,:AR-PYMT-FACILITY-CD                                
                   ,:AR-USER-ID                                         
                   ,:AR-COMPANY-NO                                      
                   ,:AR-RECORD-ONLY-FL                                  
                   ,IIF(TRY_CONVERT(DATE, :AR-DATE-ORIG-PYMT 
                                          :WS-NULL-IND2
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-ORIG-PYMT 
                                                          :WS-NULL-IND2
              ) <> 0) OR (LEN(:AR-DATE-ORIG-PYMT :WS-NULL-IND2
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-ORIG-PYMT :WS-NULL-IND2
              ), CONVERT(DATE, :AR-DATE-ORIG-PYMT :WS-NULL-IND2) )             
                   ,:AR-PYMT-REFUNDED-IND                               
                   ,:AR-CASH-COMPANY-NO                                 
                   ,:AR-CASH-LOCAL-OFFICE                               
                   ,:AR-CASH-REPORT-NO                                  
                   ,IIF(TRY_CONVERT(DATE, :AR-DATE-CASH-REPORT 
                                          :WS-NULL-IND3
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-CASH-REPORT 
                                                          :WS-NULL-IND3
              ) <> 0) OR (LEN(:AR-DATE-CASH-REPORT :WS-NULL-IND3
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-CASH-REPORT 
                                                          :WS-NULL-IND3
              ), CONVERT(DATE, :AR-DATE-CASH-REPORT :WS-NULL-IND3) )           
                   ,:AR-CASH-DRAWER-ID                                  
                   ,:AR-TRAN-COMMENT)                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     08890000
MFA-TR*        INSERT INTO CSS_AR_TRANS_HIST                            08900000
MFA-TR*            ( ACCOUNT_NO                                         08910000
MFA-TR*             ,TRANS_HIST_SEQ_NO                                  08920000
MFA-TR*             ,DATE_TRANS                                         08930000
MFA-TR*             ,CODE_TRAN_TYPE                                     08940000
MFA-TR*             ,AMT_ORIG_ENTERED                                   08950000
MFA-TR*             ,AMT_BILLED_UNPAID                                  08960000
MFA-TR*             ,RESP_AREA_ID                                       08970000
MFA-TR*             ,APPL_PROGRAM_ID                                    08980000
MFA-TR*             ,PYMT_FACILITY_CD                                   08990000
MFA-TR*             ,USER_ID                                            09000000
MFA-TR*             ,COMPANY_NO                                         09010000
MFA-TR*             ,RECORD_ONLY_FL                                     09020000
MFA-TR*             ,DATE_ORIG_PYMT                                     09030000
MFA-TR*             ,PYMT_REFUNDED_IND                                  09040000
MFA-TR*             ,CASH_COMPANY_NO                                    09050000
MFA-TR*             ,CASH_LOCAL_OFFICE                                  09060000
MFA-TR*             ,CASH_REPORT_NO                                     09070000
MFA-TR*             ,DATE_CASH_REPORT                                   09080000
MFA-TR*             ,CASH_DRAWER_ID                                     09090000
MFA-TR*             ,TRAN_COMMENT)                                      09100000
MFA-TR*       VALUES                                                    09110000
MFA-TR*           ( :AR-ACCOUNT-NO                                      09120000
MFA-TR*            ,:AR-TRANS-HIST-SEQ-NO                               09130000
MFA-TR*            ,:AR-DATE-TRANS:WS-NULL-IND1                         09140000
MFA-TR*            ,:AR-CODE-TRAN-TYPE                                  09150000
MFA-TR*            ,:AR-AMT-ORIG-ENTERED                                09160000
MFA-TR*            ,:AR-AMT-BILLED-UNPAID                               09170000
MFA-TR*            ,:AR-RESP-AREA-ID                                    09180000
MFA-TR*            ,:AR-APPL-PROGRAM-ID                                 09190000
MFA-TR*            ,:AR-PYMT-FACILITY-CD                                09200000
MFA-TR*            ,:AR-USER-ID                                         09210000
MFA-TR*            ,:AR-COMPANY-NO                                      09220000
MFA-TR*            ,:AR-RECORD-ONLY-FL                                  09230000
MFA-TR*            ,:AR-DATE-ORIG-PYMT:WS-NULL-IND2                     09240000
MFA-TR*            ,:AR-PYMT-REFUNDED-IND                               09250000
MFA-TR*            ,:AR-CASH-COMPANY-NO                                 09260000
MFA-TR*            ,:AR-CASH-LOCAL-OFFICE                               09270000
MFA-TR*            ,:AR-CASH-REPORT-NO                                  09280000
MFA-TR*            ,:AR-DATE-CASH-REPORT :WS-NULL-IND3                  09290000
MFA-TR*            ,:AR-CASH-DRAWER-ID                                  09300000
MFA-TR*            ,:AR-TRAN-COMMENT)                                   09310000
MFA-TR*    END-EXEC.                                                    09320000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
              MOVE '8040'                    TO ACTIVE-PARAGRAPH        
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'AMT_ORIG_ENTERED'        TO TABLE-ELEMENT-2         
              MOVE 'DATE_TRANS'              TO TABLE-ELEMENT-3         
              MOVE 'DATE_CASH_REPORT'        TO TABLE-ELEMENT-4         
              MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AR-AMT-ORIG-ENTERED       TO HOSTVAR-ELEMENT-2-N     
              MOVE AR-DATE-TRANS             TO HOSTVAR-ELEMENT-3       
              MOVE AR-DATE-CASH-REPORT       TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       8040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************12310000
      *                                                                *        
      * 8100-SEND-RESULT                                               *12320000
      * SEND THE RESULT SET                                            *12320000
      *                                                                *        
      ******************************************************************12310000
      *                                                                         
       8100-SEND-RESULT.                                                
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO #CSR04880_R1                         
                (                                                       
                    RETURN_CODE                                         
                   ,FROM_ACCOUNT_NO                                     
                   ,TO_ACCOUNT_NO                                       
                   ,ERROR_MSG1                                          
                   ,ERROR_MSG2                                          
                )                                                       
                VALUES                                                  
                (                                                       
                    :S-RETURN-CODE                                      
                   ,:S-FROM-ACCOUNT-NO                                  
                   ,:S-TO-ACCOUNT-NO                                    
                   ,:S-ERROR-MSG1                                       
                   ,:S-ERROR-MSG2                                       
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04880_R1                                 
MFA-TR*         (                                                               
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,FROM_ACCOUNT_NO                                             
MFA-TR*            ,TO_ACCOUNT_NO                                               
MFA-TR*            ,ERROR_MSG1                                                  
MFA-TR*            ,ERROR_MSG2                                                  
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*             :S-RETURN-CODE                                              
MFA-TR*            ,:S-FROM-ACCOUNT-NO                                          
MFA-TR*            ,:S-TO-ACCOUNT-NO                                            
MFA-TR*            ,:S-ERROR-MSG1                                               
MFA-TR*            ,:S-ERROR-MSG2                                               
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR -204           
              ADD +1                   TO CTR-ROWS                      
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSR04880_R1'        TO TABLE-1                      
              MOVE SPACES               TO TABLE-ELEMENT-1              
              MOVE SPACES               TO HOSTVAR-ELEMENT-1            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************12310000
      *                                                                *        
      * 8325-CREATE-CASH-REPORT                                        *12320000
      * INSERT A ROW IN THE CSS_CSH_REPORT_HDR TABLE                   *12320000
      *                                                                *        
      ******************************************************************12310000
      *                                                                 42860000
       8325-CREATE-CASH-REPORT.                                         
      *                                                                 42860000
           EXEC SQL                                                     
             INSERT INTO CSS_CSH_REPORT_HDR                             
                    ( CASH_COMPANY_NO                                   
                     ,CASH_LOCAL_OFFICE                                 
                     ,DATE_CASH_REPORT                                  
                     ,USER_ID                                           
                     ,STATUS                                            
                     ,CLOSED_TS)                                        
             VALUES ( :YR-CASH-COMPANY-NO                               
                      ,:YR-CASH-LOCAL-OFFICE                            
                      ,IIF(TRY_CONVERT(DATE, :YR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YR-DATE-CASH-REPORT
              ), CONVERT(DATE, :YR-DATE-CASH-REPORT) )                         
                      ,:YR-USER-ID                                      
                      ,:YR-STATUS                                       
                      ,CIS.CURRENT$TIMESTAMP())                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_CSH_REPORT_HDR                                     
MFA-TR*             ( CASH_COMPANY_NO                                           
MFA-TR*              ,CASH_LOCAL_OFFICE                                         
MFA-TR*              ,DATE_CASH_REPORT                                          
MFA-TR*              ,USER_ID                                                   
MFA-TR*              ,STATUS                                                    
MFA-TR*              ,CLOSED_TS)                                                
MFA-TR*      VALUES ( :YR-CASH-COMPANY-NO                                       
MFA-TR*               ,:YR-CASH-LOCAL-OFFICE                                    
MFA-TR*               ,:YR-DATE-CASH-REPORT                                     
MFA-TR*               ,:YR-USER-ID                                              
MFA-TR*               ,:YR-STATUS                                               
MFA-TR*               ,CURRENT TIMESTAMP)                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42860000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 42860000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8325'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CSH_REPORT_HDR'  TO TABLE-1                     
              MOVE 'CASH COMPANY NO'     TO TABLE-ELEMENT-1             
              MOVE 'CASH LOCAL OFFICE'   TO TABLE-ELEMENT-2             
              MOVE 'DATE CASH REPORT'    TO TABLE-ELEMENT-3             
              MOVE YR-CASH-COMPANY-NO    TO HOSTVAR-ELEMENT-1           
              MOVE YR-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-2           
              MOVE YR-DATE-CASH-REPORT   TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       8325-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************12310000
      *                                                                *        
      * 8330-CREATE-NEW-BATCH                                          *12320000
      * CREATES A NEW BATCH                                            *12320000
      *                                                                *        
      ******************************************************************12310000
      *                                                                 42860000
       8330-CREATE-NEW-BATCH.                                           
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO CSS_CSH_DRWR_CNTL                              
                  (                                                     
                   CASH_COMPANY_NO                                      
                  ,CASH_LOCAL_OFFICE                                    
                  ,CASH_REPORT_NO                                       
                  ,DATE_CASH_REPORT                                     
                  ,CASH_DRAWER_ID                                       
                  ,AMT_CASH_DEBIT                                       
                  ,AMT_CASH_CREDIT                                      
                  ,AMT_AR_DEBIT                                         
                  ,AMT_AR_CREDIT                                        
                  ,AMT_CK_ISS_DEBIT                                     
                  ,AMT_CK_ISS_CREDIT                                    
                  ,AMT_GL_DEBIT                                         
                  ,AMT_GL_CREDIT                                        
                  ,AMT_CASH_BEGIN_BAL                                   
                  ,AMT_BASIC_WORK                                       
                  ,USER_ID                                              
                  ,CASHIER_CODE                                         
                  ,CODE_PYMT_FACILITY                                   
                  ,CODE_FCS_EXTRACTED                                   
                  ,CODE_CSH_DRWR_STAT                                   
                  ,DATE_LAST_ACTIVITY                                   
                  ,BALANCED_BY                                          
                  ,BALANCED_TS                                          
                  ,NO_ITEMS_ENTERED                                     
                  )                                                     
           VALUES (                                                     
                   :CS-CASH-COMPANY-NO                                  
                  ,:CS-CASH-LOCAL-OFFICE                                
                  ,:CS-CASH-REPORT-NO                                   
                  ,IIF(TRY_CONVERT(DATE, :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )                         
                  ,:CS-CASH-DRAWER-ID                                   
                  ,:CS-AMT-CASH-DEBIT                                   
                  ,:CS-AMT-CASH-CREDIT                                  
                  ,:CS-AMT-AR-DEBIT                                     
                  ,:CS-AMT-AR-CREDIT                                    
                  ,:CS-AMT-CK-ISS-DEBIT                                 
                  ,:CS-AMT-CK-ISS-CREDIT                                
                  ,:CS-AMT-GL-DEBIT                                     
                  ,:CS-AMT-GL-CREDIT                                    
                  ,:CS-AMT-CASH-BEGIN-BAL                               
                  ,:CS-AMT-BASIC-WORK                                   
                  ,:CS-USER-ID                                          
                  ,:CS-CASHIER-CODE                                     
                  ,:CS-CODE-PYMT-FACILITY                               
                  ,:CS-CODE-FCS-EXTRACTED                               
                  ,:CS-CODE-CSH-DRWR-STAT                               
                  ,IIF(TRY_CONVERT(DATE, :CS-DATE-LAST-ACTIVITY
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-LAST-ACTIVITY
              ) <> 0) OR (LEN(:CS-DATE-LAST-ACTIVITY
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-LAST-ACTIVITY
              ), CONVERT(DATE, :CS-DATE-LAST-ACTIVITY) )                       
                  ,:CS-BALANCED-BY                                      
                  ,CIS.CHAR2TIMESTAMP(:CS-BALANCED-TS :WS-NULL-BAL-TS)          
                  ,:CS-NO-ITEMS-ENTERED                                 
                  )                                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_CSH_DRWR_CNTL                                      
MFA-TR*           (                                                             
MFA-TR*            CASH_COMPANY_NO                                              
MFA-TR*           ,CASH_LOCAL_OFFICE                                            
MFA-TR*           ,CASH_REPORT_NO                                               
MFA-TR*           ,DATE_CASH_REPORT                                             
MFA-TR*           ,CASH_DRAWER_ID                                               
MFA-TR*           ,AMT_CASH_DEBIT                                               
MFA-TR*           ,AMT_CASH_CREDIT                                              
MFA-TR*           ,AMT_AR_DEBIT                                                 
MFA-TR*           ,AMT_AR_CREDIT                                                
MFA-TR*           ,AMT_CK_ISS_DEBIT                                             
MFA-TR*           ,AMT_CK_ISS_CREDIT                                            
MFA-TR*           ,AMT_GL_DEBIT                                                 
MFA-TR*           ,AMT_GL_CREDIT                                                
MFA-TR*           ,AMT_CASH_BEGIN_BAL                                           
MFA-TR*           ,AMT_BASIC_WORK                                               
MFA-TR*           ,USER_ID                                                      
MFA-TR*           ,CASHIER_CODE                                                 
MFA-TR*           ,CODE_PYMT_FACILITY                                           
MFA-TR*           ,CODE_FCS_EXTRACTED                                           
MFA-TR*           ,CODE_CSH_DRWR_STAT                                           
MFA-TR*           ,DATE_LAST_ACTIVITY                                           
MFA-TR*           ,BALANCED_BY                                                  
MFA-TR*           ,BALANCED_TS                                                  
MFA-TR*           ,NO_ITEMS_ENTERED                                             
MFA-TR*           )                                                             
MFA-TR*    VALUES (                                                             
MFA-TR*            :CS-CASH-COMPANY-NO                                          
MFA-TR*           ,:CS-CASH-LOCAL-OFFICE                                        
MFA-TR*           ,:CS-CASH-REPORT-NO                                           
MFA-TR*           ,:CS-DATE-CASH-REPORT                                         
MFA-TR*           ,:CS-CASH-DRAWER-ID                                           
MFA-TR*           ,:CS-AMT-CASH-DEBIT                                           
MFA-TR*           ,:CS-AMT-CASH-CREDIT                                          
MFA-TR*           ,:CS-AMT-AR-DEBIT                                             
MFA-TR*           ,:CS-AMT-AR-CREDIT                                            
MFA-TR*           ,:CS-AMT-CK-ISS-DEBIT                                         
MFA-TR*           ,:CS-AMT-CK-ISS-CREDIT                                        
MFA-TR*           ,:CS-AMT-GL-DEBIT                                             
MFA-TR*           ,:CS-AMT-GL-CREDIT                                            
MFA-TR*           ,:CS-AMT-CASH-BEGIN-BAL                                       
MFA-TR*           ,:CS-AMT-BASIC-WORK                                           
MFA-TR*           ,:CS-USER-ID                                                  
MFA-TR*           ,:CS-CASHIER-CODE                                             
MFA-TR*           ,:CS-CODE-PYMT-FACILITY                                       
MFA-TR*           ,:CS-CODE-FCS-EXTRACTED                                       
MFA-TR*           ,:CS-CODE-CSH-DRWR-STAT                                       
MFA-TR*           ,:CS-DATE-LAST-ACTIVITY                                       
MFA-TR*           ,:CS-BALANCED-BY                                              
MFA-TR*           ,:CS-BALANCED-TS   :WS-NULL-BAL-TS                            
MFA-TR*           ,:CS-NO-ITEMS-ENTERED                                         
MFA-TR*           )                                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8330'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CSH_DRWR_CNTL'       TO TABLE-1                 
              MOVE 'CASH_LOCAL_OFFICE'       TO TABLE-ELEMENT-1         
              MOVE 'DATE_CASH_REPORT'        TO TABLE-ELEMENT-2         
              MOVE 'CASH_DRAWER_ID'          TO TABLE-ELEMENT-3         
              MOVE 'CODE_CSH_DRWR_STAT'      TO TABLE-ELEMENT-4         
              MOVE CS-CASH-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-1       
              MOVE CS-DATE-CASH-REPORT       TO HOSTVAR-ELEMENT-2       
              MOVE CS-CASH-DRAWER-ID         TO HOSTVAR-ELEMENT-3       
              MOVE CS-CODE-CSH-DRWR-STAT     TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       8330-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************12310000
      *                                                                *        
      * 9200-LINK-SCSCA182                                             *12320000
      * CALLS THE SUBPROGRAM SCSCA182 TO RETRIEVE THE LAST UPDATE      *12320000
      * TIMESTAMP FOR THE 'TO' ACCOUNT                                 *12320000
      *                                                                *        
      ******************************************************************12310000
      *                                                                 00322800
       9200-LINK-SCSCA182.                                              
      *                                                                 00322800
           CALL MCSCA182  USING  SCSCA182-ACCOUNT-NO                    
                                ,SCSCA182-RETURN-CODE                   
                                ,SCSCA182-LAST-UPDATE-TS                
                                ,ABEND-FILE.                            
      *                                                                         
       9200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************12310000
      *                                                                *        
      * 9350-LINK-SCSCO061                                             *12320000
      * CALLS THE SUBPROGRAM SCSCO061                                  *12320000
      *                                                                *        
      ******************************************************************12310000
      *                                                                 42860000
       9350-LINK-SCSCO061.                                              
      *                                                                         
           MOVE SPACES                    TO ABEND-FUNCTION.            
      *                                                                         
           CALL MCSCO061  USING  WS-GL-ACCT-NAME                        
                                 WS-GL-ACCT-MAJOR-FIELDS                
                                 WS-VALID-COMPANY-NOS                   
                                 WS-GL-NAME-INFO                        
                                 WS-GL-ACCT-NO-TABLE                    
                                 ABEND-FILE                             
                                 RS-RETURN-CODE.                        
      *                                                                         
           MOVE RS-RETURN-CODE   TO WS-ACTIVE-RETURN-CODE               
                                    S-RETURN-CODE                       
                                    SQLCODE.                            
      *                                                                         
           IF ABEND-FUNCTION  > SPACES                                  
              IF ABEND-FUNCTION EQUAL 'BADDATA'                         
                 MOVE -1         TO RS-RETURN-CODE                      
                                    S-RETURN-CODE                       
                                    WS-ACTIVE-RETURN-CODE               
              END-IF                                                    
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       9350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************12310000
      *                                                                *        
      * CPD0023C                                                       *12320000
      * 9700-PROCESS-ABEND                                             *12320000
      *                                                                *        
      ******************************************************************12310000
      *                                                                         
           EXEC SQL                                                     14890000
              INCLUDE CPD0023C                                          14900000
           END-EXEC.                                                    14910000
      *                                                                         
      ******************************************************************12310000
      *                                                                *        
      * CPDSP300                                                       *12320000
      * 9900-SQL-ERROR-ROUTINE                                         *12320000
      * 9975-ABEND-CONTROL-TRANSFER                                    *12320000
      *                                                                *        
      ******************************************************************12310000
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************14930000
      *                                                                *        
      * CPD00320                                                       *14940000
      * 8900-SEND-DONE                                                 *14940000
      * 9000-SEND-ERROR-RESULT                                         *14940000
      * 9999-END-PROGRAM                                               *14940000
      *                                                                *        
      ******************************************************************14950000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00320                                                 
           END-EXEC.                                                            
      *                                                                         
