       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04873.                                         
       DATE-WRITTEN.   OCT 2015.                                        
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                         
      * USED TO PERFORM REVENUE ADJUSTMENT TRANSACTIONS WHICH MAY               
      * INCLUDE: CANCELING A GIVEN BILL(S), CANCELING AND REBILLING A           
      * GIVEN BILL(S), CREATING BILLING INFORMATION, CHANGING PENDING,          
      * UNBILLED BILLING INFORMATION OR DELETING PENDING, UNBILLED              
      * INFORMATION.  THE TYPES OF INFORMATION WHICH MAY BE UPDATED             
      * VARIES WITH THE TYPE OF UTILITY BILL MANAGEMENT BEING PERFORMED.        
      *                                                                         
      *             ---- BASIC SEQUENCE STRUCTURE ----                          
      *    SEQ #  NAME                          FUNCTION                        
      *    ---- ------------------------- ------------------------------        
      *    0000 MAINLINE                  CONTROLS PROGRAM FLOW                 
      *    0100 INITIALIZATION            INITIALIZES FIELDS - ISSUES           
      *                                    CONTROL EXECS                        
      *    0102 ESCAPE                    HANDLES ESCAPE REQUEST                
      *    1000 PROCESS INPUT             CONTROLS INPUT EDIT                   
      *    2000 PROCESS OUTPUT            CONTROLS OUTPUT REQUESTS              
      *    9001 TERMINATE TO CICS         RETURNS CONTROL TO CICS               
      *    9900 ABEND                     ISSUES A CICS ABEND COMMAND           
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  10/15/15  NARASIMHA  NEW PROCEDURE                            *        
TEMP  *  05/06/16  HEMA       MOVING C AS CODE SOURCE ID FOR CX UPDATE *        
A05460*  06/14/16  HEMA       FIXED MIN-MAX VALIDATION ISSUE AND       *        
      *                       MANUAL CALC ISSUE WITH CODE UTIL TYPE    *        
A05460*  06/24/16  HEMA       CHANGED TRANSACTION HIST ARRAY SIZE FROM *        
      *                       50 TO 75 TO 300.                         *        
ACT004*  07/07/16  TP7R341    REMOVING UNWANTED COLUMNS OF THE TABLE   *        
ACT004*            A04177     CSS_SPCL_FCTR                            *        
A05460*  07/29/16  HEMA       ADD TEMPORARY FIX TO MOVE CORRECT RATE   *        
      *                       PLAN # FOR SEB ACCT.                     *        
A05460*  08/08/16  HEMA       MADE CODE CHANGE IN 5910- PARA TO FIX    *        
      *                       S0C7 ISSUE.                              *        
A05460*  08/19/16  HEMA       ADDED LOGIC TO INSERT UC DETAILS FOR     *        
      *                       MANUAL CALC ENTRIES.                     *        
A05460*  08/22/16  HEMA       ADDED LOGIC TO UPDATE MN ENTRY BASED ON  *        
      *                       CODE USAGE TYPE, USAGE ID & TIME PERIOD  *        
      *                       FOR PERMANENT UPDATE SCENARIO.           *        
A05460*  09/07/16  HEMA       CHANGED TRANSACTION HISTORY TEXT FOR     *        
      *                       CX/IDR CHECKBOX AND ADDED ORDER BY IN CX *        
      *                       CURSOR TO AVOID -803 IN CSS_INTERVAL_READ*        
A05460*  09/30/16  HEMA       ADDED LOGIC TO UPDATE FACTOR CODE DEBIT  *        
      *                       CREDIT IN UPDATE MODE.                   *        
A05460*  10/04/16  HEMA       INCREASED BG ROW COUNT FROM 12 TO 15.    *        
      *                       GET BG BTU FACTOR FROM BILL CORRECTION   *        
      *                       SCREEN.                                  *        
A05460*  10/13/16  HEMA       ADDED LOGIC TO UPDATE CODE TOU SEASON IN *        
      *                       CX TABLE IN UPDATE MODE.                 *        
      *                                                                *        
A05744** 01/18/17  NC94746    FRONT-END NOT SETTING UNMETER IC FLAG,   *        
A05744**                      FIXING ISSUE IN BACK-END.                *        
AA5744** 02/21/17  NC94746    GAS BASE USE FIELD ADDED IN ORDER TO EDIT*        
AA5744**                      THROUGH BILL CORRECTION APP.             *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04873'.
MSQ017     COPY MFASQLM.
       01  WS-START                    PIC X(40)                        
           VALUE 'WORKING STORAGE FOR CSR04873 STARTS HERE'.            
       01  PROGRAM-NAME                PIC X(08) VALUE 'CSR04873'.      
                                                                        
       COPY CWS00031.                                                           
       COPY CWS00100.                                                           
       COPY CWS00303.                                                           
       COPY CWSCA190.                                                           
                                                                        
       COPY CCA00003.                                                           
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(09) COMP VALUE 0.         
           05  WS-ROW-COUNT            PIC S9(09) COMP VALUE ZERO.      
           05  WS-MN-AWAITING-RD-COUNT PIC S9(04) COMP VALUE ZERO.      
           05  WS-RG-AWAITING-RD-COUNT PIC S9(04) COMP VALUE ZERO.      
                                                                        
       01  NULL-INDICATORS.                                             
           05  WS-NULL-INDICATOR       PIC S9(04) COMP VALUE +0.        
           05  WS-IDR-INFO-NULL-IND    PIC S9(04) COMP VALUE +0.        
           05  WS-DURATION-NULL        PIC S9(04) COMP VALUE +0.        
           05  WS-OVRD-BILL-DT-NULL    PIC S9(04) COMP VALUE +0.        
           05  WS-DATE-ORIG-BILL-NULL1 PIC S9(04) COMP VALUE 0.         
           05  WS-DATE-ORIG-BILL-NULL2 PIC S9(04) COMP VALUE 0.         
           05  WS-DATE-ORIG-BILL-NULL3 PIC S9(04) COMP VALUE 0.         
           05  WS-TEMP-ORIG-BILL-NULL  PIC S9(04) COMP VALUE 0.         
           05  WS-DURATION-REMAIN-NULL PIC S9(04) COMP VALUE +0.        
           05  WS-RT-PKG-NULL          PIC S9(04) COMP VALUE +0.        
           05  IND-DEF-DUR-REM-NO      PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-1               PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-2               PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-3               PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-4               PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-5               PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-6               PIC S9(04) COMP VALUE +0.        
                                                                        
       01 WS-TEMP-FIELDS.                                               
          05  WS-RES-MIN-CD            PIC X(15)  VALUE 'RES-MIN-DDC'.  
          05  WS-RES-MAX-CD            PIC X(15)  VALUE 'RES-MAX-DDC'.  
          05  WS-COM-MIN-CD            PIC X(15)  VALUE 'COM-MIN-DDC'.  
          05  WS-COM-MAX-CD            PIC X(15)  VALUE 'COM-MAX-DDC'.  
          05  WS-RES-MIN-DDC           PIC S9(08)V9999.                 
          05  WS-RES-MAX-DDC           PIC S9(08)V9999.                 
          05  WS-COM-MIN-DDC           PIC S9(08)V9999.                 
          05  WS-COM-MAX-DDC           PIC S9(08)V9999.                 
          05  WS-HOLD-FACT-VAL-RED     PIC S9(9)V9(6).                  
COB305    05 WS-OVRRIDE-RT-REV-MTH        PIC S9(06) COMP-3 VALUE 0.            
          05  WS-SPECIAL-PROCESS-CD    PIC X(02).                       
          05  WS-ADJ-TYPE-CD           PIC X(04).                       
          05  WS-BP-ADJ-TYPE-CD.                                        
             15 WS-BP-ADJ-TYPE-CD1     PIC X(04).                       
             15 WS-BP-ADJ-TYPE-CD2     PIC X(04).                       
          05 WS-AMT-BILL-ITEM-CHAR.                                     
             10 WS-AMT-BILL-ITEM-SIGN  PIC X(01).                       
             10 WS-AMT-BILL-ITEM-NUM   PIC 9(11).                       
          05 WS-AMT-BILL-TAX-CHAR.                                      
             10 WS-AMT-BILL-TAX-SIGN   PIC X(01).                       
             10 WS-AMT-BILL-TAX-NUM    PIC 9(09).                       
          05 WS-USAGE-FIXED-CHAR.                                       
             10 WS-USAGE-FIXED-SIGN    PIC X(01).                       
             10 WS-USAGE-FIXED-NUM     PIC 9(09).                       
          05 WS-FACTOR-VALUE-CHAR.                                      
             10 WS-FACTOR-VALUE-SIGN   PIC X(01).                       
             10 WS-FACTOR-VALUE-NUM    PIC 9(15).                       
          05 WS-FACTOR-VALUE           PIC S9(15).                      
          05 WS-FACTOR-VALUE-RED       REDEFINES WS-FACTOR-VALUE        
                                       PIC S999999999V999999.           
A05460    05 WS-BG-BTU-FACTOR-Z        PIC ZZ.Z(05).                    
A05460    05 WS-BG-BTU-FACTOR          PIC 9(07).                       
A05460    05 WS-BG-BTU-FACTOR-RED      REDEFINES WS-BG-BTU-FACTOR       
A05460                                 PIC 99V99999.                    
          05 WS-NO-UNITS-CHAR.                                          
             10 WS-NO-UNITS-SIGN       PIC X(01).                       
             10 WS-NO-UNITS-NUM        PIC 9(08).                       
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-BUS-RULE-ID          PIC X(10) VALUE SPACES.          
           05  RS-BUS-RESULT-CD        PIC X(08) VALUE SPACES.          
           05  RS-BUS-RULE-XREF-ID     PIC X(26) VALUE SPACES.          
                                                                        
       01 GTT-RETURN-FIELDS.                                            
           05   S-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
       01 GTT-RETURN-FIELDS1.                                           
           05   S-BUS-RULE-ID          PIC X(10) VALUE SPACES.          
           05   S-BUS-RESULT-CD        PIC X(08) VALUE SPACES.          
           05   S-BUS-RULE-XREF-ID     PIC X(26) VALUE SPACES.          
       01  WS-WORK-AREA.                                                
           05  WS-APPL-PROGRAM-ID      PIC X(08) VALUE SPACES.          
           05  WS-DATE-LAST-ACTION-NULL PIC S9(4) COMP.                 
           05  WS-ACCT-FINALED-DT-NULL PIC S9(4) COMP.                  
           05  WS-TRAN-COMMENT-LEN     PIC S9(4) COMP.                  
           05  WS-TRAN-COMMENT-TEXT    PIC X(210) VALUE SPACES.         
           05  WS-PARM-COMMENT-LEN     PIC S9(04)  COMP VALUE ZERO.     
           05  WS-LAST-UPDATE-TS       PIC X(26).                       
           05  WS-CURRENT-TIME         PIC X(08) VALUE '00.00.00'.      
           05  WS-PRV-LEN              PIC S9(4) COMP.                  
           05  WS-CHG-LEN              PIC S9(4) COMP.                  
           05  WS-PRV-TEXT             PIC X(75) VALUE SPACES.          
           05  WS-CHG-TEXT             PIC X(75) VALUE SPACES.          
           05  WS-DATE-USAGE-ENDS-NULL PIC S9(4) COMP.                  
           05  WS-DATE-READ-NULL       PIC S9(4) COMP.                  
           05  WS-TOT-NO-DAYS          PIC S9(4) COMP.                  
           05  WS-EFF-DATE-FROM-NULL   PIC S9(4) COMP.                  
           05  WS-EFF-DATE-TO-NULL     PIC S9(4) COMP.                  
COB305     05 WS-MIN-REV-MTH        PIC S9(6) COMP-3 VALUE 0.                
           05  WS-MIN-REV-MTH-NUM      PIC 9(8).                        
           05  WS-MIN-REV-MTH-WRK      PIC X(6).                        
           05  WS-SUB                  PIC S9(04) COMP.                 
           05  WS-RESP-AREA-ID         PIC X(03).                       
           05  WS-TBL-SUB              PIC 9(02) COMP.                  
           05  WS-TRAN-BREAKDOWN       PIC X(04).                       
               88  UM20-INITIATED              VALUE 'UM20'.            
           05  WS-OFF-CYCLE-SW         PIC X(01).                       
           05  WS-REBILLS-GONE-SW      PIC X(01) VALUE 'N'.             
               88 ALL-REBILLS-GONE             VALUE 'Y'.               
           05  WS-JUMP-TO-END-SW       PIC X(01) VALUE 'N'.             
               88 JUMP-TO-END                    VALUE 'Y'.             
           05  WS-NOTHING-ENTERED      PIC X(01).                       
               88  NOTHING-ENTERED               VALUE 'Y'.             
           05  WS-UNMETERED-TYPE       PIC X(01) VALUE SPACE.           
           05  WS-CUST-PLAN-SW         PIC X(01) VALUE 'N'.             
               88  HAS-CUST-PLAN                 VALUE 'Y'.             
           05  WS-PENDING-NEXT-SW      PIC X(01) VALUE 'N'.             
               88  PENDING-NEXT-BILL             VALUE 'Y'.             
           05  WS-HAS-AR               PIC X(01) VALUE 'N'.             
               88  HAS-AR                        VALUE 'Y'.             
           05  WS-INTRO-FCTR-EXISTS    PIC X(01) VALUE 'N'.             
               88 INTRO-FCTR-EXISTS              VALUE 'Y'.             
           05  WS-DATABASE             PIC 9(01) VALUE ZERO.            
               88  CSR-DATABASE                  VALUE 1.               
               88  SEB-DATABASE                  VALUE 2.               
           05  WS-TEST-UTIL            PIC X(01).                       
               88  VALID-UTIL-TYPE    VALUES 'E', 'G', 'U', 'W', 'S'.   
           05  WS-CODE-TRAN            PIC X(04).                       
               88  VALID-CODE-TRAN VALUES '    ', 'UTIL', 'PGAS',       
                                         'SGAS', 'IGAS'.                
           05  WS-FOUND-BILL-DET       PIC X(01) VALUE 'N'.             
               88  BILL-DET-IS-FOUND             VALUE 'Y'.             
           05  WS-LAST-NORM-BILL-FOUND PIC X(01) VALUE 'N'.             
               88  LAST-NORM-BILL-FOUND              VALUE 'Y'.         
           05  ALL-DONE-SW                 PIC X(01) VALUE 'N'.         
               88 NOT-ALL-DONE                       VALUE 'N'.         
               88 ALL-DONE                           VALUE 'Y'.         
           05  SEND-DONE-SW                PIC X(01) VALUE 'Y'.         
               88 SEND-DONE-ERROR                    VALUE 'N'.         
               88 SEND-DONE-OK                       VALUE 'Y'.         
           05  WS-DO-NOT-JOURNAL-SW        PIC X(01) VALUE 'N'.         
               88  DO-JOURNAL                        VALUE 'Y'.         
           05  WS-RATE-NO-CHECK.                                        
               10  WS-RATE-UTIL-TYPE       PIC X(01).                   
               10  WS-RATE-NO              PIC 9(03).                   
           05  WS-UTILITY-TYPE.                                         
               10  FILLER                  PIC X(07) VALUE 'UTLTYPE'.   
               10  WS-UTLTYPE              PIC X(01) VALUE SPACE.       
           05  WS-ACCOUNT-BILL-CODES.                                   
               10  WS-READY                PIC X(01) VALUE 'R'.         
               10  WS-AWAITING-CHECK-READ  PIC X(01) VALUE 'U'.         
               10  WS-HOLD-NO-READING      PIC X(01) VALUE 'H'.         
               10  WS-HOLD-READ-POSTED     PIC X(01) VALUE 'B'.         
               10  WS-ACCT-HAS-BILLED      PIC X(01) VALUE 'Y'.         
           05  WS-USAGE-VALUE.                                          
               10  WS-CODE-USAGE-TYPE      PIC X(01).                   
               10  WS-CODE-USAGE-ID        PIC X(01).                   
               10  WS-CODE-USAGE-SOURCE    PIC X(01).                   
           05  WS-RATE-SIC.                                             
               10  WS-RATE-TYPE-2          PIC X(01).                   
               10  WS-REVENUE-CLASS-2      PIC 9(03).                   
               10  WS-CODE-SIC-NO-G-2      PIC 9(04).                   
           05  WS-CODE-SIC-NO-G            PIC 9(04).                   
           05  FILLER REDEFINES WS-CODE-SIC-NO-G.                       
               10  WS-SIC-NO-1ST-2         PIC 9(02).                   
               10  WS-SIC-NO-2ND-2         PIC 9(02).                   
           05  WS-ADD-FLAG                 PIC X(01) VALUE SPACES.      
           05  WS-METER-NO-HOLD            PIC X(09) VALUE SPACES.      
                                                                        
           05  WS-UMMETER-SERVICE          PIC X(01) VALUE 'N'.         
           05  WS-BILLED-REV-YR            PIC 9(04).                   
           05  WS-BILLED-REV-MN            PIC 9(02).                   
           05  WS-WORK-REV-MTH             PIC S9(06).                  
           05  WS-DASH                     PIC X(01) VALUE '-'.         
           05  WS-AMT-BILL-ITEM.                                        
               10  WS-BILL-AMT-INT         PIC 9(09).                   
               10  WS-BILL-AMT-DEC         PIC 9(02).                   
           05  WS-AMT-BILL-ITEM-EDT.                                    
               10  WS-BILL-AMT-INT-EDT     PIC ZZZ,ZZZ,ZZ9.             
               10  WS-BILL-AMT-DEC-EDT     PIC 9(02).                   
           05  WS-READ-DIF                 PIC S9(07)V9(03).            
           05  WS-NO-OF-UNITS-DIF          PIC S9(07)V9(04).            
           05  WS-TOTAL-TAX                PIC S9(07)V99 VALUE ZERO.    
           05  WS-HOLD-TRAN-STATUS         PIC X(01).                   
           05  WS-HOLD-COMPANY-NO          PIC X(02) VALUE ZEROS.       
           05  WS-HOLD-TENANT-NO           PIC 9(03) VALUE ZERO.        
           05  WS-SAVE-TENANT-NO           PIC 9(04) VALUE ZERO.        
           05  WS-HOLD-SEQ-NO              PIC 9(03) VALUE ZERO.        
           05  WS-HOLD-DUP-CNTRL-NO        PIC 9(01) VALUE ZERO.        
           05  WS-HOLD-LAST-TRAN-NO        PIC 9(03) VALUE ZERO.        
           05  WS-NO-OF-BILL-ADDED         PIC 9(03) VALUE ZERO.        
           05  WS-ORIG-BILL-DATE           PIC 9(09).                   
           05  WS-NUM-2-SHIFT-2-HIGH       PIC S9(09) USAGE COMP.       
           05  WS-NUM-SHIFT-FROM           PIC S9(09) USAGE COMP.       
           05  WS-RBI-HOOK-SW              PIC X(01) VALUE SPACES.      
               88 RBI-HOOK-NOT-EXISTS                VALUE ' '.         
               88 RBI-HOOK-EXISTS                    VALUE 'Y'.         
           05  WS-RBF-HOOK-SW              PIC X(01) VALUE SPACES.      
               88 RBF-HOOK-NOT-EXISTS                VALUE ' '.         
               88 RBF-HOOK-EXISTS                    VALUE 'Y'.         
           05  WS-BG-CHNGS-SW              PIC X(01) VALUE SPACES.      
               88 BG-CHNGS-NOT-EXISTS                VALUE ' '.         
               88 BG-CHNGS-EXISTS                    VALUE 'Y'.         
           05  WS-HOOK-INDICATOR           PIC X(01).                   
               88 WS-HOOK-IS-BEING-CREATED VALUE 'Y'.                   
           05  WS-OC-EXISTS                PIC X(01) VALUE SPACES.      
           05  WS-DELETE-OFFCYC            PIC X(01) VALUE SPACES.      
           05  WS-ACCT-NO                  PIC S9(13)V.                 
           05  WS-TIME-OF-DAY              PIC 9(06).                   
           05  WS-TIME-OF-DAY-RED      REDEFINES WS-TIME-OF-DAY.        
               10  WS-TIME.                                             
                   15  WS-HOUR             PIC 9(02).                   
                   15  WS-MINUTE           PIC 9(02).                   
               10  FILLER                  PIC 9(02).                   
           05  WS-DEM-CORRECTED-READ       PIC 9(10).                   
           05  WS-LAST-READ                PIC 9(07)V9(03).             
           05  WS-LAST-READ-NUM REDEFINES WS-LAST-READ                  
                                           PIC 9(10).                   
           05  FILLER REDEFINES WS-LAST-READ.                           
               10  WS-LST-READ             PIC 9(07).                   
               10  WS-LST-READ-DEC         PIC 9(03).                   
           05  WS-FORMATTED-DATE-BREAKOUT.                              
               10  WS-FORMAT-CC           PIC 9(02).                    
               10  WS-FORMAT-YY           PIC 9(02).                    
               10  FILLER                 PIC X(01) VALUE '-'.          
               10  WS-FORMAT-MM           PIC 9(02).                    
               10  FILLER                 PIC X(01) VALUE '-'.          
               10  WS-FORMAT-DD           PIC 9(02).                    
           05  WS-FORMATTED-DATE REDEFINES WS-FORMATTED-DATE-BREAKOUT   
                                          PIC X(10).                    
           05  WS-TRAN-DATE-BREAKOUT.                                   
               10  WS-TRAN-DATE-CC        PIC 9(02).                    
               10  WS-TRAN-DATE-YY        PIC 9(02).                    
               10  WS-TRAN-DATE-MM        PIC 9(02).                    
               10  WS-TRAN-DATE-DD        PIC 9(02).                    
           05  WS-TRAN-DATE REDEFINES WS-TRAN-DATE-BREAKOUT             
                                          PIC 9(08).                    
           05  WS-NO-OF-UNITS              PIC 9(07)V9(04).             
           05  FILLER REDEFINES WS-NO-OF-UNITS.                         
               10  WS-NO-UNITS             PIC 9(07).                   
               10  WS-NO-UNITS-DEC         PIC 9(04).                   
           05  WS-ELEC-DEM-FACTOR          PIC 9(07)V9(04).             
           05  FILLER REDEFINES WS-ELEC-DEM-FACTOR.                     
               10  WS-ELEC-DEM-FACT        PIC 9(07).                   
               10  WS-ELEC-DEM-FACT-INT    PIC 9(04).                   
           05  WS-ITEM-STAT-SOURCE-ID.                                  
               10  WS-CODE-ITEM-STATUS     PIC X(01).                   
               10  WS-CODE-SOURCE-ID       PIC X(01).                   
           05  WS-HOLD-CURRENT-DATE        PIC 9(09).                   
           05  WS-CURRENT-TIMESTMP         PIC X(26) VALUE SPACES.      
           05  WS-CURRENT-DATE             PIC X(10) VALUE SPACES.      
           05  WS-CURRENT-DATE1            PIC X(10) VALUE SPACES.      
           05  WS-IC-NO                    PIC 9(03).                   
           05  WS-BILL-DATE-HOLD           PIC X(10).                   
           05  WS-DB2-DATE                 PIC X(10).                   
           05  WS-DB2-TIME.                                             
               10  WS-DB2-TIME-HH          PIC X(02).                   
               10  FILLER                  PIC X(01) VALUE '.'.         
               10  WS-DB2-TIME-MM          PIC X(02).                   
               10  FILLER                  PIC X(01) VALUE '.'.         
               10  WS-DB2-TIME-SS          PIC X(02).                   
           05  WS-BILL-KEYS                  PIC X(09).                 
           05  FILLER REDEFINES WS-BILL-KEYS.                           
               10  WS-BILL-NO                PIC 9(09).                 
           05  WS-HIST-KEYS.                                            
               10  WS-CODE-TIME-PERIOD       PIC X(01) VALUE SPACE.     
               10  WS-CODE-USAGE-VALUES-SAVE.                           
                   15 WS-SAVE-TYPE           PIC X(01).                 
                   15 WS-SAVE-ID             PIC X(01).                 
                   15 WS-SAVE-SOURCE         PIC X(01).                 
               10  WS-TABLE-TO-ACCESS        PIC X(01) VALUE SPACE.     
               10  WS-MTR-REF-NO             PIC 9(04).                 
               10  WS-MTR-REF-NO-REDEF REDEFINES WS-MTR-REF-NO.         
                   15  WS-FILLER             PIC 9(01).                 
                   15  WS-PRI-SEQ-NO         PIC 9(03).                 
               10  WS-ITEM-SEQ-NO            PIC 9(03).                 
           05  WS-OTHER-IC-NO                PIC S9(4)  COMP.           
           05  WS-RB-BILL-NO                 PIC S9(09) COMP.           
           05  WS-RBI-BILL-NO                PIC S9(09) COMP.           
           05  WS-RBF-BILL-NO                PIC S9(09) COMP.           
           05  WS-BILL-NO1                   PIC S9(09) COMP.           
           05  SHFT-FROM-BILL-NO             PIC S9(09) COMP.           
           05  SHFT-TO-BILL-NO               PIC S9(09) COMP.           
           05  WS-SAVE-BILL-NO               PIC S9(09) COMP.           
           05  WS-HOLD-BILL-NO               PIC S9(09) COMP.           
           05  WS-RBI-BILL-CORRECTED-CD      PIC X(1) VALUE ' '.        
           05  WS-ORIG-BG-TIMESTMP           PIC X(26).                 
           05  WS-BILL-ITEM-TIMESTMP         PIC X(26).                 
           05  WS-BILL-ITEM-TIMESTMP1        PIC X(26).                 
           05  WS-RB-ITEM-TIMESTMP           PIC X(26).                 
           05  WS-MTR-READ-SOURCE-CD         PIC X(01) VALUE ' '.       
           05  WS-HOLD-PRI-SEQ-NO            PIC 9(03).                 
           05  WS-MN-STATUS                  PIC X(01).                 
               88  WS-MN-FOUND               VALUE 'Y'.                 
           05  WS-BTU-DT-MM                  PIC S9(4) USAGE COMP.      
           05  WS-BTU-DT-YY                  PIC S9(9) USAGE COMP.      
COB305     05 WS-AVG-BTU-FACTOR        PIC S9(2)V9(5) COMP-3 VALUE 0.     
           05  WS-CIG-CUSTOMER               PIC X(01).                 
           05  WS-NET-MTR-CUSTOMER           PIC X(01).                 
           05  WS-FACTOR-HISTORY-CD          PIC X(01) VALUE 'N'.       
           05  WS-PARM-REVENUE-MONTH.                                   
               10 WS-PARM-REV-YEAR           PIC 9(04).                 
               10 WS-PARM-REV-MONTH          PIC 9(02).                 
           05  WS-PARM-REV-MONTH-N           REDEFINES                  
                 WS-PARM-REVENUE-MONTH       PIC 9(06).                 
           05  WS-BEG-BILL-DT                PIC X(10).                 
           05  WS-END-BILL-DT                PIC X(10).                 
           05  WS-TIMESTMP                   PIC X(26).                 
           05  WS-811                        PIC S9(9) VALUE -811 COMP. 
           05  WS-CODE-UTIL-TYPE-DESC        PIC X(18).                 
           05  WS-XMT-CODES.                                            
               10 WS-CODE-DISC-OK            PIC X VALUE SPACE.         
               10 WS-NOTICE-EXEMPT-CD        PIC X VALUE SPACE.         
               10 WS-CODE-LPC-XMT            PIC X VALUE SPACE.         
               10 WS-IVR-EXEMPT-CD           PIC X VALUE SPACE.         
           05 WS-XMT-SWITCHES.                                          
              10 DISC-OK-CHANGED-SW         PIC X VALUE ' '.            
                 88 NO-DISC-OK-CHANGED            VALUE ' '.            
                 88 DISC-OK-CHANGED               VALUE 'Y'.            
              10 EXEMPT-CD-CHANGED-SW       PIC X VALUE ' '.            
                 88 NO-EXEMPT-CD-CHANGED          VALUE ' '.            
                 88 EXEMPT-CD-CHANGED             VALUE 'Y'.            
              10 LPC-XMT-CHANGED-SW         PIC X VALUE ' '.            
                 88 NO-LPC-XMT-CHANGED            VALUE ' '.            
                 88 LPC-XMT-CHANGED               VALUE 'Y'.            
              10 IVR-EXEMPT-CHANGED-SW      PIC X VALUE ' '.            
                 88 NO-IVR-EXEMPT-CHANGED         VALUE ' '.            
                 88 IVR-EXEMPT-CHANGED            VALUE 'Y'.            
           05  WS-AT-UPDATE-REQ-SW           PIC X(1) VALUE 'N'.        
               88 WS-AT-UPDATE-REQUIRE                VALUE 'Y'.        
               88 WS-AT-UPDATE-NOT-REQUIRE            VALUE 'N'.        
           05  WS-AGLMTCHRG-FCTR-ID        PIC X(09)  VALUE 'AGLMTCHRG'.
           05  WS-AGL-TRANS-TEXT           PIC X(29)  VALUE             
                          '; AGL METER READ CHARGE ADDED'.              
           05  WS-AGL-TRANS-TEXT1          PIC X(29).                   
           05  WS-AGL-FCTR-EFF-DT          PIC X(10) VALUE SPACES.      
           05  WS-AGL-FACTOR               PIC S9(9)V9(4) COMP-3        
                                                     VALUE 0.           
           05  WS-PRV-FACTOR               PIC S9(9)V9(6) COMP-3        
                                                     VALUE 0.           
           05  WS-PRV-FACTOR-FLG           PIC X(01) VALUE 'Y'.         
           05  WS-REV-MONTH-TEMP           PIC X(06) VALUE  SPACES.     
           05  WS-AGL-DELINQ-FLG           PIC X(06) VALUE  'Y'.        
           05  WS-AGL-INS-FLG              PIC X(01) VALUE SPACES.      
           05  WS-AGL-UPD-FLG              PIC X(01) VALUE  SPACES.     
           05  WS-FF-FLG                   PIC X(01) VALUE  SPACES.     
           05  WS-FH-FLG                   PIC X(01) VALUE  SPACES.     
           05  WS-FACTOR-TEXT          PIC 9(9).9(4).                   
           05  WS-FACT-VAL-Z           PIC -Z(09).9(06).                
           05  WS-PRV-FACTOR-VALUE     PIC 9(15).                       
           05  WS-PRV-FACTOR-VALUE-RED REDEFINES WS-PRV-FACTOR-VALUE    
                                       PIC 999999999V999999.            
           05  WS-PRV-FACTOR-TEXT      PIC 9(9).9(6).                   
           05  WS-PRV-FACT-VAL-Z       PIC -Z(09).9(06).                
           05  WS-SPL-MSG-NEW-POS      PIC 9(04) VALUE 0.               
           05  WS-FACTOR-TRANS-HIST    PIC S9(9)V9(4) USAGE COMP-3      
                                       VALUE 0.                         
           05  WS-EFF-DATE-FROM        PIC X(10) VALUE SPACES.          
           05  WS-EFF-DATE-TO          PIC X(10) VALUE SPACES.          
           05  WS-DURATION-REMAIN-NO   PIC S9(4) USAGE COMP.            
           05  WS-OFF-CYCLE-ACCT-IND   PIC X(01) VALUE SPACES.          
           05  WS-FACTOR-FF            PIC S9(09)V9(06) USAGE COMP-3    
                                         VALUE 0.                       
           05  WS-FACTOR-FH            PIC S9(09)V9(06) USAGE COMP-3    
                                         VALUE 0.                       
                                                                        
           05 WS-VALUE-1               PIC X(16) VALUE                  
                                       'Copy CX/copy IDR'.              
           05 WS-VALUE-2               PIC X(23) VALUE                  
                                       'Do not copy CX/copy IDR'.       
A05460     05 WS-VALUE-3               PIC X(30) VALUE                  
A05460                                 'Do not copy CX/Do not copy IDR'.
A05460     05 WS-CHG-COLUMN-VALUE-TEXT PIC X(30) VALUE SPACES.          
A05460     05 WS-FH-FIXED-FCTR-SEQ-NO  PIC S9(4) USAGE COMP.            
                                                                        
       01  WS-RECORD-FIELD-DESC.                                        
           05  FILLER                      PIC X(01)   VALUE SPACES.    
           05  WS-TRAN-TYPE                PIC X(02).                   
           05  FILLER                      PIC X(01)   VALUE SPACES.    
           05  WS-BILL-DATE.                                            
               10  WS-BILL-MM              PIC X(02).                   
               10  WS-BILL-DD              PIC X(02).                   
               10  WS-BILL-YY              PIC X(02).                   
           05  FILLER                      PIC X(01)   VALUE SPACES.    
           05  WS-TRAN-AMT                 PIC ZZZZ,ZZ9.99-.            
       01  WS-TRAN-DESCRIPTION.                                         
           05  FILLER                      PIC X(18)                    
                                           VALUE 'ADJ REASON CODE - '.  
           05  WS-ADJ-CODE                 PIC X(04)   VALUE SPACES.    
       01  WS-TRAN-COMM-DESC.                                           
           05  WS-CODE-BILL-CALC-DESC      PIC X(09)   VALUE SPACES.    
           05  WS-TAX-REF-CODE-DESC        PIC X(15)   VALUE SPACES.    
           05  WS-BILL-WHEN-DESC           PIC X(13)   VALUE SPACES.    
       01  WS-TRAN-DESC-112.                                            
           05  WS-TRAN-STAT                PIC X(01).                   
           05  FILLER                      PIC X(03)   VALUE ' - '.     
           05  WS-TRAN-STAT-DESC           PIC X(22).                   
       01  WS-LITERALS.                                                 
           05  WS-19                       PIC S9(04)  COMP VALUE +19.  
           05  WS-20                       PIC S9(04)  COMP VALUE +20.  
           05  WS-1                        PIC 9(04)   VALUE 1.         
           05  WS-A                        PIC X(01)   VALUE 'A'.       
           05  WS-B                        PIC X(01)   VALUE 'B'.       
           05  WS-C                        PIC X(01)   VALUE 'C'.       
           05  WS-D                        PIC X(01)   VALUE 'D'.       
           05  WS-G                        PIC X(01)   VALUE 'G'.       
           05  WS-J                        PIC X(01)   VALUE 'J'.       
           05  WS-E                        PIC X(01)   VALUE 'E'.       
           05  WS-Q                        PIC X(01)   VALUE 'Q'.       
           05  WS-K                        PIC X(01)   VALUE 'K'.       
           05  WS-O                        PIC X(01)   VALUE 'O'.       
           05  WS-S                        PIC X(01)   VALUE 'S'.       
           05  WS-U                        PIC X(01)   VALUE 'U'.       
           05  WS-YES                      PIC X(01)   VALUE 'Y'.       
           05  WS-PBP                      PIC X(03)   VALUE 'PBP'.     
           05  WS-SBP                      PIC X(03)   VALUE 'SBP'.     
           05  WS-CREATE                   PIC X(06)   VALUE 'CREATE'.  
           05  WS-CANCEL                   PIC X(06)   VALUE 'CANCEL'.  
           05  WS-CHANGE                   PIC X(06)   VALUE 'CHANGE'.  
           05  WS-UPDATE                   PIC X(06)   VALUE 'UPDATE'.  
           05  WS-DELETE                   PIC X(06)   VALUE 'DELETE'.  
           05  WS-ACTIVE                   PIC X(06)   VALUE 'ACTIVE'.  
           05  WS-BACKOUT                  PIC X(07)   VALUE 'BACKOUT'. 
           05  WS-ACTIVE-DESC              PIC X(05)   VALUE 'ACTIV'.   
           05  WS-BACKOUT-DESC             PIC X(05)   VALUE 'BKOUT'.   
           05  WS-CANCEL-DESC              PIC X(05)   VALUE 'CANCL'.   
           05  WS-INTRO-VAR-FCTR           PIC X(02)   VALUE 'IN'.      
           05  WS-CANCEL-CLERICAL          PIC X(21)   VALUE            
                'CANCEL,CLERICAL ERROR'.                                
           05  WS-CANCEL-CALC              PIC X(22)   VALUE            
                'CANCEL,BILL CALC ERROR'.                               
COB305     05 WS-SUMM-ACCT-NO        PIC S9(13)V COMP-3 VALUE 0.          
           05  MCSCA182                    PIC X(08) VALUE 'MCSCA182'.  
           05  MCSCB190                    PIC X(08)   VALUE 'MCSCB190'.
           05  WS-MSG-LITERAL-LEN          PIC S9(04) COMP VALUE +24.   
           05  WS-MSG-LITERAL.                                          
               10 FILLER                   PIC X(16)                    
                                             VALUE 'CURRENT MONTH + '.  
               10 WS-MSG-MONTHS            PIC X VALUE SPACE.           
               10 FILLER                   PIC X(7) VALUE ' MONTHS'.    
           05  WS-CR-MIN-REV-MTH           PIC X(14)                    
                                             VALUE 'CR-MIN-REV-MTH'.    
A05460     05  WS-CURRENT                  PIC X(01)   VALUE 'C'.       
      *                                                                         
       01  WS-BTU-FACTOR-DEC               PIC S9(07)V9(05) USAGE COMP-3
                                           VALUE 0.                     
       01  WS-END                       PIC X(40)                       
           VALUE 'WORKING STORAGE FOR CSR04873 ENDS HERE '.             
HPCCDM*    EJECT                                                                
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
      *    CSS_SPCL_FCTR, SF                                                    
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBSPLFTR                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
           EXEC SQL                                                             
               INCLUDE TBARCNTL                                                 
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
           EXEC SQL                                                             
               INCLUDE TBMNHDT                                                  
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
           EXEC SQL                                                             
               INCLUDE TBMNHIST                                                 
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
           EXEC SQL                                                             
               INCLUDE TBINTVRD                                                 
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
           EXEC SQL                                                             
               INCLUDE TBUTLREL                                                 
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
           EXEC SQL                                                             
               INCLUDE TBUSRPRF                                                 
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
           EXEC SQL                                                             
               INCLUDE TBFXDFCT                                                 
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
           EXEC SQL                                                             
               INCLUDE TBCSTPLN                                                 
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
           EXEC SQL                                                             
               INCLUDE TBTRMOPR                                                 
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
           EXEC SQL                                                             
               INCLUDE TBCDCNTL                                                 
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
           EXEC SQL                                                             
               INCLUDE TBCDJRNL                                                 
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
           EXEC SQL                                                             
               INCLUDE TBBJCNTL                                                 
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
           EXEC SQL                                                             
               INCLUDE TBBTJRNL                                                 
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
           EXEC SQL                                                             
               INCLUDE TBMSJRNL                                                 
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
           EXEC SQL                                                             
               INCLUDE TBBLLHDR                                                 
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
           EXEC SQL                                                             
               INCLUDE TBBLLDET                                                 
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
           EXEC SQL                                                             
               INCLUDE TBCNSMP                                                  
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
           EXEC SQL                                                             
               INCLUDE TBCUST                                                   
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
           EXEC SQL                                                             
               INCLUDE TBFXHST                                                  
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
           EXEC SQL                                                             
               INCLUDE TBLIEAP                                                  
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
           EXEC SQL                                                             
               INCLUDE TBOFFCYL                                                 
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
           EXEC SQL                                                             
               INCLUDE TBRGREAD                                                 
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
           EXEC SQL                                                             
               INCLUDE TBUMCNSM                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE TBMTRCAP                                                 
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRTCRTR                                                  
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
                                                                        
           EXEC SQL                                                             
              INCLUDE TBVOLDLY                                                  
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMTRIDT                                                  
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
                                                                        
           EXEC SQL                                                             
              INCLUDE TBINDFCT                                                  
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBLCNTR                                                  
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
                                                                        
           EXEC SQL                                                             
              INCLUDE TBVOLBLK                                                  
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRDWNDW                                                  
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRTCDEF                                                  
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
                                                                        
           EXEC SQL                                                             
              INCLUDE TBTRNBLK                                                  
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
                                                                        
           EXEC SQL                                                             
              INCLUDE TBTRNCNT                                                  
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBGTPLN                                                  
           END-EXEC.                                                            
      *                                                                         
A05460*TEMP CODE                                                                
A05460     EXEC SQL                                                             
A05460        INCLUDE TBACCTRG                                                  
A05460     END-EXEC.                                                            
A05460*                                                                         
A05460     EXEC SQL                                                             
A05460        INCLUDE TBRTPKGO                                                  
A05460     END-EXEC.                                                            
A05460*                                                                         
      * COPYBOOK FOR TABLE CSS_BILL_ADJUSTMNT                                   
           EXEC SQL                                                             
              INCLUDE TBBILADJ                                                  
           END-EXEC.                                                            
      *                                                                         
      * COPYBOOK FOR TABLE CSS_BILL_ADJ_REASN                                   
           EXEC SQL                                                             
              INCLUDE TBLADRSN                                                  
           END-EXEC.                                                            
      *                                                                         
      *    CSS_BILL_WINDOW                                                      
                EXEC SQL                                                        
                    INCLUDE TBBILWDW                                            
                END-EXEC.                                                       
      *                                                                         
      * COPYBOOK FOR TABLE CSS_SO_DATA                                          
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
      *                                                                         
      * COPYBOOK FOR TABLE CSS_SO_FINAL_BILL                                    
           EXEC SQL                                                             
              INCLUDE TBSOFIN                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ACCT_ATTRIBUTE - YP                                                 
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACTATT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_BILL_MANUAL - NG                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBILMNL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_BILL_MAN_DET - NU                                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBILMDE                                                  
           END-EXEC.                                                            
      *                                                                         
       COPY CWS00182.                                                           
                                                                        
      ******************************************************************        
      *  CURSOR DECLARATION FOR THE CSS_INTERVAL_READ TABLE.           *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE IDR_CRSR CURSOR FOR                               
                 SELECT DATE_READ                                       
                       ,REPLACE(CONVERT(CHAR(8), TIME_READ, 108), ':', 
           '.') TIME_READ                                       
                       ,DST_CHNG_IND                                    
                       ,CHANNEL_A_PULSES                                
                       ,CHANNEL_A_STATUS                                
                       ,CHANNEL_B_PULSES                                
                       ,CHANNEL_B_STATUS                                
                       ,CHANNEL_C_PULSES                                
                       ,CHANNEL_C_STATUS                                
                   FROM CSS_INTERVAL_READ WITH(READUNCOMMITTED)                 
                  WHERE METER_NO           = :IV-METER-NO               
                    AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :IV-BILL-ITEM-TIMESTMP
              )     
                    AND CODE_UTIL_TYPE     = :IV-CODE-UTIL-TYPE         
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE IDR_CRSR CURSOR FOR                                       
MFA-TR*          SELECT DATE_READ                                               
MFA-TR*                ,TIME_READ                                               
MFA-TR*                ,DST_CHNG_IND                                            
MFA-TR*                ,CHANNEL_A_PULSES                                        
MFA-TR*                ,CHANNEL_A_STATUS                                        
MFA-TR*                ,CHANNEL_B_PULSES                                        
MFA-TR*                ,CHANNEL_B_STATUS                                        
MFA-TR*                ,CHANNEL_C_PULSES                                        
MFA-TR*                ,CHANNEL_C_STATUS                                        
MFA-TR*            FROM CSS_INTERVAL_READ                                       
MFA-TR*           WHERE METER_NO           = :IV-METER-NO                       
MFA-TR*             AND BILL_ITEM_TIMESTMP = :IV-BILL-ITEM-TIMESTMP             
MFA-TR*             AND CODE_UTIL_TYPE     = :IV-CODE-UTIL-TYPE                 
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*           QUERYNO 7700                                                  
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CURSOR DECLARATION FOR THE CSS_VOL_DAILY TABLE                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE VOL_CRSR CURSOR FOR                              
                      SELECT VOL_TYPE_CD,                               
                             ENERGY_UNIT_CD,                            
                             DATE_READ,                                 
                             NO_UNITS,                                  
                             FIXED_FCTR_SEQ_NO                          
                            ,CODE_TIME_PERIOD                           
                     FROM CSS_VOL_DAILY WITH(READUNCOMMITTED)                   
                    WHERE ACCOUNT_NO         = :ND-ACCOUNT-NO AND       
                          BILL_NO            = :ND-BILL-NO AND          
                          CODE_UTIL_TYPE     = :ND-CODE-UTIL-TYPE AND   
                          IC_NO              = :ND-IC-NO AND            
                          BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :ND-BILL-ITEM-TIMESTMP
              )   
                      FOR READ ONLY                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE VOL_CRSR CURSOR FOR                                      
MFA-TR*               SELECT VOL_TYPE_CD,                                       
MFA-TR*                      ENERGY_UNIT_CD,                                    
MFA-TR*                      DATE_READ,                                         
MFA-TR*                      NO_UNITS,                                          
MFA-TR*                      FIXED_FCTR_SEQ_NO                                  
MFA-TR*                     ,CODE_TIME_PERIOD                                   
MFA-TR*              FROM CSS_VOL_DAILY                                         
MFA-TR*             WHERE ACCOUNT_NO         = :ND-ACCOUNT-NO AND               
MFA-TR*                   BILL_NO            = :ND-BILL-NO AND                  
MFA-TR*                   CODE_UTIL_TYPE     = :ND-CODE-UTIL-TYPE AND           
MFA-TR*                   IC_NO              = :ND-IC-NO AND                    
MFA-TR*                   BILL_ITEM_TIMESTMP = :ND-BILL-ITEM-TIMESTMP           
MFA-TR*               FOR FETCH ONLY WITH UR                                    
MFA-TR*            QUERYNO 7820                                                 
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CURSOR DECLARATION FOR THE CSS_MTR_IDENT_HIST TABLE           *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE MTR_CRSR CURSOR FOR                              
                   SELECT MTR_REF_NO                                    
                         ,METER_NO                                      
                         ,IDR_IDENT_NO                                  
                         ,INTERVALS_PER_HR                              
                         ,CHANNEL_A_UOM                                 
                         ,CHANNEL_B_UOM                                 
                         ,CHANNEL_C_UOM                                 
                         ,IDR_INFO_RETENT_DT                            
                         ,CT_UPPER_RATIO                                
                         ,PT_UPPER_RATIO                                
                         ,CT_LOWER_RATIO                                
                         ,PT_LOWER_RATIO                                
                         ,INDUST_BTU_ID                                 
                     FROM CSS_MTR_IDENT_HIST WITH(READUNCOMMITTED)              
                    WHERE ACCOUNT_NO         = :GA-ACCOUNT-NO           
                      AND BILL_NO            = :GA-BILL-NO              
                      AND CODE_UTIL_TYPE     = :GA-CODE-UTIL-TYPE       
                      AND IC_NO              = :GA-IC-NO                
                      AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :GA-BILL-ITEM-TIMESTMP
              )   
                      FOR READ ONLY                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE MTR_CRSR CURSOR FOR                                      
MFA-TR*            SELECT MTR_REF_NO                                            
MFA-TR*                  ,METER_NO                                              
MFA-TR*                  ,IDR_IDENT_NO                                          
MFA-TR*                  ,INTERVALS_PER_HR                                      
MFA-TR*                  ,CHANNEL_A_UOM                                         
MFA-TR*                  ,CHANNEL_B_UOM                                         
MFA-TR*                  ,CHANNEL_C_UOM                                         
MFA-TR*                  ,IDR_INFO_RETENT_DT                                    
MFA-TR*                  ,CT_UPPER_RATIO                                        
MFA-TR*                  ,PT_UPPER_RATIO                                        
MFA-TR*                  ,CT_LOWER_RATIO                                        
MFA-TR*                  ,PT_LOWER_RATIO                                        
MFA-TR*                  ,INDUST_BTU_ID                                         
MFA-TR*              FROM CSS_MTR_IDENT_HIST                                    
MFA-TR*             WHERE ACCOUNT_NO         = :GA-ACCOUNT-NO                   
MFA-TR*               AND BILL_NO            = :GA-BILL-NO                      
MFA-TR*               AND CODE_UTIL_TYPE     = :GA-CODE-UTIL-TYPE               
MFA-TR*               AND IC_NO              = :GA-IC-NO                        
MFA-TR*               AND BILL_ITEM_TIMESTMP = :GA-BILL-ITEM-TIMESTMP           
MFA-TR*               FOR FETCH ONLY WITH UR                                    
MFA-TR*            QUERYNO 7800                                                 
MFA-TR*    END-EXEC.                                                            
                                                                        
      ********************************************************                  
      **  CURSOR DECLARATION -- TO GET OTHER ASSCOCIATED IC NO'S                
      **********************************************************                
           EXEC SQL                                                     
               DECLARE ASSO_IC_NO  CURSOR FOR                           
                      SELECT IC_NO                                      
                FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                   
                WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO            
                  AND BG.BILL_NO            = :BG-BILL-NO               
                  AND BG.IC_NO              <> :BG-IC-NO                
                  AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE        
                  AND BG.REVENUE_MONTH      = :BG-REVENUE-MONTH         
                  AND BG.REV_RPT_CD         <> 'T'                      
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE ASSO_IC_NO  CURSOR FOR                                   
MFA-TR*               SELECT IC_NO                                              
MFA-TR*         FROM CSS_BILLING_DET BG                                         
MFA-TR*         WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO                    
MFA-TR*           AND BG.BILL_NO            = :BG-BILL-NO                       
MFA-TR*           AND BG.IC_NO              <> :BG-IC-NO                        
MFA-TR*           AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                
MFA-TR*           AND BG.REVENUE_MONTH      = :BG-REVENUE-MONTH                 
MFA-TR*           AND BG.REV_RPT_CD         <> 'T'                              
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*         QUERYNO 7154                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
                                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *  DECLARE A CURSOR FOR THE CSS_BILLING_DET TABLE                *        
      *                                                                *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE BILL_DET_SHFT_CRSR CURSOR FOR                    
                      SELECT PREMISE_NO                                 
                            ,BILL_NO                                    
                            ,CODE_UTIL_TYPE                             
                            ,IC_NO                                      
                            ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                         
                            ,DATE_ORIG_BILL                             
                            ,AMT_BILL_ITEM                              
                            ,CODE_BILL_CALC                             
                            ,CODE_BILL_ITM_TYPE                         
                            ,CODE_BILL_ITM_IND                          
                            ,CODE_DR_CR_CNSMPTN                         
                            ,AMT_STATE_TAX                              
                            ,AMT_CITY_TAX                               
                            ,AMT_OTHER_TAX                              
                            ,CODE_REVENUE_CLASS                         
                            ,CODE_SIC_NO                                
                            ,RATE_PLAN_NO                               
                            ,CODE_CURTAIL_PRTY                          
                            ,CODE_STAT_TAX_XMT                          
                            ,CODE_CITY_TAX_XMT                          
                            ,CODE_OTHR_TAX_XMT                          
                            ,REV_RPT_CD                                 
                            ,STANDBY_COMPLIED                           
                            ,PRORATE_CD                                 
                            ,NEW_RATE_PCT                               
                            ,CODE_SUB_TOTAL                             
                            ,TAX_REFUND_CD                              
                            ,ACCOUNT_NO                                 
                            ,COMPANY_NO                                 
                            ,DATE_LFTM_HI_DMD                           
                            ,LFTM_HI_PEAK_DMD                           
                            ,REBILL_IND                                 
                            ,ADJ_REASON_CD                              
                            ,REVENUE_MONTH                              
                            ,GAS_BASE_USE                               
                            ,WNA_FACTOR                                 
                            ,BTU_FACTOR                                 
                            ,NO_OF_CONS_DAYS                            
                            ,REV_MTH_ORIG_BILL                          
                            ,REV_DISTRICT_CD                            
                            ,FUEL_SHIPPER_CD                            
                            ,ALTERNATE_FUEL_CD                          
                            ,TRNSP_OVER_MDQ_FL                          
                            ,CITY_TAX_RATE                              
                            ,OTHER_TAX_RATE                             
                            ,STATE_TAX_RATE                             
                            ,BILL_CALC_CYCLE                            
                            ,NAICS_CD                                   
                            ,RT_PKG_OPT_SEQ_NO                          
                 FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO = :BG-ACCOUNT-NO                       
                  AND BILL_NO    = :BG-BILL-NO                          
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE BILL_DET_SHFT_CRSR CURSOR FOR                            
MFA-TR*               SELECT PREMISE_NO                                         
MFA-TR*                     ,BILL_NO                                            
MFA-TR*                     ,CODE_UTIL_TYPE                                     
MFA-TR*                     ,IC_NO                                              
MFA-TR*                     ,BILL_ITEM_TIMESTMP                                 
MFA-TR*                     ,DATE_ORIG_BILL                                     
MFA-TR*                     ,AMT_BILL_ITEM                                      
MFA-TR*                     ,CODE_BILL_CALC                                     
MFA-TR*                     ,CODE_BILL_ITM_TYPE                                 
MFA-TR*                     ,CODE_BILL_ITM_IND                                  
MFA-TR*                     ,CODE_DR_CR_CNSMPTN                                 
MFA-TR*                     ,AMT_STATE_TAX                                      
MFA-TR*                     ,AMT_CITY_TAX                                       
MFA-TR*                     ,AMT_OTHER_TAX                                      
MFA-TR*                     ,CODE_REVENUE_CLASS                                 
MFA-TR*                     ,CODE_SIC_NO                                        
MFA-TR*                     ,RATE_PLAN_NO                                       
MFA-TR*                     ,CODE_CURTAIL_PRTY                                  
MFA-TR*                     ,CODE_STAT_TAX_XMT                                  
MFA-TR*                     ,CODE_CITY_TAX_XMT                                  
MFA-TR*                     ,CODE_OTHR_TAX_XMT                                  
MFA-TR*                     ,REV_RPT_CD                                         
MFA-TR*                     ,STANDBY_COMPLIED                                   
MFA-TR*                     ,PRORATE_CD                                         
MFA-TR*                     ,NEW_RATE_PCT                                       
MFA-TR*                     ,CODE_SUB_TOTAL                                     
MFA-TR*                     ,TAX_REFUND_CD                                      
MFA-TR*                     ,ACCOUNT_NO                                         
MFA-TR*                     ,COMPANY_NO                                         
MFA-TR*                     ,DATE_LFTM_HI_DMD                                   
MFA-TR*                     ,LFTM_HI_PEAK_DMD                                   
MFA-TR*                     ,REBILL_IND                                         
MFA-TR*                     ,ADJ_REASON_CD                                      
MFA-TR*                     ,REVENUE_MONTH                                      
MFA-TR*                     ,GAS_BASE_USE                                       
MFA-TR*                     ,WNA_FACTOR                                         
MFA-TR*                     ,BTU_FACTOR                                         
MFA-TR*                     ,NO_OF_CONS_DAYS                                    
MFA-TR*                     ,REV_MTH_ORIG_BILL                                  
MFA-TR*                     ,REV_DISTRICT_CD                                    
MFA-TR*                     ,FUEL_SHIPPER_CD                                    
MFA-TR*                     ,ALTERNATE_FUEL_CD                                  
MFA-TR*                     ,TRNSP_OVER_MDQ_FL                                  
MFA-TR*                     ,CITY_TAX_RATE                                      
MFA-TR*                     ,OTHER_TAX_RATE                                     
MFA-TR*                     ,STATE_TAX_RATE                                     
MFA-TR*                     ,BILL_CALC_CYCLE                                    
MFA-TR*                     ,NAICS_CD                                           
MFA-TR*                     ,RT_PKG_OPT_SEQ_NO                                  
MFA-TR*          FROM CSS_BILLING_DET                                           
MFA-TR*         WHERE ACCOUNT_NO = :BG-ACCOUNT-NO                               
MFA-TR*           AND BILL_NO    = :BG-BILL-NO                                  
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*         QUERYNO 7772                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *                                                                *        
      *  DECLARE A CURSOR FOR THE CSS_BILLING_DET TABLE                *        
      *                                                                *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE BILL_COPY_ACT_CRSR CURSOR FOR                    
                      SELECT PREMISE_NO                                 
                            ,BILL_NO                                    
                            ,CODE_UTIL_TYPE                             
                            ,IC_NO                                      
                            ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                         
                            ,DATE_ORIG_BILL                             
                            ,AMT_BILL_ITEM                              
                            ,CODE_BILL_CALC                             
                            ,CODE_BILL_ITM_TYPE                         
                            ,CODE_BILL_ITM_IND                          
                            ,CODE_DR_CR_CNSMPTN                         
                            ,AMT_STATE_TAX                              
                            ,AMT_CITY_TAX                               
                            ,AMT_OTHER_TAX                              
                            ,CODE_REVENUE_CLASS                         
                            ,CODE_SIC_NO                                
                            ,RATE_PLAN_NO                               
                            ,CODE_CURTAIL_PRTY                          
                            ,CODE_STAT_TAX_XMT                          
                            ,CODE_CITY_TAX_XMT                          
                            ,CODE_OTHR_TAX_XMT                          
                            ,REV_RPT_CD                                 
                            ,STANDBY_COMPLIED                           
                            ,PRORATE_CD                                 
                            ,NEW_RATE_PCT                               
                            ,CODE_SUB_TOTAL                             
                            ,TAX_REFUND_CD                              
                            ,ACCOUNT_NO                                 
                            ,COMPANY_NO                                 
                            ,DATE_LFTM_HI_DMD                           
                            ,LFTM_HI_PEAK_DMD                           
                            ,REBILL_IND                                 
                            ,ADJ_REASON_CD                              
                            ,REVENUE_MONTH                              
                            ,GAS_BASE_USE                               
                            ,WNA_FACTOR                                 
                            ,BTU_FACTOR                                 
                            ,NO_OF_CONS_DAYS                            
                            ,REV_MTH_ORIG_BILL                          
                            ,REV_DISTRICT_CD                            
                            ,FUEL_SHIPPER_CD                            
                            ,ALTERNATE_FUEL_CD                          
                            ,TRNSP_OVER_MDQ_FL                          
                            ,CITY_TAX_RATE                              
                            ,OTHER_TAX_RATE                             
                            ,STATE_TAX_RATE                             
                            ,BILL_CALC_CYCLE                            
                            ,NAICS_CD                                   
                            ,RT_PKG_OPT_SEQ_NO                          
                 FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO     = :BG-ACCOUNT-NO                   
                  AND BILL_NO        = :BG-BILL-NO                      
                  AND CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE               
                  AND IC_NO          = :BG-IC-NO                        
                  AND ((CODE_BILL_CALC = 'S'                            
                         AND CODE_BILL_ITM_TYPE = 'B'                   
                         AND CODE_BILL_ITM_IND  = 'A')                  
                     OR (CODE_BILL_CALC     = 'A'                       
                         AND  CODE_BILL_ITM_TYPE = 'C'                  
                         AND  CODE_BILL_ITM_IND  = 'A'                  
                         AND  REBILL_IND    = 'Y'))                     
                ORDER BY BILL_ITEM_TIMESTMP DESC                        
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE BILL_COPY_ACT_CRSR CURSOR FOR                            
MFA-TR*               SELECT PREMISE_NO                                         
MFA-TR*                     ,BILL_NO                                            
MFA-TR*                     ,CODE_UTIL_TYPE                                     
MFA-TR*                     ,IC_NO                                              
MFA-TR*                     ,BILL_ITEM_TIMESTMP                                 
MFA-TR*                     ,DATE_ORIG_BILL                                     
MFA-TR*                     ,AMT_BILL_ITEM                                      
MFA-TR*                     ,CODE_BILL_CALC                                     
MFA-TR*                     ,CODE_BILL_ITM_TYPE                                 
MFA-TR*                     ,CODE_BILL_ITM_IND                                  
MFA-TR*                     ,CODE_DR_CR_CNSMPTN                                 
MFA-TR*                     ,AMT_STATE_TAX                                      
MFA-TR*                     ,AMT_CITY_TAX                                       
MFA-TR*                     ,AMT_OTHER_TAX                                      
MFA-TR*                     ,CODE_REVENUE_CLASS                                 
MFA-TR*                     ,CODE_SIC_NO                                        
MFA-TR*                     ,RATE_PLAN_NO                                       
MFA-TR*                     ,CODE_CURTAIL_PRTY                                  
MFA-TR*                     ,CODE_STAT_TAX_XMT                                  
MFA-TR*                     ,CODE_CITY_TAX_XMT                                  
MFA-TR*                     ,CODE_OTHR_TAX_XMT                                  
MFA-TR*                     ,REV_RPT_CD                                         
MFA-TR*                     ,STANDBY_COMPLIED                                   
MFA-TR*                     ,PRORATE_CD                                         
MFA-TR*                     ,NEW_RATE_PCT                                       
MFA-TR*                     ,CODE_SUB_TOTAL                                     
MFA-TR*                     ,TAX_REFUND_CD                                      
MFA-TR*                     ,ACCOUNT_NO                                         
MFA-TR*                     ,COMPANY_NO                                         
MFA-TR*                     ,DATE_LFTM_HI_DMD                                   
MFA-TR*                     ,LFTM_HI_PEAK_DMD                                   
MFA-TR*                     ,REBILL_IND                                         
MFA-TR*                     ,ADJ_REASON_CD                                      
MFA-TR*                     ,REVENUE_MONTH                                      
MFA-TR*                     ,GAS_BASE_USE                                       
MFA-TR*                     ,WNA_FACTOR                                         
MFA-TR*                     ,BTU_FACTOR                                         
MFA-TR*                     ,NO_OF_CONS_DAYS                                    
MFA-TR*                     ,REV_MTH_ORIG_BILL                                  
MFA-TR*                     ,REV_DISTRICT_CD                                    
MFA-TR*                     ,FUEL_SHIPPER_CD                                    
MFA-TR*                     ,ALTERNATE_FUEL_CD                                  
MFA-TR*                     ,TRNSP_OVER_MDQ_FL                                  
MFA-TR*                     ,CITY_TAX_RATE                                      
MFA-TR*                     ,OTHER_TAX_RATE                                     
MFA-TR*                     ,STATE_TAX_RATE                                     
MFA-TR*                     ,BILL_CALC_CYCLE                                    
MFA-TR*                     ,NAICS_CD                                           
MFA-TR*                     ,RT_PKG_OPT_SEQ_NO                                  
MFA-TR*          FROM CSS_BILLING_DET                                           
MFA-TR*         WHERE ACCOUNT_NO     = :BG-ACCOUNT-NO                           
MFA-TR*           AND BILL_NO        = :BG-BILL-NO                              
MFA-TR*           AND CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE                       
MFA-TR*           AND IC_NO          = :BG-IC-NO                                
MFA-TR*           AND ((CODE_BILL_CALC = 'S'                                    
MFA-TR*                  AND CODE_BILL_ITM_TYPE = 'B'                           
MFA-TR*                  AND CODE_BILL_ITM_IND  = 'A')                          
MFA-TR*              OR (CODE_BILL_CALC     = 'A'                               
MFA-TR*                  AND  CODE_BILL_ITM_TYPE = 'C'                          
MFA-TR*                  AND  CODE_BILL_ITM_IND  = 'A'                          
MFA-TR*                  AND  REBILL_IND    = 'Y'))                             
MFA-TR*         ORDER BY BILL_ITEM_TIMESTMP DESC                                
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*         QUERYNO 7610                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *                                                                *        
      *  DECLARE A CURSOR FOR THE CSS_CNSMPTN_HIST TABLE.              *        
      *                                                                *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE CX_SHFT_CRSR CURSOR FOR                          
                      SELECT CODE_TIME_PERIOD                           
                            ,MTR_REF_NO                                 
                            ,CODE_USAGE_TYPE                            
                            ,CODE_USAGE_ID                              
                            ,CODE_USAGE_SOURCE                          
                            ,ITEM_SEQ_NO                                
                            ,METER_NO                                   
                            ,REG_ID_NO                                  
                            ,DATE_READ                                  
                            ,CODE_METER_READ                            
                            ,CODE_METER_NO_READ                         
                            ,METER_READING                              
                            ,DEMAND_READING                             
                            ,EMPLOYEE_NO                                
                            ,NO_UNITS                                   
                            ,NO_DEMAND_UNITS                            
                            ,NO_DAYS                                    
                            ,CODE_SOURCE_ID                             
                            ,CODE_DEBIT_CREDIT                          
                            ,CODE_ITEM_STATUS                           
                            ,CODE_DISCOUNT                              
                            ,CONSTANT                                   
                            ,NO_DIALS                                   
                            ,COMPANY_NO                                 
                            ,EXCEPT_OVERRIDE_CD                         
                            ,REQUESTED_USAGE                            
                            ,DIGTL_INTRL_MTR_NO                         
                            ,DIGTL_MTR_TYPE                             
                            ,CODE_TOU_SEASN                             
                            ,EXCL_DMD_RCHT_IND                          
                            ,MTR_READ_SOURCE_CD                         
                            ,BTU_FACTOR                                 
                            ,PCOMP_FCT                                  
                 FROM CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO               
                  AND BILL_NO            = :CX-BILL-NO                  
                  AND CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE           
                  AND IC_NO              = :CX-IC-NO                    
                  AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )       
A05460          ORDER BY METER_NO                                       
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE CX_SHFT_CRSR CURSOR FOR                                  
MFA-TR*               SELECT CODE_TIME_PERIOD                                   
MFA-TR*                     ,MTR_REF_NO                                         
MFA-TR*                     ,CODE_USAGE_TYPE                                    
MFA-TR*                     ,CODE_USAGE_ID                                      
MFA-TR*                     ,CODE_USAGE_SOURCE                                  
MFA-TR*                     ,ITEM_SEQ_NO                                        
MFA-TR*                     ,METER_NO                                           
MFA-TR*                     ,REG_ID_NO                                          
MFA-TR*                     ,DATE_READ                                          
MFA-TR*                     ,CODE_METER_READ                                    
MFA-TR*                     ,CODE_METER_NO_READ                                 
MFA-TR*                     ,METER_READING                                      
MFA-TR*                     ,DEMAND_READING                                     
MFA-TR*                     ,EMPLOYEE_NO                                        
MFA-TR*                     ,NO_UNITS                                           
MFA-TR*                     ,NO_DEMAND_UNITS                                    
MFA-TR*                     ,NO_DAYS                                            
MFA-TR*                     ,CODE_SOURCE_ID                                     
MFA-TR*                     ,CODE_DEBIT_CREDIT                                  
MFA-TR*                     ,CODE_ITEM_STATUS                                   
MFA-TR*                     ,CODE_DISCOUNT                                      
MFA-TR*                     ,CONSTANT                                           
MFA-TR*                     ,NO_DIALS                                           
MFA-TR*                     ,COMPANY_NO                                         
MFA-TR*                     ,EXCEPT_OVERRIDE_CD                                 
MFA-TR*                     ,REQUESTED_USAGE                                    
MFA-TR*                     ,DIGTL_INTRL_MTR_NO                                 
MFA-TR*                     ,DIGTL_MTR_TYPE                                     
MFA-TR*                     ,CODE_TOU_SEASN                                     
MFA-TR*                     ,EXCL_DMD_RCHT_IND                                  
MFA-TR*                     ,MTR_READ_SOURCE_CD                                 
MFA-TR*                     ,BTU_FACTOR                                         
MFA-TR*                     ,PCOMP_FCT                                          
MFA-TR*          FROM CSS_CNSMPTN_HIST                                          
MFA-TR*         WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO                       
MFA-TR*           AND BILL_NO            = :CX-BILL-NO                          
MFA-TR*           AND CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE                   
MFA-TR*           AND IC_NO              = :CX-IC-NO                            
MFA-TR*           AND BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP               
MFA-TR*         ORDER BY METER_NO                                               
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*            QUERYNO 7777                                                 
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *  CURSOR DECLARATION FOR THE CSS_FIXED_FCT_HIST TABLE.          *        
      *  THIS CURSOR IS USED IN MAINTAINING FIXED FACTOR HISTORY ROWS. *        
      *                                                                *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE FH_MAINT_CRSR CURSOR FOR                         
                  SELECT FIXED_FCTR_SEQ_NO                              
                        ,FH.FACTOR_ID                                   
                        ,EFF_DATE_FROM                                  
                        ,CMPNT_ID_CD                                    
                        ,CODE_SEASON                                    
                        ,INSTR_USE_TYPE_CD                              
                        ,CODE_TIME_PERIOD                               
                        ,CODE_DEBIT_CREDIT                              
                        ,CODE_REVENUE_CLASS                             
                        ,FH.CODE_TAX_STAT_XMT                           
                        ,FH.CODE_TAX_CITY_XMT                           
                        ,FH.CODE_TAX_OTHR_XMT                           
                        ,FACTOR                                         
                        ,EFF_DATE_TO                                    
                        ,FIXED_FCTR_TYP_CD                              
                        ,BILL_UNITS                                     
                        ,ENERGY_UNIT_CD                                 
                        ,DURATION_REMAIN_NO                             
                        ,FH.OVR_RT_VER_PRO_FL                           
                        ,RT_PKG_OPT_SEQ_NO                              
                        ,FACTOR_HISTORY_CD                              
                        ,SPCL_GROUP_CD                                  
                        ,BLOCK_NO                                       
                        ,FH.FCTR_POWER_10                               
                 FROM CSS_FIXED_FCT_HIST FH WITH(READUNCOMMITTED),              
                      CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO         = :FH-ACCOUNT-NO               
                  AND BILL_NO            = :FH-BILL-NO                  
                  AND CODE_UTIL_TYPE     = :FH-CODE-UTIL-TYPE           
                  AND IC_NO              = :FH-IC-NO                    
                  AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :FH-BILL-ITEM-TIMESTMP
              )       
                  AND FH.FACTOR_ID       = SF.FACTOR_ID                 
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE FH_MAINT_CRSR CURSOR FOR                                 
MFA-TR*           SELECT FIXED_FCTR_SEQ_NO                                      
MFA-TR*                 ,FH.FACTOR_ID                                           
MFA-TR*                 ,EFF_DATE_FROM                                          
MFA-TR*                 ,CMPNT_ID_CD                                            
MFA-TR*                 ,CODE_SEASON                                            
MFA-TR*                 ,INSTR_USE_TYPE_CD                                      
MFA-TR*                 ,CODE_TIME_PERIOD                                       
MFA-TR*                 ,CODE_DEBIT_CREDIT                                      
MFA-TR*                 ,CODE_REVENUE_CLASS                                     
MFA-TR*                 ,FH.CODE_TAX_STAT_XMT                                   
MFA-TR*                 ,FH.CODE_TAX_CITY_XMT                                   
MFA-TR*                 ,FH.CODE_TAX_OTHR_XMT                                   
MFA-TR*                 ,FACTOR                                                 
MFA-TR*                 ,EFF_DATE_TO                                            
MFA-TR*                 ,FIXED_FCTR_TYP_CD                                      
MFA-TR*                 ,BILL_UNITS                                             
MFA-TR*                 ,ENERGY_UNIT_CD                                         
MFA-TR*                 ,DURATION_REMAIN_NO                                     
MFA-TR*                 ,FH.OVR_RT_VER_PRO_FL                                   
MFA-TR*                 ,RT_PKG_OPT_SEQ_NO                                      
MFA-TR*                 ,FACTOR_HISTORY_CD                                      
MFA-TR*                 ,SPCL_GROUP_CD                                          
MFA-TR*                 ,BLOCK_NO                                               
MFA-TR*                 ,FH.FCTR_POWER_10                                       
MFA-TR*          FROM CSS_FIXED_FCT_HIST FH,                                    
MFA-TR*               CSS_SPCL_FCTR SF                                          
MFA-TR*         WHERE ACCOUNT_NO         = :FH-ACCOUNT-NO                       
MFA-TR*           AND BILL_NO            = :FH-BILL-NO                          
MFA-TR*           AND CODE_UTIL_TYPE     = :FH-CODE-UTIL-TYPE                   
MFA-TR*           AND IC_NO              = :FH-IC-NO                            
MFA-TR*           AND BILL_ITEM_TIMESTMP = :FH-BILL-ITEM-TIMESTMP               
MFA-TR*           AND FH.FACTOR_ID       = SF.FACTOR_ID                         
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*         QUERYNO 7490                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *                                                                *        
      *  DECLARE A CURSOR FOR THE CSS_UM_CNSMPT_HIST TABLE             *        
      *                                                                *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE UC_SHFT_CRSR CURSOR FOR                          
                  SELECT RATE_ITEM_CODE                                 
                        ,ITEM_SEQ_NO                                    
                        ,NO_UNITS                                       
                        ,NO_DAYS                                        
                        ,CODE_DEBIT_CREDIT                              
                        ,USAGE_FIXED                                    
                        ,DATE_USAGE_ENDS                                
                        ,CODE_SERVICE_TYPE                              
                        ,CODE_ITEM_STATUS                               
                        ,CODE_SOURCE_ID                                 
                        ,MTHLY_AMOUNT_FIXED                             
                        ,DIST_NO                                        
                        ,LIGHT_NO                                       
                        ,POLE_NO                                        
                  FROM CSS_UM_CNSMPT_HIST WITH(READUNCOMMITTED)                 
                  WHERE ACCOUNT_NO         = :UC-ACCOUNT-NO             
                    AND BILL_NO            = :UC-BILL-NO                
                    AND CODE_UTIL_TYPE     = :UC-CODE-UTIL-TYPE         
                    AND IC_NO              = :UC-IC-NO                  
                    AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :UC-BILL-ITEM-TIMESTMP
              )     
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE UC_SHFT_CRSR CURSOR FOR                                  
MFA-TR*           SELECT RATE_ITEM_CODE                                         
MFA-TR*                 ,ITEM_SEQ_NO                                            
MFA-TR*                 ,NO_UNITS                                               
MFA-TR*                 ,NO_DAYS                                                
MFA-TR*                 ,CODE_DEBIT_CREDIT                                      
MFA-TR*                 ,USAGE_FIXED                                            
MFA-TR*                 ,DATE_USAGE_ENDS                                        
MFA-TR*                 ,CODE_SERVICE_TYPE                                      
MFA-TR*                 ,CODE_ITEM_STATUS                                       
MFA-TR*                 ,CODE_SOURCE_ID                                         
MFA-TR*                 ,MTHLY_AMOUNT_FIXED                                     
MFA-TR*                 ,DIST_NO                                                
MFA-TR*                 ,LIGHT_NO                                               
MFA-TR*                 ,POLE_NO                                                
MFA-TR*           FROM CSS_UM_CNSMPT_HIST                                       
MFA-TR*           WHERE ACCOUNT_NO         = :UC-ACCOUNT-NO                     
MFA-TR*             AND BILL_NO            = :UC-BILL-NO                        
MFA-TR*             AND CODE_UTIL_TYPE     = :UC-CODE-UTIL-TYPE                 
MFA-TR*             AND IC_NO              = :UC-IC-NO                          
MFA-TR*             AND BILL_ITEM_TIMESTMP = :UC-BILL-ITEM-TIMESTMP             
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*         QUERYNO 7780                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *  DECLARE A CURSOR FOR THE CSS_BILLING_DET TABLE.  THIS CURSOR  *        
      *  IS USED TO RETRIEVE ALL REBILLS AND BACKOUTS TO BE DELETED    *        
      *  WHEN THE DELETE-ALL-REBILLS SWITCH IS SET.                    *        
      *                                                                *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE DELETE_ALL_REBILLS CURSOR FOR                    
                      SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                         
                            ,CODE_BILL_CALC                             
                            ,CODE_BILL_ITM_TYPE                         
                            ,CODE_BILL_ITM_IND                          
                FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                      
                WHERE ACCOUNT_NO     = :BG-ACCOUNT-NO                   
                  AND BILL_NO        = :BG-BILL-NO                      
                  AND CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE               
                  AND IC_NO          = :BG-IC-NO                        
                  AND ((CODE_BILL_CALC = 'S'                            
                         AND CODE_BILL_ITM_TYPE = 'B'                   
                         AND CODE_BILL_ITM_IND  = 'A')                  
                     OR (CODE_BILL_CALC     = 'A'                       
                         AND  CODE_BILL_ITM_TYPE = 'C'                  
                         AND  CODE_BILL_ITM_IND  = 'A'                  
                         AND  REBILL_IND    = 'Y'))                     
                ORDER BY BILL_ITEM_TIMESTMP DESC                        
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE DELETE_ALL_REBILLS CURSOR FOR                            
MFA-TR*               SELECT BILL_ITEM_TIMESTMP                                 
MFA-TR*                     ,CODE_BILL_CALC                                     
MFA-TR*                     ,CODE_BILL_ITM_TYPE                                 
MFA-TR*                     ,CODE_BILL_ITM_IND                                  
MFA-TR*         FROM CSS_BILLING_DET                                            
MFA-TR*         WHERE ACCOUNT_NO     = :BG-ACCOUNT-NO                           
MFA-TR*           AND BILL_NO        = :BG-BILL-NO                              
MFA-TR*           AND CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE                       
MFA-TR*           AND IC_NO          = :BG-IC-NO                                
MFA-TR*           AND ((CODE_BILL_CALC = 'S'                                    
MFA-TR*                  AND CODE_BILL_ITM_TYPE = 'B'                           
MFA-TR*                  AND CODE_BILL_ITM_IND  = 'A')                          
MFA-TR*              OR (CODE_BILL_CALC     = 'A'                               
MFA-TR*                  AND  CODE_BILL_ITM_TYPE = 'C'                          
MFA-TR*                  AND  CODE_BILL_ITM_IND  = 'A'                          
MFA-TR*                  AND  REBILL_IND    = 'Y'))                             
MFA-TR*         ORDER BY BILL_ITEM_TIMESTMP DESC                                
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*        QUERYNO 7821                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *  DECLARE A CURSOR FOR THE CSS_BILLING_DET TABLE.  THIS CURSOR  *        
      *  IS USED TO RETRIEVE ALL ACTIVE REBILLS. TO APPLY FACTOR       *        
      *                                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE REBILL_CSR CURSOR FOR                             
                 SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           BG.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                           
                       ,BG.BILL_NO                                      
                       ,BG.REV_MTH_ORIG_BILL                            
                   FROM CSS_BILLING_DET BG                              
                  WHERE BG.ACCOUNT_NO         = :FH-ACCOUNT-NO          
                    AND BG.IC_NO              = :FH-IC-NO               
                    AND BG.CODE_UTIL_TYPE     = :FH-CODE-UTIL-TYPE      
                    AND BG.DATE_ORIG_BILL     IS NOT NULL               
                    AND BG.CODE_BILL_ITM_TYPE = 'C'                     
                    AND BG.CODE_BILL_ITM_IND  <> 'K'                    
                    AND BG.REV_MTH_ORIG_BILL  > 0                       
                    AND BG.REVENUE_MONTH      = 0                       
                    AND BG.BILL_ITEM_TIMESTMP <> CIS.CHAR2TIMESTAMP(
                                                 :FH-BILL-ITEM-TIMESTMP
              ) 
                 ORDER BY BG.REV_MTH_ORIG_BILL DESC                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE REBILL_CSR CURSOR FOR                                     
MFA-TR*          SELECT BG.BILL_ITEM_TIMESTMP                                   
MFA-TR*                ,BG.BILL_NO                                              
MFA-TR*                ,BG.REV_MTH_ORIG_BILL                                    
MFA-TR*            FROM CSS_BILLING_DET BG                                      
MFA-TR*           WHERE BG.ACCOUNT_NO         = :FH-ACCOUNT-NO                  
MFA-TR*             AND BG.IC_NO              = :FH-IC-NO                       
MFA-TR*             AND BG.CODE_UTIL_TYPE     = :FH-CODE-UTIL-TYPE              
MFA-TR*             AND BG.DATE_ORIG_BILL     IS NOT NULL                       
MFA-TR*             AND BG.CODE_BILL_ITM_TYPE = 'C'                             
MFA-TR*             AND BG.CODE_BILL_ITM_IND  <> 'K'                            
MFA-TR*             AND BG.REV_MTH_ORIG_BILL  > 0                               
MFA-TR*             AND BG.REVENUE_MONTH      = 0                               
MFA-TR*             AND BG.BILL_ITEM_TIMESTMP <> :FH-BILL-ITEM-TIMESTMP         
MFA-TR*          ORDER BY BG.REV_MTH_ORIG_BILL DESC                             
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *                                                                *        
      *  CURSOR DECLARATION FOR THE CSS_BILL_ADJUSTMNT TABLE.          *        
      *  THIS CURSOR IS USED IN MAINTAINING BILL ADJUSTMNT ROWS.       *        
      *                                                                *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE BILL_ADJ_CRSR CURSOR FOR                         
                   SELECT  ACCOUNT_NO                                   
                          ,BILL_NO                                      
                          ,CODE_UTIL_TYPE                               
                          ,IC_NO                                        
                          ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                           
                          ,ADJ_TYPE_CD                                  
                          ,REVENUE_MONTH                                
                          ,ADJ_REASON_DESC                              
                          ,OVRRIDE_RT_REV_MTH                           
                          ,OVRRIDE_RT_BILL_DT                           
                          ,OVRRIDE_RT_BILL_CY                           
                          ,SPECIAL_PROCESS_CD                           
                   FROM  CSS_BILL_ADJUSTMNT WITH(READUNCOMMITTED)               
                   WHERE ACCOUNT_NO = :BP-ACCOUNT-NO                    
                   AND   BILL_NO = :BP-BILL-NO                          
                   AND   CODE_UTIL_TYPE = :BP-CODE-UTIL-TYPE            
                   AND   IC_NO = :BP-IC-NO                              
                   AND   BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BP-BILL-ITEM-TIMESTMP
              )    
                   FOR READ ONLY                              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE BILL_ADJ_CRSR CURSOR FOR                                 
MFA-TR*            SELECT  ACCOUNT_NO                                           
MFA-TR*                   ,BILL_NO                                              
MFA-TR*                   ,CODE_UTIL_TYPE                                       
MFA-TR*                   ,IC_NO                                                
MFA-TR*                   ,BILL_ITEM_TIMESTMP                                   
MFA-TR*                   ,ADJ_TYPE_CD                                          
MFA-TR*                   ,REVENUE_MONTH                                        
MFA-TR*                   ,ADJ_REASON_DESC                                      
MFA-TR*                   ,OVRRIDE_RT_REV_MTH                                   
MFA-TR*                   ,OVRRIDE_RT_BILL_DT                                   
MFA-TR*                   ,OVRRIDE_RT_BILL_CY                                   
MFA-TR*                   ,SPECIAL_PROCESS_CD                                   
MFA-TR*            FROM  CSS_BILL_ADJUSTMNT                                     
MFA-TR*            WHERE ACCOUNT_NO = :BP-ACCOUNT-NO                            
MFA-TR*            AND   BILL_NO = :BP-BILL-NO                                  
MFA-TR*            AND   CODE_UTIL_TYPE = :BP-CODE-UTIL-TYPE                    
MFA-TR*            AND   IC_NO = :BP-IC-NO                                      
MFA-TR*            AND   BILL_ITEM_TIMESTMP = :BP-BILL-ITEM-TIMESTMP            
MFA-TR*            FOR   FETCH ONLY WITH UR                                     
MFA-TR*            QUERYNO 7210                                                 
MFA-TR*    END-EXEC.                                                            
HPCCDM*    EJECT                                                                
                                                                        
      ******************************************************************        
      *  CURSOR DECLARATION FOR THE CSS_BILL_MAN_DET TABLE.            *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE BILL_MAN_DET CURSOR FOR                          
                   SELECT  NU.ACCOUNT_NO                                
                          ,NU.BILL_NO                                   
                          ,NU.CODE_UTIL_TYPE                            
                          ,NU.IC_NO                                     
                          ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           NU.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                        
                          ,NU.BILL_MAN_DET_SEQ                          
                          ,NU.BILL_MANUAL_TBL_ID                        
                          ,NU.BILL_MANUAL_DATA                          
                   FROM  CSS_BILL_MAN_DET NU WITH(READUNCOMMITTED)              
                   WHERE NU.ACCOUNT_NO         = :NU-ACCOUNT-NO         
                   AND   NU.BILL_NO            = :NU-BILL-NO            
                   AND   NU.CODE_UTIL_TYPE     = :NU-CODE-UTIL-TYPE     
                   AND   NU.IC_NO              = :NU-IC-NO              
                   AND   NU.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :NU-BILL-ITEM-TIMESTMP
              ) 
                   FOR READ ONLY                              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE BILL_MAN_DET CURSOR FOR                                  
MFA-TR*            SELECT  NU.ACCOUNT_NO                                        
MFA-TR*                   ,NU.BILL_NO                                           
MFA-TR*                   ,NU.CODE_UTIL_TYPE                                    
MFA-TR*                   ,NU.IC_NO                                             
MFA-TR*                   ,NU.BILL_ITEM_TIMESTMP                                
MFA-TR*                   ,NU.BILL_MAN_DET_SEQ                                  
MFA-TR*                   ,NU.BILL_MANUAL_TBL_ID                                
MFA-TR*                   ,NU.BILL_MANUAL_DATA                                  
MFA-TR*            FROM  CSS_BILL_MAN_DET NU                                    
MFA-TR*            WHERE NU.ACCOUNT_NO         = :NU-ACCOUNT-NO                 
MFA-TR*            AND   NU.BILL_NO            = :NU-BILL-NO                    
MFA-TR*            AND   NU.CODE_UTIL_TYPE     = :NU-CODE-UTIL-TYPE             
MFA-TR*            AND   NU.IC_NO              = :NU-IC-NO                      
MFA-TR*            AND   NU.BILL_ITEM_TIMESTMP = :NU-BILL-ITEM-TIMESTMP         
MFA-TR*            FOR   FETCH ONLY WITH UR                                     
MFA-TR*            QUERYNO 7975                                                 
MFA-TR*    END-EXEC.                                                            
      ******************************************************************        
      *   COMMAREA SIZE CHANGED FROM 550 TO 600                        *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
       01 WS-TEMP-FIELDS.                                               
          05 WS-READ-CODES.                                             
             10 WS-NORMAL-READ          PIC X(01)   VALUE 'J'.          
             10 WS-VERIFIED-READ        PIC X(01)   VALUE 'K'.          
             10 WS-CARD-READ            PIC X(01)   VALUE 'C'.          
             10 WS-NO-READ              PIC X(01)   VALUE 'N'.          
             10 WS-AWAITING-READ        PIC X(01)   VALUE 'D'.          
             10 WS-CORRECTED-READ       PIC X(01)   VALUE 'X'.          
             10 WS-MTR-ADMN-READ        PIC X(01)   VALUE 'M'.          
          05 WS-EDIT-DEC-ZERO            PIC ---------9.                
          05 WS-EDIT-DEC-ONE             PIC ---------9.9.              
          05 WS-EDIT-DEC-TWO             PIC ---------9.99.             
          05 WS-EDIT-DEC-THREE           PIC ---------9.999.            
          05 WS-EDIT-DEC-FOUR            PIC ---------9.9999.           
A05460    05 WS-DISPLAY-DEC-FOUR         PIC ZZZZZZZZ9.9999-.           
A05460    05 WS-FACTOR-FH-TEMP           PIC S9(09)V9(04) USAGE COMP-3  
A05460                                   VALUE 0.                       
          05 IN-BG-IDX                   PIC S9(4) COMP.                
          05 IN-CX-IDX                   PIC S9(4) COMP.                
          05 IN-UC-IDX                   PIC S9(4) COMP.                
          05 IN-FH-IDX                   PIC S9(4) COMP.                
          05 IN-BP-IDX                   PIC S9(4) COMP.                
          05 MATCH-IDX                   PIC S9(4) COMP.                
          05 WS-CALC-COMMAND             PIC X(1) VALUE ' '.            
          05 WS-CODE-SHORT-DESC          PIC X(15) VALUE SPACES.        
          05 WS-FUNCTION                 PIC X(01).                     
             88 BILL-CANCEL-REBILL       VALUE 'R'.                     
             88 BILL-CANCEL              VALUE 'K'.                     
             88 BILL-CHANGE              VALUE 'C'.                     
             88 BILL-CREATE              VALUE 'I'.                     
             88 BILL-DELETE              VALUE 'D'.                     
             88 FUTURE-TO-IMMIDIATE      VALUE 'Z'.                     
             88 IMMIDIATE-TO-FUTURE      VALUE 'X'.                     
             88 MANUAL-CALC              VALUE 'M'.                     
             88 METER-POST               VALUE 'T'.                     
       01 WS-BI-ORIG-DATA.                                              
          05 WS-DATE-BILLED          PIC X(10).                         
          05 WS-CODE-BILL-REASON     PIC X(1).                          
          05 WS-CODE-BILL-STATUS     PIC X(1).                          
          05 WS-CODE-BILL-TYPE       PIC X(1).                          
COB305    05 WS-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.          
          05 WS-CODE-SPCL-BILL       PIC X(1).                          
          05 WS-PREM-ACCT-SEQ-NO     PIC S9(9) USAGE COMP.              
          05 WS-SMRY-BILL-NO         PIC S9(9) USAGE COMP.              
          05 WS-SMRY-REBILL-NO       PIC S9(9) USAGE COMP.              
COB305    05 WS-ACCOUNT-NO-SUMM        PIC S9(10)V USAGE COMP-3 VALUE 0.        
COB305    05 WS-TOT-OTHER-CHARGES        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.       
COB305    05 WS-TOTAL-ARREARS        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.       
          05 WS-BILL-CORRECTED-CD    PIC X(1).                          
          05 WS-DATE-BILLED-NULL     PIC S9(4) COMP VALUE 0.            
       01 WS-BG-ORIG-DATA.                                              
          05 WS-ORIG-IC-NO           PIC S9(4) COMP.                    
          05 WS-ORIG-BILL-NO         PIC S9(9) USAGE COMP.              
          05 WS-ORIG-ITEM-TIMESTMP   PIC X(26).                         
          05 WS-DATE-ORIG-BILL       PIC X(10).                         
COB305    05 WS-BG-AMT-BILL-ITEM        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.       
          05 WS-CODE-BILL-CALC       PIC X(1).                          
          05 WS-CODE-BILL-ITM-TYPE   PIC X(1).                          
          05 WS-CODE-BILL-ITM-IND    PIC X(1).                          
          05 WS-CODE-DR-CR-CNSMPTN   PIC X(1).                          
COB305    05 WS-AMT-STATE-TAX        PIC S9(7)V9(2) USAGE COMP-3 
COB305       VALUE 0.       
COB305    05 WS-AMT-CITY-TAX        PIC S9(7)V9(2) USAGE COMP-3 VALUE 0.       
COB305    05 WS-AMT-OTHER-TAX        PIC S9(7)V9(2) USAGE COMP-3 
COB305       VALUE 0.       
          05 WS-CODE-REVENUE-CLASS   PIC X(3).                          
          05 WS-CODE-SIC-NO          PIC X(4).                          
          05 WS-RATE-PLAN-NO         PIC X(3).                          
COB305    05 WS-CODE-CURTAIL-PRTY        PIC S9(2)V9(1) USAGE COMP-3 
COB305       VALUE 0.       
          05 WS-CODE-STAT-TAX-XMT    PIC X(1).                          
          05 WS-CODE-CITY-TAX-XMT    PIC X(1).                          
          05 WS-CODE-OTHR-TAX-XMT    PIC X(1).                          
          05 WS-REV-RPT-CD           PIC X(1).                          
          05 WS-STANDBY-COMPLIED     PIC X(1).                          
          05 WS-PRORATE-CD           PIC X(1).                          
COB305    05 WS-NEW-RATE-PCT        PIC SV9(4) USAGE COMP-3 VALUE 0.           
          05 WS-CODE-SUB-TOTAL       PIC S9(4) USAGE COMP.              
          05 WS-TAX-REFUND-CD        PIC X(1).                          
          05 WS-DATE-LFTM-HI-DMD     PIC X(10).                         
COB305    05 WS-LFTM-HI-PEAK-DMD        PIC S9(7)V USAGE COMP-3 VALUE 0.        
          05 WS-REBILL-IND           PIC X(1).                          
          05 WS-ADJ-REASON-CD        PIC X(4).                          
COB305    05 WS-REVENUE-MONTH        PIC S9(6)V USAGE COMP-3 VALUE 0.           
COB305    05 WS-GAS-BASE-USE        PIC S9(9)V USAGE COMP-3 VALUE 0.           
COB305    05 WS-WNA-FACTOR        PIC S9(2)V9(5) USAGE COMP-3 VALUE 0.       
COB305    05 WS-BTU-FACTOR        PIC S9(2)V9(5) USAGE COMP-3 VALUE 0.       
          05 WS-NO-OF-CONS-DAYS      PIC S9(4) USAGE COMP.              
COB305    05 WS-REV-MTH-ORIG-BILL        PIC S9(6)V USAGE COMP-3 
COB305       VALUE 0.           
COB305    05 WS-REV-MTH-ORIG-BILL1        PIC S9(6)V USAGE COMP-3 
COB305       VALUE 0.           
          05 WS-REV-DISTRICT-CD      PIC X(3).                          
          05 WS-FUEL-SHIPPER-CD      PIC X(1).                          
          05 WS-ALTERNATE-FUEL-CD    PIC X(1).                          
          05 WS-TRNSP-OVER-MDQ-FL    PIC X(1).                          
COB305    05 WS-CITY-TAX-RATE        PIC S9(1)V9(4) USAGE COMP-3 
COB305       VALUE 0.       
COB305    05 WS-OTHER-TAX-RATE        PIC S9(1)V9(4) USAGE COMP-3 
COB305       VALUE 0.       
COB305    05 WS-STATE-TAX-RATE        PIC S9(1)V9(4) USAGE COMP-3 
COB305       VALUE 0.       
          05 WS-BILL-CALC-CYCLE      PIC X(2).                          
          05 WS-NAICS-CD             PIC X(6).                          
          05 WS-RT-PKG-OPT-SEQ-NO    PIC S9(4) USAGE COMP.              
          05 WS-DATE-ORIG-BILL-NULL    PIC S9(4) COMP VALUE 0.          
          05 WS-DATE-LFTM-HI-DMD-NULL  PIC S9(4) COMP VALUE 0.          
          05 WS-HOLD-REVENUE-MONTH     PIC S9(6) COMP-3 VALUE 0.        
A05460    05 WS-CODE-UTIL-TYPE       PIC X(1).                          
                                                                        
       01 IN-HEADER-DATA.                                               
COB305    05 IN-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.       
          05 IN-CODE-UTIL-TYPE          PIC X(1).                       
          05 IN-IC-NO                   PIC S9(4) USAGE COMP.           
          05 IN-CODE-TEMP-BILL          PIC X(01).                      
       01 IN-BG-DATA.                                                   
          05 IN-BG-RECORD-KEY           PIC 9(04).                      
          05 IN-BILL-NO                 PIC S9(9) USAGE COMP.           
          05 IN-BILL-ITEM-TIMESTMP      PIC X(26).                      
          05 IN-DATE-BILLED             PIC X(10).                      
COB305    05 IN-AMT-BILL-ITEM        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.    
COB305    05 IN-AMT-STATE-TAX        PIC S9(7)V9(2) USAGE COMP-3 
COB305       VALUE 0.    
COB305    05 IN-AMT-CITY-TAX        PIC S9(7)V9(2) USAGE COMP-3 VALUE 0.    
COB305    05 IN-AMT-OTHER-TAX        PIC S9(7)V9(2) USAGE COMP-3 
COB305       VALUE 0.    
          05 IN-CODE-REVENUE-CLASS      PIC X(03).                      
          05 IN-CODE-SIC-NO             PIC X(04).                      
          05 IN-RATE-PLAN-NO            PIC X(03).                      
      *** POPULATE THIS                                                         
          05 IN-CODE-DR-CR-CNSMPTN      PIC X(01).                      
          05 IN-CODE-STAT-TAX-XMT       PIC X(01).                      
          05 IN-CODE-CITY-TAX-XMT       PIC X(01).                      
          05 IN-CODE-OTHR-TAX-XMT       PIC X(01).                      
          05 IN-PRORATE-CD              PIC X(01).                      
          05 IN-SHIPPER                 PIC X(01).                      
          05 IN-TRNSP-OVER-MDQ-FL       PIC X(01).                      
          05 IN-RT-PKG-OPT-SEQ-NO       PIC S9(4) USAGE COMP.           
          05 IN-BG-ADJ-REASON-CD        PIC X(04).                      
          05 IN-CX-UC-RECORD-IND        PIC X(01).                      
             88 UN-METERED-IC           VALUE 'U'.                      
             88 METERED-IC              VALUE 'C'.                      
A05744       88 NO-UN-CX-CHANGED        VALUE ' '.                      
COB305    05 IN-BG-BTU-FACTOR        PIC S9(2)V9(5) USAGE COMP-3 
COB305       VALUE 0.    
COB305    05 IN-BG-GAS-BASE-USE        PIC S9(9)V USAGE COMP-3 VALUE 0.        
          05 IN-CX-DATA-REC  OCCURS 100 TIMES.                          
             10 IN-CX-CHANGE-INDICATOR  PIC X(01).                      
             10 IN-CX-MTR-REF-NO           PIC S9(4) USAGE COMP.        
             10 IN-CX-REG-ID-NO            PIC S9(4) USAGE COMP.        
             10 IN-CX-CODE-TIME-PERIOD     PIC S9(4) USAGE COMP.        
             10 IN-CX-ITEM-SEQ-NO          PIC S9(4) USAGE COMP.        
             10 IN-CX-CODE-USAGE-TYPE      PIC X(01).                   
             10 IN-CX-CODE-USAGE-ID        PIC X(01).                   
             10 IN-CX-CODE-USAGE-SOURCE    PIC X(01).                   
             10 IN-CX-CODE-SOURCE-ID       PIC X(01).                   
             10 IN-CX-CODE-TOU-SEASN       PIC X(01).                   
             10 IN-CX-METER-NO             PIC X(09).                   
             10 IN-CX-DATE-READ            PIC X(10).                   
             10 IN-CX-CODE-METER-READ      PIC X(01).                   
             10 IN-CX-CODE-METER-NO-READ   PIC X(01).                   
COB305       10 IN-CX-METER-READING        PIC S9(11)V USAGE COMP-3 
COB305          VALUE 0.    
COB305       10 IN-CX-DEMAND-READING        PIC S9(8)V9(3) USAGE COMP-3 
COB305          VALUE 0. 
             10 IN-CX-CODE-DEBIT-CREDIT    PIC X(01).                   
COB305       10 IN-CX-NO-UNITS        PIC S9(9)V USAGE COMP-3 VALUE 0.     
COB305       10 IN-CX-NO-DEMAND-UNITS        PIC S9(9)V USAGE COMP-3 
COB305          VALUE 0.     
             10 IN-CX-NO-DAYS              PIC S9(4) USAGE COMP.        
             10 IN-CX-CODE-ITEM-STATUS     PIC X(01).                   
COB305       10 IN-CX-CONSTANT        PIC S9(6)V9(5) USAGE COMP-3 
COB305          VALUE 0. 
             10 IN-CX-NO-DIALS             PIC S9(4) USAGE COMP.        
             10 IN-CX-EXCEPT-OVERRIDE-CD   PIC X(01).                   
             10 IN-CX-EXCL-DMD-RCHT-IND    PIC X(01).                   
             10 IN-CX-AGLMTCHRG-FLAG       PIC X(01).                   
COB305       10 IN-CX-PCOMP-FCT        PIC S9(2)V9(5) USAGE COMP-3 
COB305          VALUE 0. 
             10 IN-CX-PROCESS-CD           PIC X(01).                   
             10 IN-CX-MN-RG-PROCESS-CD     PIC X(02).                   
             10 IN-CX-HIGH-VALUE           PIC S9(09)V9 COMP-3 VALUE +0.
             10 IN-CX-LOW-VALUE            PIC S9(09)V9 COMP-3 VALUE +0.
             10 IN-CX-PERMANENT-UPDATE     PIC X(01).                   
          05 IN-UC-DATA-REC  OCCURS 100 TIMES.                          
             10 IN-UC-CHANGE-INDICATOR   PIC X(01).                     
             10 IN-UC-RATE-ITEM-CODE     PIC S9(4) USAGE COMP.          
             10 IN-UC-ITEM-SEQ-NO        PIC S9(4) USAGE COMP.          
             10 IN-UC-NO-UNITS           PIC S9(9) USAGE COMP.          
             10 IN-UC-NO-DAYS            PIC S9(4) USAGE COMP.          
             10 IN-UC-CODE-DEBIT-CREDIT  PIC X(01).                     
COB305       10 IN-UC-USAGE-FIXED        PIC S9(9)V USAGE COMP-3 
COB305          VALUE 0.       
             10 IN-UC-DATE-USAGE-ENDS    PIC X(10).                     
             10 IN-UC-CODE-SERVICE-TYPE  PIC X(01).                     
             10 IN-UC-CODE-ITEM-STATUS   PIC X(01).                     
             10 IN-UC-CODE-SOURCE-ID     PIC X(01).                     
COB305       10 IN-UC-MTHLY-AMOUNT-FIXED        PIC S9(9)V9(2) 
COB305          USAGE COMP-3 VALUE 0.   
             10 IN-UC-DIST-NO            PIC X(03).                     
             10 IN-UC-LIGHT-NO           PIC S9(4) USAGE COMP.          
             10 IN-UC-POLE-NO            PIC X(07).                     
             10 IN-UC-PROCESS-CD         PIC X(01).                     
             10 IN-UC-PERMANENT-UPDATE   PIC X(01).                     
          05 IN-FH-DATA-REC  OCCURS 100 TIMES.                          
             10 IN-FH-CHANGE-INDICATOR      PIC X(01).                  
             10 IN-FH-FIXED-FCTR-SEQ-NO     PIC S9(4) USAGE COMP.       
             10 IN-FH-FACTOR-ID             PIC X(09).                  
COB305       10 IN-FH-FACTOR        PIC S9(9)V9(4) USAGE COMP-3 VALUE 0.
             10 IN-FH-BLOCK-NO              PIC S9(4) USAGE COMP.       
             10 IN-FH-EFF-DATE-FROM         PIC X(10).                  
             10 IN-FH-EFF-DATE-TO           PIC X(10).                  
             10 IN-FH-CODE-SEASON           PIC X(01).                  
             10 IN-FH-INSTR-USE-TYPE-CD     PIC X(01).                  
             10 IN-FH-CODE-TIME-PERIOD      PIC S9(4) USAGE COMP.       
             10 IN-FH-CMPNT-ID-CD           PIC X(02).                  
             10 IN-FH-FIXED-FCTR-TYP-CD     PIC X(02).                  
COB305       10 IN-FF-FAC-CHRG-BASE-AM        PIC S9(7)V9(2) 
COB305          USAGE COMP-3 VALUE 0.
             10 IN-FH-DURATION-REMAIN-NO    PIC X(4).                   
             10 IN-FH-OPTION-CD             PIC X(12).                  
             10 IN-FH-FCTR-POWER-10         PIC S9(4) USAGE COMP.       
             10 IN-FH-CODE-DEBIT-CREDIT     PIC X(01).                  
             10 IN-FH-APPLY-ALL-REBILLS     PIC X(01).                  
             10 IN-FH-PROCESS-CD            PIC X(01).                  
          05 IN-BP-DATA-REC  OCCURS 100 TIMES.                          
             10 IN-BP-CHANGE-INDICATOR      PIC X(01).                  
             10 IN-BP-ADJ-TYPE-CD           PIC X(04).                  
COB305       10 IN-BP-REVENUE-MONTH        PIC S9(6) COMP-3 VALUE 0.           
COB305       10 IN-BP-OVRRIDE-RT-REV-MTH        PIC S9(6) COMP-3 
COB305          VALUE 0.           
             10 IN-BP-SPECIAL-PROCESS-CD    PIC X(02).                  
             10 IN-BP-PROCESS-CD            PIC X(01).                  
       01 WS-TRANS-HIST-DATA.                                           
          05 TH-SUB-MAX                     PIC S9(4) USAGE COMP.       
          05 TH-SUB                         PIC S9(4) USAGE COMP.       
A05460    05 WS-TH-FIELDS OCCURS 300 TIMES                              
                 INDEXED BY TH-INDEX.                                   
             10 WS-TABLE-ID                 PIC X(02).                  
             10 WS-COLUMN-DESC              PIC X(15).                  
             10 WS-PRV-COLUMN-VALUE.                                    
                15 WS-PRV-COLUMN-VALUE-LEN  PIC S9(4) USAGE COMP.       
                15 WS-PRV-COLUMN-VALUE-TXT  PIC X(75).                  
             10 WS-CHG-COLUMN-VALUE.                                    
                15 WS-CHG-COLUMN-VALUE-LEN  PIC S9(4) USAGE COMP.       
                15 WS-CHG-COLUMN-VALUE-TXT  PIC X(75).                  
                                                                        
      *** HEADER LENGTH = 74                                                    
       01 PARM-HEADER-DATA.                                             
          05 PARM-FUNCTION               PIC X(01).                     
          05 PARM-BILL-WHEN              PIC X(02).                     
             88 BILL-WHEN-IMMIDIATE      VALUE 'RB'.                    
             88 BILL-WHEN-FUTURE         VALUE 'FB'.                    
             88 BILL-WHEN-VALID          VALUE 'FB', 'RB'.              
          05 PARM-USER-ID                PIC X(07).                     
          05 PARM-BILL-CORRECTED-CD      PIC X(01).                     
          05 PARM-CODE-TEMP-BILL         PIC X(01).                     
          05 PARM-DELETE-ALL-REBILLS     PIC X(01).                     
          05 PARM-EXEMPT-FL              PIC X(01).                     
          05 PARM-ACCOUNT-NO             PIC 9(13).                     
          05 PARM-IC-NO                  PIC 9(04).                     
          05 PARM-CODE-UTIL-TYPE         PIC X(01).                     
          05 PARM-LAST-UPDATE-TS         PIC X(26).                     
          05 PARM-ADJ-REASON-CD          PIC X(04).                     
          05 PARM-COPY-IDR-DATA          PIC X(01).                     
          05 PARM-PERMANENT-UPDATE       PIC X(01).                     
          05 PARM-TRNSP-OVER-MDQ-FL      PIC X(01).                     
          05 PARM-BILL-CORR-VIEW         PIC X(01).                     
          05 PARM-COPY-CX-DATA           PIC X(01).                     
          05                             PIC X(04).                     
                                                                        
       01 PARM-COMMENTS.                                                
          49 PARM-COMMENTS-LEN         PIC S9(004) USAGE COMP.          
          49 PARM-COMMENTS-TXT         PIC  X(250).                     
                                                                        
       01 PARM-ADJ-DESC.                                                
          49 PARM-ADJ-DESC-LEN         PIC S9(004) USAGE COMP.          
          49 PARM-ADJ-DESC-TXT         PIC  X(255).                     
                                                                        
AA5744*** BG LENGTH = 132 * 15=1980                                             
       01 PARM-BG-DATA.                                                 
A05460    05 PARM-BG-DATA-REC OCCURS 15 TIMES INDEXED BY PARM-BG-IDX.   
             10 PARM-BG-RECORD-KEY       PIC 9(04).                     
             10 PARM-BILL-NO             PIC 9(09).                     
             10 PARM-BILL-ITEM-TIMESTMP  PIC X(26).                     
             10 PARM-DATE-BILLED         PIC X(10).                     
             10 PARM-AMT-BILL-ITEM       PIC X(12).                     
             10 PARM-AMT-STATE-TAX       PIC X(10).                     
             10 PARM-AMT-CITY-TAX        PIC X(10).                     
             10 PARM-AMT-OTHER-TAX       PIC X(10).                     
             10 PARM-CODE-REVENUE-CLASS  PIC X(03).                     
             10 PARM-CODE-SIC-NO         PIC X(04).                     
             10 PARM-RATE-PLAN-NO        PIC X(03).                     
             10 PARM-CODE-STAT-TAX-XMT   PIC X(01).                     
             10 PARM-CODE-CITY-TAX-XMT   PIC X(01).                     
             10 PARM-CODE-OTHR-TAX-XMT   PIC X(01).                     
             10 PARM-PRORATE-CD          PIC X(01).                     
             10 PARM-SHIPPER             PIC X(01).                     
             10 PARM-BG-TRNSP-OVER-MDQ   PIC X(01).                     
             10 PARM-RT-PKG-OPT-SEQ-NO   PIC 9(04).                     
             10 PARM-BG-ADJ-REASON-CD    PIC X(04).                     
             10 PARM-CX-UC-RECORD-IND    PIC X(01).                     
A05460       10 PARM-BG-BTU-FACTOR       PIC X(07).                     
AA5744       10 PARM-BG-GAS-BASE-USE     PIC 9(09).                     
                                                                        
      *** CX LENGTH =  97 * 100 = 9700                                          
       01 PARM-CX-DATA.                                                 
          05 PARM-CX-DATA-REC  OCCURS 100 TIMES INDEXED BY PARM-CX-IDX. 
             10 PARM-CX-RECORD-KEY         PIC 9(04).                   
             10 PARM-CX-CHANGE-INDICATOR   PIC X(01).                   
             10 PARM-CX-MTR-REF-NO         PIC 9(04).                   
             10 PARM-CX-REG-ID-NO          PIC 9(04).                   
             10 PARM-CX-CODE-TIME-PERIOD   PIC 9(04).                   
             10 PARM-CX-ITEM-SEQ-NO        PIC 9(04).                   
             10 PARM-CX-CODE-USAGE-TYPE    PIC X(01).                   
             10 PARM-CX-CODE-USAGE-ID      PIC X(01).                   
             10 PARM-CX-CODE-USAGE-SOURCE  PIC X(01).                   
             10 PARM-CX-CODE-TOU-SEASN     PIC X(01).                   
             10 PARM-CX-METER-NO           PIC X(09).                   
             10 PARM-CX-DATE-READ          PIC X(10).                   
             10 PARM-CX-CODE-METER-READ    PIC X(01).                   
             10 PARM-CX-CODE-METER-NO-READ PIC X(01).                   
             10 PARM-CX-METER-READING      PIC X(11).                   
             10 PARM-CX-NO-UNITS           PIC X(09).                   
             10 PARM-CX-NO-DAYS            PIC X(04).                   
             10 PARM-CX-CODE-ITEM-STATUS   PIC X(01).                   
             10 PARM-CX-CONSTANT           PIC 9(11).                   
             10 PARM-CX-NO-DIALS           PIC X(04).                   
             10 PARM-CX-EXCEPT-OVERRIDE-CD PIC X(01).                   
             10 PARM-CX-EXCL-DMD-RCHT-IND  PIC X(01).                   
             10 PARM-CX-PERMANENT-UPDATE   PIC X(01).                   
             10 PARM-CX-AGLMTCHRG-FLAG     PIC X(01).                   
             10 PARM-CX-PCOMP-FCT          PIC 9(07).                   
                                                                        
      *** UC LENGTH =  75 * 100 = 7500                                          
       01 PARM-UC-DATA.                                                 
          05 PARM-UC-DATA-REC  OCCURS 100 TIMES INDEXED BY PARM-UC-IDX. 
             10 PARM-UC-RECORD-KEY         PIC 9(04).                   
             10 PARM-UC-CHANGE-INDICATOR   PIC X(01).                   
             10 PARM-UC-RATE-ITEM-CODE     PIC 9(04).                   
             10 PARM-UC-ITEM-SEQ-NO        PIC 9(04).                   
             10 PARM-UC-NO-UNITS           PIC X(09).                   
             10 PARM-UC-NO-DAYS            PIC X(04).                   
             10 PARM-UC-USAGE-FIXED        PIC X(10).                   
             10 PARM-UC-DATE-USAGE-ENDS    PIC X(10).                   
             10 PARM-UC-CODE-SERVICE-TYPE  PIC X(01).                   
             10 PARM-UC-CODE-ITEM-STATUS   PIC X(01).                   
             10 PARM-UC-CODE-SOURCE-ID     PIC X(01).                   
             10 PARM-UC-MTHLY-AMOUNT-FIXED PIC X(12).                   
             10 PARM-UC-DIST-NO            PIC X(03).                   
             10 PARM-UC-LIGHT-NO           PIC X(04).                   
             10 PARM-UC-POLE-NO            PIC X(07).                   
             10 PARM-UC-PERMANENT-UPDATE   PIC X(01).                   
                                                                        
      *** FH LENGTH =  96 * 100 = 9600                                          
       01 PARM-FH-DATA.                                                 
          05 PARM-FH-DATA-REC  OCCURS 100 TIMES INDEXED BY PARM-FH-IDX. 
             10 PARM-FH-RECORD-KEY            PIC X(04).                
             10 PARM-FH-CHANGE-INDICATOR      PIC X(01).                
             10 PARM-FH-FXD-FCTR-SEQ-NO       PIC X(04).                
             10 PARM-FH-FACTOR-ID             PIC X(09).                
             10 PARM-FH-FACTOR                PIC X(16).                
             10 PARM-FH-BLOCK-NO              PIC X(04).                
             10 PARM-FH-DATE-FROM             PIC X(10).                
             10 PARM-FH-DATE-TO               PIC X(10).                
             10 PARM-FH-SEASON                PIC X(01).                
             10 PARM-FH-INSTR-USE-TYPE-CD     PIC X(01).                
             10 PARM-FH-CODE-TIME-PERIOD      PIC X(04).                
             10 PARM-FH-CMPNT-ID-CD           PIC X(02).                
             10 PARM-FH-FIXED-FCTR-TYP-CD     PIC X(02).                
             10 PARM-FF-FAC-CHRG-BASE-AM      PIC X(10).                
             10 PARM-FH-DURATION-REMAIN-NO    PIC X(04).                
             10 PARM-FH-OPTION-CD             PIC X(12).                
             10 PARM-FH-FCTR-POWER-10         PIC X(04).                
             10 PARM-FH-APPLY-ALL-REBILLS     PIC X(01).                
       01 PARM-BP-DATA.                                                 
          05 PARM-BP-DATA-REC  OCCURS 100 TIMES INDEXED BY PARM-BP-IDX. 
             10 PARM-BP-RECORD-KEY            PIC X(04).                
             10 PARM-BP-CHANGE-INDICATOR      PIC X(01).                
             10 PARM-BP-ADJ-TYPE-CD           PIC X(08).                
             10 PARM-BP-REVENUE-MONTH         PIC X(06).                
             10 PARM-BP-OVRRIDE-RT-REV-MTH    PIC X(06).                
             10 PARM-BP-SPECIAL-PROCESS-CD    PIC X(02).                
      ******************************************************************        
       LINKAGE SECTION.                                                 
      ******************************************************************        
       01 LINK-HEADER-DATA             PIC  X(070).                     
       01 LINK-COMMENTS.                                                
          49 LINK-COMMENTS-LEN         PIC S9(0004) USAGE COMP.         
          49 LINK-COMMENTS-TXT         PIC  X(0250).                    
       01 LINK-ADJ-DESC.                                                
          49 LINK-ADJ-DESC-LEN         PIC S9(0004) USAGE COMP.         
          49 LINK-ADJ-DESC-TXT         PIC  X(0255).                    
       01 LINK-BG-DATA.                                                 
          49 LINK-BG-DATA-LEN          PIC S9(0004) USAGE COMP.         
AA5744    49 LINK-BG-DATA-TXT          PIC  X(1980).                    
       01 LINK-CX-DATA.                                                 
          49 LINK-CX-DATA-LEN          PIC S9(0004) USAGE COMP.         
          49 LINK-CX-DATA-TXT          PIC  X(9700).                    
       01 LINK-UC-DATA.                                                 
          49 LINK-UC-DATA-LEN          PIC S9(0004) USAGE COMP.         
          49 LINK-UC-DATA-TXT          PIC  X(7500).                    
       01 LINK-FH-DATA.                                                 
          49 LINK-FH-DATA-LEN          PIC S9(0004) USAGE COMP.         
          49 LINK-FH-DATA-TXT          PIC  X(9600).                    
       01 LINK-BP-DATA.                                                 
          49 LINK-BP-DATA-LEN          PIC S9(0004) USAGE COMP.         
          49 LINK-BP-DATA-TXT          PIC  X(2700).                    
                                                                        
      ******************************************************************        
      ****       *       *       *        *      *       *       *    **        
      ***  *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
      ***    *       *       *       *       *       *       *       ***        
      ******************************************************************        
      ******************************************************************        
       PROCEDURE DIVISION USING  LINK-HEADER-DATA                       
                                , LINK-COMMENTS                         
                                , LINK-ADJ-DESC                         
                                , LINK-BG-DATA                          
                                , LINK-CX-DATA                          
                                , LINK-UC-DATA                          
                                , LINK-FH-DATA                          
                                , LINK-BP-DATA.                         
                                                                        
      ******************************************************************        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      *================================================================*        
       0000-MAINLINE.                                                   
      *================================================================*        
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT            
              VARYING PARM-BG-IDX FROM 1 BY 1                           
SCA006           UNTIL PARM-BG-IDX > 15 OR 
                       PARM-BG-RECORD-KEY(PARM-BG-IDX) = SPACES.                
           PERFORM 8100-SEND-RESULT    THRU 8100-EXIT                   
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       0100-INITIALIZE.                                                 
      *================================================================*        
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR                               
                               WITH ROWSET POSITIONING FOR              
             SELECT                                                     
              :S-RETURN-CODE              AS    RETURN_CODE             
             ,:S-BUS-RULE-ID              AS    BUS_RULE_ID             
             ,:S-BUS-RESULT-CD            AS    BUS_RESULT_CD           
             ,:S-BUS-RULE-XREF-ID         AS    BUS_RULE_XREF_ID        
              FROM CIS.SYSDUMMY1                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN                                      
MFA-TR*                        WITH ROWSET POSITIONING FOR                      
MFA-TR*      SELECT                                                             
MFA-TR*       :S-RETURN-CODE              AS    RETURN_CODE                     
MFA-TR*      ,:S-BUS-RULE-ID              AS    BUS_RULE_ID                     
MFA-TR*      ,:S-BUS-RESULT-CD            AS    BUS_RESULT_CD                   
MFA-TR*      ,:S-BUS-RULE-XREF-ID         AS    BUS_RULE_XREF_ID                
MFA-TR*       FROM SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
           INITIALIZE         PARM-HEADER-DATA                          
                              PARM-COMMENTS                             
                              PARM-ADJ-DESC                             
                              PARM-BG-DATA                              
                              PARM-CX-DATA                              
                              PARM-UC-DATA                              
                              PARM-FH-DATA.                             
           MOVE LINK-HEADER-DATA              TO PARM-HEADER-DATA       
           MOVE LINK-COMMENTS                 TO PARM-COMMENTS          
           MOVE LINK-ADJ-DESC-TXT (1:LINK-ADJ-DESC-LEN)                 
                                              TO PARM-ADJ-DESC-TXT      
           MOVE LINK-ADJ-DESC-LEN             TO PARM-ADJ-DESC-LEN      
           MOVE LINK-COMMENTS-TXT (1:LINK-COMMENTS-LEN)                 
                                              TO PARM-COMMENTS-TXT      
           MOVE LINK-COMMENTS-LEN             TO PARM-COMMENTS-LEN      
           MOVE LINK-BG-DATA-TXT (1:LINK-BG-DATA-LEN)                   
                                              TO PARM-BG-DATA           
           MOVE LINK-CX-DATA-TXT (1:LINK-CX-DATA-LEN)                   
                                              TO PARM-CX-DATA           
           MOVE LINK-UC-DATA-TXT (1:LINK-UC-DATA-LEN)                   
                                              TO PARM-UC-DATA           
           MOVE LINK-FH-DATA-TXT (1:LINK-FH-DATA-LEN)                   
                                              TO PARM-FH-DATA.          
           MOVE LINK-BP-DATA-TXT (1:LINK-BP-DATA-LEN)                   
                                              TO PARM-BP-DATA.          
                                                                        
           IF BILL-WHEN-VALID                                           
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CR00000016'           TO RS-BUS-RULE-ID             
              PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-ACCOUNT-NO NOT NUMERIC                               
              OR PARM-IC-NO   NOT NUMERIC                               
              OR PARM-CODE-UTIL-TYPE <= SPACES                          
              OR PARM-FUNCTION <= SPACES                                
              OR PARM-USER-ID <= SPACES                                 
      ***   VALIDATION ERROR                                                    
              MOVE 'CR00000063'           TO RS-BUS-RULE-ID             
              PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT           
           END-IF.                                                      
                                                                        
           MOVE PARM-FUNCTION                 TO WS-FUNCTION            
           IF MANUAL-CALC                                               
              MOVE 'S'                        TO WS-CALC-COMMAND        
           ELSE                                                         
              MOVE 'A'                        TO WS-CALC-COMMAND        
           END-IF.                                                      
           PERFORM 7020-SELECT-CUR-DATE  THRU 7020-EXIT                 
           MOVE WS-CURRENT-DATE   TO BI-DATE-BILLED                     
                                                                        
           PERFORM 7045-GET-FUNCTION-DESC     THRU 7045-EXIT            
                                                                        
           MOVE PARM-ACCOUNT-NO               TO IN-ACCOUNT-NO          
           MOVE PARM-CODE-UTIL-TYPE           TO IN-CODE-UTIL-TYPE      
           MOVE PARM-IC-NO                    TO IN-IC-NO               
           MOVE PARM-CODE-TEMP-BILL           TO IN-CODE-TEMP-BILL      
           MOVE IN-ACCOUNT-NO                 TO AT-ACCOUNT-NO          
           MOVE SPACES                        TO AT-LAST-UPDATE-TS      
                                                 AT-ACCT-FINALED-DT     
                                                 AT-DATE-LAST-ACTION    
           PERFORM 7000-SELECT-ACCOUNT        THRU 7000-EXIT.           
                                                                        
           IF PARM-LAST-UPDATE-TS = AT-LAST-UPDATE-TS                   
              AND AT-LAST-UPDATE-TS > SPACES                            
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CR00000014'           TO RS-BUS-RULE-ID             
              PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT           
           END-IF.                                                      
                                                                        
           MOVE AT-COMPANY-NO                 TO MC-COMPANY-NO          
                                                 C8-COMPANY-NO          
           MOVE ZERO                          TO WS-DATABASE            
           MOVE 'DATABASE'                    TO C8-DELINQ-CD           
           PERFORM 7990-GET-DELINQUENCY       THRU 7990-EXIT.           
           MOVE C8-DELINQ-VALUE               TO WS-DATABASE.           
                                                                        
           EVALUATE PARM-CODE-UTIL-TYPE                                 
              WHEN 'E'                                                  
                 MOVE 'ELECTRIC SERVICE:'     TO WS-CODE-UTIL-TYPE-DESC 
              WHEN 'G'                                                  
                 MOVE 'GAS SERVICE:'          TO WS-CODE-UTIL-TYPE-DESC 
              WHEN 'U'                                                  
                 MOVE 'UNMETERED SERVICE:'    TO WS-CODE-UTIL-TYPE-DESC 
              WHEN OTHER                                                
                 MOVE 'UNKNOWN SERVICE:'      TO WS-CODE-UTIL-TYPE-DESC 
           END-EVALUATE.                                                
                                                                        
           MOVE AT-PREMISE-NO                 TO PR-PREMISE-NO          
           PERFORM 7001-GET-REVENUE-DISTRICT  THRU 7001-EXIT.           
                                                                        
           MOVE IN-ACCOUNT-NO                 TO UT-ACCOUNT-NO          
                                                 MN-ACCOUNT-NO          
           MOVE IN-CODE-UTIL-TYPE             TO UT-CODE-UTIL-TYPE      
                                                 MN-CODE-UTIL-TYPE      
           MOVE IN-IC-NO                      TO UT-IC-NO               
                                                 MN-IC-NO               
           PERFORM 7040-SELECT-RATE-PLAN  THRU 7040-EXIT                
           PERFORM 7925-SELECT-MTRD-MV90    THRU 7925-EXIT.             
           PERFORM 0600-GET-CIG-CUST        THRU 0600-EXIT.             
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       0600-GET-CIG-CUST.                                               
      *================================================================*        
                                                                        
           MOVE 'N'                        TO WS-CIG-CUSTOMER           
                                              WS-NET-MTR-CUSTOMER.      
           MOVE IN-ACCOUNT-NO              TO TZ-ACCOUNT-NO             
           MOVE IN-CODE-UTIL-TYPE          TO TZ-CODE-UTIL-TYPE         
           MOVE SPACES                     TO TW-CNTRCT-START-DT        
                                              TZ-CODE-REVENUE-CLASS     
           MOVE ZEROS                      TO TW-PRIMARY-IC-NO          
                                                                        
           IF CSR-DATABASE                                              
              PERFORM 0650-CHECK-CIG-NET-CUST THRU 0650-EXIT            
           END-IF                                                       
                                                                        
           IF IN-CODE-UTIL-TYPE = 'G' AND CSR-DATABASE                  
              PERFORM 7930-TRNSP-CONTRACT    THRU 7930-EXIT             
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM 7931-TRNSP-CONTRACT THRU 7931-EXIT             
              END-IF                                                    
           END-IF.                                                      
                                                                        
       0600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       0650-CHECK-CIG-NET-CUST.                                         
      *================================================================*        
      ***CHECK IF THE CUSTOMER IS A CIG OR NET METER CUSTOMER          *        
                                                                        
           INITIALIZE  J1-REG-TYPE-CD                                   
                       J1-BAL-FWD-CD.                                   
           MOVE UT-CODE-UTIL-TYPE          TO J1-CODE-UTIL-TYPE         
           MOVE UT-RATE-PLAN-NO            TO J1-RATE-PLAN-NO           
           PERFORM 8000-SELECT-REG-TYPE-CD THRU 8000-EXIT.              
                                                                        
           IF J1-REG-TYPE-CD = 'D'                                      
              MOVE 'Y'                     TO WS-CIG-CUSTOMER           
           END-IF.                                                      
                                                                        
           IF J1-BAL-FWD-CD > ' '                                       
              MOVE 'Y'                     TO WS-NET-MTR-CUSTOMER       
           END-IF.                                                      
                                                                        
       0650-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *================================================================*        
       1000-PROCESS-INPUT.                                              
      *================================================================*        
                                                                        
           INITIALIZE       IN-BG-DATA.                                 
           INITIALIZE        WS-TRANS-HIST-DATA.                        
                                                                        
           IF PARM-BG-RECORD-KEY (PARM-BG-IDX) IS NUMERIC               
              MOVE PARM-BG-RECORD-KEY (PARM-BG-IDX) TO IN-BG-RECORD-KEY 
           ELSE                                                         
      ***   VALIDATION ERROR                                                    
              MOVE 'CR00000016'               TO RS-BUS-RULE-ID         
              PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT           
           END-IF.                                                      
                                                                        
           MOVE SPACES                        TO WS-AGL-TRANS-TEXT1     
           PERFORM 7010-SELECT-CUR-TIMESTAMP  THRU 7010-EXIT.           
                                                                        
           PERFORM 1010-FORMAT-BG-ITEM        THRU 1010-EXIT.           
A05460***TEMPORARY FIX TO GET THE CORRECT RATE PLAN # BASED ON RT SEQ #         
A05460***FOR SEB ACCOUNTS UNTIL FRONT END FIX MOVES TO PROD                     
A05460     IF SEB-DATABASE                                              
A05460        MOVE IN-ACCOUNT-NO              TO DF-ACCOUNT-NO          
A05460        MOVE IN-CODE-UTIL-TYPE          TO DF-CODE-UTIL-TYPE      
A05460        MOVE IN-IC-NO                   TO DF-IC-NO               
A05460        MOVE IN-RT-PKG-OPT-SEQ-NO       TO DF-RT-PKG-OPT-SEQ-NO   
A05460        PERFORM 7015-GET-RATE-PLAN-NUM  THRU 7015-EXIT            
A05460        IF FI-RATE-PLAN-NO > SPACES                               
A05460        AND FI-RATE-PLAN-NO NOT = IN-RATE-PLAN-NO                 
A05460           MOVE FI-RATE-PLAN-NO         TO IN-RATE-PLAN-NO        
A05460        END-IF                                                    
A05460     END-IF.                                                      
A05460***TEMPORARY FIX ENDS                                                     
           IF UN-METERED-IC                                             
              PERFORM 1020-FORMAT-UC-ITEMS    THRU 1020-EXIT            
           ELSE                                                         
              PERFORM 1030-FORMAT-CX-ITEMS    THRU 1030-EXIT            
           END-IF.                                                      
                                                                        
           PERFORM 1040-FORMAT-FH-ITEMS       THRU 1040-EXIT            
           PERFORM 1050-FORMAT-BP-ITEMS       THRU 1050-EXIT            
                                                                        
           PERFORM 1100-PROCESS-BILL          THRU 1100-EXIT            
                                                                        
           PERFORM 1200-PROCESS-TX-HIST       THRU 1200-EXIT.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1010-FORMAT-BG-ITEM.                                             
      *================================================================*        
                                                                        
           MOVE PARM-BILL-NO (PARM-BG-IDX)    TO IN-BILL-NO             
           MOVE PARM-BILL-ITEM-TIMESTMP (PARM-BG-IDX)                   
                                              TO IN-BILL-ITEM-TIMESTMP  
           MOVE PARM-DATE-BILLED (PARM-BG-IDX)                          
                                              TO IN-DATE-BILLED         
           MOVE 'D'                           TO IN-CODE-DR-CR-CNSMPTN  
           MOVE PARM-AMT-BILL-ITEM (PARM-BG-IDX)                        
                                              TO WS-AMT-BILL-ITEM-CHAR  
           DIVIDE WS-AMT-BILL-ITEM-NUM        BY 100                    
              GIVING IN-AMT-BILL-ITEM                                   
           IF WS-AMT-BILL-ITEM-SIGN    = '-'                            
              COMPUTE IN-AMT-BILL-ITEM = IN-AMT-BILL-ITEM * -1          
              MOVE 'D'                        TO IN-CODE-DR-CR-CNSMPTN  
           END-IF.                                                      
           MOVE PARM-AMT-STATE-TAX (PARM-BG-IDX)                        
                                              TO WS-AMT-BILL-TAX-CHAR   
           DIVIDE WS-AMT-BILL-TAX-NUM         BY 100                    
              GIVING IN-AMT-STATE-TAX                                   
           IF WS-AMT-BILL-TAX-SIGN    = '-'                             
              COMPUTE IN-AMT-STATE-TAX = IN-AMT-STATE-TAX * -1          
           END-IF.                                                      
                                                                        
           MOVE PARM-AMT-CITY-TAX (PARM-BG-IDX)                         
                                              TO WS-AMT-BILL-TAX-CHAR   
           DIVIDE WS-AMT-BILL-TAX-NUM         BY 100                    
              GIVING IN-AMT-CITY-TAX                                    
           IF WS-AMT-BILL-TAX-SIGN    = '-'                             
              COMPUTE IN-AMT-CITY-TAX  = IN-AMT-CITY-TAX  * -1          
           END-IF.                                                      
                                                                        
           MOVE PARM-AMT-OTHER-TAX (PARM-BG-IDX)                        
                                              TO WS-AMT-BILL-TAX-CHAR   
           DIVIDE WS-AMT-BILL-TAX-NUM         BY 100                    
              GIVING IN-AMT-OTHER-TAX                                   
           IF WS-AMT-BILL-TAX-SIGN    = '-'                             
              COMPUTE IN-AMT-OTHER-TAX = IN-AMT-OTHER-TAX * -1          
           END-IF.                                                      
           MOVE PARM-CODE-REVENUE-CLASS (PARM-BG-IDX)                   
                                              TO IN-CODE-REVENUE-CLASS  
           MOVE PARM-CODE-SIC-NO (PARM-BG-IDX)                          
                                              TO IN-CODE-SIC-NO         
           MOVE PARM-RATE-PLAN-NO (PARM-BG-IDX)                         
                                              TO IN-RATE-PLAN-NO        
           MOVE PARM-CODE-STAT-TAX-XMT (PARM-BG-IDX)                    
                                              TO IN-CODE-STAT-TAX-XMT   
           MOVE PARM-CODE-CITY-TAX-XMT (PARM-BG-IDX)                    
                                              TO IN-CODE-CITY-TAX-XMT   
           MOVE PARM-CODE-OTHR-TAX-XMT (PARM-BG-IDX)                    
                                              TO IN-CODE-OTHR-TAX-XMT   
           MOVE PARM-PRORATE-CD (PARM-BG-IDX) TO IN-PRORATE-CD          
           MOVE PARM-SHIPPER (PARM-BG-IDX)    TO IN-SHIPPER             
           MOVE PARM-BG-TRNSP-OVER-MDQ (PARM-BG-IDX)                    
                                              TO IN-TRNSP-OVER-MDQ-FL   
           MOVE PARM-RT-PKG-OPT-SEQ-NO (PARM-BG-IDX)                    
                                              TO IN-RT-PKG-OPT-SEQ-NO   
           MOVE PARM-BG-ADJ-REASON-CD (PARM-BG-IDX)                     
                                              TO IN-BG-ADJ-REASON-CD    
           MOVE PARM-CX-UC-RECORD-IND (PARM-BG-IDX)                     
                                              TO IN-CX-UC-RECORD-IND    
A05460     MOVE PARM-BG-BTU-FACTOR    (PARM-BG-IDX)                     
A05460                                        TO WS-BG-BTU-FACTOR       
A05460     MOVE WS-BG-BTU-FACTOR-RED          TO IN-BG-BTU-FACTOR.      
AA5744     MOVE PARM-BG-GAS-BASE-USE (PARM-BG-IDX)                      
AA5744                                        TO IN-BG-GAS-BASE-USE.    
                                                                        
       1010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1020-FORMAT-UC-ITEMS.                                            
      *================================================================*        
           MOVE ZERO              TO IN-UC-IDX                          
           PERFORM VARYING PARM-UC-IDX FROM 1 BY 1                      
SCA006           UNTIL PARM-UC-IDX > 100 OR 
                       PARM-UC-RECORD-KEY(PARM-UC-IDX) = SPACES OR 
                       PARM-UC-RECORD-KEY(PARM-UC-IDX) = ZEROS                  
              IF PARM-UC-RECORD-KEY(PARM-UC-IDX) =                      
                         PARM-BG-RECORD-KEY (PARM-BG-IDX)               
                 PERFORM 1025-GET-UC-ITEM    THRU 1025-EXIT             
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
       1020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1025-GET-UC-ITEM .                                               
      *================================================================*        
                                                                        
           COMPUTE IN-UC-IDX  =   IN-UC-IDX + 1                         
           MOVE PARM-UC-CHANGE-INDICATOR (PARM-UC-IDX)                  
                               TO IN-UC-CHANGE-INDICATOR (IN-UC-IDX)    
           MOVE PARM-UC-RATE-ITEM-CODE (PARM-UC-IDX)                    
                               TO IN-UC-RATE-ITEM-CODE (IN-UC-IDX)      
           MOVE PARM-UC-ITEM-SEQ-NO (PARM-UC-IDX)                       
                               TO IN-UC-ITEM-SEQ-NO (IN-UC-IDX)         
           MOVE PARM-UC-NO-UNITS (PARM-UC-IDX)                          
                               TO IN-UC-NO-UNITS (IN-UC-IDX)            
           MOVE PARM-UC-NO-DAYS (PARM-UC-IDX)                           
                               TO IN-UC-NO-DAYS (IN-UC-IDX)             
           MOVE PARM-UC-USAGE-FIXED (PARM-UC-IDX)                       
                               TO WS-USAGE-FIXED-CHAR                   
           MOVE WS-USAGE-FIXED-NUM                                      
                               TO IN-UC-USAGE-FIXED (IN-UC-IDX)         
           IF WS-USAGE-FIXED-SIGN    = '-'                              
              COMPUTE IN-UC-USAGE-FIXED (IN-UC-IDX)                     
                     = IN-UC-USAGE-FIXED (IN-UC-IDX) * -1               
           END-IF.                                                      
           MOVE PARM-UC-DATE-USAGE-ENDS (PARM-UC-IDX)                   
                               TO IN-UC-DATE-USAGE-ENDS (IN-UC-IDX)     
           MOVE PARM-UC-CODE-SERVICE-TYPE (PARM-UC-IDX)                 
                               TO IN-UC-CODE-SERVICE-TYPE (IN-UC-IDX)   
           MOVE PARM-UC-CODE-ITEM-STATUS (PARM-UC-IDX)                  
                               TO IN-UC-CODE-ITEM-STATUS (IN-UC-IDX)    
           MOVE PARM-UC-CODE-SOURCE-ID (PARM-UC-IDX)                    
                               TO IN-UC-CODE-SOURCE-ID (IN-UC-IDX)      
           MOVE PARM-UC-MTHLY-AMOUNT-FIXED (PARM-UC-IDX)                
                               TO IN-UC-MTHLY-AMOUNT-FIXED (IN-UC-IDX)  
           DIVIDE IN-UC-MTHLY-AMOUNT-FIXED (IN-UC-IDX) BY 100           
              GIVING IN-UC-MTHLY-AMOUNT-FIXED (IN-UC-IDX)               
           MOVE 'D'            TO IN-UC-CODE-DEBIT-CREDIT               
                                              (IN-UC-IDX)               
           MOVE PARM-UC-DIST-NO (PARM-UC-IDX)                           
                               TO IN-UC-DIST-NO (IN-UC-IDX)             
           MOVE PARM-UC-LIGHT-NO (PARM-UC-IDX)                          
                               TO IN-UC-LIGHT-NO (IN-UC-IDX)            
           MOVE PARM-UC-POLE-NO (PARM-UC-IDX)                           
                               TO IN-UC-POLE-NO (IN-UC-IDX)             
           MOVE PARM-UC-PERMANENT-UPDATE (PARM-UC-IDX)                  
                               TO IN-UC-PERMANENT-UPDATE (IN-UC-IDX).   
                                                                        
       1025-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1030-FORMAT-CX-ITEMS.                                            
      *================================================================*        
           MOVE ZERO           TO IN-CX-IDX                             
           PERFORM VARYING PARM-CX-IDX FROM 1 BY 1                      
SCA006           UNTIL PARM-CX-IDX > 100 OR 
                       PARM-CX-RECORD-KEY(PARM-CX-IDX) = SPACES OR 
                       PARM-CX-RECORD-KEY(PARM-CX-IDX) = ZEROS                  
              IF PARM-CX-RECORD-KEY(PARM-CX-IDX) =                      
                         PARM-BG-RECORD-KEY (PARM-BG-IDX)               
                 PERFORM 1035-GET-CX-ITEM    THRU 1035-EXIT             
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
      *** RESERVED FOR HILO CHECKS                                              
      **   PERFORM VARYING IN-CX-IDX FROM 1 BY 1                                
      **     UNTIL IN-CX-IDX > 100                                              
      **        OR IN-CX-CHANGE-INDICATOR (IN-CX-IDX) = SPACES.                 
      **     IF IN-CX-CHANGE-INDICATOR (IN-CX-IDX) = 'I'                        
      **        AND IN-CX-MTR-REF-NO (IN-CX-IDX) > 0                            
      **        AND IN-CX-CODE-USAGE-ID (IN-CX-IDX) = 'A'                       
      **        IF IN-CX-CODE-TIME-PERIOD (IN-CX-IDX) = 0                       
      **        END-IF                                                          
      **     END-IF                                                             
      **   END-PERFORM.                                                         
                                                                        
       1030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1035-GET-CX-ITEM .                                               
      *================================================================*        
                                                                        
           COMPUTE IN-CX-IDX = IN-CX-IDX + 1                            
           MOVE PARM-CX-CHANGE-INDICATOR (PARM-CX-IDX)                  
                               TO IN-CX-CHANGE-INDICATOR (IN-CX-IDX)    
           MOVE PARM-CX-MTR-REF-NO (PARM-CX-IDX)                        
                               TO IN-CX-MTR-REF-NO (IN-CX-IDX)          
           MOVE PARM-CX-REG-ID-NO (PARM-CX-IDX)                         
                               TO IN-CX-REG-ID-NO (IN-CX-IDX)           
           MOVE PARM-CX-CODE-TIME-PERIOD (PARM-CX-IDX)                  
                               TO IN-CX-CODE-TIME-PERIOD (IN-CX-IDX)    
           MOVE PARM-CX-ITEM-SEQ-NO (PARM-CX-IDX)                       
                               TO IN-CX-ITEM-SEQ-NO (IN-CX-IDX)         
           MOVE PARM-CX-CODE-USAGE-TYPE (PARM-CX-IDX)                   
                               TO IN-CX-CODE-USAGE-TYPE (IN-CX-IDX)     
           MOVE PARM-CX-CODE-USAGE-ID (PARM-CX-IDX)                     
                               TO IN-CX-CODE-USAGE-ID (IN-CX-IDX)       
           MOVE PARM-CX-CODE-USAGE-SOURCE (PARM-CX-IDX)                 
                               TO IN-CX-CODE-USAGE-SOURCE (IN-CX-IDX)   
           MOVE PARM-CX-CODE-TOU-SEASN (PARM-CX-IDX)                    
                               TO IN-CX-CODE-TOU-SEASN    (IN-CX-IDX)   
           MOVE PARM-CX-METER-NO (PARM-CX-IDX)                          
                               TO IN-CX-METER-NO (IN-CX-IDX)            
           MOVE PARM-CX-DATE-READ (PARM-CX-IDX)                         
                               TO IN-CX-DATE-READ (IN-CX-IDX)           
           MOVE PARM-CX-CODE-METER-READ (PARM-CX-IDX)                   
                               TO IN-CX-CODE-METER-READ (IN-CX-IDX)     
           MOVE PARM-CX-CODE-METER-NO-READ (PARM-CX-IDX)                
                               TO IN-CX-CODE-METER-NO-READ (IN-CX-IDX)  
           MOVE PARM-CX-NO-UNITS (PARM-CX-IDX)                          
                               TO WS-NO-UNITS-CHAR                      
           IF WS-NO-UNITS-SIGN = '-'                                    
              MOVE 'C'         TO IN-CX-CODE-DEBIT-CREDIT (IN-CX-IDX)   
           ELSE                                                         
              MOVE 'D'         TO IN-CX-CODE-DEBIT-CREDIT (IN-CX-IDX)   
           END-IF                                                       
           IF IN-CX-CODE-USAGE-TYPE (IN-CX-IDX) = ('E' OR 'J' OR        
                                                   'K' OR 'Q' OR        
                                                   'S' )                
              MOVE PARM-CX-METER-READING (PARM-CX-IDX)                  
                               TO IN-CX-DEMAND-READING (IN-CX-IDX)      
              DIVIDE IN-CX-DEMAND-READING (IN-CX-IDX) BY 1000           
                 GIVING IN-CX-DEMAND-READING (IN-CX-IDX)                
              MOVE ZEROS       TO IN-CX-METER-READING (IN-CX-IDX)       
              MOVE WS-NO-UNITS-NUM                                      
                               TO IN-CX-NO-DEMAND-UNITS (IN-CX-IDX)     
              MOVE ZEROS       TO IN-CX-NO-UNITS (IN-CX-IDX)            
           ELSE                                                         
              MOVE PARM-CX-METER-READING (PARM-CX-IDX)                  
                               TO IN-CX-METER-READING (IN-CX-IDX)       
              DIVIDE IN-CX-METER-READING (IN-CX-IDX) BY 1000            
                 GIVING IN-CX-METER-READING (IN-CX-IDX)                 
              MOVE ZEROS       TO IN-CX-DEMAND-READING (IN-CX-IDX)      
              MOVE WS-NO-UNITS-NUM                                      
                               TO IN-CX-NO-UNITS (IN-CX-IDX)            
              MOVE ZEROS       TO IN-CX-NO-DEMAND-UNITS (IN-CX-IDX)     
           END-IF                                                       
           MOVE PARM-CX-NO-DAYS (PARM-CX-IDX)                           
                               TO IN-CX-NO-DAYS (IN-CX-IDX)             
           MOVE PARM-CX-CODE-ITEM-STATUS (PARM-CX-IDX)                  
                               TO IN-CX-CODE-ITEM-STATUS (IN-CX-IDX)    
           MOVE 1              TO IN-CX-CONSTANT (IN-CX-IDX)            
           IF PARM-CX-CONSTANT (PARM-CX-IDX)  NUMERIC                   
              AND PARM-CX-CONSTANT (PARM-CX-IDX) > 100000               
              DIVIDE PARM-CX-CONSTANT (PARM-CX-IDX) BY 100000           
                   GIVING IN-CX-CONSTANT (IN-CX-IDX)                    
           END-IF                                                       
           MOVE 1              TO IN-CX-PCOMP-FCT   (IN-CX-IDX)         
           IF PARM-CX-PCOMP-FCT (PARM-CX-IDX)  NUMERIC                  
              AND PARM-CX-PCOMP-FCT (PARM-CX-IDX) > 100000              
              DIVIDE PARM-CX-PCOMP-FCT (PARM-CX-IDX) BY 100000          
                   GIVING IN-CX-PCOMP-FCT   (IN-CX-IDX)                 
           END-IF                                                       
           MOVE PARM-CX-NO-DIALS (PARM-CX-IDX)                          
                               TO IN-CX-NO-DIALS (IN-CX-IDX)            
           MOVE PARM-CX-EXCEPT-OVERRIDE-CD (PARM-CX-IDX)                
                               TO IN-CX-EXCEPT-OVERRIDE-CD (IN-CX-IDX)  
           MOVE PARM-CX-EXCL-DMD-RCHT-IND (PARM-CX-IDX)                 
                               TO IN-CX-EXCL-DMD-RCHT-IND (IN-CX-IDX)   
           MOVE PARM-CX-AGLMTCHRG-FLAG (PARM-CX-IDX)                    
                               TO IN-CX-AGLMTCHRG-FLAG (IN-CX-IDX)      
           MOVE PARM-CX-PERMANENT-UPDATE (PARM-CX-IDX)                  
                               TO IN-CX-PERMANENT-UPDATE (IN-CX-IDX).   
                                                                        
       1035-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1040-FORMAT-FH-ITEMS.                                            
      *================================================================*        
           MOVE ZEROS      TO IN-FH-IDX                                 
           PERFORM VARYING PARM-FH-IDX FROM 1 BY 1                      
SCA006           UNTIL PARM-FH-IDX > 100 OR 
                       PARM-FH-RECORD-KEY(PARM-FH-IDX) = SPACES OR 
                       PARM-FH-RECORD-KEY(PARM-FH-IDX) = ZEROS                  
              IF PARM-FH-RECORD-KEY(PARM-FH-IDX) =                      
                         PARM-BG-RECORD-KEY (PARM-BG-IDX)               
                 OR PARM-FH-APPLY-ALL-REBILLS (PARM-FH-IDX) = 'Y'       
                 PERFORM 1045-GET-FH-ITEM    THRU 1045-EXIT             
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
       1040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1045-GET-FH-ITEM.                                                
      *================================================================*        
                                                                        
           COMPUTE IN-FH-IDX = IN-FH-IDX + 1                            
           MOVE PARM-FH-CHANGE-INDICATOR (PARM-FH-IDX)                  
                               TO IN-FH-CHANGE-INDICATOR (IN-FH-IDX)    
           MOVE PARM-FH-FXD-FCTR-SEQ-NO (PARM-FH-IDX)                   
                          TO IN-FH-FIXED-FCTR-SEQ-NO   (IN-FH-IDX)      
           MOVE PARM-FH-FACTOR-ID (PARM-FH-IDX)                         
                               TO IN-FH-FACTOR-ID (IN-FH-IDX)           
           MOVE PARM-FH-BLOCK-NO (PARM-FH-IDX)                          
                               TO IN-FH-BLOCK-NO (IN-FH-IDX)            
           MOVE PARM-FH-DATE-FROM (PARM-FH-IDX)                         
                               TO IN-FH-EFF-DATE-FROM (IN-FH-IDX)       
           MOVE PARM-FH-DATE-TO (PARM-FH-IDX)                           
                               TO IN-FH-EFF-DATE-TO (IN-FH-IDX)         
           MOVE PARM-FH-SEASON (PARM-FH-IDX)                            
                               TO IN-FH-CODE-SEASON (IN-FH-IDX)         
           MOVE PARM-FH-INSTR-USE-TYPE-CD (PARM-FH-IDX)                 
                               TO IN-FH-INSTR-USE-TYPE-CD (IN-FH-IDX)   
           MOVE PARM-FH-CODE-TIME-PERIOD (PARM-FH-IDX)                  
                               TO IN-FH-CODE-TIME-PERIOD (IN-FH-IDX)    
           MOVE PARM-FH-CMPNT-ID-CD (PARM-FH-IDX)                       
                               TO IN-FH-CMPNT-ID-CD (IN-FH-IDX)         
           MOVE PARM-FH-FIXED-FCTR-TYP-CD (PARM-FH-IDX)                 
                               TO IN-FH-FIXED-FCTR-TYP-CD (IN-FH-IDX)   
           MOVE PARM-FF-FAC-CHRG-BASE-AM (PARM-FH-IDX) (2:9)            
                               TO IN-FF-FAC-CHRG-BASE-AM (IN-FH-IDX)    
           IF PARM-FF-FAC-CHRG-BASE-AM (PARM-FH-IDX) (1:1) = '-'        
              COMPUTE IN-FF-FAC-CHRG-BASE-AM (IN-FH-IDX)                
                           = IN-FF-FAC-CHRG-BASE-AM (IN-FH-IDX) * -1    
           END-IF                                                       
           MOVE PARM-FH-DURATION-REMAIN-NO (PARM-FH-IDX)                
                               TO IN-FH-DURATION-REMAIN-NO (IN-FH-IDX)  
           MOVE PARM-FH-OPTION-CD (PARM-FH-IDX)                         
                               TO IN-FH-OPTION-CD (IN-FH-IDX)           
           MOVE PARM-FH-FCTR-POWER-10 (PARM-FH-IDX) (2:3)               
                               TO IN-FH-FCTR-POWER-10 (IN-FH-IDX)       
           IF PARM-FH-FCTR-POWER-10 (PARM-FH-IDX) (1:1) = '-'           
              COMPUTE IN-FH-FCTR-POWER-10 (IN-FH-IDX)                   
                         = IN-FH-FCTR-POWER-10 (IN-FH-IDX) * -1         
           END-IF                                                       
           MOVE PARM-FH-APPLY-ALL-REBILLS (PARM-FH-IDX)                 
                           TO IN-FH-APPLY-ALL-REBILLS   (IN-FH-IDX)     
           MOVE PARM-FH-FACTOR (PARM-FH-IDX)                            
                               TO WS-FACTOR-VALUE-CHAR.                 
           MOVE WS-FACTOR-VALUE-NUM                                     
                               TO WS-FACTOR-VALUE                       
           IF IN-FH-FCTR-POWER-10 (IN-FH-IDX) NOT = 0                   
              COMPUTE WS-FACTOR-VALUE-RED = WS-FACTOR-VALUE-RED *       
                   (10 ** (IN-FH-FCTR-POWER-10 (IN-FH-IDX) * -1))       
           END-IF.                                                      
           MOVE WS-FACTOR-VALUE-RED TO IN-FH-FACTOR (IN-FH-IDX)         
           IF WS-FACTOR-VALUE-SIGN = '-'                                
              MOVE 'C'         TO IN-FH-CODE-DEBIT-CREDIT (IN-FH-IDX)   
           ELSE                                                         
              MOVE 'D'         TO IN-FH-CODE-DEBIT-CREDIT (IN-FH-IDX)   
           END-IF.                                                      
                                                                        
       1045-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1050-FORMAT-BP-ITEMS.                                            
      *================================================================*        
           MOVE ZEROS            TO IN-BP-IDX                           
           PERFORM VARYING PARM-BP-IDX FROM 1 BY 1                      
SCA006           UNTIL PARM-BP-IDX > 100 OR 
                       PARM-BP-RECORD-KEY(PARM-BP-IDX) = SPACES OR 
                       PARM-BP-RECORD-KEY(PARM-BP-IDX) = ZEROS                  
              IF PARM-BP-RECORD-KEY(PARM-BP-IDX) =                      
                         PARM-BG-RECORD-KEY (PARM-BG-IDX)               
                 PERFORM 1055-GET-BP-ITEM    THRU 1055-EXIT             
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
       1050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1055-GET-BP-ITEM.                                                
      *================================================================*        
                                                                        
           COMPUTE IN-BP-IDX  = IN-BP-IDX + 1                           
           MOVE PARM-BP-CHANGE-INDICATOR (PARM-BP-IDX)                  
                               TO IN-BP-CHANGE-INDICATOR (IN-BP-IDX)    
           MOVE PARM-BP-ADJ-TYPE-CD (PARM-BP-IDX)                       
                               TO WS-BP-ADJ-TYPE-CD                     
           MOVE WS-BP-ADJ-TYPE-CD1                                      
                               TO IN-BP-ADJ-TYPE-CD (IN-BP-IDX)         
           MOVE PARM-BP-REVENUE-MONTH (PARM-BP-IDX)                     
                               TO IN-BP-REVENUE-MONTH (IN-BP-IDX)       
           IF PARM-BP-OVRRIDE-RT-REV-MTH (PARM-BP-IDX) > SPACES         
              MOVE PARM-BP-OVRRIDE-RT-REV-MTH (PARM-BP-IDX)             
                               TO IN-BP-OVRRIDE-RT-REV-MTH (IN-BP-IDX)  
           ELSE                                                         
              MOVE ZEROS     TO IN-BP-OVRRIDE-RT-REV-MTH (IN-BP-IDX)    
           END-IF.                                                      
           MOVE PARM-BP-SPECIAL-PROCESS-CD (PARM-BP-IDX)                
                               TO IN-BP-SPECIAL-PROCESS-CD (IN-BP-IDX). 
           IF WS-BP-ADJ-TYPE-CD2 > SPACES                               
              MOVE IN-BP-IDX    TO MATCH-IDX                            
              COMPUTE IN-BP-IDX = IN-BP-IDX + 1                         
              MOVE IN-BP-DATA-REC (MATCH-IDX)                           
                                 TO IN-BP-DATA-REC (IN-BP-IDX)          
              MOVE WS-BP-ADJ-TYPE-CD2                                   
                                 TO IN-BP-ADJ-TYPE-CD (IN-BP-IDX)       
              MOVE ZEROS     TO IN-BP-OVRRIDE-RT-REV-MTH (MATCH-IDX)    
           END-IF.                                                      
                                                                        
       1055-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1100-PROCESS-BILL.                                               
      *================================================================*        
                                                                        
           PERFORM 1110-GET-ORIG-BILLS        THRU 1110-EXIT.           
           PERFORM 1150-GET-UNBILL-BILLS      THRU 1150-EXIT.           
                                                                        
           IF PARM-FUNCTION = 'R'                                       
              AND IN-BILL-NO > 0                                        
              AND IN-BILL-NO = (WS-RBI-BILL-NO OR WS-RBF-BILL-NO)       
              MOVE 'C'                        TO WS-FUNCTION            
           ELSE                                                         
              MOVE PARM-FUNCTION              TO WS-FUNCTION            
           END-IF.                                                      
                                                                        
           EVALUATE TRUE                                                
              WHEN BILL-CANCEL-REBILL                                   
                 PERFORM 3100-CANREB-BILL     THRU 3100-EXIT            
              WHEN BILL-CANCEL                                          
                 PERFORM 3200-CANCEL-BILL     THRU 3200-EXIT            
              WHEN BILL-DELETE                                          
                 PERFORM 3900-DELETE-BILL     THRU 3900-EXIT            
              WHEN BILL-CREATE                                          
              WHEN MANUAL-CALC                                          
                 PERFORM 3300-ADD-BILL        THRU 3300-EXIT            
              WHEN BILL-CHANGE                                          
                 PERFORM 3500-CHANGE-BILL     THRU 3500-EXIT            
              WHEN FUTURE-TO-IMMIDIATE                                  
                 PERFORM 3700-MOVE-TO-IMMIDIATE THRU 3700-EXIT          
              WHEN IMMIDIATE-TO-FUTURE                                  
                 PERFORM 3800-MOVE-TO-FUTURE    THRU 3800-EXIT          
              WHEN METER-POST                                           
                 PERFORM 3400-METER-POST-PROCESS THRU 3400-EXIT         
              WHEN OTHER                                                
                 CONTINUE                                               
           END-EVALUATE.                                                
                                                                        
           MOVE AT-ACCOUNT-NO          TO OC-ACCOUNT-NO                 
           MOVE AT-CUSTOMER-NO         TO OC-CUSTOMER-NO                
           IF BILL-WHEN-IMMIDIATE                                       
              MOVE 'A'                 TO AT-CODE-BILL-PEND             
              PERFORM 7053-CHECK-RBI-HOOK        THRU 7053-EXIT         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM 8965-CHECK-OFF-CYCLE THRU 8965-EXIT            
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                    CONTINUE                                            
                 ELSE                                                   
                    MOVE 'O'              TO OC-CODE-BILL-OFF-CYCL      
                    MOVE SPACES           TO OC-CREDIT-LETTER-IND       
                    IF AT-CODE-ACCT-STAT = 'B'                          
                       PERFORM 7950-GET-CRED-LETTER-IND THRU 7950-EXIT  
                       MOVE XD-CREDIT-LETTER-IND TO OC-CREDIT-LETTER-IND
                    END-IF                                              
                    PERFORM 8970-INSERT-OFF-CYCL-ACCT THRU 8970-EXIT    
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
      ***   ONE TIME FOR ACCOUNT                                                
           IF IN-CODE-TEMP-BILL = 'Y'                                   
              MOVE 'T'                     TO AT-CODE-TEMP-BILL         
           END-IF.                                                      
           PERFORM 8500-UPDATE-ACCOUNT   THRU 8500-EXIT.                
                                                                        
           MOVE AT-ACCOUNT-NO              TO AC-ACCOUNT-NO             
           PERFORM 5200-CHECK-AR-CNTL THRU 5200-EXIT.                   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE DCLCSS-AR-CNTL                                 
              MOVE IN-ACCOUNT-NO              TO AC-ACCOUNT-NO          
              IF IN-CODE-UTIL-TYPE = 'G'                                
                 MOVE 45                      TO AC-PYMT-PRIORITY-LVL   
              ELSE                                                      
                 MOVE 40                      TO AC-PYMT-PRIORITY-LVL   
      ***  ALSO CHECK FOR GAS UN-MTR SERVICE LATER                              
              END-IF                                                    
              MOVE WS-CURRENT-TIMESTMP TO AC-LAST-UPDATE-TS             
              PERFORM 5210-ADD-AR-ROW THRU 5210-EXIT                    
           END-IF.                                                      
                                                                        
           IF INTRO-FCTR-EXISTS                                         
              MOVE 'CR00000023'           TO RS-BUS-RULE-ID             
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1110-GET-ORIG-BILLS.                                             
      *================================================================*        
                                                                        
           MOVE IN-ACCOUNT-NO                 TO BI-ACCOUNT-NO          
                                                 BG-ACCOUNT-NO          
           MOVE IN-BILL-NO                    TO WS-ORIG-BILL-NO        
                                                 BG-BILL-NO             
                                                 BI-BILL-NO             
           MOVE IN-CODE-UTIL-TYPE             TO BG-CODE-UTIL-TYPE      
           MOVE IN-IC-NO                      TO BG-IC-NO               
           MOVE IN-BILL-ITEM-TIMESTMP         TO BG-BILL-ITEM-TIMESTMP  
                                                 WS-BILL-ITEM-TIMESTMP  
                                                 WS-ORIG-ITEM-TIMESTMP. 
                                                                        
           PERFORM 3110-GET-ORIG-BILLING-HDR  THRU 3110-EXIT.           
           PERFORM 3120-GET-ORIG-BILLING-DET  THRU 3120-EXIT.           
                                                                        
       1110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1150-GET-UNBILL-BILLS.                                           
      *================================================================*        
                                                                        
           PERFORM 7053-CHECK-RBI-HOOK        THRU 7053-EXIT            
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              SET RBI-HOOK-EXISTS             TO TRUE                   
              MOVE BI-BILL-NO                 TO WS-RBI-BILL-NO         
           ELSE                                                         
              MOVE ZEROES                     TO WS-RBI-BILL-NO         
              SET RBI-HOOK-NOT-EXISTS         TO TRUE                   
           END-IF.                                                      
                                                                        
           PERFORM 7054-CHECK-RBF-HOOK        THRU 7054-EXIT            
           IF BI-BILL-NO > 0                                            
              SET RBF-HOOK-EXISTS             TO TRUE                   
              MOVE BI-BILL-NO                 TO WS-RBF-BILL-NO         
           ELSE                                                         
              MOVE ZEROES                     TO WS-RBF-BILL-NO         
              SET RBF-HOOK-NOT-EXISTS         TO TRUE                   
              MOVE 'CR00000081'            TO RS-BUS-RULE-ID            
              PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT           
           END-IF.                                                      
                                                                        
       1150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1200-PROCESS-TX-HIST.                                            
      *================================================================*        
                                                                        
           MOVE PARM-USER-ID                  TO PF-USER-ID             
                                                 MH-USER-ID             
           PERFORM 7030-SELECT-RESP-AREA-ID  THRU 7030-EXIT             
                                                                        
           MOVE WS-HOLD-REVENUE-MONTH         TO WS-PARM-REV-MONTH-N    
                                                                        
           MOVE 1                             TO WS-TRAN-COMMENT-LEN    
           EVALUATE TRUE                                                
              WHEN PARM-COMMENTS-LEN > 0 AND WS-HOLD-REVENUE-MONTH > 0  
                 STRING WS-CODE-UTIL-TYPE-DESC DELIMITED BY ':'         
                     '; REVENUE MONTH: ' DELIMITED BY SIZE              
                     WS-PARM-REV-MONTH-N                                
                     ' - '               DELIMITED BY SIZE              
                     PARM-COMMENTS-TXT (1:PARM-COMMENTS-LEN)            
                                         DELIMITED BY SIZE              
                     WS-AGL-TRANS-TEXT1 DELIMITED BY '  '               
                 INTO WS-TRAN-COMMENT-TEXT                              
                 POINTER WS-TRAN-COMMENT-LEN                            
              WHEN WS-HOLD-REVENUE-MONTH > 0                            
                 STRING WS-CODE-UTIL-TYPE-DESC DELIMITED BY ':'         
                     '; REVENUE MONTH: ' DELIMITED BY SIZE              
                     WS-PARM-REV-MONTH-N                                
                     WS-AGL-TRANS-TEXT1 DELIMITED BY '  '               
                 INTO WS-TRAN-COMMENT-TEXT                              
                 POINTER WS-TRAN-COMMENT-LEN                            
              WHEN PARM-COMMENTS-LEN > 0                                
                 STRING WS-CODE-UTIL-TYPE-DESC DELIMITED BY ':'         
                     ' - '               DELIMITED BY SIZE              
                     PARM-COMMENTS-TXT (1:PARM-COMMENTS-LEN)            
                                         DELIMITED BY SIZE              
                     WS-AGL-TRANS-TEXT1 DELIMITED BY '  '               
                 INTO WS-TRAN-COMMENT-TEXT                              
                 POINTER WS-TRAN-COMMENT-LEN                            
              WHEN OTHER                                                
                 STRING WS-CODE-UTIL-TYPE-DESC DELIMITED BY ':'         
                     WS-AGL-TRANS-TEXT1 DELIMITED BY '  '               
                 INTO WS-TRAN-COMMENT-TEXT                              
                 POINTER WS-TRAN-COMMENT-LEN                            
           END-EVALUATE.                                                
           COMPUTE WS-TRAN-COMMENT-LEN = WS-TRAN-COMMENT-LEN - 1        
                                                                        
           MOVE WS-CURRENT-TIMESTMP           TO MH-TRANS-HIST-SEQ-NO   
           MOVE WS-CURRENT-DATE               TO MH-DATE-TRANS          
           MOVE 'F'                           TO MH-CODE-TRAN-TYPE      
           MOVE WS-RESP-AREA-ID               TO MH-RESP-AREA-ID        
           MOVE AT-ACCOUNT-NO                 TO MH-ACCOUNT-NO          
           MOVE ZEROS                         TO MH-CUSTOMER-NO         
           MOVE ZEROS                         TO MH-PREMISE-NO          
                                                                        
           IF PARM-BILL-CORR-VIEW = 'S'                                 
              MOVE 'CSR04873S'                TO MH-APPL-PROGRAM-ID     
           ELSE                                                         
              MOVE 'CSR04873N'                TO MH-APPL-PROGRAM-ID     
              IF WS-FUNCTION  = 'T'                                     
                 MOVE 'CSR04873M'             TO MH-APPL-PROGRAM-ID     
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE WS-TRAN-COMMENT-LEN           TO MH-TRAN-COMMENT-LEN    
           MOVE WS-TRAN-COMMENT-TEXT          TO MH-TRAN-COMMENT-TEXT   
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO          TO MI-TRANS-HIST-SEQ-NO   
           MOVE 1                             TO MI-TRAN-APPL-NO        
           MOVE 'FNCT DESIRED   '             TO MI-COLUMN-DESC         
           MOVE 0                       TO MI-PRV-COLUMN-VALUE-LEN      
           MOVE SPACES                  TO MI-PRV-COLUMN-VALUE-TEXT     
           MOVE 15                      TO MI-CHG-COLUMN-VALUE-LEN      
           MOVE WS-CODE-SHORT-DESC      TO MI-CHG-COLUMN-VALUE-TEXT     
           MOVE SPACES                  TO MI-TABLE-ID                  
           PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT            
                                                                        
           ADD 1                     TO MI-TRAN-APPL-NO                 
           MOVE 'BILL WHEN      '    TO MI-COLUMN-DESC                  
           EVALUATE TRUE                                                
              WHEN BILL-WHEN-FUTURE                                     
                 MOVE 'FUTURE BILL  ' TO WS-BILL-WHEN-DESC              
              WHEN BILL-WHEN-IMMIDIATE                                  
                 MOVE 'IMMEDIATELY  ' TO WS-BILL-WHEN-DESC              
              WHEN OTHER                                                
                 MOVE 'UNKNOWN      ' TO WS-BILL-WHEN-DESC              
           END-EVALUATE                                                 
           MOVE 0                     TO MI-PRV-COLUMN-VALUE-LEN        
           MOVE SPACES                TO MI-PRV-COLUMN-VALUE-TEXT       
           MOVE 13                    TO MI-CHG-COLUMN-VALUE-LEN        
           MOVE WS-BILL-WHEN-DESC       TO MI-CHG-COLUMN-VALUE-TEXT     
           MOVE SPACES                  TO MI-TABLE-ID                  
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT              
           IF WS-MTR-READ-SOURCE-CD = 'M'                               
              MOVE WS-CURRENT-TIMESTMP         TO MI-TRANS-HIST-SEQ-NO  
              ADD 1                            TO MI-TRAN-APPL-NO       
              MOVE SPACES                      TO MI-TABLE-ID           
                                                                        
              EVALUATE TRUE                                             
                 WHEN PARM-COPY-CX-DATA = 'Y'                           
      *****           AND PARM-COPY-IDR-DATA = 'Y'                              
                    MOVE WS-VALUE-1         TO WS-CHG-COLUMN-VALUE-TEXT 
                 WHEN PARM-COPY-CX-DATA = 'N'                           
                      AND PARM-COPY-IDR-DATA = 'Y'                      
                    MOVE WS-VALUE-2         TO WS-CHG-COLUMN-VALUE-TEXT 
                 WHEN OTHER                                             
                    MOVE WS-VALUE-3         TO WS-CHG-COLUMN-VALUE-TEXT 
              END-EVALUATE                                              
              MOVE WS-CHG-COLUMN-VALUE-TEXT TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-CHG-COLUMN-VALUE-TEXT                   
                                            TO MI-CHG-COLUMN-VALUE-LEN  
                                                                        
              MOVE SPACES                   TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 0                        TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE 'CX/IDR Copy'            TO MI-COLUMN-DESC           
                                                                        
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           END-IF.                                                      
           MOVE TH-SUB                 TO TH-SUB-MAX                    
           PERFORM VARYING TH-SUB FROM 1 BY 1 UNTIL TH-SUB > TH-SUB-MAX 
              ADD 1                     TO MI-TRAN-APPL-NO              
              MOVE WS-COLUMN-DESC (TH-SUB)                              
                                           TO MI-COLUMN-DESC            
              MOVE WS-PRV-COLUMN-VALUE-LEN (TH-SUB)                     
                                           TO MI-PRV-COLUMN-VALUE-LEN   
              MOVE WS-PRV-COLUMN-VALUE-TXT (TH-SUB)                     
                                           TO MI-PRV-COLUMN-VALUE-TEXT  
              MOVE WS-CHG-COLUMN-VALUE-LEN (TH-SUB)                     
                                           TO MI-CHG-COLUMN-VALUE-LEN   
              MOVE WS-CHG-COLUMN-VALUE-TXT (TH-SUB)                     
                                           TO MI-CHG-COLUMN-VALUE-TEXT  
              MOVE WS-TABLE-ID (TH-SUB)                                 
                                           TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           END-PERFORM.                                                 
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       3100-CANREB-BILL.                                                
      *================================================================*        
                                                                        
           PERFORM 3200-CANCEL-BILL     THRU 3200-EXIT.                 
                                                                        
           PERFORM 3600-CREATE-RBILL    THRU 3600-EXIT.                 
                                                                        
           IF WS-CIG-CUSTOMER = 'Y'                                     
              PERFORM 5810-PROCESS-ALL-ICS   THRU 5810-EXIT             
              PERFORM 7154-OPEN-ASSO-IC-CRSR THRU 7154-EXIT             
              PERFORM 7155-FETCH-ASSO-IC-CRSR    THRU 7155-EXIT         
              PERFORM 5821-CHK-ASSO-IC-NO    THRU 5821-EXIT             
                        UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND     
              PERFORM 7156-CLOSE-ASSO-IC-CRSR THRU 7156-EXIT            
           END-IF.                                                      
      ***  CHECK MASTER/SUB RELATION.                                           
           MOVE IN-ACCOUNT-NO          TO UR-ACCOUNT-NO-MST             
                                          UR-ACCOUNT-NO-DEP             
           MOVE IN-CODE-UTIL-TYPE      TO UR-CODE-UTIL-TYPE-MST         
                                          UR-CODE-UTIL-TYPE-DEP         
                                                                        
           PERFORM 7940-MASTER-DEPEND-REL THRU 7940-EXIT                
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              MOVE 'CR00000024'        TO RS-BUS-RULE-ID                
           END-IF.                                                      
      ***  INFO MESSAGE TO INCLUDE UNMTR SERV IN CAN/REBILL                     
           IF IN-CODE-UTIL-TYPE NOT = 'U' AND BILL-WHEN-IMMIDIATE       
              PERFORM 8985-GET-ANNIV-DATE    THRU 8985-EXIT             
              IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL               
                 MOVE 'N'                     TO WS-UMMETER-SERVICE     
                 PERFORM 8990-CHECK-UMMETER           THRU 8990-EXIT    
                 IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL            
                    MOVE WS-REVENUE-MONTH     TO WS-WORK-REV-MTH        
                    MOVE WS-WORK-REV-MTH(1:4) TO WS-BILLED-REV-YR       
                    MOVE WS-WORK-REV-MTH(5:2) TO WS-BILLED-REV-MN       
                    COMPUTE WS-BILLED-REV-YR = WS-BILLED-REV-YR + 1     
                    IF WS-BILLED-REV-YR = BU-ANNIVERSARY-DATE(1:4) AND  
                       BU-ANNIVERSARY-DATE(6:2) = WS-BILLED-REV-MN      
                       MOVE 'CR00000021'      TO RS-BUS-RULE-ID         
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       3200-CANCEL-BILL.                                                
      *================================================================*        
                                                                        
           EVALUATE TRUE                                                
              WHEN BILL-WHEN-IMMIDIATE   AND WS-RBI-BILL-NO > 0         
                 MOVE WS-RBI-BILL-NO        TO WS-RB-BILL-NO            
                                               BI-BILL-NO               
                 IF PARM-BILL-CORRECTED-CD > SPACES                     
                    AND PARM-BILL-CORRECTED-CD NOT = 'O'                
                    AND PARM-BILL-CORRECTED-CD NOT =                    
                                WS-RBI-BILL-CORRECTED-CD                
                    MOVE PARM-BILL-CORRECTED-CD TO BI-BILL-CORRECTED-CD 
                    PERFORM 8963-UPDATE-BILL-CORRECTED-CD THRU 8963-EXIT
                 END-IF                                                 
              WHEN BILL-WHEN-IMMIDIATE                                  
      ***  WE MAY NEED TO CHECK WS-RBF-BILL-NO EXISTS?                          
                   MOVE AT-NXT-BILL-NO        TO WS-RBI-BILL-NO         
                                                 SHFT-FROM-BILL-NO      
                   COMPUTE SHFT-TO-BILL-NO  = SHFT-FROM-BILL-NO + 1     
                   MOVE SHFT-TO-BILL-NO       TO WS-RBF-BILL-NO         
                   PERFORM 3950-SHIFT-BILL-NO THRU 3950-EXIT            
                   MOVE WS-RBI-BILL-NO        TO WS-RB-BILL-NO          
                   MOVE WS-ORIG-BILL-NO       TO SHFT-FROM-BILL-NO      
                   PERFORM 3960-CREATE-REBILL-HEADER THRU 3960-EXIT     
                   PERFORM 3930-POPULATE-ORIG-DET    THRU 3930-EXIT     
              WHEN OTHER                                                
                   MOVE WS-RBF-BILL-NO        TO WS-RB-BILL-NO          
           END-EVALUATE.                                                
                                                                        
      ***  MOVE BG-REVENUE-MONTH              TO WS-WORK-REV-MTH                
           MOVE WS-ORIG-ITEM-TIMESTMP         TO BG-BILL-ITEM-TIMESTMP  
                                                 WS-BILL-ITEM-TIMESTMP  
           MOVE IN-CODE-UTIL-TYPE             TO BG-CODE-UTIL-TYPE      
           MOVE WS-ORIG-BILL-NO               TO BG-BILL-NO             
           MOVE WS-K                          TO BG-CODE-BILL-ITM-IND   
           PERFORM 8902-UPDATE-BILL-DET-CAN   THRU 8902-EXIT.           
                                                                        
           MOVE WS-A                          TO BG-CODE-BILL-ITM-IND   
           MOVE WS-B                          TO BG-CODE-BILL-ITM-TYPE  
           MOVE WS-S                          TO BG-CODE-BILL-CALC      
                                                                        
           IF WS-DATE-ORIG-BILL-NULL = -1                               
              MOVE WS-DATE-BILLED             TO BG-DATE-ORIG-BILL      
           END-IF.                                                      
                                                                        
           MOVE ZERO                          TO WS-DATE-ORIG-BILL-NULL1
                                                                        
           IF WS-CODE-DR-CR-CNSMPTN EQUAL WS-C                          
               MOVE WS-D                      TO BG-CODE-DR-CR-CNSMPTN  
           ELSE                                                         
               MOVE WS-C                      TO BG-CODE-DR-CR-CNSMPTN  
           END-IF.                                                      
           IF IN-BG-ADJ-REASON-CD <= SPACES AND                         
              PARM-ADJ-REASON-CD = '999'                                
              MOVE PARM-ADJ-DESC-TXT          TO K0-ADJ-REASON-DESC     
              PERFORM 7450-GET-BADJ-ADJST-RSN-CD                        
                                              THRU 7450-EXIT            
           END-IF.                                                      
           MOVE IN-BG-ADJ-REASON-CD           TO BG-ADJ-REASON-CD       
           MOVE 'N'                           TO BG-REBILL-IND          
                                                                        
           MOVE WS-RB-BILL-NO                 TO BG-BILL-NO             
           MOVE WS-HOLD-REVENUE-MONTH         TO BG-REV-MTH-ORIG-BILL   
           MOVE ZEROES                        TO BG-REVENUE-MONTH       
           MOVE WS-CODE-STAT-TAX-XMT          TO BG-CODE-STAT-TAX-XMT   
           MOVE WS-CODE-CITY-TAX-XMT          TO BG-CODE-CITY-TAX-XMT   
           MOVE WS-CODE-OTHR-TAX-XMT          TO BG-CODE-OTHR-TAX-XMT   
                                                                        
           PERFORM 8771-INSERT-BILL-DETAIL    THRU 8771-EXIT            
                                                                        
           IF BILL-WHEN-IMMIDIATE                                       
              IF PARM-EXEMPT-FL  = 'Y' AND AT-CODE-ACCT-STAT = 'A'      
                 PERFORM 3970-PROCESS-EXEMPTS      THRU 3970-EXIT       
              END-IF                                                    
              IF AT-CODE-ACCT-STAT NOT = 'A'                            
                 AND AT-ACCT-FINALED-DT NOT EQUAL SPACES                
                 MOVE 'B'                  TO BI-CODE-BILL-TYPE         
                 MOVE WS-RB-BILL-NO        TO BI-BILL-NO                
                 PERFORM 8960-UPDATE-BILL-HDR-TYPE THRU 8960-EXIT       
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 3980-BACKOUT-HIST THRU 3980-EXIT.                    
                                                                        
       3200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       3110-GET-ORIG-BILLING-HDR.                                       
      *================================================================*        
                                                                        
           PERFORM 7052-SELECT-BILL-HEADER    THRU 7052-EXIT.           
                                                                        
           MOVE BI-DATE-BILLED                TO WS-DATE-BILLED         
           MOVE BI-CODE-BILL-REASON           TO WS-CODE-BILL-REASON    
           MOVE BI-CODE-BILL-STATUS           TO WS-CODE-BILL-STATUS    
           MOVE BI-CODE-BILL-TYPE             TO WS-CODE-BILL-TYPE      
           MOVE BI-CUSTOMER-NO                TO WS-CUSTOMER-NO         
           MOVE BI-CODE-SPCL-BILL             TO WS-CODE-SPCL-BILL      
           MOVE BI-PREM-ACCT-SEQ-NO           TO WS-PREM-ACCT-SEQ-NO    
           MOVE BI-SMRY-BILL-NO               TO WS-SMRY-BILL-NO        
           MOVE BI-SMRY-REBILL-NO             TO WS-SMRY-REBILL-NO      
           MOVE BI-ACCOUNT-NO-SUMM            TO WS-ACCOUNT-NO-SUMM     
           MOVE BI-TOT-OTHER-CHARGES          TO WS-TOT-OTHER-CHARGES   
           MOVE BI-TOTAL-ARREARS              TO WS-TOTAL-ARREARS       
           MOVE BI-BILL-CORRECTED-CD          TO WS-BILL-CORRECTED-CD.  
                                                                        
       3110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       3120-GET-ORIG-BILLING-DET.                                       
      *================================================================*        
                                                                        
           PERFORM 7051-SELECT-BILLING-DET    THRU 7051-EXIT            
                                                                        
           MOVE BG-IC-NO                      TO WS-ORIG-IC-NO          
A05460     MOVE BG-CODE-UTIL-TYPE             TO WS-CODE-UTIL-TYPE      
           MOVE BG-DATE-ORIG-BILL             TO WS-DATE-ORIG-BILL      
           MOVE BG-AMT-BILL-ITEM              TO WS-BG-AMT-BILL-ITEM    
           MOVE BG-CODE-BILL-CALC             TO WS-CODE-BILL-CALC      
           MOVE BG-CODE-BILL-ITM-TYPE         TO WS-CODE-BILL-ITM-TYPE  
           MOVE BG-CODE-BILL-ITM-IND          TO WS-CODE-BILL-ITM-IND   
           MOVE BG-CODE-DR-CR-CNSMPTN         TO WS-CODE-DR-CR-CNSMPTN  
           MOVE BG-AMT-STATE-TAX              TO WS-AMT-STATE-TAX       
           MOVE BG-AMT-CITY-TAX               TO WS-AMT-CITY-TAX        
           MOVE BG-AMT-OTHER-TAX              TO WS-AMT-OTHER-TAX       
           MOVE BG-CODE-REVENUE-CLASS         TO WS-CODE-REVENUE-CLASS  
           MOVE BG-CODE-SIC-NO                TO WS-CODE-SIC-NO         
           MOVE BG-RATE-PLAN-NO               TO WS-RATE-PLAN-NO        
           MOVE BG-CODE-CURTAIL-PRTY          TO WS-CODE-CURTAIL-PRTY   
           MOVE BG-CODE-STAT-TAX-XMT          TO WS-CODE-STAT-TAX-XMT   
           MOVE BG-CODE-CITY-TAX-XMT          TO WS-CODE-CITY-TAX-XMT   
           MOVE BG-CODE-OTHR-TAX-XMT          TO WS-CODE-OTHR-TAX-XMT   
           MOVE BG-REV-RPT-CD                 TO WS-REV-RPT-CD          
           MOVE BG-STANDBY-COMPLIED           TO WS-STANDBY-COMPLIED    
           MOVE BG-PRORATE-CD                 TO WS-PRORATE-CD          
           MOVE BG-NEW-RATE-PCT               TO WS-NEW-RATE-PCT        
           MOVE BG-CODE-SUB-TOTAL             TO WS-CODE-SUB-TOTAL      
           MOVE BG-TAX-REFUND-CD              TO WS-TAX-REFUND-CD       
           MOVE BG-DATE-LFTM-HI-DMD           TO WS-DATE-LFTM-HI-DMD    
           MOVE BG-LFTM-HI-PEAK-DMD           TO WS-LFTM-HI-PEAK-DMD    
           MOVE BG-REBILL-IND                 TO WS-REBILL-IND          
           MOVE BG-ADJ-REASON-CD              TO WS-ADJ-REASON-CD       
           MOVE BG-REVENUE-MONTH              TO WS-REVENUE-MONTH       
           MOVE BG-GAS-BASE-USE               TO WS-GAS-BASE-USE        
           MOVE BG-WNA-FACTOR                 TO WS-WNA-FACTOR          
           MOVE BG-BTU-FACTOR                 TO WS-BTU-FACTOR          
           MOVE BG-NO-OF-CONS-DAYS            TO WS-NO-OF-CONS-DAYS     
           MOVE BG-REV-MTH-ORIG-BILL          TO WS-REV-MTH-ORIG-BILL   
           MOVE BG-REV-DISTRICT-CD            TO WS-REV-DISTRICT-CD     
           MOVE BG-FUEL-SHIPPER-CD            TO WS-FUEL-SHIPPER-CD     
           MOVE BG-ALTERNATE-FUEL-CD          TO WS-ALTERNATE-FUEL-CD   
           MOVE BG-TRNSP-OVER-MDQ-FL          TO WS-TRNSP-OVER-MDQ-FL   
           MOVE BG-CITY-TAX-RATE              TO WS-CITY-TAX-RATE       
           MOVE BG-OTHER-TAX-RATE             TO WS-OTHER-TAX-RATE      
           MOVE BG-STATE-TAX-RATE             TO WS-STATE-TAX-RATE      
           MOVE BG-BILL-CALC-CYCLE            TO WS-BILL-CALC-CYCLE     
           MOVE BG-NAICS-CD                   TO WS-NAICS-CD            
           MOVE BG-RT-PKG-OPT-SEQ-NO          TO WS-RT-PKG-OPT-SEQ-NO   
           IF BG-REV-MTH-ORIG-BILL > ZERO                               
              MOVE BG-REV-MTH-ORIG-BILL       TO WS-HOLD-REVENUE-MONTH  
           ELSE                                                         
              MOVE BG-REVENUE-MONTH           TO WS-HOLD-REVENUE-MONTH  
           END-IF.                                                      
                                                                        
       3120-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *================================================================*        
       3300-ADD-BILL.                                                   
      *================================================================*        
                                                                        
           MOVE IN-BILL-NO                    TO WS-ORIG-BILL-NO        
                                                                        
           EVALUATE TRUE                                                
              WHEN BILL-WHEN-IMMIDIATE   AND WS-RBI-BILL-NO > 0         
                   MOVE WS-RBI-BILL-NO        TO WS-RB-BILL-NO          
              WHEN BILL-WHEN-IMMIDIATE                                  
      ***  WE MAY NEED TO CHECK WS-RBF-BILL-NO EXISTS?                          
                   MOVE AT-NXT-BILL-NO        TO WS-RBI-BILL-NO         
                                                 SHFT-FROM-BILL-NO      
                   COMPUTE SHFT-TO-BILL-NO  = SHFT-FROM-BILL-NO + 1     
                   MOVE SHFT-TO-BILL-NO       TO WS-RBF-BILL-NO         
                   PERFORM 3950-SHIFT-BILL-NO THRU 3950-EXIT            
                   MOVE WS-RBI-BILL-NO        TO WS-RB-BILL-NO          
                   MOVE WS-ORIG-BILL-NO       TO SHFT-FROM-BILL-NO      
                   PERFORM 3960-CREATE-REBILL-HEADER THRU 3960-EXIT     
                   PERFORM 3930-POPULATE-ORIG-DET    THRU 3930-EXIT     
              WHEN OTHER                                                
                   MOVE WS-RBF-BILL-NO        TO WS-RB-BILL-NO          
           END-EVALUATE.                                                
                                                                        
           MOVE WS-RB-BILL-NO                 TO BG-BILL-NO             
           MOVE WS-CURRENT-TIMESTMP           TO BG-BILL-ITEM-TIMESTMP  
           MOVE SPACES                        TO BG-DATE-ORIG-BILL      
           MOVE -1                            TO WS-DATE-ORIG-BILL-NULL1
           MOVE IN-AMT-BILL-ITEM              TO BG-AMT-BILL-ITEM       
           MOVE WS-CALC-COMMAND               TO BG-CODE-BILL-CALC      
           MOVE 'C'                           TO BG-CODE-BILL-ITM-TYPE  
           MOVE 'A'                           TO BG-CODE-BILL-ITM-IND   
           MOVE IN-CODE-DR-CR-CNSMPTN         TO BG-CODE-DR-CR-CNSMPTN  
           MOVE IN-AMT-STATE-TAX              TO BG-AMT-STATE-TAX       
           MOVE IN-AMT-CITY-TAX               TO BG-AMT-CITY-TAX        
           MOVE IN-AMT-OTHER-TAX              TO BG-AMT-OTHER-TAX       
           MOVE '0000'                        TO BG-CODE-SIC-NO         
           MOVE IN-CODE-REVENUE-CLASS         TO BG-CODE-REVENUE-CLASS  
           MOVE IN-RATE-PLAN-NO               TO BG-RATE-PLAN-NO        
           IF BG-CODE-BILL-CALC = 'S'                                   
               AND IN-CODE-UTIL-TYPE = BG-CODE-UTIL-TYPE                
               MOVE UT-RATE-PLAN-NO       TO BG-RATE-PLAN-NO            
               MOVE UT-CODE-REVENUE-CLASS TO BG-CODE-REVENUE-CLASS      
           END-IF.                                                      
           MOVE IN-CODE-STAT-TAX-XMT          TO BG-CODE-STAT-TAX-XMT   
           MOVE IN-CODE-CITY-TAX-XMT          TO BG-CODE-CITY-TAX-XMT   
           MOVE IN-CODE-OTHR-TAX-XMT          TO BG-CODE-OTHR-TAX-XMT   
           MOVE IN-PRORATE-CD                 TO BG-PRORATE-CD          
           IF BG-CODE-BILL-CALC = 'A'                                   
              PERFORM 5800-CHECK-CIG-CUST      THRU 5800-EXIT           
           END-IF                                                       
           MOVE 'N'                           TO BG-REBILL-IND          
           IF IN-BG-ADJ-REASON-CD   > SPACES                            
              MOVE IN-BG-ADJ-REASON-CD        TO BG-ADJ-REASON-CD       
           ELSE                                                         
              MOVE SPACES                     TO BG-ADJ-REASON-CD       
           END-IF                                                       
           MOVE ZERO                          TO BG-REVENUE-MONTH       
                                                 BG-WNA-FACTOR          
                                                 BG-BTU-FACTOR          
                                                 BG-NO-OF-CONS-DAYS     
                                                 BG-REV-MTH-ORIG-BILL   
           MOVE IN-SHIPPER                    TO BG-FUEL-SHIPPER-CD     
           MOVE IN-RT-PKG-OPT-SEQ-NO          TO BG-RT-PKG-OPT-SEQ-NO   
A05460     MOVE IN-BG-BTU-FACTOR              TO BG-BTU-FACTOR          
AA5744     MOVE IN-BG-GAS-BASE-USE            TO BG-GAS-BASE-USE        
           PERFORM 8771-INSERT-BILL-DETAIL    THRU 8771-EXIT.           
                                                                        
           PERFORM 3310-CHECK-CX-INSERTS      THRU 3310-EXIT            
           VARYING IN-CX-IDX FROM 1 BY 1                                
             UNTIL IN-CX-IDX > 100                                      
                OR IN-CX-CHANGE-INDICATOR (IN-CX-IDX) = SPACES.         
A05460                                                                  
A05460     PERFORM 3320-CHECK-UC-INSERTS      THRU 3320-EXIT            
A05460     VARYING IN-UC-IDX FROM 1 BY 1                                
A05460       UNTIL IN-UC-IDX > 100                                      
A05460          OR IN-UC-CHANGE-INDICATOR (IN-UC-IDX) = SPACES.         
                                                                        
           IF PARM-ADJ-REASON-CD = '999'                                
              PERFORM 3620-ADD-BILLADJ        THRU 3620-EXIT            
           END-IF.                                                      
                                                                        
       3300-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       3310-CHECK-CX-INSERTS.                                           
      *================================================================*        
                                                                        
           MOVE BG-ACCOUNT-NO                 TO CX-ACCOUNT-NO          
           MOVE BG-BILL-NO                    TO CX-BILL-NO             
           MOVE BG-CODE-UTIL-TYPE             TO CX-CODE-UTIL-TYPE      
           MOVE BG-IC-NO                      TO CX-IC-NO               
           MOVE BG-BILL-ITEM-TIMESTMP         TO CX-BILL-ITEM-TIMESTMP  
           MOVE SPACES                        TO WS-METER-NO-HOLD       
           MOVE IN-CX-MTR-REF-NO  (IN-CX-IDX) TO CX-MTR-REF-NO          
           MOVE IN-CX-REG-ID-NO (IN-CX-IDX)   TO CX-REG-ID-NO           
           MOVE IN-CX-CODE-TIME-PERIOD (IN-CX-IDX)                      
                                              TO CX-CODE-TIME-PERIOD    
           MOVE IN-CX-ITEM-SEQ-NO (IN-CX-IDX) TO CX-ITEM-SEQ-NO         
           MOVE IN-CX-IDX                     TO MATCH-IDX              
           IF IN-CX-CHANGE-INDICATOR (IN-CX-IDX) = 'I'                  
              PERFORM 4150-PROCESS-CX-NEW-ROWS THRU 4150-EXIT           
              MOVE 'P'                   TO IN-CX-PROCESS-CD (IN-CX-IDX)
           ELSE                                                         
              MOVE 'CR00009999'          TO RS-BUS-RULE-ID              
              PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT           
           END-IF.                                                      
                                                                        
       3310-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05460*================================================================*        
A05460 3320-CHECK-UC-INSERTS.                                           
A05460*================================================================*        
A05460                                                                  
A05460     MOVE BG-ACCOUNT-NO                 TO UC-ACCOUNT-NO          
A05460     MOVE BG-BILL-NO                    TO UC-BILL-NO             
A05460     MOVE BG-CODE-UTIL-TYPE             TO UC-CODE-UTIL-TYPE      
A05460     MOVE BG-IC-NO                      TO UC-IC-NO               
A05460     MOVE BG-BILL-ITEM-TIMESTMP         TO UC-BILL-ITEM-TIMESTMP  
A05460     MOVE IN-UC-IDX                     TO MATCH-IDX              
A05460     IF IN-UC-CHANGE-INDICATOR (IN-UC-IDX) = 'I'                  
A05460        PERFORM 4250-PROCESS-UC-NEW-ROWS THRU 4250-EXIT           
A05460        MOVE 'P'                   TO IN-UC-PROCESS-CD (IN-UC-IDX)
A05460     ELSE                                                         
A05460        MOVE 'CR00009999'          TO RS-BUS-RULE-ID              
A05460        PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT           
A05460     END-IF.                                                      
A05460                                                                  
A05460 3320-EXIT.                                                       
A05460     EXIT.                                                        
A05460                                                                  
      *================================================================*        
       3400-METER-POST-PROCESS.                                         
      *================================================================*        
                                                                        
           IF IN-BILL-NO =  WS-RBF-BILL-NO                              
              AND IN-BILL-NO > 0                                        
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CR00009999'            TO RS-BUS-RULE-ID            
              PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM VARYING IN-CX-IDX FROM 1 BY 1                        
             UNTIL IN-CX-IDX > 100                                      
                OR IN-CX-CHANGE-INDICATOR (IN-CX-IDX) = SPACES          
              IF IN-CX-CHANGE-INDICATOR (IN-CX-IDX) = 'I'               
                 PERFORM 3410-PROCESS-CONS       THRU 3410-EXIT         
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           IF AT-REV-MTH-LST-NRML > 0                                   
              MOVE BG-ACCOUNT-NO              TO UT-ACCOUNT-NO          
              MOVE BG-CODE-UTIL-TYPE          TO UT-CODE-UTIL-TYPE      
              MOVE BG-IC-NO                   TO UT-IC-NO               
              PERFORM 7110-GET-READ-CYCLE     THRU 7110-EXIT            
                                                                        
              MOVE UT-READ-CYCLE              TO RW-READ-CYCLE          
              MOVE AT-REV-MTH-LST-NRML        TO RW-REVENUE-MONTH       
              PERFORM 7125-SELECT-OPT-READ-DT THRU 7125-EXIT            
           END-IF.                                                      
                                                                        
           IF WS-CURRENT-DATE >= RW-OPTIMUM-READ-DATE                   
           OR AT-REV-MTH-LST-NRML = 0                                   
              PERFORM 3420-CHECK-FOR-NO-READS THRU 3420-EXIT            
           END-IF.                                                      
                                                                        
       3400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       3410-PROCESS-CONS.                                               
      *================================================================*        
                                                                        
           IF AT-CODE-ACCT-STAT = 'B'                                   
              MOVE 'CR00000086'               TO RS-BUS-RULE-ID         
              PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT           
           END-IF.                                                      
                                                                        
           MOVE BG-ACCOUNT-NO                 TO CX-ACCOUNT-NO          
                                                 MN-ACCOUNT-NO          
                                                 RG-ACCOUNT-NO          
           MOVE BG-BILL-NO                    TO CX-BILL-NO             
           MOVE BG-CODE-UTIL-TYPE             TO CX-CODE-UTIL-TYPE      
                                                 MN-CODE-UTIL-TYPE      
                                                 RG-CODE-UTIL-TYPE      
           MOVE BG-IC-NO                      TO CX-IC-NO               
                                                 MN-IC-NO               
                                                 RG-IC-NO               
           MOVE BG-BILL-ITEM-TIMESTMP         TO CX-BILL-ITEM-TIMESTMP  
           MOVE IN-CX-METER-NO (IN-CX-IDX)    TO CX-METER-NO            
                                                 MN-METER-NO            
                                                 RG-METER-NO            
           MOVE IN-CX-MTR-REF-NO  (IN-CX-IDX) TO CX-MTR-REF-NO          
                                                 MN-MTR-REF-NO          
                                                 RG-MTR-REF-NO          
           IF MN-MTR-REF-NO > 0                                         
              PERFORM 7910-SELECT-MTRD-TYPE  THRU  7910-EXIT            
           ELSE                                                         
              PERFORM 7915-SELECT-MTRD-TYPE  THRU  7915-EXIT            
           END-IF                                                       
           IF WS-ACTIVE-RETURN-CODE =   NOT-FOUND                       
              PERFORM 7920-SELECT-MTRD-TYPE  THRU  7920-EXIT            
           END-IF                                                       
           MOVE IN-CX-CODE-TIME-PERIOD (IN-CX-IDX)                      
                                              TO CX-CODE-TIME-PERIOD    
                                                 MN-CODE-TIME-PERIOD    
                                                 RG-CODE-TIME-PERIOD    
           MOVE IN-CX-CODE-TOU-SEASN (IN-CX-IDX)                        
                                              TO CX-CODE-TOU-SEASN      
           MOVE IN-CX-CODE-USAGE-TYPE (IN-CX-IDX)                       
                                              TO CX-CODE-USAGE-TYPE     
                                                 MN-CODE-USAGE-TYPE     
                                                 RG-CODE-USAGE-TYPE     
           MOVE IN-CX-CODE-USAGE-ID (IN-CX-IDX)                         
                                              TO CX-CODE-USAGE-ID       
                                                 MN-CODE-USAGE-ID       
                                                 RG-CODE-USAGE-ID       
           MOVE IN-CX-ITEM-SEQ-NO (IN-CX-IDX) TO CX-ITEM-SEQ-NO         
           MOVE IN-CX-IDX                     TO MATCH-IDX              
           PERFORM 7510-SELECT-MTRD-ENVRNMT  THRU 7510-EXIT             
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE MN-REG-ID-NO               TO CX-REG-ID-NO           
              MOVE 'MN'                       TO                        
                                      IN-CX-MN-RG-PROCESS-CD (IN-CX-IDX)
              IF IN-CX-DATE-READ (IN-CX-IDX) > MN-LAST-REG-READ-DATE    
                 IF  (MN-MAX-NO-UNITS > 0                               
                 AND (MN-MAX-NO-UNITS * IN-CX-CONSTANT (IN-CX-IDX)      
                                      * IN-CX-NO-DAYS  (IN-CX-IDX))     
                                      < IN-CX-NO-UNITS (IN-CX-IDX))     
                 OR  (MN-MIN-NO-UNITS > 0                               
                 AND (MN-MIN-NO-UNITS * IN-CX-CONSTANT (IN-CX-IDX)      
                                      * IN-CX-NO-DAYS  (IN-CX-IDX))     
                                      > IN-CX-NO-UNITS (IN-CX-IDX))     
                    IF IN-CX-EXCEPT-OVERRIDE-CD (IN-CX-IDX) = 'Y'       
                       CONTINUE                                         
                    ELSE                                                
                       MOVE 'CR00000083'      TO RS-BUS-RULE-ID         
                       PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT  
                    END-IF                                              
                 END-IF                                                 
                 MOVE IN-CX-DATE-READ (IN-CX-IDX)                       
                                              TO MN-LAST-REG-READ-DATE  
                 MOVE '00.00.00'              TO MN-LAST-REG-READ-TIME  
                 MOVE IN-CX-METER-READING (IN-CX-IDX)                   
                                              TO MN-LAST-READ-VALUE     
                 MOVE SPACES                  TO MN-CODE-NO-RD-REASON   
                 MOVE WS-NORMAL-READ          TO MN-CODE-CRNT-REG-READ  
                                                 MN-CODE-LAST-REG-READ  
                 MOVE ZEROES                  TO MN-NO-CONSEC-ESTIMATE  
                 MOVE IN-CX-EXCEPT-OVERRIDE-CD (IN-CX-IDX)              
                                              TO MN-EXCEPT-OVERRIDE-CD  
A05460           IF IN-CX-CODE-TOU-SEASN (IN-CX-IDX) = WS-CURRENT       
                    PERFORM 8850-UPDATE-MTRD-ENV  THRU 8850-EXIT        
A05460           END-IF                                                 
              ELSE                                                      
                 MOVE 'CR00000084'            TO RS-BUS-RULE-ID         
                 PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT        
              END-IF                                                    
           ELSE                                                         
              PERFORM 7520-SELECT-REGISTER-READ   THRU 7520-EXIT        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE RG-REG-ID-NO            TO CX-REG-ID-NO           
                 MOVE 'RG'                    TO                        
                                    IN-CX-MN-RG-PROCESS-CD (IN-CX-IDX)  
                                                                        
                 IF IN-CX-DATE-READ (IN-CX-IDX) > RG-LAST-REG-READ-DT   
                    IF  (RG-MAX-NO-UNITS > 0                            
                    AND (RG-MAX-NO-UNITS * IN-CX-CONSTANT (IN-CX-IDX)   
                                         * IN-CX-NO-DAYS  (IN-CX-IDX))  
                                         < IN-CX-NO-UNITS (IN-CX-IDX))  
                    OR  (RG-MIN-NO-UNITS > 0                            
                    AND (RG-MIN-NO-UNITS * IN-CX-CONSTANT (IN-CX-IDX)   
                                         * IN-CX-NO-DAYS  (IN-CX-IDX))  
                                         > IN-CX-NO-UNITS (IN-CX-IDX))  
                       IF IN-CX-EXCEPT-OVERRIDE-CD (IN-CX-IDX) = 'Y'    
                          CONTINUE                                      
                       ELSE                                             
                          MOVE 'CR00000083'   TO RS-BUS-RULE-ID         
                          PERFORM 8110-SEND-BUSRULE-RESULT              
                                                  THRU 8110-EXIT        
                       END-IF                                           
                    END-IF                                              
                                                                        
                    MOVE IN-CX-DATE-READ (IN-CX-IDX)                    
                                              TO RG-LAST-REG-READ-DT    
                    MOVE '00.00.00'           TO RG-LAST-REG-READ-TM    
                    MOVE WS-NORMAL-READ       TO RG-CODE-CRNT-REG-READ  
                                                 RG-CODE-LAST-REG-READ  
                    IF IN-CX-CODE-USAGE-TYPE (IN-CX-IDX) =              
                                                  ('E' OR 'J' OR        
                                                   'K' OR 'Q' OR        
                                                   'S' )                
                       MOVE IN-CX-DEMAND-READING (IN-CX-IDX)            
                                              TO RG-LAST-READ-VALUE     
                    ELSE                                                
                       MOVE IN-CX-METER-READING (IN-CX-IDX)             
                                              TO RG-LAST-READ-VALUE     
                    END-IF                                              
A05460              IF IN-CX-CODE-TOU-SEASN (IN-CX-IDX) = WS-CURRENT    
                       PERFORM 8870-UPDATE-REG-READ  THRU 8870-EXIT     
A05460              END-IF                                              
                 ELSE                                                   
                    MOVE 'CR00000084'    TO RS-BUS-RULE-ID              
                    PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT     
                 END-IF                                                 
              ELSE                                                      
                 MOVE 'CR00000085'       TO RS-BUS-RULE-ID              
                 PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT        
              END-IF                                                    
           END-IF                                                       
      *****   PERFORM 4150-PROCESS-CX-NEW-ROWS THRU 4150-EXIT                   
      *** GET MAX SEQ                                                           
           PERFORM 7420-GET-MAX-CNSMPTN-SEQ THRU 7420-EXIT              
                                                                        
           MOVE IN-CX-CODE-USAGE-SOURCE (IN-CX-IDX)                     
                                              TO CX-CODE-USAGE-SOURCE   
           MOVE IN-CX-DATE-READ (IN-CX-IDX)   TO CX-DATE-READ           
           MOVE IN-CX-CODE-METER-READ (IN-CX-IDX)                       
                                              TO CX-CODE-METER-READ     
           MOVE IN-CX-CODE-METER-NO-READ (IN-CX-IDX)                    
                                              TO CX-CODE-METER-NO-READ  
           MOVE IN-CX-METER-READING (IN-CX-IDX)                         
                                              TO CX-METER-READING       
           MOVE IN-CX-DEMAND-READING (IN-CX-IDX)                        
                                              TO CX-DEMAND-READING      
           MOVE IN-CX-NO-UNITS (IN-CX-IDX)    TO CX-NO-UNITS            
           MOVE IN-CX-NO-DEMAND-UNITS (IN-CX-IDX)                       
                                              TO CX-NO-DEMAND-UNITS     
           MOVE IN-CX-NO-DAYS (IN-CX-IDX)     TO CX-NO-DAYS             
           MOVE IN-CX-CODE-ITEM-STATUS (IN-CX-IDX)                      
                                              TO CX-CODE-ITEM-STATUS    
           MOVE IN-CX-CONSTANT (IN-CX-IDX)    TO CX-CONSTANT            
           MOVE IN-CX-NO-DIALS (IN-CX-IDX)    TO CX-NO-DIALS            
           MOVE IN-CX-EXCEPT-OVERRIDE-CD (IN-CX-IDX)                    
                                              TO CX-EXCEPT-OVERRIDE-CD  
           MOVE IN-CX-EXCL-DMD-RCHT-IND (IN-CX-IDX)                     
                                              TO CX-EXCL-DMD-RCHT-IND   
           MOVE IN-CX-CODE-DEBIT-CREDIT (IN-CX-IDX)                     
                                              TO CX-CODE-DEBIT-CREDIT   
TEMP  ***  MOVE IN-CX-CODE-SOURCE-ID (IN-CX-IDX)                                
TEMP       MOVE WS-C                          TO CX-CODE-SOURCE-ID      
      ***  MOVE IN-CX-CODE-DISCOUNT (IN-CX-IDX)                                 
      ***                                     TO CX-CODE-DISCOUNT               
           MOVE AT-COMPANY-NO                 TO CX-COMPANY-NO          
           MOVE ZEROES                        TO CX-EMPLOYEE-NO         
                                                 CX-REQUESTED-USAGE     
           MOVE MN-DIGTL-MTR-TYPE             TO  CX-DIGTL-MTR-TYPE     
           MOVE MN-MTR-READ-SOURCE-CD         TO CX-MTR-READ-SOURCE-CD  
           IF IN-CX-PCOMP-FCT (IN-CX-IDX) > 1                           
              MOVE IN-CX-PCOMP-FCT (IN-CX-IDX)   TO CX-PCOMP-FCT        
           ELSE                                                         
              MOVE 1.0                           TO CX-PCOMP-FCT        
           END-IF                                                       
      ***  IF CX-CODE-USAGE-TYPE = 'C'                                          
      ***         AND MN-METER-PRESSURE > 0                                     
      ***     COMPUTE CX-PCOMP-FCT ROUNDED =                                    
      ***               (MN-METER-PRESSURE + 14.7) / 14.73                      
      ***  END-IF                                                               
           MOVE SPACES                        TO CX-DIGTL-INTRL-MTR-NO  
                                                 CX-CODE-DISCOUNT       
                                                                        
           MOVE ZEROS                         TO CX-BTU-FACTOR          
           IF WS-CIG-CUSTOMER       = 'Y' AND MN-INDUST-BTU-ID > SPACES 
              PERFORM 4160-GET-BTU-FACTOR     THRU 4160-EXIT            
           END-IF                                                       
           MOVE IN-CX-CODE-DEBIT-CREDIT (IN-CX-IDX)                     
                                              TO CX-CODE-DEBIT-CREDIT   
           PERFORM 4116-TH-FOR-CX-NEW       THRU 4116-EXIT              
           PERFORM 8773-INSERT-CX           THRU 8773-EXIT.             
                                                                        
       3410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * CHECK WHETHER ALL REGISTERS RECEIVED THE READS. IF SO, UPDATE *         
      * ACCOUNT TO READY TO BILL                                      *         
      *****************************************************************         
      *                                                                         
       3420-CHECK-FOR-NO-READS.                                         
           MOVE AT-BILL-CYCLE                 TO BN-BILL-CYCLE          
           MOVE MN-ACCOUNT-NO                 TO RG-ACCOUNT-NO          
                                                 OC-ACCOUNT-NO          
           MOVE ZERO                          TO WS-MN-AWAITING-RD-COUNT
                                                 WS-RG-AWAITING-RD-COUNT
           PERFORM 7060-CNT-MN-NO-READS       THRU 7060-EXIT            
           IF WS-MN-AWAITING-RD-COUNT EQUAL ZERO                        
              PERFORM 7065-CNT-RG-NO-READS    THRU 7065-EXIT            
               IF WS-RG-AWAITING-RD-COUNT EQUAL ZERO                    
                   IF AT-CODE-ACCT-BILLED EQUAL WS-HOLD-NO-READING      
                                             OR WS-ACCT-HAS-BILLED      
                      CONTINUE                                          
                   ELSE                                                 
                       MOVE WS-READY          TO AT-CODE-ACCT-BILLED    
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
                                                                        
           PERFORM 7070-CHECK-OFF-CYCLE       THRU 7070-EXIT.           
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               PERFORM 7075-CHECK-BILL-DATE   THRU 7075-EXIT            
               IF  WS-DELETE-OFFCYC = 'Y'                               
                   PERFORM 8780-DELETE-OFF-CYCLE THRU 8780-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       3420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       3500-CHANGE-BILL.                                                
      *================================================================*        
                                                                        
           MOVE IN-BILL-NO                    TO WS-ORIG-BILL-NO        
                                                                        
           IF IN-BILL-NO = (WS-RBI-BILL-NO OR WS-RBF-BILL-NO)           
              AND IN-BILL-NO > 0                                        
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CR00009999'            TO RS-BUS-RULE-ID            
              PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BILL-CORRECTED-CD NOT = WS-BILL-CORRECTED-CD         
              AND PARM-BILL-CORRECTED-CD > SPACES                       
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES                     TO WS-TABLE-ID            
                                                 (TH-SUB)               
              MOVE 'BILL CORRECTED'           TO WS-COLUMN-DESC         
                                                      (TH-SUB)          
              EVALUATE WS-BILL-CORRECTED-CD                             
                 WHEN 'C'                                               
                    MOVE 'CORRECTED BILL'                               
                                  TO WS-PRV-COLUMN-VALUE-TXT (TH-SUB)   
                    MOVE 14       TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)   
                 WHEN 'D'                                               
                    MOVE 'CREDIT\DEBIT ADJ'                             
                                  TO WS-PRV-COLUMN-VALUE-TXT (TH-SUB)   
                    MOVE 16       TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)   
                 WHEN 'E'                                               
                    MOVE 'ELIXIR'                                       
                                  TO WS-PRV-COLUMN-VALUE-TXT (TH-SUB)   
                    MOVE 6        TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)   
                 WHEN 'I'                                               
                    MOVE 'IGNORE BILL'                                  
                                  TO WS-PRV-COLUMN-VALUE-TXT (TH-SUB)   
                    MOVE 11       TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)   
                 WHEN 'O'                                               
                    MOVE 'ORIGINAL BILL'                                
                                  TO WS-PRV-COLUMN-VALUE-TXT (TH-SUB)   
                    MOVE 13       TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)   
                 WHEN 'P'                                               
                    MOVE 'PREV.MONTH ADJ'                               
                                  TO WS-PRV-COLUMN-VALUE-TXT (TH-SUB)   
                    MOVE 14       TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)   
                 WHEN OTHER                                             
                    MOVE SPACES                                         
                                  TO WS-PRV-COLUMN-VALUE-TXT (TH-SUB)   
                    MOVE ZERO     TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)   
              END-EVALUATE                                              
                                                                        
              EVALUATE PARM-BILL-CORRECTED-CD                           
                 WHEN 'C'                                               
                    MOVE 'CORRECTED BILL'                               
                                  TO WS-CHG-COLUMN-VALUE-TXT (TH-SUB)   
                    MOVE 14       TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)   
                 WHEN 'D'                                               
                    MOVE 'CREDIT\DEBIT ADJ'                             
                                  TO WS-CHG-COLUMN-VALUE-TXT (TH-SUB)   
                    MOVE 16       TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)   
                 WHEN 'E'                                               
                    MOVE 'ELIXIR'                                       
                                  TO WS-CHG-COLUMN-VALUE-TXT (TH-SUB)   
                    MOVE 6        TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)   
                 WHEN 'I'                                               
                    MOVE 'IGNORE BILL'                                  
                                  TO WS-CHG-COLUMN-VALUE-TXT (TH-SUB)   
                    MOVE 11       TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)   
                 WHEN 'O'                                               
                    MOVE 'ORIGINAL BILL'                                
                                  TO WS-CHG-COLUMN-VALUE-TXT (TH-SUB)   
                    MOVE 13       TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)   
                 WHEN 'P'                                               
                    MOVE 'PREV.MONTH ADJ'                               
                                  TO WS-CHG-COLUMN-VALUE-TXT (TH-SUB)   
                    MOVE 14       TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)   
                 WHEN OTHER                                             
                    MOVE SPACES                                         
                                  TO WS-CHG-COLUMN-VALUE-TXT (TH-SUB)   
                    MOVE ZERO     TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)   
              END-EVALUATE                                              
                                                                        
              MOVE PARM-BILL-CORRECTED-CD     TO BI-BILL-CORRECTED-CD   
              PERFORM 8963-UPDATE-BILL-CORRECTED-CD THRU 8963-EXIT      
           END-IF.                                                      
                                                                        
           PERFORM 3510-CHECK-BG-CHNGS      THRU 3510-EXIT              
           IF BG-CHNGS-EXISTS                                           
              PERFORM 8901-UPDATE-BILL-DET-CHG THRU 8901-EXIT           
           END-IF.                                                      
           PERFORM 3520-CHECK-OTHER-CHNGS   THRU 3520-EXIT              
           IF PARM-ADJ-REASON-CD = '999'                                
              PERFORM 3620-ADD-BILLADJ      THRU 3620-EXIT              
           END-IF.                                                      
                                                                        
       3500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       3510-CHECK-BG-CHNGS.                                             
      *================================================================*        
           SET BG-CHNGS-NOT-EXISTS            TO TRUE                   
           IF IN-AMT-STATE-TAX      NOT = BG-AMT-STATE-TAX              
              MOVE IN-AMT-STATE-TAX      TO BG-AMT-STATE-TAX            
              SET BG-CHNGS-EXISTS             TO TRUE                   
           END-IF.                                                      
                                                                        
           IF IN-AMT-CITY-TAX       NOT = BG-AMT-CITY-TAX               
              MOVE IN-AMT-CITY-TAX       TO BG-AMT-CITY-TAX             
              SET BG-CHNGS-EXISTS             TO TRUE                   
           END-IF.                                                      
                                                                        
           IF IN-AMT-OTHER-TAX      NOT = BG-AMT-OTHER-TAX              
              MOVE IN-AMT-OTHER-TAX      TO BG-AMT-OTHER-TAX            
              SET BG-CHNGS-EXISTS             TO TRUE                   
           END-IF.                                                      
                                                                        
           IF IN-CODE-REVENUE-CLASS NOT = BG-CODE-REVENUE-CLASS         
              MOVE IN-CODE-REVENUE-CLASS TO BG-CODE-REVENUE-CLASS       
              SET BG-CHNGS-EXISTS             TO TRUE                   
           END-IF.                                                      
                                                                        
           IF IN-CODE-SIC-NO        NOT = BG-CODE-SIC-NO                
              MOVE IN-CODE-SIC-NO           TO BG-CODE-SIC-NO           
              SET BG-CHNGS-EXISTS             TO TRUE                   
           END-IF.                                                      
                                                                        
           IF IN-RATE-PLAN-NO       NOT = BG-RATE-PLAN-NO               
              MOVE IN-RATE-PLAN-NO          TO BG-RATE-PLAN-NO          
              SET BG-CHNGS-EXISTS             TO TRUE                   
           END-IF.                                                      
                                                                        
           IF IN-CODE-STAT-TAX-XMT  NOT = BG-CODE-STAT-TAX-XMT          
              MOVE IN-CODE-STAT-TAX-XMT     TO BG-CODE-STAT-TAX-XMT     
              SET BG-CHNGS-EXISTS             TO TRUE                   
           END-IF.                                                      
                                                                        
           IF IN-CODE-CITY-TAX-XMT  NOT = BG-CODE-CITY-TAX-XMT          
              MOVE IN-CODE-CITY-TAX-XMT     TO BG-CODE-CITY-TAX-XMT     
              SET BG-CHNGS-EXISTS             TO TRUE                   
           END-IF.                                                      
                                                                        
           IF IN-CODE-OTHR-TAX-XMT  NOT = BG-CODE-OTHR-TAX-XMT          
              MOVE IN-CODE-OTHR-TAX-XMT     TO BG-CODE-OTHR-TAX-XMT     
              SET BG-CHNGS-EXISTS             TO TRUE                   
           END-IF.                                                      
                                                                        
           IF IN-SHIPPER            NOT = BG-FUEL-SHIPPER-CD            
              MOVE IN-SHIPPER               TO BG-FUEL-SHIPPER-CD       
              SET BG-CHNGS-EXISTS             TO TRUE                   
           END-IF.                                                      
                                                                        
           IF IN-RT-PKG-OPT-SEQ-NO  NOT = BG-RT-PKG-OPT-SEQ-NO          
              MOVE IN-RT-PKG-OPT-SEQ-NO     TO BG-RT-PKG-OPT-SEQ-NO     
              SET BG-CHNGS-EXISTS             TO TRUE                   
           END-IF.                                                      
                                                                        
           IF IN-AMT-BILL-ITEM      NOT = BG-AMT-BILL-ITEM              
              MOVE IN-AMT-BILL-ITEM         TO BG-AMT-BILL-ITEM         
              SET BG-CHNGS-EXISTS             TO TRUE                   
           END-IF.                                                      
                                                                        
           IF IN-TRNSP-OVER-MDQ-FL NOT = BG-TRNSP-OVER-MDQ-FL           
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES                     TO WS-TABLE-ID            
                                                 (TH-SUB)               
              MOVE 'TRNSP_OVER_MDQ'           TO WS-COLUMN-DESC         
                                                      (TH-SUB)          
              MOVE BG-TRNSP-OVER-MDQ-FL       TO WS-PRV-COLUMN-VALUE-TXT
                                                      (TH-SUB)          
              MOVE 1                          TO WS-PRV-COLUMN-VALUE-LEN
                                                      (TH-SUB)          
              MOVE IN-TRNSP-OVER-MDQ-FL       TO WS-CHG-COLUMN-VALUE-TXT
                                                      (TH-SUB)          
              MOVE 1                          TO WS-CHG-COLUMN-VALUE-LEN
                                                      (TH-SUB)          
              MOVE IN-TRNSP-OVER-MDQ-FL     TO BG-TRNSP-OVER-MDQ-FL     
              SET BG-CHNGS-EXISTS             TO TRUE                   
           END-IF.                                                      
                                                                        
           PERFORM 3630-BG-CHNGS-TX-HIST    THRU 3630-EXIT.             
                                                                        
       3510-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *================================================================*        
       3520-CHECK-OTHER-CHNGS.                                          
      *================================================================*        
           MOVE IN-ACCOUNT-NO              TO UC-ACCOUNT-NO             
           MOVE WS-ORIG-BILL-NO            TO UC-BILL-NO                
           MOVE IN-CODE-UTIL-TYPE          TO UC-CODE-UTIL-TYPE         
           MOVE IN-IC-NO                   TO UC-IC-NO                  
           MOVE WS-ORIG-ITEM-TIMESTMP      TO UC-BILL-ITEM-TIMESTMP     
           PERFORM VARYING IN-UC-IDX FROM 1 BY 1                        
              UNTIL IN-UC-IDX > 100                                     
              OR IN-UC-CHANGE-INDICATOR (IN-UC-IDX) = SPACES            
              MOVE IN-UC-RATE-ITEM-CODE (IN-UC-IDX)                     
                                              TO UC-RATE-ITEM-CODE      
              MOVE IN-UC-ITEM-SEQ-NO (IN-UC-IDX)                        
                                              TO UC-ITEM-SEQ-NO         
              MOVE IN-UC-IDX                  TO MATCH-IDX              
              EVALUATE TRUE                                             
                 WHEN IN-UC-CHANGE-INDICATOR (IN-UC-IDX) = 'U'          
                    PERFORM 7791-SELECT-UC-DATA     THRU 7791-EXIT      
                    PERFORM 4220-TH-FOR-UC-UPD      THRU 4220-EXIT      
                    PERFORM 8915-UPDATE-UM-HIST     THRU 8915-EXIT      
                 WHEN IN-UC-CHANGE-INDICATOR (IN-UC-IDX) = 'D'          
                    PERFORM 7791-SELECT-UC-DATA     THRU 7791-EXIT      
                    PERFORM 4230-TH-FOR-UC-DEL      THRU 4230-EXIT      
                    PERFORM 8740-DELETE-UM-HIST     THRU 8740-EXIT      
                 WHEN IN-UC-CHANGE-INDICATOR (IN-UC-IDX) = 'I'          
                    PERFORM 4250-PROCESS-UC-NEW-ROWS THRU 4250-EXIT     
                    MOVE 'P'   TO IN-UC-PROCESS-CD  (IN-UC-IDX)         
                 WHEN OTHER                                             
                    MOVE 'CR00009999'            TO RS-BUS-RULE-ID      
                    PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT     
              END-EVALUATE                                              
           END-PERFORM.                                                 
                                                                        
                                                                        
           MOVE IN-ACCOUNT-NO                 TO CX-ACCOUNT-NO          
           MOVE WS-ORIG-BILL-NO               TO CX-BILL-NO             
           MOVE IN-CODE-UTIL-TYPE             TO CX-CODE-UTIL-TYPE      
           MOVE IN-IC-NO                      TO CX-IC-NO               
           MOVE WS-ORIG-ITEM-TIMESTMP         TO CX-BILL-ITEM-TIMESTMP  
           MOVE SPACES                        TO WS-METER-NO-HOLD       
                                                                        
           PERFORM VARYING IN-CX-IDX FROM 1 BY 1                        
              UNTIL IN-CX-IDX > 100                                     
              OR IN-CX-CHANGE-INDICATOR (IN-CX-IDX) = SPACES            
              MOVE IN-CX-MTR-REF-NO  (IN-CX-IDX)                        
                                              TO CX-MTR-REF-NO          
              MOVE IN-CX-REG-ID-NO (IN-CX-IDX) TO CX-REG-ID-NO          
              MOVE IN-CX-CODE-TIME-PERIOD (IN-CX-IDX)                   
                                              TO CX-CODE-TIME-PERIOD    
              MOVE IN-CX-ITEM-SEQ-NO (IN-CX-IDX) TO CX-ITEM-SEQ-NO      
              MOVE IN-CX-IDX                  TO MATCH-IDX              
              EVALUATE TRUE                                             
                 WHEN IN-CX-CHANGE-INDICATOR (IN-CX-IDX) = 'U'          
                    PERFORM 7792-SELECT-CX-DATA     THRU 7792-EXIT      
                    PERFORM 4112-TH-FOR-CX-UPD      THRU 4112-EXIT      
                    PERFORM 8910-UPDATE-CX-HIST     THRU 8910-EXIT      
                 WHEN IN-CX-CHANGE-INDICATOR (IN-CX-IDX) = 'D'          
                    PERFORM 7792-SELECT-CX-DATA     THRU 7792-EXIT      
                    PERFORM 4114-TH-FOR-CX-DEL      THRU 4114-EXIT      
                    PERFORM 8745-DELETE-CX-HIST     THRU 8745-EXIT      
                    MOVE CX-ACCOUNT-NO     TO UT-ACCOUNT-NO             
                    MOVE CX-CODE-UTIL-TYPE TO UT-CODE-UTIL-TYPE         
                    MOVE CX-IC-NO          TO UT-IC-NO                  
                    MOVE SPACES            TO UT-CODE-ESTIMATE-OK       
                    PERFORM 8909-UPDATE-UT-EST-OK   THRU 8909-EXIT      
                 WHEN IN-CX-CHANGE-INDICATOR (IN-CX-IDX) = 'I'          
                    PERFORM 4150-PROCESS-CX-NEW-ROWS THRU 4150-EXIT     
                    MOVE 'P'            TO IN-CX-PROCESS-CD (IN-CX-IDX) 
                 WHEN OTHER                                             
                    MOVE 'CR00009999'         TO RS-BUS-RULE-ID         
                    PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT     
              END-EVALUATE                                              
           END-PERFORM.                                                 
                                                                        
           MOVE IN-ACCOUNT-NO                 TO FH-ACCOUNT-NO          
           MOVE WS-ORIG-BILL-NO               TO FH-BILL-NO             
           MOVE IN-CODE-UTIL-TYPE             TO FH-CODE-UTIL-TYPE      
           MOVE IN-IC-NO                      TO FH-IC-NO               
           MOVE WS-ORIG-ITEM-TIMESTMP         TO FH-BILL-ITEM-TIMESTMP  
                                                                        
           PERFORM VARYING IN-FH-IDX FROM 1 BY 1                        
              UNTIL IN-FH-IDX > 100                                     
              OR IN-FH-CHANGE-INDICATOR (IN-FH-IDX) = SPACES            
              MOVE IN-FH-FIXED-FCTR-SEQ-NO  (IN-FH-IDX)                 
                                              TO FH-FIXED-FCTR-SEQ-NO   
              MOVE IN-FH-IDX                  TO MATCH-IDX              
              EVALUATE TRUE                                             
                 WHEN IN-FH-CHANGE-INDICATOR (IN-FH-IDX) = 'U'          
                    PERFORM 7793-SELECT-FH-DATA     THRU 7793-EXIT      
                    PERFORM 4320-TH-FOR-FH-UPD      THRU 4320-EXIT      
      *** DURATION REMAINING NEED TO TAKE CARE                                  
                    PERFORM 8916-UPDATE-FH-HIST     THRU 8916-EXIT      
                 WHEN IN-FH-CHANGE-INDICATOR (IN-FH-IDX) = 'D'          
                    PERFORM 7793-SELECT-FH-DATA     THRU 7793-EXIT      
                    PERFORM 4330-TH-FOR-FH-DEL      THRU 4330-EXIT      
                    PERFORM 8750-DELETE-FH-HIST     THRU 8750-EXIT      
                 WHEN IN-FH-CHANGE-INDICATOR (IN-FH-IDX) = 'I'          
                    PERFORM 4350-PROCESS-FH-NEW-ROWS THRU 4350-EXIT     
                    MOVE 'P'   TO IN-FH-PROCESS-CD  (IN-FH-IDX)         
                 WHEN OTHER                                             
                    MOVE 'CR00009999'            TO RS-BUS-RULE-ID      
                    PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT     
              END-EVALUATE                                              
           END-PERFORM.                                                 
                                                                        
           MOVE IN-ACCOUNT-NO              TO BP-ACCOUNT-NO             
           MOVE WS-ORIG-BILL-NO            TO BP-BILL-NO                
           MOVE IN-CODE-UTIL-TYPE          TO BP-CODE-UTIL-TYPE         
           MOVE IN-IC-NO                   TO BP-IC-NO                  
           MOVE WS-ORIG-ITEM-TIMESTMP      TO BP-BILL-ITEM-TIMESTMP     
                                                                        
      *** BP PROCESS DIFFERENT THAN CX, UC, FH                                  
           PERFORM 4410-PROCESS-BP-CHANGES    THRU 4410-EXIT.           
                                                                        
       3520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       3600-CREATE-RBILL.                                               
      *================================================================*        
                                                                        
           MOVE IN-ACCOUNT-NO                 TO BG-ACCOUNT-NO          
           MOVE WS-RB-BILL-NO                 TO BG-BILL-NO             
           MOVE IN-CODE-UTIL-TYPE             TO BG-CODE-UTIL-TYPE      
           MOVE IN-IC-NO                      TO BG-IC-NO               
           MOVE WS-CURRENT-TIMESTMP           TO BG-BILL-ITEM-TIMESTMP  
                                                 WS-RB-ITEM-TIMESTMP    
           MOVE WS-C                          TO BG-CODE-BILL-ITM-TYPE  
      *****  THIS VARIABLE NOT KEEPING VALUE, SO FIX IT                         
           IF WS-DATE-ORIG-BILL-NULL = -1                               
              MOVE WS-DATE-BILLED             TO BG-DATE-ORIG-BILL      
           END-IF.                                                      
           MOVE ZERO                          TO WS-DATE-ORIG-BILL-NULL1
           MOVE WS-HOLD-REVENUE-MONTH         TO BG-REV-MTH-ORIG-BILL   
           MOVE ZEROES                        TO BG-REVENUE-MONTH       
           MOVE WS-CODE-BILL-ITM-IND          TO BG-CODE-BILL-ITM-IND   
           MOVE WS-CODE-BILL-CALC             TO BG-CODE-BILL-CALC      
           MOVE WS-D                          TO BG-CODE-DR-CR-CNSMPTN  
           MOVE IN-CODE-STAT-TAX-XMT          TO BG-CODE-STAT-TAX-XMT   
           MOVE IN-CODE-CITY-TAX-XMT          TO BG-CODE-CITY-TAX-XMT   
           MOVE 'Y'                           TO BG-REBILL-IND          
           MOVE IN-CODE-OTHR-TAX-XMT          TO BG-CODE-OTHR-TAX-XMT   
           MOVE IN-RATE-PLAN-NO               TO BG-RATE-PLAN-NO        
           MOVE IN-CODE-REVENUE-CLASS         TO BG-CODE-REVENUE-CLASS  
           MOVE IN-CODE-SIC-NO                TO BG-CODE-SIC-NO         
           MOVE WS-CODE-CURTAIL-PRTY          TO BG-CODE-CURTAIL-PRTY   
           MOVE WS-TAX-REFUND-CD              TO BG-TAX-REFUND-CD       
           MOVE WS-REV-RPT-CD                 TO BG-REV-RPT-CD          
           MOVE ZERO                          TO BG-NO-OF-CONS-DAYS     
           EVALUATE TRUE                                                
              WHEN WS-CALC-COMMAND   = 'S'                              
                 MOVE IN-AMT-BILL-ITEM        TO BG-AMT-BILL-ITEM       
                 MOVE IN-AMT-STATE-TAX        TO BG-AMT-STATE-TAX       
                 MOVE IN-AMT-CITY-TAX         TO BG-AMT-CITY-TAX        
                 MOVE IN-AMT-OTHER-TAX        TO BG-AMT-OTHER-TAX       
              WHEN WS-CALC-COMMAND = 'J'                                
                 MOVE IN-AMT-BILL-ITEM        TO BG-AMT-BILL-ITEM       
                 MOVE ZEROES                  TO BG-AMT-STATE-TAX       
                                                 BG-AMT-CITY-TAX        
                                                 BG-AMT-OTHER-TAX       
              WHEN OTHER                                                
                 MOVE ZEROS                   TO BG-AMT-BILL-ITEM       
                                                 BG-AMT-STATE-TAX       
                                                 BG-AMT-CITY-TAX        
                                                 BG-AMT-OTHER-TAX       
           END-EVALUATE.                                                
           MOVE IN-SHIPPER                    TO BG-FUEL-SHIPPER-CD     
                                                                        
           MOVE IN-RT-PKG-OPT-SEQ-NO          TO BG-RT-PKG-OPT-SEQ-NO   
                                                                        
           MOVE WS-WNA-FACTOR                 TO BG-WNA-FACTOR          
           IF PARM-ADJ-REASON-CD = '999'                                
              MOVE PARM-ADJ-DESC-TXT          TO K0-ADJ-REASON-DESC     
              PERFORM 7450-GET-BADJ-ADJST-RSN-CD                        
                                              THRU 7450-EXIT            
           END-IF                                                       
AA5744     MOVE WS-ADJ-REASON-CD              TO BG-ADJ-REASON-CD       
AA5744     MOVE WS-PRORATE-CD                 TO BG-PRORATE-CD          
AA5744     MOVE WS-BTU-FACTOR                 TO BG-BTU-FACTOR          
AA5744     MOVE WS-GAS-BASE-USE               TO BG-GAS-BASE-USE        
                                                                        
AA5744     PERFORM 3630-BG-CHNGS-TX-HIST    THRU 3630-EXIT.             
                                                                        
           PERFORM 5800-CHECK-CIG-CUST        THRU 5800-EXIT            
           PERFORM 8771-INSERT-BILL-DETAIL    THRU 8771-EXIT.           
                                                                        
           IF PARM-ADJ-REASON-CD = '999'                                
              PERFORM 3620-ADD-BILLADJ        THRU 3620-EXIT            
           END-IF.                                                      
                                                                        
           PERFORM 3610-REBILL-BILL THRU 3610-EXIT.                     
                                                                        
       3600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       3610-REBILL-BILL.                                                
      *================================================================*        
                                                                        
A05744     IF UN-METERED-IC OR NO-UN-CX-CHANGED                         
              MOVE IN-ACCOUNT-NO              TO UC-ACCOUNT-NO          
              MOVE WS-ORIG-BILL-NO            TO UC-BILL-NO             
              MOVE IN-CODE-UTIL-TYPE          TO UC-CODE-UTIL-TYPE      
              MOVE IN-IC-NO                   TO UC-IC-NO               
              MOVE WS-ORIG-ITEM-TIMESTMP      TO UC-BILL-ITEM-TIMESTMP  
                                                                        
              PERFORM 7780-OPEN-UC-SHFT-CRSR  THRU 7780-EXIT            
              PERFORM 7781-FETCH-UC-SHFT-CRSR THRU 7781-EXIT            
              PERFORM 4200-PROCESS-UC-RBILL   THRU 4200-EXIT            
                 UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                
              PERFORM 7782-CLOSE-UC-SHFT-CRSR THRU 7782-EXIT            
              PERFORM VARYING IN-UC-IDX FROM 1 BY 1                     
                    UNTIL IN-UC-IDX > 100                               
                    OR IN-UC-CHANGE-INDICATOR (IN-UC-IDX) = SPACES      
                 EVALUATE TRUE                                          
                    WHEN IN-UC-PROCESS-CD (IN-UC-IDX) = ' '             
                       AND IN-UC-CHANGE-INDICATOR (IN-UC-IDX) = 'I'     
                       MOVE WS-RB-BILL-NO        TO UC-BILL-NO          
                       MOVE WS-RB-ITEM-TIMESTMP TO UC-BILL-ITEM-TIMESTMP
                       PERFORM 4250-PROCESS-UC-NEW-ROWS THRU 4250-EXIT  
                       MOVE 'P'   TO IN-UC-PROCESS-CD  (IN-UC-IDX)      
                    WHEN IN-UC-PROCESS-CD (IN-UC-IDX) = 'P'             
                       CONTINUE                                         
                    WHEN OTHER                                          
                       MOVE 'CR00009999'         TO RS-BUS-RULE-ID      
                       PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT  
                 END-EVALUATE                                           
              END-PERFORM                                               
           END-IF.                                                      
                                                                        
           MOVE IN-ACCOUNT-NO                 TO CX-ACCOUNT-NO          
           MOVE WS-ORIG-BILL-NO               TO CX-BILL-NO             
           MOVE IN-CODE-UTIL-TYPE             TO CX-CODE-UTIL-TYPE      
           MOVE IN-IC-NO                      TO CX-IC-NO               
           MOVE WS-ORIG-ITEM-TIMESTMP         TO CX-BILL-ITEM-TIMESTMP  
           MOVE SPACES                        TO WS-METER-NO-HOLD       
                                                                        
           PERFORM 7777-OPEN-CX-SHFT-CRSR     THRU 7777-EXIT            
           PERFORM 7778-FETCH-CX-SHFT-CRSR    THRU 7778-EXIT            
           PERFORM 4100-PROCESS-CX-RBILL   THRU 4100-EXIT               
               UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                  
           PERFORM 7779-CLOSE-CX-SHFT-CRSR    THRU 7779-EXIT            
           PERFORM VARYING IN-CX-IDX FROM 1 BY 1                        
              UNTIL IN-CX-IDX > 100                                     
              OR IN-CX-CHANGE-INDICATOR (IN-CX-IDX) = SPACES            
              EVALUATE TRUE                                             
                 WHEN IN-CX-PROCESS-CD (IN-CX-IDX) = ' '                
                    AND IN-CX-CHANGE-INDICATOR (IN-CX-IDX) = 'I'        
                    MOVE WS-RB-BILL-NO        TO CX-BILL-NO             
                    MOVE WS-RB-ITEM-TIMESTMP  TO CX-BILL-ITEM-TIMESTMP  
                                                                        
                    MOVE IN-CX-MTR-REF-NO (IN-CX-IDX) TO CX-MTR-REF-NO  
                    MOVE IN-CX-REG-ID-NO (IN-CX-IDX)  TO CX-REG-ID-NO   
                    MOVE IN-CX-CODE-TIME-PERIOD (IN-CX-IDX)             
                                              TO CX-CODE-TIME-PERIOD    
                    PERFORM 4150-PROCESS-CX-NEW-ROWS THRU 4150-EXIT     
                    MOVE 'P'            TO IN-CX-PROCESS-CD (IN-CX-IDX) 
                 WHEN IN-CX-PROCESS-CD (IN-CX-IDX) = 'P'                
                    CONTINUE                                            
                 WHEN OTHER                                             
                    MOVE 'CR00009999'         TO RS-BUS-RULE-ID         
                    PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT     
              END-EVALUATE                                              
           END-PERFORM                                                  
                                                                        
           MOVE IN-ACCOUNT-NO                 TO FH-ACCOUNT-NO          
           MOVE WS-ORIG-BILL-NO               TO FH-BILL-NO             
           MOVE IN-CODE-UTIL-TYPE             TO FH-CODE-UTIL-TYPE      
           MOVE IN-IC-NO                      TO FH-IC-NO               
           MOVE WS-ORIG-ITEM-TIMESTMP         TO FH-BILL-ITEM-TIMESTMP  
                                                                        
           PERFORM 7490-OPEN-FH-MAINT-CRSR    THRU 7490-EXIT            
           PERFORM 7495-FETCH-FH-MAINT-CRSR   THRU 7495-EXIT            
           PERFORM 4300-PROCESS-FH-RBILL      THRU 4300-EXIT            
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
           PERFORM 7500-CLOSE-FH-CRSR         THRU 7500-EXIT.           
           PERFORM VARYING IN-FH-IDX FROM 1 BY 1                        
              UNTIL IN-FH-IDX > 100                                     
              OR IN-FH-CHANGE-INDICATOR (IN-FH-IDX) = SPACES            
              EVALUATE TRUE                                             
                 WHEN IN-FH-PROCESS-CD (IN-FH-IDX) = ' '                
                    AND IN-FH-CHANGE-INDICATOR (IN-FH-IDX) = 'I'        
                    MOVE WS-RB-BILL-NO        TO FH-BILL-NO             
                    MOVE WS-RB-ITEM-TIMESTMP  TO FH-BILL-ITEM-TIMESTMP  
                    PERFORM 4350-PROCESS-FH-NEW-ROWS THRU 4350-EXIT     
                    MOVE 'P'   TO IN-FH-PROCESS-CD  (IN-FH-IDX)         
                 WHEN IN-FH-PROCESS-CD (IN-FH-IDX) = 'P'                
                    CONTINUE                                            
                 WHEN OTHER                                             
                    MOVE 'CR00009999'            TO RS-BUS-RULE-ID      
                    PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT     
              END-EVALUATE                                              
           END-PERFORM                                                  
                                                                        
           MOVE IN-ACCOUNT-NO                 TO GA-ACCOUNT-NO          
           MOVE WS-ORIG-BILL-NO               TO GA-BILL-NO             
           MOVE IN-CODE-UTIL-TYPE             TO GA-CODE-UTIL-TYPE      
           MOVE IN-IC-NO                      TO GA-IC-NO               
           MOVE WS-ORIG-ITEM-TIMESTMP         TO GA-BILL-ITEM-TIMESTMP  
           PERFORM 7800-OPEN-MTR-CRSR         THRU 7800-EXIT            
           PERFORM 7805-FETCH-MTR-CRSR        THRU 7805-EXIT            
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              MOVE WS-RB-BILL-NO              TO GA-BILL-NO             
              MOVE WS-RB-ITEM-TIMESTMP        TO GA-BILL-ITEM-TIMESTMP  
              PERFORM 7815-INSERT-MTR         THRU 7815-EXIT            
              PERFORM 7805-FETCH-MTR-CRSR     THRU 7805-EXIT            
           END-PERFORM.                                                 
           PERFORM 7810-CLOSE-MTR-CRSR        THRU 7810-EXIT            
                                                                        
           MOVE IN-ACCOUNT-NO              TO BP-ACCOUNT-NO             
           MOVE WS-ORIG-BILL-NO            TO BP-BILL-NO                
           MOVE IN-CODE-UTIL-TYPE          TO BP-CODE-UTIL-TYPE         
           MOVE IN-IC-NO                   TO BP-IC-NO                  
           MOVE WS-ORIG-ITEM-TIMESTMP      TO BP-BILL-ITEM-TIMESTMP     
           PERFORM 7210-OPEN-BILLADJ-CRSR     THRU 7210-EXIT            
           PERFORM 7220-FETCH-BILLADJ-CRSR    THRU 7220-EXIT            
           PERFORM 4400-PROCESS-BP-RBILL      THRU 4400-EXIT            
              UNTIL WS-ACTIVE-RETURN-CODE      = NOT-FOUND              
           PERFORM 7240-CLOSE-BILLADJ-CRSR    THRU 7240-EXIT.           
                                                                        
           MOVE WS-RB-BILL-NO         TO BP-BILL-NO                     
           MOVE WS-RB-ITEM-TIMESTMP   TO BP-BILL-ITEM-TIMESTMP          
      *** BP PROCESS DIFFERENT THAN CX, UC, FH                                  
           PERFORM 4410-PROCESS-BP-CHANGES    THRU 4410-EXIT.           
                                                                        
           MOVE IN-ACCOUNT-NO                 TO NG-ACCOUNT-NO          
                                                 NU-ACCOUNT-NO          
           MOVE WS-ORIG-BILL-NO               TO NG-BILL-NO             
                                                 NU-BILL-NO             
           MOVE IN-CODE-UTIL-TYPE             TO NG-CODE-UTIL-TYPE      
                                                 NU-CODE-UTIL-TYPE      
           MOVE IN-IC-NO                      TO NG-IC-NO               
                                                 NU-IC-NO               
           MOVE WS-ORIG-ITEM-TIMESTMP         TO NG-BILL-ITEM-TIMESTMP  
                                                 NU-BILL-ITEM-TIMESTMP  
           PERFORM 7970-GET-BILL-MANUAL THRU 7970-EXIT.                 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-RB-BILL-NO              TO NG-BILL-NO             
              MOVE WS-RB-ITEM-TIMESTMP        TO NG-BILL-ITEM-TIMESTMP  
              PERFORM 8030-INSERT-BILLMAN     THRU 8030-EXIT            
              PERFORM 7975-OPEN-BILLMAN-CRSR  THRU 7975-EXIT            
              PERFORM 7980-FETCH-BILLMAN-CRSR THRU 7980-EXIT            
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
                 MOVE WS-RB-BILL-NO           TO NU-BILL-NO             
                 MOVE WS-RB-ITEM-TIMESTMP     TO NU-BILL-ITEM-TIMESTMP  
                 PERFORM 8040-INSERT-MANDET   THRU 8040-EXIT            
                 PERFORM 7980-FETCH-BILLMAN-CRSR THRU 7980-EXIT         
              END-PERFORM                                               
              PERFORM 7985-CLOSE-BILLMAN-CRSR THRU 7985-EXIT            
           END-IF.                                                      
                                                                        
           IF WS-CIG-CUSTOMER = 'Y' OR WS-NET-MTR-CUSTOMER = 'Y'        
              MOVE IN-ACCOUNT-NO              TO ND-ACCOUNT-NO          
              MOVE WS-ORIG-BILL-NO            TO ND-BILL-NO             
              MOVE IN-CODE-UTIL-TYPE          TO ND-CODE-UTIL-TYPE      
              MOVE IN-IC-NO                   TO ND-IC-NO               
              MOVE WS-ORIG-ITEM-TIMESTMP      TO ND-BILL-ITEM-TIMESTMP  
              PERFORM 7820-OPEN-VOL-CRSR      THRU 7820-EXIT            
              PERFORM 7825-FETCH-VOL-CRSR     THRU 7825-EXIT            
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
                 MOVE WS-RB-BILL-NO           TO ND-BILL-NO             
                 MOVE WS-RB-ITEM-TIMESTMP     TO ND-BILL-ITEM-TIMESTMP  
                 PERFORM 7827-INSERT-VOL      THRU 7827-EXIT            
                 PERFORM 7825-FETCH-VOL-CRSR  THRU 7825-EXIT            
              END-PERFORM                                               
              PERFORM 7826-CLOSE-VOL-CRSR     THRU 7826-EXIT            
           END-IF.                                                      
                                                                        
       3610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       3620-ADD-BILLADJ.                                                
      *================================================================*        
                                                                        
           MOVE BG-ACCOUNT-NO              TO BP-ACCOUNT-NO             
           MOVE BG-BILL-NO                 TO BP-BILL-NO                
           MOVE BG-CODE-UTIL-TYPE          TO BP-CODE-UTIL-TYPE         
           MOVE BG-IC-NO                   TO BP-IC-NO                  
           MOVE BG-BILL-ITEM-TIMESTMP      TO BP-BILL-ITEM-TIMESTMP     
           MOVE 'BADJ'                     TO BP-ADJ-TYPE-CD            
           MOVE ZERO                       TO BP-REVENUE-MONTH          
           MOVE ZEROS                      TO BP-OVRRIDE-RT-REV-MTH     
           MOVE SPACES                     TO BP-OVRRIDE-RT-BILL-CY     
           MOVE -1                         TO WS-OVRD-BILL-DT-NULL      
           MOVE SPACES                     TO BP-SPECIAL-PROCESS-CD     
           MOVE PARM-ADJ-DESC-LEN          TO BP-ADJ-REASON-DESC-LEN    
           MOVE PARM-ADJ-DESC-TXT          TO BP-ADJ-REASON-DESC-TEXT   
                                                                        
           PERFORM 7230-INSERT-BILLADJ     THRU 7230-EXIT               
                                                                        
      **   IF WS-ACTIVE-RETURN-CODE = -803                                      
              PERFORM 7250-UPDATE-BILLADJ  THRU 7250-EXIT.              
      **   END-IF.                                                              
                                                                        
       3620-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       3630-BG-CHNGS-TX-HIST.                                           
      *================================================================*        
           IF IN-PRORATE-CD         NOT = BG-PRORATE-CD                 
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES                     TO WS-TABLE-ID            
                                                 (TH-SUB)               
              MOVE 'PRORATE_CD   '            TO WS-COLUMN-DESC         
                                                      (TH-SUB)          
              MOVE BG-PRORATE-CD              TO WS-PRV-COLUMN-VALUE-TXT
                                                      (TH-SUB)          
              MOVE 1                          TO WS-PRV-COLUMN-VALUE-LEN
                                                      (TH-SUB)          
              MOVE IN-PRORATE-CD              TO WS-CHG-COLUMN-VALUE-TXT
                                                      (TH-SUB)          
              MOVE 1                          TO WS-CHG-COLUMN-VALUE-LEN
                                                      (TH-SUB)          
                                                                        
              MOVE IN-PRORATE-CD            TO BG-PRORATE-CD            
              SET BG-CHNGS-EXISTS             TO TRUE                   
           END-IF.                                                      
                                                                        
           IF IN-BG-ADJ-REASON-CD  NOT = BG-ADJ-REASON-CD               
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES                     TO WS-TABLE-ID            
                                                 (TH-SUB)               
              MOVE 'ADJ_REASON_CD'            TO WS-COLUMN-DESC         
                                                      (TH-SUB)          
              IF BG-ADJ-REASON-CD > SPACES                              
                 MOVE BG-ADJ-REASON-CD       TO K0-ADJ-REASON-CD        
                 PERFORM 7050-GET-REASN-DESC THRU 7050-EXIT             
                 MOVE 1           TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)   
                 STRING K0-ADJ-REASON-DESC DELIMITED BY '  '            
                    INTO WS-PRV-COLUMN-VALUE-TXT (TH-SUB)               
                    WITH POINTER WS-PRV-COLUMN-VALUE-LEN (TH-SUB)       
                 COMPUTE WS-PRV-COLUMN-VALUE-LEN (TH-SUB)               
                          = WS-PRV-COLUMN-VALUE-LEN (TH-SUB) - 1        
              ELSE                                                      
                 MOVE 1           TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)   
                 MOVE SPACES      TO WS-PRV-COLUMN-VALUE-TXT (TH-SUB)   
              END-IF                                                    
              MOVE IN-BG-ADJ-REASON-CD        TO K0-ADJ-REASON-CD       
              PERFORM 7050-GET-REASN-DESC THRU 7050-EXIT                
              MOVE 1              TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)   
              STRING K0-ADJ-REASON-DESC DELIMITED BY '  '               
                INTO WS-CHG-COLUMN-VALUE-TXT (TH-SUB)                   
              WITH POINTER WS-CHG-COLUMN-VALUE-LEN (TH-SUB)             
              COMPUTE WS-CHG-COLUMN-VALUE-LEN (TH-SUB)                  
                         = WS-CHG-COLUMN-VALUE-LEN (TH-SUB) - 1         
                                                                        
              MOVE IN-BG-ADJ-REASON-CD      TO BG-ADJ-REASON-CD         
              SET BG-CHNGS-EXISTS             TO TRUE                   
           END-IF.                                                      
                                                                        
AA5744     IF IN-BG-GAS-BASE-USE    NOT = BG-GAS-BASE-USE               
AA5744        COMPUTE TH-SUB = TH-SUB + 1                               
AA5744        MOVE SPACES             TO WS-TABLE-ID (TH-SUB)           
AA5744        MOVE 'GAS BASE USE'     TO WS-COLUMN-DESC (TH-SUB)        
AA5744        MOVE BG-GAS-BASE-USE    TO WS-EDIT-DEC-ZERO               
AA5744        MOVE WS-EDIT-DEC-ZERO   TO WS-PRV-COLUMN-VALUE-TXT        
AA5744                                       (TH-SUB)                   
AA5744        MOVE 10                 TO WS-PRV-COLUMN-VALUE-LEN        
AA5744                                       (TH-SUB)                   
AA5744        MOVE IN-BG-GAS-BASE-USE TO WS-EDIT-DEC-ZERO               
AA5744        MOVE WS-EDIT-DEC-ZERO   TO WS-CHG-COLUMN-VALUE-TXT        
AA5744                                       (TH-SUB)                   
AA5744        MOVE 10                 TO WS-CHG-COLUMN-VALUE-LEN        
AA5744                                       (TH-SUB)                   
AA5744        MOVE IN-BG-GAS-BASE-USE TO BG-GAS-BASE-USE                
AA5744        SET BG-CHNGS-EXISTS             TO TRUE                   
AA5744     END-IF.                                                      
AA5744                                                                  
A05460     IF IN-BG-BTU-FACTOR      NOT = BG-BTU-FACTOR                 
A05460        COMPUTE TH-SUB = TH-SUB + 1                               
A05460        MOVE SPACES                     TO WS-TABLE-ID            
A05460                                           (TH-SUB)               
A05460        MOVE 'BTU FACTOR   '            TO WS-COLUMN-DESC         
A05460                                                (TH-SUB)          
A05460        MOVE BG-BTU-FACTOR              TO WS-BG-BTU-FACTOR-Z     
A05460        MOVE WS-BG-BTU-FACTOR-Z         TO WS-PRV-COLUMN-VALUE-TXT
A05460                                                (TH-SUB)          
A05460        MOVE 8                          TO WS-PRV-COLUMN-VALUE-LEN
A05460                                                (TH-SUB)          
A05460        MOVE IN-BG-BTU-FACTOR           TO WS-BG-BTU-FACTOR-Z     
A05460        MOVE WS-BG-BTU-FACTOR-Z         TO WS-CHG-COLUMN-VALUE-TXT
A05460                                                (TH-SUB)          
A05460        MOVE 8                          TO WS-CHG-COLUMN-VALUE-LEN
A05460                                                (TH-SUB)          
A05460        MOVE IN-BG-BTU-FACTOR           TO BG-BTU-FACTOR          
A05460        SET BG-CHNGS-EXISTS             TO TRUE                   
A05460     END-IF.                                                      
                                                                        
       3630-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       3700-MOVE-TO-IMMIDIATE.                                          
      *================================================================*        
                                                                        
           IF IN-BILL-NO =  WS-RBF-BILL-NO                              
              AND IN-BILL-NO > 0                                        
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CR00009999'            TO RS-BUS-RULE-ID            
              PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT           
           END-IF.                                                      
                                                                        
           IF WS-RBI-BILL-NO > 0                                        
              MOVE WS-RBI-BILL-NO        TO WS-RB-BILL-NO               
           ELSE                                                         
              MOVE AT-NXT-BILL-NO        TO WS-RBI-BILL-NO              
                                            SHFT-FROM-BILL-NO           
              COMPUTE SHFT-TO-BILL-NO  = SHFT-FROM-BILL-NO + 1          
              MOVE SHFT-TO-BILL-NO       TO WS-RBF-BILL-NO              
              PERFORM 3950-SHIFT-BILL-NO THRU 3950-EXIT                 
              MOVE WS-RBI-BILL-NO        TO WS-RB-BILL-NO               
              MOVE WS-ORIG-BILL-NO       TO SHFT-FROM-BILL-NO           
              PERFORM 3960-CREATE-REBILL-HEADER THRU 3960-EXIT          
           END-IF.                                                      
                                                                        
           MOVE WS-RBF-BILL-NO                TO BG-BILL-NO             
                                                 SHFT-FROM-BILL-NO      
           MOVE WS-RBI-BILL-NO                TO SHFT-TO-BILL-NO        
           MOVE IN-CODE-UTIL-TYPE             TO BG-CODE-UTIL-TYPE      
           MOVE IN-IC-NO                      TO BG-IC-NO               
           PERFORM 7610-OPEN-BILL-COPY-ACT-CRSR THRU 7610-EXIT          
           PERFORM 7620-FETCH-BILL-COPY-ACT-CRSR  THRU 7620-EXIT        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              MOVE WS-DATE-ORIG-BILL-NULL2    TO WS-TEMP-ORIG-BILL-NULL 
              PERFORM 3955-SHIFT-BILL-DETAIL-ALL    THRU 3955-EXIT      
              MOVE WS-RBF-BILL-NO             TO BG-BILL-NO             
              PERFORM 8975-DELETE-BILL-DETAIL       THRU 8975-EXIT      
              PERFORM 7620-FETCH-BILL-COPY-ACT-CRSR THRU 7620-EXIT      
           END-PERFORM.                                                 
           PERFORM 7630-CLOSE-BILL-COPY-ACT-CRSR THRU 7630-EXIT         
                                                                        
           PERFORM 3930-POPULATE-ORIG-DET        THRU 3930-EXIT         
                                                                        
           IF BILL-WHEN-IMMIDIATE                                       
              IF PARM-EXEMPT-FL  = 'Y' AND AT-CODE-ACCT-STAT = 'A'      
                 PERFORM 3970-PROCESS-EXEMPTS      THRU 3970-EXIT       
              END-IF                                                    
              IF AT-CODE-ACCT-STAT NOT = 'A'                            
                 AND AT-ACCT-FINALED-DT NOT EQUAL SPACES                
                 MOVE 'B'                  TO BI-CODE-BILL-TYPE         
                 MOVE WS-RB-BILL-NO        TO BI-BILL-NO                
                 PERFORM 8960-UPDATE-BILL-HDR-TYPE THRU 8960-EXIT       
              END-IF                                                    
           END-IF.                                                      
                                                                        
      ***  CHECK MASTER/SUB RELATION.                                           
           MOVE IN-ACCOUNT-NO          TO UR-ACCOUNT-NO-MST             
                                          UR-ACCOUNT-NO-DEP             
           MOVE IN-CODE-UTIL-TYPE      TO UR-CODE-UTIL-TYPE-MST         
                                          UR-CODE-UTIL-TYPE-DEP         
                                                                        
           PERFORM 7940-MASTER-DEPEND-REL THRU 7940-EXIT                
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              MOVE 'CR00000024'        TO RS-BUS-RULE-ID                
           END-IF.                                                      
      ***  INFO MESSAGE TO INCLUDE UNMTR SERV IN CAN/REBILL                     
           IF IN-CODE-UTIL-TYPE NOT = 'U' AND BILL-WHEN-IMMIDIATE       
              PERFORM 8985-GET-ANNIV-DATE    THRU 8985-EXIT             
              IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL               
                 MOVE 'N'                     TO WS-UMMETER-SERVICE     
                 PERFORM 8990-CHECK-UMMETER           THRU 8990-EXIT    
                 IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL            
                    MOVE WS-REVENUE-MONTH     TO WS-WORK-REV-MTH        
                    MOVE WS-WORK-REV-MTH(1:4) TO WS-BILLED-REV-YR       
                    MOVE WS-WORK-REV-MTH(5:2) TO WS-BILLED-REV-MN       
                    COMPUTE WS-BILLED-REV-YR = WS-BILLED-REV-YR + 1     
                    IF WS-BILLED-REV-YR = BU-ANNIVERSARY-DATE(1:4) AND  
                       BU-ANNIVERSARY-DATE(6:2) = WS-BILLED-REV-MN      
                       MOVE 'CR00000021'      TO RS-BUS-RULE-ID         
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       3700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       3800-MOVE-TO-FUTURE.                                             
      *================================================================*        
                                                                        
           IF IN-BILL-NO =  WS-RBI-BILL-NO                              
              AND IN-BILL-NO > 0                                        
              MOVE WS-RBI-BILL-NO             TO SHFT-FROM-BILL-NO      
                                                 BG-BILL-NO             
           ELSE                                                         
              MOVE 'CR00009999'               TO RS-BUS-RULE-ID         
              PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT           
           END-IF.                                                      
           IF WS-RBF-BILL-NO > 0                                        
              CONTINUE                                                  
              MOVE WS-RBF-BILL-NO             TO SHFT-TO-BILL-NO        
                                                 WS-RB-BILL-NO          
           ELSE                                                         
              MOVE 'CR00009999'               TO RS-BUS-RULE-ID         
              PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT           
           END-IF.                                                      
                                                                        
                                                                        
           MOVE IN-CODE-UTIL-TYPE             TO BG-CODE-UTIL-TYPE      
           MOVE IN-IC-NO                      TO BG-IC-NO               
           PERFORM 7610-OPEN-BILL-COPY-ACT-CRSR THRU 7610-EXIT          
           PERFORM 7620-FETCH-BILL-COPY-ACT-CRSR  THRU 7620-EXIT        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              MOVE WS-DATE-ORIG-BILL-NULL2    TO WS-TEMP-ORIG-BILL-NULL 
              PERFORM 3955-SHIFT-BILL-DETAIL-ALL    THRU 3955-EXIT      
              MOVE WS-RBI-BILL-NO             TO BG-BILL-NO             
              PERFORM 8975-DELETE-BILL-DETAIL       THRU 8975-EXIT      
              PERFORM 7620-FETCH-BILL-COPY-ACT-CRSR THRU 7620-EXIT      
           END-PERFORM.                                                 
           PERFORM 7630-CLOSE-BILL-COPY-ACT-CRSR THRU 7630-EXIT         
                                                                        
           MOVE WS-RBI-BILL-NO                TO BG-BILL-NO             
           PERFORM 3920-CHECK-IMMI-BILLS      THRU 3920-EXIT            
                                                                        
           PERFORM 3930-POPULATE-ORIG-DET        THRU 3930-EXIT         
                                                                        
                                                                        
      ***  CHECK MASTER/SUB RELATION.                                           
           MOVE IN-ACCOUNT-NO          TO UR-ACCOUNT-NO-MST             
                                          UR-ACCOUNT-NO-DEP             
           MOVE IN-CODE-UTIL-TYPE      TO UR-CODE-UTIL-TYPE-MST         
                                          UR-CODE-UTIL-TYPE-DEP         
                                                                        
           PERFORM 7940-MASTER-DEPEND-REL THRU 7940-EXIT                
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              MOVE 'CR00000024'        TO RS-BUS-RULE-ID                
           END-IF.                                                      
                                                                        
       3800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       3900-DELETE-BILL.                                                
      *================================================================*        
                                                                        
           MOVE IN-ACCOUNT-NO                 TO BG-ACCOUNT-NO          
           MOVE IN-BILL-NO                    TO BG-BILL-NO             
                                                 WS-ORIG-BILL-NO        
           MOVE IN-CODE-UTIL-TYPE             TO BG-CODE-UTIL-TYPE      
           MOVE IN-IC-NO                      TO BG-IC-NO               
           MOVE IN-BILL-ITEM-TIMESTMP         TO BG-BILL-ITEM-TIMESTMP  
                                                 WS-ORIG-ITEM-TIMESTMP  
                                                 WS-BILL-ITEM-TIMESTMP  
           IF IN-BILL-NO = (WS-RBI-BILL-NO OR WS-RBF-BILL-NO)           
              AND IN-BILL-NO > 0                                        
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CR00009999'            TO RS-BUS-RULE-ID            
              PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT           
           END-IF.                                                      
           EVALUATE TRUE                                                
              WHEN BILL-WHEN-IMMIDIATE                                  
                   AND IN-BILL-NO = WS-RBI-BILL-NO                      
                   CONTINUE                                             
              WHEN BILL-WHEN-FUTURE                                     
                   AND IN-BILL-NO = WS-RBF-BILL-NO                      
                   CONTINUE                                             
              WHEN OTHER                                                
                 MOVE 'CR00009999'            TO RS-BUS-RULE-ID         
                 PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT        
           END-EVALUATE                                                 
                                                                        
           IF PARM-DELETE-ALL-REBILLS = 'Y'                             
              PERFORM 7821-OPEN-ALL-REBILLS THRU  7821-EXIT             
              PERFORM 7822-FETCH-ALL-REBILLS THRU 7822-EXIT             
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
                 PERFORM 3910-DELETE-EACH-RBILL THRU 3910-EXIT          
                 PERFORM 7822-FETCH-ALL-REBILLS THRU 7822-EXIT          
              END-PERFORM                                               
              PERFORM 7823-CLOSE-ALL-REBILLS THRU 7823-EXIT             
           END-IF.                                                      
                                                                        
           MOVE IN-BILL-ITEM-TIMESTMP         TO BG-BILL-ITEM-TIMESTMP  
           PERFORM 7824-SELECT-REBILL-DELETE  THRU  7824-EXIT           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 3910-DELETE-EACH-RBILL THRU 3910-EXIT             
           END-IF                                                       
                                                                        
           IF IN-BILL-NO = WS-RBI-BILL-NO                               
              PERFORM 3920-CHECK-IMMI-BILLS   THRU 3920-EXIT            
           END-IF.                                                      
                                                                        
       3900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       3910-DELETE-EACH-RBILL.                                          
      *================================================================*        
                                                                        
           IF IN-BILL-NO = WS-RBF-BILL-NO                               
              MOVE ZEROS                TO WS-ROW-COUNT                 
              PERFORM 7828-VERIFY-BILL-DET   THRU 7828-EXIT             
              IF WS-ROW-COUNT <= 1                                      
                 MOVE 'CR00000010'      TO RS-BUS-RULE-ID               
                 PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE WS-BILL-ITEM-TIMESTMP      TO BG-BILL-ITEM-TIMESTMP     
           PERFORM 8975-DELETE-BILL-DETAIL THRU 8975-EXIT.              
           IF WS-CODE-BILL-CALC = 'S'                                   
              AND WS-CODE-BILL-ITM-TYPE = 'B'                           
              AND WS-CODE-BILL-ITM-IND  = 'A'                           
              PERFORM 8781-UNCANCEL-ORIG-BG   THRU 8781-EXIT            
           END-IF.                                                      
                                                                        
       3910-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       3920-CHECK-IMMI-BILLS.                                           
      *================================================================*        
                                                                        
           MOVE -1                      TO WS-ROW-COUNT                 
           PERFORM 7828-VERIFY-BILL-DET THRU 7828-EXIT.                 
           IF WS-ROW-COUNT = ZERO                                       
              MOVE BG-ACCOUNT-NO              TO BI-ACCOUNT-NO          
              MOVE BG-BILL-NO                 TO BI-BILL-NO             
              PERFORM 8775-DELETE-BILL-HEADER  THRU 8775-EXIT           
              PERFORM 8778-DELETE-OFF-CYCLE    THRU 8778-EXIT           
              IF WS-RBF-BILL-NO > ZERO                                  
                 AND WS-RBF-BILL-NO > WS-RBI-BILL-NO                    
                 MOVE WS-RBF-BILL-NO        TO SHFT-FROM-BILL-NO        
                 MOVE WS-RBI-BILL-NO        TO SHFT-TO-BILL-NO          
                 MOVE SHFT-TO-BILL-NO       TO WS-RBF-BILL-NO           
                 PERFORM 3950-SHIFT-BILL-NO THRU 3950-EXIT              
                 MOVE SHFT-TO-BILL-NO       TO WS-RBF-BILL-NO           
                 MOVE ZERO                  TO WS-RBI-BILL-NO           
              END-IF                                                    
           END-IF.                                                      
                                                                        
       3920-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       3930-POPULATE-ORIG-DET.                                          
      *================================================================*        
                                                                        
           MOVE WS-ORIG-IC-NO                 TO BG-IC-NO               
A05460     MOVE WS-CODE-UTIL-TYPE             TO BG-CODE-UTIL-TYPE      
           MOVE WS-DATE-ORIG-BILL             TO BG-DATE-ORIG-BILL      
           MOVE WS-BG-AMT-BILL-ITEM           TO BG-AMT-BILL-ITEM       
           MOVE WS-CODE-BILL-CALC             TO BG-CODE-BILL-CALC      
           MOVE WS-CODE-BILL-ITM-TYPE         TO BG-CODE-BILL-ITM-TYPE  
           MOVE WS-CODE-BILL-ITM-IND          TO BG-CODE-BILL-ITM-IND   
           MOVE WS-CODE-DR-CR-CNSMPTN         TO BG-CODE-DR-CR-CNSMPTN  
           MOVE WS-AMT-STATE-TAX              TO BG-AMT-STATE-TAX       
           MOVE WS-AMT-CITY-TAX               TO BG-AMT-CITY-TAX        
           MOVE WS-AMT-OTHER-TAX              TO BG-AMT-OTHER-TAX       
           MOVE WS-CODE-REVENUE-CLASS         TO BG-CODE-REVENUE-CLASS  
           MOVE WS-CODE-SIC-NO                TO BG-CODE-SIC-NO         
           MOVE WS-RATE-PLAN-NO               TO BG-RATE-PLAN-NO        
           MOVE WS-CODE-CURTAIL-PRTY          TO BG-CODE-CURTAIL-PRTY   
           MOVE WS-CODE-STAT-TAX-XMT          TO BG-CODE-STAT-TAX-XMT   
           MOVE WS-CODE-CITY-TAX-XMT          TO BG-CODE-CITY-TAX-XMT   
           MOVE WS-CODE-OTHR-TAX-XMT          TO BG-CODE-OTHR-TAX-XMT   
           MOVE WS-REV-RPT-CD                 TO BG-REV-RPT-CD          
           MOVE WS-STANDBY-COMPLIED           TO BG-STANDBY-COMPLIED    
           MOVE WS-PRORATE-CD                 TO BG-PRORATE-CD          
           MOVE WS-NEW-RATE-PCT               TO BG-NEW-RATE-PCT        
           MOVE WS-CODE-SUB-TOTAL             TO BG-CODE-SUB-TOTAL      
           MOVE WS-TAX-REFUND-CD              TO BG-TAX-REFUND-CD       
           MOVE WS-DATE-LFTM-HI-DMD           TO BG-DATE-LFTM-HI-DMD    
           MOVE WS-LFTM-HI-PEAK-DMD           TO BG-LFTM-HI-PEAK-DMD    
           MOVE WS-REBILL-IND                 TO BG-REBILL-IND          
           MOVE WS-ADJ-REASON-CD              TO BG-ADJ-REASON-CD       
           MOVE WS-REVENUE-MONTH              TO BG-REVENUE-MONTH       
           MOVE WS-GAS-BASE-USE               TO BG-GAS-BASE-USE        
           MOVE WS-WNA-FACTOR                 TO BG-WNA-FACTOR          
           MOVE WS-BTU-FACTOR                 TO BG-BTU-FACTOR          
           MOVE WS-NO-OF-CONS-DAYS            TO BG-NO-OF-CONS-DAYS     
           MOVE WS-REV-MTH-ORIG-BILL          TO BG-REV-MTH-ORIG-BILL   
           MOVE WS-REV-DISTRICT-CD            TO BG-REV-DISTRICT-CD     
           MOVE WS-FUEL-SHIPPER-CD            TO BG-FUEL-SHIPPER-CD     
           MOVE WS-ALTERNATE-FUEL-CD          TO BG-ALTERNATE-FUEL-CD   
           MOVE WS-TRNSP-OVER-MDQ-FL          TO BG-TRNSP-OVER-MDQ-FL   
           MOVE WS-CITY-TAX-RATE              TO BG-CITY-TAX-RATE       
           MOVE WS-OTHER-TAX-RATE             TO BG-OTHER-TAX-RATE      
           MOVE WS-STATE-TAX-RATE             TO BG-STATE-TAX-RATE      
           MOVE WS-BILL-CALC-CYCLE            TO BG-BILL-CALC-CYCLE     
           MOVE WS-NAICS-CD                   TO BG-NAICS-CD            
           MOVE WS-RT-PKG-OPT-SEQ-NO          TO BG-RT-PKG-OPT-SEQ-NO.  
                                                                        
       3930-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       3950-SHIFT-BILL-NO.                                              
      *================================================================*        
      *----------------------------------------------------------------*        
      *      THIS MODULE IS USED TO 'SHIFT' AN EXISTING BILL HOOK      *        
      *      UP 1 BILL_NO IN ORDER THAT A REBILL HOOK CAN BE INSERTED  *        
      *      AND THE PROPER ORDER OF BILL HOOKS IS MAINTAINED.         *        
      *                                                                *        
      *----------------------------------------------------------------*        
           MOVE SHFT-TO-BILL-NO               TO AT-NXT-BILL-NO         
           MOVE WS-CURRENT-TIMESTMP           TO AT-LAST-UPDATE-TS      
           PERFORM 8999-UPDATE-ACCOUNT        THRU 8999-EXIT            
                                                                        
           MOVE SPACES                        TO BI-DATE-BILLED         
           MOVE IN-ACCOUNT-NO                 TO BI-ACCOUNT-NO          
           MOVE SHFT-FROM-BILL-NO             TO BI-BILL-NO             
           PERFORM 7052-SELECT-BILL-HEADER    THRU 7052-EXIT            
                                                                        
           MOVE SHFT-TO-BILL-NO               TO BI-BILL-NO             
           MOVE WS-CURRENT-TIMESTMP           TO BI-LAST-UPDATE-TS      
           PERFORM 8770-INSERT-BILL-HEADER    THRU 8770-EXIT            
                                                                        
           MOVE BI-ACCOUNT-NO                 TO BG-ACCOUNT-NO          
           MOVE SHFT-FROM-BILL-NO             TO BG-BILL-NO.            
           PERFORM 7772-OPEN-BILL-DET-SHFT-CRSR THRU 7772-EXIT          
           PERFORM 7773-FETCH-BILL-DET-SHFT-CRSR  THRU 7773-EXIT        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              MOVE WS-DATE-ORIG-BILL-NULL3    TO WS-TEMP-ORIG-BILL-NULL 
              PERFORM 3955-SHIFT-BILL-DETAIL-ALL     THRU 3955-EXIT     
              PERFORM 7773-FETCH-BILL-DET-SHFT-CRSR  THRU 7773-EXIT     
           END-PERFORM.                                                 
           PERFORM 7774-CLOSE-BILL-DET-SHFT-CRSR THRU 7774-EXIT         
                                                                        
           MOVE SHFT-FROM-BILL-NO             TO BI-BILL-NO             
           PERFORM 8775-DELETE-BILL-HEADER    THRU 8775-EXIT.           
                                                                        
       3950-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       3955-SHIFT-BILL-DETAIL-ALL.                                      
      *================================================================*        
                                                                        
           MOVE SHFT-TO-BILL-NO            TO BG-BILL-NO                
           MOVE WS-TEMP-ORIG-BILL-NULL     TO WS-DATE-ORIG-BILL-NULL1   
           PERFORM 8771-INSERT-BILL-DETAIL THRU 8771-EXIT               
      ***  IF HAS-CUST-PLAN                                                     
      ***  SHIFT UN MTR HIST IF EXISTS                                          
           MOVE BG-ACCOUNT-NO                 TO UC-ACCOUNT-NO          
           MOVE SHFT-FROM-BILL-NO             TO UC-BILL-NO             
           MOVE BG-CODE-UTIL-TYPE             TO UC-CODE-UTIL-TYPE      
           MOVE BG-IC-NO                      TO UC-IC-NO               
           MOVE BG-BILL-ITEM-TIMESTMP         TO UC-BILL-ITEM-TIMESTMP  
           PERFORM 7780-OPEN-UC-SHFT-CRSR     THRU 7780-EXIT            
           PERFORM 7781-FETCH-UC-SHFT-CRSR    THRU 7781-EXIT            
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
              MOVE SHFT-TO-BILL-NO            TO UC-BILL-NO             
              PERFORM 8772-INSERT-UC          THRU 8772-EXIT            
              PERFORM 7781-FETCH-UC-SHFT-CRSR THRU 7781-EXIT            
           END-PERFORM.                                                 
           PERFORM 7782-CLOSE-UC-SHFT-CRSR    THRU 7782-EXIT            
      ***  END-IF.                                                              
      ***  SHIFT CX IF EXISTS                                                   
           MOVE BG-ACCOUNT-NO                 TO CX-ACCOUNT-NO          
           MOVE SHFT-FROM-BILL-NO             TO CX-BILL-NO             
           MOVE BG-CODE-UTIL-TYPE             TO CX-CODE-UTIL-TYPE      
           MOVE BG-IC-NO                      TO CX-IC-NO               
           MOVE BG-BILL-ITEM-TIMESTMP         TO CX-BILL-ITEM-TIMESTMP  
           PERFORM 7777-OPEN-CX-SHFT-CRSR     THRU 7777-EXIT            
           PERFORM 7778-FETCH-CX-SHFT-CRSR    THRU 7778-EXIT            
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              IF CX-CODE-USAGE-SOURCE = 'K' OR 'J'                      
                 CONTINUE                                               
      ***------- DO NOT COPY CONSUMPTION FROM AN ADDITIVE                       
      ***------- OR SUBTRACTIVE METER.  THESE WILL BE                           
      ***------- REGENERATED IN SCSCA104.                                       
              ELSE                                                      
                 MOVE SHFT-TO-BILL-NO         TO CX-BILL-NO             
                 PERFORM 8773-INSERT-CX       THRU 8773-EXIT            
              END-IF                                                    
              PERFORM 7778-FETCH-CX-SHFT-CRSR THRU 7778-EXIT            
           END-PERFORM.                                                 
           PERFORM 7779-CLOSE-CX-SHFT-CRSR    THRU 7779-EXIT            
                                                                        
           MOVE BG-ACCOUNT-NO       TO FH-ACCOUNT-NO                    
           MOVE SHFT-FROM-BILL-NO   TO FH-BILL-NO                       
           MOVE BG-CODE-UTIL-TYPE   TO FH-CODE-UTIL-TYPE                
           MOVE BG-IC-NO            TO FH-IC-NO                         
           MOVE BG-BILL-ITEM-TIMESTMP TO FH-BILL-ITEM-TIMESTMP          
           PERFORM 7490-OPEN-FH-MAINT-CRSR    THRU 7490-EXIT            
           PERFORM 7495-FETCH-FH-MAINT-CRSR   THRU 7495-EXIT            
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              MOVE SHFT-TO-BILL-NO            TO FH-BILL-NO             
              PERFORM 8774-INSERT-FH          THRU 8774-EXIT            
              PERFORM 7495-FETCH-FH-MAINT-CRSR THRU 7495-EXIT           
           END-PERFORM.                                                 
           PERFORM 7500-CLOSE-FH-CRSR         THRU 7500-EXIT.           
                                                                        
           MOVE BG-ACCOUNT-NO                 TO GA-ACCOUNT-NO          
           MOVE SHFT-FROM-BILL-NO             TO GA-BILL-NO             
           MOVE BG-CODE-UTIL-TYPE             TO GA-CODE-UTIL-TYPE      
           MOVE BG-IC-NO                      TO GA-IC-NO               
           MOVE BG-BILL-ITEM-TIMESTMP         TO GA-BILL-ITEM-TIMESTMP  
           PERFORM 7800-OPEN-MTR-CRSR         THRU 7800-EXIT            
           PERFORM 7805-FETCH-MTR-CRSR        THRU 7805-EXIT            
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              MOVE SHFT-TO-BILL-NO            TO GA-BILL-NO             
              MOVE BG-BILL-ITEM-TIMESTMP      TO GA-BILL-ITEM-TIMESTMP  
              PERFORM 7815-INSERT-MTR         THRU 7815-EXIT            
              PERFORM 7805-FETCH-MTR-CRSR     THRU 7805-EXIT            
           END-PERFORM.                                                 
           PERFORM 7810-CLOSE-MTR-CRSR        THRU 7810-EXIT            
                                                                        
           MOVE BG-ACCOUNT-NO                 TO BP-ACCOUNT-NO          
           MOVE SHFT-FROM-BILL-NO             TO BP-BILL-NO             
           MOVE BG-CODE-UTIL-TYPE             TO BP-CODE-UTIL-TYPE      
           MOVE BG-IC-NO                      TO BP-IC-NO               
           MOVE BG-BILL-ITEM-TIMESTMP         TO BP-BILL-ITEM-TIMESTMP  
           PERFORM 7210-OPEN-BILLADJ-CRSR     THRU 7210-EXIT            
           PERFORM 7220-FETCH-BILLADJ-CRSR    THRU 7220-EXIT            
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE      = NOT-FOUND         
              MOVE SHFT-TO-BILL-NO       TO BP-BILL-NO                  
              PERFORM 7230-INSERT-BILLADJ     THRU 7230-EXIT            
              PERFORM 7220-FETCH-BILLADJ-CRSR THRU 7220-EXIT            
           END-PERFORM.                                                 
           PERFORM 7240-CLOSE-BILLADJ-CRSR    THRU 7240-EXIT.           
                                                                        
           MOVE BG-ACCOUNT-NO         TO NG-ACCOUNT-NO                  
                                         NU-ACCOUNT-NO.                 
           MOVE SHFT-FROM-BILL-NO     TO NG-BILL-NO                     
                                         NU-BILL-NO.                    
           MOVE BG-CODE-UTIL-TYPE     TO NG-CODE-UTIL-TYPE              
                                         NU-CODE-UTIL-TYPE.             
           MOVE BG-IC-NO              TO NG-IC-NO                       
                                         NU-IC-NO.                      
           MOVE BG-BILL-ITEM-TIMESTMP TO NG-BILL-ITEM-TIMESTMP          
                                         NU-BILL-ITEM-TIMESTMP.         
           PERFORM 7970-GET-BILL-MANUAL THRU 7970-EXIT.                 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE SHFT-TO-BILL-NO            TO NG-BILL-NO             
              PERFORM 8030-INSERT-BILLMAN     THRU 8030-EXIT            
              PERFORM 7975-OPEN-BILLMAN-CRSR  THRU 7975-EXIT            
              PERFORM 7980-FETCH-BILLMAN-CRSR THRU 7980-EXIT            
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
                 MOVE SHFT-TO-BILL-NO         TO NU-BILL-NO             
                 PERFORM 8040-INSERT-MANDET   THRU 8040-EXIT            
                 PERFORM 7980-FETCH-BILLMAN-CRSR THRU 7980-EXIT         
              END-PERFORM                                               
              PERFORM 7985-CLOSE-BILLMAN-CRSR THRU 7985-EXIT            
           END-IF.                                                      
                                                                        
       3955-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       3960-CREATE-REBILL-HEADER.                                       
      *================================================================*        
                                                                        
           MOVE SPACES                        TO BI-DATE-BILLED         
           MOVE SHFT-FROM-BILL-NO             TO BI-BILL-NO             
           PERFORM 7410-SELECT-BILL-HEADER  THRU 7410-EXIT              
           MOVE WS-RB-BILL-NO                 TO BI-BILL-NO             
           MOVE WS-A                          TO BI-CODE-BILL-TYPE      
           MOVE WS-C                          TO BI-CODE-BILL-STATUS    
           MOVE WS-A                          TO BI-CODE-BILL-REASON    
           MOVE SPACE                         TO BI-CODE-SPCL-BILL      
           MOVE SPACES                        TO BI-DATE-BILLED         
           MOVE -1                            TO WS-DATE-BILLED-NULL    
           MOVE ZEROS                         TO BI-TOT-OTHER-CHARGES   
                                                 BI-TOTAL-ARREARS       
           MOVE AT-COMPANY-NO                 TO BI-COMPANY-NO          
           MOVE WS-CURRENT-TIMESTMP           TO BI-LAST-UPDATE-TS      
           IF PARM-BILL-CORRECTED-CD > SPACE                            
              MOVE PARM-BILL-CORRECTED-CD     TO BI-BILL-CORRECTED-CD   
           ELSE                                                         
              MOVE 'O'                        TO BI-BILL-CORRECTED-CD   
           END-IF.                                                      
           PERFORM 8770-INSERT-BILL-HEADER    THRU 8770-EXIT.           
                                                                        
       3960-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       3970-PROCESS-EXEMPTS.                                            
      *================================================================*        
                                                                        
           MOVE SPACES                        TO WS-XMT-CODES           
                                                 WS-XMT-SWITCHES        
           IF AT-CODE-DISC-OK  = ' ' OR LOW-VALUES OR '0' OR '1'        
              SET DISC-OK-CHANGED             TO TRUE                   
              MOVE AT-CODE-DISC-OK            TO WS-CODE-DISC-OK        
              MOVE '2'                        TO AT-CODE-DISC-OK        
              IF AT-CODES-DATA-PRESENT(26:1)  = 'A'                     
                 AND AT-CODE-DISC-OK > SPACES                           
                 PERFORM 7010-SELECT-CUR-TIMESTAMP THRU 7010-EXIT       
                 MOVE AT-ACCOUNT-NO           TO YP-ACCOUNT-NO          
                 MOVE 'AUTODPPDRPEXEMPIND'    TO YP-ATTRIBUTE-DESC      
                 MOVE AT-CODE-DISC-OK         TO YP-ATTRIBUTE-VALUE-CD  
                 MOVE WS-CURRENT-DATE         TO YP-ATTRIBUTE-VALUE-DT  
                 MOVE WS-CURRENT-TIMESTMP     TO YP-CREATED-TS          
                 MOVE SPACES              TO YP-ATTRIBUTE-VALUE-TX-TEXT 
                 MOVE ZERO                TO YP-ATTRIBUTE-VALUE-TX-LEN  
                 MOVE 'A'                     TO YP-STATUS-CD           
                 PERFORM 8600-INSERT-ACCT-ATTRIBUTE THRU 8600-EXIT      
                 IF WS-ACTIVE-RETURN-CODE EQUAL -803                    
                    PERFORM 7790-SELECT-ATTR-CD     THRU 7790-EXIT      
                    IF YP-ATTRIBUTE-VALUE-CD < AT-CODE-DISC-OK          
                       PERFORM 8650-UPDATE-ACCT-ATTRIBUTE THRU 8650-EXIT
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
      *** DISCONNECT CODE                                                       
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES               TO WS-TABLE-ID (TH-SUB)         
              MOVE 'DISCONNECT CODE'          TO WS-COLUMN-DESC         
                                                 (TH-SUB)               
              IF WS-CODE-DISC-OK > SPACE                                
                 MOVE WS-CODE-DISC-OK   TO WS-MSG-MONTHS                
                 MOVE WS-MSG-LITERAL    TO WS-PRV-COLUMN-VALUE-TXT      
                                                 (TH-SUB)               
                 MOVE WS-MSG-LITERAL-LEN TO WS-PRV-COLUMN-VALUE-LEN     
                                                 (TH-SUB)               
              ELSE                                                      
                 MOVE SPACE             TO WS-PRV-COLUMN-VALUE-TXT      
                                                 (TH-SUB)               
                 MOVE ZEROS              TO WS-PRV-COLUMN-VALUE-LEN     
                                                 (TH-SUB)               
              END-IF                                                    
              MOVE '2'                  TO WS-MSG-MONTHS                
              MOVE WS-MSG-LITERAL       TO WS-CHG-COLUMN-VALUE-TXT      
                                                 (TH-SUB)               
              MOVE WS-MSG-LITERAL-LEN   TO WS-CHG-COLUMN-VALUE-LEN      
                                                 (TH-SUB)               
           END-IF.                                                      
           IF AT-NOTICE-EXEMPT-CD = ' ' OR LOW-VALUES OR '0' OR '1'     
              SET EXEMPT-CD-CHANGED           TO TRUE                   
              MOVE AT-NOTICE-EXEMPT-CD        TO WS-NOTICE-EXEMPT-CD    
              MOVE '2'                        TO AT-NOTICE-EXEMPT-CD    
      *** NOTICE XMT CODE                                                       
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES               TO WS-TABLE-ID (TH-SUB)         
              MOVE 'NOTICE XMT CODE'          TO WS-COLUMN-DESC         
                                                 (TH-SUB)               
              IF WS-NOTICE-EXEMPT-CD > SPACES                           
                 MOVE WS-NOTICE-EXEMPT-CD  TO WS-MSG-MONTHS             
                 MOVE WS-MSG-LITERAL    TO WS-PRV-COLUMN-VALUE-TXT      
                                                 (TH-SUB)               
                 MOVE WS-MSG-LITERAL-LEN TO WS-PRV-COLUMN-VALUE-LEN     
                                                 (TH-SUB)               
              ELSE                                                      
                 MOVE SPACE             TO WS-PRV-COLUMN-VALUE-TXT      
                                                 (TH-SUB)               
                 MOVE ZEROS              TO WS-PRV-COLUMN-VALUE-LEN     
                                                 (TH-SUB)               
              END-IF                                                    
              MOVE '2'                  TO WS-MSG-MONTHS                
              MOVE WS-MSG-LITERAL       TO WS-CHG-COLUMN-VALUE-TXT      
                                                 (TH-SUB)               
              MOVE WS-MSG-LITERAL-LEN   TO WS-CHG-COLUMN-VALUE-LEN      
                                                 (TH-SUB)               
           END-IF.                                                      
           IF AT-CODE-LPC-XMT = ' ' OR LOW-VALUES OR '0' OR '1'         
              SET LPC-XMT-CHANGED             TO TRUE                   
              MOVE AT-CODE-LPC-XMT            TO WS-CODE-LPC-XMT        
              MOVE '2'                        TO AT-CODE-LPC-XMT        
      *** LPC EXEMPT CODE                                                       
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES               TO WS-TABLE-ID (TH-SUB)         
              MOVE 'LPC EXEMPT CODE'          TO WS-COLUMN-DESC         
                                                 (TH-SUB)               
              IF WS-CODE-LPC-XMT     > SPACES                           
                 MOVE WS-CODE-LPC-XMT   TO WS-MSG-MONTHS                
                 MOVE WS-MSG-LITERAL    TO WS-PRV-COLUMN-VALUE-TXT      
                                                 (TH-SUB)               
                 MOVE WS-MSG-LITERAL-LEN TO WS-PRV-COLUMN-VALUE-LEN     
                                                 (TH-SUB)               
              ELSE                                                      
                 MOVE SPACE             TO WS-PRV-COLUMN-VALUE-TXT      
                                                 (TH-SUB)               
                 MOVE ZEROS              TO WS-PRV-COLUMN-VALUE-LEN     
                                                 (TH-SUB)               
              END-IF                                                    
              MOVE '2'                  TO WS-MSG-MONTHS                
              MOVE WS-MSG-LITERAL       TO WS-CHG-COLUMN-VALUE-TXT      
                                                 (TH-SUB)               
              MOVE WS-MSG-LITERAL-LEN   TO WS-CHG-COLUMN-VALUE-LEN      
                                                 (TH-SUB)               
           END-IF.                                                      
           IF AT-IVR-EXEMPT-CD = ' ' OR LOW-VALUES OR '0' OR '1'        
              SET IVR-EXEMPT-CHANGED          TO TRUE                   
              MOVE AT-IVR-EXEMPT-CD           TO WS-IVR-EXEMPT-CD       
              MOVE '2'                        TO AT-IVR-EXEMPT-CD       
      *** IVR EXEMPT CODE                                                       
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES               TO WS-TABLE-ID (TH-SUB)         
              MOVE 'IVR EXEMPT CODE'          TO WS-COLUMN-DESC         
                                                 (TH-SUB)               
              IF WS-IVR-EXEMPT-CD    > SPACES                           
                 MOVE WS-IVR-EXEMPT-CD  TO WS-MSG-MONTHS                
                 MOVE WS-MSG-LITERAL    TO WS-PRV-COLUMN-VALUE-TXT      
                                                 (TH-SUB)               
                 MOVE WS-MSG-LITERAL-LEN TO WS-PRV-COLUMN-VALUE-LEN     
                                                 (TH-SUB)               
              ELSE                                                      
                 MOVE SPACE             TO WS-PRV-COLUMN-VALUE-TXT      
                                                 (TH-SUB)               
                 MOVE ZEROS              TO WS-PRV-COLUMN-VALUE-LEN     
                                                 (TH-SUB)               
              END-IF                                                    
              MOVE '2'                  TO WS-MSG-MONTHS                
              MOVE WS-MSG-LITERAL       TO WS-CHG-COLUMN-VALUE-TXT      
                                                 (TH-SUB)               
              MOVE WS-MSG-LITERAL-LEN   TO WS-CHG-COLUMN-VALUE-LEN      
                                                 (TH-SUB)               
           END-IF.                                                      
                                                                        
           PERFORM 8961-SET-EXEMPT THRU 8961-EXIT.                      
                                                                        
                                                                        
       3970-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *================================================================*        
       3980-BACKOUT-HIST.                                               
      *================================================================*        
                                                                        
A05744     IF UN-METERED-IC OR NO-UN-CX-CHANGED                         
              MOVE IN-ACCOUNT-NO              TO UC-ACCOUNT-NO          
              MOVE WS-ORIG-BILL-NO            TO UC-BILL-NO             
              MOVE IN-CODE-UTIL-TYPE          TO UC-CODE-UTIL-TYPE      
              MOVE IN-IC-NO                   TO UC-IC-NO               
              MOVE WS-ORIG-ITEM-TIMESTMP      TO UC-BILL-ITEM-TIMESTMP  
                                                                        
              PERFORM 7780-OPEN-UC-SHFT-CRSR  THRU 7780-EXIT            
              PERFORM 7781-FETCH-UC-SHFT-CRSR THRU 7781-EXIT            
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
                 MOVE 'N'                     TO WS-ADD-FLAG            
                 MOVE WS-RB-BILL-NO           TO UC-BILL-NO             
                 PERFORM 8772-INSERT-UC       THRU 8772-EXIT            
                 PERFORM 7781-FETCH-UC-SHFT-CRSR THRU 7781-EXIT         
              END-PERFORM                                               
              PERFORM 7782-CLOSE-UC-SHFT-CRSR THRU 7782-EXIT            
           END-IF.                                                      
                                                                        
           MOVE IN-ACCOUNT-NO                 TO CX-ACCOUNT-NO          
           MOVE WS-ORIG-BILL-NO               TO CX-BILL-NO             
           MOVE IN-CODE-UTIL-TYPE             TO CX-CODE-UTIL-TYPE      
           MOVE IN-IC-NO                      TO CX-IC-NO               
           MOVE WS-ORIG-ITEM-TIMESTMP         TO CX-BILL-ITEM-TIMESTMP  
                                                                        
           PERFORM 7777-OPEN-CX-SHFT-CRSR     THRU 7777-EXIT            
           PERFORM 7778-FETCH-CX-SHFT-CRSR    THRU 7778-EXIT            
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              MOVE 'N'                        TO WS-ADD-FLAG            
              MOVE WS-RB-BILL-NO              TO CX-BILL-NO             
              PERFORM 8773-INSERT-CX          THRU 8773-EXIT            
              PERFORM 7778-FETCH-CX-SHFT-CRSR THRU 7778-EXIT            
           END-PERFORM.                                                 
           PERFORM 7779-CLOSE-CX-SHFT-CRSR    THRU 7779-EXIT            
                                                                        
           MOVE IN-ACCOUNT-NO                 TO FH-ACCOUNT-NO          
           MOVE WS-ORIG-BILL-NO               TO FH-BILL-NO             
           MOVE IN-CODE-UTIL-TYPE             TO FH-CODE-UTIL-TYPE      
           MOVE IN-IC-NO                      TO FH-IC-NO               
           MOVE WS-ORIG-ITEM-TIMESTMP         TO FH-BILL-ITEM-TIMESTMP  
                                                                        
           PERFORM 7490-OPEN-FH-MAINT-CRSR    THRU 7490-EXIT            
           PERFORM 7495-FETCH-FH-MAINT-CRSR   THRU 7495-EXIT            
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              MOVE 'N'                        TO WS-ADD-FLAG            
              MOVE WS-RB-BILL-NO              TO FH-BILL-NO             
              PERFORM 8774-INSERT-FH          THRU 8774-EXIT            
              PERFORM 7495-FETCH-FH-MAINT-CRSR THRU 7495-EXIT           
           END-PERFORM.                                                 
           PERFORM 7500-CLOSE-FH-CRSR         THRU 7500-EXIT.           
                                                                        
           MOVE IN-ACCOUNT-NO                 TO GA-ACCOUNT-NO          
           MOVE WS-ORIG-BILL-NO               TO GA-BILL-NO             
           MOVE IN-CODE-UTIL-TYPE             TO GA-CODE-UTIL-TYPE      
           MOVE IN-IC-NO                      TO GA-IC-NO               
           MOVE WS-ORIG-ITEM-TIMESTMP         TO GA-BILL-ITEM-TIMESTMP  
           PERFORM 7800-OPEN-MTR-CRSR         THRU 7800-EXIT            
           PERFORM 7805-FETCH-MTR-CRSR        THRU 7805-EXIT            
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              MOVE 'N'                        TO WS-ADD-FLAG            
              MOVE WS-RB-BILL-NO              TO GA-BILL-NO             
              PERFORM 7815-INSERT-MTR         THRU 7815-EXIT            
              PERFORM 7805-FETCH-MTR-CRSR     THRU 7805-EXIT            
           END-PERFORM.                                                 
           PERFORM 7810-CLOSE-MTR-CRSR        THRU 7810-EXIT            
                                                                        
           MOVE IN-ACCOUNT-NO              TO BP-ACCOUNT-NO             
           MOVE WS-ORIG-BILL-NO            TO BP-BILL-NO                
           MOVE IN-CODE-UTIL-TYPE          TO BP-CODE-UTIL-TYPE         
           MOVE IN-IC-NO                   TO BP-IC-NO                  
           MOVE WS-ORIG-ITEM-TIMESTMP   TO BP-BILL-ITEM-TIMESTMP.       
           PERFORM 7210-OPEN-BILLADJ-CRSR     THRU 7210-EXIT            
           PERFORM 7220-FETCH-BILLADJ-CRSR    THRU 7220-EXIT            
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE      = NOT-FOUND         
              MOVE WS-RB-BILL-NO         TO BP-BILL-NO                  
              PERFORM 7230-INSERT-BILLADJ     THRU 7230-EXIT            
              PERFORM 7220-FETCH-BILLADJ-CRSR THRU 7220-EXIT            
           END-PERFORM.                                                 
           PERFORM 7240-CLOSE-BILLADJ-CRSR    THRU 7240-EXIT.           
                                                                        
           MOVE IN-ACCOUNT-NO                 TO NG-ACCOUNT-NO          
                                                 NU-ACCOUNT-NO          
           MOVE WS-ORIG-BILL-NO               TO NG-BILL-NO             
                                                 NU-BILL-NO             
           MOVE IN-CODE-UTIL-TYPE             TO NG-CODE-UTIL-TYPE      
                                                 NU-CODE-UTIL-TYPE      
           MOVE IN-IC-NO                      TO NG-IC-NO               
                                                 NU-IC-NO               
           MOVE WS-ORIG-ITEM-TIMESTMP         TO NG-BILL-ITEM-TIMESTMP  
                                                 NU-BILL-ITEM-TIMESTMP  
           PERFORM 7970-GET-BILL-MANUAL THRU 7970-EXIT.                 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-RB-BILL-NO              TO NG-BILL-NO             
              PERFORM 8030-INSERT-BILLMAN     THRU 8030-EXIT            
              PERFORM 7975-OPEN-BILLMAN-CRSR  THRU 7975-EXIT            
              PERFORM 7980-FETCH-BILLMAN-CRSR THRU 7980-EXIT            
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
                 MOVE WS-RB-BILL-NO           TO NU-BILL-NO             
                 PERFORM 8040-INSERT-MANDET   THRU 8040-EXIT            
                 PERFORM 7980-FETCH-BILLMAN-CRSR THRU 7980-EXIT         
              END-PERFORM                                               
              PERFORM 7985-CLOSE-BILLMAN-CRSR THRU 7985-EXIT            
           END-IF.                                                      
                                                                        
           IF WS-CIG-CUSTOMER = 'Y'                                     
              MOVE IN-ACCOUNT-NO              TO ND-ACCOUNT-NO          
              MOVE WS-ORIG-BILL-NO            TO ND-BILL-NO             
              MOVE IN-CODE-UTIL-TYPE          TO ND-CODE-UTIL-TYPE      
              MOVE IN-IC-NO                   TO ND-IC-NO               
              MOVE WS-ORIG-ITEM-TIMESTMP      TO ND-BILL-ITEM-TIMESTMP  
              PERFORM 7820-OPEN-VOL-CRSR      THRU 7820-EXIT            
              PERFORM 7825-FETCH-VOL-CRSR     THRU 7825-EXIT            
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
                 MOVE WS-RB-BILL-NO           TO ND-BILL-NO             
                 PERFORM 7827-INSERT-VOL      THRU 7827-EXIT            
                 PERFORM 7825-FETCH-VOL-CRSR  THRU 7825-EXIT            
              END-PERFORM                                               
              PERFORM 7826-CLOSE-VOL-CRSR     THRU 7826-EXIT            
           END-IF.                                                      
                                                                        
       3980-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *================================================================*        
       4100-PROCESS-CX-RBILL.                                           
      *================================================================*        
                                                                        
           MOVE ZERO        TO MATCH-IDX                                
           PERFORM VARYING IN-CX-IDX FROM 1 BY 1                        
SCA006        UNTIL MATCH-IDX > 0 OR 
                    IN-CX-IDX > 100 OR 
                    IN-CX-CHANGE-INDICATOR (IN-CX-IDX) = SPACES                 
              IF CX-MTR-REF-NO  = IN-CX-MTR-REF-NO     (IN-CX-IDX)      
                 AND CX-REG-ID-NO  = IN-CX-REG-ID-NO (IN-CX-IDX)        
                 AND CX-CODE-TIME-PERIOD =                              
                              IN-CX-CODE-TIME-PERIOD (IN-CX-IDX)        
                 AND CX-ITEM-SEQ-NO  = IN-CX-ITEM-SEQ-NO (IN-CX-IDX)    
                 MOVE IN-CX-IDX                  TO MATCH-IDX           
              END-IF                                                    
           END-PERFORM.                                                 
           IF MATCH-IDX = 0                                             
              MOVE WS-RB-BILL-NO              TO CX-BILL-NO             
              MOVE WS-RB-ITEM-TIMESTMP        TO CX-BILL-ITEM-TIMESTMP  
              PERFORM 4120-COPY-CX-WITH-IDR THRU 4120-EXIT              
           ELSE                                                         
              MOVE WS-RB-BILL-NO              TO CX-BILL-NO             
              MOVE WS-RB-ITEM-TIMESTMP        TO CX-BILL-ITEM-TIMESTMP  
              PERFORM 4110-CX-RBILL-CHANGES THRU 4110-EXIT              
           END-IF.                                                      
                                                                        
           PERFORM 7778-FETCH-CX-SHFT-CRSR THRU 7778-EXIT.              
                                                                        
       4100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *================================================================*        
       4110-CX-RBILL-CHANGES.                                           
      *================================================================*        
                                                                        
           MOVE 'P'               TO IN-CX-PROCESS-CD (MATCH-IDX)       
           EVALUATE TRUE                                                
              WHEN IN-CX-CHANGE-INDICATOR (MATCH-IDX) = 'U'             
                 PERFORM 4112-TH-FOR-CX-UPD    THRU 4112-EXIT           
                 PERFORM 4120-COPY-CX-WITH-IDR THRU 4120-EXIT           
              WHEN IN-CX-CHANGE-INDICATOR (MATCH-IDX) = 'D'             
                 PERFORM 4114-TH-FOR-CX-DEL  THRU 4114-EXIT             
              WHEN OTHER                                                
                 MOVE 'CR00009999'            TO RS-BUS-RULE-ID         
                 PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT        
           END-EVALUATE.                                                
                                                                        
       4110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       4112-TH-FOR-CX-UPD.                                              
      *================================================================*        
                                                                        
           IF IN-CX-NO-UNITS (MATCH-IDX) NOT = CX-NO-UNITS              
              OR IN-CX-CODE-DEBIT-CREDIT (MATCH-IDX)                    
                                         NOT = CX-CODE-DEBIT-CREDIT     
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES         TO WS-TABLE-ID (TH-SUB)               
              MOVE 'NO UNITS'     TO WS-COLUMN-DESC  (TH-SUB)           
              MOVE CX-NO-UNITS    TO WS-EDIT-DEC-ZERO                   
              MOVE WS-EDIT-DEC-ZERO  TO WS-PRV-COLUMN-VALUE-TXT         
                                                   (TH-SUB)             
              MOVE 10     TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)           
              MOVE IN-CX-NO-UNITS (MATCH-IDX)                           
                                  TO WS-EDIT-DEC-ZERO                   
              MOVE WS-EDIT-DEC-ZERO  TO WS-CHG-COLUMN-VALUE-TXT         
                                                   (TH-SUB)             
              MOVE 10     TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)           
              MOVE IN-CX-NO-UNITS (MATCH-IDX) TO CX-NO-UNITS            
              MOVE IN-CX-CODE-DEBIT-CREDIT (MATCH-IDX)                  
                                              TO CX-CODE-DEBIT-CREDIT   
           END-IF                                                       
           IF IN-CX-NO-DEMAND-UNITS (MATCH-IDX)                         
                                       NOT = CX-NO-DEMAND-UNITS         
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES         TO WS-TABLE-ID (TH-SUB)               
              MOVE 'NO DEMAND UNITS'      TO WS-COLUMN-DESC             
                                                   (TH-SUB)             
              MOVE CX-NO-DEMAND-UNITS     TO WS-EDIT-DEC-ZERO           
              MOVE WS-EDIT-DEC-ZERO  TO WS-PRV-COLUMN-VALUE-TXT         
                                                   (TH-SUB)             
              MOVE 10     TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)           
              MOVE IN-CX-NO-DEMAND-UNITS  (MATCH-IDX)                   
                                  TO WS-EDIT-DEC-ZERO                   
              MOVE WS-EDIT-DEC-ZERO  TO WS-CHG-COLUMN-VALUE-TXT         
                                                   (TH-SUB)             
              MOVE 10     TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)           
              MOVE IN-CX-NO-DEMAND-UNITS  (MATCH-IDX)                   
                                     TO CX-NO-DEMAND-UNITS              
           END-IF                                                       
           IF IN-CX-NO-DAYS (MATCH-IDX)   NOT = CX-NO-DAYS              
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES         TO WS-TABLE-ID (TH-SUB)               
              MOVE 'NO DAYS'      TO WS-COLUMN-DESC  (TH-SUB)           
              MOVE CX-NO-DAYS     TO WS-EDIT-DEC-ZERO                   
              MOVE WS-EDIT-DEC-ZERO  TO WS-PRV-COLUMN-VALUE-TXT         
                                                   (TH-SUB)             
              MOVE 10     TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)           
              MOVE IN-CX-NO-DAYS (MATCH-IDX) TO WS-EDIT-DEC-ZERO        
              MOVE WS-EDIT-DEC-ZERO  TO WS-CHG-COLUMN-VALUE-TXT         
                                                   (TH-SUB)             
              MOVE 10     TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)           
              MOVE IN-CX-NO-DAYS (MATCH-IDX)  TO CX-NO-DAYS             
           END-IF                                                       
           IF IN-CX-METER-READING (MATCH-IDX)                           
                                      NOT = CX-METER-READING            
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES         TO WS-TABLE-ID (TH-SUB)               
              MOVE 'METER READING'     TO WS-COLUMN-DESC (TH-SUB)       
              MOVE CX-METER-READING    TO WS-EDIT-DEC-ZERO              
              MOVE WS-EDIT-DEC-ZERO  TO WS-PRV-COLUMN-VALUE-TXT         
                                                   (TH-SUB)             
              MOVE 10     TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)           
              MOVE IN-CX-METER-READING  (MATCH-IDX)                     
                                     TO WS-EDIT-DEC-ZERO                
              MOVE WS-EDIT-DEC-ZERO  TO WS-CHG-COLUMN-VALUE-TXT         
                                                   (TH-SUB)             
              MOVE 10     TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)           
              MOVE IN-CX-METER-READING  (MATCH-IDX)                     
                                     TO CX-METER-READING                
           END-IF                                                       
           IF IN-CX-DEMAND-READING (MATCH-IDX)                          
                                      NOT = CX-DEMAND-READING           
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES         TO WS-TABLE-ID (TH-SUB)               
              MOVE 'DEMAND READING'    TO WS-COLUMN-DESC (TH-SUB)       
              MOVE CX-DEMAND-READING   TO WS-EDIT-DEC-THREE             
              MOVE WS-EDIT-DEC-THREE TO WS-PRV-COLUMN-VALUE-TXT         
                                                   (TH-SUB)             
              MOVE 10     TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)           
              MOVE IN-CX-DEMAND-READING (MATCH-IDX)                     
                                     TO WS-EDIT-DEC-THREE               
              MOVE WS-EDIT-DEC-THREE TO WS-CHG-COLUMN-VALUE-TXT         
                                                   (TH-SUB)             
              MOVE 10     TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)           
              MOVE IN-CX-DEMAND-READING (MATCH-IDX)                     
                                     TO CX-DEMAND-READING               
           END-IF                                                       
           IF IN-CX-CONSTANT (MATCH-IDX)                                
                                      NOT = CX-CONSTANT                 
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES         TO WS-TABLE-ID (TH-SUB)               
              MOVE 'CONSTANT'          TO WS-COLUMN-DESC (TH-SUB)       
              MOVE CX-CONSTANT         TO WS-EDIT-DEC-ZERO              
              MOVE WS-EDIT-DEC-ZERO  TO WS-PRV-COLUMN-VALUE-TXT         
                                                   (TH-SUB)             
              MOVE 10     TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)           
              MOVE IN-CX-CONSTANT (MATCH-IDX)                           
                                     TO WS-EDIT-DEC-ZERO                
              MOVE WS-EDIT-DEC-ZERO  TO WS-CHG-COLUMN-VALUE-TXT         
                                                   (TH-SUB)             
              MOVE 10     TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)           
              MOVE IN-CX-CONSTANT (MATCH-IDX)                           
                                     TO CX-CONSTANT                     
           END-IF                                                       
           IF IN-CX-PCOMP-FCT (MATCH-IDX)                               
                                      NOT = CX-PCOMP-FCT                
              AND IN-CX-PCOMP-FCT (MATCH-IDX) >= 1                      
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES         TO WS-TABLE-ID (TH-SUB)               
              MOVE 'PCOMP FCT'    TO WS-COLUMN-DESC (TH-SUB)            
              MOVE CX-PCOMP-FCT        TO WS-EDIT-DEC-FOUR              
              MOVE WS-EDIT-DEC-FOUR  TO WS-PRV-COLUMN-VALUE-TXT         
                                                   (TH-SUB)             
              MOVE 8     TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)            
              MOVE IN-CX-PCOMP-FCT  (MATCH-IDX)                         
                                     TO WS-EDIT-DEC-FOUR                
              MOVE WS-EDIT-DEC-FOUR  TO WS-CHG-COLUMN-VALUE-TXT         
                                                   (TH-SUB)             
              MOVE 8     TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)            
              MOVE IN-CX-PCOMP-FCT  (MATCH-IDX)                         
                                     TO CX-PCOMP-FCT                    
           END-IF                                                       
           IF IN-CX-NO-DIALS       (MATCH-IDX)                          
                                      NOT = CX-NO-DIALS                 
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES              TO WS-TABLE-ID (TH-SUB)          
              MOVE 'DEMAND READING'    TO WS-COLUMN-DESC (TH-SUB)       
              MOVE CX-NO-DIALS         TO WS-EDIT-DEC-ZERO              
              MOVE WS-EDIT-DEC-ZERO  TO WS-PRV-COLUMN-VALUE-TXT         
                                                   (TH-SUB)             
              MOVE 10     TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)           
              MOVE IN-CX-NO-DIALS       (MATCH-IDX)                     
                                     TO WS-EDIT-DEC-ZERO                
              MOVE WS-EDIT-DEC-ZERO  TO WS-CHG-COLUMN-VALUE-TXT         
                                                   (TH-SUB)             
              MOVE 10     TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)           
              MOVE IN-CX-NO-DIALS       (MATCH-IDX)                     
                                     TO CX-NO-DIALS                     
           END-IF                                                       
           IF IN-CX-METER-NO       (MATCH-IDX)                          
                                      NOT = CX-METER-NO                 
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES         TO WS-TABLE-ID (TH-SUB)               
              MOVE 'METER NO'          TO WS-COLUMN-DESC (TH-SUB)       
              MOVE CX-METER-NO    TO WS-PRV-COLUMN-VALUE-TXT (TH-SUB)   
              MOVE 9      TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)           
              MOVE IN-CX-METER-NO (MATCH-IDX)                           
                                TO WS-CHG-COLUMN-VALUE-TXT (TH-SUB)     
              MOVE 9      TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)           
              MOVE IN-CX-METER-NO (MATCH-IDX) TO CX-METER-NO            
           END-IF                                                       
           IF IN-CX-DATE-READ      (MATCH-IDX)                          
                                      NOT = CX-DATE-READ                
      *** CHECK ACCOUNT FINAL,UPDATE PREM HIST END DATE IF NEEDED.              
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES         TO WS-TABLE-ID (TH-SUB)               
              MOVE 'DATE READ'         TO WS-COLUMN-DESC (TH-SUB)       
              MOVE CX-DATE-READ  TO WS-PRV-COLUMN-VALUE-TXT (TH-SUB)    
              MOVE 10     TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)           
              MOVE IN-CX-DATE-READ (MATCH-IDX)                          
                              TO WS-CHG-COLUMN-VALUE-TXT (TH-SUB)       
              MOVE 10     TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)           
              MOVE IN-CX-DATE-READ (MATCH-IDX) TO CX-DATE-READ          
           END-IF                                                       
           IF IN-CX-CODE-ITEM-STATUS (MATCH-IDX)                        
                                      NOT = CX-CODE-ITEM-STATUS         
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES         TO WS-TABLE-ID (TH-SUB)               
              MOVE 'CODE ITEM STATUS'  TO WS-COLUMN-DESC (TH-SUB)       
              MOVE CX-CODE-ITEM-STATUS TO WS-PRV-COLUMN-VALUE-TXT       
                                                   (TH-SUB)             
              MOVE 1      TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)           
              MOVE IN-CX-CODE-ITEM-STATUS (MATCH-IDX)                   
                                TO WS-CHG-COLUMN-VALUE-TXT              
                                                   (TH-SUB)             
              MOVE 1      TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)           
              MOVE IN-CX-CODE-ITEM-STATUS (MATCH-IDX)                   
                                     TO CX-CODE-ITEM-STATUS             
           END-IF                                                       
           IF IN-CX-EXCEPT-OVERRIDE-CD  (MATCH-IDX)                     
                                    NOT = CX-EXCEPT-OVERRIDE-CD         
              AND IN-CX-EXCEPT-OVERRIDE-CD  (MATCH-IDX) = 'Y'           
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES         TO WS-TABLE-ID (TH-SUB)               
              MOVE 'EXCEPT OVERRIDE'  TO WS-COLUMN-DESC (TH-SUB)        
              MOVE CX-EXCEPT-OVERRIDE-CD TO                             
                               WS-PRV-COLUMN-VALUE-TXT  (TH-SUB)        
              MOVE 1      TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)           
                                                                        
              MOVE IN-CX-EXCEPT-OVERRIDE-CD (MATCH-IDX)                 
                                TO WS-CHG-COLUMN-VALUE-TXT              
                                                   (TH-SUB)             
              MOVE 1      TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)           
              MOVE IN-CX-EXCEPT-OVERRIDE-CD (MATCH-IDX)                 
                                     TO CX-EXCEPT-OVERRIDE-CD           
           END-IF                                                       
           IF IN-CX-CODE-METER-NO-READ  (MATCH-IDX)                     
                                    NOT = CX-CODE-METER-NO-READ         
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES         TO WS-TABLE-ID (TH-SUB)               
              MOVE 'CODE MTR NO READ' TO WS-COLUMN-DESC (TH-SUB)        
              MOVE CX-CODE-METER-NO-READ TO                             
                               WS-PRV-COLUMN-VALUE-TXT  (TH-SUB)        
              MOVE 1      TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)           
                                                                        
              MOVE IN-CX-CODE-METER-NO-READ (MATCH-IDX)                 
                                TO WS-CHG-COLUMN-VALUE-TXT              
                                                   (TH-SUB)             
              MOVE 1      TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)           
              MOVE IN-CX-CODE-METER-NO-READ (MATCH-IDX)                 
                                     TO CX-CODE-METER-NO-READ           
           END-IF                                                       
A05460     IF IN-CX-CODE-TOU-SEASN  (MATCH-IDX)                         
A05460                              NOT = CX-CODE-TOU-SEASN             
A05460        COMPUTE TH-SUB = TH-SUB + 1                               
A05460        MOVE SPACES            TO WS-TABLE-ID (TH-SUB)            
A05460        MOVE 'CODE TOU SEASON' TO WS-COLUMN-DESC (TH-SUB)         
A05460        MOVE CX-CODE-TOU-SEASN TO                                 
A05460                         WS-PRV-COLUMN-VALUE-TXT  (TH-SUB)        
A05460        MOVE 1                 TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)
A05460                                                                  
A05460        MOVE IN-CX-CODE-TOU-SEASN (MATCH-IDX)                     
A05460                               TO WS-CHG-COLUMN-VALUE-TXT         
A05460                                             (TH-SUB)             
A05460        MOVE 1                 TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)
A05460        MOVE IN-CX-CODE-TOU-SEASN (MATCH-IDX)                     
A05460                               TO CX-CODE-TOU-SEASN               
A05460     END-IF                                                       
           MOVE IN-CX-CODE-METER-READ (MATCH-IDX)                       
                                     TO CX-CODE-METER-READ              
           IF PARM-PERMANENT-UPDATE = 'Y' OR                            
              IN-CX-PERMANENT-UPDATE (MATCH-IDX) = 'Y'                  
              PERFORM 4700-UPD-CURRENT-READS-MN THRU 4700-EXIT          
              IF CX-CODE-METER-READ  NOT = 'E' OR                       
                 CX-CODE-METER-READ  NOT = 'D' OR                       
                 CX-CODE-METER-READ  NOT = 'S' OR                       
                 CX-CODE-METER-READ  NOT = 'F' OR                       
                 CX-CODE-METER-READ  NOT = 'M'                          
                 MOVE ZEROES           TO  MN-NO-CONSEC-ESTIMATE        
                 PERFORM 8855-UPDATE-MTRD-ENVRNMT THRU 8855-EXIT        
              END-IF                                                    
           END-IF.                                                      
           IF IN-CX-AGLMTCHRG-FLAG  (MATCH-IDX) = 'Y'                   
              MOVE WS-AGL-TRANS-TEXT            TO WS-AGL-TRANS-TEXT1   
              PERFORM 4500-PROCESS-AGL-MTR-CHRG THRU 4500-EXIT          
           END-IF.                                                      
                                                                        
           IF AT-CODE-ACCT-STAT = 'B'                                   
              PERFORM 4600-PROCESS-PRE-HIST-CHG THRU 4600-EXIT          
           END-IF.                                                      
                                                                        
       4112-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       4114-TH-FOR-CX-DEL.                                              
      *================================================================*        
                                                                        
      ***  USAGE TYPE                                                           
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE SPACES            TO WS-TABLE-ID (TH-SUB)               
           MOVE 'USAGE TYPE'      TO WS-COLUMN-DESC  (TH-SUB)           
           MOVE CX-CODE-USAGE-TYPE  TO WS-PRV-COLUMN-VALUE-TXT          
                                                (TH-SUB)                
           MOVE 1                 TO WS-PRV-COLUMN-VALUE-LEN            
                                                (TH-SUB)                
           MOVE 'DELETE'            TO WS-CHG-COLUMN-VALUE-TXT          
                                                (TH-SUB)                
           MOVE 6                 TO WS-CHG-COLUMN-VALUE-LEN            
                                                (TH-SUB)                
      ***  CDE TIME PERIOD                                                      
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE SPACES            TO WS-TABLE-ID (TH-SUB)               
           MOVE 'CDE TIME PERIOD' TO WS-COLUMN-DESC (TH-SUB)            
           MOVE CX-CODE-TIME-PERIOD     TO WS-EDIT-DEC-ZERO             
           MOVE WS-EDIT-DEC-ZERO  TO WS-PRV-COLUMN-VALUE-TXT            
                                                (TH-SUB)                
           MOVE 1                 TO WS-PRV-COLUMN-VALUE-LEN            
                                                (TH-SUB)                
           MOVE 'DELETE'          TO WS-CHG-COLUMN-VALUE-TXT            
                                                (TH-SUB)                
           MOVE 6                 TO WS-CHG-COLUMN-VALUE-LEN            
                                                (TH-SUB)                
      ***  NO DAYS                                                              
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE SPACES         TO WS-TABLE-ID (TH-SUB)                  
           MOVE 'NO DAYS'      TO WS-COLUMN-DESC  (TH-SUB)              
           MOVE CX-NO-DAYS     TO WS-EDIT-DEC-ZERO                      
           MOVE WS-EDIT-DEC-ZERO  TO WS-PRV-COLUMN-VALUE-TXT            
                                                (TH-SUB)                
           MOVE 10                TO WS-PRV-COLUMN-VALUE-LEN            
                                                (TH-SUB)                
           MOVE 'DELETE'          TO WS-CHG-COLUMN-VALUE-TXT            
                                                (TH-SUB)                
           MOVE 6                 TO WS-CHG-COLUMN-VALUE-LEN            
                                                (TH-SUB)                
      ***  METER NO                                                             
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE SPACES            TO WS-TABLE-ID (TH-SUB)               
           MOVE 'METER NO'        TO WS-COLUMN-DESC  (TH-SUB)           
           MOVE CX-METER-NO       TO WS-PRV-COLUMN-VALUE-TXT            
                                                (TH-SUB)                
           MOVE 9                 TO WS-PRV-COLUMN-VALUE-LEN            
                                                (TH-SUB)                
           MOVE 'DELETE'          TO WS-CHG-COLUMN-VALUE-TXT            
                                                (TH-SUB)                
           MOVE 6                 TO WS-CHG-COLUMN-VALUE-LEN            
                                                (TH-SUB)                
      ***  DATE READ                                                            
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE SPACES            TO WS-TABLE-ID (TH-SUB)               
           MOVE 'DATE READ'       TO WS-COLUMN-DESC  (TH-SUB)           
           MOVE CX-DATE-READ      TO WS-PRV-COLUMN-VALUE-TXT            
                                                (TH-SUB)                
           MOVE 10                TO WS-PRV-COLUMN-VALUE-LEN            
                                                (TH-SUB)                
           MOVE 'DELETE'          TO WS-CHG-COLUMN-VALUE-TXT            
                                                (TH-SUB)                
           MOVE 6                 TO WS-CHG-COLUMN-VALUE-LEN            
                                                (TH-SUB)                
      ***  NO UNITS                                                             
           IF CX-NO-UNITS > 0                                           
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES         TO WS-TABLE-ID (TH-SUB)               
              MOVE 'NO UNITS'     TO WS-COLUMN-DESC  (TH-SUB)           
              MOVE CX-NO-UNITS    TO WS-EDIT-DEC-ZERO                   
              MOVE WS-EDIT-DEC-ZERO  TO WS-PRV-COLUMN-VALUE-TXT         
                                                (TH-SUB)                
              MOVE 10                TO WS-PRV-COLUMN-VALUE-LEN         
                                                (TH-SUB)                
              MOVE 'DELETE'          TO WS-CHG-COLUMN-VALUE-TXT         
                                                (TH-SUB)                
              MOVE 6                 TO WS-CHG-COLUMN-VALUE-LEN         
                                                (TH-SUB)                
           END-IF                                                       
      ***  NO DEMAND UNITS                                                      
           IF CX-NO-DEMAND-UNITS > 0                                    
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES            TO WS-TABLE-ID (TH-SUB)            
              MOVE 'NO DEMAND UNITS' TO WS-COLUMN-DESC (TH-SUB)         
              MOVE CX-NO-DEMAND-UNITS     TO WS-EDIT-DEC-ZERO           
              MOVE WS-EDIT-DEC-ZERO  TO WS-PRV-COLUMN-VALUE-TXT         
                                                (TH-SUB)                
              MOVE 10                TO WS-PRV-COLUMN-VALUE-LEN         
                                                (TH-SUB)                
              MOVE 'DELETE'       TO WS-CHG-COLUMN-VALUE-TXT            
                                                (TH-SUB)                
              MOVE 6                 TO WS-CHG-COLUMN-VALUE-LEN         
                                                (TH-SUB)                
           END-IF                                                       
      ***  METER READING                                                        
           IF CX-METER-READING > 0                                      
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES            TO WS-TABLE-ID (TH-SUB)            
              MOVE 'METER READING'   TO WS-COLUMN-DESC  (TH-SUB)        
              MOVE CX-METER-READING  TO WS-EDIT-DEC-ZERO                
              MOVE WS-EDIT-DEC-ZERO  TO WS-PRV-COLUMN-VALUE-TXT         
                                                   (TH-SUB)             
              MOVE 10                TO WS-PRV-COLUMN-VALUE-LEN         
                                                (TH-SUB)                
              MOVE 'DELETE'          TO WS-CHG-COLUMN-VALUE-TXT         
                                                   (TH-SUB)             
              MOVE 6                 TO WS-CHG-COLUMN-VALUE-LEN         
                                                (TH-SUB)                
           END-IF                                                       
      ***  DEMAND READING                                                       
           IF CX-DEMAND-READING > 0                                     
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES            TO WS-TABLE-ID (TH-SUB)            
              MOVE 'DEMAND READING'  TO WS-COLUMN-DESC  (TH-SUB)        
              MOVE CX-DEMAND-READING TO WS-EDIT-DEC-THREE               
              MOVE WS-EDIT-DEC-THREE TO WS-PRV-COLUMN-VALUE-TXT         
                                                   (TH-SUB)             
              MOVE 10                TO WS-PRV-COLUMN-VALUE-LEN         
                                                (TH-SUB)                
              MOVE 'DELETE'          TO WS-CHG-COLUMN-VALUE-TXT         
                                                   (TH-SUB)             
              MOVE 6                 TO WS-CHG-COLUMN-VALUE-LEN         
                                                (TH-SUB)                
           END-IF.                                                      
                                                                        
       4114-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       4116-TH-FOR-CX-NEW.                                              
      *================================================================*        
                                                                        
      ***  USAGE TYPE                                                           
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE SPACES            TO WS-TABLE-ID (TH-SUB)               
           MOVE 'USAGE TYPE'      TO WS-COLUMN-DESC  (TH-SUB)           
           MOVE 'INSERT'            TO WS-PRV-COLUMN-VALUE-TXT          
                                                (TH-SUB)                
           MOVE 6                 TO WS-PRV-COLUMN-VALUE-LEN            
                                                (TH-SUB)                
           MOVE CX-CODE-USAGE-TYPE  TO WS-CHG-COLUMN-VALUE-TXT          
                                                (TH-SUB)                
           MOVE 1                 TO WS-CHG-COLUMN-VALUE-LEN            
                                                (TH-SUB)                
      ***  CDE TIME PERIOD                                                      
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE SPACES            TO WS-TABLE-ID (TH-SUB)               
           MOVE 'CDE TIME PERIOD' TO WS-COLUMN-DESC (TH-SUB)            
           MOVE 'INSERT'          TO WS-PRV-COLUMN-VALUE-TXT            
                                                (TH-SUB)                
           MOVE 6                 TO WS-PRV-COLUMN-VALUE-LEN            
                                                (TH-SUB)                
           MOVE CX-CODE-TIME-PERIOD     TO WS-EDIT-DEC-ZERO             
           MOVE WS-EDIT-DEC-ZERO  TO WS-CHG-COLUMN-VALUE-TXT            
                                                (TH-SUB)                
           MOVE 1                 TO WS-CHG-COLUMN-VALUE-LEN            
                                                (TH-SUB)                
      ***  NO DAYS                                                              
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE SPACES         TO WS-TABLE-ID (TH-SUB)                  
           MOVE 'NO DAYS'      TO WS-COLUMN-DESC  (TH-SUB)              
           MOVE 'INSERT'          TO WS-PRV-COLUMN-VALUE-TXT            
                                                (TH-SUB)                
           MOVE 6                 TO WS-PRV-COLUMN-VALUE-LEN            
                                                (TH-SUB)                
           MOVE CX-NO-DAYS     TO WS-EDIT-DEC-ZERO                      
           MOVE WS-EDIT-DEC-ZERO  TO WS-CHG-COLUMN-VALUE-TXT            
                                                (TH-SUB)                
           MOVE 10                TO WS-CHG-COLUMN-VALUE-LEN            
                                                (TH-SUB)                
      ***  METER NO                                                             
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE SPACES            TO WS-TABLE-ID (TH-SUB)               
           MOVE 'METER NO'        TO WS-COLUMN-DESC  (TH-SUB)           
           MOVE 'INSERT'          TO WS-PRV-COLUMN-VALUE-TXT            
                                                (TH-SUB)                
           MOVE 6                 TO WS-PRV-COLUMN-VALUE-LEN            
                                                (TH-SUB)                
           MOVE CX-METER-NO       TO WS-CHG-COLUMN-VALUE-TXT            
                                                (TH-SUB)                
           MOVE 9                 TO WS-CHG-COLUMN-VALUE-LEN            
                                                (TH-SUB)                
      ***  DATE READ                                                            
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE SPACES            TO WS-TABLE-ID (TH-SUB)               
           MOVE 'DATE READ'       TO WS-COLUMN-DESC  (TH-SUB)           
           MOVE 'INSERT'          TO WS-PRV-COLUMN-VALUE-TXT            
                                                (TH-SUB)                
           MOVE 6                 TO WS-PRV-COLUMN-VALUE-LEN            
                                                (TH-SUB)                
           MOVE CX-DATE-READ      TO WS-CHG-COLUMN-VALUE-TXT            
                                                (TH-SUB)                
           MOVE 10                TO WS-CHG-COLUMN-VALUE-LEN            
                                                (TH-SUB)                
      ***  NO UNITS                                                             
           IF CX-NO-UNITS > 0                                           
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES         TO WS-TABLE-ID (TH-SUB)               
              MOVE 'NO UNITS'     TO WS-COLUMN-DESC  (TH-SUB)           
              MOVE 'INSERT'          TO WS-PRV-COLUMN-VALUE-TXT         
                                                (TH-SUB)                
              MOVE 6                 TO WS-PRV-COLUMN-VALUE-LEN         
                                                (TH-SUB)                
              MOVE CX-NO-UNITS    TO WS-EDIT-DEC-ZERO                   
              MOVE WS-EDIT-DEC-ZERO  TO WS-CHG-COLUMN-VALUE-TXT         
                                                (TH-SUB)                
              MOVE 10                TO WS-CHG-COLUMN-VALUE-LEN         
                                                (TH-SUB)                
           END-IF                                                       
      ***  NO DEMAND UNITS                                                      
           IF CX-NO-DEMAND-UNITS > 0                                    
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES            TO WS-TABLE-ID (TH-SUB)            
              MOVE 'NO DEMAND UNITS' TO WS-COLUMN-DESC (TH-SUB)         
              MOVE 'INSERT'          TO WS-PRV-COLUMN-VALUE-TXT         
                                                (TH-SUB)                
              MOVE 6                 TO WS-PRV-COLUMN-VALUE-LEN         
                                                (TH-SUB)                
              MOVE CX-NO-DEMAND-UNITS     TO WS-EDIT-DEC-ZERO           
              MOVE WS-EDIT-DEC-ZERO TO WS-CHG-COLUMN-VALUE-TXT          
                                                (TH-SUB)                
              MOVE 10                TO WS-CHG-COLUMN-VALUE-LEN         
                                                (TH-SUB)                
           END-IF                                                       
      ***  METER READING                                                        
           IF CX-METER-READING > 0                                      
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES            TO WS-TABLE-ID (TH-SUB)            
              MOVE 'METER READING'   TO WS-COLUMN-DESC  (TH-SUB)        
              MOVE 'INSERT'          TO WS-PRV-COLUMN-VALUE-TXT         
                                                   (TH-SUB)             
              MOVE 6                 TO WS-PRV-COLUMN-VALUE-LEN         
                                                (TH-SUB)                
              MOVE CX-METER-READING  TO WS-EDIT-DEC-ZERO                
              MOVE WS-EDIT-DEC-ZERO  TO WS-CHG-COLUMN-VALUE-TXT         
                                                   (TH-SUB)             
              MOVE 10                TO WS-CHG-COLUMN-VALUE-LEN         
                                                (TH-SUB)                
           END-IF                                                       
      ***  DEMAND READING                                                       
           IF CX-DEMAND-READING > 0                                     
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES            TO WS-TABLE-ID (TH-SUB)            
              MOVE 'DEMAND READING'  TO WS-COLUMN-DESC  (TH-SUB)        
              MOVE 'INSERT'          TO WS-PRV-COLUMN-VALUE-TXT         
                                                   (TH-SUB)             
              MOVE 6                 TO WS-PRV-COLUMN-VALUE-LEN         
                                                (TH-SUB)                
              MOVE CX-DEMAND-READING TO WS-EDIT-DEC-THREE               
              MOVE WS-EDIT-DEC-THREE TO WS-CHG-COLUMN-VALUE-TXT         
                                                   (TH-SUB)             
              MOVE 10                TO WS-CHG-COLUMN-VALUE-LEN         
                                                (TH-SUB)                
           END-IF.                                                      
                                                                        
       4116-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       4120-COPY-CX-WITH-IDR.                                           
      *================================================================*        
                                                                        
           EVALUATE TRUE                                                
      *--- DO NOT COPY CONSUMPTION FROM AN ADDITIVE                             
      *--- OR SUBTRACTIVE METER.  THESE WILL BE                                 
      *--- REGENERATED IN SCSCA104.                                             
              WHEN CX-CODE-USAGE-SOURCE = 'K' OR 'J'                    
                 CONTINUE                                               
              WHEN CX-MTR-READ-SOURCE-CD  NOT = 'M'                     
                   AND WS-CIG-CUSTOMER        = 'Y'                     
                   PERFORM 8773-INSERT-CX     THRU 8773-EXIT            
                   PERFORM 4130-COPY-IDR      THRU 4130-EXIT            
              WHEN CX-MTR-READ-SOURCE-CD  NOT = 'M'                     
                   PERFORM 8773-INSERT-CX          THRU 8773-EXIT       
              WHEN CX-MTR-READ-SOURCE-CD  = 'M'                         
                   AND PARM-COPY-CX-DATA  = 'Y'                         
                   PERFORM 8773-INSERT-CX     THRU 8773-EXIT            
                   PERFORM 4130-COPY-IDR      THRU 4130-EXIT            
              WHEN CX-MTR-READ-SOURCE-CD  = 'M'                         
                   AND PARM-COPY-CX-DATA  = 'N'                         
                   AND PARM-COPY-IDR-DATA = 'Y'                         
                   AND (CX-CODE-USAGE-ID = '1' OR '2' OR '3' OR         
                                           '4' OR '5' OR '6' OR         
                                           '7' OR '8' OR '9')           
                   PERFORM 8773-INSERT-CX     THRU 8773-EXIT            
                   PERFORM 4130-COPY-IDR      THRU 4130-EXIT            
                 WHEN CX-MTR-READ-SOURCE-CD  = 'M'                      
                      AND PARM-COPY-CX-DATA  = 'N'                      
                      AND PARM-COPY-IDR-DATA  = 'N'                     
                    CONTINUE                                            
                 WHEN OTHER                                             
                    CONTINUE                                            
              END-EVALUATE.                                             
                                                                        
       4120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       4130-COPY-IDR.                                                   
      *================================================================*        
                                                                        
           IF CX-METER-NO NOT = WS-METER-NO-HOLD                        
              MOVE CX-METER-NO                TO WS-METER-NO-HOLD       
                                                 IV-METER-NO            
              MOVE IN-CODE-UTIL-TYPE          TO IV-CODE-UTIL-TYPE      
              MOVE WS-ORIG-ITEM-TIMESTMP      TO IV-BILL-ITEM-TIMESTMP  
              PERFORM 7700-OPEN-IDR-CRSR      THRU 7700-EXIT            
              PERFORM 7705-FETCH-IDR-CRSR     THRU 7705-EXIT            
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
                 MOVE WS-RB-ITEM-TIMESTMP     TO IV-BILL-ITEM-TIMESTMP  
                 PERFORM 7715-INSERT-IDR      THRU 7715-EXIT            
                 PERFORM 7705-FETCH-IDR-CRSR  THRU 7705-EXIT            
              END-PERFORM                                               
              PERFORM 7710-CLOSE-IDR-CRSR     THRU 7710-EXIT            
           END-IF.                                                      
                                                                        
       4130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       4150-PROCESS-CX-NEW-ROWS.                                        
      *================================================================*        
                                                                        
      *** GET MAX SEQ                                                           
           PERFORM 7420-GET-MAX-CNSMPTN-SEQ THRU 7420-EXIT              
                                                                        
           MOVE IN-CX-CODE-TOU-SEASN (IN-CX-IDX)                        
                                              TO CX-CODE-TOU-SEASN      
           MOVE IN-CX-CODE-USAGE-TYPE (IN-CX-IDX)                       
                                              TO CX-CODE-USAGE-TYPE     
           MOVE IN-CX-CODE-USAGE-ID (IN-CX-IDX)                         
                                              TO CX-CODE-USAGE-ID       
           MOVE IN-CX-CODE-USAGE-SOURCE (IN-CX-IDX)                     
                                              TO CX-CODE-USAGE-SOURCE   
           MOVE IN-CX-METER-NO (IN-CX-IDX)    TO CX-METER-NO            
           MOVE IN-CX-DATE-READ (IN-CX-IDX)   TO CX-DATE-READ           
           MOVE IN-CX-CODE-METER-READ (IN-CX-IDX)                       
                                              TO CX-CODE-METER-READ     
           MOVE IN-CX-CODE-METER-NO-READ (IN-CX-IDX)                    
                                              TO CX-CODE-METER-NO-READ  
           MOVE IN-CX-METER-READING (IN-CX-IDX)                         
                                              TO CX-METER-READING       
           MOVE IN-CX-DEMAND-READING (IN-CX-IDX)                        
                                              TO CX-DEMAND-READING      
           MOVE IN-CX-NO-UNITS (IN-CX-IDX)    TO CX-NO-UNITS            
           MOVE IN-CX-NO-DEMAND-UNITS (IN-CX-IDX)                       
                                              TO CX-NO-DEMAND-UNITS     
           MOVE IN-CX-NO-DAYS (IN-CX-IDX)     TO CX-NO-DAYS             
           MOVE IN-CX-CODE-ITEM-STATUS (IN-CX-IDX)                      
                                              TO CX-CODE-ITEM-STATUS    
           MOVE IN-CX-CONSTANT (IN-CX-IDX)    TO CX-CONSTANT            
           MOVE IN-CX-NO-DIALS (IN-CX-IDX)    TO CX-NO-DIALS            
           MOVE IN-CX-EXCEPT-OVERRIDE-CD (IN-CX-IDX)                    
                                              TO CX-EXCEPT-OVERRIDE-CD  
           MOVE IN-CX-EXCL-DMD-RCHT-IND (IN-CX-IDX)                     
                                              TO CX-EXCL-DMD-RCHT-IND   
           MOVE IN-CX-CODE-DEBIT-CREDIT (IN-CX-IDX)                     
                                              TO CX-CODE-DEBIT-CREDIT   
TEMP  ***  MOVE IN-CX-CODE-SOURCE-ID (IN-CX-IDX)                                
TEMP       MOVE WS-C                          TO CX-CODE-SOURCE-ID      
      ***  MOVE IN-CX-CODE-DISCOUNT (IN-CX-IDX)                                 
      ***                                     TO CX-CODE-DISCOUNT               
           MOVE AT-COMPANY-NO                 TO CX-COMPANY-NO          
           MOVE ZEROES                        TO CX-EMPLOYEE-NO         
                                                 CX-REQUESTED-USAGE     
           MOVE CX-ACCOUNT-NO                 TO MN-ACCOUNT-NO          
           MOVE CX-CODE-UTIL-TYPE             TO MN-CODE-UTIL-TYPE      
           MOVE CX-IC-NO                      TO MN-IC-NO               
           MOVE CX-MTR-REF-NO                 TO MN-MTR-REF-NO          
           MOVE CX-METER-NO                   TO MN-METER-NO            
           IF MN-MTR-REF-NO > 0                                         
              PERFORM 7910-SELECT-MTRD-TYPE  THRU  7910-EXIT            
           ELSE                                                         
              PERFORM 7915-SELECT-MTRD-TYPE  THRU  7915-EXIT            
           END-IF                                                       
           IF WS-ACTIVE-RETURN-CODE =   NOT-FOUND                       
              PERFORM 7920-SELECT-MTRD-TYPE  THRU  7920-EXIT            
           END-IF                                                       
           MOVE MN-DIGTL-MTR-TYPE             TO  CX-DIGTL-MTR-TYPE     
           MOVE MN-MTR-READ-SOURCE-CD         TO CX-MTR-READ-SOURCE-CD  
           IF IN-CX-PCOMP-FCT (IN-CX-IDX) > 1                           
              MOVE IN-CX-PCOMP-FCT (IN-CX-IDX)   TO CX-PCOMP-FCT        
           ELSE                                                         
              MOVE 1.0                           TO CX-PCOMP-FCT        
           END-IF                                                       
      ***  IF CX-CODE-USAGE-TYPE = 'C'                                          
      ***         AND MN-METER-PRESSURE > 0                                     
      ***     COMPUTE CX-PCOMP-FCT ROUNDED =                                    
      ***               (MN-METER-PRESSURE + 14.7) / 14.73                      
      ***  END-IF                                                               
           MOVE SPACES                        TO CX-DIGTL-INTRL-MTR-NO  
                                                 CX-CODE-DISCOUNT       
                                                                        
           MOVE ZEROS                         TO CX-BTU-FACTOR          
           IF WS-CIG-CUSTOMER       = 'Y' AND MN-INDUST-BTU-ID > SPACES 
              PERFORM 4160-GET-BTU-FACTOR     THRU 4160-EXIT            
           END-IF                                                       
           MOVE IN-CX-CODE-DEBIT-CREDIT (IN-CX-IDX)                     
                                              TO CX-CODE-DEBIT-CREDIT   
           PERFORM 4116-TH-FOR-CX-NEW       THRU 4116-EXIT              
           PERFORM 8773-INSERT-CX           THRU 8773-EXIT              
           IF PARM-PERMANENT-UPDATE = 'Y' OR                            
              IN-CX-PERMANENT-UPDATE (IN-CX-IDX) = 'Y'                  
              PERFORM 4700-UPD-CURRENT-READS-MN THRU 4700-EXIT          
              IF CX-CODE-METER-READ  NOT = 'E' OR                       
                 CX-CODE-METER-READ  NOT = 'D' OR                       
                 CX-CODE-METER-READ  NOT = 'S' OR                       
                 CX-CODE-METER-READ  NOT = 'F' OR                       
                 CX-CODE-METER-READ  NOT = 'M'                          
                 MOVE ZEROES           TO  MN-NO-CONSEC-ESTIMATE        
                 PERFORM 8855-UPDATE-MTRD-ENVRNMT THRU 8855-EXIT        
              END-IF                                                    
           END-IF.                                                      
           IF AT-CODE-ACCT-STAT = 'B'                                   
              PERFORM 4600-PROCESS-PRE-HIST-CHG THRU 4600-EXIT          
           END-IF.                                                      
                                                                        
       4150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       4160-GET-BTU-FACTOR.                                             
      *================================================================*        
                                                                        
           MOVE MN-INDUST-BTU-ID        TO FE-INDUST-BTU-ID             
           MOVE CX-DATE-READ            TO FE-BTU-DT                    
           PERFORM 7860-GET-BTU-FACTOR  THRU 7860-EXIT                  
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE FE-BTU-FACTOR        TO CX-BTU-FACTOR                
           ELSE                                                         
              MOVE ZEROS             TO WS-AVG-BTU-FACTOR               
              MOVE CX-DATE-READ(6:2)    TO WS-BTU-DT-MM                 
              MOVE CX-DATE-READ(1:4)    TO WS-BTU-DT-YY                 
              PERFORM 7870-ESTIMATE-BTU THRU 7870-EXIT                  
              IF WS-NULL-INDICATOR < 0 OR                               
                 WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 COMPUTE WS-BTU-DT-MM = WS-BTU-DT-MM - 1                
                 IF WS-BTU-DT-MM EQUAL ZERO                             
                    MOVE 12            TO WS-BTU-DT-MM                  
                    COMPUTE WS-BTU-DT-YY = WS-BTU-DT-YY - 1             
                 END-IF                                                 
                 PERFORM 7870-ESTIMATE-BTU THRU 7870-EXIT               
              END-IF                                                    
              MOVE WS-AVG-BTU-FACTOR TO CX-BTU-FACTOR                   
           END-IF.                                                      
                                                                        
       4160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       4200-PROCESS-UC-RBILL.                                           
      *================================================================*        
                                                                        
           MOVE ZERO   TO  MATCH-IDX                                    
           PERFORM VARYING IN-UC-IDX FROM 1 BY 1                        
SCA006        UNTIL MATCH-IDX > 0 OR 
                    IN-UC-IDX > 100 OR 
                    IN-UC-CHANGE-INDICATOR (IN-UC-IDX) = SPACES                 
              IF UC-RATE-ITEM-CODE  = IN-UC-RATE-ITEM-CODE (IN-UC-IDX)  
                 AND UC-ITEM-SEQ-NO = IN-UC-ITEM-SEQ-NO    (IN-UC-IDX)  
                 MOVE IN-UC-IDX                  TO MATCH-IDX           
              END-IF                                                    
           END-PERFORM.                                                 
           IF MATCH-IDX = 0                                             
              MOVE WS-RB-BILL-NO              TO UC-BILL-NO             
              MOVE WS-RB-ITEM-TIMESTMP        TO UC-BILL-ITEM-TIMESTMP  
              PERFORM 8772-INSERT-UC          THRU 8772-EXIT            
           ELSE                                                         
              PERFORM 4210-UC-RBILL-CHANGES THRU 4210-EXIT              
           END-IF                                                       
           PERFORM 7781-FETCH-UC-SHFT-CRSR THRU 7781-EXIT.              
                                                                        
       4200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       4210-UC-RBILL-CHANGES.                                           
      *================================================================*        
           MOVE 'P'               TO IN-UC-PROCESS-CD (MATCH-IDX)       
           EVALUATE TRUE                                                
              WHEN IN-UC-CHANGE-INDICATOR (MATCH-IDX) = 'U'             
                 PERFORM 4220-TH-FOR-UC-UPD  THRU 4220-EXIT             
                 MOVE WS-RB-BILL-NO           TO UC-BILL-NO             
                 MOVE WS-RB-ITEM-TIMESTMP     TO UC-BILL-ITEM-TIMESTMP  
                 PERFORM 8772-INSERT-UC       THRU 8772-EXIT            
              WHEN IN-UC-CHANGE-INDICATOR (MATCH-IDX) = 'D'             
                 PERFORM 4230-TH-FOR-UC-DEL  THRU 4230-EXIT             
              WHEN OTHER                                                
                 MOVE 'CR00009999'            TO RS-BUS-RULE-ID         
                 PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT        
           END-EVALUATE.                                                
                                                                        
       4210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       4220-TH-FOR-UC-UPD.                                              
      *================================================================*        
                                                                        
           IF IN-UC-NO-UNITS (MATCH-IDX) NOT = UC-NO-UNITS              
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES         TO WS-TABLE-ID (TH-SUB)               
              MOVE 'NO UNITS'     TO WS-COLUMN-DESC  (TH-SUB)           
              MOVE UC-NO-UNITS    TO WS-EDIT-DEC-ZERO                   
              MOVE WS-EDIT-DEC-ZERO  TO WS-PRV-COLUMN-VALUE-TXT         
                                                     (TH-SUB)           
              MOVE 10         TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)       
              MOVE IN-UC-NO-UNITS (MATCH-IDX)                           
                                    TO WS-EDIT-DEC-ZERO                 
              MOVE WS-EDIT-DEC-ZERO  TO WS-CHG-COLUMN-VALUE-TXT         
                                                      (TH-SUB)          
              MOVE 10         TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)       
              MOVE IN-UC-NO-UNITS (MATCH-IDX)   TO UC-NO-UNITS          
           END-IF                                                       
           IF IN-UC-NO-DAYS (MATCH-IDX)   NOT = UC-NO-DAYS              
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES         TO WS-TABLE-ID (TH-SUB)               
              MOVE 'NO DAYS'      TO WS-COLUMN-DESC  (TH-SUB)           
              MOVE UC-NO-DAYS     TO WS-EDIT-DEC-ZERO                   
              MOVE WS-EDIT-DEC-ZERO  TO WS-PRV-COLUMN-VALUE-TXT         
                                                      (TH-SUB)          
              MOVE 10         TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)       
              MOVE IN-UC-NO-DAYS (MATCH-IDX) TO WS-EDIT-DEC-ZERO        
              MOVE WS-EDIT-DEC-ZERO  TO WS-CHG-COLUMN-VALUE-TXT         
                                                     (TH-SUB)           
              MOVE 10         TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)       
              MOVE IN-UC-NO-DAYS (MATCH-IDX)  TO UC-NO-DAYS             
           END-IF                                                       
           IF IN-UC-USAGE-FIXED (MATCH-IDX)  NOT = UC-USAGE-FIXED       
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES            TO WS-TABLE-ID (TH-SUB)            
              MOVE 'FIXED USAGE'     TO WS-COLUMN-DESC  (TH-SUB)        
              MOVE UC-USAGE-FIXED    TO WS-EDIT-DEC-THREE               
              MOVE WS-EDIT-DEC-THREE TO WS-PRV-COLUMN-VALUE-TXT         
                                                      (TH-SUB)          
              MOVE 10         TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)       
              MOVE IN-UC-USAGE-FIXED (MATCH-IDX)                        
                                           TO WS-EDIT-DEC-THREE         
              MOVE WS-EDIT-DEC-THREE TO WS-CHG-COLUMN-VALUE-TXT         
                                                         (TH-SUB)       
              MOVE 10         TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)       
              MOVE IN-UC-USAGE-FIXED (MATCH-IDX)                        
                                                  TO UC-USAGE-FIXED     
           END-IF                                                       
           IF IN-UC-DATE-USAGE-ENDS (MATCH-IDX) > SPACES                
              AND IN-UC-DATE-USAGE-ENDS (MATCH-IDX)                     
                                        NOT = UC-DATE-USAGE-ENDS        
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES               TO WS-TABLE-ID (TH-SUB)         
              MOVE 'DATE USG ENDS'      TO WS-COLUMN-DESC  (TH-SUB)     
              MOVE UC-DATE-USAGE-ENDS   TO WS-PRV-COLUMN-VALUE-TXT      
                                                         (TH-SUB)       
              MOVE 10         TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)       
              MOVE IN-UC-DATE-USAGE-ENDS (MATCH-IDX)                    
                                            TO WS-CHG-COLUMN-VALUE-TXT  
                                                       (TH-SUB)         
              MOVE 10         TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)       
              MOVE IN-UC-DATE-USAGE-ENDS (MATCH-IDX)                    
                                         TO UC-DATE-USAGE-ENDS          
              IF PARM-PERMANENT-UPDATE = 'Y' OR                         
                 IN-UC-PERMANENT-UPDATE (MATCH-IDX) = 'Y'               
                 PERFORM 4710-UPD-CUST-PLAN   THRU 4710-EXIT            
              END-IF                                                    
           END-IF                                                       
           IF IN-UC-CODE-ITEM-STATUS (MATCH-IDX)                        
                                   NOT = UC-CODE-ITEM-STATUS            
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES               TO WS-TABLE-ID (TH-SUB)         
              MOVE 'CODE ITEM STATUS'   TO WS-COLUMN-DESC (TH-SUB)      
              MOVE UC-CODE-ITEM-STATUS  TO WS-PRV-COLUMN-VALUE-TXT      
                                                      (TH-SUB)          
              MOVE 1          TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)       
              MOVE IN-UC-CODE-ITEM-STATUS (MATCH-IDX)                   
                                           TO WS-CHG-COLUMN-VALUE-TXT   
                                                      (TH-SUB)          
              MOVE 1          TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)       
              MOVE IN-UC-CODE-ITEM-STATUS  (MATCH-IDX)                  
                                  TO UC-CODE-ITEM-STATUS                
           END-IF                                                       
           IF IN-UC-MTHLY-AMOUNT-FIXED (MATCH-IDX)                      
                                    NOT = UC-MTHLY-AMOUNT-FIXED         
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES            TO WS-TABLE-ID (TH-SUB)            
              MOVE 'MTHLY AMT FIXED' TO WS-COLUMN-DESC  (TH-SUB)        
              MOVE UC-MTHLY-AMOUNT-FIXED                                
                                     TO WS-EDIT-DEC-THREE               
              MOVE WS-EDIT-DEC-THREE TO WS-PRV-COLUMN-VALUE-TXT         
                                                     (TH-SUB)           
              MOVE 10         TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)       
              MOVE IN-UC-MTHLY-AMOUNT-FIXED  (MATCH-IDX)                
                                       TO WS-EDIT-DEC-THREE             
              MOVE WS-EDIT-DEC-THREE TO WS-CHG-COLUMN-VALUE-TXT         
                                                     (TH-SUB)           
              MOVE 10         TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)       
              MOVE IN-UC-MTHLY-AMOUNT-FIXED (MATCH-IDX)                 
                                      TO UC-MTHLY-AMOUNT-FIXED          
           END-IF.                                                      
                                                                        
       4220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       4230-TH-FOR-UC-DEL.                                              
      *================================================================*        
                                                                        
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE SPACES             TO WS-TABLE-ID (TH-SUB)              
           MOVE 'RATE ITEM CODE'   TO WS-COLUMN-DESC  (TH-SUB)          
           MOVE UC-RATE-ITEM-CODE       TO WS-EDIT-DEC-ZERO             
           MOVE WS-EDIT-DEC-ZERO        TO WS-PRV-COLUMN-VALUE-TXT      
                                                    (TH-SUB)            
           MOVE 4          TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)          
           MOVE 'DELETE'                TO WS-CHG-COLUMN-VALUE-TXT      
                                                    (TH-SUB)            
           MOVE 6          TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)          
           IF UC-NO-UNITS > ZERO                                        
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES         TO WS-TABLE-ID (TH-SUB)               
              MOVE 'NO UNITS'     TO WS-COLUMN-DESC  (TH-SUB)           
              MOVE UC-NO-UNITS    TO WS-EDIT-DEC-ZERO                   
              MOVE WS-EDIT-DEC-ZERO  TO WS-PRV-COLUMN-VALUE-TXT         
                                                      (TH-SUB)          
              MOVE 10             TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)   
              MOVE 'DELETE'       TO WS-CHG-COLUMN-VALUE-TXT            
                                                      (TH-SUB)          
              MOVE 6              TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)   
           END-IF                                                       
           IF UC-NO-DAYS > ZERO                                         
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES         TO WS-TABLE-ID (TH-SUB)               
              MOVE 'NO DAYS'      TO WS-COLUMN-DESC  (TH-SUB)           
              MOVE UC-NO-DAYS     TO WS-EDIT-DEC-ZERO                   
              MOVE WS-EDIT-DEC-ZERO  TO WS-PRV-COLUMN-VALUE-TXT         
                                                      (TH-SUB)          
              MOVE 10             TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)   
              MOVE 'DELETE'       TO WS-CHG-COLUMN-VALUE-TXT            
                                                      (TH-SUB)          
              MOVE 6              TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)   
           END-IF                                                       
           IF UC-USAGE-FIXED > ZERO                                     
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES            TO WS-TABLE-ID (TH-SUB)            
              MOVE 'FIXED USAGE'     TO WS-COLUMN-DESC  (TH-SUB)        
              MOVE UC-USAGE-FIXED    TO WS-EDIT-DEC-THREE               
              MOVE WS-EDIT-DEC-THREE TO WS-PRV-COLUMN-VALUE-TXT         
                                                   (TH-SUB)             
              MOVE 10                TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)
              MOVE 'DELETE'          TO WS-CHG-COLUMN-VALUE-TXT         
                                                         (TH-SUB)       
              MOVE 6                 TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)
           END-IF                                                       
           IF UC-DATE-USAGE-ENDS > SPACES                               
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES               TO WS-TABLE-ID (TH-SUB)         
              MOVE 'DATE USG ENDS'      TO WS-COLUMN-DESC  (TH-SUB)     
              MOVE UC-DATE-USAGE-ENDS   TO WS-PRV-COLUMN-VALUE-TXT      
                                                        (TH-SUB)        
              MOVE 10                TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)
              MOVE 'DELETE'             TO WS-CHG-COLUMN-VALUE-TXT      
                                                      (TH-SUB)          
              MOVE 6                 TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)
           END-IF                                                       
           IF UC-CODE-ITEM-STATUS > SPACES                              
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE SPACES             TO WS-TABLE-ID (TH-SUB)           
              MOVE 'CODE ITEM STATUS' TO WS-COLUMN-DESC (TH-SUB)        
              MOVE UC-CODE-ITEM-STATUS  TO WS-PRV-COLUMN-VALUE-TXT      
                                                      (TH-SUB)          
              MOVE 1                 TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)
              MOVE 'DELETE'             TO WS-CHG-COLUMN-VALUE-TXT      
                                                      (TH-SUB)          
              MOVE 6                 TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)
           END-IF.                                                      
       4230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       4250-PROCESS-UC-NEW-ROWS.                                        
      *================================================================*        
                                                                        
           MOVE IN-UC-CODE-DEBIT-CREDIT (IN-UC-IDX)                     
                                              TO UC-CODE-DEBIT-CREDIT   
           MOVE WS-A TO UC-CODE-SOURCE-ID                               
           MOVE IN-UC-CODE-ITEM-STATUS (IN-UC-IDX)                      
                                              TO UC-CODE-ITEM-STATUS    
           MOVE IN-UC-DATE-USAGE-ENDS (IN-UC-IDX)                       
                                              TO UC-DATE-USAGE-ENDS     
           MOVE IN-UC-NO-DAYS (IN-UC-IDX)     TO UC-NO-DAYS             
           MOVE IN-UC-RATE-ITEM-CODE (IN-UC-IDX)                        
                                              TO UC-RATE-ITEM-CODE      
      *** GET MAX SEQ                                                           
           MOVE IN-UC-ITEM-SEQ-NO (IN-UC-IDX) TO UC-ITEM-SEQ-NO         
           MOVE IN-UC-CODE-SERVICE-TYPE (IN-UC-IDX)                     
                                              TO UC-CODE-SERVICE-TYPE   
           MOVE IN-UC-MTHLY-AMOUNT-FIXED (IN-UC-IDX)                    
                                              TO UC-MTHLY-AMOUNT-FIXED  
           MOVE IN-UC-USAGE-FIXED (IN-UC-IDX) TO UC-USAGE-FIXED         
           MOVE IN-UC-NO-UNITS (IN-UC-IDX)    TO UC-NO-UNITS            
           MOVE SPACES                        TO UC-DIST-NO             
                                                 UC-POLE-NO             
           MOVE ZEROS                         TO UC-LIGHT-NO            
                                                                        
           PERFORM 8772-INSERT-UC       THRU 8772-EXIT.                 
                                                                        
           IF PARM-PERMANENT-UPDATE = 'Y' OR                            
              IN-UC-PERMANENT-UPDATE (IN-UC-IDX) = 'Y'                  
              PERFORM 4710-UPD-CUST-PLAN   THRU 4710-EXIT               
           END-IF.                                                      
                                                                        
       4250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       4300-PROCESS-FH-RBILL.                                           
      *================================================================*        
                                                                        
           MOVE ZEROS TO MATCH-IDX                                      
           PERFORM VARYING IN-FH-IDX FROM 1 BY 1                        
SCA006        UNTIL MATCH-IDX > 0 OR 
                    IN-FH-IDX > 100 OR 
                    IN-FH-CHANGE-INDICATOR (IN-FH-IDX) = SPACES                 
              IF FH-FIXED-FCTR-SEQ-NO = IN-FH-FIXED-FCTR-SEQ-NO         
                                                (IN-FH-IDX)             
                 MOVE IN-FH-IDX                  TO MATCH-IDX           
              END-IF                                                    
           END-PERFORM.                                                 
           IF MATCH-IDX = 0                                             
              MOVE WS-RB-BILL-NO              TO FH-BILL-NO             
              MOVE WS-RB-ITEM-TIMESTMP        TO FH-BILL-ITEM-TIMESTMP  
A05460        IF WS-FH-FIXED-FCTR-SEQ-NO > 0                            
A05460           COMPUTE FH-FIXED-FCTR-SEQ-NO = FH-FIXED-FCTR-SEQ-NO    
A05460                                        + WS-FH-FIXED-FCTR-SEQ-NO 
A05460        END-IF                                                    
              PERFORM 4340-PROCESS-FH-COPY    THRU 4340-EXIT            
           ELSE                                                         
              MOVE WS-RB-BILL-NO              TO FH-BILL-NO             
              MOVE WS-RB-ITEM-TIMESTMP        TO FH-BILL-ITEM-TIMESTMP  
              PERFORM 4310-FH-RBILL-CHANGES THRU 4310-EXIT              
           END-IF                                                       
           PERFORM 7495-FETCH-FH-MAINT-CRSR THRU 7495-EXIT.             
                                                                        
       4300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       4310-FH-RBILL-CHANGES.                                           
      *================================================================*        
                                                                        
           MOVE 'P'               TO IN-FH-PROCESS-CD (MATCH-IDX)       
           EVALUATE TRUE                                                
              WHEN IN-FH-CHANGE-INDICATOR (MATCH-IDX) = 'U'             
                 IF (PARM-COPY-CX-DATA  = 'N'                           
                  AND WS-MTR-READ-SOURCE-CD = 'M'                       
                  AND FH-FACTOR-ID (1:1) = ('&' OR '$'))                
                  OR WS-FACTOR-HISTORY-CD NOT = 'R'                     
                    CONTINUE                                            
                 ELSE                                                   
                    PERFORM 4320-TH-FOR-FH-UPD  THRU 4320-EXIT          
                    MOVE WS-RB-BILL-NO           TO UC-BILL-NO          
                    MOVE WS-RB-ITEM-TIMESTMP   TO UC-BILL-ITEM-TIMESTMP 
                    PERFORM 8774-INSERT-FH       THRU 8774-EXIT         
                 END-IF                                                 
              WHEN IN-FH-CHANGE-INDICATOR (MATCH-IDX) = 'D'             
                 PERFORM 4330-TH-FOR-FH-DEL  THRU 4330-EXIT             
              WHEN OTHER                                                
                 MOVE 'CR00009999'            TO RS-BUS-RULE-ID         
                 PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT        
           END-EVALUATE.                                                
       4310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       4320-TH-FOR-FH-UPD.                                              
      *================================================================*        
           IF IN-FH-FACTOR (MATCH-IDX) NOT = FH-FACTOR                  
A05460     OR IN-FH-CODE-DEBIT-CREDIT (MATCH-IDX) NOT =                 
A05460                                       FH-CODE-DEBIT-CREDIT       
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE '  '                  TO WS-TABLE-ID (TH-SUB)        
              MOVE 'FACTOR-VALUE'        TO WS-COLUMN-DESC (TH-SUB)     
                                                                        
A05460        MOVE FH-FACTOR             TO WS-FACTOR-FH-TEMP           
A05460        IF FH-CODE-DEBIT-CREDIT = 'C'                             
A05460           COMPUTE WS-FACTOR-FH-TEMP = WS-FACTOR-FH-TEMP * -1     
A05460        END-IF                                                    
A05460        MOVE WS-FACTOR-FH-TEMP     TO WS-DISPLAY-DEC-FOUR         
              MOVE WS-DISPLAY-DEC-FOUR   TO WS-PRV-COLUMN-VALUE-TXT     
                                                     (TH-SUB)           
A05460        MOVE 15                TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)
A05460        MOVE IN-FH-FACTOR (MATCH-IDX)                             
A05460                                   TO WS-FACTOR-FH-TEMP           
A05460        IF IN-FH-CODE-DEBIT-CREDIT (MATCH-IDX) = 'C'              
A05460           COMPUTE WS-FACTOR-FH-TEMP = WS-FACTOR-FH-TEMP * -1     
A05460        END-IF                                                    
              MOVE WS-FACTOR-FH-TEMP     TO WS-DISPLAY-DEC-FOUR         
              MOVE WS-DISPLAY-DEC-FOUR   TO WS-CHG-COLUMN-VALUE-TXT     
                                                      (TH-SUB)          
A05460        MOVE 15                TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)
              MOVE IN-FH-FACTOR (MATCH-IDX)     TO FH-FACTOR            
A05460        MOVE IN-FH-CODE-DEBIT-CREDIT (MATCH-IDX)                  
A05460                                          TO FH-CODE-DEBIT-CREDIT 
           END-IF                                                       
           IF IN-FH-BLOCK-NO (MATCH-IDX)   NOT = FH-BLOCK-NO            
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE '  '                  TO WS-TABLE-ID (TH-SUB)        
              MOVE 'BLOCK NO'          TO WS-COLUMN-DESC (TH-SUB)       
              MOVE FH-BLOCK-NO           TO WS-EDIT-DEC-ZERO            
              MOVE WS-EDIT-DEC-ZERO      TO WS-PRV-COLUMN-VALUE-TXT     
                                                      (TH-SUB)          
              MOVE 4                 TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)
              MOVE IN-FH-BLOCK-NO (MATCH-IDX) TO WS-EDIT-DEC-ZERO       
              MOVE WS-EDIT-DEC-ZERO      TO WS-CHG-COLUMN-VALUE-TXT     
                                                     (TH-SUB)           
              MOVE 4                 TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)
              MOVE IN-FH-BLOCK-NO (MATCH-IDX) TO FH-BLOCK-NO            
           END-IF                                                       
           IF IN-FH-EFF-DATE-FROM (MATCH-IDX) NOT = FH-EFF-DATE-FROM    
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE '  '                  TO WS-TABLE-ID (TH-SUB)        
              MOVE 'DATE FROM'        TO WS-COLUMN-DESC  (TH-SUB)       
              MOVE FH-EFF-DATE-FROM     TO WS-PRV-COLUMN-VALUE-TXT      
                                                   (TH-SUB)             
              MOVE 10                TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)
              MOVE IN-FH-EFF-DATE-FROM (MATCH-IDX)                      
                                        TO WS-CHG-COLUMN-VALUE-TXT      
                                                   (TH-SUB)             
              MOVE 10                TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)
              MOVE IN-FH-EFF-DATE-FROM (MATCH-IDX)                      
                                     TO FH-EFF-DATE-FROM                
           END-IF                                                       
           IF IN-FH-EFF-DATE-TO (MATCH-IDX) NOT = FH-EFF-DATE-TO        
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE '  '                  TO WS-TABLE-ID (TH-SUB)        
              MOVE 'DATE TO'          TO WS-COLUMN-DESC (TH-SUB)        
              MOVE FH-EFF-DATE-TO           TO WS-PRV-COLUMN-VALUE-TXT  
                                                   (TH-SUB)             
              MOVE 10                TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)
              MOVE IN-FH-EFF-DATE-TO (MATCH-IDX)                        
                                            TO WS-CHG-COLUMN-VALUE-TXT  
                                                   (TH-SUB)             
              MOVE 10                TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)
              MOVE IN-FH-EFF-DATE-TO (MATCH-IDX)                        
                                            TO FH-EFF-DATE-TO           
           END-IF                                                       
           IF IN-FH-CODE-SEASON (IN-FH-IDX) NOT = FH-CODE-SEASON        
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE '42'                  TO WS-TABLE-ID (TH-SUB)        
              MOVE 'SEASON CODE'      TO WS-COLUMN-DESC (TH-SUB)        
              MOVE FH-CODE-SEASON        TO WS-PRV-COLUMN-VALUE-TXT     
                                                   (TH-SUB)             
              MOVE 1                 TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)
              MOVE IN-FH-CODE-SEASON (IN-FH-IDX)                        
                                         TO WS-CHG-COLUMN-VALUE-TXT     
                                                   (TH-SUB)             
              MOVE 1                 TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)
              MOVE IN-FH-CODE-SEASON (IN-FH-IDX) TO FH-CODE-SEASON      
           END-IF                                                       
           IF IN-FH-INSTR-USE-TYPE-CD (MATCH-IDX) NOT =                 
                                           FH-INSTR-USE-TYPE-CD         
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE '43'                  TO WS-TABLE-ID (TH-SUB)        
              MOVE 'INSTR CODE'       TO WS-COLUMN-DESC (TH-SUB)        
              MOVE FH-INSTR-USE-TYPE-CD  TO WS-PRV-COLUMN-VALUE-TXT     
                                                   (TH-SUB)             
              MOVE 1                 TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)
              MOVE IN-FH-INSTR-USE-TYPE-CD (MATCH-IDX)                  
                                         TO WS-CHG-COLUMN-VALUE-TXT     
                                              (TH-SUB)                  
              MOVE 1                 TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)
              MOVE IN-FH-INSTR-USE-TYPE-CD (MATCH-IDX)                  
                                         TO FH-INSTR-USE-TYPE-CD        
           END-IF                                                       
           IF IN-FH-CODE-TIME-PERIOD (MATCH-IDX) NOT =                  
                                         FH-CODE-TIME-PERIOD            
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE '44'                  TO WS-TABLE-ID (TH-SUB)        
              MOVE 'TIME PERIOD'         TO WS-COLUMN-DESC (TH-SUB)     
              MOVE FH-CODE-TIME-PERIOD        TO WS-EDIT-DEC-ZERO       
              MOVE WS-EDIT-DEC-ZERO           TO WS-PRV-COLUMN-VALUE-TXT
                                                   (TH-SUB)             
              MOVE 4                 TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)
              MOVE IN-FH-CODE-TIME-PERIOD (MATCH-IDX)                   
                                              TO WS-EDIT-DEC-ZERO       
              MOVE WS-EDIT-DEC-ZERO           TO WS-CHG-COLUMN-VALUE-TXT
                                                   (TH-SUB)             
              MOVE 4                 TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)
              MOVE IN-FH-CODE-TIME-PERIOD (MATCH-IDX)                   
                                                TO FH-CODE-TIME-PERIOD  
           END-IF                                                       
           IF IN-FH-CMPNT-ID-CD (MATCH-IDX) NOT = FH-CMPNT-ID-CD        
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE 'N6'                  TO WS-TABLE-ID (TH-SUB)        
              MOVE 'COMPONENT ID'        TO WS-COLUMN-DESC (TH-SUB)     
              MOVE FH-CMPNT-ID-CD        TO WS-PRV-COLUMN-VALUE-TXT     
                                                   (TH-SUB)             
              MOVE 1                 TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)
              MOVE IN-FH-CMPNT-ID-CD (MATCH-IDX)                        
                                         TO WS-CHG-COLUMN-VALUE-TXT     
                                                   (TH-SUB)             
              MOVE 1                 TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)
              MOVE IN-FH-CMPNT-ID-CD (MATCH-IDX) TO FH-CMPNT-ID-CD      
           END-IF                                                       
           IF IN-FH-FIXED-FCTR-TYP-CD (MATCH-IDX) NOT =                 
                                              FH-FIXED-FCTR-TYP-CD      
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE 'FT'                  TO WS-TABLE-ID (TH-SUB)        
              MOVE 'FXD FCTR TYP CD'     TO WS-COLUMN-DESC (TH-SUB)     
              MOVE FH-FIXED-FCTR-TYP-CD  TO WS-PRV-COLUMN-VALUE-TXT     
                                                   (TH-SUB)             
              MOVE 2                 TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)
              MOVE IN-FH-FIXED-FCTR-TYP-CD (MATCH-IDX)                  
                                         TO WS-CHG-COLUMN-VALUE-TXT     
                                                   (TH-SUB)             
              MOVE 2                 TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)
              MOVE IN-FH-FIXED-FCTR-TYP-CD (MATCH-IDX)                  
                                         TO FH-FIXED-FCTR-TYP-CD        
           END-IF.                                                      
           IF FH-FCTR-POWER-10 NOT = IN-FH-FCTR-POWER-10 (MATCH-IDX)    
              MOVE IN-FH-FCTR-POWER-10 (MATCH-IDX)                      
                                     TO FH-FCTR-POWER-10                
           END-IF.                                                      
                                                                        
       4320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       4330-TH-FOR-FH-DEL.                                              
      *================================================================*        
                                                                        
      ***  FACTOR                                                               
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE '  '                  TO WS-TABLE-ID (TH-SUB)           
           MOVE 'FACTOR-VALUE'        TO WS-COLUMN-DESC (TH-SUB)        
                                                                        
           MOVE FH-FACTOR             TO WS-EDIT-DEC-THREE              
           MOVE WS-EDIT-DEC-THREE     TO WS-PRV-COLUMN-VALUE-TXT        
                                                  (TH-SUB)              
           MOVE 13                TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)   
           MOVE '**DELETED**'         TO WS-CHG-COLUMN-VALUE-TXT        
                                                   (TH-SUB)             
           MOVE 11                TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)   
      ***  BLOCK NO                                                             
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE '  '                  TO WS-TABLE-ID (TH-SUB)           
           MOVE 'BLOCK NO'            TO WS-COLUMN-DESC (TH-SUB)        
           MOVE FH-BLOCK-NO           TO WS-EDIT-DEC-ZERO               
           MOVE WS-EDIT-DEC-ZERO      TO WS-PRV-COLUMN-VALUE-TXT        
                                                   (TH-SUB)             
           MOVE 4                 TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)   
           MOVE '**DELETED**'         TO WS-CHG-COLUMN-VALUE-TXT        
                                                  (TH-SUB)              
           MOVE 11                TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)   
      ***  DATE FROM                                                            
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE '  '                  TO WS-TABLE-ID (TH-SUB)           
           MOVE 'DATE FROM'          TO WS-COLUMN-DESC (TH-SUB)         
           MOVE FH-EFF-DATE-FROM     TO WS-PRV-COLUMN-VALUE-TXT         
                                                (TH-SUB)                
           MOVE 10                TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)   
           MOVE '**DELETED**'        TO WS-CHG-COLUMN-VALUE-TXT         
                                                (TH-SUB)                
           MOVE 11                TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)   
      ***  DATE FROM                                                            
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE '  '                  TO WS-TABLE-ID (TH-SUB)           
           MOVE 'DATE TO'                TO WS-COLUMN-DESC (TH-SUB)     
           MOVE FH-EFF-DATE-TO           TO WS-PRV-COLUMN-VALUE-TXT     
                                                (TH-SUB)                
           MOVE 10                TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)   
           MOVE '**DELETED**'            TO WS-CHG-COLUMN-VALUE-TXT     
                                                (TH-SUB)                
           MOVE 11                TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)   
      ***  SEASON CODE                                                          
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE '42'                  TO WS-TABLE-ID (TH-SUB)           
           MOVE 'SEASON CODE'         TO WS-COLUMN-DESC (TH-SUB)        
           MOVE FH-CODE-SEASON        TO WS-PRV-COLUMN-VALUE-TXT        
                                                (TH-SUB)                
           MOVE 1                 TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)   
           MOVE '**DELETED**'         TO WS-CHG-COLUMN-VALUE-TXT        
                                                (TH-SUB)                
           MOVE 11                TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)   
      ***  INSTR CODE                                                           
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE '43'                  TO WS-TABLE-ID (TH-SUB)           
           MOVE 'INSTR CODE'          TO WS-COLUMN-DESC (TH-SUB)        
           MOVE FH-INSTR-USE-TYPE-CD  TO WS-PRV-COLUMN-VALUE-TXT        
                                                (TH-SUB)                
           MOVE 1                 TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)   
           MOVE '**DELETED**'         TO WS-CHG-COLUMN-VALUE-TXT        
                                                (TH-SUB)                
           MOVE 11                TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)   
      ***  TIME PERIOD                                                          
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE '44'                  TO WS-TABLE-ID (TH-SUB)           
           MOVE 'TIME PERIOD'         TO WS-COLUMN-DESC (TH-SUB)        
           MOVE FH-CODE-TIME-PERIOD        TO WS-EDIT-DEC-THREE         
           MOVE WS-EDIT-DEC-THREE          TO WS-PRV-COLUMN-VALUE-TXT   
                                                (TH-SUB)                
           MOVE 4                 TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)   
           MOVE '**DELETED**'              TO WS-CHG-COLUMN-VALUE-TXT   
                                                (TH-SUB)                
           MOVE 11                TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)   
      ***  COMPONENT ID                                                         
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE 'N6'                  TO WS-TABLE-ID (TH-SUB)           
           MOVE 'COMPONENT ID'        TO WS-COLUMN-DESC (TH-SUB)        
           MOVE FH-CMPNT-ID-CD        TO WS-PRV-COLUMN-VALUE-TXT        
                                                (TH-SUB)                
           MOVE 1                 TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)   
           MOVE '**DELETED**'         TO WS-CHG-COLUMN-VALUE-TXT        
                                                (TH-SUB)                
           MOVE 11                TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)   
      ***  FXD FCTR TYP CD                                                      
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE 'FT'                  TO WS-TABLE-ID (TH-SUB)           
           MOVE 'FXD FCTR TYP CD'     TO WS-COLUMN-DESC (TH-SUB)        
           MOVE FH-FIXED-FCTR-TYP-CD  TO WS-PRV-COLUMN-VALUE-TXT        
                                                (TH-SUB)                
           MOVE 2                 TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)   
           MOVE '**DELETED**'         TO WS-CHG-COLUMN-VALUE-TXT        
                                                (TH-SUB).               
           MOVE 11                TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB).  
                                                                        
       4330-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *================================================================*        
       4340-PROCESS-FH-COPY.                                            
      *================================================================*        
           IF (PARM-COPY-IDR-DATA  = ('2' OR '3')                       
              AND FH-FACTOR-ID (1:1) = ('&' OR '$'))                    
              OR WS-FACTOR-HISTORY-CD NOT = 'R'                         
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-RB-BILL-NO              TO FH-BILL-NO             
              MOVE WS-RB-ITEM-TIMESTMP        TO FH-BILL-ITEM-TIMESTMP  
              PERFORM 8774-INSERT-FH          THRU 8774-EXIT            
      *** RE-CHECK BELOW CODE LATER                                             
              IF SF-SPCL-GROUP-CD = WS-INTRO-VAR-FCTR                   
                 AND BILL-CANCEL-REBILL                                 
                 AND ( BILL-WHEN-IMMIDIATE                              
                       OR BILL-WHEN-FUTURE )                            
      ***        AND IN-NO-ROWS > ZEROES                                        
      ***        IF IN-NO-OF-CONS-DAYS NOT EQUAL WS-TOT-NO-DAYS                 
                    SET INTRO-FCTR-EXISTS TO TRUE                       
      ***        END-IF                                                         
              END-IF                                                    
                                                                        
           END-IF.                                                      
                                                                        
       4340-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       4350-PROCESS-FH-NEW-ROWS.                                        
      *================================================================*        
                                                                        
           MOVE IN-FH-FACTOR-ID (IN-FH-IDX)    TO FH-FACTOR-ID          
                                                  SF-FACTOR-ID          
           MOVE IN-FH-CMPNT-ID-CD (IN-FH-IDX)  TO FH-CMPNT-ID-CD        
           MOVE IN-FH-CODE-SEASON (IN-FH-IDX)  TO FH-CODE-SEASON        
           MOVE IN-FH-INSTR-USE-TYPE-CD (IN-FH-IDX)                     
                                               TO FH-INSTR-USE-TYPE-CD  
           MOVE IN-FH-CODE-TIME-PERIOD (IN-FH-IDX)                      
                                               TO FH-CODE-TIME-PERIOD   
           MOVE IN-CODE-REVENUE-CLASS          TO FH-CODE-REVENUE-CLASS 
           MOVE IN-FH-EFF-DATE-TO (IN-FH-IDX)  TO FH-EFF-DATE-TO        
           MOVE ZERO                           TO WS-EFF-DATE-TO-NULL   
           MOVE IN-FH-EFF-DATE-FROM (IN-FH-IDX)                         
                                               TO FH-EFF-DATE-FROM      
           MOVE ZERO                           TO WS-EFF-DATE-FROM-NULL 
           MOVE IN-FH-FIXED-FCTR-TYP-CD (IN-FH-IDX)                     
                                               TO FH-FIXED-FCTR-TYP-CD  
           MOVE ZERO                           TO FH-BILL-UNITS         
           MOVE SPACES                         TO FH-ENERGY-UNIT-CD     
           MOVE 'N'                            TO FH-OVR-RT-VER-PRO-FL  
      *** CHECK HOW TO GET THIS.                                                
           IF IN-FH-DURATION-REMAIN-NO (IN-FH-IDX) IS NUMERIC           
              MOVE IN-FH-DURATION-REMAIN-NO (IN-FH-IDX)                 
                                              TO FH-DURATION-REMAIN-NO  
              MOVE ZERO                       TO WS-DURATION-NULL       
           ELSE                                                         
              MOVE ZEROS                      TO FH-DURATION-REMAIN-NO  
              MOVE -1                         TO WS-DURATION-NULL       
           END-IF                                                       
      *** CHECK HOW TO GET THIS. IT SHOULD GET FROM BG                          
           MOVE IN-RT-PKG-OPT-SEQ-NO                                    
                                               TO FH-RT-PKG-OPT-SEQ-NO  
           PERFORM 7680-GET-NEW-FCT-HIST-SEQ   THRU 7680-EXIT           
           PERFORM 7681-GET-XMT-VALUES         THRU 7681-EXIT           
           MOVE IN-FH-CODE-DEBIT-CREDIT (IN-FH-IDX)                     
                                               TO FH-CODE-DEBIT-CREDIT  
           MOVE SF-CODE-TAX-STAT-XMT           TO FH-CODE-TAX-STAT-XMT  
           MOVE SF-CODE-TAX-CITY-XMT           TO FH-CODE-TAX-CITY-XMT  
ACT004     MOVE SPACES                         TO FH-CODE-TAX-OTHR-XMT  
           MOVE IN-FH-BLOCK-NO (IN-FH-IDX)     TO FH-BLOCK-NO           
           MOVE IN-FH-FACTOR (IN-FH-IDX)        TO FH-FACTOR            
           MOVE IN-FH-FCTR-POWER-10 (IN-FH-IDX) TO FH-FCTR-POWER-10     
           IF FH-FACTOR-ID = 'DDC'                                      
              PERFORM 4360-CHECK-DDC-MIN-MAX   THRU 4360-EXIT           
           END-IF                                                       
           IF IN-FH-APPLY-ALL-REBILLS (IN-FH-IDX) = 'Y'                 
              MOVE FH-BILL-NO                 TO WS-BILL-NO1            
              MOVE FH-BILL-ITEM-TIMESTMP      TO WS-BILL-ITEM-TIMESTMP1 
              PERFORM 7330-CHECK-FH-EXISTS     THRU 7330-EXIT           
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 PERFORM 4355-TH-FOR-FH-INS       THRU 4355-EXIT        
                 PERFORM 8774-INSERT-FH           THRU 8774-EXIT        
              END-IF                                                    
              PERFORM 7300-OPEN-REBILL-CSR     THRU 7300-EXIT           
              PERFORM 7310-FETCH-REBILL-CSR    THRU 7310-EXIT           
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
                 PERFORM 7330-CHECK-FH-EXISTS     THRU 7330-EXIT        
                 IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                    MOVE WS-BILL-NO1            TO FH-BILL-NO           
                    MOVE WS-BILL-ITEM-TIMESTMP1 TO FH-BILL-ITEM-TIMESTMP
                    PERFORM 7680-GET-NEW-FCT-HIST-SEQ THRU 7680-EXIT    
                    PERFORM 8774-INSERT-FH        THRU 8774-EXIT        
                 END-IF                                                 
                 PERFORM 7310-FETCH-REBILL-CSR    THRU 7310-EXIT        
              END-PERFORM                                               
              PERFORM 7320-CLOSE-REBILL-CSR    THRU 7320-EXIT           
           ELSE                                                         
              PERFORM 4355-TH-FOR-FH-INS          THRU 4355-EXIT        
              PERFORM 8774-INSERT-FH              THRU 8774-EXIT        
           END-IF.                                                      
                                                                        
       4350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       4355-TH-FOR-FH-INS.                                              
      *================================================================*        
                                                                        
      ***  FACTOR                                                               
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE '  '                  TO WS-TABLE-ID (TH-SUB)           
           MOVE 'FACTOR-VALUE'        TO WS-COLUMN-DESC (TH-SUB)        
                                                                        
           MOVE '**INSERTED**'        TO WS-PRV-COLUMN-VALUE-TXT        
                                                  (TH-SUB)              
           MOVE 12                TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)   
           MOVE FH-FACTOR             TO WS-EDIT-DEC-THREE              
           MOVE WS-EDIT-DEC-THREE     TO WS-CHG-COLUMN-VALUE-TXT        
                                                   (TH-SUB)             
           MOVE 13                TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)   
      ***  BLOCK NO                                                             
           IF FH-BLOCK-NO > 0                                           
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE '  '                  TO WS-TABLE-ID (TH-SUB)        
              MOVE 'BLOCK NO'            TO WS-COLUMN-DESC (TH-SUB)     
              MOVE '**INSERTED**'        TO WS-PRV-COLUMN-VALUE-TXT     
                                                      (TH-SUB)          
              MOVE 12                TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)
              MOVE FH-BLOCK-NO           TO WS-EDIT-DEC-THREE           
              MOVE WS-EDIT-DEC-THREE     TO WS-CHG-COLUMN-VALUE-TXT     
                                                     (TH-SUB)           
              MOVE 4                 TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)
           END-IF.                                                      
      ***  DATE FROM                                                            
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE '  '                  TO WS-TABLE-ID (TH-SUB)           
           MOVE 'DATE FROM'          TO WS-COLUMN-DESC (TH-SUB)         
           MOVE '**INSERTED**'       TO WS-PRV-COLUMN-VALUE-TXT         
                                                (TH-SUB)                
           MOVE 12                TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)   
           MOVE FH-EFF-DATE-FROM     TO WS-CHG-COLUMN-VALUE-TXT         
                                                (TH-SUB)                
           MOVE 10                TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)   
      ***  DATE TO                                                              
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE '  '                  TO WS-TABLE-ID (TH-SUB)           
           MOVE 'DATE TO'             TO WS-COLUMN-DESC (TH-SUB)        
           MOVE '**INSERTED**'           TO WS-PRV-COLUMN-VALUE-TXT     
                                                (TH-SUB)                
           MOVE 12                TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)   
           MOVE FH-EFF-DATE-TO           TO WS-CHG-COLUMN-VALUE-TXT     
                                                (TH-SUB)                
           MOVE 10                TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)   
      ***  SEASON CODE                                                          
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE '42'                  TO WS-TABLE-ID (TH-SUB)           
           MOVE 'SEASON CODE'         TO WS-COLUMN-DESC (TH-SUB)        
           MOVE '**INSERTED**'        TO WS-PRV-COLUMN-VALUE-TXT        
                                                (TH-SUB)                
           MOVE 12                TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)   
           MOVE FH-CODE-SEASON        TO WS-CHG-COLUMN-VALUE-TXT        
                                                (TH-SUB)                
           MOVE 1                 TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)   
      ***  INSTR CODE                                                           
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE '43'                  TO WS-TABLE-ID (TH-SUB)           
           MOVE 'INSTR CODE'          TO WS-COLUMN-DESC (TH-SUB)        
           MOVE '**INSERTED**'        TO WS-PRV-COLUMN-VALUE-TXT        
                                                (TH-SUB)                
           MOVE 12                TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)   
           MOVE FH-INSTR-USE-TYPE-CD  TO WS-CHG-COLUMN-VALUE-TXT        
                                                (TH-SUB)                
           MOVE 1                 TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)   
      ***  TIME PERIOD                                                          
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE '44'                  TO WS-TABLE-ID (TH-SUB)           
           MOVE 'TIME PERIOD'         TO WS-COLUMN-DESC (TH-SUB)        
           MOVE '**INSERTED**'             TO WS-PRV-COLUMN-VALUE-TXT   
                                                (TH-SUB)                
           MOVE 12                TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)   
           MOVE FH-CODE-TIME-PERIOD        TO WS-EDIT-DEC-THREE         
           MOVE WS-EDIT-DEC-THREE          TO WS-CHG-COLUMN-VALUE-TXT   
                                                (TH-SUB)                
           MOVE 4                 TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)   
      ***  COMPONENT ID                                                         
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE 'N6'                  TO WS-TABLE-ID (TH-SUB)           
           MOVE 'COMPONENT ID'        TO WS-COLUMN-DESC (TH-SUB)        
           MOVE '**INSERTED**'        TO WS-PRV-COLUMN-VALUE-TXT        
                                                (TH-SUB)                
           MOVE 12                TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)   
           MOVE FH-CMPNT-ID-CD        TO WS-CHG-COLUMN-VALUE-TXT        
                                                (TH-SUB)                
           MOVE 1                 TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)   
      ***  FXD FCTR TYP CD                                                      
           IF FH-FIXED-FCTR-TYP-CD > SPACES                             
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE 'FT'                  TO WS-TABLE-ID (TH-SUB)        
              MOVE 'FXD FCTR TYP CD'     TO WS-COLUMN-DESC (TH-SUB)     
              MOVE '**INSERTED**'        TO WS-PRV-COLUMN-VALUE-TXT     
                                                   (TH-SUB)             
              MOVE 12                TO WS-PRV-COLUMN-VALUE-LEN (TH-SUB)
              MOVE FH-FIXED-FCTR-TYP-CD  TO WS-CHG-COLUMN-VALUE-TXT     
                                                   (TH-SUB)             
              MOVE 2                 TO WS-CHG-COLUMN-VALUE-LEN (TH-SUB)
           END-IF.                                                      
                                                                        
       4355-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       4360-CHECK-DDC-MIN-MAX.                                          
      *================================================================*        
                                                                        
           MOVE WS-RES-MIN-CD                 TO C8-DELINQ-CD.          
           PERFORM 7990-GET-DELINQUENCY       THRU 7990-EXIT.           
           MOVE C8-DELINQ-VALUE               TO WS-RES-MIN-DDC.        
           MOVE WS-RES-MAX-CD                 TO C8-DELINQ-CD.          
           PERFORM 7990-GET-DELINQUENCY       THRU 7990-EXIT.           
           MOVE C8-DELINQ-VALUE               TO WS-RES-MAX-DDC.        
           MOVE WS-COM-MIN-CD                 TO C8-DELINQ-CD.          
           PERFORM 7990-GET-DELINQUENCY       THRU 7990-EXIT.           
           MOVE C8-DELINQ-VALUE               TO WS-COM-MIN-DDC.        
           MOVE WS-COM-MAX-CD                 TO C8-DELINQ-CD.          
           PERFORM 7990-GET-DELINQUENCY       THRU 7990-EXIT.           
           MOVE C8-DELINQ-VALUE               TO WS-COM-MAX-DDC.        
           IF FH-CODE-REVENUE-CLASS (2:1) = '1'                         
              IF FH-FACTOR < WS-RES-MIN-DDC  OR                         
                           > WS-RES-MAX-DDC                             
                 MOVE 'CR00005313'      TO   RS-BUS-RULE-ID             
                 PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT        
              END-IF                                                    
           END-IF.                                                      
           IF FH-CODE-REVENUE-CLASS (2:1) = '2'                         
              IF FH-FACTOR < WS-COM-MIN-DDC  OR                         
                           > WS-COM-MAX-DDC                             
                 MOVE 'CR00005313'    TO     RS-BUS-RULE-ID             
                 PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
       4360-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *================================================================*        
       4400-PROCESS-BP-RBILL.                                           
      *================================================================*        
                                                                        
           IF BP-ADJ-TYPE-CD = 'BADJ'                                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-RB-BILL-NO         TO BP-BILL-NO                  
              MOVE WS-RB-ITEM-TIMESTMP     TO BP-BILL-ITEM-TIMESTMP     
              EVALUATE TRUE                                             
                 WHEN BP-ADJ-TYPE-CD = 'AGLP'                           
                    MOVE BP-ADJ-TYPE-CD    TO WS-BP-ADJ-TYPE-CD1        
                    MOVE 'NAGL'            TO WS-BP-ADJ-TYPE-CD2        
                 WHEN BP-ADJ-TYPE-CD = 'NAGL'                           
                    MOVE BP-ADJ-TYPE-CD    TO WS-BP-ADJ-TYPE-CD1        
                    MOVE 'AGLP'            TO WS-BP-ADJ-TYPE-CD2        
                 WHEN OTHER                                             
                    MOVE BP-ADJ-TYPE-CD    TO WS-BP-ADJ-TYPE-CD1        
                                              WS-BP-ADJ-TYPE-CD2        
              END-EVALUATE                                              
              PERFORM 7794-SELECT-BP-DATA     THRU 7794-EXIT            
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE WS-ADJ-TYPE-CD       TO BP-ADJ-TYPE-CD            
                 PERFORM 8755-DELETE-BP-HIST  THRU 8755-EXIT            
              END-IF                                                    
              MOVE WS-BP-ADJ-TYPE-CD1      TO BP-ADJ-TYPE-CD            
              PERFORM 7230-INSERT-BILLADJ  THRU 7230-EXIT               
           END-IF.                                                      
                                                                        
           PERFORM 7220-FETCH-BILLADJ-CRSR THRU 7220-EXIT.              
                                                                        
       4400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       4410-PROCESS-BP-CHANGES.                                         
      *================================================================*        
                                                                        
      ***  PERFORM DELETES FIRST                                                
           MOVE ZEROS           TO  MATCH-IDX                           
           PERFORM VARYING IN-BP-IDX FROM 1 BY 1                        
              UNTIL IN-BP-IDX > 100                                     
              OR IN-BP-CHANGE-INDICATOR (IN-BP-IDX) = SPACES            
              MOVE IN-BP-ADJ-TYPE-CD        (IN-BP-IDX)                 
                                              TO BP-ADJ-TYPE-CD         
              MOVE IN-BP-IDX                  TO MATCH-IDX              
              IF IN-BP-CHANGE-INDICATOR (IN-BP-IDX) = 'D'               
                 MOVE BP-ADJ-TYPE-CD          TO WS-BP-ADJ-TYPE-CD1     
                                                 WS-BP-ADJ-TYPE-CD2     
                 PERFORM 7794-SELECT-BP-DATA     THRU 7794-EXIT         
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    PERFORM 4430-TH-FOR-BP-DEL   THRU 4430-EXIT         
                    PERFORM 8755-DELETE-BP-HIST  THRU 8755-EXIT         
                 END-IF                                                 
                 MOVE 'P'   TO IN-BP-PROCESS-CD  (IN-BP-IDX)            
              END-IF                                                    
           END-PERFORM                                                  
      ***  PERFORM UPDATES 2ND                                                  
           PERFORM VARYING IN-BP-IDX FROM 1 BY 1                        
              UNTIL IN-BP-IDX > 100                                     
              OR IN-BP-CHANGE-INDICATOR (IN-BP-IDX) = SPACES            
              MOVE IN-BP-ADJ-TYPE-CD        (IN-BP-IDX)                 
                                              TO BP-ADJ-TYPE-CD         
              MOVE IN-BP-IDX                  TO MATCH-IDX              
              IF IN-BP-CHANGE-INDICATOR (IN-BP-IDX) = 'U'               
                 MOVE BP-ADJ-TYPE-CD          TO WS-BP-ADJ-TYPE-CD1     
                                                 WS-BP-ADJ-TYPE-CD2     
                 PERFORM 7794-SELECT-BP-DATA     THRU 7794-EXIT         
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    PERFORM 4420-TH-FOR-BP-UPD  THRU 4420-EXIT          
                    MOVE WS-ADJ-TYPE-CD       TO BP-ADJ-TYPE-CD         
                    PERFORM 8755-DELETE-BP-HIST  THRU 8755-EXIT         
                    MOVE IN-BP-ADJ-TYPE-CD (MATCH-IDX)                  
                                           TO BP-ADJ-TYPE-CD            
                    MOVE IN-BP-REVENUE-MONTH (MATCH-IDX)                
                                           TO BP-REVENUE-MONTH          
                    MOVE IN-BP-OVRRIDE-RT-REV-MTH (MATCH-IDX)           
                                           TO BP-OVRRIDE-RT-REV-MTH     
                    MOVE SPACES            TO BP-OVRRIDE-RT-BILL-CY     
                    MOVE -1                TO WS-OVRD-BILL-DT-NULL      
                    MOVE IN-BP-SPECIAL-PROCESS-CD (MATCH-IDX)           
                                           TO BP-SPECIAL-PROCESS-CD     
                    MOVE ZERO              TO BP-ADJ-REASON-DESC-LEN    
                    MOVE SPACES            TO BP-ADJ-REASON-DESC-TEXT   
                    PERFORM 7230-INSERT-BILLADJ THRU 7230-EXIT          
                 END-IF                                                 
                 MOVE 'P'   TO IN-BP-PROCESS-CD  (IN-BP-IDX)            
              END-IF                                                    
           END-PERFORM                                                  
      ***  PERFORM INSERTS 3RD                                                  
           PERFORM VARYING IN-BP-IDX FROM 1 BY 1                        
              UNTIL IN-BP-IDX > 100                                     
              OR IN-BP-CHANGE-INDICATOR (IN-BP-IDX) = SPACES            
              MOVE IN-BP-ADJ-TYPE-CD        (IN-BP-IDX)                 
                                              TO BP-ADJ-TYPE-CD         
              MOVE IN-BP-IDX                  TO MATCH-IDX              
              IF IN-BP-CHANGE-INDICATOR (IN-BP-IDX) = 'I'               
                 MOVE BP-ADJ-TYPE-CD          TO WS-BP-ADJ-TYPE-CD1     
                                                 WS-BP-ADJ-TYPE-CD2     
                 PERFORM 7794-SELECT-BP-DATA     THRU 7794-EXIT         
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    MOVE WS-ADJ-TYPE-CD       TO BP-ADJ-TYPE-CD         
                    PERFORM 8755-DELETE-BP-HIST  THRU 8755-EXIT         
                 END-IF                                                 
      ***        PERFORM 4420-TH-FOR-BP-UPD  THRU 4420-EXIT                     
                 MOVE IN-BP-ADJ-TYPE-CD (MATCH-IDX)                     
                                        TO BP-ADJ-TYPE-CD               
                 MOVE IN-BP-REVENUE-MONTH (MATCH-IDX)                   
                                        TO BP-REVENUE-MONTH             
                 MOVE IN-BP-OVRRIDE-RT-REV-MTH (MATCH-IDX)              
                                        TO BP-OVRRIDE-RT-REV-MTH        
                 MOVE SPACES            TO BP-OVRRIDE-RT-BILL-CY        
                 MOVE -1                TO WS-OVRD-BILL-DT-NULL         
                 MOVE IN-BP-SPECIAL-PROCESS-CD (MATCH-IDX)              
                                        TO BP-SPECIAL-PROCESS-CD        
                 MOVE ZERO              TO BP-ADJ-REASON-DESC-LEN       
                 MOVE SPACES            TO BP-ADJ-REASON-DESC-TEXT      
                 PERFORM 4440-TH-FOR-BP-INS  THRU 4440-EXIT             
                 PERFORM 7230-INSERT-BILLADJ THRU 7230-EXIT             
                 MOVE 'P'   TO IN-BP-PROCESS-CD  (IN-BP-IDX)            
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
       4410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       4420-TH-FOR-BP-UPD.                                              
      *================================================================*        
           IF IN-BP-ADJ-TYPE-CD (MATCH-IDX) NOT =                       
                                    WS-ADJ-TYPE-CD                      
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE '  '                  TO WS-TABLE-ID (TH-SUB)        
              EVALUATE IN-BP-ADJ-TYPE-CD (MATCH-IDX)                    
                 WHEN 'AGLP'                                            
                    MOVE 'CHARGE AGLPASS'  TO WS-COLUMN-DESC (TH-SUB)   
                 WHEN 'NAGL'                                            
                    MOVE 'NO AGL PASSTHRU' TO WS-COLUMN-DESC (TH-SUB)   
                 WHEN OTHER                                             
                    MOVE IN-BP-ADJ-TYPE-CD (MATCH-IDX)                  
                                           TO WS-COLUMN-DESC (TH-SUB)   
              END-EVALUATE                                              
              MOVE 'NO'                 TO WS-PRV-COLUMN-VALUE-TXT      
                                                   (TH-SUB)             
              MOVE 'YES'                                                
                                        TO WS-CHG-COLUMN-VALUE-TXT      
                                                   (TH-SUB)             
           END-IF                                                       
           IF IN-BP-SPECIAL-PROCESS-CD (MATCH-IDX) NOT =                
                                    WS-SPECIAL-PROCESS-CD               
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE '  '                  TO WS-TABLE-ID (TH-SUB)        
              MOVE 'DELAYED BILLMSG'     TO WS-COLUMN-DESC (TH-SUB)     
              IF IN-BP-SPECIAL-PROCESS-CD (MATCH-IDX) > SPACES          
                 MOVE 'YES'   TO WS-PRV-COLUMN-VALUE-TXT (TH-SUB)       
                 MOVE 'NO'    TO WS-CHG-COLUMN-VALUE-TXT (TH-SUB)       
              ELSE                                                      
                 MOVE 'NO'    TO WS-PRV-COLUMN-VALUE-TXT (TH-SUB)       
                 MOVE 'YES'   TO WS-CHG-COLUMN-VALUE-TXT (TH-SUB)       
              END-IF                                                    
           END-IF.                                                      
           IF IN-BP-OVRRIDE-RT-REV-MTH (MATCH-IDX) NOT =                
                           WS-OVRRIDE-RT-REV-MTH                        
              AND IN-BP-ADJ-TYPE-CD (MATCH-IDX) = 'RTOV'                
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE '  '                  TO WS-TABLE-ID (TH-SUB)        
              MOVE 'Change REV MNTH'     TO WS-COLUMN-DESC (TH-SUB)     
              MOVE WS-OVRRIDE-RT-REV-MTH TO WS-EDIT-DEC-THREE           
              MOVE WS-EDIT-DEC-THREE     TO WS-PRV-COLUMN-VALUE-TXT     
                                                      (TH-SUB)          
              MOVE IN-BP-OVRRIDE-RT-REV-MTH (MATCH-IDX)                 
                                         TO WS-EDIT-DEC-THREE           
              MOVE WS-EDIT-DEC-THREE     TO WS-CHG-COLUMN-VALUE-TXT     
                                                     (TH-SUB)           
           END-IF.                                                      
                                                                        
       4420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       4430-TH-FOR-BP-DEL.                                              
      *================================================================*        
                                                                        
      ***  DELAYED BILLMSG                                                      
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE '  '                  TO WS-TABLE-ID (TH-SUB)           
           MOVE 'DELAYED BILLMSG'     TO WS-COLUMN-DESC (TH-SUB)        
                                                                        
           IF WS-SPECIAL-PROCESS-CD > SPACES                            
              MOVE 'YES'     TO WS-PRV-COLUMN-VALUE-TXT (TH-SUB)        
           ELSE                                                         
              MOVE 'NO'      TO WS-PRV-COLUMN-VALUE-TXT (TH-SUB)        
           END-IF                                                       
           MOVE '**DELETED**'         TO WS-CHG-COLUMN-VALUE-TXT        
                                                   (TH-SUB)             
      ***  AGLPASS                                                              
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE '  '                  TO WS-TABLE-ID (TH-SUB)           
           EVALUATE TRUE                                                
              WHEN WS-ADJ-TYPE-CD = 'AGLP'                              
                 MOVE 'CHARGE AGLPASS'   TO WS-COLUMN-DESC (TH-SUB)     
                 MOVE 'YES'  TO WS-PRV-COLUMN-VALUE-TXT (TH-SUB)        
              WHEN WS-ADJ-TYPE-CD = 'NAGL'                              
                 MOVE 'NO AGL PASSTHRU'  TO WS-COLUMN-DESC (TH-SUB)     
                 MOVE 'YES'  TO WS-PRV-COLUMN-VALUE-TXT (TH-SUB)        
              WHEN WS-ADJ-TYPE-CD = 'RTOV'                              
                 MOVE 'Change REV MNTH'  TO WS-COLUMN-DESC (TH-SUB)     
                 MOVE WS-OVRRIDE-RT-REV-MTH TO WS-EDIT-DEC-THREE        
                 MOVE WS-EDIT-DEC-THREE                                 
                             TO WS-PRV-COLUMN-VALUE-TXT (TH-SUB)        
              WHEN OTHER                                                
                 MOVE WS-ADJ-TYPE-CD     TO WS-COLUMN-DESC (TH-SUB)     
                 MOVE WS-ADJ-TYPE-CD                                    
                              TO WS-PRV-COLUMN-VALUE-TXT (TH-SUB)       
           END-EVALUATE                                                 
                                                                        
           MOVE '**DELETED**'         TO WS-CHG-COLUMN-VALUE-TXT        
                                                   (TH-SUB).            
                                                                        
       4430-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       4440-TH-FOR-BP-INS.                                              
      *================================================================*        
                                                                        
      ***  DELAYED BILLMSG                                                      
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE '  '                  TO WS-TABLE-ID (TH-SUB)           
           MOVE 'DELAYED BILLMSG'     TO WS-COLUMN-DESC (TH-SUB)        
                                                                        
           IF BP-SPECIAL-PROCESS-CD > SPACES                            
              MOVE 'YES'     TO WS-CHG-COLUMN-VALUE-TXT (TH-SUB)        
           ELSE                                                         
              MOVE 'NO'      TO WS-CHG-COLUMN-VALUE-TXT (TH-SUB)        
           END-IF                                                       
           MOVE '**INSERTED**'        TO WS-PRV-COLUMN-VALUE-TXT        
                                                   (TH-SUB)             
      ***  AGLPASS                                                              
           COMPUTE TH-SUB = TH-SUB + 1                                  
           MOVE '  '                  TO WS-TABLE-ID (TH-SUB)           
           EVALUATE TRUE                                                
              WHEN BP-ADJ-TYPE-CD = 'AGLP'                              
                 MOVE 'CHARGE AGLPASS'  TO WS-COLUMN-DESC (TH-SUB)      
                 MOVE 'YES'  TO WS-CHG-COLUMN-VALUE-TXT (TH-SUB)        
              WHEN BP-ADJ-TYPE-CD = 'NAGL'                              
                 MOVE 'NO AGL PASSTHRU' TO WS-COLUMN-DESC (TH-SUB)      
                 MOVE 'YES'  TO WS-CHG-COLUMN-VALUE-TXT (TH-SUB)        
              WHEN BP-ADJ-TYPE-CD = 'RTOV'                              
                 MOVE 'Change REV MNTH' TO WS-COLUMN-DESC (TH-SUB)      
                 MOVE BP-OVRRIDE-RT-REV-MTH TO WS-EDIT-DEC-THREE        
                 MOVE WS-EDIT-DEC-THREE                                 
                             TO WS-CHG-COLUMN-VALUE-TXT (TH-SUB)        
              WHEN OTHER                                                
                 MOVE BP-ADJ-TYPE-CD    TO WS-COLUMN-DESC (TH-SUB)      
                 MOVE BP-ADJ-TYPE-CD                                    
                              TO WS-CHG-COLUMN-VALUE-TXT (TH-SUB)       
           END-EVALUATE                                                 
                                                                        
           MOVE '**INSERTED**'        TO WS-PRV-COLUMN-VALUE-TXT        
                                                   (TH-SUB).            
                                                                        
       4440-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       4500-PROCESS-AGL-MTR-CHRG.                                       
      *================================================================*        
                                                                        
           IF WS-AGL-FACTOR = ZERO                                      
              MOVE '01'                          TO C8-COMPANY-NO       
              MOVE 'AGL-METER-CHARGE'            TO C8-DELINQ-CD        
              PERFORM 7990-GET-DELINQUENCY       THRU 7990-EXIT         
              MOVE C8-DELINQ-VALUE    TO  WS-AGL-FACTOR                 
           END-IF.                                                      
           PERFORM 5850-GET-AGL-FCTR-EFF-BEG-DATE THRU 5850-EXIT        
           IF WS-REVENUE-MONTH > 0 OR WS-REV-MTH-ORIG-BILL > 0          
              PERFORM 5900-SET-AGLMTR-CHRG-FCTR-HIST THRU 5900-EXIT     
              MOVE 'Y'   TO WS-FH-FLG                                   
           ELSE                                                         
              PERFORM 5910-SET-AGLMTR-CHRG-FCTR THRU 5910-EXIT          
              MOVE 'Y'   TO WS-FF-FLG                                   
           END-IF.                                                      
       4500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       4600-PROCESS-PRE-HIST-CHG.                                       
      *================================================================*        
                                                                        
           MOVE AT-ACCOUNT-NO        TO CH-ACCOUNT-NO                   
           MOVE AT-CUSTOMER-NO       TO CH-CUSTOMER-NO                  
           MOVE AT-PREMISE-NO        TO CH-PREMISE-NO                   
           MOVE SPACES               TO CH-DATE-UTIL-SVC-END            
           PERFORM 7200-GET-SERVICE-END-DATE THRU 7200-EXIT             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              AND CX-DATE-READ  NOT = CH-DATE-UTIL-SVC-END              
              MOVE CX-DATE-READ          TO CH-DATE-UTIL-SVC-END        
              PERFORM 8920-UPDATE-CUSTPRM-HIST THRU 8920-EXIT           
           END-IF.                                                      
                                                                        
       4600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       5200-CHECK-AR-CNTL.                                              
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                 INTO :WS-HAS-AR                                        
              FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                            
                 WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                      
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*          INTO :WS-HAS-AR                                                
MFA-TR*       FROM CSS_AR_CNTL                                                  
MFA-TR*          WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                              
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 5200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'              TO ABEND-PROGRAM             
              MOVE '5200'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_AR_CNTL'           TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE AC-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       5210-ADD-AR-ROW.                                                 
      *================================================================*        
      *   IF NO CSS_AR_CNTL ROWS EXIST FOR THE ACCOUNT, ADD ONE.                
      *----------------------------------------------------------------*        
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_AR_CNTL                                  
                     (ACCOUNT_NO                                        
                      ,PYMT_PRIORITY_LVL                                
                      ,ITEM_ID                                          
                      ,AMT_AR_DAY_00                                    
                      ,AMT_AR_DAY_30                                    
                      ,AMT_AR_DAY_60                                    
                      ,AMT_AR_DAY_90                                    
                      ,AMT_UNUSED_CR                                    
                      ,AMT_TRAN_BALANCE                                 
                      ,TOT_SUMM_UNBILLED                                
                      ,LAST_UPDATE_TS)                                  
               VALUES (:AC-ACCOUNT-NO                                   
                       ,:AC-PYMT-PRIORITY-LVL                           
                       ,:AC-ITEM-ID                                     
                       ,:AC-AMT-AR-DAY-00                               
                       ,:AC-AMT-AR-DAY-30                               
                       ,:AC-AMT-AR-DAY-60                               
                       ,:AC-AMT-AR-DAY-90                               
                       ,:AC-AMT-UNUSED-CR                               
                       ,:AC-AMT-TRAN-BALANCE                            
                       ,:AC-TOT-SUMM-UNBILLED                           
                       ,CIS.CHAR2TIMESTAMP(:AC-LAST-UPDATE-TS))                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_AR_CNTL                                          
MFA-TR*              (ACCOUNT_NO                                                
MFA-TR*               ,PYMT_PRIORITY_LVL                                        
MFA-TR*               ,ITEM_ID                                                  
MFA-TR*               ,AMT_AR_DAY_00                                            
MFA-TR*               ,AMT_AR_DAY_30                                            
MFA-TR*               ,AMT_AR_DAY_60                                            
MFA-TR*               ,AMT_AR_DAY_90                                            
MFA-TR*               ,AMT_UNUSED_CR                                            
MFA-TR*               ,AMT_TRAN_BALANCE                                         
MFA-TR*               ,TOT_SUMM_UNBILLED                                        
MFA-TR*               ,LAST_UPDATE_TS)                                          
MFA-TR*        VALUES (:AC-ACCOUNT-NO                                           
MFA-TR*                ,:AC-PYMT-PRIORITY-LVL                                   
MFA-TR*                ,:AC-ITEM-ID                                             
MFA-TR*                ,:AC-AMT-AR-DAY-00                                       
MFA-TR*                ,:AC-AMT-AR-DAY-30                                       
MFA-TR*                ,:AC-AMT-AR-DAY-60                                       
MFA-TR*                ,:AC-AMT-AR-DAY-90                                       
MFA-TR*                ,:AC-AMT-UNUSED-CR                                       
MFA-TR*                ,:AC-AMT-TRAN-BALANCE                                    
MFA-TR*                ,:AC-TOT-SUMM-UNBILLED                                   
MFA-TR*                ,:AC-LAST-UPDATE-TS)                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'          TO ABEND-PROGRAM                 
              MOVE '5210'              TO ACTIVE-PARAGRAPH              
              MOVE 'INSERT'            TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_AR_CNTL'       TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE AC-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       5210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       4700-UPD-CURRENT-READS-MN.                                       
      *================================================================*        
                                                                        
           MOVE CX-ACCOUNT-NO          TO MN-ACCOUNT-NO                 
                                          RG-ACCOUNT-NO                 
           MOVE CX-CODE-UTIL-TYPE      TO MN-CODE-UTIL-TYPE             
                                          MC-CODE-UTIL-TYPE             
                                          RG-CODE-UTIL-TYPE             
           MOVE CX-IC-NO               TO MN-IC-NO                      
                                          RG-IC-NO                      
           MOVE CX-REG-ID-NO           TO MC-REG-ID-NO                  
                                          RG-REG-ID-NO                  
           MOVE CX-MTR-REF-NO          TO MN-MTR-REF-NO                 
                                          RG-MTR-REF-NO                 
           MOVE CX-METER-NO            TO MC-METER-NO                   
           MOVE CX-DATE-READ           TO MN-LAST-REG-READ-DATE         
                                          RG-LAST-REG-READ-DT           
           MOVE CX-CODE-METER-READ          TO                          
                                          MN-CODE-LAST-REG-READ         
                                          MN-CODE-CRNT-REG-READ         
                                          RG-CODE-CRNT-REG-READ         
                                          RG-CODE-LAST-REG-READ         
           PERFORM 7025-GET-CURR-TIME     THRU 7025-EXIT                
           MOVE WS-CURRENT-TIME           TO RG-LAST-REG-READ-TM        
                                             MN-LAST-REG-READ-TIME      
           IF CX-CODE-USAGE-TYPE  =  ('B' OR 'C')                       
      *       AND CX-CODE-USAGE-ID       =  'A'                                 
              AND CX-CODE-TIME-PERIOD  =  ZERO                          
              MOVE WS-CURRENT-TIMESTMP    TO MN-LAST-UPDATE-TS          
              MOVE CX-METER-READING       TO MN-LAST-READ-VALUE         
A05460        MOVE CX-CODE-USAGE-TYPE     TO MN-CODE-USAGE-TYPE         
A05460        MOVE CX-CODE-USAGE-ID       TO MN-CODE-USAGE-ID           
A05460        MOVE CX-CODE-TIME-PERIOD    TO MN-CODE-TIME-PERIOD        
              PERFORM 8850-UPDATE-MTRD-ENV THRU 8850-EXIT               
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 PERFORM 4705-UPD-CURRENT-READS-RG THRU 4705-EXIT       
               ELSE                                                     
                   GO TO 4700-EXIT                                      
              END-IF                                                    
           ELSE                                                         
              PERFORM 4705-UPD-CURRENT-READS-RG THRU 4705-EXIT          
           END-IF.                                                      
                                                                        
       4700-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *================================================================*        
       4705-UPD-CURRENT-READS-RG.                                       
      *================================================================*        
                                                                        
           MOVE CX-CODE-TIME-PERIOD           TO RG-CODE-TIME-PERIOD.   
           MOVE ZEROS                         TO MC-K-Q-LEAD-LAG-IND.   
           PERFORM 7909-SELECT-MTR-CAP        THRU 7909-EXIT.           
           IF CX-CODE-USAGE-TYPE  EQUAL WS-J                            
              OR CX-CODE-USAGE-TYPE  EQUAL WS-K                         
              OR CX-CODE-USAGE-TYPE  EQUAL WS-E                         
              OR CX-CODE-USAGE-TYPE  EQUAL WS-S                         
              OR CX-CODE-USAGE-TYPE  EQUAL WS-Q                         
              EVALUATE MC-K-Q-LEAD-LAG-IND                              
                 WHEN 1                                                 
                    DIVIDE CX-DEMAND-READING  BY 100                    
                              GIVING WS-DEM-CORRECTED-READ              
                    MOVE WS-DEM-CORRECTED-READ TO WS-LAST-READ-NUM      
                    MOVE WS-LAST-READ-NUM     TO RG-LAST-READ-VALUE     
                 WHEN 2                                                 
                    DIVIDE CX-DEMAND-READING  BY 10                     
                              GIVING WS-DEM-CORRECTED-READ              
                    MOVE WS-DEM-CORRECTED-READ TO WS-LAST-READ-NUM      
                    MOVE WS-LAST-READ-NUM     TO RG-LAST-READ-VALUE     
                 WHEN OTHER                                             
                    MOVE CX-DEMAND-READING    TO RG-LAST-READ-VALUE     
              END-EVALUATE                                              
           ELSE                                                         
            MOVE CX-METER-READING             TO RG-LAST-READ-VALUE     
           END-IF.                                                      
           MOVE CX-CODE-METER-READ            TO RG-CODE-CRNT-REG-READ  
                                                 RG-CODE-LAST-REG-READ. 
                                                                        
           PERFORM 8870-UPDATE-REG-READ       THRU 8870-EXIT.           
                                                                        
       4705-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *================================================================*        
       4710-UPD-CUST-PLAN.                                              
      *================================================================*        
                                                                        
           MOVE UC-ACCOUNT-NO                 TO CP-ACCOUNT-NO          
           MOVE UC-CODE-UTIL-TYPE             TO CP-CODE-UTIL-TYPE      
           MOVE UC-IC-NO                      TO CP-IC-NO               
           MOVE UC-RATE-ITEM-CODE             TO CP-RATE-ITEM-CODE      
           MOVE UC-DATE-USAGE-ENDS            TO CP-LAST-BILL-DATE      
           PERFORM 8860-UPDATE-CUST-PLAN      THRU 8860-EXIT.           
                                                                        
       4710-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       5800-CHECK-CIG-CUST.                                             
      *================================================================*        
                                                                        
           IF PARM-TRNSP-OVER-MDQ-FL  = 'Y'                             
              EVALUATE TRUE                                             
                 WHEN IN-IC-NO NOT = TW-PRIMARY-IC-NO                   
      ***           FLAG SHOULD SET FOR PRIMARY IC                              
                    MOVE 'CR00000019'     TO RS-BUS-RULE-ID             
                    PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT     
                 WHEN IN-CODE-REVENUE-CLASS NOT = TZ-CODE-REVENUE-CLASS 
      ***           FLAG SHOULD SET FOR TRANSPORTATION ROW                      
                    MOVE 'CR00000018'     TO RS-BUS-RULE-ID             
                    PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT     
                 WHEN AT-CODE-COMPANY-ACCT  = 'B'                       
      ***           FLAG CAN ONLY SET FOR TRANSPORTATION ROW                    
                    MOVE 'CR00000018'     TO RS-BUS-RULE-ID             
                    PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT     
                 WHEN OTHER                                             
                    MOVE PARM-TRNSP-OVER-MDQ-FL TO BG-TRNSP-OVER-MDQ-FL 
              END-EVALUATE                                              
           ELSE                                                         
              IF IN-IC-NO  = TW-PRIMARY-IC-NO                           
                 AND IN-CODE-REVENUE-CLASS = TZ-CODE-REVENUE-CLASS      
                 AND AT-CODE-COMPANY-ACCT NOT EQUAL 'B'                 
      ***           FLAG SHOULD SET FOR TRANSPORTATION ROW                      
                    MOVE 'CR00000098'     TO RS-BUS-RULE-ID             
                    PERFORM 8110-SEND-BUSRULE-RESULT THRU 8110-EXIT     
              ELSE                                                      
                 MOVE 'N'                  TO BG-TRNSP-OVER-MDQ-FL      
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       5810-PROCESS-ALL-ICS.                                            
      *================================================================*        
                                                                        
           MOVE BG-ACCOUNT-NO                TO UT-ACCOUNT-NO           
           MOVE BG-CODE-UTIL-TYPE            TO UT-CODE-UTIL-TYPE       
           MOVE BG-IC-NO                     TO UT-IC-NO                
           PERFORM 7110-GET-READ-CYCLE       THRU 7110-EXIT             
           MOVE UT-READ-CYCLE                TO RW-READ-CYCLE           
           MOVE WS-REVENUE-MONTH             TO RW-REVENUE-MONTH        
                                                BG-REVENUE-MONTH        
           PERFORM 7120-SELECT-OPT-READ-DT   THRU 7120-EXIT             
           MOVE RW-OPTIMUM-READ-DATE         TO WS-END-BILL-DT          
      *                                                                         
           MOVE WS-REVENUE-MONTH             TO                         
                                             WS-PARM-REV-MONTH-N.       
           COMPUTE WS-PARM-REV-MONTH = WS-PARM-REV-MONTH - 1            
           IF  WS-PARM-REV-MONTH = 0                                    
               COMPUTE WS-PARM-REV-MONTH = 12                           
               COMPUTE WS-PARM-REV-YEAR  = WS-PARM-REV-YEAR - 1         
           END-IF.                                                      
      *                                                                         
           MOVE WS-PARM-REV-MONTH-N          TO RW-REVENUE-MONTH        
           PERFORM 7120-SELECT-OPT-READ-DT   THRU 7120-EXIT             
           MOVE RW-OPTIMUM-READ-DATE         TO WS-DB2-DATE             
           PERFORM 7130-GET-NEXT-DAY         THRU 7130-EXIT             
           MOVE WS-DB2-DATE                  TO WS-BEG-BILL-DT          
      *                                                                         
           INITIALIZE                        CWSCA190-FIELDS            
           MOVE BG-ACCOUNT-NO                TO WS-C190-ACCOUNT-NO      
           MOVE BG-CODE-UTIL-TYPE            TO WS-C190-CODE-UTIL-TYPE  
           MOVE WS-ORIG-BILL-NO              TO WS-C190-BILL-NO         
                                                BG-BILL-NO              
           MOVE BG-IC-NO                     TO WS-C190-IC-NO           
           EVALUATE TRUE                                                
              WHEN BILL-WHEN-FUTURE                                     
                 MOVE 'F'                    TO WS-C190-BILL-TYPE       
              WHEN BILL-WHEN-IMMIDIATE                                  
                 MOVE 'I'                    TO WS-C190-BILL-TYPE       
           END-EVALUATE                                                 
           MOVE 'G'                          TO WS-C190-CUSTOMER-FL     
           MOVE PARM-ADJ-REASON-CD           TO WS-C190-ADJ-REASN-CODE  
           MOVE 'O'                          TO WS-C190-CALL-FLAG       
           MOVE WS-HOLD-REVENUE-MONTH        TO WS-C190-REVENUE-MONTH   
           IF WS-REV-RPT-CD = 'T'                                       
              MOVE WS-RB-ITEM-TIMESTMP       TO WS-TIMESTMP             
              PERFORM 7190-SUB-ONE-MICROSEC  THRU 7190-EXIT             
              MOVE WS-TIMESTMP               TO WS-C190-BILL-ITM-TS     
              MOVE WS-ORIG-ITEM-TIMESTMP     TO WS-TIMESTMP             
              PERFORM 7190-SUB-ONE-MICROSEC  THRU 7190-EXIT             
              MOVE WS-TIMESTMP               TO WS-C190-ORIG-ITM-TS     
              PERFORM 9300-CALL-CANCEL-REBILL   THRU 9300-EXIT          
           ELSE                                                         
              MOVE WS-ORIG-ITEM-TIMESTMP     TO WS-TIMESTMP             
              PERFORM 7180-ADD-ONE-MICROSEC  THRU 7180-EXIT             
              MOVE WS-TIMESTMP               TO WS-C190-ORIG-ITM-TS     
              PERFORM 7195-CHK-FOR-TRNSP-ROW    THRU 7195-EXIT          
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE WS-RB-ITEM-TIMESTMP       TO WS-TIMESTMP          
                 PERFORM 7180-ADD-ONE-MICROSEC  THRU 7180-EXIT          
                 MOVE WS-TIMESTMP               TO WS-C190-BILL-ITM-TS  
                 PERFORM 9300-CALL-CANCEL-REBILL   THRU 9300-EXIT       
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5810-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       5821-CHK-ASSO-IC-NO.                                             
      *================================================================*        
                                                                        
           MOVE PARM-ADJ-REASON-CD         TO WS-C190-ADJ-REASN-CODE    
           MOVE 'O'                        TO WS-C190-CALL-FLAG         
           MOVE WS-HOLD-REVENUE-MONTH      TO WS-C190-REVENUE-MONTH     
           MOVE WS-OTHER-IC-NO            TO WS-C190-IC-NO              
           INITIALIZE                     WS-C190-BILL-ITM-TS           
                                          WS-C190-ORIG-ITM-TS           
           PERFORM 9300-CALL-CANCEL-REBILL THRU 9300-EXIT               
           PERFORM 7155-FETCH-ASSO-IC-CRSR    THRU 7155-EXIT.           
                                                                        
       5821-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       5850-GET-AGL-FCTR-EFF-BEG-DATE.                                  
      *================================================================*        
      **GET AGL METER READ CHARGE FACTOR EFFECTIVE BEGIN DATE         **        
      *----------------------------------------------------------------*        
                                                                        
           IF WS-HOLD-REVENUE-MONTH > 0                                 
              MOVE WS-HOLD-REVENUE-MONTH TO WS-REV-MONTH-TEMP           
           ELSE                                                         
              MOVE AT-BILL-CYCLE      TO BN-BILL-CYCLE                  
              PERFORM 7650-GET-MIN-REV-MTH THRU 7650-EXIT               
              MOVE BN-REVENUE-MONTH   TO WS-REV-MONTH-TEMP              
           END-IF.                                                      
           MOVE WS-REV-MONTH-TEMP(1:4)   TO WS-AGL-FCTR-EFF-DT(1:4).    
           MOVE '-'                      TO WS-AGL-FCTR-EFF-DT(5:1).    
           MOVE WS-REV-MONTH-TEMP(5:2)   TO WS-AGL-FCTR-EFF-DT(6:2).    
           MOVE '-'                      TO WS-AGL-FCTR-EFF-DT(8:1).    
           MOVE '01'                     TO WS-AGL-FCTR-EFF-DT(9:2).    
      *                                                                         
       5850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       5900-SET-AGLMTR-CHRG-FCTR-HIST.                                  
      *================================================================*        
      **INSERT/UPDATE AGL METER READ CHARGE FACTOR IN FIXED_FCTR_HIST **        
      *----------------------------------------------------------------*        
                                                                        
           MOVE CX-ACCOUNT-NO            TO FH-ACCOUNT-NO.              
           MOVE CX-BILL-NO               TO FH-BILL-NO.                 
           MOVE CX-CODE-UTIL-TYPE        TO FH-CODE-UTIL-TYPE.          
           MOVE CX-IC-NO                 TO FH-IC-NO.                   
           MOVE CX-BILL-ITEM-TIMESTMP    TO FH-BILL-ITEM-TIMESTMP.      
           MOVE WS-AGLMTCHRG-FCTR-ID     TO FH-FACTOR-ID                
                                            SF-FACTOR-ID.               
           MOVE WS-AGL-FCTR-EFF-DT       TO FH-EFF-DATE-FROM            
                                            WS-EFF-DATE-FROM.           
           PERFORM 7660-CHECK-FH-AGL-EXISTS  THRU 7660-EXIT.            
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF FH-FCTR-POWER-10 NOT = 0                               
                    COMPUTE WS-FACTOR-FH  = FH-FACTOR *                 
                                             10 ** FH-FCTR-POWER-10     
                    MOVE WS-FACTOR-FH    TO WS-PRV-FACTOR               
                 ELSE                                                   
                    MOVE FH-FACTOR       TO WS-PRV-FACTOR               
              END-IF                                                    
              ADD WS-AGL-FACTOR          TO FH-FACTOR                   
              MOVE FH-FACTOR             TO WS-FACTOR-TRANS-HIST        
              PERFORM 8200-UPDATE-FIXED-FCT-HIST THRU 8200-EXIT         
      *** FACTOR-VALUE TRNS HIST                                                
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE '  '                  TO WS-TABLE-ID (TH-SUB)        
              MOVE 'FACTOR-VALUE'        TO WS-COLUMN-DESC (TH-SUB)     
                                                                        
              MOVE WS-AGL-FACTOR         TO WS-EDIT-DEC-THREE           
              MOVE WS-EDIT-DEC-THREE     TO WS-PRV-COLUMN-VALUE-TXT     
                                                     (TH-SUB)           
              MOVE FH-FACTOR             TO WS-EDIT-DEC-THREE           
              MOVE WS-EDIT-DEC-THREE     TO WS-CHG-COLUMN-VALUE-TXT     
                                                      (TH-SUB)          
           ELSE                                                         
              MOVE '10'                  TO FH-CMPNT-ID-CD              
              MOVE 'B'                   TO FH-CODE-SEASON              
              MOVE 'R'                   TO FH-INSTR-USE-TYPE-CD        
              MOVE 0                     TO FH-CODE-TIME-PERIOD         
              MOVE WS-CODE-REVENUE-CLASS TO FH-CODE-REVENUE-CLASS       
              MOVE '2999-12-31'          TO FH-EFF-DATE-TO              
                                            WS-EFF-DATE-TO              
              MOVE SPACES                TO FH-FIXED-FCTR-TYP-CD        
              MOVE ZERO                  TO FH-BILL-UNITS               
              MOVE SPACES                TO FH-ENERGY-UNIT-CD           
              MOVE 1                     TO FH-DURATION-REMAIN-NO       
                                            WS-DURATION-REMAIN-NO       
              MOVE 'N'                   TO FH-OVR-RT-VER-PRO-FL        
              MOVE IN-RT-PKG-OPT-SEQ-NO TO FH-RT-PKG-OPT-SEQ-NO         
              MOVE ZERO                  TO FH-BLOCK-NO                 
              PERFORM 7680-GET-NEW-FCT-HIST-SEQ THRU  7680-EXIT         
              PERFORM 7681-GET-XMT-VALUES THRU  7681-EXIT               
              MOVE SF-CODE-DR-CR         TO FH-CODE-DEBIT-CREDIT        
              MOVE SF-CODE-TAX-STAT-XMT  TO FH-CODE-TAX-STAT-XMT        
              MOVE SF-CODE-TAX-CITY-XMT  TO FH-CODE-TAX-CITY-XMT        
ACT004        MOVE SPACES                TO FH-CODE-TAX-OTHR-XMT        
              MOVE WS-AGL-FACTOR         TO FH-FACTOR                   
                                            WS-FACTOR-TRANS-HIST        
A05460        MOVE FH-FIXED-FCTR-SEQ-NO  TO WS-FH-FIXED-FCTR-SEQ-NO     
              PERFORM 8774-INSERT-FH            THRU 8774-EXIT          
              PERFORM 4355-TH-FOR-FH-INS        THRU 4355-EXIT          
           END-IF.                                                      
      *                                                                         
       5900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       5910-SET-AGLMTR-CHRG-FCTR.                                       
      *================================================================*        
      **INSERT/UPDATE AGL METER READ CHARGE FACTOR IN FIXED_FCT        *        
      *----------------------------------------------------------------*        
                                                                        
           MOVE CX-ACCOUNT-NO             TO FF-ACCOUNT-NO.             
           MOVE CX-CODE-UTIL-TYPE         TO FF-CODE-UTIL-TYPE.         
           MOVE CX-IC-NO                  TO FF-IC-NO.                  
           MOVE WS-AGLMTCHRG-FCTR-ID      TO FF-FACTOR-ID.              
           MOVE WS-AGL-FCTR-EFF-DT        TO FF-EFF-DATE-FROM           
                                             FH-EFF-DATE-FROM.          
      ** Delete Expired AGLMTCHRG factors from CSS_FIXED_FCTR table.            
           PERFORM 8260-DEL-EXPIRED-AGLMTCHRG THRU 8260-EXIT.           
                                                                        
           PERFORM 7670-CHECK-FF-AGL-EXISTS  THRU 7670-EXIT.            
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF SF-FCTR-POWER-10 NOT EQUAL 0                           
                 COMPUTE WS-FACTOR-FF     = FF-FACTOR *                 
                                          10 ** SF-FCTR-POWER-10        
                 MOVE WS-FACTOR-FF        TO WS-PRV-FACTOR              
              ELSE                                                      
                 MOVE FF-FACTOR           TO WS-PRV-FACTOR              
              END-IF                                                    
              ADD WS-AGL-FACTOR           TO FF-FACTOR                  
              MOVE FF-FACTOR              TO WS-FACTOR-TRANS-HIST       
              PERFORM 8250-UPDATE-FIXED-FCTR THRU 8250-EXIT             
      *** FACTOR-VALUE TRNS HIST                                                
              COMPUTE TH-SUB = TH-SUB + 1                               
              MOVE '  '                  TO WS-TABLE-ID (TH-SUB)        
              MOVE 'FACTOR-VALUE'        TO WS-COLUMN-DESC (TH-SUB)     
                                                                        
              MOVE WS-AGL-FACTOR         TO WS-EDIT-DEC-THREE           
              MOVE WS-EDIT-DEC-THREE     TO WS-PRV-COLUMN-VALUE-TXT     
                                                     (TH-SUB)           
              MOVE FF-FACTOR             TO WS-EDIT-DEC-THREE           
              MOVE WS-EDIT-DEC-THREE     TO WS-CHG-COLUMN-VALUE-TXT     
                                                      (TH-SUB)          
           ELSE                                                         
              MOVE '10'                   TO FF-CMPNT-ID-CD             
                                             FH-CMPNT-ID-CD             
              MOVE 'B'                    TO FF-CODE-SEASON             
                                             FH-CODE-SEASON             
              MOVE 'R'                    TO FF-INSTR-USE-TYPE-CD       
                                             FH-INSTR-USE-TYPE-CD       
              MOVE 0                      TO FF-CODE-TIME-PERIOD        
                                             FH-CODE-TIME-PERIOD        
              MOVE '2999-12-31'           TO FF-EFF-DATE-TO             
                                             FH-EFF-DATE-TO             
              MOVE SPACES                 TO FF-FIXED-FCTR-TYP-CD       
                                             FF-FIXED-FCTR-TYP-CD       
              MOVE 0                      TO FF-FAC-CHRG-BASE-AM        
              MOVE 1                      TO FF-DURATION-REMAIN-NO      
                                             WS-DURATION-REMAIN-NO      
              MOVE IN-RT-PKG-OPT-SEQ-NO TO FF-RT-PKG-OPT-SEQ-NO         
              MOVE ZERO                   TO FF-BLOCK-NO                
              PERFORM 7690-GET-NEW-FCTR-SEQ THRU  7690-EXIT             
              MOVE WS-AGL-FACTOR          TO FF-FACTOR                  
A05460                                       FH-FACTOR                  
                                             WS-FACTOR-TRANS-HIST       
              PERFORM 8300-INSERT-FIXED-FCTR THRU 8300-EXIT             
              PERFORM 4355-TH-FOR-FH-INS        THRU 4355-EXIT          
           END-IF.                                                      
      *                                                                         
       5910-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * JOURNALLING COPYBOOK                                                    
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
                                                                        
      *================================================================*        
       7000-SELECT-ACCOUNT.                                             
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              SELECT CUSTOMER_NO                                        
                    ,PREMISE_NO                                         
                    ,BILL_CYCLE                                         
                    ,CODE_ACCT_STAT                                     
                    ,CODE_COMPANY_ACCT                                  
                    ,CODE_TEMP_BILL                                     
                    ,CODE_BILL_PEND                                     
                    ,NOTICE_EXEMPT_CD                                   
                    ,DATE_LAST_ACTION                                   
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_FINALED_DT
           , 121), ' ', '-'), ':', '.') ACCT_FINALED_DT                        
                    ,NXT_BILL_NO                                        
                    ,CODE_ACCT_BILLED                                   
                    ,COMPANY_NO                                         
                    ,CODE_DISC_OK                                       
                    ,CODE_LPC_XMT                                       
                    ,IVR_EXEMPT_CD                                      
                    ,CODES_DATA_PRESENT                                 
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                    ,REV_MTH_LST_NRML                                   
                INTO :AT-CUSTOMER-NO                                    
                    ,:AT-PREMISE-NO                                     
                    ,:AT-BILL-CYCLE                                     
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-CODE-COMPANY-ACCT                              
                    ,:AT-CODE-TEMP-BILL                                 
                    ,:AT-CODE-BILL-PEND                                 
                    ,:AT-NOTICE-EXEMPT-CD                               
                    ,:AT-DATE-LAST-ACTION :WS-DATE-LAST-ACTION-NULL      
                    ,:AT-ACCT-FINALED-DT :WS-ACCT-FINALED-DT-NULL        
                    ,:AT-NXT-BILL-NO                                    
                    ,:AT-CODE-ACCT-BILLED                               
                    ,:AT-COMPANY-NO                                     
                    ,:AT-CODE-DISC-OK                                   
                    ,:AT-CODE-LPC-XMT                                   
                    ,:AT-IVR-EXEMPT-CD                                  
                    ,:AT-CODES-DATA-PRESENT                             
                    ,:AT-LAST-UPDATE-TS                                 
                    ,:AT-REV-MTH-LST-NRML                               
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUSTOMER_NO                                                
MFA-TR*             ,PREMISE_NO                                                 
MFA-TR*             ,BILL_CYCLE                                                 
MFA-TR*             ,CODE_ACCT_STAT                                             
MFA-TR*             ,CODE_COMPANY_ACCT                                          
MFA-TR*             ,CODE_TEMP_BILL                                             
MFA-TR*             ,CODE_BILL_PEND                                             
MFA-TR*             ,NOTICE_EXEMPT_CD                                           
MFA-TR*             ,DATE_LAST_ACTION                                           
MFA-TR*             ,ACCT_FINALED_DT                                            
MFA-TR*             ,NXT_BILL_NO                                                
MFA-TR*             ,CODE_ACCT_BILLED                                           
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,CODE_DISC_OK                                               
MFA-TR*             ,CODE_LPC_XMT                                               
MFA-TR*             ,IVR_EXEMPT_CD                                              
MFA-TR*             ,CODES_DATA_PRESENT                                         
MFA-TR*             ,LAST_UPDATE_TS                                             
MFA-TR*             ,REV_MTH_LST_NRML                                           
MFA-TR*         INTO :AT-CUSTOMER-NO                                            
MFA-TR*             ,:AT-PREMISE-NO                                             
MFA-TR*             ,:AT-BILL-CYCLE                                             
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-CODE-COMPANY-ACCT                                      
MFA-TR*             ,:AT-CODE-TEMP-BILL                                         
MFA-TR*             ,:AT-CODE-BILL-PEND                                         
MFA-TR*             ,:AT-NOTICE-EXEMPT-CD                                       
MFA-TR*             ,:AT-DATE-LAST-ACTION:WS-DATE-LAST-ACTION-NULL              
MFA-TR*             ,:AT-ACCT-FINALED-DT:WS-ACCT-FINALED-DT-NULL                
MFA-TR*             ,:AT-NXT-BILL-NO                                            
MFA-TR*             ,:AT-CODE-ACCT-BILLED                                       
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*             ,:AT-CODE-DISC-OK                                           
MFA-TR*             ,:AT-CODE-LPC-XMT                                           
MFA-TR*             ,:AT-IVR-EXEMPT-CD                                          
MFA-TR*             ,:AT-CODES-DATA-PRESENT                                     
MFA-TR*             ,:AT-LAST-UPDATE-TS                                         
MFA-TR*             ,:AT-REV-MTH-LST-NRML                                       
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-ACCT-FINALED-DT-NULL = -1                           
                 MOVE SPACES               TO AT-ACCT-FINALED-DT        
              END-IF                                                    
           ELSE                                                         
              MOVE 'CSR04873'              TO ABEND-PROGRAM             
              MOVE '7000'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_ACCOUNT'           TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE AT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7001-GET-REVENUE-DISTRICT.                                       
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              SELECT COMPANY_NO,                                        
                     REV_DISTRICT_CD                                    
                INTO :PR-COMPANY-NO,                                    
                     :PR-REV-DISTRICT-CD                                
                FROM CSS_PREMISE WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COMPANY_NO,                                                
MFA-TR*              REV_DISTRICT_CD                                            
MFA-TR*         INTO :PR-COMPANY-NO,                                            
MFA-TR*              :PR-REV-DISTRICT-CD                                        
MFA-TR*         FROM CSS_PREMISE                                                
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7001                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                TO ABEND-PROGRAM           
              MOVE '7001'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_PREMISE'             TO TABLE-1                 
              MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1         
              MOVE 'ACCCOUNT_NO'             TO TABLE-ELEMENT-2         
              MOVE PR-PREMISE-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7001-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7010-SELECT-CUR-TIMESTAMP.                                       
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTMP             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-TIMESTMP = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7010'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SET'                      TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE SPACES                     TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE IN-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05460*================================================================*        
A05460 7015-GET-RATE-PLAN-NUM.                                          
A05460*================================================================*        
A05460                                                                  
A05460     EXEC SQL                                                     
A05460        SELECT TOP(1) FI.RATE_PLAN_NO                                    
A05460          INTO :FI-RATE-PLAN-NO                                   
A05460          FROM CSS_ACCT_RTPK_AGR  DF WITH(READUNCOMMITTED)                
A05460              ,CRM_RT_PKG_OPTION  FI WITH(READUNCOMMITTED)                
A05460         WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO             
A05460           AND DF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE         
A05460           AND DF.IC_NO              = :DF-IC-NO                  
A05460           AND DF.RT_PKG_OPT_SEQ_NO  = :DF-RT-PKG-OPT-SEQ-NO      
A05460           AND DF.OPTION_CD          = FI.OPTION_CD               
A05460           AND FI.OPT_VSTART_TS     <= CIS.CURRENT$TIMESTAMP()          
A05460           AND FI.OPT_VEND_TS       >= CIS.CURRENT$TIMESTAMP()          
A05460           AND FI.PROC_STATUS_CD     = 'AC'                       
A05460         ORDER BY FI.OPT_VSTART_TS DESC                           
A05460                                       
A05460     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FI.RATE_PLAN_NO                                            
MFA-TR*         INTO :FI-RATE-PLAN-NO                                           
MFA-TR*         FROM CSS_ACCT_RTPK_AGR  DF                                      
MFA-TR*             ,CRM_RT_PKG_OPTION  FI                                      
MFA-TR*        WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO                     
MFA-TR*          AND DF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE                 
MFA-TR*          AND DF.IC_NO              = :DF-IC-NO                          
MFA-TR*          AND DF.RT_PKG_OPT_SEQ_NO  = :DF-RT-PKG-OPT-SEQ-NO              
MFA-TR*          AND DF.OPTION_CD          = FI.OPTION_CD                       
MFA-TR*          AND FI.OPT_VSTART_TS     <= CURRENT TIMESTAMP                  
MFA-TR*          AND FI.OPT_VEND_TS       >= CURRENT TIMESTAMP                  
MFA-TR*          AND FI.PROC_STATUS_CD     = 'AC'                               
MFA-TR*        ORDER BY FI.OPT_VSTART_TS DESC                                   
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05460                                                                  
A05460     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05460                                                                  
A05460     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A05460        CONTINUE                                                  
A05460     ELSE                                                         
A05460         MOVE 'CSR04873'              TO ABEND-PROGRAM            
A05460         MOVE '7015'                  TO ACTIVE-PARAGRAPH         
A05460         MOVE 'SELECT'                TO ABEND-FUNCTION           
A05460         MOVE 'CSS_BILLING_DET'       TO TABLE-1                  
A05460         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
A05460         MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
A05460         MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
A05460         MOVE 'RT_PKG_OPT_SEQ_NO'     TO TABLE-ELEMENT-4          
A05460         MOVE DF-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
A05460         MOVE DF-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
A05460         MOVE DF-IC-NO                TO HOSTVAR-ELEMENT-3        
A05460         MOVE DF-RT-PKG-OPT-SEQ-NO    TO HOSTVAR-ELEMENT-4        
A05460         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
A05460         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
A05460     END-IF.                                                      
A05460*                                                                         
A05460 7015-EXIT.                                                       
A05460     EXIT.                                                        
A05460*                                                                         
      *================================================================*        
       7020-SELECT-CUR-DATE.                                            
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7020'               TO ACTIVE-PARAGRAPH             
              MOVE 'SET'                TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE IN-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7025-GET-CURR-TIME.                                              
      *================================================================*        
                                                                        
            EXEC SQL                                                    
               SELECT
              REPLACE(CONVERT(CHAR(8), CIS.CURRENT$TIME(), 108), ':', 
           '.')
            INTO
              :WS-CURRENT-TIME                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SET :WS-CURRENT-TIME = CURRENT TIME                              
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7020'               TO ACTIVE-PARAGRAPH             
              MOVE 'SET'                TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                          ABEND-TABLES                  
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE IN-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *===============================================================*         
       7030-SELECT-RESP-AREA-ID.                                        
      *===============================================================*         
                                                                        
           EXEC SQL                                                     
              SELECT  RESP_AREA_ID                                      
              INTO    :WS-RESP-AREA-ID                                  
              FROM    CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
              WHERE   USER_ID = :PF-USER-ID                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  RESP_AREA_ID                                              
MFA-TR*       INTO    :WS-RESP-AREA-ID                                          
MFA-TR*       FROM    CSS_USER_PROFILE                                          
MFA-TR*       WHERE   USER_ID = :PF-USER-ID                                     
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7030                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE 'SELECT'                     TO ABEND-FUNCTION       
              MOVE SPACES                       TO                      
                                                 ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_USER_PROFILE'           TO TABLE-1              
              MOVE 'USER_ID'                    TO TABLE-ELEMENT-1      
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-2      
              MOVE PF-USER-ID                   TO HOSTVAR-ELEMENT-1    
              MOVE IN-ACCOUNT-NO                TO HOSTVAR-ELEMENT-2    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *===============================================================*         
       7040-SELECT-RATE-PLAN.                                           
      *===============================================================*         
                                                                        
           EXEC SQL                                                     
              SELECT  RATE_PLAN_NO                                      
                     ,CODE_REVENUE_CLASS                                
                INTO  :UT-RATE-PLAN-NO                                  
                     ,:UT-CODE-REVENUE-CLASS                            
                FROM  CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
               WHERE  ACCOUNT_NO     = :UT-ACCOUNT-NO                   
                 AND  CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE               
                 AND  IC_NO          = :UT-IC-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  RATE_PLAN_NO                                              
MFA-TR*              ,CODE_REVENUE_CLASS                                        
MFA-TR*         INTO  :UT-RATE-PLAN-NO                                          
MFA-TR*              ,:UT-CODE-REVENUE-CLASS                                    
MFA-TR*         FROM  CSS_UTIL_ENVRNMT                                          
MFA-TR*        WHERE  ACCOUNT_NO     = :UT-ACCOUNT-NO                           
MFA-TR*          AND  CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                       
MFA-TR*          AND  IC_NO          = :UT-IC-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7040                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE '7040'                      TO ACTIVE-PARAGRAPH      
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'CSS_UTIL_ENVRNMT'          TO TABLE-1               
              MOVE 'ACCOUNT_NO'                TO TABLE-ELEMENT-1       
              MOVE 'CODE_UTILL_TYPE'           TO TABLE-ELEMENT-2       
              MOVE 'IC_NO'                     TO TABLE-ELEMENT-3       
              MOVE UT-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1     
              MOVE UT-CODE-UTIL-TYPE           TO HOSTVAR-ELEMENT-2     
              MOVE UT-IC-NO                    TO HOSTVAR-ELEMENT-3     
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17930000
      *================================================================*        
       7045-GET-FUNCTION-DESC.                                          
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CODE_SHORT_DESC                                    
                INTO :WS-CODE-SHORT-DESC                                
                FROM CSS_CODE_VALUE WITH(READUNCOMMITTED)                       
               WHERE COMPANY_NO    = '01'                               
                 AND TABLE_NA      = 'BILL_CORRECTION'                  
                 AND COLUMN_NA     = 'FUNCTION_CODE'                    
                 AND CODE_VALUE    = :PARM-FUNCTION                     
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     17960000
MFA-TR*       SELECT CODE_SHORT_DESC                                            
MFA-TR*         INTO :WS-CODE-SHORT-DESC                                        
MFA-TR*         FROM CSS_CODE_VALUE                                             
MFA-TR*        WHERE COMPANY_NO    = '01'                                       
MFA-TR*          AND TABLE_NA      = 'BILL_CORRECTION'                          
MFA-TR*          AND COLUMN_NA     = 'FUNCTION_CODE'                            
MFA-TR*          AND CODE_VALUE    = :PARM-FUNCTION                             
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*         QUERYNO 7045                                                    
MFA-TR*    END-EXEC                                                     17980000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17990000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE '7045'                      TO ACTIVE-PARAGRAPH      
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'CSS_CODE_VALUE'            TO TABLE-1               
              MOVE 'COMPANY_NO'                TO TABLE-ELEMENT-1       
              MOVE 'TABLE_NA'                  TO TABLE-ELEMENT-2       
              MOVE 'COLUMN_NA'                 TO TABLE-ELEMENT-3       
              MOVE 'CODE_VALUE'                TO TABLE-ELEMENT-4       
              MOVE '01'                        TO HOSTVAR-ELEMENT-1     
              MOVE 'BILL_CORRECTION'           TO HOSTVAR-ELEMENT-2     
              MOVE 'FUNCTION_CODE'             TO HOSTVAR-ELEMENT-3     
              MOVE PARM-FUNCTION               TO HOSTVAR-ELEMENT-4     
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7045-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *===============================================================*         
       7050-GET-REASN-DESC.                                             
      *===============================================================*         
                                                                        
           EXEC SQL                                                     
              SELECT  ADJ_REASON_DESC                                   
                INTO  :K0-ADJ-REASON-DESC                               
                FROM  CSS_BILL_ADJ_REASN WITH(READUNCOMMITTED)                  
               WHERE  ADJ_REASON_CD = :K0-ADJ-REASON-CD                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ADJ_REASON_DESC                                           
MFA-TR*         INTO  :K0-ADJ-REASON-DESC                                       
MFA-TR*         FROM  CSS_BILL_ADJ_REASN                                        
MFA-TR*        WHERE  ADJ_REASON_CD = :K0-ADJ-REASON-CD                         
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE '7050'                      TO ACTIVE-PARAGRAPH      
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'CSS_BILL_ADJ_REASN'        TO TABLE-1               
              MOVE 'ADJ_REASON_CD'             TO TABLE-ELEMENT-1       
              MOVE K0-ADJ-REASON-CD            TO HOSTVAR-ELEMENT-1     
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7051-SELECT-BILLING-DET.                                         
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               SELECT PREMISE_NO                                        
                     ,DATE_ORIG_BILL                                    
                     ,AMT_BILL_ITEM                                     
                     ,CODE_BILL_CALC                                    
                     ,CODE_BILL_ITM_TYPE                                
                     ,CODE_BILL_ITM_IND                                 
                     ,CODE_DR_CR_CNSMPTN                                
                     ,AMT_STATE_TAX                                     
                     ,AMT_CITY_TAX                                      
                     ,AMT_OTHER_TAX                                     
                     ,CODE_REVENUE_CLASS                                
                     ,CODE_SIC_NO                                       
                     ,RATE_PLAN_NO                                      
                     ,CODE_CURTAIL_PRTY                                 
                     ,CODE_STAT_TAX_XMT                                 
                     ,CODE_CITY_TAX_XMT                                 
                     ,CODE_OTHR_TAX_XMT                                 
                     ,REV_RPT_CD                                        
                     ,STANDBY_COMPLIED                                  
                     ,PRORATE_CD                                        
                     ,NEW_RATE_PCT                                      
                     ,CODE_SUB_TOTAL                                    
                     ,TAX_REFUND_CD                                     
                     ,COMPANY_NO                                        
                     ,DATE_LFTM_HI_DMD                                  
                     ,LFTM_HI_PEAK_DMD                                  
                     ,REBILL_IND                                        
                     ,ADJ_REASON_CD                                     
                     ,REVENUE_MONTH                                     
                     ,GAS_BASE_USE                                      
                     ,WNA_FACTOR                                        
                     ,BTU_FACTOR                                        
                     ,NO_OF_CONS_DAYS                                   
                     ,REV_MTH_ORIG_BILL                                 
                     ,REV_DISTRICT_CD                                   
                     ,FUEL_SHIPPER_CD                                   
                     ,ALTERNATE_FUEL_CD                                 
                     ,TRNSP_OVER_MDQ_FL                                 
                     ,CITY_TAX_RATE                                     
                     ,OTHER_TAX_RATE                                    
                     ,STATE_TAX_RATE                                    
                     ,BILL_CALC_CYCLE                                   
                     ,NAICS_CD                                          
                     ,RT_PKG_OPT_SEQ_NO                                 
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                 INTO :BG-PREMISE-NO                                    
                     ,:BG-DATE-ORIG-BILL :WS-DATE-ORIG-BILL-NULL         
                     ,:BG-AMT-BILL-ITEM                                 
                     ,:BG-CODE-BILL-CALC                                
                     ,:BG-CODE-BILL-ITM-TYPE                            
                     ,:BG-CODE-BILL-ITM-IND                             
                     ,:BG-CODE-DR-CR-CNSMPTN                            
                     ,:BG-AMT-STATE-TAX                                 
                     ,:BG-AMT-CITY-TAX                                  
                     ,:BG-AMT-OTHER-TAX                                 
                     ,:BG-CODE-REVENUE-CLASS                            
                     ,:BG-CODE-SIC-NO                                   
                     ,:BG-RATE-PLAN-NO                                  
                     ,:BG-CODE-CURTAIL-PRTY                             
                     ,:BG-CODE-STAT-TAX-XMT                             
                     ,:BG-CODE-CITY-TAX-XMT                             
                     ,:BG-CODE-OTHR-TAX-XMT                             
                     ,:BG-REV-RPT-CD                                    
                     ,:BG-STANDBY-COMPLIED                              
                     ,:BG-PRORATE-CD                                    
                     ,:BG-NEW-RATE-PCT                                  
                     ,:BG-CODE-SUB-TOTAL                                
                     ,:BG-TAX-REFUND-CD                                 
                     ,:BG-COMPANY-NO                                    
                     ,:BG-DATE-LFTM-HI-DMD :WS-DATE-LFTM-HI-DMD-NULL     
                     ,:BG-LFTM-HI-PEAK-DMD                              
                     ,:BG-REBILL-IND                                    
                     ,:BG-ADJ-REASON-CD                                 
                     ,:BG-REVENUE-MONTH                                 
                     ,:BG-GAS-BASE-USE                                  
                     ,:BG-WNA-FACTOR                                    
                     ,:BG-BTU-FACTOR                                    
                     ,:BG-NO-OF-CONS-DAYS                               
                     ,:BG-REV-MTH-ORIG-BILL                             
                     ,:BG-REV-DISTRICT-CD                               
                     ,:BG-FUEL-SHIPPER-CD                               
                     ,:BG-ALTERNATE-FUEL-CD                             
                     ,:BG-TRNSP-OVER-MDQ-FL                             
                     ,:BG-CITY-TAX-RATE                                 
                     ,:BG-OTHER-TAX-RATE                                
                     ,:BG-STATE-TAX-RATE                                
                     ,:BG-BILL-CALC-CYCLE                               
                     ,:BG-NAICS-CD                                      
                     ,:BG-RT-PKG-OPT-SEQ-NO :WS-RT-PKG-NULL              
                     ,:BG-LAST-UPDATE-TS                                
                 FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO               
                  AND BILL_NO            = :BG-BILL-NO                  
                  AND CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE           
                  AND IC_NO              = :BG-IC-NO                    
                  AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PREMISE_NO                                                
MFA-TR*              ,DATE_ORIG_BILL                                            
MFA-TR*              ,AMT_BILL_ITEM                                             
MFA-TR*              ,CODE_BILL_CALC                                            
MFA-TR*              ,CODE_BILL_ITM_TYPE                                        
MFA-TR*              ,CODE_BILL_ITM_IND                                         
MFA-TR*              ,CODE_DR_CR_CNSMPTN                                        
MFA-TR*              ,AMT_STATE_TAX                                             
MFA-TR*              ,AMT_CITY_TAX                                              
MFA-TR*              ,AMT_OTHER_TAX                                             
MFA-TR*              ,CODE_REVENUE_CLASS                                        
MFA-TR*              ,CODE_SIC_NO                                               
MFA-TR*              ,RATE_PLAN_NO                                              
MFA-TR*              ,CODE_CURTAIL_PRTY                                         
MFA-TR*              ,CODE_STAT_TAX_XMT                                         
MFA-TR*              ,CODE_CITY_TAX_XMT                                         
MFA-TR*              ,CODE_OTHR_TAX_XMT                                         
MFA-TR*              ,REV_RPT_CD                                                
MFA-TR*              ,STANDBY_COMPLIED                                          
MFA-TR*              ,PRORATE_CD                                                
MFA-TR*              ,NEW_RATE_PCT                                              
MFA-TR*              ,CODE_SUB_TOTAL                                            
MFA-TR*              ,TAX_REFUND_CD                                             
MFA-TR*              ,COMPANY_NO                                                
MFA-TR*              ,DATE_LFTM_HI_DMD                                          
MFA-TR*              ,LFTM_HI_PEAK_DMD                                          
MFA-TR*              ,REBILL_IND                                                
MFA-TR*              ,ADJ_REASON_CD                                             
MFA-TR*              ,REVENUE_MONTH                                             
MFA-TR*              ,GAS_BASE_USE                                              
MFA-TR*              ,WNA_FACTOR                                                
MFA-TR*              ,BTU_FACTOR                                                
MFA-TR*              ,NO_OF_CONS_DAYS                                           
MFA-TR*              ,REV_MTH_ORIG_BILL                                         
MFA-TR*              ,REV_DISTRICT_CD                                           
MFA-TR*              ,FUEL_SHIPPER_CD                                           
MFA-TR*              ,ALTERNATE_FUEL_CD                                         
MFA-TR*              ,TRNSP_OVER_MDQ_FL                                         
MFA-TR*              ,CITY_TAX_RATE                                             
MFA-TR*              ,OTHER_TAX_RATE                                            
MFA-TR*              ,STATE_TAX_RATE                                            
MFA-TR*              ,BILL_CALC_CYCLE                                           
MFA-TR*              ,NAICS_CD                                                  
MFA-TR*              ,RT_PKG_OPT_SEQ_NO                                         
MFA-TR*              ,LAST_UPDATE_TS                                            
MFA-TR*          INTO :BG-PREMISE-NO                                            
MFA-TR*              ,:BG-DATE-ORIG-BILL:WS-DATE-ORIG-BILL-NULL                 
MFA-TR*              ,:BG-AMT-BILL-ITEM                                         
MFA-TR*              ,:BG-CODE-BILL-CALC                                        
MFA-TR*              ,:BG-CODE-BILL-ITM-TYPE                                    
MFA-TR*              ,:BG-CODE-BILL-ITM-IND                                     
MFA-TR*              ,:BG-CODE-DR-CR-CNSMPTN                                    
MFA-TR*              ,:BG-AMT-STATE-TAX                                         
MFA-TR*              ,:BG-AMT-CITY-TAX                                          
MFA-TR*              ,:BG-AMT-OTHER-TAX                                         
MFA-TR*              ,:BG-CODE-REVENUE-CLASS                                    
MFA-TR*              ,:BG-CODE-SIC-NO                                           
MFA-TR*              ,:BG-RATE-PLAN-NO                                          
MFA-TR*              ,:BG-CODE-CURTAIL-PRTY                                     
MFA-TR*              ,:BG-CODE-STAT-TAX-XMT                                     
MFA-TR*              ,:BG-CODE-CITY-TAX-XMT                                     
MFA-TR*              ,:BG-CODE-OTHR-TAX-XMT                                     
MFA-TR*              ,:BG-REV-RPT-CD                                            
MFA-TR*              ,:BG-STANDBY-COMPLIED                                      
MFA-TR*              ,:BG-PRORATE-CD                                            
MFA-TR*              ,:BG-NEW-RATE-PCT                                          
MFA-TR*              ,:BG-CODE-SUB-TOTAL                                        
MFA-TR*              ,:BG-TAX-REFUND-CD                                         
MFA-TR*              ,:BG-COMPANY-NO                                            
MFA-TR*              ,:BG-DATE-LFTM-HI-DMD:WS-DATE-LFTM-HI-DMD-NULL             
MFA-TR*              ,:BG-LFTM-HI-PEAK-DMD                                      
MFA-TR*              ,:BG-REBILL-IND                                            
MFA-TR*              ,:BG-ADJ-REASON-CD                                         
MFA-TR*              ,:BG-REVENUE-MONTH                                         
MFA-TR*              ,:BG-GAS-BASE-USE                                          
MFA-TR*              ,:BG-WNA-FACTOR                                            
MFA-TR*              ,:BG-BTU-FACTOR                                            
MFA-TR*              ,:BG-NO-OF-CONS-DAYS                                       
MFA-TR*              ,:BG-REV-MTH-ORIG-BILL                                     
MFA-TR*              ,:BG-REV-DISTRICT-CD                                       
MFA-TR*              ,:BG-FUEL-SHIPPER-CD                                       
MFA-TR*              ,:BG-ALTERNATE-FUEL-CD                                     
MFA-TR*              ,:BG-TRNSP-OVER-MDQ-FL                                     
MFA-TR*              ,:BG-CITY-TAX-RATE                                         
MFA-TR*              ,:BG-OTHER-TAX-RATE                                        
MFA-TR*              ,:BG-STATE-TAX-RATE                                        
MFA-TR*              ,:BG-BILL-CALC-CYCLE                                       
MFA-TR*              ,:BG-NAICS-CD                                              
MFA-TR*              ,:BG-RT-PKG-OPT-SEQ-NO:WS-RT-PKG-NULL                      
MFA-TR*              ,:BG-LAST-UPDATE-TS                                        
MFA-TR*          FROM CSS_BILLING_DET                                           
MFA-TR*         WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO                       
MFA-TR*           AND BILL_NO            = :BG-BILL-NO                          
MFA-TR*           AND CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                   
MFA-TR*           AND IC_NO              = :BG-IC-NO                            
MFA-TR*           AND BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP               
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7051                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7051'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILLING_DET'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-4        
              MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BG-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE BG-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE BG-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7051-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7052-SELECT-BILL-HEADER.                                         
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               SELECT PREMISE_NO                                        
                     ,DATE_BILLED                                       
                     ,CODE_BILL_REASON                                  
                     ,CODE_BILL_STATUS                                  
                     ,CODE_BILL_TYPE                                    
                     ,CUSTOMER_NO                                       
                     ,CODE_SPCL_BILL                                    
                     ,PREM_ACCT_SEQ_NO                                  
                     ,SMRY_BILL_NO                                      
                     ,SMRY_REBILL_NO                                    
                     ,ACCOUNT_NO_SUMM                                   
                     ,COMPANY_NO                                        
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                     ,TOT_OTHER_CHARGES                                 
                     ,TOTAL_ARREARS                                     
                     ,BILL_CORRECTED_CD                                 
                INTO :BI-PREMISE-NO                                     
                    ,:BI-DATE-BILLED :WS-DATE-BILLED-NULL                
                    ,:BI-CODE-BILL-REASON                               
                    ,:BI-CODE-BILL-STATUS                               
                    ,:BI-CODE-BILL-TYPE                                 
                    ,:BI-CUSTOMER-NO                                    
                    ,:BI-CODE-SPCL-BILL                                 
                    ,:BI-PREM-ACCT-SEQ-NO                               
                    ,:BI-SMRY-BILL-NO                                   
                    ,:BI-SMRY-REBILL-NO                                 
                    ,:BI-ACCOUNT-NO-SUMM                                
                    ,:BI-COMPANY-NO                                     
                    ,:BI-LAST-UPDATE-TS                                 
                    ,:BI-TOT-OTHER-CHARGES                              
                    ,:BI-TOTAL-ARREARS                                  
                    ,:BI-BILL-CORRECTED-CD                              
                FROM CSS_BILLING_HDR WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO = :BI-ACCOUNT-NO                        
                 AND BILL_NO = :BI-BILL-NO                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PREMISE_NO                                                
MFA-TR*              ,DATE_BILLED                                               
MFA-TR*              ,CODE_BILL_REASON                                          
MFA-TR*              ,CODE_BILL_STATUS                                          
MFA-TR*              ,CODE_BILL_TYPE                                            
MFA-TR*              ,CUSTOMER_NO                                               
MFA-TR*              ,CODE_SPCL_BILL                                            
MFA-TR*              ,PREM_ACCT_SEQ_NO                                          
MFA-TR*              ,SMRY_BILL_NO                                              
MFA-TR*              ,SMRY_REBILL_NO                                            
MFA-TR*              ,ACCOUNT_NO_SUMM                                           
MFA-TR*              ,COMPANY_NO                                                
MFA-TR*              ,LAST_UPDATE_TS                                            
MFA-TR*              ,TOT_OTHER_CHARGES                                         
MFA-TR*              ,TOTAL_ARREARS                                             
MFA-TR*              ,BILL_CORRECTED_CD                                         
MFA-TR*         INTO :BI-PREMISE-NO                                             
MFA-TR*             ,:BI-DATE-BILLED:WS-DATE-BILLED-NULL                        
MFA-TR*             ,:BI-CODE-BILL-REASON                                       
MFA-TR*             ,:BI-CODE-BILL-STATUS                                       
MFA-TR*             ,:BI-CODE-BILL-TYPE                                         
MFA-TR*             ,:BI-CUSTOMER-NO                                            
MFA-TR*             ,:BI-CODE-SPCL-BILL                                         
MFA-TR*             ,:BI-PREM-ACCT-SEQ-NO                                       
MFA-TR*             ,:BI-SMRY-BILL-NO                                           
MFA-TR*             ,:BI-SMRY-REBILL-NO                                         
MFA-TR*             ,:BI-ACCOUNT-NO-SUMM                                        
MFA-TR*             ,:BI-COMPANY-NO                                             
MFA-TR*             ,:BI-LAST-UPDATE-TS                                         
MFA-TR*             ,:BI-TOT-OTHER-CHARGES                                      
MFA-TR*             ,:BI-TOTAL-ARREARS                                          
MFA-TR*             ,:BI-BILL-CORRECTED-CD                                      
MFA-TR*         FROM CSS_BILLING_HDR                                            
MFA-TR*        WHERE ACCOUNT_NO = :BI-ACCOUNT-NO                                
MFA-TR*          AND BILL_NO = :BI-BILL-NO                                      
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7052                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7052'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILLING_HDR'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE BI-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BI-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7052-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       7053-CHECK-RBI-HOOK.                                             
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               SELECT BILL_NO                                           
                     ,BILL_CORRECTED_CD                                 
                 INTO :BI-BILL-NO                                       
                     ,:WS-RBI-BILL-CORRECTED-CD                         
                 FROM CSS_BILLING_HDR WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO       = :BI-ACCOUNT-NO                 
                  AND DATE_BILLED         IS NULL                       
                  AND CODE_BILL_STATUS = 'C'                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BILL_NO                                                   
MFA-TR*              ,BILL_CORRECTED_CD                                         
MFA-TR*          INTO :BI-BILL-NO                                               
MFA-TR*              ,:WS-RBI-BILL-CORRECTED-CD                                 
MFA-TR*          FROM CSS_BILLING_HDR                                           
MFA-TR*         WHERE ACCOUNT_NO       = :BI-ACCOUNT-NO                         
MFA-TR*           AND DATE_BILLED         IS NULL                               
MFA-TR*           AND CODE_BILL_STATUS = 'C'                                    
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7053                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'              TO ABEND-PROGRAM             
              MOVE '7053'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                               ABEND-TABLES             
              MOVE 'CSS_BILLING_HDR'       TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE 'CODE_BILL_STATUS'      TO TABLE-ELEMENT-2           
              MOVE BG-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
              MOVE 'C'                     TO HOSTVAR-ELEMENT-2         
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7053-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7054-CHECK-RBF-HOOK.                                             
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               SELECT COALESCE(MAX(BILL_NO), 0)                           
                 INTO :BI-BILL-NO                                       
                 FROM CSS_BILLING_HDR WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO       = :BI-ACCOUNT-NO                 
                  AND DATE_BILLED         IS NULL                       
                  AND CODE_BILL_STATUS IN ('A', 'B')                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT IFNULL(MAX(BILL_NO), 0)                                   
MFA-TR*          INTO :BI-BILL-NO                                               
MFA-TR*          FROM CSS_BILLING_HDR                                           
MFA-TR*         WHERE ACCOUNT_NO       = :BI-ACCOUNT-NO                         
MFA-TR*           AND DATE_BILLED         IS NULL                               
MFA-TR*           AND CODE_BILL_STATUS IN ('A', 'B')                            
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7054                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'              TO ABEND-PROGRAM             
              MOVE '7054'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                               ABEND-TABLES             
              MOVE 'CSS_BILLING_HDR'       TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE 'CODE_BILL_STATUS'      TO TABLE-ELEMENT-2           
              MOVE BI-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
              MOVE 'A OR B'                TO HOSTVAR-ELEMENT-2         
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7054-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * COUNT NUMBER OF MN ROWS WITH READ CODE AWAITING/VERIFIED READ  *        
      ******************************************************************        
       7060-CNT-MN-NO-READS.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
                INTO :WS-MN-AWAITING-RD-COUNT                           
                FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO          = :MN-ACCOUNT-NO               
                 AND CODE_METER_STATUS  <> 'K'                          
                 AND (CODE_CRNT_REG_READ = :WS-AWAITING-READ            
                  OR  CODE_CRNT_REG_READ = :WS-VERIFIED-READ            
                  OR  CODE_CRNT_REG_READ = :WS-NO-READ)                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*         INTO :WS-MN-AWAITING-RD-COUNT                                   
MFA-TR*         FROM CSS_MTRD_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO          = :MN-ACCOUNT-NO                       
MFA-TR*          AND CODE_METER_STATUS  <> 'K'                                  
MFA-TR*          AND (CODE_CRNT_REG_READ = :WS-AWAITING-READ                    
MFA-TR*           OR  CODE_CRNT_REG_READ = :WS-VERIFIED-READ                    
MFA-TR*           OR  CODE_CRNT_REG_READ = :WS-NO-READ)                         
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7060                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'               TO ABEND-PROGRAM            
              MOVE '7060'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_MTRD_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE MN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * COUNT NUMBER OF RG ROWS WITH READ CODE AWAITING/VERIFIED READ  *        
      ******************************************************************        
       7065-CNT-RG-NO-READS.                                            
      *                                                                         
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                 INTO :WS-RG-AWAITING-RD-COUNT                          
                 FROM CSS_REGISTER_READ WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO          = :RG-ACCOUNT-NO              
                  AND CODE_REG_STATUS    <> 'K'                         
                  AND (CODE_CRNT_REG_READ = :WS-AWAITING-READ           
                   OR  CODE_CRNT_REG_READ = :WS-VERIFIED-READ           
                   OR  CODE_CRNT_REG_READ = :WS-NO-READ)                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*          INTO :WS-RG-AWAITING-RD-COUNT                                  
MFA-TR*          FROM CSS_REGISTER_READ                                         
MFA-TR*         WHERE ACCOUNT_NO          = :RG-ACCOUNT-NO                      
MFA-TR*           AND CODE_REG_STATUS    <> 'K'                                 
MFA-TR*           AND (CODE_CRNT_REG_READ = :WS-AWAITING-READ                   
MFA-TR*            OR  CODE_CRNT_REG_READ = :WS-VERIFIED-READ                   
MFA-TR*            OR  CODE_CRNT_REG_READ = :WS-NO-READ)                        
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7065                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'               TO ABEND-PROGRAM            
              MOVE '7065'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_REGISTER_READ'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE RG-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7065-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CHECK WHETHER ACCOUNT EXISTS IN OFF CYCLE TABLE                *        
      ******************************************************************        
       7070-CHECK-OFF-CYCLE.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT '1'                                                
                INTO :WS-OC-EXISTS                                      
                FROM CSS_OFF_CYCL_ACCT WITH(READUNCOMMITTED)                    
               WHERE ACCOUNT_NO         = :OC-ACCOUNT-NO                
                 AND CODE_BILL_OFF_CYCL = 'H'                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT '1'                                                        
MFA-TR*         INTO :WS-OC-EXISTS                                              
MFA-TR*         FROM CSS_OFF_CYCL_ACCT                                          
MFA-TR*        WHERE ACCOUNT_NO         = :OC-ACCOUNT-NO                        
MFA-TR*          AND CODE_BILL_OFF_CYCL = 'H'                                   
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7070                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'               TO ABEND-PROGRAM            
              MOVE '7070'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_OFF_CYCL_ACCT'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE OC-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CHECK WHEN THE CYCLE IS READY TO BILL                          *        
      ******************************************************************        
       7075-CHECK-BILL-DATE.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-DELETE-OFFCYC                                  
                FROM  CSS_BILL_WINDOW WITH(READUNCOMMITTED)                     
               WHERE  BILL_CYCLE               = :BN-BILL-CYCLE         
                 AND  DATE_EXTRACT            >= 
           CAST(SYSDATETIMEOFFSET() AS DATE)           
                 AND  (DATEADD( DAY, -5, DATE_EXTRACT )) <  
           CAST(SYSDATETIMEOFFSET() AS DATE)           
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-DELETE-OFFCYC                                          
MFA-TR*         FROM  CSS_BILL_WINDOW                                           
MFA-TR*        WHERE  BILL_CYCLE               = :BN-BILL-CYCLE                 
MFA-TR*          AND  DATE_EXTRACT            >= CURRENT DATE                   
MFA-TR*          AND  (DATE_EXTRACT - 5 DAYS) <  CURRENT DATE                   
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*        QUERYNO 7075                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'               TO ABEND-PROGRAM            
              MOVE '7075'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_BILL_WINDOW'        TO TABLE-1                  
              MOVE 'BILL_CYCLE'             TO TABLE-ELEMENT-1          
              MOVE BN-BILL-CYCLE            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7075-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       7110-GET-READ-CYCLE.                                             
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               SELECT READ_CYCLE                                        
                 INTO :UT-READ-CYCLE                                    
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE               
                  AND IC_NO          = :UT-IC-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT READ_CYCLE                                                
MFA-TR*          INTO :UT-READ-CYCLE                                            
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                       
MFA-TR*           AND IC_NO          = :UT-IC-NO                                
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7110                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'               TO ABEND-PROGRAM            
              MOVE '7110'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-2          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-3          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE UT-IC-NO                 TO HOSTVAR-ELEMENT-2        
              MOVE UT-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-3        
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7120-SELECT-OPT-READ-DT.                                         
      *================================================================*        
      *  GETS THE OPTIMUM READ DATE FROM CSS_READ_WINDOW               *        
      *----------------------------------------------------------------*        
                                                                        
           EXEC SQL                                                     
               SELECT OPTIMUM_READ_DATE                                 
                 INTO :RW-OPTIMUM-READ-DATE                             
                 FROM CSS_READ_WINDOW WITH(READUNCOMMITTED)                     
                WHERE READ_CYCLE    = :RW-READ-CYCLE                    
                  AND REVENUE_MONTH = :RW-REVENUE-MONTH                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT OPTIMUM_READ_DATE                                         
MFA-TR*          INTO :RW-OPTIMUM-READ-DATE                                     
MFA-TR*          FROM CSS_READ_WINDOW                                           
MFA-TR*         WHERE READ_CYCLE    = :RW-READ-CYCLE                            
MFA-TR*           AND REVENUE_MONTH = :RW-REVENUE-MONTH                         
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7120                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'               TO ABEND-PROGRAM            
              MOVE '7120'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_READ_WINDOW'        TO TABLE-1                  
              MOVE 'READ CYCLE'             TO TABLE-ELEMENT-1          
              MOVE 'REVENUE MONTH'          TO TABLE-ELEMENT-2          
              MOVE RW-READ-CYCLE            TO HOSTVAR-ELEMENT-1        
              MOVE RW-REVENUE-MONTH         TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7125-SELECT-OPT-READ-DT.                                         
      *================================================================*        
      *  GETS THE OPTIMUM READ DATE FROM CSS_READ_WINDOW               *        
      *----------------------------------------------------------------*        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) OPTIMUM_READ_DATE                                 
                 INTO :RW-OPTIMUM-READ-DATE                             
                 FROM CSS_READ_WINDOW WITH(READUNCOMMITTED)                     
                WHERE READ_CYCLE    = :RW-READ-CYCLE                    
                  AND REVENUE_MONTH > :RW-REVENUE-MONTH                 
                 ORDER BY REVENUE_MONTH                                 
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT OPTIMUM_READ_DATE                                         
MFA-TR*          INTO :RW-OPTIMUM-READ-DATE                                     
MFA-TR*          FROM CSS_READ_WINDOW                                           
MFA-TR*         WHERE READ_CYCLE    = :RW-READ-CYCLE                            
MFA-TR*           AND REVENUE_MONTH > :RW-REVENUE-MONTH                         
MFA-TR*          ORDER BY REVENUE_MONTH                                         
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7125                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'               TO ABEND-PROGRAM            
              MOVE '7125'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_READ_WINDOW'        TO TABLE-1                  
              MOVE 'READ CYCLE'             TO TABLE-ELEMENT-1          
              MOVE 'REVENUE MONTH'          TO TABLE-ELEMENT-2          
              MOVE RW-READ-CYCLE            TO HOSTVAR-ELEMENT-1        
              MOVE RW-REVENUE-MONTH         TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7125-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7130-GET-NEXT-DAY.                                               
      *================================================================*        
                                                                        
           EXEC SQL                                                     
                SELECT
              DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, :WS-DB2-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-DB2-DATE
              ) <> 0) OR (LEN(:WS-DB2-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-DB2-DATE
              ), CONVERT(DATE, :WS-DB2-DATE) ) )
            INTO
              :WS-DB2-DATE           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-DB2-DATE = DATE(:WS-DB2-DATE) + 1 DAY                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'               TO ABEND-PROGRAM            
              MOVE '7130'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'INPUT DATE'             TO TABLE-ELEMENT-1          
              MOVE WS-DB2-DATE              TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7154-OPEN-ASSO-IC-CRSR.                                          
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               OPEN ASSO_IC_NO                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'              TO ABEND-PROGRAM             
              MOVE '7154'                  TO ACTIVE-PARAGRAPH          
              MOVE 'OPEN'                  TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_BILLING_DET'       TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE 'BILL_NO'               TO TABLE-ELEMENT-2           
              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-3           
              MOVE BG-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
              MOVE BG-BILL-NO              TO HOSTVAR-ELEMENT-2         
              MOVE BG-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-3         
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7154-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7155-FETCH-ASSO-IC-CRSR.                                         
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               FETCH ASSO_IC_NO                                         
                INTO :WS-OTHER-IC-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'              TO ABEND-PROGRAM             
              MOVE '7155'                  TO ACTIVE-PARAGRAPH          
              MOVE 'OPEN'                  TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_BILLING_DET'       TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE 'BILL_NO'               TO TABLE-ELEMENT-2           
              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-3           
              MOVE BG-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
              MOVE BG-BILL-NO              TO HOSTVAR-ELEMENT-2         
              MOVE BG-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-3         
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7155-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7156-CLOSE-ASSO-IC-CRSR.                                         
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               CLOSE ASSO_IC_NO                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'              TO ABEND-PROGRAM             
              MOVE '7156'                  TO ACTIVE-PARAGRAPH          
              MOVE 'OPEN'                  TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_BILLING_DET'       TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE 'BILL_NO'               TO TABLE-ELEMENT-2           
              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-3           
              MOVE BG-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
              MOVE BG-BILL-NO              TO HOSTVAR-ELEMENT-2         
              MOVE BG-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-3         
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7156-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7180-ADD-ONE-MICROSEC.                                           
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MICROSECOND, 
              1, CIS.CHAR2TIMESTAMP(:WS-TIMESTMP) ), 121), ' ', '-'), 
           ':', '.')
            INTO
              :WS-TIMESTMP            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-TIMESTMP =                                                
MFA-TR*              TIMESTAMP(:WS-TIMESTMP) + 1 MICROSECOND                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'               TO ABEND-PROGRAM            
              MOVE '7180'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'BILL-ITEM-TIMESTMP'     TO TABLE-ELEMENT-1          
              MOVE WS-TIMESTMP              TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7180-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7190-SUB-ONE-MICROSEC.                                           
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MICROSECOND, -1
              , CIS.CHAR2TIMESTAMP(:WS-TIMESTMP) ), 121), ' ', '-'), 
           ':', '.')
            INTO
              :WS-TIMESTMP            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-TIMESTMP =                                                
MFA-TR*              TIMESTAMP(:WS-TIMESTMP) - 1 MICROSECOND                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'               TO ABEND-PROGRAM            
              MOVE '7190'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'BILL-ITEM-TIMESTMP'     TO TABLE-ELEMENT-1          
              MOVE WS-TIMESTMP              TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7190-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7195-CHK-FOR-TRNSP-ROW.                                          
      *================================================================*        
      *  CHECK IF TRANSPORTATION ROW EXISTS AND THEN CALL SUBROUTINE   *        
      *----------------------------------------------------------------*        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                         
                INTO :BG-ACCOUNT-NO                                     
                FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                      
                WHERE ACCOUNT_NO          = :BG-ACCOUNT-NO              
                  AND BILL_NO             = :WS-ORIG-BILL-NO            
                  AND CODE_UTIL_TYPE      = :BG-CODE-UTIL-TYPE          
                  AND IC_NO               = :BG-IC-NO                   
                  AND BILL_ITEM_TIMESTMP  = CIS.CHAR2TIMESTAMP(
                                                           :WS-TIMESTMP
              )                
                  AND REV_RPT_CD          = 'T'                         
                  AND CODE_BILL_ITM_IND   <> 'K'                        
                  AND CODE_BILL_CALC      <> 'S'                        
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*         INTO :BG-ACCOUNT-NO                                             
MFA-TR*         FROM CSS_BILLING_DET                                            
MFA-TR*         WHERE ACCOUNT_NO          = :BG-ACCOUNT-NO                      
MFA-TR*           AND BILL_NO             = :WS-ORIG-BILL-NO                    
MFA-TR*           AND CODE_UTIL_TYPE      = :BG-CODE-UTIL-TYPE                  
MFA-TR*           AND IC_NO               = :BG-IC-NO                           
MFA-TR*           AND BILL_ITEM_TIMESTMP  = :WS-TIMESTMP                        
MFA-TR*           AND REV_RPT_CD          = 'T'                                 
MFA-TR*           AND CODE_BILL_ITM_IND   <> 'K'                                
MFA-TR*           AND CODE_BILL_CALC      <> 'S'                                
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*        QUERYNO 7195                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'               TO ABEND-PROGRAM            
              MOVE '7195'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_BILLING_DET'        TO TABLE-1                  
              MOVE 'ACCOUNT-NO '            TO TABLE-ELEMENT-1          
              MOVE BG-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'BILL-NO    '            TO TABLE-ELEMENT-2          
              MOVE WS-ORIG-BILL-NO          TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7195-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7200-GET-SERVICE-END-DATE.                                       
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              SELECT  DATE_UTIL_SVC_END                                 
                INTO :CH-DATE-UTIL-SVC-END                              
                FROM  CSS_CUST_PREM_HIST WITH(READUNCOMMITTED)                  
               WHERE  ACCOUNT_NO          = :CH-ACCOUNT-NO              
                 AND  CUSTOMER_NO         = :CH-CUSTOMER-NO             
                 AND  PREMISE_NO          = :CH-PREMISE-NO              
                 AND  DATE_UTIL_SVC_END IS NOT NULL                     
                                                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DATE_UTIL_SVC_END                                         
MFA-TR*         INTO :CH-DATE-UTIL-SVC-END                                      
MFA-TR*         FROM  CSS_CUST_PREM_HIST                                        
MFA-TR*        WHERE  ACCOUNT_NO          = :CH-ACCOUNT-NO                      
MFA-TR*          AND  CUSTOMER_NO         = :CH-CUSTOMER-NO                     
MFA-TR*          AND  PREMISE_NO          = :CH-PREMISE-NO                      
MFA-TR*          AND  DATE_UTIL_SVC_END IS NOT NULL                             
MFA-TR*         WITH  UR                                                        
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7200'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE 'CSS_CUST_PREM_HIST'   TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-2            
              MOVE CH-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              MOVE CH-CUSTOMER-NO         TO HOSTVAR-ELEMENT-2          
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7210-OPEN-BILLADJ-CRSR.                                          
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               OPEN BILL_ADJ_CRSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7210'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_ADJUSTMENT'      TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE BP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BP-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE BP-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE BP-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *================================================================*        
       7220-FETCH-BILLADJ-CRSR.                                         
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               FETCH BILL_ADJ_CRSR                                      
                    INTO :BP-ACCOUNT-NO                                 
                        ,:BP-BILL-NO                                    
                        ,:BP-CODE-UTIL-TYPE                             
                        ,:BP-IC-NO                                      
                        ,:BP-BILL-ITEM-TIMESTMP                         
                        ,:BP-ADJ-TYPE-CD                                
                        ,:BP-REVENUE-MONTH                              
                        ,:BP-ADJ-REASON-DESC                            
                        ,:BP-OVRRIDE-RT-REV-MTH                         
                        ,:BP-OVRRIDE-RT-BILL-DT :WS-OVRD-BILL-DT-NULL    
                        ,:BP-OVRRIDE-RT-BILL-CY                         
                        ,:BP-SPECIAL-PROCESS-CD                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           EVALUATE TRUE                                                
              WHEN WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
                 IF WS-OVRD-BILL-DT-NULL < 0                            
                    MOVE SPACES               TO BP-OVRRIDE-RT-BILL-DT  
                 END-IF                                                 
                 IF BILL-WHEN-FUTURE              AND                   
                    BILL-CANCEL-REBILL             AND                  
                    BP-SPECIAL-PROCESS-CD > SPACES                      
                    MOVE SPACES            TO BP-SPECIAL-PROCESS-CD     
                 END-IF                                                 
              WHEN WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
                 CONTINUE                                               
              WHEN OTHER                                                
                 MOVE 'CSR04873'              TO ABEND-PROGRAM          
                 MOVE '7220'                  TO ACTIVE-PARAGRAPH       
                 MOVE 'FETCH'                 TO ABEND-FUNCTION         
                 MOVE SPACES                  TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                 MOVE 'CSS_BILL_ADJUSTMENT'   TO TABLE-1                
                 MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1        
                 MOVE 'BILL_NO'               TO TABLE-ELEMENT-2        
                 MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-3        
                 MOVE 'IC_NO'                 TO TABLE-ELEMENT-4        
                 MOVE BP-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1      
                 MOVE BP-BILL-NO              TO HOSTVAR-ELEMENT-2      
                 MOVE BP-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-3      
                 MOVE BP-IC-NO                TO HOSTVAR-ELEMENT-4      
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
           END-EVALUATE.                                                
                                                                        
       7220-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *================================================================*        
       7230-INSERT-BILLADJ.                                             
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_BILL_ADJUSTMNT(                          
                           ACCOUNT_NO                                   
                          ,BILL_NO                                      
                          ,CODE_UTIL_TYPE                               
                          ,IC_NO                                        
                          ,BILL_ITEM_TIMESTMP                           
                          ,ADJ_TYPE_CD                                  
                          ,REVENUE_MONTH                                
                          ,ADJ_REASON_DESC                              
                          ,OVRRIDE_RT_REV_MTH                           
                          ,OVRRIDE_RT_BILL_DT                           
                          ,OVRRIDE_RT_BILL_CY                           
                          ,SPECIAL_PROCESS_CD)                          
                VALUES  ( :BP-ACCOUNT-NO                                
                         ,:BP-BILL-NO                                   
                         ,:BP-CODE-UTIL-TYPE                            
                         ,:BP-IC-NO                                     
                         ,CIS.CHAR2TIMESTAMP(:BP-BILL-ITEM-TIMESTMP)            
                         ,:BP-ADJ-TYPE-CD                               
                         ,:BP-REVENUE-MONTH                             
                         ,:BP-ADJ-REASON-DESC                           
                         ,:BP-OVRRIDE-RT-REV-MTH                        
                         ,IIF(TRY_CONVERT(DATE, :BP-OVRRIDE-RT-BILL-DT 
                                                :WS-OVRD-BILL-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :BP-OVRRIDE-RT-BILL-DT 
                                                  :WS-OVRD-BILL-DT-NULL
              ) <> 0) OR (LEN(:BP-OVRRIDE-RT-BILL-DT 
                                                  :WS-OVRD-BILL-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:BP-OVRRIDE-RT-BILL-DT 
                                                  :WS-OVRD-BILL-DT-NULL
              ), CONVERT(DATE, :BP-OVRRIDE-RT-BILL-DT 
                                                  :WS-OVRD-BILL-DT-NULL
              ) )   
                         ,:BP-OVRRIDE-RT-BILL-CY                        
                         ,:BP-SPECIAL-PROCESS-CD)                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_BILL_ADJUSTMNT(                                  
MFA-TR*                    ACCOUNT_NO                                           
MFA-TR*                   ,BILL_NO                                              
MFA-TR*                   ,CODE_UTIL_TYPE                                       
MFA-TR*                   ,IC_NO                                                
MFA-TR*                   ,BILL_ITEM_TIMESTMP                                   
MFA-TR*                   ,ADJ_TYPE_CD                                          
MFA-TR*                   ,REVENUE_MONTH                                        
MFA-TR*                   ,ADJ_REASON_DESC                                      
MFA-TR*                   ,OVRRIDE_RT_REV_MTH                                   
MFA-TR*                   ,OVRRIDE_RT_BILL_DT                                   
MFA-TR*                   ,OVRRIDE_RT_BILL_CY                                   
MFA-TR*                   ,SPECIAL_PROCESS_CD)                                  
MFA-TR*         VALUES  ( :BP-ACCOUNT-NO                                        
MFA-TR*                  ,:BP-BILL-NO                                           
MFA-TR*                  ,:BP-CODE-UTIL-TYPE                                    
MFA-TR*                  ,:BP-IC-NO                                             
MFA-TR*                  ,:BP-BILL-ITEM-TIMESTMP                                
MFA-TR*                  ,:BP-ADJ-TYPE-CD                                       
MFA-TR*                  ,:BP-REVENUE-MONTH                                     
MFA-TR*                  ,:BP-ADJ-REASON-DESC                                   
MFA-TR*                  ,:BP-OVRRIDE-RT-REV-MTH                                
MFA-TR*                  ,:BP-OVRRIDE-RT-BILL-DT:WS-OVRD-BILL-DT-NULL           
MFA-TR*                  ,:BP-OVRRIDE-RT-BILL-CY                                
MFA-TR*                  ,:BP-SPECIAL-PROCESS-CD)                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR -803           
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7230'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_ADJUSTMENT'      TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE BP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BP-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE BP-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE BP-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7230-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *================================================================*        
       7240-CLOSE-BILLADJ-CRSR.                                         
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               CLOSE BILL_ADJ_CRSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7240'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_ADJUSTMENT'      TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE BP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BP-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE BP-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE BP-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7240-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *================================================================*        
       7250-UPDATE-BILLADJ.                                             
      *================================================================*        
      * UPDATE ALL REBILLS WITH SAME ADJ REASON (last one update all)           
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_BILL_ADJUSTMNT                                
                  SET ADJ_REASON_DESC      = :BP-ADJ-REASON-DESC        
                  WHERE ACCOUNT_NO         = :BP-ACCOUNT-NO             
                    AND BILL_NO            = :BP-BILL-NO                
                    AND CODE_UTIL_TYPE     = :BP-CODE-UTIL-TYPE         
                    AND IC_NO              = :BP-IC-NO                  
                    AND ADJ_TYPE_CD        = 'BADJ'                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
      ****     AND BILL_ITEM_TIMESTMP = :BP-BILL-ITEM-TIMESTMP                  
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7250'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_ADJUSTMENT'      TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE BP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BP-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE BP-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE BP-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *================================================================*        
       7300-OPEN-REBILL-CSR.                                            
      *================================================================*        
                                                                        
           EXEC SQL                                                     
                OPEN REBILL_CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7300'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-2         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-3         
              MOVE FH-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FH-IC-NO                  TO HOSTVAR-ELEMENT-2       
              MOVE FH-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7310-FETCH-REBILL-CSR.                                           
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               FETCH REBILL_CSR                                         
                INTO :WS-BILL-ITEM-TIMESTMP1                            
                    ,:WS-BILL-NO1                                       
                    ,:WS-REV-MTH-ORIG-BILL1                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7310'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-2         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-3         
              MOVE FH-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FH-IC-NO                  TO HOSTVAR-ELEMENT-2       
              MOVE FH-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7320-CLOSE-REBILL-CSR.                                           
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               CLOSE REBILL_CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7320'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-2         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-3         
              MOVE FH-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FH-IC-NO                  TO HOSTVAR-ELEMENT-2       
              MOVE FH-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7330-CHECK-FH-EXISTS.                                            
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              SELECT FH.FIXED_FCTR_SEQ_NO                               
                INTO :FH-FIXED-FCTR-SEQ-NO                              
                FROM CSS_FIXED_FCT_HIST  FH WITH(READUNCOMMITTED)               
               WHERE FH.ACCOUNT_NO           =  :FH-ACCOUNT-NO          
                 AND FH.BILL_NO              =  :WS-BILL-NO1            
                 AND FH.CODE_UTIL_TYPE       =  :FH-CODE-UTIL-TYPE      
                 AND FH.IC_NO                =  :FH-IC-NO               
                 AND FH.BILL_ITEM_TIMESTMP   =  CIS.CHAR2TIMESTAMP(
                                                :WS-BILL-ITEM-TIMESTMP1
              ) 
                 AND FH.FACTOR_ID            =  :FH-FACTOR-ID           
                 AND FH.CMPNT_ID_CD          =  :FH-CMPNT-ID-CD         
                 AND FH.FACTOR               =  :FH-FACTOR              
                 AND FH.CODE_DEBIT_CREDIT    =  :FH-CODE-DEBIT-CREDIT   
                 AND FH.CODE_TIME_PERIOD     =  :FH-CODE-TIME-PERIOD    
                 AND FH.INSTR_USE_TYPE_CD    =  :FH-INSTR-USE-TYPE-CD   
                 AND FH.CODE_SEASON          =  :FH-CODE-SEASON         
                 AND FH.EFF_DATE_FROM        = IIF(TRY_CONVERT(DATE, 
                                                      :FH-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FH-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FH-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FH-EFF-DATE-FROM
              ), CONVERT(DATE, :FH-EFF-DATE-FROM) )        
                 AND FH.EFF_DATE_TO          = IIF(TRY_CONVERT(DATE, 
                                                        :FH-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FH-EFF-DATE-TO
              ) <> 0) OR (LEN(:FH-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FH-EFF-DATE-TO
              ), CONVERT(DATE, :FH-EFF-DATE-TO) )          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FH.FIXED_FCTR_SEQ_NO                                       
MFA-TR*         INTO :FH-FIXED-FCTR-SEQ-NO                                      
MFA-TR*         FROM CSS_FIXED_FCT_HIST  FH                                     
MFA-TR*        WHERE FH.ACCOUNT_NO           =  :FH-ACCOUNT-NO                  
MFA-TR*          AND FH.BILL_NO              =  :WS-BILL-NO1                    
MFA-TR*          AND FH.CODE_UTIL_TYPE       =  :FH-CODE-UTIL-TYPE              
MFA-TR*          AND FH.IC_NO                =  :FH-IC-NO                       
MFA-TR*          AND FH.BILL_ITEM_TIMESTMP   =  :WS-BILL-ITEM-TIMESTMP1         
MFA-TR*          AND FH.FACTOR_ID            =  :FH-FACTOR-ID                   
MFA-TR*          AND FH.CMPNT_ID_CD          =  :FH-CMPNT-ID-CD                 
MFA-TR*          AND FH.FACTOR               =  :FH-FACTOR                      
MFA-TR*          AND FH.CODE_DEBIT_CREDIT    =  :FH-CODE-DEBIT-CREDIT           
MFA-TR*          AND FH.CODE_TIME_PERIOD     =  :FH-CODE-TIME-PERIOD            
MFA-TR*          AND FH.INSTR_USE_TYPE_CD    =  :FH-INSTR-USE-TYPE-CD           
MFA-TR*          AND FH.CODE_SEASON          =  :FH-CODE-SEASON                 
MFA-TR*          AND FH.EFF_DATE_FROM        = :FH-EFF-DATE-FROM                
MFA-TR*          AND FH.EFF_DATE_TO          = :FH-EFF-DATE-TO                  
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7330                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
                                                OR -811                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7330'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-TABLES               
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
              MOVE 'CSS_FIXED_FCT_HIST'   TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE 'BILL_NO'              TO TABLE-ELEMENT-2            
              MOVE 'IC_NO'                TO TABLE-ELEMENT-3            
              MOVE 'BILL_ITEM_TIMESTAMP'  TO TABLE-ELEMENT-4            
              MOVE FH-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              MOVE WS-BILL-NO1            TO HOSTVAR-ELEMENT-2          
              MOVE FH-IC-NO               TO HOSTVAR-ELEMENT-3          
              MOVE WS-BILL-ITEM-TIMESTMP1 TO HOSTVAR-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7330-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
      *================================================================*        
       7410-SELECT-BILL-HEADER.                                         
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              SELECT CODE_BILL_STATUS                                   
                    ,DATE_BILLED                                        
                    ,CODE_BILL_TYPE                                     
                    ,CODE_BILL_REASON                                   
               INTO :BI-CODE-BILL-STATUS                                
                   ,:BI-DATE-BILLED :WS-DATE-BILLED-NULL                 
                   ,:BI-CODE-BILL-TYPE                                  
                   ,:BI-CODE-BILL-REASON                                
               FROM CSS_BILLING_HDR WITH(READUNCOMMITTED)                       
              WHERE ACCOUNT_NO = :BI-ACCOUNT-NO                         
                AND BILL_NO    = :BI-BILL-NO                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_BILL_STATUS                                           
MFA-TR*             ,DATE_BILLED                                                
MFA-TR*             ,CODE_BILL_TYPE                                             
MFA-TR*             ,CODE_BILL_REASON                                           
MFA-TR*        INTO :BI-CODE-BILL-STATUS                                        
MFA-TR*            ,:BI-DATE-BILLED:WS-DATE-BILLED-NULL                         
MFA-TR*            ,:BI-CODE-BILL-TYPE                                          
MFA-TR*            ,:BI-CODE-BILL-REASON                                        
MFA-TR*        FROM CSS_BILLING_HDR                                             
MFA-TR*       WHERE ACCOUNT_NO = :BI-ACCOUNT-NO                                 
MFA-TR*         AND BILL_NO    = :BI-BILL-NO                                    
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7410                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'              TO ABEND-PROGRAM             
              MOVE '7410'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_BILLING_HDR'       TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO HOSTVAR-ELEMENT-1         
              MOVE 'BILL_NO'               TO HOSTVAR-ELEMENT-2         
              MOVE BI-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
              MOVE BI-BILL-NO              TO HOSTVAR-ELEMENT-2         
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7420-GET-MAX-CNSMPTN-SEQ.                                        
      *================================================================*        
      * GET MAX SEQ-NO BEFORE INSERTING A ROW INTO CX                  *        
      *----------------------------------------------------------------*        
                                                                        
           EXEC SQL                                                     
               SELECT COALESCE(MAX(ITEM_SEQ_NO) + 1,1)                    
                 INTO :CX-ITEM-SEQ-NO                                   
                 FROM CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO               
                  AND BILL_NO            = :CX-BILL-NO                  
                  AND CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE           
                  AND IC_NO              = :CX-IC-NO                    
                  AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )       
                  AND CODE_TIME_PERIOD   = :CX-CODE-TIME-PERIOD         
                  AND MTR_REF_NO         = :CX-MTR-REF-NO               
                  AND REG_ID_NO          = :CX-REG-ID-NO                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT IFNULL(MAX(ITEM_SEQ_NO) + 1,1)                            
MFA-TR*          INTO :CX-ITEM-SEQ-NO                                           
MFA-TR*          FROM CSS_CNSMPTN_HIST                                          
MFA-TR*         WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO                       
MFA-TR*           AND BILL_NO            = :CX-BILL-NO                          
MFA-TR*           AND CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE                   
MFA-TR*           AND IC_NO              = :CX-IC-NO                            
MFA-TR*           AND BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP               
MFA-TR*           AND CODE_TIME_PERIOD   = :CX-CODE-TIME-PERIOD                 
MFA-TR*           AND MTR_REF_NO         = :CX-MTR-REF-NO                       
MFA-TR*           AND REG_ID_NO          = :CX-REG-ID-NO                        
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7420                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7420'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CNSMPTN_HIST'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE CX-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE CX-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE CX-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE CX-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7450-GET-BADJ-ADJST-RSN-CD.                                      
      *================================================================*        
      * GET ADJUSTMENT REASON CODE.                                    *        
      *----------------------------------------------------------------*        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) K0.ADJ_REASON_CD                                   
                INTO :IN-BG-ADJ-REASON-CD                               
                FROM CSS_BILL_ADJ_REASN    K0 WITH(READUNCOMMITTED)             
               WHERE ADJ_REASON_DESC     = :K0-ADJ-REASON-DESC          
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT K0.ADJ_REASON_CD                                           
MFA-TR*         INTO :IN-BG-ADJ-REASON-CD                                       
MFA-TR*         FROM CSS_BILL_ADJ_REASN    K0                                   
MFA-TR*        WHERE ADJ_REASON_DESC     = :K0-ADJ-REASON-DESC                  
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE '999'                   TO IN-BG-ADJ-REASON-CD    
              END-IF                                                    
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7450'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_ADJ_REASN'       TO TABLE-1                
              MOVE 'ADJ_REASON_DESC'          TO TABLE-ELEMENT-1        
              MOVE K0-ADJ-REASON-DESC         TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7450-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
                                                                        
      *================================================================*        
       7490-OPEN-FH-MAINT-CRSR.                                         
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               OPEN FH_MAINT_CRSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7490'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_FIXED_FCT_HIST'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE FH-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE FH-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE FH-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE FH-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7490-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7495-FETCH-FH-MAINT-CRSR.                                        
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               FETCH FH_MAINT_CRSR                                      
                    INTO :FH-FIXED-FCTR-SEQ-NO                          
                        ,:FH-FACTOR-ID                                  
                        ,:FH-EFF-DATE-FROM :WS-EFF-DATE-FROM-NULL        
                        ,:FH-CMPNT-ID-CD                                
                        ,:FH-CODE-SEASON                                
                        ,:FH-INSTR-USE-TYPE-CD                          
                        ,:FH-CODE-TIME-PERIOD                           
                        ,:FH-CODE-DEBIT-CREDIT                          
                        ,:FH-CODE-REVENUE-CLASS                         
                        ,:FH-CODE-TAX-STAT-XMT                          
                        ,:FH-CODE-TAX-CITY-XMT                          
                        ,:FH-CODE-TAX-OTHR-XMT                          
                        ,:FH-FACTOR                                     
                        ,:FH-EFF-DATE-TO :WS-EFF-DATE-TO-NULL            
                        ,:FH-FIXED-FCTR-TYP-CD                          
                        ,:FH-BILL-UNITS                                 
                        ,:FH-ENERGY-UNIT-CD                             
                        ,:FH-DURATION-REMAIN-NO :WS-DURATION-NULL        
                        ,:FH-OVR-RT-VER-PRO-FL                          
                        ,:FH-RT-PKG-OPT-SEQ-NO                          
                        ,:WS-FACTOR-HISTORY-CD                          
                        ,:SF-SPCL-GROUP-CD                              
                        ,:FH-BLOCK-NO                                   
                        ,:FH-FCTR-POWER-10                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7495'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_FIXED_FCT_HIST'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE FH-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE FH-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE FH-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE FH-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7495-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7500-CLOSE-FH-CRSR.                                              
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               CLOSE FH_MAINT_CRSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7500'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_FIXED_FCT_HIST'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE FH-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE FH-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE FH-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE FH-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7510-SELECT-MTRD-ENVRNMT.                                        
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               SELECT DIGTL_MTR_TYPE                                    
                     ,MTR_READ_SOURCE_CD                                
                     ,METER_PRESSURE                                    
                     ,INDUST_BTU_ID                                     
                     ,CODE_CRNT_REG_READ                                
                     ,CODE_LAST_REG_READ                                
                     ,LAST_REG_READ_DATE                                
                     ,REPLACE(CONVERT(CHAR(8), LAST_REG_READ_TIME
           , 108), ':', '.') LAST_REG_READ_TIME                                
                     ,LAST_READ_VALUE                                   
                     ,NO_CONSEC_ESTIMATE                                
                     ,CODE_DATA_PRESENT                                 
                     ,EXCEPT_OVERRIDE_CD                                
                     ,REG_ID_NO                                         
                     ,MIN_NO_UNITS                                      
                     ,MAX_NO_UNITS                                      
                 INTO :MN-DIGTL-MTR-TYPE                                
                     ,:MN-MTR-READ-SOURCE-CD                            
                     ,:MN-METER-PRESSURE                                
                     ,:MN-INDUST-BTU-ID                                 
                     ,:MN-CODE-CRNT-REG-READ                            
                     ,:MN-CODE-LAST-REG-READ                            
                     ,:MN-LAST-REG-READ-DATE :WS-NULL-1                 
                     ,:MN-LAST-REG-READ-TIME :WS-NULL-2                 
                     ,:MN-LAST-READ-VALUE                               
                     ,:MN-NO-CONSEC-ESTIMATE                            
                     ,:MN-CODE-DATA-PRESENT                             
                     ,:MN-EXCEPT-OVERRIDE-CD                            
                     ,:MN-REG-ID-NO                                     
                     ,:MN-MIN-NO-UNITS                                  
                     ,:MN-MAX-NO-UNITS                                  
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO       = :MN-ACCOUNT-NO                 
                  AND CODE_UTIL_TYPE   = :MN-CODE-UTIL-TYPE             
                  AND METER_NO         = :MN-METER-NO                   
                  AND IC_NO            = :MN-IC-NO                      
                  AND MTR_REF_NO       = :MN-MTR-REF-NO                 
                  AND CODE_USAGE_TYPE  = :MN-CODE-USAGE-TYPE            
                  AND CODE_TIME_PERIOD = :MN-CODE-TIME-PERIOD           
                  AND CODE_USAGE_ID    = :MN-CODE-USAGE-ID              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DIGTL_MTR_TYPE                                            
MFA-TR*              ,MTR_READ_SOURCE_CD                                        
MFA-TR*              ,METER_PRESSURE                                            
MFA-TR*              ,INDUST_BTU_ID                                             
MFA-TR*              ,CODE_CRNT_REG_READ                                        
MFA-TR*              ,CODE_LAST_REG_READ                                        
MFA-TR*              ,LAST_REG_READ_DATE                                        
MFA-TR*              ,LAST_REG_READ_TIME                                        
MFA-TR*              ,LAST_READ_VALUE                                           
MFA-TR*              ,NO_CONSEC_ESTIMATE                                        
MFA-TR*              ,CODE_DATA_PRESENT                                         
MFA-TR*              ,EXCEPT_OVERRIDE_CD                                        
MFA-TR*              ,REG_ID_NO                                                 
MFA-TR*              ,MIN_NO_UNITS                                              
MFA-TR*              ,MAX_NO_UNITS                                              
MFA-TR*          INTO :MN-DIGTL-MTR-TYPE                                        
MFA-TR*              ,:MN-MTR-READ-SOURCE-CD                                    
MFA-TR*              ,:MN-METER-PRESSURE                                        
MFA-TR*              ,:MN-INDUST-BTU-ID                                         
MFA-TR*              ,:MN-CODE-CRNT-REG-READ                                    
MFA-TR*              ,:MN-CODE-LAST-REG-READ                                    
MFA-TR*              ,:MN-LAST-REG-READ-DATE :WS-NULL-1                         
MFA-TR*              ,:MN-LAST-REG-READ-TIME :WS-NULL-2                         
MFA-TR*              ,:MN-LAST-READ-VALUE                                       
MFA-TR*              ,:MN-NO-CONSEC-ESTIMATE                                    
MFA-TR*              ,:MN-CODE-DATA-PRESENT                                     
MFA-TR*              ,:MN-EXCEPT-OVERRIDE-CD                                    
MFA-TR*              ,:MN-REG-ID-NO                                             
MFA-TR*              ,:MN-MIN-NO-UNITS                                          
MFA-TR*              ,:MN-MAX-NO-UNITS                                          
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO       = :MN-ACCOUNT-NO                         
MFA-TR*           AND CODE_UTIL_TYPE   = :MN-CODE-UTIL-TYPE                     
MFA-TR*           AND METER_NO         = :MN-METER-NO                           
MFA-TR*           AND IC_NO            = :MN-IC-NO                              
MFA-TR*           AND MTR_REF_NO       = :MN-MTR-REF-NO                         
MFA-TR*           AND CODE_USAGE_TYPE  = :MN-CODE-USAGE-TYPE                    
MFA-TR*           AND CODE_TIME_PERIOD = :MN-CODE-TIME-PERIOD                   
MFA-TR*           AND CODE_USAGE_ID    = :MN-CODE-USAGE-ID                      
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7510                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'              TO ABEND-PROGRAM             
              MOVE '7510'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_MTRD_ENVRNMT'      TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2           
              MOVE 'IC_NO'                 TO TABLE-ELEMENT-3           
              MOVE 'MTR_REF_NO'            TO TABLE-ELEMENT-4           
              MOVE MN-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
              MOVE MN-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2         
              MOVE MN-IC-NO                TO HOSTVAR-ELEMENT-3         
              MOVE MN-MTR-REF-NO           TO HOSTVAR-ELEMENT-4         
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7520-SELECT-REGISTER-READ.                                       
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               SELECT CODE_REG_STATUS                                   
                     ,CODE_STATUS_REAS                                  
                     ,CODE_LAST_REG_READ                                
                     ,LAST_REG_READ_DT                                  
                     ,REPLACE(CONVERT(CHAR(8), LAST_REG_READ_TM, 108), 
           ':', '.') LAST_REG_READ_TM                                  
                     ,LAST_READ_VALUE                                   
                     ,CODE_CRNT_REG_READ                                
                     ,REG_ID_NO                                         
                     ,MIN_NO_UNITS                                      
                     ,MAX_NO_UNITS                                      
                 INTO :RG-CODE-REG-STATUS                               
                     ,:RG-CODE-STATUS-REAS                              
                     ,:RG-CODE-LAST-REG-READ                            
                     ,:RG-LAST-REG-READ-DT :WS-NULL-5                   
                     ,:RG-LAST-REG-READ-TM :WS-NULL-6                   
                     ,:RG-LAST-READ-VALUE                               
                     ,:RG-CODE-CRNT-REG-READ                            
                     ,:RG-REG-ID-NO                                     
                     ,:RG-MIN-NO-UNITS                                  
                     ,:RG-MAX-NO-UNITS                                  
                 FROM CSS_REGISTER_READ WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO       = :RG-ACCOUNT-NO                 
                  AND CODE_UTIL_TYPE   = :RG-CODE-UTIL-TYPE             
                  AND IC_NO            = :RG-IC-NO                      
                  AND METER_NO         = :RG-METER-NO                   
                  AND MTR_REF_NO       = :RG-MTR-REF-NO                 
                  AND CODE_USAGE_TYPE  = :RG-CODE-USAGE-TYPE            
                  AND CODE_TIME_PERIOD = :RG-CODE-TIME-PERIOD           
                  AND CODE_USAGE_ID    = :RG-CODE-USAGE-ID              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_REG_STATUS                                           
MFA-TR*              ,CODE_STATUS_REAS                                          
MFA-TR*              ,CODE_LAST_REG_READ                                        
MFA-TR*              ,LAST_REG_READ_DT                                          
MFA-TR*              ,LAST_REG_READ_TM                                          
MFA-TR*              ,LAST_READ_VALUE                                           
MFA-TR*              ,CODE_CRNT_REG_READ                                        
MFA-TR*              ,REG_ID_NO                                                 
MFA-TR*              ,MIN_NO_UNITS                                              
MFA-TR*              ,MAX_NO_UNITS                                              
MFA-TR*          INTO :RG-CODE-REG-STATUS                                       
MFA-TR*              ,:RG-CODE-STATUS-REAS                                      
MFA-TR*              ,:RG-CODE-LAST-REG-READ                                    
MFA-TR*              ,:RG-LAST-REG-READ-DT :WS-NULL-5                           
MFA-TR*              ,:RG-LAST-REG-READ-TM :WS-NULL-6                           
MFA-TR*              ,:RG-LAST-READ-VALUE                                       
MFA-TR*              ,:RG-CODE-CRNT-REG-READ                                    
MFA-TR*              ,:RG-REG-ID-NO                                             
MFA-TR*              ,:RG-MIN-NO-UNITS                                          
MFA-TR*              ,:RG-MAX-NO-UNITS                                          
MFA-TR*          FROM CSS_REGISTER_READ                                         
MFA-TR*         WHERE ACCOUNT_NO       = :RG-ACCOUNT-NO                         
MFA-TR*           AND CODE_UTIL_TYPE   = :RG-CODE-UTIL-TYPE                     
MFA-TR*           AND IC_NO            = :RG-IC-NO                              
MFA-TR*           AND METER_NO         = :RG-METER-NO                           
MFA-TR*           AND MTR_REF_NO       = :RG-MTR-REF-NO                         
MFA-TR*           AND CODE_USAGE_TYPE  = :RG-CODE-USAGE-TYPE                    
MFA-TR*           AND CODE_TIME_PERIOD = :RG-CODE-TIME-PERIOD                   
MFA-TR*           AND CODE_USAGE_ID    = :RG-CODE-USAGE-ID                      
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7520                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'              TO ABEND-PROGRAM             
              MOVE '7520'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_REGISTER_READ'     TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2           
              MOVE 'IC_NO'                 TO TABLE-ELEMENT-3           
              MOVE 'MTR_REF_NO'            TO TABLE-ELEMENT-4           
              MOVE RG-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
              MOVE RG-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2         
              MOVE RG-IC-NO                TO HOSTVAR-ELEMENT-3         
              MOVE RG-MTR-REF-NO           TO HOSTVAR-ELEMENT-4         
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7610-OPEN-BILL-COPY-ACT-CRSR.                                    
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               OPEN BILL_COPY_ACT_CRSR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7610'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILLING_DET'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BG-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7620-FETCH-BILL-COPY-ACT-CRSR.                                   
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               FETCH BILL_COPY_ACT_CRSR                                 
                INTO :BG-PREMISE-NO                                     
                    ,:BG-BILL-NO                                        
                    ,:BG-CODE-UTIL-TYPE                                 
                    ,:BG-IC-NO                                          
                    ,:BG-BILL-ITEM-TIMESTMP                             
                    ,:BG-DATE-ORIG-BILL :WS-DATE-ORIG-BILL-NULL2         
                    ,:BG-AMT-BILL-ITEM                                  
                    ,:BG-CODE-BILL-CALC                                 
                    ,:BG-CODE-BILL-ITM-TYPE                             
                    ,:BG-CODE-BILL-ITM-IND                              
                    ,:BG-CODE-DR-CR-CNSMPTN                             
                    ,:BG-AMT-STATE-TAX                                  
                    ,:BG-AMT-CITY-TAX                                   
                    ,:BG-AMT-OTHER-TAX                                  
                    ,:BG-CODE-REVENUE-CLASS                             
                    ,:BG-CODE-SIC-NO                                    
                    ,:BG-RATE-PLAN-NO                                   
                    ,:BG-CODE-CURTAIL-PRTY                              
                    ,:BG-CODE-STAT-TAX-XMT                              
                    ,:BG-CODE-CITY-TAX-XMT                              
                    ,:BG-CODE-OTHR-TAX-XMT                              
                    ,:BG-REV-RPT-CD                                     
                    ,:BG-STANDBY-COMPLIED                               
                    ,:BG-PRORATE-CD                                     
                    ,:BG-NEW-RATE-PCT                                   
                    ,:BG-CODE-SUB-TOTAL                                 
                    ,:BG-TAX-REFUND-CD                                  
                    ,:BG-ACCOUNT-NO                                     
                    ,:BG-COMPANY-NO                                     
                    ,:BG-DATE-LFTM-HI-DMD :WS-DATE-LFTM-HI-DMD-NULL      
                    ,:BG-LFTM-HI-PEAK-DMD                               
                    ,:BG-REBILL-IND                                     
                    ,:BG-ADJ-REASON-CD                                  
                    ,:BG-REVENUE-MONTH                                  
                    ,:BG-GAS-BASE-USE                                   
                    ,:BG-WNA-FACTOR                                     
                    ,:BG-BTU-FACTOR                                     
                    ,:BG-NO-OF-CONS-DAYS                                
                    ,:BG-REV-MTH-ORIG-BILL                              
                    ,:BG-REV-DISTRICT-CD                                
                    ,:BG-FUEL-SHIPPER-CD                                
                    ,:BG-ALTERNATE-FUEL-CD                              
                    ,:BG-TRNSP-OVER-MDQ-FL                              
                    ,:BG-CITY-TAX-RATE                                  
                    ,:BG-OTHER-TAX-RATE                                 
                    ,:BG-STATE-TAX-RATE                                 
                    ,:BG-BILL-CALC-CYCLE                                
                    ,:BG-NAICS-CD                                       
                    ,:BG-RT-PKG-OPT-SEQ-NO :WS-RT-PKG-NULL               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7620'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILLING_DET'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BG-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7620-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7630-CLOSE-BILL-COPY-ACT-CRSR.                                   
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               CLOSE BILL_COPY_ACT_CRSR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7630'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILLING_DET'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BG-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7630-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7650-GET-MIN-REV-MTH.                                            
      *================================================================*        
      * GET MINIMUM REVENUE MONTH USING BILL_CYCLE & CURRENT DATE      *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                     
              SELECT MIN(BN.REVENUE_MONTH)                              
                INTO :BN-REVENUE-MONTH                                  
                FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                   
               WHERE BN.BILL_CYCLE   = :BN-BILL-CYCLE                   
                 AND BN.DATE_EXTRACT >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MIN(BN.REVENUE_MONTH)                                      
MFA-TR*         INTO :BN-REVENUE-MONTH                                          
MFA-TR*         FROM CSS_BILL_WINDOW BN                                         
MFA-TR*        WHERE BN.BILL_CYCLE   = :BN-BILL-CYCLE                           
MFA-TR*          AND BN.DATE_EXTRACT >= CURRENT DATE                            
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7650                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7650'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-TABLES               
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
              MOVE 'CSS_BILL_WINDOW'      TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE 'BILL_CYCLE'           TO TABLE-ELEMENT-2            
              MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              MOVE BN-BILL-CYCLE          TO HOSTVAR-ELEMENT-2          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7660-CHECK-FH-AGL-EXISTS.                                        
      *================================================================*        
      **CHECK IF FIXED_FCT_HIST ROW ALREADY EXISTS                    **        
      *----------------------------------------------------------------*        
                                                                        
           EXEC SQL                                                     
              SELECT FH.FACTOR,                                         
                     FH.FIXED_FCTR_SEQ_NO,                              
                     FH.FCTR_POWER_10                                   
                INTO :FH-FACTOR,                                        
                     :FH-FIXED-FCTR-SEQ-NO,                             
                     :FH-FCTR-POWER-10                                  
                FROM CSS_FIXED_FCT_HIST  FH WITH(READUNCOMMITTED)               
               WHERE FH.ACCOUNT_NO           =  :FH-ACCOUNT-NO          
                 AND FH.BILL_NO              =  :FH-BILL-NO             
                 AND FH.CODE_UTIL_TYPE       =  :FH-CODE-UTIL-TYPE      
                 AND FH.IC_NO                =  :FH-IC-NO               
                 AND FH.BILL_ITEM_TIMESTMP   =  CIS.CHAR2TIMESTAMP(
                                                 :FH-BILL-ITEM-TIMESTMP
              )  
                 AND FH.FACTOR_ID            =  :FH-FACTOR-ID           
                 AND FH.EFF_DATE_FROM        <= IIF(TRY_CONVERT(DATE, 
                                                      :FH-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FH-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FH-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FH-EFF-DATE-FROM
              ), CONVERT(DATE, :FH-EFF-DATE-FROM) )       
                 AND FH.EFF_DATE_TO          >= IIF(TRY_CONVERT(DATE, 
                                                      :FH-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FH-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FH-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FH-EFF-DATE-FROM
              ), CONVERT(DATE, :FH-EFF-DATE-FROM) )       
                 AND FH.DURATION_REMAIN_NO   > 0                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FH.FACTOR,                                                 
MFA-TR*              FH.FIXED_FCTR_SEQ_NO,                                      
MFA-TR*              FH.FCTR_POWER_10                                           
MFA-TR*         INTO :FH-FACTOR,                                                
MFA-TR*              :FH-FIXED-FCTR-SEQ-NO,                                     
MFA-TR*              :FH-FCTR-POWER-10                                          
MFA-TR*         FROM CSS_FIXED_FCT_HIST  FH                                     
MFA-TR*        WHERE FH.ACCOUNT_NO           =  :FH-ACCOUNT-NO                  
MFA-TR*          AND FH.BILL_NO              =  :FH-BILL-NO                     
MFA-TR*          AND FH.CODE_UTIL_TYPE       =  :FH-CODE-UTIL-TYPE              
MFA-TR*          AND FH.IC_NO                =  :FH-IC-NO                       
MFA-TR*          AND FH.BILL_ITEM_TIMESTMP   =  :FH-BILL-ITEM-TIMESTMP          
MFA-TR*          AND FH.FACTOR_ID            =  :FH-FACTOR-ID                   
MFA-TR*          AND FH.EFF_DATE_FROM        <= :FH-EFF-DATE-FROM               
MFA-TR*          AND FH.EFF_DATE_TO          >= :FH-EFF-DATE-FROM               
MFA-TR*          AND FH.DURATION_REMAIN_NO   > 0                                
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7660                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7660'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-TABLES               
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
              MOVE 'CSS_FIXED_FCT_HIST'   TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE 'BILL_NO'              TO TABLE-ELEMENT-2            
              MOVE 'IC_NO'                TO TABLE-ELEMENT-3            
              MOVE 'BILL_ITEM_TIMESTAMP'  TO TABLE-ELEMENT-4            
              MOVE FH-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              MOVE FH-BILL-NO             TO HOSTVAR-ELEMENT-2          
              MOVE FH-IC-NO               TO HOSTVAR-ELEMENT-3          
              MOVE FH-BILL-ITEM-TIMESTMP  TO HOSTVAR-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7660-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7670-CHECK-FF-AGL-EXISTS.                                        
      *================================================================*        
      **CHECK IF FIXED_FCTR ROW ALREADY EXISTS                         *        
      *----------------------------------------------------------------*        
                                                                        
           EXEC SQL                                                     
              SELECT FF.FACTOR,                                         
                     FF.FIXED_FCTR_SEQ_NO,                              
                     SF.FCTR_POWER_10                                   
                INTO :FF-FACTOR,                                        
                     :FF-FIXED-FCTR-SEQ-NO,                             
                     :SF-FCTR-POWER-10                                  
                FROM CSS_FIXED_FCTR  FF WITH(READUNCOMMITTED)                   
                    ,CSS_SPCL_FCTR   SF WITH(READUNCOMMITTED)                   
               WHERE FF.ACCOUNT_NO           =  :FF-ACCOUNT-NO          
                 AND FF.CODE_UTIL_TYPE       =  :FF-CODE-UTIL-TYPE      
                 AND FF.IC_NO                =  :FF-IC-NO               
                 AND FF.FACTOR_ID            =  :FF-FACTOR-ID           
                 AND FF.FACTOR_ID            =  SF.FACTOR_ID            
                 AND FF.EFF_DATE_FROM        <= IIF(TRY_CONVERT(DATE, 
                                                      :FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FF-EFF-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM) )       
                 AND FF.EFF_DATE_TO          >= IIF(TRY_CONVERT(DATE, 
                                                      :FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FF-EFF-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM) )       
                 AND FF.DURATION_REMAIN_NO   > 0                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FF.FACTOR,                                                 
MFA-TR*              FF.FIXED_FCTR_SEQ_NO,                                      
MFA-TR*              SF.FCTR_POWER_10                                           
MFA-TR*         INTO :FF-FACTOR,                                                
MFA-TR*              :FF-FIXED-FCTR-SEQ-NO,                                     
MFA-TR*              :SF-FCTR-POWER-10                                          
MFA-TR*         FROM CSS_FIXED_FCTR  FF                                         
MFA-TR*             ,CSS_SPCL_FCTR   SF                                         
MFA-TR*        WHERE FF.ACCOUNT_NO           =  :FF-ACCOUNT-NO                  
MFA-TR*          AND FF.CODE_UTIL_TYPE       =  :FF-CODE-UTIL-TYPE              
MFA-TR*          AND FF.IC_NO                =  :FF-IC-NO                       
MFA-TR*          AND FF.FACTOR_ID            =  :FF-FACTOR-ID                   
MFA-TR*          AND FF.FACTOR_ID            =  SF.FACTOR_ID                    
MFA-TR*          AND FF.EFF_DATE_FROM        <= :FF-EFF-DATE-FROM               
MFA-TR*          AND FF.EFF_DATE_TO          >= :FF-EFF-DATE-FROM               
MFA-TR*          AND FF.DURATION_REMAIN_NO   > 0                                
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7670                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7670'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-TABLES               
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
              MOVE 'CSS_FIXED_FCTR'       TO TABLE-1                    
              MOVE 'CSS_SPCL_FCTR'        TO TABLE-2                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2            
              MOVE 'IC_NO'                TO TABLE-ELEMENT-3            
              MOVE 'EFF_DATE_FROM'        TO TABLE-ELEMENT-4            
              MOVE FF-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              MOVE FF-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2          
              MOVE FF-IC-NO               TO HOSTVAR-ELEMENT-3          
              MOVE FF-EFF-DATE-FROM       TO HOSTVAR-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7670-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7680-GET-NEW-FCT-HIST-SEQ.                                       
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT COALESCE(MAX(FH.FIXED_FCTR_SEQ_NO) + 1,1)            
                INTO :FH-FIXED-FCTR-SEQ-NO                              
                FROM CSS_FIXED_FCT_HIST  FH WITH(READUNCOMMITTED)               
               WHERE FH.ACCOUNT_NO         = :FH-ACCOUNT-NO             
                 AND FH.BILL_NO            = :FH-BILL-NO                
                 AND FH.CODE_UTIL_TYPE     = :FH-CODE-UTIL-TYPE         
                 AND FH.IC_NO              = :FH-IC-NO                  
                 AND FH.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :FH-BILL-ITEM-TIMESTMP
              )     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT IFNULL(MAX(FH.FIXED_FCTR_SEQ_NO) + 1,1)                    
MFA-TR*         INTO :FH-FIXED-FCTR-SEQ-NO                                      
MFA-TR*         FROM CSS_FIXED_FCT_HIST  FH                                     
MFA-TR*        WHERE FH.ACCOUNT_NO         = :FH-ACCOUNT-NO                     
MFA-TR*          AND FH.BILL_NO            = :FH-BILL-NO                        
MFA-TR*          AND FH.CODE_UTIL_TYPE     = :FH-CODE-UTIL-TYPE                 
MFA-TR*          AND FH.IC_NO              = :FH-IC-NO                          
MFA-TR*          AND FH.BILL_ITEM_TIMESTMP = :FH-BILL-ITEM-TIMESTMP             
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7680                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7680'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-TABLES               
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
              MOVE 'CSS_FIXED_FCT_HIST'   TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE 'BILL_NO'              TO TABLE-ELEMENT-2            
              MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-3            
              MOVE 'IC_NO'                TO TABLE-ELEMENT-4            
              MOVE FH-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              MOVE FH-BILL-NO             TO HOSTVAR-ELEMENT-2          
              MOVE FH-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-3          
              MOVE FH-IC-NO               TO HOSTVAR-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7680-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7681-GET-XMT-VALUES.                                             
      *================================================================*        
                                                                        
           EXEC SQL                                                     
                SELECT SF.CODE_DR_CR                                    
                      ,SF.CODE_TAX_STAT_XMT                             
                      ,SF.CODE_TAX_CITY_XMT                             
                      ,DEFLT_DURATION_NO                                
                      ,ADJUST_ELEMENT                                   
                      ,RT_ATTR_INCTV_TYPE                               
                  INTO :SF-CODE-DR-CR                                   
                      ,:SF-CODE-TAX-STAT-XMT                            
                      ,:SF-CODE-TAX-CITY-XMT                            
                      ,:SF-DEFLT-DURATION-NO :IND-DEF-DUR-REM-NO         
                      ,:SF-ADJUST-ELEMENT                               
                      ,:SF-RT-ATTR-INCTV-TYPE                           
                  FROM CSS_SPCL_FCTR  SF WITH(READUNCOMMITTED)                  
                 WHERE SF.FACTOR_ID = :SF-FACTOR-ID                     
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT SF.CODE_DR_CR                                            
MFA-TR*               ,SF.CODE_TAX_STAT_XMT                                     
MFA-TR*               ,SF.CODE_TAX_CITY_XMT                                     
MFA-TR*               ,DEFLT_DURATION_NO                                        
MFA-TR*               ,ADJUST_ELEMENT                                           
MFA-TR*               ,RT_ATTR_INCTV_TYPE                                       
MFA-TR*           INTO :SF-CODE-DR-CR                                           
MFA-TR*               ,:SF-CODE-TAX-STAT-XMT                                    
MFA-TR*               ,:SF-CODE-TAX-CITY-XMT                                    
MFA-TR*               ,:SF-DEFLT-DURATION-NO:IND-DEF-DUR-REM-NO                 
MFA-TR*               ,:SF-ADJUST-ELEMENT                                       
MFA-TR*               ,:SF-RT-ATTR-INCTV-TYPE                                   
MFA-TR*           FROM CSS_SPCL_FCTR  SF                                        
MFA-TR*          WHERE SF.FACTOR_ID = :SF-FACTOR-ID                             
MFA-TR*           WITH UR                                                       
MFA-TR*       QUERYNO 7681                                                      
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE                
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7681'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
              MOVE 'CSS_SPCL_FCTR'          TO TABLE-1                  
              MOVE 'FACTOR_ID'              TO TABLE-ELEMENT-1          
              MOVE FH-FACTOR-ID             TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7681-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7690-GET-NEW-FCTR-SEQ.                                           
      *================================================================*        
      **GET MAX SEQ NO FROM FIXED_FCTR TABLE                          **        
      *----------------------------------------------------------------*        
      *                                                                         
           EXEC SQL                                                     
              SELECT COALESCE(MAX(FF.FIXED_FCTR_SEQ_NO) + 1,1)            
                INTO :FF-FIXED-FCTR-SEQ-NO                              
                FROM CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                    
               WHERE FF.ACCOUNT_NO      = :FF-ACCOUNT-NO                
                 AND FF.CODE_UTIL_TYPE  = :FF-CODE-UTIL-TYPE            
                 AND FF.IC_NO           = :FF-IC-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT IFNULL(MAX(FF.FIXED_FCTR_SEQ_NO) + 1,1)                    
MFA-TR*         INTO :FF-FIXED-FCTR-SEQ-NO                                      
MFA-TR*         FROM CSS_FIXED_FCTR FF                                          
MFA-TR*        WHERE FF.ACCOUNT_NO      = :FF-ACCOUNT-NO                        
MFA-TR*          AND FF.CODE_UTIL_TYPE  = :FF-CODE-UTIL-TYPE                    
MFA-TR*          AND FF.IC_NO           = :FF-IC-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7690                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7690'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-TABLES               
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
              MOVE 'CSS_FIXED_FCTR'       TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2            
              MOVE 'IC_NO'                TO TABLE-ELEMENT-3            
              MOVE FF-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              MOVE FF-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2          
              MOVE FF-IC-NO               TO HOSTVAR-ELEMENT-3          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7690-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7700-OPEN-IDR-CRSR.                                              
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               OPEN IDR_CRSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7700'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_INTERVAL_READ'        TO TABLE-1                
              MOVE 'METER_NO'                 TO TABLE-ELEMENT-1        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE CX-METER-NO                TO HOSTVAR-ELEMENT-1      
              MOVE WS-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-2      
              MOVE IN-ACCOUNT-NO              TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7705-FETCH-IDR-CRSR.                                             
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               FETCH IDR_CRSR                                           
                INTO :IV-DATE-READ                                      
                    ,:IV-TIME-READ                                      
                    ,:IV-DST-CHNG-IND                                   
                    ,:IV-CHANNEL-A-PULSES                               
                    ,:IV-CHANNEL-A-STATUS                               
                    ,:IV-CHANNEL-B-PULSES                               
                    ,:IV-CHANNEL-B-STATUS                               
                    ,:IV-CHANNEL-C-PULSES                               
                    ,:IV-CHANNEL-C-STATUS                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7705'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_INTERVAL_READ'        TO TABLE-1                
              MOVE 'METER_NO'                 TO TABLE-ELEMENT-1        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE CX-METER-NO                TO HOSTVAR-ELEMENT-1      
              MOVE WS-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-2      
              MOVE IN-ACCOUNT-NO              TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7705-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7710-CLOSE-IDR-CRSR.                                             
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               CLOSE IDR_CRSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7710'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_INTERVAL_READ'        TO TABLE-1                
              MOVE 'METER_NO'                 TO TABLE-ELEMENT-1        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE CX-METER-NO                TO HOSTVAR-ELEMENT-1      
              MOVE WS-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-2      
              MOVE IN-ACCOUNT-NO              TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7710-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7715-INSERT-IDR.                                                 
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_INTERVAL_READ                            
                    (METER_NO                                           
                    ,BILL_ITEM_TIMESTMP                                 
                    ,DATE_READ                                          
                    ,TIME_READ                                          
                    ,DST_CHNG_IND                                       
                    ,CHANNEL_A_PULSES                                   
                    ,CHANNEL_A_STATUS                                   
                    ,CHANNEL_B_PULSES                                   
                    ,CHANNEL_B_STATUS                                   
                    ,CHANNEL_C_PULSES                                   
                    ,CHANNEL_C_STATUS                                   
                    ,CODE_UTIL_TYPE)                                    
             VALUES (:IV-METER-NO                                       
                    ,CIS.CHAR2TIMESTAMP(:IV-BILL-ITEM-TIMESTMP)                 
                    ,IIF(TRY_CONVERT(DATE, :IV-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :IV-DATE-READ
              ) <> 0) OR (LEN(:IV-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :IV-DATE-READ
              ), CONVERT(DATE, :IV-DATE-READ) )                                
                    ,CIS.CHAR2TIME(:IV-TIME-READ)                               
                    ,:IV-DST-CHNG-IND                                   
                    ,:IV-CHANNEL-A-PULSES                               
                    ,:IV-CHANNEL-A-STATUS                               
                    ,:IV-CHANNEL-B-PULSES                               
                    ,:IV-CHANNEL-B-STATUS                               
                    ,:IV-CHANNEL-C-PULSES                               
                    ,:IV-CHANNEL-C-STATUS                               
                    ,:IV-CODE-UTIL-TYPE)                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_INTERVAL_READ                                    
MFA-TR*             (METER_NO                                                   
MFA-TR*             ,BILL_ITEM_TIMESTMP                                         
MFA-TR*             ,DATE_READ                                                  
MFA-TR*             ,TIME_READ                                                  
MFA-TR*             ,DST_CHNG_IND                                               
MFA-TR*             ,CHANNEL_A_PULSES                                           
MFA-TR*             ,CHANNEL_A_STATUS                                           
MFA-TR*             ,CHANNEL_B_PULSES                                           
MFA-TR*             ,CHANNEL_B_STATUS                                           
MFA-TR*             ,CHANNEL_C_PULSES                                           
MFA-TR*             ,CHANNEL_C_STATUS                                           
MFA-TR*             ,CODE_UTIL_TYPE)                                            
MFA-TR*      VALUES (:IV-METER-NO                                               
MFA-TR*             ,:IV-BILL-ITEM-TIMESTMP                                     
MFA-TR*             ,:IV-DATE-READ                                              
MFA-TR*             ,:IV-TIME-READ                                              
MFA-TR*             ,:IV-DST-CHNG-IND                                           
MFA-TR*             ,:IV-CHANNEL-A-PULSES                                       
MFA-TR*             ,:IV-CHANNEL-A-STATUS                                       
MFA-TR*             ,:IV-CHANNEL-B-PULSES                                       
MFA-TR*             ,:IV-CHANNEL-B-STATUS                                       
MFA-TR*             ,:IV-CHANNEL-C-PULSES                                       
MFA-TR*             ,:IV-CHANNEL-C-STATUS                                       
MFA-TR*             ,:IV-CODE-UTIL-TYPE)                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7715'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_INTERVAL_READ'        TO TABLE-1                
              MOVE 'METER_NO'                 TO TABLE-ELEMENT-1        
              MOVE 'DATE_READ'                TO TABLE-ELEMENT-2        
              MOVE 'TIME_READ'                TO TABLE-ELEMENT-3        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-4        
              MOVE IV-METER-NO                TO HOSTVAR-ELEMENT-1      
              MOVE IV-DATE-READ               TO HOSTVAR-ELEMENT-2      
              MOVE IV-TIME-READ               TO HOSTVAR-ELEMENT-3      
              MOVE IN-ACCOUNT-NO              TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7715-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
      *7750-GET-RTPKG-OPTCODE.                                                  
      *================================================================*        
      *                                                                         
      *    EXEC SQL                                                             
      *       SELECT DF.OPTION_CD                                               
      *         INTO :DF-OPTION-CD                                              
      *         FROM CSS_ACCT_RTPK_AGR  DF                                      
      *        WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO                     
      *          AND DF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE                 
      *          AND DF.IC_NO              = :DF-IC-NO                          
      *          AND DF.RT_PKG_OPT_SEQ_NO  = :DF-RT-PKG-OPT-SEQ-NO              
      *        WITH UR                                                          
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                               
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND              
      *       CONTINUE                                                          
      *    ELSE                                                                 
      *        MOVE 'CSR04873'              TO ABEND-PROGRAM                    
      *        MOVE '7750'                  TO ACTIVE-PARAGRAPH                 
      *        MOVE 'SELECT'                TO ABEND-FUNCTION                   
      *        MOVE 'CSS_BILLING_DET'       TO TABLE-1                          
      *        MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1                  
      *        MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2                  
      *        MOVE 'IC_NO'                 TO TABLE-ELEMENT-3                  
      *        MOVE 'RT_PKG_OPT_SEQ_NO'     TO TABLE-ELEMENT-4                  
      *        MOVE DF-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1                
      *        MOVE DF-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2                
      *        MOVE DF-IC-NO                TO HOSTVAR-ELEMENT-3                
      *        MOVE DF-RT-PKG-OPT-SEQ-NO    TO HOSTVAR-ELEMENT-4                
      *        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                   
      *        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                   
      *    END-IF.                                                              
      *                                                                         
      *7750-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      *================================================================*        
       7772-OPEN-BILL-DET-SHFT-CRSR.                                    
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               OPEN BILL_DET_SHFT_CRSR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7772'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILLING_DET'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BG-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7772-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7773-FETCH-BILL-DET-SHFT-CRSR.                                   
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               FETCH BILL_DET_SHFT_CRSR                                 
                INTO :BG-PREMISE-NO                                     
                    ,:BG-BILL-NO                                        
                    ,:BG-CODE-UTIL-TYPE                                 
                    ,:BG-IC-NO                                          
                    ,:BG-BILL-ITEM-TIMESTMP                             
                    ,:BG-DATE-ORIG-BILL :WS-DATE-ORIG-BILL-NULL3         
                    ,:BG-AMT-BILL-ITEM                                  
                    ,:BG-CODE-BILL-CALC                                 
                    ,:BG-CODE-BILL-ITM-TYPE                             
                    ,:BG-CODE-BILL-ITM-IND                              
                    ,:BG-CODE-DR-CR-CNSMPTN                             
                    ,:BG-AMT-STATE-TAX                                  
                    ,:BG-AMT-CITY-TAX                                   
                    ,:BG-AMT-OTHER-TAX                                  
                    ,:BG-CODE-REVENUE-CLASS                             
                    ,:BG-CODE-SIC-NO                                    
                    ,:BG-RATE-PLAN-NO                                   
                    ,:BG-CODE-CURTAIL-PRTY                              
                    ,:BG-CODE-STAT-TAX-XMT                              
                    ,:BG-CODE-CITY-TAX-XMT                              
                    ,:BG-CODE-OTHR-TAX-XMT                              
                    ,:BG-REV-RPT-CD                                     
                    ,:BG-STANDBY-COMPLIED                               
                    ,:BG-PRORATE-CD                                     
                    ,:BG-NEW-RATE-PCT                                   
                    ,:BG-CODE-SUB-TOTAL                                 
                    ,:BG-TAX-REFUND-CD                                  
                    ,:BG-ACCOUNT-NO                                     
                    ,:BG-COMPANY-NO                                     
                    ,:BG-DATE-LFTM-HI-DMD :WS-DATE-LFTM-HI-DMD-NULL      
                    ,:BG-LFTM-HI-PEAK-DMD                               
                    ,:BG-REBILL-IND                                     
                    ,:BG-ADJ-REASON-CD                                  
                    ,:BG-REVENUE-MONTH                                  
                    ,:BG-GAS-BASE-USE                                   
                    ,:BG-WNA-FACTOR                                     
                    ,:BG-BTU-FACTOR                                     
                    ,:BG-NO-OF-CONS-DAYS                                
                    ,:BG-REV-MTH-ORIG-BILL                              
                    ,:BG-REV-DISTRICT-CD                                
                    ,:BG-FUEL-SHIPPER-CD                                
                    ,:BG-ALTERNATE-FUEL-CD                              
                    ,:BG-TRNSP-OVER-MDQ-FL                              
                    ,:BG-CITY-TAX-RATE                                  
                    ,:BG-OTHER-TAX-RATE                                 
                    ,:BG-STATE-TAX-RATE                                 
                    ,:BG-BILL-CALC-CYCLE                                
                    ,:BG-NAICS-CD                                       
                    ,:BG-RT-PKG-OPT-SEQ-NO :WS-RT-PKG-NULL               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7773'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILLING_DET'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BG-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7773-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
                                                                        
      *================================================================*        
       7774-CLOSE-BILL-DET-SHFT-CRSR.                                   
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               CLOSE BILL_DET_SHFT_CRSR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7774'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILLING_DET'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BG-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7774-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *================================================================*        
       7777-OPEN-CX-SHFT-CRSR.                                          
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               OPEN CX_SHFT_CRSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7777'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CNSMPTN_HIST'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE CX-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE CX-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE CX-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE CX-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7777-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7778-FETCH-CX-SHFT-CRSR.                                         
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               FETCH CX_SHFT_CRSR                                       
                INTO :CX-CODE-TIME-PERIOD,                              
                     :CX-MTR-REF-NO,                                    
                     :CX-CODE-USAGE-TYPE,                               
                     :CX-CODE-USAGE-ID,                                 
                     :CX-CODE-USAGE-SOURCE,                             
                     :CX-ITEM-SEQ-NO,                                   
                     :CX-METER-NO,                                      
                     :CX-REG-ID-NO,                                     
                     :CX-DATE-READ :WS-DATE-READ-NULL,                   
                     :CX-CODE-METER-READ,                               
                     :CX-CODE-METER-NO-READ,                            
                     :CX-METER-READING,                                 
                     :CX-DEMAND-READING,                                
                     :CX-EMPLOYEE-NO,                                   
                     :CX-NO-UNITS,                                      
                     :CX-NO-DEMAND-UNITS,                               
                     :CX-NO-DAYS,                                       
                     :CX-CODE-SOURCE-ID,                                
                     :CX-CODE-DEBIT-CREDIT,                             
                     :CX-CODE-ITEM-STATUS,                              
                     :CX-CODE-DISCOUNT,                                 
                     :CX-CONSTANT,                                      
                     :CX-NO-DIALS,                                      
                     :CX-COMPANY-NO,                                    
                     :CX-EXCEPT-OVERRIDE-CD,                            
                     :CX-REQUESTED-USAGE,                               
                     :CX-DIGTL-INTRL-MTR-NO,                            
                     :CX-DIGTL-MTR-TYPE,                                
                     :CX-CODE-TOU-SEASN,                                
                     :CX-EXCL-DMD-RCHT-IND,                             
                     :CX-MTR-READ-SOURCE-CD,                            
                     :CX-BTU-FACTOR,                                    
                     :CX-PCOMP-FCT                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7778'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CNSMPTN_HIST'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE CX-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE CX-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE CX-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE CX-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7778-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7779-CLOSE-CX-SHFT-CRSR.                                         
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               CLOSE CX_SHFT_CRSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7779'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CNSMPTN_HIST'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE CX-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE CX-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE CX-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE CX-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7779-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7780-OPEN-UC-SHFT-CRSR.                                          
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               OPEN UC_SHFT_CRSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7780'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_UM_CNSMPT_HIST'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE UC-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE UC-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE UC-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE UC-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7780-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7781-FETCH-UC-SHFT-CRSR.                                         
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               FETCH UC_SHFT_CRSR                                       
                INTO :UC-RATE-ITEM-CODE                                 
                    ,:UC-ITEM-SEQ-NO                                    
                    ,:UC-NO-UNITS                                       
                    ,:UC-NO-DAYS                                        
                    ,:UC-CODE-DEBIT-CREDIT                              
                    ,:UC-USAGE-FIXED                                    
                    ,:UC-DATE-USAGE-ENDS :WS-DATE-USAGE-ENDS-NULL        
                    ,:UC-CODE-SERVICE-TYPE                              
                    ,:UC-CODE-ITEM-STATUS                               
                    ,:UC-CODE-SOURCE-ID                                 
                    ,:UC-MTHLY-AMOUNT-FIXED                             
                    ,:UC-DIST-NO                                        
                    ,:UC-LIGHT-NO                                       
                    ,:UC-POLE-NO                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7781'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_UM_CNSMPT_HIST'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE UC-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE UC-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE UC-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE UC-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7781-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7782-CLOSE-UC-SHFT-CRSR.                                         
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               CLOSE UC_SHFT_CRSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7782'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_UM_CNSMPT_HIST'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE UC-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE UC-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE UC-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE UC-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7782-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7790-SELECT-ATTR-CD.                                             
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               SELECT ATTRIBUTE_VALUE_CD                                
                 INTO :YP-ATTRIBUTE-VALUE-CD                            
                 FROM CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                  
                WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                   
                  AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ATTRIBUTE_VALUE_CD                                        
MFA-TR*          INTO :YP-ATTRIBUTE-VALUE-CD                                    
MFA-TR*          FROM CSS_ACCT_ATTRIBUTE                                        
MFA-TR*         WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                           
MFA-TR*           AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC                       
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7790                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7790'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCT_ATTRIBUTE'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'ATTRIBUTE_DESC'           TO TABLE-ELEMENT-2        
              MOVE YP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE YP-ATTRIBUTE-DESC          TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7790-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7791-SELECT-UC-DATA.                                             
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               SELECT NO_UNITS                                          
                     ,NO_DAYS                                           
                     ,CODE_DEBIT_CREDIT                                 
                     ,USAGE_FIXED                                       
                     ,DATE_USAGE_ENDS                                   
                     ,CODE_SERVICE_TYPE                                 
                     ,CODE_ITEM_STATUS                                  
                     ,CODE_SOURCE_ID                                    
                     ,MTHLY_AMOUNT_FIXED                                
                     ,DIST_NO                                           
                     ,LIGHT_NO                                          
                     ,POLE_NO                                           
                INTO :UC-NO-UNITS                                       
                    ,:UC-NO-DAYS                                        
                    ,:UC-CODE-DEBIT-CREDIT                              
                    ,:UC-USAGE-FIXED                                    
                    ,:UC-DATE-USAGE-ENDS :WS-DATE-USAGE-ENDS-NULL        
                    ,:UC-CODE-SERVICE-TYPE                              
                    ,:UC-CODE-ITEM-STATUS                               
                    ,:UC-CODE-SOURCE-ID                                 
                    ,:UC-MTHLY-AMOUNT-FIXED                             
                    ,:UC-DIST-NO                                        
                    ,:UC-LIGHT-NO                                       
                    ,:UC-POLE-NO                                        
                  FROM CSS_UM_CNSMPT_HIST WITH(READUNCOMMITTED)                 
                  WHERE ACCOUNT_NO         = :UC-ACCOUNT-NO             
                    AND BILL_NO            = :UC-BILL-NO                
                    AND CODE_UTIL_TYPE     = :UC-CODE-UTIL-TYPE         
                    AND IC_NO              = :UC-IC-NO                  
                    AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :UC-BILL-ITEM-TIMESTMP
              )     
                    AND RATE_ITEM_CODE     = :UC-RATE-ITEM-CODE         
                    AND ITEM_SEQ_NO        = :UC-ITEM-SEQ-NO            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT NO_UNITS                                                  
MFA-TR*              ,NO_DAYS                                                   
MFA-TR*              ,CODE_DEBIT_CREDIT                                         
MFA-TR*              ,USAGE_FIXED                                               
MFA-TR*              ,DATE_USAGE_ENDS                                           
MFA-TR*              ,CODE_SERVICE_TYPE                                         
MFA-TR*              ,CODE_ITEM_STATUS                                          
MFA-TR*              ,CODE_SOURCE_ID                                            
MFA-TR*              ,MTHLY_AMOUNT_FIXED                                        
MFA-TR*              ,DIST_NO                                                   
MFA-TR*              ,LIGHT_NO                                                  
MFA-TR*              ,POLE_NO                                                   
MFA-TR*         INTO :UC-NO-UNITS                                               
MFA-TR*             ,:UC-NO-DAYS                                                
MFA-TR*             ,:UC-CODE-DEBIT-CREDIT                                      
MFA-TR*             ,:UC-USAGE-FIXED                                            
MFA-TR*             ,:UC-DATE-USAGE-ENDS:WS-DATE-USAGE-ENDS-NULL                
MFA-TR*             ,:UC-CODE-SERVICE-TYPE                                      
MFA-TR*             ,:UC-CODE-ITEM-STATUS                                       
MFA-TR*             ,:UC-CODE-SOURCE-ID                                         
MFA-TR*             ,:UC-MTHLY-AMOUNT-FIXED                                     
MFA-TR*             ,:UC-DIST-NO                                                
MFA-TR*             ,:UC-LIGHT-NO                                               
MFA-TR*             ,:UC-POLE-NO                                                
MFA-TR*           FROM CSS_UM_CNSMPT_HIST                                       
MFA-TR*           WHERE ACCOUNT_NO         = :UC-ACCOUNT-NO                     
MFA-TR*             AND BILL_NO            = :UC-BILL-NO                        
MFA-TR*             AND CODE_UTIL_TYPE     = :UC-CODE-UTIL-TYPE                 
MFA-TR*             AND IC_NO              = :UC-IC-NO                          
MFA-TR*             AND BILL_ITEM_TIMESTMP = :UC-BILL-ITEM-TIMESTMP             
MFA-TR*             AND RATE_ITEM_CODE     = :UC-RATE-ITEM-CODE                 
MFA-TR*             AND ITEM_SEQ_NO        = :UC-ITEM-SEQ-NO                    
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 7791                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7791'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_UM_CNSMPT_HIST'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE UC-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE UC-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE UC-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE UC-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7791-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7792-SELECT-CX-DATA.                                             
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              SELECT  CODE_USAGE_TYPE                                   
                     ,CODE_USAGE_ID                                     
                     ,CODE_USAGE_SOURCE                                 
                     ,METER_NO                                          
                     ,DATE_READ                                         
                     ,CODE_METER_READ                                   
                     ,CODE_METER_NO_READ                                
                     ,METER_READING                                     
                     ,DEMAND_READING                                    
                     ,EMPLOYEE_NO                                       
                     ,NO_UNITS                                          
                     ,NO_DEMAND_UNITS                                   
                     ,NO_DAYS                                           
                     ,CODE_SOURCE_ID                                    
                     ,CODE_DEBIT_CREDIT                                 
                     ,CODE_ITEM_STATUS                                  
                     ,CODE_DISCOUNT                                     
                     ,CONSTANT                                          
                     ,NO_DIALS                                          
                     ,COMPANY_NO                                        
                     ,EXCEPT_OVERRIDE_CD                                
                     ,REQUESTED_USAGE                                   
                     ,DIGTL_INTRL_MTR_NO                                
                     ,DIGTL_MTR_TYPE                                    
                     ,CODE_TOU_SEASN                                    
                     ,EXCL_DMD_RCHT_IND                                 
                     ,MTR_READ_SOURCE_CD                                
                     ,BTU_FACTOR                                        
                     ,PCOMP_FCT                                         
                INTO :CX-CODE-USAGE-TYPE                                
                    ,:CX-CODE-USAGE-ID                                  
                    ,:CX-CODE-USAGE-SOURCE                              
                    ,:CX-METER-NO                                       
                    ,:CX-DATE-READ                                      
                    ,:CX-CODE-METER-READ                                
                    ,:CX-CODE-METER-NO-READ                             
                    ,:CX-METER-READING                                  
                    ,:CX-DEMAND-READING                                 
                    ,:CX-EMPLOYEE-NO                                    
                    ,:CX-NO-UNITS                                       
                    ,:CX-NO-DEMAND-UNITS                                
                    ,:CX-NO-DAYS                                        
                    ,:CX-CODE-SOURCE-ID                                 
                    ,:CX-CODE-DEBIT-CREDIT                              
                    ,:CX-CODE-ITEM-STATUS                               
                    ,:CX-CODE-DISCOUNT                                  
                    ,:CX-CONSTANT                                       
                    ,:CX-NO-DIALS                                       
                    ,:CX-COMPANY-NO                                     
                    ,:CX-EXCEPT-OVERRIDE-CD                             
                    ,:CX-REQUESTED-USAGE                                
                    ,:CX-DIGTL-INTRL-MTR-NO                             
                    ,:CX-DIGTL-MTR-TYPE                                 
                    ,:CX-CODE-TOU-SEASN                                 
                    ,:CX-EXCL-DMD-RCHT-IND                              
                    ,:CX-MTR-READ-SOURCE-CD                             
                    ,:CX-BTU-FACTOR                                     
                    ,:CX-PCOMP-FCT                                      
                 FROM CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO               
                  AND BILL_NO            = :CX-BILL-NO                  
                  AND CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE           
                  AND IC_NO              = :CX-IC-NO                    
                  AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )       
                  AND CODE_TIME_PERIOD   = :CX-CODE-TIME-PERIOD         
                  AND MTR_REF_NO         = :CX-MTR-REF-NO               
                  AND REG_ID_NO          = :CX-REG-ID-NO                
                  AND ITEM_SEQ_NO        = :CX-ITEM-SEQ-NO              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  CODE_USAGE_TYPE                                           
MFA-TR*              ,CODE_USAGE_ID                                             
MFA-TR*              ,CODE_USAGE_SOURCE                                         
MFA-TR*              ,METER_NO                                                  
MFA-TR*              ,DATE_READ                                                 
MFA-TR*              ,CODE_METER_READ                                           
MFA-TR*              ,CODE_METER_NO_READ                                        
MFA-TR*              ,METER_READING                                             
MFA-TR*              ,DEMAND_READING                                            
MFA-TR*              ,EMPLOYEE_NO                                               
MFA-TR*              ,NO_UNITS                                                  
MFA-TR*              ,NO_DEMAND_UNITS                                           
MFA-TR*              ,NO_DAYS                                                   
MFA-TR*              ,CODE_SOURCE_ID                                            
MFA-TR*              ,CODE_DEBIT_CREDIT                                         
MFA-TR*              ,CODE_ITEM_STATUS                                          
MFA-TR*              ,CODE_DISCOUNT                                             
MFA-TR*              ,CONSTANT                                                  
MFA-TR*              ,NO_DIALS                                                  
MFA-TR*              ,COMPANY_NO                                                
MFA-TR*              ,EXCEPT_OVERRIDE_CD                                        
MFA-TR*              ,REQUESTED_USAGE                                           
MFA-TR*              ,DIGTL_INTRL_MTR_NO                                        
MFA-TR*              ,DIGTL_MTR_TYPE                                            
MFA-TR*              ,CODE_TOU_SEASN                                            
MFA-TR*              ,EXCL_DMD_RCHT_IND                                         
MFA-TR*              ,MTR_READ_SOURCE_CD                                        
MFA-TR*              ,BTU_FACTOR                                                
MFA-TR*              ,PCOMP_FCT                                                 
MFA-TR*         INTO :CX-CODE-USAGE-TYPE                                        
MFA-TR*             ,:CX-CODE-USAGE-ID                                          
MFA-TR*             ,:CX-CODE-USAGE-SOURCE                                      
MFA-TR*             ,:CX-METER-NO                                               
MFA-TR*             ,:CX-DATE-READ                                              
MFA-TR*             ,:CX-CODE-METER-READ                                        
MFA-TR*             ,:CX-CODE-METER-NO-READ                                     
MFA-TR*             ,:CX-METER-READING                                          
MFA-TR*             ,:CX-DEMAND-READING                                         
MFA-TR*             ,:CX-EMPLOYEE-NO                                            
MFA-TR*             ,:CX-NO-UNITS                                               
MFA-TR*             ,:CX-NO-DEMAND-UNITS                                        
MFA-TR*             ,:CX-NO-DAYS                                                
MFA-TR*             ,:CX-CODE-SOURCE-ID                                         
MFA-TR*             ,:CX-CODE-DEBIT-CREDIT                                      
MFA-TR*             ,:CX-CODE-ITEM-STATUS                                       
MFA-TR*             ,:CX-CODE-DISCOUNT                                          
MFA-TR*             ,:CX-CONSTANT                                               
MFA-TR*             ,:CX-NO-DIALS                                               
MFA-TR*             ,:CX-COMPANY-NO                                             
MFA-TR*             ,:CX-EXCEPT-OVERRIDE-CD                                     
MFA-TR*             ,:CX-REQUESTED-USAGE                                        
MFA-TR*             ,:CX-DIGTL-INTRL-MTR-NO                                     
MFA-TR*             ,:CX-DIGTL-MTR-TYPE                                         
MFA-TR*             ,:CX-CODE-TOU-SEASN                                         
MFA-TR*             ,:CX-EXCL-DMD-RCHT-IND                                      
MFA-TR*             ,:CX-MTR-READ-SOURCE-CD                                     
MFA-TR*             ,:CX-BTU-FACTOR                                             
MFA-TR*             ,:CX-PCOMP-FCT                                              
MFA-TR*          FROM CSS_CNSMPTN_HIST                                          
MFA-TR*         WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO                       
MFA-TR*           AND BILL_NO            = :CX-BILL-NO                          
MFA-TR*           AND CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE                   
MFA-TR*           AND IC_NO              = :CX-IC-NO                            
MFA-TR*           AND BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP               
MFA-TR*           AND CODE_TIME_PERIOD   = :CX-CODE-TIME-PERIOD                 
MFA-TR*           AND MTR_REF_NO         = :CX-MTR-REF-NO                       
MFA-TR*           AND REG_ID_NO          = :CX-REG-ID-NO                        
MFA-TR*           AND ITEM_SEQ_NO        = :CX-ITEM-SEQ-NO                      
MFA-TR*           WITH UR                                                       
MFA-TR*            QUERYNO 7792                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7792'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CNSMPTN_HIST'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE CX-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE CX-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE CX-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE CX-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7792-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7793-SELECT-FH-DATA.                                             
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              SELECT FH.FACTOR_ID                                       
                    ,EFF_DATE_FROM                                      
                    ,CMPNT_ID_CD                                        
                    ,CODE_SEASON                                        
                    ,INSTR_USE_TYPE_CD                                  
                    ,CODE_TIME_PERIOD                                   
                    ,CODE_DEBIT_CREDIT                                  
                    ,CODE_REVENUE_CLASS                                 
                    ,FH.CODE_TAX_STAT_XMT                               
                    ,FH.CODE_TAX_CITY_XMT                               
                    ,FH.CODE_TAX_OTHR_XMT                               
                    ,FACTOR                                             
                    ,EFF_DATE_TO                                        
                    ,FIXED_FCTR_TYP_CD                                  
                    ,BILL_UNITS                                         
                    ,ENERGY_UNIT_CD                                     
                    ,DURATION_REMAIN_NO                                 
                    ,FH.OVR_RT_VER_PRO_FL                               
                    ,RT_PKG_OPT_SEQ_NO                                  
                    ,FACTOR_HISTORY_CD                                  
                    ,SPCL_GROUP_CD                                      
                    ,BLOCK_NO                                           
                    ,FH.FCTR_POWER_10                                   
                INTO :FH-FACTOR-ID                                      
                    ,:FH-EFF-DATE-FROM :WS-EFF-DATE-FROM-NULL            
                    ,:FH-CMPNT-ID-CD                                    
                    ,:FH-CODE-SEASON                                    
                    ,:FH-INSTR-USE-TYPE-CD                              
                    ,:FH-CODE-TIME-PERIOD                               
                    ,:FH-CODE-DEBIT-CREDIT                              
                    ,:FH-CODE-REVENUE-CLASS                             
                    ,:FH-CODE-TAX-STAT-XMT                              
                    ,:FH-CODE-TAX-CITY-XMT                              
                    ,:FH-CODE-TAX-OTHR-XMT                              
                    ,:FH-FACTOR                                         
                    ,:FH-EFF-DATE-TO :WS-EFF-DATE-TO-NULL                
                    ,:FH-FIXED-FCTR-TYP-CD                              
                    ,:FH-BILL-UNITS                                     
                    ,:FH-ENERGY-UNIT-CD                                 
                    ,:FH-DURATION-REMAIN-NO :WS-DURATION-NULL            
                    ,:FH-OVR-RT-VER-PRO-FL                              
                    ,:FH-RT-PKG-OPT-SEQ-NO                              
                    ,:WS-FACTOR-HISTORY-CD                              
                    ,:SF-SPCL-GROUP-CD                                  
                    ,:FH-BLOCK-NO                                       
                    ,:FH-FCTR-POWER-10                                  
               FROM CSS_FIXED_FCT_HIST FH WITH(READUNCOMMITTED),                
                    CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                      
              WHERE ACCOUNT_NO         = :FH-ACCOUNT-NO                 
                AND BILL_NO            = :FH-BILL-NO                    
                AND CODE_UTIL_TYPE     = :FH-CODE-UTIL-TYPE             
                AND IC_NO              = :FH-IC-NO                      
                AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :FH-BILL-ITEM-TIMESTMP
              )         
                AND FIXED_FCTR_SEQ_NO  = :FH-FIXED-FCTR-SEQ-NO          
                AND FH.FACTOR_ID       = SF.FACTOR_ID                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FH.FACTOR_ID                                               
MFA-TR*             ,EFF_DATE_FROM                                              
MFA-TR*             ,CMPNT_ID_CD                                                
MFA-TR*             ,CODE_SEASON                                                
MFA-TR*             ,INSTR_USE_TYPE_CD                                          
MFA-TR*             ,CODE_TIME_PERIOD                                           
MFA-TR*             ,CODE_DEBIT_CREDIT                                          
MFA-TR*             ,CODE_REVENUE_CLASS                                         
MFA-TR*             ,FH.CODE_TAX_STAT_XMT                                       
MFA-TR*             ,FH.CODE_TAX_CITY_XMT                                       
MFA-TR*             ,FH.CODE_TAX_OTHR_XMT                                       
MFA-TR*             ,FACTOR                                                     
MFA-TR*             ,EFF_DATE_TO                                                
MFA-TR*             ,FIXED_FCTR_TYP_CD                                          
MFA-TR*             ,BILL_UNITS                                                 
MFA-TR*             ,ENERGY_UNIT_CD                                             
MFA-TR*             ,DURATION_REMAIN_NO                                         
MFA-TR*             ,FH.OVR_RT_VER_PRO_FL                                       
MFA-TR*             ,RT_PKG_OPT_SEQ_NO                                          
MFA-TR*             ,FACTOR_HISTORY_CD                                          
MFA-TR*             ,SPCL_GROUP_CD                                              
MFA-TR*             ,BLOCK_NO                                                   
MFA-TR*             ,FH.FCTR_POWER_10                                           
MFA-TR*         INTO :FH-FACTOR-ID                                              
MFA-TR*             ,:FH-EFF-DATE-FROM:WS-EFF-DATE-FROM-NULL                    
MFA-TR*             ,:FH-CMPNT-ID-CD                                            
MFA-TR*             ,:FH-CODE-SEASON                                            
MFA-TR*             ,:FH-INSTR-USE-TYPE-CD                                      
MFA-TR*             ,:FH-CODE-TIME-PERIOD                                       
MFA-TR*             ,:FH-CODE-DEBIT-CREDIT                                      
MFA-TR*             ,:FH-CODE-REVENUE-CLASS                                     
MFA-TR*             ,:FH-CODE-TAX-STAT-XMT                                      
MFA-TR*             ,:FH-CODE-TAX-CITY-XMT                                      
MFA-TR*             ,:FH-CODE-TAX-OTHR-XMT                                      
MFA-TR*             ,:FH-FACTOR                                                 
MFA-TR*             ,:FH-EFF-DATE-TO:WS-EFF-DATE-TO-NULL                        
MFA-TR*             ,:FH-FIXED-FCTR-TYP-CD                                      
MFA-TR*             ,:FH-BILL-UNITS                                             
MFA-TR*             ,:FH-ENERGY-UNIT-CD                                         
MFA-TR*             ,:FH-DURATION-REMAIN-NO:WS-DURATION-NULL                    
MFA-TR*             ,:FH-OVR-RT-VER-PRO-FL                                      
MFA-TR*             ,:FH-RT-PKG-OPT-SEQ-NO                                      
MFA-TR*             ,:WS-FACTOR-HISTORY-CD                                      
MFA-TR*             ,:SF-SPCL-GROUP-CD                                          
MFA-TR*             ,:FH-BLOCK-NO                                               
MFA-TR*             ,:FH-FCTR-POWER-10                                          
MFA-TR*        FROM CSS_FIXED_FCT_HIST FH,                                      
MFA-TR*             CSS_SPCL_FCTR SF                                            
MFA-TR*       WHERE ACCOUNT_NO         = :FH-ACCOUNT-NO                         
MFA-TR*         AND BILL_NO            = :FH-BILL-NO                            
MFA-TR*         AND CODE_UTIL_TYPE     = :FH-CODE-UTIL-TYPE                     
MFA-TR*         AND IC_NO              = :FH-IC-NO                              
MFA-TR*         AND BILL_ITEM_TIMESTMP = :FH-BILL-ITEM-TIMESTMP                 
MFA-TR*         AND FIXED_FCTR_SEQ_NO  = :FH-FIXED-FCTR-SEQ-NO                  
MFA-TR*         AND FH.FACTOR_ID       = SF.FACTOR_ID                           
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7793                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7793'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_FIXED_FCT_HIST'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE FH-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE FH-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE FH-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE FH-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7793-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7794-SELECT-BP-DATA.                                             
      *================================================================*        
                                                                        
           EXEC SQL                                                     
                SELECT  ADJ_TYPE_CD                                     
                       ,OVRRIDE_RT_REV_MTH                              
                       ,SPECIAL_PROCESS_CD                              
                  INTO :WS-ADJ-TYPE-CD                                  
                      ,:WS-OVRRIDE-RT-REV-MTH                           
                      ,:WS-SPECIAL-PROCESS-CD                           
                FROM  CSS_BILL_ADJUSTMNT WITH(READUNCOMMITTED)                  
                WHERE ACCOUNT_NO         = :BP-ACCOUNT-NO               
                  AND BILL_NO            = :BP-BILL-NO                  
                  AND CODE_UTIL_TYPE     = :BP-CODE-UTIL-TYPE           
                  AND IC_NO              = :BP-IC-NO                    
                  AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BP-BILL-ITEM-TIMESTMP
              )       
                  AND ADJ_TYPE_CD IN (:WS-BP-ADJ-TYPE-CD1,              
                                       :WS-BP-ADJ-TYPE-CD2)             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  ADJ_TYPE_CD                                             
MFA-TR*                ,OVRRIDE_RT_REV_MTH                                      
MFA-TR*                ,SPECIAL_PROCESS_CD                                      
MFA-TR*           INTO :WS-ADJ-TYPE-CD                                          
MFA-TR*               ,:WS-OVRRIDE-RT-REV-MTH                                   
MFA-TR*               ,:WS-SPECIAL-PROCESS-CD                                   
MFA-TR*         FROM  CSS_BILL_ADJUSTMNT                                        
MFA-TR*         WHERE ACCOUNT_NO         = :BP-ACCOUNT-NO                       
MFA-TR*           AND BILL_NO            = :BP-BILL-NO                          
MFA-TR*           AND CODE_UTIL_TYPE     = :BP-CODE-UTIL-TYPE                   
MFA-TR*           AND IC_NO              = :BP-IC-NO                            
MFA-TR*           AND BILL_ITEM_TIMESTMP = :BP-BILL-ITEM-TIMESTMP               
MFA-TR*           AND ADJ_TYPE_CD IN (:WS-BP-ADJ-TYPE-CD1,                      
MFA-TR*                                :WS-BP-ADJ-TYPE-CD2)                     
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7794                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7794'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_ADJUSTMNT'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE BP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BP-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE BP-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE BP-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7794-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7800-OPEN-MTR-CRSR.                                              
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               OPEN MTR_CRSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7800'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MTR_IDENT_HIST'       TO TABLE-1                
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-1        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE GA-BILL-NO                 TO HOSTVAR-ELEMENT-1      
              MOVE WS-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-2      
              MOVE IN-ACCOUNT-NO              TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7805-FETCH-MTR-CRSR.                                             
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               FETCH MTR_CRSR                                           
                INTO :GA-MTR-REF-NO                                     
                    ,:GA-METER-NO                                       
                    ,:GA-IDR-IDENT-NO                                   
                    ,:GA-INTERVALS-PER-HR                               
                    ,:GA-CHANNEL-A-UOM                                  
                    ,:GA-CHANNEL-B-UOM                                  
                    ,:GA-CHANNEL-C-UOM                                  
                    ,:GA-IDR-INFO-RETENT-DT :WS-IDR-INFO-NULL-IND        
                    ,:GA-CT-UPPER-RATIO                                 
                    ,:GA-PT-UPPER-RATIO                                 
                    ,:GA-CT-LOWER-RATIO                                 
                    ,:GA-PT-LOWER-RATIO                                 
                    ,:GA-INDUST-BTU-ID                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7805'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MTR_IDENT_HIST'       TO TABLE-1                
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-1        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE GA-BILL-NO                 TO HOSTVAR-ELEMENT-1      
              MOVE WS-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-2      
              MOVE IN-ACCOUNT-NO              TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7805-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7810-CLOSE-MTR-CRSR.                                             
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               CLOSE MTR_CRSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7810'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MTR_IDENT_HIST'       TO TABLE-1                
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-1        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE GA-BILL-NO                 TO HOSTVAR-ELEMENT-1      
              MOVE WS-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-2      
              MOVE IN-ACCOUNT-NO              TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7810-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7815-INSERT-MTR.                                                 
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_MTR_IDENT_HIST                           
                    (ACCOUNT_NO                                         
                    ,BILL_NO                                            
                    ,CODE_UTIL_TYPE                                     
                    ,IC_NO                                              
                    ,BILL_ITEM_TIMESTMP                                 
                    ,MTR_REF_NO                                         
                    ,METER_NO                                           
                    ,IDR_IDENT_NO                                       
                    ,INTERVALS_PER_HR                                   
                    ,CHANNEL_A_UOM                                      
                    ,CHANNEL_B_UOM                                      
                    ,CHANNEL_C_UOM                                      
                    ,IDR_INFO_RETENT_DT                                 
                    ,CT_UPPER_RATIO                                     
                    ,PT_UPPER_RATIO                                     
                    ,CT_LOWER_RATIO                                     
                    ,PT_LOWER_RATIO                                     
                    ,INDUST_BTU_ID)                                     
             VALUES (:GA-ACCOUNT-NO                                     
                    ,:GA-BILL-NO                                        
                    ,:GA-CODE-UTIL-TYPE                                 
                    ,:GA-IC-NO                                          
                    ,CIS.CHAR2TIMESTAMP(:GA-BILL-ITEM-TIMESTMP)                 
                    ,:GA-MTR-REF-NO                                     
                    ,:GA-METER-NO                                       
                    ,:GA-IDR-IDENT-NO                                   
                    ,:GA-INTERVALS-PER-HR                               
                    ,:GA-CHANNEL-A-UOM                                  
                    ,:GA-CHANNEL-B-UOM                                  
                    ,:GA-CHANNEL-C-UOM                                  
                    ,IIF(TRY_CONVERT(DATE, :GA-IDR-INFO-RETENT-DT 
                                           :WS-IDR-INFO-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :GA-IDR-INFO-RETENT-DT 
                                                  :WS-IDR-INFO-NULL-IND
              ) <> 0) OR (LEN(:GA-IDR-INFO-RETENT-DT 
                                                  :WS-IDR-INFO-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:GA-IDR-INFO-RETENT-DT 
                                                  :WS-IDR-INFO-NULL-IND
              ), CONVERT(DATE, :GA-IDR-INFO-RETENT-DT 
                                                  :WS-IDR-INFO-NULL-IND
              ) )        
                    ,:GA-CT-UPPER-RATIO                                 
                    ,:GA-PT-UPPER-RATIO                                 
                    ,:GA-CT-LOWER-RATIO                                 
                    ,:GA-PT-LOWER-RATIO                                 
                    ,:GA-INDUST-BTU-ID)                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MTR_IDENT_HIST                                   
MFA-TR*             (ACCOUNT_NO                                                 
MFA-TR*             ,BILL_NO                                                    
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,BILL_ITEM_TIMESTMP                                         
MFA-TR*             ,MTR_REF_NO                                                 
MFA-TR*             ,METER_NO                                                   
MFA-TR*             ,IDR_IDENT_NO                                               
MFA-TR*             ,INTERVALS_PER_HR                                           
MFA-TR*             ,CHANNEL_A_UOM                                              
MFA-TR*             ,CHANNEL_B_UOM                                              
MFA-TR*             ,CHANNEL_C_UOM                                              
MFA-TR*             ,IDR_INFO_RETENT_DT                                         
MFA-TR*             ,CT_UPPER_RATIO                                             
MFA-TR*             ,PT_UPPER_RATIO                                             
MFA-TR*             ,CT_LOWER_RATIO                                             
MFA-TR*             ,PT_LOWER_RATIO                                             
MFA-TR*             ,INDUST_BTU_ID)                                             
MFA-TR*      VALUES (:GA-ACCOUNT-NO                                             
MFA-TR*             ,:GA-BILL-NO                                                
MFA-TR*             ,:GA-CODE-UTIL-TYPE                                         
MFA-TR*             ,:GA-IC-NO                                                  
MFA-TR*             ,:GA-BILL-ITEM-TIMESTMP                                     
MFA-TR*             ,:GA-MTR-REF-NO                                             
MFA-TR*             ,:GA-METER-NO                                               
MFA-TR*             ,:GA-IDR-IDENT-NO                                           
MFA-TR*             ,:GA-INTERVALS-PER-HR                                       
MFA-TR*             ,:GA-CHANNEL-A-UOM                                          
MFA-TR*             ,:GA-CHANNEL-B-UOM                                          
MFA-TR*             ,:GA-CHANNEL-C-UOM                                          
MFA-TR*             ,:GA-IDR-INFO-RETENT-DT:WS-IDR-INFO-NULL-IND                
MFA-TR*             ,:GA-CT-UPPER-RATIO                                         
MFA-TR*             ,:GA-PT-UPPER-RATIO                                         
MFA-TR*             ,:GA-CT-LOWER-RATIO                                         
MFA-TR*             ,:GA-PT-LOWER-RATIO                                         
MFA-TR*             ,:GA-INDUST-BTU-ID)                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -803       
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7815'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MTR_IDENT_HIST'       TO TABLE-1                
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-1        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-4        
              MOVE GA-BILL-NO                 TO HOSTVAR-ELEMENT-1      
              MOVE GA-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-2      
              MOVE GA-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE IN-ACCOUNT-NO              TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7815-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7820-OPEN-VOL-CRSR.                                              
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               OPEN VOL_CRSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7820'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_VOL_DAILY'            TO TABLE-1                
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-1        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE ND-BILL-NO                 TO HOSTVAR-ELEMENT-1      
              MOVE ND-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-2      
              MOVE ND-ACCOUNT-NO              TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7820-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
                                                                        
      *================================================================*        
       7821-OPEN-ALL-REBILLS.                                           
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               OPEN DELETE_ALL_REBILLS                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'              TO ABEND-PROGRAM             
              MOVE '7821'                  TO ACTIVE-PARAGRAPH          
              MOVE 'OPEN'                  TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_BILLING_DET'       TO TABLE-1                   
              MOVE 'BILL_NO'               TO TABLE-ELEMENT-1           
              MOVE 'BILL_ITEM_TIMESTMP'    TO TABLE-ELEMENT-2           
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-3           
              MOVE BG-BILL-NO              TO HOSTVAR-ELEMENT-1         
              MOVE WS-BILL-ITEM-TIMESTMP   TO HOSTVAR-ELEMENT-2         
              MOVE IN-ACCOUNT-NO           TO HOSTVAR-ELEMENT-3         
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7821-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7822-FETCH-ALL-REBILLS.                                          
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               FETCH DELETE_ALL_REBILLS                                 
                INTO :WS-BILL-ITEM-TIMESTMP                             
                    ,:WS-CODE-BILL-CALC                                 
                    ,:WS-CODE-BILL-ITM-TYPE                             
                    ,:WS-CODE-BILL-ITM-IND                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'              TO ABEND-PROGRAM             
              MOVE '7822'                  TO ACTIVE-PARAGRAPH          
              MOVE 'FETCH'                 TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_BILLING_DET'       TO TABLE-1                   
              MOVE 'BILL_NO'               TO TABLE-ELEMENT-1           
              MOVE 'BILL_ITEM_TIMESTMP'    TO TABLE-ELEMENT-2           
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-3           
              MOVE BG-BILL-NO              TO HOSTVAR-ELEMENT-1         
              MOVE WS-BILL-ITEM-TIMESTMP   TO HOSTVAR-ELEMENT-2         
              MOVE IN-ACCOUNT-NO           TO HOSTVAR-ELEMENT-3         
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7822-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7823-CLOSE-ALL-REBILLS.                                          
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               CLOSE DELETE_ALL_REBILLS                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'              TO ABEND-PROGRAM             
              MOVE '7823'                  TO ACTIVE-PARAGRAPH          
              MOVE 'CLOSE'                 TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_BILLING_DET'       TO TABLE-1                   
              MOVE 'BILL_NO'               TO TABLE-ELEMENT-1           
              MOVE 'BILL_ITEM_TIMESTMP'    TO TABLE-ELEMENT-2           
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-3           
              MOVE BG-BILL-NO              TO HOSTVAR-ELEMENT-1         
              MOVE WS-BILL-ITEM-TIMESTMP   TO HOSTVAR-ELEMENT-2         
              MOVE IN-ACCOUNT-NO           TO HOSTVAR-ELEMENT-3         
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7823-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7824-SELECT-REBILL-DELETE.                                       
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                                 
                    ,CODE_BILL_CALC                                     
                    ,CODE_BILL_ITM_TYPE                                 
                    ,CODE_BILL_ITM_IND                                  
                INTO :WS-BILL-ITEM-TIMESTMP                             
                    ,:WS-CODE-BILL-CALC                                 
                    ,:WS-CODE-BILL-ITM-TYPE                             
                    ,:WS-CODE-BILL-ITM-IND                              
               FROM CSS_BILLING_DET                                     
              WHERE ACCOUNT_NO       = :BG-ACCOUNT-NO                   
                  AND BILL_NO        = :BG-BILL-NO                      
                  AND CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE               
                  AND IC_NO          = :BG-IC-NO                        
                  AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BILL_ITEM_TIMESTMP                                         
MFA-TR*             ,CODE_BILL_CALC                                             
MFA-TR*             ,CODE_BILL_ITM_TYPE                                         
MFA-TR*             ,CODE_BILL_ITM_IND                                          
MFA-TR*         INTO :WS-BILL-ITEM-TIMESTMP                                     
MFA-TR*             ,:WS-CODE-BILL-CALC                                         
MFA-TR*             ,:WS-CODE-BILL-ITM-TYPE                                     
MFA-TR*             ,:WS-CODE-BILL-ITM-IND                                      
MFA-TR*        FROM CSS_BILLING_DET                                             
MFA-TR*       WHERE ACCOUNT_NO       = :BG-ACCOUNT-NO                           
MFA-TR*           AND BILL_NO        = :BG-BILL-NO                              
MFA-TR*           AND CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE                       
MFA-TR*           AND IC_NO          = :BG-IC-NO                                
MFA-TR*           AND BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'              TO ABEND-PROGRAM             
              MOVE '7824'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_BILLING_DET'       TO TABLE-1                   
              MOVE 'BILL_NO'               TO TABLE-ELEMENT-1           
              MOVE 'BILL_ITEM_TIMESTMP'    TO TABLE-ELEMENT-2           
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-3           
              MOVE BG-BILL-NO              TO HOSTVAR-ELEMENT-1         
              MOVE WS-BILL-ITEM-TIMESTMP   TO HOSTVAR-ELEMENT-2         
              MOVE IN-ACCOUNT-NO           TO HOSTVAR-ELEMENT-3         
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7824-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       7825-FETCH-VOL-CRSR.                                             
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               FETCH VOL_CRSR                                           
                INTO :ND-VOL-TYPE-CD                                    
                    ,:ND-ENERGY-UNIT-CD                                 
                    ,:ND-DATE-READ                                      
                    ,:ND-NO-UNITS                                       
                    ,:ND-FIXED-FCTR-SEQ-NO                              
                    ,:ND-CODE-TIME-PERIOD                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7825'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_VOL_DAILY'            TO TABLE-1                
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-1        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE ND-BILL-NO                 TO HOSTVAR-ELEMENT-1      
              MOVE ND-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-2      
              MOVE ND-ACCOUNT-NO              TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7825-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
                                                                        
      *================================================================*        
       7826-CLOSE-VOL-CRSR.                                             
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               CLOSE VOL_CRSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7826'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_VOL_DAILY'            TO TABLE-1                
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-1        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE ND-BILL-NO                 TO HOSTVAR-ELEMENT-1      
              MOVE ND-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-2      
              MOVE ND-ACCOUNT-NO              TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7826-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7827-INSERT-VOL.                                                 
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_VOL_DAILY                                
                    (ACCOUNT_NO                                         
                    ,BILL_NO                                            
                    ,CODE_UTIL_TYPE                                     
                    ,IC_NO                                              
                    ,BILL_ITEM_TIMESTMP                                 
                    ,VOL_TYPE_CD                                        
                    ,ENERGY_UNIT_CD                                     
                    ,DATE_READ                                          
                    ,NO_UNITS                                           
                    ,FIXED_FCTR_SEQ_NO                                  
                    ,CODE_TIME_PERIOD)                                  
             VALUES (:ND-ACCOUNT-NO                                     
                    ,:ND-BILL-NO                                        
                    ,:ND-CODE-UTIL-TYPE                                 
                    ,:ND-IC-NO                                          
                    ,CIS.CHAR2TIMESTAMP(:ND-BILL-ITEM-TIMESTMP)                 
                    ,:ND-VOL-TYPE-CD                                    
                    ,:ND-ENERGY-UNIT-CD                                 
                    ,IIF(TRY_CONVERT(DATE, :ND-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :ND-DATE-READ
              ) <> 0) OR (LEN(:ND-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :ND-DATE-READ
              ), CONVERT(DATE, :ND-DATE-READ) )                                
                    ,:ND-NO-UNITS                                       
                    ,:ND-FIXED-FCTR-SEQ-NO                              
                    ,:ND-CODE-TIME-PERIOD)                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_VOL_DAILY                                        
MFA-TR*             (ACCOUNT_NO                                                 
MFA-TR*             ,BILL_NO                                                    
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,BILL_ITEM_TIMESTMP                                         
MFA-TR*             ,VOL_TYPE_CD                                                
MFA-TR*             ,ENERGY_UNIT_CD                                             
MFA-TR*             ,DATE_READ                                                  
MFA-TR*             ,NO_UNITS                                                   
MFA-TR*             ,FIXED_FCTR_SEQ_NO                                          
MFA-TR*             ,CODE_TIME_PERIOD)                                          
MFA-TR*      VALUES (:ND-ACCOUNT-NO                                             
MFA-TR*             ,:ND-BILL-NO                                                
MFA-TR*             ,:ND-CODE-UTIL-TYPE                                         
MFA-TR*             ,:ND-IC-NO                                                  
MFA-TR*             ,:ND-BILL-ITEM-TIMESTMP                                     
MFA-TR*             ,:ND-VOL-TYPE-CD                                            
MFA-TR*             ,:ND-ENERGY-UNIT-CD                                         
MFA-TR*             ,:ND-DATE-READ                                              
MFA-TR*             ,:ND-NO-UNITS                                               
MFA-TR*             ,:ND-FIXED-FCTR-SEQ-NO                                      
MFA-TR*             ,:ND-CODE-TIME-PERIOD)                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'                 TO ABEND-PROGRAM          
              MOVE '7827'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_VOL_DAILY'            TO TABLE-1                
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-1        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-4        
              MOVE ND-BILL-NO                 TO HOSTVAR-ELEMENT-1      
              MOVE ND-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-2      
              MOVE ND-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE ND-ACCOUNT-NO              TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7827-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7828-VERIFY-BILL-DET.                                            
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              SELECT COUNT (*)                                          
                INTO  :WS-ROW-COUNT                                     
                FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                      
              WHERE ACCOUNT_NO       = :BG-ACCOUNT-NO                   
                AND BILL_NO          = :BG-BILL-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT (*)                                                  
MFA-TR*         INTO  :WS-ROW-COUNT                                             
MFA-TR*         FROM CSS_BILLING_DET                                            
MFA-TR*       WHERE ACCOUNT_NO       = :BG-ACCOUNT-NO                           
MFA-TR*         AND BILL_NO          = :BG-BILL-NO                              
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7828                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'              TO ABEND-PROGRAM             
              MOVE '7828'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_BILLING_DET'       TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE 'BILL_NO'               TO TABLE-ELEMENT-2           
              MOVE BG-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
              MOVE BG-BILL-NO              TO HOSTVAR-ELEMENT-2         
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7828-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
      *7829-VERIFY-BILL-DET.                                                    
      *================================================================*        
      *                                                                         
      *    EXEC SQL                                                             
      *        SELECT COUNT (*)                                                 
      *        INTO  :WS-ROW-COUNT                                              
      *        FROM CSS_BILLING_DET                                             
      *        WHERE ACCOUNT_NO = :BG-ACCOUNT-NO                                
      *         AND BILL_NO     = :BG-BILL-NO                                   
      *        WITH UR                                                          
      *        QUERYNO 7829                                                     
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                               
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL                       
      *       CONTINUE                                                          
      *    ELSE                                                                 
      *       MOVE 'CSR04873'              TO ABEND-PROGRAM                     
      *       MOVE '7829'                  TO ACTIVE-PARAGRAPH                  
      *       MOVE 'SELECT'                TO ABEND-FUNCTION                    
      *       MOVE SPACES                  TO ABEND-SQL-PREDICATES              
      *                                       ABEND-TABLES                      
      *       MOVE 'CSS_BILLING_DET'       TO TABLE-1                           
      *       MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1                   
      *       MOVE 'BILL_NO'               TO TABLE-ELEMENT-2                   
      *       MOVE 'IC_NO'                 TO TABLE-ELEMENT-3                   
      *       MOVE BG-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1                 
      *       MOVE BG-BILL-NO              TO HOSTVAR-ELEMENT-2                 
      *       MOVE BG-IC-NO                TO HOSTVAR-ELEMENT-3                 
      *       PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT                  
      *       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT                     
      *    END-IF.                                                              
      *                                                                         
      *7829-EXIT.                                                               
      *     EXIT.                                                               
      *                                                                         
      *================================================================*        
       7850-GET-INDUST-BTU-ID.                                          
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               SELECT INDUST_BTU_ID                                     
                 INTO :MN-INDUST-BTU-ID                                 
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO               
                  AND CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE           
                  AND METER_NO           = :CX-METER-NO                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT INDUST_BTU_ID                                             
MFA-TR*          INTO :MN-INDUST-BTU-ID                                         
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO                       
MFA-TR*           AND CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE                   
MFA-TR*           AND METER_NO           = :CX-METER-NO                         
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7850                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'              TO ABEND-PROGRAM             
              MOVE '7850'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_MTRD_ENVRNMT'      TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2           
              MOVE 'METER_NO'              TO TABLE-ELEMENT-3           
              MOVE CX-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
              MOVE CX-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2         
              MOVE CX-METER-NO             TO HOSTVAR-ELEMENT-3         
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7860-GET-BTU-FACTOR.                                             
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               SELECT BTU_FACTOR                                        
                 INTO :FE-BTU-FACTOR                                    
                 FROM CSS_BTU_INDUST_FCT WITH(READUNCOMMITTED)                  
                WHERE COMPANY_NO         = '01'                         
                  AND INDUST_BTU_ID      = :FE-INDUST-BTU-ID            
                  AND BTU_DT             = IIF(TRY_CONVERT(DATE, 
                                                             :FE-BTU-DT
              ) IS NULL OR (PATINDEX('%.%', :FE-BTU-DT) <> 0) OR (LEN(
                                                             :FE-BTU-DT
              ) <> 10), CIS.CHAR2DATE(:FE-BTU-DT), CONVERT(DATE, 
                                                             :FE-BTU-DT
              ) )                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BTU_FACTOR                                                
MFA-TR*          INTO :FE-BTU-FACTOR                                            
MFA-TR*          FROM CSS_BTU_INDUST_FCT                                        
MFA-TR*         WHERE COMPANY_NO         = '01'                                 
MFA-TR*           AND INDUST_BTU_ID      = :FE-INDUST-BTU-ID                    
MFA-TR*           AND BTU_DT             = :FE-BTU-DT                           
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7860                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'              TO ABEND-PROGRAM             
              MOVE '7860'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_BTU_INDUST_FCT'    TO TABLE-1                   
              MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1           
              MOVE 'INDUST_BTU_ID'         TO TABLE-ELEMENT-2           
              MOVE 'BTU_DT'                TO TABLE-ELEMENT-3           
              MOVE '01'                    TO HOSTVAR-ELEMENT-1         
              MOVE FE-INDUST-BTU-ID        TO HOSTVAR-ELEMENT-2         
              MOVE FE-BTU-DT               TO HOSTVAR-ELEMENT-3         
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7860-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7870-ESTIMATE-BTU.                                               
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               SELECT AVG(BTU_FACTOR)                                   
                 INTO :WS-AVG-BTU-FACTOR :WS-NULL-INDICATOR              
                 FROM CSS_BTU_INDUST_FCT WITH(READUNCOMMITTED)                  
                WHERE COMPANY_NO            = '01'                      
                  AND INDUST_BTU_ID         = :FE-INDUST-BTU-ID         
                  AND MONTH(BTU_DT)         = :WS-BTU-DT-MM             
                  AND YEAR(BTU_DT)          = :WS-BTU-DT-YY             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AVG(BTU_FACTOR)                                           
MFA-TR*          INTO :WS-AVG-BTU-FACTOR:WS-NULL-INDICATOR                      
MFA-TR*          FROM CSS_BTU_INDUST_FCT                                        
MFA-TR*         WHERE COMPANY_NO            = '01'                              
MFA-TR*           AND INDUST_BTU_ID         = :FE-INDUST-BTU-ID                 
MFA-TR*           AND MONTH(BTU_DT)         = :WS-BTU-DT-MM                     
MFA-TR*           AND YEAR(BTU_DT)          = :WS-BTU-DT-YY                     
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7870                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'              TO ABEND-PROGRAM             
              MOVE '7870'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_BTU_INDUST_FCT'    TO TABLE-1                   
              MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1           
              MOVE 'INDUST_BTU_ID'         TO TABLE-ELEMENT-2           
              MOVE 'BTU_DATE'              TO TABLE-ELEMENT-3           
              MOVE '01'                    TO HOSTVAR-ELEMENT-1         
              MOVE FE-INDUST-BTU-ID        TO HOSTVAR-ELEMENT-2         
              MOVE FE-BTU-DT               TO HOSTVAR-ELEMENT-3         
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7870-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7909-SELECT-MTR-CAP.                                             
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               SELECT K_Q_LEAD_LAG_IND                                  
                 INTO :MC-K-Q-LEAD-LAG-IND                              
                 FROM CSS_MTR_CAP WITH(READUNCOMMITTED)                         
                WHERE CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE               
                  AND COMPANY_NO     = :MC-COMPANY-NO                   
                  AND REG_ID_NO      = :MC-REG-ID-NO                    
                  AND METER_NO       = :MC-METER-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT K_Q_LEAD_LAG_IND                                          
MFA-TR*          INTO :MC-K-Q-LEAD-LAG-IND                                      
MFA-TR*          FROM CSS_MTR_CAP                                               
MFA-TR*         WHERE CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE                       
MFA-TR*           AND COMPANY_NO     = :MC-COMPANY-NO                           
MFA-TR*           AND REG_ID_NO      = :MC-REG-ID-NO                            
MFA-TR*           AND METER_NO       = :MC-METER-NO                             
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7909                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'              TO ABEND-PROGRAM             
              MOVE '7909'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_MTR_CAP     '      TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2           
              MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-3           
              MOVE 'METER_NO'              TO TABLE-ELEMENT-4           
              MOVE MN-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
              MOVE MN-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2         
              MOVE MC-COMPANY-NO           TO HOSTVAR-ELEMENT-3         
              MOVE MN-METER-NO             TO HOSTVAR-ELEMENT-4         
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7909-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7910-SELECT-MTRD-TYPE.                                           
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               SELECT DIGTL_MTR_TYPE                                    
                     ,MTR_READ_SOURCE_CD                                
                     ,METER_PRESSURE                                    
                     ,INDUST_BTU_ID                                     
                     ,NO_CONSEC_ESTIMATE                                
                     ,EXCEPT_OVERRIDE_CD                                
                 INTO :MN-DIGTL-MTR-TYPE                                
                     ,:MN-MTR-READ-SOURCE-CD                            
                     ,:MN-METER-PRESSURE                                
                     ,:MN-INDUST-BTU-ID                                 
                     ,:MN-NO-CONSEC-ESTIMATE                            
                     ,:MN-EXCEPT-OVERRIDE-CD                            
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE               
                  AND IC_NO          = :MN-IC-NO                        
                  AND MTR_REF_NO     = :MN-MTR-REF-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DIGTL_MTR_TYPE                                            
MFA-TR*              ,MTR_READ_SOURCE_CD                                        
MFA-TR*              ,METER_PRESSURE                                            
MFA-TR*              ,INDUST_BTU_ID                                             
MFA-TR*              ,NO_CONSEC_ESTIMATE                                        
MFA-TR*              ,EXCEPT_OVERRIDE_CD                                        
MFA-TR*          INTO :MN-DIGTL-MTR-TYPE                                        
MFA-TR*              ,:MN-MTR-READ-SOURCE-CD                                    
MFA-TR*              ,:MN-METER-PRESSURE                                        
MFA-TR*              ,:MN-INDUST-BTU-ID                                         
MFA-TR*              ,:MN-NO-CONSEC-ESTIMATE                                    
MFA-TR*              ,:MN-EXCEPT-OVERRIDE-CD                                    
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                       
MFA-TR*           AND IC_NO          = :MN-IC-NO                                
MFA-TR*           AND MTR_REF_NO     = :MN-MTR-REF-NO                           
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7910                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'              TO ABEND-PROGRAM             
              MOVE '7910'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_MTRD_ENVRNMT'      TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2           
              MOVE 'IC_NO'                 TO TABLE-ELEMENT-3           
              MOVE 'MTR_REF_NO'            TO TABLE-ELEMENT-4           
              MOVE MN-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
              MOVE MN-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2         
              MOVE MN-IC-NO                TO HOSTVAR-ELEMENT-3         
              MOVE MN-MTR-REF-NO           TO HOSTVAR-ELEMENT-4         
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7910-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7915-SELECT-MTRD-TYPE.                                           
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) DIGTL_MTR_TYPE,
              MTR_READ_SOURCE_CD,
              METER_PRESSURE,
              INDUST_BTU_ID,
              NO_CONSEC_ESTIMATE,
              EXCEPT_OVERRIDE_CD                                
                 INTO :MN-DIGTL-MTR-TYPE                                
                     ,:MN-MTR-READ-SOURCE-CD                            
                     ,:MN-METER-PRESSURE                                
                     ,:MN-INDUST-BTU-ID                                 
                     ,:MN-NO-CONSEC-ESTIMATE                            
                     ,:MN-EXCEPT-OVERRIDE-CD                            
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE               
                  AND IC_NO          = :MN-IC-NO                        
                  AND METER_NO       = :MN-METER-NO                     
                  ORDER BY CODE_METER_STATUS                            
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DIGTL_MTR_TYPE                                            
MFA-TR*              ,MTR_READ_SOURCE_CD                                        
MFA-TR*              ,METER_PRESSURE                                            
MFA-TR*              ,INDUST_BTU_ID                                             
MFA-TR*              ,NO_CONSEC_ESTIMATE                                        
MFA-TR*              ,EXCEPT_OVERRIDE_CD                                        
MFA-TR*          INTO :MN-DIGTL-MTR-TYPE                                        
MFA-TR*              ,:MN-MTR-READ-SOURCE-CD                                    
MFA-TR*              ,:MN-METER-PRESSURE                                        
MFA-TR*              ,:MN-INDUST-BTU-ID                                         
MFA-TR*              ,:MN-NO-CONSEC-ESTIMATE                                    
MFA-TR*              ,:MN-EXCEPT-OVERRIDE-CD                                    
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                       
MFA-TR*           AND IC_NO          = :MN-IC-NO                                
MFA-TR*           AND METER_NO       = :MN-METER-NO                             
MFA-TR*           ORDER BY CODE_METER_STATUS                                    
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*        QUERYNO 7915                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'              TO ABEND-PROGRAM             
              MOVE '7915'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_MTRD_ENVRNMT'      TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2           
              MOVE 'IC_NO'                 TO TABLE-ELEMENT-3           
              MOVE 'METER_NO'              TO TABLE-ELEMENT-4           
              MOVE MN-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
              MOVE MN-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2         
              MOVE MN-IC-NO                TO HOSTVAR-ELEMENT-3         
              MOVE MN-METER-NO             TO HOSTVAR-ELEMENT-4         
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7915-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7920-SELECT-MTRD-TYPE.                                           
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) DIGTL_MTR_TYPE,
              MTR_READ_SOURCE_CD,
              METER_PRESSURE,
              INDUST_BTU_ID,
              NO_CONSEC_ESTIMATE,
              EXCEPT_OVERRIDE_CD                                
                 INTO :MN-DIGTL-MTR-TYPE                                
                     ,:MN-MTR-READ-SOURCE-CD                            
                     ,:MN-METER-PRESSURE                                
                     ,:MN-INDUST-BTU-ID                                 
                     ,:MN-NO-CONSEC-ESTIMATE                            
                     ,:MN-EXCEPT-OVERRIDE-CD                            
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE               
                  AND IC_NO          = :MN-IC-NO                        
                  ORDER BY CODE_METER_STATUS                            
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DIGTL_MTR_TYPE                                            
MFA-TR*              ,MTR_READ_SOURCE_CD                                        
MFA-TR*              ,METER_PRESSURE                                            
MFA-TR*              ,INDUST_BTU_ID                                             
MFA-TR*              ,NO_CONSEC_ESTIMATE                                        
MFA-TR*              ,EXCEPT_OVERRIDE_CD                                        
MFA-TR*          INTO :MN-DIGTL-MTR-TYPE                                        
MFA-TR*              ,:MN-MTR-READ-SOURCE-CD                                    
MFA-TR*              ,:MN-METER-PRESSURE                                        
MFA-TR*              ,:MN-INDUST-BTU-ID                                         
MFA-TR*              ,:MN-NO-CONSEC-ESTIMATE                                    
MFA-TR*              ,:MN-EXCEPT-OVERRIDE-CD                                    
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                       
MFA-TR*           AND IC_NO          = :MN-IC-NO                                
MFA-TR*           ORDER BY CODE_METER_STATUS                                    
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*        QUERYNO 7920                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'              TO ABEND-PROGRAM             
              MOVE '7920'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_MTRD_ENVRNMT'      TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2           
              MOVE 'IC_NO'                 TO TABLE-ELEMENT-3           
              MOVE MN-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
              MOVE MN-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2         
              MOVE MN-IC-NO                TO HOSTVAR-ELEMENT-3         
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7920-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7925-SELECT-MTRD-MV90.                                           
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MTR_READ_SOURCE_CD                                
                 INTO :WS-MTR-READ-SOURCE-CD                            
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE               
                  AND IC_NO          = :MN-IC-NO                        
                  AND MTR_READ_SOURCE_CD = 'M'                          
                  AND CODE_METER_STATUS <> 'K'                          
                  ORDER BY CODE_METER_STATUS                            
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MTR_READ_SOURCE_CD                                        
MFA-TR*          INTO :WS-MTR-READ-SOURCE-CD                                    
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                       
MFA-TR*           AND IC_NO          = :MN-IC-NO                                
MFA-TR*           AND MTR_READ_SOURCE_CD = 'M'                                  
MFA-TR*           AND CODE_METER_STATUS <> 'K'                                  
MFA-TR*           ORDER BY CODE_METER_STATUS                                    
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*        QUERYNO 7925                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'              TO ABEND-PROGRAM             
              MOVE '7925'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_MTRD_ENVRNMT'      TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2           
              MOVE 'IC_NO'                 TO TABLE-ELEMENT-3           
              MOVE MN-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
              MOVE MN-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2         
              MOVE MN-IC-NO                TO HOSTVAR-ELEMENT-3         
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7925-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7930-TRNSP-CONTRACT.                                             
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               SELECT TW.PRIMARY_IC_NO                                  
                     ,TW.CNTRCT_START_DT                                
                 INTO :TW-PRIMARY-IC-NO                                 
                     ,:TW-CNTRCT-START-DT                               
                 FROM CSS_TRNSP_CONTRACT TW WITH(READUNCOMMITTED)               
               WHERE TW.ACCOUNT_NO     = :TZ-ACCOUNT-NO                 
               AND TW.CODE_UTIL_TYPE   = :TZ-CODE-UTIL-TYPE             
               AND TW.CNTRCT_START_DT  = (SELECT MAX(T1.CNTRCT_START_DT)
                      FROM CSS_TRNSP_CONTRACT T1 WITH(READUNCOMMITTED)          
                     WHERE T1.ACCOUNT_NO      = :TZ-ACCOUNT-NO          
                       AND  T1.CODE_UTIL_TYPE  = :TZ-CODE-UTIL-TYPE)    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT TW.PRIMARY_IC_NO                                          
MFA-TR*              ,TW.CNTRCT_START_DT                                        
MFA-TR*          INTO :TW-PRIMARY-IC-NO                                         
MFA-TR*              ,:TW-CNTRCT-START-DT                                       
MFA-TR*          FROM CSS_TRNSP_CONTRACT TW                                     
MFA-TR*        WHERE TW.ACCOUNT_NO     = :TZ-ACCOUNT-NO                         
MFA-TR*        AND TW.CODE_UTIL_TYPE   = :TZ-CODE-UTIL-TYPE                     
MFA-TR*        AND TW.CNTRCT_START_DT  = (SELECT MAX(T1.CNTRCT_START_DT)        
MFA-TR*               FROM CSS_TRNSP_CONTRACT T1                                
MFA-TR*              WHERE T1.ACCOUNT_NO      = :TZ-ACCOUNT-NO                  
MFA-TR*                AND  T1.CODE_UTIL_TYPE  = :TZ-CODE-UTIL-TYPE)            
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7930                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'              TO ABEND-PROGRAM             
              MOVE '7930'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_TRNSP_VOL_BLK'     TO TABLE-1                   
              MOVE 'CSS_TRNSP_CONTRACT'    TO TABLE-2                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2           
              MOVE TZ-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
              MOVE TZ-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2         
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7930-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7931-TRNSP-CONTRACT.                                             
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              SELECT TZ.CODE_REVENUE_CLASS                              
                INTO :TZ-CODE-REVENUE-CLASS                             
                FROM CSS_TRNSP_VOL_BLK TZ WITH(READUNCOMMITTED)                 
              WHERE TZ.ACCOUNT_NO       = :TZ-ACCOUNT-NO                
                AND TZ.CODE_UTIL_TYPE   = :TZ-CODE-UTIL-TYPE            
                AND TZ.PRIMARY_IC_NO    = :TW-PRIMARY-IC-NO             
                AND TZ.IC_NO            = :TW-PRIMARY-IC-NO             
                AND TZ.CNTRCT_START_DT  = IIF(TRY_CONVERT(DATE, 
                                                    :TW-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :TW-CNTRCT-START-DT
              ) <> 0) OR (LEN(:TW-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:TW-CNTRCT-START-DT
              ), CONVERT(DATE, :TW-CNTRCT-START-DT) )           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT TZ.CODE_REVENUE_CLASS                                      
MFA-TR*         INTO :TZ-CODE-REVENUE-CLASS                                     
MFA-TR*         FROM CSS_TRNSP_VOL_BLK TZ                                       
MFA-TR*       WHERE TZ.ACCOUNT_NO       = :TZ-ACCOUNT-NO                        
MFA-TR*         AND TZ.CODE_UTIL_TYPE   = :TZ-CODE-UTIL-TYPE                    
MFA-TR*         AND TZ.PRIMARY_IC_NO    = :TW-PRIMARY-IC-NO                     
MFA-TR*         AND TZ.IC_NO            = :TW-PRIMARY-IC-NO                     
MFA-TR*         AND TZ.CNTRCT_START_DT  = :TW-CNTRCT-START-DT                   
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7931                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'              TO ABEND-PROGRAM             
              MOVE '7931'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_TRNSP_VOL_BLK'     TO TABLE-1                   
              MOVE 'CSS_TRNSP_CONTRACT'    TO TABLE-2                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2           
              MOVE TZ-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
              MOVE TZ-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2         
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7931-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7940-MASTER-DEPEND-REL.                                          
      *================================================================*        
      *   CHECK FOR MASTER/DEPENDENT RELATION                          *        
      *----------------------------------------------------------------*        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) UR.CODE_RELATION_TYPE                              
                INTO :UR-CODE-RELATION-TYPE                             
                FROM CSS_UTL_BILL_REL UR WITH(READUNCOMMITTED)                  
               WHERE (UR.ACCOUNT_NO_MST    = :UR-ACCOUNT-NO-MST         
                 AND UR.CODE_UTIL_TYPE_MST = :UR-CODE-UTIL-TYPE-MST)    
                  OR (UR.ACCOUNT_NO_DEP    = :UR-ACCOUNT-NO-DEP         
                 AND UR.CODE_UTIL_TYPE_DEP = :UR-CODE-UTIL-TYPE-DEP)    
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UR.CODE_RELATION_TYPE                                      
MFA-TR*         INTO :UR-CODE-RELATION-TYPE                                     
MFA-TR*         FROM CSS_UTL_BILL_REL UR                                        
MFA-TR*        WHERE (UR.ACCOUNT_NO_MST    = :UR-ACCOUNT-NO-MST                 
MFA-TR*          AND UR.CODE_UTIL_TYPE_MST = :UR-CODE-UTIL-TYPE-MST)            
MFA-TR*           OR (UR.ACCOUNT_NO_DEP    = :UR-ACCOUNT-NO-DEP                 
MFA-TR*          AND UR.CODE_UTIL_TYPE_DEP = :UR-CODE-UTIL-TYPE-DEP)            
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7940                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'              TO ABEND-PROGRAM             
              MOVE '7940'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_UTL_BILL_REL'      TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2           
              MOVE UR-ACCOUNT-NO-MST       TO HOSTVAR-ELEMENT-1         
              MOVE UR-CODE-UTIL-TYPE-MST   TO HOSTVAR-ELEMENT-2         
              PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT        
              PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT        
           END-IF.                                                      
                                                                        
       7940-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7950-GET-CRED-LETTER-IND.                                        
      *================================================================*        
      *  GET CREDIT LETTER INDICATOR FROM CSS_SO_FINAL_BILL TABLE.     *        
      *----------------------------------------------------------------*        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) XD.CREDIT_LETTER_IND                              
                INTO  :XD-CREDIT-LETTER-IND                             
                FROM  CSS_SO_FINAL_BILL XD WITH(READUNCOMMITTED)                
                     ,CSS_SO_DATA VO WITH(READUNCOMMITTED)                      
               WHERE  XD.SERV_ORDER_NO              = VO.SERV_ORDER_NO  
                 AND  (CIS.SUBSTR3(VO.ORDER_TYPE_CD,1,3) = 'OFF' OR          
                       CIS.SUBSTR3(VO.ORDER_TYPE_CD,1,2) = 'CC')             
                 AND  VO.ORDER_STATE_CD             = 'Z'               
                 AND  VO.ACCOUNT_NO_PRIOR           = :OC-ACCOUNT-NO    
               ORDER BY COMPLETED_DATETIME DESC                         
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  XD.CREDIT_LETTER_IND                                      
MFA-TR*         INTO  :XD-CREDIT-LETTER-IND                                     
MFA-TR*         FROM  CSS_SO_FINAL_BILL XD                                      
MFA-TR*              ,CSS_SO_DATA VO                                            
MFA-TR*        WHERE  XD.SERV_ORDER_NO              = VO.SERV_ORDER_NO          
MFA-TR*          AND  (SUBSTR(VO.ORDER_TYPE_CD,1,3) = 'OFF' OR                  
MFA-TR*                SUBSTR(VO.ORDER_TYPE_CD,1,2) = 'CC')                     
MFA-TR*          AND  VO.ORDER_STATE_CD             = 'Z'                       
MFA-TR*          AND  VO.ACCOUNT_NO_PRIOR           = :OC-ACCOUNT-NO            
MFA-TR*        ORDER BY COMPLETED_DATETIME DESC                                 
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*       QUERYNO 7950                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'              TO ABEND-PROGRAM             
              MOVE '7950'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_SO_DATA'           TO TABLE-1                   
              MOVE 'CSS_SO_FINAL_BILL'     TO TABLE-2                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE OC-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7950-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7970-GET-BILL-MANUAL.                                            
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT  ACCOUNT_NO                                        
                     ,BILL_NO                                           
                     ,CODE_UTIL_TYPE                                    
                     ,IC_NO                                             
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                                
                     ,BILL_MAN_STATUS_CD                                
                     ,BILL_MAN_SOURCE_CD                                
                     ,LAST_UPDATE_USERID                                
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                INTO  :NG-ACCOUNT-NO                                    
                     ,:NG-BILL-NO                                       
                     ,:NG-CODE-UTIL-TYPE                                
                     ,:NG-IC-NO                                         
                     ,:NG-BILL-ITEM-TIMESTMP                            
                     ,:NG-BILL-MAN-STATUS-CD                            
                     ,:NG-BILL-MAN-SOURCE-CD                            
                     ,:NG-LAST-UPDATE-USERID                            
                     ,:NG-LAST-UPDATE-TS                                
                FROM  CSS_BILL_MANUAL NG WITH(READUNCOMMITTED)                  
               WHERE  ACCOUNT_NO          = :NG-ACCOUNT-NO              
                 AND  BILL_NO             = :NG-BILL-NO                 
                 AND  CODE_UTIL_TYPE      = :NG-CODE-UTIL-TYPE          
                 AND  IC_NO               = :NG-IC-NO                   
                 AND  BILL_ITEM_TIMESTMP  = CIS.CHAR2TIMESTAMP(
                                                 :NG-BILL-ITEM-TIMESTMP
              )      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ACCOUNT_NO                                                
MFA-TR*              ,BILL_NO                                                   
MFA-TR*              ,CODE_UTIL_TYPE                                            
MFA-TR*              ,IC_NO                                                     
MFA-TR*              ,BILL_ITEM_TIMESTMP                                        
MFA-TR*              ,BILL_MAN_STATUS_CD                                        
MFA-TR*              ,BILL_MAN_SOURCE_CD                                        
MFA-TR*              ,LAST_UPDATE_USERID                                        
MFA-TR*              ,LAST_UPDATE_TS                                            
MFA-TR*         INTO  :NG-ACCOUNT-NO                                            
MFA-TR*              ,:NG-BILL-NO                                               
MFA-TR*              ,:NG-CODE-UTIL-TYPE                                        
MFA-TR*              ,:NG-IC-NO                                                 
MFA-TR*              ,:NG-BILL-ITEM-TIMESTMP                                    
MFA-TR*              ,:NG-BILL-MAN-STATUS-CD                                    
MFA-TR*              ,:NG-BILL-MAN-SOURCE-CD                                    
MFA-TR*              ,:NG-LAST-UPDATE-USERID                                    
MFA-TR*              ,:NG-LAST-UPDATE-TS                                        
MFA-TR*         FROM  CSS_BILL_MANUAL NG                                        
MFA-TR*        WHERE  ACCOUNT_NO          = :NG-ACCOUNT-NO                      
MFA-TR*          AND  BILL_NO             = :NG-BILL-NO                         
MFA-TR*          AND  CODE_UTIL_TYPE      = :NG-CODE-UTIL-TYPE                  
MFA-TR*          AND  IC_NO               = :NG-IC-NO                           
MFA-TR*          AND  BILL_ITEM_TIMESTMP  = :NG-BILL-ITEM-TIMESTMP              
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7970                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CSR04873'              TO ABEND-PROGRAM             
              MOVE '7970'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_BILL_MANUAL'       TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE 'BILL_NO'               TO TABLE-ELEMENT-2           
              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-3           
              MOVE 'BILL_ITEM_TIMESTMP'    TO TABLE-ELEMENT-4           
              MOVE NG-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
              MOVE NG-BILL-NO              TO HOSTVAR-ELEMENT-2         
              MOVE NG-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-3         
              MOVE NG-BILL-ITEM-TIMESTMP   TO HOSTVAR-ELEMENT-4         
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTIN